/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results.serializable;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalLong;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import org.apache.commons.io.input.NullReader;
import org.gradle.api.NonNullApi;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableFailure;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResult;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializedMetadata;
import org.gradle.api.tasks.testing.TestMetadataEvent;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.PlaceholderExceptionSupport;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;

@NonNullApi
public final class SerializableTestResultStore {
    private static final int STORE_VERSION = 1;
    private final Path serializedResultsFile;
    private final Path outputZipFile;

    public SerializableTestResultStore(Path resultsDir) {
        this.serializedResultsFile = resultsDir.resolve("results-generic.bin");
        this.outputZipFile = resultsDir.resolve("output-generic.zip");
    }

    public static boolean isGenericTestResults(File resultDir) {
        return Files.exists(resultDir.toPath().resolve("results-generic.bin"), new LinkOption[0]);
    }

    public Writer openWriter() throws IOException {
        return new Writer(this.serializedResultsFile, this.outputZipFile);
    }

    public boolean hasResults() {
        if (Files.exists(this.serializedResultsFile, new LinkOption[0]) && Files.exists(this.outputZipFile, new LinkOption[0])) {
            boolean bl;
            block9: {
                KryoBackedDecoder decoder = this.openAndInitializeDecoder();
                try {
                    boolean bl2 = bl = decoder.readSmallLong() != 0L;
                    if (decoder == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (decoder != null) {
                            try {
                                decoder.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException((Throwable)e);
                    }
                }
                decoder.close();
            }
            return bl;
        }
        return false;
    }

    public void forEachResult(Consumer<? super OutputTrackedResult> action) throws IOException {
        try (KryoBackedDecoder resultsDecoder = this.openAndInitializeDecoder();){
            long id;
            while ((id = resultsDecoder.readSmallLong()) != 0L) {
                if (id < 0L) {
                    throw new IllegalStateException("Invalid id: " + id);
                }
                SerializableTestResult testResult = SerializableTestResult.Serializer.deserialize((Decoder)resultsDecoder);
                long parentId = resultsDecoder.readSmallLong();
                if (parentId < 0L) {
                    throw new IllegalStateException("Invalid parent id: " + parentId);
                }
                action.accept(new OutputTrackedResult(id, testResult, parentId));
            }
        }
    }

    private KryoBackedDecoder openAndInitializeDecoder() throws IOException {
        KryoBackedDecoder decoder = new KryoBackedDecoder(Files.newInputStream(this.serializedResultsFile, new OpenOption[0]));
        try {
            int version = decoder.readSmallInt();
            if (version != 1) {
                throw new IOException("Unsupported version: " + version);
            }
        }
        catch (Throwable t) {
            try {
                decoder.close();
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            throw t;
        }
        return decoder;
    }

    public OutputReader openOutputReader() throws IOException {
        return new OutputReader(this.outputZipFile);
    }

    @NonNullApi
    public static final class Writer
    implements Closeable,
    TestListenerInternal {
        private final Map<Object, Long> assignedIds = new HashMap<Object, Long>();
        private final Path serializedResultsFile;
        private final Path temporaryResultsFile;
        private final KryoBackedEncoder resultsEncoder;
        private final FileSystem outputZipFileSystem;
        private long nextId = 1L;
        private final Multimap<TestDescriptorInternal, SerializedMetadata> metadatas = LinkedHashMultimap.create();

        private Writer(Path serializedResultsFile, Path outputZipFile) throws IOException {
            this.serializedResultsFile = serializedResultsFile;
            Files.createDirectories(serializedResultsFile.getParent(), new FileAttribute[0]);
            this.temporaryResultsFile = Files.createTempFile(serializedResultsFile.getParent(), "in-progress-results-generic", ".bin", new FileAttribute[0]);
            this.resultsEncoder = new KryoBackedEncoder(Files.newOutputStream(this.temporaryResultsFile, new OpenOption[0]));
            this.resultsEncoder.writeSmallInt(1);
            try {
                new ZipOutputStream(Files.newOutputStream(outputZipFile, new OpenOption[0])).close();
                this.outputZipFileSystem = FileSystems.newFileSystem(URI.create("jar:" + outputZipFile.toUri()), Collections.emptyMap());
            }
            catch (Throwable t) {
                try {
                    this.resultsEncoder.close();
                }
                catch (Throwable t2) {
                    t.addSuppressed(t2);
                }
                throw t;
            }
        }

        @Override
        public void started(TestDescriptorInternal testDescriptor, TestStartEvent startEvent) {
            long id = this.nextId++;
            this.assignedIds.put(testDescriptor.getId(), id);
        }

        @Override
        public void completed(TestDescriptorInternal testDescriptor, TestResult testResult, TestCompleteEvent completeEvent) {
            SerializableTestResult.Builder testNodeBuilder = SerializableTestResult.builder().name(testDescriptor.getName()).displayName(testDescriptor.getDisplayName()).startTime(testResult.getStartTime()).endTime(testResult.getEndTime()).resultType(testResult.getResultType());
            for (Throwable throwable : testResult.getExceptions()) {
                testNodeBuilder.addFailure(new SerializableFailure(Writer.failureMessage(throwable), Writer.stackTrace(throwable), Writer.exceptionClassName(throwable)));
            }
            for (SerializedMetadata metadata : this.metadatas.get((Object)testDescriptor)) {
                testNodeBuilder.addMetadata(metadata);
            }
            long id = this.assignedIds.remove(testDescriptor.getId());
            this.resultsEncoder.writeSmallLong(id);
            try {
                SerializableTestResult.Serializer.serialize(testNodeBuilder.build(), (Encoder)this.resultsEncoder);
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
            if (testDescriptor.getParent() != null) {
                this.resultsEncoder.writeSmallLong(this.assignedIds.get(testDescriptor.getParent().getId()).longValue());
            } else {
                this.resultsEncoder.writeSmallLong(0L);
            }
        }

        private static String failureMessage(Throwable throwable) {
            try {
                return throwable.toString();
            }
            catch (Throwable t) {
                String exceptionClassName = Writer.exceptionClassName(throwable);
                return String.format("Could not determine failure message for exception of type %s: %s", exceptionClassName, t);
            }
        }

        private static String exceptionClassName(Throwable throwable) {
            return throwable instanceof PlaceholderExceptionSupport ? ((PlaceholderExceptionSupport)throwable).getExceptionClassName() : throwable.getClass().getName();
        }

        private static String stackTrace(Throwable throwable) {
            try {
                return Writer.getStacktrace(throwable);
            }
            catch (Throwable t) {
                return Writer.getStacktrace(t);
            }
        }

        private static String getStacktrace(Throwable throwable) {
            StringWriter writer = new StringWriter();
            try (PrintWriter printWriter = new PrintWriter(writer);){
                throwable.printStackTrace(printWriter);
            }
            return writer.toString();
        }

        @Override
        public void output(TestDescriptorInternal testDescriptor, TestOutputEvent event) {
            Path file = this.outputZipFileSystem.getPath(Long.toString(this.assignedIds.get(testDescriptor.getId())), event.getDestination().name());
            try {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.write(file, event.getMessage().getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not write output file '" + file + "'", e);
            }
        }

        @Override
        public void metadata(TestDescriptorInternal testDescriptor, TestMetadataEvent event) {
            this.metadatas.put((Object)testDescriptor, (Object)new SerializedMetadata(event.getLogTime(), event.getValues()));
        }

        @Override
        public void close() throws IOException {
            this.resultsEncoder.writeSmallLong(0L);
            CompositeStoppable.stoppable((Object[])new Object[]{this.resultsEncoder, this.outputZipFileSystem}).stop();
            Files.move(this.temporaryResultsFile, this.serializedResultsFile, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    @NonNullApi
    public static final class OutputTrackedResult {
        private final long id;
        private final SerializableTestResult testResult;
        private final long parentId;

        private OutputTrackedResult(long id, SerializableTestResult testResult, long parentId) {
            this.id = id;
            this.testResult = testResult;
            this.parentId = parentId;
        }

        public SerializableTestResult getInnerResult() {
            return this.testResult;
        }

        public long getOutputId() {
            return this.id;
        }

        public OptionalLong getParentOutputId() {
            return this.parentId == 0L ? OptionalLong.empty() : OptionalLong.of(this.parentId);
        }
    }

    @NonNullApi
    public static final class OutputReader
    implements Closeable {
        private final ZipFile outputZipFile;

        private OutputReader(Path outputZipFile) throws IOException {
            this.outputZipFile = new ZipFile(outputZipFile.toFile());
        }

        @Nullable
        private ZipEntry getEntry(long id, TestOutputEvent.Destination destination) {
            return this.outputZipFile.getEntry(id + "/" + destination.name());
        }

        public boolean hasOutput(long id, TestOutputEvent.Destination destination) {
            return this.getEntry(id, destination) != null;
        }

        public Reader getOutput(long id, TestOutputEvent.Destination destination) {
            ZipEntry entry = this.getEntry(id, destination);
            if (entry == null) {
                return new NullReader();
            }
            try {
                return new InputStreamReader(this.outputZipFile.getInputStream(entry), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read output entry '" + entry.getName() + "'", e);
            }
        }

        @Override
        public void close() throws IOException {
            this.outputZipFile.close();
        }
    }
}

