/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.dsl.CapabilityNotationParser;
import org.gradle.api.internal.artifacts.dsl.CapabilityNotationParserFactory;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.ModuleSelectorNotationConverter;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.composite.CompositeBuildContext;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.api.model.ObjectFactory;
import org.gradle.composite.internal.AcyclicIncludedBuildRegistry;
import org.gradle.composite.internal.BuildStateFactory;
import org.gradle.composite.internal.CompositeBuildsValueSnapshotterSerializerRegistry;
import org.gradle.composite.internal.DefaultBuildTreeLocalComponentProvider;
import org.gradle.composite.internal.DefaultBuildableCompositeBuildContext;
import org.gradle.composite.internal.DefaultIncludedBuildFactory;
import org.gradle.composite.internal.DefaultIncludedBuildRegistry;
import org.gradle.composite.internal.DefaultIncludedBuildTaskGraph;
import org.gradle.composite.internal.IncludedBuildDependencySubstitutionsBuilder;
import org.gradle.composite.internal.plugins.CompositeBuildPluginResolverContributor;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildFactory;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.buildtree.GlobalDependencySubstitutionRegistry;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.scopes.AbstractGradleModuleServices;
import org.gradle.internal.snapshot.impl.ValueSnapshotterSerializerRegistry;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.plugin.use.resolve.internal.PluginResolverContributor;

public class CompositeBuildServices
extends AbstractGradleModuleServices {
    public void registerBuildSessionServices(ServiceRegistration registration) {
        registration.addProvider((ServiceRegistrationProvider)new CompositeBuildSessionScopeServices());
    }

    public void registerBuildTreeServices(ServiceRegistration registration) {
        registration.addProvider((ServiceRegistrationProvider)new CompositeBuildTreeScopeServices());
        registration.add(DefaultBuildTreeLocalComponentProvider.class);
    }

    public void registerBuildServices(ServiceRegistration registration) {
        registration.add(PluginResolverContributor.class, HoldsProjectState.class, CompositeBuildPluginResolverContributor.class);
    }

    private static class CompositeBuildSessionScopeServices
    implements ServiceRegistrationProvider {
        private CompositeBuildSessionScopeServices() {
        }

        @Provides
        public ValueSnapshotterSerializerRegistry createCompositeBuildsValueSnapshotterSerializerRegistry() {
            return new CompositeBuildsValueSnapshotterSerializerRegistry();
        }
    }

    private static class CompositeBuildTreeScopeServices
    implements ServiceRegistrationProvider {
        private CompositeBuildTreeScopeServices() {
        }

        @Provides
        public void configure(ServiceRegistration serviceRegistration) {
            serviceRegistration.add(BuildStateFactory.class);
            serviceRegistration.add(DefaultIncludedBuildFactory.class);
            serviceRegistration.add(DefaultIncludedBuildTaskGraph.class);
        }

        @Provides
        public BuildStateRegistry createBuildStateRegistry(BuildModelParameters buildModelParameters, IncludedBuildFactory includedBuildFactory, ListenerManager listenerManager, BuildStateFactory buildStateFactory) {
            if (buildModelParameters.isIsolatedProjects()) {
                return new AcyclicIncludedBuildRegistry(includedBuildFactory, listenerManager, buildStateFactory);
            }
            return new DefaultIncludedBuildRegistry(includedBuildFactory, listenerManager, buildStateFactory);
        }

        @Provides
        public GlobalDependencySubstitutionRegistry createGlobalDependencySubstitutionRegistry(CompositeBuildContext context, Instantiator instantiator, ObjectFactory objectFactory, ModuleSelectorNotationConverter moduleSelectorNotationParser, AttributesFactory attributesFactory) {
            CapabilityNotationParser capabilityNotationParser = new CapabilityNotationParserFactory(false).create();
            return new IncludedBuildDependencySubstitutionsBuilder(context, instantiator, objectFactory, attributesFactory, (NotationParser<Object, ComponentSelector>)moduleSelectorNotationParser, (NotationParser<Object, Capability>)capabilityNotationParser);
        }

        @Provides
        public CompositeBuildContext createCompositeBuildContext() {
            return new DefaultBuildableCompositeBuildContext();
        }
    }
}

