/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.session;

import java.io.Closeable;
import java.util.List;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.operations.trace.BuildOperationTrace;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.CrossBuildSessionParameters;
import org.gradle.internal.service.scopes.GradleModuleServices;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.CrossBuildSession.class})
public class CrossBuildSessionState
implements Closeable {
    private final ServiceRegistry services;

    public CrossBuildSessionState(ServiceRegistry parent, StartParameterInternal startParameter) {
        this.services = ServiceRegistryBuilder.builder().scopeStrictly(Scope.CrossBuildSession.class).displayName("cross session services").parent(parent).provider((ServiceRegistrationProvider)new Services(startParameter)).build();
        this.services.get(BuildOperationTrace.class);
    }

    public ServiceRegistry getServices() {
        return this.services;
    }

    @Override
    public void close() {
        CompositeStoppable.stoppable((Object[])new Object[]{this.services}).stop();
    }

    private class Services
    implements ServiceRegistrationProvider {
        private final StartParameterInternal startParameter;

        public Services(StartParameterInternal startParameter) {
            this.startParameter = startParameter;
        }

        @Provides
        void configure(ServiceRegistration registration, List<GradleModuleServices> servicesProviders) {
            for (GradleModuleServices services : servicesProviders) {
                services.registerCrossBuildSessionServices(registration);
            }
            registration.add(CrossBuildSessionParameters.class, (Object)new CrossBuildSessionParameters(this.startParameter));
            registration.add(CrossBuildSessionState.class, (Object)CrossBuildSessionState.this);
        }
    }
}

