/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.JsCallInfo;
import org.jetbrains.kotlin.js.inline.context.FunctionDefinitionLoader;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001%B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001a\u00a2\u0006\u0002\u0010\u001bJ&\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001aJ\u001a\u0010#\u001a\u00020\u001d2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010$\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/js/inline/InlinerCycleReporter;", "", "trace", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "functionDefinitionLoader", "Lorg/jetbrains/kotlin/js/inline/context/FunctionDefinitionLoader;", "<init>", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;Lorg/jetbrains/kotlin/js/inline/context/FunctionDefinitionLoader;)V", "getTrace", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "functionVisitingState", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "Lorg/jetbrains/kotlin/js/inline/InlinerCycleReporter$VisitedState;", "namedFunctionsStack", "Ljava/util/Stack;", "currentNamedFunction", "getCurrentNamedFunction", "()Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "inlineCallInfos", "Ljava/util/LinkedList;", "Lorg/jetbrains/kotlin/js/inline/JsCallInfo;", "withFunction", "T", "function", "body", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "processInlineFunction", "", "definition", "Lorg/jetbrains/kotlin/js/inline/util/FunctionWithWrapper;", "call", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "doProcess", "reportInlineCycle", "calledFunction", "VisitedState", "js.translator"})
public final class InlinerCycleReporter {
    @NotNull
    private final DiagnosticSink trace;
    @NotNull
    private final FunctionDefinitionLoader functionDefinitionLoader;
    @NotNull
    private final Map<JsFunction, VisitedState> functionVisitingState;
    @NotNull
    private final Stack<JsFunction> namedFunctionsStack;
    @NotNull
    private final LinkedList<JsCallInfo> inlineCallInfos;

    public InlinerCycleReporter(@NotNull DiagnosticSink trace, @NotNull FunctionDefinitionLoader functionDefinitionLoader) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)functionDefinitionLoader, (String)"functionDefinitionLoader");
        this.trace = trace;
        this.functionDefinitionLoader = functionDefinitionLoader;
        this.functionVisitingState = new LinkedHashMap();
        this.namedFunctionsStack = new Stack();
        this.inlineCallInfos = new LinkedList();
    }

    @NotNull
    public final DiagnosticSink getTrace() {
        return this.trace;
    }

    private final JsFunction getCurrentNamedFunction() {
        return this.namedFunctionsStack.empty() ? null : this.namedFunctionsStack.peek();
    }

    public final <T> T withFunction(@NotNull JsFunction function2, @NotNull Function0<? extends T> body2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        if (this.functionDefinitionLoader.getFunctionsByFunctionNodes().keySet().contains(function2)) {
            this.namedFunctionsStack.push(function2);
        }
        Object result2 = body2.invoke();
        if (Intrinsics.areEqual((Object)this.getCurrentNamedFunction(), (Object)function2)) {
            this.namedFunctionsStack.pop();
        }
        return (T)result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processInlineFunction(@NotNull FunctionWithWrapper definition, @Nullable JsInvocation call2, @NotNull Function0<Unit> doProcess) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        Intrinsics.checkNotNullParameter(doProcess, (String)"doProcess");
        JsFunction function2 = definition.getFunction();
        if (call2 != null) {
            JsFunction jsFunction = this.getCurrentNamedFunction();
            if (jsFunction != null) {
                JsFunction it = jsFunction;
                boolean bl = false;
                this.inlineCallInfos.add(new JsCallInfo(call2, it));
            }
        }
        try {
            VisitedState visitedState = this.functionVisitingState.get(definition.getFunction());
            switch (visitedState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[visitedState.ordinal()]) {
                case 1: {
                    this.reportInlineCycle(call2, definition.getFunction());
                    return;
                }
                case 2: {
                    return;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.functionVisitingState.put(function2, VisitedState.IN_PROCESS);
            this.withFunction(function2, doProcess);
            this.functionVisitingState.put(function2, VisitedState.PROCESSED);
        }
        finally {
            if (!this.inlineCallInfos.isEmpty() && Intrinsics.areEqual((Object)this.inlineCallInfos.getLast().getCall(), (Object)call2)) {
                this.inlineCallInfos.removeLast();
            }
        }
    }

    private final void reportInlineCycle(JsInvocation call2, JsFunction calledFunction) {
        JsInvocation jsInvocation = call2;
        if (jsInvocation != null) {
            MetadataProperties.setInline(jsInvocation, (Boolean)false);
        }
        Iterator<JsCallInfo> it = this.inlineCallInfos.descendingIterator();
        while (it.hasNext()) {
            JsCallInfo callInfo = it.next();
            PsiElement psiElement = MetadataProperties.getPsiElement(callInfo.getCall());
            CallableDescriptor descriptor = MetadataProperties.getDescriptor(callInfo.getCall());
            if (psiElement != null && descriptor != null) {
                this.trace.report(Errors.INLINE_CALL_CYCLE.on(psiElement, descriptor));
            }
            if (!Intrinsics.areEqual((Object)callInfo.getContainingFunction(), (Object)calledFunction)) continue;
            break;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/js/inline/InlinerCycleReporter$VisitedState;", "", "<init>", "(Ljava/lang/String;I)V", "IN_PROCESS", "PROCESSED", "js.translator"})
    private static final class VisitedState
    extends Enum<VisitedState> {
        public static final /* enum */ VisitedState IN_PROCESS = new VisitedState();
        public static final /* enum */ VisitedState PROCESSED = new VisitedState();
        private static final /* synthetic */ VisitedState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static VisitedState[] values() {
            return (VisitedState[])$VALUES.clone();
        }

        public static VisitedState valueOf(String value2) {
            return Enum.valueOf(VisitedState.class, value2);
        }

        @NotNull
        public static EnumEntries<VisitedState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = visitedStateArray = new VisitedState[]{VisitedState.IN_PROCESS, VisitedState.PROCESSED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VisitedState.values().length];
            try {
                nArray[VisitedState.IN_PROCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VisitedState.PROCESSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

