/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.artifacts.dsl;

import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.dsl.DependencyConstraintFactory;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderConvertible;
import org.gradle.declarative.dsl.model.annotations.Restricted;

@Incubating
public interface Dependencies {
    @Inject
    public DependencyFactory getDependencyFactory();

    @Inject
    public DependencyConstraintFactory getDependencyConstraintFactory();

    @Inject
    public Project getProject();

    @Restricted
    default public ProjectDependency project(String projectPath) {
        return this.getDependencyFactory().create(this.getProject().project(projectPath));
    }

    default public ProjectDependency project() {
        return this.getDependencyFactory().create(this.getProject());
    }

    default public ExternalModuleDependency module(CharSequence dependencyNotation) {
        return this.getDependencyFactory().create(dependencyNotation);
    }

    default public ExternalModuleDependency module(@Nullable String group, String name, @Nullable String version) {
        return this.getDependencyFactory().create(group, name, version);
    }

    default public DependencyConstraint constraint(CharSequence dependencyConstraintNotation) {
        return this.getDependencyConstraintFactory().create(dependencyConstraintNotation);
    }

    default public Provider<? extends DependencyConstraint> constraint(Provider<? extends MinimalExternalModuleDependency> dependencyConstraint) {
        return dependencyConstraint.map(this.getDependencyConstraintFactory()::create);
    }

    default public Provider<? extends DependencyConstraint> constraint(ProviderConvertible<? extends MinimalExternalModuleDependency> dependencyConstraint) {
        return this.constraint(dependencyConstraint.asProvider());
    }

    default public DependencyConstraint constraint(ProjectDependency project) {
        return this.getDependencyConstraintFactory().create(project);
    }

    @Inject
    public ObjectFactory getObjectFactory();
}

