/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalVariantArtifactGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveState;
import org.gradle.internal.component.local.model.MissingLocalArtifactMetadata;
import org.gradle.internal.component.local.model.VariantMetadataFactory;
import org.gradle.internal.component.model.AbstractComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentIdGenerator;
import org.gradle.internal.component.model.ImmutableModuleSources;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantArtifactGraphResolveMetadata;
import org.gradle.internal.component.model.VariantArtifactResolveState;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueCache;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.resolve.resolver.VariantArtifactResolver;

public class DefaultLocalComponentGraphResolveState
extends AbstractComponentGraphResolveState<LocalComponentGraphResolveMetadata>
implements LocalComponentGraphResolveState {
    private final ComponentIdGenerator idGenerator;
    private final boolean adHoc;
    private final VariantMetadataFactory variantFactory;
    private final Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifactTransformer;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final CalculatedValueCache<String, LocalVariantGraphResolveState> variants;
    private final AtomicReference<CalculatedValue<LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates>> graphSelectionCandidates = new AtomicReference();
    private final AtomicReference<CalculatedValue<List<ResolvedVariantResult>>> selectableVariantResults = new AtomicReference();

    public DefaultLocalComponentGraphResolveState(long instanceId, LocalComponentGraphResolveMetadata metadata, AttributeDesugaring attributeDesugaring, ComponentIdGenerator idGenerator, boolean adHoc, VariantMetadataFactory variantFactory, CalculatedValueContainerFactory calculatedValueContainerFactory, @Nullable Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifactTransformer) {
        super(instanceId, metadata, attributeDesugaring);
        this.idGenerator = idGenerator;
        this.adHoc = adHoc;
        this.variantFactory = variantFactory;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.artifactTransformer = artifactTransformer;
        this.variants = calculatedValueContainerFactory.createCache(Describables.of((Object)"variants"));
        this.initCalculatedValues();
    }

    @Override
    public void reevaluate() {
        this.variants.clear();
        this.variantFactory.invalidate();
        this.initCalculatedValues();
    }

    private void initCalculatedValues() {
        this.graphSelectionCandidates.set((CalculatedValue<LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates>)this.calculatedValueContainerFactory.create(Describables.of((Object)"variants of", this.getMetadata()), context -> DefaultLocalComponentGraphResolveState.computeGraphSelectionCandidates((LocalComponentGraphResolveMetadata)this.getMetadata(), this.idGenerator, this.variantFactory, this.calculatedValueContainerFactory, this.artifactTransformer)));
        this.selectableVariantResults.set((CalculatedValue<List<ResolvedVariantResult>>)this.calculatedValueContainerFactory.create(Describables.of((Object)"public variants of", this.getMetadata()), context -> DefaultLocalComponentGraphResolveState.computeSelectableVariantResults(this)));
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId() {
        return ((LocalComponentGraphResolveMetadata)this.getMetadata()).getModuleVersionId();
    }

    @Override
    public boolean isAdHoc() {
        return this.adHoc;
    }

    @Override
    public LocalComponentGraphResolveState copy(ComponentIdentifier newComponentId, Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> transformer) {
        HashMap transformedArtifacts = new HashMap();
        Transformer cachedTransformer = oldArtifact -> transformedArtifacts.computeIfAbsent(oldArtifact, arg_0 -> ((Transformer)transformer).transform(arg_0));
        LocalComponentGraphResolveMetadata originalMetadata = (LocalComponentGraphResolveMetadata)this.getMetadata();
        LocalComponentGraphResolveMetadata copiedMetadata = new LocalComponentGraphResolveMetadata(originalMetadata.getModuleVersionId(), newComponentId, originalMetadata.getStatus(), originalMetadata.getAttributesSchema());
        return new DefaultLocalComponentGraphResolveState(this.idGenerator.nextComponentId(), copiedMetadata, this.getAttributeDesugaring(), this.idGenerator, this.adHoc, this.variantFactory, this.calculatedValueContainerFactory, (Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata>)cachedTransformer);
    }

    @Override
    public ComponentArtifactResolveMetadata getArtifactMetadata() {
        return new LocalComponentArtifactResolveMetadata((ComponentGraphResolveMetadata)this.getMetadata());
    }

    @Override
    public LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates getCandidatesForGraphVariantSelection() {
        CalculatedValue<LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates> value = this.graphSelectionCandidates.get();
        value.finalizeIfNotAlready();
        return (LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates)value.get();
    }

    private static LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates computeGraphSelectionCandidates(LocalComponentGraphResolveMetadata componentMetadata, ComponentIdGenerator idGenerator, VariantMetadataFactory variantFactory, CalculatedValueContainerFactory calculatedValueContainerFactory, @Nullable Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifactTransformer) {
        ImmutableList.Builder variantsWithAttributes = new ImmutableList.Builder();
        ImmutableMap.Builder variantsByConfigurationName = ImmutableMap.builder();
        variantFactory.visitConsumableVariants(variant -> {
            if (artifactTransformer != null) {
                variant = variant.copyWithTransformedArtifacts(artifactTransformer);
            }
            DefaultLocalVariantGraphResolveState variantState = new DefaultLocalVariantGraphResolveState(idGenerator.nextVariantId(), componentMetadata, (LocalVariantGraphResolveMetadata)variant, calculatedValueContainerFactory);
            if (!variant.getAttributes().isEmpty()) {
                variantsWithAttributes.add((Object)variantState);
            }
            if (variant.getConfigurationName() != null) {
                variantsByConfigurationName.put((Object)variant.getConfigurationName(), (Object)variantState);
            }
        });
        return new DefaultLocalComponentGraphSelectionCandidates((List<? extends LocalVariantGraphResolveState>)variantsWithAttributes.build(), (Map<String, LocalVariantGraphResolveState>)variantsByConfigurationName.build());
    }

    @Override
    public List<ResolvedVariantResult> getAllSelectableVariantResults() {
        CalculatedValue<List<ResolvedVariantResult>> value = this.selectableVariantResults.get();
        value.finalizeIfNotAlready();
        return (List)value.get();
    }

    private static List<ResolvedVariantResult> computeSelectableVariantResults(DefaultLocalComponentGraphResolveState component) {
        return component.getCandidatesForGraphVariantSelection().getVariantsForAttributeMatching().stream().flatMap(variant -> variant.prepareForArtifactResolution().getArtifactVariants().stream()).map(variant -> new DefaultResolvedVariantResult(component.getId(), Describables.of((Object)variant.getName()), (AttributeContainer)component.getAttributeDesugaring().desugar(variant.getAttributes().asImmutable()), component.capabilitiesFor(variant.getCapabilities()), null)).collect(Collectors.toList());
    }

    @Override
    @Nullable
    @Deprecated
    public LocalVariantGraphResolveState getConfigurationLegacy(String configurationName) {
        return (LocalVariantGraphResolveState)this.variants.computeIfAbsent((Object)configurationName, n -> {
            LocalVariantGraphResolveMetadata variant = this.variantFactory.getVariantByConfigurationName(configurationName);
            if (variant == null) {
                return null;
            }
            if (this.artifactTransformer != null) {
                variant = variant.copyWithTransformedArtifacts(this.artifactTransformer);
            }
            return new DefaultLocalVariantGraphResolveState(this.idGenerator.nextVariantId(), (ComponentGraphResolveMetadata)this.getMetadata(), variant, this.calculatedValueContainerFactory);
        });
    }

    private static class DefaultLocalComponentGraphSelectionCandidates
    implements LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates {
        private final List<? extends LocalVariantGraphResolveState> variantsWithAttributes;
        private final Map<String, LocalVariantGraphResolveState> variantsByConfigurationName;

        public DefaultLocalComponentGraphSelectionCandidates(List<? extends LocalVariantGraphResolveState> variantsWithAttributes, Map<String, LocalVariantGraphResolveState> variantsByConfigurationName) {
            this.variantsWithAttributes = variantsWithAttributes;
            this.variantsByConfigurationName = variantsByConfigurationName;
        }

        public List<? extends LocalVariantGraphResolveState> getVariantsForAttributeMatching() {
            return this.variantsWithAttributes;
        }

        @Override
        @Nullable
        public VariantGraphResolveState getLegacyVariant() {
            return this.getVariantByConfigurationName("default");
        }

        @Override
        @Nullable
        public LocalVariantGraphResolveState getVariantByConfigurationName(String name) {
            return this.variantsByConfigurationName.get(name);
        }

        @Override
        public List<LocalVariantGraphResolveState> getAllSelectableVariants() {
            HashSet<String> configurationNames = new HashSet<String>(this.variantsByConfigurationName.keySet());
            for (LocalVariantGraphResolveState localVariantGraphResolveState : this.variantsWithAttributes) {
                if (localVariantGraphResolveState.getMetadata().getConfigurationName() == null) continue;
                configurationNames.remove(localVariantGraphResolveState.getMetadata().getConfigurationName());
            }
            ArrayList<LocalVariantGraphResolveState> result = new ArrayList<LocalVariantGraphResolveState>(this.variantsWithAttributes);
            for (String configurationName : configurationNames) {
                result.add(this.variantsByConfigurationName.get(configurationName));
            }
            return result;
        }
    }

    private static class LocalComponentArtifactResolveMetadata
    implements ComponentArtifactResolveMetadata {
        private final ComponentGraphResolveMetadata metadata;

        public LocalComponentArtifactResolveMetadata(ComponentGraphResolveMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public ComponentIdentifier getId() {
            return this.metadata.getId();
        }

        @Override
        public ModuleVersionIdentifier getModuleVersionId() {
            return this.metadata.getModuleVersionId();
        }

        @Override
        public ModuleSources getSources() {
            return ImmutableModuleSources.of();
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return ImmutableAttributes.EMPTY;
        }

        @Override
        public ImmutableAttributesSchema getAttributesSchema() {
            return this.metadata.getAttributesSchema();
        }
    }

    private static class DefaultLocalVariantArtifactResolveState
    implements VariantArtifactResolveState,
    VariantArtifactGraphResolveMetadata {
        private final ComponentArtifactResolveMetadata component;
        private final LocalVariantArtifactGraphResolveMetadata variant;

        public DefaultLocalVariantArtifactResolveState(ComponentArtifactResolveMetadata component, LocalVariantArtifactGraphResolveMetadata variant) {
            this.component = component;
            this.variant = variant;
        }

        @Override
        public List<? extends ComponentArtifactMetadata> getArtifacts() {
            return this.variant.getArtifacts();
        }

        @Override
        public ResolvedVariant resolveAdhocVariant(VariantArtifactResolver variantResolver, List<IvyArtifactName> dependencyArtifacts) {
            ImmutableList.Builder artifacts = ImmutableList.builderWithExpectedSize((int)dependencyArtifacts.size());
            for (IvyArtifactName dependencyArtifact : dependencyArtifacts) {
                artifacts.add((Object)this.getArtifactWithName(dependencyArtifact));
            }
            return variantResolver.resolveAdhocVariant(this.component, (ImmutableList<? extends ComponentArtifactMetadata>)artifacts.build());
        }

        private ComponentArtifactMetadata getArtifactWithName(IvyArtifactName ivyArtifactName) {
            for (ComponentArtifactMetadata componentArtifactMetadata : this.getArtifacts()) {
                if (!componentArtifactMetadata.getName().equals(ivyArtifactName)) continue;
                return componentArtifactMetadata;
            }
            return new MissingLocalArtifactMetadata(this.component.getId(), ivyArtifactName);
        }

        @Override
        public Set<? extends VariantResolveMetadata> getArtifactVariants() {
            return this.variant.getArtifactVariants();
        }
    }

    private static class DefaultLocalVariantGraphResolveState
    implements LocalVariantGraphResolveState {
        private final long instanceId;
        private final LocalVariantGraphResolveMetadata variant;
        private final CalculatedValue<DefaultLocalVariantArtifactResolveState> artifactResolveState;

        public DefaultLocalVariantGraphResolveState(long instanceId, ComponentGraphResolveMetadata componentMetadata, LocalVariantGraphResolveMetadata variant, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            this.instanceId = instanceId;
            this.variant = variant;
            this.artifactResolveState = calculatedValueContainerFactory.create(Describables.of((Object)"artifacts of", (Object)variant), context -> {
                LocalVariantArtifactGraphResolveMetadata variantArtifactMetadata = variant.prepareToResolveArtifacts();
                LocalComponentArtifactResolveMetadata componentArtifactMetadata = new LocalComponentArtifactResolveMetadata(componentMetadata);
                return new DefaultLocalVariantArtifactResolveState(componentArtifactMetadata, variantArtifactMetadata);
            });
        }

        @Override
        public long getInstanceId() {
            return this.instanceId;
        }

        @Override
        public String getName() {
            return this.variant.getName();
        }

        public String toString() {
            return this.variant.toString();
        }

        @Override
        public LocalVariantGraphResolveMetadata getMetadata() {
            return this.variant;
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.variant.getAttributes();
        }

        @Override
        public ImmutableCapabilities getCapabilities() {
            return this.variant.getCapabilities();
        }

        @Override
        public VariantArtifactGraphResolveMetadata resolveArtifacts() {
            this.artifactResolveState.finalizeIfNotAlready();
            return (VariantArtifactGraphResolveMetadata)this.artifactResolveState.get();
        }

        @Override
        public VariantArtifactResolveState prepareForArtifactResolution() {
            this.artifactResolveState.finalizeIfNotAlready();
            return (VariantArtifactResolveState)this.artifactResolveState.get();
        }
    }
}

