/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.configurations.ResolutionBackedFileCollection;
import org.gradle.api.internal.artifacts.configurations.ResolutionHost;
import org.gradle.api.internal.artifacts.configurations.ResolutionResultProvider;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSelectionSpec;
import org.gradle.api.internal.artifacts.transform.DefaultTransformDependencies;
import org.gradle.api.internal.artifacts.transform.TransformDependencies;
import org.gradle.api.internal.artifacts.transform.TransformStep;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependencies;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependenciesResolver;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.WorkNodeAction;
import org.gradle.api.specs.Spec;
import org.gradle.execution.plan.PostExecutionNodeAwareActionNode;
import org.gradle.execution.plan.TaskNode;
import org.gradle.execution.plan.TaskNodeFactory;
import org.gradle.internal.Describables;
import org.gradle.internal.Try;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ValueCalculator;
import org.gradle.operations.dependencies.configurations.ConfigurationIdentity;

public class DefaultTransformUpstreamDependenciesResolver
implements TransformUpstreamDependenciesResolver {
    public static final TransformDependencies NO_RESULT = new TransformDependencies(){

        @Override
        public Optional<FileCollection> getFiles() {
            return Optional.empty();
        }
    };
    public static final TransformUpstreamDependencies NO_DEPENDENCIES = new TransformUpstreamDependencies(){

        @Override
        @Nullable
        public ConfigurationIdentity getConfigurationIdentity() {
            return null;
        }

        @Override
        public FileCollection selectedArtifacts() {
            throw DefaultTransformUpstreamDependenciesResolver.failure();
        }

        @Override
        public void finalizeIfNotAlready() {
        }

        @Override
        public Try<TransformDependencies> computeArtifacts() {
            return Try.successful((Object)NO_RESULT);
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
        }
    };
    private final ResolutionHost resolutionHost;
    private final ConfigurationIdentity configurationIdentity;
    private final ImmutableAttributes requestAttributes;
    private final ResolutionStrategy.SortOrder artifactDependencySortOrder;
    private final ResolutionResultProvider<ResolverResults> resolverResults;
    private final ResolutionResultProvider<ResolverResults> strictResolverResults;
    private final DomainObjectContext owner;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final ImmutableAttributesFactory attributesFactory;
    private final TaskDependencyFactory taskDependencyFactory;

    public DefaultTransformUpstreamDependenciesResolver(ResolutionHost resolutionHost, @Nullable ConfigurationIdentity configurationIdentity, ImmutableAttributes requestAttributes, ResolutionStrategy.SortOrder artifactDependencySortOrder, ResolutionResultProvider<ResolverResults> strictResolverResults, ResolutionResultProvider<ResolverResults> resolverResults, DomainObjectContext owner, CalculatedValueContainerFactory calculatedValueContainerFactory, ImmutableAttributesFactory attributesFactory, TaskDependencyFactory taskDependencyFactory) {
        this.resolutionHost = resolutionHost;
        this.configurationIdentity = configurationIdentity;
        this.requestAttributes = requestAttributes;
        this.artifactDependencySortOrder = artifactDependencySortOrder;
        this.resolverResults = resolverResults;
        this.strictResolverResults = strictResolverResults;
        this.owner = owner;
        this.attributesFactory = attributesFactory;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.taskDependencyFactory = taskDependencyFactory;
    }

    private static IllegalStateException failure() {
        return new IllegalStateException("Transform does not use artifact dependencies.");
    }

    @Override
    public TransformUpstreamDependencies dependenciesFor(ComponentIdentifier componentId, TransformStep transformStep) {
        if (!transformStep.requiresDependencies()) {
            return NO_DEPENDENCIES;
        }
        return new TransformUpstreamDependenciesImpl(componentId, this.configurationIdentity, transformStep, this.calculatedValueContainerFactory);
    }

    private FileCollectionInternal selectedArtifactsFor(ComponentIdentifier componentId, ImmutableAttributes fromAttributes) {
        Set<ComponentIdentifier> dependencies = DefaultTransformUpstreamDependenciesResolver.computeDependencies(componentId, this.strictResolverResults.getValue(), false);
        return this.getDependencyResults(fromAttributes, dependencies);
    }

    private void computeDependenciesFor(ComponentIdentifier componentId, ImmutableAttributes fromAttributes, TaskDependencyResolveContext context) {
        Set<ComponentIdentifier> buildDependencies = DefaultTransformUpstreamDependenciesResolver.computeDependencies(componentId, this.strictResolverResults.getTaskDependencyValue(), true);
        FileCollectionInternal files = this.getDependencyResults(fromAttributes, buildDependencies);
        context.add((Object)files);
    }

    private FileCollectionInternal getDependencyResults(ImmutableAttributes fromAttributes, Set<ComponentIdentifier> filteredComponents) {
        Spec filter = SerializableLambdas.spec(filteredComponents::contains);
        ImmutableAttributes fullAttributes = this.attributesFactory.concat(this.requestAttributes, fromAttributes);
        return new ResolutionBackedFileCollection(this.resolverResults.map(results -> results.getVisitedArtifacts().select(new ArtifactSelectionSpec(fullAttributes, (Spec<? super ComponentIdentifier>)filter, false, false, this.artifactDependencySortOrder))), false, this.resolutionHost, this.taskDependencyFactory);
    }

    private static Set<ComponentIdentifier> computeDependencies(ComponentIdentifier componentId, ResolverResults results, boolean strict) {
        ResolvedComponentResult root = results.getVisitedGraph().getResolutionResult().getRootSource().get();
        ResolvedComponentResult targetComponent = DefaultTransformUpstreamDependenciesResolver.findComponent(root, componentId);
        if (targetComponent == null) {
            if (strict) {
                throw new AssertionError((Object)("Could not find component " + componentId + " in provided results."));
            }
            return Collections.emptySet();
        }
        HashSet<ComponentIdentifier> buildDependencies = new HashSet<ComponentIdentifier>();
        DefaultTransformUpstreamDependenciesResolver.collectReachableComponents(buildDependencies, new HashSet<ComponentIdentifier>(), targetComponent.getDependencies());
        return buildDependencies;
    }

    @Nullable
    public static ResolvedComponentResult findComponent(ResolvedComponentResult rootComponent, ComponentIdentifier componentIdentifier) {
        HashSet<ResolvedComponentResult> seen = new HashSet<ResolvedComponentResult>();
        ArrayDeque<ResolvedComponentResult> pending = new ArrayDeque<ResolvedComponentResult>();
        pending.push(rootComponent);
        while (!pending.isEmpty()) {
            ResolvedComponentResult component = (ResolvedComponentResult)pending.pop();
            if (component.getId().equals(componentIdentifier)) {
                return component;
            }
            for (DependencyResult d : component.getDependencies()) {
                ResolvedDependencyResult resolved;
                ResolvedComponentResult selected;
                if (!(d instanceof ResolvedDependencyResult) || !seen.add(selected = (resolved = (ResolvedDependencyResult)d).getSelected())) continue;
                pending.push(selected);
            }
        }
        return null;
    }

    private static void collectReachableComponents(Set<ComponentIdentifier> dependenciesIdentifiers, Set<ComponentIdentifier> visited, Set<? extends DependencyResult> dependencies) {
        for (DependencyResult dependencyResult : dependencies) {
            if (!(dependencyResult instanceof ResolvedDependencyResult) || dependencyResult.isConstraint()) continue;
            ResolvedDependencyResult resolvedDependency = (ResolvedDependencyResult)dependencyResult;
            ResolvedComponentResult selected = resolvedDependency.getSelected();
            dependenciesIdentifiers.add(selected.getId());
            if (!visited.add(selected.getId())) continue;
            DefaultTransformUpstreamDependenciesResolver.collectReachableComponents(dependenciesIdentifiers, visited, selected.getDependencies());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTransformUpstreamDependenciesResolver that = (DefaultTransformUpstreamDependenciesResolver)o;
        return this.resolutionHost.equals(that.resolutionHost);
    }

    public int hashCode() {
        return this.resolutionHost.hashCode();
    }

    private class TransformUpstreamDependenciesImpl
    implements TransformUpstreamDependencies {
        private final ComponentIdentifier componentId;
        private final ConfigurationIdentity configurationIdentity;
        private final CalculatedValueContainer<TransformDependencies, FinalizeTransformDependencies> transformDependencies;
        private final ImmutableAttributes fromAttributes;

        public TransformUpstreamDependenciesImpl(@Nullable ComponentIdentifier componentId, ConfigurationIdentity configurationIdentity, TransformStep transformStep, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            this.componentId = componentId;
            this.configurationIdentity = configurationIdentity;
            this.fromAttributes = transformStep.getFromAttributes();
            this.transformDependencies = calculatedValueContainerFactory.create(Describables.of((Object)"dependencies for", (Object)componentId, (Object)this.fromAttributes), (ValueCalculator)new FinalizeTransformDependenciesFromSelectedArtifacts(componentId, transformStep.getFromAttributes()));
        }

        @Override
        @Nullable
        public ConfigurationIdentity getConfigurationIdentity() {
            return this.configurationIdentity;
        }

        @Override
        public FileCollection selectedArtifacts() {
            return DefaultTransformUpstreamDependenciesResolver.this.selectedArtifactsFor(this.componentId, this.fromAttributes);
        }

        @Override
        public Try<TransformDependencies> computeArtifacts() {
            return this.transformDependencies.getValue();
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add(this.transformDependencies);
        }

        @Override
        public void finalizeIfNotAlready() {
            this.transformDependencies.finalizeIfNotAlready();
        }
    }

    private static class CollectingTaskDependencyResolveContext
    implements TaskDependencyResolveContext {
        private final TaskNodeFactory taskNodeFactory;
        private final Collection<TaskNode> tasks;

        public CollectingTaskDependencyResolveContext(Collection<TaskNode> tasks, TaskNodeFactory taskNodeFactory) {
            this.tasks = tasks;
            this.taskNodeFactory = taskNodeFactory;
        }

        public void add(Object dependency) {
            if (dependency instanceof Task) {
                this.tasks.add(this.taskNodeFactory.getNode((Task)dependency));
            }
        }

        public void visitFailure(Throwable failure) {
        }

        @Nullable
        public Task getTask() {
            return null;
        }
    }

    public class FinalizeTransformDependenciesFromSelectedArtifacts
    extends FinalizeTransformDependencies {
        private final ComponentIdentifier componentId;
        private final ImmutableAttributes fromAttributes;

        public FinalizeTransformDependenciesFromSelectedArtifacts(ComponentIdentifier componentId, ImmutableAttributes fromAttributes) {
            this.componentId = componentId;
            this.fromAttributes = fromAttributes;
        }

        public FileCollectionInternal selectedArtifacts() {
            return DefaultTransformUpstreamDependenciesResolver.this.selectedArtifactsFor(this.componentId, this.fromAttributes);
        }

        public boolean usesMutableProjectState() {
            return DefaultTransformUpstreamDependenciesResolver.this.owner.getProject() != null;
        }

        public ProjectInternal getOwningProject() {
            return DefaultTransformUpstreamDependenciesResolver.this.owner.getProject();
        }

        @Nullable
        public WorkNodeAction getPreExecutionAction() {
            return new CalculateFinalDependencies();
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            DefaultTransformUpstreamDependenciesResolver.this.computeDependenciesFor(this.componentId, this.fromAttributes, context);
        }

        public class CalculateFinalDependencies
        implements PostExecutionNodeAwareActionNode {
            final List<TaskNode> tasks = new ArrayList<TaskNode>();

            public boolean usesMutableProjectState() {
                return FinalizeTransformDependenciesFromSelectedArtifacts.this.usesMutableProjectState();
            }

            @Nullable
            public Project getOwningProject() {
                return FinalizeTransformDependenciesFromSelectedArtifacts.this.getOwningProject();
            }

            public void run(NodeExecutionContext context) {
                TaskNodeFactory taskNodeFactory = (TaskNodeFactory)context.getService(TaskNodeFactory.class);
                FinalizeTransformDependenciesFromSelectedArtifacts.this.selectedArtifacts().visitDependencies((TaskDependencyResolveContext)new CollectingTaskDependencyResolveContext(this.tasks, taskNodeFactory));
            }

            public List<TaskNode> getPostExecutionNodes() {
                return this.tasks;
            }
        }
    }

    public static abstract class FinalizeTransformDependencies
    implements ValueCalculator<TransformDependencies> {
        public abstract FileCollection selectedArtifacts();

        public TransformDependencies calculateValue(NodeExecutionContext context) {
            FileCollection files = this.selectedArtifacts();
            files.getFiles();
            return new DefaultTransformDependencies(files);
        }
    }
}

