/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import java.util.List;
import org.gradle.api.AntBuilder;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.ExternalProcessStartedListener;
import org.gradle.api.internal.artifacts.DependencyManagementServices;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.collections.DefaultDomainObjectCollectionFactory;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.component.DefaultSoftwareComponentContainer;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileFactory;
import org.gradle.api.internal.file.FilePropertyFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.ManagedFactories;
import org.gradle.api.internal.file.collections.ManagedFactories;
import org.gradle.api.internal.file.temp.DefaultTemporaryFileProvider;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.internal.initialization.BuildLogicBuilder;
import org.gradle.api.internal.initialization.DefaultScriptHandlerFactory;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.internal.plugins.DefaultPluginManager;
import org.gradle.api.internal.plugins.ImperativeOnlyPluginTarget;
import org.gradle.api.internal.plugins.ModelDefaultsApplyingPluginTarget;
import org.gradle.api.internal.plugins.PluginInstantiator;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.internal.plugins.PluginTargetType;
import org.gradle.api.internal.plugins.RuleBasedPluginTarget;
import org.gradle.api.internal.project.CrossProjectConfigurator;
import org.gradle.api.internal.project.CrossProjectModelAccess;
import org.gradle.api.internal.project.DefaultAntBuilderFactory;
import org.gradle.api.internal.project.DeferredProjectConfiguration;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.project.ant.DefaultAntLoggingAdapterFactory;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.project.taskfactory.TaskIdentityFactory;
import org.gradle.api.internal.project.taskfactory.TaskInstantiator;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.resources.ApiTextResourceAdapter;
import org.gradle.api.internal.resources.DefaultResourceHandler;
import org.gradle.api.internal.tasks.DefaultTaskContainerFactory;
import org.gradle.api.internal.tasks.DefaultTaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyUsageTracker;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.api.internal.tasks.TaskStatistics;
import org.gradle.api.internal.tasks.properties.TaskScheme;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.configuration.ConfigurationTargetIdentifier;
import org.gradle.configuration.project.DefaultProjectConfigurationActionContainer;
import org.gradle.configuration.project.ProjectConfigurationActionContainer;
import org.gradle.internal.Factory;
import org.gradle.internal.code.UserCodeApplicationContext;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.jvm.JavaModuleDetector;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.CloseableServiceRegistry;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.DefaultProjectFinder;
import org.gradle.internal.service.scopes.GradleModuleServices;
import org.gradle.internal.service.scopes.ProjectBackedPropertyHost;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.WorkerSharedProjectScopeServices;
import org.gradle.internal.state.DefaultManagedFactoryRegistry;
import org.gradle.internal.state.ManagedFactory;
import org.gradle.internal.state.ManagedFactoryRegistry;
import org.gradle.internal.typeconversion.DefaultTypeConverter;
import org.gradle.internal.typeconversion.TypeConverter;
import org.gradle.model.internal.inspect.ModelRuleExtractor;
import org.gradle.model.internal.inspect.ModelRuleSourceDetector;
import org.gradle.model.internal.registry.DefaultModelRegistry;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.normalization.internal.DefaultInputNormalizationHandler;
import org.gradle.normalization.internal.DefaultRuntimeClasspathNormalization;
import org.gradle.normalization.internal.InputNormalizationHandlerInternal;
import org.gradle.normalization.internal.RuntimeClasspathNormalizationInternal;
import org.gradle.plugin.software.internal.ModelDefaultsApplicator;
import org.gradle.plugin.software.internal.PluginScheme;
import org.gradle.process.internal.ExecFactory;
import org.gradle.tooling.provider.model.internal.DefaultToolingModelBuilderRegistry;

public class ProjectScopeServices
implements ServiceRegistrationProvider {
    private final ProjectInternal project;
    private final Factory<LoggingManagerInternal> loggingManagerInternalFactory;

    public static CloseableServiceRegistry create(ServiceRegistry parent, ProjectInternal project, Factory<LoggingManagerInternal> loggingManagerInternalFactory) {
        return ServiceRegistryBuilder.builder().scope(Scope.Project.class).displayName("project services").parent(parent).provider((ServiceRegistrationProvider)new ProjectScopeServices(project, loggingManagerInternalFactory)).provider((ServiceRegistrationProvider)new WorkerSharedProjectScopeServices(project.getProjectDir())).build();
    }

    public ProjectScopeServices(ProjectInternal project, Factory<LoggingManagerInternal> loggingManagerInternalFactory) {
        this.project = project;
        this.loggingManagerInternalFactory = loggingManagerInternalFactory;
    }

    @Provides
    protected void configure(ServiceRegistration registration, List<GradleModuleServices> gradleModuleServiceProviders, DependencyManagementServices dependencyManagementServices) {
        registration.add(ProjectInternal.class, (Object)this.project);
        dependencyManagementServices.addDslServices(registration, this.project);
        for (GradleModuleServices services : gradleModuleServiceProviders) {
            services.registerProjectServices(registration);
        }
    }

    @Provides
    protected PluginRegistry createPluginRegistry(PluginRegistry rootRegistry) {
        ProjectState parent = this.project.getOwner().getBuildParent();
        PluginRegistry parentRegistry = parent == null ? rootRegistry.createChild(this.project.getBaseClassLoaderScope()) : (PluginRegistry)parent.getMutableModel().getServices().get(PluginRegistry.class);
        return parentRegistry.createChild(this.project.getClassLoaderScope());
    }

    @Provides
    protected DeferredProjectConfiguration createDeferredProjectConfiguration() {
        return new DeferredProjectConfiguration(this.project);
    }

    @Provides
    protected LoggingManagerInternal createLoggingManager() {
        return (LoggingManagerInternal)this.loggingManagerInternalFactory.create();
    }

    @Provides
    protected ProjectConfigurationActionContainer createProjectConfigurationActionContainer() {
        return new DefaultProjectConfigurationActionContainer();
    }

    @Provides
    protected DefaultResourceHandler.Factory createResourceHandlerFactory(FileResolver fileResolver, TaskDependencyFactory taskDependencyFactory, FileSystem fileSystem, TemporaryFileProvider temporaryFileProvider, ApiTextResourceAdapter.Factory textResourceAdapterFactory) {
        return DefaultResourceHandler.Factory.from((FileResolver)fileResolver, (TaskDependencyFactory)taskDependencyFactory, (FileSystem)fileSystem, (TemporaryFileProvider)temporaryFileProvider, (ApiTextResourceAdapter.Factory)textResourceAdapterFactory);
    }

    @Provides
    protected ExecFactory decorateExecFactory(ExecFactory execFactory, FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, InstantiatorFactory instantiatorFactory, ObjectFactory objectFactory, JavaModuleDetector javaModuleDetector, ListenerManager listenerManager) {
        return execFactory.forContext().withFileResolver(fileResolver).withFileCollectionFactory(fileCollectionFactory).withInstantiator((Instantiator)instantiatorFactory.decorateLenient()).withObjectFactory(objectFactory).withJavaModuleDetector(javaModuleDetector).withExternalProcessStartedListener((ExternalProcessStartedListener)listenerManager.getBroadcaster(ExternalProcessStartedListener.class)).build();
    }

    @Provides
    protected TemporaryFileProvider createTemporaryFileProvider() {
        return new DefaultTemporaryFileProvider(() -> ((Directory)this.project.getLayout().getBuildDirectory().dir("tmp").get()).getAsFile());
    }

    @Provides
    protected Factory<AntBuilder> createAntBuilderFactory() {
        return new DefaultAntBuilderFactory(this.project, new DefaultAntLoggingAdapterFactory());
    }

    @Provides
    protected DefaultToolingModelBuilderRegistry decorateToolingModelRegistry(DefaultToolingModelBuilderRegistry buildScopedToolingModelBuilders, BuildOperationRunner buildOperationRunner, ProjectStateRegistry projectStateRegistry) {
        return buildScopedToolingModelBuilders.createChild();
    }

    @Provides
    protected PluginManagerInternal createPluginManager(Instantiator instantiator, InstantiatorFactory instantiatorFactory, ServiceRegistry projectScopeServiceRegistry, ModelRuleExtractor modelRuleExtractor, ModelRuleSourceDetector modelRuleSourceDetector, PluginRegistry pluginRegistry, BuildOperationRunner buildOperationRunner, UserCodeApplicationContext userCodeApplicationContext, CollectionCallbackActionDecorator decorator, DomainObjectCollectionFactory domainObjectCollectionFactory, PluginScheme pluginScheme, InternalProblems problems, ModelDefaultsApplicator modelDefaultsApplicator) {
        RuleBasedPluginTarget ruleBasedTarget = new RuleBasedPluginTarget(this.project, new ImperativeOnlyPluginTarget<ProjectInternal>(PluginTargetType.PROJECT, this.project, problems), modelRuleExtractor, modelRuleSourceDetector);
        ModelDefaultsApplyingPluginTarget<ProjectInternal> pluginTarget = new ModelDefaultsApplyingPluginTarget<ProjectInternal>(this.project, ruleBasedTarget, modelDefaultsApplicator);
        return (PluginManagerInternal)instantiator.newInstance(DefaultPluginManager.class, new Object[]{pluginRegistry, new PluginInstantiator((Instantiator)instantiatorFactory.injectScheme().withServices((ServiceLookup)projectScopeServiceRegistry).instantiator(), (Instantiator)pluginScheme.getInstantiationScheme().withServices((ServiceLookup)projectScopeServiceRegistry).instantiator()), pluginTarget, buildOperationRunner, userCodeApplicationContext, decorator, domainObjectCollectionFactory});
    }

    @Provides
    protected ITaskFactory createTaskFactory(ServiceRegistry projectScopeServiceRegistry, ITaskFactory parentFactory, TaskScheme taskScheme) {
        return parentFactory.createChild(this.project, taskScheme.getInstantiationScheme().withServices((ServiceLookup)projectScopeServiceRegistry));
    }

    @Provides
    protected TaskInstantiator createTaskInstantiator(TaskIdentityFactory taskIdentityFactory, ITaskFactory taskFactory) {
        return new TaskInstantiator(taskIdentityFactory, taskFactory, this.project);
    }

    @Provides
    protected TaskContainerInternal createTaskContainerInternal(Instantiator instantiator, TaskIdentityFactory taskIdentityFactory, ITaskFactory taskFactory, TaskStatistics taskStatistics, BuildOperationRunner buildOperationRunner, CrossProjectConfigurator crossProjectConfigurator, CollectionCallbackActionDecorator decorator, ProjectRegistry<ProjectInternal> projectRegistry) {
        return new DefaultTaskContainerFactory(instantiator, taskIdentityFactory, taskFactory, this.project, taskStatistics, buildOperationRunner, crossProjectConfigurator, decorator, projectRegistry).create();
    }

    @Provides
    protected SoftwareComponentContainer createSoftwareComponentContainer(Instantiator instantiator, InstantiatorFactory instantiatorFactory, ServiceRegistry services, CollectionCallbackActionDecorator decorator) {
        InstanceGenerator elementInstantiator = instantiatorFactory.decorate((ServiceLookup)services);
        return (SoftwareComponentContainer)elementInstantiator.newInstance(DefaultSoftwareComponentContainer.class, new Object[]{instantiator, elementInstantiator, decorator});
    }

    @Provides
    protected ProjectFinder createProjectFinder() {
        return new DefaultProjectFinder(() -> this.project);
    }

    @Provides
    protected ModelRegistry createModelRegistry(ModelRuleExtractor ruleExtractor) {
        return new DefaultModelRegistry(ruleExtractor, this.project.getPath(), run -> this.project.getOwner().applyToMutableState(p -> run.run()));
    }

    @Provides
    protected ScriptHandlerInternal createScriptHandler(DependencyManagementServices dependencyManagementServices, FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, BuildLogicBuilder buildLogicBuilder) {
        DefaultScriptHandlerFactory factory = new DefaultScriptHandlerFactory(dependencyManagementServices, buildLogicBuilder);
        return factory.createProjectScriptHandler(this.project.getBuildScriptSource(), this.project.getClassLoaderScope(), fileResolver, fileCollectionFactory, this.project);
    }

    @Provides
    protected PropertyHost createPropertyHost() {
        return new ProjectBackedPropertyHost(this.project);
    }

    @Provides
    protected TypeConverter createTypeConverter(PathToFileResolver fileResolver) {
        return new DefaultTypeConverter(fileResolver);
    }

    @Provides
    protected RuntimeClasspathNormalizationInternal createRuntimeClasspathNormalizationStrategy(Instantiator instantiator) {
        return (RuntimeClasspathNormalizationInternal)instantiator.newInstance(DefaultRuntimeClasspathNormalization.class, new Object[0]);
    }

    @Provides
    protected InputNormalizationHandlerInternal createInputNormalizationHandler(Instantiator instantiator, RuntimeClasspathNormalizationInternal runtimeClasspathNormalizationStrategy) {
        return (InputNormalizationHandlerInternal)instantiator.newInstance(DefaultInputNormalizationHandler.class, new Object[]{runtimeClasspathNormalizationStrategy});
    }

    @Provides
    protected TaskDependencyFactory createTaskDependencyFactory() {
        TaskDependencyUsageTracker tracker = ((CrossProjectModelAccess)this.project.getServices().get(CrossProjectModelAccess.class)).taskDependencyUsageTracker(this.project);
        return DefaultTaskDependencyFactory.forProject((TaskResolver)this.project.getTasks(), (TaskDependencyUsageTracker)tracker);
    }

    @Provides
    protected ConfigurationTargetIdentifier createConfigurationTargetIdentifier() {
        return ConfigurationTargetIdentifier.of(this.project);
    }

    @Provides
    protected DomainObjectCollectionFactory createDomainObjectCollectionFactory(InstantiatorFactory instantiatorFactory, ServiceRegistry projectScopeServiceRegistry, CollectionCallbackActionDecorator collectionCallbackActionDecorator, CrossProjectConfigurator projectConfigurator) {
        return new DefaultDomainObjectCollectionFactory(instantiatorFactory, projectScopeServiceRegistry, collectionCallbackActionDecorator, projectConfigurator.getLazyBehaviorGuard());
    }

    @Provides
    protected ManagedFactoryRegistry createManagedFactoryRegistry(ManagedFactoryRegistry parent, FileCollectionFactory fileCollectionFactory, FileFactory fileFactory, FilePropertyFactory filePropertyFactory) {
        return new DefaultManagedFactoryRegistry(parent).withFactories(new ManagedFactory[]{new ManagedFactories.ConfigurableFileCollectionManagedFactory(fileCollectionFactory), new ManagedFactories.RegularFilePropertyManagedFactory(filePropertyFactory), new ManagedFactories.DirectoryManagedFactory(fileFactory), new ManagedFactories.DirectoryPropertyManagedFactory(filePropertyFactory)});
    }
}

