/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.transform;

import com.google.common.base.Function;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.initialization.transform.services.CacheInstrumentationDataBuildService;
import org.gradle.api.internal.initialization.transform.services.InjectedInstrumentationServices;
import org.gradle.api.internal.initialization.transform.utils.InstrumentationTransformUtils;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.internal.classpath.TransformedClassPath;
import org.gradle.internal.classpath.transforms.ClasspathElementTransform;
import org.gradle.internal.classpath.transforms.ClasspathElementTransformFactory;
import org.gradle.internal.classpath.transforms.InstrumentingClassTransform;
import org.gradle.internal.lazy.Lazy;
import org.gradle.util.internal.GFileUtils;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Instrumented jars are too big to cache")
public abstract class BaseInstrumentingArtifactTransform<T extends Parameters>
implements TransformAction<T> {
    protected final Lazy<InjectedInstrumentationServices> internalServices = Lazy.unsafe().of(() -> (InjectedInstrumentationServices)this.getObjects().newInstance(InjectedInstrumentationServices.class, new Object[0]));

    @Inject
    public abstract ObjectFactory getObjects();

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputArtifact
    public abstract Provider<FileSystemLocation> getInput();

    protected void doTransform(File artifactToTransform, TransformOutputs outputs) {
        InstrumentationTransformUtils.createInstrumentationClasspathMarker(outputs);
        if (!artifactToTransform.exists()) {
            InstrumentationTransformUtils.createNewFile(outputs.file((Object)TransformedClassPath.FileMarker.ORIGINAL_FILE_DOES_NOT_EXIST_MARKER.getFileName()));
            return;
        }
        if (this.isAgentSupported()) {
            InstrumentationTransformUtils.createNewFile(outputs.file((Object)TransformedClassPath.FileMarker.AGENT_INSTRUMENTATION_MARKER.getFileName()));
            this.doTransform(artifactToTransform, outputs, (Function<String, String>)((Function)originalName -> "instrumented-" + originalName));
        } else {
            InstrumentationTransformUtils.createNewFile(outputs.file((Object)TransformedClassPath.FileMarker.LEGACY_INSTRUMENTATION_MARKER.getFileName()));
            this.doTransform(artifactToTransform, outputs, (Function<String, String>)((Function)originalName -> originalName));
        }
    }

    private boolean isAgentSupported() {
        return (Boolean)((Parameters)this.getParameters()).getAgentSupported().get();
    }

    private void doTransform(File input, TransformOutputs outputs, Function<String, String> instrumentedEntryNameMapper) {
        String outputPath = BaseInstrumentingArtifactTransform.getOutputPath(input, instrumentedEntryNameMapper);
        File output = input.isDirectory() ? outputs.dir((Object)outputPath) : outputs.file((Object)outputPath);
        try (InstrumentingClassTransformProvider provider = this.instrumentingClassTransformProvider(outputs);){
            InstrumentingClassTransform classTransform = provider.getClassTransform();
            ClasspathElementTransformFactory transformFactory = ((InjectedInstrumentationServices)this.internalServices.get()).getTransformFactory(this.isAgentSupported());
            ClasspathElementTransform transform = transformFactory.createTransformer(input, classTransform);
            transform.transform(output);
        }
    }

    private static String getOutputPath(File input, Function<String, String> instrumentedEntryNameMapper) {
        return "instrumented/" + (String)instrumentedEntryNameMapper.apply((Object)input.getName());
    }

    protected void doOutputOriginalArtifact(File input, TransformOutputs outputs) {
        InstrumentationTransformUtils.createInstrumentationClasspathMarker(outputs);
        if (input.isDirectory()) {
            outputs.dir((Object)input);
        } else if (((InjectedInstrumentationServices)this.internalServices.get()).getGlobalCacheLocations().isInsideGlobalCache(input.getAbsolutePath())) {
            outputs.file((Object)input);
        } else {
            File copyOfOriginalFile = outputs.file((Object)("original/" + input.getName()));
            GFileUtils.copyFile((File)input, (File)copyOfOriginalFile);
        }
    }

    protected abstract InstrumentingClassTransformProvider instrumentingClassTransformProvider(TransformOutputs var1);

    protected static interface InstrumentingClassTransformProvider
    extends AutoCloseable {
        public InstrumentingClassTransform getClassTransform();

        @Override
        public void close();
    }

    public static interface Parameters
    extends TransformParameters {
        @Internal
        public Property<CacheInstrumentationDataBuildService> getBuildService();

        @Internal
        public Property<Long> getContextId();

        @Input
        public Property<Boolean> getAgentSupported();
    }
}

