/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.trace;

import com.google.common.base.Charsets;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import groovy.json.JsonGenerator;
import groovy.json.JsonOutput;
import groovy.json.JsonSlurper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.api.NonNullApi;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.buildoption.DefaultInternalOptions;
import org.gradle.internal.buildoption.InternalFlag;
import org.gradle.internal.buildoption.InternalOption;
import org.gradle.internal.buildoption.InternalOptions;
import org.gradle.internal.buildoption.StringInternalOption;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.internal.operations.trace.BuildOperationRecord;
import org.gradle.internal.operations.trace.BuildOperationTree;
import org.gradle.internal.operations.trace.CustomOperationTraceSerialization;
import org.gradle.internal.operations.trace.SerializedOperation;
import org.gradle.internal.operations.trace.SerializedOperationFinish;
import org.gradle.internal.operations.trace.SerializedOperationProgress;
import org.gradle.internal.operations.trace.SerializedOperationStart;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.internal.GFileUtils;

@ServiceScope(value={Scope.CrossBuildSession.class})
public class BuildOperationTrace
implements Stoppable {
    public static final String SYSPROP = "org.gradle.internal.operations.trace";
    private static final StringInternalOption TRACE_OPTION = new StringInternalOption("org.gradle.internal.operations.trace", null);
    public static final String FILTER_SYSPROP = "org.gradle.internal.operations.trace.filter";
    private static final StringInternalOption FILTER_OPTION = new StringInternalOption("org.gradle.internal.operations.trace.filter", null);
    public static final String TREE_SYSPROP = "org.gradle.internal.operations.trace.tree";
    private static final InternalFlag TRACE_TREE_OPTION = new InternalFlag("org.gradle.internal.operations.trace.tree", true);
    public static final String FILTER_SEPARATOR = ";";
    private static final byte[] NEWLINE = new byte[]{10};
    private final boolean outputTree;
    private final BuildOperationListener listener;
    private final String basePath;
    private final OutputStream logOutputStream;
    private final JsonGenerator jsonGenerator = BuildOperationTrace.createJsonGenerator();
    private final BuildOperationListenerManager buildOperationListenerManager;

    public BuildOperationTrace(StartParameter startParameter, BuildOperationListenerManager buildOperationListenerManager) {
        this.buildOperationListenerManager = buildOperationListenerManager;
        DefaultInternalOptions internalOptions = new DefaultInternalOptions(startParameter.getSystemPropertiesArgs());
        this.basePath = (String)internalOptions.getOption((InternalOption)TRACE_OPTION).get();
        if (this.basePath == null || this.basePath.equals(Boolean.FALSE.toString())) {
            this.logOutputStream = null;
            this.outputTree = false;
            this.listener = null;
            return;
        }
        Set<String> filter = BuildOperationTrace.getFilter((InternalOptions)internalOptions);
        if (filter != null) {
            this.outputTree = false;
            this.listener = new FilteringBuildOperationListener(new SerializingBuildOperationListener(this::write), filter);
        } else {
            this.outputTree = (Boolean)internalOptions.getOption((InternalOption)TRACE_TREE_OPTION).get();
            this.listener = new SerializingBuildOperationListener(this::write);
        }
        try {
            File logFile = BuildOperationTrace.logFile(this.basePath);
            GFileUtils.mkdirs((File)logFile.getParentFile());
            if (logFile.isFile()) {
                GFileUtils.forceDelete((File)logFile);
            }
            logFile.createNewFile();
            this.logOutputStream = new BufferedOutputStream(new FileOutputStream(logFile));
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        buildOperationListenerManager.addListener(this.listener);
    }

    @Nullable
    private static Set<String> getFilter(InternalOptions internalOptions) {
        String filterProperty = (String)internalOptions.getOption((InternalOption)FILTER_OPTION).get();
        if (filterProperty == null) {
            return null;
        }
        return new HashSet<String>(Arrays.asList(filterProperty.split(FILTER_SEPARATOR)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.buildOperationListenerManager.removeListener(this.listener);
        if (this.logOutputStream != null) {
            try {
                OutputStream outputStream = this.logOutputStream;
                synchronized (outputStream) {
                    this.logOutputStream.close();
                }
                if (this.outputTree) {
                    List<BuildOperationRecord> roots = BuildOperationTrace.readLogToTreeRoots(BuildOperationTrace.logFile(this.basePath), false);
                    this.writeDetailTree(roots);
                    this.writeSummaryTree(roots);
                }
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(SerializedOperation operation) {
        Thread currentThread = Thread.currentThread();
        ClassLoader previousClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(JsonOutput.class.getClassLoader());
        try {
            String json = this.jsonGenerator.toJson(operation.toMap());
            try {
                OutputStream outputStream = this.logOutputStream;
                synchronized (outputStream) {
                    this.logOutputStream.write(json.getBytes(StandardCharsets.UTF_8));
                    this.logOutputStream.write(NEWLINE);
                    this.logOutputStream.flush();
                }
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        finally {
            currentThread.setContextClassLoader(previousClassLoader);
        }
    }

    private void writeDetailTree(List<BuildOperationRecord> roots) throws IOException {
        try {
            String rawJson = this.jsonGenerator.toJson(BuildOperationTree.serialize(roots));
            String prettyJson = JsonOutput.prettyPrint((String)rawJson);
            Files.asCharSink((File)BuildOperationTrace.file(this.basePath, "-tree.json"), (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)prettyJson);
        }
        catch (OutOfMemoryError e) {
            System.err.println("Failed to write build operation trace JSON due to out of memory.");
        }
    }

    private void writeSummaryTree(final List<BuildOperationRecord> roots) throws IOException {
        Files.asCharSink((File)BuildOperationTrace.file(this.basePath, "-tree.txt"), (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).writeLines((Iterable)new Iterable<String>(){

            @Override
            @Nonnull
            public Iterator<String> iterator() {
                final ArrayDeque stack = new ArrayDeque(Collections.singleton(new ArrayDeque(roots)));
                final StringBuilder stringBuilder = new StringBuilder();
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        if (stack.isEmpty()) {
                            return false;
                        }
                        if (((Queue)stack.peek()).isEmpty()) {
                            stack.pop();
                            return this.hasNext();
                        }
                        return true;
                    }

                    @Override
                    public String next() {
                        Queue children = (Queue)stack.element();
                        BuildOperationRecord record = (BuildOperationRecord)children.remove();
                        stringBuilder.setLength(0);
                        int indents = stack.size() - 1;
                        for (int i = 0; i < indents; ++i) {
                            stringBuilder.append("  ");
                        }
                        if (!record.children.isEmpty()) {
                            stack.addFirst(new ArrayDeque<BuildOperationRecord>(record.children));
                        }
                        stringBuilder.append(record.displayName);
                        if (record.details != null) {
                            stringBuilder.append(" ");
                            stringBuilder.append(BuildOperationTrace.this.jsonGenerator.toJson(record.details));
                        }
                        if (record.result != null) {
                            stringBuilder.append(" ");
                            stringBuilder.append(BuildOperationTrace.this.jsonGenerator.toJson(record.result));
                        }
                        stringBuilder.append(" [");
                        stringBuilder.append(record.endTime - record.startTime);
                        stringBuilder.append("ms]");
                        stringBuilder.append(" (");
                        stringBuilder.append(record.id);
                        stringBuilder.append(")");
                        if (!record.progress.isEmpty()) {
                            for (BuildOperationRecord.Progress progress : record.progress) {
                                stringBuilder.append(StandardSystemProperty.LINE_SEPARATOR.value());
                                for (int i = 0; i < indents; ++i) {
                                    stringBuilder.append("  ");
                                }
                                stringBuilder.append("- ").append(progress.details).append(" [").append(progress.time - record.startTime).append("]");
                            }
                        }
                        return stringBuilder.toString();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    public static BuildOperationTree read(String basePath) {
        File logFile = BuildOperationTrace.logFile(basePath);
        List<BuildOperationRecord> roots = BuildOperationTrace.readLogToTreeRoots(logFile, true);
        return new BuildOperationTree(roots);
    }

    public static BuildOperationTree readPartialTree(String basePath) {
        File logFile = BuildOperationTrace.logFile(basePath);
        List<BuildOperationRecord> partialTree = BuildOperationTrace.readLogToTreeRoots(logFile, false);
        return new BuildOperationTree(partialTree);
    }

    private static List<BuildOperationRecord> readLogToTreeRoots(final File logFile, final boolean completeTree) {
        try {
            final JsonSlurper slurper = new JsonSlurper();
            final ArrayList<BuildOperationRecord> roots = new ArrayList<BuildOperationRecord>();
            final HashMap pendings = new HashMap();
            final HashMap childrens = new HashMap();
            final ArrayList<SerializedOperationProgress> danglingProgress = new ArrayList<SerializedOperationProgress>();
            Files.asCharSource((File)logFile, (Charset)Charsets.UTF_8).readLines((LineProcessor)new LineProcessor<Void>(){

                public boolean processLine(String line) {
                    Map map = (Map)Cast.uncheckedNonnullCast((Object)slurper.parseText(line));
                    if (map.containsKey("startTime")) {
                        SerializedOperationStart serialized = new SerializedOperationStart(map);
                        pendings.put(serialized.id, new PendingOperation(serialized));
                        childrens.put(serialized.id, new LinkedList());
                    } else if (map.containsKey("time")) {
                        SerializedOperationProgress serialized = new SerializedOperationProgress(map);
                        PendingOperation pending = (PendingOperation)pendings.get(serialized.id);
                        if (pending != null) {
                            pending.progress.add(serialized);
                        } else {
                            if (completeTree) {
                                throw new IllegalStateException("did not find owner of progress event with ID " + serialized.id);
                            }
                            danglingProgress.add(serialized);
                        }
                    } else {
                        SerializedOperationFinish finish = new SerializedOperationFinish(map);
                        PendingOperation pending = (PendingOperation)pendings.remove(finish.id);
                        assert (pending != null);
                        List children = (List)childrens.remove(finish.id);
                        assert (children != null);
                        SerializedOperationStart start = pending.start;
                        Map detailsMap = (Map)Cast.uncheckedCast((Object)start.details);
                        Map resultMap = (Map)Cast.uncheckedCast((Object)finish.result);
                        BuildOperationRecord record = new BuildOperationRecord(start.id, start.parentId, start.displayName, start.startTime, finish.endTime, detailsMap == null ? null : Collections.unmodifiableMap(detailsMap), start.detailsClassName, resultMap == null ? null : Collections.unmodifiableMap(resultMap), finish.resultClassName, finish.failureMsg, BuildOperationTrace.convertProgressEvents(pending.progress), (List<BuildOperationRecord>)BuildOperationRecord.ORDERING.immutableSortedCopy((Iterable)children));
                        if (start.parentId == null) {
                            roots.add(record);
                        } else {
                            List parentChildren = (List)childrens.get(start.parentId);
                            if (parentChildren != null) {
                                parentChildren.add(record);
                            } else {
                                if (completeTree) {
                                    throw new IllegalStateException("parentChildren != null '" + line + "' from " + logFile);
                                }
                                roots.add(record);
                            }
                        }
                    }
                    return true;
                }

                public Void getResult() {
                    return null;
                }
            });
            assert (pendings.isEmpty());
            if (!completeTree && !danglingProgress.isEmpty()) {
                roots.add(new BuildOperationRecord(-1L, null, "Dangling pending operations", 0L, 0L, null, null, null, null, null, BuildOperationTrace.convertProgressEvents(danglingProgress), Collections.emptyList()));
            }
            return roots;
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private static List<BuildOperationRecord.Progress> convertProgressEvents(List<SerializedOperationProgress> toConvert) {
        ArrayList<BuildOperationRecord.Progress> progresses = new ArrayList<BuildOperationRecord.Progress>();
        for (SerializedOperationProgress progress : toConvert) {
            Map progressDetailsMap = (Map)Cast.uncheckedCast((Object)progress.details);
            progresses.add(new BuildOperationRecord.Progress(progress.time, progressDetailsMap, progress.detailsClassName));
        }
        return progresses;
    }

    private static File logFile(String basePath) {
        return BuildOperationTrace.file(basePath, "-log.txt");
    }

    private static File file(String base, String suffix) {
        return new File((base == null || base.trim().isEmpty() ? "operations" : base) + suffix).getAbsoluteFile();
    }

    public static Object toSerializableModel(Object object) {
        if (object instanceof CustomOperationTraceSerialization) {
            return ((CustomOperationTraceSerialization)object).getCustomOperationTraceSerializableModel();
        }
        return object;
    }

    private static JsonGenerator createJsonGenerator() {
        return new JsonGenerator.Options().addConverter((JsonGenerator.Converter)new JsonClassConverter()).addConverter((JsonGenerator.Converter)new JsonThrowableConverter()).excludeFieldsByName(new CharSequence[]{"resolutionFailure"}).build();
    }

    private static class FilteringBuildOperationListener
    implements BuildOperationListener {
        private final BuildOperationListener delegate;
        private final Set<String> filter;

        public FilteringBuildOperationListener(BuildOperationListener delegate, Set<String> filter) {
            this.delegate = delegate;
            this.filter = filter;
        }

        public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
            if (buildOperation.getDetails() != null && this.filter.contains(buildOperation.getDetails().getClass().getName())) {
                this.delegate.started(buildOperation, startEvent);
            }
        }

        public void progress(OperationIdentifier operationIdentifier, OperationProgressEvent progressEvent) {
            if (progressEvent.getDetails() != null && this.filter.contains(progressEvent.getDetails().getClass().getName())) {
                this.delegate.progress(operationIdentifier, progressEvent);
            }
        }

        public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
            if (buildOperation.getDetails() != null && this.filter.contains(buildOperation.getDetails().getClass().getName()) || finishEvent.getResult() != null && this.filter.contains(finishEvent.getResult().getClass().getName())) {
                this.delegate.finished(buildOperation, finishEvent);
            }
        }
    }

    private static class SerializingBuildOperationListener
    implements BuildOperationListener {
        private final Consumer<SerializedOperation> consumer;

        public SerializingBuildOperationListener(Consumer<SerializedOperation> consumer) {
            this.consumer = consumer;
        }

        public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
            this.consumer.accept(new SerializedOperationStart(buildOperation, startEvent));
        }

        public void progress(OperationIdentifier buildOperationId, OperationProgressEvent progressEvent) {
            this.consumer.accept(new SerializedOperationProgress(buildOperationId, progressEvent));
        }

        public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
            this.consumer.accept(new SerializedOperationFinish(buildOperation, finishEvent));
        }
    }

    @NonNullApi
    private static class JsonThrowableConverter
    implements JsonGenerator.Converter {
        private JsonThrowableConverter() {
        }

        public boolean handles(Class<?> type) {
            return Throwable.class.isAssignableFrom(type);
        }

        public Object convert(Object value, String key) {
            Throwable throwable = (Throwable)value;
            String message = throwable.getMessage();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            if (message != null) {
                builder.put((Object)"message", (Object)message);
            }
            builder.put((Object)"stackTrace", (Object)Throwables.getStackTraceAsString((Throwable)throwable));
            return builder.build();
        }
    }

    @NonNullApi
    private static class JsonClassConverter
    implements JsonGenerator.Converter {
        private JsonClassConverter() {
        }

        public boolean handles(Class<?> type) {
            return Class.class.equals(type);
        }

        public Object convert(Object value, String key) {
            Class clazz = (Class)value;
            return clazz.getName();
        }
    }

    static class PendingOperation {
        final SerializedOperationStart start;
        final List<SerializedOperationProgress> progress = new ArrayList<SerializedOperationProgress>();

        PendingOperation(SerializedOperationStart start) {
            this.start = start;
        }
    }
}

