/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.progress;

import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.core.CoreBundle;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.EdtReplacementThread;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.PerformInBackgroundOption;
import org.jetbrains.kotlin.com.intellij.openapi.progress.Progressive;
import org.jetbrains.kotlin.com.intellij.openapi.progress.TaskInfo;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;

public abstract class Task
implements Progressive,
TaskInfo {
    private static final Logger LOG = Logger.getInstance(Task.class);
    @Nullable
    protected final Project myProject;
    @Nullable
    protected final JComponent myParentComponent;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    protected String myTitle;
    private final boolean myCanBeCancelled;
    private String myCancelText;
    private String myCancelTooltipText;

    private Task(@Nullable Project project, @Nullable JComponent parentComponent, @NotNull String title, boolean canBeCancelled) {
        if (title == null) {
            Task.$$$reportNull$$$0(0);
        }
        this.myCancelText = CoreBundle.message("button.cancel", new Object[0]);
        this.myCancelTooltipText = CoreBundle.message("button.cancel", new Object[0]);
        this.myProject = project;
        this.myParentComponent = parentComponent;
        this.myTitle = title;
        this.myCanBeCancelled = canBeCancelled;
    }

    public void onCancel() {
    }

    public void onSuccess() {
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void onError(@NotNull Exception error) {
        if (error == null) {
            Task.$$$reportNull$$$0(1);
        }
        LOG.error(error);
    }

    public void onThrowable(@NotNull Throwable error) {
        if (error == null) {
            Task.$$$reportNull$$$0(2);
        }
        if (error instanceof Exception) {
            this.onError((Exception)error);
        } else {
            LOG.error(error);
        }
    }

    public void onFinished() {
    }

    @NotNull
    public EdtReplacementThread whereToRunCallbacks() {
        EdtReplacementThread edtReplacementThread = EdtReplacementThread.EDT_WITH_IW;
        if (edtReplacementThread == null) {
            Task.$$$reportNull$$$0(3);
        }
        return edtReplacementThread;
    }

    public final Project getProject() {
        return this.myProject;
    }

    @Nullable
    public final JComponent getParentComponent() {
        return this.myParentComponent;
    }

    @NotNull
    public final String getTitle() {
        String string2 = this.myTitle;
        if (string2 == null) {
            Task.$$$reportNull$$$0(4);
        }
        return string2;
    }

    public final String getCancelText() {
        return this.myCancelText;
    }

    public boolean isHeadless() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    public final boolean isCancellable() {
        return this.myCanBeCancelled;
    }

    public abstract boolean isModal();

    @NotNull
    public final Modal asModal() {
        if (this.isModal()) {
            Modal modal = (Modal)this;
            if (modal == null) {
                Task.$$$reportNull$$$0(9);
            }
            return modal;
        }
        throw new IllegalStateException("Not a modal task");
    }

    @NotNull
    public final Backgroundable asBackgroundable() {
        if (!this.isModal()) {
            Backgroundable backgroundable = (Backgroundable)this;
            if (backgroundable == null) {
                Task.$$$reportNull$$$0(10);
            }
            return backgroundable;
        }
        throw new IllegalStateException("Not a backgroundable task");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/progress/Task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/progress/Task";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "whereToRunCallbacks";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "setTitle";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setCancelText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "setCancelTooltipText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "asModal";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "asBackgroundable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onError";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onThrowable";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setTitle";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class Modal
    extends Task {
        public Modal(@Nullable Project project, @NotNull String title, boolean canBeCancelled) {
            if (title == null) {
                Modal.$$$reportNull$$$0(0);
            }
            this(project, null, title, canBeCancelled);
        }

        public Modal(@Nullable Project project, @Nullable JComponent parentComponent, @NotNull String title, boolean canBeCancelled) {
            if (title == null) {
                Modal.$$$reportNull$$$0(1);
            }
            super(project, parentComponent, title, canBeCancelled);
        }

        @Override
        public final boolean isModal() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/kotlin/com/intellij/openapi/progress/Task$Modal", "<init>"));
        }
    }

    public static abstract class Backgroundable
    extends Task
    implements PerformInBackgroundOption {
        @NotNull
        private final PerformInBackgroundOption myBackgroundOption;

        public Backgroundable(@Nullable Project project, @NotNull String title, boolean canBeCancelled, @Nullable PerformInBackgroundOption backgroundOption) {
            if (title == null) {
                Backgroundable.$$$reportNull$$$0(2);
            }
            this(project, null, title, canBeCancelled, backgroundOption);
        }

        public Backgroundable(@Nullable Project project, @Nullable JComponent parentComponent, @NotNull String title, boolean canBeCancelled, @Nullable PerformInBackgroundOption backgroundOption) {
            if (title == null) {
                Backgroundable.$$$reportNull$$$0(3);
            }
            super(project, parentComponent, title, canBeCancelled);
            this.myBackgroundOption = ObjectUtils.notNull(backgroundOption, ALWAYS_BACKGROUND);
            if (StringUtil.isEmptyOrSpaces(title)) {
                LOG.warn("Empty title for backgroundable task.", new Throwable());
            }
        }

        @Override
        public boolean shouldStartInBackground() {
            return this.myBackgroundOption.shouldStartInBackground();
        }

        @Override
        public final boolean isModal() {
            return false;
        }

        public boolean isConditionalModal() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/kotlin/com/intellij/openapi/progress/Task$Backgroundable", "<init>"));
        }
    }

    public static abstract class WithResult<T, E extends Exception>
    extends Modal {
        private volatile T myResult;
        private volatile Throwable myError;

        public T getResult() throws E {
            Throwable t = this.myError;
            if (t != null) {
                ExceptionUtil.rethrowUnchecked(t);
                throw (Exception)t;
            }
            return this.myResult;
        }
    }
}

