/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.ErrorReportingContextKt;
import org.jetbrains.kotlin.backend.common.IrValidationContext;
import org.jetbrains.kotlin.backend.common.IrValidationError;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.IrVerificationMode;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J8\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/common/IrValidationContextImpl;", "Lorg/jetbrains/kotlin/backend/common/IrValidationContext;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "mode", "Lorg/jetbrains/kotlin/config/IrVerificationMode;", "<init>", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/config/IrVerificationMode;)V", "hasValidationErrors", "", "reportIrValidationError", "", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "message", "", "phaseName", "parentChain", "", "throwValidationErrorIfNeeded", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nIrValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrValidator.kt\norg/jetbrains/kotlin/backend/common/IrValidationContextImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n1#2:258\n*E\n"})
final class IrValidationContextImpl
implements IrValidationContext {
    @NotNull
    private final MessageCollector messageCollector;
    @NotNull
    private final IrVerificationMode mode;
    private boolean hasValidationErrors;

    public IrValidationContextImpl(@NotNull MessageCollector messageCollector, @NotNull IrVerificationMode mode) {
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.messageCollector = messageCollector;
        this.mode = mode;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void reportIrValidationError(@Nullable IrFile file2, @NotNull IrElement element, @NotNull String message, @NotNull String phaseName, @NotNull List<? extends IrElement> parentChain) {
        CompilerMessageLocation compilerMessageLocation;
        IrFile $this$reportIrValidationError_u24lambda_u240;
        StringBuilder stringBuilder;
        CompilerMessageSeverity compilerMessageSeverity;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)phaseName, (String)"phaseName");
        Intrinsics.checkNotNullParameter(parentChain, (String)"parentChain");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                compilerMessageSeverity = CompilerMessageSeverity.WARNING;
                break;
            }
            case 2: {
                compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                break;
            }
            case 3: {
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        CompilerMessageSeverity severity = compilerMessageSeverity;
        this.hasValidationErrors = true;
        String phaseMessage = ((CharSequence)phaseName).length() > 0 ? phaseName + ": " : "";
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        CompilerMessageSeverity compilerMessageSeverity2 = severity;
        MessageCollector messageCollector = this.messageCollector;
        boolean bl = false;
        ((StringBuilder)((Object)$this$reportIrValidationError_u24lambda_u240)).append("[IR VALIDATION] ");
        ((StringBuilder)((Object)$this$reportIrValidationError_u24lambda_u240)).append(phaseMessage);
        StringBuilder stringBuilder3 = ((StringBuilder)((Object)$this$reportIrValidationError_u24lambda_u240)).append(message);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        ((StringBuilder)((Object)$this$reportIrValidationError_u24lambda_u240)).append(RenderIrElementKt.render$default(element, null, 1, null));
        Iterator iterator2 = ((Iterable)CollectionsKt.asReversed(parentChain)).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            IrElement parent2 = (IrElement)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)((Object)$this$reportIrValidationError_u24lambda_u240)).append('\n'), (String)"append(...)");
            ((StringBuilder)((Object)$this$reportIrValidationError_u24lambda_u240)).append(StringsKt.repeat((CharSequence)"  ", (int)(i + 1)));
            ((StringBuilder)((Object)$this$reportIrValidationError_u24lambda_u240)).append("inside ");
            ((StringBuilder)((Object)$this$reportIrValidationError_u24lambda_u240)).append(RenderIrElementKt.render$default(parent2, null, 1, null));
        }
        Object object = Unit.INSTANCE;
        MessageCollector messageCollector2 = messageCollector;
        CompilerMessageSeverity compilerMessageSeverity3 = compilerMessageSeverity2;
        String string2 = stringBuilder.toString();
        String string3 = string2;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        IrFile irFile = file2;
        if (irFile != null) {
            void p0;
            $this$reportIrValidationError_u24lambda_u240 = irFile;
            object = string3;
            compilerMessageSeverity2 = compilerMessageSeverity3;
            messageCollector = messageCollector2;
            boolean bl2 = false;
            CompilerMessageLocation compilerMessageLocation2 = ErrorReportingContextKt.getCompilerMessageLocation(element, (IrFile)p0);
            messageCollector2 = messageCollector;
            compilerMessageSeverity3 = compilerMessageSeverity2;
            string3 = object;
            compilerMessageLocation = compilerMessageLocation2;
        } else {
            compilerMessageLocation = null;
        }
        messageCollector2.report(compilerMessageSeverity3, string3, compilerMessageLocation);
    }

    @Override
    public void throwValidationErrorIfNeeded() {
        if (this.hasValidationErrors && this.mode == IrVerificationMode.ERROR) {
            throw new IrValidationError(null, null, 3, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrVerificationMode.values().length];
            try {
                nArray[IrVerificationMode.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrVerificationMode.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrVerificationMode.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

