/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.List;
import org.gradle.api.internal.GradleInternal;
import org.gradle.configuration.InitScriptProcessor;
import org.gradle.groovy.scripts.TextResourceScriptSource;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.resource.TextFileResourceLoader;
import org.gradle.internal.resource.TextResource;

public class InitScriptHandler {
    private final InitScriptProcessor processor;
    private final BuildOperationRunner buildOperationRunner;
    private final TextFileResourceLoader resourceLoader;

    public InitScriptHandler(InitScriptProcessor processor, BuildOperationRunner buildOperationRunner, TextFileResourceLoader resourceLoader) {
        this.processor = processor;
        this.buildOperationRunner = buildOperationRunner;
        this.resourceLoader = resourceLoader;
    }

    public void executeScripts(final GradleInternal gradle) {
        final List initScripts = gradle.getStartParameter().getAllInitScripts();
        if (initScripts.isEmpty()) {
            return;
        }
        this.buildOperationRunner.run(new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                for (File script : initScripts) {
                    TextResource resource = InitScriptHandler.this.resourceLoader.loadFile("initialization script", script);
                    InitScriptHandler.this.processor.process(new TextResourceScriptSource(resource), gradle);
                }
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Run init scripts").progressDisplayName("Running init scripts");
            }
        });
    }
}

