/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.transform.TransformedVariant;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.catalog.problems.ResolutionFailureProblemId;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.DocLink;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.problems.internal.Problem;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.GraphSelectionCandidates;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.ResolutionFailureDescriberRegistry;
import org.gradle.internal.component.resolution.failure.describer.ResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.exception.AbstractResolutionFailureException;
import org.gradle.internal.component.resolution.failure.interfaces.ResolutionFailure;
import org.gradle.internal.component.resolution.failure.type.AmbiguousArtifactTransformsFailure;
import org.gradle.internal.component.resolution.failure.type.AmbiguousArtifactsFailure;
import org.gradle.internal.component.resolution.failure.type.AmbiguousVariantsFailure;
import org.gradle.internal.component.resolution.failure.type.ConfigurationDoesNotExistFailure;
import org.gradle.internal.component.resolution.failure.type.ConfigurationNotCompatibleFailure;
import org.gradle.internal.component.resolution.failure.type.IncompatibleMultipleNodesValidationFailure;
import org.gradle.internal.component.resolution.failure.type.NoCompatibleArtifactFailure;
import org.gradle.internal.component.resolution.failure.type.NoCompatibleVariantsFailure;
import org.gradle.internal.component.resolution.failure.type.NoVariantsWithMatchingCapabilitiesFailure;
import org.gradle.internal.component.resolution.failure.type.UnknownArtifactSelectionFailure;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.util.internal.TextUtil;

public class ResolutionFailureHandler {
    public static final String DEFAULT_MESSAGE_PREFIX = "Review the variant matching algorithm at ";
    private final ResolutionFailureDescriberRegistry defaultFailureDescribers;
    private final InternalProblems problemsService;

    public ResolutionFailureHandler(ResolutionFailureDescriberRegistry failureDescriberRegistry, InternalProblems problemsService) {
        this.defaultFailureDescribers = failureDescriberRegistry;
        this.problemsService = problemsService;
    }

    public AbstractResolutionFailureException configurationNotCompatibleFailure(AttributesSchemaInternal schema, AttributeMatcher matcher, ComponentGraphResolveState targetComponent, VariantGraphResolveState targetConfiguration, AttributeContainerInternal requestedAttributes, ImmutableCapabilities targetConfigurationCapabilities) {
        ResolutionCandidateAssessor resolutionCandidateAssessor = new ResolutionCandidateAssessor(requestedAttributes, matcher);
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = Collections.singletonList(resolutionCandidateAssessor.assessCandidate(targetConfiguration.getName(), targetConfigurationCapabilities, targetConfiguration.getAttributes()));
        ConfigurationNotCompatibleFailure failure = new ConfigurationNotCompatibleFailure(targetComponent.getId(), targetConfiguration.getName(), requestedAttributes, assessedCandidates);
        return this.describeFailure(schema, failure);
    }

    public AbstractResolutionFailureException configurationDoesNotExistFailure(ComponentGraphResolveState targetComponent, String targetConfigurationName) {
        ConfigurationDoesNotExistFailure failure = new ConfigurationDoesNotExistFailure(targetComponent.getId(), targetConfigurationName);
        return this.describeFailure(failure);
    }

    public AbstractResolutionFailureException ambiguousVariantsFailure(AttributesSchemaInternal schema, AttributeMatcher matcher, ComponentGraphResolveState targetComponent, AttributeContainerInternal requestedAttributes, ImmutableCapabilities requestedCapabilities, List<? extends VariantGraphResolveState> matchingVariants) {
        ResolutionCandidateAssessor resolutionCandidateAssessor = new ResolutionCandidateAssessor(requestedAttributes, matcher);
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = resolutionCandidateAssessor.assessResolvedVariantStates(matchingVariants, targetComponent.getDefaultCapability());
        AmbiguousVariantsFailure failure = new AmbiguousVariantsFailure(targetComponent.getId(), requestedAttributes, requestedCapabilities, assessedCandidates);
        return this.describeFailure(schema, failure);
    }

    public AbstractResolutionFailureException noVariantsFailure(AttributesSchemaInternal schema, AttributeMatcher matcher, ComponentGraphResolveState targetComponent, AttributeContainerInternal requestedAttributes, ImmutableCapabilities requestedCapabilities, GraphSelectionCandidates candidates) {
        ResolutionCandidateAssessor resolutionCandidateAssessor = new ResolutionCandidateAssessor(requestedAttributes, matcher);
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = resolutionCandidateAssessor.assessGraphSelectionCandidates(candidates);
        NoCompatibleVariantsFailure failure = new NoCompatibleVariantsFailure(targetComponent.getId(), requestedAttributes, requestedCapabilities, assessedCandidates);
        return this.describeFailure(schema, failure);
    }

    public AbstractResolutionFailureException noCompatibleVariantsFailure(AttributesSchemaInternal schema, AttributeMatcher matcher, ComponentGraphResolveState targetComponent, AttributeContainerInternal requestedAttributes, ImmutableCapabilities requestedCapabilities, GraphSelectionCandidates candidates) {
        ResolutionCandidateAssessor resolutionCandidateAssessor = new ResolutionCandidateAssessor(requestedAttributes, matcher);
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = resolutionCandidateAssessor.assessGraphSelectionCandidates(candidates);
        NoCompatibleVariantsFailure failure = new NoCompatibleVariantsFailure(targetComponent.getId(), requestedAttributes, requestedCapabilities, assessedCandidates);
        return this.describeFailure(schema, failure);
    }

    public AbstractResolutionFailureException noVariantsWithMatchingCapabilitiesFailure(AttributesSchemaInternal schema, AttributeMatcher matcher, ComponentGraphResolveState targetComponent, ImmutableAttributes requestedAttributes, ImmutableCapabilities requestedCapabilities, List<? extends VariantGraphResolveState> candidates) {
        ResolutionCandidateAssessor resolutionCandidateAssessor = new ResolutionCandidateAssessor((AttributeContainerInternal)requestedAttributes, matcher);
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = resolutionCandidateAssessor.assessResolvedVariantStates(candidates, targetComponent.getDefaultCapability());
        NoVariantsWithMatchingCapabilitiesFailure failure = new NoVariantsWithMatchingCapabilitiesFailure(targetComponent.getId(), (AttributeContainerInternal)requestedAttributes, requestedCapabilities, assessedCandidates);
        return this.describeFailure(schema, failure);
    }

    public AbstractResolutionFailureException incompatibleMultipleNodesValidationFailure(AttributesSchemaInternal schema, ComponentGraphResolveMetadata selectedComponent, Set<VariantGraphResolveMetadata> incompatibleNodes) {
        ResolutionCandidateAssessor resolutionCandidateAssessor = new ResolutionCandidateAssessor((AttributeContainerInternal)ImmutableAttributes.EMPTY, schema.matcher());
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = resolutionCandidateAssessor.assessNodeMetadatas(incompatibleNodes);
        IncompatibleMultipleNodesValidationFailure failure = new IncompatibleMultipleNodesValidationFailure(selectedComponent, incompatibleNodes, assessedCandidates);
        return this.describeFailure(schema, failure);
    }

    public AbstractResolutionFailureException ambiguousArtifactTransformsFailure(AttributesSchemaInternal schema, ResolvedVariantSet targetVariantSet, ImmutableAttributes requestedAttributes, List<TransformedVariant> transformedVariants) {
        AmbiguousArtifactTransformsFailure failure = new AmbiguousArtifactTransformsFailure(this.getOrCreateVariantSetComponentIdentifier(targetVariantSet), targetVariantSet.asDescribable().getDisplayName(), (AttributeContainerInternal)requestedAttributes, transformedVariants);
        return this.describeFailure(schema, failure);
    }

    public AbstractResolutionFailureException noCompatibleArtifactFailure(AttributesSchemaInternal schema, AttributeMatcher matcher, ResolvedVariantSet targetVariantSet, ImmutableAttributes requestedAttributes, List<? extends ResolvedVariant> candidateVariants) {
        ResolutionCandidateAssessor resolutionCandidateAssessor = new ResolutionCandidateAssessor((AttributeContainerInternal)requestedAttributes, matcher);
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = resolutionCandidateAssessor.assessResolvedVariants(candidateVariants);
        NoCompatibleArtifactFailure failure = new NoCompatibleArtifactFailure(this.getOrCreateVariantSetComponentIdentifier(targetVariantSet), targetVariantSet.asDescribable().getDisplayName(), (AttributeContainerInternal)requestedAttributes, assessedCandidates);
        return this.describeFailure(schema, failure);
    }

    public AbstractResolutionFailureException ambiguousArtifactsFailure(AttributesSchemaInternal schema, AttributeMatcher matcher, ResolvedVariantSet targetVariantSet, ImmutableAttributes requestedAttributes, List<? extends ResolvedVariant> matchingVariants) {
        ResolutionCandidateAssessor resolutionCandidateAssessor = new ResolutionCandidateAssessor((AttributeContainerInternal)requestedAttributes, matcher);
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = resolutionCandidateAssessor.assessResolvedVariants(matchingVariants);
        AmbiguousArtifactsFailure failure = new AmbiguousArtifactsFailure(this.getOrCreateVariantSetComponentIdentifier(targetVariantSet), targetVariantSet.asDescribable().getDisplayName(), (AttributeContainerInternal)requestedAttributes, assessedCandidates);
        return this.describeFailure(schema, failure);
    }

    public AbstractResolutionFailureException unknownArtifactVariantSelectionFailure(AttributesSchemaInternal schema, ResolvedVariantSet targetVariantSet, ImmutableAttributes requestAttributes, Exception cause) {
        UnknownArtifactSelectionFailure failure = new UnknownArtifactSelectionFailure(this.getOrCreateVariantSetComponentIdentifier(targetVariantSet), targetVariantSet.asDescribable().getDisplayName(), (AttributeContainerInternal)requestAttributes, cause);
        return this.describeFailure(schema, failure);
    }

    private ComponentIdentifier getOrCreateVariantSetComponentIdentifier(ResolvedVariantSet resolvedVariantSet) {
        return resolvedVariantSet.getComponentIdentifier() != null ? resolvedVariantSet.getComponentIdentifier() : () -> resolvedVariantSet.asDescribable().getDisplayName();
    }

    private <FAILURE extends ResolutionFailure> AbstractResolutionFailureException describeFailure(FAILURE failure) {
        Class<?> failureType = failure.getClass();
        List<ResolutionFailureDescriber<FAILURE>> describers = this.defaultFailureDescribers.getDescribers(failureType);
        return this.describeFailure(describers, failure, Optional.empty());
    }

    private <FAILURE extends ResolutionFailure> AbstractResolutionFailureException describeFailure(AttributesSchemaInternal schema, FAILURE failure) {
        Class<?> failureType = failure.getClass();
        ArrayList<ResolutionFailureDescriber<FAILURE>> describers = new ArrayList<ResolutionFailureDescriber<FAILURE>>();
        describers.addAll(schema.getFailureDescribers(failureType));
        describers.addAll(this.defaultFailureDescribers.getDescribers(failureType));
        return this.describeFailure(describers, failure, Optional.of(schema));
    }

    private <FAILURE extends ResolutionFailure> AbstractResolutionFailureException describeFailure(List<ResolutionFailureDescriber<FAILURE>> describers, FAILURE failure, Optional<AttributesSchemaInternal> schema) {
        return describers.stream().filter(describer -> describer.canDescribeFailure(failure)).findFirst().map(describer -> describer.describeFailure(failure, schema)).map(this::reportExceptionAsProblem).orElseThrow(() -> new IllegalStateException("No describer found for failure: " + failure));
    }

    private AbstractResolutionFailureException reportExceptionAsProblem(AbstractResolutionFailureException exception) {
        Problem problem = this.problemsService.getInternalReporter().create(builder -> {
            ResolutionFailureProblemId problemId = exception.getFailure().getProblemId();
            builder.id(TextUtil.screamingSnakeToKebabCase((String)problemId.name()), problemId.getDisplayName(), GradleCoreProblemGroup.variantResolution()).contextualLabel(exception.getMessage()).documentedAt((DocLink)Documentation.userManual((String)"variant_model", (String)"sec:variant-select-errors")).severity(Severity.ERROR);
        });
        this.problemsService.getInternalReporter().report(problem);
        return exception;
    }
}

