/* -*- c++ -*- */
/*
 * Copyright 2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* this is the Italian location database, v2.2, downloaded from here:
 * https://www4.ilportaledellautomobilista.it/download/documenti_database/English%20version/DAT_22.zip
 * just the NAMES.dat so far
 * */

#define TMC_LOCATIONS_ITALIAN 13445+1

//static const std::string tmc_location_names_italian[TMC_LOCATIONS_ITALIAN][2]={
tmc_location_names_italian = new std::string[TMC_LOCATIONS_ITALIAN][2];
tmc_location_names_italian = {
	{"0",""},
	{"1","il Vittoriale (piazzale Delle Arche)"},
	{"2",""},
	{"3",""},
	{"4",""},
	{"5",""},
	{"6",""},
	{"7",""},
	{"8","A08"},
	{"9",""},
	{"10","A1"},
	{"11","A1 Roma Napoli"},
	{"12","A1(fi Certosa)"},
	{"13","A1(firenze Nord)"},
	{"14","A1/A21(est)"},
	{"15",""},
	{"16","A11"},
	{"17","A11 Firenze Pisa"},
	{"18",""},
	{"19","A13"},
	{"20","A13 Bologna-Padova"},
	{"21","A14"},
	{"22","A15"},
	{"23","A16"},
	{"24","A18"},
	{"25","A18 Dir"},
	{"26","A19"},
	{"27","A19 Palermo-Catania"},
	{"28","A20"},
	{"29","A21"},
	{"30","A21 Santena"},
	{"31",""},
	{"32","A23"},
	{"33",""},
	{"34",""},
	{"35","A26"},
	{"36",""},
	{"37","A27/A4"},
	{"38",""},
	{"39","A29"},
	{"40","A29/Diramazione Alcamo-Trapani"},
	{"41","A3"},
	{"42","A3 Salerno - R.Calabria"},
	{"43",""},
	{"44","A32"},
	{"45","A32 Torino-Bardonecchia"},
	{"46","A4"},
	{"47","A4 To-Ts"},
	{"48","A5"},
	{"49","A6"},
	{"50","A7"},
	{"51","A8"},
	{"52","Abano Terme"},
	{"53","Abbadia Di Fiastra"},
	{"54","Abbadia Di Montepulciano"},
	{"55","Abbadia Di S.Ruffino"},
	{"56","Abbadia Di Stura/Raccordo Falchera-Ss11"},
	{"57",""},
	{"58","Abbadia Lariana"},
	{"59","Abbazia Di Casamari"},
	{"60","Abbazia Di M.Oliveto"},
	{"61","Abbazia Di Montecassino"},
	{"62","Abbazia Di Sambucina"},
	{"63","Abbiategrasso"},
	{"64","Abbiategrasso/Innesto Ss494 Vigevanese"},
	{"65","Abbiategrasso/Innesto Ss526 Dell'esticino"},
	{"66","Abetone"},
	{"67","Abruzzo"},
	{"68","Acceglio"},
	{"69","Accettura"},
	{"70","Acciano"},
	{"71","Acciaroli"},
	{"72","Acerno"},
	{"73","Acerra"},
	{"74","Aci Castello"},
	{"75","Aci S.Antonio"},
	{"76","Acigliano"},
	{"77","Acilia"},
	{"78","Acireale"},
	{"79","Acqua Dei Corsari/Innesto Ss113 Sett. Sicula"},
	{"80","Acqua Dei Corsari/Innesto Ss121 Catanese"},
	{"81","Acquabona"},
	{"82","Acquacadda"},
	{"83","Acquaformosa"},
	{"84","Acquafredda"},
	{"85","Acquafredda Di Maratea"},
	{"86","Acqualagna"},
	{"87","Acqualagna/Innesto Ss257 Apecchiese"},
	{"88","Acqualagna/Innesto Ss3 Flaminia"},
	{"89","Acquanegra Cremonese"},
	{"90","Acquanegra Sul Chiese"},
	{"91","Acquapendente"},
	{"92","Acquarica Capo/Innesto Ss475 Di Casarano"},
	{"93","Acquarica Del Capo/Innesto Ss274 Salentina Di Patu'"},
	{"94","Acquaro"},
	{"95","Acquasanta Terme"},
	{"96","Acquaseria"},
	{"97","Acquasparta/Innesto Ss3 Bis Tiberina"},
	{"98","Acquaviva"},
	{"99","Acquaviva Delle Fonti"},
	{"100","Acquaviva Di Isernia"},
	{"101","Acquedolci"},
	{"102","Acquedolci Sud"},
	{"103","Acquetico"},
	{"104","Acqui Terme"},
	{"105","Acqui Terme/Incrocio Ss456 Del Turchino"},
	{"106","Acqui Terme/Innesto Ss30 Di Val Bormida"},
	{"107","Acqui Terme/Innesto Ss334 Del Sassello"},
	{"108","Acqui Terme/Innesto Ss456 Del Turchino"},
	{"109","Acri"},
	{"110","Acropoli Di Selinunte"},
	{"111","Acuto"},
	{"112","Adami"},
	{"113","Addolorata"},
	{"114","Adige"},
	{"115","Adria/Innesto Ss443 Di Adria E Ss495 Di Codigoro"},
	{"116","Adria/Innesto Ss443 Di Adria E Ss516 Piovese"},
	{"117","Adria/Innesto Ss495 Di Codigoro E Ss516 Piovese"},
	{"118","Adriatica"},
	{"119","Aeroporto Di Olbia/Innesto Ss125 Orient. Sarda"},
	{"120","Aeroporto Falcone E Borsellino"},
	{"121","Aereoporto Di Fiumicino/Allacciamento Autostrada Rm-Fiumicino"},
	{"122","Aereoporto Di Fiumicino-Allacciamento Autostrada Rm-Fiumicino"},
	{"123","Aeroporto Caselle"},
	{"124","Aeroporto Di Birgi"},
	{"125","Aeroporto Di Ciampino"},
	{"126","Aeroporto Di Elmas"},
	{"127","Aeroporto Di Fiumicino"},
	{"128","Aeroporto Di Fossoli"},
	{"129","Aeroporto Di Olbia/Innesto Ss199 Di Monti"},
	{"130","Aeroporto Di Treviso"},
	{"131","Aeroporto Falcone E Borsellino"},
	{"132","Aeroporto Tessera"},
	{"133","Affi-Lago Di Garda Sud"},
	{"134","Afragola"},
	{"135","Agaggio"},
	{"136","Agerola"},
	{"137","Agira"},
	{"138","Aglio"},
	{"139","Agnadello"},
	{"140","Agnano"},
	{"141",""},
	{"142","Agnone"},
	{"143","Agogna"},
	{"144","Agordina"},
	{"145","Agordo/Innesto Ss203 Agordina"},
	{"146","Agordo/Innesto Ss347 Passo Cereda E Duran"},
	{"147","Agrate"},
	{"148","Agrigentina"},
	{"149","Agrigento"},
	{"150","Agrigento Est/Incrocio Ss640 Di Porto Empedocle"},
	{"151","Agrigento Est/Innesto Ss115 Sud Occidentale Sicula"},
	{"152","Agrigento/Incrocio Ss640 Di Porto Empedocle"},
	{"153","Agrigento/Innesto Ss115 Sud Occ.Le Sicula"},
	{"154","Agrigento/Innesto Ss118 Corleonese Agrigentina"},
	{"155","Agrigento/Innesto Ss118 Corleonese-Agrigentina"},
	{"156","Agrigento/Innesto Ss122 Agrigentina"},
	{"157","Agrigento/Innesto Ss640 Di Porto Empedocle"},
	{"158","Agrone"},
	{"159","Agropoli"},
	{"160","Aiello Calabro"},
	{"161","Airasca"},
	{"162","Airole"},
	{"163","Aisone"},
	{"164","Ala"},
	{"165","Ala Avio"},
	{"166","Ala' Dei Sardi"},
	{"167","Alagna Valsesia"},
	{"168","Alassio"},
	{"169","Alatri"},
	{"170","Alba"},
	{"171","Alba Adriatica/Innesto Ss16 Adriatica"},
	{"172","Alba Adriatica/Innesto Ss259 Vibrata"},
	{"173","Alba/Innesto Ss231 Di S.Vittoria"},
	{"174","Alba/Innesto Ss29 Del Colle Di Cadibona"},
	{"175","Albaneto"},
	{"176","Albano Laziale"},
	{"177","Albano Laziale/Innesto Ss216 Maremmana Iii"},
	{"178","Albano Laziale/Innesto Ss7 Appia"},
	{"179","Albano S.Alessandro"},
	{"180","Albaredo Arnaboldi"},
	{"181","Albenga"},
	{"182","Albergo Monte Rovere"},
	{"183","Alberobello/Innesto Ss172 Dei Trulli"},
	{"184","Alberobello/Innesto Ss604 Di Alberobello"},
	{"185","Albi"},
	{"186","Albiano"},
	{"187","Albiano Magra"},
	{"188","Albignasego"},
	{"189","Albinia"},
	{"190","Albisola"},
	{"191","Albisola Marina"},
	{"192","Albisola Marina/Innesto Ss1 Aurelia"},
	{"193","Albisola Marina/Innesto Ss334 Del Sassello"},
	{"194","Albisola Superiore"},
	{"195","Albogascio"},
	{"196","Albonese"},
	{"197","Alcamo"},
	{"198","Alcamo Marina"},
	{"199","Aldone"},
	{"200","Alento"},
	{"201","Ales"},
	{"202","Alessandria"},
	{"203","Alessandria Della Rocca"},
	{"204","Alessandria Est"},
	{"205","Alessandria Ovest"},
	{"206","Alessandria Sud"},
	{"207","Alessandria/Bivio Con La Ss31 Del Monferrato"},
	{"208","Alessandria/Innesto Ss10 Padana Inferiore"},
	{"209","Alessandria/Innesto Ss10 Padana Inferiore"},
	{"210","Alessandria/Innesto Ss30 Di Val Bormida"},
	{"211","Alessandria/Innesto Ss494 Vigevanese"},
	{"212","Alessano"},
	{"213","Alezio"},
	{"214","Alfano"},
	{"215","Alfaterna"},
	{"216","Alfedena"},
	{"217","Alfedena/Innesto Ss158 Della Valle Del Volturno"},
	{"218","Alfedena/Innesto Ss83 Marsicana"},
	{"219","Alfonsine"},
	{"220","Alghero"},
	{"221","Alghero/Innesto Ss127 Bis Settentrionale Sarda"},
	{"222","Alghero/Innesto Ss292 Nord Occidentale Sarda"},
	{"223","Ali' Terme"},
	{"224","Alice Bel Colle"},
	{"225","Alice Castello"},
	{"226","Alife"},
	{"227","Alimena"},
	{"228","Allacciamento A1 Milano-Napoli (Direzione Sud)"},
	{"229","Allacciamento A3 Salerno-Reggio Calabria"},
	{"230","Allacciamento Diramazione Per S.Stefano Di Magra"},
	{"231",""},
	{"232","Allacciamento Raccordo Sicignano-Potenza"},
	{"233","Allacciamento Tangenziale Est Mi-Raccordo P.Le Corvetto"},
	{"234","Allacciamento Tangenziale Nord Milano"},
	{"235","Allacciamento Tangenziale Est Di Milano"},
	{"236","Allacciamento A1 Nord/Diramazione Capodichino"},
	{"237","Allacciamento A1 Sud/Diramazione Capodichino"},
	{"238","Allacciamento  A14 Bologna-Taranto"},
	{"239","Allacciamento A1 Milano Napoli"},
	{"240","Allacciamento A1 Milano-Napoli"},
	{"241","Allacciamento A1 Milano-Napoli (Direzione Nord)"},
	{"242","Allacciamento A10 Genova-Ventimiglia"},
	{"243","Allacciamento A11 Firenze-Pisa Nord"},
	{"244","Allacciamento A12 Genova-Rosignano"},
	{"245","Allacciamento A12 Roma-Civitavecchia"},
	{"246","Allacciamento A13 Bologna-Padova"},
	{"247","Allacciamento A14 Bologna Borgo Panigale"},
	{"248","Allacciamento A14 Bologna-Taranto"},
	{"249","Allacciamento A15 Parma-La Spezia"},
	{"250","Allacciamento A16 Napoli-Canosa"},
	{"251","Allacciamento A19 Palermo-Catania"},
	{"252","Allacciamento A20 Messina-Palermo"},
	{"253","Allacciamento A21 Torino-Piacenza-Brescia"},
	{"254","Allacciamento A22 Modena-Brennero"},
	{"255","Allacciamento A23 Palmanova-Tarvisio"},
	{"256","Allacciamento A24 Roma-Teramo"},
	{"257","Allacciamento A25 Torano-Pescara"},
	{"258","Allacciamento A26 Ge Voltri-Gravellona T."},
	{"259","Allacciamento A27 Mestre-Belluno"},
	{"260","Allacciamento A28 Portogruaro-Pordenone"},
	{"261","Allacciamento A29 Palerno-Mazara Del Vallo"},
	{"262","Allacciamento A30 Caserta-Salerno"},
	{"263","Allacciamento A31 Vicenza-Piovene R."},
	{"264",""},
	{"265","Allacciamento A4 Torino-Trieste"},
	{"266","Allacciamento A4 Torino-Trieste/Raccordo Per Tessera"},
	{"267","Allacciamento A4 Torino-Trieste/Raccordo A4-A5"},
	{"268","Allacciamento A4 Torino-Trieste: V.Le Certosa"},
	{"269",""},
	{"270","Allacciamento A6 Torino-Savona"},
	{"271","Allacciamento A7 Milano-Genova"},
	{"272","Allacciamento A8 Milano-Varese"},
	{"273","Allacciamento Con Ramo Casalecchio"},
	{"274","Allacciamento Diram. Predosa-Bettole"},
	{"275","Allacciamento Diramazione Aeroporto Di Birgi"},
	{"276","Allacciamento Diramazione Gallarate-Gattico"},
	{"277","Allacciamento Diramazione Lucca-Viareggio"},
	{"278",""},
	{"279","Allacciamento Diramazione Per Trapani"},
	{"280","Allacciamento Diramazione Stroppiana-Santhia'"},
	{"281","Allacciamento Diramazione Lucca-Viareggio"},
	{"282","Allacciamento Diramazione Padova Sud"},
	{"283","Allacciamento Diramazione Per Ravenna"},
	{"284","Allacciamento Diramazione Per Trapani"},
	{"285","Allacciamento Diramazione Predosa-Bettole"},
	{"286","Allacciamento Diramazione Roma Nord"},
	{"287","Allacciamento Diramazione Roma Sud"},
	{"288","Allacciamento G.R.A."},
	{"289","Allacciamento Grande Raccordo Anulare"},
	{"290","Allacciamento Raccordo A21-A1 (piacenza)"},
	{"291",""},
	{"292","Allacciamento Raccordo Per A13 Bo-Pd"},
	{"293","Allacciamento Raccordo Per AeroportoTessera"},
	{"294","Allacciamento Raccordo A4-A5"},
	{"295","Allacciamento Tangenziale Est Di Milano"},
	{"296","Allacciamento Tangenziale Nord Di Torino"},
	{"297","Allacciamento Tangenziale Ovest Di Milano"},
	{"298","Allacciamento Tangenziale Sud Di Torino"},
	{"299","Allacciamento Tangenziale Di Bologna"},
	{"300","Allacciamento  A7 Milano-Genova"},
	{"301","Allacciamento A1 Milano Napoli"},
	{"302","Allacciamento A1 Milano-Napoli"},
	{"303","Allacciamento A13 Bologna-Padova"},
	{"304","Allacciamento A20 Messina Palermo"},
	{"305","Allacciamento A27 Mestre Belluno"},
	{"306","Allacciamento A3 Napoli-Salerno"},
	{"307","Allacciamento A30 Caserta-Salerno"},
	{"308","Allacciamento A4 Torino Trieste"},
	{"309","Allacciamento A4 Torino-Trieste"},
	{"310","Allacciamento A9 Lainate-Como Chiasso"},
	{"311","Allacciamento Autostrada Roma-Fiumicino"},
	{"312","Allacciamento Diramazione Per Fiorenzuola"},
	{"313","Allacciamento Diramazione Gallarate-Gattico"},
	{"314","Allacciamento Diramazione Per Moncalieri"},
	{"315","Allacciamento G.R.A."},
	{"316","Allacciamento G.R.A./Innesto Ss8 Bis Via Ostiense"},
	{"317","Allacciamento G.R.A./Innesto Ss8 Via Del Mare"},
	{"318","Allacciamento Raccordo Pavia-Bereguardo"},
	{"319","Allacciamento Raccordo Salerno-Avellino"},
	{"320","Allacciamento Raccordo Di Firenze Nord"},
	{"321","Allacciamento Raccordo Napoli-Caserta Sud"},
	{"322","Allacciamento Tangenziale Di Bologna"},
	{"323","Allacciamento Tangenziale Di Catania"},
	{"324","Allacciamento Tangenziale Est Di Milano"},
	{"325","Allacciamento Tangenziale Nord Di Milano"},
	{"326","Allacciamento Tangenziale Ovest Di Milano"},
	{"327","Allacciamento Tangenziale Di Bari"},
	{"328","Allacciamento Tangenziale Di Pavia"},
	{"329","Allacciamento Asse Mediano"},
	{"330","Allacciamento Asse Supporto"},
	{"331","Allacciamento Ramo Casalecchio"},
	{"332","Allacciamento Tangenziale Di Napoli"},
	{"333","Alleghe"},
	{"334","Allerezze"},
	{"335",""},
	{"336","Alpignano"},
	{"337","Alseno"},
	{"338","Altamura"},
	{"339","Altare"},
	{"340","Altavilla Irpina/Innesto Ss371 Della V. Del Sabato"},
	{"341","Altavilla Irpinia/Innesto Ss88 Due Principati"},
	{"342","Altavilla Milicia"},
	{"343","Alte Ceccato/Innesto Ss11 Padana S.E Ss500 Di Lonigo"},
	{"344","Alte Ceccato/Innesto Ss11 Padana Superiore E Ss246"},
	{"345","Alte Ceccato/Innesto Ss500 Lonigo/Ss246 Di Recoaro"},
	{"346","Altedo"},
	{"347","Altichiero/Innesto Ss47 Della Valsugana"},
	{"348","Altilia-Grimaldi"},
	{"349","Altipiani Di Arcinazzo"},
	{"350","Alto Polesana"},
	{"351","Altomonte"},
	{"352","Altopascio"},
	{"353","Altopiano Dell'aremogna"},
	{"354","Alvera'"},
	{"355","Alvignanello"},
	{"356","Alvignano"},
	{"357","Alzate Brianza"},
	{"358","Amalfi"},
	{"359","Amalfitana"},
	{"360","Amandola"},
	{"361","Amandola/Innesto Ss210 Fermana Faleriense"},
	{"362","Amandola/Innesto Ss78 Picena"},
	{"363","Amantea"},
	{"364","Amantea/Innesto Ss18 Tirrena Inferiore"},
	{"365","Amantea/Innesto Ss278 Di Potame"},
	{"366","Amaroni"},
	{"367","Amato"},
	{"368","Amatrice"},
	{"369","Amatrice/Innesto Ss260 Picente"},
	{"370","Amatrice/Innesto Ss577 Del Lago Di Campotosto"},
	{"371","Ameglia"},
	{"372","Amelia"},
	{"373","Amendolara"},
	{"374","Amerina"},
	{"375","Amica"},
	{"376","Amica/Innesto Ss106 Jonica"},
	{"377","Amica/Innesto Ss106 Radd Jonica"},
	{"378","Ammeto"},
	{"379","Amorosi"},
	{"380","Amorosi/Innesto Ss265 Dei Ponti Della Valle"},
	{"381","Amorosi/Innesto Ss87 Sannitica"},
	{"382","Ampezzo"},
	{"383","Anagni - Fiuggi"},
	{"384","Anagni Innesto Ss6 Via Casilina"},
	{"385","Anagni/Innesto Ss155 Racc Di Fiuggi"},
	{"386","Anagnina"},
	{"387","Ancignano"},
	{"388","Ancona"},
	{"389","Ancona Centro"},
	{"390","Ancona Nord"},
	{"391","Ancona Sud"},
	{"392","Andalo"},
	{"393","Andora"},
	{"394","Andrazza"},
	{"395","Andretta"},
	{"396","Andria-Barletta"},
	{"397","Andriese Coratina"},
	{"398","Anela"},
	{"399","Anfo"},
	{"400","Angarano/Innesto Ss16 E Ss529"},
	{"401","Angarano/Innesto Ss16 E Ss545"},
	{"402","Angarano/Innesto Ss545 Rivolese/Ss529 Dell'ofanto"},
	{"403","Angeli"},
	{"404","Angera"},
	{"405","Anghebeni"},
	{"406","Angioina"},
	{"407","Angolo Terme"},
	{"408","Angri"},
	{"409","Angri/Innesto Ss18 Dir/B Tirrena Inferirore"},
	{"410","Angri/Innesto Ss18 Tirrena Inferiore"},
	{"411","Angri/Svincolo Per A3 Napoli-Salerno"},
	{"412","Anitrella"},
	{"413","Annone Veneto"},
	{"414","Anoia Superiore"},
	{"415","Antegnate"},
	{"416","Antegnate/Innesto Ss11 Padana Superiore"},
	{"417","Antegnate/Innesto Ss498 Soncinese"},
	{"418","Antica Campana"},
	{"419","Antignano"},
	{"420","Antognola"},
	{"421","Antrodoco"},
	{"422","Antrodoco/Innesto Ss17 App. Abruz. Appulo Sann."},
	{"423","Antrodoco/Innesto Ss4 Salaria"},
	{"424","Anversa Degli Abruzzi"},
	{"425","Anzano"},
	{"426","Anzio Colonia"},
	{"427","Anzio/Innesto Ss207 Nettunense"},
	{"428","Anzio/Innesto Ss601 Ostia Anzio"},
	{"429","Anzola Dell'emilia"},
	{"430","Anzu'"},
	{"431","Aosta"},
	{"432","Aosta/Incrocio Ss26 Della Valle D'aosta"},
	{"433","Aosta/Incrocio Ss27 Del G. S.Bernardo"},
	{"434","Apecchiese"},
	{"435","Apecchio"},
	{"436","Appula Fortorina"},
	{"437","Appulo Lucana"},
	{"438","Aprati"},
	{"439","Aprica"},
	{"440","Apricena"},
	{"441","Aprigliano"},
	{"442","Aprilia"},
	{"443","Aprilia/Incrocio Ss148 Pontina"},
	{"444","Aquileia"},
	{"445","Aquilinia"},
	{"446","Aquinum"},
	{"447","Arabba"},
	{"448","Arabba/Innesto Ss244 Di Val Badia"},
	{"449","Arabba/Innesto Ss48 Delle Dolomiti"},
	{"450","Aradeo"},
	{"451","Aragona-Caldare Staz."},
	{"452","Arborio"},
	{"453","Arbus"},
	{"454","Arce/Innesto Ss6 Casilina"},
	{"455","Arce/Innesto Ss82 Della Valle Del Liri"},
	{"456","Arcene"},
	{"457","Arcevia"},
	{"458","Arceviese"},
	{"459","Archi"},
	{"460","Arcidosso"},
	{"461","Arcisate"},
	{"462","Arco"},
	{"463","Arco Felice"},
	{"464","Arco/Innesto Ss240 Diramazione Di Loppio E Val Di Ledro"},
	{"465","Arco/Innesto Ss45 Bis Gardesana Occidentale"},
	{"466","Arcola"},
	{"467","Arda"},
	{"468","Ardeatina"},
	{"469","Ardenno/Innesto Ss404 Di Val Masino"},
	{"470","Ardenza"},
	{"471","Ardore Marina"},
	{"472","Are'"},
	{"473","Area Di Ristoro Monte Bianco"},
	{"474","Arenella-Zona Ospedaliera"},
	{"475","Arenzano"},
	{"476","Arezzo"},
	{"477","Arezzo Est/Innesto Ss71 Umb. Cas. Romagnola"},
	{"478","Arezzo Est/Innesto Ss73 Senese Aretina"},
	{"479","Arezzo/Innesto Ss69 Di Val D'arno"},
	{"480","Arezzo/Innesto Ss71 Umbro Casentinese Romag."},
	{"481","Argegno"},
	{"482","Argenta"},
	{"483","Argentera"},
	{"484","Ariana"},
	{"485","Ariano Irpino/Innesto Ss414 Di Montecalvo Irpino"},
	{"486","Ariano Irpino/Innesto Ss90 Delle Puglie"},
	{"487","Ariano Nel Polesine"},
	{"488","Ariccia"},
	{"489","Ariccia/Innesto Ss218 Via Rocca Di Papa"},
	{"490","Ariccia/Innesto Ss7 Appia"},
	{"491","Arienzo"},
	{"492","Arienzo/Innesto Ss162 Della Valle Caudina"},
	{"493","Arienzo/Innesto Ss7 Appia"},
	{"494","Aringo"},
	{"495","Arino"},
	{"496","Arischia"},
	{"497","Aritzo"},
	{"498","Arlesega"},
	{"499","Arluno"},
	{"500","Arma Di Taggia"},
	{"501","Arma Di Taggia/Innesto Ss1 Aurelia"},
	{"502","Arma Di Taggia/Innesto Ss548 Della Valle Argentina"},
	{"503","Arnaccio/Incrocio Ss206 Pisana Livornese"},
	{"504","Arnaccio/Incrocio Ss67 Bis Tosco Romagnola"},
	{"505","Arnaz"},
	{"506","Arnoga"},
	{"507","Arona"},
	{"508","Arona/Innesto Ss142 Biellese"},
	{"509","Arona/Innesto Ss33 Del Sempione"},
	{"510","Arpaia"},
	{"511","Arqua' Petrarca"},
	{"512","Arquata Del Tronto"},
	{"513","Arquata Scrivia"},
	{"514","Arrone"},
	{"515","Arsie'"},
	{"516","Arsiero"},
	{"517","Arsio"},
	{"518","Arsoli"},
	{"519","Arsoli/Innesto Ss411 Sublacense"},
	{"520","Arten/Innesto Ss141 Strada Cadorna"},
	{"521","Artena/Innesto Ss600 Ariana"},
	{"522","Artena/Innesto Ss600 Diramazione Ariana"},
	{"523","Arzachena"},
	{"524","Arzachena/Innesto Ss125 Orientale Sarda"},
	{"525","Arzachena/Innesto Ss427 Della Gallura Centrale"},
	{"526","Arzago D'adda"},
	{"527","Ascea"},
	{"528","Asciano"},
	{"529","Asciano/Innesto Ss438 Lauretana"},
	{"530","Asciano/Innesto Ss451 Di Monte Oliveto"},
	{"531","Ascoli Piceno"},
	{"532","Ascoli Piceno - Ss4 Via Salaria"},
	{"533","Ascoli Piceno/Innesto Raccordo Ascoli-P.To D'ascoli"},
	{"534","Ascoli Piceno-Innesto Ss81 Piceno Aprutina"},
	{"535","Asiago"},
	{"536","Asnago Cermenate"},
	{"537","Aso"},
	{"538","Asola"},
	{"539","Asolana"},
	{"540","Asolo"},
	{"541","Aspio Terme"},
	{"542","Aspromonte Jonio"},
	{"543","Assago Ovest"},
	{"544","Asse Attrezzato Cerignola-Bari"},
	{"545","Asse Mediano A1 Milano-Napoli"},
	{"546","Assemini"},
	{"547","Assenza Di Brenzone"},
	{"548","Assergi"},
	{"549","Assergi/Allacciamento A24 Roma-Teramo"},
	{"550","Assisi"},
	{"551","Assisi/Innesto Ss147 Di Assisi"},
	{"552","Assisi/Innesto Ss444 Del Subasio"},
	{"553","Asti"},
	{"554","Asti Est"},
	{"555","Asti Ovest"},
	{"556","Asti/Innesto Ss10 Padana Inferiore"},
	{"557","Asti/Innesto Ss457 Di Moncalvo"},
	{"558","Astracaccio"},
	{"559","Astroni"},
	{"560","Ateleta"},
	{"561","Atena Lucana"},
	{"562","Atessa"},
	{"563","Atina"},
	{"564","Atina Inferiore"},
	{"565","Atrani/Innesto Ss163 Amalfitana"},
	{"566","Atrani/Innesto Ss373 Di Ravello"},
	{"567","Atri"},
	{"568","Atri-Pineto"},
	{"569","Attigliano"},
	{"570","Attimis"},
	{"571","Atzara"},
	{"572","Augusta"},
	{"573","Aulla"},
	{"574","Aulla/Innesto Ss62 Della Cisa"},
	{"575","Aulla/Innesto Ss63 Del Valico Del Cerreto"},
	{"576","Aulla/Innesto Ss665 Massese"},
	{"577","Aune"},
	{"578","Aurelia"},
	{"579","Aurelia Bis"},
	{"580","Aurelia Sud"},
	{"581","Auronzo Di Cadore"},
	{"582","Auronzo Di Cadore/Innesto Ss48 Delle Dolomiti"},
	{"583","Auronzo Di Cadore/Innesto Ss532 Passo S.Antonio"},
	{"584","Ausonia"},
	{"585",""},
	{"586","Autoporto Di Fernetti-Dogana"},
	{"587","Autoporto Freney"},
	{"588","Autoporto Riviera Dei Fiori"},
	{"589","Autostrada Aeroporto Di Fiumicino"},
	{"590","Autostrada Del Brennero"},
	{"591","Autostrada Del Valdastico"},
	{"592","Avausa"},
	{"593","Avellino"},
	{"594","Avellino Est"},
	{"595","Avellino Ovest"},
	{"596","Avellino Ponte"},
	{"597","Avellino/Innesto Raccordo Salerno-Avellino"},
	{"598","Avellino/Innesto Ss374 Di Summonte E Montevergine"},
	{"599","Avellino/Innesto Ss7 Bis Di Terra Di Lavoro"},
	{"600","Avellino/Innesto Ss88 Dei Due Principati"},
	{"601","Avellino-Ss7bis Terra Di Lavoro"},
	{"602","Avenes"},
	{"603","Aversa"},
	{"604","Avetrana"},
	{"605","Avezzano"},
	{"606","Avezzano/Innesto Ss5 Tiburtina Valeria"},
	{"607","Avezzano/Innesto Ss82 Della Valle Del Liri"},
	{"608","Avigliana"},
	{"609","Avigliana/Innesto Ss25 Del Moncenisio"},
	{"610","Avigliana/Innesto Ss589 Dei Laghi Di Avigliana"},
	{"611","Avigno"},
	{"612","Avola"},
	{"613","Aymavilles"},
	{"614","Aymavilles/Innesto Strada Reg. 46"},
	{"615","Azzano Decimo"},
	{"616","B.Go Panigale"},
	{"617","B.Go S.Lorenzo/Innesto Ss302 Brisighellese Ravenn."},
	{"618","B.Go Salsasio/Innesto Ss393 Di Villa Stellone"},
	{"619","Baccano"},
	{"620","Baceno"},
	{"621","Badalucco"},
	{"622","Badani"},
	{"623","Badesse (Direzione Firenze)"},
	{"624","Badesse (Direzione Siena)"},
	{"625","Badia A Coltibuono/Innesto Ss408 Di Montivarchi"},
	{"626","Badia A Ripoli/Innesto Ss222 Chiantigiana"},
	{"627","Badia A Ripoli/Innesto Ss67 Tosco/Romagnola"},
	{"628","Badia Al Pino"},
	{"629","Badia Di Cava"},
	{"630","Badia Polesine/Innesto Ss434 Transpolesana"},
	{"631","Badia Polesine/Innesto Ss482 Alto Polesana"},
	{"632","Badia Prataglia"},
	{"633","Badia Tebalda"},
	{"634","Badile"},
	{"635","Badolato Marina"},
	{"636","Bagaladi"},
	{"637","Bagheria"},
	{"638","Baglio"},
	{"639","Bagnacavallo"},
	{"640","Bagnara"},
	{"641","Bagnara Calabra"},
	{"642","Bagnaria"},
	{"643","Bagnasco"},
	{"644","Bagnasco/Innesto Ss28 Del Colle Di Nava"},
	{"645","Bagnasco/Innesto Ss490 Del Colle Del Melogno"},
	{"646","Bagni Di Bormio"},
	{"647","Bagni Di Caprile"},
	{"648","Bagni Di Contursi"},
	{"649","Bagni Di Lucca"},
	{"650","Bagni Di Masino"},
	{"651","Bagni Di Tivoli"},
	{"652","Bagni Di Tivoli/Innesto Ss5 Ter"},
	{"653","Bagni Di Tivoli/Innesto Ss5 Tiburtina Valeria"},
	{"654","Bagno Di Romagna/Innesto Ss3 Bis Tiberina"},
	{"655","Bagno Di Romagna/Innesto Ss71 Umbro Cas. Romagn."},
	{"656","Bagno La Perla/Innesto Ss329 Del P.Bocca Di Valle"},
	{"657","Bagno La Perla/Innesto Ss439 Sarzanese Valdera"},
	{"658","Bagnoli Irpino"},
	{"659","Bagnolo"},
	{"660","Bagnolo Mella"},
	{"661","Bagnolo S.Vito"},
	{"662","Bagolino"},
	{"663","Baiano"},
	{"664","Baldaria"},
	{"665","Baldichieri D'asti"},
	{"666","Balestrate"},
	{"667","Ballao"},
	{"668","Ballatella"},
	{"669","Ballino"},
	{"670","Balmuccia"},
	{"671","Balocco"},
	{"672","Balsorano Nuovo"},
	{"673","Balvano"},
	{"674","Bancole"},
	{"675","Baracchella"},
	{"676","Baracchino"},
	{"677","Baraccola"},
	{"678","Barano D'ischia"},
	{"679","Barba"},
	{"680","Barbano"},
	{"681","Barbarano"},
	{"682","Barbasso"},
	{"683",""},
	{"684","Barberino Val D'elsa"},
	{"685","Barca Dei Grazi/Innesto Ss323 Di Monte Amiata"},
	{"686","Barca Di Grazi/Innesto Ss74 Maremmana"},
	{"687","Barcellona"},
	{"688","Barcellona Pozzo Di Gotto"},
	{"689","Barchi Di Asola"},
	{"690","Barcis"},
	{"691","Bard"},
	{"692","Bardalone"},
	{"693","Bardi"},
	{"694","Bardolino"},
	{"695","Bardonecchia"},
	{"696","Barese"},
	{"697","Barete"},
	{"698","Bargagli"},
	{"699","Bargagli/Innesto Ss225 Della Fontanabuona"},
	{"700","Bargagli-Ferriere/Innesto Ss45 Di Valtrebbia"},
	{"701","Barghe"},
	{"702","Bargino"},
	{"703","Bargino (Direzione Firenze)"},
	{"704","Bargino (Direzione Siena)"},
	{"705","Bargonasco"},
	{"706","Bari"},
	{"707","Bari (tangenziale)"},
	{"708","Bari Nord - Allacciamento A14 Bo-Ta"},
	{"709","Bari Nord - Raccordo Per La Tangenziale"},
	{"710","Bari Sardo"},
	{"711","Bari Sardo/Innesto Ss125 Orientale Sarda"},
	{"712","Bari Sardo/Innesto Ss390 Di Bari Sardo"},
	{"713","Bari Sud"},
	{"714","Bari Zona Industriale/Allacciamento Tangenziale Bari"},
	{"715","Bariano"},
	{"716","Barigazzo"},
	{"717","Barile"},
	{"718","Barisciano"},
	{"719","Barletta"},
	{"720","Barletta/Innesto Asse Attr. Cerignola-Bari"},
	{"721","Barletta/Innesto Ss16 Adriatica"},
	{"722","Barletta/Innesto Ss170 Dir/A Di Castel Del Monte"},
	{"723","Barletta/Innesto Ss93 Appulo Lucana"},
	{"724","Baronissi"},
	{"725","Barrafranca"},
	{"726","Barrea"},
	{"727","Barriera Aurelia"},
	{"728","Barriera Autostradale Di Vipiteno"},
	{"729","Barriera Avigliana"},
	{"730","Barriera Buonfornello"},
	{"731","Barriera Di Agrate Brianza"},
	{"732",""},
	{"733","Barriera Di Bari Nord"},
	{"734","Barriera Di Belluno"},
	{"735","Barriera Di Bereguardo"},
	{"736","Barriera Di Bruere"},
	{"737","Barriera Di Catania"},
	{"738","Barriera Di Como Grandate"},
	{"739","Barriera Di Falchera"},
	{"740","Barriera Di Ferrara Sud"},
	{"741","Barriera Di Firenze Ovest"},
	{"742","Barriera Di Gallarate Nord"},
	{"743","Barriera Di Gallarate Ovest"},
	{"744","Barriera Di Genova Ovest"},
	{"745","Barriera Di La Spezia"},
	{"746",""},
	{"747","Barriera Di Livorno"},
	{"748",""},
	{"749","Barriera Di Messina Nord"},
	{"750","Barriera Di Messina Sud"},
	{"751","Barriera Di Milano"},
	{"752","Barriera Di Milano Est"},
	{"753","Barriera Di Milano Nord"},
	{"754","Barriera Di Milano Sud"},
	{"755","Barriera Di Napoli Est"},
	{"756","Barriera Di Napoli Nord"},
	{"757","Barriera Di Napoli Sud-Barra"},
	{"758","Barriera Di Nocera Inferiore"},
	{"759","Barriera Di Padova Sud"},
	{"760",""},
	{"761","Barriera Di Pisa Nord"},
	{"762","Barriera Di Portogruaro"},
	{"763",""},
	{"764","Barriera Di Roma Est"},
	{"765","Barriera Di Roma Nord"},
	{"766","Barriera Di Roma Ovest"},
	{"767","Barriera Di Roma Sud"},
	{"768","Barriera Di Rondissone"},
	{"769","Barriera Di Rosignano Marittimo"},
	{"770","Barriera Di Salbertrand"},
	{"771","Barriera Di Salerno M.S.Severino"},
	{"772","Barriera Di Sesto S.Giovanni"},
	{"773","Barriera Di Taranto Nord"},
	{"774","Barriera Di Teramo"},
	{"775","Barriera Di Terrazzano"},
	{"776","Barriera Di Torino"},
	{"777","Barriera Di Torino Nord"},
	{"778",""},
	{"779",""},
	{"780","Barriera Di Trofarello"},
	{"781","Barriera Di Ugovizza-Tarvisio"},
	{"782","Barriera Di Venezia"},
	{"783","Barriera Di Venezia Est"},
	{"784","Barriera Di Venezia-Mestre"},
	{"785","Barriera Di Ventimiglia"},
	{"786","Barriera Di Villanova D'asti"},
	{"787","Barriera Di Villesse"},
	{"788",""},
	{"789","Barriera Lago Maggiore"},
	{"790","Barriera Milano Ghisolfa"},
	{"791","Barriera Napoli Est"},
	{"792","Barriera Napoli Ovest"},
	{"793","Barriera Noce/Innesto Ss121 Catanese"},
	{"794","Barriera Noce/Innesto Ss122 Bis Agrigentina"},
	{"795","Barriera Piovene-Rocchette"},
	{"796","Barriera St. Rhemy"},
	{"797","Barriera-Dogana Italiana"},
	{"798","Barumini"},
	{"799","Barzesto"},
	{"800","Basagliapenta"},
	{"801","Baschi"},
	{"802","Baschi/Innesto Ss448 Di Baschi"},
	{"803","Basentana"},
	{"804","Basentello/Innesto Ss169 Diramazione Di Genzano"},
	{"805","Basentello/Innesto Ss96 Bis Barese"},
	{"806","Basiliano/Sclaunicco"},
	{"807","Basilicata"},
	{"808","Bassacutena"},
	{"809","Bassanello"},
	{"810","Bassano Bresciano"},
	{"811","Bassano Del Grappa"},
	{"812","Bassano Del Grappa/Incrocio Ss47 Della Valsugana"},
	{"813","Bassano Del Grappa/Innesto Ss141 Strada Cadorna"},
	{"814","Bassano Del Grappa/Innesto Ss248 Schiavonesca"},
	{"815","Bassano Del Grappa/Innesto Ss47 Della Valsugana"},
	{"816","Bassano In Teverina"},
	{"817","Bastardo"},
	{"818","Bastia"},
	{"819","Bastiola"},
	{"820","Battaglia Terme"},
	{"821","Battipaglia"},
	{"822","Battipaglia/Innesto Ss18 Tirrena Inferiore"},
	{"823","Battipaglia/Innesto Ss19 Delle Calabrie"},
	{"824","Bauducchi"},
	{"825","Bauladu"},
	{"826","Baunei"},
	{"827","Bavareto"},
	{"828","Bavaria"},
	{"829","Baveno"},
	{"830","Ba-Villa De Lilla"},
	{"831","Bazzano"},
	{"832","Bazzano - Innesto Ss17 Dell'appennino Abruzzese"},
	{"833","Bazzano/Innesto Ss17"},
	{"834","Bazzano/Innesto Ss17 Bis Dir/A"},
	{"835","Bazzano/Innesto Ss17 Dell'appennino Abruzzese"},
	{"836","Bazzano/Innesto Ss17 Ter Dell'app. Abbruzzese"},
	{"837","Bazzera"},
	{"838","Beaume/Innesto Ss335 Di Bardonecchia"},
	{"839","Beaume/Innesto Ss335 Diramazione Di Bardonecchia"},
	{"840","Bedale"},
	{"841","Bedonia"},
	{"842","Beffi"},
	{"843",""},
	{"844","Beinette"},
	{"845","Belforte Del Chienti"},
	{"846","Belgioioso"},
	{"847","Belgirate"},
	{"848","Bellagio"},
	{"849","Bellamonte"},
	{"850","Bellante"},
	{"851","Bellaria"},
	{"852","Bellavalle"},
	{"853","Bellino/Innesto Ss106 Ionica"},
	{"854","Bellino/Innesto Ss19 Bis Delle Calabrie"},
	{"855","Bellinzago Var."},
	{"856","Bellizzi"},
	{"857","Bellizzi Irpino"},
	{"858","Bellizzi/Innesto Ss164 Delle Croci Di Acerno"},
	{"859","Bellizzi/Innesto Ss18 Tirrena Inferiore"},
	{"860","Bellocchio"},
	{"861","Bellosguardo"},
	{"862","Belluno"},
	{"863","Belluno/Incrocio Ss203 Diramazione Agordina"},
	{"864","Belluno/Innesto Ss50 Del Grappa E Passo Rolle"},
	{"865","Belmonte Castello"},
	{"866","Belvedere"},
	{"867","Belvedere Marittimo/Svincolo Ss105 Di Castrovillari"},
	{"868","Belvi'"},
	{"869","Benestare"},
	{"870","Benevento"},
	{"871","Benevento - Raccordo Di Benevento"},
	{"872","Benevento Centro-Innesto Ss90 Bis Delle Puglie"},
	{"873","Benevento Nord-Innesto Ss212 E Ss88"},
	{"874","Benevento Ovest-Petrelcina"},
	{"875","Benevento Sud- Innesto Ss7 Appia"},
	{"876","Benevento/Allacciamento Raccordo Di Benevento E Innesto Ss212"},
	{"877","Benevento/Incrocio Ss7 Appia"},
	{"878","Benevento/Incrocio Ss88 Dei Due Principati"},
	{"879","Benevento/Innesto Raccordo Autos. Di Benevento"},
	{"880","Benevento/Innesto Raccordo Di Benevento"},
	{"881","Benevento/Innesto Ss7 Appia"},
	{"882","Benevento/Innesto Ss88/InnestoRaccordo Di Benevento"},
	{"883","Benevento/Innesto Ss90 Bis Delle Puglie"},
	{"884","Benevento-A16 Napoli-Canosa"},
	{"885","Benevento-Stazione"},
	{"886","Benne"},
	{"887","Berceto"},
	{"888","Berceto/Innesto Ss523 Del Colle Di Cento Croci"},
	{"889","Berceto/Innesto Ss62 Della Cisa"},
	{"890","Bereguardo"},
	{"891","Bereguardo - Allacciamento Raccordo Bereguardo-Pv"},
	{"892","Bergamina"},
	{"893","Bergamo"},
	{"894","Bergamo/Innesto Ss342 Briantea E Ss671 Val Seriana"},
	{"895","Bergamo/Innesto Ss42 E Ss671 Della Val Seriana"},
	{"896","Bergamo/Innesto Ss470 Valle Brembana E Ss671"},
	{"897","Bergamo/Innesto Ss591 Cremasca E Ss671 Val Seriana"},
	{"898","Bergamo/Innesto Ss671 Della Val Seriana"},
	{"899","Bergantino"},
	{"900","Berioli"},
	{"901","Berleta"},
	{"902","Bernalda"},
	{"903","Berruiles"},
	{"904","Bertigaro"},
	{"905","Besano"},
	{"906","Besate"},
	{"907","Besnate"},
	{"908","Besolo"},
	{"909","Besozzo"},
	{"910","Bettola"},
	{"911","Bettola Di Sarmato"},
	{"912","Bettole"},
	{"913","Bettole Di Novi Ligure"},
	{"914","Bettolelle"},
	{"915","Bettolino Di Pogliano"},
	{"916","Bettolle"},
	{"917","Bettolle-A1-Raccordo Bettolle-Pg-Ss327"},
	{"918","Bevagna"},
	{"919","Bevano"},
	{"920","Bevilacqua"},
	{"921","Bezzecca"},
	{"922","Biacesa Di Ledro"},
	{"923","Biadene"},
	{"924","Bianco"},
	{"925","Biandrate"},
	{"926","Bibbiena"},
	{"927","Bibbiena/Innesto Ss208 Strada Della Verna"},
	{"928","Bibbiena/Innesto Ss71 Umbro Casent. Romagnola"},
	{"929","Bicocca-Asse Servizi Per Porto-Aeroporto"},
	{"930","Biella"},
	{"931","Biella/Innesto Ss142 Biellese"},
	{"932","Biella/Innesto Ss143 Vercellese"},
	{"933","Biella/Innesto Ss230 Di Massazza"},
	{"934","Biella/Innesto Ss338 Di Mongrando"},
	{"935","Biellese"},
	{"936","Bienno"},
	{"937","Bientina"},
	{"938","Biforco"},
	{"939","Binasco"},
	{"940","Bis Adriatica"},
	{"941","Bis Agrigentina"},
	{"942","Bis Barese"},
	{"943","Bis Carnica"},
	{"944","Bis Centrale Sarda"},
	{"945","Bis Centrale Sicula"},
	{"946","Bis D'aspromonte"},
	{"947","Bis Dei Giovi"},
	{"948","Bis Del Colle Di Nava"},
	{"949","Bis Del Grappa E Del Passo Rolle"},
	{"950","Bis Del Monferrato"},
	{"951","Bis Del Terminillo"},
	{"952","Bis Del Trasimeno"},
	{"953","Bis Della Funivia Del G. Sasso E Di C.Imperatore"},
	{"954","Bis Della Piccola Sila"},
	{"955","Bis Della Pusteria"},
	{"956","Bis Delle Calabrie"},
	{"957","Bis Delle Dolomiti"},
	{"958","Bis Delle Puglie"},
	{"959","Bis Dell'emissario"},
	{"960","Bis Di Alemagna"},
	{"961","Bis Di Bocca Trabaria"},
	{"962","Bis Di Carlo Felice"},
	{"963","Bis Di Mestre"},
	{"964","Bis Di Palau"},
	{"965","Bis Di Terra Di Lavoro"},
	{"966","Bis Dir/A Della Funivia Del G. Sasso Diramazione"},
	{"967","Bis Gardesana Occidentale"},
	{"968","Bis Goitese"},
	{"969","Bis Irpina"},
	{"970","Bis Jonica"},
	{"971","Bis Orvietana"},
	{"972","Bis Passo Del Rombo"},
	{"973","Bis Settentrionale Sarda"},
	{"974","Bis Silana Crotonese"},
	{"975","Bis Silana Di Cariati"},
	{"976","Bis Tiberina"},
	{"977","Bis Tosco Romagnola"},
	{"978","Bis Trasversale Sarda"},
	{"979","Bis Umbro Casentinese Romagnola"},
	{"980","Bis Var Del Grappa E Del Passo Rolle"},
	{"981","Bis Vestina-Sarentina"},
	{"982","Bis Via Cassia Veientana"},
	{"983","Bis Via Ostiense"},
	{"984","Bis/Diramazione Del Vittoriale"},
	{"985","Bis/Diramazione Di Villa Literno"},
	{"986","Bis/Diramazione Vestina"},
	{"987","Bis/Dir/B Della Funivia G.Sasso E C.Imperatore"},
	{"988","Bis/Dir/C Della Funivia G.Sasso E C.Imperatore"},
	{"989","Bis/Racc Del Trasimeno"},
	{"990","Bis/Racc Tiberina"},
	{"991","Bisaccia"},
	{"992","Bisceglie"},
	{"993","Bisenti"},
	{"994","Bisenzio"},
	{"995","Bissoncello"},
	{"996","Bistocco"},
	{"997","Bisuschio"},
	{"998","Bitonto"},
	{"999","Bitritto"},
	{"1000","Bitti"},
	{"1001","Bivio Ad Acca/Innesto Ss14 Per Confine Di Pese"},
	{"1002","Bivio Cerisey-Innesto Ss27"},
	{"1003","Bivio Colli"},
	{"1004",""},
	{"1005","Bivio Pedica-Innesto Ss215 E Ss218 Di Rocca Di Papa"},
	{"1006","Bivio Per Fiume Veneto"},
	{"1007","Bivio Per Pisa"},
	{"1008","Bivona"},
	{"1009","Bizzozero"},
	{"1010","Blessaglia"},
	{"1011","Blevio"},
	{"1012","Blokhaus"},
	{"1013","Boara"},
	{"1014","Boara Pisani"},
	{"1015","Boara Polesine"},
	{"1016","Boario Terme"},
	{"1017","Boario Terme/Innesto Ss294 Val Di Sclave"},
	{"1018","Bobbio"},
	{"1019","Bobbio/Innesto Ss45 Di Val Di Trebbia"},
	{"1020","Bobbio/Innesto Ss461 Del Passo Del Penice"},
	{"1021","Bocca Del Ravari"},
	{"1022","Bocca Di Piazza/Innesto Ss108 Bis Silana Di Cariati"},
	{"1023","Bocca Di Piazza/Innesto Ss179 Del Lago Ampollino"},
	{"1024","Bocca Di Piazza/Innesto Ss535 Del Savuto"},
	{"1025","Bocca Di Valle"},
	{"1026","Bocca Di Valle/Innesto Ss263 Di Val Di Foro"},
	{"1027","Bocca Di Valle/Innesto Ss363 Di Guardiagrele"},
	{"1028","Bocchetta Sessera"},
	{"1029","Bocchigliero"},
	{"1030","Bocconi"},
	{"1031","Boffalora"},
	{"1032","Bogliasco"},
	{"1033","Boiano/Innesto Ss17 Dell'app. Abruz. E Appulo Sann."},
	{"1034","Bojano/Innesto Ss647 Fondo Valle Del Biferno"},
	{"1035","Bollano"},
	{"1036","Bollegno/Innesto Ss338 Di Mongrando"},
	{"1037","Bollengo/Innesto Ss228 Del Lago Di Viverone"},
	{"1038","Bologna"},
	{"1039","Bologna - Innesto Ss64 Porrettana"},
	{"1040","Bologna Arcoveggio-Allacciamento A13 Bo-Pd"},
	{"1041","Bologna Arcoveggio-Raccordo Per La Tangenziale"},
	{"1042","Bologna Borgo Panigale"},
	{"1043","Bologna Casalecchio"},
	{"1044","Bologna Interporto"},
	{"1045","Bologna S.Lazzaro"},
	{"1046","Bologna San Lazzaro"},
	{"1047","Bologna/Innesto Ss253 S. Vitale"},
	{"1048","Bologna/Innesto Ss65 Della Futa"},
	{"1049","Bologna/Innesto Ss9 Emilia"},
	{"1050","Bologna/Innesto Ss9 Via Emilia"},
	{"1051","Bologna-Bari-Taranto"},
	{"1052","Bologna-Padova"},
	{"1053","Bolsena"},
	{"1054","Boltiere"},
	{"1055","Bolzano"},
	{"1056","Bolzano Nord"},
	{"1057","Bolzano Sud-Allacciamento A22 Modena-Brennero"},
	{"1058","Bolzano Sud-Allacciamento Superstrada Merano-Bz"},
	{"1059","Bolzano(sud)"},
	{"1060","Bolzano/Innesto Diramazione Per Ss38 Dello Stelvio"},
	{"1061","Bolzano/Innesto Ss12 Dell'abetone E Brennero"},
	{"1062","Bolzano/Innesto Ss38 Dello Stelvio"},
	{"1063","Bolzano/Innesto Ss42 Del Tonale E Della Mendola"},
	{"1064","Bolzino"},
	{"1065","Bondeno"},
	{"1066","Bondo"},
	{"1067","Bonefro"},
	{"1068","Bonferraro"},
	{"1069","Bonnanaro/Innesto Ss128 Bis Centrale Sarda"},
	{"1070","Bono"},
	{"1071","Bonomini"},
	{"1072","Bonpietro"},
	{"1073","Borbona"},
	{"1074","Borbore/Vezza D'alba"},
	{"1075","Borca"},
	{"1076","Borca Di Cadore"},
	{"1077","Bordighera"},
	{"1078","Bore"},
	{"1079","Borello"},
	{"1080","Boretto"},
	{"1081","Borgaccio Di Calcinelli"},
	{"1082","Borgetto"},
	{"1083","Borghetto"},
	{"1084","Borghetto D'arroscia"},
	{"1085","Borghetto Di Tuoro"},
	{"1086","Borghetto Di Tuoro/Innesto Ss75 Bis/Raccordo"},
	{"1087","Borghetto Di Vara"},
	{"1088","Borghetto Di Vara/Innesto Ss1 Aurelia"},
	{"1089","Borghetto Di Vara/Innesto Ss566 Di Val Di Vara"},
	{"1090","Borghetto S.Spirito"},
	{"1091","Borghetto/Innesto A14 Diramazione Diramazione Per Ravenna"},
	{"1092","Borghetto/Innesto Ss2 Cassia"},
	{"1093","Borghetto/Innesto Ss489 Di Gradoli"},
	{"1094","Borghetto/Innesto Ss71 Umbro Casentinese"},
	{"1095","Borgia"},
	{"1096","Borgiano/Innesto Ss502 Di Cingoli"},
	{"1097","Borgiano/Innesto Ss77 Della Val Di Chienti"},
	{"1098","Borgio Verezzi"},
	{"1099","Borgo A Giovi"},
	{"1100","Borgo A Mozzano"},
	{"1101","Borgo Alla Collina"},
	{"1102","Borgo Bagni"},
	{"1103","Borgo Bicchia"},
	{"1104","Borgo Celano"},
	{"1105","Borgo Cerreto/Innesto Ss209 Valnerina"},
	{"1106","Borgo Cerreto/Innesto Ss319 Sellanese"},
	{"1107","Borgo Chitarra"},
	{"1108","Borgo D'ale"},
	{"1109","Borgo Faiti/Incrocio Ss156 Dei Monti Lepini"},
	{"1110","Borgo Fornari Pieve"},
	{"1111","Borgo L.Taverne/Innesto Ss425 Di S. A. Dei Lombardi"},
	{"1112","Borgo Lavezzaro"},
	{"1113","Borgo Macchia"},
	{"1114","Borgo Mezzanone"},
	{"1115","Borgo Montello"},
	{"1116","Borgo Pace"},
	{"1117","Borgo Paglia/Innesto S.G.C. Orte-Ravenna"},
	{"1118","Borgo Panigale/Innesto Ss568 Di Crevalcore"},
	{"1119","Borgo Panigale/Innesto Ss9 Emilia"},
	{"1120","Borgo Piave"},
	{"1121","Borgo Ponte/Innesto Ss28 Del Colle Di Nava"},
	{"1122","Borgo Ponte/Innesto Ss582 Del Colle Di S.Bernardo"},
	{"1123","Borgo Quinzio/Innesto Ss4 Salaria"},
	{"1124","Borgo Quinzio/Innesto Ss636 Di Palombara"},
	{"1125","Borgo Revel"},
	{"1126","Borgo Ripe Di S.Ginesio"},
	{"1127","Borgo S.Antonio"},
	{"1128","Borgo S.Dalmazzo/Innesto Ss20 Del Colle Di Tenda"},
	{"1129","Borgo S.Dalmazzo/Innesto Ss21 Della Maddalena"},
	{"1130","Borgo S.Lorenzo/Innesto Ss551 Traversa Del Mugello"},
	{"1131","Borgo S.Maria"},
	{"1132","Borgo S.Michele"},
	{"1133","Borgo Salsasio/Innesto Ss20 Del Colle Di Tenda"},
	{"1134","Borgo Salsasio-Innesto Ss20 Del Colle Di Tenda"},
	{"1135","Borgo Schisina"},
	{"1136","Borgo Terzo"},
	{"1137","Borgo Tufico/Innesto Ss256 Muccese/Ss76 Var"},
	{"1138","Borgo Tufico/Innesto Ss76 Della Val D'esino"},
	{"1139","Borgo Val Di Taro"},
	{"1140","Borgo Valsugana"},
	{"1141","Borgo Vercelli"},
	{"1142","Borgoforte"},
	{"1143","Borgofranco D'ivrea"},
	{"1144","Borgomanero"},
	{"1145","Borgomanero/Incrocio Ss142 Biellese"},
	{"1146","Borgomanero/Innesto Ss142 Biellese"},
	{"1147","Borgomanero/Innesto Ss32Diramazione Ticinese"},
	{"1148","Borgomanero/Innesto Ss229 Lago D'orta"},
	{"1149","Borgone"},
	{"1150","Borgone Susa/Innesto Ss24 Del Monginevro"},
	{"1151","Borgone Susa/Innesto Ss25 Del Moncenisio"},
	{"1152","Borgonovo"},
	{"1153","Borgonovo Di Pontecchio Marconi"},
	{"1154","Borgonovo Ligure"},
	{"1155","Borgonovo Val Tidone"},
	{"1156","Borgonuovo"},
	{"1157","Borgoratto Alessandrino"},
	{"1158","Borgorose"},
	{"1159","Borgostecchi"},
	{"1160","Borgotaro"},
	{"1161","Bormida"},
	{"1162","Bormio"},
	{"1163","Bormio/Innesto Ss300 Del Passo Di Gavia"},
	{"1164","Bormio/Innesto Ss301 Del Foscagno"},
	{"1165","Bormio/Innesto Ss38 Dello Stelvio"},
	{"1166","Borsana Sud"},
	{"1167","Borselli"},
	{"1168","Borsoi"},
	{"1169","Borzonasca"},
	{"1170","Bosa"},
	{"1171","Bosa Marina"},
	{"1172","Bosaro"},
	{"1173","Boschetto"},
	{"1174","Boschi"},
	{"1175","Bosco"},
	{"1176","Bosco Di Sona"},
	{"1177","Bosco/Innesto Ss277 Di Calle"},
	{"1178","Bosco/Innesto Ss298 Eugubina"},
	{"1179","Bosco/Innesto Ss3 Bis Tiberina"},
	{"1180","Bosco/Innesto Ss96 Barese"},
	{"1181","Bosconure"},
	{"1182","Boscoreale"},
	{"1183","Boscotrecase"},
	{"1184","Botricello"},
	{"1185","Bottagna"},
	{"1186","Bottega"},
	{"1187","Bottegone"},
	{"1188","Bottegotto"},
	{"1189","Bottidda"},
	{"1190","Bova Marina"},
	{"1191","Bovalino M./Innesto Ss112 Diramazione D'aspromonte"},
	{"1192","Bovalino Marina"},
	{"1193","Bovalino Marina/Incrocio Ss106 Jonica"},
	{"1194","Bovalino Marina/Innesto Ss106 Jonica"},
	{"1195","Bovalino Marina/Innesto Ss112 D'aspromonte"},
	{"1196","Bovalino Superiore"},
	{"1197","Bovengo"},
	{"1198","Bovino/Innesto Ss90 Delle Puglie"},
	{"1199","Bozzana"},
	{"1200","Bozzolo"},
	{"1201","Bra/Innesto Ss231 Di S.Vittoria"},
	{"1202","Bra/Innesto Ss661 Delle Langhe"},
	{"1203","Braccagni"},
	{"1204","Bracciano"},
	{"1205","Bracco/Innesto Sp35 Moneglia"},
	{"1206","Bradanica"},
	{"1207","Branca"},
	{"1208","Brancaleone Marina"},
	{"1209","Brandizzo"},
	{"1210","Braulins"},
	{"1211","Brecciarola"},
	{"1212","Brecciarola Di Chieti/Innesto Ss5 Racc"},
	{"1213","Breda Cisoni"},
	{"1214","Breguzzo"},
	{"1215","Brembo"},
	{"1216","Brennero"},
	{"1217","Brennero/Innesto Ss12 Dell'abetone E Del Brennero"},
	{"1218","Brennero/Innesto Ss12 Radd/Bis Del Brennero"},
	{"1219","Brennero/Innesto Ss12radd/Bis Del Brennero"},
	{"1220","Breno/Innesto Ss345 Delle Tre Valli"},
	{"1221","Breno/Innesto Ss42 Del Tonale E Della Mendola"},
	{"1222","Brenta"},
	{"1223","Brentelle Di Sopra/Innesto Ss11 Padana Superiore"},
	{"1224","Brentelle Di Sopra/Innesto Ss250 Terme Euganee"},
	{"1225","Brenzone"},
	{"1226","Brescello"},
	{"1227","Brescia"},
	{"1228","Brescia Centro"},
	{"1229",""},
	{"1230","Brescia Est"},
	{"1231","Brescia Ovest"},
	{"1232","Brescia/Innesto Ss11 E Ss45bis"},
	{"1233","Brescia/Innesto Ss11 Padana Superiore"},
	{"1234","Brescia/Innesto Ss11padana Superiore E Ss236 Goitese"},
	{"1235","Brescia/Innesto Ss237 Del Caffaro"},
	{"1236","Brescia/Innesto Ss45bis Gardesana Occ. E Ss236"},
	{"1237","Brescia/Innesto Ss45bis Gardesana Occ."},
	{"1238","Bressanone"},
	{"1239","Bressanone/Innesto Ss12 Dell'abetone E Del Brennero"},
	{"1240","Bressanone/Innesto Ss49 Della Pusteria"},
	{"1241","Brez"},
	{"1242","Briantea"},
	{"1243","Brianza"},
	{"1244","Bribano"},
	{"1245","Bribano/Innesto Ss50 Del Grappa E Del Passo Rolle"},
	{"1246","Bribano/Innesto Ss635 Del Passo Di S.Boldo"},
	{"1247","Bricco Favole"},
	{"1248","Brienno"},
	{"1249","Brienza S./Innesto Ss598 Di Fondo Valle D'agri"},
	{"1250","Brienza Sud/Innesto Ss598 Di Fondo Valle D'agri"},
	{"1251","Brienza Sud/Innesto Ss95 Di Brienza"},
	{"1252","Brienza/Innesto Ss276 Dell'alto Agri"},
	{"1253","Brienza/Innesto Ss95 Di Brienza"},
	{"1254","Brienza/Innesto Ss95 Variante Di Brienza"},
	{"1255","Brindisi"},
	{"1256","Brindisi/Innesto Ss379 Egnazia"},
	{"1257","Brindisi/Innesto Ss613 Brindisi-Lecce"},
	{"1258","Brindisi/Innesto Ss7 Via Appia"},
	{"1259","Brindisi-Lecce"},
	{"1260","Briosco"},
	{"1261","Brischis"},
	{"1262","Brisighella"},
	{"1263","Brisighellese-Ravennate"},
	{"1264","Brittoli"},
	{"1265","Brivio"},
	{"1266","Broccostella"},
	{"1267","Broglina"},
	{"1268","Brolo"},
	{"1269","Bronese"},
	{"1270","Broni"},
	{"1271","Broni/Innesto Ss10 Padana Inferiore"},
	{"1272","Broni/Innesto Ss617 Bronese"},
	{"1273","Broni-Stradella"},
	{"1274","Bronte"},
	{"1275","Brozolo"},
	{"1276","Brozzi"},
	{"1277","Brucianesi"},
	{"1278","Brughiera"},
	{"1279","Brugnato"},
	{"1280","Brugnato-Borghetto Vara"},
	{"1281","Brugnera Sud"},
	{"1282","Bruino"},
	{"1283","Brunico"},
	{"1284","Brunico/Innesto Ss49 Della Pusteria"},
	{"1285","Brunico/Innesto Ss621 Della Valle Aurina"},
	{"1286","Buccheri"},
	{"1287","Bucchi"},
	{"1288","Buccino"},
	{"1289","Buccino/Innesto Raccordo Sicignano-Pz E Ss19 Ter"},
	{"1290","Bucine"},
	{"1291","Budditogliu/Straulas"},
	{"1292","Budduso'"},
	{"1293","Budduso'/Innesto Ss389 Di Budduso' E Del Correboi"},
	{"1294","Budduso'/Innesto Ss389 Dir/A"},
	{"1295","Budoni"},
	{"1296","Budoni Nord/Innesto Ss125 Orientale Sarda"},
	{"1297","Budoni Nord/Innesto Ss131dir/Centr. Nuorese"},
	{"1298","Budoni Sud"},
	{"1299","Budrio"},
	{"1300","Bugnara"},
	{"1301","Bultei"},
	{"1302","Bulzi"},
	{"1303","Buonabitacolo"},
	{"1304","Buonabitacolo-Padula"},
	{"1305","Buonalbergo/Bivio Per Ss414 Di Montecalvo Irpino"},
	{"1306","Buonalbergo/Innesto Ss414 Di Montecalvo Irpino"},
	{"1307","Buonalbergo/Innesto Ss90 Bis Delle Puglie"},
	{"1308","Buonconvento/Innesto Ss2 Cassia"},
	{"1309","Buonconvento/Innesto Ss451 Di Monte Oliveto"},
	{"1310","Buonfornello"},
	{"1311","Buonopane"},
	{"1312","Burana"},
	{"1313","Burgio"},
	{"1314","Busa"},
	{"1315","Busa Di Vigonza"},
	{"1316","Busachi"},
	{"1317","Busalla"},
	{"1318","Busalla/Innesto Ss226 Di Valle Scrivia"},
	{"1319","Busalla/Innesto Ss35 Dei Giovi"},
	{"1320","Busca"},
	{"1321","Busche"},
	{"1322","Bussentina"},
	{"1323","Busseto"},
	{"1324","Bussi"},
	{"1325","Bussi Sul Tirino/Innesto Ss153 Della Valle Del Tirino"},
	{"1326","Bussi-Popoli"},
	{"1327","Bussoleno"},
	{"1328","Bustese"},
	{"1329","Busto Arsizio"},
	{"1330","Buttapietra"},
	{"1331","Bivio Per Montegiorgio"},
	{"1332","Bivio Per S.Chirico Nuovo"},
	{"1333","Bivio A.Fili-Innesto Ss281 Del Passo Di Limina"},
	{"1334","Bivio Armaiolo E Rapolano Terme"},
	{"1335","Bivio Arten/Innesto Ss50 Del Grappa E Del P. Rolle"},
	{"1336","Bivio Barile E Ginestra"},
	{"1337","Bivio Benesiti/Innesto Ss117 Bis Centrale Sicula"},
	{"1338","Bivio Bonacci/Innesto Ss19 Delle Calabrie"},
	{"1339","Bivio Brace/Innesto Ss18 Dir"},
	{"1340","Bivio Brace/Innesto Ss18 Racc Tirrena Inferiore"},
	{"1341","Bivio Brandano/Innesto Ss112 D'aspromonte"},
	{"1342","Bivio Brandano/Innesto Ss183 Aspromonte-Jonio"},
	{"1343","Bivio Brescia/Incrocio Ss235 Di Orzinuovi"},
	{"1344","Bivio Campello Clitunno"},
	{"1345","Bivio Candiolo-Parpaglia"},
	{"1346","Bivio Capestrano/Innesto Ss153 Della V. Del Tirino"},
	{"1347","Bivio Capoiale"},
	{"1348","Bivio Carcare/Innesto Ss28 Bis Del Colle Di Nava"},
	{"1349","Bivio Carmine/Innesto Ss198 Di Seui E Lanusei"},
	{"1350","Bivio Carmine/Innesto Ss22 Di Val Macra"},
	{"1351","Bivio Carmine/Innesto Ss28 Del Colle Di Nava"},
	{"1352","Bivio Carmine/Innesto Ss389 Budduso'e Correboi"},
	{"1353","Bivio Casalina"},
	{"1354","Bivio Castel Del Monte/Innesto Ss170 Dir/A"},
	{"1355","Bivio Castel Lagopesole"},
	{"1356","Bivio Castelnuovo B. S. E Pianella"},
	{"1357","Bivio Castelnuovo Berardenga"},
	{"1358","Bivio Castelnuovo Berardenga Scalo"},
	{"1359","Bivio Castions/Incrocio Ss353 Della Bassa Friulana"},
	{"1360","Bivio Centovernari/Innesto Ss188 Centro Occ. Sicula"},
	{"1361","Bivio Centovernari/Innesto Ss118 Corleonese Agrig."},
	{"1362",""},
	{"1363","Bivio Ceva/Innesto Ss28 Bis Del Colle Di Nava"},
	{"1364","Bivio Chiaravalle/Innesto Ss182 Delle Serre Calabre"},
	{"1365","Bivio Collazzone"},
	{"1366","Bivio Consandolo/Innesto S.G.C. Fossanova-Sandolo B."},
	{"1367","Bivio Coseat/Innesto Ss463 Del Tagliamento"},
	{"1368","Bivio Cozzo Cipolla"},
	{"1369","Bivio Del Pantano/Innesto Ss653 Valle Del Sinni"},
	{"1370","Bivio Deruta"},
	{"1371","Bivio Di Carunchio"},
	{"1372","Bivio Di Castel Del Monte/Innesto Ss170 Dir/A"},
	{"1373","Bivio Di Fabiano/Innesto Ss370"},
	{"1374","Bivio Di Fabiano/Innesto Ss530 Di Portovenere"},
	{"1375","Bivio Di Pantano/Innesto Ss92 Dell'app. Merid.Le"},
	{"1376","Bivio Di Pavone"},
	{"1377","Bivio Di Reino/Innesto Ss212 Della Val Fortore"},
	{"1378","Bivio Di Reino/Innesto Ss369 Appula Fortorina"},
	{"1379","Bivio Di Sesto Calende/Innesto Ss33 Del Sempione"},
	{"1380","Bivio Di Tricarico/Innesto Ss7 Appia"},
	{"1381","Bivio Di Tricarico/Innesto Ss96 Barese"},
	{"1382","Bivio Donnici/Innesto Ss178 Del Lago Arvo"},
	{"1383","Bivio Donnici/Innesto Ss19 Delle Calabrie"},
	{"1384","Bivio Dragonetti"},
	{"1385","Bivio Ercole"},
	{"1386","Bivio Fasani/Innesto Ss430 Valle Del Garigliano"},
	{"1387","Bivio Filaga/Innesto Ss118 Corleonese Agrigentina"},
	{"1388","Bivio Foligno/Innesto Ss77 Della Val Di Chienti"},
	{"1389","Bivio Fossano/Incrocio Ss231 Di S.Vittoria"},
	{"1390","Bivio Frattocchie/Innesto Ss140 Del Lago Di Albano"},
	{"1391","Bivio Gallopane/Innesto Ss177 Silana Di Rossano"},
	{"1392","Bivio Gallopane/Innesto Ss660 Di Acri"},
	{"1393","Bivio Geraci/Innesto Ss120 Dell'etna E Delle Madonie"},
	{"1394","Bivio Geraci/Innesto Ss286 Di Castelbuono"},
	{"1395","Bivio Gigliotto/Innesto Ss117 Bis Centrale Sicula"},
	{"1396","Bivio Guardavalle"},
	{"1397","Bivio Iazzotto/Innesto Ss194 Ragusana"},
	{"1398","Bivio Iazzotto/Innesto Ss385 Di Palagonia"},
	{"1399","Bivio La Cavola/Innesto Ss89 Dir/B Garganica"},
	{"1400","Bivio La Cavola/Innesto Ss89 Garganica"},
	{"1401","Bivio Luogo/Innesto Ss191 Di Pietraperzia"},
	{"1402","Bivio Lupo"},
	{"1403","Bivio Madonna Laudata"},
	{"1404","Bivio Madonnino/Innesto Ss441 Massetana"},
	{"1405","Bivio Madonnino/Innesto Ss73 Senese Aretina"},
	{"1406","Bivio Magione/Innesto Ss75 Bis Del Trasimeno"},
	{"1407","Bivio Manganaro/Innesto Ss121 Catanese"},
	{"1408","Bivio Manganaro/Innesto Ss189 Della V. Del Platani"},
	{"1409","Bivio Marcianise/Innesto Ss265 Dei Ponti Della Valle"},
	{"1410","Bivio Marsciano"},
	{"1411","Bivio Melfi/Innesto Ss401"},
	{"1412","Bivio Metaponto/Innesto Ss175 Della V. Del Bradano"},
	{"1413","Bivio Mintina/Innesto Ss190 Delle Solfare"},
	{"1414","Bivio Mintina/Innesto Ss557 Di Campobello Di Licata"},
	{"1415","Bivio Mongiana/Innesto Ss110 Di M.Cucco-M.Pecoraro"},
	{"1416","Bivio Monti/Innesto Ss389 Di Budduso' E Del Correboi"},
	{"1417","Bivio None"},
	{"1418","Bivio Notaresco/Innesto Ss150 Valle Del Vomano"},
	{"1419","Bivio Pantalla"},
	{"1420","Bivio Passo Mirabella/Innesto Ss303 Del Formicoso"},
	{"1421","Bivio Passovecchio/Innesto Ss106 E Ss107"},
	{"1422","Bivio Passovecchio/Innesto Ss107 E Ss107 Bis"},
	{"1423","Bivio Pedica/Innesto Ss215 E Ss218 Di Rocca Di Papa"},
	{"1424","Bivio Pedica/Innesto Ss511 Anagnina E Ss215 Tuscol."},
	{"1425","Bivio Per A16 E Per Raccordo Di Benevento"},
	{"1426","Bivio Per Abano Terme"},
	{"1427","Bivio Per Abbadia S.Salvatore"},
	{"1428","Bivio Per Abbasanta - Innesto Ss131 Di C. Felice"},
	{"1429","Bivio Per Abbasanta/Innesto Ss131 Di C. Felice"},
	{"1430","Bivio Per Abbasanta/Innesto Ss131 Dir/C. Nuorese"},
	{"1431","Bivio Per Accadia"},
	{"1432","Bivio Per Acerenza"},
	{"1433","Bivio Per Acqua Dei Ranci"},
	{"1434","Bivio Per Acqualoreto"},
	{"1435","Bivio Per Acquarella"},
	{"1436","Bivio Per Acquarica Del Capo"},
	{"1437","Bivio Per Acquaviva Di Isernia/Innesto Ss86 E Ss17"},
	{"1438","Bivio Per Acquaviva D'isernia/Innesto Ss17 E Ss17 Racc"},
	{"1439","Bivio Per Acquaviva/Innesto Ss17racc/Innesto Ss86"},
	{"1440","Bivio Per Acri Bisignano/Innesto Ss559 Di Luzzi"},
	{"1441","Bivio Per Acri/Innesto Ss19 Delle Calabrie"},
	{"1442","Bivio Per Adelfia E Bivio Per Rutigliano"},
	{"1443","Bivio Per Adrano"},
	{"1444","Bivio Per Aeritalia Aeroporto"},
	{"1445","Bivio Per Aeroporto Di Bologna"},
	{"1446","Bivio Per Aeroporto Malpensa"},
	{"1447","Bivio Per Aeroporto Marco Polo"},
	{"1448","Bivio Per Afragola"},
	{"1449","Bivio Per Aggius"},
	{"1450","Bivio Per Agriano"},
	{"1451","Bivio Per Aidomaggiore"},
	{"1452","Bivio Per Albano Di Lucania"},
	{"1453","Bivio Per Alberoro"},
	{"1454","Bivio Per Alesso"},
	{"1455","Bivio Per Aleta"},
	{"1456","Bivio Per Alia"},
	{"1457","Bivio Per Alianello"},
	{"1458","Bivio Per Alpicella"},
	{"1459","Bivio Per Altamura/Innesto Ss171 Di Santeramo"},
	{"1460","Bivio Per Altamura/Innesto Ss96 Barese"},
	{"1461","Bivio Per Altamura/Innesto Ss99 Di Matera"},
	{"1462","Bivio Per Altamura/Innesto Ss96 Barese"},
	{"1463","Bivio Per Altofonte"},
	{"1464","Bivio Per Alviano"},
	{"1465","Bivio Per Andria"},
	{"1466","Bivio Per Andria/Innesto Ss98 Andriese Coratina"},
	{"1467","Bivio Per Andria/Innesto Ss170dir/A Di C. Del Monte"},
	{"1468","Bivio Per Anghiari"},
	{"1469","Bivio Per Angri/Innesto Ss18 Tirrena Inferiore"},
	{"1470","Bivio Per Angri/Innesto Ss367 Nolana-Sarnese"},
	{"1471","Bivio Per Ansedonia"},
	{"1472","Bivio Per Anzano Di Puglia"},
	{"1473","Bivio Per Anzi"},
	{"1474","Bivio Per Apiro E Mergo E Ss76 Var"},
	{"1475","Bivio Per Aquilonia"},
	{"1476","Bivio Per Arcinazzo Romano"},
	{"1477","Bivio Per Arcola"},
	{"1478","Bivio Per Ardara"},
	{"1479","Bivio Per Ardenno/Innesto Ss38 Dello Stelvio"},
	{"1480","Bivio Per Arezzo"},
	{"1481","Bivio Per Ariano Irpino"},
	{"1482","Bivio Per Arielli-Poggiofiorito"},
	{"1483","Bivio Per Armento"},
	{"1484","Bivio Per Armungia"},
	{"1485","Bivio Per Arrone"},
	{"1486","Bivio Per Arsoli/Innesto Ss5 Tiburtina Valeria"},
	{"1487","Bivio Per Artogne"},
	{"1488","Bivio Per Ascea Marina"},
	{"1489","Bivio Per Ascoli Satriano"},
	{"1490","Bivio Per Aso"},
	{"1491","Bivio Per Assolo"},
	{"1492","Bivio Per Assoro"},
	{"1493","Bivio Per Asuai"},
	{"1494","Bivio Per Atella/Innesto Ss93 Appulo Lucana"},
	{"1495","Bivio Per Atella/Innesto Ss381 Del P. Delle Crocelle"},
	{"1496","Bivio Per Atripalda Nord"},
	{"1497","Bivio Per Augusta"},
	{"1498","Bivio Per Auletta"},
	{"1499","Bivio Per Avigliano"},
	{"1500","Bivio Per Avola"},
	{"1501","Bivio Per Azeglio"},
	{"1502","Bivio Per B.Go Le Taverne/Innesto Ss303 Del Formicoso"},
	{"1503","Bivio Per Bacu Abis"},
	{"1504","Bivio Per Badia A Coltibuono/Innesto Ss429 Val D'elsa"},
	{"1505","Bivio Per Bagnaia"},
	{"1506","Bivio Per Bagnaia E Vitorchiano"},
	{"1507","Bivio Per Bagni Di Petriolo"},
	{"1508","Bivio Per Bagnoli Del Trigno Est"},
	{"1509","Bivio Per Bagnoli Del Trigno Ovest"},
	{"1510","Bivio Per Bagnoli Irpino"},
	{"1511","Bivio Per Bagnolo Cremasco"},
	{"1512","Bivio Per Baia E Latina"},
	{"1513","Bivio Per Bancali/Innesto Sp18 Sassari-Argentiera"},
	{"1514","Bivio Per Baranello"},
	{"1515","Bivio Per Barga"},
	{"1516","Bivio Per Bari/Innesto Ss16 Adriatica"},
	{"1517","Bivio Per Bari/Innesto Ss16 Adriatica E Tangenziale Di Ba"},
	{"1518","Bivio Per Bari/Svincolo Per Raccordo Con Tangenziale Bari"},
	{"1519","Bivio Per Bari/Svincolo Ss271 Di Cassano"},
	{"1520","Bivio Per Bari/Svincolo Ss96 Barese"},
	{"1521","Bivio Per Barletta/Innesto Asse Attr. Cerignola-Bari"},
	{"1522","Bivio Per Barrali"},
	{"1523","Bivio Per Barriera Trieste Lisert A4 To-Ts"},
	{"1524","Bivio Per Bartolomeo/Innesto Ss124 Siracusana"},
	{"1525","Bivio Per Baschi/Innesto Ss205 Amerina"},
	{"1526","Bivio Per Basciano"},
	{"1527","Bivio Per Baselga"},
	{"1528","Bivio Per Batignano"},
	{"1529","Bivio Per Beaulard"},
	{"1530","Bivio Per Bellante"},
	{"1531","Bivio Per Benesiti/Innesto Ss122 Agrigentina"},
	{"1532","Bivio Per Benetutti"},
	{"1533","Bivio Per Berchidda"},
	{"1534","Bivio Per Bergeggi"},
	{"1535","Bivio Per Biancavilla"},
	{"1536","Bivio Per Bibbiena/Innesto Ss70 Della Consuma"},
	{"1537","Bivio Per Bibbiena/Innesto Ss71 Umbro Cas. Romagn."},
	{"1538","Bivio Per Bibbona"},
	{"1539","Bivio Per Biella/Innesto Ss143 Vercellese"},
	{"1540","Bivio Per Bio'"},
	{"1541","Bivio Per Birori"},
	{"1542","Bivio Per Bisaccia/Innesto Ss303 Del Formicoso"},
	{"1543","Bivio Per Bisaccia/Innesto Ss399 Di Calitri"},
	{"1544","Bivio Per Bisacquino"},
	{"1545","Bivio Per Biselli"},
	{"1546","Bivio Per Bisignano Est"},
	{"1547","Bivio Per Bisignano Sud"},
	{"1548","Bivio Per Bitonto"},
	{"1549","Bivio Per Boario Terme/Innesto Ss42"},
	{"1550","Bivio Per Boccheggiano"},
	{"1551","Bivio Per Bolognetta/Innesto Ss118"},
	{"1552","Bivio Per Bolognetta/Innesto Ss121 Catanese"},
	{"1553","Bivio Per Bomba"},
	{"1554","Bivio Per Bonnanaro/Innesto Ss131 Di Carlo Felice"},
	{"1555","Bivio Per Bonorva"},
	{"1556","Bivio Per Borgo Braemi"},
	{"1557","Bivio Per Borgo Castelletto"},
	{"1558","Bivio Per Bortigali"},
	{"1559","Bivio Per Bortigiadas"},
	{"1560","Bivio Per Bosconero"},
	{"1561","Bivio Per Boville Ernica"},
	{"1562","Bivio Per Bovino/Innesto Ss161 Di Ortanova"},
	{"1563","Bivio Per Braies"},
	{"1564","Bivio Per Branca/Innesto Ss318 Di Valfabbrica"},
	{"1565","Bivio Per Branca/Innesto Ss219 Gubbio E Pian D'assino"},
	{"1566","Bivio Per Brecciarola/Innesto Ss5 Tib. Valeria"},
	{"1567","Bivio Per Brembate Di Sopra"},
	{"1568","Bivio Per Breno"},
	{"1569","Bivio Per Brescello"},
	{"1570","Bivio Per Brescia/Incrocio Ss11 Padana Superiore"},
	{"1571","Bivio Per Brestovizza/Confine Con La Slovenia"},
	{"1572","Bivio Per Brienza/Innesto Ss276 Dell'alto Agri"},
	{"1573","Bivio Per Brindisi Montagna"},
	{"1574","Bivio Per Brindisi/Innesto Ss16 Adriatica"},
	{"1575","Bivio Per Brindisi-Innesto Ss16 Adriatica"},
	{"1576","Bivio Per Brolio"},
	{"1577","Bivio Per Bucchianico/Innesto Ss81 Piceno Aprutina"},
	{"1578","Bivio Per Bucchianico/Innesto Ss649 Fondo V. Alento"},
	{"1579","Bivio Per Burcei"},
	{"1580","Bivio Per Buseto Palizzolo"},
	{"1581","Bivio Per Bussi Sul Tirino"},
	{"1582","Bivio Per Busso"},
	{"1583","Bivio Per Bussolengo"},
	{"1584","Bivio Per Butera"},
	{"1585","Bivio Per C.Colombo"},
	{"1586","Bivio Per Ca' Di Ferro E Ca' Degli Oppi"},
	{"1587","Bivio Per Cabras"},
	{"1588","Bivio Per Cadelmonte"},
	{"1589","Bivio Per Cafarda/Innesto Ss109 E 109 Racc"},
	{"1590","Bivio Per Cafarda/Innesto Ss109 E Ss109 Bis"},
	{"1591","Bivio Per Cafarda/Innesto Ss109bis E 109racc"},
	{"1592","Bivio Per Cala Liberotto"},
	{"1593","Bivio Per Calatifimi"},
	{"1594","Bivio Per Calciano"},
	{"1595","Bivio Per Caldonazzo"},
	{"1596","Bivio Per Caleppio/Innesto Sp39 Bis"},
	{"1597","Bivio Per Caloveto"},
	{"1598","Bivio Per Caltabellotta"},
	{"1599","Bivio Per Caltagirone/Incrocio Ss124 Siracusana"},
	{"1600","Bivio Per Caltagirone/Innesto Ss417 Di Caltagirone"},
	{"1601","Bivio Per Calvello Monte"},
	{"1602","Bivio Per Camaiore"},
	{"1603","Bivio Per Camino"},
	{"1604","Bivio Per Cammarata"},
	{"1605","Bivio Per Campana/Innesto Ss108ter Silana Di Cariati"},
	{"1606","Bivio Per Campana/Innesto Ss282 Delle Fossiate"},
	{"1607","Bivio Per Campobasso"},
	{"1608","Bivio Per Campobasso/Innesto Ss375 Gildonese"},
	{"1609","Bivio Per Campobasso/Innesto Ss645"},
	{"1610","Bivio Per Campobello Di Licata"},
	{"1611","Bivio Per Campobello Di Mazara"},
	{"1612","Bivio Per Campodipietra"},
	{"1613","Bivio Per Campofilone"},
	{"1614","Bivio Per Campofranco"},
	{"1615","Bivio Per Campoleone"},
	{"1616","Bivio Per Campoli Appennino"},
	{"1617","Bivio Per Campomaggiore"},
	{"1618","Bivio Per Camporeale E Per Capparrini"},
	{"1619","Bivio Per Campospinoso"},
	{"1620","Bivio Per Campovalano/Innesto Ss262 Di Campli"},
	{"1621","Bivio Per Campovalano/Innesto Ss81 Picena Aprutina"},
	{"1622","Bivio Per Canaro"},
	{"1623","Bivio Per Canazei/Innesto Ss48 Delle Dolomiti"},
	{"1624","Bivio Per Cancelli/Incrocio Ss76"},
	{"1625","Bivio Per Cancello-Villa Literno"},
	{"1626","Bivio Per Canda E Ramo Di Palo"},
	{"1627","Bivio Per Candide E Casamazzagno"},
	{"1628","Bivio Per Canicattini"},
	{"1629","Bivio Per Canistro"},
	{"1630","Bivio Per Cantalupo In Sabina"},
	{"1631","Bivio Per Capo D'argine"},
	{"1632","Bivio Per Caporciano"},
	{"1633","Bivio Per Capoterra"},
	{"1634","Bivio Per Cappella Maggiore"},
	{"1635","Bivio Per Capriana"},
	{"1636","Bivio Per Capriglia"},
	{"1637","Bivio Per Capurso"},
	{"1638","Bivio Per Carate Brianza"},
	{"1639","Bivio Per Carbonara Di Bari"},
	{"1640","Bivio Per Carbonia"},
	{"1641","Bivio Per Carchitti"},
	{"1642","Bivio Per Cargeghe"},
	{"1643","Bivio Per Carovilli/Innesto Ss651 Di Pescolanciano"},
	{"1644","Bivio Per Carovilli/Innesto Ss86 Istonia"},
	{"1645","Bivio Per Carpena"},
	{"1646","Bivio Per Carpenedo"},
	{"1647","Bivio Per Carrara"},
	{"1648","Bivio Per Casa Santa"},
	{"1649","Bivio Per Casacalenda/Innesto Ss376 Dei Tre Titoli"},
	{"1650","Bivio Per Casacalenda/Innesto Ss87 Sannitica"},
	{"1651","Bivio Per Casal Borsetti"},
	{"1652","Bivio Per Casale Corte Cerro"},
	{"1653","Bivio Per Casaleone"},
	{"1654","Bivio Per Casali"},
	{"1655","Bivio Per Casaluce/Allacciamento S.G.C. Nola-Domitio"},
	{"1656","Bivio Per Casaluce/Innesto Ss265 Dei Ponti Della Valle"},
	{"1657","Bivio Per Casaluce/Innesto Ss7bis/Diramazione Di Villa Literno"},
	{"1658","Bivio Per Casamassima/Innesto Ss172 Dei Trulli"},
	{"1659","Bivio Per Casavetere"},
	{"1660","Bivio Per Cascia/Innesto Ss320 Di Cascia"},
	{"1661","Bivio Per Cascia/Innesto Ss320 Diramazione Di Cascia"},
	{"1662","Bivio Per Cascina/Innesto S.G.C. Fi-Pi-Li"},
	{"1663","Bivio Per Cascine E La Croce"},
	{"1664","Bivio Per Case Nuove Russe"},
	{"1665","Bivio Per Case Rizza"},
	{"1666","Bivio Per Casello Altedo A13 Bologna-Padova"},
	{"1667","Bivio Per Casello Bolzano Sud A22 Brennero-Modena"},
	{"1668","Bivio Per Casello Sicignano A3 Salerno-Reggio C."},
	{"1669","Bivio Per Casoli/Innesto Ss81 Picena Aprutina"},
	{"1670","Bivio Per Casoli/Innesto Ss84 Frentana"},
	{"1671","Bivio Per Casotto Dei Pescatori"},
	{"1672","Bivio Per Cassana"},
	{"1673","Bivio Per Cassaro"},
	{"1674","Bivio Per Castagnaro E Mena'"},
	{"1675","Bivio Per Castagnito"},
	{"1676","Bivio Per Castel Boglione"},
	{"1677","Bivio Per Castel Castagna"},
	{"1678","Bivio Per Castel Del Monte/Innesto Ss170 Dir/B"},
	{"1679","Bivio Per Castel Di Gresti"},
	{"1680","Bivio Per Castel Di Sangro"},
	{"1681","Bivio Per Castel Rocchero"},
	{"1682","Bivio Per Castel Venzago"},
	{"1683","Bivio Per Castelbelforte"},
	{"1684","Bivio Per Castelbellino"},
	{"1685","Bivio Per Casteldelmonte"},
	{"1686","Bivio Per Casteldimezzo"},
	{"1687","Bivio Per Castelfranci/Innesto Ss164 Delle C. Di Acerno"},
	{"1688","Bivio Per Castelgomberto"},
	{"1689","Bivio Per Castelgrande Ovest"},
	{"1690","Bivio Per Castellabate"},
	{"1691","Bivio Per Castellace"},
	{"1692","Bivio Per Castellaneta Marina"},
	{"1693","Bivio Per Castellino"},
	{"1694","Bivio Per Castello Di Cisterna"},
	{"1695","Bivio Per Castelnovo Ne' Monti"},
	{"1696","Bivio Per Castelnuovo Berardenga"},
	{"1697","Bivio Per Castelnuovo Calcea"},
	{"1698","Bivio Per Castelnuovo Rangone"},
	{"1699","Bivio Per Castelplanio E Cupramontana"},
	{"1700","Bivio Per Castions/Incrocio Ss252 Di Palmanova"},
	{"1701","Bivio Per Castrignano Del Capo"},
	{"1702","Bivio Per Castro Dei Volsci"},
	{"1703","Bivio Per Castronuovo Di Sicilia"},
	{"1704","Bivio Per Cattolica Eraclea"},
	{"1705","Bivio Per Cavaion Veronese"},
	{"1706","Bivio Per Cavallino"},
	{"1707","Bivio Per Cave Di Pietra"},
	{"1708","Bivio Per Cecina/Innesto Ss1 Var. Aurelia"},
	{"1709","Bivio Per Celenza Trigno"},
	{"1710","Bivio Per Cellamare"},
	{"1711","Bivio Per Cellino Attanasio"},
	{"1712","Bivio Per Cellole/Innesto Ss430 Valle Del Garigliano"},
	{"1713","Bivio Per Cellole/Innesto Ss7 Via Appia"},
	{"1714","Bivio Per Centa S.Nicolo'"},
	{"1715","Bivio Per Centuripe"},
	{"1716","Bivio Per Cerchiara/Innesto Ss105 Di Castrovillari"},
	{"1717","Bivio Per Cerchiara/Innesto Ss92 Dell'app. Merid.Le"},
	{"1718","Bivio Per Cerenzia"},
	{"1719","Bivio Per Cereseto/Innesto Ss455 Di Pontestura"},
	{"1720","Bivio Per Cereseto/Innesto Ss457 Di Moncalvo"},
	{"1721","Bivio Per Cerreto Castello"},
	{"1722","Bivio Per Cesaro'/Innesto Ss120"},
	{"1723","Bivio Per Cesaro'/Innesto Ss289 Di Cesaro'"},
	{"1724","Bivio Per Ceto"},
	{"1725","Bivio Per Chia/Innesto Raccordo Orte Viterbo"},
	{"1726","Bivio Per Chiaramonte"},
	{"1727","Bivio Per Chiaramonti/Incrocio Ss672 Ss-Tempio"},
	{"1728","Bivio Per Chiaramonti/Innesto Ss132 Di Ozieri"},
	{"1729","Bivio Per Chiaromonte"},
	{"1730","Bivio Per Chilivani"},
	{"1731","Bivio Per Chiusa"},
	{"1732","Bivio Per Chiusi Della Verna"},
	{"1733","Bivio Per Chivasso/Innesto Ss458 Di Casalborgone"},
	{"1734","Bivio Per Chivasso/Innesto Ss590 Della Val Cerrina"},
	{"1735","Bivio Per Ciampino/Innesto Ss217 Via Dei Laghi"},
	{"1736","Bivio Per Ciampino/Innesto Ss7 Appia"},
	{"1737","Bivio Per Ciampino/Innesto Ss7 Dir/A Via Appia"},
	{"1738","Bivio Per Ciro'"},
	{"1739","Bivio Per Citta' Di Castello"},
	{"1740","Bivio Per Civate"},
	{"1741","Bivio Per Civitella"},
	{"1742","Bivio Per Civitella Marittima"},
	{"1743","Bivio Per Cocconato"},
	{"1744","Bivio Per Codevigo"},
	{"1745","Bivio Per Codroipo/Innesto Ss13 Pontebbana"},
	{"1746","Bivio Per Codroipo/Innesto Ss252 Di Palmanova"},
	{"1747","Bivio Per Col Maior"},
	{"1748","Bivio Per Colle"},
	{"1749","Bivio Per Collevecchio"},
	{"1750","Bivio Per Colli Di Monte Bove"},
	{"1751","Bivio Per Colombaro/Innesto Ss458 Di Casalborgone"},
	{"1752","Bivio Per Colombaro/Innesto Ss590 Della Val Cerrina"},
	{"1753","Bivio Per Comacchio"},
	{"1754","Bivio Per Conche"},
	{"1755","Bivio Per Configni"},
	{"1756","Bivio Per Conza Di Campania"},
	{"1757","Bivio Per Copertino"},
	{"1758","Bivio Per Corato/Innesto Ss378 Di Altamura"},
	{"1759","Bivio Per Corato/Innesto Ss98 Andriese Coratina"},
	{"1760","Bivio Per Corigliano/Innesto Ss16 Adriatica"},
	{"1761","Bivio Per Corleone"},
	{"1762","Bivio Per Cortenedolo"},
	{"1763","Bivio Per Coseat/Innesto Ss13 Pontebbana"},
	{"1764","Bivio Per Cosenza"},
	{"1765","Bivio Per Cossoine/Innesto Ss131 Di Carlo Felice"},
	{"1766","Bivio Per Cossoine/Innesto Ss292 Diramazione Nord Occ. Sarda"},
	{"1767","Bivio Per Costa Volpino"},
	{"1768","Bivio Per Cotronei"},
	{"1769","Bivio Per Cozzano"},
	{"1770","Bivio Per Crevola"},
	{"1771","Bivio Per Crosia"},
	{"1772","Bivio Per Crotone/Innesto Ss106 Jonica"},
	{"1773","Bivio Per Crotone/Innesto Ss106 Raccordo Jonica"},
	{"1774","Bivio Per Cureggio"},
	{"1775","Bivio Per Decollatura"},
	{"1776","Bivio Per Decorata"},
	{"1777","Bivio Per Delia"},
	{"1778","Bivio Per Diamante"},
	{"1779","Bivio Per Donada"},
	{"1780","Bivio Per Donori"},
	{"1781","Bivio Per Doria"},
	{"1782","Bivio Per Dragoni"},
	{"1783","Bivio Per Eboli/Innesto Ss19 Delle Calabrie"},
	{"1784","Bivio Per Eboli/Innesto Ss91 Della Valle Del Sele"},
	{"1785","Bivio Per Egna"},
	{"1786","Bivio Per Enna"},
	{"1787","Bivio Per Enna/Innesto Ss192 Della Valle Del Dittaino"},
	{"1788","Bivio Per Epitaffio"},
	{"1789","Bivio Per Erchie"},
	{"1790","Bivio Per Esperia"},
	{"1791","Bivio Per Fabriano Est/Innesto Ss76"},
	{"1792","Bivio Per Fabriano Ovest"},
	{"1793","Bivio Per Fabriano Sud"},
	{"1794","Bivio Per Fagare' Della Battaglia"},
	{"1795","Bivio Per Faggetto Lario"},
	{"1796","Bivio Per Faller"},
	{"1797","Bivio Per Fara Filiorum Petri"},
	{"1798","Bivio Per Fara In Sabina"},
	{"1799","Bivio Per Farfengo/Breda/Grumello Cremonese"},
	{"1800","Bivio Per Fasani/Innesto Ss7 Via Appia"},
	{"1801","Bivio Per Fasano - Innesto Ss16 Adriatica"},
	{"1802","Bivio Per Fasano/Innesto Ss16 Adriatica"},
	{"1803","Bivio Per Fattoria Sterpeto"},
	{"1804","Bivio Per Favara Nord"},
	{"1805","Bivio Per Favara Sud"},
	{"1806","Bivio Per Favella Di Corigliano/Innesto Ss106 Bis"},
	{"1807","Bivio Per Favella/Innesto Ss106 Jonica"},
	{"1808","Bivio Per Fercole"},
	{"1809","Bivio Per Fertilia/Innesto Ss127 Bis Sett.Le Sarda"},
	{"1810","Bivio Per Fertilia/Innesto Ss291 Della Nurra"},
	{"1811","Bivio Per Fiamignano"},
	{"1812","Bivio Per Filaga/Innesto Ss188 Centro Occ. Le Sicula"},
	{"1813","Bivio Per Filetto"},
	{"1814","Bivio Per Firmo/Innesto Ss105 Di Castrovillari"},
	{"1815","Bivio Per Firmo/Innesto Ss105 Diramazione Di Castrovillari"},
	{"1816","Bivio Per Fiume Veneto/Innesto Raccordo Per Cimpello"},
	{"1817","Bivio Per Fiume Veneto-Ss13 Pontebbana"},
	{"1818","Bivio Per Fiumicino"},
	{"1819","Bivio Per Florinas"},
	{"1820","Bivio Per Foggia - Innesto Ss16 Adriatica"},
	{"1821","Bivio Per Foggia/Incrocio Ss90 Delle Puglie"},
	{"1822","Bivio Per Foggia/Innesto Ss16 Adriatica"},
	{"1823","Bivio Per Foggia/Innesto Ss655 Di Candela"},
	{"1824","Bivio Per Foggia/Innesto Ss89 Garganica"},
	{"1825","Bivio Per Foglianise"},
	{"1826","Bivio Per Foligno"},
	{"1827","Bivio Per Foligno/Innesto Ss3 Flaminia"},
	{"1828","Bivio Per Follonica/Innesto Ss1 Aurelia"},
	{"1829","Bivio Per Follonica/Innesto Ss322 Delle Collacchie"},
	{"1830","Bivio Per Fontana"},
	{"1831","Bivio Per Fontanarosa/Innesto Ss164"},
	{"1832","Bivio Per Fonte Lepore"},
	{"1833","Bivio Per Foresta"},
	{"1834","Bivio Per Foria"},
	{"1835","Bivio Per Forli' Del Sannio"},
	{"1836","Bivio Per Forli'/Innesto Ss310 Del Bidente"},
	{"1837","Bivio Per Forli'/Innesto Ss9 Emilia"},
	{"1838","Bivio Per Formello"},
	{"1839","Bivio Per Fossano/Incrocio Ss28 Del Colle Di Nava"},
	{"1840","Bivio Per Fossato Di Vico/Incrocio Ss76"},
	{"1841","Bivio Per Fracce"},
	{"1842","Bivio Per Francavilla In Sinni"},
	{"1843","Bivio Per Francolise"},
	{"1844","Bivio Per Frassine"},
	{"1845","Bivio Per Fratta Polesine E Pincara"},
	{"1846","Bivio Per Frattocchie/Innesto Ss7 Appia"},
	{"1847","Bivio Per Frigento"},
	{"1848","Bivio Per Gabbione"},
	{"1849","Bivio Per Gabelletta/Innesto Ss3 Bis Tiberina"},
	{"1850","Bivio Per Gadoni"},
	{"1851","Bivio Per Gaeta"},
	{"1852","Bivio Per Galantina/Innesto Ss313 Di Passo Corese"},
	{"1853","Bivio Per Galantina/Innesto Ss657 Sabina"},
	{"1854","Bivio Per Galatina"},
	{"1855","Bivio Per Gallichio"},
	{"1856","Bivio Per Gambatesa/Innesto Ss17 Dell'ap. App. Sann."},
	{"1857","Bivio Per Gambatesa/Innesto Ss212 Della Val Fortore"},
	{"1858","Bivio Per Garavicchio"},
	{"1859","Bivio Per Garga/Innesto Ss108 Bis Silana Di Cariati"},
	{"1860","Bivio Per Gattara"},
	{"1861","Bivio Per Gavignano"},
	{"1862","Bivio Per Gazzani/Innesto Ss107bis Silana Crotonese"},
	{"1863","Bivio Per Gazzani/Innesto Ss109 Della Piccola Sila"},
	{"1864","Bivio Per Genazzano"},
	{"1865","Bivio Per Gerbini/Innesto Ss192"},
	{"1866","Bivio Per Gerbini/Innesto Ss288 Di Aidone"},
	{"1867","Bivio Per Germano"},
	{"1868","Bivio Per Gesico"},
	{"1869","Bivio Per Gesualdo/Innesto Ss303 Del Formicoso"},
	{"1870","Bivio Per Gesualdo/Innesto Ss428 Di Villa Maina"},
	{"1871","Bivio Per Ghilarza"},
	{"1872","Bivio Per Giacalone"},
	{"1873","Bivio Per Gianico"},
	{"1874","Bivio Per Gigliotto/Innesto Ss124 Siracusana"},
	{"1875","Bivio Per Gildone/Innesto Ss17 Dell'app. Abruzzese"},
	{"1876","Bivio Per Gildone/Innesto Ss375 Gildonese"},
	{"1877","Bivio Per Gimigliano"},
	{"1878","Bivio Per Gioia Sannitica"},
	{"1879","Bivio Per Gioiosa Jonica"},
	{"1880","Bivio Per Gissi"},
	{"1881","Bivio Per Giumarra"},
	{"1882","Bivio Per Gonnesa"},
	{"1883","Bivio Per Gorizia"},
	{"1884","Bivio Per Gradoli/Innesto Ss489 Di Gradoli"},
	{"1885","Bivio Per Grammichele"},
	{"1886","Bivio Per Grandola Ed Uniti"},
	{"1887","Bivio Per Grassano/Incrocio Ss277 Di Calle"},
	{"1888","Bivio Per Gravedona"},
	{"1889","Bivio Per Gravina Di Puglia"},
	{"1890","Bivio Per Gravina In Puglia"},
	{"1891","Bivio Per Greci"},
	{"1892","Bivio Per Gressa"},
	{"1893","Bivio Per Grigno"},
	{"1894","Bivio Per Grottaferrata"},
	{"1895","Bivio Per Grotte"},
	{"1896","Bivio Per Grotteria/Innesto Ss281 Passo Di Limina"},
	{"1897","Bivio Per Grotteria/Innesto Ss501 Di Mongiana"},
	{"1898","Bivio Per Grottolella"},
	{"1899","Bivio Per Grumento Nova"},
	{"1900","Bivio Per Gualdo Tadino"},
	{"1901","Bivio Per Guarcino/Innesto Ss155 Di Fiuggi"},
	{"1902","Bivio Per Guardia Lombardi"},
	{"1903","Bivio Per Guardiagrele"},
	{"1904","Bivio Per Guardialfiera"},
	{"1905","Bivio Per Guardiaregia"},
	{"1906","Bivio Per Guarene"},
	{"1907","Bivio Per Guazzora"},
	{"1908","Bivio Per Gulfi"},
	{"1909","Bivio Per Il Casone"},
	{"1910","Bivio Per Il Passo Delle Radici/Innesto Ss486"},
	{"1911","Bivio Per Il Tempio Di Segesta"},
	{"1912","Bivio Per Illorai"},
	{"1913","Bivio Per Impruneta"},
	{"1914","Bivio Per Introdacqua"},
	{"1915","Bivio Per Iola"},
	{"1916","Bivio Per Iriai"},
	{"1917","Bivio Per Ischia Porto"},
	{"1918","Bivio Per Isola Capo Rizzuto"},
	{"1919","Bivio Per Isola Rizza"},
	{"1920","Bivio Per Istia D'ombrone"},
	{"1921","Bivio Per Italba"},
	{"1922","Bivio Per Ittireddu"},
	{"1923","Bivio Per Jelsi Innesto Ss17 Del'app. Appulo Sannitico"},
	{"1924","Bivio Per Jelsi/Innesto Ss212 Della Val Fortore"},
	{"1925","Bivio Per Jelsi/Innesto Ss645"},
	{"1926","Bivio Per Jerzu"},
	{"1927","Bivio Per Jesi/Incrocio Ss362 Jesina"},
	{"1928","Bivio Per Jolanda Di Savoia E Italba"},
	{"1929","Bivio Per La Callura"},
	{"1930","Bivio Per La Palazzina"},
	{"1931","Bivio Per La Staz. Di Cutro"},
	{"1932","Bivio Per La Staz. Di Marconia"},
	{"1933","Bivio Per La Staz. Di Rossano"},
	{"1934","Bivio Per La Staz. Di Rutino"},
	{"1935","Bivio Per La Staz. Di S.Marco In Lamis"},
	{"1936","Bivio Per La Villa"},
	{"1937","Bivio Per Laces"},
	{"1938","Bivio Per Laerru/Innesto Ss134 Di Castelsardo"},
	{"1939","Bivio Per Lago Albano/Innesto Ss140 Dir"},
	{"1940","Bivio Per Lago Amantea"},
	{"1941","Bivio Per Lago Boracifero"},
	{"1942","Bivio Per Lago Di Disueri"},
	{"1943","Bivio Per Lago Lacreta/Innesto Ss168 Di Venosa"},
	{"1944","Bivio Per Lagosanto"},
	{"1945","Bivio Per Lagundo"},
	{"1946","Bivio Per Laion"},
	{"1947","Bivio Per L'annunziata"},
	{"1948","Bivio Per L'aquila/Innesto Ss17 Dell'appennino Abr."},
	{"1949","Bivio Per Larino E Guglionesi"},
	{"1950","Bivio Per Larino/Innesto Ss480 Di Ururi"},
	{"1951","Bivio Per Larino/Innesto Ss87 Sannitica"},
	{"1952","Bivio Per Latera/Innesto Ss312 Castrense"},
	{"1953","Bivio Per Latera/Innesto Ss74 Maremmana"},
	{"1954","Bivio Per Latina"},
	{"1955","Bivio Per Latronico"},
	{"1956","Bivio Per Lauria"},
	{"1957","Bivio Per Laurino"},
	{"1958","Bivio Per Lauro"},
	{"1959","Bivio Per Lavezzola/Innesto Ss16 Adriatica"},
	{"1960","Bivio Per Lavezzola/Innesto Ss610 Selice"},
	{"1961","Bivio Per Laviano"},
	{"1962","Bivio Per Laviano/Innesto Ss381"},
	{"1963","Bivio Per Laviano/Innesto Ss91 Della Valle Del Sele"},
	{"1964","Bivio Per Le Castella"},
	{"1965","Bivio Per Le Ville/Innesto Ss221 Di Monterchi"},
	{"1966","Bivio Per Lebrino"},
	{"1967","Bivio Per Leccia"},
	{"1968","Bivio Per Leggiuno"},
	{"1969","Bivio Per Leno"},
	{"1970","Bivio Per Lentate Sul Seveso"},
	{"1971","Bivio Per Lentella"},
	{"1972","Bivio Per Leonforte/Innesto Ss117 Centrale Sicula"},
	{"1973","Bivio Per Leonforte/Innesto Ss121 Catanese"},
	{"1974","Bivio Per Lerici"},
	{"1975","Bivio Per Lessona"},
	{"1976","Bivio Per Letizia"},
	{"1977","Bivio Per Levico Terme"},
	{"1978","Bivio Per Libertinia"},
	{"1979","Bivio Per Licata"},
	{"1980","Bivio Per Licodia Eubea"},
	{"1981","Bivio Per Lido Azzurro"},
	{"1982","Bivio Per Lido Degli Estensi"},
	{"1983","Bivio Per Lido Di Specchiolla"},
	{"1984","Bivio Per Lido Di Spina"},
	{"1985","Bivio Per Limpiddu/Innesto Ss131dir/Centr. Nuorese"},
	{"1986","Bivio Per Lioni/Innesto Ss400 Di Castelvetere"},
	{"1987","Bivio Per Lioni/Innesto Ss7 Appia"},
	{"1988","Bivio Per Lioni/Innesto Ss7 Dir/C Via Appia"},
	{"1989","Bivio Per Lioni/Innesto Ss7 Via Appia"},
	{"1990","Bivio Per Liscia"},
	{"1991","Bivio Per Lisciano Niccone"},
	{"1992","Bivio Per Lissone"},
	{"1993","Bivio Per Locati"},
	{"1994","Bivio Per Lonate/Innesto Ss341 Gallaratese"},
	{"1995","Bivio Per Lucera/Svincolo Ss160 Di Lucera"},
	{"1996","Bivio Per Lucito/Innesto Ss157 Della V. Del Biferno"},
	{"1997","Bivio Per Lugnola"},
	{"1998","Bivio Per Lula/Innesto Sp38"},
	{"1999","Bivio Per Luogo/Innesto Ss560 Di Marcatobianco"},
	{"2000","Bivio Per Luogosanto"},
	{"2001","Bivio Per Luras"},
	{"2002","Bivio Per Lustignano"},
	{"2003","Bivio Per Luzzi/Innesto Ss559 Di Luzzi"},
	{"2004","Bivio Per Luzzi/Innesto Ss660 Di Acri"},
	{"2005","Bivio Per Macchia Di Monte"},
	{"2006","Bivio Per Macere/Innesto Ss215 Tuscolana"},
	{"2007","Bivio Per Macomer/Innesto Ss129 Trasversale Sarda"},
	{"2008","Bivio Per Macomer/Innesto Ss131 Di Carlo Felice"},
	{"2009","Bivio Per Maddona Della Cava"},
	{"2010","Bivio Per Madonna Del Vetrano"},
	{"2011","Bivio Per Madonna Delle Querce"},
	{"2012","Bivio Per Maenza"},
	{"2013","Bivio Per Mafalda"},
	{"2014","Bivio Per Magione/Innesto Ss599 Del Trasimeno Inferiore"},
	{"2015","Bivio Per Magliano In Toscana"},
	{"2016","Bivio Per Magliano Nuovo"},
	{"2017","Bivio Per Magliano Sabina"},
	{"2018","Bivio Per Maglie/Innesto Ss275 Di S.Maria Di Leuca"},
	{"2019","Bivio Per Magnano"},
	{"2020","Bivio Per Maiolati E Ss76 Var"},
	{"2021","Bivio Per Maletto"},
	{"2022","Bivio Per Malie/Innesto Ss275 Di S.Maria Di Leuca"},
	{"2023","Bivio Per Maltignano/Innesto Ss259 Vibrata"},
	{"2024","Bivio Per Maltignano/Innesto Ss81 Piceno Aprutina"},
	{"2025","Bivio Per Mandria Luci"},
	{"2026","Bivio Per Manfredonia"},
	{"2027","Bivio Per Manile/Innesto Ss107bis Silana Crotonese"},
	{"2028","Bivio Per Manile/Innesto Ss109 Della Piccola Sila"},
	{"2029","Bivio Per Mara"},
	{"2030","Bivio Per Maracalagonis"},
	{"2031","Bivio Per Maranello"},
	{"2032","Bivio Per Marcaria"},
	{"2033","Bivio Per Marcellina"},
	{"2034","Bivio Per Marcellinara"},
	{"2035","Bivio Per Marina Di Caronia"},
	{"2036","Bivio Per Marina Di Grosseto"},
	{"2037","Bivio Per Marina Di Minturno"},
	{"2038","Bivio Per Marina Di Modica"},
	{"2039","Bivio Per Marina Di Puolo"},
	{"2040","Bivio Per Marina Di Torre Grande"},
	{"2041","Bivio Per Marina Faleriense"},
	{"2042","Bivio Per Marina Romea"},
	{"2043","Bivio Per Marina Schiavonea"},
	{"2044","Bivio Per Marino/Incrocio Ss217 Via Dei Laghi"},
	{"2045","Bivio Per Maritza"},
	{"2046","Bivio Per Marostica/Allacciamento Raccordo Thiene-Bassano"},
	{"2047","Bivio Per Martano"},
	{"2048","Bivio Per Martignano"},
	{"2049","Bivio Per Mascione"},
	{"2050","Bivio Per Masera/Innesto Ss33 Del Sempione"},
	{"2051","Bivio Per Massama E Zeddiani"},
	{"2052","Bivio Per Masserano"},
	{"2053","Bivio Per Masseria Apani"},
	{"2054","Bivio Per Masseria La Chiusa"},
	{"2055","Bivio Per Masseria Pellicciari"},
	{"2056","Bivio Per Matrice"},
	{"2057","Bivio Per Mattarello"},
	{"2058","Bivio Per Medole"},
	{"2059","Bivio Per Medolla/Innesto Ss12 Dell'abet. E Del Brenn."},
	{"2060","Bivio Per Medolla/Innesto Ss468 Di Correggio"},
	{"2061","Bivio Per Melazzo"},
	{"2062","Bivio Per Meleto/Innesto Ss408 Di Montevarchi"},
	{"2063","Bivio Per Meleto/Innesto Ss484 Di Castello Di Brolio"},
	{"2064","Bivio Per Melfi"},
	{"2065","Bivio Per Melfi/Innesto Ss658 Ssv Melfi-Potenza"},
	{"2066","Bivio Per Menfi"},
	{"2067","Bivio Per Mensa/Innesto Raccordo Ravenna-M.Saraceno"},
	{"2068","Bivio Per Merate"},
	{"2069","Bivio Per Mezzate"},
	{"2070","Bivio Per Miggiano/Innesto Ss275 Di S.Maria Di Leuca"},
	{"2071","Bivio Per Migiandone"},
	{"2072","Bivio Per Miglionico/Innesto Ss7 Racc Via Appia"},
	{"2073","Bivio Per Miglionico/Innesto Ss7 Via Appia"},
	{"2074","Bivio Per Milena"},
	{"2075","Bivio Per Mineo"},
	{"2076","Bivio Per Minturno"},
	{"2077","Bivio Per Mirabello Sannitico"},
	{"2078","Bivio Per Miradolo Terme"},
	{"2079","Bivio Per Misilmeri"},
	{"2080","Bivio Per Missanello/Innesto Ss598 Fondo V. D'agri"},
	{"2081","Bivio Per Missanello/Innesto Ss92 Dell'app. Merid.Le"},
	{"2082","Bivio Per Moccone/Innesto Ss279 Silana Di Rose"},
	{"2083","Bivio Per Moccone/Innesto Ss648 Del V. Di M.Te Scuro"},
	{"2084","Bivio Per Moie"},
	{"2085","Bivio Per Molin Bianco"},
	{"2086","Bivio Per Molina Aterno/Innesto Ss5 Tiburtina Valeria"},
	{"2087","Bivio Per Molteno"},
	{"2088","Bivio Per Mombello Monferrato"},
	{"2089","Bivio Per Monfalcone/Innesto Ss14 Della V. Giulia"},
	{"2090","Bivio Per Mongiana/Innesto Ss501 Di Mongiana"},
	{"2091","Bivio Per Mongrando/Innesto Ss338 Di Mongrando"},
	{"2092","Bivio Per Mongrando/Innesto Ss419 Della Serra"},
	{"2093","Bivio Per Moniga Del Garda"},
	{"2094","Bivio Per Monopoli/Innesto Ss16 Adriatica"},
	{"2095","Bivio Per Monopoli/Innesto Ss377 Delle Grotte"},
	{"2096","Bivio Per Monreale"},
	{"2097","Bivio Per Monsano"},
	{"2098","Bivio Per Monserrato/Innesto Ss387 Del Gerrei"},
	{"2099","Bivio Per Monserrato/Innesto Ss554 Cagliaritana"},
	{"2100","Bivio Per Montagano/Innesto Ss647 Fondo V. Biferno"},
	{"2101","Bivio Per Montagano/Innesto 647d/B Fondo V. Del Biferno"},
	{"2102","Bivio Per Montalbano Jonico"},
	{"2103","Bivio Per Montalcino"},
	{"2104","Bivio Per Montalto Di Castro"},
	{"2105","Bivio Per Montaquila"},
	{"2106","Bivio Per Monte Caloria"},
	{"2107","Bivio Per Monte Calvello"},
	{"2108","Bivio Per Monte S. Martino"},
	{"2109","Bivio Per Montechiaro D'asti"},
	{"2110","Bivio Per Montecontieri"},
	{"2111","Bivio Per Montefalco"},
	{"2112","Bivio Per Montefino"},
	{"2113","Bivio Per Montegemoli"},
	{"2114","Bivio Per Monteleone Rocca Doria"},
	{"2115","Bivio Per Montella/Innesto Ss164 Delle Croci Di Acerno"},
	{"2116","Bivio Per Montemarano"},
	{"2117","Bivio Per Montemolino/Innesto Ss3 Bis Tiberina"},
	{"2118","Bivio Per Montemurro"},
	{"2119","Bivio Per Montenero"},
	{"2120","Bivio Per Montepescali/Innesto Ss1 Aurelia"},
	{"2121","Bivio Per Montepescali/Innesto Ss73 Senese Aretina"},
	{"2122","Bivio Per Montepulciano"},
	{"2123","Bivio Per Montesano/Innesto Ss276 Diramazione Dell'alto Agri"},
	{"2124","Bivio Per Montescaglioso"},
	{"2125","Bivio Per Monteverde"},
	{"2126","Bivio Per Monti"},
	{"2127","Bivio Per Monti/Innesto Ss199 Di Monti"},
	{"2128","Bivio Per Montioni"},
	{"2129","Bivio Per Montone/Montecastelli"},
	{"2130","Bivio Per Montorgiali"},
	{"2131","Bivio Per Montorio Al Vomano"},
	{"2132","Bivio Per Morciano Di Leuca"},
	{"2133","Bivio Per Morlupo"},
	{"2134","Bivio Per Moscardo"},
	{"2135","Bivio Per Motta S.Giovanni"},
	{"2136","Bivio Per Mottola/Innesto Ss100 Di Gioia Del Colle"},
	{"2137","Bivio Per Mottola/Innesto Ss377 Delle Grotte"},
	{"2138","Bivio Per Mozzagrogna"},
	{"2139","Bivio Per Muggio'"},
	{"2140","Bivio Per Muravera/Innesto Ss125 Orientale Sarda"},
	{"2141","Bivio Per Muravera/Innesto Ss387 Del Gerrei"},
	{"2142","Bivio Per Muro Leccese"},
	{"2143","Bivio Per Muro Lucano"},
	{"2144","Bivio Per Muros"},
	{"2145","Bivio Per Mussotto D'alea"},
	{"2146","Bivio Per Nardo'"},
	{"2147","Bivio Per Nemi"},
	{"2148","Bivio Per Neoneli"},
	{"2149","Bivio Per Nettuno"},
	{"2150","Bivio Per Niardo"},
	{"2151","Bivio Per Nicastro"},
	{"2152","Bivio Per Niscemi"},
	{"2153","Bivio Per Nocera Superiore"},
	{"2154","Bivio Per Noepoli/Innesto Ss 653 Valle Del Sinni"},
	{"2155","Bivio Per Noepoli/Innesto Ss481 Della V. Del Ferro"},
	{"2156","Bivio Per Noepoli/Innesto Ss92 Dell'app. Meridionale"},
	{"2157","Bivio Per Noicattaro"},
	{"2158","Bivio Per Nola/Innesto Ss367 Nolana Sarnese"},
	{"2159","Bivio Per Nola/Innesto Ss7 Bis Di Terra Di Lavoro"},
	{"2160","Bivio Per Nova Siri"},
	{"2161","Bivio Per Novoli"},
	{"2162","Bivio Per Novoli/Innesto Ss65 Della Futa"},
	{"2163","Bivio Per Nuoro/Incrocio Ss389 Del Correboi"},
	{"2164","Bivio Per Nureci"},
	{"2165","Bivio Per Nurri"},
	{"2166","Bivio Per Oggiono"},
	{"2167","Bivio Per Olaca"},
	{"2168","Bivio Per Oliena"},
	{"2169","Bivio Per Olivarella E Corriolo"},
	{"2170","Bivio Per Oliveto Lucano"},
	{"2171","Bivio Per Olmedo"},
	{"2172","Bivio Per Olzai E Sedilo"},
	{"2173","Bivio Per Onifai"},
	{"2174","Bivio Per Oniferi/Innesto Ss131 Dir/C Di Carlo Felice"},
	{"2175","Bivio Per Opioli E Vangadizza"},
	{"2176","Bivio Per Oppeano"},
	{"2177","Bivio Per Oppido Lucano/Innesto Ss96 Bis Barese"},
	{"2178","Bivio Per Orasso"},
	{"2179","Bivio Per Orciatico"},
	{"2180","Bivio Per Ordona/Innesto Ss161 Di Ortanova"},
	{"2181",""},
	{"2182","Bivio Per Orta S.Giulio"},
	{"2183","Bivio Per Ortona"},
	{"2184","Bivio Per Ortonovo"},
	{"2185","Bivio Per Orune"},
	{"2186","Bivio Per Osidda"},
	{"2187","Bivio Per Ottana"},
	{"2188","Bivio Per Ottana/Innesto Ss131 Dir/Centr."},
	{"2189","Bivio Per Ottana/Innesto Ss537 Di Ghilarza"},
	{"2190","Bivio Per Ozieri/Incrocio Ss597 Di Logudoro"},
	{"2191","Bivio Per Ozieri/Innesto Ss132 Di Ozieri"},
	{"2192","Bivio Per Ozieri/Innesto Ss199 Di Monti"},
	{"2193","Bivio Per Padola"},
	{"2194","Bivio Per Padria/Innesto Ss292 Nord Occ.Le Sarda"},
	{"2195","Bivio Per Padria/Innesto Ss292Diramazione Nord Occ.Le Sarda"},
	{"2196","Bivio Per Paduli"},
	{"2197","Bivio Per Paestum"},
	{"2198","Bivio Per Palagiano/Innesto Ss106 Diramazione Jonica"},
	{"2199","Bivio Per Palagiano/Innesto Ss7 Appia"},
	{"2200","Bivio Per Palata/Innesto Ss157 Della V. Del Biferno"},
	{"2201","Bivio Per Palau/Innesto Ss125 Orientale Sarda"},
	{"2202","Bivio Per Palau/Innesto Ss133 Di Palau"},
	{"2203","Bivio Per Palazzo Minerva"},
	{"2204","Bivio Per Palesella"},
	{"2205","Bivio Per Palma Di Montechiaro"},
	{"2206","Bivio Per Palombina Nuova"},
	{"2207","Bivio Per Pandino E Dovera/Innesto Ss472"},
	{"2208","Bivio Per Panevino"},
	{"2209","Bivio Per Pannarano"},
	{"2210","Bivio Per Pantiere"},
	{"2211","Bivio Per Paola/Incrocio Ss107 Silana Crotonese"},
	{"2212","Bivio Per Paola/Innesto Ss18 Tirrena Inferiore"},
	{"2213","Bivio Per Parrutta"},
	{"2214","Bivio Per Partanna"},
	{"2215","Bivio Per Passo Colle Del Leone"},
	{"2216","Bivio Per Passo Delle Radici/Innesto Ss324"},
	{"2217","Bivio Per Passovecchio/Innesto Ss106 E Ss107bis"},
	{"2218","Bivio Per Paterno"},
	{"2219","Bivio Per Paterno'"},
	{"2220","Bivio Per Paterno'/Innesto Ss121 Catanese"},
	{"2221","Bivio Per Paterno'/Innesto Ss284 Occidentale Etnea"},
	{"2222","Bivio Per Pattada/Innesto Ss128 Bis Centrale Sarda"},
	{"2223","Bivio Per Pattada/Innesto Ss389 Dir/A Del Correboi"},
	{"2224","Bivio Per Pattano"},
	{"2225","Bivio Per Patti"},
	{"2226","Bivio Per Patu'"},
	{"2227","Bivio Per Paulilatino"},
	{"2228","Bivio Per Pavia/Innesto Ss234 Codognese"},
	{"2229","Bivio Per Pavia/Innesto Ss617 Bronese"},
	{"2230","Bivio Per Pedadace/Innesto Ss19 Delle Calabrie"},
	{"2231","Bivio Per Pedica/Innesto Ss511 Anagnina/Innesto Ss218"},
	{"2232","Bivio Per Pera"},
	{"2233","Bivio Per Perfugas"},
	{"2234","Bivio Per Pergine Valdarno"},
	{"2235","Bivio Per Pergine Valsugana"},
	{"2236","Bivio Per Perticano"},
	{"2237","Bivio Per Perugia/Innesto Ss220 Pievaiola"},
	{"2238","Bivio Per Pescarina/Innesto Ss16var"},
	{"2239","Bivio Per Peschiera Borromeo"},
	{"2240","Bivio Per Pescocostanzo"},
	{"2241","Bivio Per Petilia Policastro"},
	{"2242","Bivio Per Petrella Salto"},
	{"2243","Bivio Per Petritoli"},
	{"2244","Bivio Per Pezze Di Greco"},
	{"2245","Bivio Per Pian Camuno"},
	{"2246","Bivio Per Pian D'assino/Innesto Ss219/Innesto Sgc Orte-Ra"},
	{"2247","Bivio Per Piancastagnaio"},
	{"2248","Bivio Per Pianella"},
	{"2249","Bivio Per Pianfei"},
	{"2250","Bivio Per Piazza Armerina"},
	{"2251","Bivio Per Piegaro"},
	{"2252","Bivio Per Pierantonio"},
	{"2253","Bivio Per Pietracuta"},
	{"2254","Bivio Per Pietralunga"},
	{"2255","Bivio Per Pietraperzia"},
	{"2256","Bivio Per Pietravairano"},
	{"2257","Bivio Per Pieve Di Teco/Innesto Ss28 Del Colle Di Nava"},
	{"2258","Bivio Per Pievescola"},
	{"2259","Bivio Per Piglio"},
	{"2260","Bivio Per Pimentel"},
	{"2261","Bivio Per Piscinas"},
	{"2262","Bivio Per Pisticci"},
	{"2263","Bivio Per Pistoia"},
	{"2264","Bivio Per Pizzighettone"},
	{"2265","Bivio Per Pizzo"},
	{"2266","Bivio Per Pizzone"},
	{"2267","Bivio Per Platamona Lido"},
	{"2268","Bivio Per Poggibonsi/Innesto Ss2 Cassia"},
	{"2269","Bivio Per Poggibonsi/Innesto Ss68 Di Val Cecina"},
	{"2270","Bivio Per Poggio Bustone"},
	{"2271","Bivio Per Poggio Mirteto"},
	{"2272","Bivio Per Poggioreale"},
	{"2273","Bivio Per Poggiorsini E Staz. Di Gravina"},
	{"2274","Bivio Per Polacco/Innesto Ss2 Cassia"},
	{"2275","Bivio Per Polistena"},
	{"2276","Bivio Per Polligrone"},
	{"2277","Bivio Per Ponte Di Ferro"},
	{"2278","Bivio Per Pontelandolfo"},
	{"2279","Bivio Per Pontestura"},
	{"2280","Bivio Per Pontinia"},
	{"2281","Bivio Per Poppi"},
	{"2282","Bivio Per Porchiano"},
	{"2283","Bivio Per Portesine"},
	{"2284","Bivio Per Portiglione"},
	{"2285","Bivio Per Porto Cervo"},
	{"2286","Bivio Per Porto Rotondo"},
	{"2287","Bivio Per Porto Tolle"},
	{"2288","Bivio Per Posada E Torpe'"},
	{"2289","Bivio Per Potame"},
	{"2290","Bivio Per Poverella"},
	{"2291","Bivio Per Pozzaglia Sabina"},
	{"2292","Bivio Per Prasco E Staz. Di Cremolino"},
	{"2293","Bivio Per Prata"},
	{"2294","Bivio Per Prata D'ansidonia"},
	{"2295","Bivio Per Pratola Peligna"},
	{"2296","Bivio Per Presicce"},
	{"2297","Bivio Per Prestinari/Innesto Ss249 Gardesana Orient."},
	{"2298","Bivio Per Prestinari/Innesto Ss62 Della Cisa"},
	{"2299","Bivio Per Prizzi"},
	{"2300","Bivio Per Promano"},
	{"2301","Bivio Per Prossedi"},
	{"2302","Bivio Per Punta Marina"},
	{"2303","Bivio Per Quagliano"},
	{"2304","Bivio Per Quaregna"},
	{"2305","Bivio Per Quartucciu/Incrocio Ss554 Cagliaritana"},
	{"2306","Bivio Per Quartucciu/Innesto Ss125 Orientale Sarda"},
	{"2307","Bivio Per Quero"},
	{"2308","Bivio Per Quinto Vercellese/Innesto Ss230 Di Masazza"},
	{"2309","Bivio Per Quinto Vercellese/Innesto Ss594"},
	{"2310","Bivio Per Racale/Bivio Per Melissano"},
	{"2311","Bivio Per Racalmuto Est"},
	{"2312","Bivio Per Racalmuto Ovest"},
	{"2313","Bivio Per Raddusa"},
	{"2314","Bivio Per Radicofani"},
	{"2315","Bivio Per Radogna/Innesto Ss161 Di Ortanova"},
	{"2316","Bivio Per Ragusa"},
	{"2317","Bivio Per Raldon"},
	{"2318","Bivio Per Ramacca"},
	{"2319","Bivio Per Ramata/Innesto Ss171 Bis Di Santeramo"},
	{"2320","Bivio Per Ramundo"},
	{"2321","Bivio Per Ranzo"},
	{"2322","Bivio Per Rasun"},
	{"2323","Bivio Per Reginaldo"},
	{"2324","Bivio Per Rende"},
	{"2325","Bivio Per Renno"},
	{"2326","Bivio Per Riccia"},
	{"2327","Bivio Per Riccio/Innesto Ss71 Umbro Cas. Romagn."},
	{"2328","Bivio Per Riccio/Innesto Ss75 Bis Del Trasimeno"},
	{"2329","Bivio Per Riesi/Innesto Ss190 Delle Solfare"},
	{"2330","Bivio Per Riotorto"},
	{"2331","Bivio Per Ripa Teatina"},
	{"2332","Bivio Per Ripalimosani/Innesto Ss87 Sannitica"},
	{"2333","Bivio Per Ripalimosani/Innesto Ss647dir/B"},
	{"2334","Bivio Per Riparbella"},
	{"2335","Bivio Per Rivello"},
	{"2336","Bivio Per Rivere"},
	{"2337","Bivio Per Robegano"},
	{"2338","Bivio Per Rocca D'aspide/Innesto Ss166 Degli Alburni"},
	{"2339","Bivio Per Rocca D'aspide/Innesto Ss488 Di Rocca D'aspid"},
	{"2340","Bivio Per Rocca D'evandro"},
	{"2341","Bivio Per Rocca Di Neto"},
	{"2342","Bivio Per Rocca Di Papa/Incrocio Ss217 Via Dei Laghi"},
	{"2343","Bivio Per Rocca Priora"},
	{"2344","Bivio Per Rocca Sinibalda"},
	{"2345","Bivio Per Roccabernarda"},
	{"2346","Bivio Per Roccanova"},
	{"2347","Bivio Per Roccapalumba/Innesto Ss121 Catanese"},
	{"2348","Bivio Per Roccapalumba/Innesto Ss285 Di Caccamo"},
	{"2349","Bivio Per Rocchetta S.Antonio"},
	{"2350","Bivio Per Rodengo"},
	{"2351","Bivio Per Romagnano Al Monte"},
	{"2352","Bivio Per Romanengo"},
	{"2353","Bivio Per Rometta/Innesto Ss446 Di Fosdinovo"},
	{"2354","Bivio Per Rometta/Innesto Ss63 Del Valico Del Cerret"},
	{"2355","Bivio Per Rosignano Marittimo"},
	{"2356","Bivio Per Rotacesta"},
	{"2357","Bivio Per Rotondella"},
	{"2358","Bivio Per Royeres"},
	{"2359","Bivio Per Rucava'/Innesto Ss203 Agordina"},
	{"2360","Bivio Per Rusteghino"},
	{"2361","Bivio Per S. Cassiano"},
	{"2362","Bivio Per S. Cesareo/Innesto Ss155 Di Fiuggi"},
	{"2363","Bivio Per S. Giacomo"},
	{"2364","Bivio Per S. Marco Argentano"},
	{"2365","Bivio Per S. Rufo/Innesto Ss426 Di Polla"},
	{"2366","Bivio Per S. Severo/Incrocio Ss160 Di Lucera"},
	{"2367","Bivio Per S. Vito/Innesto Ss430 Valle Del Garigliano"},
	{"2368","Bivio Per S.Agapito E S.Salvatore"},
	{"2369","Bivio Per S.Albino"},
	{"2370","Bivio Per S.Angelo Dei Lombardi"},
	{"2371","Bivio Per S.Arcangelo"},
	{"2372","Bivio Per S.Bartolomeo/Innesto Ss385 Di Palagonia"},
	{"2373","Bivio Per S.Benigno/Raccordo Autostrada Torino - Aeroporto Caselle"},
	{"2374","Bivio Per S.Benigno-Innesto Ss460"},
	{"2375","Bivio Per S.Carlo"},
	{"2376","Bivio Per S.Cipirello"},
	{"2377","Bivio Per S.Cristina D'aspromonte/Innesto Ss112"},
	{"2378","Bivio Per S.Cristina/Innesto Ss111 Dir"},
	{"2379","Bivio Per S.Croce/Innesto Ss630 Ausonia"},
	{"2380","Bivio Per S.Donato/Innesto Ss476 Di Galatina"},
	{"2381","Bivio Per S.Donato/Innesto Ss664 Mediana Del Salento"},
	{"2382","Bivio Per S.Eusanio Del Sangro"},
	{"2383","Bivio Per S.Fele"},
	{"2384","Bivio Per S.Felice Circeo"},
	{"2385","Bivio Per S.Fili"},
	{"2386","Bivio Per S.Filippo Del Mela"},
	{"2387","Bivio Per S.Fiora"},
	{"2388","Bivio Per S.Floro"},
	{"2389","Bivio Per S.Gemini/Innesto Ss3 Ter Tiberina"},
	{"2390","Bivio Per S.Giacomo D'acri"},
	{"2391","Bivio Per S.Giorgio"},
	{"2392","Bivio Per S.Giorgio A Liri"},
	{"2393","Bivio Per S.Giorgio Di Pertiche"},
	{"2394","Bivio Per S.Giovanni"},
	{"2395","Bivio Per S.Giovanni Gemini"},
	{"2396","Bivio Per S.Giovanni Lipioni"},
	{"2397","Bivio Per S.Giustino Umbro"},
	{"2398","Bivio Per S.Giustino Umbro/Innesto Ss3 Bis Tiberina"},
	{"2399","Bivio Per S.Giustino/Innesto Ss73bis Di Bocca Trabaria"},
	{"2400","Bivio Per S.Leonardo Valcellina"},
	{"2401","Bivio Per S.Lorenzo"},
	{"2402","Bivio Per S.Lucia"},
	{"2403","Bivio Per S.Marco La Catola"},
	{"2404","Bivio Per S.Margherita"},
	{"2405","Bivio Per S.Margherita E Sambuca Di Sicilia"},
	{"2406","Bivio Per S.Maria Della Fede"},
	{"2407","Bivio Per S.Maria Di Licodia"},
	{"2408","Bivio Per S.Maria Di Mortola"},
	{"2409","Bivio Per S.Maria Licodia"},
	{"2410","Bivio Per S.Martino D'agri"},
	{"2411","Bivio Per S.Martino Olearo"},
	{"2412","Bivio Per S.Matteo"},
	{"2413","Bivio Per S.Mauro A Mare"},
	{"2414","Bivio Per S.Mauro Forte"},
	{"2415","Bivio Per S.Mauro Marchesato/Innesto Ss109 Ter"},
	{"2416","Bivio Per S.Michele Salentino"},
	{"2417","Bivio Per S.Nicolo'"},
	{"2418","Bivio Per S.Omero"},
	{"2419","Bivio Per S.Pietro Vernotico"},
	{"2420","Bivio Per S.Rocco"},
	{"2421","Bivio Per S.Rufo/Innesto Ss166 Degli Alburni"},
	{"2422","Bivio Per S.Salvatore E Castelletto"},
	{"2423","Bivio Per S.Salvatore Telesino"},
	{"2424","Bivio Per S.Severina"},
	{"2425","Bivio Per S.Severino Lucano"},
	{"2426","Bivio Per S.Sossio Baronia"},
	{"2427","Bivio Per S.Stino Di Livenza"},
	{"2428","Bivio Per S.Teodoro - Innesto Ss125 Orientale Sarda"},
	{"2429","Bivio Per S.Teodoro/Innesto Ss125 Orientale Sarda"},
	{"2430","Bivio Per S.Teodoro/Innesto Ss131dir/Centr. Nuorese"},
	{"2431","Bivio Per S.Vero Milis"},
	{"2432","Bivio Per S.Vigilio"},
	{"2433","Bivio Per S.Vincenzo"},
	{"2434","Bivio Per S.Vito Sul Cesano"},
	{"2435","Bivio Per S.Vito/Innesto Ss7 Quater Domitiana"},
	{"2436","Bivio Per Sabaudia"},
	{"2437","Bivio Per Sadali"},
	{"2438","Bivio Per Saga/Confine Con La Slovenia"},
	{"2439","Bivio Per Salo'/Innesto Ss45 Bis Gardesana Occ.Le"},
	{"2440","Bivio Per Salve"},
	{"2441","Bivio Per Sambuco"},
	{"2442","Bivio Per Samone E Per Montecorone"},
	{"2443","Bivio Per Sanluri"},
	{"2444","Bivio Per Sansepolcro/Innesto Ss258 Marecchia"},
	{"2445","Bivio Per Sansepolcro/Innesto Ss3 Bis Tiberina"},
	{"2446","Bivio Per Sansepolcro/Innesto Ss73 Senese Aretina"},
	{"2447","Bivio Per Santa Lucia"},
	{"2448","Bivio Per Saponara"},
	{"2449","Bivio Per Saracinello/Innesto Ss106 E Racc A3-Ss106 Ter"},
	{"2450","Bivio Per Sarmato"},
	{"2451","Bivio Per Saronno/Incrocio Ss527 Bustese"},
	{"2452","Bivio Per Saronno/Innesto Ss233 Varesina"},
	{"2453","Bivio Per Sarroch"},
	{"2454","Bivio Per Sarrotino"},
	{"2455","Bivio Per Sassetta"},
	{"2456","Bivio Per Sasso Marconi"},
	{"2457","Bivio Per Scala Coeli"},
	{"2458","Bivio Per Scano Di Montiferro"},
	{"2459","Bivio Per Schiavi Di Abruzzo"},
	{"2460","Bivio Per Sciara"},
	{"2461","Bivio Per Scicli"},
	{"2462","Bivio Per Scopello"},
	{"2463","Bivio Per Scopoli"},
	{"2464","Bivio Per Scorrano"},
	{"2465","Bivio Per Seccagrande"},
	{"2466","Bivio Per Sedilo"},
	{"2467","Bivio Per Seggiano"},
	{"2468","Bivio Per Selargius"},
	{"2469","Bivio Per Selci Lama"},
	{"2470","Bivio Per Sella Di Corno"},
	{"2471","Bivio Per Sellia Marina"},
	{"2472","Bivio Per Selvazzano Dentro"},
	{"2473","Bivio Per Senise"},
	{"2474","Bivio Per Seregno"},
	{"2475","Bivio Per Serra De' Conti"},
	{"2476","Bivio Per Serra S.Quirico"},
	{"2477","Bivio Per Serrastretta"},
	{"2478","Bivio Per Serre/Innesto Ss19 Delle Calabrie"},
	{"2479","Bivio Per Sessa Aurunca"},
	{"2480","Bivio Per Sessant"},
	{"2481","Bivio Per Sesto Cremonese"},
	{"2482","Bivio Per Sestri Levante - Innesto Ss370"},
	{"2483","Bivio Per Sestu"},
	{"2484","Bivio Per Settebagni"},
	{"2485","Bivio Per Settingiano"},
	{"2486","Bivio Per Sezze"},
	{"2487","Bivio Per Silanus"},
	{"2488","Bivio Per Silla"},
	{"2489","Bivio Per Sirmione"},
	{"2490","Bivio Per Sonvigo"},
	{"2491","Bivio Per Soriano Nel Cimino E Bomarzo"},
	{"2492","Bivio Per Sos Rueddos"},
	{"2493","Bivio Per Sparanise"},
	{"2494","Bivio Per Spedaletto"},
	{"2495","Bivio Per Spinazzola/Innesto Ss168 Di Venosa"},
	{"2496","Bivio Per Spinazzola/Innesto Ss169 Di Genzano"},
	{"2497","Bivio Per Squillace/Innesto Ss181 Di Maida E Squillace"},
	{"2498","Bivio Per Squinzano E Torchiarolo"},
	{"2499","Bivio Per Squinzano E Torre Rinalda"},
	{"2500","Bivio Per Staz. Carovigno"},
	{"2501","Bivio Per Staz. Di Chiusi/Innesto Ss146 Di Chianciano"},
	{"2502","Bivio Per Staz. Di Monti Telti"},
	{"2503","Bivio Per Staz. Di Nova Siri/Innesto Ss104 Di Sapri"},
	{"2504","Bivio Per Staz. Di Surbo"},
	{"2505","Bivio Per Staz. Di Venusio"},
	{"2506","Bivio Per Staz. Fildidonna"},
	{"2507","Bivio Per Staz. S.Luce"},
	{"2508","Bivio Per Stazione Di Rodda Quadda"},
	{"2509","Bivio Per Stazione Ellera Corciano"},
	{"2510","Bivio Per Steccato/Innesto Ss106 Jonica"},
	{"2511","Bivio Per Steccato/Innesto Ss109 Della Piccola Sila"},
	{"2512","Bivio Per Sternatia E Bivio Per Soleto"},
	{"2513","Bivio Per Stigliano/Innesto Ss277 Di Calle"},
	{"2514",""},
	{"2515","Bivio Per Stombi/Innesto Ss106 Jonica"},
	{"2516","Bivio Per Stombi/Innesto Ss534 Di Cammarata"},
	{"2517","Bivio Per Strigno"},
	{"2518","Bivio Per Strongoli"},
	{"2519","Bivio Per Su Canale"},
	{"2520","Bivio Per Suello/Innesto Ss36 Dell'Aeroporto D. Malpensa"},
	{"2521","Bivio Per Surbo E Bivio Per Lecce"},
	{"2522","Bivio Per Sybaris E Copia"},
	{"2523","Bivio Per Taboga/Innesto Ss13 Pontebbana"},
	{"2524","Bivio Per Taboga/Innesto Ss463 Del Tagliamento"},
	{"2525","Bivio Per Tagliata"},
	{"2526","Bivio Per Taglio Di Po"},
	{"2527","Bivio Per Talmassons E Bivio Per Mortegliano"},
	{"2528","Bivio Per Tanaunella"},
	{"2529","Bivio Per Taormina"},
	{"2530","Bivio Per Taranto/Innesto Ss172 Dei Trulli"},
	{"2531","Bivio Per Tarquinia"},
	{"2532","Bivio Per Tarsia"},
	{"2533","Bivio Per Taurianova"},
	{"2534","Bivio Per Tavernacce"},
	{"2535","Bivio Per Taverne D'arbia"},
	{"2536","Bivio Per Telese Terme/Innesto Ss372 Telesina"},
	{"2537","Bivio Per Telese/Innesto Ss87 Sannitica"},
	{"2538","Bivio Per Teora"},
	{"2539","Bivio Per Terlizzi"},
	{"2540","Bivio Per Terme Di Suio"},
	{"2541","Bivio Per Terme Selinuntine"},
	{"2542","Bivio Per Terme Vigliatore"},
	{"2543","Bivio Per Terracina/Innesto Ss148 Pontina"},
	{"2544","Bivio Per Terralba"},
	{"2545","Bivio Per Terravecchia"},
	{"2546","Bivio Per Terriciola"},
	{"2547","Bivio Per Terzo D'aquileia"},
	{"2548","Bivio Per Tignale"},
	{"2549","Bivio Per Timpone"},
	{"2550","Bivio Per Torchiarolo"},
	{"2551","Bivio Per Torre Bormida"},
	{"2552","Bivio Per Torre Di Ramitelli"},
	{"2553","Bivio Per Torre Di Ruggiero"},
	{"2554","Bivio Per Torrette A Mare"},
	{"2555","Bivio Per Torrita Di Siena"},
	{"2556","Bivio Per Tovo S.Agata"},
	{"2557","Bivio Per Trabia Miniere"},
	{"2558","Bivio Per Tradate"},
	{"2559","Bivio Per Tramutola"},
	{"2560","Bivio Per Tratalias"},
	{"2561","Bivio Per Trecchina"},
	{"2562","Bivio Per Trepuzzi E Bivio Per Surbo"},
	{"2563","Bivio Per Tricarico"},
	{"2564","Bivio Per Trignano"},
	{"2565","Bivio Per Trissino"},
	{"2566","Bivio Per Trivento"},
	{"2567","Bivio Per Trivigno"},
	{"2568","Bivio Per Troia/Innesto Ss160 Di Lucera"},
	{"2569","Bivio Per Tufillo"},
	{"2570","Bivio Per Tula"},
	{"2571","Bivio Per Tuoro Sul Trasimeno"},
	{"2572","Bivio Per Uccea"},
	{"2573","Bivio Per Ugento"},
	{"2574","Bivio Per Umbertide"},
	{"2575","Bivio Per Urbino"},
	{"2576","Bivio Per Urzulei"},
	{"2577","Bivio Per Vacone"},
	{"2578","Bivio Per Vacri"},
	{"2579","Bivio Per Vaglio Basilicata"},
	{"2580","Bivio Per Vairano Patenora"},
	{"2581","Bivio Per Valdengo"},
	{"2582","Bivio Per Valguarnera"},
	{"2583","Bivio Per Valguarnera Caropepe"},
	{"2584","Bivio Per Vallata/Innesto Ss91 Bis Irpina"},
	{"2585","Bivio Per Vallata/Innesto Ss91 Della Valle Del Sele"},
	{"2586","Bivio Per Valle Castellone"},
	{"2587","Bivio Per Valledolmo"},
	{"2588","Bivio Per Vallese"},
	{"2589","Bivio Per Vallongo"},
	{"2590","Bivio Per Valsinni"},
	{"2591","Bivio Per Varallo Pombia"},
	{"2592","Bivio Per Varedo/Incrocio Ss35 Dei Giovi"},
	{"2593","Bivio Per Vedano Olona"},
	{"2594","Bivio Per Venturina/Innesto Ss1 Aurelia"},
	{"2595","Bivio Per Venturina/Innesto Ss398 Via Val Di Cornia"},
	{"2596","Bivio Per Verdi"},
	{"2597","Bivio Per Vergiate/Innesto Ss33 Del Sempione"},
	{"2598","Bivio Per Vermezzo"},
	{"2599","Bivio Per Vernasca"},
	{"2600","Bivio Per Vernazzano"},
	{"2601","Bivio Per Veroli"},
	{"2602","Bivio Per Verona Nord/Innesto Ss11 Padana Superiore"},
	{"2603","Bivio Per Verona Nord/Innesto Ss12 Abetone E Brennero"},
	{"2604","Bivio Per Verucchio"},
	{"2605","Bivio Per Vescovato"},
	{"2606","Bivio Per Vezzano Ligure"},
	{"2607","Bivio Per Viareggio"},
	{"2608","Bivio Per Vicarello"},
	{"2609","Bivio Per Vico D'elsa"},
	{"2610","Bivio Per Viepri"},
	{"2611","Bivio Per Vigarano Mainarda"},
	{"2612","Bivio Per Viggiano"},
	{"2613","Bivio Per Viggiano/Innesto Ss276 Dell'alto Agri"},
	{"2614","Bivio Per Vigna Di Valle"},
	{"2615","Bivio Per Vigne Vanasco/Innesto Ss191 Di Pietraperzia"},
	{"2616","Bivio Per Villa"},
	{"2617","Bivio Per Villa Bartolomea"},
	{"2618","Bivio Per Villa D'agri/Innesto Ss276 Dell'alto Agri"},
	{"2619","Bivio Per Villa D'alme'"},
	{"2620","Bivio Per Villa Latina"},
	{"2621","Bivio Per Villa S.Maria"},
	{"2622","Bivio Per Villa Speciosa"},
	{"2623","Bivio Per Villadoro"},
	{"2624","Bivio Per Villafranca Padovana"},
	{"2625","Bivio Per Villaggio Pino Grande"},
	{"2626","Bivio Per Villalta"},
	{"2627","Bivio Per Villamagna"},
	{"2628","Bivio Per Villamassargia"},
	{"2629","Bivio Per Villanova D'albenga"},
	{"2630","Bivio Per Villanova/Innesto Ss602 Di Forca Di Penne"},
	{"2631","Bivio Per Villanova/Innesto Ss81 Piceno Aprutina"},
	{"2632","Bivio Per Villanovafranca"},
	{"2633","Bivio Per Villapriolo"},
	{"2634","Bivio Per Villareia/Innesto Ss5 Tiburtina Valeria"},
	{"2635","Bivio Per Villasalto"},
	{"2636","Bivio Per Villotta"},
	{"2637","Bivio Per Vilmaggiore"},
	{"2638","Bivio Per Vinchiaturo"},
	{"2639","Bivio Per Vinchiaturo/Innesto Ss17 App. Abb. App. San."},
	{"2640","Bivio Per Vinchiaturo/Innesto Ss87 Sannitica"},
	{"2641","Bivio Per Vipiteno/Incrocio Ss44 Del Passo Di Giovo"},
	{"2642","Bivio Per Vipiteno/Innesto Ss44 Del Passo Del Giovo"},
	{"2643","Bivio Per Virco E Bivio Per Galleriano"},
	{"2644","Bivio Per Vizzola Ticino"},
	{"2645","Bivio Per Volta Mantovana"},
	{"2646","Bivio Per Voltera"},
	{"2647","Bivio Per Volturara Irpina"},
	{"2648","Bivio Per Zavattarello"},
	{"2649","Bivio Per Zelo Buon Persico"},
	{"2650","Bivio Per Zingolella"},
	{"2651","Bivio Per Zoppola"},
	{"2652","Bivio Polacco/Innesto Ss321 Del Polacco"},
	{"2653","Bivio Ponte Nuovo"},
	{"2654","Bivio Ponte Pattoli"},
	{"2655","Bivio Ramata/Innesto Ss561 Pergusina"},
	{"2656","Bivio Ranocchia/Innesto Ss16 Adriatica"},
	{"2657","Bivio Ranocchia/Innesto Ss361 Septempedana"},
	{"2658","Bivio Rapolano Terme"},
	{"2659","Bivio Rapolla/Ss93 Appulo-Lucana"},
	{"2660","Bivio Rastrello"},
	{"2661","Bivio Resina"},
	{"2662","Bivio Rezzato/Innesto Ss11 Padana Superiore"},
	{"2663","Bivio Rigomagno E Sinalunga"},
	{"2664","Bivio Rionero In Vulture"},
	{"2665","Bivio Rionero In Vulture/Innesto Ss93 Appulo Lucana"},
	{"2666","Bivio Rocca Di Papa/Incrocio Ss218 Di Rocca Di Papa"},
	{"2667","Bivio Ronzone/Innesto Ss43 Dir/A"},
	{"2668","Bivio S. Angelo Possidente"},
	{"2669","Bivio S.Croce/Innesto Ss7 Appia/Var.Formia-Garigliano"},
	{"2670","Bivio S.Egidio Aeroporto"},
	{"2671","Bivio Salica'/Innesto Ss113 Settentr. Sicula"},
	{"2672","Bivio Salica'/Innesto Ss185 Di Sella Mandrazzi"},
	{"2673","Bivio Sangemini"},
	{"2674","Bivio Sannicola Nord"},
	{"2675","Bivio Sannicola Sud"},
	{"2676","Bivio Scalera E Staz. Di Forenza"},
	{"2677","Bivio Serre Di Rapolano"},
	{"2678","Bivio Sinalunga-Foiano Della Chiana"},
	{"2679","Bivio Staffoli"},
	{"2680","Bivio Staz. Oniferi/Incrocio Ss129 TraSvincolo Sarda"},
	{"2681","Bivio Taverne D'arbia-Ss438 Lauretana"},
	{"2682","Bivio Torgiano"},
	{"2683","Bivio Torre A Castello"},
	{"2684","Bivio Varedo/Innesto Ss527 Bustese"},
	{"2685","Bivio Vigne Vanasco/Innesto Ss190 Delle Solfare"},
	{"2686","Bivio Canazei/Innesto Ss242 Val Gardena E Passo Sella"},
	{"2687","Bivio Cesano Maderno"},
	{"2688","Bivio Desio"},
	{"2689","Bivio Meda"},
	{"2690","Bivio Palazzolo Milanese"},
	{"2691","Bivio Per Bonacci/Innesto Ss109 Della Piccola Sila"},
	{"2692","Bivio Per Corigliano/Innesto Ss664 Mediana Del Salento"},
	{"2693","Bivio Per Garga/Innesto Ss107 Silana Crotonese"},
	{"2694","Bivio Per Marcianise/Innesto Ss7 Bis Di Terra Di Lavoro"},
	{"2695","Bivio Per Pedadace/Innesto Ss19 Diramazione Delle Calabrie"},
	{"2696","Bivio Per S.Buono"},
	{"2697","Bivio Per S.Sossio/Innesto Ss7bis/Diramazione Di Villa Literno"},
	{"2698","Bivio Per Silla"},
	{"2699","Bivio Porto Botte"},
	{"2700","Bivio S.Giorio Di Susa"},
	{"2701","Bivio Saracinello/Innesto Ss106 Ter E Racc A3-Ss106 Ter"},
	{"2702","Bivio Vairano Scalo/Incrocio Ss608"},
	{"2703","Bivio Villar Focchiardo"},
	{"2704","Bivio Vipiteno/Innesto Ss12 Abetone E Brennero"},
	{"2705","Bivio Vipiteno/Innesto Ss508 Val Sarentino"},
	{"2706","Casa Cantoniera Scala Cavalli/Innesto Ss127 Bis Sett.Sarda"},
	{"2707","C.Cardi"},
	{"2708","C.So Unita'd'italia/Innesto Diramazione Per Moncalieri"},
	{"2709","Ca' Di David"},
	{"2710","Ca' Di Vara/Innesto Ss566 Di Val Di Vara"},
	{"2711","Ca' Di Vara/Innesto Ss566 Diramazione Di Val Di Vara"},
	{"2712","Ca' Lidora Ovest"},
	{"2713","Ca' Raffaello"},
	{"2714","Ca' Rossa/Innesto Ss237 Del Caffaro"},
	{"2715","Ca' Trebbia/Variante Di Perino"},
	{"2716","Cabelli"},
	{"2717","Cabu Abbas/Innesto Ss131 Bis Di Carlo Felice"},
	{"2718","Cabu Abbas/Innesto Ss131 Di Carlo Felice"},
	{"2719","Caccamo"},
	{"2720","Cadelbosco Di Sopra/Innesto Ss358 Di Castelnovo"},
	{"2721","Cadelbosco Di Sopra/Innesto Ss63 Del V. Del Cerreto"},
	{"2722","Cadeo"},
	{"2723","Caderzone"},
	{"2724","Cadibona"},
	{"2725","Cadilana"},
	{"2726","Cadipietra"},
	{"2727","Cadola"},
	{"2728","Cadola-Svincolo Di Belluno"},
	{"2729","Caerano Di S.Marco"},
	{"2730","Cafaggiolo"},
	{"2731","Caffagio"},
	{"2732","Cagli"},
	{"2733","Cagli/Innesto Ss3 Flaminia"},
	{"2734","Cagli/Innesto Ss424 Della Val Cesano"},
	{"2735","Cagliari"},
	{"2736","Cagliari Chiesa"},
	{"2737","Cagliari Nord/Innesto Ss131 Di Carlo Felice"},
	{"2738","Cagliari Nord/Innesto Ss131 Diramazione Carlo Felice"},
	{"2739","Cagliari Nord/Innesto Ss554 Cagliaritana"},
	{"2740","Cagliari/Innesto Ss130 Iglesiente"},
	{"2741","Cagliari/Innesto Ss131 Di Carlo Felice"},
	{"2742","Cagliari/Innesto Ss131 Diramazione Di Carlo Felice"},
	{"2743","Cagliari/Innesto Ss195 Sulcitana"},
	{"2744","Cagliari/Innesto Ss387 Del Gerrei"},
	{"2745","Cagliari/Innesto Ss391 Di Elmas"},
	{"2746","Cagliaritana"},
	{"2747","Cagnano Varano"},
	{"2748","Cagno'"},
	{"2749","Caianello"},
	{"2750","Caianello/Innesto Ss372 Telesina"},
	{"2751","Caianello/Innesto Ss372 Telesina"},
	{"2752","Caianello/Innesto Ss6 Casilina"},
	{"2753","Caiazzo"},
	{"2754","Caiazzo/Innesto Ss158 Della Valle Del Volturno"},
	{"2755","Caiazzo/Innesto Ss87 Sannitica"},
	{"2756","Caino"},
	{"2757","Caivano"},
	{"2758","Calabretto"},
	{"2759","Calabria"},
	{"2760","Calaggio"},
	{"2761","Calalzo Di Cadore"},
	{"2762","Calamandrana"},
	{"2763","Calambrone"},
	{"2764","Calamonaci"},
	{"2765","Calangianus"},
	{"2766","Calangianus/Innesto Ss127 Sett.Le Sarda"},
	{"2767","Calangianus/Innesto Ss427 Della Gallura Centrale"},
	{"2768","Calascibetta"},
	{"2769","Calasetta/Carloforte"},
	{"2770","Calatabiano"},
	{"2771","Calatafimi/Innesto Ss113 Settentrionale Sicula"},
	{"2772","Calatafimi/Innesto Ss188 Dir/A Centro Occ. Sicula"},
	{"2773","Calcinaia"},
	{"2774","Calcinelli"},
	{"2775","Calcinelli Di Saltara"},
	{"2776","Calcio"},
	{"2777","Calco Innesto Ss342 Diramazione Briantea"},
	{"2778","Calco/Innesto Ss342 Briantea"},
	{"2779","Caldare"},
	{"2780","Caldarola"},
	{"2781","Calderaro/Innesto Ss18 Diramazione E Ss280"},
	{"2782","Calderaro/Innesto Ss18Diramazione E Ss19dir"},
	{"2783","Calderaro/Innesto Ss19 Diramazione Delle Calabrie E Ss280"},
	{"2784","Caldine"},
	{"2785","Calenzano-Sesto Fiorentino"},
	{"2786","Calerno"},
	{"2787","Calitri"},
	{"2788","Calitri Sud/Innesto Ss401 E Ss7 Diramazione C"},
	{"2789","Calizzano"},
	{"2790","Calliano"},
	{"2791","Calliano/Innesto Ss12 Dell'abetone E Del Brennero"},
	{"2792","Calliano/Innesto Ss350 Di Folgaria E Val D'astico"},
	{"2793","Calmasino-Piovezzano"},
	{"2794","Calmazzo"},
	{"2795","Calmazzo/Innesto Ss3 E Raccordo Fano-Fossombrone"},
	{"2796","Calmazzo/Innesto Ss73 Bis Di Bocca Trabaria"},
	{"2797","Calmazzo-Innesto Ss3 Flaminia"},
	{"2798","Calolziocorte"},
	{"2799","Calstorta"},
	{"2800","Caltagirone"},
	{"2801","Caltagirone (ss124)"},
	{"2802","Caltanissetta"},
	{"2803","Caltanissetta/Innesto Diramazione Per Imera E Ss122bis"},
	{"2804","Caltanissetta/Innesto Ss122 Agrigentina"},
	{"2805","Caltanissetta/Innesto Ss191 Di Pietraperzia"},
	{"2806","Caltanissetta/Innesto Ss640 Di P.To Empedocle"},
	{"2807","Caltanissetta-Imera"},
	{"2808","Caltavuturo"},
	{"2809","Caltignaga"},
	{"2810","Caltrano"},
	{"2811","Caluso Var."},
	{"2812","Caluso/Innesto Ss26 Della Val D'aosta"},
	{"2813","Caluso/Innesto Ss595 Di Mazze'"},
	{"2814","Calvecchia"},
	{"2815","Camaldoli"},
	{"2816","Camastra"},
	{"2817","Cambiano"},
	{"2818","Camera"},
	{"2819","Cameriano"},
	{"2820","Camigliatello Silano/Innesto Ss648"},
	{"2821","Camigliatello Silano/Innesto Ss107 Silana Crotonese"},
	{"2822","Camigliatello/Innesto Ss107 Silana Crotonese"},
	{"2823","Camigliatello/Innesto Ss177 Silana Di Rossano"},
	{"2824","Camigliatello/Innesto Ss279Diramazione Di M.Te Curcio"},
	{"2825","Camigliatello/Innesto Ss648 Del Valico Di M.Te Scuro"},
	{"2826","Camignone"},
	{"2827","Caminata"},
	{"2828","Camino"},
	{"2829","Campagna"},
	{"2830","Campagnola/Innesto Ss32 Diramazione Ticinese"},
	{"2831","Campagnola/Innesto Ss32 Ticinese"},
	{"2832","Campaldino/Innesto Ss70 Della Consuma"},
	{"2833","Campalto"},
	{"2834","Campana"},
	{"2835","Campanelli"},
	{"2836","Campania"},
	{"2837","Campeglio"},
	{"2838","Campertogno"},
	{"2839","Campestrin"},
	{"2840","Campetto Belbo/Innesto Ss29 Del Colle Di Cadibona"},
	{"2841","Campetto Belbo/Innesto Ss592 Di Canelli"},
	{"2842","Campi Bisenzio"},
	{"2843","Campi Salentina"},
	{"2844","Campigna"},
	{"2845","Campioli"},
	{"2846","Campiolo Ovest"},
	{"2847","Campitello"},
	{"2848","Campitello Di Fassa"},
	{"2849","Campli"},
	{"2850","Campo Aperto/Innesto Ss647 Fondo V. Del Biferno"},
	{"2851","Campo Aperto/Innesto Ss647d/A Fondo V. Del Biferno"},
	{"2852","Campo Calabro"},
	{"2853","Campo Catino"},
	{"2854","Campo D'arco/Fine Variante Di Nocera"},
	{"2855","Campo Della Chiesa/Innesto Ss109 Della Piccola Sila"},
	{"2856","Campo Della Chiesa/Innesto Ss179 Del L. Ampollino"},
	{"2857","Campo Di Trens"},
	{"2858","Campo S.Martino"},
	{"2859","Campo Tizzoro"},
	{"2860","Campo Tures"},
	{"2861","Campo Verde"},
	{"2862","Campobasso"},
	{"2863","Campobasso/Innesto Ss375 Gildonese/Innesto Ss647dir/B"},
	{"2864","Campobasso/Innesto Ss87/Innesto Ss375"},
	{"2865","Campobasso/Innesto Ss87 Sannitica/Innesto Ss647 Dir/B"},
	{"2866","Campobello Di Licata"},
	{"2867","Campobello Di Licata/Incrocio Ss123 Di Licata"},
	{"2868","Campobello Di Licata/Innesto Ss123 Di Licata"},
	{"2869","Campobello Di Licata/Innesto Ss557 Campobello Di L."},
	{"2870","Campobello Di Licata/Innesto Ss644 Di Ravanusa"},
	{"2871","Campobello Di Mazara"},
	{"2872","Campocologno/Confine Con La Svizzera"},
	{"2873","Campodarsego"},
	{"2874","Campodicarne"},
	{"2875","Campodolcino"},
	{"2876","Campofelice Di Roccella"},
	{"2877","Campofiorito"},
	{"2878","Campoformido"},
	{"2879","Campoforogna"},
	{"2880","Campofranco Staz."},
	{"2881","Campogalliano"},
	{"2882","Campolarzo"},
	{"2883","Campolaspierto"},
	{"2884","Campolasta"},
	{"2885","Campolattaro"},
	{"2886","Campolattaro/Innesto Ss625 Della V. Del Tammaro"},
	{"2887","Campolattaro/Innesto Ss88 Dei Due Principati"},
	{"2888","Campoligure"},
	{"2889","Campolongo"},
	{"2890","Campolongo/Innesto Ss355 Val Degano"},
	{"2891","Campolongo/Innesto Ss465"},
	{"2892","Campomarino"},
	{"2893","Campomarino/Innesto Ss16 Adriatica"},
	{"2894","Campomarino/Innesto Ss16 Ter Adriatica"},
	{"2895","Campora Est"},
	{"2896","Campora S.Giovanni"},
	{"2897","Campora S.Giovanni/Innesto Ss18 Dir/Innesto Ss108"},
	{"2898","Campora S.Giovanni/Innesto Ss18 E Ss108"},
	{"2899","Campora S.Giovanni/Innesto Ss18 E Ss18dir"},
	{"2900","Campore"},
	{"2901","Camporeggiano"},
	{"2902","Camporgiano"},
	{"2903","Camporosso"},
	{"2904","Camporovere"},
	{"2905","Camposampiero"},
	{"2906","Camposanto"},
	{"2907","Campotenese"},
	{"2908","Campotosto"},
	{"2909","Campovalano"},
	{"2910","Campoverde"},
	{"2911","Camucia"},
	{"2912","Camurano"},
	{"2913","Canale"},
	{"2914","Canaletto"},
	{"2915","Canalone Di Salerno"},
	{"2916","Canavaccio"},
	{"2917","Canazei"},
	{"2918","Canazei/Innesto Ss48 Delle Dolomiti"},
	{"2919","Canazei/Innesto Ss641 Del Passo Fedaia"},
	{"2920","Cancello"},
	{"2921","Candela"},
	{"2922","Candelarese"},
	{"2923","Candelaro Torrente/Innesto Ss89 Garganica"},
	{"2924","Candia Lomellina"},
	{"2925","Candidoni"},
	{"2926","Canedole"},
	{"2927","Canelli"},
	{"2928","Canetra Di Castel Sant'angelo"},
	{"2929","Canicatti'"},
	{"2930","Canicatti' Nord/Innesto Tangenziale"},
	{"2931","Canicatti' Nord-Innesto Ss122 Agrigentina"},
	{"2932","Canicatti' Sud/Innesto Tangenziale"},
	{"2933","Canicatti Sud-Innesto Ss123 Di Licata"},
	{"2934","Canicatti'/Innesto Ss122 Agrigentina"},
	{"2935","Canicatti'/Innesto Ss123 Di Licata"},
	{"2936","Canicatti'/Innesto Ss190 Delle Solfare"},
	{"2937","Canicatti'/Innesto Ss410 Diramazione Di Naro"},
	{"2938","Canicatti'/Innesto Tangenziale"},
	{"2939","Canino"},
	{"2940","Canne Della Battaglia"},
	{"2941","Cannero"},
	{"2942","Canneto"},
	{"2943","Canneto Sull'oglio"},
	{"2944","Cannitello"},
	{"2945","Cannobbio/Innesto Ss631 Di Valle Cannobina"},
	{"2946","Cannobio/Innesto Ss34 Del Lago Maggiore"},
	{"2947","Canonica D'adda"},
	{"2948","Canosa"},
	{"2949","Canosa Di Puglia/Innesto Ss93 Appulo Lucana"},
	{"2950","Canosa Di Puglia/Innesto Ss97 Delle Murge"},
	{"2951","Canosa Di Puglia/Innesto Ss98 Andriese Coratina"},
	{"2952","Canova/Innesto Ss12 Dell'abetone E Del Brennero"},
	{"2953","Canova/Innesto Ss47 Della Valsugana"},
	{"2954","Canove"},
	{"2955","Casa Cantoniera Baunuxi"},
	{"2956","Casa Cantoniera Pedras De Fogu"},
	{"2957","Casa Cantoniera S. Maria"},
	{"2958","Cantagallo"},
	{"2959","Cantalupa"},
	{"2960","Cantalupo"},
	{"2961","Cantarana"},
	{"2962","Cantoniera Croce Di Romeo"},
	{"2963","Cantoniera Curadureddu"},
	{"2964","Cantoniera Pedredu"},
	{"2965","Cantoniera Pira E' Onni"},
	{"2966","Cantoniera S.Efisio"},
	{"2967","Cantoniera Sanguini Pranu"},
	{"2968","Cantoniera Sos Vaccos"},
	{"2969","Cantoniera Su Grumene"},
	{"2970","Caorso"},
	{"2971","Capaci"},
	{"2972","Capaci-Isola Delle Femmine"},
	{"2973","Capanne"},
	{"2974","Capannelle"},
	{"2975","Capannole"},
	{"2976","Capannoli"},
	{"2977","Capannori"},
	{"2978","Capannuccia"},
	{"2979","Capestrano/Innesto Ss602 Di Forca Di Penne"},
	{"2980","Capistrello"},
	{"2981","Capistrello/Innesto Ss579 Palentina"},
	{"2982","Capistrello/Innesto Ss82 Della Valle Del Liri"},
	{"2983","Capo D'acero Monte"},
	{"2984","Capo Di Ponte"},
	{"2985","Capo D'orlando"},
	{"2986","Capo D'orlando Sant."},
	{"2987","Capo D'orlando/Incrocio Ss113 Sett. Sicula"},
	{"2988","Capo D'orlando/Innesto Ss116 Randazzo C. D'orlando"},
	{"2989","Capodimonte"},
	{"2990","Capostrada/Innesto Ss64/Ss66"},
	{"2991","Cappella Del Carmine/Innesto Ss212 Della V.Fortore"},
	{"2992","Cappella Del Carmine/Innesto Ss625 Valle Tammaro"},
	{"2993","Cappelle"},
	{"2994","Cappelle Sul Tavo"},
	{"2995","Cappelle Sul Tavo/Innesto Ss151 Valle Del Tavo"},
	{"2996","Cappelle Sul Tavo/Innesto Ss16 Bis Adriatica"},
	{"2997","Cappelle/Innesto Ss5 Tiburtina Valeria"},
	{"2998","Cappelle/Innesto Ss578 Salto Cicolana"},
	{"2999","Cappelletta"},
	{"3000","Cappone"},
	{"3001","Capraglia"},
	{"3002","Capranica"},
	{"3003","Caprarico"},
	{"3004","Capriate"},
	{"3005","Capriati Al Volturno"},
	{"3006","Capriglia Irpina"},
	{"3007","Caprigliola/Innesto Ss330 Di Buonviaggio"},
	{"3008","Caprigliola/Innesto Ss62 Della Cisa"},
	{"3009","Caprile"},
	{"3010","Caprile/Innesto Ss203 Agordina"},
	{"3011","Caprile/Innesto Ss563 Di Salesei"},
	{"3012","Caprino Bergamasco"},
	{"3013","Caprioli"},
	{"3014","Capriolo"},
	{"3015","Capua"},
	{"3016","Capua/Innesto Ss264 Del Basso Volturno"},
	{"3017","Capua/Innesto Ss7 Appia"},
	{"3018","Capua/Innesto Ss7 Bis Di Terra Di Lavoro"},
	{"3019","Capurso/Innesto Ss100 Di Gioia Del Colle"},
	{"3020","Capurso/Innesto Ss634 Delle Grotte Orientali"},
	{"3021","Caracoli"},
	{"3022","Caraglio"},
	{"3023","Caragna"},
	{"3024","Caramanico Terme"},
	{"3025","Carasco"},
	{"3026","Carasco/Innesto Ss225 Della Fontanabuona"},
	{"3027","Carasco/Innesto Ss586 Della Valle Dell'aveto"},
	{"3028","Carate Urio"},
	{"3029","Caravaggio"},
	{"3030","Caravini"},
	{"3031","Caravita"},
	{"3032","Carbonara Al Ticino"},
	{"3033","Carbonare/Innesto Ss350 Di Folgaria E Val D'astico"},
	{"3034","Carbonare/Innesto Ss350 Di Folgaria E Di Val D'astico"},
	{"3035","Carbonate"},
	{"3036","Carbonin/Innesto Ss48 Bis Delle Dolomiti"},
	{"3037","Carbonin/Innesto Ss51 Di Alemagna"},
	{"3038","Carcare Vispa Est"},
	{"3039","Carcare/Innesto Ss29 Del Colle Di Cadibona"},
	{"3040","Carcina"},
	{"3041","Cardano/Innesto Ss12 Dell'abetone E Del Brennero"},
	{"3042","Cardano/Innesto Ss241 Val D'ega E P. Costalunga"},
	{"3043","Cardedu"},
	{"3044","Cardito"},
	{"3045","Careri"},
	{"3046","Caresanablot"},
	{"3047","Cargedolo"},
	{"3048","Cariati Marina"},
	{"3049","Cariati Marina/Innesto Ss106 Jonica"},
	{"3050","Cariati Marina/Innesto Ss108 Ter Silana Di Cariati"},
	{"3051","Carife"},
	{"3052","Carignano/Innesto Ss20 Del C. Di Tenda E V. Roja"},
	{"3053","Carignano/Innesto Ss663 Di Saluzzo"},
	{"3054","Carini"},
	{"3055","Carisio"},
	{"3056","Carisolo"},
	{"3057","Carlazzo"},
	{"3058","Carlopoli"},
	{"3059","Carmagnola"},
	{"3060","Carmagnola/Innesto Ss20 Del C. Di Tenda E V. Roja"},
	{"3061","Carmagnola/Innesto Ss661 Delle Langhe"},
	{"3062","Carmignanello"},
	{"3063","Carnia"},
	{"3064","Carnia/Innesto Ss13 Pontebbana"},
	{"3065","Carnia/Innesto Ss52 Carnica"},
	{"3066","Carnica"},
	{"3067","Carolei"},
	{"3068","Carosino"},
	{"3069","Ca'rossa/Innesto Ss240 Di Loppio E Di Val Di Ledro"},
	{"3070","Carovigno"},
	{"3071","Carovilli"},
	{"3072","Carpacco"},
	{"3073","Carpane'"},
	{"3074","Carpanzano"},
	{"3075","Carpen"},
	{"3076","Carpenedolo"},
	{"3077","Carpi"},
	{"3078","Carpi/Innesto Ss413 Romana"},
	{"3079","Carpi/Innesto Ss468 Di Correggio"},
	{"3080","Carpinello"},
	{"3081","Carpinetana"},
	{"3082","Carpineto Romano"},
	{"3083","Carraia"},
	{"3084","Carrara"},
	{"3085","Carrara/Cuccurano"},
	{"3086","Carrodano"},
	{"3087","Carrodano/Innesto Ss1 Aurelia"},
	{"3088","Carru'"},
	{"3089","Carsoli"},
	{"3090","Carsoli/Innesto Ss5 Quater Tiburtina"},
	{"3091","Carsoli/Innesto Ss5 Tiburtina Valeria"},
	{"3092","Carsoli-Oricola"},
	{"3093","Cartabbia"},
	{"3094","Cartignano"},
	{"3095","Cartolano P./Innesto Ss18 Racc"},
	{"3096","Cartolano P./Innesto Ss18 Tirrena Inferiore"},
	{"3097","Carugate"},
	{"3098","Casa Aguglia"},
	{"3099","Casa Cantoniera Acquacotta/Incrocio Ss196 Di Villacidro"},
	{"3100","Casa Cantoniera Dell'acquacotta/Incrocio Ss293 Di Giba"},
	{"3101","Casa Cantoniera Di Bardosu"},
	{"3102","Casa Cantoniera Di Maida/Innesto Ss19 Diramazione Delle Calabrie"},
	{"3103","Casa Cantoniera Di Marrubiu/Innesto Ss126 Sud Occ. Sarda"},
	{"3104","Casa Cantoniera Di Onferi/Innesto Ss128 Centrale Sarda"},
	{"3105","Casa Cantoniera Di Oniferi/Innesto Ss129 TraSvincolo Le Sarda"},
	{"3106","Casa Cantoniera Di Ortuabis/Innesto Ss295 Di Aritzo"},
	{"3107","Casa Cantoniera Di Pianu Ladu"},
	{"3108","Casa Cantoniera Di S.Lucia/Innesto Ss198 Seui E Lanusei"},
	{"3109","Casa Cantoniera Di Tirso/Innesto Ss128 Bis Centr. Sarda"},
	{"3110","Casa Cantoniera Di Tirso/Innesto Ss129 TraSvincolo Le Sarda"},
	{"3111","Casa Cantoniera Montagna/Innesto Ss383 Di Mandatoriccio"},
	{"3112","Casa Cantoniera Ortuabis/Innesto Ss128 Centrale Sarda"},
	{"3113","Casa Cantoniera S.Lucia/Innesto Ss128 Centrale Sarda"},
	{"3114","Casa Cantoniera Sa Codina/Innesto Ss128 Centrale Sarda"},
	{"3115","Casa CantonieraMaida/Innesto Ss181 Maida E Squillace"},
	{"3116","Casa Canton. Di Sa Codina/Innesto Ss295 Di Aritzo"},
	{"3117","Casa Cantoniera Carralzu"},
	{"3118","Casa Cantoniera Di Marrubiu/Innesto Ss131"},
	{"3119","Casa Cantoniera Di Pianu"},
	{"3120","Casa Cantoniera Marta/Innesto Ss537 Di Ghilarza"},
	{"3121","Casa Cantoniera Montagna/Innesto Ss108 Ter"},
	{"3122","Casa Castalda"},
	{"3123","Casa Cerreto"},
	{"3124","Casa Del Marchese"},
	{"3125","Casa Forestale"},
	{"3126","Casa Licciardi"},
	{"3127","Casa Lovino/Innesto Ss170 Di Castel Del Monte"},
	{"3128","Casa Mascia/Innesto Ss376 Dei Tre Titoli"},
	{"3129","Casa Mascia/Innesto Ss480 Di Ururi"},
	{"3130","Casa Matti"},
	{"3131","Casa S.Bartolo/Innesto Ss115 Sud Occ. Sicula"},
	{"3132","Casa S.Bartolo/Innesto Ss624 Palermo-Sciacca"},
	{"3133","Casa Santa Di Erice"},
	{"3134","Casacalenda"},
	{"3135","Casagiove"},
	{"3136","Casaglia"},
	{"3137","Casal Bernocchi"},
	{"3138","Casal Velino Sud/Innesto Ss267 Del Cilento"},
	{"3139","Casal Velino/Innesto Ss447 Di Palinuro"},
	{"3140","Casalbellotto"},
	{"3141","Casalbordino"},
	{"3142","Casalborgone"},
	{"3143","Casalbuono"},
	{"3144","Casalbuttano Ed Uniti"},
	{"3145","Casale"},
	{"3146","Casale Monferrato"},
	{"3147","Casale Monferrato Nord"},
	{"3148","Casale Monferrato Sud"},
	{"3149","Casale Monferrato/Innesto Ss31 Bis Del Monferrato"},
	{"3150","Casale Monferrato/Innesto Ss31 Del Monferrato"},
	{"3151","Casale Monferrato/Innesto Ss457 Di Moncalvo"},
	{"3152","Casale Monferrato/Innesto Ss596 Diramazione Dei Cairoli"},
	{"3153","Casale Ponte Minchione"},
	{"3154","Casalecchio"},
	{"3155","Casalecchio Di Reno"},
	{"3156","Casalecchio Di Reno/Tangenziale Di Bologna"},
	{"3157","Casalgrande"},
	{"3158","Casalgrasso"},
	{"3159","Casalino"},
	{"3160","Casalmaggiore"},
	{"3161","Casalmaggiore/Innesto Ss343 Asolana E Ss420"},
	{"3162","Casalmaggiore/Innesto Ss343 E Ss358"},
	{"3163","Casalmaggiore/Innesto Ss358 Di Castelnovo E Ss420"},
	{"3164","Casalmorano"},
	{"3165","Casalmoro"},
	{"3166","Casalnuovo Di Napoli"},
	{"3167","Casalonga"},
	{"3168","Casalpusterlengo"},
	{"3169","Casalpusterlengo/Incrocio Ss9 Emilia"},
	{"3170","Casalpusterlengo/Innesto Ss234 Codognese"},
	{"3171","Casalzuigno"},
	{"3172","Casamaina"},
	{"3173","Casamassima"},
	{"3174","Casamassima/Innesto Ss100 Di Gioia Del Colle"},
	{"3175","Casamicciola Terme"},
	{"3176","Casanuova"},
	{"3177","Casapulla"},
	{"3178","Casarano"},
	{"3179","Casarile"},
	{"3180","Casarsa Della Delizia"},
	{"3181","Casarza"},
	{"3182","Casasola"},
	{"3183","Casateia"},
	{"3184","Casauria-Torre De' Passeri"},
	{"3185","Casavecchia"},
	{"3186","Casazza"},
	{"3187","Cascano"},
	{"3188","Cascia/Innesto Ss320 Di Cascia"},
	{"3189","Cascia/Innesto Ss471 Di Leonessa"},
	{"3190","Casciago"},
	{"3191","Cascina"},
	{"3192","Cascina D.Barco/Innesto Ss510 Sebina Orientale"},
	{"3193","Cascina De' Santi"},
	{"3194","Cascina Donna/Innesto Ss230 Di Masazza"},
	{"3195","Cascina Donna/Innesto Ss232 Panoramica Zegna"},
	{"3196","Cascina Gobba"},
	{"3197","Cascina Olona"},
	{"3198","Case Del Conte"},
	{"3199","Case Di Nava"},
	{"3200","Case Rosse A Portovenere"},
	{"3201","Case Sant'antuono"},
	{"3202","Casecoppi"},
	{"3203","Casei Gerola"},
	{"3204","Casella"},
	{"3205","Caselle"},
	{"3206","Caselle - Allacciamento Tangenziale Nord Di Torino"},
	{"3207","Caselle Di Nogara"},
	{"3208","Caselle In Pittari"},
	{"3209","Caselle Torinese"},
	{"3210","Casello Albenga A10 Genova-Ventimiglia"},
	{"3211","Casello Albisola A10 Genova-Ventimiglia"},
	{"3212","Casello Alessandria Ovest A21 To-Pc-Bs"},
	{"3213","Casello Altare A6 Torino-Savona"},
	{"3214","Casello Anagni Fiuggi A1 Milano-Napoli"},
	{"3215","Casello Ancona Nord A14 Bo-Ta"},
	{"3216","Casello Ancona Sud A14 Bologna-Taranto"},
	{"3217","Casello Andria Barletta A14 Bologna-Taranto"},
	{"3218","Casello Asti Est A21 To-Pc-Bs/Innesto Tangenziale Asti"},
	{"3219","Casello Asti Ovest A21 Torino-Piacenza-Brescia"},
	{"3220","Casello Aulla A15 Parma-La Spezia"},
	{"3221","Casello Avellino Est A16 Napoli-Canosa"},
	{"3222","Casello Avellino Ovest A16 Napoli-Canosa"},
	{"3223","Casello Baiano A16 Napoli-Canosa"},
	{"3224","Casello Barcellona A20 Messina-Palermo"},
	{"3225","Casello Bari Sud A14 Bologna-Taranto"},
	{"3226","Casello Battipaglia A3 Salerno-Reggio C."},
	{"3227","Casello Bergamo A4 To-Ts/Innesto Ss671 Val Seriana"},
	{"3228","Casello Bo B. Panigale A14/Ramo Verde Tangenziale Bo"},
	{"3229","Casello Boara A13 Bologna-Padova"},
	{"3230","Casello Bolzano Nord A22 Brennero-Modena"},
	{"3231","Casello Borghetto-Brugnato A12 Ge-Rosignano"},
	{"3232","Casello Borgo D'ale A4 Torino-Trieste"},
	{"3233","Casello Brescia C. A21/Innesto Ss11 Padana Sup"},
	{"3234","Casello Brescia Centro A21 To-Pc-Bs"},
	{"3235","Casello Bressanone A22 Brennero-Mo/Innesto Ss12"},
	{"3236","Casello Bressanone A22 Brennero-Mo/Ss49 Bis"},
	{"3237","Casello Broni Stradella A21 To-Pc-Bs"},
	{"3238","Casello Busalla A7 Milano-Genova"},
	{"3239","Casello Bussi A25 Torano-Pescara"},
	{"3240","Casello Busto Arsizio A8 Milano-Varese"},
	{"3241","Casello Caianello A1 Milano-Napoli"},
	{"3242","Casello Canosa A14 Bologna-Taranto"},
	{"3243","Casello Caorso A21 Torino-Piacenza-Brescia"},
	{"3244","Casello Capannori A11 Firenze-Pisa Nord"},
	{"3245","Casello Capua A1 Milano-Napoli"},
	{"3246","Casello Carini A29 Palermo-Mazara Del Vallo"},
	{"3247","Casello Carnia A23 Palmanova-Tarvisio"},
	{"3248","Casello Carpi A22 Brennero-Modena"},
	{"3249","Casello Carsoli A24 Roma-Teramo"},
	{"3250","Casello Casalpusterlengo A1 Milano-Napoli"},
	{"3251","Casello Caserta Nord A1 Milano-Napoli"},
	{"3252","Casello Caserta Sud A1 Mi-Na/Innesto Ss265"},
	{"3253","Casello Caserta Sud A1 Mi-Na/Innesto Ss87"},
	{"3254","Casello Cassino A1 Milano-Napoli"},
	{"3255","Casello Casteggio A21 To-Pc-Bs"},
	{"3256","Casello Castel S.Giovanni A21 To-Pc-Bs"},
	{"3257","Casello Castellammare Di Stabia A3 Na-Sa"},
	{"3258","Casello Castellanza A8 Milano-Varese"},
	{"3259","Casello Castelvetro A21 To-Pc-Bs"},
	{"3260","Casello Cattolica A14 Bologna-Taranto"},
	{"3261","Casello Celano A25 Torano-Pescara"},
	{"3262","Casello Celle Ligure A10 Genova-Ventimiglia"},
	{"3263","Casello Ceprano A1 Milano-Napoli"},
	{"3264","Casello Cerignola Est A14 Bologna-Taranto"},
	{"3265","Casello Cerignola Ovest A16 Napoli-Canosa"},
	{"3266","Casello Cesena A14 Bologna-Taranto"},
	{"3267","Casello Ceva A6 Torino-Savona"},
	{"3268","Casello Chianocco A32 Torino-Bardonecchia"},
	{"3269","Casello Chiusa Valgardena A22 Brennero-Modena"},
	{"3270","Casello Chiusi Chianciano A1 Milano - Napoli"},
	{"3271","Casello Chiusi Chianciano A1 Milano-Napoli"},
	{"3272","Casello Chivasso A4 Torino-Trieste"},
	{"3273","Casello Como Monte Olimpino A9 Lainate-Chiasso"},
	{"3274","Casello Como Sud A9 Laiante-Chiasso"},
	{"3275","Casello Como Sud A9 Lainate-Chiasso"},
	{"3276","Casello Contursi A3 Salerno-Reggio C."},
	{"3277","Casello Cosenza Nord A3 Salerno-Reggio C."},
	{"3278","Casello Cremona A21 Torino-Piacenza-Brescia"},
	{"3279","Casello Dalmine A4 Torino-Trieste/Innesto Ss671"},
	{"3280","Casello Desenzano A4 Torino-Trieste"},
	{"3281","Casello Di Carrodano A12 Genova-Rosignano"},
	{"3282","Casello Di Falerna A3 Salerno-Reggio C."},
	{"3283","Casello Di Finale Ligure A10 Genova-Ventimiglia"},
	{"3284","Casello Di S.Giorgio Raccordo Per Benevento"},
	{"3285","Casello Di Staggia/Raccordo Firenze-Siena"},
	{"3286","Casello Egna Ora A22 Brennero-Modena"},
	{"3287","Casello Fabro A1 Milano-Napoli"},
	{"3288","Casello Fadalto A27 Mestre-Belluno"},
	{"3289","Casello Fiano Romano Diram. Roma Nord A1 Mi-Na"},
	{"3290","Casello Fidenza A1 Milano - Napoli"},
	{"3291","Casello Finale Ligure A10 Genova-Ventimiglia"},
	{"3292","Casello Fino Mornasco A9 Lainate-Chiasso"},
	{"3293","Casello Fiorenzuola A1 Mi-Na E A/21 Dir"},
	{"3294","Casello Firenze Certosa A1 Milano-Napoli"},
	{"3295","Casello Firenze Sud A1 Milano-Napoli"},
	{"3296","Casello Forli' A14 Bologna-Taranto"},
	{"3297","Casello Fornovo A15 Parma-La Spezia"},
	{"3298","Casello Frosinone A1 Milano-Napoli"},
	{"3299","Casello Gallarate A8 Milano-Varese"},
	{"3300","Casello Gallitello A29 Palermo-Mazara Del Vallo"},
	{"3301","Casello Ge-Bolzaneto A7 Milano-Genova"},
	{"3302","Casello Genova Pegli A10 Genova-Ventimiglia"},
	{"3303","Casello Giardini Naxos A18 Messina-Catania"},
	{"3304","Casello Gioia Del Colle A14 Bologna-Taranto"},
	{"3305","Casello Greggio A4 Torino-Trieste"},
	{"3306","Casello Grisignano A4 Torino-Trieste"},
	{"3307","Casello Gropello Cairoli A7 Milano-Genova"},
	{"3308","Casello Grottaminarda A16 Napoli-Canosa"},
	{"3309","Casello Imola A14 Bologna-Taranto"},
	{"3310","Casello Imperia Est A10 Genova-Ventimiglia"},
	{"3311","Casello Incisa A1 Milano-Napoli"},
	{"3312","Casello Isola Del Cantone A7 Milano-Genova"},
	{"3313",""},
	{"3314","Casello La Spezia A15 Parma - La Spezia"},
	{"3315","Casello Lacedonia A16 Napoli-Canosa"},
	{"3316","Casello Lago Varese A8 Mi-Va/Innesto Ss341"},
	{"3317","Casello Lago Varese A8 Mi-Va/Innesto Ss431 Di Velate"},
	{"3318","Casello L'aquila Ovest A24 Rm-Te/Innesto Ss17"},
	{"3319","Casello L'aquila Ovest A24 Rm-Te/Innesto Ss80"},
	{"3320","Casello Latisana A4 Torino-Trieste"},
	{"3321","Casello Lodi A1 Milano-Napoli"},
	{"3322","Casello Loreto Recanati A14 Bologna-Taranto"},
	{"3323","Casello Lucca A11 Fi-Pi/Innesto Diram.Lucca Viareggio"},
	{"3324","Casello Macerata-Civitanova A14 Bo-Ta"},
	{"3325","Casello Magliano De' Marsi A25 Torano-Pescara"},
	{"3326","Casello Magliano Sabina A1 Milano-Napoli"},
	{"3327","Casello Mandela A24 Roma-Teramo"},
	{"3328","Casello Mantova Nord A22 Brennero-Modena"},
	{"3329","Casello Mantova Sud A22 Brennero-Modena"},
	{"3330","Casello Marene A6 Torino-Savona"},
	{"3331","Casello Masone A26 Genova V.-Gravellona T."},
	{"3332","Casello Mazara Del Vallo A29 Pa-Mazara Del Vallo"},
	{"3333","Casello Me S. Tremestieri A18 Me-Ct/A20 Me-Pa"},
	{"3334","Casello Mestre Est A4 Torino-Trieste"},
	{"3335","Casello Millesimo A6 Torino-Savona"},
	{"3336","Casello Modena Nord A1"},
	{"3337","Casello Modena Sud A1 Milano-Napoli"},
	{"3338","Casello Mondovi' A6 Torino-Savona"},
	{"3339","Casello Montebello A4 Torino-Trieste"},
	{"3340","Casello Montecatini Terme A11 Firenze-Pisa Nord"},
	{"3341","Casello Montecchio A4 Torino-Trieste"},
	{"3342","Casello Montezemolo A6 Torino-Savona"},
	{"3343",""},
	{"3344","Casello Mottola Castellaneta A14 Bo-Ta"},
	{"3345","Casello Novara A4 Torino-Trieste"},
	{"3346",""},
	{"3347","Casello Orte A1 Mi-Na/Innesto Raccordo Orte-Viterbo"},
	{"3348","Casello Orvieto A1 Milano-Napoli"},
	{"3349","Casello Padova Ovest A4 To-Ts/Innesto Ss47 Racc"},
	{"3350","Casello Palazzolo A4 Torino-Trieste"},
	{"3351","Casello Palmanova A4 Torino-Trieste"},
	{"3352","Casello Parma A1 Milano-Napoli"},
	{"3353","Casello Parma Ovest A15 Parma - La Spezia"},
	{"3354","Casello Pero A4 Torino-Trieste"},
	{"3355","Casello Pesaro Urbino A14 Bologna-Taranto"},
	{"3356","Casello Pescara Nord A14 Bologna-Taranto"},
	{"3357","Casello Pescara Ovest A14 Bologna-Taranto"},
	{"3358","Casello Pescara Villanova A25 Torano-Pescara"},
	{"3359","Casello Peschiera A4 Torino-Trieste"},
	{"3360","Casello Peschiera Del Garda A4 Torino-Trieste"},
	{"3361","Casello Petina A3 Salerno-Reggio C."},
	{"3362","Casello Piacenza Nord A1 Milano - Napoli"},
	{"3363","Casello Piacenza Ovest A21 To-Pc-Bs"},
	{"3364","Casello Piacenza Sud A1 Mi-Na"},
	{"3365","Casello Piacenza Sud A1 Mi-Na/Innesto Raccordo Di Pc"},
	{"3366","Casello Pietra Ligure A10 Ge-Ventimiglia"},
	{"3367","Casello Pistoia A11 Firenze-Pisa Nord"},
	{"3368","Casello Pomigliano D'arco A16 Napoli-Canosa"},
	{"3369",""},
	{"3370","Casello Pontecagnano A3 Salerno-Reggio C."},
	{"3371","Casello Pontecorvo A1 Milano-Napoli"},
	{"3372","Casello Porto D'ascoli A14 Bo-Ta"},
	{"3373","Casello Prato Est A11 Firenze-Pisa Nord"},
	{"3374",""},
	{"3375","Casello Recco A12 Genova-Rosignano"},
	{"3376","Casello Redipuglia A4 Torino-Trieste"},
	{"3377","Casello Riccione A14 Bologna-Taranto"},
	{"3378","Casello Rimini Sud A14 Bologna-Taranto"},
	{"3379","Casello Rioveggio A1 Milano-Napoli"},
	{"3380","Casello Rocca Capri Leone A20 Messina-Palermo"},
	{"3381","Casello Roccalumera A18 Messina-Catania"},
	{"3382","Casello Ronco Scrivia A7 Milano-Genova"},
	{"3383","Casello Rondissone A4 Torino-Trieste"},
	{"3384","Casello Roseto A14 Bologna-Taranto"},
	{"3385","Casello Rovereto Nord A22 Brennero-Modena"},
	{"3386","Casello Rovereto Sud A22 Brennero-Modena"},
	{"3387","Casello S.Benedetto A14 Bo-Ta-Innesto Raccordo A14-Ap"},
	{"3388","Casello S.Cesareo Diramazione Roma Sud A1 Mi-Na"},
	{"3389","Casello S.Michele A22 Brennero-Modena"},
	{"3390","Casello S.Severo A14 Bologna-Taranto"},
	{"3391","Casello S.Vittore A1 Milano-Napoli"},
	{"3392","Casello Santena A21 Torino-Piacenza-Brescia"},
	{"3393","Casello Saronno A9 Lainate-Chiasso"},
	{"3394","Casello Sasso Marconi A1 Milano-Napoli/Ss64"},
	{"3395","Casello Savona Vado A6 Torino-Savona"},
	{"3396","Casello Savoulx A32 Torino-Bardonecchia"},
	{"3397","Casello Scafa/Alanno A25 Torano-Pescara"},
	{"3398","Casello Senigallia A14 Bologna-Taranto"},
	{"3399","Casello Seriate A4 Torino-Trieste"},
	{"3400","Casello Serravalle Scrivia A7 Milano-Genova"},
	{"3401","Casello Settimo Torinese A4 Torino-Trieste"},
	{"3402","Casello Sistiana A4 Torino-Trieste"},
	{"3403","Casello Soave A4 Torino-Trieste"},
	{"3404",""},
	{"3405","Casello Tagliacozzo A24 Roma-Teramo"},
	{"3406","Casello Taormina Nord A18 Messina-Catania"},
	{"3407","Casello Tarvisio Sud A23 Palmanova-Tarvisio"},
	{"3408","Casello Teramo-Giulianova A14 Bologna-Taranto"},
	{"3409","Casello Termoli A14 Bologna-Taranto"},
	{"3410","Casello Tornimparte A24 Roma-Teramo"},
	{"3411","Casello Torre De'passeri A25 Torano-Pescara"},
	{"3412","Casello Tortona A21 To-Pc-Bs/A7 Mi-Ge"},
	{"3413","Casello Tortona A7 Milano-Genova"},
	{"3414","Casello Trani A14 Bologna-Taranto"},
	{"3415","Casello Udine A23 Palmanova-Tarvisio"},
	{"3416","Casello Udine Nord A23 Palmanova-Tarvisio"},
	{"3417","Casello Udine Sud A23 Palmanova-Tarvisio"},
	{"3418","Casello Valdarno A1 Milano-Napoli"},
	{"3419","Casello Vallata A16 Napoli-Canosa"},
	{"3420","Casello Valle Del Salto A24 Roma-Teramo"},
	{"3421","Casello Valmontone A1 Milano-Napoli"},
	{"3422","Casello Varazze A10 Genova-Ventimiglia"},
	{"3423","Casello Varese A8 Mi-Va/Innesto Ss233 Varesina"},
	{"3424","Casello Vasto Nord A14 Bologna-Taranto"},
	{"3425","Casello Venaus A32 Torino-Bardonecchia"},
	{"3426","Casello Vercelli A26 Ge-Gravellona Toce"},
	{"3427","Casello Verona N. A22 Brennero-Mo/Innesto Ss11"},
	{"3428","Casello Verona Nord A22 Brennero-Modena"},
	{"3429",""},
	{"3430","Casello Vicenza Est A4 Torino-Trieste"},
	{"3431","Casello Vicenza Ovest A4 Torino-Trieste"},
	{"3432","Casello Vignole Arquata A7 Milano-Genova"},
	{"3433","Casello Villabate A19 Pa-Ct/Innesto Tangenziale Di Pa"},
	{"3434","Casello Vipiteno A22 Brennero-Modena"},
	{"3435","Casello Vittorio Veneto Nord A27 Mestre-Belluno"},
	{"3436","Casello Zucco A29 Palermo-Mazara Del Vallo"},
	{"3437","Casemurate"},
	{"3438","Casemurate/Incrocio Ss254 Di Cervia"},
	{"3439","Casemurate/Incrocio Ss71 Umbro Casentin. Romag."},
	{"3440","Casenove"},
	{"3441","Casenove/Innesto Ss319 Sellanese"},
	{"3442","Casenove/Innesto Ss77 Della Val Di Chienti"},
	{"3443","Casenuove"},
	{"3444","Casere"},
	{"3445","Caserta"},
	{"3446","Caserta Nord"},
	{"3447","Caserta Sud"},
	{"3448","Caserta/Incrocio Ss7 Appia"},
	{"3449","Caserta/Incrocio Ss87 Sannitica"},
	{"3450","Caserta-Salerno"},
	{"3451","Casetta Per Taverne D'a.-Pianelle"},
	{"3452","Casette Di Ospedaletto"},
	{"3453","Casette Di Rieti"},
	{"3454","Casilina"},
	{"3455","Casina"},
	{"3456","Casinalbo"},
	{"3457","Casine"},
	{"3458","Casini"},
	{"3459","Casino Dei Turchi"},
	{"3460","Casino Di Terra"},
	{"3461",""},
	{"3462","Casino Gallo/Innesto Ss19 Delle Calabrie"},
	{"3463","Casino Gallo/Innesto Ss534"},
	{"3464","Casirate D'adda"},
	{"3465","Casola"},
	{"3466","Casola In Lunigiana"},
	{"3467","Casola Valsenio"},
	{"3468","Casolana-Riolese"},
	{"3469","Casoli"},
	{"3470","Casone Di Profecchia"},
	{"3471","Casoni"},
	{"3472","Casoria"},
	{"3473","Casoria/Incrocio Ss7 Bis Di Terra Di Lavoro"},
	{"3474","Casoria/Innesto Ss87 Sannitica"},
	{"3475","Cassano D'adda"},
	{"3476","Cassano Delle Murge"},
	{"3477","Cassano Irpino"},
	{"3478","Cassibile"},
	{"3479","Cassina De' Pecchi"},
	{"3480","Cassine"},
	{"3481","Cassino"},
	{"3482","Cassino Scanasio"},
	{"3483","Cassino/Innesto Ss149 Di Montecassino"},
	{"3484","Cassino/Innesto Ss509 Di Forca D'acero"},
	{"3485","Cassino/Innesto Ss6 Casilina"},
	{"3486","Cassino/Innesto Ss6 Casilina/Innesto Ssv Sora-Cassino"},
	{"3487","Cassino/Innesto Ss630 Ausonia"},
	{"3488","Cassolo"},
	{"3489","Cassone Di Malcesine"},
	{"3490","Cast. Mes. Raimondo/Innesto Ss81 Piceno Aprutina"},
	{"3491","Castagna"},
	{"3492","Castagneto Carducci"},
	{"3493","Castagno"},
	{"3494","Castagnolo"},
	{"3495","Castagnone"},
	{"3496","Castagnone/Innesto Ss455 Di Pontestura"},
	{"3497","Castagnone/Innesto Ss590 Del Val Cerrina"},
	{"3498","Castano Primo"},
	{"3499","Castasegna/Confine Con La Svizzera"},
	{"3500","Castefiorentino"},
	{"3501","Casteggio"},
	{"3502","Casteggio/Innesto Ss10 Padana Inferiore"},
	{"3503","Casteggio/Innesto Ss35 Dei Giovi"},
	{"3504","Castel Baronia"},
	{"3505","Castel Bentivoglio"},
	{"3506","Castel Bolognese"},
	{"3507","Castel Bolognese/Innesto Ss306 Casolana Riolese"},
	{"3508","Castel Bolognese/Innesto Ss9 Emilia"},
	{"3509","Castel D'aiano"},
	{"3510","Castel D'ario"},
	{"3511","Castel Del Bosco"},
	{"3512","Castel Del Giudice"},
	{"3513","Castel Del Monte"},
	{"3514","Castel Del Monte/Innesto Ss170 Di Castel Del Monte"},
	{"3515","Castel Del Piano"},
	{"3516","Castel Del Rio"},
	{"3517","Castel Di Tusa"},
	{"3518","Castel Frentano"},
	{"3519","Castel Gandolfo"},
	{"3520","Castel Gandolfo/Innesto Ss140 Del Lago Di Albano"},
	{"3521","Castel Gandolfo/Innesto Ss216 Maremmana Iii"},
	{"3522","Castel Gandolfo/Innesto Ss297 Del Lago Olimpico"},
	{"3523","Castel Giorgio"},
	{"3524","Castel Lagopesole"},
	{"3525","Castel Madama"},
	{"3526","Castel Ruggero"},
	{"3527","Castel S. Giorgio"},
	{"3528",""},
	{"3529","Castel S.Gimignano"},
	{"3530","Castel S.Giorgio"},
	{"3531","Castel S.Giovanni"},
	{"3532","Castel S.Giovanni/Incrocio Ss10 Padana Inferiore"},
	{"3533","Castel S.Giovanni/Incrocio Ss412 Della Val Tidone"},
	{"3534","Castel S.Lorenzo"},
	{"3535","Castel S.Pietro"},
	{"3536","Castel Varco-Laimburg Est"},
	{"3537","Castel Varco-Laimburg Ovest"},
	{"3538","Castel Volturno"},
	{"3539","Castel Volturno/Innesto Ss264 Del Basso Volturno"},
	{"3540","Castel Volturno/Innesto Ss7 Quater Domitiana"},
	{"3541","Castelbello"},
	{"3542","Castelbosco Di Sotto"},
	{"3543","Castelbuono"},
	{"3544","Casteldaccia"},
	{"3545","Castelfranci"},
	{"3546","Castelfranco Emilia"},
	{"3547","Castelfranco V./Incrocio Ss245 Castellana"},
	{"3548","Castelfranco V./Innesto Ss667 Di Caerano"},
	{"3549","Castelfranco Veneto"},
	{"3550","Castelfranco Veneto/Incrocio Ss53 Postumia"},
	{"3551","Castelfranco Veneto/Innesto Ss53 Postumia"},
	{"3552","Castelgrande"},
	{"3553","Castelgrande/Incrocio Ss381"},
	{"3554","Castelgrande/Incrocio Ss7 Appia"},
	{"3555","Castell'alfero"},
	{"3556","Castellamm. Di Stabia/Innesto Ss145 Sorrentina"},
	{"3557","Castellammare Del Golfo"},
	{"3558","Castellammare Di Stabia"},
	{"3559","Castellammare/Innesto Ss145 Diramazione Sorrentina"},
	{"3560","Castellammare/Innesto Ss145 Sorrentina"},
	{"3561","Castellammare/Innesto Ss366 Di Agerola"},
	{"3562","Castellamonte"},
	{"3563","Castellana"},
	{"3564","Castellana Grotte"},
	{"3565","Castellana Grotte/Innesto Ss377 Delle Grotte"},
	{"3566","Castellana Grotte/Innesto Ss634 Delle Grotte Or."},
	{"3567","Castellana Sicula"},
	{"3568","Castellana Sicula/Innesto Ss120 Dell'etna E Madonie"},
	{"3569","Castellana Sicula/Innesto Ss643 Di Polizzi"},
	{"3570","Castellaneta"},
	{"3571","Castellanza"},
	{"3572","Castellarano"},
	{"3573","Castellaro"},
	{"3574","Castellaro Nord"},
	{"3575","Castelletto Di Brenzone"},
	{"3576","Castelletto Ticino"},
	{"3577","Castellina In Chianti/Innesto Ss222 Chiantigiana"},
	{"3578","Castellina In Chianti/Innesto Ss429 Di Val D'elsa"},
	{"3579","Castellino Nuovo"},
	{"3580","Castelliri"},
	{"3581","Castello Annone"},
	{"3582","Castello D'agogna/Innesto Ss596 Dei Cairoli E Ss494"},
	{"3583","Castello D'agogna/Innesto Ss596 Diramazione E Ss494"},
	{"3584","Castello D'agogna/Innesto Ss596 E Ss596 Dir"},
	{"3585","Castello Del Lago"},
	{"3586","Castello Del Matese"},
	{"3587","Castello Di Fiemme/Innesto Ss612 Della V. Di Cembra"},
	{"3588","Castello Di Fiemme/Innesto Ss612 Dir"},
	{"3589","Castello Di Godego"},
	{"3590","Castello Di Molina/Innesto Ss48 Delle Dolomiti"},
	{"3591","Castello Di Serravalle"},
	{"3592","Castello Molina/Innesto Ss612 Della Val Di Cembra"},
	{"3593","Castello Molina/Innesto Ss612 Diramazione Val Di Cembra"},
	{"3594","Castello Rancia"},
	{"3595","Castello Rancia/Innesto Raccordo Di P.To Civitanova"},
	{"3596","Castello S.Uberto"},
	{"3597","Castello-Molina/Innesto Ss48 Delle Dolomiti"},
	{"3598","Castellonorato"},
	{"3599","Castellucchio"},
	{"3600","Castelluccio Dei Sauri"},
	{"3601","Castelluccio Inferiore"},
	{"3602","Castell'umberto"},
	{"3603","Castelmartini"},
	{"3604","Castelmassa"},
	{"3605","Castelmassimo"},
	{"3606","Castelmauro"},
	{"3607","Castelnovo Di Sotto"},
	{"3608","Castelnuovo"},
	{"3609","Castelnuovo Bariano"},
	{"3610","Castelnuovo Berardenga"},
	{"3611","Castelnuovo Di Porto"},
	{"3612","Castelnuovo Di Verona"},
	{"3613","Castelnuovo Garf./Innesto Ss324 Passo Delle Radici"},
	{"3614","Castelnuovo Garfagnana"},
	{"3615","Castelnuovo Garfagnana/Innesto Ss445 Garfagnana"},
	{"3616","Castelnuovo M./Innesto Ss513 Di Val D'enza"},
	{"3617","Castelnuovo Ne' Monti/Innesto Ss63 Del Val. Cerreto"},
	{"3618","Castelnuovo Scrivia"},
	{"3619","Castelnuovo St./Innesto Ss18 Tirrena Inferiore"},
	{"3620","Castelnuovo Val Di Cecina"},
	{"3621","Castelnuovo Vomano"},
	{"3622","Castelpoggio"},
	{"3623","Castelraimondo/Innesto Ss256 Muccese"},
	{"3624","Castelraimondo/Innesto Ss361 Semptempedana"},
	{"3625","Castelrosso/Innesto Ss31 Bis Del Monferrato"},
	{"3626","Castelrosso/Torassi"},
	{"3627","Castelsardo Est"},
	{"3628","Castelsardo Nord"},
	{"3629","Castelsardo/Innesto Ss134 Di Castelsardo"},
	{"3630","Castelsardo/Innesto Ss200 Dell'anglona"},
	{"3631","Castelvecchio"},
	{"3632","Castelvecchio Subequo"},
	{"3633","Castelvetere Sul Calore/Innesto Ss400 Dir"},
	{"3634","Castelvetere/Innesto Ss400 Di Castelvetere"},
	{"3635","Castelvetrano"},
	{"3636","Castelvetrano/Innesto Ss115 Sud Occ.Le Sicula"},
	{"3637","Castelvetrano/Innesto Ss119 Di Gibellina"},
	{"3638","Castelvetro"},
	{"3639","Castelvetro Piacentino"},
	{"3640","Castenaso"},
	{"3641","Castenedolo"},
	{"3642","Castiglion Del Lago"},
	{"3643","Castiglion Fiorentino"},
	{"3644","Castiglioncello"},
	{"3645","Castiglione Chiavarese"},
	{"3646","Castiglione D. Lago/Innesto Ss71 Umbro Casentinese"},
	{"3647","Castiglione D'adda"},
	{"3648","Castiglione Dei Pepoli"},
	{"3649","Castiglione Della Pescaia"},
	{"3650","Castiglione Delle Stiviere"},
	{"3651","Castiglione Delle Stiviere/Innesto Ss236 Goitese"},
	{"3652","Castiglione Delle Stiviere/Innesto Ss567"},
	{"3653","Castiglione Di Cervia"},
	{"3654","Castiglione Di Garfagnana"},
	{"3655","Castiglione D'orcia"},
	{"3656","Castiglione D'ossola"},
	{"3657","Castiglione Lago/Innesto Ss454 Di Pozzuolo"},
	{"3658","Castiglione Lago/Svincolo Raccordo Bettolle-Pg"},
	{"3659","Castiglione Messer Marino"},
	{"3660","Castiglione Messer Raimondo"},
	{"3661","Castiglione Messer Raimondo/Innesto Ss365 Bisenti"},
	{"3662","Castiglione Olona"},
	{"3663","Castiglione Torinese"},
	{"3664","Castino"},
	{"3665","Castione"},
	{"3666","Castione Marchesi"},
	{"3667","Castions Di Strada"},
	{"3668","Castrense"},
	{"3669","Castro"},
	{"3670","Castrocaro Terme"},
	{"3671","Castrofilippo"},
	{"3672","Castropignano/Innesto Ss618 Molesana"},
	{"3673","Castropignano/Innesto Ss647 Fondo V. Del Biferno"},
	{"3674","Castroreale Terme"},
	{"3675","Castrovillari/Innesto Ss105 Di Castrovillari"},
	{"3676","Castrovillari/Innesto Ss19 Delle Calabrie"},
	{"3677","Casumaro"},
	{"3678","Cataeggio"},
	{"3679","Catanese"},
	{"3680","Catania"},
	{"3681","Catania - Via V.Giuffrida"},
	{"3682","Catania Centro"},
	{"3683","Catania Centro-S.Gregorio-A18 Diramazione"},
	{"3684","Catania Nord"},
	{"3685","Catania Sud"},
	{"3686","Catania Sud-Allacciamento A19 Palermo-Catania"},
	{"3687","Catania/Innesto Ss114 Orientale Sicula"},
	{"3688","Catania/Innesto Ss121 Catanese"},
	{"3689","Catania/Innesto Ss192 Della Valle Del Dittaino"},
	{"3690","Catania/Innesto Tangenziale Di Catania"},
	{"3691","Catania/Simeto/Innesto Tangenziale Di Catania"},
	{"3692","Catanzaro"},
	{"3693","Catanzaro Lido"},
	{"3694","Catanzaro Lido/Innesto Ss106 Jonica"},
	{"3695","Catanzaro Lido/Innesto Ss19q Delle Calabrie"},
	{"3696","Catanzaro/Innesto Ss109bis Della Piccola Sila"},
	{"3697","Catanzaro/Innesto Ss280 Dei Due Mari"},
	{"3698","Catanzaro-Lamezia T."},
	{"3699","Catena"},
	{"3700","Catenanuova"},
	{"3701","Catignano"},
	{"3702","Catona"},
	{"3703","Cattabriche"},
	{"3704","Cattinara/Innesto Ss15 Racc Via Flavia"},
	{"3705","Cattinara/Innesto Ss202 Triestina"},
	{"3706","Cattolica"},
	{"3707","Caupo"},
	{"3708","Cava De' Tirreni"},
	{"3709","Cava Dei Tirreni/Innesto Ss18 Tirrena Inferiore"},
	{"3710","Cava De'tirreni/Innesto Ss18 Dir/A Di Badia Di Cava"},
	{"3711","Cava Tigozzi"},
	{"3712","Cavaglia'/Innesto Ss143 E Ss228 Del Lago Di Viverone"},
	{"3713","Cavaglia'/Innesto Ss228 E Ss593"},
	{"3714","Cavaglia'/Innesto Ss593 Di Borgo D'ale E Ss143"},
	{"3715","Cavagnolo"},
	{"3716","Cavalcaselle"},
	{"3717","Cavalcaselle/Innesto Ss11 Padana Superiore"},
	{"3718","Cavalcaselle/Innesto Ss450 Di Affi"},
	{"3719","Cavalcaselle-Innesto Ss11 Padana Superiore"},
	{"3720","Cavalese"},
	{"3721","Cavalese/Innesto Ss48 Delle Dolomiti"},
	{"3722","Cavalese/Innesto Ss620 Del Passo Di Lavaze'"},
	{"3723","Cavallari"},
	{"3724","Cavallermaggiore"},
	{"3725","Cavallino/Innesto Ss67 Tosco Romagnola"},
	{"3726","Cavallino/Innesto Ss9 Ter Del Rabbi"},
	{"3727","Cavallo Di Albenga/Innesto Ss1 Aurelia"},
	{"3728","Cavallo Di Albenga/Innesto Ss582 Colle S. Bernardo"},
	{"3729","Cavareno/Innesto Ss43 Diramazione Della Val Di Non"},
	{"3730","Cavareno/Innesto Ss43 Dir/A Della Val Di Non"},
	{"3731","Cavarzere"},
	{"3732","Cave"},
	{"3733","Cave Del Predil"},
	{"3734","Cave Del Predil/Innesto Ss54 Del Friuli"},
	{"3735","Cave Del Predil/Innesto Ss54 Radd Del Friuli"},
	{"3736","Cave Faccanoni/Innesto Ss14 Della Venezia Giulia"},
	{"3737","Cave Faccanoni/Innesto Ss58 Della Carniola"},
	{"3738","Cavedago"},
	{"3739","Cavedon-Valliera"},
	{"3740","Cavenago"},
	{"3741","Cavernago/Innesto Ss498 Soncinese"},
	{"3742","Cavernago/Innesto Ss573 L'ogliese"},
	{"3743","Cavezzo"},
	{"3744","Caviola"},
	{"3745","Cavour"},
	{"3746","Cavour Ovest"},
	{"3747","Cavriglia"},
	{"3748","Ceccano"},
	{"3749","Ceccano/Innesto Ss156 Dei Monti Lepini"},
	{"3750","Ceccano/Innesto Ss156 Diramazione Dei Monti Lepini"},
	{"3751","Ceccano/Innesto Ss637 Di Frosinone E Gaeta"},
	{"3752","Ceccano/Innesto Ss637 Diramazione Di Frosinone E Gaeta"},
	{"3753","Cecchina"},
	{"3754","Ceciliano"},
	{"3755","Cecina"},
	{"3756","Cedda"},
	{"3757","Cedegolo"},
	{"3758","Cefalu'"},
	{"3759","Cefalu' Est"},
	{"3760","Cefalu' Ovest"},
	{"3761","Ceggia"},
	{"3762","Ceglie Messapica"},
	{"3763","Celano"},
	{"3764","Celano/Innesto Ss5 Bis Diramazione Vestina"},
	{"3765","Celano/Innesto Ss5 Bis Vestina-Sarentina"},
	{"3766","Celano/Innesto Ss5 Tiburtina Valeria"},
	{"3767","Celat"},
	{"3768","Celice"},
	{"3769","Celico"},
	{"3770","Cella"},
	{"3771","Celle Ligure"},
	{"3772","Celli D'ongina"},
	{"3773","Cellole"},
	{"3774","Celzi"},
	{"3775","Celzi/Innesto Ss403 Del Vallo Di Lauro"},
	{"3776","Celzi/Innesto Ss88 Dei Due Principati"},
	{"3777","Cembra"},
	{"3778","Cencenighe"},
	{"3779","Cencenighe/Innesto Ss203 Agordina"},
	{"3780","Cencenighe/Innesto Ss346 Del Passo Di S.Pellegrino"},
	{"3781","Ceneselli"},
	{"3782","Cengio"},
	{"3783","Ceniga"},
	{"3784","Centallo"},
	{"3785","Centeno"},
	{"3786","Cento"},
	{"3787","Centobuchi"},
	{"3788","Centola"},
	{"3789","Centrache"},
	{"3790","Centrale Sarda"},
	{"3791","Centrale Sicula"},
	{"3792","Centrale Umbra"},
	{"3793","Centro Occidentale Sicula"},
	{"3794","Ceola"},
	{"3795","Cepagatti/Innesto Ss602 Di Forca Di Penne"},
	{"3796","Cepagatti/Innesto Ss81 Piceno Aprutina"},
	{"3797","Ceparana"},
	{"3798","Ceppo Morelli"},
	{"3799","Ceprano"},
	{"3800","Ceprano/Innesto Ss6 Casilina"},
	{"3801","Ceprano/Innesto Ss82 Della Valle Del Liri"},
	{"3802","Ceraino"},
	{"3803","Cerami"},
	{"3804","Ceramida"},
	{"3805","Cerchiaia/Innesto Ss73/Ss223 E Tangenziale Di Siena"},
	{"3806","Cerchiara Di Calabria"},
	{"3807","Cerchio/Innesto Ss5 Tiburtina Valeria"},
	{"3808","Cerchio/Innesto Ss83 Marsicana"},
	{"3809","Cercivento Inferiore"},
	{"3810","Cerda"},
	{"3811","Cerea"},
	{"3812","Cerese Di Virgilio"},
	{"3813","Cerese/Innesto Ss413 Romana"},
	{"3814","Cerese/Innesto Ss62 Della Cisa"},
	{"3815","Ceresole Reale"},
	{"3816","Ceriale"},
	{"3817","Cerignola"},
	{"3818","Cerignola Est"},
	{"3819","Cerignola Est/InnestoSs98/Innesto Asse Cerignola-Ba"},
	{"3820","Cerignola/Innesto Ss16 E Asse Attr. Cerignola-Bari"},
	{"3821","Cerisola"},
	{"3822","Cerlongo"},
	{"3823","Cermes"},
	{"3824","Cermignano"},
	{"3825","Cermone/Innesto Ss260 Picente"},
	{"3826","Cermone/Innesto Ss80 Del G.Sasso D'italia"},
	{"3827","Cermone/Innesto Ss80 Del Gran Sasso D'italia"},
	{"3828","Cermone/Innesto Ss80 Diramazione Gran Sasso D'italia"},
	{"3829","Cernadoi/Innesto Ss203 Agordina"},
	{"3830","Cernadoi/Innesto Ss48 Delle Dolomiti"},
	{"3831","Cerniago"},
	{"3832","Cernobbio"},
	{"3833","Cernusco Sul Naviglio"},
	{"3834","Cerqueto"},
	{"3835","Cerredolo"},
	{"3836","Cerreto Castello"},
	{"3837","Cerreto D'esi"},
	{"3838","Cerro"},
	{"3839","Cerro Al Volturno"},
	{"3840","Cerro Volturno/Innesto Ss158 Della V. Del Volturno"},
	{"3841","Cerro Volturno/Innesto Ss158 Valle Del Volturno"},
	{"3842","Cerro Volturno/Innesto Ss17racc"},
	{"3843","Cerro Volturno/Innesto Ss652 Fondo Valle Sangro"},
	{"3844","Cersosimo"},
	{"3845","Cersuta"},
	{"3846","Certaldo"},
	{"3847","Certosa Di Pavia"},
	{"3848","Cerva"},
	{"3849","Cervada Est"},
	{"3850","Cervara"},
	{"3851","Cervaro"},
	{"3852","Cervere"},
	{"3853","Cervia/Innesto Ss16 Adriatica"},
	{"3854","Cervia/Innesto Ss254 Di Cervia"},
	{"3855","Cervignano D.F./Innesto Ss352 Di Grado"},
	{"3856","Cervignano Del Friuli"},
	{"3857","Cervignano Del Friuli/Innesto Ss14 Della V. Giulia"},
	{"3858","Cervignano Del Friuli/Innesto Ss351 Di Cervignano"},
	{"3859","Cervinara"},
	{"3860","Cervo"},
	{"3861","Cervorezza"},
	{"3862","Cesa"},
	{"3863","Cesana Torinese"},
	{"3864","Cesana Torinese/Innesto Ss23 Colle Di Sestriere"},
	{"3865","Cesana Torinese/Innesto Ss24 Del Monginevro"},
	{"3866","Cesano Di Senigallia"},
	{"3867","Cesaro'"},
	{"3868","Ceselli"},
	{"3869","Cesena"},
	{"3870","Cesena Citta'"},
	{"3871","Cesena Nord"},
	{"3872","Cesena/Incrocio Ss9 Emilia"},
	{"3873","Cesena/Innesto S.G.C. Orte Ravenna E Tangenziale Cesena"},
	{"3874","Cesena/Innesto S.G.C. Orte-Ravenna (e45)"},
	{"3875","Cesena/Innesto Ss 304 Di Cesena"},
	{"3876","Cesena/Innesto Ss71 Bis U. Casentinese Romagnola"},
	{"3877","Cesena/Innesto Ss71 U. Casentinese Romagnola"},
	{"3878","Cesena/Innesto Ss9 Emilia"},
	{"3879","Cesena/Innesto Tangenziale Cesena"},
	{"3880","Cesenatico/Innesto Ss16 Adriatica"},
	{"3881","Cesenatico/Innesto Ss304 Di Cesena"},
	{"3882","Ceserano"},
	{"3883","Cesio"},
	{"3884","Cessalto"},
	{"3885","Cetara"},
	{"3886","Cetona"},
	{"3887","Cetraro"},
	{"3888","Cetraro/Incrocio Ss533 Di Fagnano"},
	{"3889","Cetraro/Innesto Ss18 Tirrena Inferiore"},
	{"3890","Ceva"},
	{"3891","Ceva/Innesto Ss28 Del Colle Di Nava"},
	{"3892","C-Gombetto/Innesto Ss236 Goitese/Ss236 Bis"},
	{"3893","Chamonix"},
	{"3894","Chatillon/Innesto Strada Reg. 47"},
	{"3895","Chatillon-Saint Vincent"},
	{"3896","Cherasco"},
	{"3897","Chialina"},
	{"3898","Chianciano"},
	{"3899","Chianciano Terme"},
	{"3900","Chianocco-Bussoleno"},
	{"3901","Chianti"},
	{"3902","Chiantigiana"},
	{"3903","Chiappino"},
	{"3904","Chiaramonti"},
	{"3905","Chiaravalle Centr./Innesto Ss382 Di Chiaravalle"},
	{"3906","Chiaravalle Centrale"},
	{"3907","Chiaravalle Centro/Innesto Ss182 Serre Calabre"},
	{"3908","Chiaravalle/Innesto Ss110 Di M.Te Cucco E Pecoraro"},
	{"3909","Chiari"},
	{"3910","Chiarisacco"},
	{"3911","Chiasso"},
	{"3912","Chiasso-Dogana Di Brogeda"},
	{"3913","Chiavari"},
	{"3914","Chiavari/Innesto Ss1 Aurelia"},
	{"3915","Chiavari/Innesto Ss225 Della Fontanabuona"},
	{"3916","Chiavazza/Innesto Ss142 Biellese"},
	{"3917","Chiavazza/Innesto Ss142 Var"},
	{"3918","Chiavenna"},
	{"3919","Chiavenna Landi"},
	{"3920","Chiavenna/Innesto Ss37 Del Maloja"},
	{"3921","Chiavenna/Innesto Ss36 Lago Di Como E Dello Spluga"},
	{"3922","Chienes"},
	{"3923","Chienti"},
	{"3924","Chiesa/Innesto Ss349 Di Val D'assa"},
	{"3925","Chiesa/Innesto Ss349 Dir"},
	{"3926","Chiesina Uzzanese"},
	{"3927","Chiesuol Del Fosso"},
	{"3928","Chieti"},
	{"3929","Chieti Est/Innesto Ss649 Di Fondo Valle Alento"},
	{"3930","Chieti Est/Innesto Ss649Diramazione Di Fondo V. Alento"},
	{"3931","Chieti Scalo"},
	{"3932","Chieti Scalo/Innesto Ss5 Tiburtina Valeria"},
	{"3933","Chieti/Incrocio Ss81 Piceno Aprutina"},
	{"3934","Chieti/Innesto Ss5 Raccordo Via Tiburtina Valeria"},
	{"3935","Chieti/Innesto Ss649 Diramazione Di Fondo Valle Alento"},
	{"3936","Chieti/Innesto Ss656 Val Pescara-Chieti"},
	{"3937","Chieti/Innesto Ss656Diramazione Val Pescara-Chieti"},
	{"3938","Chieti/Innesto Ss81 Piceno Aprutina"},
	{"3939","Chifenti"},
	{"3940","Chifenti/Innesto Ss12 Dell'abetone E Del Brennero"},
	{"3941","Chifenti/Innesto Ss445 Della Garfagnana"},
	{"3942","Chioggia"},
	{"3943","Chiomonte"},
	{"3944","Chiozza"},
	{"3945","Chiuppano"},
	{"3946","Chiusa S.Michele"},
	{"3947","Chiusa Sclafani"},
	{"3948","Chiusa Sclafani/Innesto Ss188 Centro Occ. Sicula"},
	{"3949","Chiusa Sclafani/Innesto Ss386 Di Ribera"},
	{"3950","Chiusa/Innesto Ss12 Dell'abetone E Del Brennero"},
	{"3951","Chiusa/Innesto Ss242 Diramazione Val Gardena E Passo Sella"},
	{"3952","Chiusano S.Domenico"},
	{"3953","Chiusa-Valgardena"},
	{"3954","Chiusavecchia"},
	{"3955","Chiusi"},
	{"3956","Chiusi D. Verna/Innesto Ss208 Diramazione Della Verna"},
	{"3957","Chiusi Della Verna/Innesto Ss208 Della Verna"},
	{"3958","Chiusi Scalo"},
	{"3959","Chiusi/Innesto Ss146 Di Chianciano"},
	{"3960","Chiusi/Innesto Ss326 Di Rapolano"},
	{"3961","Chiusi-Chianciano"},
	{"3962","Chivasso"},
	{"3963","Chivasso Est"},
	{"3964","Chivasso Ovest"},
	{"3965","Chivasso/Innesto Ss11 Padana Superiore"},
	{"3966","Chivasso/Innesto Ss11 Padana Superiore"},
	{"3967","Chivasso/Innesto Ss26 Della Valle D'aosta"},
	{"3968","Chivasso/Innesto Ss458 Di Casalborgone"},
	{"3969","Chorio Di S.Lorenzo"},
	{"3970","Ciago"},
	{"3971","Ciampino/Innesto Ss7 Appia"},
	{"3972","Cianciana"},
	{"3973","Ciano D'enza"},
	{"3974","Ciapulla"},
	{"3975","Cibiana Di Cadore"},
	{"3976","Cicagna"},
	{"3977","Cicala"},
	{"3978","Cicese"},
	{"3979","Cicognara"},
	{"3980","Cicognola"},
	{"3981","Cicognola Pagnano"},
	{"3982","Ciconicco"},
	{"3983","Cigliano"},
	{"3984","Cigliano/Innesto Ss11 Padana Superiore"},
	{"3985","Cigliano/Innesto Ss593 Di Borgo D'ale"},
	{"3986","Cigliano/Innesto Ss595 Di Mazze'"},
	{"3987","Cima"},
	{"3988","Cima Gogna/Innesto Ss48 Delle Dolomiti"},
	{"3989","Cima Gogna/Innesto Ss52 Carnica"},
	{"3990","Cimaganda"},
	{"3991","Cimena"},
	{"3992","Cimolais"},
	{"3993","Cimpello-Allacciamento A28 Portogruaro Pordenone"},
	{"3994","Cimpello-Allacciamento Raccordo Cimpello-Ss13"},
	{"3995","Cingoli"},
	{"3996","Cinisi"},
	{"3997","Cinquefrondi/Innesto Ss281 Del Passo Di Limina"},
	{"3998","Cinquefrondi/Innesto Ss536 Di Acquaro"},
	{"3999","Cinto Cao Maggiore"},
	{"4000","Cintolese"},
	{"4001","Cinzano D'alba"},
	{"4002","Cipolleto"},
	{"4003","Circ. Ss 106"},
	{"4004","Circello"},
	{"4005","Circonvallazione Di Alberobello"},
	{"4006","Circum. Mar Piccolo"},
	{"4007","Cireglio"},
	{"4008","Cirella"},
	{"4009","Cirigliano"},
	{"4010","Ciro' Marina"},
	{"4011","Cisano Bergamasco"},
	{"4012","Cisano Bergamasco/Innesto Ss342 Briantea"},
	{"4013","Cisano Bergamasco/Innesto Ss639"},
	{"4014","Cisano Di Bardolino"},
	{"4015","Cisano Sul Neva"},
	{"4016","Ciseriis"},
	{"4017","Cislago"},
	{"4018","Cismon Del Grappa"},
	{"4019","Cisterna"},
	{"4020","Cisterna Di Latina"},
	{"4021","Citerna"},
	{"4022","Citta Della Pieve"},
	{"4023","Citta' Di Castello/Inn Ss257 Apecchiese"},
	{"4024","Citta' Di Castello/Innesto Sgc Orte-Ravenna"},
	{"4025","Citta' Di Castello/Innesto Ss221 Di Monterchi"},
	{"4026","Citta'(piazzale Bologna)"},
	{"4027","Cittadella"},
	{"4028","Cittadella/Incrocio Ss47 Della Valsugana"},
	{"4029","Cittadella/Innesto Ss53 Postumia"},
	{"4030","Cittaducale"},
	{"4031","Cittanova"},
	{"4032","Cividale Del F./Incrocio Ss356 Di Cividale"},
	{"4033","Cividale Del Friuli"},
	{"4034","Cividale Del Friuli/Incrocio Ss54 Del Friuli"},
	{"4035","Cividate Camuno"},
	{"4036","Civita"},
	{"4037","Civita Castellana"},
	{"4038","Civita Castellana/Innesto Ss3 Flaminia"},
	{"4039","Civita Castellana/Innesto Ss311 Nepesina"},
	{"4040","Civita D'antino/Morino"},
	{"4041","Civita Di Bagno"},
	{"4042","Civitacampomarano"},
	{"4043","Civitaquana"},
	{"4044","Civitatomassa/Innesto Ss17 Dell'app. Abruzzese"},
	{"4045","Civitatomassa/Innesto Ss80 Dir"},
	{"4046","Civitavecchia"},
	{"4047","Civitavecchia Sud"},
	{"4048","Civitella Di Romagna"},
	{"4049","Civitella Roveto"},
	{"4050","Claviere"},
	{"4051","Cles"},
	{"4052","Cliternia Nuova"},
	{"4053","Cloz"},
	{"4054","Coazze-Bondanello"},
	{"4055","Coccaglio"},
	{"4056","Coccaglio/Innesto Ss11 Padana Superiore"},
	{"4057","Coccaglio/Innesto Ss573 L'ogliese"},
	{"4058","Cocullo"},
	{"4059","Codigoro"},
	{"4060","Codisotto"},
	{"4061","Codognese"},
	{"4062","Codogno"},
	{"4063","Codogno Innesto Ss591 Cremasca"},
	{"4064","Codogno/Innesto Ss234 Codognese"},
	{"4065","Codrongianos/Innesto Ss597 Di Logudoro"},
	{"4066","Codrongianus/Innesto Ss131 Di Carlo Felice"},
	{"4067","Cogno"},
	{"4068","Cogoleto"},
	{"4069","Cogozzo"},
	{"4070","Cola'-Sandra'"},
	{"4071","Colcerasa"},
	{"4072","Colfiorito"},
	{"4073","Colfosco"},
	{"4074","Colico/Trivio Fuentes/S.Agata/Ss38"},
	{"4075","Collagna"},
	{"4076","Collarmele"},
	{"4077","Colle"},
	{"4078","Colle Calvo"},
	{"4079","Colle Cavaliere"},
	{"4080","Colle Del Giovo"},
	{"4081","Colle Del Melogno"},
	{"4082","Colle Del Sestriere"},
	{"4083","Colle Dell' Argentera"},
	{"4084","Colle Di Boasi"},
	{"4085","Colle Di Cadibona"},
	{"4086","Colle Di Moncenisio/Confine Con La Francia"},
	{"4087","Colle Di Monginevro/Confine Con La Francia"},
	{"4088","Colle Di Nava"},
	{"4089","Colle Di Tenda/Confine Con La Francia"},
	{"4090","Colle Di Val D'elsa"},
	{"4091","Colle Furno"},
	{"4092","Colle Isarco"},
	{"4093","Colle Licino/Innesto Raccordo Terni-Orte"},
	{"4094","Colle Rugero"},
	{"4095","Colle S.Bartolomeo"},
	{"4096","Colle S.Lorenzo"},
	{"4097","Colle S.Lucia"},
	{"4098","Colle Sannita"},
	{"4099","Colle Tasso"},
	{"4100","Colle Telugno/Innesto Ss509 Di Forca D'acero"},
	{"4101","Colle Telugno/Innesto Ss666 Di Sora"},
	{"4102","Colle Val D'elsa"},
	{"4103","Colle Val D'elsa Nord"},
	{"4104","Colle Val D'elsa Sud"},
	{"4105","Colle Val D'elsa/Innesto Ss68 Di Val Cecina"},
	{"4106","Colle Val D'elsa/Innesto Ss541 Traversa Maremmana"},
	{"4107","Colle Venatorio/Innesto Ss17 Bis"},
	{"4108","Colle Venatorio/Innesto Ss602 Di Forca Di Penne"},
	{"4109","Collebarucci"},
	{"4110","Collecchio"},
	{"4111","Colledara-San Gabriele"},
	{"4112","Colledimezzo"},
	{"4113","Colledimezzo/Innesto Ss364 Di Atesa"},
	{"4114","Colledimezzo/Innesto Ss652 Di Fondo V. Del Sangro"},
	{"4115","Collefegato"},
	{"4116","Colleferro"},
	{"4117","Colleferro/Innesto Ss600 Diramazione Ariana"},
	{"4118","Colleferro/Innesto Ss609 Carpinetana"},
	{"4119","Collegno"},
	{"4120","Collegno/Innesto Tangenziale Nord Di Torino"},
	{"4121","Collemazzolino"},
	{"4122","Collepasso"},
	{"4123","Collesalvetti"},
	{"4124","Collesalvetti/Sgc Fi-Pi-Li"},
	{"4125","Collestatte"},
	{"4126","Collestrada/Innesto Sgc Orte-Ravenna"},
	{"4127","Collestrada/Innesto Ss75 Centrale Umbra"},
	{"4128","Colli A Volturno"},
	{"4129","Colli Alti"},
	{"4130","Colli Alti/Innesto Ss325 Di Val Setta E Val Bisenzio"},
	{"4131","Colli Alti/Innesto Ss66 Pistoiese"},
	{"4132","Colli Di Fontanelle"},
	{"4133","Colli Di Fontanelle/Innesto Ss145 Sorrentina"},
	{"4134","Colli Di Fontanelle/Innesto Ss163 Amalfitana"},
	{"4135","Collicelle"},
	{"4136","Collimento"},
	{"4137","Collio"},
	{"4138","Collobiano"},
	{"4139","Colma"},
	{"4140","Colmegna"},
	{"4141","Cologna In Giudicarie"},
	{"4142","Cologna Veneta"},
	{"4143","Cologno Al Serio"},
	{"4144","Cologno M. Est"},
	{"4145","Colombella"},
	{"4146","Colonia Montana"},
	{"4147","Colonna Del Grillo/Innesto Ss73 Senese Aretina"},
	{"4148","Colonna Del Grillo-Ss73 Senese Aretina"},
	{"4149","Colonna Di Grillo/Innesto Raccordo Si-Bettolle"},
	{"4150","Colonna Di Grillo/Innesto Ss484 Castello Di Brolio"},
	{"4151","Colonna Di Grillo/Innesto Ss540 Di Valdambra"},
	{"4152","Colonnetta Di Prodo/Innesto Ss317 Marscianese"},
	{"4153","Colonnetta Di Prodo/Innesto Ss79 Bis Orvietana"},
	{"4154","Colonno"},
	{"4155","Colorno"},
	{"4156","Colosimi"},
	{"4157","Comabbio"},
	{"4158","Comacchio"},
	{"4159","Comano"},
	{"4160","Comeglians"},
	{"4161","Comerzo"},
	{"4162","Comino"},
	{"4163","Comiso"},
	{"4164","Commessaggio"},
	{"4165","Como"},
	{"4166","Como/Innesto Ss340 Regina"},
	{"4167","Como/Innesto Ss342 Briantea"},
	{"4168","Como/Innesto Ss35 Dei Giovi"},
	{"4169","Compito"},
	{"4170","Comunanza"},
	{"4171","Comunanza/Innesto Ss433 Di Val D'aso"},
	{"4172","Comunanza/Innesto Ss78 Picena"},
	{"4173","Cona"},
	{"4174","Cona Di Selvapiana"},
	{"4175","Conca Dei Marini/Innesto Ss163 Amalfitana"},
	{"4176","Conca Dei Marini/Innesto Ss366 Di Agerola"},
	{"4177","Conca Di Rozzano"},
	{"4178","Concesio"},
	{"4179","Condino"},
	{"4180","Condofuri Marina"},
	{"4181","Condove"},
	{"4182","Conegliano"},
	{"4183","Conegliano Veneto"},
	{"4184","Conero"},
	{"4185","Configno"},
	{"4186","Confine Di Stato"},
	{"4187","Confine Di Stato Francia-Italia"},
	{"4188","Confine Province Di Catania E Siracusa"},
	{"4189","Confine Province Di L'aquila E Pescara"},
	{"4190","Confine Province Di Matera E Taranto"},
	{"4191","Confine Province Di Padova E Venezia"},
	{"4192","Confine Province Di Pescara E L'aquila"},
	{"4193","Confine Province Di Roma E Rieti"},
	{"4194","Confine Province Di Siracusa E Catania"},
	{"4195","Confine Province Di Terni E Perugia"},
	{"4196","Confine Provincia Rieti-Terni"},
	{"4197","Confine Provincie Agrigento E Caltanissetta"},
	{"4198","Confine Tra Le Province Di Avellino E Foggia"},
	{"4199","Confine Tra Le Province Di Rieti E Ascoli P."},
	{"4200","Conicchio"},
	{"4201","Conioli Sud"},
	{"4202","Consandolo"},
	{"4203","Consandolo/Innesto Ss16 Adriatica"},
	{"4204","Consandolo/Innesto Ss495 Di Codigoro"},
	{"4205","Conselice"},
	{"4206","Consuma"},
	{"4207","Contarina"},
	{"4208","Contrada"},
	{"4209","Contron"},
	{"4210","Controne"},
	{"4211","Contursi"},
	{"4212","Convento Di Forano"},
	{"4213","Conversano"},
	{"4214","Conza Lago/Innesto Ss7dir/C Via Appia"},
	{"4215","Conza Lago/Innesto Ss91 Della Valle Del Sele"},
	{"4216","Copanello"},
	{"4217","Copiano"},
	{"4218","Coraci/Innesto Ss19 E Ss108 Bis Silana Di Cariati"},
	{"4219","Coraci/Innesto Ss19 E Ss616 Di Pedivigliano"},
	{"4220","Coraci/Innesto Ss108 Bis Silana Di Cariati/Innesto Ss616"},
	{"4221","Corato"},
	{"4222","Corbanese"},
	{"4223","Corbetta"},
	{"4224","Corbola"},
	{"4225","Corciano"},
	{"4226","Corciano/Innesto Raccordo Bettolle-Perugia"},
	{"4227","Cordovado"},
	{"4228","Corfinio/Innesto Ss17 App. Abruz. E Appulo Sann."},
	{"4229","Corfinio/Innesto Ss5 Via Tiburtina Valeria"},
	{"4230","Corfino"},
	{"4231","Corigliano Calabro"},
	{"4232","Corleone/Innesto Ss118 Corleonese/Agrigentina"},
	{"4233","Corleone/Innesto Ss188dir/C Centro Occ. Sicula"},
	{"4234","Corleonese-Agrigentina"},
	{"4235","Corleto Perticara/Innesto Ss103 Di Val D'agri"},
	{"4236","Corleto Perticara/Innesto Ss92 Dell'app. Merid.Le"},
	{"4237","Corlo"},
	{"4238","Cormano"},
	{"4239","Cormons"},
	{"4240","Cormons/Innesto Ss356 Di Cividale"},
	{"4241","Cormons/Innesto Ss409 Di Plessiva"},
	{"4242","Cormons/Innesto Ss56 Di Gorizia"},
	{"4243","Corne'"},
	{"4244","Cornedo Vicentino"},
	{"4245","Cornei"},
	{"4246","Corniolo"},
	{"4247","Corno Di Rosazzo"},
	{"4248","Cornuda"},
	{"4249","Corpi Santi"},
	{"4250","Corpi Santi/Innesto Ss84 Frentana"},
	{"4251","Corpi Santi/Innesto Ss263 V. Di Foro E Bocca Di Valle"},
	{"4252","Corpolo' Di Rimini"},
	{"4253","Corporeno"},
	{"4254","Correggio"},
	{"4255","Correggioli"},
	{"4256","Corridonia Maceratese"},
	{"4257","Corridonia-Piediripa"},
	{"4258","Corrugunele"},
	{"4259","Corsico"},
	{"4260","Corso Calatafimi (palermo Porto)"},
	{"4261","Corso Di Fiamignano"},
	{"4262","Corso Francia"},
	{"4263","Corso Malta"},
	{"4264","Cortale"},
	{"4265","Corte Centrale"},
	{"4266","Corte Gombetto/Innesto Ss236 E Ss62 Della Cisa"},
	{"4267","Corte Gombetto/Innesto Ss62 E Ss236bis"},
	{"4268","Corte Madama"},
	{"4269","Cortemaggiore"},
	{"4270","Cortemaggiore/Innesto Ss462 Della Val D'arda"},
	{"4271","Cortemaggiore/Innesto Ss587 Di Cortemaggiore"},
	{"4272","Cortemilia"},
	{"4273","Cortemilia/Innesto Ss29 Del Colle Di Cadibona"},
	{"4274","Cortemilia/Innesto Ss339 Di Cengio"},
	{"4275","Corteolona"},
	{"4276","Cortina D'ampezzo/Innesto Ss48 Delle Dolomiti"},
	{"4277","Cortina D'ampezzo/Innesto Ss51 Di Alemagna"},
	{"4278","Cortina D'ampezzo/Innesto Ss51racc Via Olimpia"},
	{"4279","Cortona"},
	{"4280","Cortona-Foiano"},
	{"4281","Corvara In Badia/Innesto Ss243 Del Passo Gardena"},
	{"4282","Corvara In Badia/Innesto Ss244 Di Val Badia"},
	{"4283","Corzano"},
	{"4284","Cosenza"},
	{"4285","Cosenza Nord"},
	{"4286","Cosenza/Innesto Ss107 Silana Crotonese"},
	{"4287","Cosenza/Innesto Ss19 Delle Calabrie"},
	{"4288","Cosenza/Innesto Ss278 Di Potame"},
	{"4289","Cosio Di Arroscia B."},
	{"4290","Cosoleto"},
	{"4291","Cosoleto/Innesto Ss112 Bis D'aspromonte"},
	{"4292","Cosoleto/Innesto Ss112 D'aspromonte"},
	{"4293","Cossano Belbo"},
	{"4294","Cossato"},
	{"4295","Cossato/Incrocio Ss142 Biellese"},
	{"4296","Cossato/Incrocio Ss232 Panoramica Zegna"},
	{"4297","Cossato/Svincolo Per Ss142 Var"},
	{"4298","Cossila"},
	{"4299","Cossoine"},
	{"4300","Costa"},
	{"4301","Costa Caselle/Innesto Ss217 Via Dei Laghi"},
	{"4302","Costa Caselle/Innesto Ss297 Del Lago Olimpico"},
	{"4303","Costa S.Abramo"},
	{"4304","Costafabbri/Innesto Tangenziale Di Siena"},
	{"4305","Costalpino"},
	{"4306","Costigliole D'asti"},
	{"4307","Costigliole Saluzzo"},
	{"4308","Costozza"},
	{"4309","Cotronei"},
	{"4310",""},
	{"4311","Covelo"},
	{"4312","Covigliaio"},
	{"4313","Covo"},
	{"4314","Cozzo"},
	{"4315","Cozzo Di Renelli"},
	{"4316","Craco"},
	{"4317","Craticello Ponte"},
	{"4318","Crava"},
	{"4319","Crema Ovest/Incrocio Ss415 Paullese"},
	{"4320","Crema Ovest/Innesto Ss235 Di Orzinuovi"},
	{"4321","Crema/Incrocio Ss591 Cremasca"},
	{"4322","Crema/Innesto Ss235 Di Orzinuovi"},
	{"4323","Crema/Innesto Ss415 Paullese"},
	{"4324","Crema/Innesto Ss591 Cremasca"},
	{"4325","Cremasca"},
	{"4326","Cremella"},
	{"4327","Cremolino"},
	{"4328","Cremona"},
	{"4329","Cremona Nord"},
	{"4330","Cremona Sud"},
	{"4331","Cremona/Innesto Ss10 Padana Inferiore"},
	{"4332","Cremona/Innesto Ss10 Padana Inferiore"},
	{"4333","Cremona/Innesto Ss234 Codognese"},
	{"4334","Cremona/Innesto Ss415 Paullese"},
	{"4335","Cremona/Innesto Ss45 Bis Gardesana Occidentale"},
	{"4336","Cremona/Innesto Ss498 Soncinese"},
	{"4337","Crescentino Var."},
	{"4338","Crespellano"},
	{"4339","Crespino Del Lamone"},
	{"4340","Cressogno"},
	{"4341","Creto"},
	{"4342","Crevalcore"},
	{"4343","Crevoladossola/Innesto Ss33 Del Sempione"},
	{"4344","Crevoladossola/Innesto Ss659 Valle Antigorio"},
	{"4345","Croce"},
	{"4346","Croce Di S.Eusanio/Innesto Ss84 Frentana"},
	{"4347","Croce Grossa/Innesto Ss10 Padana Inferiore"},
	{"4348","Croce Grossa/Innesto Ss587 Di Cortemaggiore"},
	{"4349","Croce S.Eusanio/Innesto Ss363 Di Guardiagrele"},
	{"4350","Croce S.Spirito"},
	{"4351","Croce S.Spirito/Innesto Ss10 Padana Inferiore"},
	{"4352","Croce S.Spirito/Innesto Ss588 Dei Due Ponti"},
	{"4353","Crocedomini/Innesto Ss345 Delle Tre Valli"},
	{"4354","Crocemosso"},
	{"4355","Crocetta"},
	{"4356","Crociale Di Manerba"},
	{"4357","Crociale/Innesto Ss324 Del Passo Delle Radici"},
	{"4358","Crociale/Innesto Ss623 Del Passo Brasa"},
	{"4359","Crocino"},
	{"4360","Crodo"},
	{"4361","Cropalati/Innesto Ss177 Silana Di Rossano"},
	{"4362","Cropalati/Innesto Ss531 Di Cropalati"},
	{"4363","Cropani"},
	{"4364","Cropani Marina"},
	{"4365","Crosere/Innesto Ss14 Della Venezia Giulia"},
	{"4366","Crosere/Innesto Ss354 Di Lignano"},
	{"4367","Crostas"},
	{"4368","Crotone"},
	{"4369","Croviana"},
	{"4370","Cuglieri"},
	{"4371","Culzei"},
	{"4372",""},
	{"4373","Cuncosu"},
	{"4374","Cuneo"},
	{"4375","Cuneo/Innesto Ss20 Del Colle Di Tenda"},
	{"4376","Cuneo/Innesto Ss22 Di Val Macra"},
	{"4377","Cuneo/Innesto Ss564 Monregalese"},
	{"4378","Cunettone"},
	{"4379","Cuorgne'"},
	{"4380","Cupello"},
	{"4381","Cupone"},
	{"4382","Cupra Marittima"},
	{"4383","Cura"},
	{"4384","Curavecchia (roasio)"},
	{"4385","Curicchi"},
	{"4386","Curno/Innesto Ss342 Briantea"},
	{"4387","Curno/Innesto Ss470 Diramazione Della Val Brembana"},
	{"4388","Curtarolo"},
	{"4389","Curtatone"},
	{"4390","Cusercoli"},
	{"4391","Cusiano"},
	{"4392","Cusinati"},
	{"4393","Cutigliano B."},
	{"4394","Cutrofiano/Innesto Ss476 Di Galatina"},
	{"4395","Cutrofiano/Innesto Ss497 Di Maglie E Di S.Cesarea T."},
	{"4396","Cuveglio"},
	{"4397","Cuzzago"},
	{"4398","Dalmine"},
	{"4399","Dalmine/Innesto Ss470 Diramazione Della Valle Brembana"},
	{"4400","Dalmine/Innesto Ss525 Del Brembo"},
	{"4401","Dama"},
	{"4402","Dare'"},
	{"4403","Darfo - Innesto Ss42 Del Tonale E Mendola"},
	{"4404","Darfo/Boario Terme"},
	{"4405","Darfo/Innesto Ss42 Del Tonale E Mendola"},
	{"4406","Darfo/Innesto Ss510 Sebina Orientale"},
	{"4407","Darzo"},
	{"4408","Dasa'"},
	{"4409","D'aspromonte"},
	{"4410","Dattilo"},
	{"4411","Daunia"},
	{"4412","Decima"},
	{"4413","Decimomannu/Innesto Ss130 Diramazione Iglesiente"},
	{"4414","Decimomannu/Innesto Ss130 Iglesiente"},
	{"4415","Decimomannu/Innesto Ss196 Di Villacidro"},
	{"4416","Degli Alburni"},
	{"4417","Degna"},
	{"4418","Dego"},
	{"4419","Dego/Innesto Ss29 Del Colle Di Cadibona"},
	{"4420","Dego/Innesto Ss542 Di Pontivrea"},
	{"4421","Dei Cairoli"},
	{"4422","Dei Due Mari"},
	{"4423","Dei Due Ponti"},
	{"4424","Dei Due Principati"},
	{"4425","Dei Giovi"},
	{"4426","Dei Laghi Di Avigliana"},
	{"4427","Dei Laghi Di Molveno E Tenno"},
	{"4428","Dei Laghi Di Monticchio"},
	{"4429","Dei Laghi Di Pusiano E Di Garlate"},
	{"4430","Dei Monti Lepini"},
	{"4431","Dei Monti Martani"},
	{"4432","Dei Piani D'aspromonte"},
	{"4433","Dei Ponti Della Valle"},
	{"4434","Dei Tre Confini"},
	{"4435","Dei Tre Titoli"},
	{"4436","Dei Trulli"},
	{"4437","Deiva Marina"},
	{"4438","Del Basso Volturno"},
	{"4439","Del Benaco"},
	{"4440","Del Bidente"},
	{"4441","Del Brembo"},
	{"4442","Del Caffaro"},
	{"4443","Del Ceraso"},
	{"4444","Del Cilento"},
	{"4445","Del Colle Del Melogno"},
	{"4446","Del Colle Di Cadibona"},
	{"4447","Del Colle Di Cento Croci"},
	{"4448","Del Colle Di Nava"},
	{"4449","Del Colle Di S.Bernardo"},
	{"4450","Del Colle Di Sestriere"},
	{"4451","Del Colle Di Tenda E Di Valle Roja"},
	{"4452","Del Faito"},
	{"4453","Del Formicoso"},
	{"4454","Del Foscagno"},
	{"4455","Del Friuli"},
	{"4456","Del Gerrei"},
	{"4457","Del Golfo Di Policastro"},
	{"4458","Del Gran San Bernardo"},
	{"4459","Del Gran Sasso D'italia"},
	{"4460","Del Grappa E Del Passo Rolle"},
	{"4461","Del Lago Ampollino"},
	{"4462","Del Lago Arvo"},
	{"4463","Del Lago Del Coghinas"},
	{"4464","Del Lago Di Albano"},
	{"4465","Del Lago Di Campotosto"},
	{"4466","Del Lago Di Cavazzo"},
	{"4467","Del Lago Di Como E Dello Spluga"},
	{"4468","Del Lago Di Monate"},
	{"4469","Del Lago Di Viverone"},
	{"4470","Del Lago D'orta"},
	{"4471","Del Lago Laceno"},
	{"4472","Del Lago Maggiore"},
	{"4473","Del Lago Olimpico"},
	{"4474","Del Lido Di Lecce"},
	{"4475","Del Maloja"},
	{"4476","Del Moncenisio"},
	{"4477","Del Monferrato"},
	{"4478","Del Monginevro"},
	{"4479","Del Monte Terminio"},
	{"4480","Del Niccone"},
	{"4481","Del Passo Brasa"},
	{"4482","Del Passo Cereda E Del Passo Duran"},
	{"4483","Del Passo Crocedomini"},
	{"4484","Del Passo Del Gioco"},
	{"4485","Del Passo Del Penice"},
	{"4486","Del Passo Delle Crocelle E Di Valle Cupa"},
	{"4487","Del Passo Delle Radici"},
	{"4488","Del Passo Di Aprica"},
	{"4489","Del Passo Di Bocca Di Valle"},
	{"4490","Del Passo Di Cerro"},
	{"4491","Del Passo Di Gavia"},
	{"4492","Del Passo Di Giau"},
	{"4493","Del Passo Di Giovo"},
	{"4494","Del Passo Di Lavaze'"},
	{"4495","Del Passo Di Limina"},
	{"4496","Del Passo Di Resia"},
	{"4497","Del Passo Di S. Pellegrino"},
	{"4498","Del Passo Di S.Antonio"},
	{"4499","Del Passo Di S.Boldo"},
	{"4500","Del Passo Fedaia"},
	{"4501","Del Passo Gardena"},
	{"4502","Del Passo Rest"},
	{"4503","Del Pasubio"},
	{"4504","Del Polacco"},
	{"4505","Del Santo"},
	{"4506","Del Sassello"},
	{"4507","Del Savuto"},
	{"4508","Del Sempione"},
	{"4509","Del Subasio"},
	{"4510","Del Tagliamento"},
	{"4511","Del Tirso E Del Mandrolisai"},
	{"4512","Del Tonale E Della Mendola"},
	{"4513","Del Trasimeno Inferiore"},
	{"4514","Del Turchino"},
	{"4515","Del Valico Del Cerreto"},
	{"4516","Del Valico Di Monte Scuro"},
	{"4517","Del Vallo Di Lauro"},
	{"4518","Del Varco Di Pietrastretta"},
	{"4519","Del Verbano Orientale"},
	{"4520","Del Vesuvio"},
	{"4521","Delebio"},
	{"4522","Delia"},
	{"4523","Delianuova"},
	{"4524","Deliceto"},
	{"4525","Della Bassa Friulana"},
	{"4526","Della Bocca Di Magra"},
	{"4527","Della Carniola"},
	{"4528","Della Cisa"},
	{"4529","Della Consuma"},
	{"4530","Della Contessa"},
	{"4531","Della Fontanabuona"},
	{"4532","Della Forcella Lavardet E Di Valle S. Canciano"},
	{"4533","Della Foresta Umbra"},
	{"4534","Della Futa"},
	{"4535","Della Gallura Centrale"},
	{"4536","Della Garfagnana"},
	{"4537","Della Lomellina"},
	{"4538","Della Maddalena"},
	{"4539","Della Maielletta"},
	{"4540","Della Nurra"},
	{"4541","Della Piccola Sila"},
	{"4542","Della Pusteria"},
	{"4543","Della Scafa"},
	{"4544","Della Serra"},
	{"4545","Della Val Cesano"},
	{"4546","Della Val D'arda"},
	{"4547","Della Val D'aso"},
	{"4548","Della Val D'esino"},
	{"4549","Della Val Di Cembra"},
	{"4550","Della Val Di Chienti"},
	{"4551","Della Val Di Non"},
	{"4552","Della Val Di Scalve"},
	{"4553","Della Val Di Zoldo E Val Cellina"},
	{"4554","Della Val Fortore"},
	{"4555","Della Val Seriana"},
	{"4556","Della Val Tidone"},
	{"4557","Della Val Vigezzo"},
	{"4558","Della Valle Argentina"},
	{"4559","Della Valle Arroscia"},
	{"4560","Della Valle Aurina"},
	{"4561","Della Valle Brembana"},
	{"4562","Della Valle Caudina"},
	{"4563","Della Valle Cerrina"},
	{"4564","Della Valle D'aosta"},
	{"4565","Della Valle Dei Platani"},
	{"4566","Della Valle Del Basento"},
	{"4567","Della Valle Del Biferno"},
	{"4568","Della Valle Del Bradano"},
	{"4569","Della Valle Del Dittaino"},
	{"4570","Della Valle Del Ferro"},
	{"4571","Della Valle Del Garigliano"},
	{"4572","Della Valle Del Liri"},
	{"4573","Della Valle Del Sabato"},
	{"4574","Della Valle Del Salso"},
	{"4575","Della Valle Del Sele"},
	{"4576","Della Valle Del Sinni"},
	{"4577","Della Valle Del Tammaro"},
	{"4578","Della Valle Del Tavo"},
	{"4579","Della Valle Del Tirino"},
	{"4580","Della Valle Del Volturno"},
	{"4581","Della Valle Del Vomano"},
	{"4582","Della Valle Dell'aveto"},
	{"4583","Della Valsugana"},
	{"4584","Della Vandra"},
	{"4585","Della Venezia Giulia"},
	{"4586","Dell'abetone E Del Brennero"},
	{"4587","Dell'aeroporto Della Malpensa"},
	{"4588","Dell'alpago E Cansiglio"},
	{"4589","Dell'alpe Di Casaglia"},
	{"4590","Dell'alto Agri"},
	{"4591","Dell'alto Ofanto E Del Vulture"},
	{"4592","Dell'anglona"},
	{"4593","Dell'appennino Abruzzese E Appulo-Sannitico"},
	{"4594","Dell'appennino Meridionale (primo Tratto)"},
	{"4595","Dell'appennino Meridionale (secondo Tratto)"},
	{"4596","Dell'aremogna"},
	{"4597","Delle Calabrie"},
	{"4598","Delle Collacchie"},
	{"4599","Delle Colline"},
	{"4600","Delle Croci Di Acerno"},
	{"4601","Delle Dolomiti"},
	{"4602","Delle Fossiate"},
	{"4603","Delle Gambarie"},
	{"4604","Delle Grotte"},
	{"4605","Delle Grotte Orientali"},
	{"4606","Delle Langhe"},
	{"4607","Delle Murge"},
	{"4608","Delle Palade"},
	{"4609","Delle Puglie"},
	{"4610","Delle Saline"},
	{"4611","Delle Serre Calabre"},
	{"4612","Delle Solfare"},
	{"4613","Delle Terme Euganee"},
	{"4614","Delle Terme Luigiane"},
	{"4615","Delle Terme Salentine"},
	{"4616","Delle Tre Valli"},
	{"4617","Dell'esticino"},
	{"4618","Dell'etna E Delle Madonie"},
	{"4619","Dell'ischia Verde"},
	{"4620","Dell'isonzo"},
	{"4621","Dello Stelvio"},
	{"4622","Dell'ofanto"},
	{"4623","Demonte"},
	{"4624","Depot"},
	{"4625","Dermulo/Innesto Ss43 Della Val Di Non"},
	{"4626","Dermulo/Innesto Ss43 Diramazione Della Val Di Non"},
	{"4627","Desana"},
	{"4628","Desenzano"},
	{"4629","Desenzano Del Garda"},
	{"4630","Desenzano Del Garda/Innesto Ss572 Di Salo'"},
	{"4631","Desenzano Garda/Innesto Ss11 Padana Superiore"},
	{"4632","Desenzano Garda/Innesto Ss567 Del Benaco"},
	{"4633","Desenzano Sul Garda/Innesto Ss11 Padana Super."},
	{"4634","Destra Sesia"},
	{"4635","Destro"},
	{"4636","Dezzo Di Scalve"},
	{"4637","Di Acquaro"},
	{"4638","Di Acri"},
	{"4639","Di Adria"},
	{"4640","Di Affi"},
	{"4641","Di Agerola"},
	{"4642","Di Aidone"},
	{"4643","Di Alagna"},
	{"4644","Di Alberobello"},
	{"4645","Di Alemagna"},
	{"4646","Di Alimena"},
	{"4647","Di Altamura"},
	{"4648","Di Angera"},
	{"4649","Di Aritzo"},
	{"4650","Di Assisi"},
	{"4651","Di Atessa"},
	{"4652","Di Atri"},
	{"4653","Di Augusta"},
	{"4654","Di Bardonecchia"},
	{"4655","Di Bari Sardo"},
	{"4656","Di Baschi"},
	{"4657","Di Bisenti"},
	{"4658","Di Borgo D'ale"},
	{"4659","Di Brienza"},
	{"4660","Di Budduso' E Del Correboi"},
	{"4661","Di Buonviaggio"},
	{"4662","Di Caccamo"},
	{"4663","Di Caerano"},
	{"4664","Di Calitri"},
	{"4665","Di Calle"},
	{"4666","Di Caltagirone"},
	{"4667","Di Cammarata E Degli Stombi"},
	{"4668","Di Campiglio"},
	{"4669","Di Campli"},
	{"4670","Di Campobello Di Licata"},
	{"4671",""},
	{"4672","Di Canelli"},
	{"4673","Di Caramanico Terme"},
	{"4674","Di Carlo Felice"},
	{"4675","Di Casalborgone"},
	{"4676","Di Casarano"},
	{"4677","Di Cascia"},
	{"4678","Di Cassano"},
	{"4679","Di Castel Del Monte"},
	{"4680","Di Castelbuono"},
	{"4681","Di Castellammare Del Golfo"},
	{"4682","Di Castellamonte"},
	{"4683","Di Castello Di Brolio"},
	{"4684","Di Castelnovo"},
	{"4685","Di Castelsardo"},
	{"4686","Di Castelvetere"},
	{"4687","Di Castrovillari"},
	{"4688","Di Cengio"},
	{"4689","Di Ceresole"},
	{"4690","Di Cervia"},
	{"4691","Di Cervignano"},
	{"4692","Di Cesaro'"},
	{"4693","Di Cesena"},
	{"4694","Di Chianciano"},
	{"4695","Di Chiaramonte"},
	{"4696","Di Chiaravalle"},
	{"4697","Di Cingoli"},
	{"4698","Di Cividale"},
	{"4699","Di Codigoro"},
	{"4700","Di Correggio"},
	{"4701","Di Cortemaggiore"},
	{"4702","Di Crevalcore"},
	{"4703","Di Croce D'aune"},
	{"4704","Di Cropalati"},
	{"4705","Di Cropani"},
	{"4706","Di Devetaki"},
	{"4707","Di Diano Marina"},
	{"4708","Di Elmas"},
	{"4709","Di Fagnano"},
	{"4710","Di Fiuggi"},
	{"4711","Di Foiano"},
	{"4712","Di Folgaria E Di Val D'astico"},
	{"4713","Di Fondo Valle Alento"},
	{"4714","Di Fondo Valle D'agri"},
	{"4715","Di Fondo Valle Sangro"},
	{"4716","Di Fondo Valle Taro"},
	{"4717","Di Fondo Valle Trigno"},
	{"4718","Di Forca D'acero"},
	{"4719","Di Forca Di Penne"},
	{"4720","Di Fornovo"},
	{"4721","Di Fosdinovo"},
	{"4722","Di Frosinone E Di Gaeta"},
	{"4723","Di Galatina"},
	{"4724",""},
	{"4725","Di Genzano"},
	{"4726","Di Ghilarza"},
	{"4727","Di Giba"},
	{"4728","Di Gibellina"},
	{"4729","Di Ginosa"},
	{"4730","Di Gioia Del Colle"},
	{"4731","Di Gioia Tauro E Di Locri"},
	{"4732","Di Girifalco"},
	{"4733","Di Gorizia"},
	{"4734","Di Grado"},
	{"4735","Di Gradoli"},
	{"4736","Di Guardiagrele"},
	{"4737","Di Guasila"},
	{"4738","Di Gubbio E Piandassino"},
	{"4739","Di Isola Del Gran Sasso"},
	{"4740","Di Jamiano"},
	{"4741","Di Laconi E Di Uras"},
	{"4742","Di Leonessa"},
	{"4743","Di Lerici"},
	{"4744","Di Licata"},
	{"4745","Di Lignano"},
	{"4746","Di Logudoro"},
	{"4747","Di Lonigo"},
	{"4748","Di Loppio E Di Val Di Ledro"},
	{"4749","Di Lucera"},
	{"4750","Di Lucoli"},
	{"4751","Di Luzzi"},
	{"4752","Di Macugnaga"},
	{"4753","Di Magliano Sabina"},
	{"4754","Di Maglie E Di S. Cesarea"},
	{"4755","Di Maida E Squillace"},
	{"4756","Di Mandatoriccio"},
	{"4757","Di Manoppello"},
	{"4758","Di Marcatobianco"},
	{"4759","Di Marina Di Pisa"},
	{"4760","Di Massafra"},
	{"4761","Di Massazza"},
	{"4762","Di Mater Domini"},
	{"4763","Di Matera"},
	{"4764","Di Mazze'"},
	{"4765","Di Mesagne"},
	{"4766","Di Moncalvo"},
	{"4767","Di Mongiana"},
	{"4768","Di Mongrando"},
	{"4769","Di Monreale"},
	{"4770","Di Monte Amiata"},
	{"4771","Di Monte Cucco E Monte Pecoraro"},
	{"4772","Di Monte Luco"},
	{"4773","Di Monte Oliveto"},
	{"4774","Di Montecalvo Irpino"},
	{"4775","Di Montecassino"},
	{"4776","Di Montefiorino"},
	{"4777","Di Montemolino"},
	{"4778","Di Monterchi"},
	{"4779","Di Montevarchi"},
	{"4780","Di Monti"},
	{"4781","Di Mormanno"},
	{"4782","Di Morro"},
	{"4783","Di Naro"},
	{"4784","Di Norcia"},
	{"4785","Di Noto"},
	{"4786","Di Oropa"},
	{"4787","Di Ortanova"},
	{"4788","Di Orzinuovi"},
	{"4789","Di Otranto"},
	{"4790","Di Ozieri"},
	{"4791","Di Paganico"},
	{"4792","Di Palagonia"},
	{"4793","Di Palau"},
	{"4794","Di Palinuro"},
	{"4795","Di Palmanova"},
	{"4796","Di Palombara"},
	{"4797","Di Parabita"},
	{"4798","Di Passo Corese"},
	{"4799","Di Pedivigliano"},
	{"4800","Di Pescolanciano"},
	{"4801","Di Pietraperzia"},
	{"4802","Di Plessiva"},
	{"4803","Di Polizzi"},
	{"4804","Di Polla"},
	{"4805","Di Pontestura"},
	{"4806","Di Pontinvrea"},
	{"4807","Di Porto Ceresio"},
	{"4808","Di Porto Empedocle"},
	{"4809","Di Porto S.Stefano"},
	{"4810","Di Portofino"},
	{"4811","Di Portovenere"},
	{"4812","Di Potame"},
	{"4813","Di Pozzuolo"},
	{"4814","Di Rapolano"},
	{"4815","Di Ravanusa"},
	{"4816","Di Ravello"},
	{"4817","Di Recoaro"},
	{"4818","Di Redipuglia"},
	{"4819","Di Ribera"},
	{"4820","Di Roccadaspide"},
	{"4821","Di S. Maria Di Leuca"},
	{"4822","Di S.Angelo Dei Lombardi"},
	{"4823","Di S.Giorgio Jonico"},
	{"4824","Di S.Giovanni Rotondo"},
	{"4825","Di S.Matteo Decima"},
	{"4826","Di S.Vittoria"},
	{"4827","Di Salesei"},
	{"4828","Di Salo'"},
	{"4829","Di Salsomaggiore E Di Bardi"},
	{"4830","Di Saluzzo"},
	{"4831","Di San Gavino E Del Flumini"},
	{"4832","Di San Marino"},
	{"4833","Di Santeramo"},
	{"4834","Di Sapri"},
	{"4835","Di Sarteano"},
	{"4836","Di Savelli"},
	{"4837","Di Savigliano"},
	{"4838","Di Scandiano"},
	{"4839","Di Sella Mandrazzi"},
	{"4840","Di Seui E Lanusei"},
	{"4841","Di Sibiola"},
	{"4842","Di Solda"},
	{"4843","Di Sora"},
	{"4844","Di Spilimbergo"},
	{"4845","Di Summonte E Di Montevergine"},
	{"4846","Di Taurisano"},
	{"4847","Di Teano"},
	{"4848","Di Trinitapoli"},
	{"4849","Di Troina"},
	{"4850","Di Tropea"},
	{"4851","Di Uccea"},
	{"4852","Di Ururi"},
	{"4853","Di Uscio"},
	{"4854","Di Val Badia"},
	{"4855","Di Val Bormida"},
	{"4856","Di Val Cecina"},
	{"4857","Di Val D'agri"},
	{"4858","Di Val D'arno"},
	{"4859","Di Val D'assa E Pedemontana Costo"},
	{"4860","Di Val D'ega E Passo Di Costalunga"},
	{"4861","Di Val D'elsa"},
	{"4862","Di Val D'enza"},
	{"4863","Di Val Di Foro E Di Bocca Di Valle"},
	{"4864","Di Val Di Setta E Val Di Bisenzio"},
	{"4865","Di Val Di Trebbia"},
	{"4866","Di Val Di Vara"},
	{"4867","Di Val Gardena E Passo Sella"},
	{"4868","Di Val Gerola"},
	{"4869","Di Val Macra"},
	{"4870","Di Val Masino"},
	{"4871","Di Val Monastero"},
	{"4872","Di Val Nure"},
	{"4873","Di Val Sarentino E Del Passo Di Vizze"},
	{"4874","Di Valfabbrica"},
	{"4875","Di Valle Antigorio E Val Formazza"},
	{"4876","Di Valle Cannobina"},
	{"4877","Di Valle Scrivia"},
	{"4878","Di Velate"},
	{"4879","Di Venosa"},
	{"4880","Di Vibo Valentia"},
	{"4881","Di Vignola"},
	{"4882","Di Vigo Di Cadore"},
	{"4883","Di Villa Di Tirano"},
	{"4884","Di Villa Maina"},
	{"4885","Di Villa Stellone"},
	{"4886","Di Villacidro"},
	{"4887","Diacceto"},
	{"4888","Diano Marina"},
	{"4889","Diano Marina/Innesto Ss1 Aurelia"},
	{"4890","Diano Marina/Innesto Ss449 Di Diano Marina"},
	{"4891","Dicomano"},
	{"4892","Dicomano/Innesto Ss551 Traversa Del Mugello"},
	{"4893","Dicomano/Innesto Ss67 Tosco Romagnola"},
	{"4894","Dignano"},
	{"4895","Dignano/Incrocio Con La Ss464 Di Spilimbergo"},
	{"4896","Dignano/Innesto Ss463 Del Tagliamento"},
	{"4897","Digonera"},
	{"4898","Dimaro"},
	{"4899","Dimaro/Innesto Ss239 Di Campiglio"},
	{"4900","Dimaro/Innesto Ss42 Del Tonale E Della Mendola"},
	{"4901","Dinami"},
	{"4902","Diramazione A  Via Appia"},
	{"4903","Diramazione A Fondo Valle Del Biferno"},
	{"4904","Diramazione Adriatica"},
	{"4905","Diramazione Agordina"},
	{"4906","Diramazione Ariana"},
	{"4907","Diramazione B Del Porto Di Ancona"},
	{"4908","Diramazione B Fondo Valle Del Biferno (strada Ingotte)"},
	{"4909","Diramazione Balvano - Ss7"},
	{"4910","Diramazione Briantea"},
	{"4911","Diramazione C Del Porto Di Pescara"},
	{"4912","Diramazione C Via Appia"},
	{"4913","Diramazione D'aspromonte"},
	{"4914","Diramazione Dei Balzi Rossi"},
	{"4915","Diramazione Dei Cairoli"},
	{"4916","Diramazione Dei Giovi"},
	{"4917","Diramazione Dei Monti Lepini"},
	{"4918","Diramazione Dei Trulli"},
	{"4919","Diramazione Del Centro Direzionale"},
	{"4920","Diramazione Del Colle Di Nava"},
	{"4921","Diramazione Del Golfo Di Policastro"},
	{"4922","Diramazione Del Gran Sasso D'italia"},
	{"4923","Diramazione Del Lago Ampollino"},
	{"4924","Diramazione Del Lago Di Albano"},
	{"4925","Diramazione Del Lago Di Como E Dello Spluga"},
	{"4926","Diramazione Del Monte Terminio"},
	{"4927","Diramazione Del Pasubio"},
	{"4928","Diramazione Della Val Di Cembra"},
	{"4929","Diramazione Della Val Di Non"},
	{"4930","Diramazione Della Valle Brembana"},
	{"4931","Diramazione Della Valle D'aosta"},
	{"4932","Diramazione Della Valle Del Volturno"},
	{"4933","Diramazione Dell'alpago E Cansiglio"},
	{"4934","Diramazione Dell'alto Agri"},
	{"4935","Diramazione Dell'alto Ofanto E Del Vulture"},
	{"4936","Diramazione Dell'aremogna"},
	{"4937","Diramazione Delle Calabrie"},
	{"4938","Diramazione Di Assisi"},
	{"4939","Diramazione Di Bardonecchia"},
	{"4940","Diramazione Di Campli"},
	{"4941","Diramazione Di Carlo Felice"},
	{"4942","Diramazione Di Cascia"},
	{"4943","Diramazione Di Castelvetere"},
	{"4944","Diramazione Di Castrovillari"},
	{"4945","Diramazione Di Fondo Valle Alento"},
	{"4946","Diramazione Di Fosdinovo"},
	{"4947","Diramazione Di Frosinone E Gaeta"},
	{"4948","Diramazione Di Genzano"},
	{"4949","Diramazione Di Gioia Tauro E Locri"},
	{"4950","Diramazione Di Loppio E Di Val Di Ledro"},
	{"4951","Diramazione Di Monte Cucco E Monte Pecoraro"},
	{"4952","Diramazione Di Monte Curcio"},
	{"4953","Diramazione Di Monte Luco"},
	{"4954","Diramazione Di Montevergine"},
	{"4955","Diramazione Di Naro"},
	{"4956","Diramazione Di Val D'assa E Pedemontana Costo"},
	{"4957","Diramazione Di Val Di Vara"},
	{"4958","Diramazione Di Val Gardena E Passo Sella"},
	{"4959","Diramazione Di Villacidro"},
	{"4960","Diramazione Iglesiente"},
	{"4961","Diramazione Jonica"},
	{"4962","Diramazione Litoranea Delle Cinque Terre"},
	{"4963","Diramazione Massese"},
	{"4964","Diramazione Nord Occidentale Sarda"},
	{"4965","Diramazione Orientale Sarda"},
	{"4966","Diramazione Per Petrignano D'assisi"},
	{"4967","Diramazione Piceno Aprutina"},
	{"4968","Diramazione Regina"},
	{"4969","Diramazione Romea"},
	{"4970","Diramazione S.S.V. Licata-Torrente Braemi"},
	{"4971","Diramazione Sarzanese Valdera (diramazione Per Volterra)"},
	{"4972","Diramazione Settentrionale Sicula"},
	{"4973","Diramazione Sorrentina"},
	{"4974","Diramazione Strada Cadorna"},
	{"4975","Diramazione Strada Della Verna"},
	{"4976","Diramazione Sublacense"},
	{"4977","Diramazione Sud Occidentale Sarda"},
	{"4978","Diramazione Sud Occidentale Sicula"},
	{"4979","Diramazione Ticinese"},
	{"4980","Diramazione Tirrena Inferiore"},
	{"4981","Diramazione Val Pescara-Chieti"},
	{"4982","Diramazione Via Casilina"},
	{"4983","Diramazione Via Cassia"},
	{"4984","Diramazione Via Salaria"},
	{"4985","Diramazione Via Tiburtina Valeria"},
	{"4986","Diramazione Aeroporto Falcone E Borsellino"},
	{"4987","Dir/A Centro Occidentale Sicula"},
	{"4988","Dir/A Della Val Di Non"},
	{"4989","Dir/A Dello Stelvio"},
	{"4990","Dir/A Di Badia Di Cava"},
	{"4991","Dir/A Di Budduso' E Del Correboi"},
	{"4992","Dir/A Di Castel Del Monte"},
	{"4993","Dir/A Diramazione Per Caltanissetta"},
	{"4994","Dir/A Garganica"},
	{"4995","Dir/B Dello Stelvio"},
	{"4996","Dir/B Di Budduso' E Del Correboi"},
	{"4997","Dir/B Di Castel Del Monte"},
	{"4998","Dir/B Garganica"},
	{"4999","Dir/B Tirrena Inferiore"},
	{"5000","Dir/C Centro Occidentale Sicula"},
	{"5001","Dir/Centr. Nuorese"},
	{"5002","Diramazione Per Trapani"},
	{"5003","Diramazione A19-Imera"},
	{"5004","Diramazione Aeroporto Di Birgi"},
	{"5005","Diramazione Capodichino"},
	{"5006",""},
	{"5007","Diramazione Lucca-Viareggio"},
	{"5008","Diramazione Nord Milano-Ghisolfa"},
	{"5009","Diramazione Opicina-Fernetti"},
	{"5010","Diramazione Padova Sud"},
	{"5011","Diramazione Per Capodichino"},
	{"5012","Diramazione Per Fiorenzuola"},
	{"5013","Diramazione Per Gallarate-Gattico"},
	{"5014","Diramazione Per Moncalieri"},
	{"5015","Diramazione Per Pinerolo"},
	{"5016","Diramazione Per Ravenna"},
	{"5017",""},
	{"5018","Diramazione Predosa-Bettole"},
	{"5019","Diramazione Roma Nord"},
	{"5020","Diramazione Roma Sud"},
	{"5021","Diramazione S.Stefano Magra"},
	{"5022","Diramazione Stroppiana-Santhia'"},
	{"5023","Diramazione Sud Milano-Ghisolfa"},
	{"5024","Dirindello"},
	{"5025","Dittaino Staz."},
	{"5026","Divieto"},
	{"5027","Dobbiaco Nuovo"},
	{"5028","Dobbiaco/Innesto Ss49 Della Pusteria"},
	{"5029","Dobbiaco/Innesto Ss51 Di Alemagna"},
	{"5030","Doccio"},
	{"5031","Dogana Di Coccau-Confine Di Stato"},
	{"5032","Dogana Nuova"},
	{"5033","Dogana S.Andrea-Confine Con La Slovenia"},
	{"5034","Dogana Vecchia/Innesto Ss48 Bis Delle Dolomiti"},
	{"5035","Dogana Vecchia/Innesto Ss48 Delle Dolomiti"},
	{"5036","Doganella"},
	{"5037","Doganella Nord"},
	{"5038","Doganelle"},
	{"5039","Dogato"},
	{"5040","Dogliani"},
	{"5041","Dogliola"},
	{"5042","Dogna"},
	{"5043","Dolce'"},
	{"5044","Dolmen Di Bisceglie"},
	{"5045","Dolo"},
	{"5046","Dolo-Mirano"},
	{"5047","Domanico"},
	{"5048","Domaso"},
	{"5049","Domegge Di Cadore"},
	{"5050","Domegliara"},
	{"5051","Domodossola"},
	{"5052","Domus De Maria"},
	{"5053","Domusnovas"},
	{"5054","Dongo"},
	{"5055","Donigala Fenughedu"},
	{"5056","Donnaz"},
	{"5057","Donnici Inferiore"},
	{"5058","Donoratico"},
	{"5059","Dont/Innesto Ss251 Della Val Di Zoldo E Val Cellina"},
	{"5060","Dont/Innesto Ss347 Del P. Cereda E Del P. Duran"},
	{"5061","Dorgali"},
	{"5062","Dormelletto"},
	{"5063","Dorno"},
	{"5064","Dorsino"},
	{"5065","Dosoledo/Innesto Ss52 Carnica"},
	{"5066","Dosoledo/Innesto Ss532 Del Passo Di S.Antonio"},
	{"5067","Dosso"},
	{"5068","Dossobuono"},
	{"5069","Dovadola"},
	{"5070","Dovera"},
	{"5071","Dragonara"},
	{"5072","Dragoncello"},
	{"5073","Dragoni"},
	{"5074","Dragoni/Innesto Ss158 Della Valle Del Volturno"},
	{"5075","Dragoni/Innesto Ss372 Telesina"},
	{"5076","Dres"},
	{"5077","Dro'"},
	{"5078","Dronero"},
	{"5079","Drosso - Allacciamento Tangenziale Sud Di Torino"},
	{"5080","Druogno"},
	{"5081","Dubino"},
	{"5082","Dueville"},
	{"5083","Dugenta"},
	{"5084","Duino"},
	{"5085","Eboli"},
	{"5086","Eboli/Svincolo Per A3 Salerno-Reggio C."},
	{"5087","Edolo"},
	{"5088","Edolo/Innesto Ss39 Del Passo Di Aprica"},
	{"5089","Edolo/Innesto Ss42 Del Tonale E Della Mendola"},
	{"5090","Egna Ora"},
	{"5091","Egnazia E Delle Terme Di Torre Canne"},
	{"5092","Emilia Romagna"},
	{"5093","Empoli"},
	{"5094","Empoli/Innesto S.G.C. Fi-Pi-Li"},
	{"5095","Endine Gaiano"},
	{"5096","Enemonzo"},
	{"5097","Enna"},
	{"5098","Enna/Innesto Ss117 Bis Centrale Sicula"},
	{"5099","Entrampo"},
	{"5100","Entreves"},
	{"5101","Episcopia"},
	{"5102","Eraclea/Innesto Ss106 Jonica"},
	{"5103","Eraclea/Innesto Ss598 Di Fondo Valle D'agri"},
	{"5104","Erba"},
	{"5105","Ercolano"},
	{"5106","Ercolano-Portici"},
	{"5107","Eremo"},
	{"5108","Erli"},
	{"5109","Erto"},
	{"5110","Escovedu"},
	{"5111","Esino"},
	{"5112","Est"},
	{"5113","Este"},
	{"5114","Este/Innesto Ss10 Padana Inferiore"},
	{"5115","Este/Innesto Ss247 Riviera"},
	{"5116",""},
	{"5117","Etroubles"},
	{"5118","Eugubina"},
	{"5119","Europa"},
	{"5120","Fabbrecce"},
	{"5121","Fabbrica"},
	{"5122","Fabbriche"},
	{"5123","Fabriano Est/Svincolo Ss76 Var"},
	{"5124","Fabrizia"},
	{"5125","Fabro"},
	{"5126","Fadalto"},
	{"5127","Fadalto-Lago Di S.Croce"},
	{"5128","Fado"},
	{"5129","Faedis"},
	{"5130","Faenza"},
	{"5131","Faenza/Incrocio Ss9 Emilia"},
	{"5132","Faenza/Innesto Ss302 Brisighellese Ravennate"},
	{"5133","Fagnano Castello"},
	{"5134","Faiti/Incrocio Ss7 Appia"},
	{"5135","Falasche"},
	{"5136","Falcade"},
	{"5137","Falcade Alto"},
	{"5138","Falcero"},
	{"5139","Falchera"},
	{"5140",""},
	{"5141","Falciano/Confine Con La Repubblica Di S.Marino"},
	{"5142","Falciano-Confine Con La Repubblica Di S.Marino"},
	{"5143","Falconara Alta/Innesto Ss16 Adriatica"},
	{"5144","Falconara Alta/Innesto Ss76 Var Della Val D'esino"},
	{"5145","Falcone"},
	{"5146","Falerna"},
	{"5147","Falerna Marina"},
	{"5148","Falerna Scalo"},
	{"5149","Falerna/Svincolo Per A3 Salerno-Reggio C."},
	{"5150","Falerna-Lamezia Terme"},
	{"5151","Falsomiele"},
	{"5152","Faltona"},
	{"5153","Fanano"},
	{"5154","Fandetta"},
	{"5155","Fanghetto/Confine Con La Francia"},
	{"5156","Fango"},
	{"5157","Fano"},
	{"5158","Fano - Raccordo Per Fossombrone"},
	{"5159","Fano/Innesto Ss16 Adriatica"},
	{"5160","Fano/Innesto Ss3 Flaminia"},
	{"5161","Fano-Zona Industriale"},
	{"5162","Fara Filiorum Petri/Innesto Ss263 Di Val Di Foro"},
	{"5163","Fara Filiorum/Incrocio Ss81 Piceno Aprutina"},
	{"5164","Fara Novarese"},
	{"5165","Fara S.Martino"},
	{"5166","Fardella"},
	{"5167","Farini"},
	{"5168","Farra"},
	{"5169","Farra D'isonzo"},
	{"5170","Farra/Innesto Ss422 Dell'alpago E Cansiglio"},
	{"5171","Farra/Innesto Ss422 Dir"},
	{"5172","Fasano"},
	{"5173","Fasano'"},
	{"5174","Fasano Del Garda"},
	{"5175","Fasano/Innesto Ss16 Adriatica"},
	{"5176","Fasano/Innesto Ss172 Diramazione Dei Trulli"},
	{"5177","Fasano/Innesto Ss379 Egnazia"},
	{"5178","Fastro"},
	{"5179","Favara"},
	{"5180","Favaro Dese"},
	{"5181","Favazzina"},
	{"5182","Faver"},
	{"5183","Fegotto-Allacciamento A29 Pa-Mazara Del Vallo"},
	{"5184","Felegara"},
	{"5185","Felitto"},
	{"5186","Felizzano"},
	{"5187","Fella Est"},
	{"5188","Feltre"},
	{"5189","Feltre/Innesto Ss348 Feltrina"},
	{"5190","Feltre/Innesto Ss473 Di Croce D'aune"},
	{"5191","Feltre/Innesto Ss50 D. Grappa E Del Passo Di Rolle"},
	{"5192","Feltre/Innesto Ss50 Del Grappa E Del Passo Rolle"},
	{"5193","Feltrina"},
	{"5194","Femminamorta"},
	{"5195","Fenadora/Innesto Ss50 Bis Del Grappa E Passo Rolle"},
	{"5196","Fenadora/Innesto Ss50 Del Grappa E Del Passo Rolle"},
	{"5197","Fener"},
	{"5198","Fenestrelle"},
	{"5199","Fenile"},
	{"5200","Ferdinandea"},
	{"5201","Ferentillo"},
	{"5202","Ferentino"},
	{"5203","Feriolo"},
	{"5204","Feriolo/Innesto Ss33 Del Sempione"},
	{"5205","Feriolo/Innesto Ss33 Racc Del Sempione"},
	{"5206","Fermana Faleriense"},
	{"5207","Fermo"},
	{"5208","Fermo-Porto S.Giorgio"},
	{"5209","Fernetti"},
	{"5210","Fernetti-Confine Con La Slovenia"},
	{"5211","Feronia"},
	{"5212","Ferrandina Sud"},
	{"5213","Ferrandina/Innesto Ss 7 Racc Via Appia"},
	{"5214","Ferrandina/Innesto Ss407 Basentana"},
	{"5215","Ferrara"},
	{"5216","Ferrara Nord"},
	{"5217","Ferrara Sud"},
	{"5218","Ferrara Sud/Raccordo Ferrara - Porto Garibaldi"},
	{"5219","Ferrara/Innesto Ss16 Adriatica"},
	{"5220","Ferrara/Innesto Ss496 Virgiliana"},
	{"5221","Ferrara/Innesto Ss64 Porrettana"},
	{"5222","Ferrara-Ss 16 Adriatica"},
	{"5223","Ferraro"},
	{"5224","Ferriera"},
	{"5225","Ferriere"},
	{"5226","Ferrito"},
	{"5227","Ferro Di Cavallo/Innesto Raccordo Bettolle-Pg"},
	{"5228","Fezzano"},
	{"5229","Fiamenga"},
	{"5230","Fiano Romano"},
	{"5231","Fiave"},
	{"5232","Ficarazzi"},
	{"5233","Ficulle"},
	{"5234","Fidenza"},
	{"5235","Fidenza/Innesto Ss359 Di Salsomaggiore E Di Bardi"},
	{"5236","Fidenza/Innesto Ss588 Dei Due Ponti"},
	{"5237","Fidenza/Innesto Ss9 Emilia"},
	{"5238","Fienil Dei Frati"},
	{"5239","Fienili"},
	{"5240","Fiera Di Primiero"},
	{"5241","Fiera Di Primiero/Innesto Ss50 Del Grappa E P.Rolle"},
	{"5242","Fiera Primiero/Innesto Ss347 Passo Cereda E Duran"},
	{"5243","Fiesso D'artico"},
	{"5244","Figline Valdarno"},
	{"5245","Figlioli"},
	{"5246","Filippa"},
	{"5247","Filipponi"},
	{"5248","Filorera"},
	{"5249","Filottrano"},
	{"5250","Finalborgo/Innesto Ss490 Del Colle Del Melogno"},
	{"5251","Finalborgo/Innesto Ss490Diramazione Del Colle Del Melogno"},
	{"5252","Finale"},
	{"5253","Finale Emilia"},
	{"5254","Finale Ligure"},
	{"5255","Finale Ligure/Innesto Ss1 Aurelia"},
	{"5256","Finale Ligure/Innesto Ss490 Del Colle Del Melogno"},
	{"5257","Fine Autostrada"},
	{"5258","Fine Circonvallazione Di Predazzo"},
	{"5259","Fine Est"},
	{"5260","Fine Galleria Cote De Sorreley"},
	{"5261",""},
	{"5262","Fine Traforo (francia)"},
	{"5263","Fine Traforo-Dogana (svizzera)"},
	{"5264","Fine Tratto In Comune Con Ss19"},
	{"5265","Fine Traversa Di Bologna"},
	{"5266","Fine Traversa Di Chiaravalle"},
	{"5267","Fine Traversa Di Fabriano"},
	{"5268","Fine Traversa Di Jesi"},
	{"5269","Fine Variante Curve Di S.Rocco"},
	{"5270","Fine Variante Di Camerino"},
	{"5271","Fine Variante Di Etroubles"},
	{"5272","Fine Variante Di Fabriano/Staz. Albacina"},
	{"5273","Fine Variante Di Lavino"},
	{"5274","Fine Variante Di Lozzo Di Cadore"},
	{"5275","Fino Mornasco"},
	{"5276","Finocchio"},
	{"5277","Fiorano Modenese"},
	{"5278","Fiorenza-Allacciamento A4 (milano V.Le Certosa)"},
	{"5279","Fiorenza-Allacciamento A8(milano V.Le Certosa)"},
	{"5280",""},
	{"5281","Fiorenzuola A1"},
	{"5282","Fiorenzuola D'arda"},
	{"5283","Fiorenzuola D'arda/Innesto Ss462 Della Valle D'arda"},
	{"5284","Fiorenzuola D'arda/Innesto Ss9 Emilia"},
	{"5285","Fiorenzuola-Diramazione Per La A1 Mi-Na"},
	{"5286","Firenze"},
	{"5287","Firenze Certosa"},
	{"5288","Firenze Certosa-A1 Milano-Napoli"},
	{"5289","Firenze Nord"},
	{"5290","Firenze Nord - Allacciamento A1 Mi-Na"},
	{"5291",""},
	{"5292","Firenze Sud"},
	{"5293","Firenze/Innesto Ss2 Cassia"},
	{"5294","Firenze/Innesto Ss2 Diramazione Cassia"},
	{"5295","Firenze/Innesto Ss66 Pistoiese"},
	{"5296","Firenze/Innesto Ss67 Tosco Romagnola"},
	{"5297","Firenze/Innesto Ss67 Tosco-Romagnola"},
	{"5298","Firenze-Peretola"},
	{"5299","Firenze-Pisa Nord"},
	{"5300","Firenzuola"},
	{"5301","Firenzuola/Innesto Ss503 Del Passo Del Gioco"},
	{"5302","Firenzuola/Innesto Ss610 Selice E Montanara Imolese"},
	{"5303",""},
	{"5304","Firmo/Innesto Ss105 Di Castrovillari"},
	{"5305","Firmo/Innesto Ss534 Di Cammarata E Degli Stombi"},
	{"5306","Fisciano-Mercato S.Severino"},
	{"5307","Fiuggi"},
	{"5308","Fiuggi Fonte/Innesto Ss155 Di Fiuggi"},
	{"5309","Fiumalbo"},
	{"5310","Fiumana"},
	{"5311","Fiumefreddo"},
	{"5312","Fiumefreddo Bruzio"},
	{"5313","Fiumefreddo Di Sicilia"},
	{"5314","Fiumefreddo/Innesto Ss114 Orientale Sicula"},
	{"5315","Fiumefreddo/Innesto Ss120 Dell'etna E Delle Madonie"},
	{"5316","Fiumicino"},
	{"5317","Fiumicino Aeroporto"},
	{"5318","Fivizzano"},
	{"5319","Flaminia"},
	{"5320","Floresta"},
	{"5321","Floridia"},
	{"5322","Floronzo"},
	{"5323","Flumeri"},
	{"5324","Fluminimaggiore"},
	{"5325","Flussio"},
	{"5326","Foce"},
	{"5327","Foce Di Terrarossa"},
	{"5328","Foggia"},
	{"5329","Foggia - A14 Bologna-Taranto"},
	{"5330","Foggia - Innesto Ss544"},
	{"5331","Foggia - Innesto Ss89"},
	{"5332","Foggia Nord"},
	{"5333","Foggia Nord Innesto Tangenziale Di Foggia"},
	{"5334","Foggia Nord-Innesto Ss16"},
	{"5335","Foggia Sud"},
	{"5336","Foggia Sud - Innesto Ss16 Adriatica"},
	{"5337","Foggia Sud/Innesto Tangenziale Di Foggia"},
	{"5338","Foggia/Innesto Ss17 App. Abruz. Appulo-Sannitico"},
	{"5339","Foggia/Innesto Ss546 Troiana"},
	{"5340","Foggia/Innesto Ss90 Delle Puglie"},
	{"5341","Foggia/Innesto Tangenziale Di Foggia"},
	{"5342","Foglia"},
	{"5343","Fogliano"},
	{"5344","Fogliano Redipuglia"},
	{"5345","Fognano"},
	{"5346","Foiano Della Chiana"},
	{"5347","Foiano Di Val Fortore"},
	{"5348","Folgaria"},
	{"5349","Follonica"},
	{"5350","Fondachello"},
	{"5351","Fondaco Motta"},
	{"5352","Fondi"},
	{"5353","Fondi/Innesto Ss637 Di Frosinone E Di Gaeta"},
	{"5354","Fondi/Innesto Ss7 Appia"},
	{"5355","Fondo"},
	{"5356","Fondo Toce/Innesto Ss34 Del Lago Maggiore"},
	{"5357","Fondo Valle Del Biferno"},
	{"5358","Fondo Valle Del Noce"},
	{"5359","Fondo Valle Del Tappino"},
	{"5360","Fondo/Innesto Ss238 Delle Palade"},
	{"5361","Fondo/Innesto Ss238 Racc (raccordo Di Fondo)"},
	{"5362","Fondo/Innesto Ss238 Racc Delle Palade"},
	{"5363","Fondo/Innesto Ss42 Del Tonale E Della Mendola"},
	{"5364","Fondotoce"},
	{"5365","Fondotoce/Innesto Ss33 Racc Del Sempione"},
	{"5366","Fonni"},
	{"5367","Fonni/Innesto Ss389 Di Budduso' E Del Correboi"},
	{"5368","Fonni/Innesto Ss389 Dir/B Budduso' E Correboi"},
	{"5369","Fontana"},
	{"5370","Fontana Di Papa"},
	{"5371","Fontana Liri"},
	{"5372","Fontana Retitto/Innesto Ss400 Di Castelvetere"},
	{"5373","Fontana Retitto/Innesto Ss425 S.Angelo Dei Lombardi"},
	{"5374","Fontanafredda"},
	{"5375","Fontanarosa"},
	{"5376","Fontanazzo"},
	{"5377","Fontanelice"},
	{"5378","Fontanella"},
	{"5379","Fontanelle"},
	{"5380","Fontaniva"},
	{"5381","Fonte"},
	{"5382","Fonte Alla Roccia"},
	{"5383","Fonte Di Fiuggi/Innesto Ss155 Racc"},
	{"5384","Fonte Minerale Di Salice"},
	{"5385","Fonteblanda"},
	{"5386","Fontebuona"},
	{"5387","Fontecchio"},
	{"5388","Fontespina"},
	{"5389","Fonti Del Clitunno"},
	{"5390","Forca Di Penne"},
	{"5391","Forcella Di Lavardet/Innesto Ss465"},
	{"5392","Forcella Lavardet/Innesto Ss619 Di Vigo Di Cadore"},
	{"5393","Forcella Staulanza"},
	{"5394","Fordongianus"},
	{"5395","Foresta/Innesto Ss109 Della Piccola Sila"},
	{"5396","Foresta/Innesto Ss109ter Della Piccola Sila"},
	{"5397","Foresta/Innesto Superstrada Merano-Bolzano"},
	{"5398","Foresta-Innesto Ss38 Dello Stelvio"},
	{"5399","Foria"},
	{"5400","Foria/Innesto Ss447 Di Palinuro"},
	{"5401","Foria/Innesto Ss447 Racc/A Di Palinuro"},
	{"5402","Forino"},
	{"5403","Forio"},
	{"5404","Forli'"},
	{"5405","Forli' Del Sannio"},
	{"5406","Forli'/Innesto Ss67 Tosco Romagnola"},
	{"5407","Forli'/Innesto Ss9 Emilia"},
	{"5408","Forli'/Innesto Ss9 Ter Del Rabbi"},
	{"5409","Forli'/Innesto Ss9 Via Emilia"},
	{"5410","Forlimpopoli"},
	{"5411","Formazza"},
	{"5412","Formia"},
	{"5413","Formia/Innesto Ss213 Via Flacca"},
	{"5414","Formia/Innesto Ss7 Appia"},
	{"5415","Formia/Innesto Ss7 Appia/Innesto Ss213 Flacca"},
	{"5416","Formia/Innesto Ss7 Var. Formia Garigliano"},
	{"5417","Formica"},
	{"5418","Formigliana"},
	{"5419","Formolosa"},
	{"5420","Fornacette"},
	{"5421","Fornacette/Innesto Ss67 Bis Tosco Romagnola"},
	{"5422","Fornacette/Innesto Ss67 Tosco Romagnola"},
	{"5423","Fornaci Di Barga"},
	{"5424","Fornaci S.Lucia"},
	{"5425","Fornesighe"},
	{"5426","Forni"},
	{"5427","Forni Avoltri"},
	{"5428","Forni Di Sopra"},
	{"5429","Forni Di Sotto"},
	{"5430","Forno Allione/Innesto Ss294 Della Val Di Sclave"},
	{"5431","Forno Allione/Innesto Ss42 Del Tonale E Mendola"},
	{"5432","Forno Di Zoldo/Innesto Ss251"},
	{"5433","Forno Di Zoldo/Innesto Ss347"},
	{"5434","Fornole"},
	{"5435","Fornovo"},
	{"5436","Fornovo Di Taro"},
	{"5437","Fornovo Di Taro/Innesto Ss308 Fondo Valle Taro"},
	{"5438","Fornovo Di Taro/Innesto Ss357 Di Fornovo"},
	{"5439","Fornovo Di Taro/Innesto Ss62 Della Cisa"},
	{"5440","Foro Ortona/Francavilla/Innesto Ss16 Adriatica"},
	{"5441","Forte Di Nava"},
	{"5442","Fortezza"},
	{"5443","Fosdinovo"},
	{"5444","Fosdinovo/Innesto Ss446 Di Fosdinovo"},
	{"5445","Fosdinovo/Innesto Ss446 Diramazione Di Fosdinovo"},
	{"5446","Fossacesia"},
	{"5447","Fossacesia Mar./Innesto Ss652 Fondo Valle Sangro"},
	{"5448","Fossacesia Marina/Innesto Ss16 Adriatica"},
	{"5449","Fossano"},
	{"5450","Fossano (ss28)"},
	{"5451","Fossano/Innesto Raccordo Di Fossano"},
	{"5452","Fossano-Allacciamento A6 Torino-Savona"},
	{"5453",""},
	{"5454","Fossano-Ss28 Del Colle Di Nava"},
	{"5455","Fossatello"},
	{"5456","Fossato Serralta"},
	{"5457","Fossiata"},
	{"5458","Fossombrone"},
	{"5459","Fossombrone Est"},
	{"5460","Fossombrone Ovest"},
	{"5461","Fossombrone/Innesto Raccordo Fano-Fossombrone"},
	{"5462","Fraccano"},
	{"5463","Fragagnano"},
	{"5464","Fragneto Monforte"},
	{"5465","Francavilla A Mare"},
	{"5466","Francavilla A./Innesto Ss110"},
	{"5467","Francavilla A./Innesto Ss522 Di Tropea"},
	{"5468","Francavilla Al Mare/Innesto Ss16 Adriatica"},
	{"5469","Francavilla Angitola/Innesto Ss18 Tirrena Inferiore"},
	{"5470","Francavilla Di Sicilia"},
	{"5471","Francavilla Fontana"},
	{"5472","Francavilla Fontana/Innesto Ss603 S.Giorgio Jonico"},
	{"5473","Francavilla Fontana/Innesto Ss7 Appia"},
	{"5474","Francavilla Mare/Innesto Ss649 Fondo Valle Alento"},
	{"5475","Francesca"},
	{"5476","Francofonte"},
	{"5477","Frascati"},
	{"5478","Frascati/Innesto Con La Ss215 E Ss216"},
	{"5479","Frascati/Innesto Ss216 E Ss218"},
	{"5480","Frascati/Innesto Ss218 Via Rocca Di Papa E Ss215"},
	{"5481","Frascineto"},
	{"5482","Frascineto-Castrovillari"},
	{"5483","Frassene'"},
	{"5484","Frassino"},
	{"5485","Fratta"},
	{"5486","Fratta Todina"},
	{"5487","Frattamaggiore"},
	{"5488","Frattocchie/Innesto Ss207 Nettunense"},
	{"5489","Frattocchie/Innesto Ss7 Appia"},
	{"5490","Fregona"},
	{"5491","Frejus"},
	{"5492","Frentana"},
	{"5493","Friuli Venezia-Giulia"},
	{"5494","Frosini"},
	{"5495","Frosinone"},
	{"5496","Frosinone/Innesto Ss155 Di Fiuggi"},
	{"5497","Frosinone/Innesto Ss6 Via Casilina"},
	{"5498","Frosinone/Innesto Ss637 Di Frosinone E Di Gaeta"},
	{"5499","Frosinone/Innesto Ss214 Maria E Isola Casamari"},
	{"5500","Frosolone"},
	{"5501","Fucecchio"},
	{"5502","Fucine"},
	{"5503","Fulgatore"},
	{"5504","Fumo"},
	{"5505","Funivia Del Gran Sasso"},
	{"5506","Funnuto Passo"},
	{"5507","Fuorigrotta"},
	{"5508","Fuorni"},
	{"5509","Furci"},
	{"5510","Furci Siculo"},
	{"5511","Furiano-Allacciamento Ss113"},
	{"5512","Furlo Di Acqualagna"},
	{"5513","Furore"},
	{"5514","Furtei/Innesto Ss197 Di S. Gavino E Del Flumini"},
	{"5515","Furtei/Innesto Ss547 Di Guasila"},
	{"5516","Fuschi"},
	{"5517","Fusine"},
	{"5518","Fusine In Valromana"},
	{"5519","Futani"},
	{"5520","Futani/Innesto Ss18 Tirrena Inferiore"},
	{"5521","Futani/Innesto Ss447 Racc/A Di Palinuro"},
	{"5522","G.R.A."},
	{"5523","Gabella Nuova"},
	{"5524","Gabelletta"},
	{"5525","Gabelletta/Svincolo Ss79 Ternana"},
	{"5526","Gabellino"},
	{"5527","Gabetti"},
	{"5528","Gabutti"},
	{"5529","Gaggi"},
	{"5530","Gaggiano"},
	{"5531","Gaggio Montano"},
	{"5532","Gaglianico"},
	{"5533","Gagliano"},
	{"5534","Gaiano"},
	{"5535","Gaibana"},
	{"5536","Gaiola"},
	{"5537","Gaiole In Chianti"},
	{"5538","Gairo"},
	{"5539","Gairo S.Elena"},
	{"5540","Gairo Taquisara"},
	{"5541","Gais"},
	{"5542","Galati"},
	{"5543","Galatina"},
	{"5544","Galatone"},
	{"5545","Galatone/Innesto Ss101 Salentina Di Gallipoli E Ss497"},
	{"5546","Galatone/Innesto Ss174 Salentina Di Manduria/Ss497"},
	{"5547","Galatone/Innesto Ss101 Salentina Di Gallipoli E Ss174"},
	{"5548","Galdo"},
	{"5549","Galeata"},
	{"5550","Gallarate"},
	{"5551","Gallarate/Innesto Ss336 Dell'Aeroporto Della Malpensa"},
	{"5552","Gallarate/Innesto Ss341 Gallaratese"},
	{"5553","Gallaratese"},
	{"5554","Gallareto Primo"},
	{"5555","Galleria"},
	{"5556","Galleria Artificiale Casale Di Pari"},
	{"5557","Galleria Artificiale Tassinetta"},
	{"5558","Galleria Artificiale Valle Della Vigna"},
	{"5559","Galleria Casale"},
	{"5560","Galleria Del Monte Bianco"},
	{"5561","Galleria Dell'annunziata Lunga"},
	{"5562","Galleria Delle Chiavi"},
	{"5563","Galleria Di Amistani"},
	{"5564","Galleria Di Biassa"},
	{"5565","Galleria Di Crozi"},
	{"5566","Galleria Di Laste"},
	{"5567","Galleria Di Limaro"},
	{"5568","Galleria Di Madesimo"},
	{"5569","Galleria Di Ponte Pia"},
	{"5570","Galleria Di Val Brasa"},
	{"5571","Galleria Madonna Del Ponte"},
	{"5572","Galleria Porretta"},
	{"5573","Galleria S.Vito"},
	{"5574","Galletti"},
	{"5575","Galliate"},
	{"5576","Gallico"},
	{"5577","Gallico Marina"},
	{"5578","Gallico Marina/Innesto Ss184 Delle Gambarie"},
	{"5579","Gallico/Innesto Ss18 Tirrena Inferiore"},
	{"5580","Galliera Veneta"},
	{"5581","Gallipoli/Innesto Ss101 Salentina Di Gallipoli"},
	{"5582","Gallipoli/Innesto Ss274 Salentina Merid."},
	{"5583","Gallipoli/Innesto Ss459 Di Parabita"},
	{"5584","Gallipoli/Innesto Ss274 Salentina Di Patu'"},
	{"5585","Gallitello"},
	{"5586","Gallo"},
	{"5587","Gallo Di Petriano"},
	{"5588","Galtelli"},
	{"5589","Galugnano"},
	{"5590","Gamalero"},
	{"5591","Gambarie"},
	{"5592","Gambarie/Innesto Ss183 Aspromonte Jonio"},
	{"5593","Gambarie/Innesto Ss184 Delle Gambarie"},
	{"5594","Gambatesa"},
	{"5595","Gangi"},
	{"5596","Ganna"},
	{"5597","Ganzirri"},
	{"5598","Garaguso"},
	{"5599","Garbagna Novarese"},
	{"5600","Garda"},
	{"5601","Gardesana Orientale"},
	{"5602","Gardone Riv./Innesto Ss45 Bis/Diramazione Del Vittoriale"},
	{"5603","Gardone Riviera"},
	{"5604","Gardone Riviera/Innesto Ss45 Bis Gardesana Occ.Le"},
	{"5605","Gardone Val Trompia"},
	{"5606","Garessio"},
	{"5607","Garganica"},
	{"5608","Gargano Est"},
	{"5609","Gargazzone"},
	{"5610","Gargnano"},
	{"5611","Garlasco"},
	{"5612","Garrufo"},
	{"5613","Garzara-Sabbioni"},
	{"5614","Gassano"},
	{"5615","Gassano/Innesto Ss445 Della Garfagnana"},
	{"5616","Gassano/Innesto Ss63 Del Valico Del Cerreto"},
	{"5617","Gassino Torinese"},
	{"5618","Gattico"},
	{"5619","Gattinara/Innesto Ss142 Biellese"},
	{"5620","Gattinara/Innesto Ss594 Destra Sesia"},
	{"5621","Gattorna"},
	{"5622","Gattorna/Innesto Ss225 Della Fontanabuona"},
	{"5623","Gattorna/Innesto Ss333 Di Uscio"},
	{"5624","Gavagnano"},
	{"5625","Gavardo"},
	{"5626","Gaviserri"},
	{"5627","Gavoi"},
	{"5628","Gazzada - Innesto A8 Mi-Va"},
	{"5629","Gazzada (a8)"},
	{"5630","Gazzi"},
	{"5631","Gazzo"},
	{"5632","Gazzo Di Bigarello"},
	{"5633","Gazzuolo"},
	{"5634","Gela/Innesto Ss115 Sud Occidentale Sicula"},
	{"5635","Gela/Innesto Ss117 Bis Centrale Sicula"},
	{"5636","Gelagna Bassa"},
	{"5637","Gelso Bianco"},
	{"5638","Gemona/Innesto Ss13 Pontebbana"},
	{"5639","Gemona/Innesto Ss512 Del Lago Di Cavazzo"},
	{"5640","Gemona-Osoppo"},
	{"5641","Gemonio"},
	{"5642","Genestrello"},
	{"5643","Genivolta"},
	{"5644","Genola"},
	{"5645","Genola/Innesto Ss20 Del Colle Di Tenda E Valle Roja"},
	{"5646","Genola/Innesto Ss28 Del Colle Di Nava"},
	{"5647","Genova"},
	{"5648","Genova Aeroporto"},
	{"5649","Genova Bolzaneto"},
	{"5650","Genova Est"},
	{"5651","Genova Nervi"},
	{"5652","Genova Pegli"},
	{"5653","Genova Staglieno"},
	{"5654","Genova Voltri"},
	{"5655","Genova Voltri - Innesto Ss1 Aurelia"},
	{"5656","Genova Voltri/Innesto Ss1 Aurelia"},
	{"5657","Genova Voltri/Innesto Ss456 Del Turchino"},
	{"5658","Genova Voltri-Gravellona Toce"},
	{"5659","Genova/Innesto Ss1 Aurelia"},
	{"5660","Genova/Innesto Ss35 Dei Giovi"},
	{"5661","Genova/Innesto Ss45 Di Val Trebbia"},
	{"5662","Genova-Rosignano"},
	{"5663","Genova-Ventimiglia"},
	{"5664","Genzano"},
	{"5665","Genzano Di Lucania"},
	{"5666","Gerace"},
	{"5667","Geraci Siculo"},
	{"5668","Gerbini"},
	{"5669","Gerenzano"},
	{"5670","Germignaga"},
	{"5671","Gerola"},
	{"5672","Gesturi"},
	{"5673","Gesualdo"},
	{"5674","Ghedi"},
	{"5675","Ghemme"},
	{"5676","Ghertele"},
	{"5677","Ghetto Randuzzi"},
	{"5678","Ghiare"},
	{"5679","Ghibullo"},
	{"5680","Ghiffa"},
	{"5681","Ghirla"},
	{"5682","Ghisalba"},
	{"5683","Ghislarengo"},
	{"5684","Ghisolfa Nord"},
	{"5685",""},
	{"5686","Ghisolfa Sud"},
	{"5687","Giacciano Con Baruchella"},
	{"5688","Giammoro"},
	{"5689","Giampilieri Marina"},
	{"5690","Giardinetto"},
	{"5691","Giardinetto Vecchio/Innesto Ss160 Di Lucera"},
	{"5692","Giardinetto Vecchio/Innesto Ss90 Delle Puglie"},
	{"5693","Giardini Naxos"},
	{"5694","Giardini Naxos Centro"},
	{"5695","Giarratana"},
	{"5696","Giarre"},
	{"5697","Giavera Del Montello"},
	{"5698","Giba"},
	{"5699","Giba/Innesto Ss195 Sulcitana"},
	{"5700","Giba/Innesto Ss293 Di Giba"},
	{"5701","Gibellina Nuova"},
	{"5702","Gibellina Vecchia"},
	{"5703","Giglio"},
	{"5704","Gignod"},
	{"5705","Gildone"},
	{"5706","Gildonese"},
	{"5707","Ginosa"},
	{"5708","Giogo Di S.Maria/Confine Con La Svizzera"},
	{"5709","Gioia Colle/Innesto Ss100 Gioia Del C. E Ss604"},
	{"5710","Gioia Dei Marsi"},
	{"5711","Gioia Del Colle"},
	{"5712","Gioia Del Colle/Innesto Ss100 E Ss171 Di Santeramo"},
	{"5713","Gioia Del Colle/Innesto Ss604 Alberobello E Ss171"},
	{"5714","Gioia Tauro"},
	{"5715","Gioia Tauro/Incrocio Ss111 Di Gioia Tauro E Locri"},
	{"5716","Gioia Tauro/Innesto Ss18 Tirrena Inferiore"},
	{"5717","Gioiosa Marea"},
	{"5718","Gionghi"},
	{"5719","Giove"},
	{"5720","Giovi"},
	{"5721","Giovinazzo"},
	{"5722","Giovo Ligure/Innesto Ss334 Del Sassello"},
	{"5723","Giovo Ligure/Innesto Ss542 Di Pontinvrea"},
	{"5724","Girasole"},
	{"5725","Girifalco"},
	{"5726","Girifalco/Innesto Ss181 Di Maida E Squillace"},
	{"5727","Girifalco/Innesto Ss384 Di Girifalco"},
	{"5728","Girini"},
	{"5729","Gisbenti"},
	{"5730","Giubiano"},
	{"5731","Giugliano In Campania/Innesto Ss162"},
	{"5732","Giugliano In Campania/Innesto Ss265 Ponti D. Valle"},
	{"5733","Giuliana"},
	{"5734","Giulianova Lido"},
	{"5735","Giulianova Lido/Innesto Ss16 Adriatica"},
	{"5736","Giulianova Lido/Innesto Ss262 Di Campli"},
	{"5737","Giulianova/Innesto Ss16 Adriatica"},
	{"5738","Giulianova/Innesto Ss80 Del Gran Sasso D'italia"},
	{"5739","Giusvalla"},
	{"5740","Givizzano"},
	{"5741","Gizzeria"},
	{"5742","Gizzeria Lido"},
	{"5743","Gizzi"},
	{"5744","Gleris"},
	{"5745","Gliaca"},
	{"5746","Glorenza"},
	{"5747","Glorie"},
	{"5748","Gnignano"},
	{"5749","Gnocchetto"},
	{"5750","Godega Di S.Urbano"},
	{"5751","Godiasco"},
	{"5752","Godo/Innesto Ss253 S.Vitale"},
	{"5753","Godo/Innesto Ss302 Brisighellese-Ravennate"},
	{"5754","Goitese"},
	{"5755","Goito"},
	{"5756","Goletto Delle Crocette"},
	{"5757","Gomagoi"},
	{"5758","Gomagoi/Innesto Ss38 Dello Stelvio"},
	{"5759","Gomagoi/Innesto Ss622 Di Solda"},
	{"5760","Gonars"},
	{"5761","Gonengo"},
	{"5762","Gonnosfanadiga"},
	{"5763","Goraiolo"},
	{"5764","Gorgo Chiesa"},
	{"5765","Gorgoglione"},
	{"5766","Gorgonzola"},
	{"5767","Gorizia"},
	{"5768","Gorizia/Confine Con La Slovenia"},
	{"5769","Gorizia/Innesto Ss351 Di Cervignano"},
	{"5770","Gorizia/Innesto Ss55 Dell'isonzo"},
	{"5771","Gorizia/Innesto Ss55 Racc Dell'isonzo"},
	{"5772","Gorizia/Innesto Ss56 Di Gorizia"},
	{"5773","Gorra"},
	{"5774","Gorzegno"},
	{"5775","Gorzone"},
	{"5776","Gosaldo"},
	{"5777","Governolo"},
	{"5778","Gozzano"},
	{"5779","Gra-Aurelia"},
	{"5780","Gracciano"},
	{"5781","Gracciano Dell'elsa"},
	{"5782","Gradisca D'isonzo"},
	{"5783","Gradisca D'isonzo/Incrocio Ss252 Di Palmanova"},
	{"5784","Gradisca D'isonzo/Incrocio Ss305 Di Redipuglia"},
	{"5785","Gradisca D'isonzo/Incrocio Ss351 Di Cervignano"},
	{"5786","Gradisca D'isonzo/Innesto Ss252 Di Palmanova"},
	{"5787","Gradisca D'isonzo/Innesto Ss351 Di Cervignano"},
	{"5788","Gradisca/Allacciamento Raccordo Villesse-Gorizia"},
	{"5789","Grado"},
	{"5790","Gradoli"},
	{"5791","Gradoli/Innesto Ss74 Maremmana"},
	{"5792","Gragnana"},
	{"5793","Gragnano"},
	{"5794","Graile' Di Sondalo/Inizio Var. A Scorr.Veloce"},
	{"5795","Gramignana"},
	{"5796","Grammichele"},
	{"5797","Grammichele Est"},
	{"5798","Grammichele Mazzarone"},
	{"5799","Grammichele Ovest-Caltagirone"},
	{"5800","Gran Bosco Salbertrand"},
	{"5801","Gran S.Bernardo/Confine Con La Svizzera"},
	{"5802","Grande Raccordo Anulare Di Roma"},
	{"5803","Grangia Avigliana"},
	{"5804","Granieri"},
	{"5805","Grassano"},
	{"5806","Grassano Staz./Innesto Ss407 Basentana"},
	{"5807","Grassano/Innesto Ss7 Appia"},
	{"5808","Grassina"},
	{"5809","Gratacasolo"},
	{"5810","Gravellona Toce"},
	{"5811","Gravellona Toce/A26 Genova V.-Gravellona T."},
	{"5812","Gravellona Toce/Innesto Ss229 Del Lago D'orta"},
	{"5813","Gravellona Toce/Innesto Ss33 Del Sempione/Allacciamento A26"},
	{"5814","Gravellona Toce/Innesto Ss33 E Ss34"},
	{"5815","Gravellona Toce/Innesto Ss34 Del L.Maggiore/InnestoA26"},
	{"5816","Gravina In Puglia"},
	{"5817","Gravina In Puglia/Innesto Ss96 Barese"},
	{"5818","Gravina In Puglia/Innesto Ss97 Delle Murgie"},
	{"5819","Grazzanise"},
	{"5820","Grazzano Visconti"},
	{"5821","Greggio"},
	{"5822","Greve In Chianti"},
	{"5823","Griante"},
	{"5824","Grignano"},
	{"5825","Grignasco"},
	{"5826","Grilli"},
	{"5827","Grimaldi"},
	{"5828","Grimoldo/Innesto Ss112 D'aspromonte"},
	{"5829","Grimoldo/Innesto Ss18 Tirrena Inferiore"},
	{"5830","Grisciano"},
	{"5831","Grisignano"},
	{"5832","Grisignano Di Zocco"},
	{"5833","Gropello Cairoli"},
	{"5834","Groppo S.Giovanni/Innesto Ss523 Del C.Di Cento Croci"},
	{"5835","Groppo S.Giovanni/Innesto Ss308 Di Fondo Valle Taro"},
	{"5836","Grosio"},
	{"5837","Grosotto"},
	{"5838","Grosseto"},
	{"5839","Grosseto/Incrocio Ss1 Aurelia"},
	{"5840","Grosseto/Incrocio Ss322 Delle Collacchie"},
	{"5841","Grosseto/Innesto Ss1 Via Aurelia"},
	{"5842","Grosseto/Innesto Ss223 Di Paganico"},
	{"5843","Grotta Di S.Teodoro"},
	{"5844","Grottacalda"},
	{"5845","Grottaferrata"},
	{"5846","Grottaferrata/Incrocio Ss216 Maremmana Iii"},
	{"5847","Grottaferrata/Incrocio Ss511 Anagnina"},
	{"5848","Grottaglie"},
	{"5849","Grottaglie - Ss7"},
	{"5850","Grottaglie/Innesto Raccordo Taranto-Grottaglie"},
	{"5851","Grottaminarda"},
	{"5852","Grottaminarda/Innesto Ss90 Delle Puglie"},
	{"5853","Grottaminarda/Innesto Ss91 Della Valle Del Sele"},
	{"5854","Grottammare"},
	{"5855","Grotte Di Castro"},
	{"5856","Grotteria"},
	{"5857","Grotti"},
	{"5858","Grottole"},
	{"5859","Gruaro"},
	{"5860","Grumello"},
	{"5861","Grumes"},
	{"5862","Guagnano"},
	{"5863","Gualdo"},
	{"5864","Gualdo Tadino"},
	{"5865","Gualdo Tadino/Innesto Ss3 Via Flaminia"},
	{"5866","Gualdo Tadino/Innesto Ss444 Del Subasio"},
	{"5867","Gualtieri"},
	{"5868","Gualtieri/Incrocio Ss63 Del Valico Del Cerreto"},
	{"5869","Gualtieri/Innesto Ss62 Della Cisa"},
	{"5870","Gualtieri/Innesto Ss62 Diramazione Della Cisa"},
	{"5871","Gualtieri/Innesto Ss63 Del Valico Del Cerreto"},
	{"5872","Guarcino/Innesto Ss411 Diramazione Sublacense"},
	{"5873","Guarcino/Innesto Ss411 Sublacense"},
	{"5874","Guardamarina/Innesto Ss106 Jonica"},
	{"5875","Guardamarina/Innesto Ss653 Della Valle Del Sinni"},
	{"5876","Guardea"},
	{"5877","Guardia"},
	{"5878","Guardia Piemontese Marina"},
	{"5879","Guardia Sanframondi"},
	{"5880","Guardiagrele"},
	{"5881","Guardiaregia/Innesto Ss158 Dir"},
	{"5882","Guarenna Nuova"},
	{"5883","Guasila"},
	{"5884","Guasticce"},
	{"5885","Gubbio/Innesto Ss219 Di Gubbio E Pian D'assino"},
	{"5886","Gubbio/Innesto Ss298 Eugubina"},
	{"5887","Guglionesi"},
	{"5888","Guidizzolo"},
	{"5889","Guidonia"},
	{"5890","Guidonia Aereoporto"},
	{"5891","Guiglia"},
	{"5892","Guspini"},
	{"5893","Guspini/Innesto Ss126 Sud Occidentale Sarda"},
	{"5894","Guspini/Innesto Ss196 Di Villacidro"},
	{"5895","Guspini/Innesto Ss197 Di S.Gavino E Del Flumini"},
	{"5896","Helvia Recina"},
	{"5897","Iavre'"},
	{"5898","Idice"},
	{"5899","Igea Marina"},
	{"5900","Iglesias"},
	{"5901","Iglesias/Innesto Ss126 Sud Occidentale Sarda"},
	{"5902","Iglesias/Innesto Ss130 Iglesiente"},
	{"5903","Iglesiente"},
	{"5904","Il Bivio"},
	{"5905","Il Casone"},
	{"5906","Il Palazzo"},
	{"5907","Il Parchetto"},
	{"5908","Il Passo/Innesto Ss340 Diramazione Regina"},
	{"5909","Il Passo/Innesto Ss402 Valeriana"},
	{"5910","Il Poggione"},
	{"5911","Il Pontino/Innesto Ss665 Massese"},
	{"5912","Il Pontino/Innesto Ss665Diramazione Massese"},
	{"5913","Il Signorino"},
	{"5914","Il Vittoriale (piazzale Delle Arche)"},
	{"5915","Ilbono"},
	{"5916","Imer"},
	{"5917","Imola"},
	{"5918","Imola/Innesto Ss610 Selice E Montanara Imolese"},
	{"5919","Imola/Innesto Ss9 Emilia"},
	{"5920","Imperia"},
	{"5921","Imperia Est"},
	{"5922","Imperia Ovest"},
	{"5923","Imperia/Innesto Ss1 Aurelia"},
	{"5924","Imperia/Innesto Ss28 Del Colle Di Nava"},
	{"5925","Impostino"},
	{"5926","Incisa"},
	{"5927","Incrocio Cancelli E Campodiegoli/IncrocioSs76 Var"},
	{"5928","Incrocio Per Cancelli/IncrocioSs76 Var"},
	{"5929","Incrocio Per Fossato Di Vico/IncrocioSs76 Var"},
	{"5930","Incrocio Ss400 Di Castelvetere"},
	{"5931","Incrocio Ss527 Bustese/Busto Arsizio/Lonate"},
	{"5932","Incrocio Ss76 Var"},
	{"5933","Incrocio Ss76 Var Della Val D'esino"},
	{"5934","Incrocio Tangenziale Di Novara"},
	{"5935","Incrocio Settebagni"},
	{"5936","Incudine"},
	{"5937","Indicatore"},
	{"5938","Induno Olona"},
	{"5939","Inizio Abitato Sestri Levante"},
	{"5940","Inizio Circonvallazione Di Predazzo"},
	{"5941","Inizio Galleria Cote De Sorreley"},
	{"5942","Inizio Ponte Della Liberta'"},
	{"5943","Inizio Ss202 Triestina"},
	{"5944","Inizio Tangenziale Bologna"},
	{"5945","Inizio Traforo"},
	{"5946","Inizio Tratto In Comune Con Ss19"},
	{"5947","Inizio Traversa Di Bologna"},
	{"5948","Inizio Traversa Di Chiaravalle"},
	{"5949","Inizio Traversa Di Fabriano"},
	{"5950","Inizio Traversa Di Jesi"},
	{"5951","Inizio Variante Curve Di S.Rocco"},
	{"5952","Inizio Variante Di Etroubles"},
	{"5953","Inizio Variante Di Fabriano"},
	{"5954","Inizio Variante Di Lavino"},
	{"5955","Inizio Variante Di Lozzo Di Cadore"},
	{"5956","Innesto A29 Palermo-Mazara Del Vallo"},
	{"5957","Innesto Con La Strada Del Traforo Del Monte Bianco"},
	{"5958","Innesto Diramazione S.Stefano Di Magra"},
	{"5959","Innesto Grande Raccordo Anulare"},
	{"5960","Innesto Raccordo Ascoli-P.To D'ascoli"},
	{"5961","Innesto Raccordo Ascoli-Porto D'ascoli"},
	{"5962","Innesto Raccordo Civitavecchia-Tarquinia(e45)"},
	{"5963","Innesto Raccordo Ascoli-P.To D'ascoli"},
	{"5964","Innesto Raccordo Chieti Pescara"},
	{"5965","Innesto Raccordo Viterbo-Terni"},
	{"5966","Innesto S.G.C. Grosseto-Fano"},
	{"5967","Innesto S.G.C. Jonio-Tirreno"},
	{"5968","Innesto Sp Castelletto Cervo"},
	{"5969","Innesto Sp. Melfi-Ofanto"},
	{"5970","Innesto Sp18/A Ponte Del Grillo"},
	{"5971","Innesto Sp26/A Per Montelibretti"},
	{"5972","Innesto Ss1 Aurelia"},
	{"5973","Innesto Ss106 E Ss106 Ter"},
	{"5974","Innesto Ss106 Jonica"},
	{"5975","Innesto Ss11 Padana Superiore-Novara-Trecate"},
	{"5976","Inizio Variante/Innesto Ss12"},
	{"5977","Inizio Variante Di Ponte A Moriano"},
	{"5978","Innesto Ss124 Siracusana"},
	{"5979","Innesto Ss13 Pontebbana"},
	{"5980","Innesto Ss148 Pontina"},
	{"5981","Innesto Ss156 Dei Monti Lepini"},
	{"5982","Innesto Ss190 Delle Solfare"},
	{"5983","Innesto Ss211 Lomellina-Novara Sud"},
	{"5984","Innesto Ss212 Della Val Fortore"},
	{"5985","Innesto Ss224 Di Marina Di Pisa"},
	{"5986","Innesto Ss232"},
	{"5987","Innesto Ss315 Di Magliano S. Per Gallese"},
	{"5988","Innesto Ss318 Diramazione Per Petrignano D'assisi"},
	{"5989","Innesto Ss32 Ticinese"},
	{"5990","Innesto Ss329 Del Passo Di Bocca Di Valle"},
	{"5991","Innesto Ss341-Pernate-Galliate-Novara"},
	{"5992","Innesto Ss345 Delle Tre Valli"},
	{"5993","Innesto Ss35 Dei Giovi (direzione Genova)"},
	{"5994","Innesto Ss35 Dei Giovi (direzione Milano)"},
	{"5995","Innesto Ss374 Di Summonte E Montevergine"},
	{"5996","Innesto Ss42 Del Tonale E Della Mendola"},
	{"5997","Innesto Ss457 Di Montecalvo"},
	{"5998","Innesto Ss5 Quater Diramazione Del Casello Di Tagliacozzo"},
	{"5999","Innesto Ss5 Quater Tiburtina Valeria"},
	{"6000","Innesto Ss502 Di Cingoli"},
	{"6001","Innesto Ss53 Di Postumia (est)"},
	{"6002","Innesto Ss53 Di Postumia (ovest)"},
	{"6003",""},
	{"6004","Innesto Ss626 Diramazione S.S.V. Licata-Torrente Braemi"},
	{"6005","Innesto Ss645 Fondo Valle Tappino"},
	{"6006","Innesto Ss653 Della Valle Del Sinni"},
	{"6007","Innesto Ss7 Appia"},
	{"6008","Innesto Ss71 - Sgc Orte Ravenna"},
	{"6009","Innesto Ss80 Del Gran Sasso"},
	{"6010","Innesto Ss80 Racc Di Teramo"},
	{"6011","Innesto Ss9 Via Emilia"},
	{"6012","Innesto Ss9 Via Emilia (direzione Pc)"},
	{"6013","Innesto Ss9 Via Emilia (direzione Re)"},
	{"6014","Innesto Ss94/Svincolo Balvano Del Raccordo Sicignano Potenza"},
	{"6015","Innesto Strada Comunale S.Leonardo"},
	{"6016","Innesto Strada Regionale Per Grande Charriere"},
	{"6017","Innesto Superstrada Merano-Bolzano"},
	{"6018","Innesto Tangenziale Di Pavia (nord)"},
	{"6019","Innesto Tangenziale Di Pavia (sud)"},
	{"6020","Innesto Tangenziale Sud Di Verona"},
	{"6021","Innesto Tangenziale Di Novara"},
	{"6022","Innesto Variante Formia-Gariglano"},
	{"6023","Innesto Ss223/Ss2/Ss73 Raccordo Si-Bettolle"},
	{"6024","Innesto Sc Selva Piana"},
	{"6025","Innesto Sp10 Lodovica"},
	{"6026","Innesto Ss16 Adriatica"},
	{"6027","Innesto Ss18 E Ss281 Del Passo Di Limina"},
	{"6028",""},
	{"6029","Interneppo"},
	{"6030","Intra"},
	{"6031","Inverno"},
	{"6032","Irpinia"},
	{"6033","Irsina"},
	{"6034","Is Domus"},
	{"6035","Isarco Est"},
	{"6036","Isarco Ponte"},
	{"6037","Ischia Porto"},
	{"6038","Ischia Porto/Innesto Ss270 Dell'ischia Verde"},
	{"6039","Ischia Porto/Innesto Ss270 Raccordo Dell'ischia Verde"},
	{"6040","Ischitella Lido"},
	{"6041","Iselle"},
	{"6042","Iseo"},
	{"6043","Isernia"},
	{"6044","Isernia/Innesto Ss17 Dell'app. Abr. E App. Sann."},
	{"6045","Isernia/Innesto Ss650 Fondo Valle Trigno"},
	{"6046","Isili"},
	{"6047","Isola"},
	{"6048","Isola D'arbia"},
	{"6049","Isola D'asti"},
	{"6050","Isola Del Cantone"},
	{"6051","Isola Del Gran Sasso D'italia"},
	{"6052","Isola Del Liri"},
	{"6053","Isola Del Liri/Innesto Ss214 Maria E Isola Casamari"},
	{"6054","Isola Del Liri/Innesto Ss82 Della Valle Del Liri"},
	{"6055","Isola Del Liri-Innesto Ss82 Della Valle Del Liri"},
	{"6056","Isola Della Scala"},
	{"6057","Isola Di Fossara"},
	{"6058","Isola Di Rovegno"},
	{"6059","Isola Perosa"},
	{"6060","Isola Vicentina"},
	{"6061","Isolaccia"},
	{"6062","Isoletta"},
	{"6063","Ispica"},
	{"6064","Isso"},
	{"6065","Istonia"},
	{"6066","Istrago"},
	{"6067","Istrana"},
	{"6068","Italia"},
	{"6069","Itri"},
	{"6070","Itri/Innesto Ss7 Appia"},
	{"6071","Itri/Innesto Ss82 Della Valle Del Liri"},
	{"6072","Ittiri"},
	{"6073","Ivrea"},
	{"6074","Ivrea/Innesto Ss228 Del Lago Di Viverone"},
	{"6075","Ivrea/Innesto Ss26 Della Val D'aosta"},
	{"6076","Ivrea/Innesto Ss26 Della Valle D'aosta"},
	{"6077","Ivrea/Innesto Ss565 Di Castellamonte"},
	{"6078","Jacurso"},
	{"6079","Jamiano/Innesto Ss519 Di Jamiano"},
	{"6080","Jamiano/Innesto Ss55 Dell'isonzo"},
	{"6081","Jelsi"},
	{"6082","Jesi/Innesto Ss362 Jesina"},
	{"6083","Jesi/Innesto Ss76 Della Val D'esino"},
	{"6084","Jesina"},
	{"6085","Jonica"},
	{"6086","Judrio Ponte/Innesto Ss305 Di Redipuglia"},
	{"6087","La Baracca"},
	{"6088","La Berzigala"},
	{"6089","La Bisarca/Innesto Ss2 Cassia"},
	{"6090","La Bisarca/Innesto Ss478 Di Sarteano"},
	{"6091","La Botte"},
	{"6092","La California/Innesto Ss1 Var"},
	{"6093","La Casetta Di Covigliaio/Innesto Ss65 Della Futa"},
	{"6094","La Casetta/Innesto Ss503 Del Passo Del Giogo"},
	{"6095","La Catena"},
	{"6096","La Cicogna"},
	{"6097","La Crocetta/Innesto Sp102 Di Campo Felice"},
	{"6098","La Crosetta"},
	{"6099","La Dogana"},
	{"6100","La Fonte/Innesto Ss416 Del Niccone"},
	{"6101","La Fonte/Innesto Ss75bis Del Trasimeno"},
	{"6102","La Forca"},
	{"6103","La Forma"},
	{"6104","La Grucitta"},
	{"6105","La Lanterna Est"},
	{"6106","La Lima"},
	{"6107","La Lima/Innesto Ss12 Dell'abetone E Del Brennero"},
	{"6108","La Lima/Innesto Ss66 Pistoiese"},
	{"6109","La Loggia"},
	{"6110","La Macchia"},
	{"6111","La Maciona"},
	{"6112","La Maddalena Di Muccia/Innesto Ss77"},
	{"6113","La Maddalena/Innesto Ss131 Di Carlo Felice"},
	{"6114","La Maddalena/Innesto Ss209 Valnerina"},
	{"6115","La Maddalena/Innesto Ss388 Del Tirso E Mandrolisai"},
	{"6116","La Madonna"},
	{"6117","La Masera"},
	{"6118","La Muda"},
	{"6119","La Palud-Innesto Ss26 Diramazione Della V. D'aosta"},
	{"6120","La Pesa/Innesto Sp Di Morubio"},
	{"6121","La Pescia"},
	{"6122","La Pioppa"},
	{"6123","La Quercia"},
	{"6124","La Rotta"},
	{"6125","La Rustica Nord"},
	{"6126","La Santona"},
	{"6127","La Secca"},
	{"6128","La Secca/Innesto Ss422 Dell'alpago E Cansiglio"},
	{"6129","La Secca/Innesto Ss51 Di Alemagna"},
	{"6130","La Spera/Innesto Ss521 Di Morro"},
	{"6131","La Spera/Innesto Ss79 Ternana"},
	{"6132","La Spezia"},
	{"6133","La Spezia/Innesto Ss1 Aurelia"},
	{"6134","La Spezia/Innesto Ss331 Di Lerici"},
	{"6135","La Spezia/Innesto Ss370 Litoranea Delle 5 Terre"},
	{"6136","La Spezia-V.Le Carducci"},
	{"6137","La Stanga"},
	{"6138","La Sterza"},
	{"6139","La Storta"},
	{"6140","La Storta/Innesto Ss2 Cassia"},
	{"6141","La Storta/Innesto Ss493 Claudia Braccianese"},
	{"6142","La Thuile"},
	{"6143","La Toppa/Innesto Ss303 Del Formicoso"},
	{"6144","La Toppa/Innesto Ss91 Della Valle Del Sele"},
	{"6145","La Torre"},
	{"6146","La Traversa"},
	{"6147","La Valle Agordina"},
	{"6148","La Variante"},
	{"6149","La Villa"},
	{"6150","Labaro"},
	{"6151","Labiata"},
	{"6152","Labico"},
	{"6153","Laccio/Innesto Ss226 Di Valle Scrivia"},
	{"6154","Laccio/Innesto Ss45 Di Val Trebbia"},
	{"6155","Lacco Ameno"},
	{"6156","Lacedonia"},
	{"6157","Laconi"},
	{"6158","Laconi/Innesto Ss128 Centrale Sarda"},
	{"6159","Laconi/Innesto Ss442 Di Laconi E Uras"},
	{"6160","Laerru"},
	{"6161","Laerru/Innesto Ss127 Settentrionale Sarda"},
	{"6162","Laganadi"},
	{"6163","Lagaro"},
	{"6164","Laggio Di Cadore"},
	{"6165","Laghetti Di Egna"},
	{"6166","Laghi Di Monticchio"},
	{"6167","Laglio"},
	{"6168","Lago"},
	{"6169","Lago Albano/Innesto Ss140 Del Lago Di Albano"},
	{"6170","Lago Arvo/Innesto Ss108 Bis Silana Di Cariati"},
	{"6171","Lago Arvo/Innesto Ss178 Del Lago Arvo"},
	{"6172","Lago Di Albano"},
	{"6173","Lago Di Cecita/Innesto Ss177 Silana Di Rossano"},
	{"6174","Lago Di Cecita/Innesto Ss282 Delle Fossate"},
	{"6175","Lago Di Laceno"},
	{"6176","Lago Di Patria"},
	{"6177","Lago Di Patria/Innesto Ss7 Quater Via Domiziana"},
	{"6178","Lago Di Patria/Ss162 Della Valle Caudina"},
	{"6179","Lago Di S.Giuliano/Innesto Ss380 Dei Tre Confini"},
	{"6180","Lago Di S.Giuliano/Innesto Ss7 Appia"},
	{"6181","Lago Di Tenno"},
	{"6182","Lago Gusana/Innesto Ss128 Centrale Sarda"},
	{"6183","Lago Gusana/Innesto Ss389dir/B Budduso' E Correboi"},
	{"6184","Lago Patria/Innesto Ss7 Quater Via Domiziana"},
	{"6185","Lago Patria/Innesto Ss7 Quater/Dir"},
	{"6186","Lago Sirino/Innesto Ss104 Di Sapri"},
	{"6187","Lagonegro"},
	{"6188","Lagonegro Nord/Innesto Ss19 Delle Calabrie"},
	{"6189","Lagonegro Nord/Innesto Ss585 Fondo Valle Del Noce"},
	{"6190","Lagonegro Nord-Maratea"},
	{"6191","Lagonegro Sud"},
	{"6192","Lagonegro Sud/Innesto Ss19 Delle Calabrie"},
	{"6193","Lagonegro Sud/Innesto Ss585 Raccordo"},
	{"6194","Lagonegro/Innesto Ss585 Fondo Valle Del Noce"},
	{"6195","Lagonegro/Innesto Ss585 Racc Fondo Valle Del Noce"},
	{"6196","Lagrimone"},
	{"6197","Laigueglia"},
	{"6198","Lainate"},
	{"6199","Lainate-Como Chiasso"},
	{"6200","Laino Borgo"},
	{"6201","Laives"},
	{"6202","Lama Dei Peligni"},
	{"6203","Lama Mocogno"},
	{"6204","Lambro"},
	{"6205","Lamezia"},
	{"6206","Lamoli"},
	{"6207","Lana D'adige"},
	{"6208","Lanciano"},
	{"6209","Lanciano Fossacesia"},
	{"6210","Lanciano/Innesto Ss524 Lanciano Fossacesia"},
	{"6211","Lanciano/Innesto Ss84 Frentana"},
	{"6212","Lancusi"},
	{"6213","Landriano"},
	{"6214","Langhirano"},
	{"6215","Lanusei"},
	{"6216","Lanusei/Innesto Ss198 Di Seui E Lanusei"},
	{"6217","Lanusei/Innesto Ss390 Di Bari Sardo"},
	{"6218","Lanzago"},
	{"6219","Lappato"},
	{"6220","L'aquila"},
	{"6221","L'aquila Est"},
	{"6222","L'aquila Ovest"},
	{"6223","L'aquila/Bivio Per Ss17 Dell'app. Abruzzese"},
	{"6224","L'aquila/Innesto Ss17 Bis E Ss80 Del G.Sasso"},
	{"6225","L'aquila/Innesto Ss17 Dell'app. Abruzzese"},
	{"6226","L'aquila/Innesto Ss5 Bis Vestina-Sarentina"},
	{"6227","L'aquila/Innesto Ss615 Di Monte Luco"},
	{"6228","L'aquila/Innesto Ss80 Del G.Sasso"},
	{"6229","L'aquila/Innesto Ss615 Di Monte Luco E Innesto Ss80"},
	{"6230","Lardaro"},
	{"6231","Lariana"},
	{"6232","Lariano"},
	{"6233","Larino"},
	{"6234","Lario"},
	{"6235","Las Plassas"},
	{"6236","Lasa"},
	{"6237","Lastebasse"},
	{"6238","Lastra A Signa/Innesto Ss325 Di Val Setta E Bisenzio"},
	{"6239","Lastra A Signa/Innesto Ss67 Tosco Romagnola"},
	{"6240","Laterza"},
	{"6241","Laterza/Innesto Ss580 Di Ginosa"},
	{"6242","Laterza/Innesto Ss7 Appia"},
	{"6243","Latiano"},
	{"6244","Latina"},
	{"6245","Latisana"},
	{"6246","Latronico"},
	{"6247","Latte"},
	{"6248","Latte/Innesto Ss1 Aurelia"},
	{"6249","Latte/Innesto Ss1 Diramazione Dei Balzi Rossi"},
	{"6250","Laureana Di Borrello"},
	{"6251","Laurenzana"},
	{"6252","Lauretana"},
	{"6253","Laureto"},
	{"6254","Lauria Nord"},
	{"6255","Lauria Sud"},
	{"6256","Laurito"},
	{"6257","Lauro"},
	{"6258","Lavagna"},
	{"6259","Lavarone"},
	{"6260","Lavena Ponte Tresa"},
	{"6261","Laveno Mombello"},
	{"6262","Lavenone"},
	{"6263","Laviano"},
	{"6264","Lavina"},
	{"6265","Lavinio"},
	{"6266","Lavis/Innesto Ss12 Dell'abetone E Del Brennero"},
	{"6267","Lavis/Innesto Ss612 Della Val Di Cembra"},
	{"6268","Lavone"},
	{"6269","Lazio"},
	{"6270","Lazise"},
	{"6271","Lazise-Pastrengo"},
	{"6272","Lazzaro"},
	{"6273","Le Cave"},
	{"6274","Le Cento Croci"},
	{"6275","Le Chiaviche"},
	{"6276","Le Conie"},
	{"6277","Le Croci Di S.Maria Di Catanzaro/Innesto Ss19 Quater"},
	{"6278","Le Croci/Innesto Ss19bis Delle Calabrie"},
	{"6279","Le Fonti Est"},
	{"6280","Le Grazie"},
	{"6281","Le Mose"},
	{"6282","Le Piastre"},
	{"6283","Le Prese"},
	{"6284","Le Risaie Ovest"},
	{"6285","Le Rughe/Innesto Ss2 Cassia"},
	{"6286","Le Rughe/Innesto Ss2bis Cassia Veientana"},
	{"6287","Le Saline"},
	{"6288","Le Schiette"},
	{"6289","Le Ville"},
	{"6290","Le Ville/Innesto Ss73 Senese/Aretina"},
	{"6291","Leca"},
	{"6292","Leca/Innesto Ss453 Della Valle Arroscia"},
	{"6293","Leca/Innesto Ss582 Del Colle Di S. Bernardo"},
	{"6294","Lecce"},
	{"6295","Lecce/Innesto Ss101 E Ss476 Galatina"},
	{"6296","Lecce/Innesto Ss16 Adriatica E Ss101"},
	{"6297","Lecce/Innesto Ss16 Adriatica/Ss476 Di Galatina"},
	{"6298","Lecce/Raccordo Per Ss613 Brindisi-Lecce"},
	{"6299","Lecco"},
	{"6300","Lecco - Innesto Ss36 Del L. Di Como E Dello Spluga"},
	{"6301","Lecco (fine Ponte Kennedy)"},
	{"6302","Ledra"},
	{"6303","Leggiana"},
	{"6304","Legnago"},
	{"6305","Legnano"},
	{"6306","Legnaro"},
	{"6307","Lenese"},
	{"6308","Lenna"},
	{"6309","Lenno"},
	{"6310","Lenola"},
	{"6311","Lentini Nord"},
	{"6312","Lentini Sud"},
	{"6313","Lentiscosa"},
	{"6314","Leonessa"},
	{"6315","Leonessa/Innesto Sgc Parrozzo-Leonessa"},
	{"6316","Leonessa/Innesto Ss471 Di Leonessa"},
	{"6317","Leonessa/Innesto Ss521 Di Morro"},
	{"6318","Leonforte"},
	{"6319","Lequile"},
	{"6320","Lercara Friddi"},
	{"6321","Lercara Friddi/Innesto Ss188 Centro Occ. Sicula"},
	{"6322","Lercara Friddi/Innesto Ss189 Della Valle Dei Platani"},
	{"6323","Lerchi"},
	{"6324","Lesa"},
	{"6325","Leuciana"},
	{"6326","Levaldigi"},
	{"6327","Levane"},
	{"6328","Levane/Innesto Ss540 Di Valdambra"},
	{"6329","Levane/Innesto Ss69 Di Val D'arno"},
	{"6330","Levanto"},
	{"6331","Lezzeno"},
	{"6332","Liardi"},
	{"6333","Licata"},
	{"6334","Licata/Incrocio Ss115 Sud Occidentale Sicula"},
	{"6335","Licata/Incrocio Ss123 Di Licata"},
	{"6336","Licciana Nardi"},
	{"6337","Licenza"},
	{"6338","Licinese"},
	{"6339","Licodia (ss194)"},
	{"6340","Licodia Eubea-Innesto Ss194"},
	{"6341","Licola Mare"},
	{"6342","Lidarno Innesto Ss318 E Ss318 Var"},
	{"6343","Lidarno/Innesto 318 Var"},
	{"6344","Lidarno/Innesto Ss318 E Ss3 Bis (e45)"},
	{"6345","Lidarno/Innesto Ss318 Var E Ss3 Bis"},
	{"6346","Lido Dei Pini"},
	{"6347","Lido Delle Sirene"},
	{"6348","Lido Di Castel Fusano/Innesto Via C. Colombo"},
	{"6349","Lido Di Cincinnato"},
	{"6350","Lido Di Fermo"},
	{"6351","Lido Di Marechiaro"},
	{"6352","Lido Di Ostia/Innesto Ss8 E Ss601"},
	{"6353","Lido Di Ostia/Innesto Ss8 E Ss8 Bis"},
	{"6354","Lido Di Ostia/Innesto Ss8bis E Ss601"},
	{"6355","Lido Di Tor S.Lorenzo"},
	{"6356","Lido Tor Materno"},
	{"6357","Liguria"},
	{"6358","Lilla"},
	{"6359","Limena"},
	{"6360","Limenella"},
	{"6361","Limestre"},
	{"6362","Limone"},
	{"6363","Limone Sul Garda"},
	{"6364","Limonta"},
	{"6365","Limpiddu/Innesto Ss125 Orientale Sarda"},
	{"6366","Limpidi"},
	{"6367","Linguaglossa"},
	{"6368","Lioni"},
	{"6369","Lipomo"},
	{"6370","Lisanza"},
	{"6371","Lisiera"},
	{"6372","Lisignago"},
	{"6373","Listolade"},
	{"6374","Litoranea Delle Cinque Terre"},
	{"6375","Liveri"},
	{"6376","Liverniano"},
	{"6377","Livigno"},
	{"6378","Livorno"},
	{"6379","Livorno - Raccordo Per Livorno"},
	{"6380","Livorno Centro"},
	{"6381",""},
	{"6382","Livorno/Innesto S.G.C. Firenze-Pisa-Livorno"},
	{"6383","Livorno/Innesto Ss1 Aurelia"},
	{"6384","Livorno/Innesto Ss224 Di Marina Di Pisa"},
	{"6385","Livorno-Allacciamento A12 Genova-Rosignano"},
	{"6386","Lizzano In Belvedere"},
	{"6387","Loano"},
	{"6388","Locana"},
	{"6389","Locate Di Triulzi"},
	{"6390","Locate Varesino"},
	{"6391","Loceri"},
	{"6392","Loch"},
	{"6393","Loco"},
	{"6394","Locorotondo"},
	{"6395","Locorotondo/Innesto Ss172 Dei Trulli"},
	{"6396","Locorotondo/Innesto Ss172 Diramazione Dei Trulli"},
	{"6397","Locri"},
	{"6398","Locri/Innesto Ss106 Jonica"},
	{"6399","Locri/Innesto Ss111 Di Gioia Tauro E Locri"},
	{"6400","Lodi"},
	{"6401","Lodi/Incrocio Ss9 Emilia"},
	{"6402","Lodi/Innesto Ss235 Di Orzinuovi"},
	{"6403","Lodi/Innesto Ss472 Bergamina"},
	{"6404","Lodrone"},
	{"6405","L'ogliese"},
	{"6406","Lograto"},
	{"6407","Loiano"},
	{"6408","Lombardia"},
	{"6409","Lombardore"},
	{"6410","Lombriasco"},
	{"6411","Lomello"},
	{"6412","Lonate Pozzolo"},
	{"6413","Lonato/Innesto Ss11 Padana Superiore"},
	{"6414","Lonato/Innesto Ss668 Lenese"},
	{"6415","Londa"},
	{"6416","Londa-Stia"},
	{"6417","Longano"},
	{"6418","Longare"},
	{"6419","Longarone/Incrocio Ss51 Di Alemagna"},
	{"6420","Longarone/Innesto Ss251 Val Di Zoldo E Val Cellina"},
	{"6421","Longega"},
	{"6422","Longobardi/Innesto Ss18 Tirrena Inferiore"},
	{"6423","Longobardi/Innesto Ss182 Delle Serre Calabre"},
	{"6424","Longobucco"},
	{"6425","Lonigo"},
	{"6426","Loreggia"},
	{"6427","Lorenzago Di Cadore"},
	{"6428","Loreto"},
	{"6429","Loreto Aprutino"},
	{"6430","Loreto/Innesto Ss16 Adriatica"},
	{"6431","Loreto/Innesto Ss77 Della Val Di Chienti"},
	{"6432","Loreto-Porto Recanati"},
	{"6433","Lorica"},
	{"6434","Lotzorai"},
	{"6435","Lova"},
	{"6436","Lovere"},
	{"6437","Lovere/Innesto Ss42 Del Tonale E Della Mendola"},
	{"6438","Lovere/Innesto Ss469 Sebina Occidentale"},
	{"6439","Lovero"},
	{"6440","Lovino/Innesto Ss378 Di Altamura"},
	{"6441","Lozzo Di Cadore"},
	{"6442","Lozzo Di Cadore/Innesto Ss51 Bis Di Alemagna"},
	{"6443","Lozzo Di Cadore/Innesto Ss52 Carnica"},
	{"6444","Lu Bagnu"},
	{"6445","Lucca"},
	{"6446","Lucca S.Donato"},
	{"6447","Lucca/Innesto Ss12 Dell'abetone E Del Brennero"},
	{"6448","Lucca/Innesto Ss12 Radd Diramazione Lucchese"},
	{"6449","Lucca/Innesto Ss435 Lucchese"},
	{"6450","Lucca/Innesto Ss439 Sarzanese Valdera"},
	{"6451","Lucchese"},
	{"6452","Lucera"},
	{"6453","Lucera/Innesto Ss17 Dell'app. Abruzz. E App. Sann"},
	{"6454","Lucignano"},
	{"6455","Lucinico"},
	{"6456","Lucino"},
	{"6457","Lucito"},
	{"6458","Lucito/Innesto Ss647 Fondo Valle Del Biferno"},
	{"6459","Lucoli"},
	{"6460","Lucrezia"},
	{"6461","Lucugnano"},
	{"6462","Lugnano In Teverina"},
	{"6463","Lugo"},
	{"6464","Lugo Cotignola"},
	{"6465","Luino"},
	{"6466","Lunata"},
	{"6467","Lunetta Di Mantova/Innesto Ss10 E Ss482"},
	{"6468","Lunetta M./Innesto Ss10 Padana Inferiore"},
	{"6469","Lunetta M./Innesto Ss482 Alto Polesana E Ss236 Bis"},
	{"6470","Lunghezza"},
	{"6471","Lungomare Di Cagliari"},
	{"6472","Lungro"},
	{"6473","Lupara/Innesto Ss544 Di Trinitapoli"},
	{"6474","Lupara/Innesto Ss545 Rivolese"},
	{"6475","Lurate Caccivio"},
	{"6476","Lutago"},
	{"6477","Luzzara"},
	{"6478","Luzzi"},
	{"6479","M.Cristo/Innesto Ss17bis/Dir/B"},
	{"6480","M.Cristo/Innesto Ss17 Bis Della Funivia Del G.Sasso"},
	{"6481","Maccagno"},
	{"6482","Maccarese-Fregene"},
	{"6483","Macchia Di Isernia"},
	{"6484","Macchiagodena"},
	{"6485","Macchietto"},
	{"6486","Macenano"},
	{"6487","Macerata"},
	{"6488","Macerata-Civitanova M."},
	{"6489","Macere/Innesto Ss600 Ariana"},
	{"6490","Macerone"},
	{"6491","Maclodio"},
	{"6492","Macomer/Innesto Ss129 Bis Trasversale Sarda"},
	{"6493","Macomer/Innesto Ss131 Di Carlo Felice"},
	{"6494","Mad. Tirano/Innesto Ss38 Dir/A Dello Stelvio"},
	{"6495","Maddaloni"},
	{"6496","Maddaloni/Incrocio Ss265 Dei Ponti Della Valle"},
	{"6497","Maddaloni/Incrocio Ss7 Appia"},
	{"6498","Madergnano"},
	{"6499","Maderno"},
	{"6500","Madesimo"},
	{"6501","Madignano"},
	{"6502","Madonna Alta/Innesto Raccordo Pg-Bettolle"},
	{"6503","Madonna Buonconsiglio"},
	{"6504","Madonna D.Ponte Metauro"},
	{"6505","Madonna D.Ponte/Innesto Ss452 Della Contessa"},
	{"6506","Madonna Degli Archetti"},
	{"6507","Madonna Del Piano/Innesto Ss3 Bis Tiberina (e45)"},
	{"6508","Madonna Del Piano/Innesto Ss3 Bis/Racc Tiberina"},
	{"6509","Madonna Del Pino"},
	{"6510","Madonna Del Ponte/Innesto Ss219 Di Gubbio E Di P."},
	{"6511","Madonna Del Salto/Innesto Ss334 Del Sassello"},
	{"6512","Madonna Del Salto/Innesto Ss542 Di Pontinvrea"},
	{"6513","Madonna Della Neve/Innesto Ss155 E Ss156"},
	{"6514","Madonna Della Neve/Innesto Ss6 Casilina"},
	{"6515","Madonna Della Neve/Innesto Ss6 Casilina E Ss156"},
	{"6516","Madonna Della Neve/Innesto Ss6 Casilina/Innesto Ss155"},
	{"6517","Madonna Della Noce/Innesto Ss117bis Centr. Sicula"},
	{"6518","Madonna Della Noce/Innesto Ss288 Di Aidone"},
	{"6519","Madonna Della Pace"},
	{"6520","Madonna Della Santita'/Innesto Ss71 Umbro Casen."},
	{"6521","Madonna Dell'alto"},
	{"6522","Madonna Dell'olmo"},
	{"6523","Madonna Dell'olmo/Innesto Ss20 Del Col Di Tenda"},
	{"6524","Madonna Dell'olmo/Innesto Ss20 Del Colle Di Tenda"},
	{"6525","Madonna Dell'olmo/Innesto Ss231 Di S.Vittoria"},
	{"6526","Madonna Dell'olmo/Innesto Ss589 Laghi Di Avigliana"},
	{"6527","Madonna Di Campiglio"},
	{"6528","Madonna Di Canneto"},
	{"6529","Madonna Di Fiamenga/Innesto Ss75 Cent.Le Umbra"},
	{"6530","Madonna Di Gaspreano"},
	{"6531","Madonna Di Termine/Innesto Ss109 Bis"},
	{"6532","Madonna Di Termine/Innesto Ss109 Racc"},
	{"6533","Madonna Di Tirano/Innesto Ss38 Dello Stelvio"},
	{"6534","Madonna Grumentina/Innesto Ss103 Di Val D'agri"},
	{"6535","Madonna Grumentino/Innesto Ss598 Fondo V. D'agri"},
	{"6536","Madonna Sanita'/Innesto Ss220 Pievaiola"},
	{"6537","Madonnina/Innesto Ss413 Romana"},
	{"6538","Madonnina/Innesto Ss9 Emilia"},
	{"6539","Maesta'"},
	{"6540","Magenta/Innesto Ss11 Padana Superiore"},
	{"6541","Magenta/Innesto Ss526 Dell'esticino"},
	{"6542","Magione"},
	{"6543","Magione/Innesto Raccordo Bettolle-Perugia"},
	{"6544","Magisano"},
	{"6545","Magliana"},
	{"6546","Maglianello"},
	{"6547","Magliano De' Marsi"},
	{"6548","Magliano In Toscana"},
	{"6549","Magliano Sabina"},
	{"6550","Maglie"},
	{"6551","Maglie/Innesto Ss16 Adriatica"},
	{"6552","Maglie/Innesto Ss459 Di Parabita"},
	{"6553","Maglie/Innesto Ss497 Di Maglie E Di S.Cesarea"},
	{"6554","Maglie/Innesto Ss497 Di Maglie E S. Cesarea"},
	{"6555","Magnano In Riviera/Innesto Ss356 Di Cividale"},
	{"6556","Magnano Riviera/Innesto Ss13 Pontebbana"},
	{"6557","Magnasco"},
	{"6558","Magonfia"},
	{"6559","Magra"},
	{"6560","Maida"},
	{"6561","Maiero"},
	{"6562","Maiori"},
	{"6563","Maiorisi/Innesto Ss608 Di Teano"},
	{"6564","Maiorisi/Innesto Ss7 Appia"},
	{"6565","Malalbergo"},
	{"6566","Malcesine"},
	{"6567","Male'"},
	{"6568","Maleo"},
	{"6569","Malesco/Innesto Ss337 Della Val Vigezzo"},
	{"6570","Malesco/Innesto Ss631 Di Valle Cannobina"},
	{"6571","Malga Gaver"},
	{"6572","Malgesso"},
	{"6573","Malgrate"},
	{"6574","Malnate"},
	{"6575","Malonno"},
	{"6576","Maltignano"},
	{"6577","Malvicino/Saquana"},
	{"6578","Mammianese-Marlianese"},
	{"6579","Mammiano/Innesto Ss633 Mammianese Marlianese"},
	{"6580","Mammiano/Innesto Ss66 Pistoiese"},
	{"6581","Mammola"},
	{"6582","Mamoiada"},
	{"6583","Manarola"},
	{"6584","Manarola/Innesto Ss370 Delle Cinque Terre"},
	{"6585","Manarola/Innesto Ss370 Diramazione Delle 5 Terre"},
	{"6586","Manca Di Sopra"},
	{"6587","Manciano"},
	{"6588","Manciano/Innesto Ss322 Delle Collacchie"},
	{"6589","Manciano/Innesto Ss74 Maremana"},
	{"6590","Mandalossa"},
	{"6591","Mandas"},
	{"6592","Mandatoriccio"},
	{"6593","Mandolossa - Innesto Ss11 Padana Superiore"},
	{"6594","Mandolossa/Innesto Ss11 Padana Superiore"},
	{"6595","Manduria"},
	{"6596","Manduria/Innesto Ss174 Salentina Di Manduria"},
	{"6597","Manduria/Innesto Ss7 Ter Salentina"},
	{"6598","Manerbio"},
	{"6599","Manerbio/Innesto Ss668 Lenese"},
	{"6600","Manerbio/Ss45bis Gardesana Occidentale"},
	{"6601","Mangano"},
	{"6602","Mangiatorella/Innesto Ss110"},
	{"6603","Mangiatorella/Innesto Ss110 Dir"},
	{"6604","Maniago/Innesto Ss251 Di Val Di Zoldo E Cellina"},
	{"6605","Maniago/Innesto Ss464 Di Spilimbergo"},
	{"6606","Mannoli"},
	{"6607","Manocalzati/Innesto Ss Ofantina"},
	{"6608","Manocalzati-Innesto Ss7 Appia"},
	{"6609","Manoppello"},
	{"6610","Manoppello Nord/Innesto Ss5 Tiburtina"},
	{"6611","Manoppello/Innesto Ss539 Di Manoppello"},
	{"6612","Manta"},
	{"6613","Mantello"},
	{"6614","Mantova"},
	{"6615","Mantova Laghi"},
	{"6616","Mantova Nord"},
	{"6617","Mantova Sud"},
	{"6618","Mantova/Incrocio Ss10 Padana Inferiore"},
	{"6619","Mantova/Incrocio Ss62 Della Cisa"},
	{"6620","Mantova/Innesto Ss10 Padana Inferiore"},
	{"6621","Mantova/Innesto Ss420 Sabbionetana"},
	{"6622","Manziana"},
	{"6623","Mar Jonio (est)"},
	{"6624","Mar Tirreno (ovest)"},
	{"6625","Marana"},
	{"6626","Maranda - Svincolo Ramo Barra Raccordo A1-A3"},
	{"6627","Maranda/Svincolo Ramo Barra Raccordo A1-A3"},
	{"6628","Maranello"},
	{"6629","Maranise"},
	{"6630","Maratea"},
	{"6631","Marausa"},
	{"6632","Marcatobianco"},
	{"6633","Marcellinara"},
	{"6634","Marche"},
	{"6635","Marcheno"},
	{"6636","Marcianise"},
	{"6637","Marcianise/Innesto Ss265 Dei Ponti Della Valle"},
	{"6638","Marcianise/Innesto Ss87 Sannitica"},
	{"6639","Marecchia"},
	{"6640","Maremmana"},
	{"6641","Maremmana Iii"},
	{"6642","Marene"},
	{"6643","Marene Centro"},
	{"6644","Marengo"},
	{"6645","Margarita"},
	{"6646","Marghera"},
	{"6647","Marghera/Incrocio Ss11 Padana Superiore"},
	{"6648","Marghera/Innesto Ss309 Romea"},
	{"6649","Margherita Di Savoia"},
	{"6650","Margine"},
	{"6651","Margine Coperta"},
	{"6652","Maria E Isola Casamari"},
	{"6653","Mariano Del Friuli"},
	{"6654","Marianopoli"},
	{"6655","Marina Di Amendolara"},
	{"6656","Marina Di Amendolara/Innesto Ss106 Jonica"},
	{"6657","Marina Di Amendolara/Innesto Ss481"},
	{"6658","Marina Di Andrano"},
	{"6659","Marina Di Ardea"},
	{"6660","Marina Di Camerota"},
	{"6661","Marina Di Campagna"},
	{"6662","Marina Di Carrara"},
	{"6663","Marina Di Casal Velino"},
	{"6664","Marina Di Caulonia"},
	{"6665","Marina Di Davoli"},
	{"6666","Marina Di Fuscaldo"},
	{"6667","Marina Di Ginosa/Innesto Ss106 Jonica"},
	{"6668","Marina Di Ginosa/Innesto Ss580 Di Ginosa"},
	{"6669","Marina Di Gioia Tauro"},
	{"6670","Marina Di Gioiosa Jonica"},
	{"6671","Marina Di Gioiosa Jonica/Innesto Ss106 Jonica"},
	{"6672","Marina Di Montemarciano"},
	{"6673","Marina Di Novaglie"},
	{"6674","Marina Di Orosei"},
	{"6675","Marina Di Ostuni"},
	{"6676","Marina Di Patti"},
	{"6677","Marina Di Pisa"},
	{"6678","Marina Di Ravenna"},
	{"6679","Marina Di Roseto"},
	{"6680","Marina Di S.Lorenzo"},
	{"6681","Marina Di S.Vito"},
	{"6682","Marina Di S.Vito/Innesto Ss84 Frentana"},
	{"6683","Marina Di S.Vito/Innesto Ss16 Adriatica"},
	{"6684","Marina Di Salzare"},
	{"6685","Marina Di Strongoli"},
	{"6686","Marina Di Vasto/Innesto Ss16 Adriatica"},
	{"6687","Marina D'itala"},
	{"6688","Marina G.Jonica/Innesto Ss281 Passo Di Limina"},
	{"6689","Marina Serra Tricase"},
	{"6690","Marinella Di Sarzana"},
	{"6691","Marineo"},
	{"6692","Marino"},
	{"6693","Marino/Incrocio Ss216 Maremmana Iii"},
	{"6694","Marlengo"},
	{"6695","Marliana"},
	{"6696","Marmigliaio"},
	{"6697","Marmirolo"},
	{"6698","Marmore"},
	{"6699","Marola"},
	{"6700","Marone"},
	{"6701","Maropati"},
	{"6702","Marostica"},
	{"6703","Marotta"},
	{"6704","Marotta/Innesto Ss16 Adriatica"},
	{"6705","Marotta/Innesto Ss424 Della Val Cesano"},
	{"6706","Marotta-Mondolfo"},
	{"6707","Marradi"},
	{"6708","Marradi/Innesto Ss302 Brisighellese-Ravennate"},
	{"6709","Marradi/Innesto Ss306 Casolana Riolese"},
	{"6710","Marrubiu"},
	{"6711","Marrucina"},
	{"6712","Marsaglia"},
	{"6713","Marsaglia/Innesto Ss45 Di Val Di Trebbia"},
	{"6714","Marsaglia/Innesto Ss586 Della Valle Dell'aveto"},
	{"6715","Marsala"},
	{"6716","Marsala/Innesto Ss115 Sud Occidentale Sicula"},
	{"6717","Marsala/Innesto Ss188 Centro Occ.Le Sicula"},
	{"6718","Marsala-Fontana Salsa"},
	{"6719","Marscianese"},
	{"6720","Marsciano"},
	{"6721","Marsciano/Innesto Ss317 Marscianese"},
	{"6722","Marsciano/Innesto Ss397 Di Montemolino"},
	{"6723","Marsia"},
	{"6724","Marsicana"},
	{"6725","Marsico Nuovo Innesto Ss598 Di Fondo V. D'agri"},
	{"6726","Marsico Nuovo/Innesto Ss276 Dell'alto Agri"},
	{"6727","Marsico Nuovo/Innesto Ss598 Di Fondo V. D'agri"},
	{"6728","Marsiletti"},
	{"6729","Marta Cantoniera/Innesto Ss129 Trasversale Sarda"},
	{"6730","Martellago"},
	{"6731","Marter"},
	{"6732","Martignacco"},
	{"6733","Martina Franca/Innesto Ss172 Dei Trulli"},
	{"6734","Martina Franca/Innesto Ss581 Di Massafra"},
	{"6735","Martincelli"},
	{"6736","Martinengo"},
	{"6737","Martinetto"},
	{"6738","Martis"},
	{"6739","Martis/Innesto Ss127 Settentrionale Sarda"},
	{"6740","Martis/Innesto Ss132 Di Ozieri"},
	{"6741","Marzabotto"},
	{"6742","Marzi"},
	{"6743","Marzocca"},
	{"6744","Mas Di Sedico"},
	{"6745","Masainas"},
	{"6746","Masare'"},
	{"6747","Mascali"},
	{"6748","Mascherone"},
	{"6749","Masera"},
	{"6750","Masera/Innesto Ss337 Della Val Vigezzo"},
	{"6751","Masi S.Giacomo"},
	{"6752","Masi Torello (direzione Ferrara)"},
	{"6753","Masino"},
	{"6754","Masone"},
	{"6755","Mass. Piano Del Monaco"},
	{"6756","Mass.Armillotti"},
	{"6757","Mass.Vittorio/Innesto Ss664 Mediana Del Salento"},
	{"6758","Massa"},
	{"6759","Massa Finalese"},
	{"6760","Massa Fiscaglia"},
	{"6761","Massa Lombarda"},
	{"6762","Massa Lombarda/Innesto Ss610"},
	{"6763","Massa Marittima"},
	{"6764","Massa Martana"},
	{"6765","Massa/Innesto Ss1 Aurelia"},
	{"6766","Massa/Innesto Ss446 Diramazione Di Fosdinovo"},
	{"6767","Massafra/Innesto Ss581 Di Massafra"},
	{"6768","Massafra/Innesto Ss7 Appia"},
	{"6769","Massalombarda/Innesto Ss253 S.Vitale"},
	{"6770","Massaquano"},
	{"6771","Massarosa"},
	{"6772","Massarosa/Innesto A11 Diramazione Lucca-Viareggio"},
	{"6773","Massazza"},
	{"6774","Masseria Abbandonata"},
	{"6775","Masseria Albospino"},
	{"6776","Masseria Beatrice"},
	{"6777","Masseria Camerino"},
	{"6778","Masseria Compierchio"},
	{"6779","Masseria Cosentino"},
	{"6780","Masseria Epitaffio/Innesto Ss168 Di Venosa"},
	{"6781","Masseria Epitaffio/Innesto Ss97 Delle Murge"},
	{"6782","Masseria Falcione/Innesto Ss157 Valle Del Biferno"},
	{"6783","Masseria Falcione/Innesto Ss16 Adriatica"},
	{"6784","Masseria Feliciona"},
	{"6785","Masseria Fontana/Innesto Ss459 Di Parabita"},
	{"6786","Masseria Fontana/Innesto Ss476 Di Galatina"},
	{"6787","Masseria Montanaro"},
	{"6788","Masseria Nuova Del Duca"},
	{"6789","Masseria Olivola/Innesto Ss372 Telesina"},
	{"6790","Masseria Olivola/Innesto Ss88 Dei Due Principati"},
	{"6791","Masseria Orimini/Innesto Ss172 Dei Trulli"},
	{"6792","Masseria Orimini/Innesto Ss172 Radd Dei Trulli"},
	{"6793","Masseria Pandoro"},
	{"6794","Masseria Pariti/Innesto Ss159 Delle Saline"},
	{"6795","Masseria Pariti/Innesto Ss89 Garganica"},
	{"6796","Masseria S. Teresa"},
	{"6797","Masseria S.Vito/Innesto Ss598 Fondo Valle D'agri"},
	{"6798","Masseria S.Vito/Innesto Ss92 Dell'app. Merid.Le"},
	{"6799","Masseria Scalella"},
	{"6800","Masseria Schianchetta"},
	{"6801","Masseria Tenutella"},
	{"6802","Masseria Valentina"},
	{"6803","Masseria Vitamore"},
	{"6804","Masseria Vittorio/Innesto Ss101 Salent. Di Gallipoli"},
	{"6805","Masseria/Innesto Sgc Nola-Domitio/Innesto Ss162 Dir"},
	{"6806","Masseria/Innesto Ss114 Orientale Sicula"},
	{"6807","Masseria/Innesto Ss162 Della Valle Caudina"},
	{"6808","Masseria/Innesto Ss193 Di Augusta"},
	{"6809","Massese"},
	{"6810","Massetana"},
	{"6811","Massicelle"},
	{"6812","Massimino"},
	{"6813","Mastellina"},
	{"6814","Matarocco"},
	{"6815","Matelica"},
	{"6816","Matera"},
	{"6817","Matera/Innesto Ss7 E Ss175 Della V. Del Bradano"},
	{"6818","Matera/Innesto Ss7 Appia E Ss99 Di Matera"},
	{"6819","Matera/Innesto Ss99 Di Matera/Ss175 Valle Del Brada"},
	{"6820","Materdomini"},
	{"6821","Matino"},
	{"6822","Mattarana"},
	{"6823","Mattinata"},
	{"6824","Mattinella"},
	{"6825","Mazara Del Vallo"},
	{"6826","Mazzancollo/Innesto Raccordo Viterbo-Terni"},
	{"6827","Mazzano"},
	{"6828","Mazzara' S.Andrea"},
	{"6829","Mazzarino"},
	{"6830","Mazzaro'"},
	{"6831","Mazze'"},
	{"6832","Mazzin"},
	{"6833","Meana Sardo"},
	{"6834","Meano"},
	{"6835","Meda"},
	{"6836","Medesano"},
	{"6837","Mediana Del Salento"},
	{"6838","Medicina"},
	{"6839","Medolla"},
	{"6840","Meduno"},
	{"6841","Meianiga"},
	{"6842","Meina"},
	{"6843","Melara"},
	{"6844","Melara Est"},
	{"6845","Meldola"},
	{"6846","Mele"},
	{"6847","Meledo"},
	{"6848","Melegnano"},
	{"6849","Melegnano/Innesto Sp39 Bis"},
	{"6850","Melfa"},
	{"6851","Melfi/Innesto Ss303 Del Formicoso"},
	{"6852","Melfi/Innesto Ss401 Dell'alto Ofanto E Del Vulture"},
	{"6853","Melicucca'"},
	{"6854","Melicucco"},
	{"6855","Melilli"},
	{"6856","Melitello"},
	{"6857","Melito Di Napoli"},
	{"6858","Melito Di Napoli - Innesto Ss7 Bis"},
	{"6859","Melito Di Napoli-Innesto Ss162 Della Valle Caudina"},
	{"6860","Melito Di Porto Salvo"},
	{"6861","Melito P.Salvo/Innesto Ss106 Jonica"},
	{"6862","Melito Porto Salvo/Innesto Ss183 Aspromonte Jonio"},
	{"6863","Mellaredo"},
	{"6864","Menaggio"},
	{"6865","Menaggio/Innesto Ss340 Diramazione Regina"},
	{"6866","Menaggio/Innesto Ss340 Regina"},
	{"6867","Mendola"},
	{"6868","Mengaccini"},
	{"6869","Merano"},
	{"6870","Merano(nord)"},
	{"6871","Merano/Innesto Ss238 Delle Palade"},
	{"6872","Merano/Innesto Ss38 Dello Stelvio"},
	{"6873","Merano/Innesto Ss44 Del Passo Di Giovo"},
	{"6874","Mercallo"},
	{"6875","Mercatale"},
	{"6876","Mercato S.Severino"},
	{"6877","Mercato S.Severino/Innesto Ss266 Nocerina"},
	{"6878","Mercato S.Severino/Innesto Ss88 Dei Due Principati"},
	{"6879","Mercato Saraceno/Innesto S.G.C. Orte-Ravenna"},
	{"6880","Mercogliano"},
	{"6881","Mereto Di Capitolo"},
	{"6882","Meri'"},
	{"6883","Meridiana"},
	{"6884","Mesagne"},
	{"6885","Mesagne/Incrocio Ss605 Di Mesagne"},
	{"6886","Mesagne/Innesto Ss7 Appia"},
	{"6887","Mesenzana-Grantola"},
	{"6888","Mesola"},
	{"6889","Mesoraca"},
	{"6890","Messina"},
	{"6891","Messina C./Allacciamento Raccordo A20 P.To Messina"},
	{"6892","Messina Sud-Tremestieri-A18"},
	{"6893","Messina/Innesto Ss113 Diramazione Settentrionale Sicula"},
	{"6894","Messina/Innesto Ss113 Settentrionale Sicula"},
	{"6895","Messina-Boccetta"},
	{"6896","Messina-Catania"},
	{"6897","Messina-Gazzi"},
	{"6898","Messina-S.Agata Di Militello"},
	{"6899","Mestre"},
	{"6900","Mestre Ovest/Svincolo Rotatoria Marghera A4 To-Ts"},
	{"6901","Mestre/Innesto Ss11 Padana Superiore"},
	{"6902","Mestre/Innesto Ss13 Pontebbana"},
	{"6903","Mestre/Innesto Ss14 Bis Di Mestre"},
	{"6904","Mestre/Innesto Ss14 Della Venezia Giulia"},
	{"6905","Mestre/Innesto Ss245 Castellana"},
	{"6906","Mestre-Belluno"},
	{"6907","Mestriago"},
	{"6908","Mestrino"},
	{"6909","Meta Di Sorrento"},
	{"6910","Meta Di Sorrento/Innesto Ss145 Sorrentina"},
	{"6911","Meta/Innesto Ss163 Amalfitana"},
	{"6912","Metaponto"},
	{"6913","Metaponto/Innesto Ss106 Jonica"},
	{"6914","Metaponto/Innesto Ss407 Basentana"},
	{"6915","Metauro"},
	{"6916","Mezzana"},
	{"6917","Mezzano"},
	{"6918","Mezzano Chitantolo"},
	{"6919","Mezzaselva"},
	{"6920","Mezzavia"},
	{"6921","Mezzegra"},
	{"6922","Mezzocanale"},
	{"6923","Mezzogoro"},
	{"6924","Mezzolago"},
	{"6925","Mezzolombardo"},
	{"6926","Miggiano"},
	{"6927","Miggiano/Innesto Ss474 Di Taurisano"},
	{"6928","Miglianico/Ripa Teatina"},
	{"6929","Migliarina Di La Spezia/Innesto Ss1 Aurelia"},
	{"6930","Migliarina/Innesto Ss330 Di Buonviaggio"},
	{"6931","Migliarino"},
	{"6932","Migliaro"},
	{"6933","Mignanego"},
	{"6934","Milano"},
	{"6935","Milano/Bivio Per A4 To-Ts E A8 Mi-Va"},
	{"6936","Milano/Incrocio Con Ss9 Ss11 Ss33 Ss233"},
	{"6937","Milano/Incrocio Ss9/Ss33/Ss35/Ss233"},
	{"6938","Milano/Innesto Ss11/Ss33/Ss35/Ss233"},
	{"6939","Milano/Innesto Ss9/Ss11/Ss33/Ss35"},
	{"6940","Milano/Innesto Ss9/Ss11/Ss35/Ss233"},
	{"6941","Milano-Allacciamento Raccordo P.Le Corvetto-Tangenziale Est"},
	{"6942","Milano-Genova"},
	{"6943","Milano-Napoli"},
	{"6944","Milano-Varese"},
	{"6945","Milazzo-Isole Eolie"},
	{"6946","Mileto"},
	{"6947","Millesimo"},
	{"6948","Millesimo/Innesto Ss28 Bis Del Colle Di Nava"},
	{"6949","Millesimo/Innesto Ss339 Di Cengio"},
	{"6950","Milo - Trapani - Ss113"},
	{"6951","Minerbe"},
	{"6952","Minerbe/Innesto Ss10 Padana Inferiore"},
	{"6953","Minerbe/Innesto Ss500 Di Lonigo"},
	{"6954","Minervino Murge"},
	{"6955","Minervino Murge/Innesto Ss170 Di Castel Del Monte"},
	{"6956","Minervino Murge/Innesto Ss97 Delle Murge"},
	{"6957","Minori"},
	{"6958","Mira"},
	{"6959","Mira Vecchia"},
	{"6960","Mirabella"},
	{"6961","Mirabello"},
	{"6962","Mirabello Monferrato"},
	{"6963","Mirabello/Innesto Ss255 Di S.Matteo Decima"},
	{"6964","Mirabello/Innesto Ss468 Di Correggio"},
	{"6965",""},
	{"6966","Mirandola"},
	{"6967","Mirto Crosia/Innesto Ss106 Jonica"},
	{"6968","Mirto Crosia/Innesto Ss531 Di Cropalati"},
	{"6969","Misericordia/Innesto Ss117 Bis Centrale Sicula"},
	{"6970","Misericordia/Innesto Ss121 Catanese"},
	{"6971","Missanello"},
	{"6972","Missano"},
	{"6973","Misterbianco"},
	{"6974","Misterbianco-Innesto Ss121 Catanese"},
	{"6975","Mistretta"},
	{"6976","Misurina"},
	{"6977","Mita"},
	{"6978","Mocaiana"},
	{"6979","Moccone/Innesto Ss107 Silana Crotonese"},
	{"6980","Moccone/Innesto Ss279 Silana Di Rose"},
	{"6981","Moccone/Innesto Ss279Diramazione Di Monte Curcio"},
	{"6982","Modena"},
	{"6983","Modena - Innesto Ss12"},
	{"6984","Modena - Innesto Ss413"},
	{"6985","Modena Nord"},
	{"6986","Modena Nord - A1 Milano-Napoli"},
	{"6987","Modena Nord (a1)"},
	{"6988","Modena Ss12"},
	{"6989","Modena Sud"},
	{"6990","Modena/Innesto Ss12 Dell'abetone E Del Brennero"},
	{"6991","Modena/Innesto Ss255 Di S.Matteo Decima"},
	{"6992","Modena/Innesto Ss486 Di Montefiorino"},
	{"6993","Modena/Innesto Ss623 Del Passo Brasa"},
	{"6994","Modena/Innesto Ss9 Emilia"},
	{"6995","Modena/Innesto Ss9 Via Emilia"},
	{"6996","Modena/Innesto Tangenziale Di Modena"},
	{"6997","Modena/Innesto Tangenziale Di Modena"},
	{"6998","Modica Nord/Innesto Ss194 Ragusana"},
	{"6999","Modica Sud/Innesto Ss194 Ragusana"},
	{"7000","Modica Ovest/Innesto Ss115 Sud Occ. Sicula"},
	{"7001","Modugno"},
	{"7002","Modugno/Innesto Ss96 Barese"},
	{"7003","Modugno/Innesto Ss98 Andriese Coratina"},
	{"7004","Moena"},
	{"7005","Moena/Innesto Ss346 Del Passo Di S.Pellegrino"},
	{"7006","Moena/Innesto Ss48 Delle Dolomiti"},
	{"7007","Moglia"},
	{"7008","Mogliano Veneto"},
	{"7009","Moiano"},
	{"7010","Moio Della Civitella"},
	{"7011","Moiola"},
	{"7012","Moirago"},
	{"7013","Mola Di Bernardo"},
	{"7014","Molare"},
	{"7015","Molaretto"},
	{"7016","Molesana"},
	{"7017","Molfetta"},
	{"7018","Molina"},
	{"7019","Molina Aterno"},
	{"7020","Molina Aterno/Innesto Ss261 Subequana"},
	{"7021","Molina Di Ledro"},
	{"7022","Molina Di Mori"},
	{"7023","Molina Di Quosa"},
	{"7024","Molinetto"},
	{"7025","Molini"},
	{"7026","Molini Di Triora"},
	{"7027","Molini Di Tures"},
	{"7028","Molini D'isola/Innesto Ss231 Di S.Vittoria"},
	{"7029","Molini D'isola/Innesto Ss456 Del Turchino"},
	{"7030","Molino Vitelli"},
	{"7031","Molise"},
	{"7032","Moliterno"},
	{"7033","Mollia"},
	{"7034","Moltrasio"},
	{"7035","Molveno"},
	{"7036","Mombello"},
	{"7037","Momo"},
	{"7038","Monasterace M./Innesto Ss110 M.Te Cucco E Pecoraro"},
	{"7039","Monasterace Marina"},
	{"7040","Monasterace Marina/Innesto Ss106 Jonica"},
	{"7041","Monastero Della Certosa Del Galluzzo"},
	{"7042","Monastir/Incrocio Ss131 Di Carlo Felice"},
	{"7043","Monastir/Incrocio Ss466 Di Sibiola"},
	{"7044","Monastir/Innesto Ss128 Cent. Sarda E Ss130"},
	{"7045","Monastir/Innesto Ss128 Centr. Sarda E Ss131 C.Felice"},
	{"7046","Monastir/Innesto Ss130 Diramazione Iglesiente"},
	{"7047","Monastir/Innesto Ss131 Carlo Felice E Ss130 Dir"},
	{"7048","Monastir/Innesto Ss466 Di Sibiola"},
	{"7049","Moncalieri/Innesto Ss20 Colle Di Tenda"},
	{"7050","Moncalieri/Innesto Ss29 Del Colle Di Cadibona"},
	{"7051","Moncalieri/Innesto Ss393 Di Villastellone"},
	{"7052","Moncalvo"},
	{"7053","Monchio Delle Corti"},
	{"7054","Monclassico"},
	{"7055","Mondovi'"},
	{"7056","Mondovi' Est"},
	{"7057","Mondovi' Ovest"},
	{"7058","Mondovi'/Innesto Ss28 Del Colle Di Nava"},
	{"7059","Mondovi'/Innesto Ss28 Diramazione Del Colle Di Nava"},
	{"7060","Mondovi'/Innesto Ss564 Monregalese"},
	{"7061","Mondragone"},
	{"7062","Monesiglio"},
	{"7063","Monestirolo"},
	{"7064","Monfalcone"},
	{"7065","Monfalcone/Innesto Raccordo Ss14-Ss55"},
	{"7066","Monfalcone/Innesto Ss14 Della Venezia Giulia"},
	{"7067","Monfalcone/Innesto Ss305 Di Redipuglia"},
	{"7068","Monfalcone-Innesto Raccordo Per A4 Ve-Ts"},
	{"7069","Monfalcone-Innesto Ss55 Dell'isonzo"},
	{"7070","Monferrato"},
	{"7071","Monforte Marina"},
	{"7072","Monghidoro"},
	{"7073","Mongiana"},
	{"7074","Mongrando"},
	{"7075","Monguelfo"},
	{"7076","Monguzzo"},
	{"7077","Moniego"},
	{"7078","Monregalese"},
	{"7079","Monselice"},
	{"7080","Monselice/Innesto Ss10 Padana Inferiore"},
	{"7081","Monselice/Innesto Ss16 Adriatica"},
	{"7082","Monserrato"},
	{"7083","Monsummano Terme"},
	{"7084","Mont Jovet"},
	{"7085","Monta'"},
	{"7086","Montagnana"},
	{"7087","Montagnano"},
	{"7088","Montaio"},
	{"7089","Montalbano"},
	{"7090","Montalbano/Innesto Ss103 Di Val D'agri"},
	{"7091","Montale"},
	{"7092","Montale/Innesto Tangenziale Di Piacenza"},
	{"7093","Montallegro"},
	{"7094","Montallese"},
	{"7095","Montalone"},
	{"7096","Montalto Delle Marche"},
	{"7097","Montalto Di Castro/Innesto Ss1 Aurelia"},
	{"7098","Montalto Di Castro/Innesto Ss312 Castrense"},
	{"7099","Montalto Dora"},
	{"7100","Montalto Ligure"},
	{"7101","Montalto/Rose S./Innesto Ss279 Silana Di Rose"},
	{"7102","Montanara"},
	{"7103","Montano Antilia"},
	{"7104","Monte Alto"},
	{"7105","Monte Baldo Nord"},
	{"7106","Monte Baldo Sud"},
	{"7107","Monte Curcio"},
	{"7108","Monte Di Quiesa Nord"},
	{"7109","Monte Faito"},
	{"7110","Monte Luco"},
	{"7111","Monte Olimpino"},
	{"7112","Monte Peloso"},
	{"7113","Monte Petrosu"},
	{"7114","Monte Porzio"},
	{"7115","Monte Romano"},
	{"7116","Monte S.Angelo/Innesto Ss272 Di S.Giovanni Rotondo"},
	{"7117","Monte S.Angelo/Innesto Ss528 Della Foresta Umbra"},
	{"7118","Monte S.Angelo/Innesto Ss89 Dir/B Garganica"},
	{"7119","Monte S.Angelo/Innesto Ss272 Di S.Giovanni Rotondo"},
	{"7120","Monte S.Savino"},
	{"7121","Monte Salviano"},
	{"7122","Monte San Savino"},
	{"7123","Monte Spaccato"},
	{"7124","Monte Tapino"},
	{"7125","Monte Velino"},
	{"7126","Monte Vidon Combatte"},
	{"7127","Montebello"},
	{"7128","Montebello D.Battaglia"},
	{"7129","Montebello Della Battaglia"},
	{"7130","Montebello/Innesto Ss3 Bis/Racc Tiberina"},
	{"7131","Montebello/Innesto Ss317 Marscianese"},
	{"7132","Montebelluna"},
	{"7133","Montebelluna/Incrocio Ss348 Feltrina"},
	{"7134","Montebelluna/Innesto Ss248"},
	{"7135","Montebruno"},
	{"7136","Montecalvo Irpino"},
	{"7137","Montecassiano"},
	{"7138","Montecastrilli"},
	{"7139","Montecatini"},
	{"7140","Montecatini T./Innesto Ss436 Francesca"},
	{"7141","Montecatini T./Innesto Ss633 Mammianese-Marlianese"},
	{"7142","Montecatini Terme/Innesto Ss435 Lucchese"},
	{"7143","Montecchio"},
	{"7144","Montecchio Maggiore"},
	{"7145","Montecenere"},
	{"7146","Montecerboli"},
	{"7147","Montecilfone"},
	{"7148","Montecompatri"},
	{"7149","Montecorvino Rovella"},
	{"7150","Montecosaro-Casette D'ete"},
	{"7151","Montecreto"},
	{"7152","Montefano"},
	{"7153","Montefeltro"},
	{"7154","Montefiascone"},
	{"7155","Montefiascone/Innesto Ss2 Cassia"},
	{"7156","Montefiascone/Innesto Ss71 Umbro Casent. Rom."},
	{"7157","Montefiore"},
	{"7158","Monteforte Irpino"},
	{"7159","Montegiordano Marina"},
	{"7160","Montegrotto Terme"},
	{"7161","Montelaguardia"},
	{"7162","Montelanico"},
	{"7163","Monteleone Di Puglia"},
	{"7164","Monteleone Di Puglia/Innesto Ss91 Bis Irpina"},
	{"7165","Monteleone Di Puglia/Innesto Ss91ter Diram. Irpina"},
	{"7166","Monteleone Di Spoleto"},
	{"7167","Montelepre"},
	{"7168","Montella"},
	{"7169","Montella/Incrocio Ss7 Appia"},
	{"7170","Montella/Innesto Ss164 Delle Croci Di Acerno"},
	{"7171","Montella/Innesto Ss368 Del Lago Laceno"},
	{"7172","Montella/Innesto Ss574 Del Monte Terminio"},
	{"7173","Montelungo"},
	{"7174","Montelupo Fiorentino"},
	{"7175","Montemarano"},
	{"7176","Montemarano/Innesto Ss400 Diramazione Di Castelvetere"},
	{"7177","Montemarano/Innesto Ss7 Appia"},
	{"7178","Montemerano"},
	{"7179","Montemesola - Monteiasi"},
	{"7180","Montemolino/Innesto Ss397 Di Monte Molino"},
	{"7181","Monteparano"},
	{"7182","Montepiano"},
	{"7183","Monteporzio"},
	{"7184","Monteporzio Catone"},
	{"7185","Montepulciano"},
	{"7186","Monterchi"},
	{"7187","Montereale"},
	{"7188","Montereale Valcellina"},
	{"7189","Montereale/Innesto Ss260 Picente"},
	{"7190","Montereale/Innesto Ss471 Di Leonessa"},
	{"7191","Monteriggioni (Direzione Firenze)"},
	{"7192","Monteriggioni (Direzione Siena)"},
	{"7193","Monteroni D'arbia"},
	{"7194","Monterosi/Innesto Ss2 Cassia"},
	{"7195","Monterosi/Innesto Ss311 Nepesina"},
	{"7196","Monterosso Almo"},
	{"7197","Monterotondo M./Innesto Ss398 Via Val Di Cornia"},
	{"7198","Monterotondo Maritt./Innesto Ss439 Sarzanese Val."},
	{"7199","Monterotondo Marittimo"},
	{"7200","Monterotondo Nucleo Industriale"},
	{"7201","Monterotondo Scalo"},
	{"7202","Montesano S. Marcellana/Innesto 103 Di Val D'agri"},
	{"7203","Montesano Salentino"},
	{"7204","Montesano Sulla Marcellana"},
	{"7205","Montesarchio"},
	{"7206","Montesardo"},
	{"7207","Montescaglioso"},
	{"7208","Montescaglioso/Innesto Ss175 Valle Del Bradano"},
	{"7209","Montescaglioso/Innesto Ss380 Dei Tre Confini"},
	{"7210","Montesilvano M./Innesto Ss16 Bis Adriatica"},
	{"7211","Montesilvano Marina"},
	{"7212","Montesilvano Marina/Innesto Ss16 Adriatica"},
	{"7213","Montesoffio"},
	{"7214","Montesordo"},
	{"7215","Montespluga"},
	{"7216","Monteulles"},
	{"7217","Montevago"},
	{"7218","Montevarchi"},
	{"7219","Montevarchi/Innesto Ss408 Di Montevarchi"},
	{"7220","Montevarchi/Innesto Ss69 Di Val D'arno"},
	{"7221","Monteverdi Marittimo"},
	{"7222","Montezemolo"},
	{"7223","Montezemolo/Innesto Ss28 Bis Del Colle Di Nava"},
	{"7224","Montezemolo/Innesto Ss661 Delle Langhe"},
	{"7225","Monti"},
	{"7226","Monticchio"},
	{"7227","Monticchio Bagni/Innesto Ss167 Laghi Di Monticchio"},
	{"7228","Monticchio Bagni/Innesto Ss401 Dell'alto Ofanto"},
	{"7229","Monticelli D'ongina"},
	{"7230","Montichiari"},
	{"7231","Montichiari/Innesto Ss236 Goitese"},
	{"7232","Montichiari/Innesto Ss343 Asolana"},
	{"7233","Montichiari/Innesto Ss668 Lenese"},
	{"7234","Monticiano"},
	{"7235","Montodine"},
	{"7236","Montoggio"},
	{"7237","Montone"},
	{"7238","Montorio Al V./Innesto Ss150 Valle Del Vomano"},
	{"7239","Montorio Al Vomano/Innesto Ss150 Valle Del Vomano"},
	{"7240","Montorio Al Vomano/Innesto Ss491 Di Isola Del G.Sasso"},
	{"7241","Montorio Al Vomano/Innesto Ss80 Del G.Sasso D'italia"},
	{"7242","Montoro"},
	{"7243","Monumento Ossario Del Monte Grappa"},
	{"7244","Monza"},
	{"7245","Monza/Innesto Ss527 Bustese"},
	{"7246","Monza/Sgc Milano-Monza/Innesto Ss36"},
	{"7247","Moraduccio"},
	{"7248","Morano Calabro"},
	{"7249","Morano Sul Po"},
	{"7250","Morano-Castrovillari"},
	{"7251","Morbegno"},
	{"7252","Morbegno/Innesto Ss38 Dello Stelvio"},
	{"7253","Morbegno/Innesto Ss402 Valeriana"},
	{"7254","Morbegno/Innesto Ss405 Di Val Gerola"},
	{"7255","Morcone"},
	{"7256","Morengo"},
	{"7257","Mores"},
	{"7258","Moretta"},
	{"7259","Morgantina"},
	{"7260",""},
	{"7261","Morgongiori"},
	{"7262","Mori"},
	{"7263","Moricone"},
	{"7264","Mormanno"},
	{"7265","Mormanno N./Innesto Ss504 Di Mormanno"},
	{"7266","Mormanno/Innesto Ss19 Delle Calabrie"},
	{"7267","Mormanno-Scalea"},
	{"7268","Morozzo"},
	{"7269","Morro Reatino"},
	{"7270","Mortara"},
	{"7271","Mortara/Incrocio Ss494 Vigevan. E Ss596 Dei Cairoli"},
	{"7272","Mortara/Innesto Ss211 E Ss494 Vigevanese"},
	{"7273","Mortara/Innesto Ss211 Della Lomellina E Ss596"},
	{"7274","Mortegliano"},
	{"7275","Mortelle"},
	{"7276","Mortola"},
	{"7277","Mosana"},
	{"7278","Moschiano"},
	{"7279","Mosciano S.Angelo"},
	{"7280","Mosciano S.Angelo/Innesto Con Ss262 Di Campli"},
	{"7281","Mosciano S.Angelo/Innesto Ss262 Diramazione Di Campli"},
	{"7282","Moso"},
	{"7283","Mossa"},
	{"7284","Mosson"},
	{"7285","Motta"},
	{"7286","Motta Di Livenza"},
	{"7287","Motta Montecorvino"},
	{"7288","Motta S.Anastasia"},
	{"7289","Motta Visconti"},
	{"7290","Motta/Innesto Ss349 Di Val D'assa"},
	{"7291","Motta/Innesto Ss39 Del Passo Di Aprica"},
	{"7292","Motta/Innesto Ss46 Del Pasubio"},
	{"7293","Motta/Innesto Ss550 Di Villa Di Tirano"},
	{"7294","Mottella S.Giorgio"},
	{"7295","Mottola-Castellaneta"},
	{"7296","Mozzanica/Innesto Ss11 Padana Superiore"},
	{"7297","Mozzanica/Innesto Ss591 Cremasca"},
	{"7298","Mozzate"},
	{"7299","Mozzecane"},
	{"7300","Muccese"},
	{"7301","Muccia"},
	{"7302","Muccia/Innesto Ss77 Della Val Di Chienti"},
	{"7303","Mucciatella"},
	{"7304","Muffa"},
	{"7305","Muggiano"},
	{"7306","Muggio'"},
	{"7307","Mugnano Del Cardinale"},
	{"7308","Mules"},
	{"7309","Mulinello"},
	{"7310","Mulinello Ponte"},
	{"7311","Mulino Di Arzachena"},
	{"7312","Multeddu"},
	{"7313","Mungivacca - Innesto Ss16 Adriatica"},
	{"7314","Mungivacca/Innesto Ss16 Adriatica"},
	{"7315","Mungivacca/Svincolo Ss100 Di Gioia Del Colle"},
	{"7316","Muravera"},
	{"7317","Murazzano"},
	{"7318","Murazzo"},
	{"7319","Murci"},
	{"7320","Murge"},
	{"7321","Murisengo"},
	{"7322","Muro Leccese"},
	{"7323","Muro Lucano"},
	{"7324","Musignano"},
	{"7325","Musile Di Piave"},
	{"7326","Mussingiua"},
	{"7327","Mussolente"},
	{"7328","Mussotto"},
	{"7329","Muzio"},
	{"7330","Muzza Piacentina"},
	{"7331","Muzzana Di Turgnano/Innesto Ss14 Della V. Giulia"},
	{"7332","Muzzana/Innesto Ss353 Della Bassa Friulana"},
	{"7333","Nago"},
	{"7334","Nago/Innesto Ss240 Di Loppio E Val Di Ledro"},
	{"7335","Nago/Innesto Ss240 Diramazione Di Loppio E Di Val Di Ledro"},
	{"7336","Napola"},
	{"7337","Napoli"},
	{"7338","Napoli Centro-Via G.Ferraris"},
	{"7339","Napoli Centro-Via Marina"},
	{"7340","Napoli-Canosa"},
	{"7341","Napoli-Salerno-Reggio Calabria"},
	{"7342","Nardo'"},
	{"7343","Narni"},
	{"7344","Narni Scalo"},
	{"7345","Narni Scalo/Innesto Ss205 Amerina"},
	{"7346","Narni Scalo/Innesto Ss3 Ter Di Narni E Sangemini"},
	{"7347","Narni/Innesto Ss204 Ortana"},
	{"7348","Narni/Innesto Ss3 Ter Di Narni E Sangemini"},
	{"7349","Naro"},
	{"7350","Naro/Innesto Ss410 Di Naro"},
	{"7351","Naro/Innesto Ss410 Diramazione Di Naro"},
	{"7352","Naro/Innesto Ss576 Furore"},
	{"7353","Narzole"},
	{"7354","Nasago'"},
	{"7355","Naso"},
	{"7356","Natile Nuovo"},
	{"7357","Natile Nuovo/Innesto Ss112 D'aspromonte"},
	{"7358","Natile Nuovo/Innesto Ss112 Diramazione D'aspromonte"},
	{"7359","Naturno"},
	{"7360","Navacchio"},
	{"7361","Nave"},
	{"7362","Navelli/Innesto Ss153 Della Valle Del Tirino"},
	{"7363","Navelli/Innesto Ss17 Dell'appen. Abruzzese"},
	{"7364","Navene"},
	{"7365","Navicello"},
	{"7366","Nembia"},
	{"7367","Nepesina"},
	{"7368","Nepi"},
	{"7369","Nera Montoro/Innesto Raccordo Viterbo-Terni"},
	{"7370","Nereto"},
	{"7371","Nerviano"},
	{"7372","Nespoli"},
	{"7373","Nesso"},
	{"7374","Nettunense"},
	{"7375","Nibbiano"},
	{"7376","Nibionno/Innesto Ss342 Briantea"},
	{"7377","Nibionno/Innesto Ss36"},
	{"7378","Nicastro"},
	{"7379","Nicastro/Incrocio Ss109 Della Piccola Sila"},
	{"7380","Nicastro/Innesto Ss18 Diramazione Tirrena Inferiore"},
	{"7381","Niccone/Innesto Ss3 Bis Tiberina"},
	{"7382","Niccone/Innesto Ss416 Del Niccone"},
	{"7383","Nichelino Nord"},
	{"7384","Nichelino Sud"},
	{"7385","Nicosia N./Innesto Ss117 Centrale Sicula"},
	{"7386","Nicosia N./Innesto Ss120 Dell'etna E Delle Madonie"},
	{"7387","Nicosia O./Innesto Ss117 Centrale Sicula"},
	{"7388","Nicosia O./Innesto Ss120 Dell'etna E Delle Madonie"},
	{"7389","Niella Tanaro"},
	{"7390","Nimis"},
	{"7391","Nismozza"},
	{"7392","Nissoria"},
	{"7393","Nizza Di Sicilia"},
	{"7394","Nizza Monferrato"},
	{"7395","Nizza Monferrato/Innesto Ss456 Del Turchino"},
	{"7396","Nizza Monferrato/Innesto Ss592 Di Canelli"},
	{"7397","Noale"},
	{"7398","Noalese"},
	{"7399","Noasca"},
	{"7400","Nocera"},
	{"7401","Nocera Inferiore"},
	{"7402","Nocera Inferiore/Innesto Ss18 Tirrena Inferiore"},
	{"7403","Nocera Inferiore/Innesto Ss266 Nocerina"},
	{"7404","Nocera Pagani"},
	{"7405","Nocera Scalo"},
	{"7406","Nocera Scalo/Inizio Variante Di Nocera"},
	{"7407","Nocera Umbra"},
	{"7408","Nocera Umbra/Innesto Ss3 Flaminia"},
	{"7409","Nocera Umbra/Innesto Ss361 Septempedana"},
	{"7410","Nocerina"},
	{"7411","Noceto"},
	{"7412","Noci"},
	{"7413","Noci/Innesto Ss377 Delle Grotte"},
	{"7414","Noci/Innesto Ss604 Di Alberobello"},
	{"7415","Noepoli"},
	{"7416","Nogara"},
	{"7417","Nogara/Innesto Ss10 Padana Inferiore"},
	{"7418","Nogara/Innesto Ss12 Dell'abetone E Del Brennero"},
	{"7419","Nogare'/Innesto Ss348 Feltrina"},
	{"7420","Nogare'/Innesto Ss667 Di Caerano"},
	{"7421","Nogaredo"},
	{"7422","Nogarole Rocca"},
	{"7423","Nogheredo"},
	{"7424","Nola"},
	{"7425","Nolana Sarnese"},
	{"7426","Noli"},
	{"7427","Nonantola"},
	{"7428","None (ss23)"},
	{"7429","Norcia"},
	{"7430","Nord Occidentale Sarda"},
	{"7431","Nosellari/Innesto Ss349 Di Val D'assa E Pedem. Costo"},
	{"7432","Nosellari/Innesto Ss350 Di Folgaria E Val D'astico"},
	{"7433","Notaresco"},
	{"7434","Notaresco Staz./Innesto Ss80 Del G.Sasso"},
	{"7435","Notaresco/Innesto Ss553 Di Atri"},
	{"7436","Noto"},
	{"7437","Noto/Innesto Ss115 Sud Occidentale Sicula"},
	{"7438","Noto/Innesto Ss287 Di Noto"},
	{"7439","Nottola"},
	{"7440","Nova Levante"},
	{"7441","Nova Milanese"},
	{"7442","Novafeltria"},
	{"7443","Novale"},
	{"7444","Novara"},
	{"7445","Novara Di Sicilia"},
	{"7446","Novara Est"},
	{"7447","Novara Ovest"},
	{"7448","Novara/Innesto Ss11 E Ss211 Della Lomellina"},
	{"7449","Novara/Innesto Ss11 Padana Superiore E Ss32 Ticinese"},
	{"7450","Novara/Innesto Ss11 Padana Superiore"},
	{"7451","Novara/Innesto Ss211 D. Lomellina E Ss32 Ticinese"},
	{"7452","Novara/Innesto Ss229 Del Lago D'orta"},
	{"7453","Novara/Innesto Ss299 Di Alagna"},
	{"7454","Novara/Innesto Ss341 Gallaratese"},
	{"7455","Novate Mezzola"},
	{"7456","Noventa Padovana/A4 Torino-Trieste"},
	{"7457","Noverasco"},
	{"7458","Novi Di Modena"},
	{"7459","Novi Ligure"},
	{"7460","Novoli/Innesto Ss551 Traversa Del Mugello"},
	{"7461","Nozza"},
	{"7462","Nucetto"},
	{"7463","Nulvi"},
	{"7464","Nuoro"},
	{"7465","Nuoro/Innesto Ss129 Trasversale Sarda"},
	{"7466","Nuoro/Innesto Ss389 Di Budduso' E Correboi"},
	{"7467","Nuova Favorita/Innesto Ss13 Pontebbana"},
	{"7468","Nuova Favorita/Innesto Ss14 Bis Di Mestre"},
	{"7469","Nuova Olonio"},
	{"7470","Nuova Olonio/Incrocio Ss402 Valeriana"},
	{"7471","Nuova Olonio/Innesto Ss36 L. Di Como E Dello Spluga"},
	{"7472","Nurachi"},
	{"7473","Nuragus"},
	{"7474","Nurallao"},
	{"7475","Nurallao/Innesto Ss128 Centrale Sarda"},
	{"7476","Nurallao/Innesto Ss197 Di S.Gavino E Del Flumini"},
	{"7477","Nuraxi De Mesu"},
	{"7478","Nure"},
	{"7479","Nus"},
	{"7480","Nuvolento"},
	{"7481","Occhieppo Inferiore"},
	{"7482","Occhiobello"},
	{"7483","Occidentale Etnea"},
	{"7484","Occimiano"},
	{"7485","Oderzo"},
	{"7486","Odolo"},
	{"7487","Ofanto"},
	{"7488","Ofena"},
	{"7489","Offanengo"},
	{"7490","Oggebbio"},
	{"7491","Ogliastro Cilento"},
	{"7492","Ogliastro Cilento/Innesto Ss18 Tirrena Inferiore"},
	{"7493","Olbia"},
	{"7494","Olbia/Incrocio Ss127 Settentrionale Sarda"},
	{"7495","Olbia/Innesto Ss125 Orientale Sarda"},
	{"7496","Oldenico"},
	{"7497","Oleggio Castello"},
	{"7498","Oleggio/Incrocio Ss32 Ticinese"},
	{"7499","Oleggio/Innesto Ss527 Bustese"},
	{"7500","Olgiate Comasco"},
	{"7501","Olivadi"},
	{"7502","Olivarella Sud"},
	{"7503","Olivella"},
	{"7504","Oliveto"},
	{"7505","Oliviera"},
	{"7506","Ollastra"},
	{"7507","Olmi"},
	{"7508","Olmo"},
	{"7509","Olmo/Innesto S.G.C. Grosseto-Fano"},
	{"7510","Olmo/Innesto Ss71 E Ss73"},
	{"7511","Olmo/Innesto Ss71 E Ss73 Var"},
	{"7512","Innesto Ss73 Senese Aretina E Ss73 Var"},
	{"7513","Ombriano"},
	{"7514","Omegna"},
	{"7515","Oneglia/Innesto Ss1 Aurelia"},
	{"7516","Oneglia/Innesto Ss449 Di Diano Marina"},
	{"7517","Oniferi"},
	{"7518","Onigo"},
	{"7519","Onno"},
	{"7520","Opera"},
	{"7521","Opi/Innesto Ss509 Di Forca D'acero"},
	{"7522","Opi/Innesto Ss83 Marsicana"},
	{"7523","Oppido Lucano"},
	{"7524","Oppido Lucano/Innesto Ss169 Di Genzano"},
	{"7525","Oppido Mamertina"},
	{"7526","Oppido Mamertina/Innesto Ss112 Bis D'aspromonte"},
	{"7527","Oppido Mamertina/Innesto Ss111Diramazione Di G.Tauro E Locri"},
	{"7528","Ora"},
	{"7529","Ora/Innesto Ss12 Abetone E Brennero"},
	{"7530","Ora/Innesto Ss48 Delle Dolomiti"},
	{"7531","Orani"},
	{"7532","Orbetello"},
	{"7533","Orbetello Scalo"},
	{"7534","Orbetello Scalo/Innesto Ss1 Aurelia"},
	{"7535","Orbetello Scalo/Innesto Ss440 Di Porto S.Stefano"},
	{"7536","Orcenigo Inferiore"},
	{"7537","Orco Feglino"},
	{"7538","Ordona"},
	{"7539","Ordona/Innesto Ss655 Di Candela"},
	{"7540","Orfengo"},
	{"7541","Orgorui Nuraghe"},
	{"7542","Oria"},
	{"7543","Oriago"},
	{"7544","Orientale Sarda"},
	{"7545","Orientale Sicula"},
	{"7546","Oriolo"},
	{"7547","Oriolo Romano"},
	{"7548","Oris"},
	{"7549","Oristano"},
	{"7550","Ormea"},
	{"7551","Ornano Grande"},
	{"7552","Ornavasso"},
	{"7553","Orosei/Incrocio Ss125 Orientale Sarda"},
	{"7554","Orosei/Innesto Ss129 Trasversale Sarda"},
	{"7555","Orotelli"},
	{"7556","Orsogna"},
	{"7557","Ortacesus"},
	{"7558","Ortana"},
	{"7559","Orte"},
	{"7560","Orte C./Innesto Raccordo Orte-Viterbo"},
	{"7561","Orte Scalo"},
	{"7562","Orte/Bivio Per Orte-Viterbo"},
	{"7563","Orte/Innesto Ss204 Ortana"},
	{"7564","Orte/Innesto Ss315 Di Magliano Sabina"},
	{"7565","Ortisei"},
	{"7566","Ortisei/Innesto Ss242 Di Val Gardena E Passo Sella"},
	{"7567","Ortisei/Innesto Ss242 Dir"},
	{"7568","Ortona"},
	{"7569","Ortona A14 Bologna-Taranto"},
	{"7570","Ortona/Innesto Ss16 Adriatica"},
	{"7571","Ortona/Innesto Ss538 Marrucina"},
	{"7572","Ortovero"},
	{"7573","Ortueri"},
	{"7574","Orvieto"},
	{"7575","Orvieto Scalo"},
	{"7576","Orvieto/Innesto Ss71 Umbro Cas. Romagnola"},
	{"7577","Orvieto/Innesto Ss79 Bis Ternana"},
	{"7578","Orvinio"},
	{"7579","Orzinuovi/Innesto Ss235 Di Orzinuovi"},
	{"7580","Orzinuovi/Innesto Ss668 Lenese"},
	{"7581","Orzivecchi"},
	{"7582","Osais"},
	{"7583","Osasco"},
	{"7584","Oscasale"},
	{"7585","Oschiri"},
	{"7586","Oschiri/Innesto Ss199 Di Monti"},
	{"7587","Oschiri/Innesto Ss392 Del Lago Di Coghinas"},
	{"7588","Oschiri/Innesto Ss597 Di Logudoro"},
	{"7589","Osilo"},
	{"7590","Osimo"},
	{"7591","Osnago"},
	{"7592","Osoppo"},
	{"7593","Ospedaletti"},
	{"7594","Ospedaletto"},
	{"7595","Ospedaletto D'alpinolo/Innesto Ss374 Dir"},
	{"7596","Ospedaletto D'alpinolo/Innesto Ss374dir"},
	{"7597","Ospedaletto Di Forli'/Innesto Ss67 Tosco Romagnola"},
	{"7598","Ospedaletto Di Pescantina"},
	{"7599","Ospedaletto Euganeo"},
	{"7600","Ospedaletto Lodigiano"},
	{"7601","Ospedaletto/Innesto Ss254 Di Cervia"},
	{"7602","Ospedalicchio/Innesto Ss75 Centrale Umbra"},
	{"7603","Ospiate"},
	{"7604","Ospidaletto"},
	{"7605","Ospitaletto"},
	{"7606","Ossario Del Pasubio"},
	{"7607","Ossario/Innesto Ss141 Diramazione Strada Cadorna"},
	{"7608","Ossario/Innesto Ss141 Strada Cadorna"},
	{"7609","Ossio Sotto"},
	{"7610","Ossuccio"},
	{"7611","Ostellato"},
	{"7612","Osteria"},
	{"7613","Osteria Alle Alpi"},
	{"7614","Osteria Ansidonia"},
	{"7615","Osteria Del Gatto"},
	{"7616","Osteria Del Gatto/Innesto Ss219 Di Gubbio/Innesto Ss76"},
	{"7617","Osteria Del Gatto/Innesto Ss3 Flaminia/Innesto Ss76"},
	{"7618","Osteria Del Gatto/Innesto Ss3 Flaminia/InnestoSs219"},
	{"7619","Osteria Del Termine"},
	{"7620","Osteria Di Morano"},
	{"7621","Osteria Nuova"},
	{"7622","Osterianova"},
	{"7623","Ostia Antica"},
	{"7624","Ostia Scavi/Innesto Ss296 Della Scafa"},
	{"7625","Ostia Scavi/Innesto Ss8 Via Del Mare"},
	{"7626","Ostia-Anzio"},
	{"7627","Ostiglia/Innesto Ss12"},
	{"7628","Ostiglia/Innesto Ss482 Alto Polesana"},
	{"7629","Ostuni"},
	{"7630","Otranto/Innesto Ss16 Adriatica"},
	{"7631","Otranto/Innesto Ss173 Delle Terme Salentine"},
	{"7632","Otranto/Innesto Ss611 Di Otranto"},
	{"7633","Ottaviano"},
	{"7634","Ottone"},
	{"7635","Oulx"},
	{"7636","Oulx Est"},
	{"7637","Oulx Ovest"},
	{"7638","Oulx/Innesto Ss24 Del Monginevro"},
	{"7639","Oulx/Innesto Ss335 Di Bardonecchia"},
	{"7640","Ovada"},
	{"7641","Ovaro"},
	{"7642","Ovest"},
	{"7643","Ovindoli"},
	{"7644","Ovindoli/Innesto Ss5 Bis Vestina-Sarentina"},
	{"7645","Ovindoli/Innesto Ss520 Del Ceraso"},
	{"7646","Ovodda"},
	{"7647","Ozegna"},
	{"7648","Ozieri"},
	{"7649","Ozieri/Innesto Ss128 Bis Centrale Sarda"},
	{"7650","Ozieri/Innesto Ss132 Di Orzieri"},
	{"7651","Ozieri/Innesto Ss132 Di Ozieri"},
	{"7652","Ozzano Dell'emilia"},
	{"7653","Ozzano Monferrato"},
	{"7654","Ozzano Monferrato/Innesto Ss457 Di Moncalvo"},
	{"7655","Ozzano Monferrato/Innesto Ss590 Val Cerrina"},
	{"7656","Ozzano Taro"},
	{"7657","P. Civitanova/Innesto Ss485 Corridonia Maceratese"},
	{"7658","P.Le Bologna"},
	{"7659","P.Te Gardena/Innesto Ss242 Di Val Gardena E P.Sella"},
	{"7660","P.Te Molinos/Innesto Ss128 Centrale Sarda"},
	{"7661","P.Te Molinos/Innesto Ss131 Dir/C Di Carlo Felice"},
	{"7662","P.Te Priula/Innesto Ss248 Schiavonesca-Marost."},
	{"7663","P.Te Squarciarelli/Incrocio Ss216 Maremmana Iii"},
	{"7664","P.Te Squarciarelli/Incrocio Ss218 Via Rocca Di Papa"},
	{"7665","P.To Di S.Antioco/Innesto Ss126 Diramazione Sud Occ. Sardo"},
	{"7666","P.To Empedocle/Innesto Ss115 Sud Occ.Le Sicula"},
	{"7667","Paceco"},
	{"7668","Pacengo"},
	{"7669","Pacentro"},
	{"7670","Padana Inferiore"},
	{"7671","Padana Superiore"},
	{"7672","Padergnone"},
	{"7673","Paderno Dugnano"},
	{"7674","Padiglione"},
	{"7675","Padivarma"},
	{"7676","Padola"},
	{"7677","Padova"},
	{"7678","Padova Est"},
	{"7679","Padova Ovest"},
	{"7680","Padova Zona Industriale-Interporto"},
	{"7681","Padova/Innesto Ss11 Padana Superiore"},
	{"7682","Padova/Innesto Ss47 Della Valsugana"},
	{"7683","Padova/Innesto Ss47 Racc Di Altichiero"},
	{"7684","Padria"},
	{"7685","Padriciano/Innesto Raccordo A4-Trieste"},
	{"7686","Padule"},
	{"7687","Paese"},
	{"7688","Paganella"},
	{"7689","Paganica"},
	{"7690","Paganica/Innesto Ss17 Bis"},
	{"7691","Paganica/Innesto Ss17 Bis Dir/A"},
	{"7692","Paganico N"},
	{"7693","Pagliaro"},
	{"7694","Pai Di Torri Del Benaco"},
	{"7695","Paisco"},
	{"7696","Paitone"},
	{"7697","Palagiano/Innesto Ss106Diramazione Jonica"},
	{"7698","Palagiano/Innesto Ss7 Appia"},
	{"7699","Palagonia"},
	{"7700","Palanzano"},
	{"7701","Palata/Innesto Ss483 Termolese"},
	{"7702","Palau"},
	{"7703","Palazzetto"},
	{"7704","Palazzo Adriano"},
	{"7705","Palazzo Del Pero"},
	{"7706","Palazzolo"},
	{"7707","Palazzolo Acreide"},
	{"7708","Palazzolo Acreide/Innesto Ss124 Siracusana"},
	{"7709","Palazzolo Acreide/Innesto Ss287 Di Noto"},
	{"7710","Palazzolo Oglio/Incrocio Ss573 L'ogliese"},
	{"7711","Palazzolo Oglio/Innesto Ss469 Sebina Occidentale"},
	{"7712","Palazzolo Sull'oglio"},
	{"7713","Palazzolo Vercellese Var."},
	{"7714","Palazzuolo Sul Senio"},
	{"7715","Palazzuolo Sul Senio/Innesto Ss306 Casolana Riolese"},
	{"7716","Palazzuolo Sul Senio/Innesto Ss477"},
	{"7717","Palena"},
	{"7718","Palentina"},
	{"7719","Palermiti"},
	{"7720","Palermo"},
	{"7721","Palermo - Innesto Ss624"},
	{"7722","Palermo C.So Vittorio Emanuele"},
	{"7723","Palermo Nord"},
	{"7724","Palermo Nord - A29 Palermo-Mazara"},
	{"7725","Palermo Porto/Innesto Tangenziale Di Palermo"},
	{"7726","Palermo Villabate"},
	{"7727","Palermo Villabate-Raccordo Per Tangenziale Pa"},
	{"7728","Palermo/Innesto Tangenziale Di Palermo"},
	{"7729","Palermo-Allacciamento Tangenziale Palermo"},
	{"7730","Palermo-Catania"},
	{"7731","Palermo-Cefalu'"},
	{"7732","Palermo-Innesto Raccordo Tangenziale Pa-A19"},
	{"7733","Palermo-Mazara Del Vallo"},
	{"7734","Palermo-Sciacca"},
	{"7735","Palese/Macc/Innesto Asse Attr. Cerignola-Bari"},
	{"7736","Palestrina"},
	{"7737","Palestro"},
	{"7738","Palinuro"},
	{"7739","Palinuro/Innesto Ss447 Di Palinuro"},
	{"7740","Palinuro/Innesto Ss447 Racc Di Palinuro"},
	{"7741","Palinuro/Innesto Ss562 Del Golfo Di Policastro"},
	{"7742","Palizzi Marina"},
	{"7743","Pallagorio"},
	{"7744","Pallanzeno"},
	{"7745","Pallerone"},
	{"7746","Palma Campania"},
	{"7747","Palma Di Montechiaro"},
	{"7748","Palma Di Montechiaro/Innesto Ss410 Di Naro"},
	{"7749","Palma Montechiaro/Innesto Ss115 Sud Occid. Sicula"},
	{"7750","Palmanova"},
	{"7751","Palmanova/Innesto Ss252 Di Palmanova"},
	{"7752","Palmanova/Innesto Ss352 Di Grado"},
	{"7753","Palmanova-Tarvisio"},
	{"7754","Palmi"},
	{"7755","Palo"},
	{"7756","Palo Del Colle"},
	{"7757","Palombara Sabina"},
	{"7758","Palombara/Innesto Raccordo Viterbo-Terni"},
	{"7759","Palombara/Innesto Ss156 Dei Monti Lepini"},
	{"7760","Palombara/Innesto Ss637 Diramazione Di Frosinone E Gaeta"},
	{"7761","Palombaro"},
	{"7762","Paludi"},
	{"7763","Paludo"},
	{"7764","Panchia'"},
	{"7765","Pancole"},
	{"7766","Pandino"},
	{"7767","Pandino-Dovera/Innesto Ss415 Paullese"},
	{"7768","Pandola"},
	{"7769","Panicaglia"},
	{"7770","Panicagliora"},
	{"7771","Panicarola"},
	{"7772","Paniga"},
	{"7773","Panoramica Zegna"},
	{"7774","Panzano In Chianti"},
	{"7775","Panzano/Innesto Ss541 Traversa Maremmana"},
	{"7776","Panzano/Innesto Ss73 Senese Aretina"},
	{"7777","Paola/Innesto Ss18 Racc/Ter Tirrena Inferiore"},
	{"7778","Paola/Innesto Ss18 Tirrena Inferiore"},
	{"7779","Paolantonio"},
	{"7780","Paolelli"},
	{"7781","Paparella"},
	{"7782","Paparotti/Innesto Ss352 Di Grado"},
	{"7783","Paparotti/Innesto Ss56 Di Gorizia"},
	{"7784","Paparotti-Innesto Ss56 E Ss352"},
	{"7785","Papasidero"},
	{"7786","Parabita"},
	{"7787","Parabita/Innesto Ss459 Di Parabita"},
	{"7788","Parabita/Innesto Ss475 Di Casarano"},
	{"7789","Paraggi"},
	{"7790","Paratico"},
	{"7791","Paravati"},
	{"7792","Parco Dei Medici"},
	{"7793","Parco Dei Monaci"},
	{"7794","Parella"},
	{"7795","Parenti"},
	{"7796","Parma"},
	{"7797","Parma Est/Innesto Tangenziale Di Parma"},
	{"7798","Parma Ovest"},
	{"7799","Parma Ovest/Innesto Tangenziale Di Parma"},
	{"7800","Parma/Incrocio Ss9 Emilia"},
	{"7801","Parma/Innesto Ss343 Asolana/Innesto Ss513"},
	{"7802","Parma/Innesto Ss513 Di Val D'enza"},
	{"7803","Parma/Innesto Ss62 Della Cisa"},
	{"7804","Parma/Innesto Ss665 Massese"},
	{"7805","Parma/Innesto Ss9 Emilia"},
	{"7806","Parma/Innesto Ss9 Emilia/Innesto Ss343"},
	{"7807","Parma/Innesto Tangenziale Di Parma"},
	{"7808","Parma-La Spezia"},
	{"7809","Parolise"},
	{"7810","Parolise/Innesto Ss Ofantina"},
	{"7811","Parolise/Innesto Ss400 Di Castelvetere"},
	{"7812","Parolise/Innesto Ss7 Appia"},
	{"7813","Parolise-Innesto Ss400 Di Castelvetere"},
	{"7814","Parrocchia"},
	{"7815","Partanna"},
	{"7816","Partina"},
	{"7817","Partinico"},
	{"7818","Partinico/Innesto Ss113 Settentrionale Sicula"},
	{"7819","Partinico/Innesto Ss186 Di Monreale"},
	{"7820","Pasa"},
	{"7821","Pascarola/Innesto S.G.C. Nola-Domitio"},
	{"7822","Passaggio D'assisi/Innesto Ss147 Di Assisi"},
	{"7823","Passaggio Di Assisi/Innesto Ss75 Centrale Umbra"},
	{"7824","Passatempo"},
	{"7825","Passignano Est"},
	{"7826","Passignano Ovest"},
	{"7827","Passignano Sul Trasimeno"},
	{"7828","Passo Alleghe"},
	{"7829","Passo Arcu Di Correboi"},
	{"7830","Passo Arcugenna Bogai"},
	{"7831","Passo Bracco"},
	{"7832","Passo Cavalli"},
	{"7833","Passo Cereda"},
	{"7834","Passo Cibiana"},
	{"7835","Passo Cibiana Di Cadore"},
	{"7836","Passo Cimabanche"},
	{"7837","Passo Cinque Croci"},
	{"7838","Passo Colla Di Casaglia/Innesto Ss302"},
	{"7839","Passo Colla Di Casaglia/Innesto Ss477"},
	{"7840","Passo Colle Borano"},
	{"7841","Passo Colle Del Piccolo S. Bernardo"},
	{"7842","Passo Colle Della Lombarda"},
	{"7843","Passo Colle Di Nava"},
	{"7844","Passo Colle Di S.Bernardo"},
	{"7845","Passo Corese/Innesto Ss313 Di Passo Corese"},
	{"7846","Passo Corese/Innesto Ss4 Salaria"},
	{"7847","Passo Costalunga"},
	{"7848","Passo Croce A Mori"},
	{"7849","Passo Croce Amori"},
	{"7850","Passo Croce Domini/Innesto Ss669 Del P.Crocedomini"},
	{"7851","Passo Crocetta"},
	{"7852","Passo Cruci"},
	{"7853","Passo D' Eira"},
	{"7854","Passo D.Corno"},
	{"7855","Passo Dei Carpinelli"},
	{"7856","Passo Dei Giovi"},
	{"7857","Passo Dei Tre"},
	{"7858","Passo D'eira"},
	{"7859","Passo Del Bocco"},
	{"7860","Passo Del Bracco"},
	{"7861","Passo Del Brallo Di Pregola"},
	{"7862","Passo Del Brennero"},
	{"7863","Passo Del Brennero/Confine Con L'austria"},
	{"7864","Passo Del Calvario"},
	{"7865","Passo Del Colle Di S.Bernardo"},
	{"7866","Passo Del Diavolo"},
	{"7867","Passo Del Falzarego"},
	{"7868","Passo Del Foscagno"},
	{"7869","Passo Del Furlo"},
	{"7870","Passo Del Gallo"},
	{"7871","Passo Del Gavia"},
	{"7872","Passo Del Gioco"},
	{"7873","Passo Del Giogo Di S.Maria"},
	{"7874","Passo Del Giovetti"},
	{"7875","Passo Del Giovo"},
	{"7876","Passo Del Gran S. Bernardo"},
	{"7877","Passo Del Mercante"},
	{"7878","Passo Del Mortirolo"},
	{"7879","Passo Del Muraglione"},
	{"7880","Passo Del Pelizzone"},
	{"7881","Passo Del Penice"},
	{"7882","Passo Del Penice/Innesto Ss461 Del Passo Penice"},
	{"7883","Passo Del Pordoi"},
	{"7884","Passo Del Predil/Confine Con La Slovenia"},
	{"7885","Passo Del Rombo"},
	{"7886","Passo Del Rombo/Confine Con L'austria"},
	{"7887","Passo Del Sassello"},
	{"7888","Passo Del Sestriere"},
	{"7889","Passo Del Signorino"},
	{"7890","Passo Del Sommo"},
	{"7891","Passo Del Tonale"},
	{"7892","Passo Del Vivione"},
	{"7893","Passo Del Zovo"},
	{"7894","Passo Dell' Agnello"},
	{"7895","Passo Dell' Apisella"},
	{"7896","Passo Dell' Aprica"},
	{"7897","Passo Della Calla"},
	{"7898","Passo Della Cisa"},
	{"7899","Passo Della Collina"},
	{"7900","Passo Della Consuma"},
	{"7901","Passo Della Forcella"},
	{"7902","Passo Della Futa"},
	{"7903","Passo Della Mendola"},
	{"7904","Passo Della Porretta"},
	{"7905","Passo Della Presolana"},
	{"7906","Passo Della Raticosa"},
	{"7907","Passo Della Scalone"},
	{"7908","Passo Della Scoffera"},
	{"7909","Passo Dell'aprica"},
	{"7910","Passo Delle Crocelle"},
	{"7911","Passo Delle Crocelle Di Valle Cupa"},
	{"7912","Passo Delle Crocelle E Di Valle Cupa"},
	{"7913","Passo Delle Palade"},
	{"7914","Passo Delle Radici"},
	{"7915","Passo Dello Scalone"},
	{"7916","Passo Dello Spluga"},
	{"7917","Passo Dello Spluga/Confine Con La Svizzera"},
	{"7918","Passo Dello Stalle"},
	{"7919","Passo Dello Stelvio"},
	{"7920","Passo Dello Stelvio/Innesto Ss38 Dello Stelvio"},
	{"7921","Passo Di Acquabona"},
	{"7922","Passo Di Amelia"},
	{"7923","Passo Di Appennino"},
	{"7924","Passo Di Arcu Di Correboi"},
	{"7925","Passo Di Arcu Genna Bogai"},
	{"7926","Passo Di Bidderdi"},
	{"7927","Passo Di Bocca Trabaria"},
	{"7928","Passo Di Cadibona"},
	{"7929","Passo Di Campo Carlo Magno"},
	{"7930","Passo Di Campo Carlomagno"},
	{"7931","Passo Di Campolongo"},
	{"7932","Passo Di Caravai"},
	{"7933","Passo Di Carpinelli"},
	{"7934","Passo Di Cento Croci"},
	{"7935","Passo Di Cinquemiglia"},
	{"7936","Passo Di Colle Borano"},
	{"7937","Passo Di Costalunga"},
	{"7938","Passo Di Croce D'aune"},
	{"7939","Passo Di Croce Dello Scrivano"},
	{"7940","Passo Di Croce Ferrata"},
	{"7941","Passo Di Crocedomini"},
	{"7942","Passo Di Forca Di Caruso"},
	{"7943","Passo Di Forca Di Penne"},
	{"7944","Passo Di Forcella Aurina"},
	{"7945","Passo Di Genna Frongia"},
	{"7946","Passo Di Genna Frorgia"},
	{"7947","Passo Di Giau"},
	{"7948","Passo Di Guardiagrele"},
	{"7949","Passo Di Lagastrello/Innesto Ss665 Massese"},
	{"7950","Passo Di Lagastrello/Innesto Ss665Diramazione Massese"},
	{"7951","Passo Di Lanciano"},
	{"7952","Passo Di Lavaze'"},
	{"7953","Passo Di Maniva"},
	{"7954","Passo Di Mirabella"},
	{"7955","Passo Di Mirabella/Innesto Ss303 Del Formicoso"},
	{"7956","Passo Di Miralago"},
	{"7957","Passo Di Monte Bove"},
	{"7958","Passo Di Monte Croce"},
	{"7959","Passo Di Monte Croce Carnico"},
	{"7960","Passo Di Monte Croce Comelico"},
	{"7961","Passo Di Monte Croce Di Comelico"},
	{"7962","Passo Di Montegodi"},
	{"7963","Passo Di Oppio"},
	{"7964","Passo Di Pennes"},
	{"7965","Passo Di Piano Della Limina"},
	{"7966","Passo Di Pietra Spada"},
	{"7967","Passo Di Resia/Austria"},
	{"7968","Passo Di Riva"},
	{"7969","Passo Di Ropola"},
	{"7970","Passo Di S.Bernardino"},
	{"7971","Passo Di S.Leonardo"},
	{"7972","Passo Di S.Lugano"},
	{"7973","Passo Di S.Osvaldo"},
	{"7974","Passo Di S.Pellegrino"},
	{"7975","Passo Di S.Savino"},
	{"7976","Passo Di Sella Carcaci"},
	{"7977","Passo Di Serra Cavallo"},
	{"7978","Passo Di Tanamea"},
	{"7979","Passo Di Treia"},
	{"7980","Passo Di Valles"},
	{"7981","Passo Di Vezzena"},
	{"7982","Passo Di Viamaggio"},
	{"7983","Passo Di Vivione"},
	{"7984","Passo Di Xon"},
	{"7985","Passo Di Zovo"},
	{"7986","Passo D'orta/Innesto Ss16 Adriatica"},
	{"7987","Passo D'orta/Innesto Ss161 Di Ortanova"},
	{"7988","Passo Duran"},
	{"7989","Passo Falzarego"},
	{"7990","Passo Fedaia"},
	{"7991","Passo Forcella Di Staulanza"},
	{"7992","Passo Gardena"},
	{"7993","Passo Genna Arramene"},
	{"7994","Passo Genna Sarbene"},
	{"7995","Passo Genna Scalas"},
	{"7996","Passo Gola Del Furlo"},
	{"7997","Passo Granito"},
	{"7998","Passo Le Piastre"},
	{"7999","Passo Limbara"},
	{"8000","Passo M.Te Croce Carnico/Confine Con L'austria"},
	{"8001","Passo Mandrioli"},
	{"8002","Passo Maniva"},
	{"8003","Passo Martino-Zona Industriale Sud"},
	{"8004","Passo Mauria"},
	{"8005","Passo Mirabella"},
	{"8006","Passo Mirabella/Innesto Ss90 Delle Puglie"},
	{"8007","Passo Miralago"},
	{"8008","Passo Penice/Innesto Ss412 Della Val Tidone"},
	{"8009","Passo Pennes"},
	{"8010","Passo Pian Mucini/Innesto Ss441 Massetana"},
	{"8011","Passo Portella Bifolchi"},
	{"8012","Passo Portella Del Bafurco"},
	{"8013","Passo Predil"},
	{"8014","Passo Predil/Innesto Ss54 Del Friuli"},
	{"8015","Passo Predil/Innesto Ss54 Radd Del Friuli"},
	{"8016","Passo Quercia Del Monaco"},
	{"8017","Passo Resia"},
	{"8018","Passo Rest"},
	{"8019","Passo Rolle"},
	{"8020","Passo S.Boldo"},
	{"8021","Passo S.Giacomo/Confine Con La Svizzera"},
	{"8022","Passo S.Leonardo"},
	{"8023","Passo S.Lugano"},
	{"8024","Passo S.Marco"},
	{"8025","Passo S.Savino"},
	{"8026","Passo Sambuca"},
	{"8027","Passo Sarcerei"},
	{"8028","Passo S'arcu De Genneruxi"},
	{"8029","Passo Sella"},
	{"8030","Passo Sella Carcaci"},
	{"8031","Passo Sentinella"},
	{"8032","Passo Serra"},
	{"8033","Passo Tascussi"},
	{"8034","Passo Tomarlo"},
	{"8035","Passo Tre Croci"},
	{"8036","Passo Tubre"},
	{"8037","Passo Tubre/Confine Con La Svizzera"},
	{"8038","Passo Vezzena"},
	{"8039","Passo Viamaggio"},
	{"8040","Passo Villa"},
	{"8041","Passo Vizze"},
	{"8042","Passo Vizze/Confine Con L'austria"},
	{"8043","Passo Xon"},
	{"8044","Passo Zovallo"},
	{"8045","Passons"},
	{"8046","Passopisciaro"},
	{"8047","Pasteria/Lapide"},
	{"8048","Pastina"},
	{"8049","Pastorello"},
	{"8050","Paterno"},
	{"8051","Paterno S./Innesto Ss5 Tiburtina Valeria"},
	{"8052","Paterno/Innesto Ss5 Bis/Diramazione (ramo Destro) Vestina"},
	{"8053","Paterno/Innesto Ss5 Bis/Diramazione (ramo Sinistro) Vestina"},
	{"8054","Paterno/Innesto Ss5 Tiburtina Valeria"},
	{"8055","Paternopoli"},
	{"8056","Pattada"},
	{"8057","Patti"},
	{"8058","Paullese"},
	{"8059","Paullo"},
	{"8060","Paurano-Collalto"},
	{"8061","Pausa"},
	{"8062","Pavana Pistoiese"},
	{"8063","Pavia"},
	{"8064","Pavia/Innesto Ss234 Codognese"},
	{"8065","Pavia/Innesto Ss235 Di Orzinuovi"},
	{"8066","Pavia/Innesto Ss35 Dei Giovi"},
	{"8067","Pavia/Innesto Ss526 Dell'esticino"},
	{"8068","Pavia/Raccordo Pavia-Bereguardo"},
	{"8069","Pavona"},
	{"8070","Pavullo Nel Frignano"},
	{"8071","Pazzano"},
	{"8072","Pazzarello"},
	{"8073","Peaio"},
	{"8074","Pece"},
	{"8075","Pecetto"},
	{"8076","Pecol"},
	{"8077","Pecorone/Innesto Ss19 E Ss104"},
	{"8078","Pecorone/Innesto Ss653 E Ss104"},
	{"8079","Pedaso"},
	{"8080","Pedaso/Innesto Ss16 Adriatica"},
	{"8081","Pedaso/Innesto Ss433 Di Val D'aso"},
	{"8082","Pedavena"},
	{"8083","Pederoa"},
	{"8084","Pederobba"},
	{"8085","Pedicciano"},
	{"8086","Pedivigliano"},
	{"8087","Pedraces"},
	{"8088","Pegognaga"},
	{"8089","Pegola"},
	{"8090","Pegolotte"},
	{"8091","Pellegrina"},
	{"8092","Pellegrino Parmense"},
	{"8093","Pellizzano"},
	{"8094","Pelos Di Cadore"},
	{"8095","Pelugo"},
	{"8096","Penia"},
	{"8097","Penna S.Andrea"},
	{"8098","Pennapiedimonte"},
	{"8099","Penne"},
	{"8100","Penne/Innesto Ss151 Della Valle Del Tavo"},
	{"8101","Penne/Innesto Ss81 Picena Aprutina"},
	{"8102","Pennes"},
	{"8103","Pentone"},
	{"8104","Pera"},
	{"8105","Pera-Fluno"},
	{"8106","Perarolo Di Cadore"},
	{"8107","Perca"},
	{"8108","Percile"},
	{"8109","Pereta"},
	{"8110","Peretola"},
	{"8111","Pergola"},
	{"8112","Pergola Ponte"},
	{"8113","Pergola/Innesto Ss276 Dell'alto Agri"},
	{"8114","Pergola/Innesto Ss598 Di Fondo Valle D'agri"},
	{"8115","Pergusa"},
	{"8116","Pergusina"},
	{"8117","Peri"},
	{"8118","Perinetti"},
	{"8119","Perino Di Coli"},
	{"8120","Perle"},
	{"8121","Pernate/Incrocio Tangenziale Di Novara"},
	{"8122","Pero"},
	{"8123","Perosa Argentina"},
	{"8124","Pertegada"},
	{"8125","Perugia"},
	{"8126","Perugia Centro-Prepo"},
	{"8127","Perugia Est-Piscille"},
	{"8128","Perugia Ovest-Ferro Di Cavallo"},
	{"8129","Perugia Stadio-Madonna Alta"},
	{"8130","Perugia Staz.-San Faustino"},
	{"8131","Perugia/Innesto Ss317 Marscianese"},
	{"8132","Perugia/Innesto Ss75 Bis Del Trasimeno"},
	{"8133","Pesa Ponte"},
	{"8134","Pesariis"},
	{"8135","Pesaro"},
	{"8136","Pesaro-Urbino"},
	{"8137","Pescantina"},
	{"8138","Pescara"},
	{"8139","Pescara Aeroporto/Innesto Ss16 Var"},
	{"8140","Pescara Centro/Innesto Ss16 Diramazione C"},
	{"8141","Pescara N. Citta' S.Angelo"},
	{"8142","Pescara Ovest-Chieti"},
	{"8143","Pescara Sud-Francavilla"},
	{"8144","Pescara/Fine Variante Di Pescara"},
	{"8145","Pescara/Inizio Variante Di Pescara"},
	{"8146","Pescara/Innesto Ss16 Adriatica"},
	{"8147","Pescara/Innesto Ss16 Bis Adriatica"},
	{"8148","Pescara/Innesto Ss5 Tiburtina Valeria"},
	{"8149","Pescara/Innesto Ss16 Adriatica"},
	{"8150","Pescara-Villanova"},
	{"8151","Pescasseroli"},
	{"8152","Pescate/Innesto Ss36 Del L. Di Como E Dello Spluga"},
	{"8153","Pescate/Innesto Ss583 Lariana"},
	{"8154","Peschici"},
	{"8155","Peschiera"},
	{"8156","Peschiera Del Garda"},
	{"8157","Peschiera Del Garda/Innesto Ss11 Padana Superiore"},
	{"8158","Peschiera Del Garda/Svincolo Ss249 Gard. Orien."},
	{"8159","Peschiera/Innesto Ss103 Di Val D'angri"},
	{"8160","Peschiera/Innesto Ss176 Della Valle Del Basento"},
	{"8161","Pescia"},
	{"8162","Pescina"},
	{"8163","Pesco Sannita"},
	{"8164","Pescolanciano/Innesto Ss650 Di Fondo Valle Trigno"},
	{"8165","Pescolanciano/Innesto Ss651 Di Pescolanciano"},
	{"8166","Pescopagano"},
	{"8167","Pescul"},
	{"8168","Pese Di Grozzana/Confine Con La Slovenia"},
	{"8169","Pestarena"},
	{"8170","Petina"},
	{"8171","Petralia Sottana"},
	{"8172","Petrazzi"},
	{"8173","Petrella Tifernina"},
	{"8174","Petrignano D'assisi"},
	{"8175","Petrizzi-Gagliato"},
	{"8176","Petrona'"},
	{"8177","Petroro/Innesto Ss614 Della Maielletta"},
	{"8178","Pettenasco"},
	{"8179","Pezze Di Greco"},
	{"8180","Pezzo"},
	{"8181","Piacenza"},
	{"8182","Piacenza Nord"},
	{"8183","Piacenza Ovest"},
	{"8184","Piacenza Sud"},
	{"8185",""},
	{"8186","Piacenza/Innesto Ss10 Padana Inferiore"},
	{"8187","Piacenza/Innesto Ss10 Padana Inferiore"},
	{"8188","Piacenza/Innesto Ss45 Di Val Trebbia"},
	{"8189","Piacenza/Innesto Ss9 Via Emilia"},
	{"8190","Piacenza/Innesto Tangenziale Di Piacenza"},
	{"8191",""},
	{"8192","Piadena/Innesto Ss10 Padana Inferiore"},
	{"8193","Piadena/Innesto Ss343 Asolana"},
	{"8194","Piaggio Valmara/Confine Con La Svizzera"},
	{"8195","Piaggione"},
	{"8196","Pian D. Fugazze/Innesto Ss46 Diramazione Del Pasubio"},
	{"8197","Pian D.Fugazze/Innesto Ss46 Del Pasubio"},
	{"8198","Pian D'alma"},
	{"8199","Pian Del Lago/Innesto Ss140Diramazione Del Lago Di Albano"},
	{"8200","Pian Del Lago/Innesto Ss297 Bis Dell'emissario"},
	{"8201","Pian Del Lago/Innesto Ss297 Del Lago Olimpico"},
	{"8202","Pian Del Medico/Innesto Ss76 Della Val D'esino"},
	{"8203","Pian Del Voglio"},
	{"8204","Pian Della Osteria"},
	{"8205","Pian Della Pieve"},
	{"8206","Pian Di Barca"},
	{"8207","Pian Di Borno"},
	{"8208","Pian Di Mugnone"},
	{"8209","Pian Di Pieca/Innesto Ss502 Di Cingoli"},
	{"8210","Pian Di Pieca/Innesto Ss78 Picena"},
	{"8211","Pian Di Vedoia Ovest"},
	{"8212","Pian Di Vedoia/A27 Portogruaro-Pordenone"},
	{"8213","Pian Di Vedoia-Ss51 Di Alemagna"},
	{"8214","Pian Mucini Podere/Innesto Ss439 Sarzanese V."},
	{"8215","Piana Crixia"},
	{"8216","Piana Crixia/Innesto Ss29 Del Colle Di Cadibona"},
	{"8217","Piana Crixia/Innesto Ss30 Di Val Bormida"},
	{"8218","Piana Di M.Verna/Innesto Ss264 Del Basso Volturno"},
	{"8219","Piana Di S.Raffaele"},
	{"8220","Pianazzo/Innesto Ss36 Diramazione Per Madesimo"},
	{"8221","Pianazzo/Innesto Ss36 Lago Di Como E Dello Spluga"},
	{"8222","Pianche"},
	{"8223","Piandassino/Innesto Sgc Orte-Ra E Ss3 Bis"},
	{"8224","Piandelagotti"},
	{"8225","Piane Di Falerone"},
	{"8226","Pianella"},
	{"8227","Pianello"},
	{"8228","Pianello - Innesto Ss318"},
	{"8229","Pianello Lario"},
	{"8230","Pianello/Innesto Ss318 Var"},
	{"8231","Pianengo"},
	{"8232","Pianezza"},
	{"8233","Piani D'invrea"},
	{"8234","Pianico"},
	{"8235","Piano"},
	{"8236","Piano Campaldino/Innesto Ss310 Del Bidente"},
	{"8237","Piano Del Lago/Innesto Ss108 Silana Di Cariati"},
	{"8238","Piano Del Lago/Innesto Ss19 Delle Calabrie"},
	{"8239","Piano Della Lente"},
	{"8240","Piano Delle Cinquemiglia"},
	{"8241","Piano Di M.Verna/Innesto Ss87 Sannitica"},
	{"8242","Piano Di Sorrento"},
	{"8243","Piano D'ischia/Innesto Ss574 Del M.Te Terminio"},
	{"8244","Piano D'ischia/Innesto Ss574 Diramazione Del M.Te Terminio"},
	{"8245","Piano D'orta"},
	{"8246","Piano Laceno"},
	{"8247","Pianodardine/Innesto Ss7 Bis Di Terra Di Lavoro"},
	{"8248","Pianodardine/Innesto Ss7 Via Appia"},
	{"8249","Pianola"},
	{"8250","Pianomarotta"},
	{"8251","Pianoro Nuovo"},
	{"8252","Pianoro Vecchio"},
	{"8253","Pianosinatico"},
	{"8254","Piantedo/Innesto Ss340 Diramazione Regina"},
	{"8255","Piantedo/Innesto Ss36"},
	{"8256","Piave"},
	{"8257","Piazza"},
	{"8258","Piazza Al Serchio"},
	{"8259","Piazza Armerina"},
	{"8260","Piazza Kennedy"},
	{"8261","Piazzale Del Castello"},
	{"8262","Piazzale Impianti Sportivi"},
	{"8263","Piazzale Lato Francese"},
	{"8264","Piazzale Lato Italiano"},
	{"8265","Piazzale Traforo Del Frejus"},
	{"8266","Piazze"},
	{"8267","Picciame Di Posta"},
	{"8268","Piccione"},
	{"8269","Piccolino"},
	{"8270","Piccolo S.Bernardo/Confine Con La Francia"},
	{"8271","Picena"},
	{"8272","Piceno"},
	{"8273","Piceno Aprutina"},
	{"8274","Picente"},
	{"8275","Picerno"},
	{"8276","Pico"},
	{"8277","Pico/Innesto Ss628 Leuciana"},
	{"8278","Pico/Innesto Ss82 Della Valle Del Liri"},
	{"8279","Pie' Di Moggio"},
	{"8280","Pie' Di Via Contignaco"},
	{"8281","Piedimonte"},
	{"8282","Piedimonte Etneo"},
	{"8283","Piedimonte Matese"},
	{"8284","Piedimulera"},
	{"8285","Piedipaterno Nord/Innesto Ss209 Valnerina"},
	{"8286","Piedipaterno Sul Nera/Innesto Ss395 Passo Di Cerro"},
	{"8287","Piediripa"},
	{"8288","Piemonte"},
	{"8289","Pienza"},
	{"8290","Pieria"},
	{"8291","Pieris"},
	{"8292","Pietole"},
	{"8293","Pietra Ligure"},
	{"8294","Pietrabissarra"},
	{"8295","Pietracatella"},
	{"8296","Pietragalla"},
	{"8297","Pietragoliti"},
	{"8298","Pietraia"},
	{"8299","Pietramala"},
	{"8300","Pietramurata"},
	{"8301","Pietraperzia"},
	{"8302","Pietraporzio"},
	{"8303","Pietrasanta/Innesto Ss1 Aurelia"},
	{"8304","Pietrasanta/Innesto Ss439 Sarzanese Valdera"},
	{"8305","Pietrastornina"},
	{"8306","Pievaiola"},
	{"8307","Pieve A Nievole/Innesto Ss435 Lucchese"},
	{"8308","Pieve A Nievole/Innesto Ss436 Francesca"},
	{"8309","Pieve Al Toppo"},
	{"8310","Pieve Al Toppo/Innesto Ss327 Di Foiano"},
	{"8311","Pieve Al Toppo/Innesto Ss73 Senese Aretina"},
	{"8312","Pieve Del Cairo"},
	{"8313","Pieve Di Cadore"},
	{"8314","Pieve Di Ledro"},
	{"8315","Pieve Di Livinallongo"},
	{"8316","Pieve Di Teco"},
	{"8317","Pieve Di Teco/Innesto Ss453 Della Valle Arroscia"},
	{"8318","Pieve Fosciana"},
	{"8319","Pieve Ligure"},
	{"8320","Pieve Porto Morone"},
	{"8321","Pieve S.Stefano Sud"},
	{"8322","Pieve S.Stefano/Innesto Ss208 Strada Della Verna"},
	{"8323","Pieve S.Stefano/Innesto Ss3 Bis Tiberina"},
	{"8324","Pieve Torina"},
	{"8325","Pievepelago/Innesto Ss324 Passo Delle Radici"},
	{"8326","Pievepelago/Innesto Ss12 Dell'abetone E Del Brennero"},
	{"8327","Pievetta"},
	{"8328","Pievina"},
	{"8329","Pignataro Interamna"},
	{"8330","Pila"},
	{"8331","Pilastri"},
	{"8332","Pilastro"},
	{"8333","Pilzone"},
	{"8334","Pimonte"},
	{"8335","Pinarella/Innesto Ss16 Adriatica"},
	{"8336","Pinarella/Innesto Ss71 Bis Umbro Casent. Rom."},
	{"8337","Pinasca"},
	{"8338",""},
	{"8339","Pinerolo Est"},
	{"8340","Pinerolo S./Innesto Ss589 Dei Laghi Di Avigliana"},
	{"8341","Pinerolo Sud/Innesto Ss23 Del Colle Del Sestriere"},
	{"8342","Pinerolo Variante"},
	{"8343","Pineto"},
	{"8344","Pino Sul Lago Maggiore"},
	{"8345","Pinocchio/Innesto Ss16 Adriatica"},
	{"8346","Pinocchio/Innesto Ss16 Dir/B Del Porto Di Ancona"},
	{"8347","Pinzolo"},
	{"8348","Piobbico"},
	{"8349","Piode"},
	{"8350","Piombino D'ese"},
	{"8351","Pioppi"},
	{"8352","Pioppo"},
	{"8353","Pioraco"},
	{"8354","Piossasco"},
	{"8355","Piove Di Sacco"},
	{"8356","Piovene R."},
	{"8357","Piovene Rocchette"},
	{"8358","Piovene Rocchette/Innesto Ss349"},
	{"8359","Piovene Rocchette/Innesto Ss350"},
	{"8360","Piovese"},
	{"8361","Pirazzolu"},
	{"8362","Pirivoglia"},
	{"8363","Pirri"},
	{"8364","Pisa"},
	{"8365","Pisa (san Giusto)/Innesto Ss67 Tosco-Romagnola"},
	{"8366","Pisa Aeroporto-Ss 1 Aurelia"},
	{"8367","Pisa C. A12 Ge-Ros.- Allacciamento S.G.C. Fi-Pi-Li"},
	{"8368","Pisa Centro"},
	{"8369","Pisa Centro - A12 Genova-Rosignano"},
	{"8370","Pisa/Innesto S.G.C. Firenze-Pisa-Livorno"},
	{"8371","Pisa/Innesto Ss1 Aurelia"},
	{"8372","Pisa/Innesto Ss1 Aurelia E S.G.C. Fi-Pi-Li"},
	{"8373","Pisa/Innesto Ss12 Dell'abetone E Del Brennero"},
	{"8374","Pisa/Innesto Ss206 Pisana-Livornese"},
	{"8375","Pisa/Innesto Ss224 Di Marina Di Pisa"},
	{"8376","Pisana"},
	{"8377","Pisana-Livornese"},
	{"8378","Piscetto"},
	{"8379","Pisciotta"},
	{"8380","Pisogne"},
	{"8381","Pisticci Staz./Innesto Ss407 Basentana"},
	{"8382","Pistoia"},
	{"8383","Pistoia/Innesto Ss435 Lucchese"},
	{"8384","Pistoia/Innesto Ss66 Pistoiese"},
	{"8385","Pistoiese"},
	{"8386","Piticchio"},
	{"8387","Pitigliano"},
	{"8388","Pizzo"},
	{"8389","Pizzo Calabro"},
	{"8390","Pizzo Calabro/Svincolo Per A3 Salerno-Reggio C."},
	{"8391","Pizzo Est"},
	{"8392","Pizzo Guerrino"},
	{"8393","Pizzoletta"},
	{"8394","Pizzoli"},
	{"8395","Plaesano"},
	{"8396","Plan De Gralba/Innesto Ss242 Di Val Gardena"},
	{"8397","Plan De Gralba/Innesto Ss243 Del Passo Gardena"},
	{"8398",""},
	{"8399",""},
	{"8400","Plati'"},
	{"8401","Plessiva/Confine Con La Slovenia"},
	{"8402","Ploaghe/Innesto Ss597 Di Logudoro"},
	{"8403","Ploaghe/Innesto Ss672 Sassari-Tempio"},
	{"8404","Plose"},
	{"8405","Po"},
	{"8406","Pocaia"},
	{"8407","Pocol/Innesto Ss48 Delle Dolomiti"},
	{"8408","Pocol/Innesto Ss638 Del Passo Di Giau"},
	{"8409","Podenzano"},
	{"8410","Podere Bambolo/Innesto Ss1 Aurelia"},
	{"8411","Poggiardo"},
	{"8412","Poggibonsi (Direzione Firenze)"},
	{"8413","Poggibonsi (Direzione Siena)"},
	{"8414","Poggibonsi/Innesto Ss2 Cassia"},
	{"8415","Poggibonsi/Innesto Ss429 Di Val D'elsa"},
	{"8416","Poggio"},
	{"8417","Poggio A Caiano"},
	{"8418","Poggio Cancelli"},
	{"8419","Poggio Di Biagio/Innesto Ss71 Umbro Cas. Romag."},
	{"8420","Poggio Di Biagio/Innesto Ss74 Maremmana"},
	{"8421","Poggio Di Roio"},
	{"8422","Poggio Di Roio/Innesto Ss615 Di Monte Luco"},
	{"8423","Poggio Di Roio/Innesto Ss615 Diramazione Di M.Te Luco"},
	{"8424","Poggio Imperiale"},
	{"8425","Poggio Marano"},
	{"8426","Poggio Moiano"},
	{"8427","Poggio Picenze"},
	{"8428","Poggio Rusco/Innesto Ss12 Dell'abetone E Del Brenn."},
	{"8429","Poggio Rusco/Innesto Ss496 Virgiliana"},
	{"8430","Poggio Torrone"},
	{"8431","Poggioferro"},
	{"8432","Pogli"},
	{"8433","Pogliola"},
	{"8434","Pognana Lario"},
	{"8435","Poirino"},
	{"8436","Poirino/Innesto Ss29 Del Colle Di Cadibona"},
	{"8437","Poirino/Innesto Ss29 Racc Del Colle Di Cadibona"},
	{"8438","Polcanto"},
	{"8439","Polesella"},
	{"8440","Policastro Bussentino/Innesto Ss18 Tirrena Inferiore"},
	{"8441","Policastro Bussentino/Innesto Ss562"},
	{"8442","Policoro"},
	{"8443","Polistena"},
	{"8444","Polizzi Generosa"},
	{"8445","Polla"},
	{"8446","Polla/Innesto Ss19 Delle Calabrie"},
	{"8447","Polla/Innesto Ss19 Ter Dorsale Aulettese"},
	{"8448","Polonghera"},
	{"8449","Pomarance"},
	{"8450","Pomigliano D'arco"},
	{"8451","Pomigliano D'arco/Svincolo Per A16 Napoli-Canosa"},
	{"8452","Pompei"},
	{"8453","Pompei/Innesto Ss145 Diramazione Sorrentina"},
	{"8454","Pompei/Innesto Ss145 Sorrentina"},
	{"8455","Pompiano"},
	{"8456","Pomposa"},
	{"8457","Pongelli"},
	{"8458","Ponsacco"},
	{"8459","Pont Canavese"},
	{"8460","Pont Saint Martin"},
	{"8461","Pont St. Martin"},
	{"8462","Pont St. Martin/Innesto Strada Reg. 44"},
	{"8463","Pontagna"},
	{"8464","Pontassieve"},
	{"8465","Pontassieve/Innesto Ss67 Tosco Romagnola"},
	{"8466","Pontassieve/Innesto Ss69 Di Val D'arno"},
	{"8467","Pontassieve/Innesto Ss70 Della Consuma"},
	{"8468","Ponte 13 Archi/Innesto Ss17 Dell'app. Abruzzese"},
	{"8469","Ponte 13 Archi/Innesto Ss645 Fondo Valle Del Tappino"},
	{"8470","Ponte 25 Archi"},
	{"8471","Ponte 5 Archi"},
	{"8472","Ponte A Egola"},
	{"8473","Ponte A Egola/Innesto S.G.C. Fi-Pi-Li"},
	{"8474","Ponte A Elsa"},
	{"8475","Ponte A Elsa/Innesto Ss429 Di Val D'elsa"},
	{"8476","Ponte A Elsa/Innesto Ss67 Tosco Romagnola"},
	{"8477","Ponte A Moriano"},
	{"8478","Ponte A Rigo"},
	{"8479","Ponte A Signa"},
	{"8480","Ponte A Tre Luci"},
	{"8481","Ponte A Tressa"},
	{"8482","Ponte Alla Chiassa"},
	{"8483","Ponte Alla Pergola"},
	{"8484","Ponte All'abate"},
	{"8485","Ponte Alto"},
	{"8486","Ponte Arche/Innesto Ss237 Del Caffaro"},
	{"8487","Ponte Arche/Innesto Ss421"},
	{"8488","Ponte Balletto"},
	{"8489","Ponte Besaro/Incrocio Ss191 Di Pietraperzia"},
	{"8490","Ponte Besaro/Innesto Ss626 Della Valle Del Salso"},
	{"8491","Ponte Biddusa"},
	{"8492","Ponte Biferchia"},
	{"8493","Ponte Buffa"},
	{"8494","Ponte Buida/Innesto Ss314 Licinese"},
	{"8495","Ponte Buida/Innesto Ss4 Salaria"},
	{"8496","Ponte Caffaro/Innesto Ss237 Del Caffaro"},
	{"8497","Ponte Calcara"},
	{"8498","Ponte Caliano"},
	{"8499","Ponte Camedda"},
	{"8500","Ponte Campomizzo"},
	{"8501","Ponte Candina"},
	{"8502","Ponte Capodarso"},
	{"8503","Ponte Capodarso/Innesto Ss122 Agrigentina"},
	{"8504","Ponte Capodarso/Innesto Ss560 Di Marcatobianco"},
	{"8505","Ponte Carrodano/Innesto Ss566 Diramazione Di Val Di Vara"},
	{"8506","Ponte Castrocucco/Innesto Ss18 Tirrena Inferiore"},
	{"8507","Ponte Cerasaro"},
	{"8508","Ponte Chiasso/Confine Con La Svizzera"},
	{"8509","Ponte Cracaxia"},
	{"8510","Ponte D.Delizia/Innesto Ss13 Pontebbana"},
	{"8511","Ponte D.Delizia/Innesto Ss463 Del Tagliamento"},
	{"8512","Ponte D.Muda"},
	{"8513","Ponte D'arbia"},
	{"8514","Ponte D'arcera"},
	{"8515","Ponte D'assi"},
	{"8516","Ponte Del Giulio"},
	{"8517","Ponte Del Rio"},
	{"8518","Ponte Della Palomba/Innesto Ss271 Di Cassano"},
	{"8519","Ponte Della Palomba/Innesto Ss7 Appia"},
	{"8520","Ponte Della Pietra"},
	{"8521","Ponte Della Venturina/Innesto Ss632 Pracchia"},
	{"8522","Ponte Delle Alpi Est"},
	{"8523","Ponte Dell'olio"},
	{"8524","Ponte Di Aletzia"},
	{"8525","Ponte Di Barbarano"},
	{"8526","Ponte Di Bella/Innesto Ss7 Appia"},
	{"8527","Ponte Di Bella/Innesto Ss94 Dir"},
	{"8528","Ponte Di Bovino"},
	{"8529","Ponte Di Caitta"},
	{"8530","Ponte Di Campia"},
	{"8531","Ponte Di Castegnero"},
	{"8532","Ponte Di Chiatte Sul Fiume Po"},
	{"8533","Ponte Di Falmenta"},
	{"8534","Ponte Di Ferro"},
	{"8535","Ponte Di Finita"},
	{"8536","Ponte Di Legno"},
	{"8537","Ponte Di Legno/Innesto Ss300 Passo Di Gavia"},
	{"8538","Ponte Di Legno/Innesto Ss42"},
	{"8539","Ponte Di Masone/Innesto Ss33 Del Sempione"},
	{"8540","Ponte Di Masone/Innesto Ss549 Di Macugnaga"},
	{"8541","Ponte Di Mezzavia/Innesto Ss16 Adriatica"},
	{"8542","Ponte Di Nanto"},
	{"8543","Ponte Di Nori"},
	{"8544","Ponte Di Peschio/Innesto Ss17 Dell'app. Abruzzese"},
	{"8545","Ponte Di Peschio/Innesto Ss584 Di Lucoli"},
	{"8546","Ponte Di Piave"},
	{"8547","Ponte Di Pietra Lunga"},
	{"8548","Ponte Di Valenza"},
	{"8549","Ponte Dolo"},
	{"8550","Ponte D'oltra/Innesto Ss473 Di Croce D'aune"},
	{"8551","Ponte D'oltra/Innesto Ss50 D. Grappa E Passo Rolle"},
	{"8552","Ponte Erro"},
	{"8553","Ponte Fazio/Incrocio Ss640 Di Porto Empedocle"},
	{"8554","Ponte Fazio/Innesto Ss122 Agrigentina"},
	{"8555","Ponte Felcino"},
	{"8556","Ponte Felice/Innesto Ss3 Flaminia"},
	{"8557","Ponte Felice/Innesto Ss657 Sabina"},
	{"8558","Ponte Foro/Innesto Ss263 Val Di Foro E Bocca Di Valle"},
	{"8559","Ponte Gardena"},
	{"8560","Ponte Gardena/Innesto Ss12"},
	{"8561","Ponte Gornalunga"},
	{"8562","Ponte Guspene"},
	{"8563","Ponte Impiso"},
	{"8564","Ponte In Nava"},
	{"8565","Ponte Judrio/Innesto Ss56 Di Gorizia"},
	{"8566","Ponte Locatello"},
	{"8567","Ponte Lovatto-Lignano"},
	{"8568","Ponte Maccarone/Innesto Ss121 Catanese"},
	{"8569","Ponte Maccarone/Innesto Ss575 Di Troina"},
	{"8570","Ponte Macchia"},
	{"8571","Ponte Macereto"},
	{"8572","Ponte Maglio"},
	{"8573","Ponte Maria Cristina"},
	{"8574","Ponte Marreri"},
	{"8575","Ponte Maruzzo/Innesto Ss156 Dei Monti Lepini"},
	{"8576","Ponte Maruzzo/Innesto Ss609 Carpinetana"},
	{"8577","Ponte Messa"},
	{"8578","Ponte Mezzavia/Innesto Ss250 Terme Euganee"},
	{"8579","Ponte Molinu"},
	{"8580","Ponte Mostizzolo/Innesto Ss42 Del Tonale"},
	{"8581","Ponte Mostizzolo/Innesto Ss43 Della Val Di Non"},
	{"8582","Ponte Murello"},
	{"8583","Ponte Nelle Alpi"},
	{"8584","Ponte Nelle Alpi/Innesto Ss51 Di Alemagna"},
	{"8585","Ponte Nelle Alpi/Innesto Ss50 Grappa E Passo Rolle"},
	{"8586","Ponte Neto/Innesto Ss107 Silana Crotonese"},
	{"8587","Ponte Nizza"},
	{"8588","Ponte Nova"},
	{"8589","Ponte Nova/Innesto Ss241 Di Val D'ega"},
	{"8590","Ponte Nova/Innesto Ss620 Del Passo Di Lavaze'"},
	{"8591","Ponte Nuovo"},
	{"8592","Ponte Nuovo Di Magenta"},
	{"8593","Ponte Nuovo/Innesto Ss158 Della V. Del Volturno"},
	{"8594","Ponte Nuovo/Innesto Ss627 Della Vandra"},
	{"8595","Ponte Ofanto"},
	{"8596","Ponte Ofanto/Innesto Ss159 Delle Saline"},
	{"8597","Ponte Ofanto/Innesto Ss16 Adriatica"},
	{"8598","Ponte Ofanto/Innesto Ss544 Di Trinitapoli"},
	{"8599","Ponte Ofanto/Innesto Asse Attr. Cerignola-Bari"},
	{"8600","Ponte Oglio"},
	{"8601","Ponte Olivo/Innesto Ss117 Bis Centrale Sicula"},
	{"8602","Ponte Olivo/Innesto Ss190 Delle Solfare"},
	{"8603","Ponte Orcia/Innesto Ss2 Cassia"},
	{"8604","Ponte Orcia/Innesto Ss323 Di Monte Amiata"},
	{"8605","Ponte Paestum"},
	{"8606","Ponte Parrozzo/Innesto S.G.C. P.Parrozzo-Leonessa"},
	{"8607",""},
	{"8608","Ponte Piscina Nuxedda"},
	{"8609","Ponte Po"},
	{"8610","Ponte Priula"},
	{"8611","Ponte Priula/Innesto Ss13 Pontebbana"},
	{"8612","Ponte Recchio/Innesto Ss357 Di Fornovo"},
	{"8613","Ponte Recchio/Innesto Ss9 Emilia"},
	{"8614","Ponte Ribellasca/Confine Con La Svizzera"},
	{"8615","Ponte Rio"},
	{"8616","Ponte Rio Di Todi/Innesto Ss79 Bis Orvietana/Ss448"},
	{"8617","Ponte Rio/Innesto Ss3 Bis E Ss448 Di Baschi"},
	{"8618","Ponte Rio/Innesto Ss3 Bis E Ss79 Bis Orvietana"},
	{"8619","Ponte Ritorto"},
	{"8620","Ponte Ronca"},
	{"8621","Ponte S. Giovanni/Innesto Ss3 Flaminia"},
	{"8622","Ponte S. Giovanni/Innesto Ss76 Var Della Val D'esino"},
	{"8623","Ponte S.Giovanni/Innesto Ss3 Bis Tiberina"},
	{"8624","Ponte S.Giulia"},
	{"8625","Ponte S.Lorenzo"},
	{"8626","Ponte S.Ludovico/Confine Con La Francia"},
	{"8627","Ponte S.Luigi/Allacciamento A10 Genova-Ventimiglia"},
	{"8628","Ponte S.Marco"},
	{"8629","Ponte S.Nicolo'"},
	{"8630","Ponte S.Paolo"},
	{"8631","Ponte S.Pietro"},
	{"8632","Ponte S.Quirino"},
	{"8633","Ponte S.Venere"},
	{"8634","Ponte S.Vetturino/Innesto Ss147 Di Assisi"},
	{"8635","Ponte S.Vetturino/Innesto Ss147 Dir"},
	{"8636","Ponte Salvatore Troga"},
	{"8637","Ponte San Giovanni/Innesto Raccordo Bettolle-Perugia"},
	{"8638","Ponte San Giovanni/Svincolo Ss75 Bis Del Trasimeno"},
	{"8639","Ponte Sanguinaro/Innesto Ss3 Flaminia"},
	{"8640","Ponte Sanguinaro/Innesto Ss3 Ter"},
	{"8641","Ponte Scandarello/Innesto Ss260 Picente"},
	{"8642","Ponte Scandarello/Innesto Ss4 Salaria"},
	{"8643","Ponte Su Grancifone/Innesto Ss115 Sud Occ. Sicula"},
	{"8644","Ponte Sul Brenta/Innesto Ss515 Noalese"},
	{"8645","Ponte Sul Calore/Innesto Ss7 Appia"},
	{"8646","Ponte Sul Castrocucco/Innesto Ss585"},
	{"8647","Ponte Sul Fiume Brenta/Innesto Ss11 Padana Superiore"},
	{"8648","Ponte Sul Fiume Calore/Innesto Ss90 Delle Puglie"},
	{"8649","Ponte Sul Fiume Garigliano - Innesto Ss7 Via Appia"},
	{"8650","Ponte Sul Fiume Garigliano/Innesto Ss7 Via Appia"},
	{"8651","Ponte Sul Fiume Grancifone/Innesto Ss576 Furore"},
	{"8652","Ponte Sul Fiume Liscia/Innesto Ss133 Bis Di Palau"},
	{"8653","Ponte Sul Fiume Liscia/Innesto Ss133 Di Palau"},
	{"8654","Ponte Sul Fiume Mingardo/Innesto Ss562"},
	{"8655","Ponte Sul Fiume Mingardo/Innesto Ss562 Dir"},
	{"8656","Ponte Sul Fiume Neto/Innesto Ss107bis"},
	{"8657","Ponte Sul Fiume Ofanto/Innesto Ss16 Adriatica"},
	{"8658","Ponte Sul Fiume Reno"},
	{"8659","Ponte Sul Fiume Sele/Innesto Ss165 Di Mater Domini"},
	{"8660","Ponte Sul Fiume Sele/Innesto Ss91 Valle Del Sele"},
	{"8661","Ponte Sul Garigliano/Innesto Ss7 Quater Domiziana"},
	{"8662","Ponte Sul Garigliano/Innesto Ss7/Innesto Ss7 Quater"},
	{"8663","Ponte Sul Magra/Innesto Ss1 Aurelia"},
	{"8664","Ponte Sul Magra/Innesto Ss331 Di Lerici"},
	{"8665","Ponte Tappino"},
	{"8666","Ponte Taro"},
	{"8667","Ponte Tavole/Innesto Ss117 Bis Cent. Sicula"},
	{"8668","Ponte Tavole/Innesto Ss417 Di Caltagirone"},
	{"8669","Ponte Tittiri/Innesto Ss128 Centrale Sarda"},
	{"8670","Ponte Tittiri/Innesto Ss388 Tirso E Mandrolisai"},
	{"8671","Ponte Tommaso"},
	{"8672","Ponte Tona"},
	{"8673","Ponte Torto/Innesto Ss626 Della Valle Del Salso"},
	{"8674","Ponte Tresa/Confine Con La Svizzera"},
	{"8675","Ponte Valdinte"},
	{"8676","Ponte Valleceppi/Innesto Sgc Orte Ra E Ss3 Bis"},
	{"8677","Ponte Valleceppi/Innesto Ss318 Di Valfabbrica"},
	{"8678","Ponte Ventoso/Innesto Ss24 Del Monginevro"},
	{"8679","Ponte Ventoso/Innesto Ss335 Diramazione Di Bardonecchia"},
	{"8680","Ponte Venturina/Innesto Ss64 Porrettana"},
	{"8681","Ponte Verdura/Innesto Ss115 Sud Occ.Le Sicula"},
	{"8682","Ponte Verdura/Innesto Ss386 Di Ribera"},
	{"8683","Ponte Vonchia"},
	{"8684","Ponte Zittola/Innesto Ss17 Dell'app. Abruzzese"},
	{"8685","Ponte Zittola/Innesto Ss83 Marsicana"},
	{"8686","Pontebba"},
	{"8687","Pontebbana"},
	{"8688","Pontecaffaro/Innesto Ss669 Del P.Crocedomini"},
	{"8689","Pontecagnano"},
	{"8690","Ponteceno"},
	{"8691","Ponteceno Di Sopra"},
	{"8692","Pontechiusita"},
	{"8693","Pontecorvo"},
	{"8694","Pontecurone"},
	{"8695","Pontedassio"},
	{"8696","Pontedazzo"},
	{"8697","Pontedera/Innesto Ss439 Sarzanese Valdera"},
	{"8698","Pontedera/Innesto Ss67 Tosco Romagnola"},
	{"8699","Ponteggia"},
	{"8700","Ponteginori"},
	{"8701","Pontegrande"},
	{"8702","Pontelagoscuro"},
	{"8703","Pontelandolfo"},
	{"8704","Pontelandolfo/Innesto 87 Sannitica"},
	{"8705","Pontelandolfo/Innesto Ss88 Dei Due Principati"},
	{"8706","Pontelatrave"},
	{"8707","Pontelongo"},
	{"8708","Pontenure"},
	{"8709","Pontepetri"},
	{"8710","Pontepetri/Innesto Ss632 Traversa Di Pracchia"},
	{"8711","Pontepetri/Innesto Ss66 Pistoiese"},
	{"8712","Pontericcioli/Innesto Ss3 Flaminia"},
	{"8713","Pontericcioli/Innesto Ss452 Della Contessa"},
	{"8714","Ponteromito/Incrocio Ss7 Appia"},
	{"8715","Ponteromito/Innesto Ss164 Delle Croci Di Acerno"},
	{"8716","Ponterotto"},
	{"8717","Pontetidone Di Sarmato"},
	{"8718","Pontevico"},
	{"8719","Pontevico Robecco"},
	{"8720","Ponti"},
	{"8721","Ponticino"},
	{"8722","Pontida"},
	{"8723","Pontina"},
	{"8724","Pontinvrea"},
	{"8725","Pontoglio"},
	{"8726","Pontremoli"},
	{"8727","Ponzano Romano-Soratte"},
	{"8728","Popiglio"},
	{"8729","Popolano"},
	{"8730","Popoli/Innesto Ss17 App.Abruz. E Appulo Sann."},
	{"8731","Popoli/Innesto Ss5 Via Tiburtina Valeria"},
	{"8732","Porcella/Innesto Ss11 Padana Superiore"},
	{"8733","Porcella/Innesto Ss12 Dell'abetone E Del Brennero"},
	{"8734","Porcia"},
	{"8735","Porcia Nord"},
	{"8736","Porcinari/Innesto Ss577 Del Lago Di Campotosto"},
	{"8737","Porcinari/Innesto Ss80 Del G. Sasso D'italia"},
	{"8738","Pordenone"},
	{"8739","Pordenone A28"},
	{"8740","Pordenone Centro Comm.Le"},
	{"8741","Pordenone Sud"},
	{"8742","Pordenone/Incrocio Ss13 Pontebbana"},
	{"8743","Pordenone/Innesto Ss251val Di Zoldo E Val Cellina"},
	{"8744","Porlezza"},
	{"8745","Pornassio"},
	{"8746","Porotto/Innesto Ss255 Di S.Matteo Decima"},
	{"8747","Porotto/Innesto Ss496 Virgiliana"},
	{"8748","Porre"},
	{"8749","Porretta Terme"},
	{"8750","Porrettana"},
	{"8751","Porrino"},
	{"8752","Porta Genova/Allacciamento Tangenziale Ovest Di Milano"},
	{"8753","Porta S.Marco - Ss73 Senese Aretina"},
	{"8754","Porta Vigentina/Svincolo Tangenziale Ovest Di Milano"},
	{"8755","Portale Di R.Calabria Centro"},
	{"8756","Porte"},
	{"8757","Portella Della Paglia"},
	{"8758","Portella Di Montenero"},
	{"8759","Portella Madonnuzza/Innesto Ss290 Di Alimena"},
	{"8760","Portella Misilbesi/Innesto Ss188 Centro Occ. Sicula"},
	{"8761","Portella Misilmeri/Innesto Ss624 Pa-Sciacca"},
	{"8762","Portelle"},
	{"8763","Portichetto Di Luisago"},
	{"8764","Portici"},
	{"8765","Portici-Bellavista"},
	{"8766","Portico Di Romagna"},
	{"8767","Porto Badisco"},
	{"8768","Porto Ceresio"},
	{"8769","Porto Ceresio/Confine Con La Svizzera"},
	{"8770","Porto Cesareo"},
	{"8771","Porto Civitanova"},
	{"8772","Porto Civitanova/Innesto Raccordo Di P.To Civitanova"},
	{"8773","Porto Civitanova/Innesto Ss16 Adriatica"},
	{"8774","Porto Civitanova-Ss16 Adriatica"},
	{"8775","Porto Conte"},
	{"8776","Porto D'ascoli"},
	{"8777","Porto D'ascoli- Innesto Ss16 Adriatica"},
	{"8778","Porto D'ascoli/Innesto Ex Ss4 Salaria"},
	{"8779","Porto Di Arbatax"},
	{"8780","Porto Di Brenzone"},
	{"8781","Porto Di Civitavecchia"},
	{"8782","Porto Di Crotone"},
	{"8783","Porto Di Messina"},
	{"8784","Porto Di Mezzo"},
	{"8785","Porto Di Palinuro"},
	{"8786","Porto Di Pescara/Innesto Ss16"},
	{"8787","Porto Di Reggio Calabria"},
	{"8788","Porto Di Taranto"},
	{"8789","Porto Di Vieste"},
	{"8790","Porto Empedocle"},
	{"8791","Porto Empedocle/Innesto Ss115 Sud Occ.Le Sicula"},
	{"8792","Porto Empedocle/Innesto Ss115ter Sud Occ. Sicula"},
	{"8793","Porto Empedocle/Innesto Ss640 Di P.To Empedocle"},
	{"8794","Porto Garibaldi"},
	{"8795","Porto Garibaldi/Allacciamento Raccordo Fe-P.To Garibaldi"},
	{"8796","Porto Mantovano"},
	{"8797","Porto Potenza Picena"},
	{"8798","Porto Pozzo"},
	{"8799","Porto Recanati"},
	{"8800","Porto S.Elpidio"},
	{"8801","Porto S.Giorgio"},
	{"8802","Porto S.Giorgio/Innesto Ss16 Adriatica"},
	{"8803","Porto S.Giorgio/Innesto Ss210 Fermana Faleriense"},
	{"8804","Porto S.Paolo"},
	{"8805","Porto S.Stefano"},
	{"8806","Porto Salvo"},
	{"8807","Porto Torres"},
	{"8808","Portofino"},
	{"8809","Portogruaro"},
	{"8810","Portogruaro/Innesto Ss14 Della Venezia Giulia"},
	{"8811","Portogruaro/Innesto Ss463 Del Tagliamento"},
	{"8812","Portogruaro/Innesto Ss53 Postumia"},
	{"8813","Portogruaro/Innesto Ss251 Val Zoldo E V. Cellina"},
	{"8814","Portogruaro-Pordenone"},
	{"8815","Portomaggiore"},
	{"8816","Portonaccio - Galla Placidia"},
	{"8817","Portovenere"},
	{"8818","Posada"},
	{"8819","Posada N Ss125/131dir-C"},
	{"8820","Posada/Innesto Ss131 Dir/Centr. Nuorese"},
	{"8821","Positano"},
	{"8822","Posta Di Gaudiano/Innesto Ss529 Dell'ofanto"},
	{"8823","Posta Di Gaudiano/Innesto Ss93 Appulo Lucana"},
	{"8824","Posta/Innesto Ss4 Via Salaria"},
	{"8825","Posta/Innesto Ss471 Di Leonessa"},
	{"8826","Postal"},
	{"8827","Postioma"},
	{"8828","Postumia"},
	{"8829","Postumia Nord"},
	{"8830","Potenza"},
	{"8831","Potenza - Raccordo Sicignano-Potenza"},
	{"8832","Potenza A30"},
	{"8833","Potenza Est"},
	{"8834","Potenza Est - Ss7 Appia"},
	{"8835","Potenza Est/Innesto Tangenziale Potenza"},
	{"8836","Potenza Nord/Innesto Ss7 Appia"},
	{"8837","Potenza Nord/Innesto Ss93 Appulo Lucana"},
	{"8838","Potenza Sud"},
	{"8839","Potenza/Innesto Raccordo Sicignano Pz/Innesto Ss94"},
	{"8840","Pourrieres"},
	{"8841","Povegliano"},
	{"8842","Poviglio"},
	{"8843","Povolaro"},
	{"8844","Pozza Di Fassa"},
	{"8845","Pozza/Innesto Ss12 E Ss467 Di Scandiano"},
	{"8846","Pozza/Innesto Ss12 E Ss569 Di Vignola"},
	{"8847","Pozza/Innesto Ss569 Di Vignola/Ss467 Di Scandiano"},
	{"8848","Pozzallo/Innesto Sp66"},
	{"8849","Pozzo"},
	{"8850","Pozzo S. Evasio"},
	{"8851","Pozzolo Formigaro"},
	{"8852","Pozzolo Formigaro/Innesto Ss211 Lomellina"},
	{"8853","Pozzolo Formigaro/Innesto Ss35 Bis Dei Giovi"},
	{"8854","Pozzomaggiore"},
	{"8855","Pozzo-S.G.Lupatoto"},
	{"8856","Pozzuoli - Innesto Tangenziale Di Napoli"},
	{"8857","Pozzuoli/Innesto Tangenziale Di Napoli"},
	{"8858",""},
	{"8859","Pozzuoli-Via Campana"},
	{"8860","Pozzuolo"},
	{"8861","Pozzuolo Del Friuli"},
	{"8862","Pra' Di Levada"},
	{"8863","Pracchia"},
	{"8864","Pradielis"},
	{"8865","Pradipozzo"},
	{"8866","Pragelato"},
	{"8867","Praiano"},
	{"8868","Prata Camportaccio"},
	{"8869","Prata Sannita"},
	{"8870","Prataccio"},
	{"8871","Pratantico"},
	{"8872","Pratella"},
	{"8873","Prati Di Mezzanego"},
	{"8874","Prati Di Vizze"},
	{"8875","Prato"},
	{"8876","Prato Alla Drava/Confine Con L'austria"},
	{"8877","Prato Allo Stelvo"},
	{"8878","Prato Carnico"},
	{"8879","Prato Est"},
	{"8880","Prato Isarco"},
	{"8881","Prato Ovest"},
	{"8882","Prato Sardo/Innesto Ss131Diramazione Centrale"},
	{"8883","Pratola Peligna"},
	{"8884","Pratola Peligna/Innesto Ss17 Dell'app. Abruzzese"},
	{"8885","Pratola Peligna/Innesto Ss5 Diramazione Tiburtina Valeria"},
	{"8886","Pratola Serra"},
	{"8887","Pratola Serra/Innesto Ss371 Valle Del Sabato"},
	{"8888","Pratola Serra/Innesto Ss7 Appia"},
	{"8889","Pratolino"},
	{"8890","Pratora"},
	{"8891","Pratovecchio"},
	{"8892","Prazzo"},
	{"8893","Pre' St Didier"},
	{"8894","Pre' St Didier/Innesto Ss26 Della Valle D'aosta"},
	{"8895","Pre' St Didier/Innesto Ss26 Diramazione Della Valle D'aosta"},
	{"8896","Predappio"},
	{"8897","Predazzo"},
	{"8898","Predazzo/Innesto Ss48 Delle Dolomiti"},
	{"8899","Predazzo/Innesto Ss50 Del Grappa E Passo Rolle"},
	{"8900","Predoi"},
	{"8901","Predore"},
	{"8902","Preganziol"},
	{"8903","Preglia"},
	{"8904","Premilcuore"},
	{"8905","Premosello Chiovenda"},
	{"8906","Prenestina"},
	{"8907","Preseglie"},
	{"8908","Preselle"},
	{"8909","Presenzano"},
	{"8910","Prestieri"},
	{"8911","Pretoro"},
	{"8912","Pretoro/Innesto Ss539 Di Manoppello"},
	{"8913","Preturo"},
	{"8914","Priero"},
	{"8915","Prima Porta"},
	{"8916","Primolano"},
	{"8917","Primolano/Innesto Ss47 Della Valsugana"},
	{"8918","Primolano/Innesto Ss50 Bis Del Grappa E Passo Rolle"},
	{"8919","Primosole/Innesto Ss114 Orientale Sicula"},
	{"8920","Primosole/Innesto Ss194 Ragusana"},
	{"8921","Priola"},
	{"8922","Priolo Gargallo"},
	{"8923","Priuso/Innesto Ss52 Carnica"},
	{"8924","Priuso/Innesto Ss552 Del Passo Rest"},
	{"8925","Prodo"},
	{"8926","Prosto"},
	{"8927","Provaglio D'iseo"},
	{"8928","Prunetta"},
	{"8929","Puglia"},
	{"8930","Pula"},
	{"8931","Pulfero"},
	{"8932","Puliciano"},
	{"8933","Punta Bella/Innesto Ss75 Bis/Racc Del Trasimeno"},
	{"8934","Punta Bella/Innesto Ss75bis Del Trasimeno"},
	{"8935","Punta Penna"},
	{"8936","Punta Raisi/Diramazione Aeroporto Falcone E Borsellino"},
	{"8937","Puntadura"},
	{"8938","Puos D'alpago"},
	{"8939","Purello"},
	{"8940","Pusiano"},
	{"8941","Putignano"},
	{"8942","Putignano/Innesto Ss172 Dei Trulli"},
	{"8943","Putignano/Innesto Ss377 Delle Grotte"},
	{"8944","Quadrelli"},
	{"8945","Quadri"},
	{"8946","Quadrivio D. Misericordia/Innesto Ss290 Di Alimena"},
	{"8947","Quadrivio Della Misericordia/Innesto Ss121"},
	{"8948","Quadrivio Di Guardaregia/Innesto Ss17"},
	{"8949","Quadrivio Di Ischia Porto"},
	{"8950","Quadrivio Di Monteverde"},
	{"8951","Quadrivio Pioppetta/Innesto Ss158"},
	{"8952","Quadrivio Pioppetta/Innesto Ss158 Dir"},
	{"8953","Quadrivio S.Anna/Innesto Ss117 Bis Centrale Sicula"},
	{"8954","Quadrivio Spinasanta/Innesto Ss118 E Ss122"},
	{"8955","Quaglietta"},
	{"8956","Quagliuzzo"},
	{"8957","Quarto D'altino"},
	{"8958","Quartu S.Elena"},
	{"8959","Quater Delle Calabrie"},
	{"8960","Quater Sud Occidentale Sicula"},
	{"8961","Quater Via Domiziana"},
	{"8962","Quater Via Tiburtina Valeria"},
	{"8963","Quater/Diramazione Di Ischitella Lido"},
	{"8964","Quater-Diramazione Del Casello Di Tagliacozzo"},
	{"8965","Quattordio"},
	{"8966","Quattromiglia Di Rende"},
	{"8967","Querce Al Pino/Innesto Ss146 Di Chianciano"},
	{"8968","Querce Al Pino/Innesto Ss478 Di Sarteano"},
	{"8969","Querce D'orlando/Innesto Ss2 Cassia"},
	{"8970","Querceta"},
	{"8971","Querciagrossa"},
	{"8972","Quercianella/Innesto Ss1 Var"},
	{"8973","Quercie D'orlando/Innesto Ss493 Claudia Braccianese"},
	{"8974","Quincinetto"},
	{"8975","Quinto Di Treviso"},
	{"8976","Quirra"},
	{"8977","Quistello"},
	{"8978","Rabla'"},
	{"8979","Rabuiese/Confine Con La Slovenia"},
	{"8980","Racc Del Colle Di Cadibona"},
	{"8981","Racc Del Sempione"},
	{"8982","Racc Della Piccola Sila"},
	{"8983","Racc Della Valle Del Sele"},
	{"8984","Racc Della Venezia Giulia"},
	{"8985","Racc Dell'appennino Abruzzese E Appulo Sannitico"},
	{"8986","Racc Delle Palade"},
	{"8987","Racc Dell'ischia Verde"},
	{"8988","Racc Di Altichiero"},
	{"8989","Racc Di Fiuggi"},
	{"8990","Racc Di Palinuro"},
	{"8991","Racc Di Teramo"},
	{"8992","Racc Di Venosa"},
	{"8993","Racc Fondo Valle Del Noce"},
	{"8994","Racc Jonica"},
	{"8995","Racc Pontebbana"},
	{"8996","Racc Raccordo Tra Ss55 E Ss56"},
	{"8997","Racc Tirrena Inferiore"},
	{"8998","Racc Via Appia"},
	{"8999","Racc Via Flavia"},
	{"9000","Racc Via Olimpia"},
	{"9001","Racc Via Tiburtina-Valeria"},
	{"9002","Raccordo A3 - Ss106 Ter"},
	{"9003","Raccordo Autostradale A4-Trieste"},
	{"9004","Raccordo Gazzada-Varese"},
	{"9005","Raccordo Siracusa-Cassibile (ex A18)"},
	{"9006","Raccordo Vt/Tr"},
	{"9007","Raccordo Ascoli-P.Ascoli"},
	{"9008","Raccordo Civitav.-Tarquinia (rato)"},
	{"9009","Raccordo Falchera-Ss11(diram. Per Mi)"},
	{"9010","Raccordo Vetralla-Viterbo (rato)"},
	{"9011","Raccordo Viterbo-Terni (rato)"},
	{"9012","Racc/A Di Palinuro"},
	{"9013","Racc/Bis Tirrena Inferiore"},
	{"9014","Racc/Ter Tirrena Inferiore"},
	{"9015","Racchiuso"},
	{"9016","Racconigi"},
	{"9017","Raccordo A13-Porto Garibaldi"},
	{"9018","Raccordo A14-Tangenziale Di Bari"},
	{"9019","Raccordo A1-Piazzale Corvetto"},
	{"9020","Raccordo A1-Tangenziale Est Di Milano"},
	{"9021","Raccordo A20-Porto Di Messina"},
	{"9022",""},
	{"9023","Raccordo A27/A4-Aeroporto Tessera"},
	{"9024","Raccordo A4/A5"},
	{"9025","Raccordo Ascoli P.-Porto D'ascoli"},
	{"9026","Raccordo Bereguardo-Pavia"},
	{"9027","Raccordo Bettolle-Perugia"},
	{"9028","Raccordo Chieti-Pescara"},
	{"9029","Raccordo Di Firenze Nord (a11-A1)"},
	{"9030","Raccordo Di Fossano"},
	{"9031","Raccordo Di Pistoia"},
	{"9032","Raccordo Di Porto Civitanova"},
	{"9033","Raccordo Fano-Fossombrone"},
	{"9034","Raccordo Fossano Ovest"},
	{"9035","Raccordo Per A12 Genova Rosignano"},
	{"9036","Raccordo Per Benevento"},
	{"9037","Raccordo Per Il Gran San Bernardo"},
	{"9038","Raccordo Per Livorno"},
	{"9039","Raccordo Pordenone A28-Ss13"},
	{"9040","Raccordo Rieti-Terni (rato)"},
	{"9041","Raccordo Salerno-Avellino"},
	{"9042","Raccordo Sicignano-Potenza"},
	{"9043","Raccordo Siena-Bettolle"},
	{"9044","Raccordo Siena-Firenze"},
	{"9045","Raccordo Ss14-Ss55"},
	{"9046","Raccordo Tangenziale Di Bologna-A13"},
	{"9047","Raccordo Tangenziale Di Palermo-A19"},
	{"9048","Raccordo Taranto-Grottaglie"},
	{"9049","Raccordo Torino-Aeroporto Caselle"},
	{"9050","Raccordo Villesse-Gorizia"},
	{"9051","Radd Dei Trulli"},
	{"9052","Radd Del Friuli"},
	{"9053","Radd Dell'abetone E Del Brennero (diramazione Lucchese)"},
	{"9054","Radd Jonica"},
	{"9055","Radd/Bis Del Brennero"},
	{"9056","Radda In Chianti"},
	{"9057","Raddusa/Agira St."},
	{"9058","Radogna/Innesto Ss91 Ter Diramazione Irpina"},
	{"9059","Radura Di Sotto"},
	{"9060","Raffa"},
	{"9061","Raffadali"},
	{"9062","Raggio"},
	{"9063","Ragusa"},
	{"9064","Ragusa Ibla"},
	{"9065","Ragusa/Innesto Ss115 Sud Occidentale Sicula"},
	{"9066","Ragusa/Innesto Ss514 Di Chiaramonte"},
	{"9067","Ragusana"},
	{"9068","Raiano"},
	{"9069","Raiano/Innesto Ss5 Diramazione Tiburtina Valeria"},
	{"9070","Raiano/Innesto Ss5 Tiburtina Valeria"},
	{"9071","Ramo Casalecchio"},
	{"9072","Ramo Verde Tangenziale Di Bologna"},
	{"9073","Ramuscello"},
	{"9074","Rancio Valcuvia"},
	{"9075","Randazzo"},
	{"9076","Randazzo - Capo D'orlando"},
	{"9077","Randazzo/Innesto Ss116 Randazzo-Capo D'orlando"},
	{"9078","Randazzo/Innesto Ss120 Dell'etna E Delle Madonie"},
	{"9079","Randazzo/Innesto Ss284 Occidentale Etnea"},
	{"9080","Raossi"},
	{"9081","Rapallo"},
	{"9082","Rapallo/Innesto Ss1 Aurelia"},
	{"9083","Rapallo/Innesto Ss227 Di Portofino"},
	{"9084","Rapino"},
	{"9085","Rapolla"},
	{"9086","Rapolla/Innesto Ss303 Del Formicoso"},
	{"9087","Rapolla/Innesto Ss93 Appulo Lucana"},
	{"9088","Rasiglia"},
	{"9089","Rassina"},
	{"9090","Rastignano"},
	{"9091","Rasura"},
	{"9092","Ratece/Confine Con La Slovenia"},
	{"9093","Ravanusa"},
	{"9094","Ravanusa/Innesto Ss557 Di Campobello Di Licata"},
	{"9095","Ravanusa/Innesto Ss644 Di Ravanusa"},
	{"9096","Ravello"},
	{"9097","Ravenna"},
	{"9098","Ravenna Ovest/Innesto Ss16 Adriatica"},
	{"9099","Ravenna Ponte"},
	{"9100","Ravenna/Allacciamento A14 Diramazione Per Ravenna E Innesto Ss16"},
	{"9101","Ravenna/Innesto Sgc Ravenna-M.Saraceno/Innesto Ss71"},
	{"9102","Ravenna/Innesto Ss16 Adriatica"},
	{"9103","Ravenna/Innesto Ss16 E S.G.C. Ra-M. Saraceno"},
	{"9104","Ravenna/Innesto Ss253 S.Vitale"},
	{"9105","Ravenna/Innesto Ss309 Romea"},
	{"9106","Ravenna/Innesto Ss309Diramazione Romea"},
	{"9107","Ravenna/Innesto Ss67 Tosco Romagnola"},
	{"9108","Razzuolo"},
	{"9109","Re"},
	{"9110","Rebbio"},
	{"9111","Recanati"},
	{"9112","Recco"},
	{"9113","Recco/Innesto Ss1 Aurelia"},
	{"9114","Recco/Innesto Ss333 Di Uscio"},
	{"9115","Recoaro Terme"},
	{"9116","Redavalle"},
	{"9117","Redipuglia"},
	{"9118","Redona"},
	{"9119","Regalbuto"},
	{"9120","Regalgioffoli"},
	{"9121","Reggello"},
	{"9122","Reggio Calabria"},
	{"9123","Reggio Calabria/Innesto Ss106 Jonica"},
	{"9124","Reggio Calabria/Innesto Ss18 Tirrena Inferiore"},
	{"9125","Reggio Di Calabria"},
	{"9126","Reggio Emilia"},
	{"9127","Reggio Emilia/Innesto Ss468 Di Correggio"},
	{"9128","Reggio Emilia/Innesto Ss63 Del Valico Del Cerreto"},
	{"9129","Reggio Emilia/Innesto Ss9 Emilia"},
	{"9130","Reggio Nell'emilia"},
	{"9131","Reggio Nell'emilia/Innesto Ss467 Di Scandiano"},
	{"9132","Reggio Nell'emilia/Innesto Ss63 Del. V. Del Cerreto"},
	{"9133","Reggio Nell'emilia/Innesto Ss9 Via Emilia"},
	{"9134","Reggiolo-Rolo"},
	{"9135","Regina"},
	{"9136","Regoledo"},
	{"9137","Reino"},
	{"9138","Reitano"},
	{"9139","Remanzacco"},
	{"9140","Resana"},
	{"9141","Resana/Innesto Ss245 Castellana"},
	{"9142","Resana/Innesto Ss307 Del Santo"},
	{"9143","Rescaldina"},
	{"9144","Resia"},
	{"9145","Ressora"},
	{"9146","Resuttana-Via Belgio"},
	{"9147","Resuttano"},
	{"9148","Revere"},
	{"9149","Revo'"},
	{"9150","Rezzato/Innesto Ss45 Bis Gardesana Occ."},
	{"9151","Rezzoaglio/Innesto Ss586 Della Valle Dell'aveto"},
	{"9152","Rezzoaglio/Innesto Ss654 Di Val Nure"},
	{"9153","Rho"},
	{"9154","Rho Ovest"},
	{"9155","Riace Marina"},
	{"9156","Riale"},
	{"9157","Riano Flaminio"},
	{"9158","Ribera"},
	{"9159","Ribis/Tavagnacco"},
	{"9160","Ricca"},
	{"9161","Riccio"},
	{"9162","Riccione"},
	{"9163","Ricco' Del Golfo Di La Spezia"},
	{"9164","Riccovolto"},
	{"9165","Riesi"},
	{"9166","Riesi/Innesto Ss626 Della Valle Del Salso"},
	{"9167","Rieti"},
	{"9168","Rieti/Innesto Ss4 Salaria"},
	{"9169","Rieti/Innesto Ss578 Salto Cicolana"},
	{"9170","Rieti-Innesto Raccordo Rieti-Terni"},
	{"9171","Rieti-Innesto Ss4 Salaria"},
	{"9172","Rifiano"},
	{"9173","Rifugio Dell'aremogna/Innesto Ss437 Dell'aremogna"},
	{"9174","Rifugio Dell'aremogna/Innesto Ss437 Dir"},
	{"9175","Rifugio Duca Degli Abruzzi"},
	{"9176","Rigali"},
	{"9177","Riglione"},
	{"9178","Rignano Flaminio"},
	{"9179","Rigolato"},
	{"9180","Rigoroso"},
	{"9181","Rigutino"},
	{"9182","Rilievo"},
	{"9183","Rimini"},
	{"9184","Rimini Nord"},
	{"9185","Rimini Sud"},
	{"9186","Rimini/Innesto Ss16 Adriatica"},
	{"9187","Rimini/Innesto Ss258 Marecchia"},
	{"9188","Rimini/Innesto Ss72 Di San Marino"},
	{"9189","Rimini/Innesto Ss9 Emilia"},
	{"9190","Rinovo Nord"},
	{"9191","Rio Colore"},
	{"9192","Rio Dei Cocchi"},
	{"9193","Rio Ghidone"},
	{"9194","Rio Pusteria"},
	{"9195",""},
	{"9196","Riobianco"},
	{"9197","Riola Di Vergato"},
	{"9198","Riola Sardo"},
	{"9199","Riolo Terme"},
	{"9200","Riolunato"},
	{"9201","Rionero In Vulture/Innesto Ss167 Laghi Di Monticchio"},
	{"9202","Rionero Sannitico/Innesto Ss17"},
	{"9203","Rionero Sannitico/Innesto Ss652"},
	{"9204","Rioveggio"},
	{"9205","Riovivo"},
	{"9206","Ripafratta"},
	{"9207","Ripalta Nuova"},
	{"9208","Ripapersico"},
	{"9209","Riva Del Garda/Innesto Ss240 Di Loppio"},
	{"9210","Riva Del Garda/Innesto Ss45 Bis Gardesana Occ."},
	{"9211","Riva Del Garda/Innesto Ss45 Bis Gardesana Occid."},
	{"9212","Riva Del Garda/Innesto Ss421 Laghi Di Molveno E Tenno"},
	{"9213","Riva Di Solto"},
	{"9214","Riva Ligure"},
	{"9215","Riva Trigoso"},
	{"9216","Riva Valdobbia"},
	{"9217","Rivalgo"},
	{"9218","Rivanazzano"},
	{"9219","Rivara"},
	{"9220","Rivarolo Canavese"},
	{"9221","Rivarolo Canavese/Innesto Ss460 Di Ceresole"},
	{"9222","Rivarolo Canavese/Innesto Ss565 Di Castellamonte"},
	{"9223","Rivella/Innesto Ss16 Adriatica"},
	{"9224","Rivella/Innesto Ss16 Dir/A Adriatica"},
	{"9225","Rivello/Bivio Per Ss104 Di Sapri"},
	{"9226","Rivello/Bivio Per Ss585 Fondo Valle Del Noce"},
	{"9227","Riviera"},
	{"9228","Rivis"},
	{"9229","Rivo"},
	{"9230","Rivo/Innesto Raccordo Per Terni"},
	{"9231","Rivolese"},
	{"9232","Rivoli"},
	{"9233","Rivoli Nord"},
	{"9234","Rivoli Sud"},
	{"9235","Rivoli/Innesto Tangenziale Nord Di Torino"},
	{"9236","Rivoli-Rosta"},
	{"9237","Rivoltella"},
	{"9238","Rivolto"},
	{"9239","Rivotorto"},
	{"9240","Robbio"},
	{"9241","Robecco D'oglio"},
	{"9242","Robilante"},
	{"9243","Roca Vecchia"},
	{"9244","Rocca Albegna"},
	{"9245","Rocca D'aspide/Innesto Ss166 Degli Alburni"},
	{"9246","Rocca D'aspide/Innesto Ss488 Di Rocca D'aspide"},
	{"9247","Rocca Di Capri Leone"},
	{"9248","Rocca Di Corno"},
	{"9249","Rocca Di Mezzo"},
	{"9250","Rocca Di Papa"},
	{"9251","Rocca Imperiale Marina"},
	{"9252","Rocca Pia"},
	{"9253","Rocca Pietore/Innesto Ss563 Di Salesei"},
	{"9254","Rocca Pietore/Innesto Ss641 Del Passo Fedaia"},
	{"9255","Rocca Priora/Innesto Ss16 Adriatica"},
	{"9256","Rocca Priora/Innesto Ss76 Della Val D'esino"},
	{"9257","Rocca S.Casciano"},
	{"9258","Roccabascerana"},
	{"9259","Roccabernarda"},
	{"9260","Roccalumera"},
	{"9261","Roccamontepiano"},
	{"9262","Roccapalumba"},
	{"9263","Roccaporena"},
	{"9264","Roccaprebalza"},
	{"9265","Roccaraso"},
	{"9266","Roccaraso/Innesto Ss17 Dell'appennino Abruzzese"},
	{"9267","Roccaraso/Innesto Ss437 Dell'aremogna"},
	{"9268","Roccaraso/Innesto Ss84 Frentana"},
	{"9269","Roccaraso/Innesto Ss17 Dell'app. Abr. E App. Sann."},
	{"9270","Roccasicura"},
	{"9271","Roccastrada"},
	{"9272","Roccavione"},
	{"9273","Roccella Jonica"},
	{"9274","Roccella/Innesto Ss106 Jonica"},
	{"9275","Roccella/Innesto Ss384 Di Girifalco"},
	{"9276","Rocche Di Civitella"},
	{"9277","Rocchetta"},
	{"9278","Rocchetta Belbo"},
	{"9279","Rocchetta/Innesto Ss421 Laghi Di Molveno E Tenno"},
	{"9280","Rocchetta/Innesto Ss43 Della Val Di Non"},
	{"9281","Rochefort"},
	{"9282","Rodi Garganico"},
	{"9283","Roe Alte"},
	{"9284","Rogliano"},
	{"9285","Rogliano/Innesto Ss19 Delle Calabrie"},
	{"9286","Rogliano/Innesto Ss535 Del Savuto"},
	{"9287","Rogliano-Grimaldi"},
	{"9288","Rogno"},
	{"9289","Roma"},
	{"9290","Roma Centro"},
	{"9291","Roma Citta'"},
	{"9292","Roma Eur/V.Le Oceano Pacifico"},
	{"9293","Roma-Civitavecchia"},
	{"9294","Romagnano Sesia"},
	{"9295","Romagnano Sesia/Innesto Ss142 Biellese"},
	{"9296","Romagnano Sesia/Innesto Ss299 Di Alagna"},
	{"9297","Romagnano Sesia-Ghemme"},
	{"9298","Romagnese"},
	{"9299","Romallo"},
	{"9300","Romana"},
	{"9301","Romano D'ezzelino"},
	{"9302","Romano Di Lombardia"},
	{"9303","Romanore"},
	{"9304","Romans D'isonzo"},
	{"9305","Roma-Teramo"},
	{"9306","Romea"},
	{"9307","Romeno"},
	{"9308","Rometta"},
	{"9309","Rometta Marea"},
	{"9310","Romito Magra"},
	{"9311","Romito Magra/Innesto Ss331 Di Lerici"},
	{"9312","Romito Magra/Innesto Ss432 Della Bocca Di Magra"},
	{"9313","Roncadelle"},
	{"9314","Roncaglia"},
	{"9315","Roncanova"},
	{"9316","Ronchi"},
	{"9317","Ronchi Dei Legionari"},
	{"9318","Ronco Scrivia"},
	{"9319","Roncobilaccio"},
	{"9320","Roncolla/Innesto Ss439 Diramazione Sarzanese Valdera"},
	{"9321","Roncolla/Innesto Ss68 Di Val Cecina"},
	{"9322","Roncone"},
	{"9323","Rondelli/Innesto Ss1 Aurelia"},
	{"9324","Rondelli/Innesto Ss439 Sarzanese Valdera"},
	{"9325","Rondissone"},
	{"9326","Ronta"},
	{"9327","Ronzone"},
	{"9328","Ronzone/Innesto Ss42 Del Tonale E Mendola"},
	{"9329","Roreto Chisone"},
	{"9330","Roreto/Innesto Ss231 Di S.Vittoria"},
	{"9331","Roreto/Innesto Ss662 Di Savigliano"},
	{"9332","Rosa'"},
	{"9333","Rosa Marina"},
	{"9334","Rosa'/Innesto Raccordo Bassano-Thiene"},
	{"9335","Rosa'/Innesto Ss245 Castellana"},
	{"9336","Rosa'/Innesto Ss47 Della Valsugana"},
	{"9337","Rosa-Ligugnana"},
	{"9338","Rosanisco"},
	{"9339","Rosarno"},
	{"9340","Rosarno/Innesto Ss18 Tirrena Inferiore"},
	{"9341","Rosarno/Innesto Ss281/Innesto S.G.C. Jonio-Tirreno"},
	{"9342","Rose"},
	{"9343","Rose-Montalto Uffugo"},
	{"9344","Roseto D. Abruzzi/Innesto Ss150 Della Valle Vomano"},
	{"9345","Roseto Degli Abruzzi"},
	{"9346","Roseto Degli Abruzzi/Innesto Ss16 Adriatica"},
	{"9347","Rosia"},
	{"9348","Rosignano"},
	{"9349","Rosignano Solvay"},
	{"9350","Rosolina"},
	{"9351","Rosolini"},
	{"9352","Rosone"},
	{"9353","Rossano"},
	{"9354","Rossano Veneto"},
	{"9355","Rossiglione"},
	{"9356","Rotatoria Di Silea"},
	{"9357","Rotatoria Ospedale Di Treviso"},
	{"9358","Roteglia"},
	{"9359","Rotondi"},
	{"9360","Rottofreno"},
	{"9361","Rovale"},
	{"9362","Rovato"},
	{"9363","Roveleto"},
	{"9364","Roverbella"},
	{"9365","Rovere"},
	{"9366","Rovereto"},
	{"9367","Rovereto Nord"},
	{"9368","Rovereto Sud-Lago Di Garda Nord"},
	{"9369","Rovereto/Innesto Ss12 Dell'abetone E Del Brennero"},
	{"9370","Rovereto/Innesto Ss240 Di Loppio E Di Val Di Ledro"},
	{"9371","Rovereto/Innesto Ss46 Del Pasubio"},
	{"9372","Rovereto/Innesto Ss12 Dell'abetone E Brennero"},
	{"9373","Rovereto-Portomaggiore"},
	{"9374","Roverino"},
	{"9375","Rovigo"},
	{"9376","Rovigo Sud/Innesto Ss16 Adriatica"},
	{"9377","Rovigo/Incrocio Ss16 Adriatica"},
	{"9378","Rovigo/Incrocio Ss443 Di Adria"},
	{"9379","Rovigo/Innesto Ss434 Transpolesana"},
	{"9380","Rozzano Est"},
	{"9381","Rubano"},
	{"9382","Rubbianello"},
	{"9383","Rubicone"},
	{"9384","Rubiera"},
	{"9385","Rucava'/Innesto Ss251 Di Val Zoldo E Val Cellina"},
	{"9386","Ruffano"},
	{"9387","Ruffano Sud/Innesto Ss474 Di Taurisano"},
	{"9388","Ruffano Sud/Innesto Ss476 Di Galatina"},
	{"9389","Ruffolo"},
	{"9390","Rufina"},
	{"9391","Rugginara"},
	{"9392","Rumia/Innesto Ss183 Aspromonte-Jonio"},
	{"9393","Rumia/Innesto Ss670 Dei Piani D'aspromonte"},
	{"9394","Ruoti"},
	{"9395","Rupa/Confine Con La Slovenia"},
	{"9396","Rupa/Innesto Ss518 Di Devetaki"},
	{"9397","Rupa/Innesto Ss55 Dell'isonzo"},
	{"9398","Russi"},
	{"9399","Rutino"},
	{"9400","Ruviano"},
	{"9401","Ruvo Di Puglia"},
	{"9402","Ruvo Di Puglia/Innesto Ss170 Di Castel Del Monte"},
	{"9403","Ruvo Di Puglia/Innesto Ss98 Andriese Coratina"},
	{"9404","S. Andrea Di Conza/Innesto Ss401"},
	{"9405","S. Andrea Frius/Innesto Ss547 Di Guasila"},
	{"9406","S. Anna"},
	{"9407","S. Anna Q./Innesto Ss561 Pergusina"},
	{"9408","S. Antonio"},
	{"9409","S. Bonifacio"},
	{"9410","S. Candido Variante/Innesto Ss52 Carnica"},
	{"9411","S. Casciano In Val Di Pesa"},
	{"9412","S. Cosimato/Innesto Ss314 Licinese"},
	{"9413","S. Domenica/Innesto Ss514 Di Chiaramonte"},
	{"9414","S. Dona' Di Piave"},
	{"9415","S. Germano Verc./Innesto Ss143 Vercellese"},
	{"9416","S. Giorgio"},
	{"9417","S. Giorgio Canavese"},
	{"9418","S. Giorgio Del Sannio"},
	{"9419","S. Giorgio Di Nogaro"},
	{"9420","S. Giovanni Profiamma/Innesto Ss75 Centrale Umbra"},
	{"9421","S. Giovanni Scalo"},
	{"9422","S. Giovanni/Innesto Ss241 Val D'ega E Passo Di Costa"},
	{"9423","S. Giuliano"},
	{"9424","S. Giuliano N./Innesto Ss12 Radd Diramazione Lucchese"},
	{"9425","S. Giuliano/Innesto Ss12 Dell'abetone E Del Brennero"},
	{"9426","S. Grato Di Lodi"},
	{"9427","S. Guido"},
	{"9428","S. Ilario D'enza"},
	{"9429","S. Lucia"},
	{"9430","S. Maria Angeli/Innesto Ss75 Centrale Umbra"},
	{"9431","S. Maria Di Leuca/Innesto Ss274 Salentina Di Patu'"},
	{"9432","S. Maria Di Leuca/Innesto Ss275 Di S.Maria Di Leuca"},
	{"9433","S. Maria Di Leuca/Innesto Ss173 D. Terme Salentine"},
	{"9434","S. Maria Potenza/Innesto Ss571 Helvia Recina"},
	{"9435","S. Maria/Innesto Ss423 Urbinate"},
	{"9436","S. Martino Buonalbergo"},
	{"9437","S. Martino Di Bareggio"},
	{"9438","S. Michele Extra"},
	{"9439","S. Nicola D'avigliano/Innesto Ss169 E Ss93"},
	{"9440","S. Nicolo' A Tordino"},
	{"9441","S. Ninfa"},
	{"9442","S. Pancrazio"},
	{"9443","S. Paolo Staz./Innesto Ss172 Radd Dei Trulli"},
	{"9444","S. Pelino"},
	{"9445","S. Piero A Sieve/Innesto Ss503 Del Passo Di Gioco"},
	{"9446","S. Pietro All'olmo"},
	{"9447","S. Pietro Vara/Innesto Ss566 Di Val Di Vara"},
	{"9448","S. Severo/Innesto Ss16 Adriatica"},
	{"9449","S. Stefano Di Cadore/Innesto Ss355 Di Val Degano"},
	{"9450","S. Stino Di Livenza"},
	{"9451","S. Vito Dei Normanni"},
	{"9452","S. Zaccaria"},
	{"9453","S.Adele"},
	{"9454","S.Adriano"},
	{"9455","S.Agata Bolognese"},
	{"9456","S.Agata Di  Militello"},
	{"9457","S.Agata Di Esaro"},
	{"9458","S.Agata Di Militello"},
	{"9459","S.Agata Di Militello/Innesto Ss113 Sett. Sicula"},
	{"9460","S.Agata Di Militello/Innesto Ss289 Di Cesaro'"},
	{"9461","S.Agata Militello"},
	{"9462","S.Agata Sui Due Golfi"},
	{"9463","S.Agata Sul Santerno"},
	{"9464","S.Agnello"},
	{"9465","S.Agnese"},
	{"9466","S.Agostino"},
	{"9467","S.Alessio In Aspromonte"},
	{"9468","S.Alessio Siculo"},
	{"9469","S.Allucio"},
	{"9470","S.Ambrogio"},
	{"9471","S.Anastasia"},
	{"9472","S.Anatolia"},
	{"9473","S.Andrea Ansea Di Rimini"},
	{"9474","S.Andrea Di Conza/Innesto Ss7 Appia"},
	{"9475","S.Andrea Di Sorbello"},
	{"9476","S.Andrea Frius"},
	{"9477","S.Andrea Frius/Innesto Ss387 Del Gerrei"},
	{"9478","S.Angelo"},
	{"9479","S.Angelo A Lecore"},
	{"9480","S.Angelo Dei Lombardi"},
	{"9481","S.Angelo Del Pesco"},
	{"9482","S.Angelo Di Acquaro/Innesto Ss536 Di Acquaro"},
	{"9483","S.Angelo In Vado"},
	{"9484","S.Angelo Lodigiano"},
	{"9485","S.Angelo Lomellina"},
	{"9486","S.Anna"},
	{"9487","S.Anna Arresi"},
	{"9488","S.Antioco"},
	{"9489","S.Antioco/Innesto Ss126 Sud Occ.Le Sarda"},
	{"9490","S.Antonino Di Susa"},
	{"9491","S.Antonio"},
	{"9492","S.Antonio A Trebbia"},
	{"9493","S.Antonio Di Gallura"},
	{"9494","S.Antonio Di Mavignola"},
	{"9495","S.Antonio Di Morignone"},
	{"9496","S.Antonio Tortal"},
	{"9497","S.Antonio/Innesto Ss109 Bis Della Piccola Sila"},
	{"9498","S.Antonio/Innesto Ss19 E Ss109 Bis"},
	{"9499","S.Antonio/Innesto Ss19 E Ss19 Quater Delle Calabrie"},
	{"9500","S.Antuono"},
	{"9501","S.Apollinare"},
	{"9502","S.Arcangelo"},
	{"9503","S.Arsenio"},
	{"9504","S.Bartolomeo"},
	{"9505","S.Bartolomeo Al Mare"},
	{"9506","S.Bartolomeo In Galdo"},
	{"9507","S.Basile"},
	{"9508","S.Bellino"},
	{"9509","S.Benedetto"},
	{"9510","S.Benedetto Del Tronto"},
	{"9511","S.Benedetto In Alpe"},
	{"9512","S.Benedetto Po"},
	{"9513","S.Benedetto Po/Innesto Ss413 Romana"},
	{"9514","S.Benedetto Po/Innesto Ss496 Virgiliana"},
	{"9515","S.Biagio"},
	{"9516","S.Biagio Di Callalta"},
	{"9517","S.Biagio Saracinisco"},
	{"9518","S.Biase"},
	{"9519","S.Bortolo"},
	{"9520","S.Candido"},
	{"9521","S.Carlo"},
	{"9522","S.Carlo (ss3)"},
	{"9523","S.Carlo/Innesto S.G.C. Orte-Ravenna"},
	{"9524","S.Casciano Dei Bagni"},
	{"9525","S.Casciano Nord"},
	{"9526","S.Casciano Sud"},
	{"9527","S.Cataldo"},
	{"9528","S.Cataldo/Innesto Ss113 Settentrionale Sicula"},
	{"9529","S.Cataldo/Innesto Ss187 Di Castellammare Del Golfo"},
	{"9530","S.Cataldo/Innesto Ss543 Del Lido Di Lecce"},
	{"9531","S.Cataldo/Innesto Ss611 Di Otranto"},
	{"9532","S.Caterina Di Pasian Di Prato"},
	{"9533","S.Caterina Di Pittinuri"},
	{"9534","S.Caterina Valfurva"},
	{"9535","S.Caterina Villarmosa"},
	{"9536","S.Cesarea Terme"},
	{"9537","S.Cesarea Terme/Innesto Ss497 Maglie E S.Cesarea"},
	{"9538","S.Cesarea Terme/Innesto Ss173 Delle Terme Salentine"},
	{"9539","S.Cesareo/Innesto Ss216 Maremmana Iii"},
	{"9540","S.Cesareo/Innesto Ss6 Casilina"},
	{"9541","S.Chiaffredo"},
	{"9542","S.Colombano"},
	{"9543","S.Corrado Di Fuori"},
	{"9544","S.Cosimato/Innesto Ss5 Tiburtina Valeria"},
	{"9545","S.Cristina D'aspromonte"},
	{"9546","S.Cristina Valgardena"},
	{"9547","S.Cristina/Innesto Ss234 Codognese"},
	{"9548","S.Cristina/Innesto Ss412 Della Val Tidone"},
	{"9549","S.Croce"},
	{"9550","S.Croce Di Magliano"},
	{"9551","S.Croce Di Piuro"},
	{"9552","S.Damaso"},
	{"9553","S.Damiano Macra"},
	{"9554","S.Daniele Del Friuli"},
	{"9555","S.Demetrio Ne' Vestini"},
	{"9556","S.Domenica Talao"},
	{"9557","S.Domenica Vittoria"},
	{"9558","S.Domenica/Innesto Ss194 Ragusana"},
	{"9559","S.Dona' Di Piave"},
	{"9560","S.Donaci"},
	{"9561","S.Donato"},
	{"9562","S.Donato Milanese"},
	{"9563","S.Donato Val Di Comino"},
	{"9564","S.Donnino"},
	{"9565","S.Egidio"},
	{"9566","S.Egidio Alla Vibrata"},
	{"9567","S.Egidio/Innesto Ss17 Bis Della Funivia Del G.Sasso"},
	{"9568","S.Egidio/Innesto Ss17 Bis Dir/C"},
	{"9569","S.Elia"},
	{"9570","S.Elia A Pianisi"},
	{"9571","S.Elia/Seminara/Svincolo Per A3 Salerno-Reggio C."},
	{"9572","S.Enea"},
	{"9573","S.Eufemia"},
	{"9574","S.Eufemia A Maiella"},
	{"9575","S.Eufemia Lamezia"},
	{"9576","S.Eufemia Lamezia - Innesto Ss18 Tirrena Inferiore"},
	{"9577","S.Eufemia Lamezia/Innesto Ss18 Tirrena Inferiore"},
	{"9578","S.Eufemia Lamezia/Innesto Ss280 Dei Due Mari"},
	{"9579","S.Felice"},
	{"9580","S.Felice A Cancello"},
	{"9581","S.Felice Sul Panaro"},
	{"9582","S.Felice Sul Panaro/Innesto Ss468 Di Correggio"},
	{"9583","S.Felice Sul Panaro/Innesto Ss568 Di Crevalcore"},
	{"9584","S.Filippo Sul Cesano"},
	{"9585","S.Fior"},
	{"9586","S.Flavia"},
	{"9587","S.Foca"},
	{"9588","S.Fortunato Della Collina"},
	{"9589","S.Francesco"},
	{"9590","S.Fratello"},
	{"9591","S.Frediano A Settimo"},
	{"9592",""},
	{"9593",""},
	{"9594","Strada Grande Comunicazione Fi-Pi-Li (per Livorno)"},
	{"9595",""},
	{"9596","Strada Grande Comunicazione Grosseto-Fano"},
	{"9597","Strada Grande Comunicazione Jonio-Tirreno"},
	{"9598","Strada Grande Comunicazione Orte-Ravenna (e45)"},
	{"9599","S.Gaudenzio"},
	{"9600","S.Gavino Monreale"},
	{"9601","S.Germano"},
	{"9602","S.Germano Vercellese"},
	{"9603","S.Germano Vercellese/Innesto Ss11 Padana Superiore"},
	{"9604","S.Giacomo"},
	{"9605","S.Giacomo Degli Schiavoni"},
	{"9606","S.Giacomo Delle Segnate"},
	{"9607","S.Giacomo Di Teglio"},
	{"9608","S.Giacomo Di Veglia"},
	{"9609","S.Giacomo Filippo"},
	{"9610","S.Gimignanello/Innesto Raccordo Siena-Bettolle"},
	{"9611","S.Gimignanello-Ss438 Lauretana"},
	{"9612","S.Giorgio"},
	{"9613","S.Giorgio Del Sannio-Innesto Ss7 Appia"},
	{"9614","S.Giorgio Di Lomellina"},
	{"9615","S.Giorgio In Bosco"},
	{"9616","S.Giorgio Jonico"},
	{"9617","S.Giorgio Jonico/Innesto Ss603 Di S.Giorgio Jonico"},
	{"9618","S.Giorgio Jonico/Innesto Ss7 Ter Salentina"},
	{"9619","S.Giorgio Jonico/Innesto Ss7 Via Appia"},
	{"9620","S.Giorgio N./Innesto S.G.C. S.Giorgio Nogaro-Ausa"},
	{"9621","S.Giovanni"},
	{"9622","S.Giovanni A Piro"},
	{"9623","S.Giovanni A Teduccio/Innesto Ss18 Tirrena Inferiore"},
	{"9624","S.Giovanni A Teduccio/Innesto Ss268 Del Vesuvio"},
	{"9625","S.Giovanni Al Timavo/Innesto Ss55 Dell'isonzo"},
	{"9626","S.Giovanni Bianco"},
	{"9627","S.Giovanni Bosco"},
	{"9628","S.Giovanni D'albi/Innesto Ss109 Della Piccola Sila"},
	{"9629","S.Giovanni Di Baiano"},
	{"9630","S.Giovanni In Croce"},
	{"9631","S.Giovanni In Fiore/Innesto Ss1o8ter"},
	{"9632","S.Giovanni In Fiore/Innesto Ss107 Silana Crotonese"},
	{"9633","S.Giovanni In Persiceto/Innesto Ss255 Di S.Matteo"},
	{"9634","S.Giovanni Incarico"},
	{"9635","S.Giovanni Persiceto/Innesto Ss568 Di Crevalcore"},
	{"9636","S.Giovanni Profiamma/Innesto Ss3 Flaminia"},
	{"9637","S.Giovanni Rotondo"},
	{"9638","S.Giovanni Rotondo/Innesto Ss272 Di S.G. Rotondo"},
	{"9639","S.Giovanni Rotondo/Innesto Ss273 Candelarese"},
	{"9640","S.Giovanni Suergiu"},
	{"9641","S.Giovanni Suergiu/Innesto Ss126 Sud Occ. Sarda"},
	{"9642","S.Giovanni Suergiu/Innesto Ss195 Sulcitana"},
	{"9643","S.Giovanni Timavo/Innesto Ss14 Della Venezia Giulia"},
	{"9644","S.Giovanni Valdarno"},
	{"9645","S.Giovanni/Innesto Ss179 Diramazione Del Lago Ampollino"},
	{"9646","S.Giovanni/Innesto Ss48 Delle Dolomiti"},
	{"9647","S.Giovanni-Zona Industriale"},
	{"9648","S.Giuliano"},
	{"9649","S.Giuliano Milanese"},
	{"9650","S.Giuliano Terme"},
	{"9651","S.Giuliano Terme/Innesto Ss12 Abet. E Brennero"},
	{"9652","S.Giuseppe"},
	{"9653","S.Giuseppe Di Cairo Montenotte"},
	{"9654","S.Giuseppe Vesuviano"},
	{"9655","S.Giuseppe/Innesto Ss1 Variante"},
	{"9656","S.Giusta/Innesto Ss131 Di Carlo Felice"},
	{"9657","S.Giusta/Innesto Ss292 Nord Occ. Sarda"},
	{"9658","S.Giustina"},
	{"9659","S.Giustina Bellunese"},
	{"9660","S.Godenzo"},
	{"9661","S.Gregorio D'ippona"},
	{"9662","S.Gregorio Matese"},
	{"9663","S.Gregorio/Innesto Ss17 Dell'app.Abbr.Ed App.Sannit."},
	{"9664","S.Gregorio/Innesto Ss261 Subequana"},
	{"9665","S.Gregorio-Allacciamento A18 Messina-Catania"},
	{"9666","S.Ilario"},
	{"9667","S.Ippolito"},
	{"9668","S.Isidoro/Copertino"},
	{"9669","S.Lazzaro Di Savena"},
	{"9670","S.Leo"},
	{"9671","S.Leonardello"},
	{"9672","S.Leonardo"},
	{"9673","S.Leonardo In Pass./Innesto Ss44 Bis Passo Rombo"},
	{"9674","S.Leonardo In Passiria"},
	{"9675","S.Leonardo In Passiria/Innesto Ss44 Del Passo Giovo"},
	{"9676","S.Leonardo/Innesto Ss105 Di Castrovillari"},
	{"9677","S.Leonardo/Innesto Ss105 Diramazione Di Castrovillari"},
	{"9678","S.Leopardo/Innesto Ss571 Helvia Recina"},
	{"9679","S.Leopardo/Innesto Ss77 Della Val Di Chienti"},
	{"9680","S.Liberato"},
	{"9681","S.Lorenzo"},
	{"9682","S.Lorenzo Al Mare"},
	{"9683","S.Lorenzo Di Sebato/Innesto Ss244 Di Val Badia"},
	{"9684","S.Lorenzo Di Sebato/Innesto Ss49 Della Pusteria"},
	{"9685","S.Lorenzo In Banale"},
	{"9686","S.Lorenzo In Campo"},
	{"9687","S.Lorenzo Nuovo"},
	{"9688","S.Lorenzo Nuovo/Incrocio Ss2 Cassia"},
	{"9689","S.Lorenzo Nuovo/Incrocio Ss74 Maremmana"},
	{"9690","S.Lorenzo Parabiago"},
	{"9691","S.Lucia"},
	{"9692","S.Lucido"},
	{"9693","S.Lugano"},
	{"9694","S.Lupo"},
	{"9695","S.Lussorio"},
	{"9696","S.Mamete"},
	{"9697","S.Mango D'aquino"},
	{"9698","S.Marcello Pistoiese"},
	{"9699","S.Marco"},
	{"9700","S.Marco Dei Cavoti"},
	{"9701","S.Marco In Lamis"},
	{"9702","S.Margherita Di Belice"},
	{"9703","S.Margherita Ligure"},
	{"9704","S.Maria"},
	{"9705","S.Maria A Vico"},
	{"9706","S.Maria Capua Vetere"},
	{"9707","S.Maria D.Grazie/Scopetone/Innesto Ss73 Senese-Aretin"},
	{"9708","S.Maria Degli Angeli"},
	{"9709","S.Maria Degli Angeli/Innesto Ss147 Diramazione Di Assisi"},
	{"9710","S.Maria Dei Sabbioni/Bivio Per Cappella Cantore"},
	{"9711","S.Maria Della Croce"},
	{"9712","S.Maria Delle Fabbrecce/Innesto Ss16 Adriatica"},
	{"9713","S.Maria Delle Grazie"},
	{"9714","S.Maria Delle Macchie/Innesto Ss17 Dell'app.Abruz"},
	{"9715","S.Maria Di Catanzaro - Innesto Ss19quater"},
	{"9716","S.Maria Di Catanzaro/Innesto Ss19quater"},
	{"9717","S.Maria Di Catanzaro/Innesto Ss280 Dei Due Mari"},
	{"9718","S.Maria Di Leuca/Innesto Ss275 Di S.Maria Di Leuca"},
	{"9719","S.Maria Di Morcone"},
	{"9720","S.Maria La Fossa"},
	{"9721","S.Maria La Longa"},
	{"9722","S.Maria La Palma"},
	{"9723","S.Maria La Strada"},
	{"9724","S.Maria Maddalena"},
	{"9725","S.Maria Potenza/Innesto Ss16 Adriatica"},
	{"9726","S.Maria Rossa Di Garvagnate"},
	{"9727","S.Marino"},
	{"9728","S.Martino"},
	{"9729","S.Martino Di Campagna"},
	{"9730","S.Martino Di Castrozza"},
	{"9731","S.Martino Di Valdisotto/Fine Var. A Scorr.Veloce"},
	{"9732","S.Martino In Beliseto"},
	{"9733","S.Martino In Colle"},
	{"9734","S.Martino In Passiria"},
	{"9735","S.Martino In Strada"},
	{"9736","S.Martino Marrucina/Innesto Ss81 Piceno Aprutina"},
	{"9737","S.Martino Maruccina/Innesto Ss81Diramazione Piceno Apr."},
	{"9738","S.Martino Siccomario/Innesto Ss35 Dei Giovi"},
	{"9739","S.Martino Siccomario/Innesto Ss596 Di Cairoli"},
	{"9740","S.Martino Siccomario/Innesto Tangenziale Di Pavia"},
	{"9741","S.Martino Valle Caudina"},
	{"9742","S.Marzano Sul Sarno"},
	{"9743","S.Mauro"},
	{"9744","S.Mauro Marchesato/Innesto Ss109"},
	{"9745","S.Mauro Torinese"},
	{"9746","S.Menaio"},
	{"9747","S.Michele"},
	{"9748","S.Michele Al Fiume"},
	{"9749","S.Michele All'adige/Innesto Ss12 Abetone E Brennero"},
	{"9750","S.Michele All'adige/Innesto Ss43 Della Val Di Non"},
	{"9751","S.Michele Di Appiano"},
	{"9752","S.Michele Di Ganzaria"},
	{"9753","S.Michele/Innesto Ss439 Sarzanese Valdera"},
	{"9754","S.Michele/Innesto Ss439Diramazione Sarzanese Valdera"},
	{"9755","S.Minato Basso"},
	{"9756","S.Miniato Basso/Innesto Ss436 Francesca"},
	{"9757","S.Miniato Basso/Innesto Ss67 Tosco Romagnola"},
	{"9758","S.Miniato/Innesto S.G.C. Fi-Pi-Li"},
	{"9759","S.Nicola Baronia"},
	{"9760","S.Nicola Da Crissa"},
	{"9761","S.Nicola D'avigliano/Innesto Ss93/Innesto Ss658"},
	{"9762","S.Nicola Dell'alto"},
	{"9763","S.Nicola Di Centola"},
	{"9764","S.Nicola L'arena"},
	{"9765","S.Nicola/Innesto Ss169 Di Genzano"},
	{"9766","S.Nicolo' A Trebbia"},
	{"9767","S.Nicolo' D'arcidano"},
	{"9768","S.Nicolo' Di Comelico"},
	{"9769","S.Nicolo Ferrarese"},
	{"9770","S.Nicolo' Gerrei"},
	{"9771","S.Ninfa"},
	{"9772","S.Ninfa/Innesto Ss119 Di Gibellina"},
	{"9773","S.Ninfa/Innesto Ss188 Centro Occidentale Sicula"},
	{"9774","S.Odorico"},
	{"9775","S.Osvaldo"},
	{"9776","S.Pancrazio"},
	{"9777","S.Paolo"},
	{"9778","S.Paolo Bel Sito/Innesto Ss367 Nolana Sarnese"},
	{"9779","S.Paolo Bel Sito/Innesto Ss403 Del Vallo Di Lauro"},
	{"9780","S.Paolo Civitate"},
	{"9781","S.Paolo/Innesto Diramazione Autostradale Di Moncalieri"},
	{"9782","S.Pedretto"},
	{"9783","S.Pelino"},
	{"9784","S.Pellegrino"},
	{"9785","S.Pellegrino Terme"},
	{"9786","S.Pier Marina"},
	{"9787","S.Pierino"},
	{"9788","S.Piero A Ponti"},
	{"9789","S.Piero A Sieve"},
	{"9790","S.Piero A Sieve/Innesto Ss551 Trav. Di Mugello"},
	{"9791","S.Pietro"},
	{"9792","S.Pietro Al Natisone"},
	{"9793","S.Pietro Al Tanagro"},
	{"9794","S.Pietro Apostolo"},
	{"9795","S.Pietro Casasco"},
	{"9796","S.Pietro Di Berbenno"},
	{"9797","S.Pietro Di Carida'"},
	{"9798","S.Pietro Di Legnago"},
	{"9799","S.Pietro Di Polla/Innesto Ss19 Delle Calabrie"},
	{"9800","S.Pietro In Bagno"},
	{"9801","S.Pietro In Cerro"},
	{"9802","S.Pietro In Corte/Innesto Ss10 Padana Inferiore"},
	{"9803","S.Pietro In Corte/Innesto Ss462 Della Val D'arda"},
	{"9804","S.Pietro In P./Innesto Ss1 E Ss206 Pisana-Livornese"},
	{"9805","S.Pietro In Palazzi"},
	{"9806","S.Pietro In Palazzi/Innesto Ss1/Ss68 Di Val Cecina"},
	{"9807","S.Pietro In Palazzi/Innesto Ss68 E Ss206"},
	{"9808","S.Pietro Infine/Innesto Ss6 Diramazione Via Casilina"},
	{"9809","S.Pietro Valdastico"},
	{"9810","S.Pietro Vara"},
	{"9811","S.Pietro Vara/Innesto Ss523 Colle Di Cento Croci"},
	{"9812","S.Pietro/Innesto Ss10 Padana Inferiore"},
	{"9813","S.Pietro/Innesto Ss426 Di Polla"},
	{"9814","S.Pietro/Innesto Ss434 Legnaghese"},
	{"9815","S.Pietro/Innesto Ss6 Casilina"},
	{"9816","S.Polo D'enza"},
	{"9817","S.Potito"},
	{"9818","S.Presto"},
	{"9819","S.Priamo"},
	{"9820","S.Prospero"},
	{"9821","S.Quirico"},
	{"9822","S.Quirico D'orcia/Innesto Ss146 Di Chianciano"},
	{"9823","S.Quirico D'orcia/Innesto Ss2 Cassia"},
	{"9824","S.Reparata"},
	{"9825","S.Roberto"},
	{"9826","S.Rocco/Innesto Ss127 Settentrionale Sarda"},
	{"9827","S.Rocco/Innesto Ss672 Sassari Tempio"},
	{"9828","S.Romano"},
	{"9829","S.Ruffillo"},
	{"9830","S.Rufo"},
	{"9831","S.S.V. Licodia Eubea-Libertinia"},
	{"9832","S.S.V. Lioni-Parolise"},
	{"9833","S.S.V. Melfi-Potenza"},
	{"9834","S.S.V. Sora-Atina-Cassino"},
	{"9835","S.Salvatore A Pilli"},
	{"9836","S.Salvo Est"},
	{"9837","S.Salvo Marina/Innesto Ss16 Adriatica"},
	{"9838","S.Salvo Marina/Innesto Ss650 Di Fondo Valle Trigno"},
	{"9839","S.Sebastiano"},
	{"9840","S.Severino Marche/Innesto Ss361 Septempedana"},
	{"9841","S.Severino Marche/Innesto Ss502 Di Cingoli"},
	{"9842","S.Severo"},
	{"9843","S.Severo - Innesto Ss16 Ter Adriatica"},
	{"9844","S.Severo/Innesto Ss16 Adriatica"},
	{"9845","S.Severo/Innesto Ss16 Ter Adriatica"},
	{"9846","S.Severo/Innesto Ss272 Di S.Giovanni Rotondo"},
	{"9847","S.Severo/Innesto Ss89 Garganica"},
	{"9848","S.Sisto"},
	{"9849","S.Sofia"},
	{"9850","S.Sossio - Innesto Ss7 Quater Via Domiziana"},
	{"9851","S.Sossio/Innesto Ss7 Quater Via Domiziana"},
	{"9852","S.Sosti"},
	{"9853","S.Sperate"},
	{"9854","S.Spirito"},
	{"9855","S.Stefano"},
	{"9856","S.Stefano Al Mare"},
	{"9857","S.Stefano Belbo"},
	{"9858","S.Stefano D'aveto"},
	{"9859","S.Stefano Di Cadore"},
	{"9860","S.Stefano Di Cadore/Innesto Ss52 Carnica"},
	{"9861","S.Stefano Di Camastra"},
	{"9862","S.Stefano Di Camastra/Innesto Ss113 Sett. Sicula"},
	{"9863","S.Stefano Di Camastra/Innesto Ss117 Centr. Sicula"},
	{"9864","S.Stefano Di Magra"},
	{"9865","S.Stefano Di Magra-La Spezia-Allacciamento A15 Pr-Sp"},
	{"9866","S.Stefano In Aspromonte"},
	{"9867","S.Stefano Quisquina"},
	{"9868","S.Stefano Udinese"},
	{"9869","S.Terenzo Di Lerici"},
	{"9870","S.Teresa Di Gallura"},
	{"9871","S.Teresa Di Riva"},
	{"9872","S.Tommaso"},
	{"9873","S.Trada"},
	{"9874","S.Trada/Svincolo Per A3 Salerno-Reggio C."},
	{"9875","S.Trifone"},
	{"9876","S.Valentino"},
	{"9877","S.Valentino In Abruzzo C."},
	{"9878","S.Valentino Torio"},
	{"9879","S.Venanzo"},
	{"9880","S.Vendemiano/Innesto Ss13 Pontebbana"},
	{"9881","S.Vendemiano/Innesto Ss51 Di Alemagna"},
	{"9882","S.Veronica - Innesto Ss17 Bis"},
	{"9883","S.Veronica/Innesto Ss17 Bis"},
	{"9884","S.Veronica/Innesto Ss17 Ter Dell'app. Abruzzese"},
	{"9885","S.Vitale"},
	{"9886","S.Vitale/Innesto Tangenziale Di Bologna"},
	{"9887","S.Vito"},
	{"9888","S.Vito Al Tagliamento"},
	{"9889","S.Vito Al Torre"},
	{"9890","S.Vito Dei Normanni"},
	{"9891","S.Vito Dei Normanni/Innesto Ss16 Adriatica"},
	{"9892","S.Vito Dei Normanni/Innesto Ss605 Di Mesagne"},
	{"9893","S.Vito Di Cadore"},
	{"9894","S.Vito Di Fagagna"},
	{"9895","S.Vito Marina"},
	{"9896","S.Vito Sullo Jonio"},
	{"9897","S.Vito-Innesto Ss87 Var Ovest Di Campobasso"},
	{"9898","S.Vito-Innesto Ss87 Sannitica"},
	{"9899","S.Vittore"},
	{"9900","S.Vittore Olona"},
	{"9901","S.Vittoria"},
	{"9902","S.Vittorino"},
	{"9903","S.Zeno - Innesto Ss73 Senese Aretina"},
	{"9904","S.Zeno Sul Naviglio"},
	{"9905","S.Zenone Degli Ezzelini"},
	{"9906","Sabbion"},
	{"9907","Sabbioneta"},
	{"9908","Sabbionetana"},
	{"9909","Sabbioni"},
	{"9910","Sabina"},
	{"9911","Sacchitello"},
	{"9912","Sacco"},
	{"9913","Sacile"},
	{"9914","Sacile Est"},
	{"9915","Sacile Ovest"},
	{"9916","Sadobre"},
	{"9917","Sagrado"},
	{"9918","Saiaccio"},
	{"9919","Sailetto"},
	{"9920","Saint Vincent-Chatillon"},
	{"9921","Sala"},
	{"9922","Sala Comacina"},
	{"9923","Sala Consilina"},
	{"9924","Salaria"},
	{"9925","Salbertrand"},
	{"9926","Salcheto/Innesto Ss326 Di Rapolano"},
	{"9927","Salcheto/Innesto Ss454 Di Pozzuolo"},
	{"9928","Sale Marasino"},
	{"9929","Salemi"},
	{"9930","Salemi/Innesto Ss188 Centro Occidentale Sicula"},
	{"9931","Salemi/Innesto Ss188 Dir/A Centro Occ. Sicula"},
	{"9932","Salentina Di Gallipoli"},
	{"9933","Salentina Di Manduria"},
	{"9934","Salentina Di Patu'"},
	{"9935","Salere"},
	{"9936","Salerno"},
	{"9937","Salerno - Raccordo Salerno-Avellino"},
	{"9938","Salerno Centro"},
	{"9939","Salerno Fratte"},
	{"9940","Salerno/Innesto Ss18 Tirrena Inferiore"},
	{"9941","Salerno/Innesto Ss18racc/Bis Tirrena Inferiore"},
	{"9942","Salerno/Innesto Ss88 Dei Due Principati"},
	{"9943","Salesei/Innesto Ss48 Delle Dolomiti"},
	{"9944","Salesei/Innesto Ss563 Di Salesei"},
	{"9945","Saletto"},
	{"9946","Salice Salentino/Innesto Ss605 Di Mesagne"},
	{"9947","Salice Salentino/Innesto Ss7 Ter Salentina"},
	{"9948","Saliceto"},
	{"9949","Saline Di Volterra/Innesto Ss439 Sarz. Valdera"},
	{"9950","Saline Di Volterra/Innesto Ss68 Di Val Cecina"},
	{"9951","Salo'"},
	{"9952","Salo'/Innesto Ss572 Di Salo'"},
	{"9953","Salorno"},
	{"9954","Salsomaggiore"},
	{"9955","Salsominore"},
	{"9956","Salto"},
	{"9957","Salto Cicolana"},
	{"9958","Salussola"},
	{"9959","Saluzzo/Innesto Ss589 Dei Laghi Di Avigliana E Ss662"},
	{"9960","Saluzzo/Innesto Ss589 Dei Laghi Di Avigliana E Ss663"},
	{"9961","Saluzzo/Innesto Ss662 E Ss663 Di Saluzzo"},
	{"9962","Salvaiessi"},
	{"9963","Salvatelle"},
	{"9964","Salviano"},
	{"9965","Salza Irpina"},
	{"9966","Salzen"},
	{"9967","Samassi/Innesto Ss196Diramazione Di Villacidro"},
	{"9968","Samassi/Innesto Ss293 Di Giba"},
	{"9969","Sambatello"},
	{"9970","Sambiase"},
	{"9971","Sambuca Di Sicilia"},
	{"9972","Sambucheto"},
	{"9973","Sambuchi"},
	{"9974","San Bartolomeo"},
	{"9975","San Benedetto"},
	{"9976","San Benedetto Del Tronto"},
	{"9977","San Cesareo"},
	{"9978","San Cristoforo"},
	{"9979","San Donato (Direzione Firenze)"},
	{"9980","San Donato (Direzione Siena)"},
	{"9981","San Giacomo"},
	{"9982","San Giorgio A Cremano"},
	{"9983","San Giuliano/Innesto Ss12 Radd Diramazione Lucchese"},
	{"9984","San Martino"},
	{"9985","San Michele All'adige-Mezzocorona"},
	{"9986","San Nicola"},
	{"9987","San Pelagio"},
	{"9988","San Remo"},
	{"9989","San Severo"},
	{"9990","San Vittore"},
	{"9991","San Zenone"},
	{"9992","Sanarica"},
	{"9993","Sandetole/Innesto Ss556 Londa-Stia"},
	{"9994","Sandetole/Innesto Ss67 Tosco Romagnola"},
	{"9995","Sandigliano"},
	{"9996","Sandrigo"},
	{"9997","Sangemini Fonte/Innesto Ss3 Ter Di Narni E Sangemini"},
	{"9998","Sangemini/Innesto Ss3 Bis Tiberina (e45)"},
	{"9999","Sangemini/Innesto Ss79 Ternana"},
	{"10000","Sangro"},
	{"10001","Sanguarzo"},
	{"10002","Sanguinetto"},
	{"10003","Sannicandro Garganico"},
	{"10004","Sannite"},
	{"10005","Sannitica"},
	{"10006","Sanremo Ovest"},
	{"10007","Sansepolcro"},
	{"10008","Sant' Angelo/Innesto Ss182 Delle Serre Calabre"},
	{"10009","Sant' Ilario"},
	{"10010","Santa Caterina"},
	{"10011","Santa Croce"},
	{"10012","Santa Giuletta"},
	{"10013","Santa Lucia"},
	{"10014","Santa Maria"},
	{"10015","Santa Maria Apparente"},
	{"10016","Santa Maria Delle Macchie/Innesto Ss647"},
	{"10017","Santa Maria Di Sala"},
	{"10018","Santa Maria Maggiore"},
	{"10019","Santa Maria-Innesto Sp26/A Per Montelibretti"},
	{"10020","Santa Marinella"},
	{"10021","Santa Severa"},
	{"10022","Santena - A21 Torino-Brescia"},
	{"10023","Santena - Tangenziale Sud Torino"},
	{"10024","Santeramo In Colle/Innesto Ss171 Di Santeramo"},
	{"10025","Santeramo In Colle/Innesto Ss271 Di Cassano"},
	{"10026","Santerno"},
	{"10027","Sant'eufemia"},
	{"10028","Sant'eufemia Di Aspromonte"},
	{"10029","Santhia'"},
	{"10030","Santuario Della Verna"},
	{"10031","Santuario Di Montevergine"},
	{"10032","Santuario Di Oropa"},
	{"10033","Santuario Di Santa Maria Di Leuca"},
	{"10034","Sanza"},
	{"10035","Sanzan"},
	{"10036","Saone"},
	{"10037","Sappada"},
	{"10038","Sapri"},
	{"10039","Sapri/Innesto Ss104 Di Sapri"},
	{"10040","Sapri/Innesto Ss18 Tirrena Inferiore"},
	{"10041","Sarche"},
	{"10042","Sarche/Innesto Ss237 Del Caffaro"},
	{"10043","Sarche/Innesto Ss45 Bis Gardesana Occidentale"},
	{"10044","Sardegna"},
	{"10045","Sardonico/Innesto Ss43 Diramazione Della Val Di Non"},
	{"10046","Sarego"},
	{"10047","Sarezzo"},
	{"10048","Sarmeola"},
	{"10049","Sarnano"},
	{"10050","Sarnico"},
	{"10051","Sarno"},
	{"10052","Sarnonico"},
	{"10053","Sarnonico/Innesto Ss42 Del Tonale E Della Mendola"},
	{"10054","Saronno"},
	{"10055","Sarsina"},
	{"10056","Sarteano"},
	{"10057","Sartirana Lomellina"},
	{"10058","Sarule"},
	{"10059","Sarzana"},
	{"10060","Sarzana/Innesto Ss1 Aurelia"},
	{"10061","Sarzana/Innesto Ss446 Di Fosdinovo"},
	{"10062","Sarzana/Innesto Ss62 Della Cisa"},
	{"10063","Sarzanese Valdera"},
	{"10064","Sassari"},
	{"10065","Sassari Nord/Innesto Ss131 Di Carlo Felice"},
	{"10066","Sassari Nord/Innesto Ss291 Della Nurra"},
	{"10067","Sassari/Innesto Ss127 Bis Settentrionale Sarda"},
	{"10068","Sassari/Innesto Ss131 Di Carlo Felice"},
	{"10069","Sassari/Ippodromo"},
	{"10070","Sassari-Tempio"},
	{"10071","Sassatella"},
	{"10072","Sassello"},
	{"10073","Sassi Di Torino/Innesto Ss10 Padana Inferiore"},
	{"10074","Sassi Di Torino/Innesto Ss590 Della Val Cerrina"},
	{"10075","Sassinoro"},
	{"10076","Sasso Marconi"},
	{"10077","Sasso Marconi/Innesto Ss325 Val Setta E Val Bisenzio"},
	{"10078","Sassoferrato"},
	{"10079","Sassuolo"},
	{"10080","Sassuolo/Innesto Ss467 Di Scandiano"},
	{"10081","Satriano Di Lucania"},
	{"10082","Sava"},
	{"10083","Savagnasco"},
	{"10084","Savalano Ovest"},
	{"10085","Savelli"},
	{"10086","Savelli/Innesto Ss108 Ter Silana Di Cariati"},
	{"10087","Savelli/Innesto Ss492 Di Savelli"},
	{"10088","Savigliano/Innesto Ss20 Del C. Di Tenda E V. Roja"},
	{"10089","Savigliano/Innesto Ss662 Di Savigliano"},
	{"10090","Savignano Irpino"},
	{"10091","Savignano Sul Panaro"},
	{"10092","Savignano Sul Rubicone"},
	{"10093","Savio"},
	{"10094","Savona"},
	{"10095",""},
	{"10096","Savona/Innesto Ss1 Aurelia"},
	{"10097","Savona/Innesto Ss29 Del Colle Di Cadibona"},
	{"10098","Savona-Zinola-Vado-Allacciamento A10 Ge-Ventimiglia"},
	{"10099","Savoulx"},
	{"10100","Scafa S.Valentino/Innesto Ss487 Di Caramanico Terme"},
	{"10101","Scafa Sul Trino/Innesto Ss5 Tiburtina Valeria"},
	{"10102","Scafa-Alanno"},
	{"10103","Scafati"},
	{"10104","Scala"},
	{"10105","Scala Cavalli/Innesto Ss131 Bis Carlo Felice"},
	{"10106","Scala Di Giocca/Innesto Ss127 Sett. Sarda"},
	{"10107","Scala Di Giocca/Innesto Ss131 Di Carlo Felice"},
	{"10108","Scalea"},
	{"10109","Scalea/Innesto Ss18 Tirrena Inferiore"},
	{"10110","Scalea/Innesto Ss504 Di Mormanno"},
	{"10111","Scaletta Zanclea"},
	{"10112","Scaligera"},
	{"10113","Scampitella"},
	{"10114","Scandale"},
	{"10115","Scandiano"},
	{"10116","Scanno"},
	{"10117","Scansano/Innesto Ss322 Delle Collacchie"},
	{"10118","Scansano/Innesto Ss323 Di Monte Amiata"},
	{"10119","Scanzano Jonico"},
	{"10120","Scario"},
	{"10121","Scarlino Scalo"},
	{"10122","Scarmagno"},
	{"10123","Scarperia"},
	{"10124","Scauri"},
	{"10125","Scerne Di Pineto"},
	{"10126","Scheggia"},
	{"10127","Scheggia/Innesto Ss298 Eugubina"},
	{"10128","Scheggia/Innesto Ss3 Flaminia"},
	{"10129","Scheggia/Innesto Ss360 Arceviese"},
	{"10130","Scheggino"},
	{"10131","Schiava"},
	{"10132","Schiavon"},
	{"10133","Schiavonesca-Marosticana"},
	{"10134","Schilpario"},
	{"10135","Schio"},
	{"10136","Schio/Innesto Ss350 Di Folgaria E Di Val D'astico"},
	{"10137","Schio/Innesto Ss46 Del Pasubio"},
	{"10138","Schiso'/Innesto Ss114 Orientale Sicula"},
	{"10139","Schiso'/Innesto Ss185 Di Sella Mandrazzi"},
	{"10140","Sciaves/Innesto Ss49 Bis Della Pusteria"},
	{"10141","Sciaves/Innesto Ss49 Della Pusteria"},
	{"10142","Scido"},
	{"10143","Sciliar Ovest"},
	{"10144","Scilla"},
	{"10145","Scilla/Svincolo Per A3 Salerno-Reggio C."},
	{"10146","Scillato"},
	{"10147","Scillato Centro"},
	{"10148","Scillato Sud"},
	{"10149","Sciovia Di Montecristo"},
	{"10150","Scoglio Della Regina"},
	{"10151","Scopa"},
	{"10152","Scopello"},
	{"10153","Scopeti"},
	{"10154","Scorze'"},
	{"10155","Scorze'/Incrocio Ss515 Noalese"},
	{"10156","Scorze'/Innesto Ss245 Castellana"},
	{"10157","Scorzo"},
	{"10158","Scritto"},
	{"10159","Scudillo"},
	{"10160","Scurcola Marsicana"},
	{"10161","Sebina Occidentale"},
	{"10162","Sebina Orientale"},
	{"10163","Sebino"},
	{"10164","Secante Di Cesena"},
	{"10165","Secchia"},
	{"10166","Secchiano"},
	{"10167","Secli'"},
	{"10168","Secondigliano"},
	{"10169","Secondigliano-Raccordo Capodichino"},
	{"10170","Secugnago"},
	{"10171","Sedico"},
	{"10172","Sedico/Innesto Ss203 Agordina"},
	{"10173","Sedico/Innesto Ss50 Del Grappa E Del Passo Rolle"},
	{"10174","Sedini"},
	{"10175","Sega"},
	{"10176","Segariu"},
	{"10177","Segesta"},
	{"10178","Seggio/Innesto Ss115Diramazione Sud Occidentale Sicula"},
	{"10179","Seggio/Innesto Ss115 Sud Occidentale Sicula"},
	{"10180","Segheria Il Mandrione"},
	{"10181","Segni Scalo"},
	{"10182","Selice E Montanara Imolese"},
	{"10183","Selignano"},
	{"10184","Sella Bifurto"},
	{"10185","Sella Del Perrone"},
	{"10186","Sella Di Conza"},
	{"10187","Sella Di Conza/Incrocio Ss7 Appia"},
	{"10188","Sella Di Conza/Incrocio Ss91 Della Valle Del Sele"},
	{"10189","Sella Di Fadalto/Innesto Ss51 Di Alemagna"},
	{"10190","Sella Entrata"},
	{"10191","Sella Fadaldo/Innesto Ss422 Diramazione Alpago E Cansiglio"},
	{"10192","Sella Monello/Innesto Ss122 Agrigentina"},
	{"10193","Sella Monello/Innesto Ss410 Di Naro"},
	{"10194","Sella Valcada"},
	{"10195","Sellanese"},
	{"10196","Sellano"},
	{"10197","Selva"},
	{"10198","Selva Candida"},
	{"10199","Selva Del Montello"},
	{"10200","Selva Di Cadore"},
	{"10201","Selva Di Cadore/Innesto Ss638 Del Passo Di Giau"},
	{"10202","Selva Di Cadore/Innesto Ss251 Di Val Zoldo E Cellina"},
	{"10203","Selva Di Val Gardena"},
	{"10204","Selvanizza"},
	{"10205","Selvotta"},
	{"10206","Semogo"},
	{"10207","Semonte"},
	{"10208","Sempione/Svizzera"},
	{"10209","Sendrina"},
	{"10210","Senese Aretina"},
	{"10211","Senigallia"},
	{"10212","Senigallia/Innesto Ss16 Adriatica"},
	{"10213","Senigallia/Innesto Ss360 Arceviese"},
	{"10214","Senis"},
	{"10215","Senise"},
	{"10216","Sennariolo"},
	{"10217","Sennori"},
	{"10218","Senorbi'/Innesto Ss128 Centrale Sarda"},
	{"10219","Senorbi/Innesto Ss547 Di Guasila"},
	{"10220","Septempedana"},
	{"10221","Sequals"},
	{"10222","Sequals/Innesto Ss464 Di Spilimbergo"},
	{"10223","Sequals/Innesto Ss552 Del Passo Rest"},
	{"10224","Serdiana/Innesto Ss387 Del Gerrei"},
	{"10225","Serdiana/Innesto Ss466 Di Sibiola"},
	{"10226","Sergnano"},
	{"10227","Seriate"},
	{"10228","Seriate/Innesto Ss42 Del Tonale E Della Mendola"},
	{"10229","Seriate/Innesto Ss498 Soncinese"},
	{"10230","Serino"},
	{"10231","Serra D.Cazzola/Innesto Ss122 Agrigentina"},
	{"10232","Serra D.Cazzola/Innesto Ss640 Di P.To Empedocle"},
	{"10233","Serra D'aiello"},
	{"10234","Serra Del Fiego/Innesto Ss648"},
	{"10235","Serra Di Fiego/Innesto Ss107 Silana Crotonese"},
	{"10236","Serra S.Bruno/Innesto Ss182 Delle Serre Calabre"},
	{"10237","Serra S.Bruno/Innesto Ss110 M.Te Cucco E Pecoraro"},
	{"10238","Serracapriola"},
	{"10239","Serracapriola/Innesto Ss16 Ter Adriatica"},
	{"10240","Serracapriola/Innesto Ss376 Dei Tre Titoli"},
	{"10241","Serradarce"},
	{"10242","Serramanna"},
	{"10243","Serramonacesca"},
	{"10244","Serrapetrona"},
	{"10245","Serrara"},
	{"10246","Serrata"},
	{"10247","Serravalle"},
	{"10248","Serravalle A Po"},
	{"10249","Serravalle All'adige"},
	{"10250","Serravalle D'asti"},
	{"10251","Serravalle Di Chienti"},
	{"10252","Serravalle Di Norcia/Innesto Ss320 Di Cascia"},
	{"10253","Serravalle Di Norcia/Innesto Ss396 Di Norcia"},
	{"10254","Serravalle Pistoiese"},
	{"10255","Serravalle Scrivia"},
	{"10256","Serravalle Scrivia/Innesto Ss35 Dei Giovi"},
	{"10257","Serravalle Sesia"},
	{"10258","Serravalle/Innesto Ss35 Bis Dei Giovi"},
	{"10259","Serrazzano"},
	{"10260","Serre"},
	{"10261","Serre/Innesto Ss488 Di Rocca D'aspide"},
	{"10262","Serrungarina"},
	{"10263","Sersale"},
	{"10264","Sersale/Innesto Ss109 Della Piccola Sila"},
	{"10265","Sersale/Innesto Ss180 Di Cropani"},
	{"10266","Servigliano"},
	{"10267","Servo"},
	{"10268","Sesia"},
	{"10269","Sesta Godano"},
	{"10270","Sesto"},
	{"10271","Sesto Al Reghena"},
	{"10272","Sesto Calende"},
	{"10273","Sesto Calende - Innesto Ss33 Del Sempione"},
	{"10274","Sesto Calende/Innesto A8 Diramazione Gallarate-S. Calende"},
	{"10275","Sesto Calende/Innesto Ss32 Ticinese"},
	{"10276","Sesto Calende/Innesto Ss629 Di Angera"},
	{"10277","Sesto Calende-Vergiate"},
	{"10278","Sesto Imolese"},
	{"10279","Sestola"},
	{"10280","Sestri Levante"},
	{"10281","Sestri Levante/Via Tino Paggi"},
	{"10282","Sestri Levante-Innesto Ss523 Colle Di Cento Croci"},
	{"10283","Sestriere"},
	{"10284","Sette Vene"},
	{"10285","Settebagni"},
	{"10286","Setteca'"},
	{"10287","Settentrionale Sarda"},
	{"10288","Settentrionale Sicula"},
	{"10289","Settimo Torinese"},
	{"10290","Settimo Vittone"},
	{"10291","Settimo Vittone/Innesto Ss419 Della Serra"},
	{"10292","Settimo Vittone/Innesto Ss26 Della Valle D'aosta"},
	{"10293","Seui"},
	{"10294","Sezze Scalo"},
	{"10295","Sfercia"},
	{"10296","Sferro"},
	{"10297","Sforzacosta"},
	{"10298","Sforzacosta Sud/Innesto Raccordo Di P.To Civitanova"},
	{"10299","Sforzacosta/Innesto Ss485 Corridonia Maceratese"},
	{"10300","Sforzacosta/Innesto Ss77 Della Val Di Chienti"},
	{"10301","Sforzacosta/Innesto Ss78 Picena"},
	{"10302","Sgonico"},
	{"10303","Sibari"},
	{"10304","Sicignano Est"},
	{"10305","Sicignano/Innesto Raccordo Sicignano Potenza"},
	{"10306","Sicignano-Allacciamento A3 Sa-Rc"},
	{"10307","Sicilia"},
	{"10308","Siculiana"},
	{"10309","Siderno"},
	{"10310","Sieci"},
	{"10311","Siena"},
	{"10312","Siena Est - Due Ponti"},
	{"10313","Siena Est/Tangenziale Siena/Raccordo Si-Bettolle"},
	{"10314","Siena N./Innesto Ss222/Bivio Per Raccordo Fi-Si E Tangenziale Si"},
	{"10315","Siena Nord"},
	{"10316","Siena Nord-Raccordo Fi-Si-Ss222-Ss2"},
	{"10317","Siena Sud"},
	{"10318","Siena/Bivio Per Raccordo Fi-Si E Per Tangenziale Siena"},
	{"10319","Siena/Innesto Ss2 Cassia"},
	{"10320","Siena/Innesto Ss2/Ss223/Tangenziale Siena"},
	{"10321","Siena/Innesto Ss2/Ss73/Tangenziale Siena"},
	{"10322","Siena/Innesto Ss408 Di Montevarchi"},
	{"10323","Sigillo"},
	{"10324","Signa"},
	{"10325","Signoressa"},
	{"10326","Silana Crotonese"},
	{"10327","Silana Di Cariati"},
	{"10328","Silana Di Rose"},
	{"10329","Silana Di Rossano"},
	{"10330","Silandro"},
	{"10331","Siliqua"},
	{"10332","Siliqua/Incrocio Ss130 Iglesiente"},
	{"10333","Siliqua/Incrocio Ss293 Di Giba"},
	{"10334","Silla"},
	{"10335","Sillaro"},
	{"10336","Silvella"},
	{"10337","Silvi Marina"},
	{"10338","Silvi Marina/Innesto Ss16 Adriatica"},
	{"10339","Silvi Marina/Innesto Ss553 Di Atri"},
	{"10340","Sim Tirrenella"},
	{"10341","Simaxis"},
	{"10342","Simbario"},
	{"10343","Simeto-Innesto Ss114"},
	{"10344","Simeto-Ss114"},
	{"10345","Sinalunga/Innesto Raccordo Siena-Bettolle"},
	{"10346","Sinalunga-Bivio Ss326 Di Rapolano"},
	{"10347","Sindia"},
	{"10348","Siniscola Nord/Innesto Ss125 Orientale Sarda"},
	{"10349","Siniscola Nord/Innesto Ss131 Dir/Centr. Nuorese"},
	{"10350","Siniscola Sud"},
	{"10351","Sinopoli"},
	{"10352","Siracusa"},
	{"10353","Siracusa/Innesto Ss114 Or. S. E Ss115 Sud Occ.Le S."},
	{"10354","Siracusa/Innesto Ss114 Or.Sicula E Ss124 Siracusana"},
	{"10355","Siracusa/Innesto Ss115 E Ss124 Ragusana"},
	{"10356","Siracusana"},
	{"10357","Sirmione"},
	{"10358","Siror"},
	{"10359","Sistiana"},
	{"10360","Sizzano"},
	{"10361","Sluderno"},
	{"10362","Sluderno/Innesto Ss40 Del Passo Resia"},
	{"10363","Sluderno/Innesto Ss41 Di Val Monastero"},
	{"10364","Smirra"},
	{"10365","Soave"},
	{"10366","Socchieve"},
	{"10367","Soci"},
	{"10368","Sogliano Cavour"},
	{"10369","Sola"},
	{"10370","Solagna"},
	{"10371","Solarino"},
	{"10372","Solaro"},
	{"10373","Solbiate Arno"},
	{"10374","Solcio Di Lesa"},
	{"10375","Solda"},
	{"10376","Solda Di Fuori"},
	{"10377","Solero"},
	{"10378","Solignano"},
	{"10379","Solimbergo"},
	{"10380","Solofra"},
	{"10381","Somaglia"},
	{"10382","Somma Lombarda"},
	{"10383","Somma Lombardo"},
	{"10384","Somma Vesuviana"},
	{"10385","Sommacampagna"},
	{"10386","Sommariva Del Bosco"},
	{"10387","Sommatino"},
	{"10388","Sompiano"},
	{"10389","Somplago"},
	{"10390","Soncinese"},
	{"10391","Soncino/Innesto Ss235 Di Orzinuovi"},
	{"10392","Soncino/Innesto Ss498 Soncinese"},
	{"10393","Sondalo"},
	{"10394","Sondrio"},
	{"10395","Sonico"},
	{"10396","Sora"},
	{"10397","Sora/Innesto Ss627 Della Vandra"},
	{"10398","Sora/Innesto Ss666 Di Sora"},
	{"10399","Sora/Innesto Ss82 Della Valle Del Liri"},
	{"10400","Soraga"},
	{"10401","Sorbo S.Basile"},
	{"10402","Sorbolo"},
	{"10403","Sorgono"},
	{"10404","Sori"},
	{"10405","Sorianello"},
	{"10406","Soriano Calabro"},
	{"10407","Sorrentina"},
	{"10408","Sorrento"},
	{"10409","Sorriva"},
	{"10410","Sorso"},
	{"10411","Soverato"},
	{"10412","Soverato Marina/Innesto Ss106 Jonica"},
	{"10413","Soverato Marina/Innesto Ss182 Delle Serre Calabre"},
	{"10414","Sovereto"},
	{"10415","Soveria Mannelli"},
	{"10416","Soveria Mannelli/Innesto Ss109 Della Piccola Sila"},
	{"10417","Soveria Mannelli/Innesto Ss19 Delle Calabrie"},
	{"10418","Sovilla"},
	{"10419","Sp44 Mi-Meda"},
	{"10420","Spadafora"},
	{"10421","Spadola"},
	{"10422","Spallatteria"},
	{"10423","Sparone"},
	{"10424","Sparta'"},
	{"10425","Spazzavento"},
	{"10426","Sperlinga"},
	{"10427","Sperlonga"},
	{"10428","Sperone"},
	{"10429","Spert"},
	{"10430","Spervara"},
	{"10431","Speziale"},
	{"10432","Spezzano"},
	{"10433","Spezzano Albanese"},
	{"10434","Spezzano Albanese/Innesto Ss106 Bis Jonica"},
	{"10435","Spezzano Albanese/Innesto Ss19 Delle Calabrie"},
	{"10436","Spezzano Della Sila/Innesto Ss107 Silana Crotonese"},
	{"10437","Spezzano Della Sila/Innesto Ss648"},
	{"10438","Spezzano Terme"},
	{"10439","Spiazzo"},
	{"10440","Spigno Monferrato Var."},
	{"10441","Spilamberto"},
	{"10442","Spilimbergo"},
	{"10443","Spinasanta/Innesto Ss118 E Ss189"},
	{"10444","Spinasanta/Innesto Ss189 E Ss122 Agrigentina"},
	{"10445","Spinazzola"},
	{"10446","Spinazzola/Innesto Ss168 Raccordo Di Venosa"},
	{"10447","Spinazzola/Innesto Ss169 Di Genzano"},
	{"10448","Spinazzola/Innesto Ss169 Diramazione Di Genzano"},
	{"10449","Spinazzola/Innesto Ss97 Delle Murge"},
	{"10450","Spineta"},
	{"10451","Spinetta Marengo/Innesto Ss10 Padana Inferiore"},
	{"10452","Spinetta Marengo/Innesto Ss35 Bis Dei Giovi"},
	{"10453","Spoletina"},
	{"10454","Spoleto"},
	{"10455","Spoleto/Innesto Ss3 E Ss395 Passo Di Cerro"},
	{"10456","Spoleto/Innesto Ss3 Flaminia E Ss418 Spoletina"},
	{"10457","Spoleto/Innesto Ss395 Passo Cerro/Ss418 Spoletina"},
	{"10458","Spoltore"},
	{"10459","Spondigna/Innesto Ss38 Dello Stelvio"},
	{"10460","Spondigna/Innesto Ss4o Del Passo Di Resia"},
	{"10461","Spormaggiore"},
	{"10462","Spotorno"},
	{"10463","Spresiano"},
	{"10464","Spropolo"},
	{"10465","Squillace"},
	{"10466","Squillace/Innesto Ss382 Di Chiaravalle"},
	{"10467","Squinzano"},
	{"10468","Ss Ofantina"},
	{"10469","Ss10"},
	{"10470","Ss10 Padana Inferiore-Asti Est"},
	{"10471","Ss10(sud)"},
	{"10472","Ss106 Ter"},
	{"10473","Ss109"},
	{"10474","Ss11"},
	{"10475","Ss113"},
	{"10476","Ss113 Settentrionale Sicula"},
	{"10477","Ss122(nord)"},
	{"10478","Ss123(sud)"},
	{"10479","Ss13"},
	{"10480","Ss131"},
	{"10481","Ss14"},
	{"10482","Ss16"},
	{"10483","Ss211(sud)"},
	{"10484","Ss217"},
	{"10485","Ss223"},
	{"10486","Ss26 Dir"},
	{"10487","Ss27"},
	{"10488","Ss274"},
	{"10489","Ss280"},
	{"10490","Ss29"},
	{"10491","Ss3"},
	{"10492","Ss3 Bis Tiberina"},
	{"10493","Ss32"},
	{"10494","Ss32(nord)"},
	{"10495","Ss33"},
	{"10496","Ss35(direzione Ge)"},
	{"10497","Ss35(direzione Mi)"},
	{"10498","Ss387"},
	{"10499","Ss4"},
	{"10500","Ss400 Di Castelvetere"},
	{"10501","Ss437"},
	{"10502","Ss45(ovest)"},
	{"10503","Ss457(nord)"},
	{"10504","Ss55"},
	{"10505","Ss56/Ss352"},
	{"10506","Ss600"},
	{"10507","Ss601"},
	{"10508","Ss62"},
	{"10509","Ss64 Porrettana"},
	{"10510","Ss7"},
	{"10511","Ss7 Appia"},
	{"10512","Ss71"},
	{"10513","Ss8"},
	{"10514","Ss87"},
	{"10515","Ss87 Sannitica/Bivio Per Matrice"},
	{"10516","Ss96"},
	{"10517","St. Oyen"},
	{"10518","St. Pierre"},
	{"10519","St. Rhemy"},
	{"10520","St. Vaglio Basilicata/Innesto Ss7 E Ss407 Basentana"},
	{"10521","Stabbia"},
	{"10522","Staffa"},
	{"10523","Staggia Senese"},
	{"10524","Stagno"},
	{"10525","Stagno/Innesto Ss1 Aurelia"},
	{"10526","Stagno/Innesto Ss555 Delle Colline"},
	{"10527","Stagno/Innesto Ss67 Bis Tosco Romagnola"},
	{"10528","Stanghella"},
	{"10529","Staro"},
	{"10530","Stava"},
	{"10531","Staz Di Nocera Terinese"},
	{"10532","Staz. Albinia/Innesto Ss1 Aurelia"},
	{"10533","Staz. Arzana"},
	{"10534","Staz. Belvedere Marittimo/Innesto Ss18 Tirrena Inferiore"},
	{"10535","Staz. Bussi Sul Tirino/Innesto Ss5 Tiburtina Val."},
	{"10536","Staz. Campiglia Marittima"},
	{"10537","Staz. Cantalupo Nel Sannio/Innesto Ss618 Molesana"},
	{"10538","Staz. Capaccio Rocca D'aspide"},
	{"10539","Staz. Capaccio Rocca D'aspide/Innesto Ss166"},
	{"10540","Staz. Capaccio/Innesto Ss18 Tirrena Inferiore"},
	{"10541","Staz. Caprioli/Innesto Ss447 Di Palinuro"},
	{"10542","Staz. Caprioli/Innesto Ss447 Racc Di Palinuro"},
	{"10543","Staz. Casalbordino/Innesto Ss364 Di Atessa"},
	{"10544","Staz. Castelnuovo Vallo Di Lucania/Innesto Ss267"},
	{"10545","Staz. Chiatona/Innesto Ss106 Diramazione Jonica"},
	{"10546","Staz. Chiusi/Innesto Ss321 Del Polacco"},
	{"10547","Staz. Chiusi/Innesto Ss71 Umbro Casen. Rom."},
	{"10548","Staz. Colleferro/Segni/Innesto Ss609 Carpinetana"},
	{"10549","Staz. Colleferro-Segni/Innesto Ss6 Casilina"},
	{"10550","Staz. Cropani/Innesto Ss106 Jonica"},
	{"10551","Staz. D'aquino/Innesto Ss628 Leuciana"},
	{"10552","Staz. Di Acate"},
	{"10553","Staz. Di Acquaviva-Casteltermini"},
	{"10554","Staz. Di Albano Di Lucania"},
	{"10555","Staz. Di Albinia/Innesto Ss74 Maremmana"},
	{"10556","Staz. Di Altavilla Milicia"},
	{"10557","Staz. Di Aquilonia/Innesto Ss401 Diramazione"},
	{"10558","Staz. Di Aquino/Innesto Ss6 Casilina"},
	{"10559","Staz. Di Archi"},
	{"10560","Staz. Di Ascoli"},
	{"10561","Staz. Di Atena L./Innesto Ss19 E Ss166 Degli Alburni"},
	{"10562","Staz. Di Atena Lucana/Innesto Ss19 E Innesto Ss95"},
	{"10563","Staz. Di Atena Lucana/Innesto Ss95 E Ss166 Alburni"},
	{"10564","Staz. Di Avetrana"},
	{"10565","Staz. Di Baragiano"},
	{"10566","Staz. Di Battipaglia"},
	{"10567","Staz. Di Bella/Muro"},
	{"10568","Staz. Di Bibbiena"},
	{"10569","Staz. Di Bologna"},
	{"10570","Staz. Di Bovino"},
	{"10571","Staz. Di Calitri/Innesto Ss399 Di Calitri E Ss7dir"},
	{"10572","Staz. Di Calitri/Innesto Ss401/Innesto Ss399"},
	{"10573","Staz. Di Campobasso"},
	{"10574","Staz. Di Cantalupo Del Sannio/Innesto Ss17"},
	{"10575","Staz. Di Casal Velino"},
	{"10576","Staz. Di Casalbordino/Innesto Ss16 Adriatica"},
	{"10577","Staz. Di Castel S.Giovanni"},
	{"10578","Staz. Di Castelbuono/Innesto Ss113 Sett. Sicula"},
	{"10579","Staz. Di Castelbuono/Innesto Ss286 Di Castelbuono"},
	{"10580","Staz. Di Cerda/Innesto Ss113 Settentrionale Sicula"},
	{"10581","Staz. Di Cereda/Innesto Ss120"},
	{"10582","Staz. Di Chiatona/Innesto Ss106 Jonica"},
	{"10583","Staz. Di Chiusi/Innesto Ss146 Di Chianciano"},
	{"10584","Staz. Di Conza"},
	{"10585","Staz. Di Corigliano Calabro"},
	{"10586","Staz. Di Cropani/Innesto Ss180 Di Cropani"},
	{"10587","Staz. Di Desulo/Tonara"},
	{"10588","Staz. Di Fabro"},
	{"10589","Staz. Di Firenze"},
	{"10590","Staz. Di Francavilla/Innesto Ss19 Diramazione Delle Calabrie"},
	{"10591","Staz. Di Gavorrano"},
	{"10592","Staz. Di Grassano/Innesto Ss277 Di Calle"},
	{"10593","Staz. Di Guardiagrele/Innesto Ss538 Marrucina"},
	{"10594","Staz. Di Guglionesi/Innesto Ss647"},
	{"10595","Staz. Di Guglionesi/Innesto Ss87 Sannitica"},
	{"10596","Staz. Di Imera/Innesto Diramazione Per Imera E Ss626"},
	{"10597","Staz. Di Irsina"},
	{"10598","Staz. Di Isola Capo Rizzuto"},
	{"10599","Staz. Di Latomie"},
	{"10600","Staz. Di Magliano Sabina/Innesto Ss3 Flaminia"},
	{"10601","Staz. Di Masotti"},
	{"10602","Staz. Di Massa Martana/Innesto Ss3 Bis Tiberina"},
	{"10603","Staz. Di Mellitto"},
	{"10604","Staz. Di Mirto Crosia"},
	{"10605","Staz. Di Modena"},
	{"10606","Staz. Di Mongrassano"},
	{"10607","Staz. Di Montalto"},
	{"10608","Staz. Di Montalto Rose/Innesto Ss19 Delle Calabrie"},
	{"10609","Staz. Di Montecosaro"},
	{"10610","Staz. Di Montesano/Innesto Ss103 Di Val D'agri"},
	{"10611","Staz. Di Montesano/Innesto Ss517 Bussentina"},
	{"10612","Staz. Di Monteverde"},
	{"10613","Staz. Di Mosciano/Innesto Ss262 Diramazione Di Campli"},
	{"10614","Staz. Di Mosciano/Innesto Ss80 Del Gran Sasso"},
	{"10615","Staz. Di Notaresco/Innesto Ss553 Di Atri"},
	{"10616","Staz. Di Nusco"},
	{"10617","Staz. Di Omignano"},
	{"10618","Staz. Di Panigale/Innesto Ss71 Umbro Cas. Rom."},
	{"10619","Staz. Di Paola"},
	{"10620","Staz. Di Pascarola"},
	{"10621","Staz. Di Pescariello"},
	{"10622","Staz. Di Pirato"},
	{"10623","Staz. Di Pisticci/Innesto Ss176 Della V. Del Basento"},
	{"10624","Staz. Di Poggio Mirteto"},
	{"10625","Staz. Di Pollenza"},
	{"10626","Staz. Di Portacomaro"},
	{"10627","Staz. Di Rignano Garganico"},
	{"10628","Staz. Di Ripabottoni/Innesto Ss212 Della V.Fortore"},
	{"10629","Staz. Di Rocca D'evandro"},
	{"10630","Staz. Di Rocchetta-Lacedonia"},
	{"10631","Staz. Di Rossano"},
	{"10632","Staz. Di Rossano/Innesto Ss177 Silana Di Rossano"},
	{"10633","Staz. Di S.Cataldo"},
	{"10634","Staz. Di S.Paolo/Innesto Ss172 Dei Trulli"},
	{"10635","Staz. Di S.Teresa Di Longarini"},
	{"10636","Staz. Di Salandra-Grottole"},
	{"10637","Staz. Di Savignano"},
	{"10638","Staz. Di Savignano Irpino/Innesto Ss90 Delle Puglie"},
	{"10639","Staz. Di Savignano/Innesto Ss90 Bis Delle Puglie"},
	{"10640","Staz. Di Savignano/Innesto Ss90 Delle Puglie"},
	{"10641","Staz. Di Sepino"},
	{"10642","Staz. Di Sibari/Innesto Ss106 Radd Jonica"},
	{"10643","Staz. Di Spinazzola/Innesto Ss168 Racc Di Venosa"},
	{"10644","Staz. Di Strongoli/Innesto Ss106 Jonica"},
	{"10645","Staz. Di Surbo/Innesto Ss16 Adriatica"},
	{"10646","Staz. Di Terontola"},
	{"10647","Staz. Di Tiera/Innesto Ss658 Ssv Melfi-Potenza"},
	{"10648","Staz. Di Tito"},
	{"10649","Staz. Di Torano"},
	{"10650","Staz. Di Vaglio Basilicata/Innesto Ss7 Appia"},
	{"10651","Staz. Di Vaglio Basilicata/Innesto Ss407/Innesto Ss658"},
	{"10652","Staz. Di Vairano/Innesto Ss6 Casilina/Innesto Ss608"},
	{"10653","Staz. Di Vairano/Innesto Ss85 Venafrana/Innesto Ss608"},
	{"10654","Staz. Di Valmozzola"},
	{"10655","Staz. Di Vigevano"},
	{"10656","Staz. Di Villapiana"},
	{"10657","Staz. Di Villapiana/Innesto Ss106 Jonica"},
	{"10658","Staz. Di Villapiana/Innesto Ss92 Dell' App. Merid."},
	{"10659","Staz. Di Vizzini/Incrocio Ss124 Siracusana"},
	{"10660","Staz. Di Vizzini/Incrocio Ss514 Di Chiaramonte"},
	{"10661","Staz. Enas"},
	{"10662","Staz. Esterzili"},
	{"10663","Staz. Fenosu"},
	{"10664","Staz. Ferrandina"},
	{"10665","Staz. Fossacesia/Innesto Ss16 Adriatica"},
	{"10666","Staz. Fossacesia/Innesto Ss524 Lanciano Fossacesia"},
	{"10667","Staz. Francavilla Angitola/Innesto Ss18 Tirrena Inferiore"},
	{"10668","Staz. Gerbini"},
	{"10669","Staz. Guardiagrele/Innesto Ss363 Di Guardiagrele"},
	{"10670","Staz. Libertinia"},
	{"10671","Staz. Mandatoriccio/Innesto Ss106 Jonica"},
	{"10672","Staz. Mandatoriccio/Innesto Ss383 Di Mandatoriccio"},
	{"10673","Staz. Metaponto"},
	{"10674","Staz. Montalbano/Innesto Ss598 Fondo V. D'agri"},
	{"10675","Staz. Montesano/Innesto Ss19 Delle Calabrie"},
	{"10676","Staz. Motta S.Anastasia"},
	{"10677","Staz. Ogliastro Cilento/Innesto Ss267 Del Cilento"},
	{"10678","Staz. Orvieto/Innesto Ss205 Amerina"},
	{"10679","Staz. Orvieto/Innesto Ss71 Umbro Casentinese Rom."},
	{"10680","Staz. Palagiano - Innesto Ss7 Appia"},
	{"10681","Staz. Palagiano/Innesto Ss100 Di Gioia Del Colle"},
	{"10682","Staz. Palagiano/Innesto Ss7 Appia"},
	{"10683","Staz. Palagonia"},
	{"10684","Staz. Panigale/Innesto Ss599 Trasimeno Inferiore"},
	{"10685","Staz. Pellicciari/Innesto Ss96 Barese"},
	{"10686","Staz. Pellicciari/Innesto Ss96 Bis Barese"},
	{"10687","Staz. Rapolla Lavello/Innesto Ss168 Di Venosa"},
	{"10688","Staz. Rapolla-Lavello/Innesto Ss93 Appulo Lucana"},
	{"10689","Staz. Ripabottoni/Innesto Ss87 Sannitica"},
	{"10690","Staz. Rossano/Innesto Ss106 Jonica"},
	{"10691","Staz. S.Martino/Innesto Ss192 Valle Del Dittaino"},
	{"10692","Staz. S.Martino/Innesto Ss417 Di Caltagirone"},
	{"10693","Staz. Savignano Irpino/Innesto Ss91 Bis Irpina"},
	{"10694","Staz. Sibari/Innesto Ss106 Jonica"},
	{"10695","Staz. Squillace/Innesto Ss106 Jonica"},
	{"10696","Staz. Squillace/Innesto Ss181 Di Maida E Squillace"},
	{"10697","Staz. Strongoli/Incrocio Ss492 Di Savelli"},
	{"10698","Staz. Surbo/Innesto Ss7 Ter Salentina"},
	{"10699","Staz. Tito/Innesto Ss94 Del Varco Di Pietrastretta"},
	{"10700","Staz. Ussassai"},
	{"10701","Staz. Villa S.Sebastiano/Innesto Ss5 Tiburtina"},
	{"10702","Staz. Villa S.Sebastiano/Innesto Ss579 Palentina"},
	{"10703","Staz. Villagrande"},
	{"10704","Staz. Villanovatulo"},
	{"10705","Stazione Di Acri"},
	{"10706","Stazione Di Albacina/Ss76 Var"},
	{"10707","Stazione Di Ancona"},
	{"10708","Stazione Di Aquilonia/Innesto Ss401"},
	{"10709","Stazione Di Imera"},
	{"10710","Stazione Di Nuova Siri"},
	{"10711","Stazione Di Osimo"},
	{"10712","Stazione Di Ostia"},
	{"10713","Stazione Di Pietrelcina"},
	{"10714","Stazione Di Porto Di Vasto"},
	{"10715","Stazione Di S.Massimo"},
	{"10716","Stazione Di Sforzacosta"},
	{"10717","Stazione Di Soliera"},
	{"10718","Stazione Di Varese"},
	{"10719","Stazione Imera"},
	{"10720","Stazzona"},
	{"10721","Stella"},
	{"10722","Stelvio/Innesto Ss38 Dir/B Dello Stelvio"},
	{"10723","Stezzano"},
	{"10724","Stia"},
	{"10725","Stia/Innesto Ss310 Del Bidente"},
	{"10726","Stia/Innesto Ss556 Londa-Stia"},
	{"10727","Stifone"},
	{"10728","Stigliano"},
	{"10729","Stigliano/Innesto Ss103 Di Val D'agri"},
	{"10730","Stilo"},
	{"10731","Stimigliano"},
	{"10732","Stio"},
	{"10733","Storo"},
	{"10734","Stra"},
	{"10735","Stra'"},
	{"10736","Stra Di Caldiero"},
	{"10737","Strada"},
	{"10738","Strada C. S.Cristoforo"},
	{"10739","Strada Cadorna"},
	{"10740","Strada Della Verna"},
	{"10741","Strada In Chianti"},
	{"10742","Stradella"},
	{"10743","Strambino"},
	{"10744","Strasatti"},
	{"10745","Strembo"},
	{"10746","Stresa"},
	{"10747","Strevi"},
	{"10748","Strongoli"},
	{"10749","Stroppiana Var."},
	{"10750","Stroppo"},
	{"10751","Strozzacapponi"},
	{"10752","Stupinigi"},
	{"10753","Stupinigi/Innesto Tangenziale Sud Torino"},
	{"10754","Stupizza"},
	{"10755","Stura"},
	{"10756","Stura Nord"},
	{"10757","Stura Sud"},
	{"10758","Suaredda"},
	{"10759","Subbiano"},
	{"10760","Subequana"},
	{"10761","Subiaco"},
	{"10762","Sublacense"},
	{"10763","Succiano"},
	{"10764","Sud"},
	{"10765","Sud Occidentale Sarda"},
	{"10766","Sud Occidentale Sicula"},
	{"10767","Suelli"},
	{"10768","Suello"},
	{"10769","Suello/Innesto Ss639 Dei Laghi Di Pusiano"},
	{"10770","Suini/Incrocio Ss292 Nord Occidentale Sarda"},
	{"10771","Sulcitana"},
	{"10772","Sulmona Nord"},
	{"10773","Sulmona/Incrocio Ss487 Di Caramanico Terme"},
	{"10774","Sulmona/Innesto Ss17"},
	{"10775","Sulmona/Innesto Ss479 Sannite"},
	{"10776","Sulmona-Pratola Peligna"},
	{"10777","Sulzano"},
	{"10778","Summaga"},
	{"10779","Summonte"},
	{"10780","Suni/Incrocio Ss129bis Trasversale Sarda"},
	{"10781","Supersano"},
	{"10782","Superstrada Merano-Bolzano"},
	{"10783","Susa"},
	{"10784","Susa Est"},
	{"10785","Susa Ovest-Venaus"},
	{"10786","Susa-Autoporto"},
	{"10787","Susano/Innesto Ss10 Padana Inferiore"},
	{"10788","Susano/Innesto Ss249 Gardesana Orientale"},
	{"10789","Susegana"},
	{"10790","Sustinente"},
	{"10791","Sutera Staz."},
	{"10792","Sutri"},
	{"10793","Sutrio"},
	{"10794","Sutrio/Innesto Ss465 Della Forcella Di Lavardet"},
	{"10795","Sutrio/Innesto Ss52 Bis Carnica"},
	{"10796","Suvereto"},
	{"10797","Svincolo A14"},
	{"10798","Svincolo A4 To-Ts/Ss525/Dalmine"},
	{"10799","Svincolo Acea-S.Liberato Sud"},
	{"10800","Svincolo Acquacalda"},
	{"10801","Svincolo Acquasparta"},
	{"10802","Svincolo Acquasparta/Innesto Ss418 Spoletina"},
	{"10803","Svincolo Aeroporto"},
	{"10804","Svincolo Affi - Lago Garda A22 Brennero-Mo-Innesto Ss450"},
	{"10805","Svincolo Affi Lago Garda A22 Modena-Brennero"},
	{"10806","Svincolo Agrate B.: Sp13 Melzo-Monza-Dogana"},
	{"10807","Svincolo Alpo"},
	{"10808","Svincolo Altavilla Milicia A19 Palermo-Catania"},
	{"10809","Svincolo Altilia-Grimaldi A3 Sa-Rc"},
	{"10810","Svincolo Alvito"},
	{"10811","Svincolo Anagnina G.R.A."},
	{"10812","Svincolo Aosta Est A5/Innesto Raccordo Per G.S.Bernardo"},
	{"10813","Svincolo Aosta Est A5/Innesto Ss26"},
	{"10814","Svincolo Apiro/Mergo/Ss76"},
	{"10815","Svincolo Aprilia/Innesto Ss207 Nettunense"},
	{"10816","Svincolo Apriliana"},
	{"10817","Svincolo Aranova"},
	{"10818","Svincolo Ardeatina"},
	{"10819","Svincolo Arenzano A10 Genova-Ventimiglia"},
	{"10820","Svincolo Arsie'"},
	{"10821","Svincolo Asti Est A21 To-Pc/Innesto Ss10 Padana Inferiore"},
	{"10822","Svincolo Atena Lucana A3 Sa-Rc/Innesto Ss598"},
	{"10823","Svincolo Atena Lucana A3 Sa-Rc/Innesto Ss95 Di Brienza"},
	{"10824","Svincolo Atina Superiore"},
	{"10825","Svincolo Aurelia A12 Roma - Civitavecchia"},
	{"10826","Svincolo Ausonia-Innesto Ss630 Ausonia"},
	{"10827","Svincolo Avenza A12 Genova-Rosignano"},
	{"10828","Svincolo Avigliana A32 Torino-Bardonecchia"},
	{"10829","Svincolo Baggio-Cusago: Via Zurigo-Zona Ind."},
	{"10830","Svincolo Bagnara Calabra A3 Salerno-Reggio C."},
	{"10831","Svincolo Bagnatica/Cremona/Brescia/A4 To-Ts/Ss42"},
	{"10832","Svincolo Bagno Di Romagna"},
	{"10833","Svincolo Balanzano"},
	{"10834","Svincolo Balestrate A29 Palermo-Mazara Del Vallo"},
	{"10835","Svincolo Balvano Raccordo Sicignano-Potenza"},
	{"10836","Svincolo Bargino Raccordo Firenze-Siena"},
	{"10837","Svincolo Bari A14 Bologna-Taranto"},
	{"10838","Svincolo Bari-Tangenziale Di Bari"},
	{"10839","Svincolo Barletta"},
	{"10840","Svincolo Barletta Nord"},
	{"10841","Svincolo Barletta Sud"},
	{"10842","Svincolo Barletta-Ss170 Dir/A Di Castel Del Monte"},
	{"10843","Svincolo Barletta-Ss93 Appulo Lucana-A14 Bo-Ta"},
	{"10844","Svincolo Bastia Centro/Torgiano/Loc. S.Lucia"},
	{"10845","Svincolo Bastia Sud/Umbia Fiere"},
	{"10846",""},
	{"10847",""},
	{"10848","Svincolo Bellaveduta-Cerignola"},
	{"10849","Svincolo Bellaveduta-S.Ferdinando"},
	{"10850","Svincolo Belmonte Castello"},
	{"10851","Svincolo Bergamo Centro/Treviglio/Colognola"},
	{"10852","Svincolo Bergamo/Alzano L./Ponteranica/Ss470"},
	{"10853","Svincolo Bergamo/Longolo"},
	{"10854","Svincolo Bisceglie Sud-Ss16 Adriatica"},
	{"10855","Svincolo Bisceglie-Sc Lama Monachile"},
	{"10856","Svincolo Bisceglie-Sp188 Bisceglie-Andria"},
	{"10857","Svincolo Bisceglie-Sp85 Bisceglie-Corato"},
	{"10858","Svincolo Bisceglie-Sp85 Bisceglie-Ruvo"},
	{"10859","Svincolo Bolifano"},
	{"10860","Svincolo Bomarzo (Direzione Orte)"},
	{"10861","Svincolo Bomarzo (Direzione Viterbo)"},
	{"10862","Svincolo Borello (per Borello)"},
	{"10863","Svincolo Borello (per Ranchio)"},
	{"10864","Svincolo Borgo Roma-Bivio Per Ca' Di David-Ss12"},
	{"10865","Svincolo Borgo Tufico/Ss256/Ss76"},
	{"10866","Svincolo Bosco"},
	{"10867","Svincolo Braemi"},
	{"10868","Svincolo Brolo A20 Messina-Palermo"},
	{"10869","Svincolo Buonfornello A19 Palermo-Catania"},
	{"10870","Svincolo C.A.M.M.: Monlue'"},
	{"10871","Svincolo Calopinace"},
	{"10872","Svincolo Caltanissetta A19 Pa-Ct/Innesto Diramazione Imera/Ss640"},
	{"10873","Svincolo Campagna Per A3 Salerno-Reggio C."},
	{"10874","Svincolo Campo Tenese A3 Salerno-Reggio C."},
	{"10875","Svincolo Campobello Di Mazara A29 Pa-Mazara Del Vallo"},
	{"10876","Svincolo Campodiegoli E Cancelli/Incrocio Ss76"},
	{"10877","Svincolo Camponocecchio/Ss76"},
	{"10878","Svincolo Canalicchio"},
	{"10879","Svincolo Canili"},
	{"10880","Svincolo Cannara"},
	{"10881","Svincolo Capaci A29 Palermo-Mazara Del Vallo"},
	{"10882","Svincolo Capreria"},
	{"10883","Svincolo Cardinale Porta Nova"},
	{"10884","Svincolo Carrara A12 Genova-Rosignano"},
	{"10885","Svincolo Carrodano A12 Genova-Rosignano"},
	{"10886","Svincolo Casale (passarelle)"},
	{"10887","Svincolo Casale Monf. Nord A26 Genova-Gravellona T."},
	{"10888","Svincolo Casalina"},
	{"10889","Svincolo Casalvieri-Loc.Fallena"},
	{"10890","Svincolo Cascina"},
	{"10891","Svincolo Cascina Campagna"},
	{"10892","Svincolo Cascina Gaggiola"},
	{"10893","Svincolo Cascina Gobba Tangenziale Est Di Milano"},
	{"10894",""},
	{"10895","Svincolo Casello Ancona Nord A14 Bo-Ta"},
	{"10896","Svincolo Casello Bergamo Centro A4 To-Ts"},
	{"10897",""},
	{"10898",""},
	{"10899","Svincolo Casemurate"},
	{"10900","Svincolo Casoria A1 Milano-Napoli"},
	{"10901","Svincolo Casottole"},
	{"10902","Svincolo Cassino-Loc. S.Pasquale"},
	{"10903","Svincolo Cassino-Viale Bonomi"},
	{"10904","Svincolo Castel Di Guido Nord"},
	{"10905","Svincolo Castel Di Guido Sud"},
	{"10906","Svincolo Castel Giubileo G.R.A."},
	{"10907","Svincolo Castel Romano/Trigoria"},
	{"10908","Svincolo Castel S.Giorgio A30 Caserta-Salerno"},
	{"10909","Svincolo Castelbellino"},
	{"10910","Svincolo Casteldaccia A19 Palermo-Catania"},
	{"10911","Svincolo Castelvetrano A29 Palermo-Mazara Del Vallo"},
	{"10912","Svincolo Catania Sud A19 Palermo-Catania"},
	{"10913","Svincolo Catenanuova A19 Palermo-Catania"},
	{"10914","Svincolo Cava De' Tirreni A3 Napoli-Salerno"},
	{"10915","Svincolo Cefalu' A20 Messina-Palermo"},
	{"10916","Svincolo Cerignola- Ss98 - Ss16"},
	{"10917","Svincolo Cerveteri Ladispoli A12 Roma-Civitavecchia"},
	{"10918","Svincolo Cervia-Rimini-Mirabilandia"},
	{"10919","Svincolo Cesena Nord"},
	{"10920","Svincolo Cesena Ovest-Innesto Ss71"},
	{"10921","Svincolo Cesena Sud"},
	{"10922","Svincolo Chieti-Pescara-Raccordo Ch-Pe"},
	{"10923","Svincolo Cingoli/Incrocio Ss502 Di Cingoli"},
	{"10924","Svincolo Cinisello B.-Robecco"},
	{"10925","Svincolo Cinisi A29 Palermo-Mazara Del Vallo"},
	{"10926","Svincolo Citta' Di Castello-Ss221"},
	{"10927","Svincolo Civitavecchia Sud A12 Roma-Civitavecchia"},
	{"10928","Svincolo Colle Val D'elsa Nord Raccordo Fi-Si"},
	{"10929","Svincolo Colledara-S.Gabriele A24 Roma-Teramo"},
	{"10930","Svincolo Colleferro A1 Milano Napoli"},
	{"10931","Svincolo Collestrada"},
	{"10932","Svincolo Collevalenza"},
	{"10933","Svincolo Cologno Monzese: S.S.Giovanni Sud"},
	{"10934","Svincolo Concorezzo: Agrate Nord"},
	{"10935","Svincolo Corso Europa"},
	{"10936","Svincolo Corso Francia Tangenziale Sud Di Torino"},
	{"10937","Svincolo Cortemaggiore Diramazione Per Fiorenzuola"},
	{"10938","Svincolo Cosenza Sud A3 Salerno-Reggio C."},
	{"10939","Svincolo Crema/Piacenza/Orio Al Serio/Ss591"},
	{"10940","Svincolo Curnasco/Treviolo"},
	{"10941","Svincolo Curno/Curnasco/Treviolo"},
	{"10942","Svincolo Dei Giovi Tangenziale Ovest Di Milano"},
	{"10943","Svincolo Deiva Marina A12 Genova-Rosignano"},
	{"10944",""},
	{"10945","Svincolo Deruta Centro"},
	{"10946","Svincolo Deruta Nord"},
	{"10947","Svincolo Deruta Sud"},
	{"10948","Svincolo Di Agapito"},
	{"10949","Svincolo Di Agognate A4 Torino-Trieste"},
	{"10950","Svincolo Di Ancarano-Castel Di Lama"},
	{"10951","Svincolo Di Basciano-Villa Vomano"},
	{"10952","Svincolo Di Bellano"},
	{"10953","Svincolo Di Ciampino"},
	{"10954","Svincolo Di Desio Nord"},
	{"10955","Svincolo Di Maltignano"},
	{"10956","Svincolo Di Monfalcone-Raccordo Ss14-Ss55"},
	{"10957","Svincolo Di Monsampolo"},
	{"10958","Svincolo Di Monteprandone-A14 Bo-Ta"},
	{"10959","Svincolo Di Padriciano-Innesto Ss202"},
	{"10960","Svincolo Di Piona"},
	{"10961","Svincolo Di Poasco"},
	{"10962","Svincolo Di Polignano Sud"},
	{"10963","Svincolo Di Prosecco"},
	{"10964","Svincolo Di S.Nicolo' A Tordino"},
	{"10965","Svincolo Di Santa Rufina"},
	{"10966","Svincolo Di Sgonico"},
	{"10967","Svincolo Di Sistiana-A4 To-Ts"},
	{"10968","Svincolo Di Spinetoli"},
	{"10969","Svincolo Di Teramo A24"},
	{"10970","Svincolo Di Toano"},
	{"10971","Svincolo Di Torrimpietra A12 Roma-Civitavecchia"},
	{"10972","Svincolo Di Trabia A19 Palermo-Catania"},
	{"10973","Svincolo Di Trebiciano"},
	{"10974","Svincolo Di Val Vomano"},
	{"10975","Svincolo Di Villareia-Innesto Ss5 Tiburtina"},
	{"10976","Svincolo Dueville A31 Del Valdastico"},
	{"10977","Svincolo Duino A4 Torino-Trieste"},
	{"10978","Svincolo Empoli Est"},
	{"10979","Svincolo Empoli Ovest"},
	{"10980","Svincolo Enna A19 Palermo-Catania"},
	{"10981",""},
	{"10982","Svincolo Falcone A20 Messina-Palermo"},
	{"10983","Svincolo Faul-Bagni"},
	{"10984","Svincolo Fenadora/Innesto Ss50"},
	{"10985","Svincolo Ferrara Innesto Raccordo Ferrara-Porto Garibaldi"},
	{"10986","Svincolo Firenze Signa A1 Mi-Na/Innesto S.G.C. Fi-Pi-Li"},
	{"10987","Svincolo Fiumefreddo A18 Messina-Catania"},
	{"10988","Svincolo Foligno/Innesto Ss316 Dei Monti Martani"},
	{"10989","Svincolo Fossignano/Valle Lata"},
	{"10990","Svincolo Frascineto A3 Salerno-Reggio C."},
	{"10991","Svincolo Fregene Nord"},
	{"10992","Svincolo Fregene Sud"},
	{"10993","Svincolo Fulgatore A29 Diramazione Alcamo-Trapani"},
	{"10994","Svincolo Furiano A20 Messina-Palermo"},
	{"10995","Svincolo Gargazzone-Innesto Sp159"},
	{"10996",""},
	{"10997","Svincolo Genova Sampierdarena A7 Milano-Genova"},
	{"10998","Svincolo Genova Voltri A10 Genova-Ventimiglia"},
	{"10999","Svincolo Gerbini A19 Palermo-Catania"},
	{"11000","Svincolo Giaroni"},
	{"11001","Svincolo Ginestra Fiorentina"},
	{"11002","Svincolo Gioia Tauro A3 Salerno-Reggio C."},
	{"11003","Svincolo Gioiosa Jonica I"},
	{"11004","Svincolo Gioiosa Jonica Ii"},
	{"11005","Svincolo Giovinazzo-Sc Pietre Rosse"},
	{"11006","Svincolo Giovinazzo-Sp107 Giovinazzo-Terlizzi"},
	{"11007","Svincolo Giovinazzo-Sp171 Giovinazzo-Bitonto"},
	{"11008","Svincolo Giovinazzo-Ss16 Adriatica"},
	{"11009","Svincolo Gobba: Treviglio-Vimodrone"},
	{"11010","Svincolo Gola Della Rossa/Ss76"},
	{"11011",""},
	{"11012",""},
	{"11013","Svincolo Grande Raccordo Anulare"},
	{"11014","Svincolo Grandi Motori-St. Dorligo"},
	{"11015","Svincolo Grassobbio Centro/Zona Industriale/Seriate"},
	{"11016","Svincolo Gravina"},
	{"11017","Svincolo Grottarossa"},
	{"11018","Svincolo Imera/Innesto Diramazione Per Imera E Ss640"},
	{"11019","Svincolo La Loggia Tangenziale Sud Di Torino"},
	{"11020","Svincolo La Loggia-Ss20 Del Colle Di Tenda"},
	{"11021","Svincolo La Rizza - Castel D'azzano"},
	{"11022","Svincolo Lagonegro-Maratea A3 Sa-Rc"},
	{"11023","Svincolo Lagundo-Merano Nord"},
	{"11024","Svincolo Lambrate: Melzo - Dogana Segrate"},
	{"11025","Svincolo Lamezia Terme A3 Salerno-Reggio C."},
	{"11026","Svincolo Lana-Innesto Sp69 Postal-Lana"},
	{"11027","Svincolo Lastra A Signa"},
	{"11028","Svincolo Lauria Nord A3 Salerno-Reggio C."},
	{"11029","Svincolo Lauria Sud A3 Salerno-Reggio C."},
	{"11030","Svincolo Lavagna A12 Ge-Rosignano"},
	{"11031","Svincolo Lavoria"},
	{"11032","Svincolo Licata Calandrino/Innesto Ss123 Di Licata"},
	{"11033","Svincolo Lidarno"},
	{"11034","Svincolo Limina"},
	{"11035","Svincolo Linate: V.Le Forlanini-Sp14 Rivoltana"},
	{"11036","Svincolo Lioni-Innesto Ss7 Appia"},
	{"11037","Svincolo L'oliva-Trinitapoli"},
	{"11038","Svincolo Macerata-Civitanova Racc Di P.To Civitanova"},
	{"11039","Svincolo Madonna Del Piano"},
	{"11040","Svincolo Madonnuccia Poggiolino"},
	{"11041","Svincolo Maiolati/Ss76"},
	{"11042","Svincolo Malagrotta"},
	{"11043","Svincolo Marene A6 Torino-Savona"},
	{"11044","Svincolo Marina Di Gioiosa-Grotteria A Mare"},
	{"11045","Svincolo Marino Del Tronto"},
	{"11046","Svincolo Marlengo-Merano Ovest"},
	{"11047","Svincolo Marsala A29 Diramazione Per Birgi"},
	{"11048","Svincolo Massa A12 Genova-Rosignano"},
	{"11049","Svincolo Massa Martana"},
	{"11050","Svincolo Massa Martana/Innesto Ss316 Monti Martani"},
	{"11051","Svincolo Masseria Trentangeli"},
	{"11052","Svincolo Massimina"},
	{"11053","Svincolo Mercato Saraceno"},
	{"11054","Svincolo Migliarino Raccordo Ferrara-P.To Garibaldi"},
	{"11055","Svincolo Milano/Bergamo/Grumello"},
	{"11056","Svincolo Milazzo A20 Messina-Palermo"},
	{"11057","Svincolo Modena"},
	{"11058","Svincolo Moie"},
	{"11059","Svincolo Molfetta Nord"},
	{"11060","Svincolo Molfetta Sud"},
	{"11061","Svincolo Molfetta-Sp112 Terlizzi-Molfetta"},
	{"11062","Svincolo Molfetta-Zona Industriale"},
	{"11063","Svincolo Monachina-Casalombroso"},
	{"11064","Svincolo Monfalcone-Raccordo Per A4 To-Ts"},
	{"11065","Svincolo Monfalcone-Ss14 Della Venezia Giulia"},
	{"11066","Svincolo Monsano"},
	{"11067","Svincolo Montalto Rose A3 Salerno-Reggio C."},
	{"11068","Svincolo Monte Castello"},
	{"11069","Svincolo Monte D'oro/Pomezia Nord"},
	{"11070","Svincolo Monte Gelli"},
	{"11071","Svincolo Montecastrilli"},
	{"11072","Svincolo Montella"},
	{"11073","Svincolo Montelupo Fiorentino"},
	{"11074","Svincolo Montemolino"},
	{"11075","Svincolo Monteriggioni/Raccordo Firenze-Siena"},
	{"11076","Svincolo Monteroduni"},
	{"11077","Svincolo Montone"},
	{"11078","Svincolo Montopoli In Val D'arno"},
	{"11079",""},
	{"11080","Svincolo Monza Centro: 1 Maggio"},
	{"11081","Svincolo Monza-S.Alessandro"},
	{"11082","Svincolo Morano Castrovillari A3 Salerno-Reggio C."},
	{"11083","Svincolo Mormanno A3 Salerno-Reggio C."},
	{"11084","Svincolo Mostacciano"},
	{"11085","Svincolo Motta S.Anastasia A19 Palermo-Catania"},
	{"11086","Svincolo Mulinello A19 Palermo-Catania"},
	{"11087","Svincolo Navacchio-Visignano"},
	{"11088","Svincolo Nera Montoro-Ss204 Ortana"},
	{"11089","Svincolo Nocera Pagani A3 Napoli-Salerno"},
	{"11090","Svincolo Nola A30 Ce-Sa/Innesto Sgc Nola-Domitio"},
	{"11091","Svincolo Nusco"},
	{"11092","Svincolo Orio Al Serio/Bergamo C./Seriate/Aeroclub"},
	{"11093","Svincolo Orte"},
	{"11094","Svincolo Ospedalicchio/Innesto Ss147 Di Assisi"},
	{"11095","Svincolo Ovada A26 Genova V.-Gravellone Toce"},
	{"11096","Svincolo Padova A13 Bologna-Padova"},
	{"11097","Svincolo Paggese"},
	{"11098","Svincolo Palese"},
	{"11099","Svincolo Palese Sud"},
	{"11100","Svincolo Palese-Ss16 Adriatica"},
	{"11101","Svincolo Pantalla"},
	{"11102","Svincolo Paolo Stimolo"},
	{"11103","Svincolo Parolise"},
	{"11104","Svincolo Partinico A29 Palermo-Mazara Del Vallo"},
	{"11105","Svincolo Passignano Est Raccordo Bettolle-Pg"},
	{"11106","Svincolo Passignano Ovest Raccordo Bettolle-Pg"},
	{"11107","Svincolo Patti A20 Messina-Palermo"},
	{"11108","Svincolo Paullo Tangenziale Est Di Milano"},
	{"11109","Svincolo Paullo: Ss415 Paullese-Ss10 Padana Inferiore"},
	{"11110","Svincolo Pavia Lanfranco"},
	{"11111","Svincolo Pavoncelli"},
	{"11112","Svincolo Pecorone/Innesto Ss19 E Ss653"},
	{"11113","Svincolo Pedaso A14 Bo-Ta"},
	{"11114","Svincolo Per A1 Milano-Napoli (Direzione Terni)"},
	{"11115","Svincolo Per A1 Milano-Napoli (Direzione Viterbo)"},
	{"11116","Svincolo Per A14 Bologna-Taranto"},
	{"11117","Svincolo Per Alberoro"},
	{"11118","Svincolo Per Balvano"},
	{"11119","Svincolo Per Camaiore-Innesto Sp25 Morianese"},
	{"11120","Svincolo Per Camponocecchio/Ss76 Var"},
	{"11121","Svincolo Per Gola Della Rossa E Falcioni/Ss76 Var"},
	{"11122","Svincolo Per Laureana Di Borrello"},
	{"11123","Svincolo Per Lavello"},
	{"11124","Svincolo Per Leonessa"},
	{"11125","Svincolo Per Livorno Centro"},
	{"11126","Svincolo Per Livorno Porto"},
	{"11127","Svincolo Per Lucignano-Sp19 Dei Procacci"},
	{"11128","Svincolo Per Mammola"},
	{"11129","Svincolo Per Melicucco"},
	{"11130","Svincolo Per Montagnano"},
	{"11131","Svincolo Per Monte S.Savino"},
	{"11132","Svincolo Per Palazzo S.Gervasio"},
	{"11133","Svincolo Per Pieve Al Toppo-Innesto Ss327"},
	{"11134","Svincolo Per Roglieri"},
	{"11135","Svincolo Per S.Angelo Le Fratte"},
	{"11136","Svincolo Per S.Nicola Di Melfi"},
	{"11137","Svincolo Per S.Oreste"},
	{"11138","Svincolo Per Sp Bastardo"},
	{"11139","Svincolo Per Sp Bettona"},
	{"11140","Svincolo Per Sp Collepepe"},
	{"11141","Svincolo Per Sp S.Martino In Campo"},
	{"11142","Svincolo Per Sp S.Nicolo' Di Celle"},
	{"11143","Svincolo Per Sp73 (carr. Destra)"},
	{"11144","Svincolo Per Sp73 (carr. Sinistra)"},
	{"11145","Svincolo Per Ss2 Cassia-Viterbo Sud"},
	{"11146","Svincolo Per Ss76"},
	{"11147","Svincolo Per Ss81 Piceno Aprutina"},
	{"11148","Svincolo Per Tegoleto"},
	{"11149","Svincolo Per Termennotte"},
	{"11150","Svincolo Per Tuscania-Vetralla"},
	{"11151","Svincolo Per Valtreara/Ss76 Var"},
	{"11152","Svincolo Per Vecchia Ss16 E Variante Di Barletta"},
	{"11153","Svincolo Per Venosa Sud"},
	{"11154","Svincolo Per Verza/Innesto Ss45"},
	{"11155","Svincolo Per Villanova D'asti A21 Torino-Piacenza"},
	{"11156","Svincolo Per Zona Industriale Di Rieti"},
	{"11157","Svincolo Peretola A11 Fi-Pi/Innesto Sgc Fi-Pi-Li"},
	{"11158","Svincolo Pescara Centro"},
	{"11159",""},
	{"11160","Svincolo Piazza Aterno"},
	{"11161","Svincolo Piazza Unione"},
	{"11162","Svincolo Pierantonio"},
	{"11163","Svincolo Pieve S.Stefano Nord"},
	{"11164","Svincolo Pieve S.Stefano Sud"},
	{"11165","Svincolo Pio Spezi"},
	{"11166","Svincolo Piovene Rocchette A31 Vc-Piovene R."},
	{"11167","Svincolo Pisa Nord A11 Firenze-Pisa Nord"},
	{"11168","Svincolo Pisa Nord Est"},
	{"11169","Svincolo Pistoia Centro"},
	{"11170","Svincolo Pistoia Ovest"},
	{"11171","Svincolo Pistoia Sud"},
	{"11172","Svincolo Poggibonsi Raccordo Firenze-Siena"},
	{"11173","Svincolo Polistena"},
	{"11174","Svincolo Polla"},
	{"11175","Svincolo Pompei A3 Na-Sa"},
	{"11176","Svincolo Ponte Cinque Archi A19 Palermo-Catania"},
	{"11177","Svincolo Ponte Felcino"},
	{"11178","Svincolo Ponte Melfa Di Atina-Atina Inferiore"},
	{"11179","Svincolo Ponte Nuovo"},
	{"11180","Svincolo Ponte Pattoli"},
	{"11181","Svincolo Ponte Rio Di Todi"},
	{"11182","Svincolo Ponte S.Giovanni"},
	{"11183","Svincolo Ponte S.Giovanni-Ss3 Bis-Raccordo Orte-Ra"},
	{"11184","Svincolo Pontebba A23 Palmanova-Tarvisio"},
	{"11185","Svincolo Pontedera Est"},
	{"11186","Svincolo Pontedera Ovest-Ponsacco"},
	{"11187","Svincolo Pontina Vecchia"},
	{"11188","Svincolo Pordenone A28 Portogruaro-Pordenone"},
	{"11189","Svincolo Porta Cartara"},
	{"11190","Svincolo Porto D'ascoli - Ss16 Adriatica"},
	{"11191","Svincolo Porto S. Giorgio A14 Bologna-Taranto"},
	{"11192","Svincolo Portogruaro A28 Portogruaro-Pn E A4 To-Ts"},
	{"11193","Svincolo Posta Fibreno-Vicalvi-Fontechiari"},
	{"11194","Svincolo Potenza Raccordo Sicignano-Pz/Innesto Ss92"},
	{"11195","Svincolo Pratica Di Mare/Torvajanica"},
	{"11196","Svincolo Promano"},
	{"11197","Svincolo Quarto"},
	{"11198","Svincolo Raccordo Bettolle-Perugia"},
	{"11199","Svincolo Raccordo Chieti-Pescara"},
	{"11200","Svincolo Raccordo Di Pistoia"},
	{"11201","Svincolo Raccordo Viterbo-Terni"},
	{"11202","Svincolo Ravanusa Nord 'cianciarito'"},
	{"11203","Svincolo Ravanusa Sud"},
	{"11204","Svincolo Ravenna"},
	{"11205","Svincolo Reggio Arangea"},
	{"11206",""},
	{"11207","Svincolo Rendina"},
	{"11208","Svincolo Resina"},
	{"11209","Svincolo Rho Tangenziale Ovest Di Milano"},
	{"11210","Svincolo Ripabianca"},
	{"11211","Svincolo Riserva Nuova/Via Delle Valli"},
	{"11212","Svincolo Rivello/Innesto Ss19 Delle Calabrie"},
	{"11213",""},
	{"11214","Svincolo Rogliano Grimaldi A3 Salerno-Reggio C."},
	{"11215","Svincolo Rogoredo Tangenziale Est Di Milano"},
	{"11216","Svincolo Romagnano Sesia A26 Ge-Gravellona Toce"},
	{"11217","Svincolo Rometta A20 Messina-Palermo"},
	{"11218","Svincolo Rosara - Innesto Ss4 Salaria"},
	{"11219","Svincolo Rosarno A3 Salerno-Reggio C."},
	{"11220","Svincolo Rosarno A3 Sa-Reggio Calabria"},
	{"11221","Svincolo S. Casciano In Val Di Pesa Raccordo Fi-Si"},
	{"11222","Svincolo S. Croce/Innesto Ss630 Ausonia/Innesto Ss7"},
	{"11223","Svincolo S.Carlo"},
	{"11224","Svincolo S.Carlo-Ss3 Flaminia"},
	{"11225","Svincolo S.Damiano"},
	{"11226","Svincolo S.Donato A1 Milano-Napoli"},
	{"11227","Svincolo S.Ferdinando Di Puglia"},
	{"11228","Svincolo S.Ferdinando Di Puglia Nord"},
	{"11229","Svincolo S.Ferdinando Di Puglia Sud"},
	{"11230","Svincolo S.Giovanni A3 Napoli-Salerno"},
	{"11231","Svincolo S.Giovanni Galermo"},
	{"11232","Svincolo S.Giuseppe Della Chiusa"},
	{"11233","Svincolo S.Giustino"},
	{"11234","Svincolo S.Lazzaro Di Savena/Tangenziale Di Bologna"},
	{"11235","Svincolo S.Lucia"},
	{"11236","Svincolo S.Lucia Golosine - Ss62 Della Cisa"},
	{"11237","Svincolo S.Martino"},
	{"11238","Svincolo S.Martino Buonalbergo"},
	{"11239","Svincolo S.Michele A22 Brennero-Modena"},
	{"11240","Svincolo S.Nazzaro"},
	{"11241","Svincolo S.Ninfa A29 Palermo-Mazara Del Vallo"},
	{"11242","Svincolo S.Onofrio-Vibo Valentia A3 Sa-Rc"},
	{"11243","Svincolo S.Piero In Bagno"},
	{"11244","Svincolo S.Samuele"},
	{"11245","Svincolo S.Spirito Nord-Ss16 Adriatica"},
	{"11246","Svincolo S.Spirito-Sp91 S.Spirito-Bitonto"},
	{"11247","Svincolo S.Spirito-Via Enziteto"},
	{"11248","Svincolo S.Vittore"},
	{"11249","Svincolo Sablici-Ss55 Dell'isonzo"},
	{"11250","Svincolo Sacrofanese-Malborghetto"},
	{"11251","Svincolo Sala Consilina"},
	{"11252","Svincolo Salemi A29 Palermo-Mazara Del Vallo"},
	{"11253","Svincolo Salerno Fratte A3 Sa-Rc"},
	{"11254","Svincolo San Gemini Fonte"},
	{"11255","Svincolo San Gemini Nord"},
	{"11256","Svincolo San Gemini Sud"},
	{"11257","Svincolo San Miniato Basso"},
	{"11258","Svincolo Sansepolcro Nord"},
	{"11259","Svincolo Sansepolcro Sud"},
	{"11260","Svincolo Santa Croce Sull'arno"},
	{"11261","Svincolo Santa Severa A12 Roma-Civitavecchia"},
	{"11262","Svincolo Sant'elia Fiumerapido"},
	{"11263","Svincolo Santena Tangenziale Sud Di Torino"},
	{"11264","Svincolo Santhia' A4 Torino-Trieste"},
	{"11265","Svincolo Sarsina Nord"},
	{"11266","Svincolo Sarsina Sud"},
	{"11267","Svincolo Sarzana A12 Genova-Rosignano"},
	{"11268","Svincolo Sasso Marconi A1 Milano-Napoli/Innesto Ss325"},
	{"11269","Svincolo Savarino"},
	{"11270","Svincolo Saxa Rubra"},
	{"11271","Svincolo Scafati Pompei A3 Napoli-Salerno"},
	{"11272","Svincolo Selci"},
	{"11273","Svincolo Seriate/Bagnatica/Brusaporto/Centro Comm.Le"},
	{"11274","Svincolo Serino Raccordo Salerno-Avellino"},
	{"11275","Svincolo Serra S. Quirico"},
	{"11276","Svincolo Serre A3 Salerno-Reggio C."},
	{"11277","Svincolo Sesto S.Giovanni (Diramazione  Nord)"},
	{"11278","Svincolo Sesto S.Giovanni Sud: Cologno M."},
	{"11279","Svincolo Sestri Levante A12/Innesto Ss1 Aurelia"},
	{"11280","Svincolo Sestri Levante A12/Innesto Ss523"},
	{"11281","Svincolo Settebagni Diramazione Roma Nord A1 Mi-Na"},
	{"11282","Svincolo Settignano Di Atina"},
	{"11283",""},
	{"11284","Svincolo Settimo Milanese Tangenziale Ovest Di Milano"},
	{"11285","Svincolo Settimo Milanese-Ss11: S.Siro-Fiera"},
	{"11286","Svincolo Sibari-Spezzano A3 Napoli-Reggio C."},
	{"11287","Svincolo Sinigo-Merano Sud-Innesto Sp101"},
	{"11288","Svincolo Sora Centro"},
	{"11289","Svincolo Sora Nord"},
	{"11290","Svincolo Sora Sud-Broccostella"},
	{"11291","Svincolo Soriano-Chia (Direzione Terni)"},
	{"11292","Svincolo Soriano-Chia (Direzione Viterbo)"},
	{"11293","Svincolo Sottopasso Via Del Tufetto"},
	{"11294","Svincolo Sp Campagnese Per Magliano Romano"},
	{"11295","Svincolo Sp Cerignola-Canosa"},
	{"11296","Svincolo Sp Montoro"},
	{"11297","Svincolo Sp Narni Scalo-Capitone"},
	{"11298","Svincolo Sp Per Collazzone"},
	{"11299","Svincolo Sp Per Marsciano"},
	{"11300","Svincolo Sp S.Ferdinando-Trinitapoli"},
	{"11301","Svincolo Sp113 Cernusco Sul Naviglio"},
	{"11302","Svincolo Sp131 Nova Milanese"},
	{"11303","Svincolo Sp151 Cinisello B.Nord: Zona Industriale"},
	{"11304","Svincolo Sp2 Novara-Cameri"},
	{"11305","Svincolo Sp208 Carugate: Brugherio Nord"},
	{"11306","Svincolo Sp3 Brugherio: Cologno M. Nord"},
	{"11307","Svincolo Sp41 Cascina Morosina: Burago"},
	{"11308","Svincolo Sp44 Milano-Meda: Lentate-Bruzzano"},
	{"11309","Svincolo Sp59 Vigevanese Vecchia: Trezzano"},
	{"11310","Svincolo Sp94 Di Bicinicco"},
	{"11311","Svincolo Spello"},
	{"11312","Svincolo Spirito Santo"},
	{"11313","Svincolo Ss.35 Dei Giovi: Pavia-Rozzano-Assago"},
	{"11314","Svincolo Ss.412 Della Val Tidone: Pavia-Opera"},
	{"11315","Svincolo Ss1 Aurelia  Per Pisa"},
	{"11316","Svincolo Ss11 Padana Superiore E Ss33: Molino Dorino"},
	{"11317","Svincolo Ss16 Adriatica A14dir/Innesto Ss309 Diramazione Romea"},
	{"11318","Svincolo Ss205 Amerina"},
	{"11319","Svincolo Ss219 Di Gubbio E Piandassino"},
	{"11320","Svincolo Ss3 Bis Tiberina-Sgc. Orte-Ra (e45)"},
	{"11321","Svincolo Ss3 Ter Di Narni E S.Gemini"},
	{"11322","Svincolo Ss318 Di Valfabbrica"},
	{"11323","Svincolo Ss33 Del Sempione"},
	{"11324","Svincolo Ss33 Del Sempione: Rho-Pero"},
	{"11325","Svincolo Ss36 Del Lago Di Como: Lecco-Monza"},
	{"11326","Svincolo Ss470 Val Brembana/Ss342 Lecco-Como"},
	{"11327","Svincolo Ss494 Vigevanese Nuova: Lorenteggio"},
	{"11328","Svincolo Ss75 Centrale Umbra"},
	{"11329","Svincolo Ss76 Var"},
	{"11330","Svincolo Ss9 Via Emilia/Montale"},
	{"11331","Svincolo Ss9 Via Emilia: Rogoredo-P.Le Corvetto"},
	{"11332","Svincolo Strada Bobbiese/Innesto Ss654"},
	{"11333","Svincolo Strada Delle Novate"},
	{"11334","Svincolo Strada Farnesiana"},
	{"11335","Svincolo Strada Magnana"},
	{"11336","Svincolo Strada Provinciale Di Via Ortalonga"},
	{"11337","Svincolo Strada Provinciale Passanti-Flocco"},
	{"11338","Svincolo Strampelli"},
	{"11339","Svincolo Sulmona P.Peligna A25 Torano-Pescara"},
	{"11340","Svincolo Tangenziale Di Asti"},
	{"11341","Svincolo Tangenziale Di Cesena"},
	{"11342","Svincolo Taranto A14 Bologna-Taranto"},
	{"11343","Svincolo Tarsia A3 Salerno-Reggio C."},
	{"11344","Svincolo Tavarnelle Val Di Pesa Raccordo Firenze-Siena"},
	{"11345","Svincolo Tavernuzze Raccordo Firenze-Siena"},
	{"11346","Svincolo Teramo A24 Roma-Teramo"},
	{"11347","Svincolo Terlano"},
	{"11348","Svincolo Termini Imerese A19 Palermo-Catania"},
	{"11349","Svincolo Terni Nord"},
	{"11350","Svincolo Terrasini A29 Palermo-Mazara Del Vallo"},
	{"11351","Svincolo Tito Raccordo Sicignano-Potenza"},
	{"11352","Svincolo Tito Raccordo Sicignano-Pz/Innesto Ss94"},
	{"11353","Svincolo Tor De' Cenci"},
	{"11354","Svincolo Torano A3 Salerno-Reggio C."},
	{"11355","Svincolo Torgiano"},
	{"11356","Svincolo Torre Annunziata A3 Na-Sa/Innesto Ss18"},
	{"11357","Svincolo Torre D'isola"},
	{"11358","Svincolo Trabia"},
	{"11359","Svincolo Trani Centro"},
	{"11360","Svincolo Trani Sud"},
	{"11361","Svincolo Trani-Colonna"},
	{"11362","Svincolo Trani-Sp Andria-Trani"},
	{"11363","Svincolo Trani-Sp Monachelle"},
	{"11364","Svincolo Trani-Ss378 Di Altamura-A14 Bo-Ta"},
	{"11365","Svincolo Trani-Zona Industriale"},
	{"11366","Svincolo Trapani A29 Diramazione Alcamo-Trapani"},
	{"11367","Svincolo Tre Monzelli A19 Palermo-Catania"},
	{"11368","Svincolo Tuculia/Innesto Ss626 Del Salso"},
	{"11369","Svincolo Tuoro Raccordo Bettolle-Perugia"},
	{"11370","Svincolo Umbertide"},
	{"11371","Svincolo Usmate-Velate Nord: Merate-Lecco"},
	{"11372","Svincolo Usmate-Velate Sud: Carnate-Paderno"},
	{"11373","Svincolo V. Rubattino: Segrate-Citta' Studi"},
	{"11374","Svincolo Vago Di Lavagno - Ss11 Padana Superiore"},
	{"11375","Svincolo Val Di Chiana A1 Milano-Napoli"},
	{"11376","Svincolo Val Di Sangro A14 Bologna-Taranto"},
	{"11377","Svincolo Val Seriana/Sp69/Pedrengo/Torre De' Roveri"},
	{"11378",""},
	{"11379","Svincolo Valsavignone"},
	{"11380","Svincolo Valsugana/Innesto Ss47"},
	{"11381","Svincolo Valtreara/Ss76"},
	{"11382","Svincolo Vasto Sud A14 Bologna-Taranto"},
	{"11383",""},
	{"11384","Svincolo Ventimiglia A10 Ge-Ventimiglia"},
	{"11385","Svincolo Vercelli A26 Diramazione Stroppiana-Santhia'"},
	{"11386","Svincolo Verghereto"},
	{"11387","Svincolo Vezzano A15 Parma-La Spezia"},
	{"11388","Svincolo Via Aterno"},
	{"11389","Svincolo Via Caboto"},
	{"11390","Svincolo Via Di Decima/Ospedale S.Raffaele"},
	{"11391","Svincolo Via Lia"},
	{"11392","Svincolo Via Magliana Vecchia"},
	{"11393","Svincolo Via Mecenate: Ponte Lambro"},
	{"11394","Svincolo Via Rampinelli"},
	{"11395","Svincolo Viareggio Diramazione Lucca-Viareggio"},
	{"11396","Svincolo Vicarello"},
	{"11397","Svincolo Vicenza Nord A31 Del Valdastico"},
	{"11398","Svincolo Villa Grazia A29 Palermo-Mazara Del Vallo"},
	{"11399","Svincolo Villafranca Tirrena A20 Me-Pa"},
	{"11400",""},
	{"11401","Svincolo Vilpiano-Innesto Sp10 Vilpiano-Tesimo"},
	{"11402","Svincolo Vimercate Centro: Oreno"},
	{"11403","Svincolo Vimercate Nord: Frazione Velasca"},
	{"11404","Svincolo Vimercate Sud: Bg-Trezzo-Arcore"},
	{"11405","Svincolo Viterbo Nord-Innesto Ss2 Cassia"},
	{"11406","Svincolo Viterbo Sud/Innesto Raccordo Vetralla-Viterbo"},
	{"11407","Svincolo Vitorchiano"},
	{"11408","Svincolo Volturara"},
	{"11409","Svincolo Zipa"},
	{"11410","Svincolo Zona Industriale Di Caltanissetta"},
	{"11411","Svincolo 1 Bologna Casalecchio"},
	{"11412","Svincolo 1: Ss1 Via Aurelia"},
	{"11413","Svincolo 10 Zona Industriale Roveri"},
	{"11414","Svincolo 10: Allacciamento Diramazione Roma Nord"},
	{"11415","Svincolo 11 Bis Castenaso-Ravenna"},
	{"11416","Svincolo 11 Ss253 S.Vitale-Ravenna"},
	{"11417","Svincolo 11: Via Nomentana"},
	{"11418","Svincolo 12 Quartiere Mazzini - Ss 65  Delle Futa"},
	{"11419","Svincolo 12: Via S.Alessandro-C.Le Latte"},
	{"11420","Svincolo 13 Ss9 Via Emilia"},
	{"11421","Svincolo 13: Ss5 Via Tiburtina"},
	{"11422","Svincolo 14: Allacciamento A24 Roma-Teramo"},
	{"11423","Svincolo 14: Allacciamento Tronco Penetraz. Urbano"},
	{"11424","Svincolo 15: La Rustica"},
	{"11425","Svincolo 16: Via Prenestina"},
	{"11426","Svincolo 17: Tor Bella Monaca"},
	{"11427","Svincolo 18: Ss6 Via Casilina"},
	{"11428","Svincolo 19: Allacciamento Diramazione Roma Sud"},
	{"11429","Svincolo 2 Bologna Centro-Bo Borgo Panigale"},
	{"11430","Svincolo 2: Via Di Boccea"},
	{"11431","Svincolo 20: La Romanina"},
	{"11432","Svincolo 21: Ss215 Via Tuscolana"},
	{"11433","Svincolo 22: Ss511 Via Anagnina"},
	{"11434","Svincolo 23: Ss7 Via Appia"},
	{"11435","Svincolo 24: Via Ardeatina"},
	{"11436","Svincolo 25: Via Laurentina"},
	{"11437","Svincolo 26: Ss148 Via Pontina"},
	{"11438","Svincolo 27: Via C.Colombo"},
	{"11439","Svincolo 28: Ss8 Via Del Mare-V.Ostiense"},
	{"11440","Svincolo 3 Allacciamento Ramo Verde-Via Emilia"},
	{"11441","Svincolo 3: Ss2 Via Cassia"},
	{"11442","Svincolo 30: Allacciamento Autos. Per Aeroporto Fiumicino"},
	{"11443","Svincolo 31: Via Della Magliana"},
	{"11444","Svincolo 32: Via Della Pisana"},
	{"11445","Svincolo 33: Via Del Pescaccio"},
	{"11446","Svincolo 4 Aeroporto Bologna Borgo Panigale"},
	{"11447","Svincolo 5 Bologna Quartiere Lame"},
	{"11448","Svincolo 5: Ss2bis Cassia Veientana"},
	{"11449","Svincolo 6 Castelmaggiore"},
	{"11450","Svincolo 6: Ss3 Via Flaminia"},
	{"11451","Svincolo 7 Bis Per Ferrara"},
	{"11452","Svincolo 7 Bologna Centro-V.Stalingrado"},
	{"11453","Svincolo 7: Castel Giubileo"},
	{"11454","Svincolo 8 Fiera-Via Michelino"},
	{"11455","Svincolo 8: Ss4 Via Salaria"},
	{"11456","Svincolo 9 San Donato"},
	{"11457","Svincolo 9: Via Di Settebagni-Bel Poggio"},
	{"11458","Svincolo Buccino Raccordo Sicignano-Potenza"},
	{"11459","Svincolo Castellammare Del G.Fo A29 Pa-Mazara Del V."},
	{"11460","Svincolo Gravellona Toce-Ss34 Lago Maggiore"},
	{"11461","Svincolo Padula Buonabitacolo A3 Salerno-Reggio C."},
	{"11462",""},
	{"11463","Svincolo Aosta Ovest-Aymavilles"},
	{"11464","Svincolo Autoporto S.I.T.O."},
	{"11465","Svincolo Bereguardo"},
	{"11466","Svincolo Candiolo"},
	{"11467","Svincolo Centro Direzionale"},
	{"11468","Svincolo Cesena"},
	{"11469","Svincolo Chieti A25 Torano-Pescara"},
	{"11470","Svincolo Contigliano"},
	{"11471","Svincolo Corso Francia-Cascine Vica"},
	{"11472","Svincolo Corso Iv Novembre"},
	{"11473","Svincolo Debouche'"},
	{"11474","Svincolo Di Arese"},
	{"11475","Svincolo Di Assago"},
	{"11476","Svincolo Di Asti Nord"},
	{"11477","Svincolo Di Bari Zona Industriale"},
	{"11478","Svincolo Di Baveno"},
	{"11479","Svincolo Di Binasco"},
	{"11480","Svincolo Di Brennero"},
	{"11481","Svincolo Di Busto Arsizio"},
	{"11482","Svincolo Di Caorso"},
	{"11483","Svincolo Di Carpugnino"},
	{"11484","Svincolo Di Casoria"},
	{"11485","Svincolo Di Casoria:strada Provinciale 1"},
	{"11486","Svincolo Di Castellanza"},
	{"11487","Svincolo Di Castronno"},
	{"11488","Svincolo Di Cavaria"},
	{"11489","Svincolo Di Cerveteri-Ladispoli"},
	{"11490","Svincolo Di Civitavecchia Nord"},
	{"11491","Svincolo Di Como Monte Olimpino"},
	{"11492","Svincolo Di Como Nord"},
	{"11493","Svincolo Di Como Sud"},
	{"11494","Svincolo Di Cormano"},
	{"11495","Svincolo Di Cortemaggiore"},
	{"11496","Svincolo Di Duino"},
	{"11497","Svincolo Di Fiano Romano"},
	{"11498","Svincolo Di Fino Mornasco"},
	{"11499","Svincolo Di Gallarate"},
	{"11500","Svincolo Di Gazzada-Lago Di Varese"},
	{"11501",""},
	{"11502","Svincolo Di Lainate"},
	{"11503","Svincolo Di Legnano"},
	{"11504",""},
	{"11505","Svincolo Di Lomazzo"},
	{"11506","Svincolo Di Lunghezza"},
	{"11507","Svincolo Di Marcon"},
	{"11508","Svincolo Di Melegnano"},
	{"11509","Svincolo Di Modugno"},
	{"11510","Svincolo Di Mogliano Veneto"},
	{"11511","Svincolo Di Origgio"},
	{"11512","Svincolo Di Origgio Ovest"},
	{"11513","Svincolo Di Padova"},
	{"11514","Svincolo Di Pero"},
	{"11515",""},
	{"11516","Svincolo Di Ponte Suero"},
	{"11517","Svincolo Di Ponticelli"},
	{"11518","Svincolo Di Ponticolo"},
	{"11519","Svincolo Di Ravenna - S.Vitale"},
	{"11520","Svincolo Di Rosignano Marittimo"},
	{"11521","Svincolo Di S. Giuliano"},
	{"11522","Svincolo Di S.Donato"},
	{"11523","Svincolo Di S.Nicolo' A Tordino"},
	{"11524","Svincolo Di S.Severa-S.Marinella"},
	{"11525","Svincolo Di Santena"},
	{"11526","Svincolo Di Saronno"},
	{"11527","Svincolo Di Sesto Fiorentino"},
	{"11528","Svincolo Di Settebagni"},
	{"11529","Svincolo Di Solbiate Arno"},
	{"11530",""},
	{"11531","Svincolo Di Tarvisio Nord"},
	{"11532","Svincolo Di Tarvisio Sud"},
	{"11533","Svincolo Di Teramo"},
	{"11534","Svincolo Di Terme Di Brennero"},
	{"11535","Svincolo Di Torrenova"},
	{"11536","Svincolo Di Turate"},
	{"11537",""},
	{"11538","Svincolo Di Vezzano"},
	{"11539","Svincolo Di Via Fiorentini"},
	{"11540","Svincolo Di Via Togliatti"},
	{"11541",""},
	{"11542","Svincolo Gerbole"},
	{"11543","Svincolo Greccio"},
	{"11544",""},
	{"11545","Svincolo Malborghetto-Valbruna"},
	{"11546",""},
	{"11547","Svincolo None"},
	{"11548",""},
	{"11549","Svincolo Orbassano"},
	{"11550","Svincolo Pavia Nord"},
	{"11551","Svincolo Pavia Sud"},
	{"11552","Svincolo Per Baganzola"},
	{"11553","Svincolo Per Corso Allamano"},
	{"11554","Svincolo Per Trinita'-Bene Vagienna"},
	{"11555","Svincolo Per Via Della Barchetta"},
	{"11556","Svincolo Policlinico"},
	{"11557","Svincolo Rieti Ovest"},
	{"11558","Svincolo Rotatoria Castellana"},
	{"11559","Svincolo Rotatoria Marghera"},
	{"11560","Svincolo Rotatoria Miranese"},
	{"11561","Svincolo S.Giovanni In Persiceto"},
	{"11562","Svincolo S.Martino Siccomario-Ss596"},
	{"11563","Svincolo S.S.16 Adriatica"},
	{"11564","Svincolo S.S.9 Via Emilia-Poasco"},
	{"11565","Svincolo Sesto San Giovanni-Viale Zara"},
	{"11566",""},
	{"11567","Svincolo Sistiana"},
	{"11568","Svincolo Ss 9 Via Emilia"},
	{"11569","Svincolo Ss.1 Aurelia"},
	{"11570",""},
	{"11571","Svincolo Ss64 Porrettana"},
	{"11572","Svincolo Stupinigi"},
	{"11573","Svincolo Terraglio"},
	{"11574","Svincolo Universita'"},
	{"11575","Svincolo Via Leonardo (ss343)"},
	{"11576","Svincolo Via Mantolla"},
	{"11577","Svincolo Via Moletolo"},
	{"11578","Svincolo Via Paradigna"},
	{"11579","Svincolo Via Venezia"},
	{"11580","Svincolo Volvera"},
	{"11581","Svincolo Zona Industriale"},
	{"11582","Svizzera"},
	{"11583","Tabaccaro"},
	{"11584","Tabina Di Santa Maria Di Sala"},
	{"11585","Taccone"},
	{"11586","Taccone Di Mezzo - Innesto Ss1bis Via Aurelia"},
	{"11587","Taccone Di Mezzo/Innesto Ss1 Bis Via Aurelia"},
	{"11588","Taccone Di Mezzo/Innesto Ss1 Via Aurelia"},
	{"11589","Tagliacozzo"},
	{"11590","Tagliacozzo - Innesto Ss5 Quater Dir"},
	{"11591","Tagliacozzo/Innesto Ss5 Quater"},
	{"11592","Tagliacozzo/Innesto Ss5 Tiburtina Valeria"},
	{"11593","Tai Di Cadore"},
	{"11594","Tai Di Cadore/Innesto Ss51 Bis Di Alemagna"},
	{"11595","Tai Di Cadore/Innesto Ss51 Di Alemagna"},
	{"11596","Taio"},
	{"11597","Taizzano"},
	{"11598","Tambre"},
	{"11599","Tangenziale Bo"},
	{"11600","Tangenziale Di Bari"},
	{"11601","Tangenziale Di Bologna"},
	{"11602","Tangenziale Est Di Milano-P.Le Corvetto"},
	{"11603","Tangenziale Napoli"},
	{"11604","Tangenziale Nord"},
	{"11605","Tangenziale Ovest"},
	{"11606","Tangenziale Palermo"},
	{"11607","Tangenz. Est"},
	{"11608","Tangenziale Di Ascoli"},
	{"11609","Tangenziale Di Asti"},
	{"11610","Tangenziale Di Bologna"},
	{"11611","Tangenziale Di Canicatti'"},
	{"11612","Tangenziale Di Catania"},
	{"11613","Tangenziale Di Foggia"},
	{"11614","Tangenziale Di Modena"},
	{"11615","Tangenziale Di Napoli"},
	{"11616","Tangenziale Di Novara"},
	{"11617","Tangenziale Di Palermo"},
	{"11618","Tangenziale Di Parma (ss9)"},
	{"11619","Tangenziale Di Pavia"},
	{"11620","Tangenziale Di Piacenza"},
	{"11621","Tangenziale Di Potenza"},
	{"11622","Tangenziale Di Siena"},
	{"11623","Tangenziale Di Varese"},
	{"11624","Tangenziale Est"},
	{"11625","Tangenziale Est Di Milano"},
	{"11626","Tangenziale Nord Di Milano"},
	{"11627","Tangenziale Nord Di Torino"},
	{"11628","Tangenziale Ovest Di Milano"},
	{"11629","Tangenziale Sud Di Torino"},
	{"11630","Tangenziale Sud Di Treviso"},
	{"11631","Tangenziale Sud Di Udine"},
	{"11632","Tangenziale Sud Di Verona"},
	{"11633","Taormina"},
	{"11634","Taranto"},
	{"11635","Taranto - Bivio Statte"},
	{"11636","Taranto - Galese - Innesto Ss172"},
	{"11637","Taranto - Innesto Ss106 - Innesto Ss7"},
	{"11638","Taranto Centro"},
	{"11639","Taranto Galese Staz./Innesto Raccordo Ta-Grottaglie"},
	{"11640","Taranto/Innesto Raccordo Ta-Grottaglie E Ss7 Appia"},
	{"11641","Taranto/Innesto Ss106 Jonica/InnestoRaccordo Ta-Grottaglie"},
	{"11642","Taranto/Innesto Ss7 Appia"},
	{"11643","Taranto/Masseria S.Paolo"},
	{"11644","Taranto/Punta Penna"},
	{"11645","Tarcento"},
	{"11646","Tarces"},
	{"11647","Tarquinia"},
	{"11648","Tarsia"},
	{"11649","Tarsia/Innesto Ss19 Delle Calabrie"},
	{"11650","Tarsia/Innesto Ss533 Di Fagnano"},
	{"11651","Tarvisio"},
	{"11652","Tarvisio Alto/Innesto Ss13 Pontebbana"},
	{"11653","Tarvisio Alto/Innesto Ss13 Racc Pontebbana"},
	{"11654","Tarvisio/Innesto Ss13 Racc Pontebbana"},
	{"11655","Tarvisio/Innesto Ss54 Del Friuli"},
	{"11656","Tarzo"},
	{"11657","Taurianova"},
	{"11658","Taurianova/Innesto Ss111 Diramazione E Ss536 Di Acquaro"},
	{"11659","Taurianova/Innesto Ss111 E Ss111 Dir"},
	{"11660","Taurianova/Innesto Ss111 E Ss536 Di Acquaro"},
	{"11661","Taurisano/Innesto Ss474 Di Taurisano"},
	{"11662","Taurisano/Innesto Ss475 Di Casarano"},
	{"11663","Tavarnelle"},
	{"11664","Tavarnelle (Direzione Firenze)"},
	{"11665","Tavarnelle (Direzione Siena)"},
	{"11666","Tavarnelle Val Di Pesa"},
	{"11667","Tavazzano Con Villavesco"},
	{"11668","Taverna"},
	{"11669","Taverna Piccinini/Innesto Ss4 Salaria"},
	{"11670","Taverna Piccinini/Innesto Ss78 Picena"},
	{"11671","Taverna Pugliese"},
	{"11672","Taverna Ravindola/Innesto Ss85 Venafrana"},
	{"11673","Taverna Rocca Ravindola/Innesto Ss158 V. Del Volturno"},
	{"11674","Taverna Spartimento/Innesto Ss6 Casilina"},
	{"11675","Taverna Spartimento/Innesto Ss7 Via Appia"},
	{"11676","Taverna/Innesto Ss430 Valle Del Garigliano"},
	{"11677","Taverna/Innesto Ss6 Casilina"},
	{"11678","Tavernanova"},
	{"11679","Taverne"},
	{"11680","Taverne D'arbia/Innesto Raccordo Si-Bettolle E Ss438"},
	{"11681","Taverne D'arbia/Innesto Raccordo Si-Bettolle E Ss73"},
	{"11682","Tavernelle"},
	{"11683","Tavernola Bergamasca"},
	{"11684","Tavernole Sul Mella"},
	{"11685","Tavernuzze"},
	{"11686","Taviano"},
	{"11687","Taviano E"},
	{"11688","Taviano N"},
	{"11689","Teano"},
	{"11690","Teglia"},
	{"11691","Tegoleto"},
	{"11692","Tel"},
	{"11693","Telese Terme"},
	{"11694","Telesina"},
	{"11695","Teliseri"},
	{"11696","Telti"},
	{"11697","Tempio Pausania"},
	{"11698","Tempio Pausania/Innesto Ss127 Settent. Sarda"},
	{"11699","Tempio Pausania/Innesto Ss127 Settentrionale Sarda"},
	{"11700","Tempio Pausania/Innesto Ss133 Di Palau"},
	{"11701","Tempio Pausania/Innesto Ss392 Del Lago Di Coghinas"},
	{"11702","Temu'"},
	{"11703","Tendola"},
	{"11704","Teora"},
	{"11705","Teora/Innesto Ss165 Di Mater Domini"},
	{"11706","Teora/Innesto Ss7 Appia"},
	{"11707","Ter Adriatica"},
	{"11708","Ter Del Rabbi"},
	{"11709","Ter Della Piccola Sila"},
	{"11710","Ter Dell'appennino Abruzzese"},
	{"11711","Ter Di Narni E San Gemini"},
	{"11712","Ter Diramazione Irpina"},
	{"11713","Ter Dorsale Aulettese"},
	{"11714","Ter Jonica"},
	{"11715","Ter Salentina"},
	{"11716","Ter Silana Di Cariati"},
	{"11717","Ter Sud Occidentale Sicula"},
	{"11718","Ter Tiburtina Valeria"},
	{"11719","Teramo"},
	{"11720","Teramo/Innesto Ss80 Del Gran Sasso D'italia"},
	{"11721","Teramo/Innesto Ss81 Picena Aprutina"},
	{"11722","Teramo-Giulianova-Mosciano"},
	{"11723","Terlano"},
	{"11724","Terme Euganee"},
	{"11725","Terme Forlenza/Innesto Ss91 Della Valle Del Sele"},
	{"11726","Terme Forlenza/Innesto Ss91racc Della V. Del Sele"},
	{"11727","Terme Luigiane"},
	{"11728","Terme Luigiane/Incrocio Ss18 Tirrena Inferiore"},
	{"11729","Terme Luigiane/Incrocio Ss283 Delle Terme Luigiane"},
	{"11730","Termine Abitato Di Sestri Levante"},
	{"11731","Termine Di Roverano"},
	{"11732","Termini Imerese"},
	{"11733","Termini Imerese/Innesto Ss113 Settentrionale Sicula"},
	{"11734","Termini Imerese/Innesto Ss285 Di Caccamo"},
	{"11735","Terminillo"},
	{"11736","Termo"},
	{"11737","Termolese"},
	{"11738","Termoli/Innesto Ss16 Adriatica"},
	{"11739","Termoli/Innesto Ss483 Termolese"},
	{"11740","Termoli/Innesto Ss87 Sannitica"},
	{"11741","Termoli-Molise"},
	{"11742","Ternana"},
	{"11743","Terni"},
	{"11744","Terni/Innesto Ss209 Valnerina E Ss79"},
	{"11745","Terni/Innesto Ss3 Flaminia"},
	{"11746","Terni/Innesto Ss3 Flaminia E Ss209 Valnerina"},
	{"11747","Terni/Innesto Ss3 Flaminia E Ss79 Ternana"},
	{"11748","Terni/Innesto Ss313 Di Passo Corese"},
	{"11749","Terni/Svincolo Raccordo Terni-Orte"},
	{"11750","Terra Del Sole"},
	{"11751","Terra Pelata"},
	{"11752","Terracina"},
	{"11753","Terracina/Innesto Ss213 Via Flacca"},
	{"11754","Terracina/Innesto Ss7 Appia"},
	{"11755","Terracina/Innesto Ss7 Appia"},
	{"11756","Terralba"},
	{"11757","Terranova"},
	{"11758","Terranova Da Sibari"},
	{"11759","Terranova Di Pollino"},
	{"11760","Terranova Sappo Minulio"},
	{"11761","Terrarossa"},
	{"11762","Terrasini"},
	{"11763","Terrenove"},
	{"11764","Tertenia"},
	{"11765","Terzigno"},
	{"11766","Tesero"},
	{"11767","Tesina Sud"},
	{"11768","Tessera"},
	{"11769","Testaccio"},
	{"11770","Teulada"},
	{"11771","Tevere"},
	{"11772","Teverina Scalo"},
	{"11773","Teverola - Innesto Ss7 Bis Di Terra Di Lavoro"},
	{"11774","Teverola/Innesto Ss7 Bis Di Terra Di Lavoro"},
	{"11775","Teverola/Innesto Ss7bis/Diramazione Di Villa Literno"},
	{"11776","Tezze"},
	{"11777","Tangenziale Est Milano"},
	{"11778","Thiene"},
	{"11779","Thiene/Innesto Raccordo Thiene-Bassano"},
	{"11780","Thiesi"},
	{"11781","Thorl/Confine Con L'austria"},
	{"11782","Tiana"},
	{"11783","Tiarno Di Sopra"},
	{"11784","Tiarno Di Sotto"},
	{"11785","Tiburtina Sud"},
	{"11786","Ticengo"},
	{"11787","Ticinese"},
	{"11788","Tiera/Tratto In Comune Con Ss93 Appulo-Lucana"},
	{"11789","Tindari"},
	{"11790","Tinnura"},
	{"11791","Tiolo"},
	{"11792","Tione Di Trento"},
	{"11793","Tione Di Trento/Innesto Ss237 Del Caffaro"},
	{"11794","Tione Di Trento/Innesto Ss239 Di Campiglio"},
	{"11795","Tirano"},
	{"11796","Tiriolo"},
	{"11797","Tirrena Inferiore"},
	{"11798","Tirrenia"},
	{"11799","Tirreno"},
	{"11800","Tito"},
	{"11801","Tito Scalo"},
	{"11802","Tito/Innesto Ss95 Di Brienza E Raccordo Sicignano-Pz"},
	{"11803","Tivoli"},
	{"11804","Tivoli/Innesto Ss5 Tiburtina Valeria"},
	{"11805","Tivoli/Innesto Ss636 Di Palombara"},
	{"11806","Todi"},
	{"11807","To-Eliporto"},
	{"11808","Tola"},
	{"11809","Tolentino"},
	{"11810","Tolfa"},
	{"11811","Toline"},
	{"11812","Tolmezzo"},
	{"11813","Tolmezzo/Innesto Ss512 Del Lago Di Cavazzo"},
	{"11814","Tolmezzo/Innesto Ss52 Bis Carnica"},
	{"11815","Tolmezzo/Innesto Ss52 Carnica"},
	{"11816","Tolve"},
	{"11817","Tomaini"},
	{"11818","Tonadico"},
	{"11819","Tonale"},
	{"11820","Tonara"},
	{"11821","Tor Di Mezzavia - Innesto Ss215 Tuscolana"},
	{"11822","Torano"},
	{"11823","Torano-Pescara"},
	{"11824","Torbole"},
	{"11825","Torbole/Innesto Ss240 Di Loppio E Di Val Di Ledro"},
	{"11826","Torbole/Innesto Ss249 Gardesana Orientale"},
	{"11827","Torchiati"},
	{"11828","Torella Dei Lombardi"},
	{"11829","Torella Dei Lombardi/Innesto Ss400 Di Castelvetere"},
	{"11830","Torella Dei Lombardi/Innesto Ss428 Di Villamaina"},
	{"11831","Torella Del Sannio"},
	{"11832","Torelli/Innesto Ss7 Bis Di Terra Di Lavoro"},
	{"11833","Torino"},
	{"11834","Torino - Corso Grosseto"},
	{"11835","Torino - Corso Orbassano"},
	{"11836","Torino Di Sangro"},
	{"11837","Torino-Bardonecchia"},
	{"11838","Torino-C.So Unita' D'italia-A6 To Sv"},
	{"11839",""},
	{"11840",""},
	{"11841","Torino-Piacenza-Brescia"},
	{"11842","Torino-Savona"},
	{"11843","Torino-Trieste"},
	{"11844","Toritto"},
	{"11845","Tornareccio"},
	{"11846","Tornello"},
	{"11847","Torniella"},
	{"11848","Tornimparte"},
	{"11849","Torno"},
	{"11850","Torre Alemanna"},
	{"11851","Torre Annunziata"},
	{"11852","Torre Annunziata Nord"},
	{"11853","Torre Annunziata/Innesto Ss145 Sorrentina"},
	{"11854","Torre Annunziata/Innesto Ss18 Tirrena Inferiore"},
	{"11855","Torre Annunziata/Svincolo A3 Na-Sa E Innesto Ss268"},
	{"11856","Torre Beretti"},
	{"11857","Torre Canne"},
	{"11858","Torre Cerrano"},
	{"11859","Torre D.Mangano/Innesto Ss35 Diramazione Dei Giovi"},
	{"11860","Torre Del Colle/Innesto Ss263 Di Val Di Foro"},
	{"11861","Torre Del Colle/Innesto Ss539 Di Manoppello"},
	{"11862","Torre Del Greco"},
	{"11863","Torre Del Greco Nord"},
	{"11864","Torre Del Mare"},
	{"11865","Torre Del Vento"},
	{"11866","Torre Dell'orso"},
	{"11867","Torre Di Jesi"},
	{"11868","Torre Di Mangano (certosa)"},
	{"11869","Torre Di Taglio E S.Elpidio"},
	{"11870","Torre Fantine"},
	{"11871","Torre Faro"},
	{"11872","Torre Mangano/Innesto Ss35 Dei Giovi"},
	{"11873","Torre Orsaia"},
	{"11874","Torre Orsaia/Innesto Ss18 Tirrena Inferiore"},
	{"11875","Torre Orsaia/Innesto Ss517 Bussentina"},
	{"11876","Torre Pedrera"},
	{"11877","Torre Rivoli/Innesto Ss159 Delle Saline"},
	{"11878","Torre Rivoli/Innesto Ss545 Rivolese"},
	{"11879","Torre S.Anna"},
	{"11880","Torre Specchia Ruggeri"},
	{"11881","Torre Spineto/Innesto Ss179 Del Lago Ampollino"},
	{"11882","Torre Spineto/Innesto Ss179 Diramazione Del Lago Ampollino"},
	{"11883","Torrebelvicino"},
	{"11884","Torrebruna"},
	{"11885","Torrenieri"},
	{"11886","Torrenova"},
	{"11887","Torrente Candelaro/Innesto Ss273 Candelarese"},
	{"11888","Torretta"},
	{"11889","Torretta/Innesto Ss10 Padana Inferiore"},
	{"11890","Torretta/Innesto Ss458 Di Casalborgone"},
	{"11891","Torrevecchia Pia"},
	{"11892","Torri Del Benaco"},
	{"11893","Torri Di Quartesolo"},
	{"11894","Torriana"},
	{"11895","Torricella"},
	{"11896","Torricella Verzate"},
	{"11897","Torriglia"},
	{"11898","Torrimpietra"},
	{"11899","Torrita Di Siena"},
	{"11900","Torrita Di Siena/Innesto Ss326 Di Rapolano"},
	{"11901","Torrita Di Siena/Innesto Ss327 Di Foiano"},
	{"11902","Tortoli'"},
	{"11903","Tortoli'/Innesto Ss125 Diramazione Orientale Sarda"},
	{"11904","Tortoli'/Innesto Ss125 Orientale Sarda"},
	{"11905","Tortoli'/Innesto Ss198 Di Seui E Lanusei"},
	{"11906","Tortona"},
	{"11907","Tortona/Innesto Ss10 Padana Inferiore"},
	{"11908","Tortona/Innesto Ss10 Padana Inferiore"},
	{"11909","Tortona/Innesto Ss211 Della Lomellina"},
	{"11910","Tortoreto"},
	{"11911","Tortoreto Lido"},
	{"11912","Tortorici/Innesto Ss188 Centro Occ. Sicula"},
	{"11913","Tortorici/Innesto Ss188 Dir/C Centro Occ. Sicula"},
	{"11914","Torvaianica"},
	{"11915","Torza"},
	{"11916","Toscana"},
	{"11917","Toscanella"},
	{"11918","Tosco Romagnola"},
	{"11919","Toscolano"},
	{"11920","Tossicia"},
	{"11921","Tovena"},
	{"11922","Tozzaga"},
	{"11923","Trabia"},
	{"11924","Trafoi"},
	{"11925","Traforo Bargagli-Ferriere"},
	{"11926","Traforo Del Frejus"},
	{"11927","Traforo Del Gran S.Bernardo"},
	{"11928","Traforo Del Monte Bianco"},
	{"11929","Tramatza"},
	{"11930","Tramonti Di Sopra"},
	{"11931","Tramonti Di Sotto"},
	{"11932","Tramutola/Innesto Ss276 Dell'alto Agri"},
	{"11933","Tramutola/Innesto Ss276 Diramazione Dell'alto Agri"},
	{"11934","Trana"},
	{"11935","Trani"},
	{"11936","Trani Sud/Innesto Asse Attr. Cerignola-Bari"},
	{"11937","Trani/Innesto Ss16 Adriatica"},
	{"11938","Trani/Innesto Ss378 Di Altamura"},
	{"11939","Transacqua"},
	{"11940","Transpolesana"},
	{"11941","Traona"},
	{"11942","Trapani"},
	{"11943","Trapani/Innesto Ss113 Settentrionale Sicula"},
	{"11944","Trapani/Innesto Ss115 Sud Occidentale Sicula"},
	{"11945","Trapani/Innesto Ss187 Di Castellammare Del Golfo"},
	{"11946","Trappa"},
	{"11947","Trappeto"},
	{"11948","Trappeto Bambino"},
	{"11949","Trappitello"},
	{"11950","Trasaghis"},
	{"11951","Trasanni"},
	{"11952","Trasversale Sarda"},
	{"11953","Tratto Urbano A24"},
	{"11954","Travedona/Monate"},
	{"11955","Travedona-Monate"},
	{"11956","Traversa Di Mugello"},
	{"11957","Traversa Di Pracchia"},
	{"11958","Traversa Interna Di Pistoia"},
	{"11959","Traversa Maremmana"},
	{"11960","Traversetolo"},
	{"11961","Tre Monzelli"},
	{"11962","Tre Ponti"},
	{"11963","Tre Ponti/Innesto Ss52 Carnica"},
	{"11964","Tre Ponti/Innesto Ss619 Di Vigo Di Cadore"},
	{"11965","Tre Re"},
	{"11966","Trebaseleghe"},
	{"11967","Trebbio"},
	{"11968","Trebisacce"},
	{"11969","Trecate"},
	{"11970","Tremestieri-A20"},
	{"11971","Tremestrieri Ovest"},
	{"11972","Tremezzo"},
	{"11973","Tremoli"},
	{"11974","Trens"},
	{"11975","Trentino Alto Adige"},
	{"11976","Trento"},
	{"11977","Trento Centro"},
	{"11978","Trento Centro(entrata Direzione Sud)"},
	{"11979","Trento Nord"},
	{"11980","Trento/Innesto Ss12 Dell'abetone E Del Brennero"},
	{"11981","Trento/Innesto Ss349 Val D'assa-Pedemontana Costo"},
	{"11982","Trento/Innesto Ss45 Bis Gardesana Occ."},
	{"11983","Trepalle"},
	{"11984","Trepido' Soprano"},
	{"11985","Trepido' Sottano"},
	{"11986","Treponti"},
	{"11987","Trepunti"},
	{"11988","Trepuzzi"},
	{"11989","Tresche' Conca"},
	{"11990","Tresenda"},
	{"11991","Tresenda/Innesto Ss38 Dello Stelvio"},
	{"11992","Tresenda/Innesto Ss39 Del Passo D'aprica"},
	{"11993","Tresnuraghes"},
	{"11994","Treviglio"},
	{"11995","Treviglio/Incrocio Ss11 Padana Superiore"},
	{"11996","Treviglio/Innesto Ss11 Padana Superiore"},
	{"11997","Treviglio/Innesto Ss42 Del Tonale E Della Mendola"},
	{"11998","Treviglio/Innesto Ss472 Bergamina"},
	{"11999","Treviolo"},
	{"12000","Treviso"},
	{"12001","Treviso Nord"},
	{"12002","Treviso Sud"},
	{"12003","Treviso/Incrocio Ss13 Pontebbana"},
	{"12004","Treviso/Innesto Ss53 Carnica E Ss348 Feltrina"},
	{"12005","Treviso/Innesto Ss53 Postumia"},
	{"12006","Treviso/Innesto Ss53 Postumia E Ss515 Noalese"},
	{"12007","Treviso/Innesto Ss348 Feltrina E Ss515 Noalese"},
	{"12008","Trevozzo"},
	{"12009","Trezzo"},
	{"12010","Triana"},
	{"12011","Tricarico"},
	{"12012","Tricase Porto"},
	{"12013","Tricerro"},
	{"12014","Tricesimo"},
	{"12015","Trichiana"},
	{"12016","Trieste"},
	{"12017","Trieste/Innesto Ss14 Della Venezia Giulia"},
	{"12018","Trieste/Innesto Ss15 Via Flavia"},
	{"12019","Trieste/Innesto Ss202 Triestina"},
	{"12020","Trieste-Molo Vii"},
	{"12021","Trieste-Via Servola"},
	{"12022","Triestina"},
	{"12023","Triflisco"},
	{"12024","Trigno"},
	{"12025","Trinita'"},
	{"12026","Trinitapoli"},
	{"12027","Trino"},
	{"12028","Trino/Incrocio Ss455 Di Pontestura"},
	{"12029","Trino/Innesto Ss31 Bis Del Monferrato"},
	{"12030","Triponzo/Innesto Ss209 Valnerina"},
	{"12031","Triponzo/Innesto Ss320 Di Cascia"},
	{"12032","Triulzo"},
	{"12033","Trivero"},
	{"12034","Trivignano"},
	{"12035","Trivio"},
	{"12036","Trivio Di Fuentes/Innesto Ss36 Del Lago Di Como"},
	{"12037","Trodica"},
	{"12038","Trodica-Villa S.Filippo"},
	{"12039","Trofarello"},
	{"12040","Troia/Innesto Ss546 Troiana"},
	{"12041","Troiana"},
	{"12042","Troiano"},
	{"12043","Troina"},
	{"12044","Troina/Innesto Ss120 Dell'etna E Delle Madonie"},
	{"12045","Troina/Innesto Ss575 Di Troina"},
	{"12046","Tromello"},
	{"12047",""},
	{"12048","Tronzano Vercellese"},
	{"12049","Tropea"},
	{"12050","Troppola"},
	{"12051","Trovamola"},
	{"12052","Trucchi"},
	{"12053","Trucco"},
	{"12054","Trullo Masseria"},
	{"12055","Tubre"},
	{"12056","Tufara"},
	{"12057","Tufo"},
	{"12058","Tugo"},
	{"12059","Tuoro"},
	{"12060","Tuoro Sul Trasimeno"},
	{"12061","Turbigo"},
	{"12062","Turchino"},
	{"12063","Turi"},
	{"12064","Turrida"},
	{"12065","Tuscolana"},
	{"12066","Uboldo"},
	{"12067","Ucria"},
	{"12068","Udine"},
	{"12069","Udine Nord"},
	{"12070","Udine Sud-Tangenziale"},
	{"12071","Udine/Innesto Ss13 Pontebbana E Ss54 Del Friuli"},
	{"12072","Udine/Innesto Ss353 Della Bassa Friulana"},
	{"12073","Udine/Innesto Ss464 Di Spilimbergo E Ss13"},
	{"12074","Udine/Innesto Ss54 Del Friuli"},
	{"12075","Udine/Innesto Ss54 Del Friuli/ Ss464 Di Spilimbergo"},
	{"12076","Udine/Innesto Ss56 Di Gorizia"},
	{"12077","Uggiano La Chiesa"},
	{"12078","Umbria"},
	{"12079","Umbro Casentinese Romagnola"},
	{"12080","Ummari"},
	{"12081","Urago D'oglio/Innesto Ss11 Padana Superiore"},
	{"12082","Urago D'oglio/Innesto Ss469 Sebina Occidentale"},
	{"12083","Urago/Innesto Ss342 Briantea"},
	{"12084","Urago/Innesto Ss639 Dei Laghi Di Pusiano E Garlate"},
	{"12085","Uras/Innesto Ss131 Di Carlo Felice"},
	{"12086","Uras/Innesto Ss442 Di Laconi E Di Uras"},
	{"12087","Urbania"},
	{"12088","Urbinate"},
	{"12089","Urbino"},
	{"12090","Urbino/Innesto Ss423 Urbinate"},
	{"12091","Urbino/Innesto Ss73bis Di Bocca Trabaria"},
	{"12092","Urgnano"},
	{"12093","Ururi"},
	{"12094","Uscio"},
	{"12095","Uscita Pomezia"},
	{"12096","Uscita Pomezia Centro/Castelli Romani"},
	{"12097","Uscita Pomezia Sud/Maggiona"},
	{"12098","Via Decima-Castel Porziano (direzione Rm)"},
	{"12099","Usmate"},
	{"12100","Usmate/Velate Nord"},
	{"12101","Ussassai"},
	{"12102","Uzza"},
	{"12103","V.Della Magliana-Ss8 Via Ostiense"},
	{"12104","V.Le Leonardo Da Vinci-Palermo Porto"},
	{"12105","Vaciglio"},
	{"12106","Vada"},
	{"12107","Vado"},
	{"12108","Vado Ceraso"},
	{"12109","Vado Ligure"},
	{"12110","Vaglia"},
	{"12111","Vago Di Lavagno"},
	{"12112","Vaiano"},
	{"12113","Vairano Scalo"},
	{"12114","Vairano Scalo - Innesto Ss608 Di Teano"},
	{"12115","Vairano Scalo/Innesto Ss6 Casilina/Innesto Ss85 Venafrana"},
	{"12116","Val Degano"},
	{"12117","Val Di Sangro"},
	{"12118","Val Pescara-Chieti"},
	{"12119","Val Trompia"},
	{"12120","Val Vibrata"},
	{"12121","Valazzo/Innesto Ss528 Della Foresta Umbra"},
	{"12122","Valazzo/Innesto Ss89 Garganica"},
	{"12123","Valcimarra"},
	{"12124","Valda"},
	{"12125","Valdagno"},
	{"12126","Valdambra"},
	{"12127","Valdarno"},
	{"12128","Valdengo"},
	{"12129","Valderice"},
	{"12130","Valdichiana"},
	{"12131","Valdichiana A1/Bettolle/Raccordo Si-Bettolle-Pg"},
	{"12132","Valdichiana-Ss327-Raccordo Siena-Bettolle"},
	{"12133","Valeggio Sul Mincio"},
	{"12134","Valentano"},
	{"12135","Valenza"},
	{"12136","Valeria Fratta"},
	{"12137","Valeriana"},
	{"12138","Valfabbrica"},
	{"12139","Valico Arcueri"},
	{"12140","Valico Bocca Del Passo"},
	{"12141","Valico Bocca Di Piazza"},
	{"12142","Valico Bocca Trabaria"},
	{"12143","Valico Capannelle"},
	{"12144","Valico Case Di Tasso"},
	{"12145","Valico Casone Cocca"},
	{"12146","Valico Casone Di Cocca"},
	{"12147","Valico Castiglione Messer Marino"},
	{"12148","Valico Cima Di Sappada"},
	{"12149","Valico Cima Grappa"},
	{"12150","Valico Col D'ascione"},
	{"12151","Valico Colle Caprile"},
	{"12152","Valico Colle Del Contrasto"},
	{"12153","Valico Colle Del Moncenisio"},
	{"12154","Valico Colle Del Monginevro"},
	{"12155","Valico Colle Del Sestriere"},
	{"12156","Valico Colle Della Cama"},
	{"12157","Valico Colle Della Maddalena"},
	{"12158","Valico Colle Di Civitella"},
	{"12159","Valico Colle Di S.Bartolomeo"},
	{"12160","Valico Colle Di Tenda"},
	{"12161","Valico Colle Maddalena/Confine Con La Francia"},
	{"12162","Valico Croce Di Casale"},
	{"12163","Valico D.P. Sella Della Calla"},
	{"12164","Valico Decolla"},
	{"12165","Valico Dei Pozzi"},
	{"12166","Valico Dei Tre Cancelli"},
	{"12167","Valico Dei Tre Faggi"},
	{"12168","Valico Del Cerreto"},
	{"12169","Valico Del Colle Di S.Bartolomeo"},
	{"12170","Valico Del Cornello"},
	{"12171","Valico Del Cuccu"},
	{"12172","Valico Del Faggeto"},
	{"12173","Valico Del Fossato Di Vico"},
	{"12174","Valico Del Fuscello"},
	{"12175","Valico Del Giau"},
	{"12176","Valico Del Lupo"},
	{"12177","Valico Del Macerone"},
	{"12178","Valico Del Marmo"},
	{"12179","Valico Del Passo Della Calla"},
	{"12180","Valico Del Perrone"},
	{"12181","Valico Del Pramollo"},
	{"12182","Valico Del Sempione"},
	{"12183","Valico Del Soglio"},
	{"12184","Valico Del Turchino"},
	{"12185","Valico Del Verghereto"},
	{"12186","Valico Dell' Abetone"},
	{"12187","Valico Dell' Apparita"},
	{"12188","Valico Della Cessuta"},
	{"12189","Valico Della Foce Di Scopetone"},
	{"12190","Valico Della Forca D'acero"},
	{"12191","Valico Della Forchetta"},
	{"12192","Valico Della Forcola Di Livigno"},
	{"12193","Valico Della Fricca"},
	{"12194","Valico Della Scheggia"},
	{"12195","Valico Della Somma"},
	{"12196","Valico Della Spolverina"},
	{"12197","Valico Della Vaiana"},
	{"12198","Valico Della Velva"},
	{"12199","Valico Dell'abetone"},
	{"12200","Valico Delle Croci Di Acerno"},
	{"12201","Valico Delle Fornaci"},
	{"12202","Valico Dellla Fricca"},
	{"12203","Valico Dello Spino"},
	{"12204","Valico Di Bocca Di Piazza"},
	{"12205","Valico Di Bocca Seriola"},
	{"12206","Valico Di Bocca Serriola"},
	{"12207","Valico Di Campo Tenese"},
	{"12208","Valico Di Campotenese"},
	{"12209","Valico Di Capannelle"},
	{"12210","Valico Di Castiglione Messer Marino"},
	{"12211","Valico Di Cento Croci"},
	{"12212","Valico Di Cerro"},
	{"12213","Valico Di Cerro Secco"},
	{"12214","Valico Di Cerrosecco"},
	{"12215","Valico Di Cima Ciampigotto"},
	{"12216","Valico Di Cima Sappada"},
	{"12217","Valico Di Cimagrappa"},
	{"12218","Valico Di Coccau"},
	{"12219","Valico Di Colfiorito"},
	{"12220","Valico Di Colla Di Casaglia"},
	{"12221","Valico Di Colle Castagna"},
	{"12222","Valico Di Collecivitella"},
	{"12223","Valico Di Croce Di Casale"},
	{"12224","Valico Di Dobbiaco"},
	{"12225","Valico Di Fernetti/Confine Con La Slovenia"},
	{"12226","Valico Di Firenzuola"},
	{"12227","Valico Di Forca Barrea"},
	{"12228","Valico Di Forca Canapine"},
	{"12229","Valico Di Forca Caruso"},
	{"12230","Valico Di Forca D'acero"},
	{"12231","Valico Di Forca Di Cerro"},
	{"12232","Valico Di Forcella Lavardet"},
	{"12233","Valico Di Genna Silana"},
	{"12234","Valico Di Marmo"},
	{"12235","Valico Di Mengara"},
	{"12236","Valico Di Monte Altare"},
	{"12237","Valico Di Monte Bove"},
	{"12238","Valico Di Monte Di Mezzo"},
	{"12239","Valico Di Monte Mezzo"},
	{"12240","Valico Di Monte Nibbio"},
	{"12241","Valico Di Monte Scuro"},
	{"12242","Valico Di Monte Scurro"},
	{"12243","Valico Di Montecoronaro"},
	{"12244","Valico Di Montepiano"},
	{"12245","Valico Di Montocchio"},
	{"12246","Valico Di Ortuabis"},
	{"12247","Valico Di Pazzano"},
	{"12248","Valico Di Pese"},
	{"12249","Valico Di Piano Della Limina"},
	{"12250","Valico Di Poggio Di Biagio"},
	{"12251","Valico Di Poggio Di Selva"},
	{"12252","Valico Di Poggio Evangelista"},
	{"12253","Valico Di Poggio Selva"},
	{"12254","Valico Di Portella Di Mola"},
	{"12255","Valico Di Portella Di Scavo"},
	{"12256","Valico Di Portella Femmina Morta"},
	{"12257","Valico Di Portella Imbriaca"},
	{"12258","Valico Di Portella Madonnuzza/Innesto Ss120"},
	{"12259","Valico Di Portella Madonuzza"},
	{"12260","Valico Di Portella Mandrazzi"},
	{"12261","Valico Di Portella Pertusa"},
	{"12262","Valico Di Portella S.Martino"},
	{"12263","Valico Di Portella Scorciavacche"},
	{"12264","Valico Di Potame"},
	{"12265","Valico Di Rabuiese"},
	{"12266","Valico Di Radicofani"},
	{"12267","Valico Di Riofreddo"},
	{"12268","Valico Di Rocca Di Cambio"},
	{"12269","Valico Di Rocca Di Mezzo"},
	{"12270","Valico Di Rovere"},
	{"12271","Valico Di Rustici"},
	{"12272","Valico Di S.Eusebio"},
	{"12273","Valico Di S.Francesco"},
	{"12274","Valico Di S.Giusta"},
	{"12275","Valico Di S.Giusta Torrita"},
	{"12276","Valico Di Sa Casa"},
	{"12277","Valico Di Scannello"},
	{"12278","Valico Di Sella Di Camporosso"},
	{"12279","Valico Di Sella Di Gonza"},
	{"12280","Valico Di Sella Lata"},
	{"12281","Valico Di Serra Alta"},
	{"12282","Valico Di Somma"},
	{"12283","Valico Di Stupizza"},
	{"12284","Valico Di Stupizza/Confine Con La Slovenia"},
	{"12285","Valico Di Torrita"},
	{"12286","Valico Di Tre Cancelli"},
	{"12287","Valico Di Varco S. Mauro"},
	{"12288","Valico Di Varco S.Mauro"},
	{"12289","Valico Di Velva"},
	{"12290","Valico Forca Rua La Cama"},
	{"12291","Valico Forcella Di Lavardet"},
	{"12292","Valico Genna Silana"},
	{"12293","Valico Gioia Vecchio"},
	{"12294","Valico La Chiesole"},
	{"12295","Valico La Maesta'"},
	{"12296","Valico Lago Todaro"},
	{"12297","Valico Madonna Della Cima"},
	{"12298","Valico Monte Coronaro"},
	{"12299","Valico Monte Piano"},
	{"12300","Valico Monte Salviano"},
	{"12301","Valico Pian Delle Fugazze"},
	{"12302","Valico Poggio Evangelista"},
	{"12303","Valico Portella Del Contrasto"},
	{"12304","Valico Portella Dello Zoppo"},
	{"12305","Valico Portella Di Blasi"},
	{"12306","Valico Portella Di Femmina Morta"},
	{"12307","Valico Portella Di Madonnuzza"},
	{"12308","Valico Portella Di Recattivo"},
	{"12309","Valico Portella Di Scavo"},
	{"12310","Valico Portella Imbriaca"},
	{"12311","Valico Portella Mandrazzi"},
	{"12312","Valico Portella Miraglia"},
	{"12313","Valico Portella Misilbesi"},
	{"12314","Valico Portella Mola"},
	{"12315","Valico Portella Pertusa"},
	{"12316","Valico Portella S.Martino"},
	{"12317","Valico Portella S.Rizzo"},
	{"12318","Valico Portella Scorciavacche"},
	{"12319","Valico Scheggia"},
	{"12320","Valico Sella Canala"},
	{"12321","Valico Sella Ciampigotto"},
	{"12322","Valico Sella Di Camporosso"},
	{"12323","Valico Sella Di Conza"},
	{"12324","Valico Sella Di Corno"},
	{"12325","Valico Sella Di Corso"},
	{"12326","Valico Sella Di Fadalto"},
	{"12327","Valico Sella Lata"},
	{"12328","Valico Serra Alta"},
	{"12329","Valico Torre Di Satriano"},
	{"12330","Valico Vado Mistongo"},
	{"12331","Valico Villa Rustici (gola Della Rossa)"},
	{"12332","Valla'"},
	{"12333","Vallata"},
	{"12334","Valle Aterno"},
	{"12335","Valle Cerrina"},
	{"12336","Valle Chiappa Sud"},
	{"12337","Valle D'aosta"},
	{"12338","Valle Del Salto"},
	{"12339","Valle Di Cadore"},
	{"12340","Valle Di Maddaloni"},
	{"12341","Valle Lomellina"},
	{"12342","Valle Scrivia"},
	{"12343","Vallecorsa"},
	{"12344","Vallecrosia"},
	{"12345","Vallecupa"},
	{"12346","Vallegrande"},
	{"12347","Valleluna"},
	{"12348","Vallelunga Pratameno"},
	{"12349","Vallemosso"},
	{"12350","Vallermosa"},
	{"12351","Valli Del Pasubio"},
	{"12352","Valli Del Pasubio/Innesto Ss246 Di Recoaro"},
	{"12353","Valli Del Pasubio/Innesto Ss46 Del Pasubio"},
	{"12354","Vallo Della L./Innesto Ss488 Di Rocca D'aspidde"},
	{"12355","Vallo Della Lucania/Innesto Ss18 Tirrena Inferiore"},
	{"12356","Vallone"},
	{"12357","Valmadrera"},
	{"12358","Valmadrera Stazione"},
	{"12359","Valmadrera/Civate"},
	{"12360","Valmesta"},
	{"12361","Valmontone"},
	{"12362","Valmontone/Innesto Ss6 Casilina"},
	{"12363","Valmontone/Innesto Ss600 Ariana"},
	{"12364","Valmorbia"},
	{"12365","Valnerina"},
	{"12366","Valpiana"},
	{"12367","Valsavignone"},
	{"12368","Valsinni"},
	{"12369","Valsolda/Confine Con La Svizzera"},
	{"12370","Valsorda"},
	{"12371","Valtopina"},
	{"12372","Valzemola"},
	{"12373","Vancimuglio"},
	{"12374","Vandoies Di Sopra"},
	{"12375","Vanzone"},
	{"12376","Vaprio D'adda"},
	{"12377","Var Biellese"},
	{"12378","Var Della Val D'esino"},
	{"12379","Var Di Valfabbrica"},
	{"12380","Var Teramo-Mare"},
	{"12381","Var. Di Calizzano"},
	{"12382","Var. Galleria Delle Anime"},
	{"12383","Var. Ovest Di Campobasso"},
	{"12384","Var. Sanluri/Innesto Ss131 Di Carlo Felice"},
	{"12385","Varallo Piombia/Innesto Ss336 Aeroporto Malpensa"},
	{"12386","Varallo Pombia"},
	{"12387","Varallo Pombia/Innesto Ss32 Ticinese"},
	{"12388","Varazze"},
	{"12389","Varazze/Innesto Ss1 Aurelia"},
	{"12390","Varazze/Innesto Ss542 Di Pontinvrea"},
	{"12391","Varco Di Pietra Stretta"},
	{"12392","Varco S.Mauro/Innesto Ss279 Silana Di Rose"},
	{"12393","Varco S.Mauro/Innesto Ss559 Di Luzzi"},
	{"12394","Varena"},
	{"12395","Varese"},
	{"12396","Varese Est"},
	{"12397","Varese Ligure"},
	{"12398","Varese Sud"},
	{"12399","Varese/Innesto Ss233 Varesina"},
	{"12400","Varese/Innesto Ss341 Gallaratese"},
	{"12401","Varese/Innesto Ss342 Briantea"},
	{"12402","Varese/Innesto Ss344 Di Porto Ceresio"},
	{"12403","Varesina"},
	{"12404","Variane Di Sardara"},
	{"12405","Variante Ambra"},
	{"12406","Variante Barbaricina"},
	{"12407","Variante Del Ponte Sul Po'"},
	{"12408","Variante Di Accumoli"},
	{"12409","Variante Di Acquarica Del Capo"},
	{"12410","Variante Di Alcamo"},
	{"12411","Variante Di Altamura"},
	{"12412","Variante Di Andria"},
	{"12413","Variante Di Arezzo Nord/Innesto Ss71"},
	{"12414","Variante Di Arezzo Sud"},
	{"12415","Variante Di Arezzo Sud/Innesto Ss71"},
	{"12416","Variante Di Arten-Fonzaso"},
	{"12417","Variante Di Ascoli Piceno"},
	{"12418","Variante Di Aversa"},
	{"12419","Variante Di Battipaglia"},
	{"12420","Variante Di Begliano"},
	{"12421","Variante Di Benevento"},
	{"12422","Variante Di Bitonto"},
	{"12423","Variante Di Bivona"},
	{"12424","Variante Di Bojano"},
	{"12425","Variante Di Borgo Ticino"},
	{"12426","Variante Di Borgo Trevi"},
	{"12427","Variante Di Borgosesia"},
	{"12428","Variante Di Bosco"},
	{"12429","Variante Di Bovino"},
	{"12430","Variante Di Briatico"},
	{"12431","Variante Di Brienza"},
	{"12432","Variante Di Brindisi"},
	{"12433","Variante Di Camerino"},
	{"12434","Variante Di Canosa Di Puglia"},
	{"12435","Variante Di Capitello"},
	{"12436","Variante Di Carnia"},
	{"12437","Variante Di Caronno"},
	{"12438","Variante Di Cassano Spinola"},
	{"12439","Variante Di Castelfidardo"},
	{"12440","Variante Di Castelfranco Veneto"},
	{"12441","Variante Di Castelleone"},
	{"12442","Variante Di Castello Lavazzo"},
	{"12443","Variante Di Castelvenere"},
	{"12444","Variante Di Cava Dei Tirreni"},
	{"12445","Variante Di Cavazzo Carnico"},
	{"12446","Variante Di Centola"},
	{"12447","Variante Di Cerignola"},
	{"12448","Variante Di Cervellino"},
	{"12449","Variante Di Cesenatico"},
	{"12450","Variante Di Chatillon"},
	{"12451","Variante Di Chieri"},
	{"12452","Variante Di Chiusaforte"},
	{"12453","Variante Di Codroipo"},
	{"12454","Variante Di Conegliano"},
	{"12455","Variante Di Corato"},
	{"12456","Variante Di Cozze"},
	{"12457","Variante Di Cressa"},
	{"12458","Variante Di Dobbiaco"},
	{"12459","Variante Di Elmas"},
	{"12460","Variante Di Faenza"},
	{"12461","Variante Di Fagnano Castello"},
	{"12462","Variante Di Falconara Marittima"},
	{"12463","Variante Di Fasano"},
	{"12464","Variante Di Feletto"},
	{"12465","Variante Di Fiuminata"},
	{"12466","Variante Di Foggia"},
	{"12467","Variante Di Fontana"},
	{"12468","Variante Di Fossalto Di Portogruaro"},
	{"12469","Variante Di Fossano"},
	{"12470","Variante Di Gagliano Del Capo"},
	{"12471","Variante Di Gela"},
	{"12472","Variante Di Gioa Del Colle"},
	{"12473","Variante Di Guardamiglio"},
	{"12474","Variante Di Guastalla"},
	{"12475","Variante Di Ispra"},
	{"12476","Variante Di Lamia"},
	{"12477","Variante Di Lamiozza"},
	{"12478","Variante Di Lanciano"},
	{"12479","Variante Di Lavello"},
	{"12480","Variante Di Leprea"},
	{"12481","Variante Di Levane"},
	{"12482","Variante Di Longarone"},
	{"12483","Variante Di Lucera Est"},
	{"12484","Variante Di Lucera Ovest"},
	{"12485","Variante Di Magenta"},
	{"12486","Variante Di Maglie Nord"},
	{"12487","Variante Di Magnonevolo"},
	{"12488","Variante Di Mazara Del Vallo"},
	{"12489","Variante Di Merna"},
	{"12490","Variante Di Mola Di Bari"},
	{"12491","Variante Di Monastir"},
	{"12492","Variante Di Monopoli Nord"},
	{"12493","Variante Di Monopoli Sud"},
	{"12494","Variante Di Monselice"},
	{"12495","Variante Di Montaguto"},
	{"12496","Variante Di Montalto Di Castro"},
	{"12497","Variante Di Montesano Salentino"},
	{"12498","Variante Di Mottalciata"},
	{"12499","Variante Di Mottola"},
	{"12500","Variante Di Mussotto"},
	{"12501","Variante Di Muzzana Di Turgnano"},
	{"12502","Variante Di Nociglia"},
	{"12503","Variante Di Novi Ligure"},
	{"12504","Variante Di Nuraminis"},
	{"12505","Variante Di Nus"},
	{"12506","Variante Di Orsara Di Puglia"},
	{"12507","Variante Di Orta Nova"},
	{"12508","Variante Di Ospedaletto"},
	{"12509","Variante Di Ospitale Di Cadore"},
	{"12510","Variante Di Paestum"},
	{"12511","Variante Di Pagani"},
	{"12512","Variante Di Paganico"},
	{"12513","Variante Di Pagliaga E Portegrandi"},
	{"12514","Variante Di Palazzo S.Gervasio"},
	{"12515","Variante Di Palmariggi"},
	{"12516","Variante Di Parghelia"},
	{"12517","Variante Di Partinico"},
	{"12518","Variante Di Paterno'"},
	{"12519","Variante Di Peschiera"},
	{"12520","Variante Di Pian Di Vedoia"},
	{"12521","Variante Di Pietraviva"},
	{"12522","Variante Di Pinerolo"},
	{"12523","Variante Di Pissignano"},
	{"12524","Variante Di Platania"},
	{"12525","Variante Di Poirino"},
	{"12526","Variante Di Polignano A Mare"},
	{"12527","Variante Di Ponte A Ema"},
	{"12528","Variante Di Ponte A Moriano"},
	{"12529","Variante Di Ponte Barizzo"},
	{"12530","Variante Di Ponte Nuovo"},
	{"12531","Variante Di Pontecurone"},
	{"12532","Variante Di Pontelungo"},
	{"12533","Variante Di Pordenone"},
	{"12534","Variante Di Porretta Terme"},
	{"12535","Variante Di Pozzolo Formigaro"},
	{"12536","Variante Di Praia A Mare"},
	{"12537","Variante Di Praia A Mare Sud"},
	{"12538","Variante Di Pralormo"},
	{"12539","Variante Di Quercianella"},
	{"12540","Variante Di Resiutta"},
	{"12541","Variante Di Rho"},
	{"12542","Variante Di Rimini"},
	{"12543","Variante Di Rivergaro"},
	{"12544","Variante Di Rivoli Bianchi"},
	{"12545","Variante Di Roccaraso"},
	{"12546","Variante Di Roselle"},
	{"12547","Variante Di Rutigliano"},
	{"12548","Variante Di S.Candido/Innesto Ss49 Della Pusteria"},
	{"12549","Variante Di S.Cesario Di Lecce"},
	{"12550","Variante Di S.Clemente"},
	{"12551","Variante Di S.Ferdinando Di Puglia"},
	{"12552","Variante Di S.Giacomo"},
	{"12553","Variante Di S.Giovanni"},
	{"12554","Variante Di S.Margherita"},
	{"12555","Variante Di S.Pietro Vernotico"},
	{"12556","Variante Di S.Severo"},
	{"12557","Variante Di S.Severo S."},
	{"12558","Variante Di S.Stefano Belbo"},
	{"12559","Variante Di Salassa-Valperga"},
	{"12560","Variante Di Sale"},
	{"12561","Variante Di Sammichele Di Bari"},
	{"12562","Variante Di Sanluri/Innesto Ss197 Di San Gavino"},
	{"12563","Variante Di Sannicandro Di Bari"},
	{"12564","Variante Di Santhia'"},
	{"12565","Variante Di Sarentino"},
	{"12566","Variante Di Savignano Irpino"},
	{"12567","Variante Di Sciacca"},
	{"12568","Variante Di Sedriano E Roveda Di Sedriano"},
	{"12569","Variante Di Serradifalco"},
	{"12570","Variante Di Serrenti"},
	{"12571","Variante Di Siliqua"},
	{"12572","Variante Di Sioneri"},
	{"12573","Variante Di Spezzano Della Sila"},
	{"12574","Variante Di Spindoli"},
	{"12575","Variante Di Spinetta Marengo"},
	{"12576","Variante Di Spino D'adda"},
	{"12577","Variante Di Spoleto"},
	{"12578","Variante Di St. Vincent"},
	{"12579","Variante Di Sulmona"},
	{"12580","Variante Di Suni"},
	{"12581","Variante Di Termine Di Cadore"},
	{"12582","Variante Di Terzo"},
	{"12583","Variante Di Torre A Mare"},
	{"12584","Variante Di Tortona"},
	{"12585","Variante Di Tortona/Bivio Per La Ss35 Dei Giovi"},
	{"12586","Variante Di Trento/Ponte Alto"},
	{"12587","Variante Di Trinita'"},
	{"12588","Variante Di Udine"},
	{"12589","Variante Di Uras"},
	{"12590","Variante Di Ussana"},
	{"12591","Variante Di Vallo Della Lucania"},
	{"12592","Variante Di Varallo Sesia"},
	{"12593","Variante Di Venticano"},
	{"12594","Variante Di Ventimiglia"},
	{"12595","Variante Di Verres"},
	{"12596","Variante Di Viareggio"},
	{"12597","Variante Di Vittoria"},
	{"12598","Variante Di Volturara Appula"},
	{"12599","Variante Formia Garigliano"},
	{"12600","Variante Maglie"},
	{"12601","Variante Olmo Scopetone"},
	{"12602","Variante Per Fombio"},
	{"12603","Variante S. Leo-Pellaro-Bocale"},
	{"12604","Variante S.Eraclio E Foligno"},
	{"12605","Varigotti"},
	{"12606",""},
	{"12607","Varna"},
	{"12608","Varopodio"},
	{"12609","Varzi"},
	{"12610","Varzo"},
	{"12611","Vasche"},
	{"12612","Vassena"},
	{"12613","Vasto"},
	{"12614","Vasto Marina"},
	{"12615","Vasto Marina/Innesto Ss86 Istonia"},
	{"12616","Vasto Nord-Casalbordino"},
	{"12617","Vasto Sud"},
	{"12618","Vattaro"},
	{"12619","Vazia"},
	{"12620","Vecchiarelli"},
	{"12621","Vedelago"},
	{"12622","Vedronza"},
	{"12623","Veggia"},
	{"12624","Vejano"},
	{"12625","Velasca Ovest"},
	{"12626","Velletri"},
	{"12627","Velletri/Innesto Ss217 Via Dei Laghi"},
	{"12628","Velletri/Innesto Ss600 Ariana"},
	{"12629","Velletri/Innesto Ss7 Appia"},
	{"12630","Vello"},
	{"12631","Velva"},
	{"12632","Venafrana"},
	{"12633","Venafro"},
	{"12634","Venafro/Innesto Ss6 Diramazione Via Casilina"},
	{"12635","Venafro/Innesto Ss85 Venafrana"},
	{"12636","Venas Di Cadore"},
	{"12637","Venas Di Cadore/Innesto Ss347 P. Cereda E P. Duran"},
	{"12638","Venas Di Cadore/Innesto Ss51 Di Alemagna"},
	{"12639","Venegazzu'"},
	{"12640","Venere Di Pescina"},
	{"12641","Venetico Marina"},
	{"12642","Veneto"},
	{"12643","Venezia"},
	{"12644","Venezia-Aeroporto Tessera"},
	{"12645","Venosa"},
	{"12646","Ventimiglia"},
	{"12647","Ventimiglia/Innesto Ss1 Aurelia"},
	{"12648","Ventimiglia/Innesto Ss20 Del Colle Di Tenda"},
	{"12649","Venturina"},
	{"12650","Verano Brianza"},
	{"12651","Verbano"},
	{"12652","Verbano Cusio Ossola"},
	{"12653","Vercellese"},
	{"12654","Vercelli"},
	{"12655","Vercelli Est"},
	{"12656","Vercelli Ovest"},
	{"12657","Vercelli/Innesto Ss11 Padana Superiore"},
	{"12658","Vercelli/Innesto Ss11 Padana Superiore"},
	{"12659","Vercelli/Innesto Ss230 Di Massazza"},
	{"12660","Vercelli/Innesto Ss31 Del Monferrato"},
	{"12661","Vercelli/Innesto Ss455 Di Pontestura"},
	{"12662","Vercelli/Innesto Ss596 Dei Cairoli"},
	{"12663","Vercurago"},
	{"12664","Verdello"},
	{"12665","Vergato"},
	{"12666","Verghereto"},
	{"12667","Vergiate/Innesto Ss33 Del Sempione"},
	{"12668","Vergiate/Innesto Ss394 Verbano Orientale"},
	{"12669","Vergnasco"},
	{"12670","Verla"},
	{"12671","Vermiglio"},
	{"12672","Vernante"},
	{"12673","Vernio"},
	{"12674","Verolengo"},
	{"12675","Verona"},
	{"12676","Verona Ca' Di David/Innesto Tangenziale Sud Di Verona"},
	{"12677","Verona Est"},
	{"12678","Verona Nord"},
	{"12679","Verona Sud"},
	{"12680","Verona/Innesto Ss11 Padana Superiore"},
	{"12681","Verona/Innesto Ss12 Dell'abetone E Del Brennero"},
	{"12682","Verona/Innesto Ss12 E Ss62 Della Cisa"},
	{"12683","Verona/Innesto Ss12/Ss434 Transpolesana"},
	{"12684","Verona/Innesto Ss62 Della Cisa/Ss434 Legnaghese"},
	{"12685","Verona/Innesto Tangenziale Sud Di Verona"},
	{"12686","Verres"},
	{"12687","Verres/Innesto Strada Reg. 45"},
	{"12688","Verrone"},
	{"12689","Versa"},
	{"12690","Versilia"},
	{"12691","Verzino"},
	{"12692","Verzuolo"},
	{"12693","Vescona"},
	{"12694","Vespolate"},
	{"12695","Vessalico"},
	{"12696","Vestone"},
	{"12697","Vesuvio"},
	{"12698","Vetralla"},
	{"12699","Vetralla - Innesto Ss2 Cassia"},
	{"12700","Vetralla/Innesto Ss1 Bis Aurelia"},
	{"12701","Vetralla/Innesto Ss2 Cassia"},
	{"12702","Vetto D'enza"},
	{"12703","Vezza D'oglio"},
	{"12704","Vezzano"},
	{"12705","Vezzano Sul Crostolo"},
	{"12706","Via Appia"},
	{"12707","Via Argine"},
	{"12708","Via Aurelia"},
	{"12709","Via Casilina"},
	{"12710","Via Cassia"},
	{"12711","Via Claudia Braccianese"},
	{"12712","Via Dei Laghi"},
	{"12713","Via Del Mare"},
	{"12714","Via Della Magliana"},
	{"12715","Via Della Magliana/Innesto Autostrada Per Aeroporto Fiumicino"},
	{"12716","Via Di Decima/Castel Porziano (direzione Lt)"},
	{"12717","Via Domiziana"},
	{"12718","Via Emilia"},
	{"12719","Via Erasmo Piaggio"},
	{"12720","Via Flacca"},
	{"12721","Via Flaminia"},
	{"12722","Via Flavia"},
	{"12723","Via Fregessi/Innesto Ss15 Via Flavia"},
	{"12724","Via Giuseppe Pitre'-Aeroporto Boccadifalco"},
	{"12725","Via Isacco Newton"},
	{"12726","Via Larga"},
	{"12727","Via Oreto"},
	{"12728","Via Rocca Di Papa"},
	{"12729","Via Salaria"},
	{"12730","Via Tiburtina Valeria"},
	{"12731","Via Tor Di Mezza/Innesto Ss215 Tuscolana"},
	{"12732","Via Tor Di Mezza/Innesto Ss511 Anagnina"},
	{"12733","Via Val Di Cornia"},
	{"12734","Viadana"},
	{"12735","Viadotto A1"},
	{"12736","Viamaggio"},
	{"12737","Viareggio"},
	{"12738","Vibo Marina"},
	{"12739","Vibo Marina/Innesto Ss182 Delle Serre Calabre"},
	{"12740","Vibo Marina/Innesto Ss522 Di Tropea"},
	{"12741","Vibo Valentia"},
	{"12742","Vibo Valentia/Innesto Ss18 E Ss182 D. Serre Calabre"},
	{"12743","Vibo Valentia/Innesto Ss18 Tirrena Inferiore E Ss606"},
	{"12744","Vibo Valentia/Innesto Ss606/Innesto Ss182"},
	{"12745","Vibo Valentia-Sant'onofrio"},
	{"12746","Vibrata"},
	{"12747","Vicarello"},
	{"12748","Vicarello/Innesto Sgc Fi-Pi-Li"},
	{"12749","Vicarello/Innesto Ss206 Pisana-Livornese"},
	{"12750","Vicarello/Innesto Ss555 Delle Colline"},
	{"12751","Vicchio"},
	{"12752","Vicenza"},
	{"12753","Vicenza Est"},
	{"12754","Vicenza Nord"},
	{"12755","Vicenza Ovest"},
	{"12756","Vicenza/Innesto Ss11 Padana Superiore"},
	{"12757","Vicenza/Innesto Ss11 Padana Superiore"},
	{"12758","Vicenza/Innesto Ss247 Riviera"},
	{"12759","Vicenza/Innesto Ss248 Schiavonesca Marosticana"},
	{"12760","Vicenza/Innesto Ss46 Del Pasubio"},
	{"12761","Vicenza/Innesto Ss53 Postumia"},
	{"12762","Vico Del Gargano"},
	{"12763","Vico Equense"},
	{"12764","Vico Equense/Innesto Ss145 Sorrentina"},
	{"12765","Vico Equense/Innesto Ss269 Del Faito"},
	{"12766","Vicobellignano"},
	{"12767","Vicomoscano"},
	{"12768","Vicovaro"},
	{"12769","Vicovaro-Mandela"},
	{"12770","Vidulis"},
	{"12771","Vieste"},
	{"12772","Vieste/Innesto Ss89 Dir/A Garganica"},
	{"12773","Vieste/Innesto Ss89 Garganica"},
	{"12774","Vietri Di Potenza"},
	{"12775","Vietri Sul Mare"},
	{"12776","Vietri Sul Mare/Innesto Ss163 Amalfitana"},
	{"12777","Vietri Sul Mare/Innesto Ss18 Tirrena Inferiore"},
	{"12778","Vigalfo"},
	{"12779","Vigarano Mainarda"},
	{"12780","Vigarano Pieve"},
	{"12781","Vigevanese"},
	{"12782","Viggiano/Innesto Ss103 Di Val D'agri"},
	{"12783","Vigliano Biellese"},
	{"12784","Vignale"},
	{"12785","Vignola"},
	{"12786","Vignole"},
	{"12787","Vignole Borbera"},
	{"12788","Vignole/Innesto Ss203 Agordina"},
	{"12789","Vignole/Innesto Ss203 Diramazione Agordina"},
	{"12790","Vigo Di Cadore"},
	{"12791","Vigo Di Fassa"},
	{"12792","Vigo Rendena"},
	{"12793","Vigolo Vattaro"},
	{"12794","Vigonza"},
	{"12795","Vigorovea"},
	{"12796","Villa A Sesta"},
	{"12797","Villa Badessa"},
	{"12798","Villa Banale"},
	{"12799","Villa Cade'"},
	{"12800","Villa Carcina"},
	{"12801","Villa Col De Canali"},
	{"12802","Villa D'agri"},
	{"12803","Villa D'agri/Innesto Ss598 Di Fondo Valle D'agri"},
	{"12804","Villa D'alme'/Innesto Ss470 D Della Val Brembana"},
	{"12805","Villa D'alme'/Innesto Ss470 Della Valle Brembana"},
	{"12806","Villa Del Bosco"},
	{"12807","Villa Di Chiavenna"},
	{"12808","Villa Di Lesa"},
	{"12809","Villa Di Tirano/Innesto Ss550 Di Villa Di Tirano"},
	{"12810","Villa D'orri"},
	{"12811","Villa Fornaci"},
	{"12812","Villa Fornaci/Innesto Ss11 Padana Superiore"},
	{"12813","Villa Fornaci/Innesto Ss525 Del Brembo"},
	{"12814","Villa Gabrieli"},
	{"12815","Villa Giovannina"},
	{"12816","Villa Grazia Di Carini"},
	{"12817","Villa Guardia"},
	{"12818","Villa Lempa"},
	{"12819","Villa Literno"},
	{"12820","Villa Maggiore/Innesto Ss150 Della Valle Del Vomano"},
	{"12821","Villa Maggiore/Innesto Ss491 Isola Gran Sasso"},
	{"12822","Villa Morosini Nord"},
	{"12823","Villa Opicina"},
	{"12824","Villa Opicina/Innesto Ss202 Triestina"},
	{"12825","Villa Opicina-Raccordo A4-Trieste"},
	{"12826","Villa Ostuni"},
	{"12827","Villa Ottone"},
	{"12828","Villa Petto"},
	{"12829","Villa Poma"},
	{"12830","Villa Potenza/Innesto Ss361 Septempedana"},
	{"12831","Villa Potenza/Innesto Ss362 Jesina"},
	{"12832","Villa Potenza/Innesto Ss77 Della Val Di Chienti"},
	{"12833","Villa Raspa Di Spoltore"},
	{"12834","Villa Raspa Ovest/Innesto Ss16 Variante"},
	{"12835","Villa Raspa/Innesto Ss16 Bis Adriatica"},
	{"12836","Villa Raspa/Innesto Ss602 Di Forca Di Penne"},
	{"12837","Villa Rendena"},
	{"12838","Villa Romagnoli"},
	{"12839","Villa S.Giovanni"},
	{"12840","Villa S.Giovanni/Innesto Ss18 Tirrena Inferiore"},
	{"12841","Villa S.Giovanni/Innesto Ss670 Dei Piani D'aspromonte"},
	{"12842","Villa S.Lucia Degli Abruzzi"},
	{"12843","Villa S.Sebastiano"},
	{"12844","Villa S.Teresa"},
	{"12845","Villa Sant'antonio"},
	{"12846","Villa Santina"},
	{"12847","Villa Santina/Innesto Ss355 Di Val Degano"},
	{"12848","Villa Santina/Innesto Ss52 Carnica"},
	{"12849","Villa Tirano/Innesto Ss38 Dello Stelvio"},
	{"12850","Villa Vela"},
	{"12851","Villa Verdi"},
	{"12852","Villa Verrucchio"},
	{"12853","Villa Vomano/Innesto Ss150 Valle Del Vomano"},
	{"12854","Villa Vomano/Innesto Ss365 Di Bisenti"},
	{"12855","Villa Vomano/Innesto Ss81 Picena Aprutina"},
	{"12856","Villa Vomano/Innesto Ss81 Piceno Aprutina"},
	{"12857","Villabassa"},
	{"12858","Villacidro"},
	{"12859","Villadose"},
	{"12860","Villadossola"},
	{"12861","Villafranca"},
	{"12862","Villafranca D'asti"},
	{"12863","Villafranca Di Verona"},
	{"12864","Villafranca In Lunigiana"},
	{"12865","Villafranca Sicula"},
	{"12866","Villafranca Tirrena"},
	{"12867","Villafranca Tirrena/Innesto Ss113 Diramazione Sett. Sicula"},
	{"12868","Villafranca Tirrena/Innesto Ss113 Sett. Sicula"},
	{"12869","Villafrati"},
	{"12870","Villaggio Del Fanciullo"},
	{"12871","Villaggio Mancuso"},
	{"12872","Villaggio Racise"},
	{"12873","Villaggio Tognazzi"},
	{"12874","Villagio De Leo"},
	{"12875","Villagrazia Di Carini"},
	{"12876","Villalago"},
	{"12877","Villalvernia"},
	{"12878","Villamaina"},
	{"12879","Villamar"},
	{"12880","Villamarzana"},
	{"12881","Villammare"},
	{"12882","Villanoce"},
	{"12883","Villanova"},
	{"12884","Villanova D'asti/Innesto Ss10 Padana Inferiore"},
	{"12885","Villanova D'asti/Innesto Ss29 Racc Del C. Di Cadibona"},
	{"12886","Villanova Monferrato"},
	{"12887","Villanova Monteleone"},
	{"12888","Villanova Strisaili"},
	{"12889","Villanova Sull'arda"},
	{"12890","Villanova Truschedu"},
	{"12891","Villanterio"},
	{"12892","Villanterio/Incrocio Con La Ss235 Di Orzinuovi"},
	{"12893","Villanterio/Incrocio Ss412 Della Val Tidone"},
	{"12894","Villanuova Sul Clisi"},
	{"12895","Villaperuccio/Santadi"},
	{"12896","Villapiana Lido"},
	{"12897","Villaputzu"},
	{"12898","Villar Perosa"},
	{"12899","Villarboit"},
	{"12900","Villareggia"},
	{"12901","Villareia"},
	{"12902","Villareia/Innesto Raccordo Chieti-Pescara"},
	{"12903","Villareia/Innesto Ss656 Diramazione Val Pescara-Chieti"},
	{"12904","Villaretto"},
	{"12905","Villarosa"},
	{"12906","Villasanta/Innesto Ss131 E Ss197 Di Villacidro"},
	{"12907","Villasanta/Innesto Ss293 Di Giba E Ss197"},
	{"12908","Villasanta/Innesto Ss293 Di Giba/Innesto Ss131"},
	{"12909","Villaseta"},
	{"12910","Villaseta/Innesto Ss115 Quater Sud Occ. Sicula"},
	{"12911","Villaseta/Innesto Ss115 Quater Sud Occ.Le Sicula"},
	{"12912","Villaseta/Innesto Ss115 Sud Occidentale Sicula"},
	{"12913","Villaseta/Innesto Ss640 Di Porto Empedocle"},
	{"12914","Villasor"},
	{"12915","Villasor/Innesto Ss196 Di Villacidro"},
	{"12916","Villasor/Innesto Ss196 Diramazione Di Villacidro"},
	{"12917","Villastellone"},
	{"12918","Villaverla"},
	{"12919","Ville Di Fano"},
	{"12920","Villefranche"},
	{"12921","Villeneuve"},
	{"12922","Villese"},
	{"12923","Villesse"},
	{"12924","Villesse/Innesto Raccordo Villesse-Gorizia"},
	{"12925","Villesse-Allacciamento Raccordo Villesse-Gorizia"},
	{"12926","Villesse-Allacciamento A4 Torino-Trieste"},
	{"12927","Villetta Barrea"},
	{"12928","Villetta Barrea/Innesto Ss479 Sannite"},
	{"12929","Villetta Barrea/Innesto Ss83 Marsicana"},
	{"12930","Villorba"},
	{"12931","Villoresi"},
	{"12932","Villotta"},
	{"12933","Vilpiano"},
	{"12934","Vimodrone"},
	{"12935","Vinadio"},
	{"12936","Vinchiaturo"},
	{"12937","Vinciarello"},
	{"12938","Vione"},
	{"12939","Viotto"},
	{"12940","Viottolone"},
	{"12941","Vipiteno"},
	{"12942","Vipiteno/Incrocio Ss12 Dell'abetone E Brennero"},
	{"12943","Vipiteno/Innesto Ss508 Di Val Sarentino E P. Vizze"},
	{"12944","Virgiliana"},
	{"12945","Visco"},
	{"12946","Visnadello"},
	{"12947","Visone"},
	{"12948","Vispa Di Carcare"},
	{"12949","Visso"},
	{"12950","Vita"},
	{"12951","Viterbo"},
	{"12952","Viterbo Nord/Innesto Raccordo Vetralla-Viterbo"},
	{"12953","Viterbo/Innesto Ss2 Cassia"},
	{"12954","Viterbo/Innesto Ss204 Ortana"},
	{"12955","Vitiano"},
	{"12956","Vitigliano"},
	{"12957","Vitinia"},
	{"12958","Vittorio Veneto"},
	{"12959","Vittorio Veneto Nord"},
	{"12960","Vittorio Veneto Sud"},
	{"12961","Vittorio Veneto/Innesto Ss422 Alpago E Cansiglio"},
	{"12962","Vittorio Veneto/Innesto Ss51 Di Alemagna"},
	{"12963","Viverone"},
	{"12964","Vizzini"},
	{"12965","Vizzini/Innesto Ss124 Siracusana"},
	{"12966","Vizzini/Innesto Ss194 Ragusana"},
	{"12967","Vocca"},
	{"12968","Vodo Di Cadore"},
	{"12969","Voghera"},
	{"12970","Voghera/Innesto Ss10 Padana Inferiore"},
	{"12971","Voghera/Innesto Ss461 Septempedana"},
	{"12972","Vogogna"},
	{"12973","Volano"},
	{"12974","Volargne"},
	{"12975","Volpago Del Montello"},
	{"12976","Volpiano"},
	{"12977","Voltago Agordino"},
	{"12978","Voltarrosto"},
	{"12979","Volterra"},
	{"12980","Volturara Appula"},
	{"12981","Volturara Appula/Innesto Ss17 Dell'app. Abb."},
	{"12982","Volturara Appula/Innesto Ss369 Appulo-Fortorina"},
	{"12983","Volturno Ponte"},
	{"12984","Vomano"},
	{"12985","Vomero"},
	{"12986","Xitta"},
	{"12987","Zagarise"},
	{"12988","Zane'"},
	{"12989","Zanica"},
	{"12990","Zappardino"},
	{"12991","Zapponeta"},
	{"12992","Zaule/Innesto Ss15 Racc Via Flavia"},
	{"12993","Zaule/Innesto Ss15 Via Flavia"},
	{"12994","Zellina"},
	{"12995","Zelo"},
	{"12996","Zeme"},
	{"12997","Zenna/Confine Con La Svizzera"},
	{"12998","Zeppara"},
	{"12999","Zepponami"},
	{"13000","Zero Branco"},
	{"13001","Ziano Di Fiemme"},
	{"13002","Zimella"},
	{"13003","Zoagli"},
	{"13004","Zocca"},
	{"13005","Zogno"},
	{"13006","Zola Predosa-Lavino Sopra"},
	{"13007","Zoldo Alto"},
	{"13008","Zollino"},
	{"13009","Zona Industriale"},
	{"13010","Zona Industriale Di Campotrino"},
	{"13011","Zona Industriale Di Pescara"},
	{"13012","Zona Industriale Nord"},
	{"13013","Zona Industriale Sambuceto"},
	{"13014","Zone"},
	{"13015","Zorba"},
	{"13016","Zorlesco"},
	{"13017","Zubiena"},
	{"13018","Zuccarello"},
	{"13019","Zucco"},
	{"13020","Zuel"},
	{"13021","Zugliano"},
	{"13022","Zuppino"},
	{"13023","Zurco"},
	{"13024",""},
	{"13025",""},
	{"13026",""},
	{"13027",""},
	{"13028",""},
	{"13029",""},
	{"13030",""},
	{"13031",""},
	{"13032",""},
	{"13033",""},
	{"13034",""},
	{"13035",""},
	{"13036","Casello Ivrea Nord A5 Torino-Courmayeur"},
	{"13037","Allacciamento A5 Torino-Courmayeur"},
	{"13038","Casello Quincinetto A5 Torino-Courmayeur"},
	{"13039","Casello Pont St Martin A5 Torino-Courmayeur"},
	{"13040","Casello Verres A5 Torino-Courmayeur"},
	{"13041","Casello St. Vincent Chatillon A5 To-Courmayeur"},
	{"13042","Casello Nus A5 Torino-Courmayeur"},
	{"13043","Casello Morgex A5 Torino-Courmayeur"},
	{"13044",""},
	{"13045","Torino-Courmayeur"},
	{"13046","Courmayeur"},
	{"13047","Settimo Est"},
	{"13048","Les Iles De Brissogne Nord"},
	{"13049",""},
	{"13050",""},
	{"13051","Aosta Est"},
	{"13052",""},
	{"13053","Svincolo Morgex (entrata Direzione Sud)"},
	{"13054",""},
	{"13055","Inizio Galleria Signayes"},
	{"13056","Fine Galleria Signayes"},
	{"13057","Variney/Innesto Ss27"},
	{"13058","Plan De Signayes"},
	{"13059","Variney/Innesto Raccordo G.S. Bernardo"},
	{"13060","Bivio Cerisey/Innesto Traforo Gran S.Bernardo"},
	{"13061","Courmayeur/Svincolo Courmayeur A5"},
	{"13062",""},
	{"13063","Innesto Ss626 Dir/A Per Caltanissetta"},
	{"13064","Fine Variante Di Ponte A Moriano"},
	{"13065","Fine Variante/Innesto Ss12"},
	{"13066","Isernia (tangenziale)"},
	{"13067","Modica Sud/Innesto Ss15"},
	{"13068","Olmo/Innesto Ss73 Senese Aretina E Ss73 Var"},
	{"13069",""},
	{"13070","Muccia/Innesto Ss256 Muccese"},
	{"13071",""},
	{"13072",""},
	{"13073",""},
	{"13074","Borghetto Santo Spirito"},
	{"13075",""},
	{"13076",""},
	{"13077","Fiera Milano"},
	{"13078","Svincolo di Pontechiasso"},
	{"13079","Svincolo Chiasso uscita merci"},
	{"13080","Autostrada Torino - Aosta"},
	{"13081","Allacciamento A05 - Tangenziale di Torino"},
	{"13082","Raccordo SS516 Piovese"},
	{"13083",""},
	{"13084",""},
	{"13085","Allacciamento Aosta Monte Bianco"},
	{"13086","Allacciamento A5/Controllo Merci Aosta"},
	{"13087","Allacciamento Controllo Merci AO / A5"},
	{"13088","Autoporto Aosta Sud"},
	{"13089","SVINCOLO AOSTA EST-AUTOPORTO"},
	{"13090","SVINCOLO LIBERO AOSTA OVEST"},
	{"13091","USCITA COURMAYEUR SUD"},
	{"13092","ENTRATA COURMAYEUR SUD"},
	{"13093",""},
	{"13094","Svincolo di Barchette"},
	{"13095",""},
	{"13096","Borgaro Torinese"},
	{"13097","Allacciamento Complanare Poasco-Via Emilia"},
	{"13098","Allacciamento Raccordo P.le Corvetto"},
	{"13099",""},
	{"13100","Svincolo SP9 Vecchia Valsassina"},
	{"13101","Rho Area Industriale"},
	{"13102",""},
	{"13103",""},
	{"13104","Area di servizio Fabro"},
	{"13105",""},
	{"13106","Torino - Corso Giulio Cesare"},
	{"13107",""},
	{"13108","Settimo Nord"},
	{"13109",""},
	{"13110",""},
	{"13111",""},
	{"13112",""},
	{"13113",""},
	{"13114","Svincolo Firenze Viadotto Indiano"},
	{"13115","ITALIA '90 COMUNE DI NAPOLI"},
	{"13116","Strada Grande Comunicazione Fi-Pi-Li (diramazione per Pisa)"},
	{"13117","Svincolo Gello-Bivio Allacciamento Fi-Pi-Li per Livorno"},
	{"13118","Svincolo Gello-Bivio Allacciamento Diramazione per Pisa"},
	{"13119","Strada Grande Comunicazione Fi-Pi-Li - Diramazione per Pisa"},
	{"13120",""},
	{"13121",""},
	{"13122","Centro Intermodale Est"},
	{"13123","Centro Intermodale Ovest"},
	{"13124","Svincolo di Tirrenia"},
	{"13125","Svincolo Darsena - Toscana Est"},
	{"13126",""},
	{"13127",""},
	{"13128","Uscita Arco Felice"},
	{"13129","Strada Statale Domitiana"},
	{"13130","Pozzuoli-Ss7 Quater - Inizio Tangenziale"},
	{"13131",""},
	{"13132","Ingresso Arco Felice"},
	{"13133","Cuma"},
	{"13134",""},
	{"13135","Pozzuoli Arco Felice"},
	{"13136","Damiani"},
	{"13137",""},
	{"13138","Viale Maddalena"},
	{"13139","Barriera di Bardonecchia"},
	{"13140","Svincolo di Bardonecchia"},
	{"13141",""},
	{"13142",""},
	{"13143","Barriera di Modan-Replat"},
	{"13144","Collegamento Autoporto Freney"},
	{"13145","Svincolo Modan Replat"},
	{"13146","Svincolo Autoporto Freney"},
	{"13147",""},
	{"13148",""},
	{"13149","Allacciamento A06 - A33"},
	{"13150","Asti - Cuneo"},
	{"13151","Sant'Albano"},
	{"13152",""},
	{"13153",""},
	{"13154",""},
	{"13155","Fiera"},
	{"13156","Allacciamento ss33 del Sempione"},
	{"13157",""},
	{"13158","Raccordo Milano Nuova Fiera"},
	{"13159","Accesso Sud-Ovest Fiera"},
	{"13160","Svincolo Pero - Fiera"},
	{"13161","Accesso Est Merci Fiera"},
	{"13162","Accesso Nord Est Fiera"},
	{"13163","Allacciamento SP 46 Rho - Monza"},
	{"13164","Raccordo SS11-SS33"},
	{"13165",""},
	{"13166","Settimo Milanese"},
	{"13167","Molino Dorino"},
	{"13168","Allacciamento Raccordo SS11-SS33 - Tangenziale Ovest"},
	{"13169","Via Silla - Figino"},
	{"13170","Pero Sud"},
	{"13171","Raccordo A4 Milano Viale Certosa"},
	{"13172","A4 Milano"},
	{"13173",""},
	{"13174",""},
	{"13175",""},
	{"13176","Viale Certosa - Raccordo A4"},
	{"13177","Svincolo Via Cogne"},
	{"13178","Viale Certosa"},
	{"13179","A4 - Raccordo Viale Certosa"},
	{"13180","Raccordo Milano A7-Piazza Maggi"},
	{"13181","Piazza Maggi"},
	{"13182","Milano Inizio A7"},
	{"13183","Famagosta"},
	{"13184","Piazza Gian Antonio Maggi"},
	{"13185",""},
	{"13186","Raccordo A1-SGC FiPiLi"},
	{"13187","A1 Fi Signa"},
	{"13188","SGC Fi Pi Li"},
	{"13189","Svincolo di Scandicci"},
	{"13190","Allacciamento A1"},
	{"13191","Svincolo Fi Pi Li"},
	{"13192","Raccordo Collesalvetti - FiPiLi"},
	{"13193","Collesalvetti - Allacciamento Fi-Pi-Li"},
	{"13194","Brennero/Innesto Ss12 Dell'abetone E Brennero"},
	{"13195","Svincolo SS 309 Diramazione Ravenna"},
	{"13196","Svincolo Di Meina"},
	{"13197","Autostrada Caserta - Salerno"},
	{"13198",""},
	{"13199","Svincolo Mercato S.Severino"},
	{"13200",""},
	{"13201","Svincolo Area Retroportuale"},
	{"13202",""},
	{"13203","Allacciamento A15/Raccordo Lerici Porto Est"},
	{"13204","Raccordo La Spezia - Lerici"},
	{"13205","Porto Est"},
	{"13206","Svincolo Lerici"},
	{"13207",""},
	{"13208",""},
	{"13209","Allacciamento Ramo Lerici-S.S. 331"},
	{"13210","Raccordo SGC FiPiLi - A12"},
	{"13211",""},
	{"13212","Allacciamento A12 Direzione Livorno"},
	{"13213",""},
	{"13214","Allacciamento SGC FiPiLi"},
	{"13215","Raccordo SGC FiPiLi - Pisa"},
	{"13216",""},
	{"13217","Allacciamento Raccordo PI C./SGC FI-PI-LI"},
	{"13218",""},
	{"13219","Svincolo S.PIERO A GRADO-TIRRENIA"},
	{"13220",""},
	{"13221","Raccordo Sacile Ovest - SS13"},
	{"13222",""},
	{"13223",""},
	{"13224","Cornadella"},
	{"13225","Raccordo Sacile Est - SS13"},
	{"13226",""},
	{"13227",""},
	{"13228","San Giovanni al Tempio"},
	{"13229","Tangenziale di Udine"},
	{"13230",""},
	{"13231",""},
	{"13232","Udine Sud"},
	{"13233","SS56 Diramazione"},
	{"13234",""},
	{"13235","SS 52-Basaldella"},
	{"13236","VIA POPONE - VVFF"},
	{"13237",""},
	{"13238","Viale Venezia"},
	{"13239",""},
	{"13240","Viale Cadore"},
	{"13241",""},
	{"13242","Via Martignacco"},
	{"13243",""},
	{"13244","Via Spilinbergo"},
	{"13245",""},
	{"13246","UDINE FIERA - STADIO"},
	{"13247","Via Pagnacco"},
	{"13248","Feletto Umbro"},
	{"13249",""},
	{"13250","Allacciamento A23 Udine Nord"},
	{"13251",""},
	{"13252","Via Buonarroti"},
	{"13253",""},
	{"13254","Zona Industriale Tavagnacco"},
	{"13255",""},
	{"13256","SS13"},
	{"13257",""},
	{"13258","Complanare Milano-Poasco-Via Emilia"},
	{"13259",""},
	{"13260","Svincolo Via Emilia"},
	{"13261","Svincolo di Poasco"},
	{"13262","SVINCOLO VIA EMILIA-E.N.I."},
	{"13263","Raccordo A4 Milano - Viale Certosa"},
	{"13264","Raccordo La Spezia-Lerici"},
	{"13265","Raccordo La Spezia"},
	{"13266","Lerici"},
	{"13267","Raccordo FiPiLi"},
	{"13268","A12"},
	{"13269","SS13 Pontebbana"},
	{"13270","Milano Poasco"},
	{"13271","via Emilia"},
	{"13272","Innesto Ss12 Dell'abetone E Del Brennero"},
	{"13273","Tangenziale"},
	{"13274","Grontone"},
	{"13275","Case Pesci"},
	{"13276","Casacca"},
	{"13277","Gravagna"},
	{"13278","Lusuolo"},
	{"13279","Svincolo SS11 - Abbadia di Stura"},
	{"13280","Allacciamento Raccordo Falchera-A5/Tangenziale To"},
	{"13281","Rondissone sud"},
	{"13282","Allacciamento Diramazione Stroppiana-Santhia'-A4/A26"},
	{"13283","Ghisolfa Ovest - Tangenziale Ovest"},
	{"13284",""},
	{"13285",""},
	{"13286","Chieri"},
	{"13287","Livorno -Variante SS1 Aurelia (Porto)"},
	{"13288","Avigliana  Est"},
	{"13289","Avigliana  Ovest"},
	{"13290",""},
	{"13291","Circonvallazione Oulx"},
	{"13292",""},
	{"13293","Abbadia di Stura"},
	{"13294",""},
	{"13295",""},
	{"13296",""},
	{"13297",""},
	{"13298",""},
	{"13299",""},
	{"13300",""},
	{"13301","Ss25 Del Moncenisio"},
	{"13302",""},
	{"13303",""},
	{"13304","Savonera"},
	{"13305",""},
	{"13306",""},
	{"13307","Allacciamento Rn 205 / Tunnel M.Bianco"},
	{"13308",""},
	{"13309",""},
	{"13310","Route National 205"},
	{"13311","Controllo Merci"},
	{"13312","Traforo Monte Bianco"},
	{"13313","Passy &#8211, St. Gervais"},
	{"13314","Allacciamento RN205 / Controllo Merci Passy"},
	{"13315","Allacciamento Controllo Merci Passy / RN 205"},
	{"13316","Vigie"},
	{"13317","Allacciamento Rn205 / Controllo Merci Passy"},
	{"13318",""},
	{"13319",""},
	{"13320",""},
	{"13321","Route National 205 - Controllo Merci - S"},
	{"13322","Regolazione Passy"},
	{"13323","Passy"},
	{"13324",""},
	{"13325",""},
	{"13326",""},
	{"13327","Redipuglia - Monfalcone Ovest"},
	{"13328","Barriera Di Trieste Lisert - Monfalcone Est"},
	{"13329",""},
	{"13330","Svincolo Godega S.Urbano"},
	{"13331","Svincolo Villesse"},
	{"13332","Svincolo Gradisca"},
	{"13333","Svincolo Gorizia"},
	{"13334","Svincolo Farra"},
	{"13335",""},
	{"13336","Svincolo Autoporto Gorizia"},
	{"13337",""},
	{"13338","Campagnola"},
	{"13339","Val di Sona"},
	{"13340","San Lorenzo Est"},
	{"13341","San Lorenzo Ovest"},
	{"13342","Barberino di Mugello"},
	{"13343","Firenze Scandicci"},
	{"13344",""},
	{"13345","Allacciamento A1 Firenze Scandicci"},
	{"13346","Svincolo Empoli"},
	{"13347",""},
	{"13348",""},
	{"13349","Bologna Fiera"},
	{"13350",""},
	{"13351","Svincolo Via Triumvirato"},
	{"13352","Allacciamento A05-SS26DIR"},
	{"13353","Bressanone Zona Industriale"},
	{"13354","Ponte di Nona"},
	{"13355",""},
	{"13356","Raccordo Sasso Marconi-S.S. 64"},
	{"13357",""},
	{"13358",""},
	{"13359","Strada Provinciale 325"},
	{"13360","Svincolo Sasso Marconi"},
	{"13361","Mirafiori"},
	{"13362","Pinerolo"},
	{"13363",""},
	{"13364",""},
	{"13365","Svincolo Beinasco"},
	{"13366","Piscina"},
	{"13367","Riva"},
	{"13368","Innesto S.R. 23"},
	{"13369","Pianezza-Collegno - Ss24 Del Monginevro"},
	{"13370","Regina Margherita"},
	{"13371","Venaria-Stadio"},
	{"13372","Valli Di Lanzo-Borgaro"},
	{"13373","Settimo"},
	{"13374","Torino Nord - A5 To-Aosta"},
	{"13375",""},
	{"13376","Valeggia Nord"},
	{"13377",""},
	{"13378",""},
	{"13379",""},
	{"13380","Svincolo per Porto"},
	{"13381","Svincolo Venezia"},
	{"13382",""},
	{"13383",""},
	{"13384","Raccordo A10 &#8211, A06 al Km 44"},
	{"13385","Raccordo A10 &#8211, A06 al Km 45"},
	{"13386",""},
	{"13387","Allcciamento A12 - Lucca"},
	{"13388","Allcciamento A12 &#8211, Pisa"},
	{"13389",""},
	{"13390","Rovigo Sud &#8211, Villa Marzana"},
	{"13391","Allacciamento Raccordo A1-A21 Brescia"},
	{"13392","Settecamini (C.A.R.)"},
	{"13393",""},
	{"13394","Cartecchio"},
	{"13395",""},
	{"13396","Svincolo Capodichino"},
	{"13397",""},
	{"13398","Allacciamento SGC Fi-Pi-Li"},
	{"13399","Svincolo Cascina Ghisolfa"},
	{"13400","Svincolo San Donato"},
	{"13401","Complanare di Piacenza"},
	{"13402","Nodo A1/A21 km 55"},
	{"13403","Nodo A1/A21 km 58"},
	{"13404","Nodo A21/A1 Torino"},
	{"13405","Nodo A21/A1 Brescia"},
	{"13406","Interconnessione A21"},
	{"13407","Fiorenzuola"},
	{"13408",""},
	{"13409","Complanare Controllo merci"},
	{"13410","A05"},
	{"13411","Allacciamento A05/Controllo Merci Aosta"},
	{"13412","Regolazione Aosta"},
	{"13413","Controllo Merci Aosta / Allacciamento A05"},
	{"13414",""},
	{"13415","Svincolo di Vadò"},
	{"13416","Interscambio Diramazione per Moncalieri"},
	{"13417","Interscambio Drosso"},
	{"13418","Interconnessione Tangenziale Nord"},
	{"13419","Alpi Graie"},
	{"13420","Interconnesione Tangenziale Sud"},
	{"13421","Interconnesione diramazione Pescarito"},
	{"13422","Interconnesione Tangenziale Nord"},
	{"13423","Interconessione SS11 Padana Superiore"},
	{"13424","Interconnessione Tangenziale Sud"},
	{"13425","Beinasco Nord"},
	{"13426","Svincolo Torino Corso Giulio Cesare"},
	{"13427","Diramazione Per Viareggio"},
	{"13428","A11/A12"},
	{"13429","Allacciamento  A12/A11 Viareggio (R59)"},
	{"13430","Viareggio Città"},
	{"13431",""},
	{"13432","Allacciamento D11 - Diramazione Viareggio"},
	{"13433","Aosta Gran S. Bernardo"},
	{"13434",""},
	{"13435","Beinasco Sud"},
	{"13436","Barriera Di Aosta  Monte Bianco"},
	{"13437","A06"},
	{"13438","Interconnessione Marene"},
	{"13439","Bra/ Marene"},
	{"13440",""},
	{"13441","GRA"},
	{"13442","Appia"},
	{"13443","Svincolo Per Ss16"},
	{"13444","La Spezia Porto est /Via Valdilocchi"},
	{"13445","Allacciamento FiPiLi"}};
