/* original parser id follows */
/* yysccsid[] = "@(#)yaccpar	1.9 (Berkeley) 02/21/93" */
/* (use YYMAJOR/YYMINOR for ifdefs dependent on parser version) */

#define YYBYACC 1
#define YYMAJOR 2
#define YYMINOR 0
#define YYPATCH 20230201

#define YYEMPTY        (-1)
#define yyclearin      (yychar = YYEMPTY)
#define yyerrok        (yyerrflag = 0)
#define YYRECOVERING() (yyerrflag != 0)
#define YYENOMEM       (-2)
#define YYEOF          0
#undef YYBTYACC
#define YYBTYACC 0
#define YYDEBUGSTR YYPREFIX "debug"
#define YYPREFIX "yy"

#define YYPURE 0

#line 25 "parse.y"

#include <sys/queue.h>

#include <ctype.h>
#include <err.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <stdint.h>
#include <string.h>
#include <unistd.h>

#include "got_compat.h"

#ifndef nitems
#define nitems(_a) (sizeof((_a)) / sizeof((_a)[0]))
#endif

TAILQ_HEAD(files, file)		 files = TAILQ_HEAD_INITIALIZER(files);
static struct file {
	TAILQ_ENTRY(file)	 entry;
	FILE			*stream;
	char			*name;
	size_t			 ungetpos;
	size_t			 ungetsize;
	unsigned char		*ungetbuf;
	int			 eof_reached;
	int			 lineno;
	int			 errors;
} *file, *topfile;
int		 parse(FILE *, const char *);
struct file	*pushfile(const char *, int);
int		 popfile(void);
int		 yyparse(void);
int		 yylex(void);
int		 yyerror(const char *, ...)
    __attribute__((__format__ (printf, 1, 2)))
    __attribute__((__nonnull__ (1)));
int		 kw_cmp(const void *, const void *);
int		 lookup(char *);
int		 igetc(void);
int		 lgetc(int);
void		 lungetc(int);
int		 findeol(void);

void		 dbg(void);
void		 printq(const char *);

extern int	 nodebug;

static FILE	*fp;

static int	 block;
static int	 in_define;
static int	 errors;
static int	 lastline = -1;

typedef struct {
	union {
		char		*string;
	} v;
	int lineno;
} YYSTYPE;

#line 89 "parse.c"

/* compatibility with bison */
#ifdef YYPARSE_PARAM
/* compatibility with FreeBSD */
# ifdef YYPARSE_PARAM_TYPE
#  define YYPARSE_DECL() yyparse(YYPARSE_PARAM_TYPE YYPARSE_PARAM)
# else
#  define YYPARSE_DECL() yyparse(void *YYPARSE_PARAM)
# endif
#else
# define YYPARSE_DECL() yyparse(void)
#endif

/* Parameters sent to lex. */
#ifdef YYLEX_PARAM
# define YYLEX_DECL() yylex(void *YYLEX_PARAM)
# define YYLEX yylex(YYLEX_PARAM)
#else
# define YYLEX_DECL() yylex(void)
# define YYLEX yylex()
#endif

#if !(defined(yylex) || defined(YYSTATE))
int YYLEX_DECL();
#endif

/* Parameters sent to yyerror. */
#ifndef YYERROR_DECL
#define YYERROR_DECL() yyerror(const char *s)
#endif
#ifndef YYERROR_CALL
#define YYERROR_CALL(msg) yyerror(msg)
#endif

extern int YYPARSE_DECL();

#define DEFINE 257
#define ELSE 258
#define END 259
#define ERROR 260
#define FINALLY 261
#define FOR 262
#define IF 263
#define INCLUDE 264
#define PRINTF 265
#define RENDER 266
#define TQFOREACH 267
#define UNSAFE 268
#define URLESCAPE 269
#define WHILE 270
#define STRING 271
#define YYERRCODE 256
typedef int YYINT;
static const YYINT yylhs[] = {                           -1,
    0,    0,    0,    0,    0,    3,    4,    6,    6,    7,
    7,    8,    5,    5,    9,   10,   10,   10,   10,   13,
   13,   13,   13,   13,   13,   13,   19,   14,   18,   18,
   15,   16,   16,   16,   21,   20,   22,   17,   23,   17,
   24,   17,   11,   25,   12,    1,    1,    2,    2,    2,
};
static const YYINT yylen[] = {                            2,
    0,    2,    2,    2,    2,    2,    3,    0,    2,    0,
    2,    1,    3,    4,    4,    0,    2,    2,    2,    4,
    1,    3,    1,    5,    5,    3,    0,    5,    0,    2,
    4,    1,    3,    3,    5,    3,    0,    7,    0,    9,
    0,    7,    3,    0,    5,    2,    1,    1,    2,    2,
};
static const YYINT yydefred[] = {                         1,
    0,    5,    0,    8,    0,    2,    3,    4,   16,    6,
    0,    0,    0,    9,    7,    0,    0,   12,    0,   17,
   18,   13,    0,   19,   21,   16,   23,   46,   15,    0,
    0,    0,    0,   27,    0,    0,    0,    0,    0,   14,
    0,   43,   44,    0,    0,    0,    0,   29,    0,    0,
    0,   26,    0,    0,   32,   22,   16,   16,   10,   49,
   50,   37,   31,    0,   20,    0,   41,    0,    0,    0,
    0,    0,    0,   16,   30,   28,    0,   16,   24,   25,
    0,   36,    0,   33,   34,   11,    0,   39,    0,    0,
   38,   16,   42,   35,    0,   40,
};
#if defined(YYDESTRUCT_CALL) || defined(YYSTYPE_TOSTRING)
static const YYINT yystos[] = {                           0,
  273,  256,  264,   33,  123,  276,  277,  278,  282,  271,
  279,  257,  283,  271,   33,  271,  274,  271,  123,  277,
  281,  284,  285,  286,  287,  288,  290,  274,  125,  259,
  261,  262,  263,  265,  266,  267,  270,  274,  123,  284,
  283,  125,  125,  271,  124,  275,  275,  292,  274,  271,
  275,  125,  124,  123,  284,  289,  293,  294,  298,  275,
  275,  125,  125,  291,  125,  271,  125,  268,  269,  258,
  283,  283,  280,  295,  271,  125,  271,  297,  125,  125,
  263,  125,  123,  284,  289,  277,  283,  125,  283,  275,
  284,  296,  284,  125,  283,  284,
};
#endif /* YYDESTRUCT_CALL || YYSTYPE_TOSTRING */
static const YYINT yydgoto[] = {                          1,
   38,   46,    6,   20,    8,   11,   73,   21,    9,   13,
   55,   23,   24,   25,   26,   56,   27,   64,   48,   57,
   58,   74,   92,   78,   59,
};
static const YYINT yysindex[] = {                         0,
  -29,    0, -259,    0, -243,    0,    0,    0,    0,    0,
  -30, -245,  -33,    0,    0, -245,  -88,    0, -216,    0,
    0,    0,  -85,    0,    0,    0,    0,    0,    0,  -86,
  -81, -119, -119,    0, -245, -231, -119, -106, -211,    0,
  -32,    0,    0, -119, -119,  -73,  -72,    0,  -69, -214,
  -65,    0, -234, -238,    0,    0,    0,    0,    0,    0,
    0,    0,    0, -118,    0, -210,    0,  -60,  -57, -117,
  -31,  -32,   39,    0,    0,    0,  -52,    0,    0,    0,
 -119,    0, -196,    0,    0,    0,  -31,    0,  -31,  -48,
    0,    0,    0,    0,  -31,    0,
};
static const YYINT yyrindex[] = {                         0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  -94,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  -47,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  -44,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,
};
#if YYBTYACC
static const YYINT yycindex[] = {                         0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,
};
#endif
static const YYINT yygindex[] = {                         0,
    1,  -22,    0,    8,    0,    0,    0,    0,    0,  -16,
   -7,    0,    0,    0,    0,   11,    0,    0,    0,    0,
    0,    0,    0,    0,    0,
};
#define YYTABLESIZE 241
static const YYINT yytable[] = {                          4,
    4,    4,   15,    4,   45,   22,   76,   82,    7,   41,
   47,   10,   17,   12,   51,   40,   28,   53,   52,   70,
   30,   60,   61,   32,   33,   16,   34,   35,   36,   47,
   47,   37,   16,   68,   69,   49,   29,   39,   42,   50,
   71,   72,   30,   43,   31,   32,   33,   30,   34,   35,
   36,   62,   63,   37,   16,   65,   66,   87,   90,   67,
   77,   89,   30,   84,   79,   32,   33,   80,   34,   35,
   36,    4,   88,   37,   16,   95,   94,   48,   45,   91,
   86,   93,   85,    0,    0,    0,    0,   96,    0,   19,
   54,   83,    0,    5,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   81,    0,    0,    0,    0,
    0,   44,   75,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    2,    0,    0,    0,
    0,    0,    0,    0,    3,    0,    0,   18,   18,   18,
   14,
};
static const YYINT yycheck[] = {                         33,
   33,   33,   33,   33,  124,   13,  125,  125,    1,   26,
   33,  271,   12,  257,   37,   23,   16,  124,  125,  258,
  259,   44,   45,  262,  263,  271,  265,  266,  267,  124,
  125,  270,  271,  268,  269,   35,  125,  123,  125,  271,
   57,   58,  259,  125,  261,  262,  263,  259,  265,  266,
  267,  125,  125,  270,  271,  125,  271,   74,   81,  125,
  271,   78,  259,   71,  125,  262,  263,  125,  265,  266,
  267,   33,  125,  270,  271,   92,  125,  125,  123,   87,
   73,   89,   72,   -1,   -1,   -1,   -1,   95,   -1,  123,
  123,  123,   -1,  123,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  263,   -1,   -1,   -1,   -1,
   -1,  271,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  264,   -1,   -1,  271,  271,  271,
  271,
};
#if YYBTYACC
static const YYINT yyctable[] = {                        -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
};
#endif
#define YYFINAL 1
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 271
#define YYUNDFTOKEN 299
#define YYTRANSLATE(a) ((a) > YYMAXTOKEN ? YYUNDFTOKEN : (a))
#if YYDEBUG
static const char *const yyname[] = {

"$end",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'!'",0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,"'{'","'|'","'}'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"error","DEFINE","ELSE",
"END","ERROR","FINALLY","FOR","IF","INCLUDE","PRINTF","RENDER","TQFOREACH",
"UNSAFE","URLESCAPE","WHILE","STRING","$accept","grammar","string","stringy",
"include","verbatim","block","verbatim1","verbatims","raw","define","body",
"end","finally","special","printf","if","endif","loop","printfargs","$$1",
"else","elsif","$$2","$$3","$$4","$$5","illegal-symbol",
};
static const char *const yyrule[] = {
"$accept : grammar",
"grammar :",
"grammar : grammar include",
"grammar : grammar verbatim",
"grammar : grammar block",
"grammar : grammar error",
"include : INCLUDE STRING",
"verbatim : '!' verbatim1 '!'",
"verbatim1 :",
"verbatim1 : verbatim1 STRING",
"verbatims :",
"verbatims : verbatims verbatim",
"raw : STRING",
"block : define body end",
"block : define body finally end",
"define : '{' DEFINE string '}'",
"body :",
"body : body verbatim",
"body : body raw",
"body : body special",
"special : '{' RENDER string '}'",
"special : printf",
"special : if body endif",
"special : loop",
"special : '{' string '|' UNSAFE '}'",
"special : '{' string '|' URLESCAPE '}'",
"special : '{' string '}'",
"$$1 :",
"printf : '{' PRINTF $$1 printfargs '}'",
"printfargs :",
"printfargs : printfargs STRING",
"if : '{' IF stringy '}'",
"endif : end",
"endif : else body end",
"endif : elsif body endif",
"elsif : '{' ELSE IF stringy '}'",
"else : '{' ELSE '}'",
"$$2 :",
"loop : '{' FOR stringy '}' $$2 body end",
"$$3 :",
"loop : '{' TQFOREACH STRING STRING STRING '}' $$3 body end",
"$$4 :",
"loop : '{' WHILE stringy '}' $$4 body end",
"end : '{' END '}'",
"$$5 :",
"finally : '{' FINALLY '}' $$5 verbatims",
"string : STRING string",
"string : STRING",
"stringy : STRING",
"stringy : STRING stringy",
"stringy : '|' stringy",

};
#endif

#if YYDEBUG
int      yydebug;
#endif

int      yyerrflag;
int      yychar;
YYSTYPE  yyval;
YYSTYPE  yylval;
int      yynerrs;

/* define the initial stack-sizes */
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH  YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH  10000
#endif
#endif

#define YYINITSTACKSIZE 200

typedef struct {
    unsigned stacksize;
    YYINT    *s_base;
    YYINT    *s_mark;
    YYINT    *s_last;
    YYSTYPE  *l_base;
    YYSTYPE  *l_mark;
} YYSTACKDATA;
/* variables for the parser stack */
static YYSTACKDATA yystack;
#line 319 "parse.y"

struct keywords {
	const char	*k_name;
	int		 k_val;
};

int
yyerror(const char *fmt, ...)
{
	va_list	 ap;
	char	*msg;

	file->errors++;
	va_start(ap, fmt);
	if (vasprintf(&msg, fmt, ap) == -1)
		err(1, "yyerror vasprintf");
	va_end(ap);
	fprintf(stderr, "%s:%d: %s\n", file->name, yylval.lineno, msg);
	free(msg);
	return (0);
}

int
kw_cmp(const void *k, const void *e)
{
	return (strcmp(k, ((const struct keywords *)e)->k_name));
}

int
lookup(char *s)
{
	/* this has to be sorted always */
	static const struct keywords keywords[] = {
		{ "define",		DEFINE },
		{ "else",		ELSE },
		{ "end",		END },
		{ "finally",		FINALLY },
		{ "for",		FOR },
		{ "if",			IF },
		{ "include",		INCLUDE },
		{ "printf",		PRINTF },
		{ "render",		RENDER },
		{ "tailq-foreach",	TQFOREACH },
		{ "unsafe",		UNSAFE },
		{ "urlescape",		URLESCAPE },
		{ "while",		WHILE },
	};
	const struct keywords	*p;

	p = bsearch(s, keywords, nitems(keywords), sizeof(keywords[0]),
	    kw_cmp);

	if (p)
		return (p->k_val);
	else
		return (STRING);
}

#define START_EXPAND	1
#define DONE_EXPAND	2

static int	expanding;

int
igetc(void)
{
	int	c;

	while (1) {
		if (file->ungetpos > 0)
			c = file->ungetbuf[--file->ungetpos];
		else
			c = getc(file->stream);

		if (c == START_EXPAND)
			expanding = 1;
		else if (c == DONE_EXPAND)
			expanding = 0;
		else
			break;
	}
	return (c);
}

int
lgetc(int quotec)
{
	int		c;

	if (quotec) {
		if ((c = igetc()) == EOF) {
			yyerror("reached end of filewhile parsing "
			    "quoted string");
			if (file == topfile || popfile() == EOF)
				return (EOF);
			return (quotec);
		}
		return (c);
	}

	c = igetc();
	if (c == '\t' || c == ' ') {
		/* Compress blanks to a sigle space. */
		do {
			c = getc(file->stream);
		} while (c == '\t'  || c == ' ');
		ungetc(c, file->stream);
		c = ' ';
	}

	if (c == EOF) {
		/*
		 * Fake EOL when hit EOF for the first time. This gets line
		 * count rigchtif last line included file is syntactically
		 * invalid and has no newline.
		 */
		if (file->eof_reached == 0) {
			file->eof_reached = 1;
			return ('\n');
		}
		while (c == EOF) {
			if (file == topfile || popfile() == EOF)
				return (EOF);
			c = igetc();
		}
	}
	return (c);
}

void
lungetc(int c)
{
	if (c == EOF)
		return;

	if (file->ungetpos >= file->ungetsize) {
		void *p = reallocarray(file->ungetbuf, file->ungetsize, 2);
		if (p == NULL)
			err(1, "reallocarray");
		file->ungetbuf = p;
		file->ungetsize *= 2;
	}
	file->ungetbuf[file->ungetpos++] = c;
}

int
findeol(void)
{
	int	c;

	/* skip to either EOF or the first real EOL */
	while (1) {
		c = lgetc(0);
		if (c == '\n') {
			file->lineno++;
			break;
		}
		if (c == EOF)
			break;
	}
	return (ERROR);
}

int
yylex(void)
{
	char		 buf[8096];
	char		*p = buf;
	int		 c;
	int		 token;
	int		 starting = 0;
	int		 ending = 0;
	int		 quote = 0;

	if (!in_define && block == 0) {
		while ((c = lgetc(0)) != '{' && c != EOF) {
			if (c == '\n')
				file->lineno++;
		}

		if (c == EOF)
			return (0);

newblock:
		c = lgetc(0);
		if (c == '{' || c == '!') {
			if (c == '{')
				block = '}';
			else
				block = c;
			return (c);
		}
		if (c == '\n')
			file->lineno++;
	}

	while ((c = lgetc(0)) == ' ' || c == '\t' || c == '\n') {
		if (c == '\n')
			file->lineno++;
	}

	if (c == EOF) {
		yyerror("unterminated block");
		return (0);
	}

	yylval.lineno = file->lineno;

	if (block != 0 && c == block) {
		if ((c = lgetc(0)) == '}') {
			if (block == '!') {
				block = 0;
				return ('!');
			}
			block = 0;
			return ('}');
		}
		lungetc(c);
		c = block;
	}

	if (in_define && block == 0) {
		if (c == '{')
			goto newblock;

		do {
			if (starting) {
				if (c == '!' || c == '{') {
					lungetc(c);
					lungetc('{');
					break;
				}
				starting = 0;
				lungetc(c);
				c = '{';
			} else if (c == '{') {
				starting = 1;
				continue;
			}

			*p++ = c;
			if ((size_t)(p - buf) >= sizeof(buf)) {
				yyerror("string too long");
				return (findeol());
			}
		} while ((c = lgetc(0)) != EOF && c != '\n');
		*p = '\0';
		if (c == EOF) {
			yyerror("unterminated block");
			return (0);
		}
		if (c == '\n')
			file->lineno++;
		if ((yylval.v.string = strdup(buf)) == NULL)
			err(1, "strdup");
		return (STRING);
	}

	if (block == '!') {
		do {
			if (ending) {
				if (c == '}') {
					lungetc(c);
					lungetc(block);
					break;
				}
				ending = 0;
				lungetc(c);
				c = block;
			} else if (c == '!') {
				ending = 1;
				continue;
			}

			*p++ = c;
			if ((size_t)(p - buf) >= sizeof(buf)) {
				yyerror("line too long");
				return (findeol());
			}
		} while ((c = lgetc(0)) != EOF && c != '\n');
		*p = '\0';

		if (c == EOF) {
			yyerror("unterminated block");
			return (0);
		}
		if (c == '\n')
			file->lineno++;

		if ((yylval.v.string = strdup(buf)) == NULL)
			err(1, "strdup");
		return (STRING);
	}

	if (c == '|')
		return (c);

	do {
		if (!quote && isspace((unsigned char)c))
			break;

		if (c == '"')
			quote = !quote;

		if (!quote && c == '|') {
			lungetc(c);
			break;
		}

		if (ending) {
			if (c == '}') {
				lungetc(c);
				lungetc('}');
				break;
			}
			ending = 0;
			lungetc(c);
			c = block;
		} else if (!quote && c == '}') {
			ending = 1;
			continue;
		}

		*p++ = c;
		if ((size_t)(p - buf) >= sizeof(buf)) {
			yyerror("string too long");
			return (findeol());
		}
	} while ((c = lgetc(0)) != EOF);
	*p = '\0';

	if (c == EOF) {
		yyerror(quote ? "unterminated quote" : "unterminated block");
		return (0);
	}
	if (c ==  '\n')
		file->lineno++;
	if ((token = lookup(buf)) == STRING)
		if ((yylval.v.string = strdup(buf)) == NULL)
			err(1, "strdup");
	return (token);
}

struct file *
pushfile(const char *name, int secret)
{
	struct file	*nfile;

	if ((nfile = calloc(1, sizeof(*nfile))) == NULL)
		err(1, "calloc");
	if ((nfile->name = strdup(name)) == NULL)
		err(1, "strdup");
	if ((nfile->stream = fopen(nfile->name, "r")) == NULL) {
		warn("can't open %s", nfile->name);
		free(nfile->name);
		free(nfile);
		return (NULL);
	}
	nfile->lineno = TAILQ_EMPTY(&files) ? 1 : 0;
	nfile->ungetsize = 16;
	nfile->ungetbuf = malloc(nfile->ungetsize);
	if (nfile->ungetbuf == NULL)
		err(1, "malloc");
	TAILQ_INSERT_TAIL(&files, nfile, entry);
	return (nfile);
}

int
popfile(void)
{
	struct file	*prev;

	if ((prev = TAILQ_PREV(file, files, entry)) != NULL)
		prev->errors += file->errors;

	TAILQ_REMOVE(&files, file, entry);
	fclose(file->stream);
	free(file->name);
	free(file->ungetbuf);
	free(file);
	file = prev;
	return (file ? 0 : EOF);
}

int
parse(FILE *outfile, const char *filename)
{
	fp = outfile;

	if ((file = pushfile(filename, 0)) == 0)
		return (-1);
	topfile = file;

	yyparse();
	errors = file->errors;
	popfile();

	return (errors ? -1 : 0);
}

void
dbg(void)
{
	if (nodebug)
		return;

	if (yylval.lineno == lastline + 1) {
		lastline = yylval.lineno;
		return;
	}
	lastline = yylval.lineno;

	fprintf(fp, "#line %d ", yylval.lineno);
	printq(file->name);
	putc('\n', fp);
}

void
printq(const char *str)
{
	putc('"', fp);
	for (; *str; ++str) {
		if (*str == '"')
			putc('\\', fp);
		putc(*str, fp);
	}
	putc('"', fp);
}
#line 857 "parse.c"

#if YYDEBUG
#include <stdio.h>	/* needed for printf */
#endif

#include <stdlib.h>	/* needed for malloc, etc */
#include <string.h>	/* needed for memset */

/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(YYSTACKDATA *data)
{
    int i;
    unsigned newsize;
    YYINT *newss;
    YYSTYPE *newvs;

    if ((newsize = data->stacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return YYENOMEM;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;

    i = (int) (data->s_mark - data->s_base);
    newss = (YYINT *)realloc(data->s_base, newsize * sizeof(*newss));
    if (newss == NULL)
        return YYENOMEM;

    data->s_base = newss;
    data->s_mark = newss + i;

    newvs = (YYSTYPE *)realloc(data->l_base, newsize * sizeof(*newvs));
    if (newvs == NULL)
        return YYENOMEM;

    data->l_base = newvs;
    data->l_mark = newvs + i;

    data->stacksize = newsize;
    data->s_last = data->s_base + newsize - 1;
    return 0;
}

#if YYPURE || defined(YY_NO_LEAKS)
static void yyfreestack(YYSTACKDATA *data)
{
    free(data->s_base);
    free(data->l_base);
    memset(data, 0, sizeof(*data));
}
#else
#define yyfreestack(data) /* nothing */
#endif

#define YYABORT  goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR  goto yyerrlab

int
YYPARSE_DECL()
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")) != NULL)
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    /* yym is set below */
    /* yyn is set below */
    yynerrs = 0;
    yyerrflag = 0;
    yychar = YYEMPTY;
    yystate = 0;

#if YYPURE
    memset(&yystack, 0, sizeof(yystack));
#endif

    if (yystack.s_base == NULL && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
    yystack.s_mark = yystack.s_base;
    yystack.l_mark = yystack.l_base;
    yystate = 0;
    *yystack.s_mark = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
        yychar = YYLEX;
        if (yychar < 0) yychar = YYEOF;
#if YYDEBUG
        if (yydebug)
        {
            if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if (((yyn = yysindex[yystate]) != 0) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
        yystate = yytable[yyn];
        *++yystack.s_mark = yytable[yyn];
        *++yystack.l_mark = yylval;
        yychar = YYEMPTY;
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if (((yyn = yyrindex[yystate]) != 0) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag != 0) goto yyinrecovery;

    YYERROR_CALL("syntax error");

    goto yyerrlab; /* redundant goto avoids 'unused label' warning */
yyerrlab:
    ++yynerrs;

yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if (((yyn = yysindex[*yystack.s_mark]) != 0) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yystack.s_mark, yytable[yyn]);
#endif
                if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
                yystate = yytable[yyn];
                *++yystack.s_mark = yytable[yyn];
                *++yystack.l_mark = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yystack.s_mark);
#endif
                if (yystack.s_mark <= yystack.s_base) goto yyabort;
                --yystack.s_mark;
                --yystack.l_mark;
            }
        }
    }
    else
    {
        if (yychar == YYEOF) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = YYEMPTY;
        goto yyloop;
    }

yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    if (yym > 0)
        yyval = yystack.l_mark[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);

    switch (yyn)
    {
case 5:
#line 103 "parse.y"
	{ file->errors++; }
#line 1059 "parse.c"
break;
case 6:
#line 106 "parse.y"
	{
			struct file	*nfile;

			if ((nfile = pushfile(yystack.l_mark[0].v.string, 0)) == NULL) {
				yyerror("failed to include file %s", yystack.l_mark[0].v.string);
				free(yystack.l_mark[0].v.string);
				YYERROR;
			}
			free(yystack.l_mark[0].v.string);

			file = nfile;
			lungetc('\n');
		}
#line 1076 "parse.c"
break;
case 7:
#line 121 "parse.y"
	{
			if (in_define) {
				/* TODO: check template status and exit in case */
			}
		}
#line 1085 "parse.c"
break;
case 9:
#line 129 "parse.y"
	{
			if (*yystack.l_mark[0].v.string != '\0') {
				dbg();
				fprintf(fp, "%s\n", yystack.l_mark[0].v.string);
			}
			free(yystack.l_mark[0].v.string);
		}
#line 1096 "parse.c"
break;
case 12:
#line 142 "parse.y"
	{
			dbg();
			fprintf(fp, "if ((tp_ret = tp->tp_puts(tp, ");
			printq(yystack.l_mark[0].v.string);
			fputs(")) == -1) goto err;\n", fp);

			free(yystack.l_mark[0].v.string);
		}
#line 1108 "parse.c"
break;
case 13:
#line 152 "parse.y"
	{
			fputs("err:\n", fp);
			fputs("return tp_ret;\n", fp);
			fputs("}\n", fp);
			in_define = 0;
		}
#line 1118 "parse.c"
break;
case 14:
#line 158 "parse.y"
	{
			fputs("return tp_ret;\n", fp);
			fputs("}\n", fp);
			in_define = 0;
		}
#line 1127 "parse.c"
break;
case 15:
#line 165 "parse.y"
	{
			in_define = 1;

			dbg();
			fprintf(fp, "int\n%s\n{\n", yystack.l_mark[-1].v.string);
			fputs("int tp_ret = 0;\n", fp);

			free(yystack.l_mark[-1].v.string);
		}
#line 1140 "parse.c"
break;
case 20:
#line 182 "parse.y"
	{
			dbg();
			fprintf(fp, "if ((tp_ret = %s) == -1) goto err;\n",
			    yystack.l_mark[-1].v.string);
			free(yystack.l_mark[-1].v.string);
		}
#line 1150 "parse.c"
break;
case 22:
#line 189 "parse.y"
	{ fputs("}\n", fp); }
#line 1155 "parse.c"
break;
case 24:
#line 191 "parse.y"
	{
			dbg();
			fprintf(fp,
			    "if ((tp_ret = tp->tp_puts(tp, %s)) == -1)\n",
			    yystack.l_mark[-3].v.string);
			fputs("goto err;\n", fp);
			free(yystack.l_mark[-3].v.string);
		}
#line 1167 "parse.c"
break;
case 25:
#line 199 "parse.y"
	{
			dbg();
			fprintf(fp,
			    "if ((tp_ret = tp_urlescape(tp, %s)) == -1)\n",
			    yystack.l_mark[-3].v.string);
			fputs("goto err;\n", fp);
			free(yystack.l_mark[-3].v.string);
		}
#line 1179 "parse.c"
break;
case 26:
#line 207 "parse.y"
	{
			dbg();
			fprintf(fp,
			    "if ((tp_ret = tp->tp_escape(tp, %s)) == -1)\n",
			    yystack.l_mark[-1].v.string);
			fputs("goto err;\n", fp);
			free(yystack.l_mark[-1].v.string);
		}
#line 1191 "parse.c"
break;
case 27:
#line 217 "parse.y"
	{
			dbg();
			fprintf(fp, "if (asprintf(&tp->tp_tmp, ");
		}
#line 1199 "parse.c"
break;
case 28:
#line 220 "parse.y"
	{
			fputs(") == -1)\n", fp);
			fputs("goto err;\n", fp);
			fputs("if ((tp_ret = tp->tp_escape(tp, tp->tp_tmp)) "
			    "== -1)\n", fp);
			fputs("goto err;\n", fp);
			fputs("free(tp->tp_tmp);\n", fp);
			fputs("tp->tp_tmp = NULL;\n", fp);
		}
#line 1212 "parse.c"
break;
case 30:
#line 232 "parse.y"
	{
			fprintf(fp, " %s", yystack.l_mark[0].v.string);
			free(yystack.l_mark[0].v.string);
		}
#line 1220 "parse.c"
break;
case 31:
#line 238 "parse.y"
	{
			dbg();
			fprintf(fp, "if (%s) {\n", yystack.l_mark[-1].v.string);
			free(yystack.l_mark[-1].v.string);
		}
#line 1229 "parse.c"
break;
case 35:
#line 250 "parse.y"
	{
			dbg();
			fprintf(fp, "} else if (%s) {\n", yystack.l_mark[-1].v.string);
			free(yystack.l_mark[-1].v.string);
		}
#line 1238 "parse.c"
break;
case 36:
#line 257 "parse.y"
	{
			dbg();
			fputs("} else {\n", fp);
		}
#line 1246 "parse.c"
break;
case 37:
#line 263 "parse.y"
	{
			fprintf(fp, "for (%s) {\n", yystack.l_mark[-1].v.string);
			free(yystack.l_mark[-1].v.string);
		}
#line 1254 "parse.c"
break;
case 38:
#line 266 "parse.y"
	{
			fputs("}\n", fp);
		}
#line 1261 "parse.c"
break;
case 39:
#line 269 "parse.y"
	{
			fprintf(fp, "TAILQ_FOREACH(%s, %s, %s) {\n",
			    yystack.l_mark[-3].v.string, yystack.l_mark[-2].v.string, yystack.l_mark[-1].v.string);
			free(yystack.l_mark[-3].v.string);
			free(yystack.l_mark[-2].v.string);
			free(yystack.l_mark[-1].v.string);
		}
#line 1272 "parse.c"
break;
case 40:
#line 275 "parse.y"
	{
			fputs("}\n", fp);
		}
#line 1279 "parse.c"
break;
case 41:
#line 278 "parse.y"
	{
			fprintf(fp, "while (%s) {\n", yystack.l_mark[-1].v.string);
			free(yystack.l_mark[-1].v.string);
		}
#line 1287 "parse.c"
break;
case 42:
#line 281 "parse.y"
	{
			fputs("}\n", fp);
		}
#line 1294 "parse.c"
break;
case 44:
#line 289 "parse.y"
	{
			dbg();
			fputs("err:\n", fp);
		}
#line 1302 "parse.c"
break;
case 46:
#line 295 "parse.y"
	{
			if (asprintf(&yyval.v.string, "%s %s", yystack.l_mark[-1].v.string, yystack.l_mark[0].v.string) == -1)
				err(1, "asprintf");
			free(yystack.l_mark[-1].v.string);
			free(yystack.l_mark[0].v.string);
		}
#line 1312 "parse.c"
break;
case 49:
#line 305 "parse.y"
	{
			if (asprintf(&yyval.v.string, "%s %s", yystack.l_mark[-1].v.string, yystack.l_mark[0].v.string) == -1)
				err(1, "asprintf");
			free(yystack.l_mark[-1].v.string);
			free(yystack.l_mark[0].v.string);
		}
#line 1322 "parse.c"
break;
case 50:
#line 311 "parse.y"
	{
			if (asprintf(&yyval.v.string, "|%s", yystack.l_mark[0].v.string) == -1)
				err(1, "asprintf");
			free(yystack.l_mark[0].v.string);
		}
#line 1331 "parse.c"
break;
#line 1333 "parse.c"
    }
    yystack.s_mark -= yym;
    yystate = *yystack.s_mark;
    yystack.l_mark -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yystack.s_mark = YYFINAL;
        *++yystack.l_mark = yyval;
        if (yychar < 0)
        {
            yychar = YYLEX;
            if (yychar < 0) yychar = YYEOF;
#if YYDEBUG
            if (yydebug)
            {
                if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == YYEOF) goto yyaccept;
        goto yyloop;
    }
    if (((yyn = yygindex[yym]) != 0) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yystack.s_mark, yystate);
#endif
    if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
    *++yystack.s_mark = (YYINT) yystate;
    *++yystack.l_mark = yyval;
    goto yyloop;

yyoverflow:
    YYERROR_CALL("yacc stack overflow");

yyabort:
    yyfreestack(&yystack);
    return (1);

yyaccept:
    yyfreestack(&yystack);
    return (0);
}
