"""Generated message classes for biglake version v1.

The BigLake API provides access to BigLake Metastore, a serverless, fully
managed, and highly available metastore for open-source data that can be used
for querying Apache Iceberg tables in BigQuery.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'biglake'


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts `jose@example.com` from DATA_READ logging, and
  `aliya@example.com` from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsCreateRequest(_messages.Message):
  r"""A BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsCreateRequest
  object.

  Fields:
    iceberg_catalog_id: Required. The name of the catalog.
    icebergCatalog: A IcebergCatalog resource to be passed as the request
      body.
    parent: Required. The parent resource where this catalog will be created.
      Format: projects/{project_id}
  """

  iceberg_catalog_id = _messages.StringField(1)
  icebergCatalog = _messages.MessageField('IcebergCatalog', 2)
  parent = _messages.StringField(3, required=True)


class BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsDeleteRequest(_messages.Message):
  r"""A BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsDeleteRequest
  object.

  Fields:
    name: Required. The catalog to delete.
  """

  name = _messages.StringField(1, required=True)


class BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsFailoverRequest(_messages.Message):
  r"""A BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsFailoverRequest
  object.

  Fields:
    failoverIcebergCatalogRequest: A FailoverIcebergCatalogRequest resource to
      be passed as the request body.
    name: Required. The name of the catalog in the form
      "projects/{project_id}/catalogs/{catalog_id}"
  """

  failoverIcebergCatalogRequest = _messages.MessageField('FailoverIcebergCatalogRequest', 1)
  name = _messages.StringField(2, required=True)


class BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsGetRequest(_messages.Message):
  r"""A BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsGetRequest
  object.

  Fields:
    name: Required. The catalog to get.
  """

  name = _messages.StringField(1, required=True)


class BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsListRequest(_messages.Message):
  r"""A BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsListRequest
  object.

  Enums:
    ViewValueValuesEnum: Optional. The view of the catalog to return.

  Fields:
    page_size: Optional. The maximum number of catalogs to return. The service
      may return fewer than this value.
    page_token: Optional. The page token, received from a previous
      `ListIcebergCatalogs` call. Provide this to retrieve the subsequent
      page.
    parent: Required. The parent resource where this catalog will be created.
      Format: projects/{project_id}
    view: Optional. The view of the catalog to return.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Optional. The view of the catalog to return.

    Values:
      CATALOG_VIEW_UNSPECIFIED: Default/unset value. Same as BASIC.
      CATALOG_VIEW_BASIC: Include only the name and catalog type.
      CATALOG_VIEW_FULL: Include all fields of the catalog.
    """
    CATALOG_VIEW_UNSPECIFIED = 0
    CATALOG_VIEW_BASIC = 1
    CATALOG_VIEW_FULL = 2

  page_size = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  page_token = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsPatchRequest(_messages.Message):
  r"""A BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsPatchRequest
  object.

  Fields:
    icebergCatalog: A IcebergCatalog resource to be passed as the request
      body.
    name: Identifier. The catalog name, `projects/my-project/catalogs/my-
      catalog`. This field is immutable. This field is ignored for
      CreateIcebergCatalog.
    updateMask: Optional. The list of fields to update.
  """

  icebergCatalog = _messages.MessageField('IcebergCatalog', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class BiglakeIcebergV1RestcatalogV1GetConfigRequest(_messages.Message):
  r"""A BiglakeIcebergV1RestcatalogV1GetConfigRequest object.

  Fields:
    warehouse: Required. Warehouse location or identifier to request from the
      service.
  """

  warehouse = _messages.StringField(1)


class BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesCreateRequest(_messages.Message):
  r"""A BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesCreateRequest
  object.

  Fields:
    icebergNamespace: A IcebergNamespace resource to be passed as the request
      body.
    parent: Required. The parent resource where this namespace will be
      created. Format: projects/{project_id}/catalogs/{catalog_id}
  """

  icebergNamespace = _messages.MessageField('IcebergNamespace', 1)
  parent = _messages.StringField(2, required=True)


class BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesDeleteRequest(_messages.Message):
  r"""A BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesDeleteRequest
  object.

  Fields:
    name: Required. Iceberg namespace to delete in the format:
      `projects/{project_id}/catalogs/{catalog_id}/namespaces/{namespace}`.
  """

  name = _messages.StringField(1, required=True)


class BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesGetRequest(_messages.Message):
  r"""A BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesGetRequest
  object.

  Fields:
    name: Required. Iceberg namespace to fetch in the format:
      `projects/{project_id}/catalogs/{catalog_id}/namespaces/{namespace}`.
  """

  name = _messages.StringField(1, required=True)


class BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesListRequest(_messages.Message):
  r"""A BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesListRequest
  object.

  Fields:
    apiParent: Required. The parent from the resource path.
    pageSize: Optional. For servers that support pagination, this signals an
      upper bound of the number of results that a client will receive. For
      servers that do not support pagination, clients may receive results
      larger than the indicated `pageSize`. Defaults to 100 if not set.
    pageToken: Optional. Specify the page_token returned in the previous
      response to retrieve the next page of results.
    parent: Optional. An optional namespace, underneath which to list
      namespaces. If not provided or empty, all top-level namespaces should be
      listed. If parent is a multipart namespace, the parts must be separated
      by the unit separator (`0x1F`) byte. Not a real parent, so
      ST_NOT_REQUIRED.
  """

  apiParent = _messages.StringField(1, required=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4)


class BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesPropertiesRequest(_messages.Message):
  r"""A
  BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesPropertiesRequest
  object.

  Fields:
    icebergNamespaceUpdate: A IcebergNamespaceUpdate resource to be passed as
      the request body.
    name: Required. The namespace to update. The namespace's `name` field is
      used to identify the namespace to update. Format:
      projects/{project_id}/catalogs/{catalog_id}/namespaces/{namespace}
  """

  icebergNamespaceUpdate = _messages.MessageField('IcebergNamespaceUpdate', 1)
  name = _messages.StringField(2, required=True)


class BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesRegisterRequest(_messages.Message):
  r"""A BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesRegisterRequest
  object.

  Fields:
    parent: Required. Table to register in the format:
      `projects/{project_id}/catalogs/{catalog_id}/namespaces/{namespace}`.
    registerIcebergTableRequest: A RegisterIcebergTableRequest resource to be
      passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  registerIcebergTableRequest = _messages.MessageField('RegisterIcebergTableRequest', 2)


class BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesCreateRequest(_messages.Message):
  r"""A
  BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesCreateRequest
  object.

  Fields:
    createIcebergTableRequest: A CreateIcebergTableRequest resource to be
      passed as the request body.
    parent: Required. The parent resource where this table will be created.
      Format:
      projects/{project_id}/catalogs/{catalog_id}/namespaces/{namespace}
  """

  createIcebergTableRequest = _messages.MessageField('CreateIcebergTableRequest', 1)
  parent = _messages.StringField(2, required=True)


class BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesCredentialsRequest(_messages.Message):
  r"""A BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesCredentia
  lsRequest object.

  Fields:
    name: Required. Table to get in the format:
    snapshots: Optional. What snapshot to get. Valid only for GetIcebergTable.
  """

  name = _messages.StringField(1, required=True)
  snapshots = _messages.StringField(2)


class BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesDeleteRequest(_messages.Message):
  r"""A
  BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesDeleteRequest
  object.

  Fields:
    name: Required. Table to delete in the format:
      `projects/{project_id}/namespaces/{namespace}/tables/{table}`.
    purgeRequested: Optional. If true we'll delete both the table and the
      data. Currently purgin data is not supported.
  """

  name = _messages.StringField(1, required=True)
  purgeRequested = _messages.BooleanField(2)


class BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesGetRequest(_messages.Message):
  r"""A
  BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesGetRequest
  object.

  Fields:
    name: Required. Table to get in the format:
    snapshots: Optional. What snapshot to get. Valid only for GetIcebergTable.
  """

  name = _messages.StringField(1, required=True)
  snapshots = _messages.StringField(2)


class BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesListRequest(_messages.Message):
  r"""A
  BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesListRequest
  object.

  Fields:
    pageSize: Optional. Page size for pagination.
    pageToken: Optional. PageToken for pagination.
    parent: Required. The namespace to list tables from.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesUpdateIcebergTableRequest(_messages.Message):
  r"""A BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesUpdateIce
  bergTableRequest object.

  Fields:
    name: Required. Table to commit in the format:
      `projects/{project_id}/namespaces/{namespace}/tables/{table}`.
    updateIcebergTableRequest: A UpdateIcebergTableRequest resource to be
      passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  updateIcebergTableRequest = _messages.MessageField('UpdateIcebergTableRequest', 2)


class BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesUpdatePropertiesRequest(_messages.Message):
  r"""A BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesUpdatePropertie
  sRequest object.

  Fields:
    icebergNamespaceUpdate: A IcebergNamespaceUpdate resource to be passed as
      the request body.
    name: Required. The namespace to update. The namespace's `name` field is
      used to identify the namespace to update. Format:
      projects/{project_id}/catalogs/{catalog_id}/namespaces/{namespace}
  """

  icebergNamespaceUpdate = _messages.MessageField('IcebergNamespaceUpdate', 1)
  name = _messages.StringField(2, required=True)


class BiglakeProjectsCatalogsGetIamPolicyRequest(_messages.Message):
  r"""A BiglakeProjectsCatalogsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class BiglakeProjectsCatalogsNamespacesGetIamPolicyRequest(_messages.Message):
  r"""A BiglakeProjectsCatalogsNamespacesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class BiglakeProjectsCatalogsNamespacesSetIamPolicyRequest(_messages.Message):
  r"""A BiglakeProjectsCatalogsNamespacesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class BiglakeProjectsCatalogsSetIamPolicyRequest(_messages.Message):
  r"""A BiglakeProjectsCatalogsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. Does not include identities that come from
      external identity providers (IdPs) through identity federation. *
      `user:{emailid}`: An email address that represents a specific Google
      account. For example, `alice@example.com` . *
      `serviceAccount:{emailid}`: An email address that represents a Google
      service account. For example, `my-other-
      app@appspot.gserviceaccount.com`. *
      `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
      An identifier for a [Kubernetes service
      account](https://cloud.google.com/kubernetes-engine/docs/how-
      to/kubernetes-service-accounts). For example, `my-
      project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
      (primary) that represents all the users of that domain. For example,
      `google.com` or `example.com`. * `principal://iam.googleapis.com/locatio
      ns/global/workforcePools/{pool_id}/subject/{subject_attribute_value}`: A
      single identity in a workforce identity pool. * `principalSet://iam.goog
      leapis.com/locations/global/workforcePools/{pool_id}/group/{group_id}`:
      All workforce identities in a group. * `principalSet://iam.googleapis.co
      m/locations/global/workforcePools/{pool_id}/attribute.{attribute_name}/{
      attribute_value}`: All workforce identities with a specific attribute
      value. * `principalSet://iam.googleapis.com/locations/global/workforcePo
      ols/{pool_id}/*`: All identities in a workforce identity pool. * `princi
      pal://iam.googleapis.com/projects/{project_number}/locations/global/work
      loadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
      identity in a workload identity pool. * `principalSet://iam.googleapis.c
      om/projects/{project_number}/locations/global/workloadIdentityPools/{poo
      l_id}/group/{group_id}`: A workload identity pool group. * `principalSet
      ://iam.googleapis.com/projects/{project_number}/locations/global/workloa
      dIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}`:
      All identities in a workload identity pool with a certain attribute. * `
      principalSet://iam.googleapis.com/projects/{project_number}/locations/gl
      obal/workloadIdentityPools/{pool_id}/*`: All identities in a workload
      identity pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email
      address (plus unique identifier) representing a user that has been
      recently deleted. For example,
      `alice@example.com?uid=123456789012345678901`. If the user is recovered,
      this value reverts to `user:{emailid}` and the recovered user retains
      the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `deleted:principal://iam.google
      apis.com/locations/global/workforcePools/{pool_id}/subject/{subject_attr
      ibute_value}`: Deleted single identity in a workforce identity pool. For
      example, `deleted:principal://iam.googleapis.com/locations/global/workfo
      rcePools/my-pool-id/subject/my-subject-attribute-value`.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an
      overview of the IAM roles and permissions, see the [IAM
      documentation](https://cloud.google.com/iam/docs/roles-overview). For a
      list of the available pre-defined roles, see
      [here](https://cloud.google.com/iam/docs/understanding-roles).
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CreateIcebergTableRequest(_messages.Message):
  r"""The request message for the `CreateIcebergTable` API."""


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class FailoverIcebergCatalogRequest(_messages.Message):
  r"""Request message for FailoverIcebergCatalog.

  Fields:
    conditionalFailoverReplicationTime: Optional. If unset, wait for all data
      from the source region to replicate to the new primary region before
      completing the failover, with no data loss (also called "soft
      failover"). If set, failover immediately, accepting the loss of any data
      committed in the source region after this timestamp, that has not yet
      replicated. If any data committed before this time has not replicated,
      the failover will not be performed and an error will be returned (also
      called "hard failover").
    primaryReplica: Required. The region being assigned as the new primary
      replica region. For example "us-east1". This must be one of the replica
      regions in the catalog's list of replicas marked as a "secondary".
    validateOnly: Optional. If set, only validate the request, but do not
      perform the update. This can be used to inspect the replication_time at
      any time, including before performing a fail-over.
  """

  conditionalFailoverReplicationTime = _messages.StringField(1)
  primaryReplica = _messages.StringField(2)
  validateOnly = _messages.BooleanField(3)


class FailoverIcebergCatalogResponse(_messages.Message):
  r"""Response message for FailoverIcebergCatalog.

  Fields:
    replicationTime: Output only. The min timestamp for which all namespaces
      and table metadata have been replicated in the region specified as the
      new primary_replica. Some resources may have been replicated more
      recently than this timestamp. If empty, the replica has just been
      created and has not yet been fully initialized. NOTE: When the Cloud
      Storage replication watermark is available, this will represent both
      catalog metadata and Cloud Storage data.
  """

  replicationTime = _messages.StringField(1)


class HttpBody(_messages.Message):
  r"""Message that represents an arbitrary HTTP body. It should only be used
  for payload formats that can't be represented as JSON, such as raw binary or
  an HTML page. This message can be used both in streaming and non-streaming
  API methods in the request as well as the response. It can be used as a top-
  level request field, which is convenient if one wants to extract parameters
  from either the URL or HTTP template into the request fields and also want
  access to the raw HTTP body. Example: message GetResourceRequest { // A
  unique request id. string request_id = 1; // The raw HTTP body is bound to
  this field. google.api.HttpBody http_body = 2; } service ResourceService {
  rpc GetResource(GetResourceRequest) returns (google.api.HttpBody); rpc
  UpdateResource(google.api.HttpBody) returns (google.protobuf.Empty); }
  Example with streaming methods: service CaldavService { rpc
  GetCalendar(stream google.api.HttpBody) returns (stream
  google.api.HttpBody); rpc UpdateCalendar(stream google.api.HttpBody) returns
  (stream google.api.HttpBody); } Use of this type only changes how the
  request and response bodies are handled, all other features will continue to
  work unchanged.

  Messages:
    ExtensionsValueListEntry: A ExtensionsValueListEntry object.

  Fields:
    contentType: The HTTP Content-Type header value specifying the content
      type of the body.
    data: The HTTP request/response body as raw binary.
    extensions: Application specific response metadata. Must be set in the
      first response for streaming APIs.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ExtensionsValueListEntry(_messages.Message):
    r"""A ExtensionsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a
        ExtensionsValueListEntry object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ExtensionsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  contentType = _messages.StringField(1)
  data = _messages.BytesField(2)
  extensions = _messages.MessageField('ExtensionsValueListEntry', 3, repeated=True)


class IcebergCatalog(_messages.Message):
  r"""The Iceberg REST Catalog information.

  Enums:
    CatalogTypeValueValuesEnum: Required. The catalog type. Required for
      CreateIcebergCatalog.
    CredentialModeValueValuesEnum: Optional. The credential mode for the
      catalog.

  Fields:
    biglake_service_account: Output only. The service account used for
      credential vending, output only. Might be empty if Credential vending
      was never enabled for the catalog.
    catalog_type: Required. The catalog type. Required for
      CreateIcebergCatalog.
    create_time: Output only. When the catalog was created.
    credential_mode: Optional. The credential mode for the catalog.
    default_location: Optional. The default storage location for the catalog,
      e.g., `gs://my-bucket`. For the Google Cloud Storage Bucket catalog this
      is output only. For BigLake flexible catalogs, this field must be
      provided and point to a Google Cloud Storage bucket or a path within
      that bucket. This path serves as the base directory for constructing the
      full path to a table's data and metadata directories when a location is
      not specified at the namespace or table level. The full path is formed
      by appending the namespace and table identifiers to the default
      location.
    name: Identifier. The catalog name, `projects/my-project/catalogs/my-
      catalog`. This field is immutable. This field is ignored for
      CreateIcebergCatalog.
    replicas: Output only. The replicas for the catalog metadata.
    storage_regions: Output only. The GCP region(s) where the physical
      metadata for the tables is stored, e.g. `us-central1`, `nam4` or `us`.
      This will contain one value for all locations, except for the catalogs
      that are configured to use custom dual region buckets.
    update_time: Output only. When the catalog was last updated.
  """

  class CatalogTypeValueValuesEnum(_messages.Enum):
    r"""Required. The catalog type. Required for CreateIcebergCatalog.

    Values:
      CATALOG_TYPE_UNSPECIFIED: Default value. This value is unused.
      CATALOG_TYPE_GCS_BUCKET: Catalog type for Google Cloud Storage Buckets.
    """
    CATALOG_TYPE_UNSPECIFIED = 0
    CATALOG_TYPE_GCS_BUCKET = 1

  class CredentialModeValueValuesEnum(_messages.Enum):
    r"""Optional. The credential mode for the catalog.

    Values:
      CREDENTIAL_MODE_UNSPECIFIED: Default value. This value is unused.
      CREDENTIAL_MODE_END_USER: End user credentials, default. The
        authenticating user must have access to the catalog resources and the
        corresponding Google Cloud Storage files.
      CREDENTIAL_MODE_VENDED_CREDENTIALS: Use credential vending. The
        authenticating user must have access to the catalog resources and the
        system will provide the caller with downscoped credentials to access
        the Google Cloud Storage files. All table operations in this mode
        would require `X-Iceberg-Access-Delegation` header with `vended-
        credentials` value included. System will generate a service account
        and the catalog administrator must grant the service account
        appropriate permissions. See: https://github.com/apache/iceberg/blob/9
        31865ecaf40a827f9081dddb675bf1c95c05461/open-api/rest-catalog-open-
        api.yaml#L1854 for more details.
    """
    CREDENTIAL_MODE_UNSPECIFIED = 0
    CREDENTIAL_MODE_END_USER = 1
    CREDENTIAL_MODE_VENDED_CREDENTIALS = 2

  biglake_service_account = _messages.StringField(1)
  catalog_type = _messages.EnumField('CatalogTypeValueValuesEnum', 2)
  create_time = _messages.StringField(3)
  credential_mode = _messages.EnumField('CredentialModeValueValuesEnum', 4)
  default_location = _messages.StringField(5)
  name = _messages.StringField(6)
  replicas = _messages.MessageField('Replica', 7, repeated=True)
  storage_regions = _messages.StringField(8, repeated=True)
  update_time = _messages.StringField(9)


class IcebergCatalogConfig(_messages.Message):
  r"""The iceberg catalog configuration.

  Messages:
    DefaultsValue: Output only. Properties that should be used as default
      configuration; applied before client configuration. Required, even if
      empty.
    OverridesValue: Output only. Properties that should be used to override
      client configuration; applied after defaults and client configuration.
      Required, even if empty.

  Fields:
    defaults: Output only. Properties that should be used as default
      configuration; applied before client configuration. Required, even if
      empty.
    endpoints: Output only. Endpoints, required, must not be empty.
    overrides: Output only. Properties that should be used to override client
      configuration; applied after defaults and client configuration.
      Required, even if empty.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DefaultsValue(_messages.Message):
    r"""Output only. Properties that should be used as default configuration;
    applied before client configuration. Required, even if empty.

    Messages:
      AdditionalProperty: An additional property for a DefaultsValue object.

    Fields:
      additionalProperties: Additional properties of type DefaultsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DefaultsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class OverridesValue(_messages.Message):
    r"""Output only. Properties that should be used to override client
    configuration; applied after defaults and client configuration. Required,
    even if empty.

    Messages:
      AdditionalProperty: An additional property for a OverridesValue object.

    Fields:
      additionalProperties: Additional properties of type OverridesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a OverridesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  defaults = _messages.MessageField('DefaultsValue', 1)
  endpoints = _messages.StringField(2, repeated=True)
  overrides = _messages.MessageField('OverridesValue', 3)


class IcebergNamespace(_messages.Message):
  r"""The namespace object to create.

  Messages:
    PropertiesValue: Optional. The optional properties of the namespace.

  Fields:
    namespace: Required. The name of the namespace.
    properties: Optional. The optional properties of the namespace.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    r"""Optional. The optional properties of the namespace.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  namespace = _messages.StringField(1, repeated=True)
  properties = _messages.MessageField('PropertiesValue', 2)


class IcebergNamespaceUpdate(_messages.Message):
  r"""The request message for the `UpdateIcebergNamespace` API.

  Messages:
    UpdatesValue: Optional. List of properties to update or add.

  Fields:
    removals: Optional. Keys of the properties to remove.
    updates: Optional. List of properties to update or add.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class UpdatesValue(_messages.Message):
    r"""Optional. List of properties to update or add.

    Messages:
      AdditionalProperty: An additional property for a UpdatesValue object.

    Fields:
      additionalProperties: Additional properties of type UpdatesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a UpdatesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  removals = _messages.StringField(1, repeated=True)
  updates = _messages.MessageField('UpdatesValue', 2)


class ListIcebergCatalogsResponse(_messages.Message):
  r"""The response message for the `ListIcebergCatalogs` API.

  Fields:
    iceberg_catalogs: Output only. The list of iceberg catalogs.
    next_page_token: Output only. The next page token for pagination.
    unreachable: Output only. The list of unreachable cloud regions. If non-
      empty, the result set might be incomplete.
  """

  iceberg_catalogs = _messages.MessageField('IcebergCatalog', 1, repeated=True)
  next_page_token = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListIcebergNamespacesResponse(_messages.Message):
  r"""The response message for the `ListIcebergNamespaces` API.

  Messages:
    NamespacesValueListEntry: Single entry in a NamespacesValue.

  Fields:
    namespaces: The list of namespaces.
    next_page_token: The next page token for pagination.
    unreachable: Output only. A list of skipped locations that were
      unreachable. If non-empty, the result set might be incomplete.
  """

  class NamespacesValueListEntry(_messages.Message):
    r"""Single entry in a NamespacesValue.

    Fields:
      entry: A extra_types.JsonValue attribute.
    """

    entry = _messages.MessageField('extra_types.JsonValue', 1, repeated=True)

  namespaces = _messages.MessageField('NamespacesValueListEntry', 1, repeated=True)
  next_page_token = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListIcebergTableIdentifiersResponse(_messages.Message):
  r"""The response message for the `ListIcebergTableIdentifiers` API.

  Fields:
    identifiers: Output only. The list of table identifiers.
    next_page_token: Output only. The next page token for pagination.
  """

  identifiers = _messages.MessageField('TableIdentifier', 1, repeated=True)
  next_page_token = _messages.StringField(2)


class LoadIcebergTableCredentialsResponse(_messages.Message):
  r"""The response message for the `LoadCredentials` API.

  Fields:
    storage_credentials: The credentials for the table assigned to the caller.
  """

  storage_credentials = _messages.MessageField('StorageCredential', 1, repeated=True)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** ``` { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
  members: - user:mike@example.com - group:admins@example.com -
  domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
  role: roles/resourcemanager.organizationAdmin - members: -
  user:eve@example.com role: roles/resourcemanager.organizationViewer
  condition: title: expirable access description: Does not grant access after
  Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
  etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
  see the [IAM documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class RegisterIcebergTableRequest(_messages.Message):
  r"""The request message for the `RegisterIcebergTable` API.

  Fields:
    metadata_location: Required. The metadata location of the table.
    name: Required. The name of the table to register.
    overwrite: Optional. Whether to overwrite the table if it already exists.
      Default is false. Currently this field is ignored and an error is
      returned if the table already exists.
  """

  metadata_location = _messages.StringField(1)
  name = _messages.StringField(2)
  overwrite = _messages.BooleanField(3)


class Replica(_messages.Message):
  r"""The replica of the Catalog.

  Enums:
    StateValueValuesEnum: Output only. The current state of the replica.

  Fields:
    region: Output only. The region of the replica. For example "us-east1"
    state: Output only. The current state of the replica.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the replica.

    Values:
      STATE_UNKNOWN: The replica state is unknown.
      STATE_PRIMARY: The replica is the writable primary.
      STATE_PRIMARY_IN_PROGRESS: The replica has been recently assigned as the
        primary, but not all namespaces are writeable yet.
      STATE_SECONDARY: The replica is a read-only secondary replica.
    """
    STATE_UNKNOWN = 0
    STATE_PRIMARY = 1
    STATE_PRIMARY_IN_PROGRESS = 2
    STATE_SECONDARY = 3

  region = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Google Cloud services (such as Projects) might
      reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class StorageCredential(_messages.Message):
  r"""The storage credential for a path in the table.

  Messages:
    ConfigValue: The credentials for the storage location. The keys that are
      populated are: - `gcs.oauth2.token` - `gcs.oauth2.token_expires_at` -
      `expiration-time` (to support federation from Polaris).

  Fields:
    config: The credentials for the storage location. The keys that are
      populated are: - `gcs.oauth2.token` - `gcs.oauth2.token_expires_at` -
      `expiration-time` (to support federation from Polaris).
    prefix: Indicates a storage location prefix where the credential is
      relevant.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ConfigValue(_messages.Message):
    r"""The credentials for the storage location. The keys that are populated
    are: - `gcs.oauth2.token` - `gcs.oauth2.token_expires_at` - `expiration-
    time` (to support federation from Polaris).

    Messages:
      AdditionalProperty: An additional property for a ConfigValue object.

    Fields:
      additionalProperties: Additional properties of type ConfigValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ConfigValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  config = _messages.MessageField('ConfigValue', 1)
  prefix = _messages.StringField(2)


class TableIdentifier(_messages.Message):
  r"""The table identifier.

  Fields:
    name: The table name.
    namespace: The namespace of the table. This is always 1 element, since we
      don't support nested namespaces.
  """

  name = _messages.StringField(1)
  namespace = _messages.StringField(2, repeated=True)


class UpdateIcebergNamespaceResponse(_messages.Message):
  r"""The response message for the `UpdateIcebergNamespace` API.

  Fields:
    added: Output only. List of properties that were added or updated.
    missing: Output only. List of properties that were requested to be
      removed, but were not found.
    removed: Output only. List of properties that were removed.
  """

  added = _messages.StringField(1, repeated=True)
  missing = _messages.StringField(2, repeated=True)
  removed = _messages.StringField(3, repeated=True)


class UpdateIcebergTableRequest(_messages.Message):
  r"""The update message for the `UpdateIcebergTable` API."""


encoding.AddCustomJsonFieldMapping(
    IcebergCatalog, 'biglake_service_account', 'biglake-service-account')
encoding.AddCustomJsonFieldMapping(
    IcebergCatalog, 'catalog_type', 'catalog-type')
encoding.AddCustomJsonFieldMapping(
    IcebergCatalog, 'create_time', 'create-time')
encoding.AddCustomJsonFieldMapping(
    IcebergCatalog, 'credential_mode', 'credential-mode')
encoding.AddCustomJsonFieldMapping(
    IcebergCatalog, 'default_location', 'default-location')
encoding.AddCustomJsonFieldMapping(
    IcebergCatalog, 'storage_regions', 'storage-regions')
encoding.AddCustomJsonFieldMapping(
    IcebergCatalog, 'update_time', 'update-time')
encoding.AddCustomJsonFieldMapping(
    ListIcebergCatalogsResponse, 'iceberg_catalogs', 'iceberg-catalogs')
encoding.AddCustomJsonFieldMapping(
    ListIcebergCatalogsResponse, 'next_page_token', 'next-page-token')
encoding.AddCustomJsonFieldMapping(
    ListIcebergNamespacesResponse, 'next_page_token', 'next-page-token')
encoding.AddCustomJsonFieldMapping(
    ListIcebergTableIdentifiersResponse, 'next_page_token', 'next-page-token')
encoding.AddCustomJsonFieldMapping(
    LoadIcebergTableCredentialsResponse, 'storage_credentials', 'storage-credentials')
encoding.AddCustomJsonFieldMapping(
    RegisterIcebergTableRequest, 'metadata_location', 'metadata-location')
encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
encoding.AddCustomJsonFieldMapping(
    BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsCreateRequest, 'iceberg_catalog_id', 'iceberg-catalog-id')
encoding.AddCustomJsonFieldMapping(
    BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsListRequest, 'page_size', 'page-size')
encoding.AddCustomJsonFieldMapping(
    BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsListRequest, 'page_token', 'page-token')
encoding.AddCustomJsonFieldMapping(
    BiglakeProjectsCatalogsGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    BiglakeProjectsCatalogsNamespacesGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
