"""Generated message classes for aiplatform version v1beta1.

Train high-quality custom machine learning models with minimal machine
learning expertise and effort.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'aiplatform'


class AiplatformDatasetsCreateRequest(_messages.Message):
  r"""A AiplatformDatasetsCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1Dataset: A GoogleCloudAiplatformV1beta1Dataset
      resource to be passed as the request body.
    parent: Required. The resource name of the Location to create the Dataset
      in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1Dataset = _messages.MessageField('GoogleCloudAiplatformV1beta1Dataset', 1)
  parent = _messages.StringField(2)


class AiplatformDatasetsDatasetVersionsCreateRequest(_messages.Message):
  r"""A AiplatformDatasetsDatasetVersionsCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1DatasetVersion: A
      GoogleCloudAiplatformV1beta1DatasetVersion resource to be passed as the
      request body.
    parent: Required. The name of the Dataset resource. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
  """

  googleCloudAiplatformV1beta1DatasetVersion = _messages.MessageField('GoogleCloudAiplatformV1beta1DatasetVersion', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformDatasetsDatasetVersionsDeleteRequest(_messages.Message):
  r"""A AiplatformDatasetsDatasetVersionsDeleteRequest object.

  Fields:
    name: Required. The resource name of the Dataset version to delete.
      Format: `projects/{project}/locations/{location}/datasets/{dataset}/data
      setVersions/{dataset_version}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformDatasetsDatasetVersionsGetRequest(_messages.Message):
  r"""A AiplatformDatasetsDatasetVersionsGetRequest object.

  Fields:
    name: Required. The resource name of the Dataset version to delete.
      Format: `projects/{project}/locations/{location}/datasets/{dataset}/data
      setVersions/{dataset_version}`
    readMask: Mask specifying which fields to read.
  """

  name = _messages.StringField(1, required=True)
  readMask = _messages.StringField(2)


class AiplatformDatasetsDatasetVersionsListRequest(_messages.Message):
  r"""A AiplatformDatasetsDatasetVersionsListRequest object.

  Fields:
    filter: Optional. The standard list filter.
    orderBy: Optional. A comma-separated list of fields to order by, sorted in
      ascending order. Use "desc" after a field name for descending.
    pageSize: Optional. The standard list page size.
    pageToken: Optional. The standard list page token.
    parent: Required. The resource name of the Dataset to list DatasetVersions
      from. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
    readMask: Optional. Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformDatasetsDatasetVersionsPatchRequest(_messages.Message):
  r"""A AiplatformDatasetsDatasetVersionsPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1DatasetVersion: A
      GoogleCloudAiplatformV1beta1DatasetVersion resource to be passed as the
      request body.
    name: Output only. Identifier. The resource name of the DatasetVersion.
      Format: `projects/{project}/locations/{location}/datasets/{dataset}/data
      setVersions/{dataset_version}`
    updateMask: Required. The update mask applies to the resource. For the
      `FieldMask` definition, see google.protobuf.FieldMask. Updatable fields:
      * `display_name`
  """

  googleCloudAiplatformV1beta1DatasetVersion = _messages.MessageField('GoogleCloudAiplatformV1beta1DatasetVersion', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformDatasetsDatasetVersionsRestoreRequest(_messages.Message):
  r"""A AiplatformDatasetsDatasetVersionsRestoreRequest object.

  Fields:
    name: Required. The name of the DatasetVersion resource. Format: `projects
      /{project}/locations/{location}/datasets/{dataset}/datasetVersions/{data
      set_version}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformDatasetsDeleteRequest(_messages.Message):
  r"""A AiplatformDatasetsDeleteRequest object.

  Fields:
    name: Required. The resource name of the Dataset to delete. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformDatasetsGetRequest(_messages.Message):
  r"""A AiplatformDatasetsGetRequest object.

  Fields:
    name: Required. The name of the Dataset resource.
    readMask: Mask specifying which fields to read.
  """

  name = _messages.StringField(1, required=True)
  readMask = _messages.StringField(2)


class AiplatformDatasetsListRequest(_messages.Message):
  r"""A AiplatformDatasetsListRequest object.

  Fields:
    filter: An expression for filtering the results of the request. For field
      names both snake_case and camelCase are supported. * `display_name`:
      supports = and != * `metadata_schema_uri`: supports = and != * `labels`
      supports general map functions that is: * `labels.key=value` - key:value
      equality * `labels.key:* or labels:key - key existence * A key including
      a space must be quoted. `labels."a key"`. Some examples: *
      `displayName="myDisplayName"` * `labels.myKey="myValue"`
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending. Supported fields: *
      `display_name` * `create_time` * `update_time`
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: Required. The name of the Dataset's parent resource. Format:
      `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5)
  readMask = _messages.StringField(6)


class AiplatformDatasetsPatchRequest(_messages.Message):
  r"""A AiplatformDatasetsPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1Dataset: A GoogleCloudAiplatformV1beta1Dataset
      resource to be passed as the request body.
    name: Output only. Identifier. The resource name of the Dataset. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
    updateMask: Required. The update mask applies to the resource. For the
      `FieldMask` definition, see google.protobuf.FieldMask. Updatable fields:
      * `display_name` * `description` * `labels`
  """

  googleCloudAiplatformV1beta1Dataset = _messages.MessageField('GoogleCloudAiplatformV1beta1Dataset', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformEndpointsComputeTokensRequest(_messages.Message):
  r"""A AiplatformEndpointsComputeTokensRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to get lists of
      tokens and token ids.
    googleCloudAiplatformV1beta1ComputeTokensRequest: A
      GoogleCloudAiplatformV1beta1ComputeTokensRequest resource to be passed
      as the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1ComputeTokensRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ComputeTokensRequest', 2)


class AiplatformEndpointsCountTokensRequest(_messages.Message):
  r"""A AiplatformEndpointsCountTokensRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to perform token
      counting. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1CountTokensRequest: A
      GoogleCloudAiplatformV1beta1CountTokensRequest resource to be passed as
      the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1CountTokensRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1CountTokensRequest', 2)


class AiplatformEndpointsGenerateContentRequest(_messages.Message):
  r"""A AiplatformEndpointsGenerateContentRequest object.

  Fields:
    googleCloudAiplatformV1beta1GenerateContentRequest: A
      GoogleCloudAiplatformV1beta1GenerateContentRequest resource to be passed
      as the request body.
    model: Required. The fully qualified name of the publisher model or tuned
      model endpoint to use. Publisher model format:
      `projects/{project}/locations/{location}/publishers/*/models/*` Tuned
      model endpoint format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
  """

  googleCloudAiplatformV1beta1GenerateContentRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1GenerateContentRequest', 1)
  model = _messages.StringField(2, required=True)


class AiplatformEndpointsPredictRequest(_messages.Message):
  r"""A AiplatformEndpointsPredictRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1PredictRequest: A
      GoogleCloudAiplatformV1beta1PredictRequest resource to be passed as the
      request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1PredictRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1PredictRequest', 2)


class AiplatformEndpointsStreamGenerateContentRequest(_messages.Message):
  r"""A AiplatformEndpointsStreamGenerateContentRequest object.

  Fields:
    googleCloudAiplatformV1beta1GenerateContentRequest: A
      GoogleCloudAiplatformV1beta1GenerateContentRequest resource to be passed
      as the request body.
    model: Required. The fully qualified name of the publisher model or tuned
      model endpoint to use. Publisher model format:
      `projects/{project}/locations/{location}/publishers/*/models/*` Tuned
      model endpoint format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
  """

  googleCloudAiplatformV1beta1GenerateContentRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1GenerateContentRequest', 1)
  model = _messages.StringField(2, required=True)


class AiplatformMediaUploadRequest(_messages.Message):
  r"""A AiplatformMediaUploadRequest object.

  Fields:
    googleCloudAiplatformV1beta1UploadRagFileRequest: A
      GoogleCloudAiplatformV1beta1UploadRagFileRequest resource to be passed
      as the request body.
    parent: Required. The name of the RagCorpus resource into which to upload
      the file. Format:
      `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
  """

  googleCloudAiplatformV1beta1UploadRagFileRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1UploadRagFileRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsGetCacheConfigRequest(_messages.Message):
  r"""A AiplatformProjectsGetCacheConfigRequest object.

  Fields:
    name: Required. Name of the cache config. Format: -
      `projects/{project}/cacheConfig`.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsAgentsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsAgentsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsAgentsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsAgentsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsAgentsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsAgentsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsAgentsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsAgentsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsAgentsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsAgentsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsAppsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsAppsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsAppsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsAppsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsAppsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsAppsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsAppsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsAppsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsAppsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsAppsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsAugmentPromptRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsAugmentPromptRequest object.

  Fields:
    googleCloudAiplatformV1beta1AugmentPromptRequest: A
      GoogleCloudAiplatformV1beta1AugmentPromptRequest resource to be passed
      as the request body.
    parent: Required. The resource name of the Location from which to augment
      prompt. The users must have permission to make a call in the project.
      Format: `projects/{project}/locations/{location}`.
  """

  googleCloudAiplatformV1beta1AugmentPromptRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1AugmentPromptRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsBatchPredictionJobsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsBatchPredictionJobsCancelRequest object.

  Fields:
    googleCloudAiplatformV1beta1CancelBatchPredictionJobRequest: A
      GoogleCloudAiplatformV1beta1CancelBatchPredictionJobRequest resource to
      be passed as the request body.
    name: Required. The name of the BatchPredictionJob to cancel. Format: `pro
      jects/{project}/locations/{location}/batchPredictionJobs/{batch_predicti
      on_job}`
  """

  googleCloudAiplatformV1beta1CancelBatchPredictionJobRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1CancelBatchPredictionJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsBatchPredictionJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsBatchPredictionJobsCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1BatchPredictionJob: A
      GoogleCloudAiplatformV1beta1BatchPredictionJob resource to be passed as
      the request body.
    parent: Required. The resource name of the Location to create the
      BatchPredictionJob in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1BatchPredictionJob = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchPredictionJob', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsBatchPredictionJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsBatchPredictionJobsDeleteRequest object.

  Fields:
    name: Required. The name of the BatchPredictionJob resource to be deleted.
      Format: `projects/{project}/locations/{location}/batchPredictionJobs/{ba
      tch_prediction_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsBatchPredictionJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsBatchPredictionJobsGetRequest object.

  Fields:
    name: Required. The name of the BatchPredictionJob resource. Format: `proj
      ects/{project}/locations/{location}/batchPredictionJobs/{batch_predictio
      n_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsBatchPredictionJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsBatchPredictionJobsListRequest object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports `=`, `!=` comparisons, and `:` wildcard. * `model_display_name`
      supports `=`, `!=` comparisons. * `state` supports `=`, `!=`
      comparisons. * `create_time` supports `=`, `!=`,`<`, `<=`,`>`, `>=`
      comparisons. `create_time` must be in RFC 3339 format. * `labels`
      supports general map functions that is: `labels.key=value` - key:value
      equality `labels.key:* - key existence Some examples of using the filter
      are: * `state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"` *
      `state!="JOB_STATE_FAILED" OR display_name="my_job"` * `NOT
      display_name="my_job"` * `create_time>"2021-05-18T00:00:00Z"` *
      `labels.keyA=valueA` * `labels.keyB:*`
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListBatchPredictionJobsResponse.next_page_token of the previous
      JobService.ListBatchPredictionJobs call.
    parent: Required. The resource name of the Location to list the
      BatchPredictionJobs from. Format:
      `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsCachedContentsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCachedContentsCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1CachedContent: A
      GoogleCloudAiplatformV1beta1CachedContent resource to be passed as the
      request body.
    parent: Required. The parent resource where the cached content will be
      created
  """

  googleCloudAiplatformV1beta1CachedContent = _messages.MessageField('GoogleCloudAiplatformV1beta1CachedContent', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsCachedContentsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCachedContentsDeleteRequest object.

  Fields:
    name: Required. The resource name referring to the cached content
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsCachedContentsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCachedContentsGetRequest object.

  Fields:
    name: Required. The resource name referring to the cached content
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsCachedContentsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCachedContentsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of cached contents to return. The
      service may return fewer than this value. If unspecified, some default
      (under maximum) number of items will be returned. The maximum value is
      1000; values above 1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListCachedContents` call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters provided to `ListCachedContents`
      must match the call that provided the page token.
    parent: Required. The parent, which owns this collection of cached
      contents.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsCachedContentsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCachedContentsPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1CachedContent: A
      GoogleCloudAiplatformV1beta1CachedContent resource to be passed as the
      request body.
    name: Immutable. Identifier. The server-generated resource name of the
      cached content Format:
      projects/{project}/locations/{location}/cachedContents/{cached_content}
    updateMask: Required. The list of fields to update.
  """

  googleCloudAiplatformV1beta1CachedContent = _messages.MessageField('GoogleCloudAiplatformV1beta1CachedContent', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsCorroborateContentRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCorroborateContentRequest object.

  Fields:
    googleCloudAiplatformV1beta1CorroborateContentRequest: A
      GoogleCloudAiplatformV1beta1CorroborateContentRequest resource to be
      passed as the request body.
    parent: Required. The resource name of the Location from which to
      corroborate text. The users must have permission to make a call in the
      project. Format: `projects/{project}/locations/{location}`.
  """

  googleCloudAiplatformV1beta1CorroborateContentRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1CorroborateContentRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsCustomJobsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsCancelRequest object.

  Fields:
    googleCloudAiplatformV1beta1CancelCustomJobRequest: A
      GoogleCloudAiplatformV1beta1CancelCustomJobRequest resource to be passed
      as the request body.
    name: Required. The name of the CustomJob to cancel. Format:
      `projects/{project}/locations/{location}/customJobs/{custom_job}`
  """

  googleCloudAiplatformV1beta1CancelCustomJobRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1CancelCustomJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsCustomJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1CustomJob: A
      GoogleCloudAiplatformV1beta1CustomJob resource to be passed as the
      request body.
    parent: Required. The resource name of the Location to create the
      CustomJob in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1CustomJob = _messages.MessageField('GoogleCloudAiplatformV1beta1CustomJob', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsCustomJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsDeleteRequest object.

  Fields:
    name: Required. The name of the CustomJob resource to be deleted. Format:
      `projects/{project}/locations/{location}/customJobs/{custom_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsCustomJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsGetRequest object.

  Fields:
    name: Required. The name of the CustomJob resource. Format:
      `projects/{project}/locations/{location}/customJobs/{custom_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsCustomJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsListRequest object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports `=`, `!=` comparisons, and `:` wildcard. * `state` supports
      `=`, `!=` comparisons. * `create_time` supports `=`, `!=`,`<`, `<=`,`>`,
      `>=` comparisons. `create_time` must be in RFC 3339 format. * `labels`
      supports general map functions that is: `labels.key=value` - key:value
      equality `labels.key:* - key existence Some examples of using the filter
      are: * `state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"` *
      `state!="JOB_STATE_FAILED" OR display_name="my_job"` * `NOT
      display_name="my_job"` * `create_time>"2021-05-18T00:00:00Z"` *
      `labels.keyA=valueA` * `labels.keyB:*`
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListCustomJobsResponse.next_page_token of the previous
      JobService.ListCustomJobs call.
    parent: Required. The resource name of the Location to list the CustomJobs
      from. Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsCustomJobsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsCustomJobsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsCustomJobsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsCustomJobsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsCustomJobsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsDataLabelingJobsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsCancelRequest object.

  Fields:
    googleCloudAiplatformV1beta1CancelDataLabelingJobRequest: A
      GoogleCloudAiplatformV1beta1CancelDataLabelingJobRequest resource to be
      passed as the request body.
    name: Required. The name of the DataLabelingJob. Format: `projects/{projec
      t}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
  """

  googleCloudAiplatformV1beta1CancelDataLabelingJobRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1CancelDataLabelingJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsDataLabelingJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1DataLabelingJob: A
      GoogleCloudAiplatformV1beta1DataLabelingJob resource to be passed as the
      request body.
    parent: Required. The parent of the DataLabelingJob. Format:
      `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1DataLabelingJob = _messages.MessageField('GoogleCloudAiplatformV1beta1DataLabelingJob', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsDataLabelingJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsDeleteRequest object.

  Fields:
    name: Required. The name of the DataLabelingJob to be deleted. Format: `pr
      ojects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_jo
      b}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDataLabelingJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsGetRequest object.

  Fields:
    name: Required. The name of the DataLabelingJob. Format: `projects/{projec
      t}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDataLabelingJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsListRequest object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports `=`, `!=` comparisons, and `:` wildcard. * `state` supports
      `=`, `!=` comparisons. * `create_time` supports `=`, `!=`,`<`, `<=`,`>`,
      `>=` comparisons. `create_time` must be in RFC 3339 format. * `labels`
      supports general map functions that is: `labels.key=value` - key:value
      equality `labels.key:* - key existence Some examples of using the filter
      are: * `state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"` *
      `state!="JOB_STATE_FAILED" OR display_name="my_job"` * `NOT
      display_name="my_job"` * `create_time>"2021-05-18T00:00:00Z"` *
      `labels.keyA=valueA` * `labels.keyB:*`
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order by default. Use `desc` after a field name for descending.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: Required. The parent of the DataLabelingJob. Format:
      `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read. FieldMask represents a set
      of symbolic field paths. For example, the mask can be `paths: "name"`.
      The "name" here is a field in DataLabelingJob. If this field is not set,
      all fields of the DataLabelingJob are returned.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsDataLabelingJobsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDataLabelingJobsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDataLabelingJobsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDataLabelingJobsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsDataLabelingJobsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsAnnotationSpecsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsAnnotationSpecsGetRequest object.

  Fields:
    name: Required. The name of the AnnotationSpec resource. Format: `projects
      /{project}/locations/{location}/datasets/{dataset}/annotationSpecs/{anno
      tation_spec}`
    readMask: Mask specifying which fields to read.
  """

  name = _messages.StringField(1, required=True)
  readMask = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsCancelRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1Dataset: A GoogleCloudAiplatformV1beta1Dataset
      resource to be passed as the request body.
    parent: Required. The resource name of the Location to create the Dataset
      in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1Dataset = _messages.MessageField('GoogleCloudAiplatformV1beta1Dataset', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsDatasetsDataItemsAnnotationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsAnnotationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: Required. The resource name of the DataItem to list Annotations
      from. Format: `projects/{project}/locations/{location}/datasets/{dataset
      }/dataItems/{data_item}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsCance
  lRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsDelet
  eRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsGetRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsDataItemsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsListRequest object.

  Fields:
    filter: The standard list filter.
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: Required. The resource name of the Dataset to list DataItems from.
      Format: `projects/{project}/locations/{location}/datasets/{dataset}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsDatasetsDataItemsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsDataItemsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsDataItemsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsDataItemsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsDatasetsDataItemsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsDatasetVersionsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDatasetVersionsCreateRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1DatasetVersion: A
      GoogleCloudAiplatformV1beta1DatasetVersion resource to be passed as the
      request body.
    parent: Required. The name of the Dataset resource. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
  """

  googleCloudAiplatformV1beta1DatasetVersion = _messages.MessageField('GoogleCloudAiplatformV1beta1DatasetVersion', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsDatasetsDatasetVersionsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDatasetVersionsDeleteRequest
  object.

  Fields:
    name: Required. The resource name of the Dataset version to delete.
      Format: `projects/{project}/locations/{location}/datasets/{dataset}/data
      setVersions/{dataset_version}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsDatasetVersionsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDatasetVersionsGetRequest object.

  Fields:
    name: Required. The resource name of the Dataset version to delete.
      Format: `projects/{project}/locations/{location}/datasets/{dataset}/data
      setVersions/{dataset_version}`
    readMask: Mask specifying which fields to read.
  """

  name = _messages.StringField(1, required=True)
  readMask = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsDatasetVersionsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDatasetVersionsListRequest object.

  Fields:
    filter: Optional. The standard list filter.
    orderBy: Optional. A comma-separated list of fields to order by, sorted in
      ascending order. Use "desc" after a field name for descending.
    pageSize: Optional. The standard list page size.
    pageToken: Optional. The standard list page token.
    parent: Required. The resource name of the Dataset to list DatasetVersions
      from. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
    readMask: Optional. Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsDatasetsDatasetVersionsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDatasetVersionsPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1DatasetVersion: A
      GoogleCloudAiplatformV1beta1DatasetVersion resource to be passed as the
      request body.
    name: Output only. Identifier. The resource name of the DatasetVersion.
      Format: `projects/{project}/locations/{location}/datasets/{dataset}/data
      setVersions/{dataset_version}`
    updateMask: Required. The update mask applies to the resource. For the
      `FieldMask` definition, see google.protobuf.FieldMask. Updatable fields:
      * `display_name`
  """

  googleCloudAiplatformV1beta1DatasetVersion = _messages.MessageField('GoogleCloudAiplatformV1beta1DatasetVersion', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsDatasetsDatasetVersionsRestoreRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDatasetVersionsRestoreRequest
  object.

  Fields:
    name: Required. The name of the DatasetVersion resource. Format: `projects
      /{project}/locations/{location}/datasets/{dataset}/datasetVersions/{data
      set_version}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDeleteRequest object.

  Fields:
    name: Required. The resource name of the Dataset to delete. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsExportRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsExportRequest object.

  Fields:
    googleCloudAiplatformV1beta1ExportDataRequest: A
      GoogleCloudAiplatformV1beta1ExportDataRequest resource to be passed as
      the request body.
    name: Required. The name of the Dataset resource. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
  """

  googleCloudAiplatformV1beta1ExportDataRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ExportDataRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsDatasetsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsGetRequest object.

  Fields:
    name: Required. The name of the Dataset resource.
    readMask: Mask specifying which fields to read.
  """

  name = _messages.StringField(1, required=True)
  readMask = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsImportRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsImportRequest object.

  Fields:
    googleCloudAiplatformV1beta1ImportDataRequest: A
      GoogleCloudAiplatformV1beta1ImportDataRequest resource to be passed as
      the request body.
    name: Required. The name of the Dataset resource. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
  """

  googleCloudAiplatformV1beta1ImportDataRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ImportDataRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsDatasetsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsListRequest object.

  Fields:
    filter: An expression for filtering the results of the request. For field
      names both snake_case and camelCase are supported. * `display_name`:
      supports = and != * `metadata_schema_uri`: supports = and != * `labels`
      supports general map functions that is: * `labels.key=value` - key:value
      equality * `labels.key:* or labels:key - key existence * A key including
      a space must be quoted. `labels."a key"`. Some examples: *
      `displayName="myDisplayName"` * `labels.myKey="myValue"`
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending. Supported fields: *
      `display_name` * `create_time` * `update_time`
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: Required. The name of the Dataset's parent resource. Format:
      `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsDatasetsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsDatasetsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1Dataset: A GoogleCloudAiplatformV1beta1Dataset
      resource to be passed as the request body.
    name: Output only. Identifier. The resource name of the Dataset. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
    updateMask: Required. The update mask applies to the resource. For the
      `FieldMask` definition, see google.protobuf.FieldMask. Updatable fields:
      * `display_name` * `description` * `labels`
  """

  googleCloudAiplatformV1beta1Dataset = _messages.MessageField('GoogleCloudAiplatformV1beta1Dataset', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsDatasetsSavedQueriesDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsSavedQueriesDeleteRequest object.

  Fields:
    name: Required. The resource name of the SavedQuery to delete. Format: `pr
      ojects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{s
      aved_query}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsSavedQueriesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsSavedQueriesListRequest object.

  Fields:
    filter: The standard list filter.
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: Required. The resource name of the Dataset to list SavedQueries
      from. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsDatasetsSavedQueriesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsSavedQueriesOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsSavedQueriesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsSavedQueriesOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsSavedQueriesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsSavedQueriesOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsSavedQueriesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsSavedQueriesOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsDatasetsSavedQueriesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsSavedQueriesOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsSearchDataItemsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsSearchDataItemsRequest object.

  Fields:
    annotationFilters: An expression that specifies what Annotations will be
      returned per DataItem. Annotations satisfied either of the conditions
      will be returned. * `annotation_spec_id` - for = or !=. Must specify
      `saved_query_id=` - saved query id that annotations should belong to.
    annotationsFilter: An expression for filtering the Annotations that will
      be returned per DataItem. * `annotation_spec_id` - for = or !=.
    annotationsLimit: If set, only up to this many of Annotations will be
      returned per DataItemView. The maximum value is 1000. If not set, the
      maximum value will be used.
    dataItemFilter: An expression for filtering the DataItem that will be
      returned. * `data_item_id` - for = or !=. * `labeled` - for = or !=. *
      `has_annotation(ANNOTATION_SPEC_ID)` - true only for DataItem that have
      at least one annotation with annotation_spec_id = `ANNOTATION_SPEC_ID`
      in the context of SavedQuery or DataLabelingJob. For example: *
      `data_item=1` * `has_annotation(5)`
    dataLabelingJob: The resource name of a DataLabelingJob. Format: `projects
      /{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}` If
      this field is set, all of the search will be done in the context of this
      DataLabelingJob.
    dataset: Required. The resource name of the Dataset from which to search
      DataItems. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
    fieldMask: Mask specifying which fields of DataItemView to read.
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending.
    orderByAnnotation_orderBy: A comma-separated list of annotation fields to
      order by, sorted in ascending order. Use "desc" after a field name for
      descending. Must also specify saved_query.
    orderByAnnotation_savedQuery: Required. Saved query of the Annotation.
      Only Annotations belong to this saved query will be considered for
      ordering.
    orderByDataItem: A comma-separated list of data item fields to order by,
      sorted in ascending order. Use "desc" after a field name for descending.
    pageSize: Requested page size. Server may return fewer results than
      requested. Default and maximum page size is 100.
    pageToken: A token identifying a page of results for the server to return
      Typically obtained via SearchDataItemsResponse.next_page_token of the
      previous DatasetService.SearchDataItems call.
    savedQuery: The resource name of a SavedQuery(annotation set in UI).
      Format: `projects/{project}/locations/{location}/datasets/{dataset}/save
      dQueries/{saved_query}` All of the search will be done in the context of
      this SavedQuery.
  """

  annotationFilters = _messages.StringField(1, repeated=True)
  annotationsFilter = _messages.StringField(2)
  annotationsLimit = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  dataItemFilter = _messages.StringField(4)
  dataLabelingJob = _messages.StringField(5)
  dataset = _messages.StringField(6, required=True)
  fieldMask = _messages.StringField(7)
  orderBy = _messages.StringField(8)
  orderByAnnotation_orderBy = _messages.StringField(9)
  orderByAnnotation_savedQuery = _messages.StringField(10)
  orderByDataItem = _messages.StringField(11)
  pageSize = _messages.IntegerField(12, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(13)
  savedQuery = _messages.StringField(14)


class AiplatformProjectsLocationsDeployRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDeployRequest object.

  Fields:
    destination: Required. The resource name of the Location to deploy the
      model in. Format: `projects/{project}/locations/{location}`
    googleCloudAiplatformV1beta1DeployPublisherModelRequest: A
      GoogleCloudAiplatformV1beta1DeployPublisherModelRequest resource to be
      passed as the request body.
  """

  destination = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1DeployPublisherModelRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployPublisherModelRequest', 2)


class AiplatformProjectsLocationsDeploymentResourcePoolsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDeploymentResourcePoolsCreateRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1CreateDeploymentResourcePoolRequest: A
      GoogleCloudAiplatformV1beta1CreateDeploymentResourcePoolRequest resource
      to be passed as the request body.
    parent: Required. The parent location resource where this
      DeploymentResourcePool will be created. Format:
      `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1CreateDeploymentResourcePoolRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1CreateDeploymentResourcePoolRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsDeploymentResourcePoolsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDeploymentResourcePoolsDeleteRequest
  object.

  Fields:
    name: Required. The name of the DeploymentResourcePool to delete. Format:
      `projects/{project}/locations/{location}/deploymentResourcePools/{deploy
      ment_resource_pool}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDeploymentResourcePoolsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDeploymentResourcePoolsGetRequest object.

  Fields:
    name: Required. The name of the DeploymentResourcePool to retrieve.
      Format: `projects/{project}/locations/{location}/deploymentResourcePools
      /{deployment_resource_pool}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDeploymentResourcePoolsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDeploymentResourcePoolsListRequest object.

  Fields:
    pageSize: The maximum number of DeploymentResourcePools to return. The
      service may return fewer than this value.
    pageToken: A page token, received from a previous
      `ListDeploymentResourcePools` call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      `ListDeploymentResourcePools` must match the call that provided the page
      token.
    parent: Required. The parent Location which owns this collection of
      DeploymentResourcePools. Format:
      `projects/{project}/locations/{location}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsDeploymentResourcePoolsOperationsCancelRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDeploymentResourcePoolsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDeploymentResourcePoolsOperationsDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDeploymentResourcePoolsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDeploymentResourcePoolsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDeploymentResourcePoolsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDeploymentResourcePoolsOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDeploymentResourcePoolsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsDeploymentResourcePoolsOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDeploymentResourcePoolsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsDeploymentResourcePoolsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDeploymentResourcePoolsPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1DeploymentResourcePool: A
      GoogleCloudAiplatformV1beta1DeploymentResourcePool resource to be passed
      as the request body.
    name: Immutable. The resource name of the DeploymentResourcePool. Format:
      `projects/{project}/locations/{location}/deploymentResourcePools/{deploy
      ment_resource_pool}`
    updateMask: Required. The list of fields to update.
  """

  googleCloudAiplatformV1beta1DeploymentResourcePool = _messages.MessageField('GoogleCloudAiplatformV1beta1DeploymentResourcePool', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsDeploymentResourcePoolsQueryDeployedModelsRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDeploymentResourcePoolsQueryDeployedModelsRequest
  object.

  Fields:
    deploymentResourcePool: Required. The name of the target
      DeploymentResourcePool to query. Format: `projects/{project}/locations/{
      location}/deploymentResourcePools/{deployment_resource_pool}`
    pageSize: The maximum number of DeployedModels to return. The service may
      return fewer than this value.
    pageToken: A page token, received from a previous `QueryDeployedModels`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to `QueryDeployedModels` must match the call
      that provided the page token.
  """

  deploymentResourcePool = _messages.StringField(1, required=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class AiplatformProjectsLocationsEdgeDevicesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEdgeDevicesOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsEdgeDevicesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEdgeDevicesOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsEdgeDevicesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEdgeDevicesOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsEdgeDevicesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEdgeDevicesOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsEdgeDevicesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEdgeDevicesOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsEndpointsChatCompletionsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsChatCompletionsRequest object.

  Fields:
    endpoint: Required. The name of the endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleApiHttpBody: A GoogleApiHttpBody resource to be passed as the
      request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleApiHttpBody = _messages.MessageField('GoogleApiHttpBody', 2)


class AiplatformProjectsLocationsEndpointsComputeTokensRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsComputeTokensRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to get lists of
      tokens and token ids.
    googleCloudAiplatformV1beta1ComputeTokensRequest: A
      GoogleCloudAiplatformV1beta1ComputeTokensRequest resource to be passed
      as the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1ComputeTokensRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ComputeTokensRequest', 2)


class AiplatformProjectsLocationsEndpointsCountTokensRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsCountTokensRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to perform token
      counting. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1CountTokensRequest: A
      GoogleCloudAiplatformV1beta1CountTokensRequest resource to be passed as
      the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1CountTokensRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1CountTokensRequest', 2)


class AiplatformProjectsLocationsEndpointsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsCreateRequest object.

  Fields:
    endpointId: Immutable. The ID to use for endpoint, which will become the
      final component of the endpoint resource name. If not provided, Vertex
      AI will generate a value for this ID. If the first character is a
      letter, this value may be up to 63 characters, and valid characters are
      `[a-z0-9-]`. The last character must be a letter or number. If the first
      character is a number, this value may be up to 9 characters, and valid
      characters are `[0-9]` with no leading zeros. When using HTTP/JSON, this
      field is populated based on a query string argument, such as
      `?endpoint_id=12345`. This is the fallback for fields that are not
      included in either the URI or the body.
    googleCloudAiplatformV1beta1Endpoint: A
      GoogleCloudAiplatformV1beta1Endpoint resource to be passed as the
      request body.
    parent: Required. The resource name of the Location to create the Endpoint
      in. Format: `projects/{project}/locations/{location}`
  """

  endpointId = _messages.StringField(1)
  googleCloudAiplatformV1beta1Endpoint = _messages.MessageField('GoogleCloudAiplatformV1beta1Endpoint', 2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsEndpointsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsDeleteRequest object.

  Fields:
    name: Required. The name of the Endpoint resource to be deleted. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsEndpointsDeployModelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsDeployModelRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint resource into which to deploy
      a Model. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1DeployModelRequest: A
      GoogleCloudAiplatformV1beta1DeployModelRequest resource to be passed as
      the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1DeployModelRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployModelRequest', 2)


class AiplatformProjectsLocationsEndpointsDirectPredictRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsDirectPredictRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1DirectPredictRequest: A
      GoogleCloudAiplatformV1beta1DirectPredictRequest resource to be passed
      as the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1DirectPredictRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1DirectPredictRequest', 2)


class AiplatformProjectsLocationsEndpointsDirectRawPredictRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsDirectRawPredictRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1DirectRawPredictRequest: A
      GoogleCloudAiplatformV1beta1DirectRawPredictRequest resource to be
      passed as the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1DirectRawPredictRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1DirectRawPredictRequest', 2)


class AiplatformProjectsLocationsEndpointsExplainRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsExplainRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      explanation. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1ExplainRequest: A
      GoogleCloudAiplatformV1beta1ExplainRequest resource to be passed as the
      request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1ExplainRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplainRequest', 2)


class AiplatformProjectsLocationsEndpointsFetchPredictOperationRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsFetchPredictOperationRequest
  object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}` or `proje
      cts/{project}/locations/{location}/publishers/{publisher}/models/{model}
      `
    googleCloudAiplatformV1beta1FetchPredictOperationRequest: A
      GoogleCloudAiplatformV1beta1FetchPredictOperationRequest resource to be
      passed as the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1FetchPredictOperationRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1FetchPredictOperationRequest', 2)


class AiplatformProjectsLocationsEndpointsGenerateContentRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsGenerateContentRequest object.

  Fields:
    googleCloudAiplatformV1beta1GenerateContentRequest: A
      GoogleCloudAiplatformV1beta1GenerateContentRequest resource to be passed
      as the request body.
    model: Required. The fully qualified name of the publisher model or tuned
      model endpoint to use. Publisher model format:
      `projects/{project}/locations/{location}/publishers/*/models/*` Tuned
      model endpoint format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
  """

  googleCloudAiplatformV1beta1GenerateContentRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1GenerateContentRequest', 1)
  model = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsEndpointsGetIamPolicyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsEndpointsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsGetRequest object.

  Fields:
    name: Required. The name of the Endpoint resource. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsEndpointsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsListRequest object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      For field names both snake_case and camelCase are supported. *
      `endpoint` supports `=` and `!=`. `endpoint` represents the Endpoint ID,
      i.e. the last segment of the Endpoint's resource name. * `display_name`
      supports `=` and `!=`. * `labels` supports general map functions that
      is: * `labels.key=value` - key:value equality * `labels.key:*` or
      `labels:key` - key existence * A key including a space must be quoted.
      `labels."a key"`. * `base_model_name` only supports `=`. Some examples:
      * `endpoint=1` * `displayName="myDisplayName"` *
      `labels.myKey="myValue"` * `baseModelName="text-bison"`
    pageSize: Optional. The standard list page size.
    pageToken: Optional. The standard list page token. Typically obtained via
      ListEndpointsResponse.next_page_token of the previous
      EndpointService.ListEndpoints call.
    parent: Required. The resource name of the Location from which to list the
      Endpoints. Format: `projects/{project}/locations/{location}`
    readMask: Optional. Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsEndpointsMutateDeployedModelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsMutateDeployedModelRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint resource into which to mutate
      a DeployedModel. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1MutateDeployedModelRequest: A
      GoogleCloudAiplatformV1beta1MutateDeployedModelRequest resource to be
      passed as the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1MutateDeployedModelRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1MutateDeployedModelRequest', 2)


class AiplatformProjectsLocationsEndpointsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsEndpointsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsEndpointsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsEndpointsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsEndpointsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsEndpointsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1Endpoint: A
      GoogleCloudAiplatformV1beta1Endpoint resource to be passed as the
      request body.
    name: Output only. The resource name of the Endpoint.
    updateMask: Required. The update mask applies to the resource. See
      google.protobuf.FieldMask.
  """

  googleCloudAiplatformV1beta1Endpoint = _messages.MessageField('GoogleCloudAiplatformV1beta1Endpoint', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsEndpointsPredictLongRunningRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsPredictLongRunningRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}` or `proje
      cts/{project}/locations/{location}/publishers/{publisher}/models/{model}
      `
    googleCloudAiplatformV1beta1PredictLongRunningRequest: A
      GoogleCloudAiplatformV1beta1PredictLongRunningRequest resource to be
      passed as the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1PredictLongRunningRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1PredictLongRunningRequest', 2)


class AiplatformProjectsLocationsEndpointsPredictRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsPredictRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1PredictRequest: A
      GoogleCloudAiplatformV1beta1PredictRequest resource to be passed as the
      request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1PredictRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1PredictRequest', 2)


class AiplatformProjectsLocationsEndpointsRawPredictRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsRawPredictRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1RawPredictRequest: A
      GoogleCloudAiplatformV1beta1RawPredictRequest resource to be passed as
      the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1RawPredictRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1RawPredictRequest', 2)


class AiplatformProjectsLocationsEndpointsServerStreamingPredictRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsServerStreamingPredictRequest
  object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1StreamingPredictRequest: A
      GoogleCloudAiplatformV1beta1StreamingPredictRequest resource to be
      passed as the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1StreamingPredictRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1StreamingPredictRequest', 2)


class AiplatformProjectsLocationsEndpointsSetIamPolicyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsEndpointsStreamGenerateContentRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsStreamGenerateContentRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1GenerateContentRequest: A
      GoogleCloudAiplatformV1beta1GenerateContentRequest resource to be passed
      as the request body.
    model: Required. The fully qualified name of the publisher model or tuned
      model endpoint to use. Publisher model format:
      `projects/{project}/locations/{location}/publishers/*/models/*` Tuned
      model endpoint format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
  """

  googleCloudAiplatformV1beta1GenerateContentRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1GenerateContentRequest', 1)
  model = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsEndpointsStreamRawPredictRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsStreamRawPredictRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1StreamRawPredictRequest: A
      GoogleCloudAiplatformV1beta1StreamRawPredictRequest resource to be
      passed as the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1StreamRawPredictRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1StreamRawPredictRequest', 2)


class AiplatformProjectsLocationsEndpointsTestIamPermissionsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsTestIamPermissionsRequest object.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  permissions = _messages.StringField(1, repeated=True)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsEndpointsUndeployModelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsUndeployModelRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint resource from which to
      undeploy a Model. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1UndeployModelRequest: A
      GoogleCloudAiplatformV1beta1UndeployModelRequest resource to be passed
      as the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1UndeployModelRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1UndeployModelRequest', 2)


class AiplatformProjectsLocationsEndpointsUpdateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsUpdateRequest object.

  Fields:
    googleCloudAiplatformV1beta1UpdateEndpointLongRunningRequest: A
      GoogleCloudAiplatformV1beta1UpdateEndpointLongRunningRequest resource to
      be passed as the request body.
    name: Output only. The resource name of the Endpoint.
  """

  googleCloudAiplatformV1beta1UpdateEndpointLongRunningRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1UpdateEndpointLongRunningRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsEvaluateDatasetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEvaluateDatasetRequest object.

  Fields:
    googleCloudAiplatformV1beta1EvaluateDatasetRequest: A
      GoogleCloudAiplatformV1beta1EvaluateDatasetRequest resource to be passed
      as the request body.
    location: Required. The resource name of the Location to evaluate the
      dataset. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1EvaluateDatasetRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1EvaluateDatasetRequest', 1)
  location = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsEvaluateInstancesRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEvaluateInstancesRequest object.

  Fields:
    googleCloudAiplatformV1beta1EvaluateInstancesRequest: A
      GoogleCloudAiplatformV1beta1EvaluateInstancesRequest resource to be
      passed as the request body.
    location: Required. The resource name of the Location to evaluate the
      instances. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1EvaluateInstancesRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1EvaluateInstancesRequest', 1)
  location = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsEvaluationTasksOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEvaluationTasksOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsEvaluationTasksOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEvaluationTasksOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsEvaluationTasksOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEvaluationTasksOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsEvaluationTasksOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEvaluationTasksOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsExampleStoresOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsExampleStoresOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsExampleStoresOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsExampleStoresOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsExampleStoresOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsExampleStoresOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsExampleStoresOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsExampleStoresOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsExampleStoresOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsExampleStoresOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsExtensionControllersOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsExtensionControllersOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsExtensionControllersOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsExtensionControllersOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsExtensionControllersOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsExtensionControllersOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsExtensionControllersOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsExtensionControllersOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsExtensionControllersOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsExtensionControllersOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsExtensionsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsExtensionsDeleteRequest object.

  Fields:
    name: Required. The name of the Extension resource to be deleted. Format:
      `projects/{project}/locations/{location}/extensions/{extension}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsExtensionsExecuteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsExtensionsExecuteRequest object.

  Fields:
    googleCloudAiplatformV1beta1ExecuteExtensionRequest: A
      GoogleCloudAiplatformV1beta1ExecuteExtensionRequest resource to be
      passed as the request body.
    name: Required. Name (identifier) of the extension; Format:
      `projects/{project}/locations/{location}/extensions/{extension}`
  """

  googleCloudAiplatformV1beta1ExecuteExtensionRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ExecuteExtensionRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsExtensionsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsExtensionsGetRequest object.

  Fields:
    name: Required. The name of the Extension resource. Format:
      `projects/{project}/locations/{location}/extensions/{extension}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsExtensionsImportRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsExtensionsImportRequest object.

  Fields:
    googleCloudAiplatformV1beta1Extension: A
      GoogleCloudAiplatformV1beta1Extension resource to be passed as the
      request body.
    parent: Required. The resource name of the Location to import the
      Extension in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1Extension = _messages.MessageField('GoogleCloudAiplatformV1beta1Extension', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsExtensionsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsExtensionsListRequest object.

  Fields:
    filter: Optional. The standard list filter. Supported fields: *
      `display_name` * `create_time` * `update_time` More detail in
      [AIP-160](https://google.aip.dev/160).
    orderBy: Optional. A comma-separated list of fields to order by, sorted in
      ascending order. Use "desc" after a field name for descending. Supported
      fields: * `display_name` * `create_time` * `update_time` Example:
      `display_name, create_time desc`.
    pageSize: Optional. The standard list page size.
    pageToken: Optional. The standard list page token.
    parent: Required. The resource name of the Location to list the Extensions
      from. Format: `projects/{project}/locations/{location}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AiplatformProjectsLocationsExtensionsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsExtensionsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsExtensionsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsExtensionsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsExtensionsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsExtensionsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsExtensionsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsExtensionsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsExtensionsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsExtensionsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsExtensionsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsExtensionsPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1Extension: A
      GoogleCloudAiplatformV1beta1Extension resource to be passed as the
      request body.
    name: Identifier. The resource name of the Extension.
    updateMask: Required. Mask specifying which fields to update. Supported
      fields: * `display_name` * `description` * `runtime_config` *
      `tool_use_examples` * `manifest.description`
  """

  googleCloudAiplatformV1beta1Extension = _messages.MessageField('GoogleCloudAiplatformV1beta1Extension', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsExtensionsQueryRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsExtensionsQueryRequest object.

  Fields:
    googleCloudAiplatformV1beta1QueryExtensionRequest: A
      GoogleCloudAiplatformV1beta1QueryExtensionRequest resource to be passed
      as the request body.
    name: Required. Name (identifier) of the extension; Format:
      `projects/{project}/locations/{location}/extensions/{extension}`
  """

  googleCloudAiplatformV1beta1QueryExtensionRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1QueryExtensionRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeatureGroupsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsCreateRequest object.

  Fields:
    featureGroupId: Required. The ID to use for this FeatureGroup, which will
      become the final component of the FeatureGroup's resource name. This
      value may be up to 128 characters, and valid characters are `[a-z0-9_]`.
      The first character cannot be a number. The value must be unique within
      the project and location.
    googleCloudAiplatformV1beta1FeatureGroup: A
      GoogleCloudAiplatformV1beta1FeatureGroup resource to be passed as the
      request body.
    parent: Required. The resource name of the Location to create
      FeatureGroups. Format: `projects/{project}/locations/{location}`
  """

  featureGroupId = _messages.StringField(1)
  googleCloudAiplatformV1beta1FeatureGroup = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureGroup', 2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsFeatureGroupsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsDeleteRequest object.

  Fields:
    force: If set to true, any Features under this FeatureGroup will also be
      deleted. (Otherwise, the request will only work if the FeatureGroup has
      no Features.)
    name: Required. The name of the FeatureGroup to be deleted. Format:
      `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsCreateRequest
  object.

  Fields:
    featureMonitorId: Required. The ID to use for this FeatureMonitor, which
      will become the final component of the FeatureGroup's resource name.
      This value may be up to 60 characters, and valid characters are
      `[a-z0-9_]`. The first character cannot be a number. The value must be
      unique within the FeatureGroup.
    googleCloudAiplatformV1beta1FeatureMonitor: A
      GoogleCloudAiplatformV1beta1FeatureMonitor resource to be passed as the
      request body.
    parent: Required. The resource name of FeatureGroup to create
      FeatureMonitor. Format:
      `projects/{project}/locations/{location}/featureGroups/{featuregroup}`
  """

  featureMonitorId = _messages.StringField(1)
  googleCloudAiplatformV1beta1FeatureMonitor = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureMonitor', 2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsDeleteRequest
  object.

  Fields:
    name: Required. The name of the FeatureMonitor to be deleted. Format: `pro
      jects/{project}/locations/{location}/featureGroups/{feature_group}/featu
      reMonitors/{feature_monitor}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsFeatureMonitorJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsFeatureMonitorJ
  obsCreateRequest object.

  Fields:
    featureMonitorJobId: Optional. Output only. System-generated ID for
      feature monitor job.
    googleCloudAiplatformV1beta1FeatureMonitorJob: A
      GoogleCloudAiplatformV1beta1FeatureMonitorJob resource to be passed as
      the request body.
    parent: Required. The resource name of FeatureMonitor to create
      FeatureMonitorJob. Format: `projects/{project}/locations/{location}/feat
      ureGroups/{feature_group}/featureMonitors/{feature_monitor}`
  """

  featureMonitorJobId = _messages.IntegerField(1)
  googleCloudAiplatformV1beta1FeatureMonitorJob = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureMonitorJob', 2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsFeatureMonitorJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsFeatureMonitorJ
  obsGetRequest object.

  Fields:
    name: Required. The name of the FeatureMonitorJob resource. Format: `proje
      cts/{project}/locations/{location}/featureGroups/{feature_group}/feature
      Monitors/{feature_monitor}/featureMonitorJobs/{feature_monitor_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsFeatureMonitorJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsFeatureMonitorJ
  obsListRequest object.

  Fields:
    filter: Optional. Lists the FeatureMonitorJobs that match the filter
      expression. The following fields are supported: * `create_time`:
      Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons. Values must be
      Examples: * `create_time > "2020-01-01"` FeatureMonitorJobs created
      after 2020-01-01.
    orderBy: Optional. A comma-separated list of fields to order by, sorted in
      ascending order. Use "desc" after a field name for descending. Supported
      Fields: * `create_time`
    pageSize: Optional. The maximum number of FeatureMonitorJobs to return.
      The service may return fewer than this value. If unspecified, at most
      100 FeatureMonitorJobs will be returned. The maximum value is 100; any
      value greater than 100 will be coerced to 100.
    pageToken: Optional. A page token, received from a previous
      FeatureRegistryService.ListFeatureMonitorJobs call. Provide this to
      retrieve the subsequent page. When paginating, all other parameters
      provided to FeatureRegistryService.ListFeatureMonitorJobs must match the
      call that provided the page token.
    parent: Required. The resource name of the FeatureMonitor to list
      FeatureMonitorJobs. Format: `projects/{project}/locations/{location}/fea
      tureGroups/{feature_group}/featureMonitors/{feature_monitor}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsGetRequest
  object.

  Fields:
    name: Required. The name of the FeatureMonitor resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsListRequest
  object.

  Fields:
    filter: Optional. Lists the FeatureMonitors that match the filter
      expression. The following fields are supported: * `create_time`:
      Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons. Values must be
      in RFC 3339 format. * `update_time`: Supports `=`, `!=`, `<`, `>`, `<=`,
      and `>=` comparisons. Values must be in RFC 3339 format. * `labels`:
      Supports key-value equality and key presence. Examples: * `create_time >
      "2020-01-01" OR update_time > "2020-01-01"` FeatureMonitors created or
      updated after 2020-01-01. * `labels.env = "prod"` FeatureGroups with
      label "env" set to "prod".
    orderBy: Optional. A comma-separated list of fields to order by, sorted in
      ascending order. Use "desc" after a field name for descending. Supported
      Fields: * `create_time` * `update_time`
    pageSize: Optional. The maximum number of FeatureGroups to return. The
      service may return fewer than this value. If unspecified, at most 100
      FeatureMonitors will be returned. The maximum value is 100; any value
      greater than 100 will be coerced to 100.
    pageToken: Optional. A page token, received from a previous
      FeatureRegistryService.ListFeatureMonitors call. Provide this to
      retrieve the subsequent page. When paginating, all other parameters
      provided to FeatureRegistryService.ListFeatureMonitors must match the
      call that provided the page token.
    parent: Required. The resource name of the FeatureGroup to list
      FeatureMonitors. Format:
      `projects/{project}/locations/{location}/featureGroups/{featureGroup}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsOperationsDelet
  eRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsOperationsGetRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsFeatureMonitorsPatchRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1FeatureMonitor: A
      GoogleCloudAiplatformV1beta1FeatureMonitor resource to be passed as the
      request body.
    name: Identifier. Name of the FeatureMonitor. Format: `projects/{project}/
      locations/{location}/featureGroups/{featureGroup}/featureMonitors/{featu
      reMonitor}`
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the FeatureMonitor resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then only the non-empty fields present in the
      request will be overwritten. Set the update_mask to `*` to override all
      fields. Updatable fields: * `labels` * `description` * `schedule_config`
      * `feature_selection_config`
  """

  googleCloudAiplatformV1beta1FeatureMonitor = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureMonitor', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsFeatureGroupsFeaturesBatchCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsFeaturesBatchCreateRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1BatchCreateFeaturesRequest: A
      GoogleCloudAiplatformV1beta1BatchCreateFeaturesRequest resource to be
      passed as the request body.
    parent: Required. The resource name of the EntityType/FeatureGroup to
      create the batch of Features under. Format: `projects/{project}/location
      s/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
      `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  """

  googleCloudAiplatformV1beta1BatchCreateFeaturesRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchCreateFeaturesRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeatureGroupsFeaturesCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsFeaturesCreateRequest object.

  Fields:
    featureId: Required. The ID to use for the Feature, which will become the
      final component of the Feature's resource name. This value may be up to
      128 characters, and valid characters are `[a-z0-9_]`. The first
      character cannot be a number. The value must be unique within an
      EntityType/FeatureGroup.
    googleCloudAiplatformV1beta1Feature: A GoogleCloudAiplatformV1beta1Feature
      resource to be passed as the request body.
    parent: Required. The resource name of the EntityType or FeatureGroup to
      create a Feature. Format for entity_type as parent: `projects/{project}/
      locations/{location}/featurestores/{featurestore}/entityTypes/{entity_ty
      pe}` Format for feature_group as parent:
      `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  """

  featureId = _messages.StringField(1)
  googleCloudAiplatformV1beta1Feature = _messages.MessageField('GoogleCloudAiplatformV1beta1Feature', 2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsFeatureGroupsFeaturesDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsFeaturesDeleteRequest object.

  Fields:
    name: Required. The name of the Features to be deleted. Format: `projects/
      {project}/locations/{location}/featurestores/{featurestore}/entityTypes/
      {entity_type}/features/{feature}` `projects/{project}/locations/{locatio
      n}/featureGroups/{feature_group}/features/{feature}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeatureGroupsFeaturesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsFeaturesGetRequest object.

  Fields:
    featureStatsAndAnomalySpec_latestStatsCount: Optional. If set, returns the
      most recent count of stats. Valid value is [0, 100]. If stats_time_range
      is set, return most recent count of stats within the stats_time_range.
    featureStatsAndAnomalySpec_statsTimeRange_endTime: Optional. Exclusive end
      of the interval. If specified, a Timestamp matching this interval will
      have to be before the end.
    featureStatsAndAnomalySpec_statsTimeRange_startTime: Optional. Inclusive
      start of the interval. If specified, a Timestamp matching this interval
      will have to be the same or after the start.
    name: Required. The name of the Feature resource. Format for entity_type
      as parent: `projects/{project}/locations/{location}/featurestores/{featu
      restore}/entityTypes/{entity_type}` Format for feature_group as parent:
      `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  """

  featureStatsAndAnomalySpec_latestStatsCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  featureStatsAndAnomalySpec_statsTimeRange_endTime = _messages.StringField(2)
  featureStatsAndAnomalySpec_statsTimeRange_startTime = _messages.StringField(3)
  name = _messages.StringField(4, required=True)


class AiplatformProjectsLocationsFeatureGroupsFeaturesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsFeaturesListRequest object.

  Fields:
    filter: Lists the Features that match the filter expression. The following
      filters are supported: * `value_type`: Supports = and != comparisons. *
      `create_time`: Supports =, !=, <, >, >=, and <= comparisons. Values must
      be in RFC 3339 format. * `update_time`: Supports =, !=, <, >, >=, and <=
      comparisons. Values must be in RFC 3339 format. * `labels`: Supports
      key-value equality as well as key presence. Examples: * `value_type =
      DOUBLE` --> Features whose type is DOUBLE. * `create_time >
      \"2020-01-31T15:30:00.000000Z\" OR update_time >
      \"2020-01-31T15:30:00.000000Z\"` --> EntityTypes created or updated
      after 2020-01-31T15:30:00.000000Z. * `labels.active = yes AND labels.env
      = prod` --> Features having both (active: yes) and (env: prod) labels. *
      `labels.env: *` --> Any Feature which has a label with 'env' as the key.
    latestStatsCount: Only applicable for Vertex AI Feature Store (Legacy). If
      set, return the most recent ListFeaturesRequest.latest_stats_count of
      stats for each Feature in response. Valid value is [0, 10]. If number of
      stats exists < ListFeaturesRequest.latest_stats_count, return all
      existing stats.
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending. Supported fields: *
      `feature_id` * `value_type` (Not supported for FeatureRegistry Feature)
      * `create_time` * `update_time`
    pageSize: The maximum number of Features to return. The service may return
      fewer than this value. If unspecified, at most 1000 Features will be
      returned. The maximum value is 1000; any value greater than 1000 will be
      coerced to 1000.
    pageToken: A page token, received from a previous
      FeaturestoreService.ListFeatures call or
      FeatureRegistryService.ListFeatures call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      FeaturestoreService.ListFeatures or FeatureRegistryService.ListFeatures
      must match the call that provided the page token.
    parent: Required. The resource name of the Location to list Features.
      Format for entity_type as parent: `projects/{project}/locations/{locatio
      n}/featurestores/{featurestore}/entityTypes/{entity_type}` Format for
      feature_group as parent:
      `projects/{project}/locations/{location}/featureGroups/{feature_group}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  latestStatsCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  orderBy = _messages.StringField(3)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)
  parent = _messages.StringField(6, required=True)
  readMask = _messages.StringField(7)


class AiplatformProjectsLocationsFeatureGroupsFeaturesOperationsDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeatureGroupsFeaturesOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeatureGroupsFeaturesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsFeaturesOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeatureGroupsFeaturesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsFeaturesOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsFeatureGroupsFeaturesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsFeaturesOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsFeatureGroupsFeaturesPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsFeaturesPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1Feature: A GoogleCloudAiplatformV1beta1Feature
      resource to be passed as the request body.
    name: Immutable. Name of the Feature. Format: `projects/{project}/location
      s/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/feat
      ures/{feature}` `projects/{project}/locations/{location}/featureGroups/{
      feature_group}/features/{feature}` The last part feature is assigned by
      the client. The feature can be up to 64 characters long and can consist
      only of ASCII Latin letters A-Z and a-z, underscore(_), and ASCII digits
      0-9 starting with a letter. The value will be unique given an entity
      type.
    updateMask: Field mask is used to specify the fields to be overwritten in
      the Features resource by the update. The fields specified in the
      update_mask are relative to the resource, not the full request. A field
      will be overwritten if it is in the mask. If the user does not provide a
      mask then only the non-empty fields present in the request will be
      overwritten. Set the update_mask to `*` to override all fields.
      Updatable fields: * `description` * `labels` * `disable_monitoring` (Not
      supported for FeatureRegistryService Feature) * `point_of_contact` (Not
      supported for FeaturestoreService FeatureStore)
  """

  googleCloudAiplatformV1beta1Feature = _messages.MessageField('GoogleCloudAiplatformV1beta1Feature', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsFeatureGroupsGetIamPolicyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeatureGroupsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsGetRequest object.

  Fields:
    name: Required. The name of the FeatureGroup resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeatureGroupsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsListRequest object.

  Fields:
    filter: Lists the FeatureGroups that match the filter expression. The
      following fields are supported: * `create_time`: Supports `=`, `!=`,
      `<`, `>`, `<=`, and `>=` comparisons. Values must be in RFC 3339 format.
      * `update_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=`
      comparisons. Values must be in RFC 3339 format. * `labels`: Supports
      key-value equality and key presence. Examples: * `create_time >
      "2020-01-01" OR update_time > "2020-01-01"` FeatureGroups created or
      updated after 2020-01-01. * `labels.env = "prod"` FeatureGroups with
      label "env" set to "prod".
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending. Supported Fields: *
      `create_time` * `update_time`
    pageSize: The maximum number of FeatureGroups to return. The service may
      return fewer than this value. If unspecified, at most 100 FeatureGroups
      will be returned. The maximum value is 100; any value greater than 100
      will be coerced to 100.
    pageToken: A page token, received from a previous
      FeatureRegistryService.ListFeatureGroups call. Provide this to retrieve
      the subsequent page. When paginating, all other parameters provided to
      FeatureRegistryService.ListFeatureGroups must match the call that
      provided the page token.
    parent: Required. The resource name of the Location to list FeatureGroups.
      Format: `projects/{project}/locations/{location}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AiplatformProjectsLocationsFeatureGroupsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeatureGroupsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeatureGroupsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsFeatureGroupsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsFeatureGroupsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1FeatureGroup: A
      GoogleCloudAiplatformV1beta1FeatureGroup resource to be passed as the
      request body.
    name: Identifier. Name of the FeatureGroup. Format:
      `projects/{project}/locations/{location}/featureGroups/{featureGroup}`
    updateMask: Field mask is used to specify the fields to be overwritten in
      the FeatureGroup resource by the update. The fields specified in the
      update_mask are relative to the resource, not the full request. A field
      will be overwritten if it is in the mask. If the user does not provide a
      mask then only the non-empty fields present in the request will be
      overwritten. Set the update_mask to `*` to override all fields.
      Updatable fields: * `labels` * `description` * `big_query` *
      `big_query.entity_id_columns` * `service_agent_type`
  """

  googleCloudAiplatformV1beta1FeatureGroup = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureGroup', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsFeatureGroupsSetIamPolicyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeatureGroupsTestIamPermissionsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureGroupsTestIamPermissionsRequest
  object.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  permissions = _messages.StringField(1, repeated=True)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeatureOnlineStoresCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresCreateRequest object.

  Fields:
    featureOnlineStoreId: Required. The ID to use for this FeatureOnlineStore,
      which will become the final component of the FeatureOnlineStore's
      resource name. This value may be up to 60 characters, and valid
      characters are `[a-z0-9_]`. The first character cannot be a number. The
      value must be unique within the project and location.
    googleCloudAiplatformV1beta1FeatureOnlineStore: A
      GoogleCloudAiplatformV1beta1FeatureOnlineStore resource to be passed as
      the request body.
    parent: Required. The resource name of the Location to create
      FeatureOnlineStores. Format: `projects/{project}/locations/{location}`
  """

  featureOnlineStoreId = _messages.StringField(1)
  googleCloudAiplatformV1beta1FeatureOnlineStore = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureOnlineStore', 2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsFeatureOnlineStoresDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresDeleteRequest object.

  Fields:
    force: If set to true, any FeatureViews and Features for this
      FeatureOnlineStore will also be deleted. (Otherwise, the request will
      only work if the FeatureOnlineStore has no FeatureViews.)
    name: Required. The name of the FeatureOnlineStore to be deleted. Format:
      `projects/{project}/locations/{location}/featureOnlineStores/{feature_on
      line_store}`
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsCreateRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsCreateRequest
  object.

  Fields:
    featureViewId: Required. The ID to use for the FeatureView, which will
      become the final component of the FeatureView's resource name. This
      value may be up to 60 characters, and valid characters are `[a-z0-9_]`.
      The first character cannot be a number. The value must be unique within
      a FeatureOnlineStore.
    googleCloudAiplatformV1beta1FeatureView: A
      GoogleCloudAiplatformV1beta1FeatureView resource to be passed as the
      request body.
    parent: Required. The resource name of the FeatureOnlineStore to create
      FeatureViews. Format: `projects/{project}/locations/{location}/featureOn
      lineStores/{feature_online_store}`
    runSyncImmediately: Immutable. If set to true, one on demand sync will be
      run immediately, regardless whether the FeatureView.sync_config is
      configured or not.
  """

  featureViewId = _messages.StringField(1)
  googleCloudAiplatformV1beta1FeatureView = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureView', 2)
  parent = _messages.StringField(3, required=True)
  runSyncImmediately = _messages.BooleanField(4)


class AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsDeleteRequest
  object.

  Fields:
    name: Required. The name of the FeatureView to be deleted. Format: `projec
      ts/{project}/locations/{location}/featureOnlineStores/{feature_online_st
      ore}/featureViews/{feature_view}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewS
  yncsGetRequest object.

  Fields:
    name: Required. The name of the FeatureViewSync resource. Format: `project
      s/{project}/locations/{location}/featureOnlineStores/{feature_online_sto
      re}/featureViews/{feature_view}/featureViewSyncs/{feature_view_sync}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewS
  yncsListRequest object.

  Fields:
    filter: Lists the FeatureViewSyncs that match the filter expression. The
      following filters are supported: * `create_time`: Supports `=`, `!=`,
      `<`, `>`, `>=`, and `<=` comparisons. Values must be in RFC 3339 format.
      Examples: * `create_time > \"2020-01-31T15:30:00.000000Z\"` -->
      FeatureViewSyncs created after 2020-01-31T15:30:00.000000Z.
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending. Supported fields: *
      `create_time`
    pageSize: The maximum number of FeatureViewSyncs to return. The service
      may return fewer than this value. If unspecified, at most 1000
      FeatureViewSyncs will be returned. The maximum value is 1000; any value
      greater than 1000 will be coerced to 1000.
    pageToken: A page token, received from a previous
      FeatureOnlineStoreAdminService.ListFeatureViewSyncs call. Provide this
      to retrieve the subsequent page. When paginating, all other parameters
      provided to FeatureOnlineStoreAdminService.ListFeatureViewSyncs must
      match the call that provided the page token.
    parent: Required. The resource name of the FeatureView to list
      FeatureViewSyncs. Format: `projects/{project}/locations/{location}/featu
      reOnlineStores/{feature_online_store}/featureViews/{feature_view}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsFetchFeatureValuesRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsFetchFeature
  ValuesRequest object.

  Fields:
    featureView: Required. FeatureView resource format `projects/{project}/loc
      ations/{location}/featureOnlineStores/{featureOnlineStore}/featureViews/
      {featureView}`
    googleCloudAiplatformV1beta1FetchFeatureValuesRequest: A
      GoogleCloudAiplatformV1beta1FetchFeatureValuesRequest resource to be
      passed as the request body.
  """

  featureView = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1FetchFeatureValuesRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1FetchFeatureValuesRequest', 2)


class AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsGetIamPolicyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsGetIamPolicy
  Request object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsGetRequest
  object.

  Fields:
    name: Required. The name of the FeatureView resource. Format: `projects/{p
      roject}/locations/{location}/featureOnlineStores/{feature_online_store}/
      featureViews/{feature_view}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsListRequest
  object.

  Fields:
    filter: Lists the FeatureViews that match the filter expression. The
      following filters are supported: * `create_time`: Supports `=`, `!=`,
      `<`, `>`, `>=`, and `<=` comparisons. Values must be in RFC 3339 format.
      * `update_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=`
      comparisons. Values must be in RFC 3339 format. * `labels`: Supports
      key-value equality as well as key presence. Examples: * `create_time >
      \"2020-01-31T15:30:00.000000Z\" OR update_time >
      \"2020-01-31T15:30:00.000000Z\"` --> FeatureViews created or updated
      after 2020-01-31T15:30:00.000000Z. * `labels.active = yes AND labels.env
      = prod` --> FeatureViews having both (active: yes) and (env: prod)
      labels. * `labels.env: *` --> Any FeatureView which has a label with
      'env' as the key.
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending. Supported fields: *
      `feature_view_id` * `create_time` * `update_time`
    pageSize: The maximum number of FeatureViews to return. The service may
      return fewer than this value. If unspecified, at most 1000 FeatureViews
      will be returned. The maximum value is 1000; any value greater than 1000
      will be coerced to 1000.
    pageToken: A page token, received from a previous
      FeatureOnlineStoreAdminService.ListFeatureViews call. Provide this to
      retrieve the subsequent page. When paginating, all other parameters
      provided to FeatureOnlineStoreAdminService.ListFeatureViews must match
      the call that provided the page token.
    parent: Required. The resource name of the FeatureOnlineStore to list
      FeatureViews. Format: `projects/{project}/locations/{location}/featureOn
      lineStores/{feature_online_store}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsDe
  leteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsGe
  tRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsLi
  stRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsWa
  itRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsPatchRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1FeatureView: A
      GoogleCloudAiplatformV1beta1FeatureView resource to be passed as the
      request body.
    name: Identifier. Name of the FeatureView. Format: `projects/{project}/loc
      ations/{location}/featureOnlineStores/{feature_online_store}/featureView
      s/{feature_view}`
    updateMask: Field mask is used to specify the fields to be overwritten in
      the FeatureView resource by the update. The fields specified in the
      update_mask are relative to the resource, not the full request. A field
      will be overwritten if it is in the mask. If the user does not provide a
      mask then only the non-empty fields present in the request will be
      overwritten. Set the update_mask to `*` to override all fields.
      Updatable fields: * `labels` * `service_agent_type` * `big_query_source`
      * `big_query_source.uri` * `big_query_source.entity_id_columns` *
      `feature_registry_source` * `feature_registry_source.feature_groups` *
      `sync_config` * `sync_config.cron` *
      `optimized_config.automatic_resources`
  """

  googleCloudAiplatformV1beta1FeatureView = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureView', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsSearchNearestEntitiesRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsSearchNeares
  tEntitiesRequest object.

  Fields:
    featureView: Required. FeatureView resource format `projects/{project}/loc
      ations/{location}/featureOnlineStores/{featureOnlineStore}/featureViews/
      {featureView}`
    googleCloudAiplatformV1beta1SearchNearestEntitiesRequest: A
      GoogleCloudAiplatformV1beta1SearchNearestEntitiesRequest resource to be
      passed as the request body.
  """

  featureView = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1SearchNearestEntitiesRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1SearchNearestEntitiesRequest', 2)


class AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsSetIamPolicyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsSetIamPolicy
  Request object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsStreamingFetchFeatureValuesRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsStreamingFet
  chFeatureValuesRequest object.

  Fields:
    featureView: Required. FeatureView resource format `projects/{project}/loc
      ations/{location}/featureOnlineStores/{featureOnlineStore}/featureViews/
      {featureView}`
    googleCloudAiplatformV1beta1StreamingFetchFeatureValuesRequest: A
      GoogleCloudAiplatformV1beta1StreamingFetchFeatureValuesRequest resource
      to be passed as the request body.
  """

  featureView = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1StreamingFetchFeatureValuesRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1StreamingFetchFeatureValuesRequest', 2)


class AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsSyncRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsSyncRequest
  object.

  Fields:
    featureView: Required. Format: `projects/{project}/locations/{location}/fe
      atureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
    googleCloudAiplatformV1beta1SyncFeatureViewRequest: A
      GoogleCloudAiplatformV1beta1SyncFeatureViewRequest resource to be passed
      as the request body.
  """

  featureView = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1SyncFeatureViewRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1SyncFeatureViewRequest', 2)


class AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsTestIamPermissionsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresFeatureViewsTestIamPermi
  ssionsRequest object.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  permissions = _messages.StringField(1, repeated=True)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeatureOnlineStoresGetIamPolicyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeatureOnlineStoresGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresGetRequest object.

  Fields:
    name: Required. The name of the FeatureOnlineStore resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeatureOnlineStoresListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresListRequest object.

  Fields:
    filter: Lists the FeatureOnlineStores that match the filter expression.
      The following fields are supported: * `create_time`: Supports `=`, `!=`,
      `<`, `>`, `<=`, and `>=` comparisons. Values must be in RFC 3339 format.
      * `update_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=`
      comparisons. Values must be in RFC 3339 format. * `labels`: Supports
      key-value equality and key presence. Examples: * `create_time >
      "2020-01-01" OR update_time > "2020-01-01"` FeatureOnlineStores created
      or updated after 2020-01-01. * `labels.env = "prod"` FeatureOnlineStores
      with label "env" set to "prod".
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending. Supported Fields: *
      `create_time` * `update_time`
    pageSize: The maximum number of FeatureOnlineStores to return. The service
      may return fewer than this value. If unspecified, at most 100
      FeatureOnlineStores will be returned. The maximum value is 100; any
      value greater than 100 will be coerced to 100.
    pageToken: A page token, received from a previous
      FeatureOnlineStoreAdminService.ListFeatureOnlineStores call. Provide
      this to retrieve the subsequent page. When paginating, all other
      parameters provided to
      FeatureOnlineStoreAdminService.ListFeatureOnlineStores must match the
      call that provided the page token.
    parent: Required. The resource name of the Location to list
      FeatureOnlineStores. Format: `projects/{project}/locations/{location}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AiplatformProjectsLocationsFeatureOnlineStoresOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeatureOnlineStoresOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeatureOnlineStoresOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsFeatureOnlineStoresOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsFeatureOnlineStoresPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1FeatureOnlineStore: A
      GoogleCloudAiplatformV1beta1FeatureOnlineStore resource to be passed as
      the request body.
    name: Identifier. Name of the FeatureOnlineStore. Format: `projects/{proje
      ct}/locations/{location}/featureOnlineStores/{featureOnlineStore}`
    updateMask: Field mask is used to specify the fields to be overwritten in
      the FeatureOnlineStore resource by the update. The fields specified in
      the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then only the non-empty fields present in the request
      will be overwritten. Set the update_mask to `*` to override all fields.
      Updatable fields: * `labels` * `description` * `bigtable` *
      `bigtable.auto_scaling` * `bigtable.enable_multi_region_replica`
  """

  googleCloudAiplatformV1beta1FeatureOnlineStore = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureOnlineStore', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsFeatureOnlineStoresSetIamPolicyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeatureOnlineStoresSetIamPolicyRequest
  object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeatureOnlineStoresTestIamPermissionsRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeatureOnlineStoresTestIamPermissionsRequest
  object.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  permissions = _messages.StringField(1, repeated=True)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeaturestoresBatchReadFeatureValuesRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresBatchReadFeatureValuesRequest
  object.

  Fields:
    featurestore: Required. The resource name of the Featurestore from which
      to query Feature values. Format:
      `projects/{project}/locations/{location}/featurestores/{featurestore}`
    googleCloudAiplatformV1beta1BatchReadFeatureValuesRequest: A
      GoogleCloudAiplatformV1beta1BatchReadFeatureValuesRequest resource to be
      passed as the request body.
  """

  featurestore = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1BatchReadFeatureValuesRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchReadFeatureValuesRequest', 2)


class AiplatformProjectsLocationsFeaturestoresCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresCreateRequest object.

  Fields:
    featurestoreId: Required. The ID to use for this Featurestore, which will
      become the final component of the Featurestore's resource name. This
      value may be up to 60 characters, and valid characters are `[a-z0-9_]`.
      The first character cannot be a number. The value must be unique within
      the project and location.
    googleCloudAiplatformV1beta1Featurestore: A
      GoogleCloudAiplatformV1beta1Featurestore resource to be passed as the
      request body.
    parent: Required. The resource name of the Location to create
      Featurestores. Format: `projects/{project}/locations/{location}`
  """

  featurestoreId = _messages.StringField(1)
  googleCloudAiplatformV1beta1Featurestore = _messages.MessageField('GoogleCloudAiplatformV1beta1Featurestore', 2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsFeaturestoresDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresDeleteRequest object.

  Fields:
    force: If set to true, any EntityTypes and Features for this Featurestore
      will also be deleted. (Otherwise, the request will only work if the
      Featurestore has no EntityTypes.)
    name: Required. The name of the Featurestore to be deleted. Format:
      `projects/{project}/locations/{location}/featurestores/{featurestore}`
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesCreateRequest
  object.

  Fields:
    entityTypeId: Required. The ID to use for the EntityType, which will
      become the final component of the EntityType's resource name. This value
      may be up to 60 characters, and valid characters are `[a-z0-9_]`. The
      first character cannot be a number. The value must be unique within a
      featurestore.
    googleCloudAiplatformV1beta1EntityType: A
      GoogleCloudAiplatformV1beta1EntityType resource to be passed as the
      request body.
    parent: Required. The resource name of the Featurestore to create
      EntityTypes. Format:
      `projects/{project}/locations/{location}/featurestores/{featurestore}`
  """

  entityTypeId = _messages.StringField(1)
  googleCloudAiplatformV1beta1EntityType = _messages.MessageField('GoogleCloudAiplatformV1beta1EntityType', 2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesDeleteFeatureValuesRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesDeleteFeatureValues
  Request object.

  Fields:
    entityType: Required. The resource name of the EntityType grouping the
      Features for which values are being deleted from. Format: `projects/{pro
      ject}/locations/{location}/featurestores/{featurestore}/entityTypes/{ent
      ityType}`
    googleCloudAiplatformV1beta1DeleteFeatureValuesRequest: A
      GoogleCloudAiplatformV1beta1DeleteFeatureValuesRequest resource to be
      passed as the request body.
  """

  entityType = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1DeleteFeatureValuesRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1DeleteFeatureValuesRequest', 2)


class AiplatformProjectsLocationsFeaturestoresEntityTypesDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesDeleteRequest
  object.

  Fields:
    force: If set to true, any Features for this EntityType will also be
      deleted. (Otherwise, the request will only work if the EntityType has no
      Features.)
    name: Required. The name of the EntityType to be deleted. Format: `project
      s/{project}/locations/{location}/featurestores/{featurestore}/entityType
      s/{entity_type}`
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesExportFeatureValuesRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesExportFeatureValues
  Request object.

  Fields:
    entityType: Required. The resource name of the EntityType from which to
      export Feature values. Format: `projects/{project}/locations/{location}/
      featurestores/{featurestore}/entityTypes/{entity_type}`
    googleCloudAiplatformV1beta1ExportFeatureValuesRequest: A
      GoogleCloudAiplatformV1beta1ExportFeatureValuesRequest resource to be
      passed as the request body.
  """

  entityType = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1ExportFeatureValuesRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ExportFeatureValuesRequest', 2)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesBatchCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesBatchCreate
  Request object.

  Fields:
    googleCloudAiplatformV1beta1BatchCreateFeaturesRequest: A
      GoogleCloudAiplatformV1beta1BatchCreateFeaturesRequest resource to be
      passed as the request body.
    parent: Required. The resource name of the EntityType/FeatureGroup to
      create the batch of Features under. Format: `projects/{project}/location
      s/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
      `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  """

  googleCloudAiplatformV1beta1BatchCreateFeaturesRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchCreateFeaturesRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesCreateRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesCreateRequest
  object.

  Fields:
    featureId: Required. The ID to use for the Feature, which will become the
      final component of the Feature's resource name. This value may be up to
      128 characters, and valid characters are `[a-z0-9_]`. The first
      character cannot be a number. The value must be unique within an
      EntityType/FeatureGroup.
    googleCloudAiplatformV1beta1Feature: A GoogleCloudAiplatformV1beta1Feature
      resource to be passed as the request body.
    parent: Required. The resource name of the EntityType or FeatureGroup to
      create a Feature. Format for entity_type as parent: `projects/{project}/
      locations/{location}/featurestores/{featurestore}/entityTypes/{entity_ty
      pe}` Format for feature_group as parent:
      `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  """

  featureId = _messages.StringField(1)
  googleCloudAiplatformV1beta1Feature = _messages.MessageField('GoogleCloudAiplatformV1beta1Feature', 2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesDeleteRequest
  object.

  Fields:
    name: Required. The name of the Features to be deleted. Format: `projects/
      {project}/locations/{location}/featurestores/{featurestore}/entityTypes/
      {entity_type}/features/{feature}` `projects/{project}/locations/{locatio
      n}/featureGroups/{feature_group}/features/{feature}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesGetRequest
  object.

  Fields:
    featureStatsAndAnomalySpec_latestStatsCount: Optional. If set, returns the
      most recent count of stats. Valid value is [0, 100]. If stats_time_range
      is set, return most recent count of stats within the stats_time_range.
    featureStatsAndAnomalySpec_statsTimeRange_endTime: Optional. Exclusive end
      of the interval. If specified, a Timestamp matching this interval will
      have to be before the end.
    featureStatsAndAnomalySpec_statsTimeRange_startTime: Optional. Inclusive
      start of the interval. If specified, a Timestamp matching this interval
      will have to be the same or after the start.
    name: Required. The name of the Feature resource. Format for entity_type
      as parent: `projects/{project}/locations/{location}/featurestores/{featu
      restore}/entityTypes/{entity_type}` Format for feature_group as parent:
      `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  """

  featureStatsAndAnomalySpec_latestStatsCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  featureStatsAndAnomalySpec_statsTimeRange_endTime = _messages.StringField(2)
  featureStatsAndAnomalySpec_statsTimeRange_startTime = _messages.StringField(3)
  name = _messages.StringField(4, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesListRequest
  object.

  Fields:
    filter: Lists the Features that match the filter expression. The following
      filters are supported: * `value_type`: Supports = and != comparisons. *
      `create_time`: Supports =, !=, <, >, >=, and <= comparisons. Values must
      be in RFC 3339 format. * `update_time`: Supports =, !=, <, >, >=, and <=
      comparisons. Values must be in RFC 3339 format. * `labels`: Supports
      key-value equality as well as key presence. Examples: * `value_type =
      DOUBLE` --> Features whose type is DOUBLE. * `create_time >
      \"2020-01-31T15:30:00.000000Z\" OR update_time >
      \"2020-01-31T15:30:00.000000Z\"` --> EntityTypes created or updated
      after 2020-01-31T15:30:00.000000Z. * `labels.active = yes AND labels.env
      = prod` --> Features having both (active: yes) and (env: prod) labels. *
      `labels.env: *` --> Any Feature which has a label with 'env' as the key.
    latestStatsCount: Only applicable for Vertex AI Feature Store (Legacy). If
      set, return the most recent ListFeaturesRequest.latest_stats_count of
      stats for each Feature in response. Valid value is [0, 10]. If number of
      stats exists < ListFeaturesRequest.latest_stats_count, return all
      existing stats.
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending. Supported fields: *
      `feature_id` * `value_type` (Not supported for FeatureRegistry Feature)
      * `create_time` * `update_time`
    pageSize: The maximum number of Features to return. The service may return
      fewer than this value. If unspecified, at most 1000 Features will be
      returned. The maximum value is 1000; any value greater than 1000 will be
      coerced to 1000.
    pageToken: A page token, received from a previous
      FeaturestoreService.ListFeatures call or
      FeatureRegistryService.ListFeatures call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      FeaturestoreService.ListFeatures or FeatureRegistryService.ListFeatures
      must match the call that provided the page token.
    parent: Required. The resource name of the Location to list Features.
      Format for entity_type as parent: `projects/{project}/locations/{locatio
      n}/featurestores/{featurestore}/entityTypes/{entity_type}` Format for
      feature_group as parent:
      `projects/{project}/locations/{location}/featureGroups/{feature_group}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  latestStatsCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  orderBy = _messages.StringField(3)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)
  parent = _messages.StringField(6, required=True)
  readMask = _messages.StringField(7)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsC
  ancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsD
  eleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsG
  etRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsL
  istRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsW
  aitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesPatchRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesPatchRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1Feature: A GoogleCloudAiplatformV1beta1Feature
      resource to be passed as the request body.
    name: Immutable. Name of the Feature. Format: `projects/{project}/location
      s/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/feat
      ures/{feature}` `projects/{project}/locations/{location}/featureGroups/{
      feature_group}/features/{feature}` The last part feature is assigned by
      the client. The feature can be up to 64 characters long and can consist
      only of ASCII Latin letters A-Z and a-z, underscore(_), and ASCII digits
      0-9 starting with a letter. The value will be unique given an entity
      type.
    updateMask: Field mask is used to specify the fields to be overwritten in
      the Features resource by the update. The fields specified in the
      update_mask are relative to the resource, not the full request. A field
      will be overwritten if it is in the mask. If the user does not provide a
      mask then only the non-empty fields present in the request will be
      overwritten. Set the update_mask to `*` to override all fields.
      Updatable fields: * `description` * `labels` * `disable_monitoring` (Not
      supported for FeatureRegistryService Feature) * `point_of_contact` (Not
      supported for FeaturestoreService FeatureStore)
  """

  googleCloudAiplatformV1beta1Feature = _messages.MessageField('GoogleCloudAiplatformV1beta1Feature', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsFeaturestoresEntityTypesGetIamPolicyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesGetRequest object.

  Fields:
    name: Required. The name of the EntityType resource. Format: `projects/{pr
      oject}/locations/{location}/featurestores/{featurestore}/entityTypes/{en
      tity_type}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesImportFeatureValuesRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesImportFeatureValues
  Request object.

  Fields:
    entityType: Required. The resource name of the EntityType grouping the
      Features for which values are being imported. Format: `projects/{project
      }/locations/{location}/featurestores/{featurestore}/entityTypes/{entityT
      ype}`
    googleCloudAiplatformV1beta1ImportFeatureValuesRequest: A
      GoogleCloudAiplatformV1beta1ImportFeatureValuesRequest resource to be
      passed as the request body.
  """

  entityType = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1ImportFeatureValuesRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ImportFeatureValuesRequest', 2)


class AiplatformProjectsLocationsFeaturestoresEntityTypesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesListRequest object.

  Fields:
    filter: Lists the EntityTypes that match the filter expression. The
      following filters are supported: * `create_time`: Supports `=`, `!=`,
      `<`, `>`, `>=`, and `<=` comparisons. Values must be in RFC 3339 format.
      * `update_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=`
      comparisons. Values must be in RFC 3339 format. * `labels`: Supports
      key-value equality as well as key presence. Examples: * `create_time >
      \"2020-01-31T15:30:00.000000Z\" OR update_time >
      \"2020-01-31T15:30:00.000000Z\"` --> EntityTypes created or updated
      after 2020-01-31T15:30:00.000000Z. * `labels.active = yes AND labels.env
      = prod` --> EntityTypes having both (active: yes) and (env: prod)
      labels. * `labels.env: *` --> Any EntityType which has a label with
      'env' as the key.
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending. Supported fields: *
      `entity_type_id` * `create_time` * `update_time`
    pageSize: The maximum number of EntityTypes to return. The service may
      return fewer than this value. If unspecified, at most 1000 EntityTypes
      will be returned. The maximum value is 1000; any value greater than 1000
      will be coerced to 1000.
    pageToken: A page token, received from a previous
      FeaturestoreService.ListEntityTypes call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      FeaturestoreService.ListEntityTypes must match the call that provided
      the page token.
    parent: Required. The resource name of the Featurestore to list
      EntityTypes. Format:
      `projects/{project}/locations/{location}/featurestores/{featurestore}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsCancelRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsGetRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsFeaturestoresEntityTypesPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesPatchRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1EntityType: A
      GoogleCloudAiplatformV1beta1EntityType resource to be passed as the
      request body.
    name: Immutable. Name of the EntityType. Format: `projects/{project}/locat
      ions/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
      The last part entity_type is assigned by the client. The entity_type can
      be up to 64 characters long and can consist only of ASCII Latin letters
      A-Z and a-z and underscore(_), and ASCII digits 0-9 starting with a
      letter. The value will be unique given a featurestore.
    updateMask: Field mask is used to specify the fields to be overwritten in
      the EntityType resource by the update. The fields specified in the
      update_mask are relative to the resource, not the full request. A field
      will be overwritten if it is in the mask. If the user does not provide a
      mask then only the non-empty fields present in the request will be
      overwritten. Set the update_mask to `*` to override all fields.
      Updatable fields: * `description` * `labels` *
      `monitoring_config.snapshot_analysis.disabled` *
      `monitoring_config.snapshot_analysis.monitoring_interval_days` *
      `monitoring_config.snapshot_analysis.staleness_days` *
      `monitoring_config.import_features_analysis.state` *
      `monitoring_config.import_features_analysis.anomaly_detection_baseline`
      * `monitoring_config.numerical_threshold_config.value` *
      `monitoring_config.categorical_threshold_config.value` *
      `offline_storage_ttl_days`
  """

  googleCloudAiplatformV1beta1EntityType = _messages.MessageField('GoogleCloudAiplatformV1beta1EntityType', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsFeaturestoresEntityTypesReadFeatureValuesRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesReadFeatureValuesRequest
  object.

  Fields:
    entityType: Required. The resource name of the EntityType for the entity
      being read. Value format: `projects/{project}/locations/{location}/featu
      restores/{featurestore}/entityTypes/{entityType}`. For example, for a
      machine learning model predicting user clicks on a website, an
      EntityType ID could be `user`.
    googleCloudAiplatformV1beta1ReadFeatureValuesRequest: A
      GoogleCloudAiplatformV1beta1ReadFeatureValuesRequest resource to be
      passed as the request body.
  """

  entityType = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1ReadFeatureValuesRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ReadFeatureValuesRequest', 2)


class AiplatformProjectsLocationsFeaturestoresEntityTypesSetIamPolicyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesSetIamPolicyRequest
  object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesStreamingReadFeatureValuesRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesStreamingReadFeatur
  eValuesRequest object.

  Fields:
    entityType: Required. The resource name of the entities' type. Value
      format: `projects/{project}/locations/{location}/featurestores/{features
      tore}/entityTypes/{entityType}`. For example, for a machine learning
      model predicting user clicks on a website, an EntityType ID could be
      `user`.
    googleCloudAiplatformV1beta1StreamingReadFeatureValuesRequest: A
      GoogleCloudAiplatformV1beta1StreamingReadFeatureValuesRequest resource
      to be passed as the request body.
  """

  entityType = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1StreamingReadFeatureValuesRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1StreamingReadFeatureValuesRequest', 2)


class AiplatformProjectsLocationsFeaturestoresEntityTypesTestIamPermissionsRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesTestIamPermissionsRequest
  object.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  permissions = _messages.StringField(1, repeated=True)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesWriteFeatureValuesRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesWriteFeatureValuesRequest
  object.

  Fields:
    entityType: Required. The resource name of the EntityType for the entities
      being written. Value format:
      `projects/{project}/locations/{location}/featurestores/
      {featurestore}/entityTypes/{entityType}`. For example, for a machine
      learning model predicting user clicks on a website, an EntityType ID
      could be `user`.
    googleCloudAiplatformV1beta1WriteFeatureValuesRequest: A
      GoogleCloudAiplatformV1beta1WriteFeatureValuesRequest resource to be
      passed as the request body.
  """

  entityType = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1WriteFeatureValuesRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1WriteFeatureValuesRequest', 2)


class AiplatformProjectsLocationsFeaturestoresGetIamPolicyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresGetIamPolicyRequest object.

  Fields:
    googleIamV1GetIamPolicyRequest: A GoogleIamV1GetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1GetIamPolicyRequest = _messages.MessageField('GoogleIamV1GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeaturestoresGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresGetRequest object.

  Fields:
    name: Required. The name of the Featurestore resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresListRequest object.

  Fields:
    filter: Lists the featurestores that match the filter expression. The
      following fields are supported: * `create_time`: Supports `=`, `!=`,
      `<`, `>`, `<=`, and `>=` comparisons. Values must be in RFC 3339 format.
      * `update_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=`
      comparisons. Values must be in RFC 3339 format. *
      `online_serving_config.fixed_node_count`: Supports `=`, `!=`, `<`, `>`,
      `<=`, and `>=` comparisons. * `labels`: Supports key-value equality and
      key presence. Examples: * `create_time > "2020-01-01" OR update_time >
      "2020-01-01"` Featurestores created or updated after 2020-01-01. *
      `labels.env = "prod"` Featurestores with label "env" set to "prod".
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending. Supported Fields: *
      `create_time` * `update_time` * `online_serving_config.fixed_node_count`
    pageSize: The maximum number of Featurestores to return. The service may
      return fewer than this value. If unspecified, at most 100 Featurestores
      will be returned. The maximum value is 100; any value greater than 100
      will be coerced to 100.
    pageToken: A page token, received from a previous
      FeaturestoreService.ListFeaturestores call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      FeaturestoreService.ListFeaturestores must match the call that provided
      the page token.
    parent: Required. The resource name of the Location to list Featurestores.
      Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsFeaturestoresOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsFeaturestoresOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsFeaturestoresPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1Featurestore: A
      GoogleCloudAiplatformV1beta1Featurestore resource to be passed as the
      request body.
    name: Output only. Name of the Featurestore. Format:
      `projects/{project}/locations/{location}/featurestores/{featurestore}`
    updateMask: Field mask is used to specify the fields to be overwritten in
      the Featurestore resource by the update. The fields specified in the
      update_mask are relative to the resource, not the full request. A field
      will be overwritten if it is in the mask. If the user does not provide a
      mask then only the non-empty fields present in the request will be
      overwritten. Set the update_mask to `*` to override all fields.
      Updatable fields: * `labels` * `online_serving_config.fixed_node_count`
      * `online_serving_config.scaling` * `online_storage_ttl_days`
  """

  googleCloudAiplatformV1beta1Featurestore = _messages.MessageField('GoogleCloudAiplatformV1beta1Featurestore', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsFeaturestoresSearchFeaturesRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresSearchFeaturesRequest object.

  Fields:
    location: Required. The resource name of the Location to search Features.
      Format: `projects/{project}/locations/{location}`
    pageSize: The maximum number of Features to return. The service may return
      fewer than this value. If unspecified, at most 100 Features will be
      returned. The maximum value is 100; any value greater than 100 will be
      coerced to 100.
    pageToken: A page token, received from a previous
      FeaturestoreService.SearchFeatures call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      FeaturestoreService.SearchFeatures, except `page_size`, must match the
      call that provided the page token.
    query: Query string that is a conjunction of field-restricted queries
      and/or field-restricted filters. Field-restricted queries and filters
      can be combined using `AND` to form a conjunction. A field query is in
      the form FIELD:QUERY. This implicitly checks if QUERY exists as a
      substring within Feature's FIELD. The QUERY and the FIELD are converted
      to a sequence of words (i.e. tokens) for comparison. This is done by: *
      Removing leading/trailing whitespace and tokenizing the search value.
      Characters that are not one of alphanumeric `[a-zA-Z0-9]`, underscore
      `_`, or asterisk `*` are treated as delimiters for tokens. `*` is
      treated as a wildcard that matches characters within a token. * Ignoring
      case. * Prepending an asterisk to the first and appending an asterisk to
      the last token in QUERY. A QUERY must be either a singular token or a
      phrase. A phrase is one or multiple words enclosed in double quotation
      marks ("). With phrases, the order of the words is important. Words in
      the phrase must be matching in order and consecutively. Supported FIELDs
      for field-restricted queries: * `feature_id` * `description` *
      `entity_type_id` Examples: * `feature_id: foo` --> Matches a Feature
      with ID containing the substring `foo` (eg. `foo`, `foofeature`,
      `barfoo`). * `feature_id: foo*feature` --> Matches a Feature with ID
      containing the substring `foo*feature` (eg. `foobarfeature`). *
      `feature_id: foo AND description: bar` --> Matches a Feature with ID
      containing the substring `foo` and description containing the substring
      `bar`. Besides field queries, the following exact-match filters are
      supported. The exact-match filters do not support wildcards. Unlike
      field-restricted queries, exact-match filters are case-sensitive. *
      `feature_id`: Supports = comparisons. * `description`: Supports =
      comparisons. Multi-token filters should be enclosed in quotes. *
      `entity_type_id`: Supports = comparisons. * `value_type`: Supports = and
      != comparisons. * `labels`: Supports key-value equality as well as key
      presence. * `featurestore_id`: Supports = comparisons. Examples: *
      `description = "foo bar"` --> Any Feature with description exactly equal
      to `foo bar` * `value_type = DOUBLE` --> Features whose type is DOUBLE.
      * `labels.active = yes AND labels.env = prod` --> Features having both
      (active: yes) and (env: prod) labels. * `labels.env: *` --> Any Feature
      which has a label with `env` as the key.
  """

  location = _messages.StringField(1, required=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  query = _messages.StringField(4)


class AiplatformProjectsLocationsFeaturestoresSetIamPolicyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsFeaturestoresTestIamPermissionsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresTestIamPermissionsRequest
  object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHyperparameterTuningJobsCancelRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1CancelHyperparameterTuningJobRequest: A
      GoogleCloudAiplatformV1beta1CancelHyperparameterTuningJobRequest
      resource to be passed as the request body.
    name: Required. The name of the HyperparameterTuningJob to cancel. Format:
      `projects/{project}/locations/{location}/hyperparameterTuningJobs/{hyper
      parameter_tuning_job}`
  """

  googleCloudAiplatformV1beta1CancelHyperparameterTuningJobRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1CancelHyperparameterTuningJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHyperparameterTuningJobsCreateRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1HyperparameterTuningJob: A
      GoogleCloudAiplatformV1beta1HyperparameterTuningJob resource to be
      passed as the request body.
    parent: Required. The resource name of the Location to create the
      HyperparameterTuningJob in. Format:
      `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1HyperparameterTuningJob = _messages.MessageField('GoogleCloudAiplatformV1beta1HyperparameterTuningJob', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHyperparameterTuningJobsDeleteRequest
  object.

  Fields:
    name: Required. The name of the HyperparameterTuningJob resource to be
      deleted. Format: `projects/{project}/locations/{location}/hyperparameter
      TuningJobs/{hyperparameter_tuning_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHyperparameterTuningJobsGetRequest object.

  Fields:
    name: Required. The name of the HyperparameterTuningJob resource. Format:
      `projects/{project}/locations/{location}/hyperparameterTuningJobs/{hyper
      parameter_tuning_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHyperparameterTuningJobsListRequest object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports `=`, `!=` comparisons, and `:` wildcard. * `state` supports
      `=`, `!=` comparisons. * `create_time` supports `=`, `!=`,`<`, `<=`,`>`,
      `>=` comparisons. `create_time` must be in RFC 3339 format. * `labels`
      supports general map functions that is: `labels.key=value` - key:value
      equality `labels.key:* - key existence Some examples of using the filter
      are: * `state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"` *
      `state!="JOB_STATE_FAILED" OR display_name="my_job"` * `NOT
      display_name="my_job"` * `create_time>"2021-05-18T00:00:00Z"` *
      `labels.keyA=valueA` * `labels.keyB:*`
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListHyperparameterTuningJobsResponse.next_page_token of the previous
      JobService.ListHyperparameterTuningJobs call.
    parent: Required. The resource name of the Location to list the
      HyperparameterTuningJobs from. Format:
      `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsHyperparameterTuningJobsOperationsCancelRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsHyperparameterTuningJobsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsOperationsDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsHyperparameterTuningJobsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsOperationsGetRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsHyperparameterTuningJobsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsHyperparameterTuningJobsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsHyperparameterTuningJobsOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsHyperparameterTuningJobsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsIndexEndpointsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1IndexEndpoint: A
      GoogleCloudAiplatformV1beta1IndexEndpoint resource to be passed as the
      request body.
    parent: Required. The resource name of the Location to create the
      IndexEndpoint in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1IndexEndpoint = _messages.MessageField('GoogleCloudAiplatformV1beta1IndexEndpoint', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsIndexEndpointsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsDeleteRequest object.

  Fields:
    name: Required. The name of the IndexEndpoint resource to be deleted.
      Format: `projects/{project}/locations/{location}/indexEndpoints/{index_e
      ndpoint}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsIndexEndpointsDeployIndexRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsDeployIndexRequest object.

  Fields:
    googleCloudAiplatformV1beta1DeployIndexRequest: A
      GoogleCloudAiplatformV1beta1DeployIndexRequest resource to be passed as
      the request body.
    indexEndpoint: Required. The name of the IndexEndpoint resource into which
      to deploy an Index. Format: `projects/{project}/locations/{location}/ind
      exEndpoints/{index_endpoint}`
  """

  googleCloudAiplatformV1beta1DeployIndexRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployIndexRequest', 1)
  indexEndpoint = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsIndexEndpointsFindNeighborsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsFindNeighborsRequest object.

  Fields:
    googleCloudAiplatformV1beta1FindNeighborsRequest: A
      GoogleCloudAiplatformV1beta1FindNeighborsRequest resource to be passed
      as the request body.
    indexEndpoint: Required. The name of the index endpoint. Format:
      `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}
      `
  """

  googleCloudAiplatformV1beta1FindNeighborsRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1FindNeighborsRequest', 1)
  indexEndpoint = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsIndexEndpointsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsGetRequest object.

  Fields:
    name: Required. The name of the IndexEndpoint resource. Format:
      `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}
      `
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsIndexEndpointsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsListRequest object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      For field names both snake_case and camelCase are supported. *
      `index_endpoint` supports = and !=. `index_endpoint` represents the
      IndexEndpoint ID, ie. the last segment of the IndexEndpoint's
      resourcename. * `display_name` supports =, != and regex() (uses
      [re2](https://github.com/google/re2/wiki/Syntax) syntax) * `labels`
      supports general map functions that is: `labels.key=value` - key:value
      equality `labels.key:* or labels:key - key existence A key including a
      space must be quoted. `labels."a key"`. Some examples: *
      `index_endpoint="1"` * `display_name="myDisplayName"` *
      `regex(display_name, "^A") -> The display name starts with an A. *
      `labels.myKey="myValue"`
    pageSize: Optional. The standard list page size.
    pageToken: Optional. The standard list page token. Typically obtained via
      ListIndexEndpointsResponse.next_page_token of the previous
      IndexEndpointService.ListIndexEndpoints call.
    parent: Required. The resource name of the Location from which to list the
      IndexEndpoints. Format: `projects/{project}/locations/{location}`
    readMask: Optional. Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsIndexEndpointsMutateDeployedIndexRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsMutateDeployedIndexRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1DeployedIndex: A
      GoogleCloudAiplatformV1beta1DeployedIndex resource to be passed as the
      request body.
    indexEndpoint: Required. The name of the IndexEndpoint resource into which
      to deploy an Index. Format: `projects/{project}/locations/{location}/ind
      exEndpoints/{index_endpoint}`
  """

  googleCloudAiplatformV1beta1DeployedIndex = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployedIndex', 1)
  indexEndpoint = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsIndexEndpointsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsIndexEndpointsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsIndexEndpointsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsIndexEndpointsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsIndexEndpointsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsIndexEndpointsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1IndexEndpoint: A
      GoogleCloudAiplatformV1beta1IndexEndpoint resource to be passed as the
      request body.
    name: Output only. The resource name of the IndexEndpoint.
    updateMask: Required. The update mask applies to the resource. See
      google.protobuf.FieldMask.
  """

  googleCloudAiplatformV1beta1IndexEndpoint = _messages.MessageField('GoogleCloudAiplatformV1beta1IndexEndpoint', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsIndexEndpointsReadIndexDatapointsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsReadIndexDatapointsRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1ReadIndexDatapointsRequest: A
      GoogleCloudAiplatformV1beta1ReadIndexDatapointsRequest resource to be
      passed as the request body.
    indexEndpoint: Required. The name of the index endpoint. Format:
      `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}
      `
  """

  googleCloudAiplatformV1beta1ReadIndexDatapointsRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ReadIndexDatapointsRequest', 1)
  indexEndpoint = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsIndexEndpointsUndeployIndexRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexEndpointsUndeployIndexRequest object.

  Fields:
    googleCloudAiplatformV1beta1UndeployIndexRequest: A
      GoogleCloudAiplatformV1beta1UndeployIndexRequest resource to be passed
      as the request body.
    indexEndpoint: Required. The name of the IndexEndpoint resource from which
      to undeploy an Index. Format: `projects/{project}/locations/{location}/i
      ndexEndpoints/{index_endpoint}`
  """

  googleCloudAiplatformV1beta1UndeployIndexRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1UndeployIndexRequest', 1)
  indexEndpoint = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsIndexesCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexesCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1Index: A GoogleCloudAiplatformV1beta1Index
      resource to be passed as the request body.
    parent: Required. The resource name of the Location to create the Index
      in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1Index = _messages.MessageField('GoogleCloudAiplatformV1beta1Index', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsIndexesDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexesDeleteRequest object.

  Fields:
    name: Required. The name of the Index resource to be deleted. Format:
      `projects/{project}/locations/{location}/indexes/{index}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsIndexesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexesGetRequest object.

  Fields:
    name: Required. The name of the Index resource. Format:
      `projects/{project}/locations/{location}/indexes/{index}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsIndexesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexesListRequest object.

  Fields:
    filter: The standard list filter.
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListIndexesResponse.next_page_token of the previous
      IndexService.ListIndexes call.
    parent: Required. The resource name of the Location from which to list the
      Indexes. Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsIndexesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexesOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsIndexesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexesOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsIndexesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexesOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsIndexesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexesOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsIndexesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexesOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsIndexesPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexesPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1Index: A GoogleCloudAiplatformV1beta1Index
      resource to be passed as the request body.
    name: Output only. The resource name of the Index.
    updateMask: The update mask applies to the resource. For the `FieldMask`
      definition, see google.protobuf.FieldMask.
  """

  googleCloudAiplatformV1beta1Index = _messages.MessageField('GoogleCloudAiplatformV1beta1Index', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsIndexesRemoveDatapointsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexesRemoveDatapointsRequest object.

  Fields:
    googleCloudAiplatformV1beta1RemoveDatapointsRequest: A
      GoogleCloudAiplatformV1beta1RemoveDatapointsRequest resource to be
      passed as the request body.
    index: Required. The name of the Index resource to be updated. Format:
      `projects/{project}/locations/{location}/indexes/{index}`
  """

  googleCloudAiplatformV1beta1RemoveDatapointsRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1RemoveDatapointsRequest', 1)
  index = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsIndexesUpsertDatapointsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsIndexesUpsertDatapointsRequest object.

  Fields:
    googleCloudAiplatformV1beta1UpsertDatapointsRequest: A
      GoogleCloudAiplatformV1beta1UpsertDatapointsRequest resource to be
      passed as the request body.
    index: Required. The name of the Index resource to be updated. Format:
      `projects/{project}/locations/{location}/indexes/{index}`
  """

  googleCloudAiplatformV1beta1UpsertDatapointsRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1UpsertDatapointsRequest', 1)
  index = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsMetadataStoresArtifactsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresArtifactsCreateRequest
  object.

  Fields:
    artifactId: The {artifact} portion of the resource name with the format: `
      projects/{project}/locations/{location}/metadataStores/{metadatastore}/a
      rtifacts/{artifact}` If not provided, the Artifact's ID will be a UUID
      generated by the service. Must be 4-128 characters in length. Valid
      characters are `/a-z-/`. Must be unique across all Artifacts in the
      parent MetadataStore. (Otherwise the request will fail with
      ALREADY_EXISTS, or PERMISSION_DENIED if the caller can't view the
      preexisting Artifact.)
    googleCloudAiplatformV1beta1Artifact: A
      GoogleCloudAiplatformV1beta1Artifact resource to be passed as the
      request body.
    parent: Required. The resource name of the MetadataStore where the
      Artifact should be created. Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  artifactId = _messages.StringField(1)
  googleCloudAiplatformV1beta1Artifact = _messages.MessageField('GoogleCloudAiplatformV1beta1Artifact', 2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsMetadataStoresArtifactsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresArtifactsDeleteRequest
  object.

  Fields:
    etag: Optional. The etag of the Artifact to delete. If this is provided,
      it must match the server's etag. Otherwise, the request will fail with a
      FAILED_PRECONDITION.
    name: Required. The resource name of the Artifact to delete. Format: `proj
      ects/{project}/locations/{location}/metadataStores/{metadatastore}/artif
      acts/{artifact}`
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsMetadataStoresArtifactsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresArtifactsGetRequest object.

  Fields:
    name: Required. The resource name of the Artifact to retrieve. Format: `pr
      ojects/{project}/locations/{location}/metadataStores/{metadatastore}/art
      ifacts/{artifact}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresArtifactsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresArtifactsListRequest object.

  Fields:
    filter: Filter specifying the boolean condition for the Artifacts to
      satisfy in order to be part of the result set. The syntax to define
      filter query is based on https://google.aip.dev/160. The supported set
      of filters include the following: * **Attribute filtering**: For
      example: `display_name = "test"`. Supported fields include: `name`,
      `display_name`, `uri`, `state`, `schema_title`, `create_time`, and
      `update_time`. Time fields, such as `create_time` and `update_time`,
      require values specified in RFC-3339 format. For example: `create_time =
      "2020-11-19T11:30:00-04:00"` * **Metadata field**: To filter on metadata
      fields use traversal operation as follows: `metadata..`. For example:
      `metadata.field_1.number_value = 10.0` In case the field name contains
      special characters (such as colon), one can embed it inside double
      quote. For example: `metadata."field:1".number_value = 10.0` * **Context
      based filtering**: To filter Artifacts based on the contexts to which
      they belong, use the function operator with the full resource name
      `in_context()`. For example:
      `in_context("projects//locations//metadataStores//contexts/")` Each of
      the above supported filter types can be combined together using logical
      operators (`AND` & `OR`). Maximum nested expression depth allowed is 5.
      For example: `display_name = "test" AND metadata.field1.bool_value =
      true`.
    orderBy: How the list of messages is ordered. Specify the values to order
      by and an ordering operation. The default sorting order is ascending. To
      specify descending order for a field, users append a " desc" suffix; for
      example: "foo desc, bar". Subfields are specified with a `.` character,
      such as foo.bar. see https://google.aip.dev/132#ordering for more
      details.
    pageSize: The maximum number of Artifacts to return. The service may
      return fewer. Must be in range 1-1000, inclusive. Defaults to 100.
    pageToken: A page token, received from a previous
      MetadataService.ListArtifacts call. Provide this to retrieve the
      subsequent page. When paginating, all other provided parameters must
      match the call that provided the page token. (Otherwise the request will
      fail with INVALID_ARGUMENT error.)
    parent: Required. The MetadataStore whose Artifacts should be listed.
      Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AiplatformProjectsLocationsMetadataStoresArtifactsOperationsCancelRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsMetadataStoresArtifactsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresArtifactsOperationsDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsMetadataStoresArtifactsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresArtifactsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresArtifactsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresArtifactsOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsMetadataStoresArtifactsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsMetadataStoresArtifactsOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsMetadataStoresArtifactsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsMetadataStoresArtifactsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresArtifactsPatchRequest object.

  Fields:
    allowMissing: If set to true, and the Artifact is not found, a new
      Artifact is created.
    googleCloudAiplatformV1beta1Artifact: A
      GoogleCloudAiplatformV1beta1Artifact resource to be passed as the
      request body.
    name: Output only. The resource name of the Artifact.
    updateMask: Optional. A FieldMask indicating which fields should be
      updated.
  """

  allowMissing = _messages.BooleanField(1)
  googleCloudAiplatformV1beta1Artifact = _messages.MessageField('GoogleCloudAiplatformV1beta1Artifact', 2)
  name = _messages.StringField(3, required=True)
  updateMask = _messages.StringField(4)


class AiplatformProjectsLocationsMetadataStoresArtifactsPurgeRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresArtifactsPurgeRequest object.

  Fields:
    googleCloudAiplatformV1beta1PurgeArtifactsRequest: A
      GoogleCloudAiplatformV1beta1PurgeArtifactsRequest resource to be passed
      as the request body.
    parent: Required. The metadata store to purge Artifacts from. Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  googleCloudAiplatformV1beta1PurgeArtifactsRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1PurgeArtifactsRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsMetadataStoresArtifactsQueryArtifactLineageSubgraphRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresArtifactsQueryArtifactLineage
  SubgraphRequest object.

  Fields:
    artifact: Required. The resource name of the Artifact whose Lineage needs
      to be retrieved as a LineageSubgraph. Format: `projects/{project}/locati
      ons/{location}/metadataStores/{metadatastore}/artifacts/{artifact}` The
      request may error with FAILED_PRECONDITION if the number of Artifacts,
      the number of Executions, or the number of Events that would be returned
      for the Context exceeds 1000.
    filter: Filter specifying the boolean condition for the Artifacts to
      satisfy in order to be part of the Lineage Subgraph. The syntax to
      define filter query is based on https://google.aip.dev/160. The
      supported set of filters include the following: * **Attribute
      filtering**: For example: `display_name = "test"` Supported fields
      include: `name`, `display_name`, `uri`, `state`, `schema_title`,
      `create_time`, and `update_time`. Time fields, such as `create_time` and
      `update_time`, require values specified in RFC-3339 format. For example:
      `create_time = "2020-11-19T11:30:00-04:00"` * **Metadata field**: To
      filter on metadata fields use traversal operation as follows:
      `metadata..`. For example: `metadata.field_1.number_value = 10.0` In
      case the field name contains special characters (such as colon), one can
      embed it inside double quote. For example:
      `metadata."field:1".number_value = 10.0` Each of the above supported
      filter types can be combined together using logical operators (`AND` &
      `OR`). Maximum nested expression depth allowed is 5. For example:
      `display_name = "test" AND metadata.field1.bool_value = true`.
    maxHops: Specifies the size of the lineage graph in terms of number of
      hops from the specified artifact. Negative Value: INVALID_ARGUMENT error
      is returned 0: Only input artifact is returned. No value: Transitive
      closure is performed to return the complete graph.
  """

  artifact = _messages.StringField(1, required=True)
  filter = _messages.StringField(2)
  maxHops = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class AiplatformProjectsLocationsMetadataStoresContextsAddContextArtifactsAndExecutionsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresContextsAddContextArtifactsAn
  dExecutionsRequest object.

  Fields:
    context: Required. The resource name of the Context that the Artifacts and
      Executions belong to. Format: `projects/{project}/locations/{location}/m
      etadataStores/{metadatastore}/contexts/{context}`
    googleCloudAiplatformV1beta1AddContextArtifactsAndExecutionsRequest: A
      GoogleCloudAiplatformV1beta1AddContextArtifactsAndExecutionsRequest
      resource to be passed as the request body.
  """

  context = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1AddContextArtifactsAndExecutionsRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1AddContextArtifactsAndExecutionsRequest', 2)


class AiplatformProjectsLocationsMetadataStoresContextsAddContextChildrenRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsMetadataStoresContextsAddContextChildrenRequest
  object.

  Fields:
    context: Required. The resource name of the parent Context. Format: `proje
      cts/{project}/locations/{location}/metadataStores/{metadatastore}/contex
      ts/{context}`
    googleCloudAiplatformV1beta1AddContextChildrenRequest: A
      GoogleCloudAiplatformV1beta1AddContextChildrenRequest resource to be
      passed as the request body.
  """

  context = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1AddContextChildrenRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1AddContextChildrenRequest', 2)


class AiplatformProjectsLocationsMetadataStoresContextsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresContextsCreateRequest object.

  Fields:
    contextId: The {context} portion of the resource name with the format: `pr
      ojects/{project}/locations/{location}/metadataStores/{metadatastore}/con
      texts/{context}`. If not provided, the Context's ID will be a UUID
      generated by the service. Must be 4-128 characters in length. Valid
      characters are `/a-z-/`. Must be unique across all Contexts in the
      parent MetadataStore. (Otherwise the request will fail with
      ALREADY_EXISTS, or PERMISSION_DENIED if the caller can't view the
      preexisting Context.)
    googleCloudAiplatformV1beta1Context: A GoogleCloudAiplatformV1beta1Context
      resource to be passed as the request body.
    parent: Required. The resource name of the MetadataStore where the Context
      should be created. Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  contextId = _messages.StringField(1)
  googleCloudAiplatformV1beta1Context = _messages.MessageField('GoogleCloudAiplatformV1beta1Context', 2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsMetadataStoresContextsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresContextsDeleteRequest object.

  Fields:
    etag: Optional. The etag of the Context to delete. If this is provided, it
      must match the server's etag. Otherwise, the request will fail with a
      FAILED_PRECONDITION.
    force: The force deletion semantics is still undefined. Users should not
      use this field.
    name: Required. The resource name of the Context to delete. Format: `proje
      cts/{project}/locations/{location}/metadataStores/{metadatastore}/contex
      ts/{context}`
  """

  etag = _messages.StringField(1)
  force = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsMetadataStoresContextsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresContextsGetRequest object.

  Fields:
    name: Required. The resource name of the Context to retrieve. Format: `pro
      jects/{project}/locations/{location}/metadataStores/{metadatastore}/cont
      exts/{context}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresContextsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresContextsListRequest object.

  Fields:
    filter: Filter specifying the boolean condition for the Contexts to
      satisfy in order to be part of the result set. The syntax to define
      filter query is based on https://google.aip.dev/160. Following are the
      supported set of filters: * **Attribute filtering**: For example:
      `display_name = "test"`. Supported fields include: `name`,
      `display_name`, `schema_title`, `create_time`, and `update_time`. Time
      fields, such as `create_time` and `update_time`, require values
      specified in RFC-3339 format. For example: `create_time =
      "2020-11-19T11:30:00-04:00"`. * **Metadata field**: To filter on
      metadata fields use traversal operation as follows: `metadata..`. For
      example: `metadata.field_1.number_value = 10.0`. In case the field name
      contains special characters (such as colon), one can embed it inside
      double quote. For example: `metadata."field:1".number_value = 10.0` *
      **Parent Child filtering**: To filter Contexts based on parent-child
      relationship use the HAS operator as follows: ``` parent_contexts:
      "projects//locations//metadataStores//contexts/" child_contexts:
      "projects//locations//metadataStores//contexts/" ``` Each of the above
      supported filters can be combined together using logical operators
      (`AND` & `OR`). Maximum nested expression depth allowed is 5. For
      example: `display_name = "test" AND metadata.field1.bool_value = true`.
    orderBy: How the list of messages is ordered. Specify the values to order
      by and an ordering operation. The default sorting order is ascending. To
      specify descending order for a field, users append a " desc" suffix; for
      example: "foo desc, bar". Subfields are specified with a `.` character,
      such as foo.bar. see https://google.aip.dev/132#ordering for more
      details.
    pageSize: The maximum number of Contexts to return. The service may return
      fewer. Must be in range 1-1000, inclusive. Defaults to 100.
    pageToken: A page token, received from a previous
      MetadataService.ListContexts call. Provide this to retrieve the
      subsequent page. When paginating, all other provided parameters must
      match the call that provided the page token. (Otherwise the request will
      fail with INVALID_ARGUMENT error.)
    parent: Required. The MetadataStore whose Contexts should be listed.
      Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AiplatformProjectsLocationsMetadataStoresContextsOperationsCancelRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsMetadataStoresContextsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresContextsOperationsDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsMetadataStoresContextsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresContextsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresContextsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresContextsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresContextsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsMetadataStoresContextsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresContextsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsMetadataStoresContextsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresContextsPatchRequest object.

  Fields:
    allowMissing: If set to true, and the Context is not found, a new Context
      is created.
    googleCloudAiplatformV1beta1Context: A GoogleCloudAiplatformV1beta1Context
      resource to be passed as the request body.
    name: Immutable. The resource name of the Context.
    updateMask: Optional. A FieldMask indicating which fields should be
      updated.
  """

  allowMissing = _messages.BooleanField(1)
  googleCloudAiplatformV1beta1Context = _messages.MessageField('GoogleCloudAiplatformV1beta1Context', 2)
  name = _messages.StringField(3, required=True)
  updateMask = _messages.StringField(4)


class AiplatformProjectsLocationsMetadataStoresContextsPurgeRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresContextsPurgeRequest object.

  Fields:
    googleCloudAiplatformV1beta1PurgeContextsRequest: A
      GoogleCloudAiplatformV1beta1PurgeContextsRequest resource to be passed
      as the request body.
    parent: Required. The metadata store to purge Contexts from. Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  googleCloudAiplatformV1beta1PurgeContextsRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1PurgeContextsRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsMetadataStoresContextsQueryContextLineageSubgraphRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresContextsQueryContextLineageSu
  bgraphRequest object.

  Fields:
    context: Required. The resource name of the Context whose Artifacts and
      Executions should be retrieved as a LineageSubgraph. Format: `projects/{
      project}/locations/{location}/metadataStores/{metadatastore}/contexts/{c
      ontext}` The request may error with FAILED_PRECONDITION if the number of
      Artifacts, the number of Executions, or the number of Events that would
      be returned for the Context exceeds 1000.
  """

  context = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresContextsRemoveContextChildrenRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresContextsRemoveContextChildren
  Request object.

  Fields:
    context: Required. The resource name of the parent Context. Format: `proje
      cts/{project}/locations/{location}/metadataStores/{metadatastore}/contex
      ts/{context}`
    googleCloudAiplatformV1beta1RemoveContextChildrenRequest: A
      GoogleCloudAiplatformV1beta1RemoveContextChildrenRequest resource to be
      passed as the request body.
  """

  context = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1RemoveContextChildrenRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1RemoveContextChildrenRequest', 2)


class AiplatformProjectsLocationsMetadataStoresCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1MetadataStore: A
      GoogleCloudAiplatformV1beta1MetadataStore resource to be passed as the
      request body.
    metadataStoreId: The {metadatastore} portion of the resource name with the
      format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
      If not provided, the MetadataStore's ID will be a UUID generated by the
      service. Must be 4-128 characters in length. Valid characters are
      `/a-z-/`. Must be unique across all MetadataStores in the parent
      Location. (Otherwise the request will fail with ALREADY_EXISTS, or
      PERMISSION_DENIED if the caller can't view the preexisting
      MetadataStore.)
    parent: Required. The resource name of the Location where the
      MetadataStore should be created. Format:
      `projects/{project}/locations/{location}/`
  """

  googleCloudAiplatformV1beta1MetadataStore = _messages.MessageField('GoogleCloudAiplatformV1beta1MetadataStore', 1)
  metadataStoreId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsMetadataStoresDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresDeleteRequest object.

  Fields:
    force: Deprecated: Field is no longer supported.
    name: Required. The resource name of the MetadataStore to delete. Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsMetadataStoresExecutionsAddExecutionEventsRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsMetadataStoresExecutionsAddExecutionEventsRequest
  object.

  Fields:
    execution: Required. The resource name of the Execution that the Events
      connect Artifacts with. Format: `projects/{project}/locations/{location}
      /metadataStores/{metadatastore}/executions/{execution}`
    googleCloudAiplatformV1beta1AddExecutionEventsRequest: A
      GoogleCloudAiplatformV1beta1AddExecutionEventsRequest resource to be
      passed as the request body.
  """

  execution = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1AddExecutionEventsRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1AddExecutionEventsRequest', 2)


class AiplatformProjectsLocationsMetadataStoresExecutionsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresExecutionsCreateRequest
  object.

  Fields:
    executionId: The {execution} portion of the resource name with the format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}/
      executions/{execution}` If not provided, the Execution's ID will be a
      UUID generated by the service. Must be 4-128 characters in length. Valid
      characters are `/a-z-/`. Must be unique across all Executions in the
      parent MetadataStore. (Otherwise the request will fail with
      ALREADY_EXISTS, or PERMISSION_DENIED if the caller can't view the
      preexisting Execution.)
    googleCloudAiplatformV1beta1Execution: A
      GoogleCloudAiplatformV1beta1Execution resource to be passed as the
      request body.
    parent: Required. The resource name of the MetadataStore where the
      Execution should be created. Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  executionId = _messages.StringField(1)
  googleCloudAiplatformV1beta1Execution = _messages.MessageField('GoogleCloudAiplatformV1beta1Execution', 2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsMetadataStoresExecutionsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresExecutionsDeleteRequest
  object.

  Fields:
    etag: Optional. The etag of the Execution to delete. If this is provided,
      it must match the server's etag. Otherwise, the request will fail with a
      FAILED_PRECONDITION.
    name: Required. The resource name of the Execution to delete. Format: `pro
      jects/{project}/locations/{location}/metadataStores/{metadatastore}/exec
      utions/{execution}`
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsMetadataStoresExecutionsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresExecutionsGetRequest object.

  Fields:
    name: Required. The resource name of the Execution to retrieve. Format: `p
      rojects/{project}/locations/{location}/metadataStores/{metadatastore}/ex
      ecutions/{execution}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresExecutionsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresExecutionsListRequest object.

  Fields:
    filter: Filter specifying the boolean condition for the Executions to
      satisfy in order to be part of the result set. The syntax to define
      filter query is based on https://google.aip.dev/160. Following are the
      supported set of filters: * **Attribute filtering**: For example:
      `display_name = "test"`. Supported fields include: `name`,
      `display_name`, `state`, `schema_title`, `create_time`, and
      `update_time`. Time fields, such as `create_time` and `update_time`,
      require values specified in RFC-3339 format. For example: `create_time =
      "2020-11-19T11:30:00-04:00"`. * **Metadata field**: To filter on
      metadata fields use traversal operation as follows: `metadata..` For
      example: `metadata.field_1.number_value = 10.0` In case the field name
      contains special characters (such as colon), one can embed it inside
      double quote. For example: `metadata."field:1".number_value = 10.0` *
      **Context based filtering**: To filter Executions based on the contexts
      to which they belong use the function operator with the full resource
      name: `in_context()`. For example:
      `in_context("projects//locations//metadataStores//contexts/")` Each of
      the above supported filters can be combined together using logical
      operators (`AND` & `OR`). Maximum nested expression depth allowed is 5.
      For example: `display_name = "test" AND metadata.field1.bool_value =
      true`.
    orderBy: How the list of messages is ordered. Specify the values to order
      by and an ordering operation. The default sorting order is ascending. To
      specify descending order for a field, users append a " desc" suffix; for
      example: "foo desc, bar". Subfields are specified with a `.` character,
      such as foo.bar. see https://google.aip.dev/132#ordering for more
      details.
    pageSize: The maximum number of Executions to return. The service may
      return fewer. Must be in range 1-1000, inclusive. Defaults to 100.
    pageToken: A page token, received from a previous
      MetadataService.ListExecutions call. Provide this to retrieve the
      subsequent page. When paginating, all other provided parameters must
      match the call that provided the page token. (Otherwise the request will
      fail with an INVALID_ARGUMENT error.)
    parent: Required. The MetadataStore whose Executions should be listed.
      Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AiplatformProjectsLocationsMetadataStoresExecutionsOperationsCancelRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsMetadataStoresExecutionsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresExecutionsOperationsDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsMetadataStoresExecutionsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresExecutionsOperationsGetRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsMetadataStoresExecutionsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresExecutionsOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsMetadataStoresExecutionsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsMetadataStoresExecutionsOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsMetadataStoresExecutionsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsMetadataStoresExecutionsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresExecutionsPatchRequest
  object.

  Fields:
    allowMissing: If set to true, and the Execution is not found, a new
      Execution is created.
    googleCloudAiplatformV1beta1Execution: A
      GoogleCloudAiplatformV1beta1Execution resource to be passed as the
      request body.
    name: Output only. The resource name of the Execution.
    updateMask: Optional. A FieldMask indicating which fields should be
      updated.
  """

  allowMissing = _messages.BooleanField(1)
  googleCloudAiplatformV1beta1Execution = _messages.MessageField('GoogleCloudAiplatformV1beta1Execution', 2)
  name = _messages.StringField(3, required=True)
  updateMask = _messages.StringField(4)


class AiplatformProjectsLocationsMetadataStoresExecutionsPurgeRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresExecutionsPurgeRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1PurgeExecutionsRequest: A
      GoogleCloudAiplatformV1beta1PurgeExecutionsRequest resource to be passed
      as the request body.
    parent: Required. The metadata store to purge Executions from. Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  googleCloudAiplatformV1beta1PurgeExecutionsRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1PurgeExecutionsRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsMetadataStoresExecutionsQueryExecutionInputsAndOutputsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresExecutionsQueryExecutionInput
  sAndOutputsRequest object.

  Fields:
    execution: Required. The resource name of the Execution whose input and
      output Artifacts should be retrieved as a LineageSubgraph. Format: `proj
      ects/{project}/locations/{location}/metadataStores/{metadatastore}/execu
      tions/{execution}`
  """

  execution = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresGetRequest object.

  Fields:
    name: Required. The resource name of the MetadataStore to retrieve.
      Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresListRequest object.

  Fields:
    pageSize: The maximum number of Metadata Stores to return. The service may
      return fewer. Must be in range 1-1000, inclusive. Defaults to 100.
    pageToken: A page token, received from a previous
      MetadataService.ListMetadataStores call. Provide this to retrieve the
      subsequent page. When paginating, all other provided parameters must
      match the call that provided the page token. (Otherwise the request will
      fail with INVALID_ARGUMENT error.)
    parent: Required. The Location whose MetadataStores should be listed.
      Format: `projects/{project}/locations/{location}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsMetadataStoresMetadataSchemasCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresMetadataSchemasCreateRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1MetadataSchema: A
      GoogleCloudAiplatformV1beta1MetadataSchema resource to be passed as the
      request body.
    metadataSchemaId: The {metadata_schema} portion of the resource name with
      the format: `projects/{project}/locations/{location}/metadataStores/{met
      adatastore}/metadataSchemas/{metadataschema}` If not provided, the
      MetadataStore's ID will be a UUID generated by the service. Must be
      4-128 characters in length. Valid characters are `/a-z-/`. Must be
      unique across all MetadataSchemas in the parent Location. (Otherwise the
      request will fail with ALREADY_EXISTS, or PERMISSION_DENIED if the
      caller can't view the preexisting MetadataSchema.)
    parent: Required. The resource name of the MetadataStore where the
      MetadataSchema should be created. Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  googleCloudAiplatformV1beta1MetadataSchema = _messages.MessageField('GoogleCloudAiplatformV1beta1MetadataSchema', 1)
  metadataSchemaId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsMetadataStoresMetadataSchemasGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresMetadataSchemasGetRequest
  object.

  Fields:
    name: Required. The resource name of the MetadataSchema to retrieve.
      Format: `projects/{project}/locations/{location}/metadataStores/{metadat
      astore}/metadataSchemas/{metadataschema}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresMetadataSchemasListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresMetadataSchemasListRequest
  object.

  Fields:
    filter: A query to filter available MetadataSchemas for matching results.
    pageSize: The maximum number of MetadataSchemas to return. The service may
      return fewer. Must be in range 1-1000, inclusive. Defaults to 100.
    pageToken: A page token, received from a previous
      MetadataService.ListMetadataSchemas call. Provide this to retrieve the
      next page. When paginating, all other provided parameters must match the
      call that provided the page token. (Otherwise the request will fail with
      INVALID_ARGUMENT error.)
    parent: Required. The MetadataStore whose MetadataSchemas should be
      listed. Format:
      `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class AiplatformProjectsLocationsMetadataStoresOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMetadataStoresOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsMetadataStoresOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMetadataStoresOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsMigratableResourcesBatchMigrateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesBatchMigrateRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1BatchMigrateResourcesRequest: A
      GoogleCloudAiplatformV1beta1BatchMigrateResourcesRequest resource to be
      passed as the request body.
    parent: Required. The location of the migrated resource will live in.
      Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1BatchMigrateResourcesRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchMigrateResourcesRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsMigratableResourcesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMigratableResourcesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMigratableResourcesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMigratableResourcesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsMigratableResourcesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsMigratableResourcesSearchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesSearchRequest object.

  Fields:
    googleCloudAiplatformV1beta1SearchMigratableResourcesRequest: A
      GoogleCloudAiplatformV1beta1SearchMigratableResourcesRequest resource to
      be passed as the request body.
    parent: Required. The location that the migratable resources should be
      searched from. It's the Vertex AI location that the resources can be
      migrated to, not the resources' original location. Format:
      `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1SearchMigratableResourcesRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1SearchMigratableResourcesRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsCreateRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1ModelDeploymentMonitoringJob: A
      GoogleCloudAiplatformV1beta1ModelDeploymentMonitoringJob resource to be
      passed as the request body.
    parent: Required. The parent of the ModelDeploymentMonitoringJob. Format:
      `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1ModelDeploymentMonitoringJob = _messages.MessageField('GoogleCloudAiplatformV1beta1ModelDeploymentMonitoringJob', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsDeleteRequest
  object.

  Fields:
    name: Required. The resource name of the model monitoring job to delete.
      Format: `projects/{project}/locations/{location}/modelDeploymentMonitori
      ngJobs/{model_deployment_monitoring_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsGetRequest
  object.

  Fields:
    name: Required. The resource name of the ModelDeploymentMonitoringJob.
      Format: `projects/{project}/locations/{location}/modelDeploymentMonitori
      ngJobs/{model_deployment_monitoring_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsListRequest
  object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports `=`, `!=` comparisons, and `:` wildcard. * `state` supports
      `=`, `!=` comparisons. * `create_time` supports `=`, `!=`,`<`, `<=`,`>`,
      `>=` comparisons. `create_time` must be in RFC 3339 format. * `labels`
      supports general map functions that is: `labels.key=value` - key:value
      equality `labels.key:* - key existence Some examples of using the filter
      are: * `state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"` *
      `state!="JOB_STATE_FAILED" OR display_name="my_job"` * `NOT
      display_name="my_job"` * `create_time>"2021-05-18T00:00:00Z"` *
      `labels.keyA=valueA` * `labels.keyB:*`
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: Required. The parent of the ModelDeploymentMonitoringJob. Format:
      `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsCanc
  elRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsDele
  teRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsGetRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsList
  Request object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsWait
  Request object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsPatchRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1ModelDeploymentMonitoringJob: A
      GoogleCloudAiplatformV1beta1ModelDeploymentMonitoringJob resource to be
      passed as the request body.
    name: Output only. Resource name of a ModelDeploymentMonitoringJob.
    updateMask: Required. The update mask is used to specify the fields to be
      overwritten in the ModelDeploymentMonitoringJob resource by the update.
      The fields specified in the update_mask are relative to the resource,
      not the full request. A field will be overwritten if it is in the mask.
      If the user does not provide a mask then only the non-empty fields
      present in the request will be overwritten. Set the update_mask to `*`
      to override all fields. For the objective config, the user can either
      provide the update mask for
      model_deployment_monitoring_objective_configs or any combination of its
      nested fields, such as: model_deployment_monitoring_objective_configs.ob
      jective_config.training_dataset. Updatable fields: * `display_name` *
      `model_deployment_monitoring_schedule_config` *
      `model_monitoring_alert_config` * `logging_sampling_strategy` * `labels`
      * `log_ttl` * `enable_monitoring_pipeline_logs` . and *
      `model_deployment_monitoring_objective_configs` . or * `model_deployment
      _monitoring_objective_configs.objective_config.training_dataset` * `mode
      l_deployment_monitoring_objective_configs.objective_config.training_pred
      iction_skew_detection_config` * `model_deployment_monitoring_objective_c
      onfigs.objective_config.prediction_drift_detection_config`
  """

  googleCloudAiplatformV1beta1ModelDeploymentMonitoringJob = _messages.MessageField('GoogleCloudAiplatformV1beta1ModelDeploymentMonitoringJob', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsPauseRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsPauseRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1PauseModelDeploymentMonitoringJobRequest: A
      GoogleCloudAiplatformV1beta1PauseModelDeploymentMonitoringJobRequest
      resource to be passed as the request body.
    name: Required. The resource name of the ModelDeploymentMonitoringJob to
      pause. Format: `projects/{project}/locations/{location}/modelDeploymentM
      onitoringJobs/{model_deployment_monitoring_job}`
  """

  googleCloudAiplatformV1beta1PauseModelDeploymentMonitoringJobRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1PauseModelDeploymentMonitoringJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsResumeRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsResumeRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1ResumeModelDeploymentMonitoringJobRequest: A
      GoogleCloudAiplatformV1beta1ResumeModelDeploymentMonitoringJobRequest
      resource to be passed as the request body.
    name: Required. The resource name of the ModelDeploymentMonitoringJob to
      resume. Format: `projects/{project}/locations/{location}/modelDeployment
      MonitoringJobs/{model_deployment_monitoring_job}`
  """

  googleCloudAiplatformV1beta1ResumeModelDeploymentMonitoringJobRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ResumeModelDeploymentMonitoringJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsSearchModelDeploymentMonitoringStatsAnomaliesRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsSearchModelDep
  loymentMonitoringStatsAnomaliesRequest object.

  Fields:
    googleCloudAiplatformV1beta1SearchModelDeploymentMonitoringStatsAnomaliesR
      equest: A GoogleCloudAiplatformV1beta1SearchModelDeploymentMonitoringSta
      tsAnomaliesRequest resource to be passed as the request body.
    modelDeploymentMonitoringJob: Required. ModelDeploymentMonitoring Job
      resource name. Format: `projects/{project}/locations/{location}/modelDep
      loymentMonitoringJobs/{model_deployment_monitoring_job}`
  """

  googleCloudAiplatformV1beta1SearchModelDeploymentMonitoringStatsAnomaliesRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1SearchModelDeploymentMonitoringStatsAnomaliesRequest', 1)
  modelDeploymentMonitoringJob = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelMonitorsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelMonitorsCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1ModelMonitor: A
      GoogleCloudAiplatformV1beta1ModelMonitor resource to be passed as the
      request body.
    modelMonitorId: Optional. The ID to use for the Model Monitor, which will
      become the final component of the model monitor resource name. The
      maximum length is 63 characters, and valid characters are
      `/^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$/`.
    parent: Required. The resource name of the Location to create the
      ModelMonitor in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1ModelMonitor = _messages.MessageField('GoogleCloudAiplatformV1beta1ModelMonitor', 1)
  modelMonitorId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsModelMonitorsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelMonitorsDeleteRequest object.

  Fields:
    force: Optional. Force delete the model monitor with schedules.
    name: Required. The name of the ModelMonitor resource to be deleted.
      Format:
      `projects/{project}/locations/{location}/modelMonitords/{model_monitor}`
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelMonitorsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelMonitorsGetRequest object.

  Fields:
    name: Required. The name of the ModelMonitor resource. Format:
      `projects/{project}/locations/{location}/modelMonitors/{model_monitor}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelMonitorsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelMonitorsListRequest object.

  Fields:
    filter: The standard list filter. More detail in
      [AIP-160](https://google.aip.dev/160).
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: Required. The resource name of the Location to list the
      ModelMonitors from. Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsModelMonitorsModelMonitoringJobsCreateRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsModelMonitorsModelMonitoringJobsCreateRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1ModelMonitoringJob: A
      GoogleCloudAiplatformV1beta1ModelMonitoringJob resource to be passed as
      the request body.
    modelMonitoringJobId: Optional. The ID to use for the Model Monitoring
      Job, which will become the final component of the model monitoring job
      resource name. The maximum length is 63 characters, and valid characters
      are `/^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$/`.
    parent: Required. The parent of the ModelMonitoringJob. Format:
      `projects/{project}/locations/{location}/modelMoniitors/{model_monitor}`
  """

  googleCloudAiplatformV1beta1ModelMonitoringJob = _messages.MessageField('GoogleCloudAiplatformV1beta1ModelMonitoringJob', 1)
  modelMonitoringJobId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsModelMonitorsModelMonitoringJobsDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsModelMonitorsModelMonitoringJobsDeleteRequest
  object.

  Fields:
    name: Required. The resource name of the model monitoring job to delete.
      Format: `projects/{project}/locations/{location}/modelMonitors/{model_mo
      nitor}/modelMonitoringJobs/{model_monitoring_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelMonitorsModelMonitoringJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelMonitorsModelMonitoringJobsGetRequest
  object.

  Fields:
    name: Required. The resource name of the ModelMonitoringJob. Format: `proj
      ects/{project}/locations/{location}/modelMonitors/{model_monitor}/modelM
      onitoringJobs/{model_monitoring_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelMonitorsModelMonitoringJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelMonitorsModelMonitoringJobsListRequest
  object.

  Fields:
    filter: The standard list filter. More detail in
      [AIP-160](https://google.aip.dev/160).
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: Required. The parent of the ModelMonitoringJob. Format:
      `projects/{project}/locations/{location}/modelMonitors/{model_monitor}`
    readMask: Mask specifying which fields to read
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsModelMonitorsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelMonitorsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelMonitorsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelMonitorsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelMonitorsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelMonitorsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelMonitorsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelMonitorsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsModelMonitorsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelMonitorsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsModelMonitorsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelMonitorsPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1ModelMonitor: A
      GoogleCloudAiplatformV1beta1ModelMonitor resource to be passed as the
      request body.
    name: Immutable. Resource name of the ModelMonitor. Format:
      `projects/{project}/locations/{location}/modelMonitors/{model_monitor}`.
    updateMask: Required. Mask specifying which fields to update.
  """

  googleCloudAiplatformV1beta1ModelMonitor = _messages.MessageField('GoogleCloudAiplatformV1beta1ModelMonitor', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsModelMonitorsSearchModelMonitoringAlertsRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsModelMonitorsSearchModelMonitoringAlertsRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1SearchModelMonitoringAlertsRequest: A
      GoogleCloudAiplatformV1beta1SearchModelMonitoringAlertsRequest resource
      to be passed as the request body.
    modelMonitor: Required. ModelMonitor resource name. Format:
      `projects/{project}/locations/{location}/modelMonitors/{model_monitor}`
  """

  googleCloudAiplatformV1beta1SearchModelMonitoringAlertsRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1SearchModelMonitoringAlertsRequest', 1)
  modelMonitor = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelMonitorsSearchModelMonitoringStatsRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsModelMonitorsSearchModelMonitoringStatsRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1SearchModelMonitoringStatsRequest: A
      GoogleCloudAiplatformV1beta1SearchModelMonitoringStatsRequest resource
      to be passed as the request body.
    modelMonitor: Required. ModelMonitor resource name. Format:
      `projects/{project}/locations/{location}/modelMonitors/{model_monitor}`
  """

  googleCloudAiplatformV1beta1SearchModelMonitoringStatsRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1SearchModelMonitoringStatsRequest', 1)
  modelMonitor = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelsCopyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsCopyRequest object.

  Fields:
    googleCloudAiplatformV1beta1CopyModelRequest: A
      GoogleCloudAiplatformV1beta1CopyModelRequest resource to be passed as
      the request body.
    parent: Required. The resource name of the Location into which to copy the
      Model. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1CopyModelRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1CopyModelRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsDeleteRequest object.

  Fields:
    name: Required. The name of the Model resource to be deleted. Format:
      `projects/{project}/locations/{location}/models/{model}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsDeleteVersionRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsDeleteVersionRequest object.

  Fields:
    name: Required. The name of the model version to be deleted, with a
      version ID explicitly included. Example:
      `projects/{project}/locations/{location}/models/{model}@1234`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsEvaluationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsGetRequest object.

  Fields:
    name: Required. The name of the ModelEvaluation resource. Format: `project
      s/{project}/locations/{location}/models/{model}/evaluations/{evaluation}
      `
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsEvaluationsImportRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsImportRequest object.

  Fields:
    googleCloudAiplatformV1beta1ImportModelEvaluationRequest: A
      GoogleCloudAiplatformV1beta1ImportModelEvaluationRequest resource to be
      passed as the request body.
    parent: Required. The name of the parent model resource. Format:
      `projects/{project}/locations/{location}/models/{model}`
  """

  googleCloudAiplatformV1beta1ImportModelEvaluationRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ImportModelEvaluationRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelsEvaluationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsListRequest object.

  Fields:
    filter: The standard list filter.
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListModelEvaluationsResponse.next_page_token of the previous
      ModelService.ListModelEvaluations call.
    parent: Required. The resource name of the Model to list the
      ModelEvaluations from. Format:
      `projects/{project}/locations/{location}/models/{model}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsModelsEvaluationsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsEvaluationsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsEvaluationsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsEvaluationsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsModelsEvaluationsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsModelsEvaluationsSlicesBatchImportRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsSlicesBatchImportRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1BatchImportEvaluatedAnnotationsRequest: A
      GoogleCloudAiplatformV1beta1BatchImportEvaluatedAnnotationsRequest
      resource to be passed as the request body.
    parent: Required. The name of the parent ModelEvaluationSlice resource.
      Format: `projects/{project}/locations/{location}/models/{model}/evaluati
      ons/{evaluation}/slices/{slice}`
  """

  googleCloudAiplatformV1beta1BatchImportEvaluatedAnnotationsRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchImportEvaluatedAnnotationsRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelsEvaluationsSlicesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsSlicesGetRequest object.

  Fields:
    name: Required. The name of the ModelEvaluationSlice resource. Format: `pr
      ojects/{project}/locations/{location}/models/{model}/evaluations/{evalua
      tion}/slices/{slice}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsEvaluationsSlicesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsSlicesListRequest object.

  Fields:
    filter: The standard list filter. * `slice.dimension` - for =.
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListModelEvaluationSlicesResponse.next_page_token of the previous
      ModelService.ListModelEvaluationSlices call.
    parent: Required. The resource name of the ModelEvaluation to list the
      ModelEvaluationSlices from. Format: `projects/{project}/locations/{locat
      ion}/models/{model}/evaluations/{evaluation}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsModelsExportRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsExportRequest object.

  Fields:
    googleCloudAiplatformV1beta1ExportModelRequest: A
      GoogleCloudAiplatformV1beta1ExportModelRequest resource to be passed as
      the request body.
    name: Required. The resource name of the Model to export. The resource
      name may contain version id or version alias to specify the version, if
      no version is specified, the default version will be exported.
  """

  googleCloudAiplatformV1beta1ExportModelRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ExportModelRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelsGetIamPolicyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsGetRequest object.

  Fields:
    name: Required. The name of the Model resource. Format:
      `projects/{project}/locations/{location}/models/{model}` In order to
      retrieve a specific version of the model, also provide the version ID or
      version alias. Example:
      `projects/{project}/locations/{location}/models/{model}@2` or
      `projects/{project}/locations/{location}/models/{model}@golden` If no
      version ID or alias is specified, the "default" version will be
      returned. The "default" version alias is created for the first version
      of the model, and can be moved to other versions later on. There will be
      exactly one default version.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsListCheckpointsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsListCheckpointsRequest object.

  Fields:
    name: Required. The name of the model version to list checkpoints for.
      `projects/{project}/locations/{location}/models/{model}@{version}`
      Example: `projects/{project}/locations/{location}/models/{model}@2` or
      `projects/{project}/locations/{location}/models/{model}@golden` If no
      version ID or alias is specified, the latest version will be used.
    pageSize: Optional. The standard list page size.
    pageToken: Optional. The standard list page token. Typically obtained via
      next_page_token of the previous ListModelVersionCheckpoints call.
  """

  name = _messages.StringField(1, required=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class AiplatformProjectsLocationsModelsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsListRequest object.

  Fields:
    filter: An expression for filtering the results of the request. For field
      names both snake_case and camelCase are supported. * `model` supports =
      and !=. `model` represents the Model ID, i.e. the last segment of the
      Model's resource name. * `display_name` supports = and != * `labels`
      supports general map functions that is: * `labels.key=value` - key:value
      equality * `labels.key:* or labels:key - key existence * A key including
      a space must be quoted. `labels."a key"`. * `base_model_name` only
      supports = Some examples: * `model=1234` * `displayName="myDisplayName"`
      * `labels.myKey="myValue"` * `baseModelName="text-bison"`
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListModelsResponse.next_page_token of the previous
      ModelService.ListModels call.
    parent: Required. The resource name of the Location to list the Models
      from. Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsModelsListVersionsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsListVersionsRequest object.

  Fields:
    filter: An expression for filtering the results of the request. For field
      names both snake_case and camelCase are supported. * `labels` supports
      general map functions that is: * `labels.key=value` - key:value equality
      * `labels.key:* or labels:key - key existence * A key including a space
      must be quoted. `labels."a key"`. Some examples: *
      `labels.myKey="myValue"`
    name: Required. The name of the model to list versions for.
    orderBy: A comma-separated list of fields to order by, sorted in ascending
      order. Use "desc" after a field name for descending. Supported fields: *
      `create_time` * `update_time` Example: `update_time asc, create_time
      desc`.
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      next_page_token of the previous ListModelVersions call.
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  orderBy = _messages.StringField(3)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsModelsMergeVersionAliasesRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsMergeVersionAliasesRequest object.

  Fields:
    googleCloudAiplatformV1beta1MergeVersionAliasesRequest: A
      GoogleCloudAiplatformV1beta1MergeVersionAliasesRequest resource to be
      passed as the request body.
    name: Required. The name of the model version to merge aliases, with a
      version ID explicitly included. Example:
      `projects/{project}/locations/{location}/models/{model}@1234`
  """

  googleCloudAiplatformV1beta1MergeVersionAliasesRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1MergeVersionAliasesRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsModelsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsModelsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1Model: A GoogleCloudAiplatformV1beta1Model
      resource to be passed as the request body.
    name: The resource name of the Model.
    updateMask: Required. The update mask applies to the resource. For the
      `FieldMask` definition, see google.protobuf.FieldMask.
  """

  googleCloudAiplatformV1beta1Model = _messages.MessageField('GoogleCloudAiplatformV1beta1Model', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsModelsSetIamPolicyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelsTestIamPermissionsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsTestIamPermissionsRequest object.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  permissions = _messages.StringField(1, repeated=True)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelsUpdateExplanationDatasetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsUpdateExplanationDatasetRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1UpdateExplanationDatasetRequest: A
      GoogleCloudAiplatformV1beta1UpdateExplanationDatasetRequest resource to
      be passed as the request body.
    model: Required. The resource name of the Model to update. Format:
      `projects/{project}/locations/{location}/models/{model}`
  """

  googleCloudAiplatformV1beta1UpdateExplanationDatasetRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1UpdateExplanationDatasetRequest', 1)
  model = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelsUploadRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsUploadRequest object.

  Fields:
    googleCloudAiplatformV1beta1UploadModelRequest: A
      GoogleCloudAiplatformV1beta1UploadModelRequest resource to be passed as
      the request body.
    parent: Required. The resource name of the Location into which to upload
      the Model. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1UploadModelRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1UploadModelRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsNasJobsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNasJobsCancelRequest object.

  Fields:
    googleCloudAiplatformV1beta1CancelNasJobRequest: A
      GoogleCloudAiplatformV1beta1CancelNasJobRequest resource to be passed as
      the request body.
    name: Required. The name of the NasJob to cancel. Format:
      `projects/{project}/locations/{location}/nasJobs/{nas_job}`
  """

  googleCloudAiplatformV1beta1CancelNasJobRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1CancelNasJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsNasJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNasJobsCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1NasJob: A GoogleCloudAiplatformV1beta1NasJob
      resource to be passed as the request body.
    parent: Required. The resource name of the Location to create the NasJob
      in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1NasJob = _messages.MessageField('GoogleCloudAiplatformV1beta1NasJob', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsNasJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNasJobsDeleteRequest object.

  Fields:
    name: Required. The name of the NasJob resource to be deleted. Format:
      `projects/{project}/locations/{location}/nasJobs/{nas_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsNasJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNasJobsGetRequest object.

  Fields:
    name: Required. The name of the NasJob resource. Format:
      `projects/{project}/locations/{location}/nasJobs/{nas_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsNasJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNasJobsListRequest object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports `=`, `!=` comparisons, and `:` wildcard. * `state` supports
      `=`, `!=` comparisons. * `create_time` supports `=`, `!=`,`<`, `<=`,`>`,
      `>=` comparisons. `create_time` must be in RFC 3339 format. * `labels`
      supports general map functions that is: `labels.key=value` - key:value
      equality `labels.key:* - key existence Some examples of using the filter
      are: * `state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"` *
      `state!="JOB_STATE_FAILED" OR display_name="my_job"` * `NOT
      display_name="my_job"` * `create_time>"2021-05-18T00:00:00Z"` *
      `labels.keyA=valueA` * `labels.keyB:*`
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListNasJobsResponse.next_page_token of the previous
      JobService.ListNasJobs call.
    parent: Required. The resource name of the Location to list the NasJobs
      from. Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsNasJobsNasTrialDetailsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNasJobsNasTrialDetailsGetRequest object.

  Fields:
    name: Required. The name of the NasTrialDetail resource. Format: `projects
      /{project}/locations/{location}/nasJobs/{nas_job}/nasTrialDetails/{nas_t
      rial_detail}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsNasJobsNasTrialDetailsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNasJobsNasTrialDetailsListRequest object.

  Fields:
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListNasTrialDetailsResponse.next_page_token of the previous
      JobService.ListNasTrialDetails call.
    parent: Required. The name of the NasJob resource. Format:
      `projects/{project}/locations/{location}/nasJobs/{nas_job}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsNotebookExecutionJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookExecutionJobsCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1NotebookExecutionJob: A
      GoogleCloudAiplatformV1beta1NotebookExecutionJob resource to be passed
      as the request body.
    notebookExecutionJobId: Optional. User specified ID for the
      NotebookExecutionJob.
    parent: Required. The resource name of the Location to create the
      NotebookExecutionJob. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1NotebookExecutionJob = _messages.MessageField('GoogleCloudAiplatformV1beta1NotebookExecutionJob', 1)
  notebookExecutionJobId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsNotebookExecutionJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookExecutionJobsDeleteRequest object.

  Fields:
    name: Required. The name of the NotebookExecutionJob resource to be
      deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsNotebookExecutionJobsGenerateAccessTokenRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsNotebookExecutionJobsGenerateAccessTokenRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1GenerateAccessTokenRequest: A
      GoogleCloudAiplatformV1beta1GenerateAccessTokenRequest resource to be
      passed as the request body.
    name: Required. The name of the resource requesting the OAuth2 token.
      Format: `projects/{project}/locations/{location}/notebookRuntimes/{noteb
      ook_runtime}` `projects/{project}/locations/{location}/notebookExecution
      Jobs/{notebook_execution_job}`
  """

  googleCloudAiplatformV1beta1GenerateAccessTokenRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1GenerateAccessTokenRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsNotebookExecutionJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookExecutionJobsGetRequest object.

  Enums:
    ViewValueValuesEnum: Optional. The NotebookExecutionJob view. Defaults to
      BASIC.

  Fields:
    name: Required. The name of the NotebookExecutionJob resource.
    view: Optional. The NotebookExecutionJob view. Defaults to BASIC.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Optional. The NotebookExecutionJob view. Defaults to BASIC.

    Values:
      NOTEBOOK_EXECUTION_JOB_VIEW_UNSPECIFIED: When unspecified, the API
        defaults to the BASIC view.
      NOTEBOOK_EXECUTION_JOB_VIEW_BASIC: Includes all fields except for direct
        notebook inputs.
      NOTEBOOK_EXECUTION_JOB_VIEW_FULL: Includes all fields.
    """
    NOTEBOOK_EXECUTION_JOB_VIEW_UNSPECIFIED = 0
    NOTEBOOK_EXECUTION_JOB_VIEW_BASIC = 1
    NOTEBOOK_EXECUTION_JOB_VIEW_FULL = 2

  name = _messages.StringField(1, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 2)


class AiplatformProjectsLocationsNotebookExecutionJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookExecutionJobsListRequest object.

  Enums:
    ViewValueValuesEnum: Optional. The NotebookExecutionJob view. Defaults to
      BASIC.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      For field names both snake_case and camelCase are supported. *
      `notebookExecutionJob` supports = and !=. `notebookExecutionJob`
      represents the NotebookExecutionJob ID. * `displayName` supports = and
      != and regex. * `schedule` supports = and != and regex. Some examples: *
      `notebookExecutionJob="123"` * `notebookExecutionJob="my-execution-job"`
      * `displayName="myDisplayName"` and `displayName=~"myDisplayNameRegex"`
    orderBy: Optional. A comma-separated list of fields to order by, sorted in
      ascending order. Use "desc" after a field name for descending. Supported
      fields: * `display_name` * `create_time` * `update_time` Example:
      `display_name, create_time desc`.
    pageSize: Optional. The standard list page size.
    pageToken: Optional. The standard list page token. Typically obtained via
      ListNotebookExecutionJobsResponse.next_page_token of the previous
      NotebookService.ListNotebookExecutionJobs call.
    parent: Required. The resource name of the Location from which to list the
      NotebookExecutionJobs. Format: `projects/{project}/locations/{location}`
    view: Optional. The NotebookExecutionJob view. Defaults to BASIC.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Optional. The NotebookExecutionJob view. Defaults to BASIC.

    Values:
      NOTEBOOK_EXECUTION_JOB_VIEW_UNSPECIFIED: When unspecified, the API
        defaults to the BASIC view.
      NOTEBOOK_EXECUTION_JOB_VIEW_BASIC: Includes all fields except for direct
        notebook inputs.
      NOTEBOOK_EXECUTION_JOB_VIEW_FULL: Includes all fields.
    """
    NOTEBOOK_EXECUTION_JOB_VIEW_UNSPECIFIED = 0
    NOTEBOOK_EXECUTION_JOB_VIEW_BASIC = 1
    NOTEBOOK_EXECUTION_JOB_VIEW_FULL = 2

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 6)


class AiplatformProjectsLocationsNotebookExecutionJobsOperationsCancelRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsNotebookExecutionJobsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsNotebookExecutionJobsOperationsDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsNotebookExecutionJobsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsNotebookExecutionJobsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookExecutionJobsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsNotebookExecutionJobsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookExecutionJobsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsNotebookExecutionJobsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookExecutionJobsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsNotebookExecutionJobsReportEventRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookExecutionJobsReportEventRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1ReportExecutionEventRequest: A
      GoogleCloudAiplatformV1beta1ReportExecutionEventRequest resource to be
      passed as the request body.
    name: Required. The name of the NotebookExecutionJob resource. Format: `pr
      ojects/{project}/locations/{location}/notebookExecutionJobs/{notebook_ex
      ecution_jobs}`
  """

  googleCloudAiplatformV1beta1ReportExecutionEventRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ReportExecutionEventRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsNotebookRuntimeTemplatesCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookRuntimeTemplatesCreateRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1NotebookRuntimeTemplate: A
      GoogleCloudAiplatformV1beta1NotebookRuntimeTemplate resource to be
      passed as the request body.
    notebookRuntimeTemplateId: Optional. User specified ID for the notebook
      runtime template.
    parent: Required. The resource name of the Location to create the
      NotebookRuntimeTemplate. Format:
      `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1NotebookRuntimeTemplate = _messages.MessageField('GoogleCloudAiplatformV1beta1NotebookRuntimeTemplate', 1)
  notebookRuntimeTemplateId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsNotebookRuntimeTemplatesDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookRuntimeTemplatesDeleteRequest
  object.

  Fields:
    name: Required. The name of the NotebookRuntimeTemplate resource to be
      deleted. Format: `projects/{project}/locations/{location}/notebookRuntim
      eTemplates/{notebook_runtime_template}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsNotebookRuntimeTemplatesGetIamPolicyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookRuntimeTemplatesGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsNotebookRuntimeTemplatesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookRuntimeTemplatesGetRequest object.

  Fields:
    name: Required. The name of the NotebookRuntimeTemplate resource. Format:
      `projects/{project}/locations/{location}/notebookRuntimeTemplates/{noteb
      ook_runtime_template}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsNotebookRuntimeTemplatesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookRuntimeTemplatesListRequest object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      For field names both snake_case and camelCase are supported. *
      `notebookRuntimeTemplate` supports = and !=. `notebookRuntimeTemplate`
      represents the NotebookRuntimeTemplate ID, i.e. the last segment of the
      NotebookRuntimeTemplate's resource name. * `display_name` supports = and
      != * `labels` supports general map functions that is: *
      `labels.key=value` - key:value equality * `labels.key:* or labels:key -
      key existence * A key including a space must be quoted. `labels."a
      key"`. * `notebookRuntimeType` supports = and !=. notebookRuntimeType
      enum: [USER_DEFINED, ONE_CLICK]. * `machineType` supports = and !=. *
      `acceleratorType` supports = and !=. Some examples: *
      `notebookRuntimeTemplate=notebookRuntimeTemplate123` *
      `displayName="myDisplayName"` * `labels.myKey="myValue"` *
      `notebookRuntimeType=USER_DEFINED` * `machineType=e2-standard-4` *
      `acceleratorType=NVIDIA_TESLA_T4`
    orderBy: Optional. A comma-separated list of fields to order by, sorted in
      ascending order. Use "desc" after a field name for descending. Supported
      fields: * `display_name` * `create_time` * `update_time` Example:
      `display_name, create_time desc`.
    pageSize: Optional. The standard list page size.
    pageToken: Optional. The standard list page token. Typically obtained via
      ListNotebookRuntimeTemplatesResponse.next_page_token of the previous
      NotebookService.ListNotebookRuntimeTemplates call.
    parent: Required. The resource name of the Location from which to list the
      NotebookRuntimeTemplates. Format:
      `projects/{project}/locations/{location}`
    readMask: Optional. Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsNotebookRuntimeTemplatesOperationsCancelRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsNotebookRuntimeTemplatesOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsNotebookRuntimeTemplatesOperationsDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsNotebookRuntimeTemplatesOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsNotebookRuntimeTemplatesOperationsGetRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsNotebookRuntimeTemplatesOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsNotebookRuntimeTemplatesOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsNotebookRuntimeTemplatesOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsNotebookRuntimeTemplatesOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsNotebookRuntimeTemplatesOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsNotebookRuntimeTemplatesPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookRuntimeTemplatesPatchRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1NotebookRuntimeTemplate: A
      GoogleCloudAiplatformV1beta1NotebookRuntimeTemplate resource to be
      passed as the request body.
    name: The resource name of the NotebookRuntimeTemplate.
    updateMask: Required. The update mask applies to the resource. For the
      `FieldMask` definition, see google.protobuf.FieldMask. Input format:
      `{paths: "${updated_filed}"}` Updatable fields: *
      `encryption_spec.kms_key_name`
  """

  googleCloudAiplatformV1beta1NotebookRuntimeTemplate = _messages.MessageField('GoogleCloudAiplatformV1beta1NotebookRuntimeTemplate', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsNotebookRuntimeTemplatesSetIamPolicyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookRuntimeTemplatesSetIamPolicyRequest
  object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsNotebookRuntimeTemplatesTestIamPermissionsRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsNotebookRuntimeTemplatesTestIamPermissionsRequest
  object.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  permissions = _messages.StringField(1, repeated=True)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsNotebookRuntimesAssignRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookRuntimesAssignRequest object.

  Fields:
    googleCloudAiplatformV1beta1AssignNotebookRuntimeRequest: A
      GoogleCloudAiplatformV1beta1AssignNotebookRuntimeRequest resource to be
      passed as the request body.
    parent: Required. The resource name of the Location to get the
      NotebookRuntime assignment. Format:
      `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1AssignNotebookRuntimeRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1AssignNotebookRuntimeRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsNotebookRuntimesDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookRuntimesDeleteRequest object.

  Fields:
    name: Required. The name of the NotebookRuntime resource to be deleted.
      Instead of checking whether the name is in valid NotebookRuntime
      resource name format, directly throw NotFound exception if there is no
      such NotebookRuntime in spanner.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsNotebookRuntimesGenerateAccessTokenRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookRuntimesGenerateAccessTokenRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1GenerateAccessTokenRequest: A
      GoogleCloudAiplatformV1beta1GenerateAccessTokenRequest resource to be
      passed as the request body.
    name: Required. The name of the resource requesting the OAuth2 token.
      Format: `projects/{project}/locations/{location}/notebookRuntimes/{noteb
      ook_runtime}` `projects/{project}/locations/{location}/notebookExecution
      Jobs/{notebook_execution_job}`
  """

  googleCloudAiplatformV1beta1GenerateAccessTokenRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1GenerateAccessTokenRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsNotebookRuntimesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookRuntimesGetRequest object.

  Fields:
    name: Required. The name of the NotebookRuntime resource. Instead of
      checking whether the name is in valid NotebookRuntime resource name
      format, directly throw NotFound exception if there is no such
      NotebookRuntime in spanner.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsNotebookRuntimesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookRuntimesListRequest object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      For field names both snake_case and camelCase are supported. *
      `notebookRuntime` supports = and !=. `notebookRuntime` represents the
      NotebookRuntime ID, i.e. the last segment of the NotebookRuntime's
      resource name. * `displayName` supports = and != and regex. *
      `notebookRuntimeTemplate` supports = and !=. `notebookRuntimeTemplate`
      represents the NotebookRuntimeTemplate ID, i.e. the last segment of the
      NotebookRuntimeTemplate's resource name. * `healthState` supports = and
      !=. healthState enum: [HEALTHY, UNHEALTHY, HEALTH_STATE_UNSPECIFIED]. *
      `runtimeState` supports = and !=. runtimeState enum:
      [RUNTIME_STATE_UNSPECIFIED, RUNNING, BEING_STARTED, BEING_STOPPED,
      STOPPED, BEING_UPGRADED, ERROR, INVALID]. * `runtimeUser` supports = and
      !=. * API version is UI only: `uiState` supports = and !=. uiState enum:
      [UI_RESOURCE_STATE_UNSPECIFIED, UI_RESOURCE_STATE_BEING_CREATED,
      UI_RESOURCE_STATE_ACTIVE, UI_RESOURCE_STATE_BEING_DELETED,
      UI_RESOURCE_STATE_CREATION_FAILED]. * `notebookRuntimeType` supports =
      and !=. notebookRuntimeType enum: [USER_DEFINED, ONE_CLICK]. *
      `machineType` supports = and !=. * `acceleratorType` supports = and !=.
      Some examples: * `notebookRuntime="notebookRuntime123"` *
      `displayName="myDisplayName"` and `displayName=~"myDisplayNameRegex"` *
      `notebookRuntimeTemplate="notebookRuntimeTemplate321"` *
      `healthState=HEALTHY` * `runtimeState=RUNNING` *
      `runtimeUser="test@google.com"` *
      `uiState=UI_RESOURCE_STATE_BEING_DELETED` *
      `notebookRuntimeType=USER_DEFINED` * `machineType=e2-standard-4` *
      `acceleratorType=NVIDIA_TESLA_T4`
    orderBy: Optional. A comma-separated list of fields to order by, sorted in
      ascending order. Use "desc" after a field name for descending. Supported
      fields: * `display_name` * `create_time` * `update_time` Example:
      `display_name, create_time desc`.
    pageSize: Optional. The standard list page size.
    pageToken: Optional. The standard list page token. Typically obtained via
      ListNotebookRuntimesResponse.next_page_token of the previous
      NotebookService.ListNotebookRuntimes call.
    parent: Required. The resource name of the Location from which to list the
      NotebookRuntimes. Format: `projects/{project}/locations/{location}`
    readMask: Optional. Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsNotebookRuntimesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookRuntimesOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsNotebookRuntimesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookRuntimesOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsNotebookRuntimesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookRuntimesOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsNotebookRuntimesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookRuntimesOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsNotebookRuntimesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookRuntimesOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsNotebookRuntimesReportEventRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookRuntimesReportEventRequest object.

  Fields:
    googleCloudAiplatformV1beta1ReportRuntimeEventRequest: A
      GoogleCloudAiplatformV1beta1ReportRuntimeEventRequest resource to be
      passed as the request body.
    name: Required. The name of the NotebookRuntime resource. Format: `project
      s/{project}/locations/{location}/notebookRuntimes/{notebook_runtime}`
  """

  googleCloudAiplatformV1beta1ReportRuntimeEventRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ReportRuntimeEventRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsNotebookRuntimesStartRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookRuntimesStartRequest object.

  Fields:
    googleCloudAiplatformV1beta1StartNotebookRuntimeRequest: A
      GoogleCloudAiplatformV1beta1StartNotebookRuntimeRequest resource to be
      passed as the request body.
    name: Required. The name of the NotebookRuntime resource to be started.
      Instead of checking whether the name is in valid NotebookRuntime
      resource name format, directly throw NotFound exception if there is no
      such NotebookRuntime in spanner.
  """

  googleCloudAiplatformV1beta1StartNotebookRuntimeRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1StartNotebookRuntimeRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsNotebookRuntimesStopRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookRuntimesStopRequest object.

  Fields:
    googleCloudAiplatformV1beta1StopNotebookRuntimeRequest: A
      GoogleCloudAiplatformV1beta1StopNotebookRuntimeRequest resource to be
      passed as the request body.
    name: Required. The name of the NotebookRuntime resource to be stopped.
      Instead of checking whether the name is in valid NotebookRuntime
      resource name format, directly throw NotFound exception if there is no
      such NotebookRuntime in spanner.
  """

  googleCloudAiplatformV1beta1StopNotebookRuntimeRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1StopNotebookRuntimeRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsNotebookRuntimesUpgradeRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsNotebookRuntimesUpgradeRequest object.

  Fields:
    googleCloudAiplatformV1beta1UpgradeNotebookRuntimeRequest: A
      GoogleCloudAiplatformV1beta1UpgradeNotebookRuntimeRequest resource to be
      passed as the request body.
    name: Required. The name of the NotebookRuntime resource to be upgrade.
      Instead of checking whether the name is in valid NotebookRuntime
      resource name format, directly throw NotFound exception if there is no
      such NotebookRuntime in spanner.
  """

  googleCloudAiplatformV1beta1UpgradeNotebookRuntimeRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1UpgradeNotebookRuntimeRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsPersistentResourcesCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPersistentResourcesCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1PersistentResource: A
      GoogleCloudAiplatformV1beta1PersistentResource resource to be passed as
      the request body.
    parent: Required. The resource name of the Location to create the
      PersistentResource in. Format: `projects/{project}/locations/{location}`
    persistentResourceId: Required. The ID to use for the PersistentResource,
      which become the final component of the PersistentResource's resource
      name. The maximum length is 63 characters, and valid characters are
      `/^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$/`.
  """

  googleCloudAiplatformV1beta1PersistentResource = _messages.MessageField('GoogleCloudAiplatformV1beta1PersistentResource', 1)
  parent = _messages.StringField(2, required=True)
  persistentResourceId = _messages.StringField(3)


class AiplatformProjectsLocationsPersistentResourcesDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPersistentResourcesDeleteRequest object.

  Fields:
    name: Required. The name of the PersistentResource to be deleted. Format:
      `projects/{project}/locations/{location}/persistentResources/{persistent
      _resource}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsPersistentResourcesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPersistentResourcesGetRequest object.

  Fields:
    name: Required. The name of the PersistentResource resource. Format: `proj
      ects/{project_id_or_number}/locations/{location_id}/persistentResources/
      {persistent_resource_id}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsPersistentResourcesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPersistentResourcesListRequest object.

  Fields:
    pageSize: Optional. The standard list page size.
    pageToken: Optional. The standard list page token. Typically obtained via
      ListPersistentResourcesResponse.next_page_token of the previous
      PersistentResourceService.ListPersistentResource call.
    parent: Required. The resource name of the Location to list the
      PersistentResources from. Format:
      `projects/{project}/locations/{location}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsPersistentResourcesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPersistentResourcesOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsPersistentResourcesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPersistentResourcesOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsPersistentResourcesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPersistentResourcesOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsPersistentResourcesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPersistentResourcesOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsPersistentResourcesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPersistentResourcesOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsPersistentResourcesPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPersistentResourcesPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1PersistentResource: A
      GoogleCloudAiplatformV1beta1PersistentResource resource to be passed as
      the request body.
    name: Immutable. Resource name of a PersistentResource.
    updateMask: Required. Specify the fields to be overwritten in the
      PersistentResource by the update method.
  """

  googleCloudAiplatformV1beta1PersistentResource = _messages.MessageField('GoogleCloudAiplatformV1beta1PersistentResource', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsPersistentResourcesRebootRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPersistentResourcesRebootRequest object.

  Fields:
    googleCloudAiplatformV1beta1RebootPersistentResourceRequest: A
      GoogleCloudAiplatformV1beta1RebootPersistentResourceRequest resource to
      be passed as the request body.
    name: Required. The name of the PersistentResource resource. Format: `proj
      ects/{project_id_or_number}/locations/{location_id}/persistentResources/
      {persistent_resource_id}`
  """

  googleCloudAiplatformV1beta1RebootPersistentResourceRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1RebootPersistentResourceRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsPipelineJobsBatchCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsBatchCancelRequest object.

  Fields:
    googleCloudAiplatformV1beta1BatchCancelPipelineJobsRequest: A
      GoogleCloudAiplatformV1beta1BatchCancelPipelineJobsRequest resource to
      be passed as the request body.
    parent: Required. The name of the PipelineJobs' parent resource. Format:
      `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1BatchCancelPipelineJobsRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchCancelPipelineJobsRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsPipelineJobsBatchDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsBatchDeleteRequest object.

  Fields:
    googleCloudAiplatformV1beta1BatchDeletePipelineJobsRequest: A
      GoogleCloudAiplatformV1beta1BatchDeletePipelineJobsRequest resource to
      be passed as the request body.
    parent: Required. The name of the PipelineJobs' parent resource. Format:
      `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1BatchDeletePipelineJobsRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchDeletePipelineJobsRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsPipelineJobsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsCancelRequest object.

  Fields:
    googleCloudAiplatformV1beta1CancelPipelineJobRequest: A
      GoogleCloudAiplatformV1beta1CancelPipelineJobRequest resource to be
      passed as the request body.
    name: Required. The name of the PipelineJob to cancel. Format:
      `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`
  """

  googleCloudAiplatformV1beta1CancelPipelineJobRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1CancelPipelineJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsPipelineJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1PipelineJob: A
      GoogleCloudAiplatformV1beta1PipelineJob resource to be passed as the
      request body.
    parent: Required. The resource name of the Location to create the
      PipelineJob in. Format: `projects/{project}/locations/{location}`
    pipelineJobId: The ID to use for the PipelineJob, which will become the
      final component of the PipelineJob name. If not provided, an ID will be
      automatically generated. This value should be less than 128 characters,
      and valid characters are `/a-z-/`.
  """

  googleCloudAiplatformV1beta1PipelineJob = _messages.MessageField('GoogleCloudAiplatformV1beta1PipelineJob', 1)
  parent = _messages.StringField(2, required=True)
  pipelineJobId = _messages.StringField(3)


class AiplatformProjectsLocationsPipelineJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsDeleteRequest object.

  Fields:
    name: Required. The name of the PipelineJob resource to be deleted.
      Format:
      `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsPipelineJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsGetRequest object.

  Fields:
    name: Required. The name of the PipelineJob resource. Format:
      `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsPipelineJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsListRequest object.

  Fields:
    filter: Lists the PipelineJobs that match the filter expression. The
      following fields are supported: * `pipeline_name`: Supports `=` and `!=`
      comparisons. * `display_name`: Supports `=`, `!=` comparisons, and `:`
      wildcard. * `pipeline_job_user_id`: Supports `=`, `!=` comparisons, and
      `:` wildcard. for example, can check if pipeline's display_name contains
      *step* by doing display_name:\"*step*\" * `state`: Supports `=` and `!=`
      comparisons. * `create_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and
      `>=` comparisons. Values must be in RFC 3339 format. * `update_time`:
      Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons. Values must be
      in RFC 3339 format. * `end_time`: Supports `=`, `!=`, `<`, `>`, `<=`,
      and `>=` comparisons. Values must be in RFC 3339 format. * `labels`:
      Supports key-value equality and key presence. * `template_uri`: Supports
      `=`, `!=` comparisons, and `:` wildcard. * `template_metadata.version`:
      Supports `=`, `!=` comparisons, and `:` wildcard. Filter expressions can
      be combined together using logical operators (`AND` & `OR`). For
      example: `pipeline_name="test" AND create_time>"2020-05-18T13:30:00Z"`.
      The syntax to define filter expression is based on
      https://google.aip.dev/160. Examples: *
      `create_time>"2021-05-18T00:00:00Z" OR
      update_time>"2020-05-18T00:00:00Z"` PipelineJobs created or updated
      after 2020-05-18 00:00:00 UTC. * `labels.env = "prod"` PipelineJobs with
      label "env" set to "prod".
    orderBy: A comma-separated list of fields to order by. The default sort
      order is in ascending order. Use "desc" after a field name for
      descending. You can have multiple order_by fields provided e.g.
      "create_time desc, end_time", "end_time, start_time, update_time" For
      example, using "create_time desc, end_time" will order results by create
      time in descending order, and if there are multiple jobs having the same
      create time, order them by the end time in ascending order. if order_by
      is not specified, it will order by default order is create time in
      descending order. Supported fields: * `create_time` * `update_time` *
      `end_time` * `start_time`
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListPipelineJobsResponse.next_page_token of the previous
      PipelineService.ListPipelineJobs call.
    parent: Required. The resource name of the Location to list the
      PipelineJobs from. Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsPipelineJobsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsPipelineJobsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsPipelineJobsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsPipelineJobsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsPipelineJobsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsPublishersModelsComputeTokensRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPublishersModelsComputeTokensRequest
  object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to get lists of
      tokens and token ids.
    googleCloudAiplatformV1beta1ComputeTokensRequest: A
      GoogleCloudAiplatformV1beta1ComputeTokensRequest resource to be passed
      as the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1ComputeTokensRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ComputeTokensRequest', 2)


class AiplatformProjectsLocationsPublishersModelsCountTokensRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPublishersModelsCountTokensRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to perform token
      counting. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1CountTokensRequest: A
      GoogleCloudAiplatformV1beta1CountTokensRequest resource to be passed as
      the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1CountTokensRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1CountTokensRequest', 2)


class AiplatformProjectsLocationsPublishersModelsFetchPredictOperationRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsPublishersModelsFetchPredictOperationRequest
  object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}` or `proje
      cts/{project}/locations/{location}/publishers/{publisher}/models/{model}
      `
    googleCloudAiplatformV1beta1FetchPredictOperationRequest: A
      GoogleCloudAiplatformV1beta1FetchPredictOperationRequest resource to be
      passed as the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1FetchPredictOperationRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1FetchPredictOperationRequest', 2)


class AiplatformProjectsLocationsPublishersModelsGenerateContentRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPublishersModelsGenerateContentRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1GenerateContentRequest: A
      GoogleCloudAiplatformV1beta1GenerateContentRequest resource to be passed
      as the request body.
    model: Required. The fully qualified name of the publisher model or tuned
      model endpoint to use. Publisher model format:
      `projects/{project}/locations/{location}/publishers/*/models/*` Tuned
      model endpoint format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
  """

  googleCloudAiplatformV1beta1GenerateContentRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1GenerateContentRequest', 1)
  model = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsPublishersModelsGetIamPolicyRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPublishersModelsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsPublishersModelsPredictLongRunningRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPublishersModelsPredictLongRunningRequest
  object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}` or `proje
      cts/{project}/locations/{location}/publishers/{publisher}/models/{model}
      `
    googleCloudAiplatformV1beta1PredictLongRunningRequest: A
      GoogleCloudAiplatformV1beta1PredictLongRunningRequest resource to be
      passed as the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1PredictLongRunningRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1PredictLongRunningRequest', 2)


class AiplatformProjectsLocationsPublishersModelsPredictRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPublishersModelsPredictRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1PredictRequest: A
      GoogleCloudAiplatformV1beta1PredictRequest resource to be passed as the
      request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1PredictRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1PredictRequest', 2)


class AiplatformProjectsLocationsPublishersModelsRawPredictRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPublishersModelsRawPredictRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1RawPredictRequest: A
      GoogleCloudAiplatformV1beta1RawPredictRequest resource to be passed as
      the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1RawPredictRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1RawPredictRequest', 2)


class AiplatformProjectsLocationsPublishersModelsServerStreamingPredictRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsPublishersModelsServerStreamingPredictRequest
  object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1StreamingPredictRequest: A
      GoogleCloudAiplatformV1beta1StreamingPredictRequest resource to be
      passed as the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1StreamingPredictRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1StreamingPredictRequest', 2)


class AiplatformProjectsLocationsPublishersModelsStreamGenerateContentRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsPublishersModelsStreamGenerateContentRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1GenerateContentRequest: A
      GoogleCloudAiplatformV1beta1GenerateContentRequest resource to be passed
      as the request body.
    model: Required. The fully qualified name of the publisher model or tuned
      model endpoint to use. Publisher model format:
      `projects/{project}/locations/{location}/publishers/*/models/*` Tuned
      model endpoint format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
  """

  googleCloudAiplatformV1beta1GenerateContentRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1GenerateContentRequest', 1)
  model = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsPublishersModelsStreamRawPredictRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPublishersModelsStreamRawPredictRequest
  object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1StreamRawPredictRequest: A
      GoogleCloudAiplatformV1beta1StreamRawPredictRequest resource to be
      passed as the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1StreamRawPredictRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1StreamRawPredictRequest', 2)


class AiplatformProjectsLocationsRagCorporaCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsRagCorporaCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1RagCorpus: A
      GoogleCloudAiplatformV1beta1RagCorpus resource to be passed as the
      request body.
    parent: Required. The resource name of the Location to create the
      RagCorpus in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1RagCorpus = _messages.MessageField('GoogleCloudAiplatformV1beta1RagCorpus', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsRagCorporaDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsRagCorporaDeleteRequest object.

  Fields:
    force: Optional. If set to true, any RagFiles in this RagCorpus will also
      be deleted. Otherwise, the request will only work if the RagCorpus has
      no RagFiles.
    name: Required. The name of the RagCorpus resource to be deleted. Format:
      `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsRagCorporaGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsRagCorporaGetRequest object.

  Fields:
    name: Required. The name of the RagCorpus resource. Format:
      `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsRagCorporaListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsRagCorporaListRequest object.

  Fields:
    pageSize: Optional. The standard list page size.
    pageToken: Optional. The standard list page token. Typically obtained via
      ListRagCorporaResponse.next_page_token of the previous
      VertexRagDataService.ListRagCorpora call.
    parent: Required. The resource name of the Location from which to list the
      RagCorpora. Format: `projects/{project}/locations/{location}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsRagCorporaOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsRagCorporaOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsRagCorporaOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsRagCorporaOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsRagCorporaOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsRagCorporaOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsRagCorporaOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsRagCorporaOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsRagCorporaOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsRagCorporaOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsRagCorporaRagFilesDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsRagCorporaRagFilesDeleteRequest object.

  Fields:
    name: Required. The name of the RagFile resource to be deleted. Format: `p
      rojects/{project}/locations/{location}/ragCorpora/{rag_corpus}/ragFiles/
      {rag_file}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsRagCorporaRagFilesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsRagCorporaRagFilesGetRequest object.

  Fields:
    name: Required. The name of the RagFile resource. Format: `projects/{proje
      ct}/locations/{location}/ragCorpora/{rag_corpus}/ragFiles/{rag_file}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsRagCorporaRagFilesImportRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsRagCorporaRagFilesImportRequest object.

  Fields:
    googleCloudAiplatformV1beta1ImportRagFilesRequest: A
      GoogleCloudAiplatformV1beta1ImportRagFilesRequest resource to be passed
      as the request body.
    parent: Required. The name of the RagCorpus resource into which to import
      files. Format:
      `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
  """

  googleCloudAiplatformV1beta1ImportRagFilesRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ImportRagFilesRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsRagCorporaRagFilesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsRagCorporaRagFilesListRequest object.

  Fields:
    pageSize: Optional. The standard list page size.
    pageToken: Optional. The standard list page token. Typically obtained via
      ListRagFilesResponse.next_page_token of the previous
      VertexRagDataService.ListRagFiles call.
    parent: Required. The resource name of the RagCorpus from which to list
      the RagFiles. Format:
      `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsRagCorporaRagFilesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsRagCorporaRagFilesOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsRagCorporaRagFilesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsRagCorporaRagFilesOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsRagCorporaRagFilesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsRagCorporaRagFilesOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsRagCorporaRagFilesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsRagCorporaRagFilesOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsRagCorporaRagFilesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsRagCorporaRagFilesOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsReasoningEnginesCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsReasoningEnginesCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1ReasoningEngine: A
      GoogleCloudAiplatformV1beta1ReasoningEngine resource to be passed as the
      request body.
    parent: Required. The resource name of the Location to create the
      ReasoningEngine in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1ReasoningEngine = _messages.MessageField('GoogleCloudAiplatformV1beta1ReasoningEngine', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsReasoningEnginesDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsReasoningEnginesDeleteRequest object.

  Fields:
    name: Required. The name of the ReasoningEngine resource to be deleted.
      Format: `projects/{project}/locations/{location}/reasoningEngines/{reaso
      ning_engine}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsReasoningEnginesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsReasoningEnginesGetRequest object.

  Fields:
    name: Required. The name of the ReasoningEngine resource. Format: `project
      s/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsReasoningEnginesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsReasoningEnginesListRequest object.

  Fields:
    filter: Optional. The standard list filter. More detail in
      [AIP-160](https://google.aip.dev/160).
    pageSize: Optional. The standard list page size.
    pageToken: Optional. The standard list page token.
    parent: Required. The resource name of the Location to list the
      ReasoningEngines from. Format: `projects/{project}/locations/{location}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class AiplatformProjectsLocationsReasoningEnginesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsReasoningEnginesOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsReasoningEnginesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsReasoningEnginesOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsReasoningEnginesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsReasoningEnginesOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsReasoningEnginesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsReasoningEnginesOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsReasoningEnginesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsReasoningEnginesOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsReasoningEnginesPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsReasoningEnginesPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1ReasoningEngine: A
      GoogleCloudAiplatformV1beta1ReasoningEngine resource to be passed as the
      request body.
    name: Identifier. The resource name of the ReasoningEngine.
    updateMask: Optional. Mask specifying which fields to update.
  """

  googleCloudAiplatformV1beta1ReasoningEngine = _messages.MessageField('GoogleCloudAiplatformV1beta1ReasoningEngine', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsReasoningEnginesQueryRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsReasoningEnginesQueryRequest object.

  Fields:
    googleCloudAiplatformV1beta1QueryReasoningEngineRequest: A
      GoogleCloudAiplatformV1beta1QueryReasoningEngineRequest resource to be
      passed as the request body.
    name: Required. The name of the ReasoningEngine resource to use. Format: `
      projects/{project}/locations/{location}/reasoningEngines/{reasoning_engi
      ne}`
  """

  googleCloudAiplatformV1beta1QueryReasoningEngineRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1QueryReasoningEngineRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsReasoningEnginesStreamQueryRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsReasoningEnginesStreamQueryRequest object.

  Fields:
    googleCloudAiplatformV1beta1StreamQueryReasoningEngineRequest: A
      GoogleCloudAiplatformV1beta1StreamQueryReasoningEngineRequest resource
      to be passed as the request body.
    name: Required. The name of the ReasoningEngine resource to use. Format: `
      projects/{project}/locations/{location}/reasoningEngines/{reasoning_engi
      ne}`
  """

  googleCloudAiplatformV1beta1StreamQueryReasoningEngineRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1StreamQueryReasoningEngineRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsRetrieveContextsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsRetrieveContextsRequest object.

  Fields:
    googleCloudAiplatformV1beta1RetrieveContextsRequest: A
      GoogleCloudAiplatformV1beta1RetrieveContextsRequest resource to be
      passed as the request body.
    parent: Required. The resource name of the Location from which to retrieve
      RagContexts. The users must have permission to make a call in the
      project. Format: `projects/{project}/locations/{location}`.
  """

  googleCloudAiplatformV1beta1RetrieveContextsRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1RetrieveContextsRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsSchedulesCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSchedulesCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1Schedule: A
      GoogleCloudAiplatformV1beta1Schedule resource to be passed as the
      request body.
    parent: Required. The resource name of the Location to create the Schedule
      in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1Schedule = _messages.MessageField('GoogleCloudAiplatformV1beta1Schedule', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsSchedulesDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSchedulesDeleteRequest object.

  Fields:
    name: Required. The name of the Schedule resource to be deleted. Format:
      `projects/{project}/locations/{location}/schedules/{schedule}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsSchedulesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSchedulesGetRequest object.

  Fields:
    name: Required. The name of the Schedule resource. Format:
      `projects/{project}/locations/{location}/schedules/{schedule}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsSchedulesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSchedulesListRequest object.

  Fields:
    filter: Lists the Schedules that match the filter expression. The
      following fields are supported: * `display_name`: Supports `=`, `!=`
      comparisons, and `:` wildcard. * `state`: Supports `=` and `!=`
      comparisons. * `request`: Supports existence of the check. (e.g.
      `create_pipeline_job_request:*` --> Schedule has
      create_pipeline_job_request). * `create_time`: Supports `=`, `!=`, `<`,
      `>`, `<=`, and `>=` comparisons. Values must be in RFC 3339 format. *
      `start_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
      Values must be in RFC 3339 format. * `end_time`: Supports `=`, `!=`,
      `<`, `>`, `<=`, `>=` comparisons and `:*` existence check. Values must
      be in RFC 3339 format. * `next_run_time`: Supports `=`, `!=`, `<`, `>`,
      `<=`, and `>=` comparisons. Values must be in RFC 3339 format. Filter
      expressions can be combined together using logical operators (`NOT`,
      `AND` & `OR`). The syntax to define filter expression is based on
      https://google.aip.dev/160. Examples: * `state="ACTIVE" AND
      display_name:"my_schedule_*"` * `NOT display_name="my_schedule"` *
      `create_time>"2021-05-18T00:00:00Z"` * `end_time>"2021-05-18T00:00:00Z"
      OR NOT end_time:*` * `create_pipeline_job_request:*`
    orderBy: A comma-separated list of fields to order by. The default sort
      order is in ascending order. Use "desc" after a field name for
      descending. You can have multiple order_by fields provided. For example,
      using "create_time desc, end_time" will order results by create time in
      descending order, and if there are multiple schedules having the same
      create time, order them by the end time in ascending order. If order_by
      is not specified, it will order by default with create_time in
      descending order. Supported fields: * `create_time` * `start_time` *
      `end_time` * `next_run_time`
    pageSize: The standard list page size. Default to 100 if not specified.
    pageToken: The standard list page token. Typically obtained via
      ListSchedulesResponse.next_page_token of the previous
      ScheduleService.ListSchedules call.
    parent: Required. The resource name of the Location to list the Schedules
      from. Format: `projects/{project}/locations/{location}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class AiplatformProjectsLocationsSchedulesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSchedulesOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsSchedulesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSchedulesOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsSchedulesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSchedulesOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsSchedulesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSchedulesOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsSchedulesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSchedulesOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsSchedulesPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSchedulesPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1Schedule: A
      GoogleCloudAiplatformV1beta1Schedule resource to be passed as the
      request body.
    name: Immutable. The resource name of the Schedule.
    updateMask: Required. The update mask applies to the resource. See
      google.protobuf.FieldMask.
  """

  googleCloudAiplatformV1beta1Schedule = _messages.MessageField('GoogleCloudAiplatformV1beta1Schedule', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsSchedulesPauseRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSchedulesPauseRequest object.

  Fields:
    googleCloudAiplatformV1beta1PauseScheduleRequest: A
      GoogleCloudAiplatformV1beta1PauseScheduleRequest resource to be passed
      as the request body.
    name: Required. The name of the Schedule resource to be paused. Format:
      `projects/{project}/locations/{location}/schedules/{schedule}`
  """

  googleCloudAiplatformV1beta1PauseScheduleRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1PauseScheduleRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsSchedulesResumeRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSchedulesResumeRequest object.

  Fields:
    googleCloudAiplatformV1beta1ResumeScheduleRequest: A
      GoogleCloudAiplatformV1beta1ResumeScheduleRequest resource to be passed
      as the request body.
    name: Required. The name of the Schedule resource to be resumed. Format:
      `projects/{project}/locations/{location}/schedules/{schedule}`
  """

  googleCloudAiplatformV1beta1ResumeScheduleRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ResumeScheduleRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsServerlessRayJobsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsServerlessRayJobsCancelRequest object.

  Fields:
    googleCloudAiplatformV1beta1CancelServerlessRayJobRequest: A
      GoogleCloudAiplatformV1beta1CancelServerlessRayJobRequest resource to be
      passed as the request body.
    name: Required. The name of the ServerlessRayJob to cancel. Format: `proje
      cts/{project}/locations/{location}/ServerlessRayJobs/{serverless_ray_job
      }`
  """

  googleCloudAiplatformV1beta1CancelServerlessRayJobRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1CancelServerlessRayJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsServerlessRayJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsServerlessRayJobsCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1ServerlessRayJob: A
      GoogleCloudAiplatformV1beta1ServerlessRayJob resource to be passed as
      the request body.
    parent: Required. The resource name of the Location to create the
      ServerlessRayJob in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1ServerlessRayJob = _messages.MessageField('GoogleCloudAiplatformV1beta1ServerlessRayJob', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsServerlessRayJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsServerlessRayJobsDeleteRequest object.

  Fields:
    name: Required. The name of the ServerlessRayJob resource to be deleted.
      Format: `projects/{project}/locations/{location}/ServerlessRayJobs/{serv
      erless_ray_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsServerlessRayJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsServerlessRayJobsGetRequest object.

  Fields:
    name: Required. The name of the ServerlessRayJob resource. Format: `projec
      ts/{project}/locations/{location}/serverlessRayJobs/{serverless_ray_job}
      `
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsServerlessRayJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsServerlessRayJobsListRequest object.

  Fields:
    filter: Optional. The standard list filter. Supported fields: *
      `serverless_ray_job_id` supports `=`, `!=` comparisons, and `:`
      wildcard. * `state` supports `=`, `!=` comparisons. * `labels` supports
      general map functions that is: `labels.key=value` - key:value equality
      `labels.key:* - key existence
    pageSize: Optional. The standard list page size.
    pageToken: Optional. The standard list page token. Typically obtained via
      ListServerlessRayJobsResponse.next_page_token of the previous
      JobService.ListServerlessRayJobs call.
    parent: Required. The resource name of the Location to list the
      ServerlessRayJobs from. Format:
      `projects/{project}/locations/{location}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class AiplatformProjectsLocationsSolversOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSolversOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsSolversOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSolversOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsSolversOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSolversOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsSpecialistPoolsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1SpecialistPool: A
      GoogleCloudAiplatformV1beta1SpecialistPool resource to be passed as the
      request body.
    parent: Required. The parent Project name for the new SpecialistPool. The
      form is `projects/{project}/locations/{location}`.
  """

  googleCloudAiplatformV1beta1SpecialistPool = _messages.MessageField('GoogleCloudAiplatformV1beta1SpecialistPool', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsSpecialistPoolsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsDeleteRequest object.

  Fields:
    force: If set to true, any specialist managers in this SpecialistPool will
      also be deleted. (Otherwise, the request will only work if the
      SpecialistPool has no specialist managers.)
    name: Required. The resource name of the SpecialistPool to delete. Format:
      `projects/{project}/locations/{location}/specialistPools/{specialist_poo
      l}`
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsSpecialistPoolsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsGetRequest object.

  Fields:
    name: Required. The name of the SpecialistPool resource. The form is `proj
      ects/{project}/locations/{location}/specialistPools/{specialist_pool}`.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsSpecialistPoolsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsListRequest object.

  Fields:
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained by
      ListSpecialistPoolsResponse.next_page_token of the previous
      SpecialistPoolService.ListSpecialistPools call. Return first page if
      empty.
    parent: Required. The name of the SpecialistPool's parent resource.
      Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read. FieldMask represents a set
      of
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  readMask = _messages.StringField(4)


class AiplatformProjectsLocationsSpecialistPoolsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsSpecialistPoolsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsSpecialistPoolsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsSpecialistPoolsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsSpecialistPoolsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsSpecialistPoolsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1SpecialistPool: A
      GoogleCloudAiplatformV1beta1SpecialistPool resource to be passed as the
      request body.
    name: Required. The resource name of the SpecialistPool.
    updateMask: Required. The update mask applies to the resource.
  """

  googleCloudAiplatformV1beta1SpecialistPool = _messages.MessageField('GoogleCloudAiplatformV1beta1SpecialistPool', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsStudiesCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1Study: A GoogleCloudAiplatformV1beta1Study
      resource to be passed as the request body.
    parent: Required. The resource name of the Location to create the
      CustomJob in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1Study = _messages.MessageField('GoogleCloudAiplatformV1beta1Study', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsStudiesDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesDeleteRequest object.

  Fields:
    name: Required. The name of the Study resource to be deleted. Format:
      `projects/{project}/locations/{location}/studies/{study}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsStudiesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesGetRequest object.

  Fields:
    name: Required. The name of the Study resource. Format:
      `projects/{project}/locations/{location}/studies/{study}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsStudiesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesListRequest object.

  Fields:
    pageSize: Optional. The maximum number of studies to return per "page" of
      results. If unspecified, service will pick an appropriate default.
    pageToken: Optional. A page token to request the next page of results. If
      unspecified, there are no subsequent pages.
    parent: Required. The resource name of the Location to list the Study
      from. Format: `projects/{project}/locations/{location}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsStudiesLookupRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesLookupRequest object.

  Fields:
    googleCloudAiplatformV1beta1LookupStudyRequest: A
      GoogleCloudAiplatformV1beta1LookupStudyRequest resource to be passed as
      the request body.
    parent: Required. The resource name of the Location to get the Study from.
      Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1LookupStudyRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1LookupStudyRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsStudiesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsStudiesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsStudiesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsStudiesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsStudiesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsStudiesTrialsAddTrialMeasurementRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsAddTrialMeasurementRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1AddTrialMeasurementRequest: A
      GoogleCloudAiplatformV1beta1AddTrialMeasurementRequest resource to be
      passed as the request body.
    trialName: Required. The name of the trial to add measurement. Format:
      `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
  """

  googleCloudAiplatformV1beta1AddTrialMeasurementRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1AddTrialMeasurementRequest', 1)
  trialName = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsStudiesTrialsCheckTrialEarlyStoppingStateRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsStudiesTrialsCheckTrialEarlyStoppingStateRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1CheckTrialEarlyStoppingStateRequest: A
      GoogleCloudAiplatformV1beta1CheckTrialEarlyStoppingStateRequest resource
      to be passed as the request body.
    trialName: Required. The Trial's name. Format:
      `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
  """

  googleCloudAiplatformV1beta1CheckTrialEarlyStoppingStateRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1CheckTrialEarlyStoppingStateRequest', 1)
  trialName = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsStudiesTrialsCompleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsCompleteRequest object.

  Fields:
    googleCloudAiplatformV1beta1CompleteTrialRequest: A
      GoogleCloudAiplatformV1beta1CompleteTrialRequest resource to be passed
      as the request body.
    name: Required. The Trial's name. Format:
      `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
  """

  googleCloudAiplatformV1beta1CompleteTrialRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1CompleteTrialRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsStudiesTrialsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1Trial: A GoogleCloudAiplatformV1beta1Trial
      resource to be passed as the request body.
    parent: Required. The resource name of the Study to create the Trial in.
      Format: `projects/{project}/locations/{location}/studies/{study}`
  """

  googleCloudAiplatformV1beta1Trial = _messages.MessageField('GoogleCloudAiplatformV1beta1Trial', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsStudiesTrialsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsDeleteRequest object.

  Fields:
    name: Required. The Trial's name. Format:
      `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsStudiesTrialsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsGetRequest object.

  Fields:
    name: Required. The name of the Trial resource. Format:
      `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsStudiesTrialsListOptimalTrialsRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsListOptimalTrialsRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1ListOptimalTrialsRequest: A
      GoogleCloudAiplatformV1beta1ListOptimalTrialsRequest resource to be
      passed as the request body.
    parent: Required. The name of the Study that the optimal Trial belongs to.
  """

  googleCloudAiplatformV1beta1ListOptimalTrialsRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ListOptimalTrialsRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsStudiesTrialsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsListRequest object.

  Fields:
    pageSize: Optional. The number of Trials to retrieve per "page" of
      results. If unspecified, the service will pick an appropriate default.
    pageToken: Optional. A page token to request the next page of results. If
      unspecified, there are no subsequent pages.
    parent: Required. The resource name of the Study to list the Trial from.
      Format: `projects/{project}/locations/{location}/studies/{study}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsStudiesTrialsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsStudiesTrialsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsStudiesTrialsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsStudiesTrialsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsStudiesTrialsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsStudiesTrialsStopRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsStopRequest object.

  Fields:
    googleCloudAiplatformV1beta1StopTrialRequest: A
      GoogleCloudAiplatformV1beta1StopTrialRequest resource to be passed as
      the request body.
    name: Required. The Trial's name. Format:
      `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
  """

  googleCloudAiplatformV1beta1StopTrialRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1StopTrialRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsStudiesTrialsSuggestRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsSuggestRequest object.

  Fields:
    googleCloudAiplatformV1beta1SuggestTrialsRequest: A
      GoogleCloudAiplatformV1beta1SuggestTrialsRequest resource to be passed
      as the request body.
    parent: Required. The project and location that the Study belongs to.
      Format: `projects/{project}/locations/{location}/studies/{study}`
  """

  googleCloudAiplatformV1beta1SuggestTrialsRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1SuggestTrialsRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTensorboardsBatchReadRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsBatchReadRequest object.

  Fields:
    tensorboard: Required. The resource name of the Tensorboard containing
      TensorboardTimeSeries to read data from. Format:
      `projects/{project}/locations/{location}/tensorboards/{tensorboard}`.
      The TensorboardTimeSeries referenced by time_series must be sub
      resources of this Tensorboard.
    timeSeries: Required. The resource names of the TensorboardTimeSeries to
      read data from. Format: `projects/{project}/locations/{location}/tensorb
      oards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time
      _series}`
  """

  tensorboard = _messages.StringField(1, required=True)
  timeSeries = _messages.StringField(2, repeated=True)


class AiplatformProjectsLocationsTensorboardsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1Tensorboard: A
      GoogleCloudAiplatformV1beta1Tensorboard resource to be passed as the
      request body.
    parent: Required. The resource name of the Location to create the
      Tensorboard in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1Tensorboard = _messages.MessageField('GoogleCloudAiplatformV1beta1Tensorboard', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTensorboardsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsDeleteRequest object.

  Fields:
    name: Required. The name of the Tensorboard to be deleted. Format:
      `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsBatchCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsBatchCreateRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1BatchCreateTensorboardTimeSeriesRequest: A
      GoogleCloudAiplatformV1beta1BatchCreateTensorboardTimeSeriesRequest
      resource to be passed as the request body.
    parent: Required. The resource name of the TensorboardExperiment to create
      the TensorboardTimeSeries in. Format: `projects/{project}/locations/{loc
      ation}/tensorboards/{tensorboard}/experiments/{experiment}` The
      TensorboardRuns referenced by the parent fields in the
      CreateTensorboardTimeSeriesRequest messages must be sub resources of
      this TensorboardExperiment.
  """

  googleCloudAiplatformV1beta1BatchCreateTensorboardTimeSeriesRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchCreateTensorboardTimeSeriesRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsCreateRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1TensorboardExperiment: A
      GoogleCloudAiplatformV1beta1TensorboardExperiment resource to be passed
      as the request body.
    parent: Required. The resource name of the Tensorboard to create the
      TensorboardExperiment in. Format:
      `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
    tensorboardExperimentId: Required. The ID to use for the Tensorboard
      experiment, which becomes the final component of the Tensorboard
      experiment's resource name. This value should be 1-128 characters, and
      valid characters are `/a-z-/`.
  """

  googleCloudAiplatformV1beta1TensorboardExperiment = _messages.MessageField('GoogleCloudAiplatformV1beta1TensorboardExperiment', 1)
  parent = _messages.StringField(2, required=True)
  tensorboardExperimentId = _messages.StringField(3)


class AiplatformProjectsLocationsTensorboardsExperimentsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsDeleteRequest
  object.

  Fields:
    name: Required. The name of the TensorboardExperiment to be deleted.
      Format: `projects/{project}/locations/{location}/tensorboards/{tensorboa
      rd}/experiments/{experiment}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsGetRequest object.

  Fields:
    name: Required. The name of the TensorboardExperiment resource. Format: `p
      rojects/{project}/locations/{location}/tensorboards/{tensorboard}/experi
      ments/{experiment}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsListRequest object.

  Fields:
    filter: Lists the TensorboardExperiments that match the filter expression.
    orderBy: Field to use to sort the list.
    pageSize: The maximum number of TensorboardExperiments to return. The
      service may return fewer than this value. If unspecified, at most 50
      TensorboardExperiments are returned. The maximum value is 1000; values
      above 1000 are coerced to 1000.
    pageToken: A page token, received from a previous
      TensorboardService.ListTensorboardExperiments call. Provide this to
      retrieve the subsequent page. When paginating, all other parameters
      provided to TensorboardService.ListTensorboardExperiments must match the
      call that provided the page token.
    parent: Required. The resource name of the Tensorboard to list
      TensorboardExperiments. Format:
      `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsTensorboardsExperimentsOperationsCancelRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsOperationsDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsTensorboardsExperimentsOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsTensorboardsExperimentsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1TensorboardExperiment: A
      GoogleCloudAiplatformV1beta1TensorboardExperiment resource to be passed
      as the request body.
    name: Output only. Name of the TensorboardExperiment. Format: `projects/{p
      roject}/locations/{location}/tensorboards/{tensorboard}/experiments/{exp
      eriment}`
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the TensorboardExperiment resource by the update. The
      fields specified in the update_mask are relative to the resource, not
      the full request. A field is overwritten if it's in the mask. If the
      user does not provide a mask then all fields are overwritten if new
      values are specified.
  """

  googleCloudAiplatformV1beta1TensorboardExperiment = _messages.MessageField('GoogleCloudAiplatformV1beta1TensorboardExperiment', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsBatchCreateRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsRunsBatchCreateRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1BatchCreateTensorboardRunsRequest: A
      GoogleCloudAiplatformV1beta1BatchCreateTensorboardRunsRequest resource
      to be passed as the request body.
    parent: Required. The resource name of the TensorboardExperiment to create
      the TensorboardRuns in. Format: `projects/{project}/locations/{location}
      /tensorboards/{tensorboard}/experiments/{experiment}` The parent field
      in the CreateTensorboardRunRequest messages must match this field.
  """

  googleCloudAiplatformV1beta1BatchCreateTensorboardRunsRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchCreateTensorboardRunsRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsCreateRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1TensorboardRun: A
      GoogleCloudAiplatformV1beta1TensorboardRun resource to be passed as the
      request body.
    parent: Required. The resource name of the TensorboardExperiment to create
      the TensorboardRun in. Format: `projects/{project}/locations/{location}/
      tensorboards/{tensorboard}/experiments/{experiment}`
    tensorboardRunId: Required. The ID to use for the Tensorboard run, which
      becomes the final component of the Tensorboard run's resource name. This
      value should be 1-128 characters, and valid characters are `/a-z-/`.
  """

  googleCloudAiplatformV1beta1TensorboardRun = _messages.MessageField('GoogleCloudAiplatformV1beta1TensorboardRun', 1)
  parent = _messages.StringField(2, required=True)
  tensorboardRunId = _messages.StringField(3)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsDeleteRequest
  object.

  Fields:
    name: Required. The name of the TensorboardRun to be deleted. Format: `pro
      jects/{project}/locations/{location}/tensorboards/{tensorboard}/experime
      nts/{experiment}/runs/{run}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsGetRequest
  object.

  Fields:
    name: Required. The name of the TensorboardRun resource. Format: `projects
      /{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{
      experiment}/runs/{run}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsListRequest
  object.

  Fields:
    filter: Lists the TensorboardRuns that match the filter expression.
    orderBy: Field to use to sort the list.
    pageSize: The maximum number of TensorboardRuns to return. The service may
      return fewer than this value. If unspecified, at most 50 TensorboardRuns
      are returned. The maximum value is 1000; values above 1000 are coerced
      to 1000.
    pageToken: A page token, received from a previous
      TensorboardService.ListTensorboardRuns call. Provide this to retrieve
      the subsequent page. When paginating, all other parameters provided to
      TensorboardService.ListTensorboardRuns must match the call that provided
      the page token.
    parent: Required. The resource name of the TensorboardExperiment to list
      TensorboardRuns. Format: `projects/{project}/locations/{location}/tensor
      boards/{tensorboard}/experiments/{experiment}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsCancel
  Request object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsDelete
  Request object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsGetRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsPatchRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1TensorboardRun: A
      GoogleCloudAiplatformV1beta1TensorboardRun resource to be passed as the
      request body.
    name: Output only. Name of the TensorboardRun. Format: `projects/{project}
      /locations/{location}/tensorboards/{tensorboard}/experiments/{experiment
      }/runs/{run}`
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the TensorboardRun resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field is overwritten if it's in the mask. If the user does
      not provide a mask then all fields are overwritten if new values are
      specified.
  """

  googleCloudAiplatformV1beta1TensorboardRun = _messages.MessageField('GoogleCloudAiplatformV1beta1TensorboardRun', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesCreate
  Request object.

  Fields:
    googleCloudAiplatformV1beta1TensorboardTimeSeries: A
      GoogleCloudAiplatformV1beta1TensorboardTimeSeries resource to be passed
      as the request body.
    parent: Required. The resource name of the TensorboardRun to create the
      TensorboardTimeSeries in. Format: `projects/{project}/locations/{locatio
      n}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
    tensorboardTimeSeriesId: Optional. The user specified unique ID to use for
      the TensorboardTimeSeries, which becomes the final component of the
      TensorboardTimeSeries's resource name. This value should match
      "a-z0-9{0, 127}"
  """

  googleCloudAiplatformV1beta1TensorboardTimeSeries = _messages.MessageField('GoogleCloudAiplatformV1beta1TensorboardTimeSeries', 1)
  parent = _messages.StringField(2, required=True)
  tensorboardTimeSeriesId = _messages.StringField(3)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesDelete
  Request object.

  Fields:
    name: Required. The name of the TensorboardTimeSeries to be deleted.
      Format: `projects/{project}/locations/{location}/tensorboards/{tensorboa
      rd}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesExportTensorboardTimeSeriesRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesExport
  TensorboardTimeSeriesRequest object.

  Fields:
    googleCloudAiplatformV1beta1ExportTensorboardTimeSeriesDataRequest: A
      GoogleCloudAiplatformV1beta1ExportTensorboardTimeSeriesDataRequest
      resource to be passed as the request body.
    tensorboardTimeSeries: Required. The resource name of the
      TensorboardTimeSeries to export data from. Format: `projects/{project}/l
      ocations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/
      runs/{run}/timeSeries/{time_series}`
  """

  googleCloudAiplatformV1beta1ExportTensorboardTimeSeriesDataRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ExportTensorboardTimeSeriesDataRequest', 1)
  tensorboardTimeSeries = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesGetRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesGetRequest
  object.

  Fields:
    name: Required. The name of the TensorboardTimeSeries resource. Format: `p
      rojects/{project}/locations/{location}/tensorboards/{tensorboard}/experi
      ments/{experiment}/runs/{run}/timeSeries/{time_series}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesListRequest
  object.

  Fields:
    filter: Lists the TensorboardTimeSeries that match the filter expression.
    orderBy: Field to use to sort the list.
    pageSize: The maximum number of TensorboardTimeSeries to return. The
      service may return fewer than this value. If unspecified, at most 50
      TensorboardTimeSeries are returned. The maximum value is 1000; values
      above 1000 are coerced to 1000.
    pageToken: A page token, received from a previous
      TensorboardService.ListTensorboardTimeSeries call. Provide this to
      retrieve the subsequent page. When paginating, all other parameters
      provided to TensorboardService.ListTensorboardTimeSeries must match the
      call that provided the page token.
    parent: Required. The resource name of the TensorboardRun to list
      TensorboardTimeSeries. Format: `projects/{project}/locations/{location}/
      tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperat
  ionsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperat
  ionsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperat
  ionsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperat
  ionsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperat
  ionsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesPatchRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesPatchRequest
  object.

  Fields:
    googleCloudAiplatformV1beta1TensorboardTimeSeries: A
      GoogleCloudAiplatformV1beta1TensorboardTimeSeries resource to be passed
      as the request body.
    name: Output only. Name of the TensorboardTimeSeries.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the TensorboardTimeSeries resource by the update. The
      fields specified in the update_mask are relative to the resource, not
      the full request. A field is overwritten if it's in the mask. If the
      user does not provide a mask then all fields are overwritten if new
      values are specified.
  """

  googleCloudAiplatformV1beta1TensorboardTimeSeries = _messages.MessageField('GoogleCloudAiplatformV1beta1TensorboardTimeSeries', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesReadBlobDataRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesReadBl
  obDataRequest object.

  Fields:
    blobIds: IDs of the blobs to read.
    timeSeries: Required. The resource name of the TensorboardTimeSeries to
      list Blobs. Format: `projects/{project}/locations/{location}/tensorboard
      s/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_ser
      ies}`
  """

  blobIds = _messages.StringField(1, repeated=True)
  timeSeries = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesReadRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesReadRequest
  object.

  Fields:
    filter: Reads the TensorboardTimeSeries' data that match the filter
      expression.
    maxDataPoints: The maximum number of TensorboardTimeSeries' data to
      return. This value should be a positive integer. This value can be set
      to -1 to return all data.
    tensorboardTimeSeries: Required. The resource name of the
      TensorboardTimeSeries to read data from. Format: `projects/{project}/loc
      ations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/ru
      ns/{run}/timeSeries/{time_series}`
  """

  filter = _messages.StringField(1)
  maxDataPoints = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  tensorboardTimeSeries = _messages.StringField(3, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsWriteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsWriteRequest object.

  Fields:
    googleCloudAiplatformV1beta1WriteTensorboardExperimentDataRequest: A
      GoogleCloudAiplatformV1beta1WriteTensorboardExperimentDataRequest
      resource to be passed as the request body.
    tensorboardExperiment: Required. The resource name of the
      TensorboardExperiment to write data to. Format: `projects/{project}/loca
      tions/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
  """

  googleCloudAiplatformV1beta1WriteTensorboardExperimentDataRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1WriteTensorboardExperimentDataRequest', 1)
  tensorboardExperiment = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTensorboardsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsGetRequest object.

  Fields:
    name: Required. The name of the Tensorboard resource. Format:
      `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsListRequest object.

  Fields:
    filter: Lists the Tensorboards that match the filter expression.
    orderBy: Field to use to sort the list.
    pageSize: The maximum number of Tensorboards to return. The service may
      return fewer than this value. If unspecified, at most 100 Tensorboards
      are returned. The maximum value is 100; values above 100 are coerced to
      100.
    pageToken: A page token, received from a previous
      TensorboardService.ListTensorboards call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      TensorboardService.ListTensorboards must match the call that provided
      the page token.
    parent: Required. The resource name of the Location to list Tensorboards.
      Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readMask = _messages.StringField(6)


class AiplatformProjectsLocationsTensorboardsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsTensorboardsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsTensorboardsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsPatchRequest object.

  Fields:
    googleCloudAiplatformV1beta1Tensorboard: A
      GoogleCloudAiplatformV1beta1Tensorboard resource to be passed as the
      request body.
    name: Output only. Name of the Tensorboard. Format:
      `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Tensorboard resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field is overwritten if it's in the mask. If the user does
      not provide a mask then all fields are overwritten if new values are
      specified.
  """

  googleCloudAiplatformV1beta1Tensorboard = _messages.MessageField('GoogleCloudAiplatformV1beta1Tensorboard', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsTensorboardsReadSizeRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsReadSizeRequest object.

  Fields:
    tensorboard: Required. The name of the Tensorboard resource. Format:
      `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  """

  tensorboard = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsReadUsageRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsReadUsageRequest object.

  Fields:
    tensorboard: Required. The name of the Tensorboard resource. Format:
      `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  """

  tensorboard = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTrainingPipelinesCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesCancelRequest object.

  Fields:
    googleCloudAiplatformV1beta1CancelTrainingPipelineRequest: A
      GoogleCloudAiplatformV1beta1CancelTrainingPipelineRequest resource to be
      passed as the request body.
    name: Required. The name of the TrainingPipeline to cancel. Format: `proje
      cts/{project}/locations/{location}/trainingPipelines/{training_pipeline}
      `
  """

  googleCloudAiplatformV1beta1CancelTrainingPipelineRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1CancelTrainingPipelineRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTrainingPipelinesCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1TrainingPipeline: A
      GoogleCloudAiplatformV1beta1TrainingPipeline resource to be passed as
      the request body.
    parent: Required. The resource name of the Location to create the
      TrainingPipeline in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1TrainingPipeline = _messages.MessageField('GoogleCloudAiplatformV1beta1TrainingPipeline', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTrainingPipelinesDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesDeleteRequest object.

  Fields:
    name: Required. The name of the TrainingPipeline resource to be deleted.
      Format: `projects/{project}/locations/{location}/trainingPipelines/{trai
      ning_pipeline}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTrainingPipelinesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesGetRequest object.

  Fields:
    name: Required. The name of the TrainingPipeline resource. Format: `projec
      ts/{project}/locations/{location}/trainingPipelines/{training_pipeline}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTrainingPipelinesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesListRequest object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports `=`, `!=` comparisons, and `:` wildcard. * `state` supports
      `=`, `!=` comparisons. * `training_task_definition` `=`, `!=`
      comparisons, and `:` wildcard. * `create_time` supports `=`, `!=`,`<`,
      `<=`,`>`, `>=` comparisons. `create_time` must be in RFC 3339 format. *
      `labels` supports general map functions that is: `labels.key=value` -
      key:value equality `labels.key:* - key existence Some examples of using
      the filter are: * `state="PIPELINE_STATE_SUCCEEDED" AND
      display_name:"my_pipeline_*"` * `state!="PIPELINE_STATE_FAILED" OR
      display_name="my_pipeline"` * `NOT display_name="my_pipeline"` *
      `create_time>"2021-05-18T00:00:00Z"` *
      `training_task_definition:"*automl_text_classification*"`
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListTrainingPipelinesResponse.next_page_token of the previous
      PipelineService.ListTrainingPipelines call.
    parent: Required. The resource name of the Location to list the
      TrainingPipelines from. Format:
      `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsTrainingPipelinesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTrainingPipelinesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTrainingPipelinesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTrainingPipelinesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsTrainingPipelinesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsTuningJobsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTuningJobsCancelRequest object.

  Fields:
    googleCloudAiplatformV1beta1CancelTuningJobRequest: A
      GoogleCloudAiplatformV1beta1CancelTuningJobRequest resource to be passed
      as the request body.
    name: Required. The name of the TuningJob to cancel. Format:
      `projects/{project}/locations/{location}/tuningJobs/{tuning_job}`
  """

  googleCloudAiplatformV1beta1CancelTuningJobRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1CancelTuningJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTuningJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTuningJobsCreateRequest object.

  Fields:
    googleCloudAiplatformV1beta1TuningJob: A
      GoogleCloudAiplatformV1beta1TuningJob resource to be passed as the
      request body.
    parent: Required. The resource name of the Location to create the
      TuningJob in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1TuningJob = _messages.MessageField('GoogleCloudAiplatformV1beta1TuningJob', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTuningJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTuningJobsGetRequest object.

  Fields:
    name: Required. The name of the TuningJob resource. Format:
      `projects/{project}/locations/{location}/tuningJobs/{tuning_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTuningJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTuningJobsListRequest object.

  Fields:
    filter: Optional. The standard list filter.
    pageSize: Optional. The standard list page size.
    pageToken: Optional. The standard list page token. Typically obtained via
      ListTuningJobsResponse.next_page_token of the previous
      GenAiTuningService.ListTuningJob][] call.
    parent: Required. The resource name of the Location to list the TuningJobs
      from. Format: `projects/{project}/locations/{location}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class AiplatformProjectsLocationsTuningJobsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTuningJobsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTuningJobsRebaseTunedModelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTuningJobsRebaseTunedModelRequest object.

  Fields:
    googleCloudAiplatformV1beta1RebaseTunedModelRequest: A
      GoogleCloudAiplatformV1beta1RebaseTunedModelRequest resource to be
      passed as the request body.
    parent: Required. The resource name of the Location into which to rebase
      the Model. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1beta1RebaseTunedModelRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1RebaseTunedModelRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformPublishersModelsComputeTokensRequest(_messages.Message):
  r"""A AiplatformPublishersModelsComputeTokensRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to get lists of
      tokens and token ids.
    googleCloudAiplatformV1beta1ComputeTokensRequest: A
      GoogleCloudAiplatformV1beta1ComputeTokensRequest resource to be passed
      as the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1ComputeTokensRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1ComputeTokensRequest', 2)


class AiplatformPublishersModelsCountTokensRequest(_messages.Message):
  r"""A AiplatformPublishersModelsCountTokensRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to perform token
      counting. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1CountTokensRequest: A
      GoogleCloudAiplatformV1beta1CountTokensRequest resource to be passed as
      the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1CountTokensRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1CountTokensRequest', 2)


class AiplatformPublishersModelsGenerateContentRequest(_messages.Message):
  r"""A AiplatformPublishersModelsGenerateContentRequest object.

  Fields:
    googleCloudAiplatformV1beta1GenerateContentRequest: A
      GoogleCloudAiplatformV1beta1GenerateContentRequest resource to be passed
      as the request body.
    model: Required. The fully qualified name of the publisher model or tuned
      model endpoint to use. Publisher model format:
      `projects/{project}/locations/{location}/publishers/*/models/*` Tuned
      model endpoint format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
  """

  googleCloudAiplatformV1beta1GenerateContentRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1GenerateContentRequest', 1)
  model = _messages.StringField(2, required=True)


class AiplatformPublishersModelsGetRequest(_messages.Message):
  r"""A AiplatformPublishersModelsGetRequest object.

  Enums:
    ViewValueValuesEnum: Optional. PublisherModel view specifying which fields
      to read.

  Fields:
    huggingFaceToken: Optional. Token used to access Hugging Face gated
      models.
    isHuggingFaceModel: Optional. Boolean indicates whether the requested
      model is a Hugging Face model.
    languageCode: Optional. The IETF BCP-47 language code representing the
      language in which the publisher model's text information should be
      written in.
    name: Required. The name of the PublisherModel resource. Format:
      `publishers/{publisher}/models/{publisher_model}`
    view: Optional. PublisherModel view specifying which fields to read.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Optional. PublisherModel view specifying which fields to read.

    Values:
      PUBLISHER_MODEL_VIEW_UNSPECIFIED: The default / unset value. The API
        will default to the BASIC view.
      PUBLISHER_MODEL_VIEW_BASIC: Include basic metadata about the publisher
        model, but not the full contents.
      PUBLISHER_MODEL_VIEW_FULL: Include everything.
      PUBLISHER_MODEL_VERSION_VIEW_BASIC: Include: VersionId,
        ModelVersionExternalName, and SupportedActions.
    """
    PUBLISHER_MODEL_VIEW_UNSPECIFIED = 0
    PUBLISHER_MODEL_VIEW_BASIC = 1
    PUBLISHER_MODEL_VIEW_FULL = 2
    PUBLISHER_MODEL_VERSION_VIEW_BASIC = 3

  huggingFaceToken = _messages.StringField(1)
  isHuggingFaceModel = _messages.BooleanField(2)
  languageCode = _messages.StringField(3)
  name = _messages.StringField(4, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 5)


class AiplatformPublishersModelsListRequest(_messages.Message):
  r"""A AiplatformPublishersModelsListRequest object.

  Enums:
    ViewValueValuesEnum: Optional. PublisherModel view specifying which fields
      to read.

  Fields:
    filter: Optional. The standard list filter.
    languageCode: Optional. The IETF BCP-47 language code representing the
      language in which the publisher models' text information should be
      written in. If not set, by default English (en).
    listAllVersions: Optional. List all publisher model versions if the flag
      is set to true.
    orderBy: Optional. A comma-separated list of fields to order by, sorted in
      ascending order. Use "desc" after a field name for descending.
    pageSize: Optional. The standard list page size.
    pageToken: Optional. The standard list page token. Typically obtained via
      ListPublisherModelsResponse.next_page_token of the previous
      ModelGardenService.ListPublisherModels call.
    parent: Required. The name of the Publisher from which to list the
      PublisherModels. Format: `publishers/{publisher}`
    view: Optional. PublisherModel view specifying which fields to read.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Optional. PublisherModel view specifying which fields to read.

    Values:
      PUBLISHER_MODEL_VIEW_UNSPECIFIED: The default / unset value. The API
        will default to the BASIC view.
      PUBLISHER_MODEL_VIEW_BASIC: Include basic metadata about the publisher
        model, but not the full contents.
      PUBLISHER_MODEL_VIEW_FULL: Include everything.
      PUBLISHER_MODEL_VERSION_VIEW_BASIC: Include: VersionId,
        ModelVersionExternalName, and SupportedActions.
    """
    PUBLISHER_MODEL_VIEW_UNSPECIFIED = 0
    PUBLISHER_MODEL_VIEW_BASIC = 1
    PUBLISHER_MODEL_VIEW_FULL = 2
    PUBLISHER_MODEL_VERSION_VIEW_BASIC = 3

  filter = _messages.StringField(1)
  languageCode = _messages.StringField(2)
  listAllVersions = _messages.BooleanField(3)
  orderBy = _messages.StringField(4)
  pageSize = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(6)
  parent = _messages.StringField(7, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 8)


class AiplatformPublishersModelsPredictRequest(_messages.Message):
  r"""A AiplatformPublishersModelsPredictRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1beta1PredictRequest: A
      GoogleCloudAiplatformV1beta1PredictRequest resource to be passed as the
      request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1beta1PredictRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1PredictRequest', 2)


class AiplatformPublishersModelsStreamGenerateContentRequest(_messages.Message):
  r"""A AiplatformPublishersModelsStreamGenerateContentRequest object.

  Fields:
    googleCloudAiplatformV1beta1GenerateContentRequest: A
      GoogleCloudAiplatformV1beta1GenerateContentRequest resource to be passed
      as the request body.
    model: Required. The fully qualified name of the publisher model or tuned
      model endpoint to use. Publisher model format:
      `projects/{project}/locations/{location}/publishers/*/models/*` Tuned
      model endpoint format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
  """

  googleCloudAiplatformV1beta1GenerateContentRequest = _messages.MessageField('GoogleCloudAiplatformV1beta1GenerateContentRequest', 1)
  model = _messages.StringField(2, required=True)


class CloudAiLargeModelsVisionGenerateVideoResponse(_messages.Message):
  r"""Generate video response.

  Fields:
    generatedSamples: The generates samples.
    raiMediaFilteredCount: Returns if any videos were filtered due to RAI
      policies.
    raiMediaFilteredReasons: Returns rai failure reasons if any.
    videos: List of videos, used to align naming with the external response.
  """

  generatedSamples = _messages.MessageField('CloudAiLargeModelsVisionMedia', 1, repeated=True)
  raiMediaFilteredCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  raiMediaFilteredReasons = _messages.StringField(3, repeated=True)
  videos = _messages.MessageField('CloudAiLargeModelsVisionGenerateVideoResponseVideo', 4, repeated=True)


class CloudAiLargeModelsVisionGenerateVideoResponseVideo(_messages.Message):
  r"""A CloudAiLargeModelsVisionGenerateVideoResponseVideo object.

  Fields:
    bytesBase64Encoded: Base64 encoded bytes string representing the video.
    gcsUri: Cloud Storage URI where the generated video is written.
    mimeType: The MIME type of the content of the video. - video/mp4
  """

  bytesBase64Encoded = _messages.StringField(1)
  gcsUri = _messages.StringField(2)
  mimeType = _messages.StringField(3)


class CloudAiLargeModelsVisionImage(_messages.Message):
  r"""Image.

  Fields:
    encoding: Image encoding, encoded as "image/png" or "image/jpg".
    generationSeed: Generation seed for the sampled image. This parameter is
      exposed to the user only if one of the following is true: 1. The user
      specified per-example seeds in the request. 2. The user doesn't specify
      the generation seed in the request.
    image: Raw bytes.
    imageRaiScores: RAI scores for generated image.
    imageSize: Image size. The size of the image. Can be self reported, or
      computed from the image bytes.
    raiInfo: RAI info for image.
    semanticFilterResponse: Semantic filter info for image.
    text: Text/Expanded text input for imagen.
    uri: Path to another storage (typically Google Cloud Storage).
  """

  encoding = _messages.StringField(1)
  generationSeed = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  image = _messages.BytesField(3)
  imageRaiScores = _messages.MessageField('CloudAiLargeModelsVisionImageRAIScores', 4)
  imageSize = _messages.MessageField('CloudAiLargeModelsVisionImageImageSize', 5)
  raiInfo = _messages.MessageField('CloudAiLargeModelsVisionRaiInfo', 6)
  semanticFilterResponse = _messages.MessageField('CloudAiLargeModelsVisionSemanticFilterResponse', 7)
  text = _messages.StringField(8)
  uri = _messages.StringField(9)


class CloudAiLargeModelsVisionImageImageSize(_messages.Message):
  r"""Image size.

  Fields:
    channels: A integer attribute.
    height: A integer attribute.
    width: A integer attribute.
  """

  channels = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  height = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  width = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class CloudAiLargeModelsVisionImageRAIScores(_messages.Message):
  r"""RAI scores for generated image returned.

  Fields:
    agileWatermarkDetectionScore: Agile watermark score for image.
  """

  agileWatermarkDetectionScore = _messages.FloatField(1)


class CloudAiLargeModelsVisionMedia(_messages.Message):
  r"""Media.

  Fields:
    image: Image.
    video: Video
  """

  image = _messages.MessageField('CloudAiLargeModelsVisionImage', 1)
  video = _messages.MessageField('CloudAiLargeModelsVisionVideo', 2)


class CloudAiLargeModelsVisionNamedBoundingBox(_messages.Message):
  r"""A CloudAiLargeModelsVisionNamedBoundingBox object.

  Fields:
    classes: A string attribute.
    entities: A string attribute.
    scores: A number attribute.
    x1: A number attribute.
    x2: A number attribute.
    y1: A number attribute.
    y2: A number attribute.
  """

  classes = _messages.StringField(1, repeated=True)
  entities = _messages.StringField(2, repeated=True)
  scores = _messages.FloatField(3, repeated=True, variant=_messages.Variant.FLOAT)
  x1 = _messages.FloatField(4, variant=_messages.Variant.FLOAT)
  x2 = _messages.FloatField(5, variant=_messages.Variant.FLOAT)
  y1 = _messages.FloatField(6, variant=_messages.Variant.FLOAT)
  y2 = _messages.FloatField(7, variant=_messages.Variant.FLOAT)


class CloudAiLargeModelsVisionRaiInfo(_messages.Message):
  r"""Next ID: 6

  Fields:
    blockedEntities: List of blocked entities from the blocklist if it is
      detected.
    detectedLabels: The list of detected labels for different rai categories.
    modelName: The model name used to indexing into the RaiFilterConfig map.
      Would either be one of imagegeneration@002-006, imagen-3.0-... api
      endpoint names, or internal names used for mapping to different filter
      configs (genselfie, ai_watermark) than its api endpoint.
    raiCategories: List of rai categories' information to return
    scores: List of rai scores mapping to the rai categories. Rounded to 1
      decimal place.
  """

  blockedEntities = _messages.StringField(1, repeated=True)
  detectedLabels = _messages.MessageField('CloudAiLargeModelsVisionRaiInfoDetectedLabels', 2, repeated=True)
  modelName = _messages.StringField(3)
  raiCategories = _messages.StringField(4, repeated=True)
  scores = _messages.FloatField(5, repeated=True, variant=_messages.Variant.FLOAT)


class CloudAiLargeModelsVisionRaiInfoDetectedLabels(_messages.Message):
  r"""Filters returning list of deteceted labels, scores, and bounding boxes.

  Fields:
    entities: The list of detected entities for the rai signal.
    raiCategory: The RAI category for the deteceted labels.
  """

  entities = _messages.MessageField('CloudAiLargeModelsVisionRaiInfoDetectedLabelsEntity', 1, repeated=True)
  raiCategory = _messages.StringField(2)


class CloudAiLargeModelsVisionRaiInfoDetectedLabelsBoundingBox(_messages.Message):
  r"""An integer bounding box of original pixels of the image for the detected
  labels.

  Fields:
    x1: The X coordinate of the top-left corner, in pixels.
    x2: The X coordinate of the bottom-right corner, in pixels.
    y1: The Y coordinate of the top-left corner, in pixels.
    y2: The Y coordinate of the bottom-right corner, in pixels.
  """

  x1 = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  x2 = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  y1 = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  y2 = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class CloudAiLargeModelsVisionRaiInfoDetectedLabelsEntity(_messages.Message):
  r"""The properties for a detected entity from the rai signal.

  Fields:
    boundingBox: Bounding box of the label
    description: Description of the label
    iouScore: The intersection ratio between the detection bounding box and
      the mask.
    mid: MID of the label
    score: Confidence score of the label
  """

  boundingBox = _messages.MessageField('CloudAiLargeModelsVisionRaiInfoDetectedLabelsBoundingBox', 1)
  description = _messages.StringField(2)
  iouScore = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  mid = _messages.StringField(4)
  score = _messages.FloatField(5, variant=_messages.Variant.FLOAT)


class CloudAiLargeModelsVisionSemanticFilterResponse(_messages.Message):
  r"""A CloudAiLargeModelsVisionSemanticFilterResponse object.

  Fields:
    namedBoundingBoxes: Class labels of the bounding boxes that failed the
      semantic filtering. Bounding box coordinates.
    passedSemanticFilter: This response is added when semantic filter config
      is turned on in EditConfig. It reports if this image is passed semantic
      filter response. If passed_semantic_filter is false, the bounding box
      information will be populated for user to check what caused the semantic
      filter to fail.
  """

  namedBoundingBoxes = _messages.MessageField('CloudAiLargeModelsVisionNamedBoundingBox', 1, repeated=True)
  passedSemanticFilter = _messages.BooleanField(2)


class CloudAiLargeModelsVisionVideo(_messages.Message):
  r"""Video

  Fields:
    encodedVideo: Base 64 encoded video bytes.
    encoding: Video encoding, for example "video/mp4".
    text: Text/Expanded text input for Help Me Write.
    uri: Path to another storage (typically Google Cloud Storage).
    video: Raw bytes.
  """

  encodedVideo = _messages.StringField(1)
  encoding = _messages.StringField(2)
  text = _messages.StringField(3)
  uri = _messages.StringField(4)
  video = _messages.BytesField(5)


class CloudAiPlatformCommonCreatePipelineJobApiErrorDetail(_messages.Message):
  r"""Create API error message for Vertex Pipeline.

  Enums:
    ErrorCauseValueValuesEnum: The error root cause returned by
      CreatePipelineJob API.

  Fields:
    errorCause: The error root cause returned by CreatePipelineJob API.
    publicMessage: Public messages contains actionable items for the error
      cause.
  """

  class ErrorCauseValueValuesEnum(_messages.Enum):
    r"""The error root cause returned by CreatePipelineJob API.

    Values:
      ERROR_CAUSE_UNSPECIFIED: Should never be used.
      INVALID_PIPELINE_SPEC_FORMAT: IR Pipeline Spec can not been parsed to
        yaml or json format.
      INVALID_PIPELINE_SPEC: A pipeline spec is invalid.
      INVALID_DEPLOYMENT_CONFIG: A deployment config is invalid.
      INVALID_DEPLOYMENT_SPEC: A deployment spec is invalid.
      INVALID_INSTANCE_SCHEMA: An instance schema is invalid.
      INVALID_CUSTOM_JOB: A custom job is invalid.
      INVALID_CONTAINER_SPEC: A container spec is invalid.
      INVALID_NOTIFICATION_EMAIL_SETUP: Notification email setup is invalid.
      INVALID_SERVICE_ACCOUNT_SETUP: Service account setup is invalid.
      INVALID_KMS_SETUP: KMS setup is invalid.
      INVALID_NETWORK_SETUP: Network setup is invalid.
      INVALID_PIPELINE_TASK_SPEC: Task spec is invalid.
      INVALID_PIPELINE_TASK_ARTIFACT: Task artifact is invalid.
      INVALID_IMPORTER_SPEC: Importer spec is invalid.
      INVALID_RESOLVER_SPEC: Resolver spec is invalid.
      INVALID_RUNTIME_PARAMETERS: Runtime Parameters are invalid.
      CLOUD_API_NOT_ENABLED: Cloud API not enabled.
      INVALID_GCS_INPUT_URI: Invalid Cloud Storage input uri
      INVALID_GCS_OUTPUT_URI: Invalid Cloud Storage output uri
      INVALID_COMPONENT_SPEC: Component spec of pipeline is invalid.
      INVALID_DAG_OUTPUTS_SPEC: DagOutputsSpec is invalid.
      INVALID_DAG_SPEC: DagSpec is invalid.
      INSUFFICIENT_QUOTA: Project does not have enough quota.
      INTERNAL: An internal error with unknown cause.
    """
    ERROR_CAUSE_UNSPECIFIED = 0
    INVALID_PIPELINE_SPEC_FORMAT = 1
    INVALID_PIPELINE_SPEC = 2
    INVALID_DEPLOYMENT_CONFIG = 3
    INVALID_DEPLOYMENT_SPEC = 4
    INVALID_INSTANCE_SCHEMA = 5
    INVALID_CUSTOM_JOB = 6
    INVALID_CONTAINER_SPEC = 7
    INVALID_NOTIFICATION_EMAIL_SETUP = 8
    INVALID_SERVICE_ACCOUNT_SETUP = 9
    INVALID_KMS_SETUP = 10
    INVALID_NETWORK_SETUP = 11
    INVALID_PIPELINE_TASK_SPEC = 12
    INVALID_PIPELINE_TASK_ARTIFACT = 13
    INVALID_IMPORTER_SPEC = 14
    INVALID_RESOLVER_SPEC = 15
    INVALID_RUNTIME_PARAMETERS = 16
    CLOUD_API_NOT_ENABLED = 17
    INVALID_GCS_INPUT_URI = 18
    INVALID_GCS_OUTPUT_URI = 19
    INVALID_COMPONENT_SPEC = 20
    INVALID_DAG_OUTPUTS_SPEC = 21
    INVALID_DAG_SPEC = 22
    INSUFFICIENT_QUOTA = 23
    INTERNAL = 24

  errorCause = _messages.EnumField('ErrorCauseValueValuesEnum', 1)
  publicMessage = _messages.StringField(2)


class GoogleApiHttpBody(_messages.Message):
  r"""Message that represents an arbitrary HTTP body. It should only be used
  for payload formats that can't be represented as JSON, such as raw binary or
  an HTML page. This message can be used both in streaming and non-streaming
  API methods in the request as well as the response. It can be used as a top-
  level request field, which is convenient if one wants to extract parameters
  from either the URL or HTTP template into the request fields and also want
  access to the raw HTTP body. Example: message GetResourceRequest { // A
  unique request id. string request_id = 1; // The raw HTTP body is bound to
  this field. google.api.HttpBody http_body = 2; } service ResourceService {
  rpc GetResource(GetResourceRequest) returns (google.api.HttpBody); rpc
  UpdateResource(google.api.HttpBody) returns (google.protobuf.Empty); }
  Example with streaming methods: service CaldavService { rpc
  GetCalendar(stream google.api.HttpBody) returns (stream
  google.api.HttpBody); rpc UpdateCalendar(stream google.api.HttpBody) returns
  (stream google.api.HttpBody); } Use of this type only changes how the
  request and response bodies are handled, all other features will continue to
  work unchanged.

  Messages:
    ExtensionsValueListEntry: A ExtensionsValueListEntry object.

  Fields:
    contentType: The HTTP Content-Type header value specifying the content
      type of the body.
    data: The HTTP request/response body as raw binary.
    extensions: Application specific response metadata. Must be set in the
      first response for streaming APIs.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ExtensionsValueListEntry(_messages.Message):
    r"""A ExtensionsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a
        ExtensionsValueListEntry object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ExtensionsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  contentType = _messages.StringField(1)
  data = _messages.BytesField(2)
  extensions = _messages.MessageField('ExtensionsValueListEntry', 3, repeated=True)


class GoogleCloudAiplatformV1beta1ActiveLearningConfig(_messages.Message):
  r"""Parameters that configure the active learning pipeline. Active learning
  will label the data incrementally by several iterations. For every
  iteration, it will select a batch of data based on the sampling strategy.

  Fields:
    maxDataItemCount: Max number of human labeled DataItems.
    maxDataItemPercentage: Max percent of total DataItems for human labeling.
    sampleConfig: Active learning data sampling config. For every active
      learning labeling iteration, it will select a batch of data based on the
      sampling strategy.
    trainingConfig: CMLE training config. For every active learning labeling
      iteration, system will train a machine learning model on CMLE. The
      trained model will be used by data sampling algorithm to select
      DataItems.
  """

  maxDataItemCount = _messages.IntegerField(1)
  maxDataItemPercentage = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  sampleConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1SampleConfig', 3)
  trainingConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1TrainingConfig', 4)


class GoogleCloudAiplatformV1beta1AddContextArtifactsAndExecutionsRequest(_messages.Message):
  r"""Request message for MetadataService.AddContextArtifactsAndExecutions.

  Fields:
    artifacts: The resource names of the Artifacts to attribute to the
      Context. Format: `projects/{project}/locations/{location}/metadataStores
      /{metadatastore}/artifacts/{artifact}`
    executions: The resource names of the Executions to associate with the
      Context. Format: `projects/{project}/locations/{location}/metadataStores
      /{metadatastore}/executions/{execution}`
  """

  artifacts = _messages.StringField(1, repeated=True)
  executions = _messages.StringField(2, repeated=True)


class GoogleCloudAiplatformV1beta1AddContextArtifactsAndExecutionsResponse(_messages.Message):
  r"""Response message for MetadataService.AddContextArtifactsAndExecutions.
  """



class GoogleCloudAiplatformV1beta1AddContextChildrenRequest(_messages.Message):
  r"""Request message for MetadataService.AddContextChildren.

  Fields:
    childContexts: The resource names of the child Contexts.
  """

  childContexts = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1beta1AddContextChildrenResponse(_messages.Message):
  r"""Response message for MetadataService.AddContextChildren."""


class GoogleCloudAiplatformV1beta1AddExecutionEventsRequest(_messages.Message):
  r"""Request message for MetadataService.AddExecutionEvents.

  Fields:
    events: The Events to create and add.
  """

  events = _messages.MessageField('GoogleCloudAiplatformV1beta1Event', 1, repeated=True)


class GoogleCloudAiplatformV1beta1AddExecutionEventsResponse(_messages.Message):
  r"""Response message for MetadataService.AddExecutionEvents."""


class GoogleCloudAiplatformV1beta1AddTrialMeasurementRequest(_messages.Message):
  r"""Request message for VizierService.AddTrialMeasurement.

  Fields:
    measurement: Required. The measurement to be added to a Trial.
  """

  measurement = _messages.MessageField('GoogleCloudAiplatformV1beta1Measurement', 1)


class GoogleCloudAiplatformV1beta1Annotation(_messages.Message):
  r"""Used to assign specific AnnotationSpec to a particular area of a
  DataItem or the whole part of the DataItem.

  Messages:
    LabelsValue: Optional. The labels with user-defined metadata to organize
      your Annotations. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one
      Annotation(System labels are excluded). See https://goo.gl/xmQnxf for
      more information and examples of labels. System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable. Following
      system labels exist for each Annotation: *
      "aiplatform.googleapis.com/annotation_set_name": optional, name of the
      UI's annotation set this Annotation belongs to. If not set, the
      Annotation is not visible in the UI. *
      "aiplatform.googleapis.com/payload_schema": output only, its value is
      the payload_schema's title.

  Fields:
    annotationSource: Output only. The source of the Annotation.
    createTime: Output only. Timestamp when this Annotation was created.
    etag: Optional. Used to perform consistent read-modify-write updates. If
      not set, a blind "overwrite" update happens.
    labels: Optional. The labels with user-defined metadata to organize your
      Annotations. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one
      Annotation(System labels are excluded). See https://goo.gl/xmQnxf for
      more information and examples of labels. System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable. Following
      system labels exist for each Annotation: *
      "aiplatform.googleapis.com/annotation_set_name": optional, name of the
      UI's annotation set this Annotation belongs to. If not set, the
      Annotation is not visible in the UI. *
      "aiplatform.googleapis.com/payload_schema": output only, its value is
      the payload_schema's title.
    name: Output only. Resource name of the Annotation.
    payload: Required. The schema of the payload can be found in
      payload_schema.
    payloadSchemaUri: Required. Google Cloud Storage URI points to a YAML file
      describing payload. The schema is defined as an [OpenAPI 3.0.2 Schema
      Object](https://github.com/OAI/OpenAPI-
      Specification/blob/main/versions/3.0.2.md#schemaObject). The schema
      files that can be used here are found in gs://google-cloud-
      aiplatform/schema/dataset/annotation/, note that the chosen schema must
      be consistent with the parent Dataset's metadata.
    updateTime: Output only. Timestamp when this Annotation was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels with user-defined metadata to organize your
    Annotations. Label keys and values can be no longer than 64 characters
    (Unicode codepoints), can only contain lowercase letters, numeric
    characters, underscores and dashes. International characters are allowed.
    No more than 64 user labels can be associated with one Annotation(System
    labels are excluded). See https://goo.gl/xmQnxf for more information and
    examples of labels. System reserved label keys are prefixed with
    "aiplatform.googleapis.com/" and are immutable. Following system labels
    exist for each Annotation: *
    "aiplatform.googleapis.com/annotation_set_name": optional, name of the
    UI's annotation set this Annotation belongs to. If not set, the Annotation
    is not visible in the UI. * "aiplatform.googleapis.com/payload_schema":
    output only, its value is the payload_schema's title.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotationSource = _messages.MessageField('GoogleCloudAiplatformV1beta1UserActionReference', 1)
  createTime = _messages.StringField(2)
  etag = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  payload = _messages.MessageField('extra_types.JsonValue', 6)
  payloadSchemaUri = _messages.StringField(7)
  updateTime = _messages.StringField(8)


class GoogleCloudAiplatformV1beta1AnnotationSpec(_messages.Message):
  r"""Identifies a concept with which DataItems may be annotated with.

  Fields:
    createTime: Output only. Timestamp when this AnnotationSpec was created.
    displayName: Required. The user-defined name of the AnnotationSpec. The
      name can be up to 128 characters long and can consist of any UTF-8
      characters.
    etag: Optional. Used to perform consistent read-modify-write updates. If
      not set, a blind "overwrite" update happens.
    name: Output only. Resource name of the AnnotationSpec.
    updateTime: Output only. Timestamp when AnnotationSpec was last updated.
  """

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  etag = _messages.StringField(3)
  name = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class GoogleCloudAiplatformV1beta1ApiAuth(_messages.Message):
  r"""The generic reusable api auth config. Deprecated. Please use AuthConfig
  (google/cloud/aiplatform/master/auth.proto) instead.

  Fields:
    apiKeyConfig: The API secret.
  """

  apiKeyConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1ApiAuthApiKeyConfig', 1)


class GoogleCloudAiplatformV1beta1ApiAuthApiKeyConfig(_messages.Message):
  r"""The API secret.

  Fields:
    apiKeySecretVersion: Required. The SecretManager secret version resource
      name storing API key. e.g.
      projects/{project}/secrets/{secret}/versions/{version}
  """

  apiKeySecretVersion = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1Artifact(_messages.Message):
  r"""Instance of a general artifact.

  Enums:
    StateValueValuesEnum: The state of this Artifact. This is a property of
      the Artifact, and does not imply or capture any ongoing process. This
      property is managed by clients (such as Vertex AI Pipelines), and the
      system does not prescribe or check the validity of state transitions.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      Artifacts. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one Artifact
      (System labels are excluded).
    MetadataValue: Properties of the Artifact. Top level metadata keys'
      heading and trailing spaces will be trimmed. The size of this field
      should not exceed 200KB.

  Fields:
    createTime: Output only. Timestamp when this Artifact was created.
    description: Description of the Artifact
    displayName: User provided display name of the Artifact. May be up to 128
      Unicode characters.
    etag: An eTag used to perform consistent read-modify-write updates. If not
      set, a blind "overwrite" update happens.
    labels: The labels with user-defined metadata to organize your Artifacts.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. No more
      than 64 user labels can be associated with one Artifact (System labels
      are excluded).
    metadata: Properties of the Artifact. Top level metadata keys' heading and
      trailing spaces will be trimmed. The size of this field should not
      exceed 200KB.
    name: Output only. The resource name of the Artifact.
    schemaTitle: The title of the schema describing the metadata. Schema title
      and version is expected to be registered in earlier Create Schema calls.
      And both are used together as unique identifiers to identify schemas
      within the local metadata store.
    schemaVersion: The version of the schema in schema_name to use. Schema
      title and version is expected to be registered in earlier Create Schema
      calls. And both are used together as unique identifiers to identify
      schemas within the local metadata store.
    state: The state of this Artifact. This is a property of the Artifact, and
      does not imply or capture any ongoing process. This property is managed
      by clients (such as Vertex AI Pipelines), and the system does not
      prescribe or check the validity of state transitions.
    updateTime: Output only. Timestamp when this Artifact was last updated.
    uri: The uniform resource identifier of the artifact file. May be empty if
      there is no actual artifact file.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of this Artifact. This is a property of the Artifact, and
    does not imply or capture any ongoing process. This property is managed by
    clients (such as Vertex AI Pipelines), and the system does not prescribe
    or check the validity of state transitions.

    Values:
      STATE_UNSPECIFIED: Unspecified state for the Artifact.
      PENDING: A state used by systems like Vertex AI Pipelines to indicate
        that the underlying data item represented by this Artifact is being
        created.
      LIVE: A state indicating that the Artifact should exist, unless
        something external to the system deletes it.
    """
    STATE_UNSPECIFIED = 0
    PENDING = 1
    LIVE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your Artifacts.
    Label keys and values can be no longer than 64 characters (Unicode
    codepoints), can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. No more than
    64 user labels can be associated with one Artifact (System labels are
    excluded).

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Properties of the Artifact. Top level metadata keys' heading and
    trailing spaces will be trimmed. The size of this field should not exceed
    200KB.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  etag = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  metadata = _messages.MessageField('MetadataValue', 6)
  name = _messages.StringField(7)
  schemaTitle = _messages.StringField(8)
  schemaVersion = _messages.StringField(9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  updateTime = _messages.StringField(11)
  uri = _messages.StringField(12)


class GoogleCloudAiplatformV1beta1ArtifactTypeSchema(_messages.Message):
  r"""The definition of a artifact type in MLMD.

  Fields:
    instanceSchema: Contains a raw YAML string, describing the format of the
      properties of the type.
    schemaTitle: The name of the type. The format of the title must be: `.`.
      Examples: - `aiplatform.Model` - `acme.CustomModel` When this field is
      set, the type must be pre-registered in the MLMD store.
    schemaUri: Points to a YAML file stored on Cloud Storage describing the
      format. Deprecated. Use PipelineArtifactTypeSchema.schema_title or
      PipelineArtifactTypeSchema.instance_schema instead.
    schemaVersion: The schema version of the artifact. If the value is not
      set, it defaults to the latest version in the system.
  """

  instanceSchema = _messages.StringField(1)
  schemaTitle = _messages.StringField(2)
  schemaUri = _messages.StringField(3)
  schemaVersion = _messages.StringField(4)


class GoogleCloudAiplatformV1beta1AssignNotebookRuntimeOperationMetadata(_messages.Message):
  r"""Metadata information for NotebookService.AssignNotebookRuntime.

  Fields:
    genericMetadata: The operation generic information.
    progressMessage: A human-readable message that shows the intermediate
      progress details of NotebookRuntime.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)
  progressMessage = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1AssignNotebookRuntimeRequest(_messages.Message):
  r"""Request message for NotebookService.AssignNotebookRuntime.

  Fields:
    notebookRuntime: Required. Provide runtime specific information (e.g.
      runtime owner, notebook id) used for NotebookRuntime assignment.
    notebookRuntimeId: Optional. User specified ID for the notebook runtime.
    notebookRuntimeTemplate: Required. The resource name of the
      NotebookRuntimeTemplate based on which a NotebookRuntime will be
      assigned (reuse or create a new one).
  """

  notebookRuntime = _messages.MessageField('GoogleCloudAiplatformV1beta1NotebookRuntime', 1)
  notebookRuntimeId = _messages.StringField(2)
  notebookRuntimeTemplate = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1Attribution(_messages.Message):
  r"""Attribution that explains a particular prediction output.

  Fields:
    approximationError: Output only. Error of feature_attributions caused by
      approximation used in the explanation method. Lower value means more
      precise attributions. * For Sampled Shapley attribution, increasing
      path_count might reduce the error. * For Integrated Gradients
      attribution, increasing step_count might reduce the error. * For XRAI
      attribution, increasing step_count might reduce the error. See [this
      introduction](/vertex-ai/docs/explainable-ai/overview) for more
      information.
    baselineOutputValue: Output only. Model predicted output if the input
      instance is constructed from the baselines of all the features defined
      in ExplanationMetadata.inputs. The field name of the output is
      determined by the key in ExplanationMetadata.outputs. If the Model's
      predicted output has multiple dimensions (rank > 1), this is the value
      in the output located by output_index. If there are multiple baselines,
      their output values are averaged.
    featureAttributions: Output only. Attributions of each explained feature.
      Features are extracted from the prediction instances according to
      explanation metadata for inputs. The value is a struct, whose keys are
      the name of the feature. The values are how much the feature in the
      instance contributed to the predicted result. The format of the value is
      determined by the feature's input format: * If the feature is a scalar
      value, the attribution value is a floating number. * If the feature is
      an array of scalar values, the attribution value is an array. * If the
      feature is a struct, the attribution value is a struct. The keys in the
      attribution value struct are the same as the keys in the feature struct.
      The formats of the values in the attribution struct are determined by
      the formats of the values in the feature struct. The
      ExplanationMetadata.feature_attributions_schema_uri field, pointed to by
      the ExplanationSpec field of the Endpoint.deployed_models object, points
      to the schema file that describes the features and their attribution
      values (if it is populated).
    instanceOutputValue: Output only. Model predicted output on the
      corresponding explanation instance. The field name of the output is
      determined by the key in ExplanationMetadata.outputs. If the Model
      predicted output has multiple dimensions, this is the value in the
      output located by output_index.
    outputDisplayName: Output only. The display name of the output identified
      by output_index. For example, the predicted class name by a multi-
      classification Model. This field is only populated iff the Model
      predicts display names as a separate field along with the explained
      output. The predicted display name must has the same shape of the
      explained output, and can be located using output_index.
    outputIndex: Output only. The index that locates the explained prediction
      output. If the prediction output is a scalar value, output_index is not
      populated. If the prediction output has multiple dimensions, the length
      of the output_index list is the same as the number of dimensions of the
      output. The i-th element in output_index is the element index of the
      i-th dimension of the output vector. Indices start from 0.
    outputName: Output only. Name of the explain output. Specified as the key
      in ExplanationMetadata.outputs.
  """

  approximationError = _messages.FloatField(1)
  baselineOutputValue = _messages.FloatField(2)
  featureAttributions = _messages.MessageField('extra_types.JsonValue', 3)
  instanceOutputValue = _messages.FloatField(4)
  outputDisplayName = _messages.StringField(5)
  outputIndex = _messages.IntegerField(6, repeated=True, variant=_messages.Variant.INT32)
  outputName = _messages.StringField(7)


class GoogleCloudAiplatformV1beta1AugmentPromptRequest(_messages.Message):
  r"""Request message for AugmentPrompt.

  Fields:
    contents: Optional. Input content to augment, only text format is
      supported for now.
    model: Optional. Metadata of the backend deployed model.
    vertexRagStore: Optional. Retrieves contexts from the Vertex RagStore.
  """

  contents = _messages.MessageField('GoogleCloudAiplatformV1beta1Content', 1, repeated=True)
  model = _messages.MessageField('GoogleCloudAiplatformV1beta1AugmentPromptRequestModel', 2)
  vertexRagStore = _messages.MessageField('GoogleCloudAiplatformV1beta1VertexRagStore', 3)


class GoogleCloudAiplatformV1beta1AugmentPromptRequestModel(_messages.Message):
  r"""Metadata of the backend deployed model.

  Fields:
    model: Optional. The model that the user will send the augmented prompt
      for content generation.
    modelVersion: Optional. The model version of the backend deployed model.
  """

  model = _messages.StringField(1)
  modelVersion = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1AugmentPromptResponse(_messages.Message):
  r"""Response message for AugmentPrompt.

  Fields:
    augmentedPrompt: Augmented prompt, only text format is supported for now.
    facts: Retrieved facts from RAG data sources.
  """

  augmentedPrompt = _messages.MessageField('GoogleCloudAiplatformV1beta1Content', 1, repeated=True)
  facts = _messages.MessageField('GoogleCloudAiplatformV1beta1Fact', 2, repeated=True)


class GoogleCloudAiplatformV1beta1AuthConfig(_messages.Message):
  r"""Auth configuration to run the extension.

  Enums:
    AuthTypeValueValuesEnum: Type of auth scheme.

  Fields:
    apiKeyConfig: Config for API key auth.
    authType: Type of auth scheme.
    googleServiceAccountConfig: Config for Google Service Account auth.
    httpBasicAuthConfig: Config for HTTP Basic auth.
    oauthConfig: Config for user oauth.
    oidcConfig: Config for user OIDC auth.
  """

  class AuthTypeValueValuesEnum(_messages.Enum):
    r"""Type of auth scheme.

    Values:
      AUTH_TYPE_UNSPECIFIED: <no description>
      NO_AUTH: No Auth.
      API_KEY_AUTH: API Key Auth.
      HTTP_BASIC_AUTH: HTTP Basic Auth.
      GOOGLE_SERVICE_ACCOUNT_AUTH: Google Service Account Auth.
      OAUTH: OAuth auth.
      OIDC_AUTH: OpenID Connect (OIDC) Auth.
    """
    AUTH_TYPE_UNSPECIFIED = 0
    NO_AUTH = 1
    API_KEY_AUTH = 2
    HTTP_BASIC_AUTH = 3
    GOOGLE_SERVICE_ACCOUNT_AUTH = 4
    OAUTH = 5
    OIDC_AUTH = 6

  apiKeyConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1AuthConfigApiKeyConfig', 1)
  authType = _messages.EnumField('AuthTypeValueValuesEnum', 2)
  googleServiceAccountConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1AuthConfigGoogleServiceAccountConfig', 3)
  httpBasicAuthConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1AuthConfigHttpBasicAuthConfig', 4)
  oauthConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1AuthConfigOauthConfig', 5)
  oidcConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1AuthConfigOidcConfig', 6)


class GoogleCloudAiplatformV1beta1AuthConfigApiKeyConfig(_messages.Message):
  r"""Config for authentication with API key.

  Enums:
    HttpElementLocationValueValuesEnum: Required. The location of the API key.

  Fields:
    apiKeySecret: Optional. The name of the SecretManager secret version
      resource storing the API key. Format:
      `projects/{project}/secrets/{secrete}/versions/{version}` - If both
      `api_key_secret` and `api_key_string` are specified, this field takes
      precedence over `api_key_string`. - If specified, the
      `secretmanager.versions.access` permission should be granted to Vertex
      AI Extension Service Agent (https://cloud.google.com/vertex-
      ai/docs/general/access-control#service-agents) on the specified
      resource.
    apiKeyString: Optional. The API key to be used in the request directly.
    httpElementLocation: Required. The location of the API key.
    name: Required. The parameter name of the API key. E.g. If the API request
      is "https://example.com/act?api_key=", "api_key" would be the parameter
      name.
  """

  class HttpElementLocationValueValuesEnum(_messages.Enum):
    r"""Required. The location of the API key.

    Values:
      HTTP_IN_UNSPECIFIED: <no description>
      HTTP_IN_QUERY: Element is in the HTTP request query.
      HTTP_IN_HEADER: Element is in the HTTP request header.
      HTTP_IN_PATH: Element is in the HTTP request path.
      HTTP_IN_BODY: Element is in the HTTP request body.
      HTTP_IN_COOKIE: Element is in the HTTP request cookie.
    """
    HTTP_IN_UNSPECIFIED = 0
    HTTP_IN_QUERY = 1
    HTTP_IN_HEADER = 2
    HTTP_IN_PATH = 3
    HTTP_IN_BODY = 4
    HTTP_IN_COOKIE = 5

  apiKeySecret = _messages.StringField(1)
  apiKeyString = _messages.StringField(2)
  httpElementLocation = _messages.EnumField('HttpElementLocationValueValuesEnum', 3)
  name = _messages.StringField(4)


class GoogleCloudAiplatformV1beta1AuthConfigGoogleServiceAccountConfig(_messages.Message):
  r"""Config for Google Service Account Authentication.

  Fields:
    serviceAccount: Optional. The service account that the extension execution
      service runs as. - If the service account is specified, the
      `iam.serviceAccounts.getAccessToken` permission should be granted to
      Vertex AI Extension Service Agent (https://cloud.google.com/vertex-
      ai/docs/general/access-control#service-agents) on the specified service
      account. - If not specified, the Vertex AI Extension Service Agent will
      be used to execute the Extension.
  """

  serviceAccount = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1AuthConfigHttpBasicAuthConfig(_messages.Message):
  r"""Config for HTTP Basic Authentication.

  Fields:
    credentialSecret: Required. The name of the SecretManager secret version
      resource storing the base64 encoded credentials. Format:
      `projects/{project}/secrets/{secrete}/versions/{version}` - If
      specified, the `secretmanager.versions.access` permission should be
      granted to Vertex AI Extension Service Agent
      (https://cloud.google.com/vertex-ai/docs/general/access-control#service-
      agents) on the specified resource.
  """

  credentialSecret = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1AuthConfigOauthConfig(_messages.Message):
  r"""Config for user oauth.

  Fields:
    accessToken: Access token for extension endpoint. Only used to propagate
      token from [[ExecuteExtensionRequest.runtime_auth_config]] at request
      time.
    serviceAccount: The service account used to generate access tokens for
      executing the Extension. - If the service account is specified, the
      `iam.serviceAccounts.getAccessToken` permission should be granted to
      Vertex AI Extension Service Agent (https://cloud.google.com/vertex-
      ai/docs/general/access-control#service-agents) on the provided service
      account.
  """

  accessToken = _messages.StringField(1)
  serviceAccount = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1AuthConfigOidcConfig(_messages.Message):
  r"""Config for user OIDC auth.

  Fields:
    idToken: OpenID Connect formatted ID token for extension endpoint. Only
      used to propagate token from
      [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
    serviceAccount: The service account used to generate an OpenID Connect
      (OIDC)-compatible JWT token signed by the Google OIDC Provider
      (accounts.google.com) for extension endpoint
      (https://cloud.google.com/iam/docs/create-short-lived-credentials-
      direct#sa-credentials-oidc). - The audience for the token will be set to
      the URL in the server url defined in the OpenApi spec. - If the service
      account is provided, the service account should grant
      `iam.serviceAccounts.getOpenIdToken` permission to Vertex AI Extension
      Service Agent (https://cloud.google.com/vertex-ai/docs/general/access-
      control#service-agents).
  """

  idToken = _messages.StringField(1)
  serviceAccount = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1AutomaticResources(_messages.Message):
  r"""A description of resources that to large degree are decided by Vertex
  AI, and require only a modest additional configuration. Each Model
  supporting these resources documents its specific guidelines.

  Fields:
    maxReplicaCount: Immutable. The maximum number of replicas that may be
      deployed on when the traffic against it increases. If the requested
      value is too large, the deployment will error, but if deployment
      succeeds then the ability to scale to that many replicas is guaranteed
      (barring service outages). If traffic increases beyond what its replicas
      at maximum may handle, a portion of the traffic will be dropped. If this
      value is not provided, a no upper bound for scaling under heavy traffic
      will be assume, though Vertex AI may be unable to scale beyond certain
      replica number.
    minReplicaCount: Immutable. The minimum number of replicas that will be
      always deployed on. If traffic against it increases, it may dynamically
      be deployed onto more replicas up to max_replica_count, and as traffic
      decreases, some of these extra replicas may be freed. If the requested
      value is too large, the deployment will error.
  """

  maxReplicaCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minReplicaCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1AutoraterConfig(_messages.Message):
  r"""The configs for autorater. This is applicable to both EvaluateInstances
  and EvaluateDataset.

  Fields:
    autoraterModel: Optional. The fully qualified name of the publisher model
      or tuned autorater endpoint to use. Publisher model format:
      `projects/{project}/locations/{location}/publishers/*/models/*` Tuned
      model endpoint format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    flipEnabled: Optional. Whether to flip the candidate and baseline
      responses. This is only applicable to the pairwise metric. If enabled,
      also provide PairwiseMetricSpec.candidate_response_field_name and
      PairwiseMetricSpec.baseline_response_field_name. When rendering
      PairwiseMetricSpec.metric_prompt_template, the candidate and baseline
      fields will be flipped for half of the samples to reduce bias.
    samplingCount: Optional. Number of samples for each instance in the
      dataset. If not specified, the default is 4. Minimum value is 1, maximum
      value is 32.
  """

  autoraterModel = _messages.StringField(1)
  flipEnabled = _messages.BooleanField(2)
  samplingCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1AutoscalingMetricSpec(_messages.Message):
  r"""The metric specification that defines the target resource utilization
  (CPU utilization, accelerator's duty cycle, and so on) for calculating the
  desired replica count.

  Fields:
    metricName: Required. The resource metric name. Supported metrics: * For
      Online Prediction: *
      `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle` *
      `aiplatform.googleapis.com/prediction/online/cpu/utilization`
    target: The target resource utilization in percentage (1% - 100%) for the
      given metric; once the real usage deviates from the target by a certain
      percentage, the machine replicas change. The default value is 60
      (representing 60%) if not provided.
  """

  metricName = _messages.StringField(1)
  target = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1AvroSource(_messages.Message):
  r"""The storage details for Avro input content.

  Fields:
    gcsSource: Required. Google Cloud Storage location.
  """

  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1beta1GcsSource', 1)


class GoogleCloudAiplatformV1beta1BatchCancelPipelineJobsRequest(_messages.Message):
  r"""Request message for PipelineService.BatchCancelPipelineJobs.

  Fields:
    names: Required. The names of the PipelineJobs to cancel. A maximum of 32
      PipelineJobs can be cancelled in a batch. Format:
      `projects/{project}/locations/{location}/pipelineJobs/{pipelineJob}`
  """

  names = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1beta1BatchCancelPipelineJobsResponse(_messages.Message):
  r"""Response message for PipelineService.BatchCancelPipelineJobs.

  Fields:
    pipelineJobs: PipelineJobs cancelled.
  """

  pipelineJobs = _messages.MessageField('GoogleCloudAiplatformV1beta1PipelineJob', 1, repeated=True)


class GoogleCloudAiplatformV1beta1BatchCreateFeaturesOperationMetadata(_messages.Message):
  r"""Details of operations that perform batch create Features.

  Fields:
    genericMetadata: Operation metadata for Feature.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1BatchCreateFeaturesRequest(_messages.Message):
  r"""Request message for FeaturestoreService.BatchCreateFeatures. Request
  message for FeatureRegistryService.BatchCreateFeatures.

  Fields:
    requests: Required. The request message specifying the Features to create.
      All Features must be created under the same parent EntityType /
      FeatureGroup. The `parent` field in each child request message can be
      omitted. If `parent` is set in a child request, then the value must
      match the `parent` value in this request message.
  """

  requests = _messages.MessageField('GoogleCloudAiplatformV1beta1CreateFeatureRequest', 1, repeated=True)


class GoogleCloudAiplatformV1beta1BatchCreateFeaturesResponse(_messages.Message):
  r"""Response message for FeaturestoreService.BatchCreateFeatures.

  Fields:
    features: The Features created.
  """

  features = _messages.MessageField('GoogleCloudAiplatformV1beta1Feature', 1, repeated=True)


class GoogleCloudAiplatformV1beta1BatchCreateTensorboardRunsRequest(_messages.Message):
  r"""Request message for TensorboardService.BatchCreateTensorboardRuns.

  Fields:
    requests: Required. The request message specifying the TensorboardRuns to
      create. A maximum of 1000 TensorboardRuns can be created in a batch.
  """

  requests = _messages.MessageField('GoogleCloudAiplatformV1beta1CreateTensorboardRunRequest', 1, repeated=True)


class GoogleCloudAiplatformV1beta1BatchCreateTensorboardRunsResponse(_messages.Message):
  r"""Response message for TensorboardService.BatchCreateTensorboardRuns.

  Fields:
    tensorboardRuns: The created TensorboardRuns.
  """

  tensorboardRuns = _messages.MessageField('GoogleCloudAiplatformV1beta1TensorboardRun', 1, repeated=True)


class GoogleCloudAiplatformV1beta1BatchCreateTensorboardTimeSeriesRequest(_messages.Message):
  r"""Request message for TensorboardService.BatchCreateTensorboardTimeSeries.

  Fields:
    requests: Required. The request message specifying the
      TensorboardTimeSeries to create. A maximum of 1000 TensorboardTimeSeries
      can be created in a batch.
  """

  requests = _messages.MessageField('GoogleCloudAiplatformV1beta1CreateTensorboardTimeSeriesRequest', 1, repeated=True)


class GoogleCloudAiplatformV1beta1BatchCreateTensorboardTimeSeriesResponse(_messages.Message):
  r"""Response message for
  TensorboardService.BatchCreateTensorboardTimeSeries.

  Fields:
    tensorboardTimeSeries: The created TensorboardTimeSeries.
  """

  tensorboardTimeSeries = _messages.MessageField('GoogleCloudAiplatformV1beta1TensorboardTimeSeries', 1, repeated=True)


class GoogleCloudAiplatformV1beta1BatchDedicatedResources(_messages.Message):
  r"""A description of resources that are used for performing batch
  operations, are dedicated to a Model, and need manual configuration.

  Fields:
    machineSpec: Required. Immutable. The specification of a single machine.
    maxReplicaCount: Immutable. The maximum number of machine replicas the
      batch operation may be scaled to. The default value is 10.
    startingReplicaCount: Immutable. The number of machine replicas used at
      the start of the batch operation. If not set, Vertex AI decides starting
      number, not greater than max_replica_count
  """

  machineSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1MachineSpec', 1)
  maxReplicaCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  startingReplicaCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1BatchDeletePipelineJobsRequest(_messages.Message):
  r"""Request message for PipelineService.BatchDeletePipelineJobs.

  Fields:
    names: Required. The names of the PipelineJobs to delete. A maximum of 32
      PipelineJobs can be deleted in a batch. Format:
      `projects/{project}/locations/{location}/pipelineJobs/{pipelineJob}`
  """

  names = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1beta1BatchDeletePipelineJobsResponse(_messages.Message):
  r"""Response message for PipelineService.BatchDeletePipelineJobs.

  Fields:
    pipelineJobs: PipelineJobs deleted.
  """

  pipelineJobs = _messages.MessageField('GoogleCloudAiplatformV1beta1PipelineJob', 1, repeated=True)


class GoogleCloudAiplatformV1beta1BatchImportEvaluatedAnnotationsRequest(_messages.Message):
  r"""Request message for ModelService.BatchImportEvaluatedAnnotations

  Fields:
    evaluatedAnnotations: Required. Evaluated annotations resource to be
      imported.
  """

  evaluatedAnnotations = _messages.MessageField('GoogleCloudAiplatformV1beta1EvaluatedAnnotation', 1, repeated=True)


class GoogleCloudAiplatformV1beta1BatchImportEvaluatedAnnotationsResponse(_messages.Message):
  r"""Response message for ModelService.BatchImportEvaluatedAnnotations

  Fields:
    importedEvaluatedAnnotationsCount: Output only. Number of
      EvaluatedAnnotations imported.
  """

  importedEvaluatedAnnotationsCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1BatchImportModelEvaluationSlicesRequest(_messages.Message):
  r"""Request message for ModelService.BatchImportModelEvaluationSlices

  Fields:
    modelEvaluationSlices: Required. Model evaluation slice resource to be
      imported.
  """

  modelEvaluationSlices = _messages.MessageField('GoogleCloudAiplatformV1beta1ModelEvaluationSlice', 1, repeated=True)


class GoogleCloudAiplatformV1beta1BatchImportModelEvaluationSlicesResponse(_messages.Message):
  r"""Response message for ModelService.BatchImportModelEvaluationSlices

  Fields:
    importedModelEvaluationSlices: Output only. List of imported
      ModelEvaluationSlice.name.
  """

  importedModelEvaluationSlices = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1beta1BatchMigrateResourcesOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  MigrationService.BatchMigrateResources.

  Fields:
    genericMetadata: The common part of the operation metadata.
    partialResults: Partial results that reflect the latest migration
      operation progress.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)
  partialResults = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchMigrateResourcesOperationMetadataPartialResult', 2, repeated=True)


class GoogleCloudAiplatformV1beta1BatchMigrateResourcesOperationMetadataPartialResult(_messages.Message):
  r"""Represents a partial result in batch migration operation for one
  MigrateResourceRequest.

  Fields:
    dataset: Migrated dataset resource name.
    error: The error result of the migration request in case of failure.
    model: Migrated model resource name.
    request: It's the same as the value in
      BatchMigrateResourcesRequest.migrate_resource_requests.
  """

  dataset = _messages.StringField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  model = _messages.StringField(3)
  request = _messages.MessageField('GoogleCloudAiplatformV1beta1MigrateResourceRequest', 4)


class GoogleCloudAiplatformV1beta1BatchMigrateResourcesRequest(_messages.Message):
  r"""Request message for MigrationService.BatchMigrateResources.

  Fields:
    migrateResourceRequests: Required. The request messages specifying the
      resources to migrate. They must be in the same location as the
      destination. Up to 50 resources can be migrated in one batch.
  """

  migrateResourceRequests = _messages.MessageField('GoogleCloudAiplatformV1beta1MigrateResourceRequest', 1, repeated=True)


class GoogleCloudAiplatformV1beta1BatchMigrateResourcesResponse(_messages.Message):
  r"""Response message for MigrationService.BatchMigrateResources.

  Fields:
    migrateResourceResponses: Successfully migrated resources.
  """

  migrateResourceResponses = _messages.MessageField('GoogleCloudAiplatformV1beta1MigrateResourceResponse', 1, repeated=True)


class GoogleCloudAiplatformV1beta1BatchPredictionJob(_messages.Message):
  r"""A job that uses a Model to produce predictions on multiple input
  instances. If predictions for significant portion of the instances fail, the
  job may finish without attempting predictions for all remaining instances.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the job.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize
      BatchPredictionJobs. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.

  Fields:
    completionStats: Output only. Statistics on completed and failed
      prediction instances.
    createTime: Output only. Time when the BatchPredictionJob was created.
    dedicatedResources: The config of resources used by the Model during the
      batch prediction. If the Model supports DEDICATED_RESOURCES this config
      may be provided (and the job will use these resources), if the Model
      doesn't support AUTOMATIC_RESOURCES, this config must be provided.
    disableContainerLogging: For custom-trained Models and AutoML Tabular
      Models, the container of the DeployedModel instances will send `stderr`
      and `stdout` streams to Cloud Logging by default. Please note that the
      logs incur cost, which are subject to [Cloud Logging
      pricing](https://cloud.google.com/logging/pricing). User can disable
      container logging by setting this flag to true.
    displayName: Required. The user-defined name of this BatchPredictionJob.
    encryptionSpec: Customer-managed encryption key options for a
      BatchPredictionJob. If this is set, then all resources created by the
      BatchPredictionJob will be encrypted with the provided encryption key.
    endTime: Output only. Time when the BatchPredictionJob entered any of the
      following states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`,
      `JOB_STATE_CANCELLED`.
    error: Output only. Only populated when the job's state is
      JOB_STATE_FAILED or JOB_STATE_CANCELLED.
    explanationSpec: Explanation configuration for this BatchPredictionJob.
      Can be specified only if generate_explanation is set to `true`. This
      value overrides the value of Model.explanation_spec. All fields of
      explanation_spec are optional in the request. If a field of the
      explanation_spec object is not populated, the corresponding field of the
      Model.explanation_spec object is inherited.
    generateExplanation: Generate explanation with the batch prediction
      results. When set to `true`, the batch prediction output changes based
      on the `predictions_format` field of the
      BatchPredictionJob.output_config object: * `bigquery`: output includes a
      column named `explanation`. The value is a struct that conforms to the
      Explanation object. * `jsonl`: The JSON objects on each line include an
      additional entry keyed `explanation`. The value of the entry is a JSON
      object that conforms to the Explanation object. * `csv`: Generating
      explanations for CSV format is not supported. If this field is set to
      true, either the Model.explanation_spec or explanation_spec must be
      populated.
    inputConfig: Required. Input configuration of the instances on which
      predictions are performed. The schema of any single instance may be
      specified via the Model's PredictSchemata's instance_schema_uri.
    instanceConfig: Configuration for how to convert batch prediction input
      instances to the prediction instances that are sent to the Model.
    labels: The labels with user-defined metadata to organize
      BatchPredictionJobs. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.
    manualBatchTuningParameters: Immutable. Parameters configuring the batch
      behavior. Currently only applicable when dedicated_resources are used
      (in other cases Vertex AI does the tuning itself).
    model: The name of the Model resource that produces the predictions via
      this job, must share the same ancestor Location. Starting this job has
      no impact on any existing deployments of the Model and their resources.
      Exactly one of model and unmanaged_container_model must be set. The
      model resource name may contain version id or version alias to specify
      the version. Example:
      `projects/{project}/locations/{location}/models/{model}@2` or
      `projects/{project}/locations/{location}/models/{model}@golden` if no
      version is specified, the default version will be deployed. The model
      resource could also be a publisher model. Example:
      `publishers/{publisher}/models/{model}` or `projects/{project}/locations
      /{location}/publishers/{publisher}/models/{model}`
    modelMonitoringConfig: Model monitoring config will be used for analysis
      model behaviors, based on the input and output to the batch prediction
      job, as well as the provided training dataset.
    modelMonitoringStatsAnomalies: Get batch prediction job monitoring
      statistics.
    modelMonitoringStatus: Output only. The running status of the model
      monitoring pipeline.
    modelParameters: The parameters that govern the predictions. The schema of
      the parameters may be specified via the Model's PredictSchemata's
      parameters_schema_uri.
    modelVersionId: Output only. The version ID of the Model that produces the
      predictions via this job.
    name: Output only. Resource name of the BatchPredictionJob.
    outputConfig: Required. The Configuration specifying where output
      predictions should be written. The schema of any single prediction may
      be specified as a concatenation of Model's PredictSchemata's
      instance_schema_uri and prediction_schema_uri.
    outputInfo: Output only. Information further describing the output of this
      job.
    partialFailures: Output only. Partial failures encountered. For example,
      single files that can't be read. This field never exceeds 20 entries.
      Status details fields contain standard Google Cloud error details.
    resourcesConsumed: Output only. Information about resources that had been
      consumed by this job. Provided in real time at best effort basis, as
      well as a final value once the job completes. Note: This field currently
      may be not populated for batch predictions that use AutoML Models.
    satisfiesPzi: Output only. Reserved for future use.
    satisfiesPzs: Output only. Reserved for future use.
    serviceAccount: The service account that the DeployedModel's container
      runs as. If not specified, a system generated one will be used, which
      has minimal permissions and the custom container, if used, may not have
      enough permission to access other Google Cloud resources. Users
      deploying the Model must have the `iam.serviceAccounts.actAs` permission
      on this service account.
    startTime: Output only. Time when the BatchPredictionJob for the first
      time entered the `JOB_STATE_RUNNING` state.
    state: Output only. The detailed state of the job.
    unmanagedContainerModel: Contains model information necessary to perform
      batch prediction without requiring uploading to model registry. Exactly
      one of model and unmanaged_container_model must be set.
    updateTime: Output only. Time when the BatchPredictionJob was most
      recently updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the job.

    Values:
      JOB_STATE_UNSPECIFIED: The job state is unspecified.
      JOB_STATE_QUEUED: The job has been just created or resumed and
        processing has not yet begun.
      JOB_STATE_PENDING: The service is preparing to run the job.
      JOB_STATE_RUNNING: The job is in progress.
      JOB_STATE_SUCCEEDED: The job completed successfully.
      JOB_STATE_FAILED: The job failed.
      JOB_STATE_CANCELLING: The job is being cancelled. From this state the
        job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
        `JOB_STATE_CANCELLED`.
      JOB_STATE_CANCELLED: The job has been cancelled.
      JOB_STATE_PAUSED: The job has been stopped, and can be resumed.
      JOB_STATE_EXPIRED: The job has expired.
      JOB_STATE_UPDATING: The job is being updated. Only jobs in the `RUNNING`
        state can be updated. After updating, the job goes back to the
        `RUNNING` state.
      JOB_STATE_PARTIALLY_SUCCEEDED: The job is partially succeeded, some
        results may be missing due to errors.
    """
    JOB_STATE_UNSPECIFIED = 0
    JOB_STATE_QUEUED = 1
    JOB_STATE_PENDING = 2
    JOB_STATE_RUNNING = 3
    JOB_STATE_SUCCEEDED = 4
    JOB_STATE_FAILED = 5
    JOB_STATE_CANCELLING = 6
    JOB_STATE_CANCELLED = 7
    JOB_STATE_PAUSED = 8
    JOB_STATE_EXPIRED = 9
    JOB_STATE_UPDATING = 10
    JOB_STATE_PARTIALLY_SUCCEEDED = 11

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize BatchPredictionJobs.
    Label keys and values can be no longer than 64 characters (Unicode
    codepoints), can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. See
    https://goo.gl/xmQnxf for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  completionStats = _messages.MessageField('GoogleCloudAiplatformV1beta1CompletionStats', 1)
  createTime = _messages.StringField(2)
  dedicatedResources = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchDedicatedResources', 3)
  disableContainerLogging = _messages.BooleanField(4)
  displayName = _messages.StringField(5)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1EncryptionSpec', 6)
  endTime = _messages.StringField(7)
  error = _messages.MessageField('GoogleRpcStatus', 8)
  explanationSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationSpec', 9)
  generateExplanation = _messages.BooleanField(10)
  inputConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchPredictionJobInputConfig', 11)
  instanceConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchPredictionJobInstanceConfig', 12)
  labels = _messages.MessageField('LabelsValue', 13)
  manualBatchTuningParameters = _messages.MessageField('GoogleCloudAiplatformV1beta1ManualBatchTuningParameters', 14)
  model = _messages.StringField(15)
  modelMonitoringConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1ModelMonitoringConfig', 16)
  modelMonitoringStatsAnomalies = _messages.MessageField('GoogleCloudAiplatformV1beta1ModelMonitoringStatsAnomalies', 17, repeated=True)
  modelMonitoringStatus = _messages.MessageField('GoogleRpcStatus', 18)
  modelParameters = _messages.MessageField('extra_types.JsonValue', 19)
  modelVersionId = _messages.StringField(20)
  name = _messages.StringField(21)
  outputConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchPredictionJobOutputConfig', 22)
  outputInfo = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchPredictionJobOutputInfo', 23)
  partialFailures = _messages.MessageField('GoogleRpcStatus', 24, repeated=True)
  resourcesConsumed = _messages.MessageField('GoogleCloudAiplatformV1beta1ResourcesConsumed', 25)
  satisfiesPzi = _messages.BooleanField(26)
  satisfiesPzs = _messages.BooleanField(27)
  serviceAccount = _messages.StringField(28)
  startTime = _messages.StringField(29)
  state = _messages.EnumField('StateValueValuesEnum', 30)
  unmanagedContainerModel = _messages.MessageField('GoogleCloudAiplatformV1beta1UnmanagedContainerModel', 31)
  updateTime = _messages.StringField(32)


class GoogleCloudAiplatformV1beta1BatchPredictionJobInputConfig(_messages.Message):
  r"""Configures the input to BatchPredictionJob. See
  Model.supported_input_storage_formats for Model's supported input formats,
  and how instances should be expressed via any of them.

  Fields:
    bigquerySource: The BigQuery location of the input table. The schema of
      the table should be in the format described by the given context OpenAPI
      Schema, if one is provided. The table may contain additional columns
      that are not described by the schema, and they will be ignored.
    gcsSource: The Cloud Storage location for the input instances.
    instancesFormat: Required. The format in which instances are given, must
      be one of the Model's supported_input_storage_formats.
  """

  bigquerySource = _messages.MessageField('GoogleCloudAiplatformV1beta1BigQuerySource', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1beta1GcsSource', 2)
  instancesFormat = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1BatchPredictionJobInstanceConfig(_messages.Message):
  r"""Configuration defining how to transform batch prediction input instances
  to the instances that the Model accepts.

  Fields:
    excludedFields: Fields that will be excluded in the prediction instance
      that is sent to the Model. Excluded will be attached to the batch
      prediction output if key_field is not specified. When excluded_fields is
      populated, included_fields must be empty. The input must be JSONL with
      objects at each line, BigQuery or TfRecord.
    includedFields: Fields that will be included in the prediction instance
      that is sent to the Model. If instance_type is `array`, the order of
      field names in included_fields also determines the order of the values
      in the array. When included_fields is populated, excluded_fields must be
      empty. The input must be JSONL with objects at each line, BigQuery or
      TfRecord.
    instanceType: The format of the instance that the Model accepts. Vertex AI
      will convert compatible batch prediction input instance formats to the
      specified format. Supported values are: * `object`: Each input is
      converted to JSON object format. * For `bigquery`, each row is converted
      to an object. * For `jsonl`, each line of the JSONL input must be an
      object. * Does not apply to `csv`, `file-list`, `tf-record`, or `tf-
      record-gzip`. * `array`: Each input is converted to JSON array format. *
      For `bigquery`, each row is converted to an array. The order of columns
      is determined by the BigQuery column order, unless included_fields is
      populated. included_fields must be populated for specifying field
      orders. * For `jsonl`, if each line of the JSONL input is an object,
      included_fields must be populated for specifying field orders. * Does
      not apply to `csv`, `file-list`, `tf-record`, or `tf-record-gzip`. If
      not specified, Vertex AI converts the batch prediction input as follows:
      * For `bigquery` and `csv`, the behavior is the same as `array`. The
      order of columns is the same as defined in the file or table, unless
      included_fields is populated. * For `jsonl`, the prediction instance
      format is determined by each line of the input. * For `tf-record`/`tf-
      record-gzip`, each record will be converted to an object in the format
      of `{"b64": }`, where `` is the Base64-encoded string of the content of
      the record. * For `file-list`, each file in the list will be converted
      to an object in the format of `{"b64": }`, where `` is the
      Base64-encoded string of the content of the file.
    keyField: The name of the field that is considered as a key. The values
      identified by the key field is not included in the transformed instances
      that is sent to the Model. This is similar to specifying this name of
      the field in excluded_fields. In addition, the batch prediction output
      will not include the instances. Instead the output will only include the
      value of the key field, in a field named `key` in the output: * For
      `jsonl` output format, the output will have a `key` field instead of the
      `instance` field. * For `csv`/`bigquery` output format, the output will
      have have a `key` column instead of the instance feature columns. The
      input must be JSONL with objects at each line, CSV, BigQuery or
      TfRecord.
  """

  excludedFields = _messages.StringField(1, repeated=True)
  includedFields = _messages.StringField(2, repeated=True)
  instanceType = _messages.StringField(3)
  keyField = _messages.StringField(4)


class GoogleCloudAiplatformV1beta1BatchPredictionJobOutputConfig(_messages.Message):
  r"""Configures the output of BatchPredictionJob. See
  Model.supported_output_storage_formats for supported output formats, and how
  predictions are expressed via any of them.

  Fields:
    bigqueryDestination: The BigQuery project or dataset location where the
      output is to be written to. If project is provided, a new dataset is
      created with name `prediction__` where is made BigQuery-dataset-name
      compatible (for example, most special characters become underscores),
      and timestamp is in YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format.
      In the dataset two tables will be created, `predictions`, and `errors`.
      If the Model has both instance and prediction schemata defined then the
      tables have columns as follows: The `predictions` table contains
      instances for which the prediction succeeded, it has columns as per a
      concatenation of the Model's instance and prediction schemata. The
      `errors` table contains rows for which the prediction has failed, it has
      instance columns, as per the instance schema, followed by a single
      "errors" column, which as values has google.rpc.Status represented as a
      STRUCT, and containing only `code` and `message`.
    gcsDestination: The Cloud Storage location of the directory where the
      output is to be written to. In the given directory a new directory is
      created. Its name is `prediction--`, where timestamp is in YYYY-MM-
      DDThh:mm:ss.sssZ ISO-8601 format. Inside of it files
      `predictions_0001.`, `predictions_0002.`, ..., `predictions_N.` are
      created where `` depends on chosen predictions_format, and N may equal
      0001 and depends on the total number of successfully predicted
      instances. If the Model has both instance and prediction schemata
      defined then each such file contains predictions as per the
      predictions_format. If prediction for any instance failed (partially or
      completely), then an additional `errors_0001.`, `errors_0002.`,...,
      `errors_N.` files are created (N depends on total number of failed
      predictions). These files contain the failed instances, as per their
      schema, followed by an additional `error` field which as value has
      google.rpc.Status containing only `code` and `message` fields.
    predictionsFormat: Required. The format in which Vertex AI gives the
      predictions, must be one of the Model's
      supported_output_storage_formats.
  """

  bigqueryDestination = _messages.MessageField('GoogleCloudAiplatformV1beta1BigQueryDestination', 1)
  gcsDestination = _messages.MessageField('GoogleCloudAiplatformV1beta1GcsDestination', 2)
  predictionsFormat = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1BatchPredictionJobOutputInfo(_messages.Message):
  r"""Further describes this job's output. Supplements output_config.

  Fields:
    bigqueryOutputDataset: Output only. The path of the BigQuery dataset
      created, in `bq://projectId.bqDatasetId` format, into which the
      prediction output is written.
    bigqueryOutputTable: Output only. The name of the BigQuery table created,
      in `predictions_` format, into which the prediction output is written.
      Can be used by UI to generate the BigQuery output path, for example.
    gcsOutputDirectory: Output only. The full path of the Cloud Storage
      directory created, into which the prediction output is written.
  """

  bigqueryOutputDataset = _messages.StringField(1)
  bigqueryOutputTable = _messages.StringField(2)
  gcsOutputDirectory = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1BatchReadFeatureValuesOperationMetadata(_messages.Message):
  r"""Details of operations that batch reads Feature values.

  Fields:
    genericMetadata: Operation metadata for Featurestore batch read Features
      values.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1BatchReadFeatureValuesRequest(_messages.Message):
  r"""Request message for FeaturestoreService.BatchReadFeatureValues.

  Fields:
    bigqueryReadInstances: Similar to csv_read_instances, but from BigQuery
      source.
    csvReadInstances: Each read instance consists of exactly one read
      timestamp and one or more entity IDs identifying entities of the
      corresponding EntityTypes whose Features are requested. Each output
      instance contains Feature values of requested entities concatenated
      together as of the read time. An example read instance may be
      `foo_entity_id, bar_entity_id, 2020-01-01T10:00:00.123Z`. An example
      output instance may be `foo_entity_id, bar_entity_id,
      2020-01-01T10:00:00.123Z, foo_entity_feature1_value,
      bar_entity_feature2_value`. Timestamp in each read instance must be
      millisecond-aligned. `csv_read_instances` are read instances stored in a
      plain-text CSV file. The header should be: [ENTITY_TYPE_ID1],
      [ENTITY_TYPE_ID2], ..., timestamp The columns can be in any order.
      Values in the timestamp column must use the RFC 3339 format, e.g.
      `2012-07-30T10:43:17.123Z`.
    destination: Required. Specifies output location and format.
    entityTypeSpecs: Required. Specifies EntityType grouping Features to read
      values of and settings.
    passThroughFields: When not empty, the specified fields in the
      *_read_instances source will be joined as-is in the output, in addition
      to those fields from the Featurestore Entity. For BigQuery source, the
      type of the pass-through values will be automatically inferred. For CSV
      source, the pass-through values will be passed as opaque bytes.
    startTime: Optional. Excludes Feature values with feature generation
      timestamp before this timestamp. If not set, retrieve oldest values kept
      in Feature Store. Timestamp, if present, must not have higher than
      millisecond precision.
  """

  bigqueryReadInstances = _messages.MessageField('GoogleCloudAiplatformV1beta1BigQuerySource', 1)
  csvReadInstances = _messages.MessageField('GoogleCloudAiplatformV1beta1CsvSource', 2)
  destination = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureValueDestination', 3)
  entityTypeSpecs = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchReadFeatureValuesRequestEntityTypeSpec', 4, repeated=True)
  passThroughFields = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchReadFeatureValuesRequestPassThroughField', 5, repeated=True)
  startTime = _messages.StringField(6)


class GoogleCloudAiplatformV1beta1BatchReadFeatureValuesRequestEntityTypeSpec(_messages.Message):
  r"""Selects Features of an EntityType to read values of and specifies read
  settings.

  Fields:
    entityTypeId: Required. ID of the EntityType to select Features. The
      EntityType id is the entity_type_id specified during EntityType
      creation.
    featureSelector: Required. Selectors choosing which Feature values to read
      from the EntityType.
    settings: Per-Feature settings for the batch read.
  """

  entityTypeId = _messages.StringField(1)
  featureSelector = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureSelector', 2)
  settings = _messages.MessageField('GoogleCloudAiplatformV1beta1DestinationFeatureSetting', 3, repeated=True)


class GoogleCloudAiplatformV1beta1BatchReadFeatureValuesRequestPassThroughField(_messages.Message):
  r"""Describe pass-through fields in read_instance source.

  Fields:
    fieldName: Required. The name of the field in the CSV header or the name
      of the column in BigQuery table. The naming restriction is the same as
      Feature.name.
  """

  fieldName = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1BatchReadFeatureValuesResponse(_messages.Message):
  r"""Response message for FeaturestoreService.BatchReadFeatureValues."""


class GoogleCloudAiplatformV1beta1BatchReadTensorboardTimeSeriesDataResponse(_messages.Message):
  r"""Response message for
  TensorboardService.BatchReadTensorboardTimeSeriesData.

  Fields:
    timeSeriesData: The returned time series data.
  """

  timeSeriesData = _messages.MessageField('GoogleCloudAiplatformV1beta1TimeSeriesData', 1, repeated=True)


class GoogleCloudAiplatformV1beta1BigQueryDestination(_messages.Message):
  r"""The BigQuery location for the output content.

  Fields:
    outputUri: Required. BigQuery URI to a project or table, up to 2000
      characters long. When only the project is specified, the Dataset and
      Table is created. When the full table reference is specified, the
      Dataset must exist and table must not exist. Accepted forms: * BigQuery
      path. For example: `bq://projectId` or `bq://projectId.bqDatasetId` or
      `bq://projectId.bqDatasetId.bqTableId`.
  """

  outputUri = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1BigQuerySource(_messages.Message):
  r"""The BigQuery location for the input content.

  Fields:
    inputUri: Required. BigQuery URI to a table, up to 2000 characters long.
      Accepted forms: * BigQuery path. For example:
      `bq://projectId.bqDatasetId.bqTableId`.
  """

  inputUri = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1BleuInput(_messages.Message):
  r"""Input for bleu metric.

  Fields:
    instances: Required. Repeated bleu instances.
    metricSpec: Required. Spec for bleu score metric.
  """

  instances = _messages.MessageField('GoogleCloudAiplatformV1beta1BleuInstance', 1, repeated=True)
  metricSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1BleuSpec', 2)


class GoogleCloudAiplatformV1beta1BleuInstance(_messages.Message):
  r"""Spec for bleu instance.

  Fields:
    prediction: Required. Output of the evaluated model.
    reference: Required. Ground truth used to compare against the prediction.
  """

  prediction = _messages.StringField(1)
  reference = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1BleuMetricValue(_messages.Message):
  r"""Bleu metric value for an instance.

  Fields:
    score: Output only. Bleu score.
  """

  score = _messages.FloatField(1, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1beta1BleuResults(_messages.Message):
  r"""Results for bleu metric.

  Fields:
    bleuMetricValues: Output only. Bleu metric values.
  """

  bleuMetricValues = _messages.MessageField('GoogleCloudAiplatformV1beta1BleuMetricValue', 1, repeated=True)


class GoogleCloudAiplatformV1beta1BleuSpec(_messages.Message):
  r"""Spec for bleu score metric - calculates the precision of n-grams in the
  prediction as compared to reference - returns a score ranging between 0 to
  1.

  Fields:
    useEffectiveOrder: Optional. Whether to use_effective_order to compute
      bleu score.
  """

  useEffectiveOrder = _messages.BooleanField(1)


class GoogleCloudAiplatformV1beta1Blob(_messages.Message):
  r"""Content blob.

  Fields:
    data: Required. Raw bytes.
    displayName: Optional. Display name of the blob. Used to provide a label
      or filename to distinguish blobs. This field is only returned in
      PromptMessage for prompt management. It is not currently used in the
      Gemini GenerateContent calls.
    mimeType: Required. The IANA standard MIME type of the source data.
  """

  data = _messages.BytesField(1)
  displayName = _messages.StringField(2)
  mimeType = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1BlurBaselineConfig(_messages.Message):
  r"""Config for blur baseline. When enabled, a linear path from the maximally
  blurred image to the input image is created. Using a blurred baseline
  instead of zero (black image) is motivated by the BlurIG approach explained
  here: https://arxiv.org/abs/2004.03383

  Fields:
    maxBlurSigma: The standard deviation of the blur kernel for the blurred
      baseline. The same blurring parameter is used for both the height and
      the width dimension. If not set, the method defaults to the zero (i.e.
      black for images) baseline.
  """

  maxBlurSigma = _messages.FloatField(1, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1beta1BoolArray(_messages.Message):
  r"""A list of boolean values.

  Fields:
    values: A list of bool values.
  """

  values = _messages.BooleanField(1, repeated=True)


class GoogleCloudAiplatformV1beta1CacheConfig(_messages.Message):
  r"""Config of GenAI caching features. This is a singleton resource.

  Fields:
    disableCache: If set to true, disables GenAI caching. Otherwise caching is
      enabled.
    name: Identifier. Name of the cache config. Format: -
      `projects/{project}/cacheConfig`.
  """

  disableCache = _messages.BooleanField(1)
  name = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1CachedContent(_messages.Message):
  r"""A resource used in LLM queries for users to explicitly specify what to
  cache and how to cache.

  Fields:
    contents: Optional. Input only. Immutable. The content to cache
    createTime: Output only. Creation time of the cache entry.
    displayName: Optional. Immutable. The user-generated meaningful display
      name of the cached content.
    expireTime: Timestamp of when this resource is considered expired. This is
      *always* provided on output, regardless of what was sent on input.
    model: Immutable. The name of the `Model` to use for cached content.
      Currently, only the published Gemini base models are supported, in form
      of
      projects/{PROJECT}/locations/{LOCATION}/publishers/google/models/{MODEL}
    name: Immutable. Identifier. The server-generated resource name of the
      cached content Format:
      projects/{project}/locations/{location}/cachedContents/{cached_content}
    systemInstruction: Optional. Input only. Immutable. Developer set system
      instruction. Currently, text only
    toolConfig: Optional. Input only. Immutable. Tool config. This config is
      shared for all tools
    tools: Optional. Input only. Immutable. A list of `Tools` the model may
      use to generate the next response
    ttl: Input only. The TTL for this resource. The expiration time is
      computed: now + TTL.
    updateTime: Output only. When the cache entry was last updated in UTC
      time.
    usageMetadata: Output only. Metadata on the usage of the cached content.
  """

  contents = _messages.MessageField('GoogleCloudAiplatformV1beta1Content', 1, repeated=True)
  createTime = _messages.StringField(2)
  displayName = _messages.StringField(3)
  expireTime = _messages.StringField(4)
  model = _messages.StringField(5)
  name = _messages.StringField(6)
  systemInstruction = _messages.MessageField('GoogleCloudAiplatformV1beta1Content', 7)
  toolConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1ToolConfig', 8)
  tools = _messages.MessageField('GoogleCloudAiplatformV1beta1Tool', 9, repeated=True)
  ttl = _messages.StringField(10)
  updateTime = _messages.StringField(11)
  usageMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1CachedContentUsageMetadata', 12)


class GoogleCloudAiplatformV1beta1CachedContentUsageMetadata(_messages.Message):
  r"""Metadata on the usage of the cached content.

  Fields:
    audioDurationSeconds: Duration of audio in seconds.
    imageCount: Number of images.
    textCount: Number of text characters.
    totalTokenCount: Total number of tokens that the cached content consumes.
    videoDurationSeconds: Duration of video in seconds.
  """

  audioDurationSeconds = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  imageCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  textCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  totalTokenCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  videoDurationSeconds = _messages.IntegerField(5, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1CancelBatchPredictionJobRequest(_messages.Message):
  r"""Request message for JobService.CancelBatchPredictionJob."""


class GoogleCloudAiplatformV1beta1CancelCustomJobRequest(_messages.Message):
  r"""Request message for JobService.CancelCustomJob."""


class GoogleCloudAiplatformV1beta1CancelDataLabelingJobRequest(_messages.Message):
  r"""Request message for JobService.CancelDataLabelingJob."""


class GoogleCloudAiplatformV1beta1CancelHyperparameterTuningJobRequest(_messages.Message):
  r"""Request message for JobService.CancelHyperparameterTuningJob."""


class GoogleCloudAiplatformV1beta1CancelNasJobRequest(_messages.Message):
  r"""Request message for JobService.CancelNasJob."""


class GoogleCloudAiplatformV1beta1CancelPipelineJobRequest(_messages.Message):
  r"""Request message for PipelineService.CancelPipelineJob."""


class GoogleCloudAiplatformV1beta1CancelServerlessRayJobRequest(_messages.Message):
  r"""Request message for JobService.CancelServerlessRayJob."""


class GoogleCloudAiplatformV1beta1CancelServerlessRayJobResponse(_messages.Message):
  r"""Message for JobService.CancelServerlessRayJob response."""


class GoogleCloudAiplatformV1beta1CancelTrainingPipelineRequest(_messages.Message):
  r"""Request message for PipelineService.CancelTrainingPipeline."""


class GoogleCloudAiplatformV1beta1CancelTuningJobRequest(_messages.Message):
  r"""Request message for GenAiTuningService.CancelTuningJob."""


class GoogleCloudAiplatformV1beta1Candidate(_messages.Message):
  r"""A response candidate generated from the model.

  Enums:
    FinishReasonValueValuesEnum: Output only. The reason why the model stopped
      generating tokens. If empty, the model has not stopped generating the
      tokens.

  Fields:
    avgLogprobs: Output only. Average log probability score of the candidate.
    citationMetadata: Output only. Source attribution of the generated
      content.
    content: Output only. Content parts of the candidate.
    finishMessage: Output only. Describes the reason the mode stopped
      generating tokens in more detail. This is only filled when
      `finish_reason` is set.
    finishReason: Output only. The reason why the model stopped generating
      tokens. If empty, the model has not stopped generating the tokens.
    groundingMetadata: Output only. Metadata specifies sources used to ground
      generated content.
    index: Output only. Index of the candidate.
    logprobsResult: Output only. Log-likelihood scores for the response tokens
      and top tokens
    safetyRatings: Output only. List of ratings for the safety of a response
      candidate. There is at most one rating per category.
  """

  class FinishReasonValueValuesEnum(_messages.Enum):
    r"""Output only. The reason why the model stopped generating tokens. If
    empty, the model has not stopped generating the tokens.

    Values:
      FINISH_REASON_UNSPECIFIED: The finish reason is unspecified.
      STOP: Token generation reached a natural stopping point or a configured
        stop sequence.
      MAX_TOKENS: Token generation reached the configured maximum output
        tokens.
      SAFETY: Token generation stopped because the content potentially
        contains safety violations. NOTE: When streaming, content is empty if
        content filters blocks the output.
      RECITATION: The token generation stopped because of potential
        recitation.
      OTHER: All other reasons that stopped the token generation.
      BLOCKLIST: Token generation stopped because the content contains
        forbidden terms.
      PROHIBITED_CONTENT: Token generation stopped for potentially containing
        prohibited content.
      SPII: Token generation stopped because the content potentially contains
        Sensitive Personally Identifiable Information (SPII).
      MALFORMED_FUNCTION_CALL: The function call generated by the model is
        invalid.
    """
    FINISH_REASON_UNSPECIFIED = 0
    STOP = 1
    MAX_TOKENS = 2
    SAFETY = 3
    RECITATION = 4
    OTHER = 5
    BLOCKLIST = 6
    PROHIBITED_CONTENT = 7
    SPII = 8
    MALFORMED_FUNCTION_CALL = 9

  avgLogprobs = _messages.FloatField(1)
  citationMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1CitationMetadata', 2)
  content = _messages.MessageField('GoogleCloudAiplatformV1beta1Content', 3)
  finishMessage = _messages.StringField(4)
  finishReason = _messages.EnumField('FinishReasonValueValuesEnum', 5)
  groundingMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GroundingMetadata', 6)
  index = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  logprobsResult = _messages.MessageField('GoogleCloudAiplatformV1beta1LogprobsResult', 8)
  safetyRatings = _messages.MessageField('GoogleCloudAiplatformV1beta1SafetyRating', 9, repeated=True)


class GoogleCloudAiplatformV1beta1CheckTrialEarlyStoppingStateMetatdata(_messages.Message):
  r"""This message will be placed in the metadata field of a
  google.longrunning.Operation associated with a CheckTrialEarlyStoppingState
  request.

  Fields:
    genericMetadata: Operation metadata for suggesting Trials.
    study: The name of the Study that the Trial belongs to.
    trial: The Trial name.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)
  study = _messages.StringField(2)
  trial = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1CheckTrialEarlyStoppingStateRequest(_messages.Message):
  r"""Request message for VizierService.CheckTrialEarlyStoppingState."""


class GoogleCloudAiplatformV1beta1CheckTrialEarlyStoppingStateResponse(_messages.Message):
  r"""Response message for VizierService.CheckTrialEarlyStoppingState.

  Fields:
    shouldStop: True if the Trial should stop.
  """

  shouldStop = _messages.BooleanField(1)


class GoogleCloudAiplatformV1beta1Citation(_messages.Message):
  r"""Source attributions for content.

  Fields:
    endIndex: Output only. End index into the content.
    license: Output only. License of the attribution.
    publicationDate: Output only. Publication date of the attribution.
    startIndex: Output only. Start index into the content.
    title: Output only. Title of the attribution.
    uri: Output only. Url reference of the attribution.
  """

  endIndex = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  license = _messages.StringField(2)
  publicationDate = _messages.MessageField('GoogleTypeDate', 3)
  startIndex = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  title = _messages.StringField(5)
  uri = _messages.StringField(6)


class GoogleCloudAiplatformV1beta1CitationMetadata(_messages.Message):
  r"""A collection of source attributions for a piece of content.

  Fields:
    citations: Output only. List of citations.
  """

  citations = _messages.MessageField('GoogleCloudAiplatformV1beta1Citation', 1, repeated=True)


class GoogleCloudAiplatformV1beta1Claim(_messages.Message):
  r"""Claim that is extracted from the input text and facts that support it.

  Fields:
    endIndex: Index in the input text where the claim ends (exclusive).
    factIndexes: Indexes of the facts supporting this claim.
    score: Confidence score of this corroboration.
    startIndex: Index in the input text where the claim starts (inclusive).
  """

  endIndex = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  factIndexes = _messages.IntegerField(2, repeated=True, variant=_messages.Variant.INT32)
  score = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  startIndex = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1ClientConnectionConfig(_messages.Message):
  r"""Configurations (e.g. inference timeout) that are applied on your
  endpoints.

  Fields:
    inferenceTimeout: Customizable online prediction request timeout.
  """

  inferenceTimeout = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1CodeExecutionResult(_messages.Message):
  r"""Result of executing the [ExecutableCode]. Always follows a `part`
  containing the [ExecutableCode].

  Enums:
    OutcomeValueValuesEnum: Required. Outcome of the code execution.

  Fields:
    outcome: Required. Outcome of the code execution.
    output: Optional. Contains stdout when code execution is successful,
      stderr or other description otherwise.
  """

  class OutcomeValueValuesEnum(_messages.Enum):
    r"""Required. Outcome of the code execution.

    Values:
      OUTCOME_UNSPECIFIED: Unspecified status. This value should not be used.
      OUTCOME_OK: Code execution completed successfully.
      OUTCOME_FAILED: Code execution finished but with a failure. `stderr`
        should contain the reason.
      OUTCOME_DEADLINE_EXCEEDED: Code execution ran for too long, and was
        cancelled. There may or may not be a partial output present.
    """
    OUTCOME_UNSPECIFIED = 0
    OUTCOME_OK = 1
    OUTCOME_FAILED = 2
    OUTCOME_DEADLINE_EXCEEDED = 3

  outcome = _messages.EnumField('OutcomeValueValuesEnum', 1)
  output = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1CoherenceInput(_messages.Message):
  r"""Input for coherence metric.

  Fields:
    instance: Required. Coherence instance.
    metricSpec: Required. Spec for coherence score metric.
  """

  instance = _messages.MessageField('GoogleCloudAiplatformV1beta1CoherenceInstance', 1)
  metricSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1CoherenceSpec', 2)


class GoogleCloudAiplatformV1beta1CoherenceInstance(_messages.Message):
  r"""Spec for coherence instance.

  Fields:
    prediction: Required. Output of the evaluated model.
  """

  prediction = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1CoherenceResult(_messages.Message):
  r"""Spec for coherence result.

  Fields:
    confidence: Output only. Confidence for coherence score.
    explanation: Output only. Explanation for coherence score.
    score: Output only. Coherence score.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  explanation = _messages.StringField(2)
  score = _messages.FloatField(3, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1beta1CoherenceSpec(_messages.Message):
  r"""Spec for coherence score metric.

  Fields:
    version: Optional. Which version to use for evaluation.
  """

  version = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1CometInput(_messages.Message):
  r"""Input for Comet metric.

  Fields:
    instance: Required. Comet instance.
    metricSpec: Required. Spec for comet metric.
  """

  instance = _messages.MessageField('GoogleCloudAiplatformV1beta1CometInstance', 1)
  metricSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1CometSpec', 2)


class GoogleCloudAiplatformV1beta1CometInstance(_messages.Message):
  r"""Spec for Comet instance - The fields used for evaluation are dependent
  on the comet version.

  Fields:
    prediction: Required. Output of the evaluated model.
    reference: Optional. Ground truth used to compare against the prediction.
    source: Optional. Source text in original language.
  """

  prediction = _messages.StringField(1)
  reference = _messages.StringField(2)
  source = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1CometResult(_messages.Message):
  r"""Spec for Comet result - calculates the comet score for the given
  instance using the version specified in the spec.

  Fields:
    score: Output only. Comet score. Range depends on version.
  """

  score = _messages.FloatField(1, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1beta1CometSpec(_messages.Message):
  r"""Spec for Comet metric.

  Enums:
    VersionValueValuesEnum: Required. Which version to use for evaluation.

  Fields:
    sourceLanguage: Optional. Source language in BCP-47 format.
    targetLanguage: Optional. Target language in BCP-47 format. Covers both
      prediction and reference.
    version: Required. Which version to use for evaluation.
  """

  class VersionValueValuesEnum(_messages.Enum):
    r"""Required. Which version to use for evaluation.

    Values:
      COMET_VERSION_UNSPECIFIED: Comet version unspecified.
      COMET_22_SRC_REF: Comet 22 for translation + source + reference (source-
        reference-combined).
    """
    COMET_VERSION_UNSPECIFIED = 0
    COMET_22_SRC_REF = 1

  sourceLanguage = _messages.StringField(1)
  targetLanguage = _messages.StringField(2)
  version = _messages.EnumField('VersionValueValuesEnum', 3)


class GoogleCloudAiplatformV1beta1CompleteTrialRequest(_messages.Message):
  r"""Request message for VizierService.CompleteTrial.

  Fields:
    finalMeasurement: Optional. If provided, it will be used as the completed
      Trial's final_measurement; Otherwise, the service will auto-select a
      previously reported measurement as the final-measurement
    infeasibleReason: Optional. A human readable reason why the trial was
      infeasible. This should only be provided if `trial_infeasible` is true.
    trialInfeasible: Optional. True if the Trial cannot be run with the given
      Parameter, and final_measurement will be ignored.
  """

  finalMeasurement = _messages.MessageField('GoogleCloudAiplatformV1beta1Measurement', 1)
  infeasibleReason = _messages.StringField(2)
  trialInfeasible = _messages.BooleanField(3)


class GoogleCloudAiplatformV1beta1CompletionStats(_messages.Message):
  r"""Success and error statistics of processing multiple entities (for
  example, DataItems or structured data rows) in batch.

  Fields:
    failedCount: Output only. The number of entities for which any error was
      encountered.
    incompleteCount: Output only. In cases when enough errors are encountered
      a job, pipeline, or operation may be failed as a whole. Below is the
      number of entities for which the processing had not been finished
      (either in successful or failed state). Set to -1 if the number is
      unknown (for example, the operation failed before the total entity
      number could be collected).
    successfulCount: Output only. The number of entities that had been
      processed successfully.
    successfulForecastPointCount: Output only. The number of the successful
      forecast points that are generated by the forecasting model. This is
      ONLY used by the forecasting batch prediction.
  """

  failedCount = _messages.IntegerField(1)
  incompleteCount = _messages.IntegerField(2)
  successfulCount = _messages.IntegerField(3)
  successfulForecastPointCount = _messages.IntegerField(4)


class GoogleCloudAiplatformV1beta1ComputeTokensRequest(_messages.Message):
  r"""Request message for ComputeTokens RPC call.

  Fields:
    contents: Optional. Input content.
    instances: Optional. The instances that are the input to token computing
      API call. Schema is identical to the prediction schema of the text
      model, even for the non-text models, like chat models, or Codey models.
    model: Optional. The name of the publisher model requested to serve the
      prediction. Format:
      projects/{project}/locations/{location}/publishers/*/models/*
  """

  contents = _messages.MessageField('GoogleCloudAiplatformV1beta1Content', 1, repeated=True)
  instances = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)
  model = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1ComputeTokensResponse(_messages.Message):
  r"""Response message for ComputeTokens RPC call.

  Fields:
    tokensInfo: Lists of tokens info from the input. A ComputeTokensRequest
      could have multiple instances with a prompt in each instance. We also
      need to return lists of tokens info for the request with multiple
      instances.
  """

  tokensInfo = _messages.MessageField('GoogleCloudAiplatformV1beta1TokensInfo', 1, repeated=True)


class GoogleCloudAiplatformV1beta1ContainerRegistryDestination(_messages.Message):
  r"""The Container Registry location for the container image.

  Fields:
    outputUri: Required. Container Registry URI of a container image. Only
      Google Container Registry and Artifact Registry are supported now.
      Accepted forms: * Google Container Registry path. For example:
      `gcr.io/projectId/imageName:tag`. * Artifact Registry path. For example:
      `us-central1-docker.pkg.dev/projectId/repoName/imageName:tag`. If a tag
      is not specified, "latest" will be used as the default tag.
  """

  outputUri = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1ContainerSpec(_messages.Message):
  r"""The spec of a Container.

  Fields:
    args: The arguments to be passed when starting the container.
    command: The command to be invoked when the container is started. It
      overrides the entrypoint instruction in Dockerfile when provided.
    env: Environment variables to be passed to the container. Maximum limit is
      100.
    imageUri: Required. The URI of a container image in the Container Registry
      that is to be run on each worker replica.
  """

  args = _messages.StringField(1, repeated=True)
  command = _messages.StringField(2, repeated=True)
  env = _messages.MessageField('GoogleCloudAiplatformV1beta1EnvVar', 3, repeated=True)
  imageUri = _messages.StringField(4)


class GoogleCloudAiplatformV1beta1Content(_messages.Message):
  r"""The base structured datatype containing multi-part content of a message.
  A `Content` includes a `role` field designating the producer of the
  `Content` and a `parts` field containing multi-part data that contains the
  content of the message turn.

  Fields:
    parts: Required. Ordered `Parts` that constitute a single message. Parts
      may have different IANA MIME types.
    role: Optional. The producer of the content. Must be either 'user' or
      'model'. Useful to set for multi-turn conversations, otherwise can be
      left blank or unset.
  """

  parts = _messages.MessageField('GoogleCloudAiplatformV1beta1Part', 1, repeated=True)
  role = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1Context(_messages.Message):
  r"""Instance of a general context.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      Contexts. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one Context
      (System labels are excluded).
    MetadataValue: Properties of the Context. Top level metadata keys' heading
      and trailing spaces will be trimmed. The size of this field should not
      exceed 200KB.

  Fields:
    createTime: Output only. Timestamp when this Context was created.
    description: Description of the Context
    displayName: User provided display name of the Context. May be up to 128
      Unicode characters.
    etag: An eTag used to perform consistent read-modify-write updates. If not
      set, a blind "overwrite" update happens.
    labels: The labels with user-defined metadata to organize your Contexts.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. No more
      than 64 user labels can be associated with one Context (System labels
      are excluded).
    metadata: Properties of the Context. Top level metadata keys' heading and
      trailing spaces will be trimmed. The size of this field should not
      exceed 200KB.
    name: Immutable. The resource name of the Context.
    parentContexts: Output only. A list of resource names of Contexts that are
      parents of this Context. A Context may have at most 10 parent_contexts.
    schemaTitle: The title of the schema describing the metadata. Schema title
      and version is expected to be registered in earlier Create Schema calls.
      And both are used together as unique identifiers to identify schemas
      within the local metadata store.
    schemaVersion: The version of the schema in schema_name to use. Schema
      title and version is expected to be registered in earlier Create Schema
      calls. And both are used together as unique identifiers to identify
      schemas within the local metadata store.
    updateTime: Output only. Timestamp when this Context was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your Contexts. Label
    keys and values can be no longer than 64 characters (Unicode codepoints),
    can only contain lowercase letters, numeric characters, underscores and
    dashes. International characters are allowed. No more than 64 user labels
    can be associated with one Context (System labels are excluded).

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Properties of the Context. Top level metadata keys' heading and
    trailing spaces will be trimmed. The size of this field should not exceed
    200KB.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  etag = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  metadata = _messages.MessageField('MetadataValue', 6)
  name = _messages.StringField(7)
  parentContexts = _messages.StringField(8, repeated=True)
  schemaTitle = _messages.StringField(9)
  schemaVersion = _messages.StringField(10)
  updateTime = _messages.StringField(11)


class GoogleCloudAiplatformV1beta1CopyModelOperationMetadata(_messages.Message):
  r"""Details of ModelService.CopyModel operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CopyModelRequest(_messages.Message):
  r"""Request message for ModelService.CopyModel.

  Fields:
    encryptionSpec: Customer-managed encryption key options. If this is set,
      then the Model copy will be encrypted with the provided encryption key.
    modelId: Optional. Copy source_model into a new Model with this ID. The ID
      will become the final component of the model resource name. This value
      may be up to 63 characters, and valid characters are `[a-z0-9_-]`. The
      first character cannot be a number or hyphen.
    parentModel: Optional. Specify this field to copy source_model into this
      existing Model as a new version. Format:
      `projects/{project}/locations/{location}/models/{model}`
    sourceModel: Required. The resource name of the Model to copy. That Model
      must be in the same Project. Format:
      `projects/{project}/locations/{location}/models/{model}`
  """

  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1EncryptionSpec', 1)
  modelId = _messages.StringField(2)
  parentModel = _messages.StringField(3)
  sourceModel = _messages.StringField(4)


class GoogleCloudAiplatformV1beta1CopyModelResponse(_messages.Message):
  r"""Response message of ModelService.CopyModel operation.

  Fields:
    model: The name of the copied Model resource. Format:
      `projects/{project}/locations/{location}/models/{model}`
    modelVersionId: Output only. The version ID of the model that is copied.
  """

  model = _messages.StringField(1)
  modelVersionId = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1CorpusStatus(_messages.Message):
  r"""RagCorpus status.

  Enums:
    StateValueValuesEnum: Output only. RagCorpus life state.

  Fields:
    errorStatus: Output only. Only when the `state` field is ERROR.
    state: Output only. RagCorpus life state.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. RagCorpus life state.

    Values:
      UNKNOWN: This state is not supposed to happen.
      INITIALIZED: RagCorpus resource entry is initialized, but hasn't done
        validation.
      ACTIVE: RagCorpus is provisioned successfully and is ready to serve.
      ERROR: RagCorpus is in a problematic situation. See `error_message`
        field for details.
    """
    UNKNOWN = 0
    INITIALIZED = 1
    ACTIVE = 2
    ERROR = 3

  errorStatus = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class GoogleCloudAiplatformV1beta1CorroborateContentRequest(_messages.Message):
  r"""Request message for CorroborateContent.

  Fields:
    content: Optional. Input content to corroborate, only text format is
      supported for now.
    facts: Optional. Facts used to generate the text can also be used to
      corroborate the text.
    parameters: Optional. Parameters that can be set to override default
      settings per request.
  """

  content = _messages.MessageField('GoogleCloudAiplatformV1beta1Content', 1)
  facts = _messages.MessageField('GoogleCloudAiplatformV1beta1Fact', 2, repeated=True)
  parameters = _messages.MessageField('GoogleCloudAiplatformV1beta1CorroborateContentRequestParameters', 3)


class GoogleCloudAiplatformV1beta1CorroborateContentRequestParameters(_messages.Message):
  r"""Parameters that can be overrided per request.

  Fields:
    citationThreshold: Optional. Only return claims with citation score larger
      than the threshold.
  """

  citationThreshold = _messages.FloatField(1)


class GoogleCloudAiplatformV1beta1CorroborateContentResponse(_messages.Message):
  r"""Response message for CorroborateContent.

  Fields:
    claims: Claims that are extracted from the input content and facts that
      support the claims.
    corroborationScore: Confidence score of corroborating content. Value is
      [0,1] with 1 is the most confidence.
  """

  claims = _messages.MessageField('GoogleCloudAiplatformV1beta1Claim', 1, repeated=True)
  corroborationScore = _messages.FloatField(2, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1beta1CountTokensRequest(_messages.Message):
  r"""Request message for PredictionService.CountTokens.

  Fields:
    contents: Optional. Input content.
    generationConfig: Optional. Generation config that the model will use to
      generate the response.
    instances: Optional. The instances that are the input to token counting
      call. Schema is identical to the prediction schema of the underlying
      model.
    model: Optional. The name of the publisher model requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/publishers/*/models/*`
    systemInstruction: Optional. The user provided system instructions for the
      model. Note: only text should be used in parts and content in each part
      will be in a separate paragraph.
    tools: Optional. A list of `Tools` the model may use to generate the next
      response. A `Tool` is a piece of code that enables the system to
      interact with external systems to perform an action, or set of actions,
      outside of knowledge and scope of the model.
  """

  contents = _messages.MessageField('GoogleCloudAiplatformV1beta1Content', 1, repeated=True)
  generationConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1GenerationConfig', 2)
  instances = _messages.MessageField('extra_types.JsonValue', 3, repeated=True)
  model = _messages.StringField(4)
  systemInstruction = _messages.MessageField('GoogleCloudAiplatformV1beta1Content', 5)
  tools = _messages.MessageField('GoogleCloudAiplatformV1beta1Tool', 6, repeated=True)


class GoogleCloudAiplatformV1beta1CountTokensResponse(_messages.Message):
  r"""Response message for PredictionService.CountTokens.

  Fields:
    promptTokensDetails: Output only. List of modalities that were processed
      in the request input.
    totalBillableCharacters: The total number of billable characters counted
      across all instances from the request.
    totalTokens: The total number of tokens counted across all instances from
      the request.
  """

  promptTokensDetails = _messages.MessageField('GoogleCloudAiplatformV1beta1ModalityTokenCount', 1, repeated=True)
  totalBillableCharacters = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  totalTokens = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1CreateDatasetOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.CreateDataset.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreateDatasetVersionOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.CreateDatasetVersion.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreateDeploymentResourcePoolOperationMetadata(_messages.Message):
  r"""Runtime operation information for CreateDeploymentResourcePool method.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreateDeploymentResourcePoolRequest(_messages.Message):
  r"""Request message for CreateDeploymentResourcePool method.

  Fields:
    deploymentResourcePool: Required. The DeploymentResourcePool to create.
    deploymentResourcePoolId: Required. The ID to use for the
      DeploymentResourcePool, which will become the final component of the
      DeploymentResourcePool's resource name. The maximum length is 63
      characters, and valid characters are
      `/^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$/`.
  """

  deploymentResourcePool = _messages.MessageField('GoogleCloudAiplatformV1beta1DeploymentResourcePool', 1)
  deploymentResourcePoolId = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1CreateEndpointOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.CreateEndpoint.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreateEntityTypeOperationMetadata(_messages.Message):
  r"""Details of operations that perform create EntityType.

  Fields:
    genericMetadata: Operation metadata for EntityType.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreateExtensionControllerOperationMetadata(_messages.Message):
  r"""Details of ExtensionControllerService.CreateExtensionController
  operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreateFeatureGroupOperationMetadata(_messages.Message):
  r"""Details of operations that perform create FeatureGroup.

  Fields:
    genericMetadata: Operation metadata for FeatureGroup.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreateFeatureOnlineStoreOperationMetadata(_messages.Message):
  r"""Details of operations that perform create FeatureOnlineStore.

  Fields:
    genericMetadata: Operation metadata for FeatureOnlineStore.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreateFeatureOperationMetadata(_messages.Message):
  r"""Details of operations that perform create Feature.

  Fields:
    genericMetadata: Operation metadata for Feature.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreateFeatureRequest(_messages.Message):
  r"""Request message for FeaturestoreService.CreateFeature. Request message
  for FeatureRegistryService.CreateFeature.

  Fields:
    feature: Required. The Feature to create.
    featureId: Required. The ID to use for the Feature, which will become the
      final component of the Feature's resource name. This value may be up to
      128 characters, and valid characters are `[a-z0-9_]`. The first
      character cannot be a number. The value must be unique within an
      EntityType/FeatureGroup.
    parent: Required. The resource name of the EntityType or FeatureGroup to
      create a Feature. Format for entity_type as parent: `projects/{project}/
      locations/{location}/featurestores/{featurestore}/entityTypes/{entity_ty
      pe}` Format for feature_group as parent:
      `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  """

  feature = _messages.MessageField('GoogleCloudAiplatformV1beta1Feature', 1)
  featureId = _messages.StringField(2)
  parent = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1CreateFeatureViewOperationMetadata(_messages.Message):
  r"""Details of operations that perform create FeatureView.

  Fields:
    genericMetadata: Operation metadata for FeatureView Create.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreateFeaturestoreOperationMetadata(_messages.Message):
  r"""Details of operations that perform create Featurestore.

  Fields:
    genericMetadata: Operation metadata for Featurestore.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreateIndexEndpointOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  IndexEndpointService.CreateIndexEndpoint.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreateIndexOperationMetadata(_messages.Message):
  r"""Runtime operation information for IndexService.CreateIndex.

  Fields:
    genericMetadata: The operation generic information.
    nearestNeighborSearchOperationMetadata: The operation metadata with regard
      to Matching Engine Index operation.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)
  nearestNeighborSearchOperationMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1NearestNeighborSearchOperationMetadata', 2)


class GoogleCloudAiplatformV1beta1CreateMetadataStoreOperationMetadata(_messages.Message):
  r"""Details of operations that perform MetadataService.CreateMetadataStore.

  Fields:
    genericMetadata: Operation metadata for creating a MetadataStore.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreateModelMonitorOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  ModelMonitoringService.CreateModelMonitor.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreateModelMonitoringJobRequest(_messages.Message):
  r"""Request message for ModelMonitoringService.CreateModelMonitoringJob.

  Fields:
    modelMonitoringJob: Required. The ModelMonitoringJob to create
    modelMonitoringJobId: Optional. The ID to use for the Model Monitoring
      Job, which will become the final component of the model monitoring job
      resource name. The maximum length is 63 characters, and valid characters
      are `/^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$/`.
    parent: Required. The parent of the ModelMonitoringJob. Format:
      `projects/{project}/locations/{location}/modelMoniitors/{model_monitor}`
  """

  modelMonitoringJob = _messages.MessageField('GoogleCloudAiplatformV1beta1ModelMonitoringJob', 1)
  modelMonitoringJobId = _messages.StringField(2)
  parent = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1CreateNotebookExecutionJobOperationMetadata(_messages.Message):
  r"""Metadata information for NotebookService.CreateNotebookExecutionJob.

  Fields:
    genericMetadata: The operation generic information.
    progressMessage: A human-readable message that shows the intermediate
      progress details of NotebookRuntime.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)
  progressMessage = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1CreateNotebookExecutionJobRequest(_messages.Message):
  r"""Request message for [NotebookService.CreateNotebookExecutionJob]

  Fields:
    notebookExecutionJob: Required. The NotebookExecutionJob to create.
    notebookExecutionJobId: Optional. User specified ID for the
      NotebookExecutionJob.
    parent: Required. The resource name of the Location to create the
      NotebookExecutionJob. Format: `projects/{project}/locations/{location}`
  """

  notebookExecutionJob = _messages.MessageField('GoogleCloudAiplatformV1beta1NotebookExecutionJob', 1)
  notebookExecutionJobId = _messages.StringField(2)
  parent = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1CreateNotebookRuntimeTemplateOperationMetadata(_messages.Message):
  r"""Metadata information for NotebookService.CreateNotebookRuntimeTemplate.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreatePersistentResourceOperationMetadata(_messages.Message):
  r"""Details of operations that perform create PersistentResource.

  Fields:
    genericMetadata: Operation metadata for PersistentResource.
    progressMessage: Progress Message for Create LRO
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)
  progressMessage = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1CreatePipelineJobRequest(_messages.Message):
  r"""Request message for PipelineService.CreatePipelineJob.

  Fields:
    parent: Required. The resource name of the Location to create the
      PipelineJob in. Format: `projects/{project}/locations/{location}`
    pipelineJob: Required. The PipelineJob to create.
    pipelineJobId: The ID to use for the PipelineJob, which will become the
      final component of the PipelineJob name. If not provided, an ID will be
      automatically generated. This value should be less than 128 characters,
      and valid characters are `/a-z-/`.
  """

  parent = _messages.StringField(1)
  pipelineJob = _messages.MessageField('GoogleCloudAiplatformV1beta1PipelineJob', 2)
  pipelineJobId = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1CreateRegistryFeatureOperationMetadata(_messages.Message):
  r"""Details of operations that perform create FeatureGroup.

  Fields:
    genericMetadata: Operation metadata for Feature.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreateSolverOperationMetadata(_messages.Message):
  r"""Runtime operation information for SolverService.CreateSolver.

  Fields:
    genericMetadata: The generic operation information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreateSpecialistPoolOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  SpecialistPoolService.CreateSpecialistPool.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreateTensorboardOperationMetadata(_messages.Message):
  r"""Details of operations that perform create Tensorboard.

  Fields:
    genericMetadata: Operation metadata for Tensorboard.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreateTensorboardRunRequest(_messages.Message):
  r"""Request message for TensorboardService.CreateTensorboardRun.

  Fields:
    parent: Required. The resource name of the TensorboardExperiment to create
      the TensorboardRun in. Format: `projects/{project}/locations/{location}/
      tensorboards/{tensorboard}/experiments/{experiment}`
    tensorboardRun: Required. The TensorboardRun to create.
    tensorboardRunId: Required. The ID to use for the Tensorboard run, which
      becomes the final component of the Tensorboard run's resource name. This
      value should be 1-128 characters, and valid characters are `/a-z-/`.
  """

  parent = _messages.StringField(1)
  tensorboardRun = _messages.MessageField('GoogleCloudAiplatformV1beta1TensorboardRun', 2)
  tensorboardRunId = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1CreateTensorboardTimeSeriesRequest(_messages.Message):
  r"""Request message for TensorboardService.CreateTensorboardTimeSeries.

  Fields:
    parent: Required. The resource name of the TensorboardRun to create the
      TensorboardTimeSeries in. Format: `projects/{project}/locations/{locatio
      n}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
    tensorboardTimeSeries: Required. The TensorboardTimeSeries to create.
    tensorboardTimeSeriesId: Optional. The user specified unique ID to use for
      the TensorboardTimeSeries, which becomes the final component of the
      TensorboardTimeSeries's resource name. This value should match
      "a-z0-9{0, 127}"
  """

  parent = _messages.StringField(1)
  tensorboardTimeSeries = _messages.MessageField('GoogleCloudAiplatformV1beta1TensorboardTimeSeries', 2)
  tensorboardTimeSeriesId = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1CsvDestination(_messages.Message):
  r"""The storage details for CSV output content.

  Fields:
    gcsDestination: Required. Google Cloud Storage location.
  """

  gcsDestination = _messages.MessageField('GoogleCloudAiplatformV1beta1GcsDestination', 1)


class GoogleCloudAiplatformV1beta1CsvSource(_messages.Message):
  r"""The storage details for CSV input content.

  Fields:
    gcsSource: Required. Google Cloud Storage location.
  """

  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1beta1GcsSource', 1)


class GoogleCloudAiplatformV1beta1CustomJob(_messages.Message):
  r"""Represents a job that runs custom workloads such as a Docker container
  or a Python package. A CustomJob can have multiple worker pools and each
  worker pool can have its own machine and input spec. A CustomJob will be
  cleaned up once the job enters terminal state (failed or succeeded).

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the job.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize CustomJobs.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. See
      https://goo.gl/xmQnxf for more information and examples of labels.
    WebAccessUrisValue: Output only. URIs for accessing [interactive
      shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-
      interactive-shell) (one URI for each training node). Only available if
      job_spec.enable_web_access is `true`. The keys are names of each node in
      the training job; for example, `workerpool0-0` for the primary node,
      `workerpool1-0` for the first node in the second worker pool, and
      `workerpool1-1` for the second node in the second worker pool. The
      values are the URIs for each node's interactive shell.

  Fields:
    createTime: Output only. Time when the CustomJob was created.
    displayName: Required. The display name of the CustomJob. The name can be
      up to 128 characters long and can consist of any UTF-8 characters.
    encryptionSpec: Customer-managed encryption key options for a CustomJob.
      If this is set, then all resources created by the CustomJob will be
      encrypted with the provided encryption key.
    endTime: Output only. Time when the CustomJob entered any of the following
      states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`,
      `JOB_STATE_CANCELLED`.
    error: Output only. Only populated when job's state is `JOB_STATE_FAILED`
      or `JOB_STATE_CANCELLED`.
    jobSpec: Required. Job spec.
    labels: The labels with user-defined metadata to organize CustomJobs.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. See
      https://goo.gl/xmQnxf for more information and examples of labels.
    name: Output only. Resource name of a CustomJob.
    pubsubTopic: Immutable. The `Topic.name` of the Pub/Sub topic to which to
      publish the update when this job finishes. Must be of the format:
      `projects/{project}/topics/{topic}`. If not provided, such an update
      won't be sent, but the job state can still be polled via
      JobService.GetCustomJob. If a non-existing topic, or a topic to which
      Vertex AI is not allowed to publish to is provided, the job creation
      will succeed, but the update still won't be sent. The update message
      contains as its data a JSON in the following format: ``` { "title": "Job
      state update", "type": "object", "properties": { "job": { "type":
      "string", "description": "The resource name of the job, in
      \"projects/{project}/locations/{location}/custom_jobs/{custom_job}\"
      format, this update pertains to." }, "status": { "type": "string",
      "enum": ["succeeded", "failed", "cancelled", "expired"], "description":
      "The status in which the job finished its execution." } } } ```
    satisfiesPzi: Output only. Reserved for future use.
    satisfiesPzs: Output only. Reserved for future use.
    startTime: Output only. Time when the CustomJob for the first time entered
      the `JOB_STATE_RUNNING` state.
    state: Output only. The detailed state of the job.
    updateTime: Output only. Time when the CustomJob was most recently
      updated.
    webAccessUris: Output only. URIs for accessing [interactive
      shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-
      interactive-shell) (one URI for each training node). Only available if
      job_spec.enable_web_access is `true`. The keys are names of each node in
      the training job; for example, `workerpool0-0` for the primary node,
      `workerpool1-0` for the first node in the second worker pool, and
      `workerpool1-1` for the second node in the second worker pool. The
      values are the URIs for each node's interactive shell.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the job.

    Values:
      JOB_STATE_UNSPECIFIED: The job state is unspecified.
      JOB_STATE_QUEUED: The job has been just created or resumed and
        processing has not yet begun.
      JOB_STATE_PENDING: The service is preparing to run the job.
      JOB_STATE_RUNNING: The job is in progress.
      JOB_STATE_SUCCEEDED: The job completed successfully.
      JOB_STATE_FAILED: The job failed.
      JOB_STATE_CANCELLING: The job is being cancelled. From this state the
        job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
        `JOB_STATE_CANCELLED`.
      JOB_STATE_CANCELLED: The job has been cancelled.
      JOB_STATE_PAUSED: The job has been stopped, and can be resumed.
      JOB_STATE_EXPIRED: The job has expired.
      JOB_STATE_UPDATING: The job is being updated. Only jobs in the `RUNNING`
        state can be updated. After updating, the job goes back to the
        `RUNNING` state.
      JOB_STATE_PARTIALLY_SUCCEEDED: The job is partially succeeded, some
        results may be missing due to errors.
    """
    JOB_STATE_UNSPECIFIED = 0
    JOB_STATE_QUEUED = 1
    JOB_STATE_PENDING = 2
    JOB_STATE_RUNNING = 3
    JOB_STATE_SUCCEEDED = 4
    JOB_STATE_FAILED = 5
    JOB_STATE_CANCELLING = 6
    JOB_STATE_CANCELLED = 7
    JOB_STATE_PAUSED = 8
    JOB_STATE_EXPIRED = 9
    JOB_STATE_UPDATING = 10
    JOB_STATE_PARTIALLY_SUCCEEDED = 11

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize CustomJobs. Label
    keys and values can be no longer than 64 characters (Unicode codepoints),
    can only contain lowercase letters, numeric characters, underscores and
    dashes. International characters are allowed. See https://goo.gl/xmQnxf
    for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class WebAccessUrisValue(_messages.Message):
    r"""Output only. URIs for accessing [interactive
    shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-
    interactive-shell) (one URI for each training node). Only available if
    job_spec.enable_web_access is `true`. The keys are names of each node in
    the training job; for example, `workerpool0-0` for the primary node,
    `workerpool1-0` for the first node in the second worker pool, and
    `workerpool1-1` for the second node in the second worker pool. The values
    are the URIs for each node's interactive shell.

    Messages:
      AdditionalProperty: An additional property for a WebAccessUrisValue
        object.

    Fields:
      additionalProperties: Additional properties of type WebAccessUrisValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a WebAccessUrisValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1EncryptionSpec', 3)
  endTime = _messages.StringField(4)
  error = _messages.MessageField('GoogleRpcStatus', 5)
  jobSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1CustomJobSpec', 6)
  labels = _messages.MessageField('LabelsValue', 7)
  name = _messages.StringField(8)
  pubsubTopic = _messages.StringField(9)
  satisfiesPzi = _messages.BooleanField(10)
  satisfiesPzs = _messages.BooleanField(11)
  startTime = _messages.StringField(12)
  state = _messages.EnumField('StateValueValuesEnum', 13)
  updateTime = _messages.StringField(14)
  webAccessUris = _messages.MessageField('WebAccessUrisValue', 15)


class GoogleCloudAiplatformV1beta1CustomJobSpec(_messages.Message):
  r"""Represents the spec of a CustomJob.

  Fields:
    baseOutputDirectory: The Cloud Storage location to store the output of
      this CustomJob or HyperparameterTuningJob. For HyperparameterTuningJob,
      the baseOutputDirectory of each child CustomJob backing a Trial is set
      to a subdirectory of name id under its parent HyperparameterTuningJob's
      baseOutputDirectory. The following Vertex AI environment variables will
      be passed to containers or python modules when this field is set: For
      CustomJob: * AIP_MODEL_DIR = `/model/` * AIP_CHECKPOINT_DIR =
      `/checkpoints/` * AIP_TENSORBOARD_LOG_DIR = `/logs/` For CustomJob
      backing a Trial of HyperparameterTuningJob: * AIP_MODEL_DIR = `//model/`
      * AIP_CHECKPOINT_DIR = `//checkpoints/` * AIP_TENSORBOARD_LOG_DIR =
      `//logs/`
    enableDashboardAccess: Optional. Whether you want Vertex AI to enable
      access to the customized dashboard in training chief container. If set
      to `true`, you can access the dashboard at the URIs given by
      CustomJob.web_access_uris or Trial.web_access_uris (within
      HyperparameterTuningJob.trials).
    enableWebAccess: Optional. Whether you want Vertex AI to enable
      [interactive shell access](https://cloud.google.com/vertex-
      ai/docs/training/monitor-debug-interactive-shell) to training
      containers. If set to `true`, you can access interactive shells at the
      URIs given by CustomJob.web_access_uris or Trial.web_access_uris (within
      HyperparameterTuningJob.trials).
    experiment: Optional. The Experiment associated with this job. Format: `pr
      ojects/{project}/locations/{location}/metadataStores/{metadataStores}/co
      ntexts/{experiment-name}`
    experimentRun: Optional. The Experiment Run associated with this job.
      Format: `projects/{project}/locations/{location}/metadataStores/{metadat
      aStores}/contexts/{experiment-name}-{experiment-run-name}`
    models: Optional. The name of the Model resources for which to generate a
      mapping to artifact URIs. Applicable only to some of the Google-provided
      custom jobs. Format:
      `projects/{project}/locations/{location}/models/{model}` In order to
      retrieve a specific version of the model, also provide the version ID or
      version alias. Example:
      `projects/{project}/locations/{location}/models/{model}@2` or
      `projects/{project}/locations/{location}/models/{model}@golden` If no
      version ID or alias is specified, the "default" version will be
      returned. The "default" version alias is created for the first version
      of the model, and can be moved to other versions later on. There will be
      exactly one default version.
    network: Optional. The full name of the Compute Engine
      [network](/compute/docs/networks-and-firewalls#networks) to which the
      Job should be peered. For example,
      `projects/12345/global/networks/myVPC`.
      [Format](/compute/docs/reference/rest/v1/networks/insert) is of the form
      `projects/{project}/global/networks/{network}`. Where {project} is a
      project number, as in `12345`, and {network} is a network name. To
      specify this field, you must have already [configured VPC Network
      Peering for Vertex AI](https://cloud.google.com/vertex-
      ai/docs/general/vpc-peering). If this field is left unspecified, the job
      is not peered with any network.
    persistentResourceId: Optional. The ID of the PersistentResource in the
      same Project and Location which to run If this is specified, the job
      will be run on existing machines held by the PersistentResource instead
      of on-demand short-live machines. The network and CMEK configs on the
      job should be consistent with those on the PersistentResource,
      otherwise, the job will be rejected.
    protectedArtifactLocationId: The ID of the location to store protected
      artifacts. e.g. us-central1. Populate only when the location is
      different than CustomJob location. List of supported locations:
      https://cloud.google.com/vertex-ai/docs/general/locations
    pscInterfaceConfig: Optional. Configuration for PSC-I for CustomJob.
    reservedIpRanges: Optional. A list of names for the reserved ip ranges
      under the VPC network that can be used for this job. If set, we will
      deploy the job within the provided ip ranges. Otherwise, the job will be
      deployed to any ip ranges under the provided VPC network. Example:
      ['vertex-ai-ip-range'].
    scheduling: Scheduling options for a CustomJob.
    serviceAccount: Specifies the service account for workload run-as account.
      Users submitting jobs must have act-as permission on this run-as
      account. If unspecified, the [Vertex AI Custom Code Service
      Agent](https://cloud.google.com/vertex-ai/docs/general/access-
      control#service-agents) for the CustomJob's project is used.
    tensorboard: Optional. The name of a Vertex AI Tensorboard resource to
      which this CustomJob will upload Tensorboard logs. Format:
      `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
    workerPoolSpecs: Required. The spec of the worker pools including machine
      type and Docker image. All worker pools except the first one are
      optional and can be skipped by providing an empty value.
  """

  baseOutputDirectory = _messages.MessageField('GoogleCloudAiplatformV1beta1GcsDestination', 1)
  enableDashboardAccess = _messages.BooleanField(2)
  enableWebAccess = _messages.BooleanField(3)
  experiment = _messages.StringField(4)
  experimentRun = _messages.StringField(5)
  models = _messages.StringField(6, repeated=True)
  network = _messages.StringField(7)
  persistentResourceId = _messages.StringField(8)
  protectedArtifactLocationId = _messages.StringField(9)
  pscInterfaceConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1PscInterfaceConfig', 10)
  reservedIpRanges = _messages.StringField(11, repeated=True)
  scheduling = _messages.MessageField('GoogleCloudAiplatformV1beta1Scheduling', 12)
  serviceAccount = _messages.StringField(13)
  tensorboard = _messages.StringField(14)
  workerPoolSpecs = _messages.MessageField('GoogleCloudAiplatformV1beta1WorkerPoolSpec', 15, repeated=True)


class GoogleCloudAiplatformV1beta1DataItem(_messages.Message):
  r"""A piece of data in a Dataset. Could be an image, a video, a document or
  plain text.

  Messages:
    LabelsValue: Optional. The labels with user-defined metadata to organize
      your DataItems. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one
      DataItem(System labels are excluded). See https://goo.gl/xmQnxf for more
      information and examples of labels. System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable.

  Fields:
    createTime: Output only. Timestamp when this DataItem was created.
    etag: Optional. Used to perform consistent read-modify-write updates. If
      not set, a blind "overwrite" update happens.
    labels: Optional. The labels with user-defined metadata to organize your
      DataItems. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one
      DataItem(System labels are excluded). See https://goo.gl/xmQnxf for more
      information and examples of labels. System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable.
    name: Output only. The resource name of the DataItem.
    payload: Required. The data that the DataItem represents (for example, an
      image or a text snippet). The schema of the payload is stored in the
      parent Dataset's metadata schema's dataItemSchemaUri field.
    satisfiesPzi: Output only. Reserved for future use.
    satisfiesPzs: Output only. Reserved for future use.
    updateTime: Output only. Timestamp when this DataItem was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels with user-defined metadata to organize your
    DataItems. Label keys and values can be no longer than 64 characters
    (Unicode codepoints), can only contain lowercase letters, numeric
    characters, underscores and dashes. International characters are allowed.
    No more than 64 user labels can be associated with one DataItem(System
    labels are excluded). See https://goo.gl/xmQnxf for more information and
    examples of labels. System reserved label keys are prefixed with
    "aiplatform.googleapis.com/" and are immutable.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  etag = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  payload = _messages.MessageField('extra_types.JsonValue', 5)
  satisfiesPzi = _messages.BooleanField(6)
  satisfiesPzs = _messages.BooleanField(7)
  updateTime = _messages.StringField(8)


class GoogleCloudAiplatformV1beta1DataItemView(_messages.Message):
  r"""A container for a single DataItem and Annotations on it.

  Fields:
    annotations: The Annotations on the DataItem. If too many Annotations
      should be returned for the DataItem, this field will be truncated per
      annotations_limit in request. If it was, then the
      has_truncated_annotations will be set to true.
    dataItem: The DataItem.
    hasTruncatedAnnotations: True if and only if the Annotations field has
      been truncated. It happens if more Annotations for this DataItem met the
      request's annotation_filter than are allowed to be returned by
      annotations_limit. Note that if Annotations field is not being returned
      due to field mask, then this field will not be set to true no matter how
      many Annotations are there.
  """

  annotations = _messages.MessageField('GoogleCloudAiplatformV1beta1Annotation', 1, repeated=True)
  dataItem = _messages.MessageField('GoogleCloudAiplatformV1beta1DataItem', 2)
  hasTruncatedAnnotations = _messages.BooleanField(3)


class GoogleCloudAiplatformV1beta1DataLabelingJob(_messages.Message):
  r"""DataLabelingJob is used to trigger a human labeling job on unlabeled
  data from the following Dataset:

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the job.

  Messages:
    AnnotationLabelsValue: Labels to assign to annotations generated by this
      DataLabelingJob. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable.
    LabelsValue: The labels with user-defined metadata to organize your
      DataLabelingJobs. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable. Following system labels
      exist for each DataLabelingJob: * "aiplatform.googleapis.com/schema":
      output only, its value is the inputs_schema's title.

  Fields:
    activeLearningConfig: Parameters that configure the active learning
      pipeline. Active learning will label the data incrementally via several
      iterations. For every iteration, it will select a batch of data based on
      the sampling strategy.
    annotationLabels: Labels to assign to annotations generated by this
      DataLabelingJob. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable.
    createTime: Output only. Timestamp when this DataLabelingJob was created.
    currentSpend: Output only. Estimated cost(in US dollars) that the
      DataLabelingJob has incurred to date.
    datasets: Required. Dataset resource names. Right now we only support
      labeling from a single Dataset. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
    displayName: Required. The user-defined name of the DataLabelingJob. The
      name can be up to 128 characters long and can consist of any UTF-8
      characters. Display name of a DataLabelingJob.
    encryptionSpec: Customer-managed encryption key spec for a
      DataLabelingJob. If set, this DataLabelingJob will be secured by this
      key. Note: Annotations created in the DataLabelingJob are associated
      with the EncryptionSpec of the Dataset they are exported to.
    error: Output only. DataLabelingJob errors. It is only populated when
      job's state is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
    inputs: Required. Input config parameters for the DataLabelingJob.
    inputsSchemaUri: Required. Points to a YAML file stored on Google Cloud
      Storage describing the config for a specific type of DataLabelingJob.
      The schema files that can be used here are found in the
      https://storage.googleapis.com/google-cloud-aiplatform bucket in the
      /schema/datalabelingjob/inputs/ folder.
    instructionUri: Required. The Google Cloud Storage location of the
      instruction pdf. This pdf is shared with labelers, and provides detailed
      description on how to label DataItems in Datasets.
    labelerCount: Required. Number of labelers to work on each DataItem.
    labelingProgress: Output only. Current labeling job progress percentage
      scaled in interval [0, 100], indicating the percentage of DataItems that
      has been finished.
    labels: The labels with user-defined metadata to organize your
      DataLabelingJobs. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable. Following system labels
      exist for each DataLabelingJob: * "aiplatform.googleapis.com/schema":
      output only, its value is the inputs_schema's title.
    name: Output only. Resource name of the DataLabelingJob.
    specialistPools: The SpecialistPools' resource names associated with this
      job.
    state: Output only. The detailed state of the job.
    updateTime: Output only. Timestamp when this DataLabelingJob was updated
      most recently.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the job.

    Values:
      JOB_STATE_UNSPECIFIED: The job state is unspecified.
      JOB_STATE_QUEUED: The job has been just created or resumed and
        processing has not yet begun.
      JOB_STATE_PENDING: The service is preparing to run the job.
      JOB_STATE_RUNNING: The job is in progress.
      JOB_STATE_SUCCEEDED: The job completed successfully.
      JOB_STATE_FAILED: The job failed.
      JOB_STATE_CANCELLING: The job is being cancelled. From this state the
        job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
        `JOB_STATE_CANCELLED`.
      JOB_STATE_CANCELLED: The job has been cancelled.
      JOB_STATE_PAUSED: The job has been stopped, and can be resumed.
      JOB_STATE_EXPIRED: The job has expired.
      JOB_STATE_UPDATING: The job is being updated. Only jobs in the `RUNNING`
        state can be updated. After updating, the job goes back to the
        `RUNNING` state.
      JOB_STATE_PARTIALLY_SUCCEEDED: The job is partially succeeded, some
        results may be missing due to errors.
    """
    JOB_STATE_UNSPECIFIED = 0
    JOB_STATE_QUEUED = 1
    JOB_STATE_PENDING = 2
    JOB_STATE_RUNNING = 3
    JOB_STATE_SUCCEEDED = 4
    JOB_STATE_FAILED = 5
    JOB_STATE_CANCELLING = 6
    JOB_STATE_CANCELLED = 7
    JOB_STATE_PAUSED = 8
    JOB_STATE_EXPIRED = 9
    JOB_STATE_UPDATING = 10
    JOB_STATE_PARTIALLY_SUCCEEDED = 11

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationLabelsValue(_messages.Message):
    r"""Labels to assign to annotations generated by this DataLabelingJob.
    Label keys and values can be no longer than 64 characters (Unicode
    codepoints), can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. See
    https://goo.gl/xmQnxf for more information and examples of labels. System
    reserved label keys are prefixed with "aiplatform.googleapis.com/" and are
    immutable.

    Messages:
      AdditionalProperty: An additional property for a AnnotationLabelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        AnnotationLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your
    DataLabelingJobs. Label keys and values can be no longer than 64
    characters (Unicode codepoints), can only contain lowercase letters,
    numeric characters, underscores and dashes. International characters are
    allowed. See https://goo.gl/xmQnxf for more information and examples of
    labels. System reserved label keys are prefixed with
    "aiplatform.googleapis.com/" and are immutable. Following system labels
    exist for each DataLabelingJob: * "aiplatform.googleapis.com/schema":
    output only, its value is the inputs_schema's title.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  activeLearningConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1ActiveLearningConfig', 1)
  annotationLabels = _messages.MessageField('AnnotationLabelsValue', 2)
  createTime = _messages.StringField(3)
  currentSpend = _messages.MessageField('GoogleTypeMoney', 4)
  datasets = _messages.StringField(5, repeated=True)
  displayName = _messages.StringField(6)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1EncryptionSpec', 7)
  error = _messages.MessageField('GoogleRpcStatus', 8)
  inputs = _messages.MessageField('extra_types.JsonValue', 9)
  inputsSchemaUri = _messages.StringField(10)
  instructionUri = _messages.StringField(11)
  labelerCount = _messages.IntegerField(12, variant=_messages.Variant.INT32)
  labelingProgress = _messages.IntegerField(13, variant=_messages.Variant.INT32)
  labels = _messages.MessageField('LabelsValue', 14)
  name = _messages.StringField(15)
  specialistPools = _messages.StringField(16, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 17)
  updateTime = _messages.StringField(18)


class GoogleCloudAiplatformV1beta1Dataset(_messages.Message):
  r"""A collection of DataItems and Annotations on them.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      Datasets. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one Dataset
      (System labels are excluded). See https://goo.gl/xmQnxf for more
      information and examples of labels. System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable. Following
      system labels exist for each Dataset: *
      "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
      value is the metadata_schema's title.

  Fields:
    createTime: Output only. Timestamp when this Dataset was created.
    dataItemCount: Output only. The number of DataItems in this Dataset. Only
      apply for non-structured Dataset.
    description: The description of the Dataset.
    displayName: Required. The user-defined name of the Dataset. The name can
      be up to 128 characters long and can consist of any UTF-8 characters.
    encryptionSpec: Customer-managed encryption key spec for a Dataset. If
      set, this Dataset and all sub-resources of this Dataset will be secured
      by this key.
    etag: Used to perform consistent read-modify-write updates. If not set, a
      blind "overwrite" update happens.
    labels: The labels with user-defined metadata to organize your Datasets.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. No more
      than 64 user labels can be associated with one Dataset (System labels
      are excluded). See https://goo.gl/xmQnxf for more information and
      examples of labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable. Following system labels
      exist for each Dataset: *
      "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
      value is the metadata_schema's title.
    metadata: Required. Additional information about the Dataset.
    metadataArtifact: Output only. The resource name of the Artifact that was
      created in MetadataStore when creating the Dataset. The Artifact
      resource name pattern is `projects/{project}/locations/{location}/metada
      taStores/{metadata_store}/artifacts/{artifact}`.
    metadataSchemaUri: Required. Points to a YAML file stored on Google Cloud
      Storage describing additional information about the Dataset. The schema
      is defined as an OpenAPI 3.0.2 Schema Object. The schema files that can
      be used here are found in gs://google-cloud-
      aiplatform/schema/dataset/metadata/.
    modelReference: Optional. Reference to the public base model last used by
      the dataset. Only set for prompt datasets.
    name: Output only. Identifier. The resource name of the Dataset. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
    satisfiesPzi: Output only. Reserved for future use.
    satisfiesPzs: Output only. Reserved for future use.
    savedQueries: All SavedQueries belong to the Dataset will be returned in
      List/Get Dataset response. The annotation_specs field will not be
      populated except for UI cases which will only use annotation_spec_count.
      In CreateDataset request, a SavedQuery is created together if this field
      is set, up to one SavedQuery can be set in CreateDatasetRequest. The
      SavedQuery should not contain any AnnotationSpec.
    updateTime: Output only. Timestamp when this Dataset was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your Datasets. Label
    keys and values can be no longer than 64 characters (Unicode codepoints),
    can only contain lowercase letters, numeric characters, underscores and
    dashes. International characters are allowed. No more than 64 user labels
    can be associated with one Dataset (System labels are excluded). See
    https://goo.gl/xmQnxf for more information and examples of labels. System
    reserved label keys are prefixed with "aiplatform.googleapis.com/" and are
    immutable. Following system labels exist for each Dataset: *
    "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
    value is the metadata_schema's title.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  dataItemCount = _messages.IntegerField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1EncryptionSpec', 5)
  etag = _messages.StringField(6)
  labels = _messages.MessageField('LabelsValue', 7)
  metadata = _messages.MessageField('extra_types.JsonValue', 8)
  metadataArtifact = _messages.StringField(9)
  metadataSchemaUri = _messages.StringField(10)
  modelReference = _messages.StringField(11)
  name = _messages.StringField(12)
  satisfiesPzi = _messages.BooleanField(13)
  satisfiesPzs = _messages.BooleanField(14)
  savedQueries = _messages.MessageField('GoogleCloudAiplatformV1beta1SavedQuery', 15, repeated=True)
  updateTime = _messages.StringField(16)


class GoogleCloudAiplatformV1beta1DatasetDistribution(_messages.Message):
  r"""Distribution computed over a tuning dataset.

  Fields:
    buckets: Output only. Defines the histogram bucket.
    max: Output only. The maximum of the population values.
    mean: Output only. The arithmetic mean of the values in the population.
    median: Output only. The median of the values in the population.
    min: Output only. The minimum of the population values.
    p5: Output only. The 5th percentile of the values in the population.
    p95: Output only. The 95th percentile of the values in the population.
    sum: Output only. Sum of a given population of values.
  """

  buckets = _messages.MessageField('GoogleCloudAiplatformV1beta1DatasetDistributionDistributionBucket', 1, repeated=True)
  max = _messages.FloatField(2)
  mean = _messages.FloatField(3)
  median = _messages.FloatField(4)
  min = _messages.FloatField(5)
  p5 = _messages.FloatField(6)
  p95 = _messages.FloatField(7)
  sum = _messages.FloatField(8)


class GoogleCloudAiplatformV1beta1DatasetDistributionDistributionBucket(_messages.Message):
  r"""Dataset bucket used to create a histogram for the distribution given a
  population of values.

  Fields:
    count: Output only. Number of values in the bucket.
    left: Output only. Left bound of the bucket.
    right: Output only. Right bound of the bucket.
  """

  count = _messages.IntegerField(1)
  left = _messages.FloatField(2)
  right = _messages.FloatField(3)


class GoogleCloudAiplatformV1beta1DatasetStats(_messages.Message):
  r"""Statistics computed over a tuning dataset.

  Fields:
    totalBillableCharacterCount: Output only. Number of billable characters in
      the tuning dataset.
    totalTuningCharacterCount: Output only. Number of tuning characters in the
      tuning dataset.
    tuningDatasetExampleCount: Output only. Number of examples in the tuning
      dataset.
    tuningStepCount: Output only. Number of tuning steps for this Tuning Job.
    userDatasetExamples: Output only. Sample user messages in the training
      dataset uri.
    userInputTokenDistribution: Output only. Dataset distributions for the
      user input tokens.
    userMessagePerExampleDistribution: Output only. Dataset distributions for
      the messages per example.
    userOutputTokenDistribution: Output only. Dataset distributions for the
      user output tokens.
  """

  totalBillableCharacterCount = _messages.IntegerField(1)
  totalTuningCharacterCount = _messages.IntegerField(2)
  tuningDatasetExampleCount = _messages.IntegerField(3)
  tuningStepCount = _messages.IntegerField(4)
  userDatasetExamples = _messages.MessageField('GoogleCloudAiplatformV1beta1Content', 5, repeated=True)
  userInputTokenDistribution = _messages.MessageField('GoogleCloudAiplatformV1beta1DatasetDistribution', 6)
  userMessagePerExampleDistribution = _messages.MessageField('GoogleCloudAiplatformV1beta1DatasetDistribution', 7)
  userOutputTokenDistribution = _messages.MessageField('GoogleCloudAiplatformV1beta1DatasetDistribution', 8)


class GoogleCloudAiplatformV1beta1DatasetVersion(_messages.Message):
  r"""Describes the dataset version.

  Fields:
    bigQueryDatasetName: Output only. Name of the associated BigQuery dataset.
    createTime: Output only. Timestamp when this DatasetVersion was created.
    displayName: The user-defined name of the DatasetVersion. The name can be
      up to 128 characters long and can consist of any UTF-8 characters.
    etag: Used to perform consistent read-modify-write updates. If not set, a
      blind "overwrite" update happens.
    metadata: Required. Output only. Additional information about the
      DatasetVersion.
    modelReference: Output only. Reference to the public base model last used
      by the dataset version. Only set for prompt dataset versions.
    name: Output only. Identifier. The resource name of the DatasetVersion.
      Format: `projects/{project}/locations/{location}/datasets/{dataset}/data
      setVersions/{dataset_version}`
    satisfiesPzi: Output only. Reserved for future use.
    satisfiesPzs: Output only. Reserved for future use.
    updateTime: Output only. Timestamp when this DatasetVersion was last
      updated.
  """

  bigQueryDatasetName = _messages.StringField(1)
  createTime = _messages.StringField(2)
  displayName = _messages.StringField(3)
  etag = _messages.StringField(4)
  metadata = _messages.MessageField('extra_types.JsonValue', 5)
  modelReference = _messages.StringField(6)
  name = _messages.StringField(7)
  satisfiesPzi = _messages.BooleanField(8)
  satisfiesPzs = _messages.BooleanField(9)
  updateTime = _messages.StringField(10)


class GoogleCloudAiplatformV1beta1DedicatedResources(_messages.Message):
  r"""A description of resources that are dedicated to a DeployedModel or
  DeployedIndex, and that need a higher degree of manual configuration.

  Fields:
    autoscalingMetricSpecs: Immutable. The metric specifications that
      overrides a resource utilization metric (CPU utilization, accelerator's
      duty cycle, and so on) target value (default to 60 if not set). At most
      one entry is allowed per metric. If machine_spec.accelerator_count is
      above 0, the autoscaling will be based on both CPU utilization and
      accelerator's duty cycle metrics and scale up when either metrics
      exceeds its target value while scale down if both metrics are under
      their target value. The default target value is 60 for both metrics. If
      machine_spec.accelerator_count is 0, the autoscaling will be based on
      CPU utilization metric only with default target value 60 if not
      explicitly set. For example, in the case of Online Prediction, if you
      want to override target CPU utilization to 80, you should set
      autoscaling_metric_specs.metric_name to
      `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
      autoscaling_metric_specs.target to `80`.
    machineSpec: Required. Immutable. The specification of a single machine
      being used.
    maxReplicaCount: Immutable. The maximum number of replicas that may be
      deployed on when the traffic against it increases. If the requested
      value is too large, the deployment will error, but if deployment
      succeeds then the ability to scale to that many replicas is guaranteed
      (barring service outages). If traffic increases beyond what its replicas
      at maximum may handle, a portion of the traffic will be dropped. If this
      value is not provided, will use min_replica_count as the default value.
      The value of this field impacts the charge against Vertex CPU and GPU
      quotas. Specifically, you will be charged for (max_replica_count *
      number of cores in the selected machine type) and (max_replica_count *
      number of GPUs per replica in the selected machine type).
    minReplicaCount: Required. Immutable. The minimum number of machine
      replicas that will be always deployed on. This value must be greater
      than or equal to 1. If traffic increases, it may dynamically be deployed
      onto more replicas, and as traffic decreases, some of these extra
      replicas may be freed.
    requiredReplicaCount: Optional. Number of required available replicas for
      the deployment to succeed. This field is only needed when partial
      deployment/mutation is desired. If set, the deploy/mutate operation will
      succeed once available_replica_count reaches required_replica_count, and
      the rest of the replicas will be retried. If not set, the default
      required_replica_count will be min_replica_count.
    spot: Optional. If true, schedule the deployment workload on [spot
      VMs](https://cloud.google.com/kubernetes-engine/docs/concepts/spot-vms).
  """

  autoscalingMetricSpecs = _messages.MessageField('GoogleCloudAiplatformV1beta1AutoscalingMetricSpec', 1, repeated=True)
  machineSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1MachineSpec', 2)
  maxReplicaCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  minReplicaCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  requiredReplicaCount = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  spot = _messages.BooleanField(6)


class GoogleCloudAiplatformV1beta1DeleteFeatureValuesOperationMetadata(_messages.Message):
  r"""Details of operations that delete Feature values.

  Fields:
    genericMetadata: Operation metadata for Featurestore delete Features
      values.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1DeleteFeatureValuesRequest(_messages.Message):
  r"""Request message for FeaturestoreService.DeleteFeatureValues.

  Fields:
    selectEntity: Select feature values to be deleted by specifying entities.
    selectTimeRangeAndFeature: Select feature values to be deleted by
      specifying time range and features.
  """

  selectEntity = _messages.MessageField('GoogleCloudAiplatformV1beta1DeleteFeatureValuesRequestSelectEntity', 1)
  selectTimeRangeAndFeature = _messages.MessageField('GoogleCloudAiplatformV1beta1DeleteFeatureValuesRequestSelectTimeRangeAndFeature', 2)


class GoogleCloudAiplatformV1beta1DeleteFeatureValuesRequestSelectEntity(_messages.Message):
  r"""Message to select entity. If an entity id is selected, all the feature
  values corresponding to the entity id will be deleted, including the
  entityId.

  Fields:
    entityIdSelector: Required. Selectors choosing feature values of which
      entity id to be deleted from the EntityType.
  """

  entityIdSelector = _messages.MessageField('GoogleCloudAiplatformV1beta1EntityIdSelector', 1)


class GoogleCloudAiplatformV1beta1DeleteFeatureValuesRequestSelectTimeRangeAndFeature(_messages.Message):
  r"""Message to select time range and feature. Values of the selected feature
  generated within an inclusive time range will be deleted. Using this option
  permanently deletes the feature values from the specified feature IDs within
  the specified time range. This might include data from the online storage.
  If you want to retain any deleted historical data in the online storage, you
  must re-ingest it.

  Fields:
    featureSelector: Required. Selectors choosing which feature values to be
      deleted from the EntityType.
    skipOnlineStorageDelete: If set, data will not be deleted from online
      storage. When time range is older than the data in online storage,
      setting this to be true will make the deletion have no impact on online
      serving.
    timeRange: Required. Select feature generated within a half-inclusive time
      range. The time range is lower inclusive and upper exclusive.
  """

  featureSelector = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureSelector', 1)
  skipOnlineStorageDelete = _messages.BooleanField(2)
  timeRange = _messages.MessageField('GoogleTypeInterval', 3)


class GoogleCloudAiplatformV1beta1DeleteFeatureValuesResponse(_messages.Message):
  r"""Response message for FeaturestoreService.DeleteFeatureValues.

  Fields:
    selectEntity: Response for request specifying the entities to delete
    selectTimeRangeAndFeature: Response for request specifying time range and
      feature
  """

  selectEntity = _messages.MessageField('GoogleCloudAiplatformV1beta1DeleteFeatureValuesResponseSelectEntity', 1)
  selectTimeRangeAndFeature = _messages.MessageField('GoogleCloudAiplatformV1beta1DeleteFeatureValuesResponseSelectTimeRangeAndFeature', 2)


class GoogleCloudAiplatformV1beta1DeleteFeatureValuesResponseSelectEntity(_messages.Message):
  r"""Response message if the request uses the SelectEntity option.

  Fields:
    offlineStorageDeletedEntityRowCount: The count of deleted entity rows in
      the offline storage. Each row corresponds to the combination of an
      entity ID and a timestamp. One entity ID can have multiple rows in the
      offline storage.
    onlineStorageDeletedEntityCount: The count of deleted entities in the
      online storage. Each entity ID corresponds to one entity.
  """

  offlineStorageDeletedEntityRowCount = _messages.IntegerField(1)
  onlineStorageDeletedEntityCount = _messages.IntegerField(2)


class GoogleCloudAiplatformV1beta1DeleteFeatureValuesResponseSelectTimeRangeAndFeature(_messages.Message):
  r"""Response message if the request uses the SelectTimeRangeAndFeature
  option.

  Fields:
    impactedFeatureCount: The count of the features or columns impacted. This
      is the same as the feature count in the request.
    offlineStorageModifiedEntityRowCount: The count of modified entity rows in
      the offline storage. Each row corresponds to the combination of an
      entity ID and a timestamp. One entity ID can have multiple rows in the
      offline storage. Within each row, only the features specified in the
      request are deleted.
    onlineStorageModifiedEntityCount: The count of modified entities in the
      online storage. Each entity ID corresponds to one entity. Within each
      entity, only the features specified in the request are deleted.
  """

  impactedFeatureCount = _messages.IntegerField(1)
  offlineStorageModifiedEntityRowCount = _messages.IntegerField(2)
  onlineStorageModifiedEntityCount = _messages.IntegerField(3)


class GoogleCloudAiplatformV1beta1DeleteMetadataStoreOperationMetadata(_messages.Message):
  r"""Details of operations that perform MetadataService.DeleteMetadataStore.

  Fields:
    genericMetadata: Operation metadata for deleting a MetadataStore.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1DeleteOperationMetadata(_messages.Message):
  r"""Details of operations that perform deletes of any entities.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1DeployIndexOperationMetadata(_messages.Message):
  r"""Runtime operation information for IndexEndpointService.DeployIndex.

  Fields:
    deployedIndexId: The unique index id specified by user
    genericMetadata: The operation generic information.
  """

  deployedIndexId = _messages.StringField(1)
  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 2)


class GoogleCloudAiplatformV1beta1DeployIndexRequest(_messages.Message):
  r"""Request message for IndexEndpointService.DeployIndex.

  Fields:
    deployedIndex: Required. The DeployedIndex to be created within the
      IndexEndpoint.
  """

  deployedIndex = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployedIndex', 1)


class GoogleCloudAiplatformV1beta1DeployIndexResponse(_messages.Message):
  r"""Response message for IndexEndpointService.DeployIndex.

  Fields:
    deployedIndex: The DeployedIndex that had been deployed in the
      IndexEndpoint.
  """

  deployedIndex = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployedIndex', 1)


class GoogleCloudAiplatformV1beta1DeployModelOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.DeployModel.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1DeployModelRequest(_messages.Message):
  r"""Request message for EndpointService.DeployModel.

  Messages:
    TrafficSplitValue: A map from a DeployedModel's ID to the percentage of
      this Endpoint's traffic that should be forwarded to that DeployedModel.
      If this field is non-empty, then the Endpoint's traffic_split will be
      overwritten with it. To refer to the ID of the just being deployed
      Model, a "0" should be used, and the actual ID of the new DeployedModel
      will be filled in its place by this method. The traffic percentage
      values must add up to 100. If this field is empty, then the Endpoint's
      traffic_split is not updated.

  Fields:
    deployedModel: Required. The DeployedModel to be created within the
      Endpoint. Note that Endpoint.traffic_split must be updated for the
      DeployedModel to start receiving traffic, either as part of this call,
      or via EndpointService.UpdateEndpoint.
    trafficSplit: A map from a DeployedModel's ID to the percentage of this
      Endpoint's traffic that should be forwarded to that DeployedModel. If
      this field is non-empty, then the Endpoint's traffic_split will be
      overwritten with it. To refer to the ID of the just being deployed
      Model, a "0" should be used, and the actual ID of the new DeployedModel
      will be filled in its place by this method. The traffic percentage
      values must add up to 100. If this field is empty, then the Endpoint's
      traffic_split is not updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TrafficSplitValue(_messages.Message):
    r"""A map from a DeployedModel's ID to the percentage of this Endpoint's
    traffic that should be forwarded to that DeployedModel. If this field is
    non-empty, then the Endpoint's traffic_split will be overwritten with it.
    To refer to the ID of the just being deployed Model, a "0" should be used,
    and the actual ID of the new DeployedModel will be filled in its place by
    this method. The traffic percentage values must add up to 100. If this
    field is empty, then the Endpoint's traffic_split is not updated.

    Messages:
      AdditionalProperty: An additional property for a TrafficSplitValue
        object.

    Fields:
      additionalProperties: Additional properties of type TrafficSplitValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TrafficSplitValue object.

      Fields:
        key: Name of the additional property.
        value: A integer attribute.
      """

      key = _messages.StringField(1)
      value = _messages.IntegerField(2, variant=_messages.Variant.INT32)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  deployedModel = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployedModel', 1)
  trafficSplit = _messages.MessageField('TrafficSplitValue', 2)


class GoogleCloudAiplatformV1beta1DeployModelResponse(_messages.Message):
  r"""Response message for EndpointService.DeployModel.

  Fields:
    deployedModel: The DeployedModel that had been deployed in the Endpoint.
  """

  deployedModel = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployedModel', 1)


class GoogleCloudAiplatformV1beta1DeployPublisherModelRequest(_messages.Message):
  r"""Request message for ModelGardenService.DeployPublisherModel.

  Fields:
    acceptEula: Optional. Whether the user accepts the End User License
      Agreement (EULA) for the model.
    dedicatedResources: Optional. The dedicated resources to use for the
      endpoint. If not set, the default resources will be used.
    endpointDisplayName: Optional. The user-specified display name of the
      endpoint. If not set, a default name will be used.
    huggingFaceAccessToken: Optional. The Hugging Face read access token used
      to access the model artifacts of gated models.
    model: Required. The model to deploy. Format: 1.
      `publishers/{publisher}/models/{publisher_model}@{version_id}`, or
      `publishers/hf-{hugging-face-author}/models/{hugging-face-model-
      name}@001`. 2. Hugging Face model ID like `google/gemma-2-2b-it`. 3.
      Custom model Google Cloud Storage URI like `gs://bucket`. 4. Custom
      model zip file like `https://abc.com/a.zip`.
    modelDisplayName: Optional. The user-specified display name of the
      uploaded model. If not set, a default name will be used.
  """

  acceptEula = _messages.BooleanField(1)
  dedicatedResources = _messages.MessageField('GoogleCloudAiplatformV1beta1DedicatedResources', 2)
  endpointDisplayName = _messages.StringField(3)
  huggingFaceAccessToken = _messages.StringField(4)
  model = _messages.StringField(5)
  modelDisplayName = _messages.StringField(6)


class GoogleCloudAiplatformV1beta1DeployRequest(_messages.Message):
  r"""Request message for ModelGardenService.Deploy.

  Fields:
    deployConfig: Optional. The deploy config to use for the deployment. If
      not specified, the default deploy config will be used.
    endpointConfig: Optional. The endpoint config to use for the deployment.
      If not specified, the default endpoint config will be used.
    huggingFaceModelId: The Hugging Face model to deploy. Format: Hugging Face
      model ID like `google/gemma-2-2b-it`.
    modelConfig: Optional. The model config to use for the deployment. If not
      specified, the default model config will be used.
    publisherModelName: The Model Garden model to deploy. Format:
      `publishers/{publisher}/models/{publisher_model}@{version_id}`, or
      `publishers/hf-{hugging-face-author}/models/{hugging-face-model-
      name}@001`.
  """

  deployConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployRequestDeployConfig', 1)
  endpointConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployRequestEndpointConfig', 2)
  huggingFaceModelId = _messages.StringField(3)
  modelConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployRequestModelConfig', 4)
  publisherModelName = _messages.StringField(5)


class GoogleCloudAiplatformV1beta1DeployRequestDeployConfig(_messages.Message):
  r"""The deploy config to use for the deployment.

  Fields:
    dedicatedResources: Optional. The dedicated resources to use for the
      endpoint. If not set, the default resources will be used.
    fastTryoutEnabled: Optional. If true, enable the QMT fast tryout feature
      for this model if possible.
  """

  dedicatedResources = _messages.MessageField('GoogleCloudAiplatformV1beta1DedicatedResources', 1)
  fastTryoutEnabled = _messages.BooleanField(2)


class GoogleCloudAiplatformV1beta1DeployRequestEndpointConfig(_messages.Message):
  r"""The endpoint config to use for the deployment.

  Fields:
    dedicatedEndpointEnabled: Optional. If true, the endpoint will be exposed
      through a dedicated DNS [Endpoint.dedicated_endpoint_dns]. Your request
      to the dedicated DNS will be isolated from other users' traffic and will
      have better performance and reliability. Note: Once you enabled
      dedicated endpoint, you won't be able to send request to the shared DNS
      {region}-aiplatform.googleapis.com. The limitations will be removed
      soon.
    endpointDisplayName: Optional. The user-specified display name of the
      endpoint. If not set, a default name will be used.
  """

  dedicatedEndpointEnabled = _messages.BooleanField(1)
  endpointDisplayName = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1DeployRequestModelConfig(_messages.Message):
  r"""The model config to use for the deployment.

  Fields:
    acceptEula: Optional. Whether the user accepts the End User License
      Agreement (EULA) for the model.
    containerSpec: Optional. The specification of the container that is to be
      used when deploying. If not set, the default container spec will be
      used.
    huggingFaceAccessToken: Optional. The Hugging Face read access token used
      to access the model artifacts of gated models.
    huggingFaceCacheEnabled: Optional. If true, the model will deploy with a
      cached version instead of directly downloading the model artifacts from
      Hugging Face. This is suitable for VPC-SC users with limited internet
      access.
    modelDisplayName: Optional. The user-specified display name of the
      uploaded model. If not set, a default name will be used.
  """

  acceptEula = _messages.BooleanField(1)
  containerSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1ModelContainerSpec', 2)
  huggingFaceAccessToken = _messages.StringField(3)
  huggingFaceCacheEnabled = _messages.BooleanField(4)
  modelDisplayName = _messages.StringField(5)


class GoogleCloudAiplatformV1beta1DeploySolverOperationMetadata(_messages.Message):
  r"""Runtime operation information for SolverService.DeploySolver.

  Fields:
    genericMetadata: The generic operation information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1DeployedIndex(_messages.Message):
  r"""A deployment of an Index. IndexEndpoints contain one or more
  DeployedIndexes.

  Fields:
    automaticResources: Optional. A description of resources that the
      DeployedIndex uses, which to large degree are decided by Vertex AI, and
      optionally allows only a modest additional configuration. If
      min_replica_count is not set, the default value is 2 (we don't provide
      SLA when min_replica_count=1). If max_replica_count is not set, the
      default value is min_replica_count. The max allowed replica count is
      1000.
    createTime: Output only. Timestamp when the DeployedIndex was created.
    dedicatedResources: Optional. A description of resources that are
      dedicated to the DeployedIndex, and that need a higher degree of manual
      configuration. The field min_replica_count must be set to a value
      strictly greater than 0, or else validation will fail. We don't provide
      SLA when min_replica_count=1. If max_replica_count is not set, the
      default value is min_replica_count. The max allowed replica count is
      1000. Available machine types for SMALL shard: e2-standard-2 and all
      machine types available for MEDIUM and LARGE shard. Available machine
      types for MEDIUM shard: e2-standard-16 and all machine types available
      for LARGE shard. Available machine types for LARGE shard: e2-highmem-16,
      n2d-standard-32. n1-standard-16 and n1-standard-32 are still available,
      but we recommend e2-standard-16 and e2-highmem-16 for cost efficiency.
    deployedIndexAuthConfig: Optional. If set, the authentication is enabled
      for the private endpoint.
    deploymentGroup: Optional. The deployment group can be no longer than 64
      characters (eg: 'test', 'prod'). If not set, we will use the 'default'
      deployment group. Creating `deployment_groups` with `reserved_ip_ranges`
      is a recommended practice when the peered network has multiple peering
      ranges. This creates your deployments from predictable IP spaces for
      easier traffic administration. Also, one deployment_group (except
      'default') can only be used with the same reserved_ip_ranges which means
      if the deployment_group has been used with reserved_ip_ranges: [a, b,
      c], using it with [a, b] or [d, e] is disallowed. Note: we only support
      up to 5 deployment groups(not including 'default').
    displayName: The display name of the DeployedIndex. If not provided upon
      creation, the Index's display_name is used.
    enableAccessLogging: Optional. If true, private endpoint's access logs are
      sent to Cloud Logging. These logs are like standard server access logs,
      containing information like timestamp and latency for each MatchRequest.
      Note that logs may incur a cost, especially if the deployed index
      receives a high queries per second rate (QPS). Estimate your costs
      before enabling this option.
    id: Required. The user specified ID of the DeployedIndex. The ID can be up
      to 128 characters long and must start with a letter and only contain
      letters, numbers, and underscores. The ID must be unique within the
      project it is created in.
    index: Required. The name of the Index this is the deployment of. We may
      refer to this Index as the DeployedIndex's "original" Index.
    indexSyncTime: Output only. The DeployedIndex may depend on various data
      on its original Index. Additionally when certain changes to the original
      Index are being done (e.g. when what the Index contains is being
      changed) the DeployedIndex may be asynchronously updated in the
      background to reflect these changes. If this timestamp's value is at
      least the Index.update_time of the original Index, it means that this
      DeployedIndex and the original Index are in sync. If this timestamp is
      older, then to see which updates this DeployedIndex already contains
      (and which it does not), one must list the operations that are running
      on the original Index. Only the successfully completed Operations with
      update_time equal or before this sync time are contained in this
      DeployedIndex.
    privateEndpoints: Output only. Provides paths for users to send requests
      directly to the deployed index services running on Cloud via private
      services access. This field is populated if network is configured.
    pscAutomationConfigs: Optional. If set for PSC deployed index, PSC
      connection will be automatically created after deployment is done and
      the endpoint information is populated in
      private_endpoints.psc_automated_endpoints.
    reservedIpRanges: Optional. A list of reserved ip ranges under the VPC
      network that can be used for this DeployedIndex. If set, we will deploy
      the index within the provided ip ranges. Otherwise, the index might be
      deployed to any ip ranges under the provided VPC network. The value
      should be the name of the address
      (https://cloud.google.com/compute/docs/reference/rest/v1/addresses)
      Example: ['vertex-ai-ip-range']. For more information about subnets and
      network IP ranges, please see https://cloud.google.com/vpc/docs/subnets#
      manually_created_subnet_ip_ranges.
  """

  automaticResources = _messages.MessageField('GoogleCloudAiplatformV1beta1AutomaticResources', 1)
  createTime = _messages.StringField(2)
  dedicatedResources = _messages.MessageField('GoogleCloudAiplatformV1beta1DedicatedResources', 3)
  deployedIndexAuthConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployedIndexAuthConfig', 4)
  deploymentGroup = _messages.StringField(5)
  displayName = _messages.StringField(6)
  enableAccessLogging = _messages.BooleanField(7)
  id = _messages.StringField(8)
  index = _messages.StringField(9)
  indexSyncTime = _messages.StringField(10)
  privateEndpoints = _messages.MessageField('GoogleCloudAiplatformV1beta1IndexPrivateEndpoints', 11)
  pscAutomationConfigs = _messages.MessageField('GoogleCloudAiplatformV1beta1PSCAutomationConfig', 12, repeated=True)
  reservedIpRanges = _messages.StringField(13, repeated=True)


class GoogleCloudAiplatformV1beta1DeployedIndexAuthConfig(_messages.Message):
  r"""Used to set up the auth on the DeployedIndex's private endpoint.

  Fields:
    authProvider: Defines the authentication provider that the DeployedIndex
      uses.
  """

  authProvider = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployedIndexAuthConfigAuthProvider', 1)


class GoogleCloudAiplatformV1beta1DeployedIndexAuthConfigAuthProvider(_messages.Message):
  r"""Configuration for an authentication provider, including support for
  [JSON Web Token (JWT)](https://tools.ietf.org/html/draft-ietf-oauth-json-
  web-token-32).

  Fields:
    allowedIssuers: A list of allowed JWT issuers. Each entry must be a valid
      Google service account, in the following format: `service-account-
      name@project-id.iam.gserviceaccount.com`
    audiences: The list of JWT [audiences](https://tools.ietf.org/html/draft-
      ietf-oauth-json-web-token-32#section-4.1.3). that are allowed to access.
      A JWT containing any of these audiences will be accepted.
  """

  allowedIssuers = _messages.StringField(1, repeated=True)
  audiences = _messages.StringField(2, repeated=True)


class GoogleCloudAiplatformV1beta1DeployedIndexRef(_messages.Message):
  r"""Points to a DeployedIndex.

  Fields:
    deployedIndexId: Immutable. The ID of the DeployedIndex in the above
      IndexEndpoint.
    displayName: Output only. The display name of the DeployedIndex.
    indexEndpoint: Immutable. A resource name of the IndexEndpoint.
  """

  deployedIndexId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  indexEndpoint = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1DeployedModel(_messages.Message):
  r"""A deployment of a Model. Endpoints contain one or more DeployedModels.

  Messages:
    SystemLabelsValue: System labels to apply to Model Garden deployments.
      System labels are managed by Google for internal use only.

  Fields:
    automaticResources: A description of resources that to large degree are
      decided by Vertex AI, and require only a modest additional
      configuration.
    createTime: Output only. Timestamp when the DeployedModel was created.
    dedicatedResources: A description of resources that are dedicated to the
      DeployedModel, and that need a higher degree of manual configuration.
    disableExplanations: If true, deploy the model without explainable
      feature, regardless the existence of Model.explanation_spec or
      explanation_spec.
    displayName: The display name of the DeployedModel. If not provided upon
      creation, the Model's display_name is used.
    enableAccessLogging: If true, online prediction access logs are sent to
      Cloud Logging. These logs are like standard server access logs,
      containing information like timestamp and latency for each prediction
      request. Note that logs may incur a cost, especially if your project
      receives prediction requests at a high queries per second rate (QPS).
      Estimate your costs before enabling this option.
    enableContainerLogging: If true, the container of the DeployedModel
      instances will send `stderr` and `stdout` streams to Cloud Logging. Only
      supported for custom-trained Models and AutoML Tabular Models.
    explanationSpec: Explanation configuration for this DeployedModel. When
      deploying a Model using EndpointService.DeployModel, this value
      overrides the value of Model.explanation_spec. All fields of
      explanation_spec are optional in the request. If a field of
      explanation_spec is not populated, the value of the same field of
      Model.explanation_spec is inherited. If the corresponding
      Model.explanation_spec is not populated, all fields of the
      explanation_spec will be used for the explanation configuration.
    fasterDeploymentConfig: Configuration for faster model deployment.
    id: Immutable. The ID of the DeployedModel. If not provided upon
      deployment, Vertex AI will generate a value for this ID. This value
      should be 1-10 characters, and valid characters are `/[0-9]/`.
    model: Required. The resource name of the Model that this is the
      deployment of. Note that the Model may be in a different location than
      the DeployedModel's Endpoint. The resource name may contain version id
      or version alias to specify the version. Example:
      `projects/{project}/locations/{location}/models/{model}@2` or
      `projects/{project}/locations/{location}/models/{model}@golden` if no
      version is specified, the default version will be deployed.
    modelVersionId: Output only. The version ID of the model that is deployed.
    privateEndpoints: Output only. Provide paths for users to send
      predict/explain/health requests directly to the deployed model services
      running on Cloud via private services access. This field is populated if
      network is configured.
    rolloutOptions: Options for configuring rolling deployments.
    serviceAccount: The service account that the DeployedModel's container
      runs as. Specify the email address of the service account. If this
      service account is not specified, the container runs as a service
      account that doesn't have access to the resource project. Users
      deploying the Model must have the `iam.serviceAccounts.actAs` permission
      on this service account.
    sharedResources: The resource name of the shared DeploymentResourcePool to
      deploy on. Format: `projects/{project}/locations/{location}/deploymentRe
      sourcePools/{deployment_resource_pool}`
    speculativeDecodingSpec: Optional. Spec for configuring speculative
      decoding.
    status: Output only. Runtime status of the deployed model.
    systemLabels: System labels to apply to Model Garden deployments. System
      labels are managed by Google for internal use only.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SystemLabelsValue(_messages.Message):
    r"""System labels to apply to Model Garden deployments. System labels are
    managed by Google for internal use only.

    Messages:
      AdditionalProperty: An additional property for a SystemLabelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type SystemLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SystemLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  automaticResources = _messages.MessageField('GoogleCloudAiplatformV1beta1AutomaticResources', 1)
  createTime = _messages.StringField(2)
  dedicatedResources = _messages.MessageField('GoogleCloudAiplatformV1beta1DedicatedResources', 3)
  disableExplanations = _messages.BooleanField(4)
  displayName = _messages.StringField(5)
  enableAccessLogging = _messages.BooleanField(6)
  enableContainerLogging = _messages.BooleanField(7)
  explanationSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationSpec', 8)
  fasterDeploymentConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1FasterDeploymentConfig', 9)
  id = _messages.StringField(10)
  model = _messages.StringField(11)
  modelVersionId = _messages.StringField(12)
  privateEndpoints = _messages.MessageField('GoogleCloudAiplatformV1beta1PrivateEndpoints', 13)
  rolloutOptions = _messages.MessageField('GoogleCloudAiplatformV1beta1RolloutOptions', 14)
  serviceAccount = _messages.StringField(15)
  sharedResources = _messages.StringField(16)
  speculativeDecodingSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1SpeculativeDecodingSpec', 17)
  status = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployedModelStatus', 18)
  systemLabels = _messages.MessageField('SystemLabelsValue', 19)


class GoogleCloudAiplatformV1beta1DeployedModelRef(_messages.Message):
  r"""Points to a DeployedModel.

  Fields:
    deployedModelId: Immutable. An ID of a DeployedModel in the above
      Endpoint.
    endpoint: Immutable. A resource name of an Endpoint.
  """

  deployedModelId = _messages.StringField(1)
  endpoint = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1DeployedModelStatus(_messages.Message):
  r"""Runtime status of the deployed model.

  Fields:
    availableReplicaCount: Output only. The number of available replicas of
      the deployed model.
    lastUpdateTime: Output only. The time at which the status was last
      updated.
    message: Output only. The latest deployed model's status message (if any).
  """

  availableReplicaCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  lastUpdateTime = _messages.StringField(2)
  message = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1DeploymentResourcePool(_messages.Message):
  r"""A description of resources that can be shared by multiple
  DeployedModels, whose underlying specification consists of a
  DedicatedResources.

  Fields:
    createTime: Output only. Timestamp when this DeploymentResourcePool was
      created.
    dedicatedResources: Required. The underlying DedicatedResources that the
      DeploymentResourcePool uses.
    disableContainerLogging: If the DeploymentResourcePool is deployed with
      custom-trained Models or AutoML Tabular Models, the container(s) of the
      DeploymentResourcePool will send `stderr` and `stdout` streams to Cloud
      Logging by default. Please note that the logs incur cost, which are
      subject to [Cloud Logging
      pricing](https://cloud.google.com/logging/pricing). User can disable
      container logging by setting this flag to true.
    encryptionSpec: Customer-managed encryption key spec for a
      DeploymentResourcePool. If set, this DeploymentResourcePool will be
      secured by this key. Endpoints and the DeploymentResourcePool they
      deploy in need to have the same EncryptionSpec.
    name: Immutable. The resource name of the DeploymentResourcePool. Format:
      `projects/{project}/locations/{location}/deploymentResourcePools/{deploy
      ment_resource_pool}`
    satisfiesPzi: Output only. Reserved for future use.
    satisfiesPzs: Output only. Reserved for future use.
    serviceAccount: The service account that the DeploymentResourcePool's
      container(s) run as. Specify the email address of the service account.
      If this service account is not specified, the container(s) run as a
      service account that doesn't have access to the resource project. Users
      deploying the Models to this DeploymentResourcePool must have the
      `iam.serviceAccounts.actAs` permission on this service account.
  """

  createTime = _messages.StringField(1)
  dedicatedResources = _messages.MessageField('GoogleCloudAiplatformV1beta1DedicatedResources', 2)
  disableContainerLogging = _messages.BooleanField(3)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1EncryptionSpec', 4)
  name = _messages.StringField(5)
  satisfiesPzi = _messages.BooleanField(6)
  satisfiesPzs = _messages.BooleanField(7)
  serviceAccount = _messages.StringField(8)


class GoogleCloudAiplatformV1beta1DestinationFeatureSetting(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1DestinationFeatureSetting object.

  Fields:
    destinationField: Specify the field name in the export destination. If not
      specified, Feature ID is used.
    featureId: Required. The ID of the Feature to apply the setting to.
  """

  destinationField = _messages.StringField(1)
  featureId = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1DirectPredictRequest(_messages.Message):
  r"""Request message for PredictionService.DirectPredict.

  Fields:
    inputs: The prediction input.
    parameters: The parameters that govern the prediction.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1beta1Tensor', 1, repeated=True)
  parameters = _messages.MessageField('GoogleCloudAiplatformV1beta1Tensor', 2)


class GoogleCloudAiplatformV1beta1DirectPredictResponse(_messages.Message):
  r"""Response message for PredictionService.DirectPredict.

  Fields:
    outputs: The prediction output.
    parameters: The parameters that govern the prediction.
  """

  outputs = _messages.MessageField('GoogleCloudAiplatformV1beta1Tensor', 1, repeated=True)
  parameters = _messages.MessageField('GoogleCloudAiplatformV1beta1Tensor', 2)


class GoogleCloudAiplatformV1beta1DirectRawPredictRequest(_messages.Message):
  r"""Request message for PredictionService.DirectRawPredict.

  Fields:
    input: The prediction input.
    methodName: Fully qualified name of the API method being invoked to
      perform predictions. Format: `/namespace.Service/Method/` Example:
      `/tensorflow.serving.PredictionService/Predict`
  """

  input = _messages.BytesField(1)
  methodName = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1DirectRawPredictResponse(_messages.Message):
  r"""Response message for PredictionService.DirectRawPredict.

  Fields:
    output: The prediction output.
  """

  output = _messages.BytesField(1)


class GoogleCloudAiplatformV1beta1DirectUploadSource(_messages.Message):
  r"""The input content is encapsulated and uploaded in the request."""


class GoogleCloudAiplatformV1beta1DiskSpec(_messages.Message):
  r"""Represents the spec of disk options.

  Fields:
    bootDiskSizeGb: Size in GB of the boot disk (default is 100GB).
    bootDiskType: Type of the boot disk (default is "pd-ssd"). Valid values:
      "pd-ssd" (Persistent Disk Solid State Drive) or "pd-standard"
      (Persistent Disk Hard Disk Drive).
  """

  bootDiskSizeGb = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  bootDiskType = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1DistillationDataStats(_messages.Message):
  r"""Statistics computed for datasets used for distillation.

  Fields:
    trainingDatasetStats: Output only. Statistics computed for the training
      dataset.
  """

  trainingDatasetStats = _messages.MessageField('GoogleCloudAiplatformV1beta1DatasetStats', 1)


class GoogleCloudAiplatformV1beta1DistillationHyperParameters(_messages.Message):
  r"""Hyperparameters for Distillation.

  Enums:
    AdapterSizeValueValuesEnum: Optional. Adapter size for distillation.

  Fields:
    adapterSize: Optional. Adapter size for distillation.
    epochCount: Optional. Number of complete passes the model makes over the
      entire training dataset during training.
    learningRateMultiplier: Optional. Multiplier for adjusting the default
      learning rate.
  """

  class AdapterSizeValueValuesEnum(_messages.Enum):
    r"""Optional. Adapter size for distillation.

    Values:
      ADAPTER_SIZE_UNSPECIFIED: Adapter size is unspecified.
      ADAPTER_SIZE_ONE: Adapter size 1.
      ADAPTER_SIZE_TWO: Adapter size 2.
      ADAPTER_SIZE_FOUR: Adapter size 4.
      ADAPTER_SIZE_EIGHT: Adapter size 8.
      ADAPTER_SIZE_SIXTEEN: Adapter size 16.
      ADAPTER_SIZE_THIRTY_TWO: Adapter size 32.
    """
    ADAPTER_SIZE_UNSPECIFIED = 0
    ADAPTER_SIZE_ONE = 1
    ADAPTER_SIZE_TWO = 2
    ADAPTER_SIZE_FOUR = 3
    ADAPTER_SIZE_EIGHT = 4
    ADAPTER_SIZE_SIXTEEN = 5
    ADAPTER_SIZE_THIRTY_TWO = 6

  adapterSize = _messages.EnumField('AdapterSizeValueValuesEnum', 1)
  epochCount = _messages.IntegerField(2)
  learningRateMultiplier = _messages.FloatField(3)


class GoogleCloudAiplatformV1beta1DistillationSpec(_messages.Message):
  r"""Tuning Spec for Distillation.

  Fields:
    baseTeacherModel: The base teacher model that is being distilled, e.g.,
      "gemini-1.0-pro-002".
    hyperParameters: Optional. Hyperparameters for Distillation.
    pipelineRootDirectory: Deprecated. A path in a Cloud Storage bucket, which
      will be treated as the root output directory of the distillation
      pipeline. It is used by the system to generate the paths of output
      artifacts.
    studentModel: The student model that is being tuned, e.g.,
      "google/gemma-2b-1.1-it". Deprecated. Use base_model instead.
    trainingDatasetUri: Deprecated. Cloud Storage path to file containing
      training dataset for tuning. The dataset must be formatted as a JSONL
      file.
    tunedTeacherModelSource: The resource name of the Tuned teacher model.
      Format: `projects/{project}/locations/{location}/models/{model}`.
    validationDatasetUri: Optional. Cloud Storage path to file containing
      validation dataset for tuning. The dataset must be formatted as a JSONL
      file.
  """

  baseTeacherModel = _messages.StringField(1)
  hyperParameters = _messages.MessageField('GoogleCloudAiplatformV1beta1DistillationHyperParameters', 2)
  pipelineRootDirectory = _messages.StringField(3)
  studentModel = _messages.StringField(4)
  trainingDatasetUri = _messages.StringField(5)
  tunedTeacherModelSource = _messages.StringField(6)
  validationDatasetUri = _messages.StringField(7)


class GoogleCloudAiplatformV1beta1DoubleArray(_messages.Message):
  r"""A list of double values.

  Fields:
    values: A list of double values.
  """

  values = _messages.FloatField(1, repeated=True)


class GoogleCloudAiplatformV1beta1DynamicRetrievalConfig(_messages.Message):
  r"""Describes the options to customize dynamic retrieval.

  Enums:
    ModeValueValuesEnum: The mode of the predictor to be used in dynamic
      retrieval.

  Fields:
    dynamicThreshold: Optional. The threshold to be used in dynamic retrieval.
      If not set, a system default value is used.
    mode: The mode of the predictor to be used in dynamic retrieval.
  """

  class ModeValueValuesEnum(_messages.Enum):
    r"""The mode of the predictor to be used in dynamic retrieval.

    Values:
      MODE_UNSPECIFIED: Always trigger retrieval.
      MODE_DYNAMIC: Run retrieval only when system decides it is necessary.
    """
    MODE_UNSPECIFIED = 0
    MODE_DYNAMIC = 1

  dynamicThreshold = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  mode = _messages.EnumField('ModeValueValuesEnum', 2)


class GoogleCloudAiplatformV1beta1EncryptionSpec(_messages.Message):
  r"""Represents a customer-managed encryption key spec that can be applied to
  a top-level resource.

  Fields:
    kmsKeyName: Required. The Cloud KMS resource identifier of the customer
      managed encryption key used to protect a resource. Has the form:
      `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-
      key`. The key needs to be in the same region as where the compute
      resource is created.
  """

  kmsKeyName = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1Endpoint(_messages.Message):
  r"""Models are deployed into it, and afterwards Endpoint is called to obtain
  predictions and explanations.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      Endpoints. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.
    TrafficSplitValue: A map from a DeployedModel's ID to the percentage of
      this Endpoint's traffic that should be forwarded to that DeployedModel.
      If a DeployedModel's ID is not listed in this map, then it receives no
      traffic. The traffic percentage values must add up to 100, or map must
      be empty if the Endpoint is to not accept any traffic at a moment.

  Fields:
    clientConnectionConfig: Configurations that are applied to the endpoint
      for online prediction.
    createTime: Output only. Timestamp when this Endpoint was created.
    dedicatedEndpointDns: Output only. DNS of the dedicated endpoint. Will
      only be populated if dedicated_endpoint_enabled is true. Format: `https:
      //{endpoint_id}.{region}-{project_number}.prediction.vertexai.goog`.
    dedicatedEndpointEnabled: If true, the endpoint will be exposed through a
      dedicated DNS [Endpoint.dedicated_endpoint_dns]. Your request to the
      dedicated DNS will be isolated from other users' traffic and will have
      better performance and reliability. Note: Once you enabled dedicated
      endpoint, you won't be able to send request to the shared DNS
      {region}-aiplatform.googleapis.com. The limitation will be removed soon.
    deployedModels: Output only. The models deployed in this Endpoint. To add
      or remove DeployedModels use EndpointService.DeployModel and
      EndpointService.UndeployModel respectively.
    description: The description of the Endpoint.
    displayName: Required. The display name of the Endpoint. The name can be
      up to 128 characters long and can consist of any UTF-8 characters.
    enablePrivateServiceConnect: Deprecated: If true, expose the Endpoint via
      private service connect. Only one of the fields, network or
      enable_private_service_connect, can be set.
    encryptionSpec: Customer-managed encryption key spec for an Endpoint. If
      set, this Endpoint and all sub-resources of this Endpoint will be
      secured by this key.
    etag: Used to perform consistent read-modify-write updates. If not set, a
      blind "overwrite" update happens.
    gdceConfig: Configures the Google Distributed Cloud Edge (GDCE)
      environment for online prediction. Only set this field when the Endpoint
      is to be deployed in a GDCE environment.
    genAiAdvancedFeaturesConfig: Optional. Configuration for
      GenAiAdvancedFeatures. If the endpoint is serving GenAI models, advanced
      features like native RAG integration can be configured. Currently, only
      Model Garden models are supported.
    labels: The labels with user-defined metadata to organize your Endpoints.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. See
      https://goo.gl/xmQnxf for more information and examples of labels.
    modelDeploymentMonitoringJob: Output only. Resource name of the Model
      Monitoring job associated with this Endpoint if monitoring is enabled by
      JobService.CreateModelDeploymentMonitoringJob. Format: `projects/{projec
      t}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_
      monitoring_job}`
    name: Output only. The resource name of the Endpoint.
    network: Optional. The full name of the Google Compute Engine
      [network](https://cloud.google.com//compute/docs/networks-and-
      firewalls#networks) to which the Endpoint should be peered. Private
      services access must already be configured for the network. If left
      unspecified, the Endpoint is not peered with any network. Only one of
      the fields, network or enable_private_service_connect, can be set. [Form
      at](https://cloud.google.com/compute/docs/reference/rest/v1/networks/ins
      ert): `projects/{project}/global/networks/{network}`. Where `{project}`
      is a project number, as in `12345`, and `{network}` is network name.
    predictRequestResponseLoggingConfig: Configures the request-response
      logging for online prediction.
    privateServiceConnectConfig: Optional. Configuration for private service
      connect. network and private_service_connect_config are mutually
      exclusive.
    satisfiesPzi: Output only. Reserved for future use.
    satisfiesPzs: Output only. Reserved for future use.
    trafficSplit: A map from a DeployedModel's ID to the percentage of this
      Endpoint's traffic that should be forwarded to that DeployedModel. If a
      DeployedModel's ID is not listed in this map, then it receives no
      traffic. The traffic percentage values must add up to 100, or map must
      be empty if the Endpoint is to not accept any traffic at a moment.
    updateTime: Output only. Timestamp when this Endpoint was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your Endpoints.
    Label keys and values can be no longer than 64 characters (Unicode
    codepoints), can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. See
    https://goo.gl/xmQnxf for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TrafficSplitValue(_messages.Message):
    r"""A map from a DeployedModel's ID to the percentage of this Endpoint's
    traffic that should be forwarded to that DeployedModel. If a
    DeployedModel's ID is not listed in this map, then it receives no traffic.
    The traffic percentage values must add up to 100, or map must be empty if
    the Endpoint is to not accept any traffic at a moment.

    Messages:
      AdditionalProperty: An additional property for a TrafficSplitValue
        object.

    Fields:
      additionalProperties: Additional properties of type TrafficSplitValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TrafficSplitValue object.

      Fields:
        key: Name of the additional property.
        value: A integer attribute.
      """

      key = _messages.StringField(1)
      value = _messages.IntegerField(2, variant=_messages.Variant.INT32)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clientConnectionConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1ClientConnectionConfig', 1)
  createTime = _messages.StringField(2)
  dedicatedEndpointDns = _messages.StringField(3)
  dedicatedEndpointEnabled = _messages.BooleanField(4)
  deployedModels = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployedModel', 5, repeated=True)
  description = _messages.StringField(6)
  displayName = _messages.StringField(7)
  enablePrivateServiceConnect = _messages.BooleanField(8)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1EncryptionSpec', 9)
  etag = _messages.StringField(10)
  gdceConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1GdceConfig', 11)
  genAiAdvancedFeaturesConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1GenAiAdvancedFeaturesConfig', 12)
  labels = _messages.MessageField('LabelsValue', 13)
  modelDeploymentMonitoringJob = _messages.StringField(14)
  name = _messages.StringField(15)
  network = _messages.StringField(16)
  predictRequestResponseLoggingConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1PredictRequestResponseLoggingConfig', 17)
  privateServiceConnectConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1PrivateServiceConnectConfig', 18)
  satisfiesPzi = _messages.BooleanField(19)
  satisfiesPzs = _messages.BooleanField(20)
  trafficSplit = _messages.MessageField('TrafficSplitValue', 21)
  updateTime = _messages.StringField(22)


class GoogleCloudAiplatformV1beta1EntityIdSelector(_messages.Message):
  r"""Selector for entityId. Getting ids from the given source.

  Fields:
    csvSource: Source of Csv
    entityIdField: Source column that holds entity IDs. If not provided,
      entity IDs are extracted from the column named entity_id.
  """

  csvSource = _messages.MessageField('GoogleCloudAiplatformV1beta1CsvSource', 1)
  entityIdField = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1EntityType(_messages.Message):
  r"""An entity type is a type of object in a system that needs to be modeled
  and have stored information about. For example, driver is an entity type,
  and driver0 is an instance of an entity type driver.

  Messages:
    LabelsValue: Optional. The labels with user-defined metadata to organize
      your EntityTypes. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information on and examples
      of labels. No more than 64 user labels can be associated with one
      EntityType (System labels are excluded)." System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable.

  Fields:
    createTime: Output only. Timestamp when this EntityType was created.
    description: Optional. Description of the EntityType.
    etag: Optional. Used to perform a consistent read-modify-write updates. If
      not set, a blind "overwrite" update happens.
    labels: Optional. The labels with user-defined metadata to organize your
      EntityTypes. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information on and examples
      of labels. No more than 64 user labels can be associated with one
      EntityType (System labels are excluded)." System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable.
    monitoringConfig: Optional. The default monitoring configuration for all
      Features with value type (Feature.ValueType) BOOL, STRING, DOUBLE or
      INT64 under this EntityType. If this is populated with
      [FeaturestoreMonitoringConfig.monitoring_interval] specified, snapshot
      analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
      is disabled.
    name: Immutable. Name of the EntityType. Format: `projects/{project}/locat
      ions/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
      The last part entity_type is assigned by the client. The entity_type can
      be up to 64 characters long and can consist only of ASCII Latin letters
      A-Z and a-z and underscore(_), and ASCII digits 0-9 starting with a
      letter. The value will be unique given a featurestore.
    offlineStorageTtlDays: Optional. Config for data retention policy in
      offline storage. TTL in days for feature values that will be stored in
      offline storage. The Feature Store offline storage periodically removes
      obsolete feature values older than `offline_storage_ttl_days` since the
      feature generation time. If unset (or explicitly set to 0), default to
      4000 days TTL.
    satisfiesPzi: Output only. Reserved for future use.
    satisfiesPzs: Output only. Reserved for future use.
    updateTime: Output only. Timestamp when this EntityType was most recently
      updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels with user-defined metadata to organize your
    EntityTypes. Label keys and values can be no longer than 64 characters
    (Unicode codepoints), can only contain lowercase letters, numeric
    characters, underscores and dashes. International characters are allowed.
    See https://goo.gl/xmQnxf for more information on and examples of labels.
    No more than 64 user labels can be associated with one EntityType (System
    labels are excluded)." System reserved label keys are prefixed with
    "aiplatform.googleapis.com/" and are immutable.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  etag = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  monitoringConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfig', 5)
  name = _messages.StringField(6)
  offlineStorageTtlDays = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  satisfiesPzi = _messages.BooleanField(8)
  satisfiesPzs = _messages.BooleanField(9)
  updateTime = _messages.StringField(10)


class GoogleCloudAiplatformV1beta1EnvVar(_messages.Message):
  r"""Represents an environment variable present in a Container or Python
  Module.

  Fields:
    name: Required. Name of the environment variable. Must be a valid C
      identifier.
    value: Required. Variables that reference a $(VAR_NAME) are expanded using
      the previous defined environment variables in the container and any
      service environment variables. If a variable cannot be resolved, the
      reference in the input string will be unchanged. The $(VAR_NAME) syntax
      can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references
      will never be expanded, regardless of whether the variable exists or
      not.
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ErrorAnalysisAnnotation(_messages.Message):
  r"""Model error analysis for each annotation.

  Enums:
    QueryTypeValueValuesEnum: The query type used for finding the attributed
      items.

  Fields:
    attributedItems: Attributed items for a given annotation, typically
      representing neighbors from the training sets constrained by the query
      type.
    outlierScore: The outlier score of this annotated item. Usually defined as
      the min of all distances from attributed items.
    outlierThreshold: The threshold used to determine if this annotation is an
      outlier or not.
    queryType: The query type used for finding the attributed items.
  """

  class QueryTypeValueValuesEnum(_messages.Enum):
    r"""The query type used for finding the attributed items.

    Values:
      QUERY_TYPE_UNSPECIFIED: Unspecified query type for model error analysis.
      ALL_SIMILAR: Query similar samples across all classes in the dataset.
      SAME_CLASS_SIMILAR: Query similar samples from the same class of the
        input sample.
      SAME_CLASS_DISSIMILAR: Query dissimilar samples from the same class of
        the input sample.
    """
    QUERY_TYPE_UNSPECIFIED = 0
    ALL_SIMILAR = 1
    SAME_CLASS_SIMILAR = 2
    SAME_CLASS_DISSIMILAR = 3

  attributedItems = _messages.MessageField('GoogleCloudAiplatformV1beta1ErrorAnalysisAnnotationAttributedItem', 1, repeated=True)
  outlierScore = _messages.FloatField(2)
  outlierThreshold = _messages.FloatField(3)
  queryType = _messages.EnumField('QueryTypeValueValuesEnum', 4)


class GoogleCloudAiplatformV1beta1ErrorAnalysisAnnotationAttributedItem(_messages.Message):
  r"""Attributed items for a given annotation, typically representing
  neighbors from the training sets constrained by the query type.

  Fields:
    annotationResourceName: The unique ID for each annotation. Used by FE to
      allocate the annotation in DB.
    distance: The distance of this item to the annotation.
  """

  annotationResourceName = _messages.StringField(1)
  distance = _messages.FloatField(2)


class GoogleCloudAiplatformV1beta1EvaluateDatasetRequest(_messages.Message):
  r"""Request message for EvaluationService.EvaluateDataset.

  Fields:
    autoraterConfig: Optional. Autorater config used for evaluation.
    dataset: Required. The dataset used for evaluation.
    metrics: Required. The metrics used for evaluation.
    outputConfig: Required. Config for evaluation output.
  """

  autoraterConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1AutoraterConfig', 1)
  dataset = _messages.MessageField('GoogleCloudAiplatformV1beta1EvaluationDataset', 2)
  metrics = _messages.MessageField('GoogleCloudAiplatformV1beta1Metric', 3, repeated=True)
  outputConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1OutputConfig', 4)


class GoogleCloudAiplatformV1beta1EvaluateInstancesRequest(_messages.Message):
  r"""Request message for EvaluationService.EvaluateInstances.

  Fields:
    autoraterConfig: Optional. Autorater config used for evaluation.
    bleuInput: Instances and metric spec for bleu metric.
    coherenceInput: Input for coherence metric.
    cometInput: Translation metrics. Input for Comet metric.
    exactMatchInput: Auto metric instances. Instances and metric spec for
      exact match metric.
    fluencyInput: LLM-based metric instance. General text generation metrics,
      applicable to other categories. Input for fluency metric.
    fulfillmentInput: Input for fulfillment metric.
    groundednessInput: Input for groundedness metric.
    metricxInput: Input for Metricx metric.
    pairwiseMetricInput: Input for pairwise metric.
    pairwiseQuestionAnsweringQualityInput: Input for pairwise question
      answering quality metric.
    pairwiseSummarizationQualityInput: Input for pairwise summarization
      quality metric.
    pointwiseMetricInput: Input for pointwise metric.
    questionAnsweringCorrectnessInput: Input for question answering
      correctness metric.
    questionAnsweringHelpfulnessInput: Input for question answering
      helpfulness metric.
    questionAnsweringQualityInput: Input for question answering quality
      metric.
    questionAnsweringRelevanceInput: Input for question answering relevance
      metric.
    rougeInput: Instances and metric spec for rouge metric.
    safetyInput: Input for safety metric.
    summarizationHelpfulnessInput: Input for summarization helpfulness metric.
    summarizationQualityInput: Input for summarization quality metric.
    summarizationVerbosityInput: Input for summarization verbosity metric.
    toolCallValidInput: Tool call metric instances. Input for tool call valid
      metric.
    toolNameMatchInput: Input for tool name match metric.
    toolParameterKeyMatchInput: Input for tool parameter key match metric.
    toolParameterKvMatchInput: Input for tool parameter key value match
      metric.
    trajectoryAnyOrderMatchInput: Input for trajectory match any order metric.
    trajectoryExactMatchInput: Input for trajectory exact match metric.
    trajectoryInOrderMatchInput: Input for trajectory in order match metric.
    trajectoryPrecisionInput: Input for trajectory precision metric.
    trajectoryRecallInput: Input for trajectory recall metric.
    trajectorySingleToolUseInput: Input for trajectory single tool use metric.
  """

  autoraterConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1AutoraterConfig', 1)
  bleuInput = _messages.MessageField('GoogleCloudAiplatformV1beta1BleuInput', 2)
  coherenceInput = _messages.MessageField('GoogleCloudAiplatformV1beta1CoherenceInput', 3)
  cometInput = _messages.MessageField('GoogleCloudAiplatformV1beta1CometInput', 4)
  exactMatchInput = _messages.MessageField('GoogleCloudAiplatformV1beta1ExactMatchInput', 5)
  fluencyInput = _messages.MessageField('GoogleCloudAiplatformV1beta1FluencyInput', 6)
  fulfillmentInput = _messages.MessageField('GoogleCloudAiplatformV1beta1FulfillmentInput', 7)
  groundednessInput = _messages.MessageField('GoogleCloudAiplatformV1beta1GroundednessInput', 8)
  metricxInput = _messages.MessageField('GoogleCloudAiplatformV1beta1MetricxInput', 9)
  pairwiseMetricInput = _messages.MessageField('GoogleCloudAiplatformV1beta1PairwiseMetricInput', 10)
  pairwiseQuestionAnsweringQualityInput = _messages.MessageField('GoogleCloudAiplatformV1beta1PairwiseQuestionAnsweringQualityInput', 11)
  pairwiseSummarizationQualityInput = _messages.MessageField('GoogleCloudAiplatformV1beta1PairwiseSummarizationQualityInput', 12)
  pointwiseMetricInput = _messages.MessageField('GoogleCloudAiplatformV1beta1PointwiseMetricInput', 13)
  questionAnsweringCorrectnessInput = _messages.MessageField('GoogleCloudAiplatformV1beta1QuestionAnsweringCorrectnessInput', 14)
  questionAnsweringHelpfulnessInput = _messages.MessageField('GoogleCloudAiplatformV1beta1QuestionAnsweringHelpfulnessInput', 15)
  questionAnsweringQualityInput = _messages.MessageField('GoogleCloudAiplatformV1beta1QuestionAnsweringQualityInput', 16)
  questionAnsweringRelevanceInput = _messages.MessageField('GoogleCloudAiplatformV1beta1QuestionAnsweringRelevanceInput', 17)
  rougeInput = _messages.MessageField('GoogleCloudAiplatformV1beta1RougeInput', 18)
  safetyInput = _messages.MessageField('GoogleCloudAiplatformV1beta1SafetyInput', 19)
  summarizationHelpfulnessInput = _messages.MessageField('GoogleCloudAiplatformV1beta1SummarizationHelpfulnessInput', 20)
  summarizationQualityInput = _messages.MessageField('GoogleCloudAiplatformV1beta1SummarizationQualityInput', 21)
  summarizationVerbosityInput = _messages.MessageField('GoogleCloudAiplatformV1beta1SummarizationVerbosityInput', 22)
  toolCallValidInput = _messages.MessageField('GoogleCloudAiplatformV1beta1ToolCallValidInput', 23)
  toolNameMatchInput = _messages.MessageField('GoogleCloudAiplatformV1beta1ToolNameMatchInput', 24)
  toolParameterKeyMatchInput = _messages.MessageField('GoogleCloudAiplatformV1beta1ToolParameterKeyMatchInput', 25)
  toolParameterKvMatchInput = _messages.MessageField('GoogleCloudAiplatformV1beta1ToolParameterKVMatchInput', 26)
  trajectoryAnyOrderMatchInput = _messages.MessageField('GoogleCloudAiplatformV1beta1TrajectoryAnyOrderMatchInput', 27)
  trajectoryExactMatchInput = _messages.MessageField('GoogleCloudAiplatformV1beta1TrajectoryExactMatchInput', 28)
  trajectoryInOrderMatchInput = _messages.MessageField('GoogleCloudAiplatformV1beta1TrajectoryInOrderMatchInput', 29)
  trajectoryPrecisionInput = _messages.MessageField('GoogleCloudAiplatformV1beta1TrajectoryPrecisionInput', 30)
  trajectoryRecallInput = _messages.MessageField('GoogleCloudAiplatformV1beta1TrajectoryRecallInput', 31)
  trajectorySingleToolUseInput = _messages.MessageField('GoogleCloudAiplatformV1beta1TrajectorySingleToolUseInput', 32)


class GoogleCloudAiplatformV1beta1EvaluateInstancesResponse(_messages.Message):
  r"""Response message for EvaluationService.EvaluateInstances.

  Fields:
    bleuResults: Results for bleu metric.
    coherenceResult: Result for coherence metric.
    cometResult: Translation metrics. Result for Comet metric.
    exactMatchResults: Auto metric evaluation results. Results for exact match
      metric.
    fluencyResult: LLM-based metric evaluation result. General text generation
      metrics, applicable to other categories. Result for fluency metric.
    fulfillmentResult: Result for fulfillment metric.
    groundednessResult: Result for groundedness metric.
    metricxResult: Result for Metricx metric.
    pairwiseMetricResult: Result for pairwise metric.
    pairwiseQuestionAnsweringQualityResult: Result for pairwise question
      answering quality metric.
    pairwiseSummarizationQualityResult: Result for pairwise summarization
      quality metric.
    pointwiseMetricResult: Generic metrics. Result for pointwise metric.
    questionAnsweringCorrectnessResult: Result for question answering
      correctness metric.
    questionAnsweringHelpfulnessResult: Result for question answering
      helpfulness metric.
    questionAnsweringQualityResult: Question answering only metrics. Result
      for question answering quality metric.
    questionAnsweringRelevanceResult: Result for question answering relevance
      metric.
    rougeResults: Results for rouge metric.
    safetyResult: Result for safety metric.
    summarizationHelpfulnessResult: Result for summarization helpfulness
      metric.
    summarizationQualityResult: Summarization only metrics. Result for
      summarization quality metric.
    summarizationVerbosityResult: Result for summarization verbosity metric.
    toolCallValidResults: Tool call metrics. Results for tool call valid
      metric.
    toolNameMatchResults: Results for tool name match metric.
    toolParameterKeyMatchResults: Results for tool parameter key match metric.
    toolParameterKvMatchResults: Results for tool parameter key value match
      metric.
    trajectoryAnyOrderMatchResults: Result for trajectory any order match
      metric.
    trajectoryExactMatchResults: Result for trajectory exact match metric.
    trajectoryInOrderMatchResults: Result for trajectory in order match
      metric.
    trajectoryPrecisionResults: Result for trajectory precision metric.
    trajectoryRecallResults: Results for trajectory recall metric.
    trajectorySingleToolUseResults: Results for trajectory single tool use
      metric.
  """

  bleuResults = _messages.MessageField('GoogleCloudAiplatformV1beta1BleuResults', 1)
  coherenceResult = _messages.MessageField('GoogleCloudAiplatformV1beta1CoherenceResult', 2)
  cometResult = _messages.MessageField('GoogleCloudAiplatformV1beta1CometResult', 3)
  exactMatchResults = _messages.MessageField('GoogleCloudAiplatformV1beta1ExactMatchResults', 4)
  fluencyResult = _messages.MessageField('GoogleCloudAiplatformV1beta1FluencyResult', 5)
  fulfillmentResult = _messages.MessageField('GoogleCloudAiplatformV1beta1FulfillmentResult', 6)
  groundednessResult = _messages.MessageField('GoogleCloudAiplatformV1beta1GroundednessResult', 7)
  metricxResult = _messages.MessageField('GoogleCloudAiplatformV1beta1MetricxResult', 8)
  pairwiseMetricResult = _messages.MessageField('GoogleCloudAiplatformV1beta1PairwiseMetricResult', 9)
  pairwiseQuestionAnsweringQualityResult = _messages.MessageField('GoogleCloudAiplatformV1beta1PairwiseQuestionAnsweringQualityResult', 10)
  pairwiseSummarizationQualityResult = _messages.MessageField('GoogleCloudAiplatformV1beta1PairwiseSummarizationQualityResult', 11)
  pointwiseMetricResult = _messages.MessageField('GoogleCloudAiplatformV1beta1PointwiseMetricResult', 12)
  questionAnsweringCorrectnessResult = _messages.MessageField('GoogleCloudAiplatformV1beta1QuestionAnsweringCorrectnessResult', 13)
  questionAnsweringHelpfulnessResult = _messages.MessageField('GoogleCloudAiplatformV1beta1QuestionAnsweringHelpfulnessResult', 14)
  questionAnsweringQualityResult = _messages.MessageField('GoogleCloudAiplatformV1beta1QuestionAnsweringQualityResult', 15)
  questionAnsweringRelevanceResult = _messages.MessageField('GoogleCloudAiplatformV1beta1QuestionAnsweringRelevanceResult', 16)
  rougeResults = _messages.MessageField('GoogleCloudAiplatformV1beta1RougeResults', 17)
  safetyResult = _messages.MessageField('GoogleCloudAiplatformV1beta1SafetyResult', 18)
  summarizationHelpfulnessResult = _messages.MessageField('GoogleCloudAiplatformV1beta1SummarizationHelpfulnessResult', 19)
  summarizationQualityResult = _messages.MessageField('GoogleCloudAiplatformV1beta1SummarizationQualityResult', 20)
  summarizationVerbosityResult = _messages.MessageField('GoogleCloudAiplatformV1beta1SummarizationVerbosityResult', 21)
  toolCallValidResults = _messages.MessageField('GoogleCloudAiplatformV1beta1ToolCallValidResults', 22)
  toolNameMatchResults = _messages.MessageField('GoogleCloudAiplatformV1beta1ToolNameMatchResults', 23)
  toolParameterKeyMatchResults = _messages.MessageField('GoogleCloudAiplatformV1beta1ToolParameterKeyMatchResults', 24)
  toolParameterKvMatchResults = _messages.MessageField('GoogleCloudAiplatformV1beta1ToolParameterKVMatchResults', 25)
  trajectoryAnyOrderMatchResults = _messages.MessageField('GoogleCloudAiplatformV1beta1TrajectoryAnyOrderMatchResults', 26)
  trajectoryExactMatchResults = _messages.MessageField('GoogleCloudAiplatformV1beta1TrajectoryExactMatchResults', 27)
  trajectoryInOrderMatchResults = _messages.MessageField('GoogleCloudAiplatformV1beta1TrajectoryInOrderMatchResults', 28)
  trajectoryPrecisionResults = _messages.MessageField('GoogleCloudAiplatformV1beta1TrajectoryPrecisionResults', 29)
  trajectoryRecallResults = _messages.MessageField('GoogleCloudAiplatformV1beta1TrajectoryRecallResults', 30)
  trajectorySingleToolUseResults = _messages.MessageField('GoogleCloudAiplatformV1beta1TrajectorySingleToolUseResults', 31)


class GoogleCloudAiplatformV1beta1EvaluatedAnnotation(_messages.Message):
  r"""True positive, false positive, or false negative. EvaluatedAnnotation is
  only available under ModelEvaluationSlice with slice of `annotationSpec`
  dimension.

  Enums:
    TypeValueValuesEnum: Output only. Type of the EvaluatedAnnotation.

  Fields:
    dataItemPayload: Output only. The data item payload that the Model
      predicted this EvaluatedAnnotation on.
    errorAnalysisAnnotations: Annotations of model error analysis results.
    evaluatedDataItemViewId: Output only. ID of the EvaluatedDataItemView
      under the same ancestor ModelEvaluation. The EvaluatedDataItemView
      consists of all ground truths and predictions on data_item_payload.
    explanations: Explanations of predictions. Each element of the
      explanations indicates the explanation for one explanation Method. The
      attributions list in the EvaluatedAnnotationExplanation.explanation
      object corresponds to the predictions list. For example, the second
      element in the attributions list explains the second element in the
      predictions list.
    groundTruths: Output only. The ground truth Annotations, i.e. the
      Annotations that exist in the test data the Model is evaluated on. For
      true positive, there is one and only one ground truth annotation, which
      matches the only prediction in predictions. For false positive, there
      are zero or more ground truth annotations that are similar to the only
      prediction in predictions, but not enough for a match. For false
      negative, there is one and only one ground truth annotation, which
      doesn't match any predictions created by the model. The schema of the
      ground truth is stored in ModelEvaluation.annotation_schema_uri
    predictions: Output only. The model predicted annotations. For true
      positive, there is one and only one prediction, which matches the only
      one ground truth annotation in ground_truths. For false positive, there
      is one and only one prediction, which doesn't match any ground truth
      annotation of the corresponding data_item_view_id. For false negative,
      there are zero or more predictions which are similar to the only ground
      truth annotation in ground_truths but not enough for a match. The schema
      of the prediction is stored in ModelEvaluation.annotation_schema_uri
    type: Output only. Type of the EvaluatedAnnotation.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Output only. Type of the EvaluatedAnnotation.

    Values:
      EVALUATED_ANNOTATION_TYPE_UNSPECIFIED: Invalid value.
      TRUE_POSITIVE: The EvaluatedAnnotation is a true positive. It has a
        prediction created by the Model and a ground truth Annotation which
        the prediction matches.
      FALSE_POSITIVE: The EvaluatedAnnotation is false positive. It has a
        prediction created by the Model which does not match any ground truth
        annotation.
      FALSE_NEGATIVE: The EvaluatedAnnotation is false negative. It has a
        ground truth annotation which is not matched by any of the model
        created predictions.
    """
    EVALUATED_ANNOTATION_TYPE_UNSPECIFIED = 0
    TRUE_POSITIVE = 1
    FALSE_POSITIVE = 2
    FALSE_NEGATIVE = 3

  dataItemPayload = _messages.MessageField('extra_types.JsonValue', 1)
  errorAnalysisAnnotations = _messages.MessageField('GoogleCloudAiplatformV1beta1ErrorAnalysisAnnotation', 2, repeated=True)
  evaluatedDataItemViewId = _messages.StringField(3)
  explanations = _messages.MessageField('GoogleCloudAiplatformV1beta1EvaluatedAnnotationExplanation', 4, repeated=True)
  groundTruths = _messages.MessageField('extra_types.JsonValue', 5, repeated=True)
  predictions = _messages.MessageField('extra_types.JsonValue', 6, repeated=True)
  type = _messages.EnumField('TypeValueValuesEnum', 7)


class GoogleCloudAiplatformV1beta1EvaluatedAnnotationExplanation(_messages.Message):
  r"""Explanation result of the prediction produced by the Model.

  Fields:
    explanation: Explanation attribution response details.
    explanationType: Explanation type. For AutoML Image Classification models,
      possible values are: * `image-integrated-gradients` * `image-xrai`
  """

  explanation = _messages.MessageField('GoogleCloudAiplatformV1beta1Explanation', 1)
  explanationType = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1EvaluationDataset(_messages.Message):
  r"""The dataset used for evaluation.

  Fields:
    bigquerySource: BigQuery source holds the dataset.
    gcsSource: Cloud storage source holds the dataset.
  """

  bigquerySource = _messages.MessageField('GoogleCloudAiplatformV1beta1BigQuerySource', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1beta1GcsSource', 2)


class GoogleCloudAiplatformV1beta1Event(_messages.Message):
  r"""An edge describing the relationship between an Artifact and an Execution
  in a lineage graph.

  Enums:
    TypeValueValuesEnum: Required. The type of the Event.

  Messages:
    LabelsValue: The labels with user-defined metadata to annotate Events.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. No more
      than 64 user labels can be associated with one Event (System labels are
      excluded). See https://goo.gl/xmQnxf for more information and examples
      of labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable.

  Fields:
    artifact: Required. The relative resource name of the Artifact in the
      Event.
    eventTime: Output only. Time the Event occurred.
    execution: Output only. The relative resource name of the Execution in the
      Event.
    labels: The labels with user-defined metadata to annotate Events. Label
      keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. No more
      than 64 user labels can be associated with one Event (System labels are
      excluded). See https://goo.gl/xmQnxf for more information and examples
      of labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable.
    type: Required. The type of the Event.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of the Event.

    Values:
      TYPE_UNSPECIFIED: Unspecified whether input or output of the Execution.
      INPUT: An input of the Execution.
      OUTPUT: An output of the Execution.
    """
    TYPE_UNSPECIFIED = 0
    INPUT = 1
    OUTPUT = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to annotate Events. Label keys
    and values can be no longer than 64 characters (Unicode codepoints), can
    only contain lowercase letters, numeric characters, underscores and
    dashes. International characters are allowed. No more than 64 user labels
    can be associated with one Event (System labels are excluded). See
    https://goo.gl/xmQnxf for more information and examples of labels. System
    reserved label keys are prefixed with "aiplatform.googleapis.com/" and are
    immutable.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  artifact = _messages.StringField(1)
  eventTime = _messages.StringField(2)
  execution = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  type = _messages.EnumField('TypeValueValuesEnum', 5)


class GoogleCloudAiplatformV1beta1ExactMatchInput(_messages.Message):
  r"""Input for exact match metric.

  Fields:
    instances: Required. Repeated exact match instances.
    metricSpec: Required. Spec for exact match metric.
  """

  instances = _messages.MessageField('GoogleCloudAiplatformV1beta1ExactMatchInstance', 1, repeated=True)
  metricSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1ExactMatchSpec', 2)


class GoogleCloudAiplatformV1beta1ExactMatchInstance(_messages.Message):
  r"""Spec for exact match instance.

  Fields:
    prediction: Required. Output of the evaluated model.
    reference: Required. Ground truth used to compare against the prediction.
  """

  prediction = _messages.StringField(1)
  reference = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ExactMatchMetricValue(_messages.Message):
  r"""Exact match metric value for an instance.

  Fields:
    score: Output only. Exact match score.
  """

  score = _messages.FloatField(1, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1beta1ExactMatchResults(_messages.Message):
  r"""Results for exact match metric.

  Fields:
    exactMatchMetricValues: Output only. Exact match metric values.
  """

  exactMatchMetricValues = _messages.MessageField('GoogleCloudAiplatformV1beta1ExactMatchMetricValue', 1, repeated=True)


class GoogleCloudAiplatformV1beta1ExactMatchSpec(_messages.Message):
  r"""Spec for exact match metric - returns 1 if prediction and reference
  exactly matches, otherwise 0.
  """



class GoogleCloudAiplatformV1beta1Examples(_messages.Message):
  r"""Example-based explainability that returns the nearest neighbors from the
  provided dataset.

  Fields:
    exampleGcsSource: The Cloud Storage input instances.
    gcsSource: The Cloud Storage locations that contain the instances to be
      indexed for approximate nearest neighbor search.
    nearestNeighborSearchConfig: The full configuration for the generated
      index, the semantics are the same as metadata and should match
      [NearestNeighborSearchConfig](https://cloud.google.com/vertex-
      ai/docs/explainable-ai/configuring-explanations-example-based#nearest-
      neighbor-search-config).
    neighborCount: The number of neighbors to return when querying for
      examples.
    presets: Simplified preset configuration, which automatically sets
      configuration values based on the desired query speed-precision trade-
      off and modality.
  """

  exampleGcsSource = _messages.MessageField('GoogleCloudAiplatformV1beta1ExamplesExampleGcsSource', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1beta1GcsSource', 2)
  nearestNeighborSearchConfig = _messages.MessageField('extra_types.JsonValue', 3)
  neighborCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  presets = _messages.MessageField('GoogleCloudAiplatformV1beta1Presets', 5)


class GoogleCloudAiplatformV1beta1ExamplesExampleGcsSource(_messages.Message):
  r"""The Cloud Storage input instances.

  Enums:
    DataFormatValueValuesEnum: The format in which instances are given, if not
      specified, assume it's JSONL format. Currently only JSONL format is
      supported.

  Fields:
    dataFormat: The format in which instances are given, if not specified,
      assume it's JSONL format. Currently only JSONL format is supported.
    gcsSource: The Cloud Storage location for the input instances.
  """

  class DataFormatValueValuesEnum(_messages.Enum):
    r"""The format in which instances are given, if not specified, assume it's
    JSONL format. Currently only JSONL format is supported.

    Values:
      DATA_FORMAT_UNSPECIFIED: Format unspecified, used when unset.
      JSONL: Examples are stored in JSONL files.
    """
    DATA_FORMAT_UNSPECIFIED = 0
    JSONL = 1

  dataFormat = _messages.EnumField('DataFormatValueValuesEnum', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1beta1GcsSource', 2)


class GoogleCloudAiplatformV1beta1ExamplesOverride(_messages.Message):
  r"""Overrides for example-based explanations.

  Enums:
    DataFormatValueValuesEnum: The format of the data being provided with each
      call.

  Fields:
    crowdingCount: The number of neighbors to return that have the same
      crowding tag.
    dataFormat: The format of the data being provided with each call.
    neighborCount: The number of neighbors to return.
    restrictions: Restrict the resulting nearest neighbors to respect these
      constraints.
    returnEmbeddings: If true, return the embeddings instead of neighbors.
  """

  class DataFormatValueValuesEnum(_messages.Enum):
    r"""The format of the data being provided with each call.

    Values:
      DATA_FORMAT_UNSPECIFIED: Unspecified format. Must not be used.
      INSTANCES: Provided data is a set of model inputs.
      EMBEDDINGS: Provided data is a set of embeddings.
    """
    DATA_FORMAT_UNSPECIFIED = 0
    INSTANCES = 1
    EMBEDDINGS = 2

  crowdingCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  dataFormat = _messages.EnumField('DataFormatValueValuesEnum', 2)
  neighborCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  restrictions = _messages.MessageField('GoogleCloudAiplatformV1beta1ExamplesRestrictionsNamespace', 4, repeated=True)
  returnEmbeddings = _messages.BooleanField(5)


class GoogleCloudAiplatformV1beta1ExamplesRestrictionsNamespace(_messages.Message):
  r"""Restrictions namespace for example-based explanations overrides.

  Fields:
    allow: The list of allowed tags.
    deny: The list of deny tags.
    namespaceName: The namespace name.
  """

  allow = _messages.StringField(1, repeated=True)
  deny = _messages.StringField(2, repeated=True)
  namespaceName = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1ExecutableCode(_messages.Message):
  r"""Code generated by the model that is meant to be executed, and the result
  returned to the model. Generated when using the [FunctionDeclaration] tool
  and [FunctionCallingConfig] mode is set to [Mode.CODE].

  Enums:
    LanguageValueValuesEnum: Required. Programming language of the `code`.

  Fields:
    code: Required. The code to be executed.
    language: Required. Programming language of the `code`.
  """

  class LanguageValueValuesEnum(_messages.Enum):
    r"""Required. Programming language of the `code`.

    Values:
      LANGUAGE_UNSPECIFIED: Unspecified language. This value should not be
        used.
      PYTHON: Python >= 3.10, with numpy and simpy available.
    """
    LANGUAGE_UNSPECIFIED = 0
    PYTHON = 1

  code = _messages.StringField(1)
  language = _messages.EnumField('LanguageValueValuesEnum', 2)


class GoogleCloudAiplatformV1beta1ExecuteExtensionRequest(_messages.Message):
  r"""Request message for ExtensionExecutionService.ExecuteExtension.

  Messages:
    OperationParamsValue: Optional. Request parameters that will be used for
      executing this operation. The struct should be in a form of map with
      param name as the key and actual param value as the value. E.g. If this
      operation requires a param "name" to be set to "abc". you can set this
      to something like {"name": "abc"}.

  Fields:
    operationId: Required. The desired ID of the operation to be executed in
      this extension as defined in ExtensionOperation.operation_id.
    operationParams: Optional. Request parameters that will be used for
      executing this operation. The struct should be in a form of map with
      param name as the key and actual param value as the value. E.g. If this
      operation requires a param "name" to be set to "abc". you can set this
      to something like {"name": "abc"}.
    runtimeAuthConfig: Optional. Auth config provided at runtime to override
      the default value in Extension.manifest.auth_config. The
      AuthConfig.auth_type should match the value in
      Extension.manifest.auth_config.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class OperationParamsValue(_messages.Message):
    r"""Optional. Request parameters that will be used for executing this
    operation. The struct should be in a form of map with param name as the
    key and actual param value as the value. E.g. If this operation requires a
    param "name" to be set to "abc". you can set this to something like
    {"name": "abc"}.

    Messages:
      AdditionalProperty: An additional property for a OperationParamsValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a OperationParamsValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  operationId = _messages.StringField(1)
  operationParams = _messages.MessageField('OperationParamsValue', 2)
  runtimeAuthConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1AuthConfig', 3)


class GoogleCloudAiplatformV1beta1ExecuteExtensionResponse(_messages.Message):
  r"""Response message for ExtensionExecutionService.ExecuteExtension.

  Fields:
    content: Response content from the extension. The content should be
      conformant to the response.content schema in the extension's
      manifest/OpenAPI spec.
  """

  content = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1Execution(_messages.Message):
  r"""Instance of a general execution.

  Enums:
    StateValueValuesEnum: The state of this Execution. This is a property of
      the Execution, and does not imply or capture any ongoing process. This
      property is managed by clients (such as Vertex AI Pipelines) and the
      system does not prescribe or check the validity of state transitions.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      Executions. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one
      Execution (System labels are excluded).
    MetadataValue: Properties of the Execution. Top level metadata keys'
      heading and trailing spaces will be trimmed. The size of this field
      should not exceed 200KB.

  Fields:
    createTime: Output only. Timestamp when this Execution was created.
    description: Description of the Execution
    displayName: User provided display name of the Execution. May be up to 128
      Unicode characters.
    etag: An eTag used to perform consistent read-modify-write updates. If not
      set, a blind "overwrite" update happens.
    labels: The labels with user-defined metadata to organize your Executions.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. No more
      than 64 user labels can be associated with one Execution (System labels
      are excluded).
    metadata: Properties of the Execution. Top level metadata keys' heading
      and trailing spaces will be trimmed. The size of this field should not
      exceed 200KB.
    name: Output only. The resource name of the Execution.
    schemaTitle: The title of the schema describing the metadata. Schema title
      and version is expected to be registered in earlier Create Schema calls.
      And both are used together as unique identifiers to identify schemas
      within the local metadata store.
    schemaVersion: The version of the schema in `schema_title` to use. Schema
      title and version is expected to be registered in earlier Create Schema
      calls. And both are used together as unique identifiers to identify
      schemas within the local metadata store.
    state: The state of this Execution. This is a property of the Execution,
      and does not imply or capture any ongoing process. This property is
      managed by clients (such as Vertex AI Pipelines) and the system does not
      prescribe or check the validity of state transitions.
    updateTime: Output only. Timestamp when this Execution was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of this Execution. This is a property of the Execution, and
    does not imply or capture any ongoing process. This property is managed by
    clients (such as Vertex AI Pipelines) and the system does not prescribe or
    check the validity of state transitions.

    Values:
      STATE_UNSPECIFIED: Unspecified Execution state
      NEW: The Execution is new
      RUNNING: The Execution is running
      COMPLETE: The Execution has finished running
      FAILED: The Execution has failed
      CACHED: The Execution completed through Cache hit.
      CANCELLED: The Execution was cancelled.
    """
    STATE_UNSPECIFIED = 0
    NEW = 1
    RUNNING = 2
    COMPLETE = 3
    FAILED = 4
    CACHED = 5
    CANCELLED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your Executions.
    Label keys and values can be no longer than 64 characters (Unicode
    codepoints), can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. No more than
    64 user labels can be associated with one Execution (System labels are
    excluded).

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Properties of the Execution. Top level metadata keys' heading and
    trailing spaces will be trimmed. The size of this field should not exceed
    200KB.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  etag = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  metadata = _messages.MessageField('MetadataValue', 6)
  name = _messages.StringField(7)
  schemaTitle = _messages.StringField(8)
  schemaVersion = _messages.StringField(9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  updateTime = _messages.StringField(11)


class GoogleCloudAiplatformV1beta1ExplainRequest(_messages.Message):
  r"""Request message for PredictionService.Explain.

  Messages:
    ConcurrentExplanationSpecOverrideValue: Optional. This field is the same
      as the one above, but supports multiple explanations to occur in
      parallel. The key can be any string. Each override will be run against
      the model, then its explanations will be grouped together. Note - these
      explanations are run **In Addition** to the default Explanation in the
      deployed model.

  Fields:
    concurrentExplanationSpecOverride: Optional. This field is the same as the
      one above, but supports multiple explanations to occur in parallel. The
      key can be any string. Each override will be run against the model, then
      its explanations will be grouped together. Note - these explanations are
      run **In Addition** to the default Explanation in the deployed model.
    deployedModelId: If specified, this ExplainRequest will be served by the
      chosen DeployedModel, overriding Endpoint.traffic_split.
    explanationSpecOverride: If specified, overrides the explanation_spec of
      the DeployedModel. Can be used for explaining prediction results with
      different configurations, such as: - Explaining top-5 predictions
      results as opposed to top-1; - Increasing path count or step count of
      the attribution methods to reduce approximate errors; - Using different
      baselines for explaining the prediction results.
    instances: Required. The instances that are the input to the explanation
      call. A DeployedModel may have an upper limit on the number of instances
      it supports per request, and when it is exceeded the explanation call
      errors in case of AutoML Models, or, in case of customer created Models,
      the behaviour is as documented by that Model. The schema of any single
      instance may be specified via Endpoint's DeployedModels' Model's
      PredictSchemata's instance_schema_uri.
    parameters: The parameters that govern the prediction. The schema of the
      parameters may be specified via Endpoint's DeployedModels' Model's
      PredictSchemata's parameters_schema_uri.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ConcurrentExplanationSpecOverrideValue(_messages.Message):
    r"""Optional. This field is the same as the one above, but supports
    multiple explanations to occur in parallel. The key can be any string.
    Each override will be run against the model, then its explanations will be
    grouped together. Note - these explanations are run **In Addition** to the
    default Explanation in the deployed model.

    Messages:
      AdditionalProperty: An additional property for a
        ConcurrentExplanationSpecOverrideValue object.

    Fields:
      additionalProperties: Additional properties of type
        ConcurrentExplanationSpecOverrideValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ConcurrentExplanationSpecOverrideValue
      object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformV1beta1ExplanationSpecOverride
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationSpecOverride', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  concurrentExplanationSpecOverride = _messages.MessageField('ConcurrentExplanationSpecOverrideValue', 1)
  deployedModelId = _messages.StringField(2)
  explanationSpecOverride = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationSpecOverride', 3)
  instances = _messages.MessageField('extra_types.JsonValue', 4, repeated=True)
  parameters = _messages.MessageField('extra_types.JsonValue', 5)


class GoogleCloudAiplatformV1beta1ExplainResponse(_messages.Message):
  r"""Response message for PredictionService.Explain.

  Messages:
    ConcurrentExplanationsValue: This field stores the results of the
      explanations run in parallel with The default explanation
      strategy/method.

  Fields:
    concurrentExplanations: This field stores the results of the explanations
      run in parallel with The default explanation strategy/method.
    deployedModelId: ID of the Endpoint's DeployedModel that served this
      explanation.
    explanations: The explanations of the Model's PredictResponse.predictions.
      It has the same number of elements as instances to be explained.
    predictions: The predictions that are the output of the predictions call.
      Same as PredictResponse.predictions.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ConcurrentExplanationsValue(_messages.Message):
    r"""This field stores the results of the explanations run in parallel with
    The default explanation strategy/method.

    Messages:
      AdditionalProperty: An additional property for a
        ConcurrentExplanationsValue object.

    Fields:
      additionalProperties: Additional properties of type
        ConcurrentExplanationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ConcurrentExplanationsValue object.

      Fields:
        key: Name of the additional property.
        value: A
          GoogleCloudAiplatformV1beta1ExplainResponseConcurrentExplanation
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplainResponseConcurrentExplanation', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  concurrentExplanations = _messages.MessageField('ConcurrentExplanationsValue', 1)
  deployedModelId = _messages.StringField(2)
  explanations = _messages.MessageField('GoogleCloudAiplatformV1beta1Explanation', 3, repeated=True)
  predictions = _messages.MessageField('extra_types.JsonValue', 4, repeated=True)


class GoogleCloudAiplatformV1beta1ExplainResponseConcurrentExplanation(_messages.Message):
  r"""This message is a wrapper grouping Concurrent Explanations.

  Fields:
    explanations: The explanations of the Model's PredictResponse.predictions.
      It has the same number of elements as instances to be explained.
  """

  explanations = _messages.MessageField('GoogleCloudAiplatformV1beta1Explanation', 1, repeated=True)


class GoogleCloudAiplatformV1beta1Explanation(_messages.Message):
  r"""Explanation of a prediction (provided in PredictResponse.predictions)
  produced by the Model on a given instance.

  Fields:
    attributions: Output only. Feature attributions grouped by predicted
      outputs. For Models that predict only one output, such as regression
      Models that predict only one score, there is only one attibution that
      explains the predicted output. For Models that predict multiple outputs,
      such as multiclass Models that predict multiple classes, each element
      explains one specific item. Attribution.output_index can be used to
      identify which output this attribution is explaining. By default, we
      provide Shapley values for the predicted class. However, you can
      configure the explanation request to generate Shapley values for any
      other classes too. For example, if a model predicts a probability of
      `0.4` for approving a loan application, the model's decision is to
      reject the application since `p(reject) = 0.6 > p(approve) = 0.4`, and
      the default Shapley values would be computed for rejection decision and
      not approval, even though the latter might be the positive class. If
      users set ExplanationParameters.top_k, the attributions are sorted by
      instance_output_value in descending order. If
      ExplanationParameters.output_indices is specified, the attributions are
      stored by Attribution.output_index in the same order as they appear in
      the output_indices.
    neighbors: Output only. List of the nearest neighbors for example-based
      explanations. For models deployed with the examples explanations feature
      enabled, the attributions field is empty and instead the neighbors field
      is populated.
  """

  attributions = _messages.MessageField('GoogleCloudAiplatformV1beta1Attribution', 1, repeated=True)
  neighbors = _messages.MessageField('GoogleCloudAiplatformV1beta1Neighbor', 2, repeated=True)


class GoogleCloudAiplatformV1beta1ExplanationMetadata(_messages.Message):
  r"""Metadata describing the Model's input and output for explanation.

  Messages:
    InputsValue: Required. Map from feature names to feature input metadata.
      Keys are the name of the features. Values are the specification of the
      feature. An empty InputMetadata is valid. It describes a text feature
      which has the name specified as the key in ExplanationMetadata.inputs.
      The baseline of the empty feature is chosen by Vertex AI. For Vertex AI-
      provided Tensorflow images, the key can be any friendly name of the
      feature. Once specified, featureAttributions are keyed by this key (if
      not grouped with another feature). For custom images, the key must match
      with the key in instance.
    OutputsValue: Required. Map from output names to output metadata. For
      Vertex AI-provided Tensorflow images, keys can be any user defined
      string that consists of any UTF-8 characters. For custom images, keys
      are the name of the output field in the prediction to be explained.
      Currently only one key is allowed.

  Fields:
    featureAttributionsSchemaUri: Points to a YAML file stored on Google Cloud
      Storage describing the format of the feature attributions. The schema is
      defined as an OpenAPI 3.0.2 [Schema
      Object](https://github.com/OAI/OpenAPI-
      Specification/blob/main/versions/3.0.2.md#schemaObject). AutoML tabular
      Models always have this field populated by Vertex AI. Note: The URI
      given on output may be different, including the URI scheme, than the one
      given on input. The output URI will point to a location where the user
      only has a read access.
    inputs: Required. Map from feature names to feature input metadata. Keys
      are the name of the features. Values are the specification of the
      feature. An empty InputMetadata is valid. It describes a text feature
      which has the name specified as the key in ExplanationMetadata.inputs.
      The baseline of the empty feature is chosen by Vertex AI. For Vertex AI-
      provided Tensorflow images, the key can be any friendly name of the
      feature. Once specified, featureAttributions are keyed by this key (if
      not grouped with another feature). For custom images, the key must match
      with the key in instance.
    latentSpaceSource: Name of the source to generate embeddings for example
      based explanations.
    outputs: Required. Map from output names to output metadata. For Vertex
      AI-provided Tensorflow images, keys can be any user defined string that
      consists of any UTF-8 characters. For custom images, keys are the name
      of the output field in the prediction to be explained. Currently only
      one key is allowed.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InputsValue(_messages.Message):
    r"""Required. Map from feature names to feature input metadata. Keys are
    the name of the features. Values are the specification of the feature. An
    empty InputMetadata is valid. It describes a text feature which has the
    name specified as the key in ExplanationMetadata.inputs. The baseline of
    the empty feature is chosen by Vertex AI. For Vertex AI-provided
    Tensorflow images, the key can be any friendly name of the feature. Once
    specified, featureAttributions are keyed by this key (if not grouped with
    another feature). For custom images, the key must match with the key in
    instance.

    Messages:
      AdditionalProperty: An additional property for a InputsValue object.

    Fields:
      additionalProperties: Additional properties of type InputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InputsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadata
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadata', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class OutputsValue(_messages.Message):
    r"""Required. Map from output names to output metadata. For Vertex AI-
    provided Tensorflow images, keys can be any user defined string that
    consists of any UTF-8 characters. For custom images, keys are the name of
    the output field in the prediction to be explained. Currently only one key
    is allowed.

    Messages:
      AdditionalProperty: An additional property for a OutputsValue object.

    Fields:
      additionalProperties: Additional properties of type OutputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a OutputsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformV1beta1ExplanationMetadataOutputMetadata
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationMetadataOutputMetadata', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  featureAttributionsSchemaUri = _messages.StringField(1)
  inputs = _messages.MessageField('InputsValue', 2)
  latentSpaceSource = _messages.StringField(3)
  outputs = _messages.MessageField('OutputsValue', 4)


class GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadata(_messages.Message):
  r"""Metadata of the input of a feature. Fields other than
  InputMetadata.input_baselines are applicable only for Models that are using
  Vertex AI-provided images for Tensorflow.

  Enums:
    EncodingValueValuesEnum: Defines how the feature is encoded into the input
      tensor. Defaults to IDENTITY.

  Fields:
    denseShapeTensorName: Specifies the shape of the values of the input if
      the input is a sparse representation. Refer to Tensorflow documentation
      for more details:
      https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
    encodedBaselines: A list of baselines for the encoded tensor. The shape of
      each baseline should match the shape of the encoded tensor. If a scalar
      is provided, Vertex AI broadcasts to the same shape as the encoded
      tensor.
    encodedTensorName: Encoded tensor is a transformation of the input tensor.
      Must be provided if choosing Integrated Gradients attribution or XRAI
      attribution and the input tensor is not differentiable. An encoded
      tensor is generated if the input tensor is encoded by a lookup table.
    encoding: Defines how the feature is encoded into the input tensor.
      Defaults to IDENTITY.
    featureValueDomain: The domain details of the input feature value. Like
      min/max, original mean or standard deviation if normalized.
    groupName: Name of the group that the input belongs to. Features with the
      same group name will be treated as one feature when computing
      attributions. Features grouped together can have different shapes in
      value. If provided, there will be one single attribution generated in
      Attribution.feature_attributions, keyed by the group name.
    indexFeatureMapping: A list of feature names for each index in the input
      tensor. Required when the input InputMetadata.encoding is
      BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
    indicesTensorName: Specifies the index of the values of the input tensor.
      Required when the input tensor is a sparse representation. Refer to
      Tensorflow documentation for more details:
      https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
    inputBaselines: Baseline inputs for this feature. If no baseline is
      specified, Vertex AI chooses the baseline for this feature. If multiple
      baselines are specified, Vertex AI returns the average attributions
      across them in Attribution.feature_attributions. For Vertex AI-provided
      Tensorflow images (both 1.x and 2.x), the shape of each baseline must
      match the shape of the input tensor. If a scalar is provided, we
      broadcast to the same shape as the input tensor. For custom images, the
      element of the baselines must be in the same format as the feature's
      input in the instance[]. The schema of any single instance may be
      specified via Endpoint's DeployedModels' Model's PredictSchemata's
      instance_schema_uri.
    inputTensorName: Name of the input tensor for this feature. Required and
      is only applicable to Vertex AI-provided images for Tensorflow.
    modality: Modality of the feature. Valid values are: numeric, image.
      Defaults to numeric.
    visualization: Visualization configurations for image explanation.
  """

  class EncodingValueValuesEnum(_messages.Enum):
    r"""Defines how the feature is encoded into the input tensor. Defaults to
    IDENTITY.

    Values:
      ENCODING_UNSPECIFIED: Default value. This is the same as IDENTITY.
      IDENTITY: The tensor represents one feature.
      BAG_OF_FEATURES: The tensor represents a bag of features where each
        index maps to a feature. InputMetadata.index_feature_mapping must be
        provided for this encoding. For example: ``` input = [27, 6.0, 150]
        index_feature_mapping = ["age", "height", "weight"] ```
      BAG_OF_FEATURES_SPARSE: The tensor represents a bag of features where
        each index maps to a feature. Zero values in the tensor indicates
        feature being non-existent. InputMetadata.index_feature_mapping must
        be provided for this encoding. For example: ``` input = [2, 0, 5, 0,
        1] index_feature_mapping = ["a", "b", "c", "d", "e"] ```
      INDICATOR: The tensor is a list of binaries representing whether a
        feature exists or not (1 indicates existence).
        InputMetadata.index_feature_mapping must be provided for this
        encoding. For example: ``` input = [1, 0, 1, 0, 1]
        index_feature_mapping = ["a", "b", "c", "d", "e"] ```
      COMBINED_EMBEDDING: The tensor is encoded into a 1-dimensional array
        represented by an encoded tensor. InputMetadata.encoded_tensor_name
        must be provided for this encoding. For example: ``` input = ["This",
        "is", "a", "test", "."] encoded = [0.1, 0.2, 0.3, 0.4, 0.5] ```
      CONCAT_EMBEDDING: Select this encoding when the input tensor is encoded
        into a 2-dimensional array represented by an encoded tensor.
        InputMetadata.encoded_tensor_name must be provided for this encoding.
        The first dimension of the encoded tensor's shape is the same as the
        input tensor's shape. For example: ``` input = ["This", "is", "a",
        "test", "."] encoded = [[0.1, 0.2, 0.3, 0.4, 0.5], [0.2, 0.1, 0.4,
        0.3, 0.5], [0.5, 0.1, 0.3, 0.5, 0.4], [0.5, 0.3, 0.1, 0.2, 0.4], [0.4,
        0.3, 0.2, 0.5, 0.1]] ```
    """
    ENCODING_UNSPECIFIED = 0
    IDENTITY = 1
    BAG_OF_FEATURES = 2
    BAG_OF_FEATURES_SPARSE = 3
    INDICATOR = 4
    COMBINED_EMBEDDING = 5
    CONCAT_EMBEDDING = 6

  denseShapeTensorName = _messages.StringField(1)
  encodedBaselines = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)
  encodedTensorName = _messages.StringField(3)
  encoding = _messages.EnumField('EncodingValueValuesEnum', 4)
  featureValueDomain = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadataFeatureValueDomain', 5)
  groupName = _messages.StringField(6)
  indexFeatureMapping = _messages.StringField(7, repeated=True)
  indicesTensorName = _messages.StringField(8)
  inputBaselines = _messages.MessageField('extra_types.JsonValue', 9, repeated=True)
  inputTensorName = _messages.StringField(10)
  modality = _messages.StringField(11)
  visualization = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadataVisualization', 12)


class GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadataFeatureValueDomain(_messages.Message):
  r"""Domain details of the input feature value. Provides numeric information
  about the feature, such as its range (min, max). If the feature has been
  pre-processed, for example with z-scoring, then it provides information
  about how to recover the original feature. For example, if the input feature
  is an image and it has been pre-processed to obtain 0-mean and stddev = 1
  values, then original_mean, and original_stddev refer to the mean and stddev
  of the original feature (e.g. image tensor) from which input feature (with
  mean = 0 and stddev = 1) was obtained.

  Fields:
    maxValue: The maximum permissible value for this feature.
    minValue: The minimum permissible value for this feature.
    originalMean: If this input feature has been normalized to a mean value of
      0, the original_mean specifies the mean value of the domain prior to
      normalization.
    originalStddev: If this input feature has been normalized to a standard
      deviation of 1.0, the original_stddev specifies the standard deviation
      of the domain prior to normalization.
  """

  maxValue = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  minValue = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  originalMean = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  originalStddev = _messages.FloatField(4, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadataVisualization(_messages.Message):
  r"""Visualization configurations for image explanation.

  Enums:
    ColorMapValueValuesEnum: The color scheme used for the highlighted areas.
      Defaults to PINK_GREEN for Integrated Gradients attribution, which shows
      positive attributions in green and negative in pink. Defaults to VIRIDIS
      for XRAI attribution, which highlights the most influential regions in
      yellow and the least influential in blue.
    OverlayTypeValueValuesEnum: How the original image is displayed in the
      visualization. Adjusting the overlay can help increase visual clarity if
      the original image makes it difficult to view the visualization.
      Defaults to NONE.
    PolarityValueValuesEnum: Whether to only highlight pixels with positive
      contributions, negative or both. Defaults to POSITIVE.
    TypeValueValuesEnum: Type of the image visualization. Only applicable to
      Integrated Gradients attribution. OUTLINES shows regions of attribution,
      while PIXELS shows per-pixel attribution. Defaults to OUTLINES.

  Fields:
    clipPercentLowerbound: Excludes attributions below the specified
      percentile, from the highlighted areas. Defaults to 62.
    clipPercentUpperbound: Excludes attributions above the specified
      percentile from the highlighted areas. Using the clip_percent_upperbound
      and clip_percent_lowerbound together can be useful for filtering out
      noise and making it easier to see areas of strong attribution. Defaults
      to 99.9.
    colorMap: The color scheme used for the highlighted areas. Defaults to
      PINK_GREEN for Integrated Gradients attribution, which shows positive
      attributions in green and negative in pink. Defaults to VIRIDIS for XRAI
      attribution, which highlights the most influential regions in yellow and
      the least influential in blue.
    overlayType: How the original image is displayed in the visualization.
      Adjusting the overlay can help increase visual clarity if the original
      image makes it difficult to view the visualization. Defaults to NONE.
    polarity: Whether to only highlight pixels with positive contributions,
      negative or both. Defaults to POSITIVE.
    type: Type of the image visualization. Only applicable to Integrated
      Gradients attribution. OUTLINES shows regions of attribution, while
      PIXELS shows per-pixel attribution. Defaults to OUTLINES.
  """

  class ColorMapValueValuesEnum(_messages.Enum):
    r"""The color scheme used for the highlighted areas. Defaults to
    PINK_GREEN for Integrated Gradients attribution, which shows positive
    attributions in green and negative in pink. Defaults to VIRIDIS for XRAI
    attribution, which highlights the most influential regions in yellow and
    the least influential in blue.

    Values:
      COLOR_MAP_UNSPECIFIED: Should not be used.
      PINK_GREEN: Positive: green. Negative: pink.
      VIRIDIS: Viridis color map: A perceptually uniform color mapping which
        is easier to see by those with colorblindness and progresses from
        yellow to green to blue. Positive: yellow. Negative: blue.
      RED: Positive: red. Negative: red.
      GREEN: Positive: green. Negative: green.
      RED_GREEN: Positive: green. Negative: red.
      PINK_WHITE_GREEN: PiYG palette.
    """
    COLOR_MAP_UNSPECIFIED = 0
    PINK_GREEN = 1
    VIRIDIS = 2
    RED = 3
    GREEN = 4
    RED_GREEN = 5
    PINK_WHITE_GREEN = 6

  class OverlayTypeValueValuesEnum(_messages.Enum):
    r"""How the original image is displayed in the visualization. Adjusting
    the overlay can help increase visual clarity if the original image makes
    it difficult to view the visualization. Defaults to NONE.

    Values:
      OVERLAY_TYPE_UNSPECIFIED: Default value. This is the same as NONE.
      NONE: No overlay.
      ORIGINAL: The attributions are shown on top of the original image.
      GRAYSCALE: The attributions are shown on top of grayscaled version of
        the original image.
      MASK_BLACK: The attributions are used as a mask to reveal predictive
        parts of the image and hide the un-predictive parts.
    """
    OVERLAY_TYPE_UNSPECIFIED = 0
    NONE = 1
    ORIGINAL = 2
    GRAYSCALE = 3
    MASK_BLACK = 4

  class PolarityValueValuesEnum(_messages.Enum):
    r"""Whether to only highlight pixels with positive contributions, negative
    or both. Defaults to POSITIVE.

    Values:
      POLARITY_UNSPECIFIED: Default value. This is the same as POSITIVE.
      POSITIVE: Highlights the pixels/outlines that were most influential to
        the model's prediction.
      NEGATIVE: Setting polarity to negative highlights areas that does not
        lead to the models's current prediction.
      BOTH: Shows both positive and negative attributions.
    """
    POLARITY_UNSPECIFIED = 0
    POSITIVE = 1
    NEGATIVE = 2
    BOTH = 3

  class TypeValueValuesEnum(_messages.Enum):
    r"""Type of the image visualization. Only applicable to Integrated
    Gradients attribution. OUTLINES shows regions of attribution, while PIXELS
    shows per-pixel attribution. Defaults to OUTLINES.

    Values:
      TYPE_UNSPECIFIED: Should not be used.
      PIXELS: Shows which pixel contributed to the image prediction.
      OUTLINES: Shows which region contributed to the image prediction by
        outlining the region.
    """
    TYPE_UNSPECIFIED = 0
    PIXELS = 1
    OUTLINES = 2

  clipPercentLowerbound = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  clipPercentUpperbound = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  colorMap = _messages.EnumField('ColorMapValueValuesEnum', 3)
  overlayType = _messages.EnumField('OverlayTypeValueValuesEnum', 4)
  polarity = _messages.EnumField('PolarityValueValuesEnum', 5)
  type = _messages.EnumField('TypeValueValuesEnum', 6)


class GoogleCloudAiplatformV1beta1ExplanationMetadataOutputMetadata(_messages.Message):
  r"""Metadata of the prediction output to be explained.

  Fields:
    displayNameMappingKey: Specify a field name in the prediction to look for
      the display name. Use this if the prediction contains the display names
      for the outputs. The display names in the prediction must have the same
      shape of the outputs, so that it can be located by
      Attribution.output_index for a specific output.
    indexDisplayNameMapping: Static mapping between the index and display
      name. Use this if the outputs are a deterministic n-dimensional array,
      e.g. a list of scores of all the classes in a pre-defined order for a
      multi-classification Model. It's not feasible if the outputs are non-
      deterministic, e.g. the Model produces top-k classes or sort the outputs
      by their values. The shape of the value must be an n-dimensional array
      of strings. The number of dimensions must match that of the outputs to
      be explained. The Attribution.output_display_name is populated by
      locating in the mapping with Attribution.output_index.
    outputTensorName: Name of the output tensor. Required and is only
      applicable to Vertex AI provided images for Tensorflow.
  """

  displayNameMappingKey = _messages.StringField(1)
  indexDisplayNameMapping = _messages.MessageField('extra_types.JsonValue', 2)
  outputTensorName = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1ExplanationMetadataOverride(_messages.Message):
  r"""The ExplanationMetadata entries that can be overridden at online
  explanation time.

  Messages:
    InputsValue: Required. Overrides the input metadata of the features. The
      key is the name of the feature to be overridden. The keys specified here
      must exist in the input metadata to be overridden. If a feature is not
      specified here, the corresponding feature's input metadata is not
      overridden.

  Fields:
    inputs: Required. Overrides the input metadata of the features. The key is
      the name of the feature to be overridden. The keys specified here must
      exist in the input metadata to be overridden. If a feature is not
      specified here, the corresponding feature's input metadata is not
      overridden.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InputsValue(_messages.Message):
    r"""Required. Overrides the input metadata of the features. The key is the
    name of the feature to be overridden. The keys specified here must exist
    in the input metadata to be overridden. If a feature is not specified
    here, the corresponding feature's input metadata is not overridden.

    Messages:
      AdditionalProperty: An additional property for a InputsValue object.

    Fields:
      additionalProperties: Additional properties of type InputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InputsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformV1beta1ExplanationMetadataOverrideInputM
          etadataOverride attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationMetadataOverrideInputMetadataOverride', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  inputs = _messages.MessageField('InputsValue', 1)


class GoogleCloudAiplatformV1beta1ExplanationMetadataOverrideInputMetadataOverride(_messages.Message):
  r"""The input metadata entries to be overridden.

  Fields:
    inputBaselines: Baseline inputs for this feature. This overrides the
      `input_baseline` field of the ExplanationMetadata.InputMetadata object
      of the corresponding feature's input metadata. If it's not specified,
      the original baselines are not overridden.
  """

  inputBaselines = _messages.MessageField('extra_types.JsonValue', 1, repeated=True)


class GoogleCloudAiplatformV1beta1ExplanationParameters(_messages.Message):
  r"""Parameters to configure explaining for Model's predictions.

  Fields:
    examples: Example-based explanations that returns the nearest neighbors
      from the provided dataset.
    integratedGradientsAttribution: An attribution method that computes
      Aumann-Shapley values taking advantage of the model's fully
      differentiable structure. Refer to this paper for more details:
      https://arxiv.org/abs/1703.01365
    outputIndices: If populated, only returns attributions that have
      output_index contained in output_indices. It must be an ndarray of
      integers, with the same shape of the output it's explaining. If not
      populated, returns attributions for top_k indices of outputs. If neither
      top_k nor output_indices is populated, returns the argmax index of the
      outputs. Only applicable to Models that predict multiple outputs (e,g,
      multi-class Models that predict multiple classes).
    sampledShapleyAttribution: An attribution method that approximates Shapley
      values for features that contribute to the label being predicted. A
      sampling strategy is used to approximate the value rather than
      considering all subsets of features. Refer to this paper for model
      details: https://arxiv.org/abs/1306.4265.
    topK: If populated, returns attributions for top K indices of outputs
      (defaults to 1). Only applies to Models that predicts more than one
      outputs (e,g, multi-class Models). When set to -1, returns explanations
      for all outputs.
    xraiAttribution: An attribution method that redistributes Integrated
      Gradients attribution to segmented regions, taking advantage of the
      model's fully differentiable structure. Refer to this paper for more
      details: https://arxiv.org/abs/1906.02825 XRAI currently performs better
      on natural images, like a picture of a house or an animal. If the images
      are taken in artificial environments, like a lab or manufacturing line,
      or from diagnostic equipment, like x-rays or quality-control cameras,
      use Integrated Gradients instead.
  """

  examples = _messages.MessageField('GoogleCloudAiplatformV1beta1Examples', 1)
  integratedGradientsAttribution = _messages.MessageField('GoogleCloudAiplatformV1beta1IntegratedGradientsAttribution', 2)
  outputIndices = _messages.MessageField('extra_types.JsonValue', 3, repeated=True)
  sampledShapleyAttribution = _messages.MessageField('GoogleCloudAiplatformV1beta1SampledShapleyAttribution', 4)
  topK = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  xraiAttribution = _messages.MessageField('GoogleCloudAiplatformV1beta1XraiAttribution', 6)


class GoogleCloudAiplatformV1beta1ExplanationSpec(_messages.Message):
  r"""Specification of Model explanation.

  Fields:
    metadata: Optional. Metadata describing the Model's input and output for
      explanation.
    parameters: Required. Parameters that configure explaining of the Model's
      predictions.
  """

  metadata = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationMetadata', 1)
  parameters = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationParameters', 2)


class GoogleCloudAiplatformV1beta1ExplanationSpecOverride(_messages.Message):
  r"""The ExplanationSpec entries that can be overridden at online explanation
  time.

  Fields:
    examplesOverride: The example-based explanations parameter overrides.
    metadata: The metadata to be overridden. If not specified, no metadata is
      overridden.
    parameters: The parameters to be overridden. Note that the attribution
      method cannot be changed. If not specified, no parameter is overridden.
  """

  examplesOverride = _messages.MessageField('GoogleCloudAiplatformV1beta1ExamplesOverride', 1)
  metadata = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationMetadataOverride', 2)
  parameters = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationParameters', 3)


class GoogleCloudAiplatformV1beta1ExportDataConfig(_messages.Message):
  r"""Describes what part of the Dataset is to be exported, the destination of
  the export and how to export.

  Fields:
    annotationsFilter: An expression for filtering what part of the Dataset is
      to be exported. Only Annotations that match this filter will be
      exported. The filter syntax is the same as in ListAnnotations.
    fractionSplit: Split based on fractions defining the size of each set.
    gcsDestination: The Google Cloud Storage location where the output is to
      be written to. In the given directory a new directory will be created
      with name: `export-data--` where timestamp is in YYYY-MM-
      DDThh:mm:ss.sssZ ISO-8601 format. All export output will be written into
      that directory. Inside that directory, annotations with the same schema
      will be grouped into sub directories which are named with the
      corresponding annotations' schema title. Inside these sub directories, a
      schema.yaml will be created to describe the output format.
  """

  annotationsFilter = _messages.StringField(1)
  fractionSplit = _messages.MessageField('GoogleCloudAiplatformV1beta1ExportFractionSplit', 2)
  gcsDestination = _messages.MessageField('GoogleCloudAiplatformV1beta1GcsDestination', 3)


class GoogleCloudAiplatformV1beta1ExportDataOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.ExportData.

  Fields:
    gcsOutputDirectory: A Google Cloud Storage directory which path ends with
      '/'. The exported data is stored in the directory.
    genericMetadata: The common part of the operation metadata.
  """

  gcsOutputDirectory = _messages.StringField(1)
  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 2)


class GoogleCloudAiplatformV1beta1ExportDataRequest(_messages.Message):
  r"""Request message for DatasetService.ExportData.

  Fields:
    exportConfig: Required. The desired output location.
  """

  exportConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1ExportDataConfig', 1)


class GoogleCloudAiplatformV1beta1ExportDataResponse(_messages.Message):
  r"""Response message for DatasetService.ExportData.

  Fields:
    exportedFiles: All of the files that are exported in this export
      operation. For custom code training export, only three (training,
      validation and test) Cloud Storage paths in wildcard format are
      populated (for example, gs://.../training-*).
  """

  exportedFiles = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1beta1ExportFeatureValuesOperationMetadata(_messages.Message):
  r"""Details of operations that exports Features values.

  Fields:
    genericMetadata: Operation metadata for Featurestore export Feature
      values.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1ExportFeatureValuesRequest(_messages.Message):
  r"""Request message for FeaturestoreService.ExportFeatureValues.

  Fields:
    destination: Required. Specifies destination location and format.
    featureSelector: Required. Selects Features to export values of.
    fullExport: Exports all historical values of all entities of the
      EntityType within a time range
    settings: Per-Feature export settings.
    snapshotExport: Exports the latest Feature values of all entities of the
      EntityType within a time range.
  """

  destination = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureValueDestination', 1)
  featureSelector = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureSelector', 2)
  fullExport = _messages.MessageField('GoogleCloudAiplatformV1beta1ExportFeatureValuesRequestFullExport', 3)
  settings = _messages.MessageField('GoogleCloudAiplatformV1beta1DestinationFeatureSetting', 4, repeated=True)
  snapshotExport = _messages.MessageField('GoogleCloudAiplatformV1beta1ExportFeatureValuesRequestSnapshotExport', 5)


class GoogleCloudAiplatformV1beta1ExportFeatureValuesRequestFullExport(_messages.Message):
  r"""Describes exporting all historical Feature values of all entities of the
  EntityType between [start_time, end_time].

  Fields:
    endTime: Exports Feature values as of this timestamp. If not set, retrieve
      values as of now. Timestamp, if present, must not have higher than
      millisecond precision.
    startTime: Excludes Feature values with feature generation timestamp
      before this timestamp. If not set, retrieve oldest values kept in
      Feature Store. Timestamp, if present, must not have higher than
      millisecond precision.
  """

  endTime = _messages.StringField(1)
  startTime = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ExportFeatureValuesRequestSnapshotExport(_messages.Message):
  r"""Describes exporting the latest Feature values of all entities of the
  EntityType between [start_time, snapshot_time].

  Fields:
    snapshotTime: Exports Feature values as of this timestamp. If not set,
      retrieve values as of now. Timestamp, if present, must not have higher
      than millisecond precision.
    startTime: Excludes Feature values with feature generation timestamp
      before this timestamp. If not set, retrieve oldest values kept in
      Feature Store. Timestamp, if present, must not have higher than
      millisecond precision.
  """

  snapshotTime = _messages.StringField(1)
  startTime = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ExportFeatureValuesResponse(_messages.Message):
  r"""Response message for FeaturestoreService.ExportFeatureValues."""


class GoogleCloudAiplatformV1beta1ExportFractionSplit(_messages.Message):
  r"""Assigns the input data to training, validation, and test sets as per the
  given fractions. Any of `training_fraction`, `validation_fraction` and
  `test_fraction` may optionally be provided, they must sum to up to 1. If the
  provided ones sum to less than 1, the remainder is assigned to sets as
  decided by Vertex AI. If none of the fractions are set, by default roughly
  80% of data is used for training, 10% for validation, and 10% for test.

  Fields:
    testFraction: The fraction of the input data that is to be used to
      evaluate the Model.
    trainingFraction: The fraction of the input data that is to be used to
      train the Model.
    validationFraction: The fraction of the input data that is to be used to
      validate the Model.
  """

  testFraction = _messages.FloatField(1)
  trainingFraction = _messages.FloatField(2)
  validationFraction = _messages.FloatField(3)


class GoogleCloudAiplatformV1beta1ExportModelOperationMetadata(_messages.Message):
  r"""Details of ModelService.ExportModel operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
    outputInfo: Output only. Information further describing the output of this
      Model export.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)
  outputInfo = _messages.MessageField('GoogleCloudAiplatformV1beta1ExportModelOperationMetadataOutputInfo', 2)


class GoogleCloudAiplatformV1beta1ExportModelOperationMetadataOutputInfo(_messages.Message):
  r"""Further describes the output of the ExportModel. Supplements
  ExportModelRequest.OutputConfig.

  Fields:
    artifactOutputUri: Output only. If the Model artifact is being exported to
      Google Cloud Storage this is the full path of the directory created,
      into which the Model files are being written to.
    imageOutputUri: Output only. If the Model image is being exported to
      Google Container Registry or Artifact Registry this is the full path of
      the image created.
  """

  artifactOutputUri = _messages.StringField(1)
  imageOutputUri = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ExportModelRequest(_messages.Message):
  r"""Request message for ModelService.ExportModel.

  Fields:
    outputConfig: Required. The desired output location and configuration.
  """

  outputConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1ExportModelRequestOutputConfig', 1)


class GoogleCloudAiplatformV1beta1ExportModelRequestOutputConfig(_messages.Message):
  r"""Output configuration for the Model export.

  Fields:
    artifactDestination: The Cloud Storage location where the Model artifact
      is to be written to. Under the directory given as the destination a new
      one with name "`model-export--`", where timestamp is in YYYY-MM-
      DDThh:mm:ss.sssZ ISO-8601 format, will be created. Inside, the Model and
      any of its supporting files will be written. This field should only be
      set when the `exportableContent` field of the
      [Model.supported_export_formats] object contains `ARTIFACT`.
    exportFormatId: The ID of the format in which the Model must be exported.
      Each Model lists the export formats it supports. If no value is provided
      here, then the first from the list of the Model's supported formats is
      used by default.
    imageDestination: The Google Container Registry or Artifact Registry uri
      where the Model container image will be copied to. This field should
      only be set when the `exportableContent` field of the
      [Model.supported_export_formats] object contains `IMAGE`.
  """

  artifactDestination = _messages.MessageField('GoogleCloudAiplatformV1beta1GcsDestination', 1)
  exportFormatId = _messages.StringField(2)
  imageDestination = _messages.MessageField('GoogleCloudAiplatformV1beta1ContainerRegistryDestination', 3)


class GoogleCloudAiplatformV1beta1ExportModelResponse(_messages.Message):
  r"""Response message of ModelService.ExportModel operation."""


class GoogleCloudAiplatformV1beta1ExportPublisherModelOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  ModelGardenService.ExportPublisherModel.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1ExportPublisherModelResponse(_messages.Message):
  r"""Response message for ModelGardenService.ExportPublisherModel.

  Fields:
    destinationUri: The destination uri of the model weights.
    publisherModel: The name of the PublisherModel resource. Format:
      `publishers/{publisher}/models/{publisher_model}@{version_id}`
  """

  destinationUri = _messages.StringField(1)
  publisherModel = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ExportTensorboardTimeSeriesDataRequest(_messages.Message):
  r"""Request message for TensorboardService.ExportTensorboardTimeSeriesData.

  Fields:
    filter: Exports the TensorboardTimeSeries' data that match the filter
      expression.
    orderBy: Field to use to sort the TensorboardTimeSeries' data. By default,
      TensorboardTimeSeries' data is returned in a pseudo random order.
    pageSize: The maximum number of data points to return per page. The
      default page_size is 1000. Values must be between 1 and 10000. Values
      above 10000 are coerced to 10000.
    pageToken: A page token, received from a previous
      ExportTensorboardTimeSeriesData call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      ExportTensorboardTimeSeriesData must match the call that provided the
      page token.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GoogleCloudAiplatformV1beta1ExportTensorboardTimeSeriesDataResponse(_messages.Message):
  r"""Response message for TensorboardService.ExportTensorboardTimeSeriesData.

  Fields:
    nextPageToken: A token, which can be sent as page_token to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    timeSeriesDataPoints: The returned time series data points.
  """

  nextPageToken = _messages.StringField(1)
  timeSeriesDataPoints = _messages.MessageField('GoogleCloudAiplatformV1beta1TimeSeriesDataPoint', 2, repeated=True)


class GoogleCloudAiplatformV1beta1Extension(_messages.Message):
  r"""Extensions are tools for large language models to access external data,
  run computations, etc.

  Fields:
    createTime: Output only. Timestamp when this Extension was created.
    description: Optional. The description of the Extension.
    displayName: Required. The display name of the Extension. The name can be
      up to 128 characters long and can consist of any UTF-8 characters.
    etag: Optional. Used to perform consistent read-modify-write updates. If
      not set, a blind "overwrite" update happens.
    extensionOperations: Output only. Supported operations.
    manifest: Required. Manifest of the Extension.
    name: Identifier. The resource name of the Extension.
    privateServiceConnectConfig: Optional. The PrivateServiceConnect config
      for the extension. If specified, the service endpoints associated with
      the Extension should be [registered with private network access in the
      provided Service Directory](https://cloud.google.com/service-
      directory/docs/configuring-private-network-access). If the service
      contains more than one endpoint with a network, the service will
      arbitrarilty choose one of the endpoints to use for extension execution.
    runtimeConfig: Optional. Runtime config controlling the runtime behavior
      of this Extension.
    satisfiesPzi: Output only. Reserved for future use.
    satisfiesPzs: Output only. Reserved for future use.
    toolUseExamples: Optional. Examples to illustrate the usage of the
      extension as a tool.
    updateTime: Output only. Timestamp when this Extension was most recently
      updated.
  """

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  etag = _messages.StringField(4)
  extensionOperations = _messages.MessageField('GoogleCloudAiplatformV1beta1ExtensionOperation', 5, repeated=True)
  manifest = _messages.MessageField('GoogleCloudAiplatformV1beta1ExtensionManifest', 6)
  name = _messages.StringField(7)
  privateServiceConnectConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1ExtensionPrivateServiceConnectConfig', 8)
  runtimeConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1RuntimeConfig', 9)
  satisfiesPzi = _messages.BooleanField(10)
  satisfiesPzs = _messages.BooleanField(11)
  toolUseExamples = _messages.MessageField('GoogleCloudAiplatformV1beta1ToolUseExample', 12, repeated=True)
  updateTime = _messages.StringField(13)


class GoogleCloudAiplatformV1beta1ExtensionManifest(_messages.Message):
  r"""Manifest spec of an Extension needed for runtime execution.

  Fields:
    apiSpec: Required. Immutable. The API specification shown to the LLM.
    authConfig: Required. Immutable. Type of auth supported by this extension.
    description: Required. The natural language description shown to the LLM.
      It should describe the usage of the extension, and is essential for the
      LLM to perform reasoning. e.g., if the extension is a data store, you
      can let the LLM know what data it contains.
    name: Required. Extension name shown to the LLM. The name can be up to 128
      characters long.
  """

  apiSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1ExtensionManifestApiSpec', 1)
  authConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1AuthConfig', 2)
  description = _messages.StringField(3)
  name = _messages.StringField(4)


class GoogleCloudAiplatformV1beta1ExtensionManifestApiSpec(_messages.Message):
  r"""The API specification shown to the LLM.

  Fields:
    openApiGcsUri: Cloud Storage URI pointing to the OpenAPI spec.
    openApiYaml: The API spec in Open API standard and YAML format.
  """

  openApiGcsUri = _messages.StringField(1)
  openApiYaml = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ExtensionOperation(_messages.Message):
  r"""Operation of an extension.

  Fields:
    functionDeclaration: Output only. Structured representation of a function
      declaration as defined by the OpenAPI Spec.
    operationId: Operation ID that uniquely identifies the operations among
      the extension. See: "Operation Object" in
      https://swagger.io/specification/. This field is parsed from the OpenAPI
      spec. For HTTP extensions, if it does not exist in the spec, we will
      generate one from the HTTP method and path.
  """

  functionDeclaration = _messages.MessageField('GoogleCloudAiplatformV1beta1FunctionDeclaration', 1)
  operationId = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ExtensionPrivateServiceConnectConfig(_messages.Message):
  r"""PrivateExtensionConfig configuration for the extension.

  Fields:
    serviceDirectory: Required. The Service Directory resource name in which
      the service endpoints associated to the extension are registered.
      Format: `projects/{project_id}/locations/{location_id}/namespaces/{names
      pace_id}/services/{service_id}` - The Vertex AI Extension Service Agent
      (https://cloud.google.com/vertex-ai/docs/general/access-control#service-
      agents) should be granted `servicedirectory.viewer` and
      `servicedirectory.pscAuthorizedService` roles on the resource.
  """

  serviceDirectory = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1Fact(_messages.Message):
  r"""The fact used in grounding.

  Fields:
    query: Query that is used to retrieve this fact.
    score: If present, according to the underlying Vector DB and the selected
      metric type, the score can be either the distance or the similarity
      between the query and the fact and its range depends on the metric type.
      For example, if the metric type is COSINE_DISTANCE, it represents the
      distance between the query and the fact. The larger the distance, the
      less relevant the fact is to the query. The range is [0, 2], while 0
      means the most relevant and 2 means the least relevant.
    summary: If present, the summary/snippet of the fact.
    title: If present, it refers to the title of this fact.
    uri: If present, this uri links to the source of the fact.
    vectorDistance: If present, the distance between the query vector and this
      fact vector.
  """

  query = _messages.StringField(1)
  score = _messages.FloatField(2)
  summary = _messages.StringField(3)
  title = _messages.StringField(4)
  uri = _messages.StringField(5)
  vectorDistance = _messages.FloatField(6)


class GoogleCloudAiplatformV1beta1FasterDeploymentConfig(_messages.Message):
  r"""Configuration for faster model deployment.

  Fields:
    fastTryoutEnabled: If true, enable fast tryout feature for this deployed
      model.
  """

  fastTryoutEnabled = _messages.BooleanField(1)


class GoogleCloudAiplatformV1beta1Feature(_messages.Message):
  r"""Feature Metadata information. For example, color is a feature that
  describes an apple.

  Enums:
    ValueTypeValueValuesEnum: Immutable. Only applicable for Vertex AI Feature
      Store (Legacy). Type of Feature value.

  Messages:
    LabelsValue: Optional. The labels with user-defined metadata to organize
      your Features. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information on and examples
      of labels. No more than 64 user labels can be associated with one
      Feature (System labels are excluded)." System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable.

  Fields:
    createTime: Output only. Only applicable for Vertex AI Feature Store
      (Legacy). Timestamp when this EntityType was created.
    description: Description of the Feature.
    disableMonitoring: Optional. Only applicable for Vertex AI Feature Store
      (Legacy). If not set, use the monitoring_config defined for the
      EntityType this Feature belongs to. Only Features with type
      (Feature.ValueType) BOOL, STRING, DOUBLE or INT64 can enable monitoring.
      If set to true, all types of data monitoring are disabled despite the
      config on EntityType.
    etag: Used to perform a consistent read-modify-write updates. If not set,
      a blind "overwrite" update happens.
    featureStatsAndAnomaly: Output only. Only applicable for Vertex AI Feature
      Store. The list of historical stats and anomalies.
    labels: Optional. The labels with user-defined metadata to organize your
      Features. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information on and examples
      of labels. No more than 64 user labels can be associated with one
      Feature (System labels are excluded)." System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable.
    monitoringConfig: Optional. Only applicable for Vertex AI Feature Store
      (Legacy). Deprecated: The custom monitoring configuration for this
      Feature, if not set, use the monitoring_config defined for the
      EntityType this Feature belongs to. Only Features with type
      (Feature.ValueType) BOOL, STRING, DOUBLE or INT64 can enable monitoring.
      If this is populated with FeaturestoreMonitoringConfig.disabled = true,
      snapshot analysis monitoring is disabled; if
      FeaturestoreMonitoringConfig.monitoring_interval specified, snapshot
      analysis monitoring is enabled. Otherwise, snapshot analysis monitoring
      config is same as the EntityType's this Feature belongs to.
    monitoringStats: Output only. Only applicable for Vertex AI Feature Store
      (Legacy). A list of historical SnapshotAnalysis stats requested by user,
      sorted by FeatureStatsAnomaly.start_time descending.
    monitoringStatsAnomalies: Output only. Only applicable for Vertex AI
      Feature Store (Legacy). The list of historical stats and anomalies with
      specified objectives.
    name: Immutable. Name of the Feature. Format: `projects/{project}/location
      s/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/feat
      ures/{feature}` `projects/{project}/locations/{location}/featureGroups/{
      feature_group}/features/{feature}` The last part feature is assigned by
      the client. The feature can be up to 64 characters long and can consist
      only of ASCII Latin letters A-Z and a-z, underscore(_), and ASCII digits
      0-9 starting with a letter. The value will be unique given an entity
      type.
    pointOfContact: Entity responsible for maintaining this feature. Can be
      comma separated list of email addresses or URIs.
    updateTime: Output only. Only applicable for Vertex AI Feature Store
      (Legacy). Timestamp when this EntityType was most recently updated.
    valueType: Immutable. Only applicable for Vertex AI Feature Store
      (Legacy). Type of Feature value.
    versionColumnName: Only applicable for Vertex AI Feature Store. The name
      of the BigQuery Table/View column hosting data for this version. If no
      value is provided, will use feature_id.
  """

  class ValueTypeValueValuesEnum(_messages.Enum):
    r"""Immutable. Only applicable for Vertex AI Feature Store (Legacy). Type
    of Feature value.

    Values:
      VALUE_TYPE_UNSPECIFIED: The value type is unspecified.
      BOOL: Used for Feature that is a boolean.
      BOOL_ARRAY: Used for Feature that is a list of boolean.
      DOUBLE: Used for Feature that is double.
      DOUBLE_ARRAY: Used for Feature that is a list of double.
      INT64: Used for Feature that is INT64.
      INT64_ARRAY: Used for Feature that is a list of INT64.
      STRING: Used for Feature that is string.
      STRING_ARRAY: Used for Feature that is a list of String.
      BYTES: Used for Feature that is bytes.
      STRUCT: Used for Feature that is struct.
    """
    VALUE_TYPE_UNSPECIFIED = 0
    BOOL = 1
    BOOL_ARRAY = 2
    DOUBLE = 3
    DOUBLE_ARRAY = 4
    INT64 = 5
    INT64_ARRAY = 6
    STRING = 7
    STRING_ARRAY = 8
    BYTES = 9
    STRUCT = 10

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels with user-defined metadata to organize your
    Features. Label keys and values can be no longer than 64 characters
    (Unicode codepoints), can only contain lowercase letters, numeric
    characters, underscores and dashes. International characters are allowed.
    See https://goo.gl/xmQnxf for more information on and examples of labels.
    No more than 64 user labels can be associated with one Feature (System
    labels are excluded)." System reserved label keys are prefixed with
    "aiplatform.googleapis.com/" and are immutable.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  disableMonitoring = _messages.BooleanField(3)
  etag = _messages.StringField(4)
  featureStatsAndAnomaly = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureStatsAndAnomaly', 5, repeated=True)
  labels = _messages.MessageField('LabelsValue', 6)
  monitoringConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfig', 7)
  monitoringStats = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureStatsAnomaly', 8, repeated=True)
  monitoringStatsAnomalies = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureMonitoringStatsAnomaly', 9, repeated=True)
  name = _messages.StringField(10)
  pointOfContact = _messages.StringField(11)
  updateTime = _messages.StringField(12)
  valueType = _messages.EnumField('ValueTypeValueValuesEnum', 13)
  versionColumnName = _messages.StringField(14)


class GoogleCloudAiplatformV1beta1FeatureGroup(_messages.Message):
  r"""Vertex AI Feature Group.

  Enums:
    ServiceAgentTypeValueValuesEnum: Optional. Service agent type used during
      jobs under a FeatureGroup. By default, the Vertex AI Service Agent is
      used. When using an IAM Policy to isolate this FeatureGroup within a
      project, a separate service account should be provisioned by setting
      this field to `SERVICE_AGENT_TYPE_FEATURE_GROUP`. This will generate a
      separate service account to access the BigQuery source table.

  Messages:
    LabelsValue: Optional. The labels with user-defined metadata to organize
      your FeatureGroup. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information on and examples
      of labels. No more than 64 user labels can be associated with one
      FeatureGroup(System labels are excluded)." System reserved label keys
      are prefixed with "aiplatform.googleapis.com/" and are immutable.

  Fields:
    bigQuery: Indicates that features for this group come from BigQuery
      Table/View. By default treats the source as a sparse time series source.
      The BigQuery source table or view must have at least one entity ID
      column and a column named `feature_timestamp`.
    createTime: Output only. Timestamp when this FeatureGroup was created.
    description: Optional. Description of the FeatureGroup.
    etag: Optional. Used to perform consistent read-modify-write updates. If
      not set, a blind "overwrite" update happens.
    labels: Optional. The labels with user-defined metadata to organize your
      FeatureGroup. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information on and examples
      of labels. No more than 64 user labels can be associated with one
      FeatureGroup(System labels are excluded)." System reserved label keys
      are prefixed with "aiplatform.googleapis.com/" and are immutable.
    name: Identifier. Name of the FeatureGroup. Format:
      `projects/{project}/locations/{location}/featureGroups/{featureGroup}`
    serviceAccountEmail: Output only. A Service Account unique to this
      FeatureGroup. The role bigquery.dataViewer should be granted to this
      service account to allow Vertex AI Feature Store to access source data
      while running jobs under this FeatureGroup.
    serviceAgentType: Optional. Service agent type used during jobs under a
      FeatureGroup. By default, the Vertex AI Service Agent is used. When
      using an IAM Policy to isolate this FeatureGroup within a project, a
      separate service account should be provisioned by setting this field to
      `SERVICE_AGENT_TYPE_FEATURE_GROUP`. This will generate a separate
      service account to access the BigQuery source table.
    updateTime: Output only. Timestamp when this FeatureGroup was last
      updated.
  """

  class ServiceAgentTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Service agent type used during jobs under a FeatureGroup. By
    default, the Vertex AI Service Agent is used. When using an IAM Policy to
    isolate this FeatureGroup within a project, a separate service account
    should be provisioned by setting this field to
    `SERVICE_AGENT_TYPE_FEATURE_GROUP`. This will generate a separate service
    account to access the BigQuery source table.

    Values:
      SERVICE_AGENT_TYPE_UNSPECIFIED: By default, the project-level Vertex AI
        Service Agent is enabled.
      SERVICE_AGENT_TYPE_PROJECT: Specifies the project-level Vertex AI
        Service Agent (https://cloud.google.com/vertex-ai/docs/general/access-
        control#service-agents).
      SERVICE_AGENT_TYPE_FEATURE_GROUP: Enable a FeatureGroup service account
        to be created by Vertex AI and output in the field
        `service_account_email`. This service account will be used to read
        from the source BigQuery table during jobs under a FeatureGroup.
    """
    SERVICE_AGENT_TYPE_UNSPECIFIED = 0
    SERVICE_AGENT_TYPE_PROJECT = 1
    SERVICE_AGENT_TYPE_FEATURE_GROUP = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels with user-defined metadata to organize your
    FeatureGroup. Label keys and values can be no longer than 64 characters
    (Unicode codepoints), can only contain lowercase letters, numeric
    characters, underscores and dashes. International characters are allowed.
    See https://goo.gl/xmQnxf for more information on and examples of labels.
    No more than 64 user labels can be associated with one FeatureGroup(System
    labels are excluded)." System reserved label keys are prefixed with
    "aiplatform.googleapis.com/" and are immutable.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  bigQuery = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureGroupBigQuery', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  etag = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  name = _messages.StringField(6)
  serviceAccountEmail = _messages.StringField(7)
  serviceAgentType = _messages.EnumField('ServiceAgentTypeValueValuesEnum', 8)
  updateTime = _messages.StringField(9)


class GoogleCloudAiplatformV1beta1FeatureGroupBigQuery(_messages.Message):
  r"""Input source type for BigQuery Tables and Views.

  Fields:
    bigQuerySource: Required. Immutable. The BigQuery source URI that points
      to either a BigQuery Table or View.
    dense: Optional. If set, all feature values will be fetched from a single
      row per unique entityId including nulls. If not set, will collapse all
      rows for each unique entityId into a singe row with any non-null values
      if present, if no non-null values are present will sync null. ex: If
      source has schema `(entity_id, feature_timestamp, f0, f1)` and the
      following rows: `(e1, 2020-01-01T10:00:00.123Z, 10, 15)` `(e1,
      2020-02-01T10:00:00.123Z, 20, null)` If dense is set, `(e1, 20, null)`
      is synced to online stores. If dense is not set, `(e1, 20, 15)` is
      synced to online stores.
    entityIdColumns: Optional. Columns to construct entity_id / row keys. If
      not provided defaults to `entity_id`.
    staticDataSource: Optional. Set if the data source is not a time-series.
    timeSeries: Optional. If the source is a time-series source, this can be
      set to control how downstream sources (ex: FeatureView ) will treat
      time-series sources. If not set, will treat the source as a time-series
      source with `feature_timestamp` as timestamp column and no scan
      boundary.
  """

  bigQuerySource = _messages.MessageField('GoogleCloudAiplatformV1beta1BigQuerySource', 1)
  dense = _messages.BooleanField(2)
  entityIdColumns = _messages.StringField(3, repeated=True)
  staticDataSource = _messages.BooleanField(4)
  timeSeries = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureGroupBigQueryTimeSeries', 5)


class GoogleCloudAiplatformV1beta1FeatureGroupBigQueryTimeSeries(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1FeatureGroupBigQueryTimeSeries object.

  Fields:
    timestampColumn: Optional. Column hosting timestamp values for a time-
      series source. Will be used to determine the latest `feature_values` for
      each entity. Optional. If not provided, column named `feature_timestamp`
      of type `TIMESTAMP` will be used.
  """

  timestampColumn = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1FeatureMonitor(_messages.Message):
  r"""Vertex AI Feature Monitor.

  Messages:
    LabelsValue: Optional. The labels with user-defined metadata to organize
      your FeatureMonitor. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information on and examples
      of labels. No more than 64 user labels can be associated with one
      FeatureMonitor(System labels are excluded)." System reserved label keys
      are prefixed with "aiplatform.googleapis.com/" and are immutable.

  Fields:
    createTime: Output only. Timestamp when this FeatureMonitor was created.
    description: Optional. Description of the FeatureMonitor.
    etag: Optional. Used to perform consistent read-modify-write updates. If
      not set, a blind "overwrite" update happens.
    featureSelectionConfig: Required. Feature selection config for the
      FeatureMonitor.
    labels: Optional. The labels with user-defined metadata to organize your
      FeatureMonitor. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information on and examples
      of labels. No more than 64 user labels can be associated with one
      FeatureMonitor(System labels are excluded)." System reserved label keys
      are prefixed with "aiplatform.googleapis.com/" and are immutable.
    name: Identifier. Name of the FeatureMonitor. Format: `projects/{project}/
      locations/{location}/featureGroups/{featureGroup}/featureMonitors/{featu
      reMonitor}`
    scheduleConfig: Required. Schedule config for the FeatureMonitor.
    updateTime: Output only. Timestamp when this FeatureMonitor was last
      updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels with user-defined metadata to organize your
    FeatureMonitor. Label keys and values can be no longer than 64 characters
    (Unicode codepoints), can only contain lowercase letters, numeric
    characters, underscores and dashes. International characters are allowed.
    See https://goo.gl/xmQnxf for more information on and examples of labels.
    No more than 64 user labels can be associated with one
    FeatureMonitor(System labels are excluded)." System reserved label keys
    are prefixed with "aiplatform.googleapis.com/" and are immutable.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  etag = _messages.StringField(3)
  featureSelectionConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureSelectionConfig', 4)
  labels = _messages.MessageField('LabelsValue', 5)
  name = _messages.StringField(6)
  scheduleConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1ScheduleConfig', 7)
  updateTime = _messages.StringField(8)


class GoogleCloudAiplatformV1beta1FeatureMonitorJob(_messages.Message):
  r"""Vertex AI Feature Monitor Job.

  Enums:
    TriggerTypeValueValuesEnum: Output only. Trigger type of the Feature
      Monitor Job.

  Messages:
    LabelsValue: Optional. The labels with user-defined metadata to organize
      your FeatureMonitorJob. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information on and examples
      of labels. No more than 64 user labels can be associated with one
      FeatureMonitor(System labels are excluded)." System reserved label keys
      are prefixed with "aiplatform.googleapis.com/" and are immutable.

  Fields:
    createTime: Output only. Timestamp when this FeatureMonitorJob was
      created. Creation of a FeatureMonitorJob means that the job is pending /
      waiting for sufficient resources but may not have started running yet.
    description: Optional. Description of the FeatureMonitor.
    driftBaseFeatureMonitorJobId: Output only. FeatureMonitorJob ID comparing
      to which the drift is calculated.
    driftBaseSnapshotTime: Output only. Data snapshot time comparing to which
      the drift is calculated.
    featureSelectionConfig: Output only. Feature selection config used when
      creating FeatureMonitorJob.
    finalStatus: Output only. Final status of the FeatureMonitorJob.
    jobSummary: Output only. Summary from the FeatureMonitorJob.
    labels: Optional. The labels with user-defined metadata to organize your
      FeatureMonitorJob. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information on and examples
      of labels. No more than 64 user labels can be associated with one
      FeatureMonitor(System labels are excluded)." System reserved label keys
      are prefixed with "aiplatform.googleapis.com/" and are immutable.
    name: Identifier. Name of the FeatureMonitorJob. Format: `projects/{projec
      t}/locations/{location}/featureGroups/{feature_group}/featureMonitors/{f
      eature_monitor}/featureMonitorJobs/{feature_monitor_job}`.
    triggerType: Output only. Trigger type of the Feature Monitor Job.
  """

  class TriggerTypeValueValuesEnum(_messages.Enum):
    r"""Output only. Trigger type of the Feature Monitor Job.

    Values:
      FEATURE_MONITOR_JOB_TRIGGER_UNSPECIFIED: Trigger type unspecified.
      FEATURE_MONITOR_JOB_TRIGGER_PERIODIC: Triggered by periodic schedule.
      FEATURE_MONITOR_JOB_TRIGGER_ON_DEMAND: Triggered on demand by
        CreateFeatureMonitorJob request.
    """
    FEATURE_MONITOR_JOB_TRIGGER_UNSPECIFIED = 0
    FEATURE_MONITOR_JOB_TRIGGER_PERIODIC = 1
    FEATURE_MONITOR_JOB_TRIGGER_ON_DEMAND = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels with user-defined metadata to organize your
    FeatureMonitorJob. Label keys and values can be no longer than 64
    characters (Unicode codepoints), can only contain lowercase letters,
    numeric characters, underscores and dashes. International characters are
    allowed. See https://goo.gl/xmQnxf for more information on and examples of
    labels. No more than 64 user labels can be associated with one
    FeatureMonitor(System labels are excluded)." System reserved label keys
    are prefixed with "aiplatform.googleapis.com/" and are immutable.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  driftBaseFeatureMonitorJobId = _messages.IntegerField(3)
  driftBaseSnapshotTime = _messages.StringField(4)
  featureSelectionConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureSelectionConfig', 5)
  finalStatus = _messages.MessageField('GoogleRpcStatus', 6)
  jobSummary = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureMonitorJobJobSummary', 7)
  labels = _messages.MessageField('LabelsValue', 8)
  name = _messages.StringField(9)
  triggerType = _messages.EnumField('TriggerTypeValueValuesEnum', 10)


class GoogleCloudAiplatformV1beta1FeatureMonitorJobJobSummary(_messages.Message):
  r"""Summary from the FeatureMonitorJob.

  Fields:
    featureStatsAndAnomalies: Output only. Features and their stats and
      anomalies
    totalSlotMs: Output only. BigQuery slot milliseconds consumed.
  """

  featureStatsAndAnomalies = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureStatsAndAnomaly', 1, repeated=True)
  totalSlotMs = _messages.IntegerField(2)


class GoogleCloudAiplatformV1beta1FeatureMonitoringStatsAnomaly(_messages.Message):
  r"""A list of historical SnapshotAnalysis or ImportFeaturesAnalysis stats
  requested by user, sorted by FeatureStatsAnomaly.start_time descending.

  Enums:
    ObjectiveValueValuesEnum: Output only. The objective for each stats.

  Fields:
    featureStatsAnomaly: Output only. The stats and anomalies generated at
      specific timestamp.
    objective: Output only. The objective for each stats.
  """

  class ObjectiveValueValuesEnum(_messages.Enum):
    r"""Output only. The objective for each stats.

    Values:
      OBJECTIVE_UNSPECIFIED: If it's OBJECTIVE_UNSPECIFIED, monitoring_stats
        will be empty.
      IMPORT_FEATURE_ANALYSIS: Stats are generated by Import Feature Analysis.
      SNAPSHOT_ANALYSIS: Stats are generated by Snapshot Analysis.
    """
    OBJECTIVE_UNSPECIFIED = 0
    IMPORT_FEATURE_ANALYSIS = 1
    SNAPSHOT_ANALYSIS = 2

  featureStatsAnomaly = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureStatsAnomaly', 1)
  objective = _messages.EnumField('ObjectiveValueValuesEnum', 2)


class GoogleCloudAiplatformV1beta1FeatureNoiseSigma(_messages.Message):
  r"""Noise sigma by features. Noise sigma represents the standard deviation
  of the gaussian kernel that will be used to add noise to interpolated inputs
  prior to computing gradients.

  Fields:
    noiseSigma: Noise sigma per feature. No noise is added to features that
      are not set.
  """

  noiseSigma = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureNoiseSigmaNoiseSigmaForFeature', 1, repeated=True)


class GoogleCloudAiplatformV1beta1FeatureNoiseSigmaNoiseSigmaForFeature(_messages.Message):
  r"""Noise sigma for a single feature.

  Fields:
    name: The name of the input feature for which noise sigma is provided. The
      features are defined in explanation metadata inputs.
    sigma: This represents the standard deviation of the Gaussian kernel that
      will be used to add noise to the feature prior to computing gradients.
      Similar to noise_sigma but represents the noise added to the current
      feature. Defaults to 0.1.
  """

  name = _messages.StringField(1)
  sigma = _messages.FloatField(2, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1beta1FeatureOnlineStore(_messages.Message):
  r"""Vertex AI Feature Online Store provides a centralized repository for
  serving ML features and embedding indexes at low latency. The Feature Online
  Store is a top-level container.

  Enums:
    StateValueValuesEnum: Output only. State of the featureOnlineStore.

  Messages:
    LabelsValue: Optional. The labels with user-defined metadata to organize
      your FeatureOnlineStore. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information on and examples
      of labels. No more than 64 user labels can be associated with one
      FeatureOnlineStore(System labels are excluded)." System reserved label
      keys are prefixed with "aiplatform.googleapis.com/" and are immutable.

  Fields:
    bigtable: Contains settings for the Cloud Bigtable instance that will be
      created to serve featureValues for all FeatureViews under this
      FeatureOnlineStore.
    createTime: Output only. Timestamp when this FeatureOnlineStore was
      created.
    dedicatedServingEndpoint: Optional. The dedicated serving endpoint for
      this FeatureOnlineStore, which is different from common Vertex service
      endpoint.
    embeddingManagement: Optional. Deprecated: This field is no longer needed
      anymore and embedding management is automatically enabled when
      specifying Optimized storage type.
    encryptionSpec: Optional. Customer-managed encryption key spec for data
      storage. If set, online store will be secured by this key.
    etag: Optional. Used to perform consistent read-modify-write updates. If
      not set, a blind "overwrite" update happens.
    labels: Optional. The labels with user-defined metadata to organize your
      FeatureOnlineStore. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information on and examples
      of labels. No more than 64 user labels can be associated with one
      FeatureOnlineStore(System labels are excluded)." System reserved label
      keys are prefixed with "aiplatform.googleapis.com/" and are immutable.
    name: Identifier. Name of the FeatureOnlineStore. Format: `projects/{proje
      ct}/locations/{location}/featureOnlineStores/{featureOnlineStore}`
    optimized: Contains settings for the Optimized store that will be created
      to serve featureValues for all FeatureViews under this
      FeatureOnlineStore. When choose Optimized storage type, need to set
      PrivateServiceConnectConfig.enable_private_service_connect to use
      private endpoint. Otherwise will use public endpoint by default.
    satisfiesPzi: Output only. Reserved for future use.
    satisfiesPzs: Output only. Reserved for future use.
    state: Output only. State of the featureOnlineStore.
    updateTime: Output only. Timestamp when this FeatureOnlineStore was last
      updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the featureOnlineStore.

    Values:
      STATE_UNSPECIFIED: Default value. This value is unused.
      STABLE: State when the featureOnlineStore configuration is not being
        updated and the fields reflect the current configuration of the
        featureOnlineStore. The featureOnlineStore is usable in this state.
      UPDATING: The state of the featureOnlineStore configuration when it is
        being updated. During an update, the fields reflect either the
        original configuration or the updated configuration of the
        featureOnlineStore. The featureOnlineStore is still usable in this
        state.
    """
    STATE_UNSPECIFIED = 0
    STABLE = 1
    UPDATING = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels with user-defined metadata to organize your
    FeatureOnlineStore. Label keys and values can be no longer than 64
    characters (Unicode codepoints), can only contain lowercase letters,
    numeric characters, underscores and dashes. International characters are
    allowed. See https://goo.gl/xmQnxf for more information on and examples of
    labels. No more than 64 user labels can be associated with one
    FeatureOnlineStore(System labels are excluded)." System reserved label
    keys are prefixed with "aiplatform.googleapis.com/" and are immutable.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  bigtable = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureOnlineStoreBigtable', 1)
  createTime = _messages.StringField(2)
  dedicatedServingEndpoint = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureOnlineStoreDedicatedServingEndpoint', 3)
  embeddingManagement = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureOnlineStoreEmbeddingManagement', 4)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1EncryptionSpec', 5)
  etag = _messages.StringField(6)
  labels = _messages.MessageField('LabelsValue', 7)
  name = _messages.StringField(8)
  optimized = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureOnlineStoreOptimized', 9)
  satisfiesPzi = _messages.BooleanField(10)
  satisfiesPzs = _messages.BooleanField(11)
  state = _messages.EnumField('StateValueValuesEnum', 12)
  updateTime = _messages.StringField(13)


class GoogleCloudAiplatformV1beta1FeatureOnlineStoreBigtable(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1FeatureOnlineStoreBigtable object.

  Fields:
    autoScaling: Required. Autoscaling config applied to Bigtable Instance.
  """

  autoScaling = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureOnlineStoreBigtableAutoScaling', 1)


class GoogleCloudAiplatformV1beta1FeatureOnlineStoreBigtableAutoScaling(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1FeatureOnlineStoreBigtableAutoScaling
  object.

  Fields:
    cpuUtilizationTarget: Optional. A percentage of the cluster's CPU
      capacity. Can be from 10% to 80%. When a cluster's CPU utilization
      exceeds the target that you have set, Bigtable immediately adds nodes to
      the cluster. When CPU utilization is substantially lower than the
      target, Bigtable removes nodes. If not set will default to 50%.
    maxNodeCount: Required. The maximum number of nodes to scale up to. Must
      be greater than or equal to min_node_count, and less than or equal to 10
      times of 'min_node_count'.
    minNodeCount: Required. The minimum number of nodes to scale down to. Must
      be greater than or equal to 1.
  """

  cpuUtilizationTarget = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  maxNodeCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  minNodeCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1FeatureOnlineStoreDedicatedServingEndpoint(_messages.Message):
  r"""The dedicated serving endpoint for this FeatureOnlineStore. Only need to
  set when you choose Optimized storage type. Public endpoint is provisioned
  by default.

  Fields:
    privateServiceConnectConfig: Optional. Private service connect config. The
      private service connection is available only for Optimized storage type,
      not for embedding management now. If
      PrivateServiceConnectConfig.enable_private_service_connect set to true,
      customers will use private service connection to send request.
      Otherwise, the connection will set to public endpoint.
    publicEndpointDomainName: Output only. This field will be populated with
      the domain name to use for this FeatureOnlineStore
    serviceAttachment: Output only. The name of the service attachment
      resource. Populated if private service connect is enabled and after
      FeatureViewSync is created.
  """

  privateServiceConnectConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1PrivateServiceConnectConfig', 1)
  publicEndpointDomainName = _messages.StringField(2)
  serviceAttachment = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1FeatureOnlineStoreEmbeddingManagement(_messages.Message):
  r"""Deprecated: This sub message is no longer needed anymore and embedding
  management is automatically enabled when specifying Optimized storage type.
  Contains settings for embedding management.

  Fields:
    enabled: Optional. Immutable. Whether to enable embedding management in
      this FeatureOnlineStore. It's immutable after creation to ensure the
      FeatureOnlineStore availability.
  """

  enabled = _messages.BooleanField(1)


class GoogleCloudAiplatformV1beta1FeatureOnlineStoreOptimized(_messages.Message):
  r"""Optimized storage type"""


class GoogleCloudAiplatformV1beta1FeatureSelectionConfig(_messages.Message):
  r"""Feature selection configuration for the FeatureMonitor.

  Fields:
    featureConfigs: Optional. A list of features to be monitored and each
      feature's drift threshold.
  """

  featureConfigs = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureSelectionConfigFeatureConfig', 1, repeated=True)


class GoogleCloudAiplatformV1beta1FeatureSelectionConfigFeatureConfig(_messages.Message):
  r"""Feature configuration.

  Fields:
    driftThreshold: Optional. Drift threshold. If calculated difference with
      baseline data larger than threshold, it will be considered as the
      feature has drift. If not present, the threshold will be default to 0.3.
    featureId: Required. The ID of the feature resource. Final component of
      the Feature's resource name.
  """

  driftThreshold = _messages.FloatField(1)
  featureId = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1FeatureSelector(_messages.Message):
  r"""Selector for Features of an EntityType.

  Fields:
    idMatcher: Required. Matches Features based on ID.
  """

  idMatcher = _messages.MessageField('GoogleCloudAiplatformV1beta1IdMatcher', 1)


class GoogleCloudAiplatformV1beta1FeatureStatsAndAnomaly(_messages.Message):
  r"""Stats and Anomaly generated by FeatureMonitorJobs. Anomaly only includes
  Drift.

  Fields:
    distributionDeviation: Deviation from the current stats to baseline stats.
      1. For categorical feature, the distribution distance is calculated by
      L-inifinity norm. 2. For numerical feature, the distribution distance is
      calculated by Jensen\u2013Shannon divergence.
    driftDetected: If set to true, indicates current stats is detected as and
      comparing with baseline stats.
    driftDetectionThreshold: This is the threshold used when detecting drifts,
      which is set in
      FeatureMonitor.FeatureSelectionConfig.FeatureConfig.drift_threshold
    featureId: Feature Id.
    featureMonitorId: The ID of the FeatureMonitor that this
      FeatureStatsAndAnomaly generated according to.
    featureMonitorJobId: The ID of the FeatureMonitorJob that generated this
      FeatureStatsAndAnomaly.
    featureStats: Feature stats. e.g. histogram buckets. In the format of
      tensorflow.metadata.v0.DatasetFeatureStatistics.
    statsTime: The timestamp we take snapshot for feature values to generate
      stats.
  """

  distributionDeviation = _messages.FloatField(1)
  driftDetected = _messages.BooleanField(2)
  driftDetectionThreshold = _messages.FloatField(3)
  featureId = _messages.StringField(4)
  featureMonitorId = _messages.StringField(5)
  featureMonitorJobId = _messages.IntegerField(6)
  featureStats = _messages.MessageField('extra_types.JsonValue', 7)
  statsTime = _messages.StringField(8)


class GoogleCloudAiplatformV1beta1FeatureStatsAnomaly(_messages.Message):
  r"""Stats and Anomaly generated at specific timestamp for specific Feature.
  The start_time and end_time are used to define the time range of the dataset
  that current stats belongs to, e.g. prediction traffic is bucketed into
  prediction datasets by time window. If the Dataset is not defined by time
  window, start_time = end_time. Timestamp of the stats and anomalies always
  refers to end_time. Raw stats and anomalies are stored in stats_uri or
  anomaly_uri in the tensorflow defined protos. Field data_stats contains
  almost identical information with the raw stats in Vertex AI defined proto,
  for UI to display.

  Fields:
    anomalyDetectionThreshold: This is the threshold used when detecting
      anomalies. The threshold can be changed by user, so this one might be
      different from ThresholdConfig.value.
    anomalyUri: Path of the anomaly file for current feature values in Cloud
      Storage bucket. Format: gs:////anomalies. Example:
      gs://monitoring_bucket/feature_name/anomalies. Stats are stored as
      binary format with Protobuf message Anoamlies are stored as binary
      format with Protobuf message [tensorflow.metadata.v0.AnomalyInfo] (https
      ://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/
      v0/anomalies.proto).
    distributionDeviation: Deviation from the current stats to baseline stats.
      1. For categorical feature, the distribution distance is calculated by
      L-inifinity norm. 2. For numerical feature, the distribution distance is
      calculated by Jensen\u2013Shannon divergence.
    endTime: The end timestamp of window where stats were generated. For
      objectives where time window doesn't make sense (e.g. Featurestore
      Snapshot Monitoring), end_time indicates the timestamp of the data used
      to generate stats (e.g. timestamp we take snapshots for feature values).
    score: Feature importance score, only populated when cross-feature
      monitoring is enabled. For now only used to represent feature
      attribution score within range [0, 1] for
      ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_SKEW and
      ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_DRIFT.
    startTime: The start timestamp of window where stats were generated. For
      objectives where time window doesn't make sense (e.g. Featurestore
      Snapshot Monitoring), start_time is only used to indicate the monitoring
      intervals, so it always equals to (end_time - monitoring_interval).
    statsUri: Path of the stats file for current feature values in Cloud
      Storage bucket. Format: gs:////stats. Example:
      gs://monitoring_bucket/feature_name/stats. Stats are stored as binary
      format with Protobuf message [tensorflow.metadata.v0.FeatureNameStatisti
      cs](https://github.com/tensorflow/metadata/blob/master/tensorflow_metada
      ta/proto/v0/statistics.proto).
  """

  anomalyDetectionThreshold = _messages.FloatField(1)
  anomalyUri = _messages.StringField(2)
  distributionDeviation = _messages.FloatField(3)
  endTime = _messages.StringField(4)
  score = _messages.FloatField(5)
  startTime = _messages.StringField(6)
  statsUri = _messages.StringField(7)


class GoogleCloudAiplatformV1beta1FeatureValue(_messages.Message):
  r"""Value for a feature.

  Fields:
    boolArrayValue: A list of bool type feature value.
    boolValue: Bool type feature value.
    bytesValue: Bytes feature value.
    doubleArrayValue: A list of double type feature value.
    doubleValue: Double type feature value.
    int64ArrayValue: A list of int64 type feature value.
    int64Value: Int64 feature value.
    metadata: Metadata of feature value.
    stringArrayValue: A list of string type feature value.
    stringValue: String feature value.
    structValue: A struct type feature value.
  """

  boolArrayValue = _messages.MessageField('GoogleCloudAiplatformV1beta1BoolArray', 1)
  boolValue = _messages.BooleanField(2)
  bytesValue = _messages.BytesField(3)
  doubleArrayValue = _messages.MessageField('GoogleCloudAiplatformV1beta1DoubleArray', 4)
  doubleValue = _messages.FloatField(5)
  int64ArrayValue = _messages.MessageField('GoogleCloudAiplatformV1beta1Int64Array', 6)
  int64Value = _messages.IntegerField(7)
  metadata = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureValueMetadata', 8)
  stringArrayValue = _messages.MessageField('GoogleCloudAiplatformV1beta1StringArray', 9)
  stringValue = _messages.StringField(10)
  structValue = _messages.MessageField('GoogleCloudAiplatformV1beta1StructValue', 11)


class GoogleCloudAiplatformV1beta1FeatureValueDestination(_messages.Message):
  r"""A destination location for Feature values and format.

  Fields:
    bigqueryDestination: Output in BigQuery format.
      BigQueryDestination.output_uri in
      FeatureValueDestination.bigquery_destination must refer to a table.
    csvDestination: Output in CSV format. Array Feature value types are not
      allowed in CSV format.
    tfrecordDestination: Output in TFRecord format. Below are the mapping from
      Feature value type in Featurestore to Feature value type in TFRecord:
      Value type in Featurestore | Value type in TFRecord DOUBLE, DOUBLE_ARRAY
      | FLOAT_LIST INT64, INT64_ARRAY | INT64_LIST STRING, STRING_ARRAY, BYTES
      | BYTES_LIST true -> byte_string("true"), false -> byte_string("false")
      BOOL, BOOL_ARRAY (true, false) | BYTES_LIST
  """

  bigqueryDestination = _messages.MessageField('GoogleCloudAiplatformV1beta1BigQueryDestination', 1)
  csvDestination = _messages.MessageField('GoogleCloudAiplatformV1beta1CsvDestination', 2)
  tfrecordDestination = _messages.MessageField('GoogleCloudAiplatformV1beta1TFRecordDestination', 3)


class GoogleCloudAiplatformV1beta1FeatureValueList(_messages.Message):
  r"""Container for list of values.

  Fields:
    values: A list of feature values. All of them should be the same data
      type.
  """

  values = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureValue', 1, repeated=True)


class GoogleCloudAiplatformV1beta1FeatureValueMetadata(_messages.Message):
  r"""Metadata of feature value.

  Fields:
    generateTime: Feature generation timestamp. Typically, it is provided by
      user at feature ingestion time. If not, feature store will use the
      system timestamp when the data is ingested into feature store. For
      streaming ingestion, the time, aligned by days, must be no older than
      five years (1825 days) and no later than one year (366 days) in the
      future.
  """

  generateTime = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1FeatureView(_messages.Message):
  r"""FeatureView is representation of values that the FeatureOnlineStore will
  serve based on its syncConfig.

  Enums:
    ServiceAgentTypeValueValuesEnum: Optional. Service agent type used during
      data sync. By default, the Vertex AI Service Agent is used. When using
      an IAM Policy to isolate this FeatureView within a project, a separate
      service account should be provisioned by setting this field to
      `SERVICE_AGENT_TYPE_FEATURE_VIEW`. This will generate a separate service
      account to access the BigQuery source table.

  Messages:
    LabelsValue: Optional. The labels with user-defined metadata to organize
      your FeatureViews. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information on and examples
      of labels. No more than 64 user labels can be associated with one
      FeatureOnlineStore(System labels are excluded)." System reserved label
      keys are prefixed with "aiplatform.googleapis.com/" and are immutable.

  Fields:
    bigQuerySource: Optional. Configures how data is supposed to be extracted
      from a BigQuery source to be loaded onto the FeatureOnlineStore.
    createTime: Output only. Timestamp when this FeatureView was created.
    etag: Optional. Used to perform consistent read-modify-write updates. If
      not set, a blind "overwrite" update happens.
    featureRegistrySource: Optional. Configures the features from a Feature
      Registry source that need to be loaded onto the FeatureOnlineStore.
    indexConfig: Optional. Configuration for index preparation for vector
      search. It contains the required configurations to create an index from
      source data, so that approximate nearest neighbor (a.k.a ANN) algorithms
      search can be performed during online serving.
    labels: Optional. The labels with user-defined metadata to organize your
      FeatureViews. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information on and examples
      of labels. No more than 64 user labels can be associated with one
      FeatureOnlineStore(System labels are excluded)." System reserved label
      keys are prefixed with "aiplatform.googleapis.com/" and are immutable.
    name: Identifier. Name of the FeatureView. Format: `projects/{project}/loc
      ations/{location}/featureOnlineStores/{feature_online_store}/featureView
      s/{feature_view}`
    optimizedConfig: Optional. Configuration for FeatureView created under
      Optimized FeatureOnlineStore.
    satisfiesPzi: Output only. Reserved for future use.
    satisfiesPzs: Output only. Reserved for future use.
    serviceAccountEmail: Output only. A Service Account unique to this
      FeatureView. The role bigquery.dataViewer should be granted to this
      service account to allow Vertex AI Feature Store to sync data to the
      online store.
    serviceAgentType: Optional. Service agent type used during data sync. By
      default, the Vertex AI Service Agent is used. When using an IAM Policy
      to isolate this FeatureView within a project, a separate service account
      should be provisioned by setting this field to
      `SERVICE_AGENT_TYPE_FEATURE_VIEW`. This will generate a separate service
      account to access the BigQuery source table.
    syncConfig: Configures when data is to be synced/updated for this
      FeatureView. At the end of the sync the latest featureValues for each
      entityId of this FeatureView are made ready for online serving.
    updateTime: Output only. Timestamp when this FeatureView was last updated.
    vectorSearchConfig: Optional. Deprecated: please use
      FeatureView.index_config instead.
    vertexRagSource: Optional. The Vertex RAG Source that the FeatureView is
      linked to.
  """

  class ServiceAgentTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Service agent type used during data sync. By default, the
    Vertex AI Service Agent is used. When using an IAM Policy to isolate this
    FeatureView within a project, a separate service account should be
    provisioned by setting this field to `SERVICE_AGENT_TYPE_FEATURE_VIEW`.
    This will generate a separate service account to access the BigQuery
    source table.

    Values:
      SERVICE_AGENT_TYPE_UNSPECIFIED: By default, the project-level Vertex AI
        Service Agent is enabled.
      SERVICE_AGENT_TYPE_PROJECT: Indicates the project-level Vertex AI
        Service Agent (https://cloud.google.com/vertex-ai/docs/general/access-
        control#service-agents) will be used during sync jobs.
      SERVICE_AGENT_TYPE_FEATURE_VIEW: Enable a FeatureView service account to
        be created by Vertex AI and output in the field
        `service_account_email`. This service account will be used to read
        from the source BigQuery table during sync.
    """
    SERVICE_AGENT_TYPE_UNSPECIFIED = 0
    SERVICE_AGENT_TYPE_PROJECT = 1
    SERVICE_AGENT_TYPE_FEATURE_VIEW = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels with user-defined metadata to organize your
    FeatureViews. Label keys and values can be no longer than 64 characters
    (Unicode codepoints), can only contain lowercase letters, numeric
    characters, underscores and dashes. International characters are allowed.
    See https://goo.gl/xmQnxf for more information on and examples of labels.
    No more than 64 user labels can be associated with one
    FeatureOnlineStore(System labels are excluded)." System reserved label
    keys are prefixed with "aiplatform.googleapis.com/" and are immutable.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  bigQuerySource = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureViewBigQuerySource', 1)
  createTime = _messages.StringField(2)
  etag = _messages.StringField(3)
  featureRegistrySource = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureViewFeatureRegistrySource', 4)
  indexConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureViewIndexConfig', 5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  optimizedConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureViewOptimizedConfig', 8)
  satisfiesPzi = _messages.BooleanField(9)
  satisfiesPzs = _messages.BooleanField(10)
  serviceAccountEmail = _messages.StringField(11)
  serviceAgentType = _messages.EnumField('ServiceAgentTypeValueValuesEnum', 12)
  syncConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureViewSyncConfig', 13)
  updateTime = _messages.StringField(14)
  vectorSearchConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureViewVectorSearchConfig', 15)
  vertexRagSource = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureViewVertexRagSource', 16)


class GoogleCloudAiplatformV1beta1FeatureViewBigQuerySource(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1FeatureViewBigQuerySource object.

  Fields:
    entityIdColumns: Required. Columns to construct entity_id / row keys.
    uri: Required. The BigQuery view URI that will be materialized on each
      sync trigger based on FeatureView.SyncConfig.
  """

  entityIdColumns = _messages.StringField(1, repeated=True)
  uri = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1FeatureViewDataKey(_messages.Message):
  r"""Lookup key for a feature view.

  Fields:
    compositeKey: The actual Entity ID will be composed from this struct. This
      should match with the way ID is defined in the FeatureView spec.
    key: String key to use for lookup.
  """

  compositeKey = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureViewDataKeyCompositeKey', 1)
  key = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1FeatureViewDataKeyCompositeKey(_messages.Message):
  r"""ID that is comprised from several parts (columns).

  Fields:
    parts: Parts to construct Entity ID. Should match with the same ID columns
      as defined in FeatureView in the same order.
  """

  parts = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1beta1FeatureViewFeatureRegistrySource(_messages.Message):
  r"""A Feature Registry source for features that need to be synced to Online
  Store.

  Fields:
    featureGroups: Required. List of features that need to be synced to Online
      Store.
    projectNumber: Optional. The project number of the parent project of the
      Feature Groups.
  """

  featureGroups = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureViewFeatureRegistrySourceFeatureGroup', 1, repeated=True)
  projectNumber = _messages.IntegerField(2)


class GoogleCloudAiplatformV1beta1FeatureViewFeatureRegistrySourceFeatureGroup(_messages.Message):
  r"""Features belonging to a single feature group that will be synced to
  Online Store.

  Fields:
    featureGroupId: Required. Identifier of the feature group.
    featureIds: Required. Identifiers of features under the feature group.
  """

  featureGroupId = _messages.StringField(1)
  featureIds = _messages.StringField(2, repeated=True)


class GoogleCloudAiplatformV1beta1FeatureViewIndexConfig(_messages.Message):
  r"""Configuration for vector indexing.

  Enums:
    DistanceMeasureTypeValueValuesEnum: Optional. The distance measure used in
      nearest neighbor search.

  Fields:
    bruteForceConfig: Optional. Configuration options for using brute force
      search, which simply implements the standard linear search in the
      database for each query. It is primarily meant for benchmarking and to
      generate the ground truth for approximate search.
    crowdingColumn: Optional. Column of crowding. This column contains
      crowding attribute which is a constraint on a neighbor list produced by
      FeatureOnlineStoreService.SearchNearestEntities to diversify search
      results. If NearestNeighborQuery.per_crowding_attribute_neighbor_count
      is set to K in SearchNearestEntitiesRequest, it's guaranteed that no
      more than K entities of the same crowding attribute are returned in the
      response.
    distanceMeasureType: Optional. The distance measure used in nearest
      neighbor search.
    embeddingColumn: Optional. Column of embedding. This column contains the
      source data to create index for vector search. embedding_column must be
      set when using vector search.
    embeddingDimension: Optional. The number of dimensions of the input
      embedding.
    filterColumns: Optional. Columns of features that're used to filter vector
      search results.
    treeAhConfig: Optional. Configuration options for the tree-AH algorithm
      (Shallow tree + Asymmetric Hashing). Please refer to this paper for more
      details: https://arxiv.org/abs/1908.10396
  """

  class DistanceMeasureTypeValueValuesEnum(_messages.Enum):
    r"""Optional. The distance measure used in nearest neighbor search.

    Values:
      DISTANCE_MEASURE_TYPE_UNSPECIFIED: Should not be set.
      SQUARED_L2_DISTANCE: Euclidean (L_2) Distance.
      COSINE_DISTANCE: Cosine Distance. Defined as 1 - cosine similarity. We
        strongly suggest using DOT_PRODUCT_DISTANCE + UNIT_L2_NORM instead of
        COSINE distance. Our algorithms have been more optimized for
        DOT_PRODUCT distance which, when combined with UNIT_L2_NORM, is
        mathematically equivalent to COSINE distance and results in the same
        ranking.
      DOT_PRODUCT_DISTANCE: Dot Product Distance. Defined as a negative of the
        dot product.
    """
    DISTANCE_MEASURE_TYPE_UNSPECIFIED = 0
    SQUARED_L2_DISTANCE = 1
    COSINE_DISTANCE = 2
    DOT_PRODUCT_DISTANCE = 3

  bruteForceConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureViewIndexConfigBruteForceConfig', 1)
  crowdingColumn = _messages.StringField(2)
  distanceMeasureType = _messages.EnumField('DistanceMeasureTypeValueValuesEnum', 3)
  embeddingColumn = _messages.StringField(4)
  embeddingDimension = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  filterColumns = _messages.StringField(6, repeated=True)
  treeAhConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureViewIndexConfigTreeAHConfig', 7)


class GoogleCloudAiplatformV1beta1FeatureViewIndexConfigBruteForceConfig(_messages.Message):
  r"""Configuration options for using brute force search."""


class GoogleCloudAiplatformV1beta1FeatureViewIndexConfigTreeAHConfig(_messages.Message):
  r"""Configuration options for the tree-AH algorithm.

  Fields:
    leafNodeEmbeddingCount: Optional. Number of embeddings on each leaf node.
      The default value is 1000 if not set.
  """

  leafNodeEmbeddingCount = _messages.IntegerField(1)


class GoogleCloudAiplatformV1beta1FeatureViewOptimizedConfig(_messages.Message):
  r"""Configuration for FeatureViews created in Optimized FeatureOnlineStore.

  Fields:
    automaticResources: Optional. A description of resources that the
      FeatureView uses, which to large degree are decided by Vertex AI, and
      optionally allows only a modest additional configuration. If
      min_replica_count is not set, the default value is 2. If
      max_replica_count is not set, the default value is 6. The max allowed
      replica count is 1000.
  """

  automaticResources = _messages.MessageField('GoogleCloudAiplatformV1beta1AutomaticResources', 1)


class GoogleCloudAiplatformV1beta1FeatureViewSync(_messages.Message):
  r"""FeatureViewSync is a representation of sync operation which copies data
  from data source to Feature View in Online Store.

  Fields:
    createTime: Output only. Time when this FeatureViewSync is created.
      Creation of a FeatureViewSync means that the job is pending / waiting
      for sufficient resources but may not have started the actual data
      transfer yet.
    finalStatus: Output only. Final status of the FeatureViewSync.
    name: Identifier. Name of the FeatureViewSync. Format: `projects/{project}
      /locations/{location}/featureOnlineStores/{feature_online_store}/feature
      Views/{feature_view}/featureViewSyncs/{feature_view_sync}`
    runTime: Output only. Time when this FeatureViewSync is finished.
    satisfiesPzi: Output only. Reserved for future use.
    satisfiesPzs: Output only. Reserved for future use.
    syncSummary: Output only. Summary of the sync job.
  """

  createTime = _messages.StringField(1)
  finalStatus = _messages.MessageField('GoogleRpcStatus', 2)
  name = _messages.StringField(3)
  runTime = _messages.MessageField('GoogleTypeInterval', 4)
  satisfiesPzi = _messages.BooleanField(5)
  satisfiesPzs = _messages.BooleanField(6)
  syncSummary = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureViewSyncSyncSummary', 7)


class GoogleCloudAiplatformV1beta1FeatureViewSyncConfig(_messages.Message):
  r"""Configuration for Sync. Only one option is set.

  Fields:
    continuous: Optional. If true, syncs the FeatureView in a continuous
      manner to Online Store.
    cron: Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch
      scheduled runs. To explicitly set a timezone to the cron tab, apply a
      prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or
      "TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string
      from IANA time zone database. For example, "CRON_TZ=America/New_York 1 *
      * * *", or "TZ=America/New_York 1 * * * *".
  """

  continuous = _messages.BooleanField(1)
  cron = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1FeatureViewSyncSyncSummary(_messages.Message):
  r"""Summary from the Sync job. For continuous syncs, the summary is updated
  periodically. For batch syncs, it gets updated on completion of the sync.

  Fields:
    rowSynced: Output only. Total number of rows synced.
    systemWatermarkTime: Lower bound of the system time watermark for the sync
      job. This is only set for continuously syncing feature views.
    totalSlot: Output only. BigQuery slot milliseconds consumed for the sync
      job.
  """

  rowSynced = _messages.IntegerField(1)
  systemWatermarkTime = _messages.StringField(2)
  totalSlot = _messages.IntegerField(3)


class GoogleCloudAiplatformV1beta1FeatureViewVectorSearchConfig(_messages.Message):
  r"""Deprecated. Use IndexConfig instead.

  Enums:
    DistanceMeasureTypeValueValuesEnum: Optional. The distance measure used in
      nearest neighbor search.

  Fields:
    bruteForceConfig: Optional. Configuration options for using brute force
      search, which simply implements the standard linear search in the
      database for each query. It is primarily meant for benchmarking and to
      generate the ground truth for approximate search.
    crowdingColumn: Optional. Column of crowding. This column contains
      crowding attribute which is a constraint on a neighbor list produced by
      FeatureOnlineStoreService.SearchNearestEntities to diversify search
      results. If NearestNeighborQuery.per_crowding_attribute_neighbor_count
      is set to K in SearchNearestEntitiesRequest, it's guaranteed that no
      more than K entities of the same crowding attribute are returned in the
      response.
    distanceMeasureType: Optional. The distance measure used in nearest
      neighbor search.
    embeddingColumn: Optional. Column of embedding. This column contains the
      source data to create index for vector search. embedding_column must be
      set when using vector search.
    embeddingDimension: Optional. The number of dimensions of the input
      embedding.
    filterColumns: Optional. Columns of features that're used to filter vector
      search results.
    treeAhConfig: Optional. Configuration options for the tree-AH algorithm
      (Shallow tree + Asymmetric Hashing). Please refer to this paper for more
      details: https://arxiv.org/abs/1908.10396
  """

  class DistanceMeasureTypeValueValuesEnum(_messages.Enum):
    r"""Optional. The distance measure used in nearest neighbor search.

    Values:
      DISTANCE_MEASURE_TYPE_UNSPECIFIED: Should not be set.
      SQUARED_L2_DISTANCE: Euclidean (L_2) Distance.
      COSINE_DISTANCE: Cosine Distance. Defined as 1 - cosine similarity. We
        strongly suggest using DOT_PRODUCT_DISTANCE + UNIT_L2_NORM instead of
        COSINE distance. Our algorithms have been more optimized for
        DOT_PRODUCT distance which, when combined with UNIT_L2_NORM, is
        mathematically equivalent to COSINE distance and results in the same
        ranking.
      DOT_PRODUCT_DISTANCE: Dot Product Distance. Defined as a negative of the
        dot product.
    """
    DISTANCE_MEASURE_TYPE_UNSPECIFIED = 0
    SQUARED_L2_DISTANCE = 1
    COSINE_DISTANCE = 2
    DOT_PRODUCT_DISTANCE = 3

  bruteForceConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureViewVectorSearchConfigBruteForceConfig', 1)
  crowdingColumn = _messages.StringField(2)
  distanceMeasureType = _messages.EnumField('DistanceMeasureTypeValueValuesEnum', 3)
  embeddingColumn = _messages.StringField(4)
  embeddingDimension = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  filterColumns = _messages.StringField(6, repeated=True)
  treeAhConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureViewVectorSearchConfigTreeAHConfig', 7)


class GoogleCloudAiplatformV1beta1FeatureViewVectorSearchConfigBruteForceConfig(_messages.Message):
  r"""A
  GoogleCloudAiplatformV1beta1FeatureViewVectorSearchConfigBruteForceConfig
  object.
  """



class GoogleCloudAiplatformV1beta1FeatureViewVectorSearchConfigTreeAHConfig(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1FeatureViewVectorSearchConfigTreeAHConfig
  object.

  Fields:
    leafNodeEmbeddingCount: Optional. Number of embeddings on each leaf node.
      The default value is 1000 if not set.
  """

  leafNodeEmbeddingCount = _messages.IntegerField(1)


class GoogleCloudAiplatformV1beta1FeatureViewVertexRagSource(_messages.Message):
  r"""A Vertex Rag source for features that need to be synced to Online Store.

  Fields:
    ragCorpusId: Optional. The RAG corpus id corresponding to this
      FeatureView.
    uri: Required. The BigQuery view/table URI that will be materialized on
      each manual sync trigger. The table/view is expected to have the
      following columns and types at least: - `corpus_id` (STRING,
      NULLABLE/REQUIRED) - `file_id` (STRING, NULLABLE/REQUIRED) - `chunk_id`
      (STRING, NULLABLE/REQUIRED) - `chunk_data_type` (STRING,
      NULLABLE/REQUIRED) - `chunk_data` (STRING, NULLABLE/REQUIRED) -
      `embeddings` (FLOAT, REPEATED) - `file_original_uri` (STRING,
      NULLABLE/REQUIRED)
  """

  ragCorpusId = _messages.IntegerField(1)
  uri = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1Featurestore(_messages.Message):
  r"""Vertex AI Feature Store provides a centralized repository for
  organizing, storing, and serving ML features. The Featurestore is a top-
  level container for your features and their values.

  Enums:
    StateValueValuesEnum: Output only. State of the featurestore.

  Messages:
    LabelsValue: Optional. The labels with user-defined metadata to organize
      your Featurestore. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information on and examples
      of labels. No more than 64 user labels can be associated with one
      Featurestore(System labels are excluded)." System reserved label keys
      are prefixed with "aiplatform.googleapis.com/" and are immutable.

  Fields:
    createTime: Output only. Timestamp when this Featurestore was created.
    encryptionSpec: Optional. Customer-managed encryption key spec for data
      storage. If set, both of the online and offline data storage will be
      secured by this key.
    etag: Optional. Used to perform consistent read-modify-write updates. If
      not set, a blind "overwrite" update happens.
    labels: Optional. The labels with user-defined metadata to organize your
      Featurestore. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information on and examples
      of labels. No more than 64 user labels can be associated with one
      Featurestore(System labels are excluded)." System reserved label keys
      are prefixed with "aiplatform.googleapis.com/" and are immutable.
    name: Output only. Name of the Featurestore. Format:
      `projects/{project}/locations/{location}/featurestores/{featurestore}`
    onlineServingConfig: Optional. Config for online storage resources. The
      field should not co-exist with the field of
      `OnlineStoreReplicationConfig`. If both of it and
      OnlineStoreReplicationConfig are unset, the feature store will not have
      an online store and cannot be used for online serving.
    onlineStorageTtlDays: Optional. TTL in days for feature values that will
      be stored in online serving storage. The Feature Store online storage
      periodically removes obsolete feature values older than
      `online_storage_ttl_days` since the feature generation time. Note that
      `online_storage_ttl_days` should be less than or equal to
      `offline_storage_ttl_days` for each EntityType under a featurestore. If
      not set, default to 4000 days
    satisfiesPzi: Output only. Reserved for future use.
    satisfiesPzs: Output only. Reserved for future use.
    state: Output only. State of the featurestore.
    updateTime: Output only. Timestamp when this Featurestore was last
      updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the featurestore.

    Values:
      STATE_UNSPECIFIED: Default value. This value is unused.
      STABLE: State when the featurestore configuration is not being updated
        and the fields reflect the current configuration of the featurestore.
        The featurestore is usable in this state.
      UPDATING: The state of the featurestore configuration when it is being
        updated. During an update, the fields reflect either the original
        configuration or the updated configuration of the featurestore. For
        example, `online_serving_config.fixed_node_count` can take minutes to
        update. While the update is in progress, the featurestore is in the
        UPDATING state, and the value of `fixed_node_count` can be the
        original value or the updated value, depending on the progress of the
        operation. Until the update completes, the actual number of nodes can
        still be the original value of `fixed_node_count`. The featurestore is
        still usable in this state.
    """
    STATE_UNSPECIFIED = 0
    STABLE = 1
    UPDATING = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels with user-defined metadata to organize your
    Featurestore. Label keys and values can be no longer than 64 characters
    (Unicode codepoints), can only contain lowercase letters, numeric
    characters, underscores and dashes. International characters are allowed.
    See https://goo.gl/xmQnxf for more information on and examples of labels.
    No more than 64 user labels can be associated with one Featurestore(System
    labels are excluded)." System reserved label keys are prefixed with
    "aiplatform.googleapis.com/" and are immutable.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1EncryptionSpec', 2)
  etag = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  onlineServingConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1FeaturestoreOnlineServingConfig', 6)
  onlineStorageTtlDays = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  satisfiesPzi = _messages.BooleanField(8)
  satisfiesPzs = _messages.BooleanField(9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  updateTime = _messages.StringField(11)


class GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfig(_messages.Message):
  r"""Configuration of how features in Featurestore are monitored.

  Fields:
    categoricalThresholdConfig: Threshold for categorical features of anomaly
      detection. This is shared by all types of Featurestore Monitoring for
      categorical features (i.e. Features with type (Feature.ValueType) BOOL
      or STRING).
    importFeaturesAnalysis: The config for ImportFeatures Analysis Based
      Feature Monitoring.
    numericalThresholdConfig: Threshold for numerical features of anomaly
      detection. This is shared by all objectives of Featurestore Monitoring
      for numerical features (i.e. Features with type (Feature.ValueType)
      DOUBLE or INT64).
    snapshotAnalysis: The config for Snapshot Analysis Based Feature
      Monitoring.
  """

  categoricalThresholdConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigThresholdConfig', 1)
  importFeaturesAnalysis = _messages.MessageField('GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigImportFeaturesAnalysis', 2)
  numericalThresholdConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigThresholdConfig', 3)
  snapshotAnalysis = _messages.MessageField('GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigSnapshotAnalysis', 4)


class GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigImportFeaturesAnalysis(_messages.Message):
  r"""Configuration of the Featurestore's ImportFeature Analysis Based
  Monitoring. This type of analysis generates statistics for values of each
  Feature imported by every ImportFeatureValues operation.

  Enums:
    AnomalyDetectionBaselineValueValuesEnum: The baseline used to do anomaly
      detection for the statistics generated by import features analysis.
    StateValueValuesEnum: Whether to enable / disable / inherite default
      hebavior for import features analysis.

  Fields:
    anomalyDetectionBaseline: The baseline used to do anomaly detection for
      the statistics generated by import features analysis.
    state: Whether to enable / disable / inherite default hebavior for import
      features analysis.
  """

  class AnomalyDetectionBaselineValueValuesEnum(_messages.Enum):
    r"""The baseline used to do anomaly detection for the statistics generated
    by import features analysis.

    Values:
      BASELINE_UNSPECIFIED: Should not be used.
      LATEST_STATS: Choose the later one statistics generated by either most
        recent snapshot analysis or previous import features analysis. If non
        of them exists, skip anomaly detection and only generate a statistics.
      MOST_RECENT_SNAPSHOT_STATS: Use the statistics generated by the most
        recent snapshot analysis if exists.
      PREVIOUS_IMPORT_FEATURES_STATS: Use the statistics generated by the
        previous import features analysis if exists.
    """
    BASELINE_UNSPECIFIED = 0
    LATEST_STATS = 1
    MOST_RECENT_SNAPSHOT_STATS = 2
    PREVIOUS_IMPORT_FEATURES_STATS = 3

  class StateValueValuesEnum(_messages.Enum):
    r"""Whether to enable / disable / inherite default hebavior for import
    features analysis.

    Values:
      STATE_UNSPECIFIED: Should not be used.
      DEFAULT: The default behavior of whether to enable the monitoring.
        EntityType-level config: disabled. Feature-level config: inherited
        from the configuration of EntityType this Feature belongs to.
      ENABLED: Explicitly enables import features analysis. EntityType-level
        config: by default enables import features analysis for all Features
        under it. Feature-level config: enables import features analysis
        regardless of the EntityType-level config.
      DISABLED: Explicitly disables import features analysis. EntityType-level
        config: by default disables import features analysis for all Features
        under it. Feature-level config: disables import features analysis
        regardless of the EntityType-level config.
    """
    STATE_UNSPECIFIED = 0
    DEFAULT = 1
    ENABLED = 2
    DISABLED = 3

  anomalyDetectionBaseline = _messages.EnumField('AnomalyDetectionBaselineValueValuesEnum', 1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigSnapshotAnalysis(_messages.Message):
  r"""Configuration of the Featurestore's Snapshot Analysis Based Monitoring.
  This type of analysis generates statistics for each Feature based on a
  snapshot of the latest feature value of each entities every
  monitoring_interval.

  Fields:
    disabled: The monitoring schedule for snapshot analysis. For EntityType-
      level config: unset / disabled = true indicates disabled by default for
      Features under it; otherwise by default enable snapshot analysis
      monitoring with monitoring_interval for Features under it. Feature-level
      config: disabled = true indicates disabled regardless of the EntityType-
      level config; unset monitoring_interval indicates going with EntityType-
      level config; otherwise run snapshot analysis monitoring with
      monitoring_interval regardless of the EntityType-level config.
      Explicitly Disable the snapshot analysis based monitoring.
    monitoringInterval: Configuration of the snapshot analysis based
      monitoring pipeline running interval. The value is rolled up to full
      day. If both monitoring_interval_days and the deprecated
      `monitoring_interval` field are set when creating/updating
      EntityTypes/Features, monitoring_interval_days will be used.
    monitoringIntervalDays: Configuration of the snapshot analysis based
      monitoring pipeline running interval. The value indicates number of
      days.
    stalenessDays: Customized export features time window for snapshot
      analysis. Unit is one day. Default value is 3 weeks. Minimum value is 1
      day. Maximum value is 4000 days.
  """

  disabled = _messages.BooleanField(1)
  monitoringInterval = _messages.StringField(2)
  monitoringIntervalDays = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  stalenessDays = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigThresholdConfig(_messages.Message):
  r"""The config for Featurestore Monitoring threshold.

  Fields:
    value: Specify a threshold value that can trigger the alert. 1. For
      categorical feature, the distribution distance is calculated by
      L-inifinity norm. 2. For numerical feature, the distribution distance is
      calculated by Jensen\u2013Shannon divergence. Each feature must have a
      non-zero threshold if they need to be monitored. Otherwise no alert will
      be triggered for that feature.
  """

  value = _messages.FloatField(1)


class GoogleCloudAiplatformV1beta1FeaturestoreOnlineServingConfig(_messages.Message):
  r"""OnlineServingConfig specifies the details for provisioning online
  serving resources.

  Fields:
    fixedNodeCount: The number of nodes for the online store. The number of
      nodes doesn't scale automatically, but you can manually update the
      number of nodes. If set to 0, the featurestore will not have an online
      store and cannot be used for online serving.
    scaling: Online serving scaling configuration. Only one of
      `fixed_node_count` and `scaling` can be set. Setting one will reset the
      other.
  """

  fixedNodeCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  scaling = _messages.MessageField('GoogleCloudAiplatformV1beta1FeaturestoreOnlineServingConfigScaling', 2)


class GoogleCloudAiplatformV1beta1FeaturestoreOnlineServingConfigScaling(_messages.Message):
  r"""Online serving scaling configuration. If min_node_count and
  max_node_count are set to the same value, the cluster will be configured
  with the fixed number of node (no auto-scaling).

  Fields:
    cpuUtilizationTarget: Optional. The cpu utilization that the Autoscaler
      should be trying to achieve. This number is on a scale from 0 (no
      utilization) to 100 (total utilization), and is limited between 10 and
      80. When a cluster's CPU utilization exceeds the target that you have
      set, Bigtable immediately adds nodes to the cluster. When CPU
      utilization is substantially lower than the target, Bigtable removes
      nodes. If not set or set to 0, default to 50.
    maxNodeCount: The maximum number of nodes to scale up to. Must be greater
      than min_node_count, and less than or equal to 10 times of
      'min_node_count'.
    minNodeCount: Required. The minimum number of nodes to scale down to. Must
      be greater than or equal to 1.
  """

  cpuUtilizationTarget = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  maxNodeCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  minNodeCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1FetchFeatureValuesRequest(_messages.Message):
  r"""Request message for FeatureOnlineStoreService.FetchFeatureValues. All
  the features under the requested feature view will be returned.

  Enums:
    DataFormatValueValuesEnum: Optional. Response data format. If not set,
      FeatureViewDataFormat.KEY_VALUE will be used.
    FormatValueValuesEnum: Specify response data format. If not set, KeyValue
      format will be used. Deprecated. Use
      FetchFeatureValuesRequest.data_format.

  Fields:
    dataFormat: Optional. Response data format. If not set,
      FeatureViewDataFormat.KEY_VALUE will be used.
    dataKey: Optional. The request key to fetch feature values for.
    format: Specify response data format. If not set, KeyValue format will be
      used. Deprecated. Use FetchFeatureValuesRequest.data_format.
    id: Simple ID. The whole string will be used as is to identify Entity to
      fetch feature values for.
  """

  class DataFormatValueValuesEnum(_messages.Enum):
    r"""Optional. Response data format. If not set,
    FeatureViewDataFormat.KEY_VALUE will be used.

    Values:
      FEATURE_VIEW_DATA_FORMAT_UNSPECIFIED: Not set. Will be treated as the
        KeyValue format.
      KEY_VALUE: Return response data in key-value format.
      PROTO_STRUCT: Return response data in proto Struct format.
    """
    FEATURE_VIEW_DATA_FORMAT_UNSPECIFIED = 0
    KEY_VALUE = 1
    PROTO_STRUCT = 2

  class FormatValueValuesEnum(_messages.Enum):
    r"""Specify response data format. If not set, KeyValue format will be
    used. Deprecated. Use FetchFeatureValuesRequest.data_format.

    Values:
      FORMAT_UNSPECIFIED: Not set. Will be treated as the KeyValue format.
      KEY_VALUE: Return response data in key-value format.
      PROTO_STRUCT: Return response data in proto Struct format.
    """
    FORMAT_UNSPECIFIED = 0
    KEY_VALUE = 1
    PROTO_STRUCT = 2

  dataFormat = _messages.EnumField('DataFormatValueValuesEnum', 1)
  dataKey = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureViewDataKey', 2)
  format = _messages.EnumField('FormatValueValuesEnum', 3)
  id = _messages.StringField(4)


class GoogleCloudAiplatformV1beta1FetchFeatureValuesResponse(_messages.Message):
  r"""Response message for FeatureOnlineStoreService.FetchFeatureValues

  Messages:
    ProtoStructValue: Feature values in proto Struct format.

  Fields:
    dataKey: The data key associated with this response. Will only be
      populated for FeatureOnlineStoreService.StreamingFetchFeatureValues
      RPCs.
    keyValues: Feature values in KeyValue format.
    protoStruct: Feature values in proto Struct format.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ProtoStructValue(_messages.Message):
    r"""Feature values in proto Struct format.

    Messages:
      AdditionalProperty: An additional property for a ProtoStructValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ProtoStructValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  dataKey = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureViewDataKey', 1)
  keyValues = _messages.MessageField('GoogleCloudAiplatformV1beta1FetchFeatureValuesResponseFeatureNameValuePairList', 2)
  protoStruct = _messages.MessageField('ProtoStructValue', 3)


class GoogleCloudAiplatformV1beta1FetchFeatureValuesResponseFeatureNameValuePairList(_messages.Message):
  r"""Response structure in the format of key (feature name) and (feature)
  value pair.

  Fields:
    features: List of feature names and values.
  """

  features = _messages.MessageField('GoogleCloudAiplatformV1beta1FetchFeatureValuesResponseFeatureNameValuePairListFeatureNameValuePair', 1, repeated=True)


class GoogleCloudAiplatformV1beta1FetchFeatureValuesResponseFeatureNameValuePairListFeatureNameValuePair(_messages.Message):
  r"""Feature name & value pair.

  Fields:
    name: Feature short name.
    value: Feature value.
  """

  name = _messages.StringField(1)
  value = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureValue', 2)


class GoogleCloudAiplatformV1beta1FetchPredictOperationRequest(_messages.Message):
  r"""Request message for PredictionService.FetchPredictOperation.

  Fields:
    operationName: Required. The server-assigned name for the operation.
  """

  operationName = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1FileData(_messages.Message):
  r"""URI based data.

  Fields:
    displayName: Optional. Display name of the file data. Used to provide a
      label or filename to distinguish file datas. This field is only returned
      in PromptMessage for prompt management. It is not currently used in the
      Gemini GenerateContent calls.
    fileUri: Required. URI.
    mimeType: Required. The IANA standard MIME type of the source data.
  """

  displayName = _messages.StringField(1)
  fileUri = _messages.StringField(2)
  mimeType = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1FileStatus(_messages.Message):
  r"""RagFile status.

  Enums:
    StateValueValuesEnum: Output only. RagFile state.

  Fields:
    errorStatus: Output only. Only when the `state` field is ERROR.
    state: Output only. RagFile state.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. RagFile state.

    Values:
      STATE_UNSPECIFIED: RagFile state is unspecified.
      ACTIVE: RagFile resource has been created and indexed successfully.
      ERROR: RagFile resource is in a problematic state. See `error_message`
        field for details.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    ERROR = 2

  errorStatus = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class GoogleCloudAiplatformV1beta1FilterSplit(_messages.Message):
  r"""Assigns input data to training, validation, and test sets based on the
  given filters, data pieces not matched by any filter are ignored. Currently
  only supported for Datasets containing DataItems. If any of the filters in
  this message are to match nothing, then they can be set as '-' (the minus
  sign). Supported only for unstructured Datasets.

  Fields:
    testFilter: Required. A filter on DataItems of the Dataset. DataItems that
      match this filter are used to test the Model. A filter with same syntax
      as the one used in DatasetService.ListDataItems may be used. If a single
      DataItem is matched by more than one of the FilterSplit filters, then it
      is assigned to the first set that applies to it in the training,
      validation, test order.
    trainingFilter: Required. A filter on DataItems of the Dataset. DataItems
      that match this filter are used to train the Model. A filter with same
      syntax as the one used in DatasetService.ListDataItems may be used. If a
      single DataItem is matched by more than one of the FilterSplit filters,
      then it is assigned to the first set that applies to it in the training,
      validation, test order.
    validationFilter: Required. A filter on DataItems of the Dataset.
      DataItems that match this filter are used to validate the Model. A
      filter with same syntax as the one used in DatasetService.ListDataItems
      may be used. If a single DataItem is matched by more than one of the
      FilterSplit filters, then it is assigned to the first set that applies
      to it in the training, validation, test order.
  """

  testFilter = _messages.StringField(1)
  trainingFilter = _messages.StringField(2)
  validationFilter = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1FindNeighborsRequest(_messages.Message):
  r"""The request message for MatchService.FindNeighbors.

  Fields:
    deployedIndexId: The ID of the DeployedIndex that will serve the request.
      This request is sent to a specific IndexEndpoint, as per the
      IndexEndpoint.network. That IndexEndpoint also has
      IndexEndpoint.deployed_indexes, and each such index has a
      DeployedIndex.id field. The value of the field below must equal one of
      the DeployedIndex.id fields of the IndexEndpoint that is being called
      for this request.
    queries: The list of queries.
    returnFullDatapoint: If set to true, the full datapoints (including all
      vector values and restricts) of the nearest neighbors are returned. Note
      that returning full datapoint will significantly increase the latency
      and cost of the query.
  """

  deployedIndexId = _messages.StringField(1)
  queries = _messages.MessageField('GoogleCloudAiplatformV1beta1FindNeighborsRequestQuery', 2, repeated=True)
  returnFullDatapoint = _messages.BooleanField(3)


class GoogleCloudAiplatformV1beta1FindNeighborsRequestQuery(_messages.Message):
  r"""A query to find a number of the nearest neighbors (most similar vectors)
  of a vector.

  Fields:
    approximateNeighborCount: The number of neighbors to find via approximate
      search before exact reordering is performed. If not set, the default
      value from scam config is used; if set, this value must be > 0.
    datapoint: Required. The datapoint/vector whose nearest neighbors should
      be searched for.
    fractionLeafNodesToSearchOverride: The fraction of the number of leaves to
      search, set at query time allows user to tune search performance. This
      value increase result in both search accuracy and latency increase. The
      value should be between 0.0 and 1.0. If not set or set to 0.0, query
      uses the default value specified in
      NearestNeighborSearchConfig.TreeAHConfig.fraction_leaf_nodes_to_search.
    neighborCount: The number of nearest neighbors to be retrieved from
      database for each query. If not set, will use the default from the
      service configuration (https://cloud.google.com/vertex-ai/docs/matching-
      engine/configuring-indexes#nearest-neighbor-search-config).
    perCrowdingAttributeNeighborCount: Crowding is a constraint on a neighbor
      list produced by nearest neighbor search requiring that no more than
      some value k' of the k neighbors returned have the same value of
      crowding_attribute. It's used for improving result diversity. This field
      is the maximum number of matches with the same crowding tag.
    rrf: Optional. Represents RRF algorithm that combines search results.
  """

  approximateNeighborCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  datapoint = _messages.MessageField('GoogleCloudAiplatformV1beta1IndexDatapoint', 2)
  fractionLeafNodesToSearchOverride = _messages.FloatField(3)
  neighborCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  perCrowdingAttributeNeighborCount = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  rrf = _messages.MessageField('GoogleCloudAiplatformV1beta1FindNeighborsRequestQueryRRF', 6)


class GoogleCloudAiplatformV1beta1FindNeighborsRequestQueryRRF(_messages.Message):
  r"""Parameters for RRF algorithm that combines search results.

  Fields:
    alpha: Required. Users can provide an alpha value to give more weight to
      dense vs sparse results. For example, if the alpha is 0, we only return
      sparse and if the alpha is 1, we only return dense.
  """

  alpha = _messages.FloatField(1, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1beta1FindNeighborsResponse(_messages.Message):
  r"""The response message for MatchService.FindNeighbors.

  Fields:
    nearestNeighbors: The nearest neighbors of the query datapoints.
  """

  nearestNeighbors = _messages.MessageField('GoogleCloudAiplatformV1beta1FindNeighborsResponseNearestNeighbors', 1, repeated=True)


class GoogleCloudAiplatformV1beta1FindNeighborsResponseNearestNeighbors(_messages.Message):
  r"""Nearest neighbors for one query.

  Fields:
    id: The ID of the query datapoint.
    neighbors: All its neighbors.
  """

  id = _messages.StringField(1)
  neighbors = _messages.MessageField('GoogleCloudAiplatformV1beta1FindNeighborsResponseNeighbor', 2, repeated=True)


class GoogleCloudAiplatformV1beta1FindNeighborsResponseNeighbor(_messages.Message):
  r"""A neighbor of the query vector.

  Fields:
    datapoint: The datapoint of the neighbor. Note that full datapoints are
      returned only when "return_full_datapoint" is set to true. Otherwise,
      only the "datapoint_id" and "crowding_tag" fields are populated.
    distance: The distance between the neighbor and the dense embedding query.
    sparseDistance: The distance between the neighbor and the query
      sparse_embedding.
  """

  datapoint = _messages.MessageField('GoogleCloudAiplatformV1beta1IndexDatapoint', 1)
  distance = _messages.FloatField(2)
  sparseDistance = _messages.FloatField(3)


class GoogleCloudAiplatformV1beta1FluencyInput(_messages.Message):
  r"""Input for fluency metric.

  Fields:
    instance: Required. Fluency instance.
    metricSpec: Required. Spec for fluency score metric.
  """

  instance = _messages.MessageField('GoogleCloudAiplatformV1beta1FluencyInstance', 1)
  metricSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1FluencySpec', 2)


class GoogleCloudAiplatformV1beta1FluencyInstance(_messages.Message):
  r"""Spec for fluency instance.

  Fields:
    prediction: Required. Output of the evaluated model.
  """

  prediction = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1FluencyResult(_messages.Message):
  r"""Spec for fluency result.

  Fields:
    confidence: Output only. Confidence for fluency score.
    explanation: Output only. Explanation for fluency score.
    score: Output only. Fluency score.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  explanation = _messages.StringField(2)
  score = _messages.FloatField(3, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1beta1FluencySpec(_messages.Message):
  r"""Spec for fluency score metric.

  Fields:
    version: Optional. Which version to use for evaluation.
  """

  version = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1FractionSplit(_messages.Message):
  r"""Assigns the input data to training, validation, and test sets as per the
  given fractions. Any of `training_fraction`, `validation_fraction` and
  `test_fraction` may optionally be provided, they must sum to up to 1. If the
  provided ones sum to less than 1, the remainder is assigned to sets as
  decided by Vertex AI. If none of the fractions are set, by default roughly
  80% of data is used for training, 10% for validation, and 10% for test.

  Fields:
    testFraction: The fraction of the input data that is to be used to
      evaluate the Model.
    trainingFraction: The fraction of the input data that is to be used to
      train the Model.
    validationFraction: The fraction of the input data that is to be used to
      validate the Model.
  """

  testFraction = _messages.FloatField(1)
  trainingFraction = _messages.FloatField(2)
  validationFraction = _messages.FloatField(3)


class GoogleCloudAiplatformV1beta1FulfillmentInput(_messages.Message):
  r"""Input for fulfillment metric.

  Fields:
    instance: Required. Fulfillment instance.
    metricSpec: Required. Spec for fulfillment score metric.
  """

  instance = _messages.MessageField('GoogleCloudAiplatformV1beta1FulfillmentInstance', 1)
  metricSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1FulfillmentSpec', 2)


class GoogleCloudAiplatformV1beta1FulfillmentInstance(_messages.Message):
  r"""Spec for fulfillment instance.

  Fields:
    instruction: Required. Inference instruction prompt to compare prediction
      with.
    prediction: Required. Output of the evaluated model.
  """

  instruction = _messages.StringField(1)
  prediction = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1FulfillmentResult(_messages.Message):
  r"""Spec for fulfillment result.

  Fields:
    confidence: Output only. Confidence for fulfillment score.
    explanation: Output only. Explanation for fulfillment score.
    score: Output only. Fulfillment score.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  explanation = _messages.StringField(2)
  score = _messages.FloatField(3, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1beta1FulfillmentSpec(_messages.Message):
  r"""Spec for fulfillment metric.

  Fields:
    version: Optional. Which version to use for evaluation.
  """

  version = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1FunctionCall(_messages.Message):
  r"""A predicted [FunctionCall] returned from the model that contains a
  string representing the [FunctionDeclaration.name] and a structured JSON
  object containing the parameters and their values.

  Messages:
    ArgsValue: Optional. Required. The function parameters and values in JSON
      object format. See [FunctionDeclaration.parameters] for parameter
      details.

  Fields:
    args: Optional. Required. The function parameters and values in JSON
      object format. See [FunctionDeclaration.parameters] for parameter
      details.
    name: Required. The name of the function to call. Matches
      [FunctionDeclaration.name].
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ArgsValue(_messages.Message):
    r"""Optional. Required. The function parameters and values in JSON object
    format. See [FunctionDeclaration.parameters] for parameter details.

    Messages:
      AdditionalProperty: An additional property for a ArgsValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ArgsValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  args = _messages.MessageField('ArgsValue', 1)
  name = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1FunctionCallingConfig(_messages.Message):
  r"""Function calling config.

  Enums:
    ModeValueValuesEnum: Optional. Function calling mode.

  Fields:
    allowedFunctionNames: Optional. Function names to call. Only set when the
      Mode is ANY. Function names should match [FunctionDeclaration.name].
      With mode set to ANY, model will predict a function call from the set of
      function names provided.
    mode: Optional. Function calling mode.
  """

  class ModeValueValuesEnum(_messages.Enum):
    r"""Optional. Function calling mode.

    Values:
      MODE_UNSPECIFIED: Unspecified function calling mode. This value should
        not be used.
      AUTO: Default model behavior, model decides to predict either function
        calls or natural language response.
      ANY: Model is constrained to always predicting function calls only. If
        "allowed_function_names" are set, the predicted function calls will be
        limited to any one of "allowed_function_names", else the predicted
        function calls will be any one of the provided
        "function_declarations".
      NONE: Model will not predict any function calls. Model behavior is same
        as when not passing any function declarations.
    """
    MODE_UNSPECIFIED = 0
    AUTO = 1
    ANY = 2
    NONE = 3

  allowedFunctionNames = _messages.StringField(1, repeated=True)
  mode = _messages.EnumField('ModeValueValuesEnum', 2)


class GoogleCloudAiplatformV1beta1FunctionDeclaration(_messages.Message):
  r"""Structured representation of a function declaration as defined by the
  [OpenAPI 3.0 specification](https://spec.openapis.org/oas/v3.0.3). Included
  in this declaration are the function name, description, parameters and
  response type. This FunctionDeclaration is a representation of a block of
  code that can be used as a `Tool` by the model and executed by the client.

  Fields:
    description: Optional. Description and purpose of the function. Model uses
      it to decide how and whether to call the function.
    name: Required. The name of the function to call. Must start with a letter
      or an underscore. Must be a-z, A-Z, 0-9, or contain underscores, dots
      and dashes, with a maximum length of 64.
    parameters: Optional. Describes the parameters to this function in JSON
      Schema Object format. Reflects the Open API 3.03 Parameter Object.
      string Key: the name of the parameter. Parameter names are case
      sensitive. Schema Value: the Schema defining the type used for the
      parameter. For function with no parameters, this can be left unset.
      Parameter names must start with a letter or an underscore and must only
      contain chars a-z, A-Z, 0-9, or underscores with a maximum length of 64.
      Example with 1 required and 1 optional parameter: type: OBJECT
      properties: param1: type: STRING param2: type: INTEGER required: -
      param1
    response: Optional. Describes the output from this function in JSON Schema
      format. Reflects the Open API 3.03 Response Object. The Schema defines
      the type used for the response value of the function.
  """

  description = _messages.StringField(1)
  name = _messages.StringField(2)
  parameters = _messages.MessageField('GoogleCloudAiplatformV1beta1Schema', 3)
  response = _messages.MessageField('GoogleCloudAiplatformV1beta1Schema', 4)


class GoogleCloudAiplatformV1beta1FunctionResponse(_messages.Message):
  r"""The result output from a [FunctionCall] that contains a string
  representing the [FunctionDeclaration.name] and a structured JSON object
  containing any output from the function is used as context to the model.
  This should contain the result of a [FunctionCall] made based on model
  prediction.

  Messages:
    ResponseValue: Required. The function response in JSON object format. Use
      "output" key to specify function output and "error" key to specify error
      details (if any). If "output" and "error" keys are not specified, then
      whole "response" is treated as function output.

  Fields:
    name: Required. The name of the function to call. Matches
      [FunctionDeclaration.name] and [FunctionCall.name].
    response: Required. The function response in JSON object format. Use
      "output" key to specify function output and "error" key to specify error
      details (if any). If "output" and "error" keys are not specified, then
      whole "response" is treated as function output.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""Required. The function response in JSON object format. Use "output"
    key to specify function output and "error" key to specify error details
    (if any). If "output" and "error" keys are not specified, then whole
    "response" is treated as function output.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  name = _messages.StringField(1)
  response = _messages.MessageField('ResponseValue', 2)


class GoogleCloudAiplatformV1beta1GcsDestination(_messages.Message):
  r"""The Google Cloud Storage location where the output is to be written to.

  Fields:
    outputUriPrefix: Required. Google Cloud Storage URI to output directory.
      If the uri doesn't end with '/', a '/' will be automatically appended.
      The directory is created if it doesn't exist.
  """

  outputUriPrefix = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1GcsSource(_messages.Message):
  r"""The Google Cloud Storage location for the input content.

  Fields:
    uris: Required. Google Cloud Storage URI(-s) to the input file(s). May
      contain wildcards. For more information on wildcards, see
      https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames.
  """

  uris = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1beta1GdceConfig(_messages.Message):
  r"""Google Distributed Cloud Edge (GDCE) config.

  Fields:
    zone: GDCE zone. A cluster will be designated for the Vertex AI workload
      in this zone. Format: `-edge-[-]#`. Example: us-central1-edge-att-dfw1.
  """

  zone = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1GenAiAdvancedFeaturesConfig(_messages.Message):
  r"""Configuration for GenAiAdvancedFeatures.

  Fields:
    ragConfig: Configuration for Retrieval Augmented Generation feature.
  """

  ragConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1GenAiAdvancedFeaturesConfigRagConfig', 1)


class GoogleCloudAiplatformV1beta1GenAiAdvancedFeaturesConfigRagConfig(_messages.Message):
  r"""Configuration for Retrieval Augmented Generation feature.

  Fields:
    enableRag: If true, enable Retrieval Augmented Generation in
      ChatCompletion request. Once enabled, the endpoint will be identified as
      GenAI endpoint and Arthedain router will be used.
  """

  enableRag = _messages.BooleanField(1)


class GoogleCloudAiplatformV1beta1GenerateAccessTokenRequest(_messages.Message):
  r"""Request message for NotebookInternalService.GenerateAccessToken.

  Fields:
    vmToken: Required. The VM identity token (a JWT) for authenticating the
      VM. https://cloud.google.com/compute/docs/instances/verifying-instance-
      identity
  """

  vmToken = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1GenerateAccessTokenResponse(_messages.Message):
  r"""Response message for NotebookInternalService.GenerateToken.

  Fields:
    accessToken: Short-lived access token string which may be used to access
      Google APIs.
    expiresIn: The time in seconds when the access token expires. Typically
      that's 3600.
    scope: Space-separated list of scopes contained in the returned token.
      https://cloud.google.com/docs/authentication/token-types#access-contents
    tokenType: Type of the returned access token (e.g. "Bearer"). It specifies
      how the token must be used. Bearer tokens may be used by any entity
      without proof of identity.
  """

  accessToken = _messages.StringField(1)
  expiresIn = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  scope = _messages.StringField(3)
  tokenType = _messages.StringField(4)


class GoogleCloudAiplatformV1beta1GenerateContentRequest(_messages.Message):
  r"""Request message for [PredictionService.GenerateContent].

  Messages:
    LabelsValue: Optional. The labels with user-defined metadata for the
      request. It is used for billing and reporting only. Label keys and
      values can be no longer than 63 characters (Unicode codepoints) and can
      only contain lowercase letters, numeric characters, underscores, and
      dashes. International characters are allowed. Label values are optional.
      Label keys must start with a letter.

  Fields:
    cachedContent: Optional. The name of the cached content used as context to
      serve the prediction. Note: only used in explicit caching, where users
      can have control over caching (e.g. what content to cache) and enjoy
      guaranteed cost savings. Format:
      `projects/{project}/locations/{location}/cachedContents/{cachedContent}`
    contents: Required. The content of the current conversation with the
      model. For single-turn queries, this is a single instance. For multi-
      turn queries, this is a repeated field that contains conversation
      history + latest request.
    generationConfig: Optional. Generation config.
    labels: Optional. The labels with user-defined metadata for the request.
      It is used for billing and reporting only. Label keys and values can be
      no longer than 63 characters (Unicode codepoints) and can only contain
      lowercase letters, numeric characters, underscores, and dashes.
      International characters are allowed. Label values are optional. Label
      keys must start with a letter.
    safetySettings: Optional. Per request settings for blocking unsafe
      content. Enforced on GenerateContentResponse.candidates.
    systemInstruction: Optional. The user provided system instructions for the
      model. Note: only text should be used in parts and content in each part
      will be in a separate paragraph.
    toolConfig: Optional. Tool config. This config is shared for all tools
      provided in the request.
    tools: Optional. A list of `Tools` the model may use to generate the next
      response. A `Tool` is a piece of code that enables the system to
      interact with external systems to perform an action, or set of actions,
      outside of knowledge and scope of the model.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels with user-defined metadata for the request. It is
    used for billing and reporting only. Label keys and values can be no
    longer than 63 characters (Unicode codepoints) and can only contain
    lowercase letters, numeric characters, underscores, and dashes.
    International characters are allowed. Label values are optional. Label
    keys must start with a letter.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  cachedContent = _messages.StringField(1)
  contents = _messages.MessageField('GoogleCloudAiplatformV1beta1Content', 2, repeated=True)
  generationConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1GenerationConfig', 3)
  labels = _messages.MessageField('LabelsValue', 4)
  safetySettings = _messages.MessageField('GoogleCloudAiplatformV1beta1SafetySetting', 5, repeated=True)
  systemInstruction = _messages.MessageField('GoogleCloudAiplatformV1beta1Content', 6)
  toolConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1ToolConfig', 7)
  tools = _messages.MessageField('GoogleCloudAiplatformV1beta1Tool', 8, repeated=True)


class GoogleCloudAiplatformV1beta1GenerateContentResponse(_messages.Message):
  r"""Response message for [PredictionService.GenerateContent].

  Fields:
    candidates: Output only. Generated candidates.
    createTime: Output only. Timestamp when the request is made to the server.
    modelVersion: Output only. The model version used to generate the
      response.
    promptFeedback: Output only. Content filter results for a prompt sent in
      the request. Note: Sent only in the first stream chunk. Only happens
      when no candidates were generated due to content violations.
    responseId: Output only. response_id is used to identify each response. It
      is the encoding of the event_id.
    usageMetadata: Usage metadata about the response(s).
  """

  candidates = _messages.MessageField('GoogleCloudAiplatformV1beta1Candidate', 1, repeated=True)
  createTime = _messages.StringField(2)
  modelVersion = _messages.StringField(3)
  promptFeedback = _messages.MessageField('GoogleCloudAiplatformV1beta1GenerateContentResponsePromptFeedback', 4)
  responseId = _messages.StringField(5)
  usageMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenerateContentResponseUsageMetadata', 6)


class GoogleCloudAiplatformV1beta1GenerateContentResponsePromptFeedback(_messages.Message):
  r"""Content filter results for a prompt sent in the request.

  Enums:
    BlockReasonValueValuesEnum: Output only. Blocked reason.

  Fields:
    blockReason: Output only. Blocked reason.
    blockReasonMessage: Output only. A readable block reason message.
    safetyRatings: Output only. Safety ratings.
  """

  class BlockReasonValueValuesEnum(_messages.Enum):
    r"""Output only. Blocked reason.

    Values:
      BLOCKED_REASON_UNSPECIFIED: Unspecified blocked reason.
      SAFETY: Candidates blocked due to safety.
      OTHER: Candidates blocked due to other reason.
      BLOCKLIST: Candidates blocked due to the terms which are included from
        the terminology blocklist.
      PROHIBITED_CONTENT: Candidates blocked due to prohibited content.
    """
    BLOCKED_REASON_UNSPECIFIED = 0
    SAFETY = 1
    OTHER = 2
    BLOCKLIST = 3
    PROHIBITED_CONTENT = 4

  blockReason = _messages.EnumField('BlockReasonValueValuesEnum', 1)
  blockReasonMessage = _messages.StringField(2)
  safetyRatings = _messages.MessageField('GoogleCloudAiplatformV1beta1SafetyRating', 3, repeated=True)


class GoogleCloudAiplatformV1beta1GenerateContentResponseUsageMetadata(_messages.Message):
  r"""Usage metadata about response(s).

  Fields:
    cacheTokensDetails: Output only. List of modalities of the cached content
      in the request input.
    cachedContentTokenCount: Output only. Number of tokens in the cached part
      in the input (the cached content).
    candidatesTokenCount: Number of tokens in the response(s).
    candidatesTokensDetails: Output only. List of modalities that were
      returned in the response.
    promptTokenCount: Number of tokens in the request. When `cached_content`
      is set, this is still the total effective prompt size meaning this
      includes the number of tokens in the cached content.
    promptTokensDetails: Output only. List of modalities that were processed
      in the request input.
    toolUsePromptTokenCount: Output only. Number of tokens present in tool-use
      prompt(s).
    toolUsePromptTokensDetails: Output only. List of modalities that were
      processed for tool-use request inputs.
    totalTokenCount: Total token count for prompt, response candidates, and
      tool-use prompts (if present).
  """

  cacheTokensDetails = _messages.MessageField('GoogleCloudAiplatformV1beta1ModalityTokenCount', 1, repeated=True)
  cachedContentTokenCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  candidatesTokenCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  candidatesTokensDetails = _messages.MessageField('GoogleCloudAiplatformV1beta1ModalityTokenCount', 4, repeated=True)
  promptTokenCount = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  promptTokensDetails = _messages.MessageField('GoogleCloudAiplatformV1beta1ModalityTokenCount', 6, repeated=True)
  toolUsePromptTokenCount = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  toolUsePromptTokensDetails = _messages.MessageField('GoogleCloudAiplatformV1beta1ModalityTokenCount', 8, repeated=True)
  totalTokenCount = _messages.IntegerField(9, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1GenerateVideoResponse(_messages.Message):
  r"""Generate video response.

  Fields:
    generatedSamples: The cloud storage uris of the generated videos.
    raiMediaFilteredCount: Returns if any videos were filtered due to RAI
      policies.
    raiMediaFilteredReasons: Returns rai failure reasons if any.
    videos: List of video bytes or Cloud Storage URIs of the generated videos.
  """

  generatedSamples = _messages.StringField(1, repeated=True)
  raiMediaFilteredCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  raiMediaFilteredReasons = _messages.StringField(3, repeated=True)
  videos = _messages.MessageField('GoogleCloudAiplatformV1beta1GenerateVideoResponseVideo', 4, repeated=True)


class GoogleCloudAiplatformV1beta1GenerateVideoResponseVideo(_messages.Message):
  r"""A generated video.

  Fields:
    bytesBase64Encoded: Base64 encoded bytes string representing the video.
    gcsUri: Cloud Storage URI where the generated video is written.
    mimeType: The MIME type of the content of the video. - video/mp4
  """

  bytesBase64Encoded = _messages.StringField(1)
  gcsUri = _messages.StringField(2)
  mimeType = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1GenerationConfig(_messages.Message):
  r"""Generation config.

  Enums:
    MediaResolutionValueValuesEnum: Optional. If specified, the media
      resolution specified will be used.
    ResponseModalitiesValueListEntryValuesEnum:

  Fields:
    audioTimestamp: Optional. If enabled, audio timestamp will be included in
      the request to the model.
    candidateCount: Optional. Number of candidates to generate.
    frequencyPenalty: Optional. Frequency penalties.
    logprobs: Optional. Logit probabilities.
    maxOutputTokens: Optional. The maximum number of output tokens to generate
      per message.
    mediaResolution: Optional. If specified, the media resolution specified
      will be used.
    presencePenalty: Optional. Positive penalties.
    responseLogprobs: Optional. If true, export the logprobs results in
      response.
    responseMimeType: Optional. Output response mimetype of the generated
      candidate text. Supported mimetype: - `text/plain`: (default) Text
      output. - `application/json`: JSON response in the candidates. The model
      needs to be prompted to output the appropriate response type, otherwise
      the behavior is undefined. This is a preview feature.
    responseModalities: Optional. The modalities of the response.
    responseSchema: Optional. The `Schema` object allows the definition of
      input and output data types. These types can be objects, but also
      primitives and arrays. Represents a select subset of an [OpenAPI 3.0
      schema object](https://spec.openapis.org/oas/v3.0.3#schema). If set, a
      compatible response_mime_type must also be set. Compatible mimetypes:
      `application/json`: Schema for JSON response.
    routingConfig: Optional. Routing configuration.
    seed: Optional. Seed.
    speechConfig: Optional. The speech generation config.
    stopSequences: Optional. Stop sequences.
    temperature: Optional. Controls the randomness of predictions.
    topK: Optional. If specified, top-k sampling will be used.
    topP: Optional. If specified, nucleus sampling will be used.
  """

  class MediaResolutionValueValuesEnum(_messages.Enum):
    r"""Optional. If specified, the media resolution specified will be used.

    Values:
      MEDIA_RESOLUTION_UNSPECIFIED: Media resolution has not been set.
      MEDIA_RESOLUTION_LOW: Media resolution set to low (64 tokens).
      MEDIA_RESOLUTION_MEDIUM: Media resolution set to medium (256 tokens).
      MEDIA_RESOLUTION_HIGH: Media resolution set to high (zoomed reframing
        with 256 tokens).
    """
    MEDIA_RESOLUTION_UNSPECIFIED = 0
    MEDIA_RESOLUTION_LOW = 1
    MEDIA_RESOLUTION_MEDIUM = 2
    MEDIA_RESOLUTION_HIGH = 3

  class ResponseModalitiesValueListEntryValuesEnum(_messages.Enum):
    r"""ResponseModalitiesValueListEntryValuesEnum enum type.

    Values:
      MODALITY_UNSPECIFIED: Unspecified modality. Will be processed as text.
      TEXT: Text modality.
      IMAGE: Image modality.
      AUDIO: Audio modality.
    """
    MODALITY_UNSPECIFIED = 0
    TEXT = 1
    IMAGE = 2
    AUDIO = 3

  audioTimestamp = _messages.BooleanField(1)
  candidateCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  frequencyPenalty = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  logprobs = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  maxOutputTokens = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  mediaResolution = _messages.EnumField('MediaResolutionValueValuesEnum', 6)
  presencePenalty = _messages.FloatField(7, variant=_messages.Variant.FLOAT)
  responseLogprobs = _messages.BooleanField(8)
  responseMimeType = _messages.StringField(9)
  responseModalities = _messages.EnumField('ResponseModalitiesValueListEntryValuesEnum', 10, repeated=True)
  responseSchema = _messages.MessageField('GoogleCloudAiplatformV1beta1Schema', 11)
  routingConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfig', 12)
  seed = _messages.IntegerField(13, variant=_messages.Variant.INT32)
  speechConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1SpeechConfig', 14)
  stopSequences = _messages.StringField(15, repeated=True)
  temperature = _messages.FloatField(16, variant=_messages.Variant.FLOAT)
  topK = _messages.FloatField(17, variant=_messages.Variant.FLOAT)
  topP = _messages.FloatField(18, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfig(_messages.Message):
  r"""The configuration for routing the request to a specific model.

  Fields:
    autoMode: Automated routing.
    manualMode: Manual routing.
  """

  autoMode = _messages.MessageField('GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigAutoRoutingMode', 1)
  manualMode = _messages.MessageField('GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigManualRoutingMode', 2)


class GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigAutoRoutingMode(_messages.Message):
  r"""When automated routing is specified, the routing will be determined by
  the pretrained routing model and customer provided model routing preference.

  Enums:
    ModelRoutingPreferenceValueValuesEnum: The model routing preference.

  Fields:
    modelRoutingPreference: The model routing preference.
  """

  class ModelRoutingPreferenceValueValuesEnum(_messages.Enum):
    r"""The model routing preference.

    Values:
      UNKNOWN: Unspecified model routing preference.
      PRIORITIZE_QUALITY: Prefer higher quality over low cost.
      BALANCED: Balanced model routing preference.
      PRIORITIZE_COST: Prefer lower cost over higher quality.
    """
    UNKNOWN = 0
    PRIORITIZE_QUALITY = 1
    BALANCED = 2
    PRIORITIZE_COST = 3

  modelRoutingPreference = _messages.EnumField('ModelRoutingPreferenceValueValuesEnum', 1)


class GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigManualRoutingMode(_messages.Message):
  r"""When manual routing is set, the specified model will be used directly.

  Fields:
    modelName: The model name to use. Only the public LLM models are accepted.
      e.g. 'gemini-1.5-pro-001'.
  """

  modelName = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1GenericOperationMetadata(_messages.Message):
  r"""Generic Metadata shared by all operations.

  Fields:
    createTime: Output only. Time when the operation was created.
    partialFailures: Output only. Partial failures encountered. E.g. single
      files that couldn't be read. This field should never exceed 20 entries.
      Status details field will contain standard Google Cloud error details.
    updateTime: Output only. Time when the operation was updated for the last
      time. If the operation has finished (successfully or not), this is the
      finish time.
  """

  createTime = _messages.StringField(1)
  partialFailures = _messages.MessageField('GoogleRpcStatus', 2, repeated=True)
  updateTime = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1GenieSource(_messages.Message):
  r"""Contains information about the source of the models generated from
  Generative AI Studio.

  Fields:
    baseModelUri: Required. The public base model URI.
  """

  baseModelUri = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1GoogleDriveSource(_messages.Message):
  r"""The Google Drive location for the input content.

  Fields:
    resourceIds: Required. Google Drive resource IDs.
  """

  resourceIds = _messages.MessageField('GoogleCloudAiplatformV1beta1GoogleDriveSourceResourceId', 1, repeated=True)


class GoogleCloudAiplatformV1beta1GoogleDriveSourceResourceId(_messages.Message):
  r"""The type and ID of the Google Drive resource.

  Enums:
    ResourceTypeValueValuesEnum: Required. The type of the Google Drive
      resource.

  Fields:
    resourceId: Required. The ID of the Google Drive resource.
    resourceType: Required. The type of the Google Drive resource.
  """

  class ResourceTypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of the Google Drive resource.

    Values:
      RESOURCE_TYPE_UNSPECIFIED: Unspecified resource type.
      RESOURCE_TYPE_FILE: File resource type.
      RESOURCE_TYPE_FOLDER: Folder resource type.
    """
    RESOURCE_TYPE_UNSPECIFIED = 0
    RESOURCE_TYPE_FILE = 1
    RESOURCE_TYPE_FOLDER = 2

  resourceId = _messages.StringField(1)
  resourceType = _messages.EnumField('ResourceTypeValueValuesEnum', 2)


class GoogleCloudAiplatformV1beta1GoogleSearchRetrieval(_messages.Message):
  r"""Tool to retrieve public web data for grounding, powered by Google.

  Fields:
    dynamicRetrievalConfig: Specifies the dynamic retrieval configuration for
      the given source.
  """

  dynamicRetrievalConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1DynamicRetrievalConfig', 1)


class GoogleCloudAiplatformV1beta1GroundednessInput(_messages.Message):
  r"""Input for groundedness metric.

  Fields:
    instance: Required. Groundedness instance.
    metricSpec: Required. Spec for groundedness metric.
  """

  instance = _messages.MessageField('GoogleCloudAiplatformV1beta1GroundednessInstance', 1)
  metricSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1GroundednessSpec', 2)


class GoogleCloudAiplatformV1beta1GroundednessInstance(_messages.Message):
  r"""Spec for groundedness instance.

  Fields:
    context: Required. Background information provided in context used to
      compare against the prediction.
    prediction: Required. Output of the evaluated model.
  """

  context = _messages.StringField(1)
  prediction = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1GroundednessResult(_messages.Message):
  r"""Spec for groundedness result.

  Fields:
    confidence: Output only. Confidence for groundedness score.
    explanation: Output only. Explanation for groundedness score.
    score: Output only. Groundedness score.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  explanation = _messages.StringField(2)
  score = _messages.FloatField(3, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1beta1GroundednessSpec(_messages.Message):
  r"""Spec for groundedness metric.

  Fields:
    version: Optional. Which version to use for evaluation.
  """

  version = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1GroundingChunk(_messages.Message):
  r"""Grounding chunk.

  Fields:
    retrievedContext: Grounding chunk from context retrieved by the retrieval
      tools.
    web: Grounding chunk from the web.
  """

  retrievedContext = _messages.MessageField('GoogleCloudAiplatformV1beta1GroundingChunkRetrievedContext', 1)
  web = _messages.MessageField('GoogleCloudAiplatformV1beta1GroundingChunkWeb', 2)


class GoogleCloudAiplatformV1beta1GroundingChunkRetrievedContext(_messages.Message):
  r"""Chunk from context retrieved by the retrieval tools.

  Fields:
    text: Text of the attribution.
    title: Title of the attribution.
    uri: URI reference of the attribution.
  """

  text = _messages.StringField(1)
  title = _messages.StringField(2)
  uri = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1GroundingChunkWeb(_messages.Message):
  r"""Chunk from the web.

  Fields:
    title: Title of the chunk.
    uri: URI reference of the chunk.
  """

  title = _messages.StringField(1)
  uri = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1GroundingMetadata(_messages.Message):
  r"""Metadata returned to client when grounding is enabled.

  Fields:
    groundingChunks: List of supporting references retrieved from specified
      grounding source.
    groundingSupports: Optional. List of grounding support.
    retrievalMetadata: Optional. Output only. Retrieval metadata.
    retrievalQueries: Optional. Queries executed by the retrieval tools.
    searchEntryPoint: Optional. Google search entry for the following-up web
      searches.
    webSearchQueries: Optional. Web search queries for the following-up web
      search.
  """

  groundingChunks = _messages.MessageField('GoogleCloudAiplatformV1beta1GroundingChunk', 1, repeated=True)
  groundingSupports = _messages.MessageField('GoogleCloudAiplatformV1beta1GroundingSupport', 2, repeated=True)
  retrievalMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1RetrievalMetadata', 3)
  retrievalQueries = _messages.StringField(4, repeated=True)
  searchEntryPoint = _messages.MessageField('GoogleCloudAiplatformV1beta1SearchEntryPoint', 5)
  webSearchQueries = _messages.StringField(6, repeated=True)


class GoogleCloudAiplatformV1beta1GroundingSupport(_messages.Message):
  r"""Grounding support.

  Fields:
    confidenceScores: Confidence score of the support references. Ranges from
      0 to 1. 1 is the most confident. This list must have the same size as
      the grounding_chunk_indices.
    groundingChunkIndices: A list of indices (into 'grounding_chunk')
      specifying the citations associated with the claim. For instance [1,3,4]
      means that grounding_chunk[1], grounding_chunk[3], grounding_chunk[4]
      are the retrieved content attributed to the claim.
    segment: Segment of the content this support belongs to.
  """

  confidenceScores = _messages.FloatField(1, repeated=True, variant=_messages.Variant.FLOAT)
  groundingChunkIndices = _messages.IntegerField(2, repeated=True, variant=_messages.Variant.INT32)
  segment = _messages.MessageField('GoogleCloudAiplatformV1beta1Segment', 3)


class GoogleCloudAiplatformV1beta1HyperparameterTuningJob(_messages.Message):
  r"""Represents a HyperparameterTuningJob. A HyperparameterTuningJob has a
  Study specification and multiple CustomJobs with identical CustomJob
  specification.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the job.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize
      HyperparameterTuningJobs. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.

  Fields:
    createTime: Output only. Time when the HyperparameterTuningJob was
      created.
    displayName: Required. The display name of the HyperparameterTuningJob.
      The name can be up to 128 characters long and can consist of any UTF-8
      characters.
    encryptionSpec: Customer-managed encryption key options for a
      HyperparameterTuningJob. If this is set, then all resources created by
      the HyperparameterTuningJob will be encrypted with the provided
      encryption key.
    endTime: Output only. Time when the HyperparameterTuningJob entered any of
      the following states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`,
      `JOB_STATE_CANCELLED`.
    error: Output only. Only populated when job's state is JOB_STATE_FAILED or
      JOB_STATE_CANCELLED.
    labels: The labels with user-defined metadata to organize
      HyperparameterTuningJobs. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.
    maxFailedTrialCount: The number of failed Trials that need to be seen
      before failing the HyperparameterTuningJob. If set to 0, Vertex AI
      decides how many Trials must fail before the whole job fails.
    maxTrialCount: Required. The desired total number of Trials.
    name: Output only. Resource name of the HyperparameterTuningJob.
    parallelTrialCount: Required. The desired number of Trials to run in
      parallel.
    satisfiesPzi: Output only. Reserved for future use.
    satisfiesPzs: Output only. Reserved for future use.
    startTime: Output only. Time when the HyperparameterTuningJob for the
      first time entered the `JOB_STATE_RUNNING` state.
    state: Output only. The detailed state of the job.
    studySpec: Required. Study configuration of the HyperparameterTuningJob.
    trialJobSpec: Required. The spec of a trial job. The same spec applies to
      the CustomJobs created in all the trials.
    trials: Output only. Trials of the HyperparameterTuningJob.
    updateTime: Output only. Time when the HyperparameterTuningJob was most
      recently updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the job.

    Values:
      JOB_STATE_UNSPECIFIED: The job state is unspecified.
      JOB_STATE_QUEUED: The job has been just created or resumed and
        processing has not yet begun.
      JOB_STATE_PENDING: The service is preparing to run the job.
      JOB_STATE_RUNNING: The job is in progress.
      JOB_STATE_SUCCEEDED: The job completed successfully.
      JOB_STATE_FAILED: The job failed.
      JOB_STATE_CANCELLING: The job is being cancelled. From this state the
        job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
        `JOB_STATE_CANCELLED`.
      JOB_STATE_CANCELLED: The job has been cancelled.
      JOB_STATE_PAUSED: The job has been stopped, and can be resumed.
      JOB_STATE_EXPIRED: The job has expired.
      JOB_STATE_UPDATING: The job is being updated. Only jobs in the `RUNNING`
        state can be updated. After updating, the job goes back to the
        `RUNNING` state.
      JOB_STATE_PARTIALLY_SUCCEEDED: The job is partially succeeded, some
        results may be missing due to errors.
    """
    JOB_STATE_UNSPECIFIED = 0
    JOB_STATE_QUEUED = 1
    JOB_STATE_PENDING = 2
    JOB_STATE_RUNNING = 3
    JOB_STATE_SUCCEEDED = 4
    JOB_STATE_FAILED = 5
    JOB_STATE_CANCELLING = 6
    JOB_STATE_CANCELLED = 7
    JOB_STATE_PAUSED = 8
    JOB_STATE_EXPIRED = 9
    JOB_STATE_UPDATING = 10
    JOB_STATE_PARTIALLY_SUCCEEDED = 11

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize
    HyperparameterTuningJobs. Label keys and values can be no longer than 64
    characters (Unicode codepoints), can only contain lowercase letters,
    numeric characters, underscores and dashes. International characters are
    allowed. See https://goo.gl/xmQnxf for more information and examples of
    labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1EncryptionSpec', 3)
  endTime = _messages.StringField(4)
  error = _messages.MessageField('GoogleRpcStatus', 5)
  labels = _messages.MessageField('LabelsValue', 6)
  maxFailedTrialCount = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  maxTrialCount = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  name = _messages.StringField(9)
  parallelTrialCount = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  satisfiesPzi = _messages.BooleanField(11)
  satisfiesPzs = _messages.BooleanField(12)
  startTime = _messages.StringField(13)
  state = _messages.EnumField('StateValueValuesEnum', 14)
  studySpec = _messages.MessageField('GoogleCloudAiplatformV1beta1StudySpec', 15)
  trialJobSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1CustomJobSpec', 16)
  trials = _messages.MessageField('GoogleCloudAiplatformV1beta1Trial', 17, repeated=True)
  updateTime = _messages.StringField(18)


class GoogleCloudAiplatformV1beta1IdMatcher(_messages.Message):
  r"""Matcher for Features of an EntityType by Feature ID.

  Fields:
    ids: Required. The following are accepted as `ids`: * A single-element
      list containing only `*`, which selects all Features in the target
      EntityType, or * A list containing only Feature IDs, which selects only
      Features with those IDs in the target EntityType.
  """

  ids = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1beta1ImportDataConfig(_messages.Message):
  r"""Describes the location from where we import data into a Dataset,
  together with the labels that will be applied to the DataItems and the
  Annotations.

  Messages:
    AnnotationLabelsValue: Labels that will be applied to newly imported
      Annotations. If two Annotations are identical, one of them will be
      deduped. Two Annotations are considered identical if their payload,
      payload_schema_uri and all of their labels are the same. These labels
      will be overridden by Annotation labels specified inside index file
      referenced by import_schema_uri, e.g. jsonl file.
    DataItemLabelsValue: Labels that will be applied to newly imported
      DataItems. If an identical DataItem as one being imported already exists
      in the Dataset, then these labels will be appended to these of the
      already existing one, and if labels with identical key is imported
      before, the old label value will be overwritten. If two DataItems are
      identical in the same import data operation, the labels will be combined
      and if key collision happens in this case, one of the values will be
      picked randomly. Two DataItems are considered identical if their content
      bytes are identical (e.g. image bytes or pdf bytes). These labels will
      be overridden by Annotation labels specified inside index file
      referenced by import_schema_uri, e.g. jsonl file.

  Fields:
    annotationLabels: Labels that will be applied to newly imported
      Annotations. If two Annotations are identical, one of them will be
      deduped. Two Annotations are considered identical if their payload,
      payload_schema_uri and all of their labels are the same. These labels
      will be overridden by Annotation labels specified inside index file
      referenced by import_schema_uri, e.g. jsonl file.
    dataItemLabels: Labels that will be applied to newly imported DataItems.
      If an identical DataItem as one being imported already exists in the
      Dataset, then these labels will be appended to these of the already
      existing one, and if labels with identical key is imported before, the
      old label value will be overwritten. If two DataItems are identical in
      the same import data operation, the labels will be combined and if key
      collision happens in this case, one of the values will be picked
      randomly. Two DataItems are considered identical if their content bytes
      are identical (e.g. image bytes or pdf bytes). These labels will be
      overridden by Annotation labels specified inside index file referenced
      by import_schema_uri, e.g. jsonl file.
    gcsSource: The Google Cloud Storage location for the input content.
    importSchemaUri: Required. Points to a YAML file stored on Google Cloud
      Storage describing the import format. Validation will be done against
      the schema. The schema is defined as an [OpenAPI 3.0.2 Schema
      Object](https://github.com/OAI/OpenAPI-
      Specification/blob/main/versions/3.0.2.md#schemaObject).
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationLabelsValue(_messages.Message):
    r"""Labels that will be applied to newly imported Annotations. If two
    Annotations are identical, one of them will be deduped. Two Annotations
    are considered identical if their payload, payload_schema_uri and all of
    their labels are the same. These labels will be overridden by Annotation
    labels specified inside index file referenced by import_schema_uri, e.g.
    jsonl file.

    Messages:
      AdditionalProperty: An additional property for a AnnotationLabelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        AnnotationLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DataItemLabelsValue(_messages.Message):
    r"""Labels that will be applied to newly imported DataItems. If an
    identical DataItem as one being imported already exists in the Dataset,
    then these labels will be appended to these of the already existing one,
    and if labels with identical key is imported before, the old label value
    will be overwritten. If two DataItems are identical in the same import
    data operation, the labels will be combined and if key collision happens
    in this case, one of the values will be picked randomly. Two DataItems are
    considered identical if their content bytes are identical (e.g. image
    bytes or pdf bytes). These labels will be overridden by Annotation labels
    specified inside index file referenced by import_schema_uri, e.g. jsonl
    file.

    Messages:
      AdditionalProperty: An additional property for a DataItemLabelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type DataItemLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DataItemLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotationLabels = _messages.MessageField('AnnotationLabelsValue', 1)
  dataItemLabels = _messages.MessageField('DataItemLabelsValue', 2)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1beta1GcsSource', 3)
  importSchemaUri = _messages.StringField(4)


class GoogleCloudAiplatformV1beta1ImportDataOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.ImportData.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1ImportDataRequest(_messages.Message):
  r"""Request message for DatasetService.ImportData.

  Fields:
    importConfigs: Required. The desired input locations. The contents of all
      input locations will be imported in one batch.
  """

  importConfigs = _messages.MessageField('GoogleCloudAiplatformV1beta1ImportDataConfig', 1, repeated=True)


class GoogleCloudAiplatformV1beta1ImportDataResponse(_messages.Message):
  r"""Response message for DatasetService.ImportData."""


class GoogleCloudAiplatformV1beta1ImportExtensionOperationMetadata(_messages.Message):
  r"""Details of ExtensionRegistryService.ImportExtension operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1ImportFeatureValuesOperationMetadata(_messages.Message):
  r"""Details of operations that perform import Feature values.

  Fields:
    blockingOperationIds: List of ImportFeatureValues operations running under
      a single EntityType that are blocking this operation.
    genericMetadata: Operation metadata for Featurestore import Feature
      values.
    importedEntityCount: Number of entities that have been imported by the
      operation.
    importedFeatureValueCount: Number of Feature values that have been
      imported by the operation.
    invalidRowCount: The number of rows in input source that weren't imported
      due to either * Not having any featureValues. * Having a null entityId.
      * Having a null timestamp. * Not being parsable (applicable for CSV
      sources).
    sourceUris: The source URI from where Feature values are imported.
    timestampOutsideRetentionRowsCount: The number rows that weren't ingested
      due to having timestamps outside the retention boundary.
  """

  blockingOperationIds = _messages.IntegerField(1, repeated=True)
  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 2)
  importedEntityCount = _messages.IntegerField(3)
  importedFeatureValueCount = _messages.IntegerField(4)
  invalidRowCount = _messages.IntegerField(5)
  sourceUris = _messages.StringField(6, repeated=True)
  timestampOutsideRetentionRowsCount = _messages.IntegerField(7)


class GoogleCloudAiplatformV1beta1ImportFeatureValuesRequest(_messages.Message):
  r"""Request message for FeaturestoreService.ImportFeatureValues.

  Fields:
    avroSource: A GoogleCloudAiplatformV1beta1AvroSource attribute.
    bigquerySource: A GoogleCloudAiplatformV1beta1BigQuerySource attribute.
    csvSource: A GoogleCloudAiplatformV1beta1CsvSource attribute.
    disableIngestionAnalysis: If true, API doesn't start ingestion analysis
      pipeline.
    disableOnlineServing: If set, data will not be imported for online
      serving. This is typically used for backfilling, where Feature
      generation timestamps are not in the timestamp range needed for online
      serving.
    entityIdField: Source column that holds entity IDs. If not provided,
      entity IDs are extracted from the column named entity_id.
    featureSpecs: Required. Specifications defining which Feature values to
      import from the entity. The request fails if no feature_specs are
      provided, and having multiple feature_specs for one Feature is not
      allowed.
    featureTime: Single Feature timestamp for all entities being imported. The
      timestamp must not have higher than millisecond precision.
    featureTimeField: Source column that holds the Feature timestamp for all
      Feature values in each entity.
    workerCount: Specifies the number of workers that are used to write data
      to the Featurestore. Consider the online serving capacity that you
      require to achieve the desired import throughput without interfering
      with online serving. The value must be positive, and less than or equal
      to 100. If not set, defaults to using 1 worker. The low count ensures
      minimal impact on online serving performance.
  """

  avroSource = _messages.MessageField('GoogleCloudAiplatformV1beta1AvroSource', 1)
  bigquerySource = _messages.MessageField('GoogleCloudAiplatformV1beta1BigQuerySource', 2)
  csvSource = _messages.MessageField('GoogleCloudAiplatformV1beta1CsvSource', 3)
  disableIngestionAnalysis = _messages.BooleanField(4)
  disableOnlineServing = _messages.BooleanField(5)
  entityIdField = _messages.StringField(6)
  featureSpecs = _messages.MessageField('GoogleCloudAiplatformV1beta1ImportFeatureValuesRequestFeatureSpec', 7, repeated=True)
  featureTime = _messages.StringField(8)
  featureTimeField = _messages.StringField(9)
  workerCount = _messages.IntegerField(10, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1ImportFeatureValuesRequestFeatureSpec(_messages.Message):
  r"""Defines the Feature value(s) to import.

  Fields:
    id: Required. ID of the Feature to import values of. This Feature must
      exist in the target EntityType, or the request will fail.
    sourceField: Source column to get the Feature values from. If not set,
      uses the column with the same name as the Feature ID.
  """

  id = _messages.StringField(1)
  sourceField = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ImportFeatureValuesResponse(_messages.Message):
  r"""Response message for FeaturestoreService.ImportFeatureValues.

  Fields:
    importedEntityCount: Number of entities that have been imported by the
      operation.
    importedFeatureValueCount: Number of Feature values that have been
      imported by the operation.
    invalidRowCount: The number of rows in input source that weren't imported
      due to either * Not having any featureValues. * Having a null entityId.
      * Having a null timestamp. * Not being parsable (applicable for CSV
      sources).
    timestampOutsideRetentionRowsCount: The number rows that weren't ingested
      due to having feature timestamps outside the retention boundary.
  """

  importedEntityCount = _messages.IntegerField(1)
  importedFeatureValueCount = _messages.IntegerField(2)
  invalidRowCount = _messages.IntegerField(3)
  timestampOutsideRetentionRowsCount = _messages.IntegerField(4)


class GoogleCloudAiplatformV1beta1ImportModelEvaluationRequest(_messages.Message):
  r"""Request message for ModelService.ImportModelEvaluation

  Fields:
    modelEvaluation: Required. Model evaluation resource to be imported.
  """

  modelEvaluation = _messages.MessageField('GoogleCloudAiplatformV1beta1ModelEvaluation', 1)


class GoogleCloudAiplatformV1beta1ImportRagFilesConfig(_messages.Message):
  r"""Config for importing RagFiles.

  Fields:
    gcsSource: Google Cloud Storage location. Supports importing individual
      files as well as entire Google Cloud Storage directories. Sample
      formats: - `gs://bucket_name/my_directory/object_name/my_file.txt` -
      `gs://bucket_name/my_directory`
    googleDriveSource: Google Drive location. Supports importing individual
      files as well as Google Drive folders.
    jiraSource: Jira queries with their corresponding authentication.
    maxEmbeddingRequestsPerMin: Optional. The max number of queries per minute
      that this job is allowed to make to the embedding model specified on the
      corpus. This value is specific to this job and not shared across other
      import jobs. Consult the Quotas page on the project to set an
      appropriate value here. If unspecified, a default value of 1,000 QPM
      would be used.
    partialFailureBigquerySink: The BigQuery destination to write partial
      failures to. It should be a bigquery table resource name (e.g.
      "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
      table does not exist, it will be created with the expected schema. If
      the table exists, the schema will be validated and data will be added to
      this existing table. Deprecated. Prefer to use `import_result_bq_sink`.
    partialFailureGcsSink: The Cloud Storage path to write partial failures
      to. Deprecated. Prefer to use `import_result_gcs_sink`.
    ragFileChunkingConfig: Specifies the size and overlap of chunks after
      importing RagFiles.
    ragFileParsingConfig: Optional. Specifies the parsing config for RagFiles.
      RAG will use the default parser if this field is not set.
    ragFileTransformationConfig: Specifies the transformation config for
      RagFiles.
    sharePointSources: SharePoint sources.
    slackSource: Slack channels with their corresponding access tokens.
  """

  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1beta1GcsSource', 1)
  googleDriveSource = _messages.MessageField('GoogleCloudAiplatformV1beta1GoogleDriveSource', 2)
  jiraSource = _messages.MessageField('GoogleCloudAiplatformV1beta1JiraSource', 3)
  maxEmbeddingRequestsPerMin = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  partialFailureBigquerySink = _messages.MessageField('GoogleCloudAiplatformV1beta1BigQueryDestination', 5)
  partialFailureGcsSink = _messages.MessageField('GoogleCloudAiplatformV1beta1GcsDestination', 6)
  ragFileChunkingConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1RagFileChunkingConfig', 7)
  ragFileParsingConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1RagFileParsingConfig', 8)
  ragFileTransformationConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1RagFileTransformationConfig', 9)
  sharePointSources = _messages.MessageField('GoogleCloudAiplatformV1beta1SharePointSources', 10)
  slackSource = _messages.MessageField('GoogleCloudAiplatformV1beta1SlackSource', 11)


class GoogleCloudAiplatformV1beta1ImportRagFilesRequest(_messages.Message):
  r"""Request message for VertexRagDataService.ImportRagFiles.

  Fields:
    importRagFilesConfig: Required. The config for the RagFiles to be synced
      and imported into the RagCorpus. VertexRagDataService.ImportRagFiles.
  """

  importRagFilesConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1ImportRagFilesConfig', 1)


class GoogleCloudAiplatformV1beta1Index(_messages.Message):
  r"""A representation of a collection of database items organized in a way
  that allows for approximate nearest neighbor (a.k.a ANN) algorithms search.

  Enums:
    IndexUpdateMethodValueValuesEnum: Immutable. The update method to use with
      this Index. If not set, BATCH_UPDATE will be used by default.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      Indexes. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.

  Fields:
    createTime: Output only. Timestamp when this Index was created.
    deployedIndexes: Output only. The pointers to DeployedIndexes created from
      this Index. An Index can be only deleted if all its DeployedIndexes had
      been undeployed first.
    description: The description of the Index.
    displayName: Required. The display name of the Index. The name can be up
      to 128 characters long and can consist of any UTF-8 characters.
    encryptionSpec: Immutable. Customer-managed encryption key spec for an
      Index. If set, this Index and all sub-resources of this Index will be
      secured by this key.
    etag: Used to perform consistent read-modify-write updates. If not set, a
      blind "overwrite" update happens.
    indexStats: Output only. Stats of the index resource.
    indexUpdateMethod: Immutable. The update method to use with this Index. If
      not set, BATCH_UPDATE will be used by default.
    labels: The labels with user-defined metadata to organize your Indexes.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. See
      https://goo.gl/xmQnxf for more information and examples of labels.
    metadata: An additional information about the Index; the schema of the
      metadata can be found in metadata_schema.
    metadataSchemaUri: Immutable. Points to a YAML file stored on Google Cloud
      Storage describing additional information about the Index, that is
      specific to it. Unset if the Index does not have any additional
      information. The schema is defined as an OpenAPI 3.0.2 [Schema
      Object](https://github.com/OAI/OpenAPI-
      Specification/blob/main/versions/3.0.2.md#schemaObject). Note: The URI
      given on output will be immutable and probably different, including the
      URI scheme, than the one given on input. The output URI will point to a
      location where the user only has a read access.
    name: Output only. The resource name of the Index.
    satisfiesPzi: Output only. Reserved for future use.
    satisfiesPzs: Output only. Reserved for future use.
    updateTime: Output only. Timestamp when this Index was most recently
      updated. This also includes any update to the contents of the Index.
      Note that Operations working on this Index may have their
      Operations.metadata.generic_metadata.update_time a little after the
      value of this timestamp, yet that does not mean their results are not
      already reflected in the Index. Result of any successfully completed
      Operation on the Index is reflected in it.
  """

  class IndexUpdateMethodValueValuesEnum(_messages.Enum):
    r"""Immutable. The update method to use with this Index. If not set,
    BATCH_UPDATE will be used by default.

    Values:
      INDEX_UPDATE_METHOD_UNSPECIFIED: Should not be used.
      BATCH_UPDATE: BatchUpdate: user can call UpdateIndex with files on Cloud
        Storage of Datapoints to update.
      STREAM_UPDATE: StreamUpdate: user can call
        UpsertDatapoints/DeleteDatapoints to update the Index and the updates
        will be applied in corresponding DeployedIndexes in nearly real-time.
    """
    INDEX_UPDATE_METHOD_UNSPECIFIED = 0
    BATCH_UPDATE = 1
    STREAM_UPDATE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your Indexes. Label
    keys and values can be no longer than 64 characters (Unicode codepoints),
    can only contain lowercase letters, numeric characters, underscores and
    dashes. International characters are allowed. See https://goo.gl/xmQnxf
    for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  deployedIndexes = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployedIndexRef', 2, repeated=True)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1EncryptionSpec', 5)
  etag = _messages.StringField(6)
  indexStats = _messages.MessageField('GoogleCloudAiplatformV1beta1IndexStats', 7)
  indexUpdateMethod = _messages.EnumField('IndexUpdateMethodValueValuesEnum', 8)
  labels = _messages.MessageField('LabelsValue', 9)
  metadata = _messages.MessageField('extra_types.JsonValue', 10)
  metadataSchemaUri = _messages.StringField(11)
  name = _messages.StringField(12)
  satisfiesPzi = _messages.BooleanField(13)
  satisfiesPzs = _messages.BooleanField(14)
  updateTime = _messages.StringField(15)


class GoogleCloudAiplatformV1beta1IndexDatapoint(_messages.Message):
  r"""A datapoint of Index.

  Fields:
    crowdingTag: Optional. CrowdingTag of the datapoint, the number of
      neighbors to return in each crowding can be configured during query.
    datapointId: Required. Unique identifier of the datapoint.
    featureVector: Required. Feature embedding vector for dense index. An
      array of numbers with the length of
      [NearestNeighborSearchConfig.dimensions].
    numericRestricts: Optional. List of Restrict of the datapoint, used to
      perform "restricted searches" where boolean rule are used to filter the
      subset of the database eligible for matching. This uses numeric
      comparisons.
    restricts: Optional. List of Restrict of the datapoint, used to perform
      "restricted searches" where boolean rule are used to filter the subset
      of the database eligible for matching. This uses categorical tokens.
      See: https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
    sparseEmbedding: Optional. Feature embedding vector for sparse index.
  """

  crowdingTag = _messages.MessageField('GoogleCloudAiplatformV1beta1IndexDatapointCrowdingTag', 1)
  datapointId = _messages.StringField(2)
  featureVector = _messages.FloatField(3, repeated=True, variant=_messages.Variant.FLOAT)
  numericRestricts = _messages.MessageField('GoogleCloudAiplatformV1beta1IndexDatapointNumericRestriction', 4, repeated=True)
  restricts = _messages.MessageField('GoogleCloudAiplatformV1beta1IndexDatapointRestriction', 5, repeated=True)
  sparseEmbedding = _messages.MessageField('GoogleCloudAiplatformV1beta1IndexDatapointSparseEmbedding', 6)


class GoogleCloudAiplatformV1beta1IndexDatapointCrowdingTag(_messages.Message):
  r"""Crowding tag is a constraint on a neighbor list produced by nearest
  neighbor search requiring that no more than some value k' of the k neighbors
  returned have the same value of crowding_attribute.

  Fields:
    crowdingAttribute: The attribute value used for crowding. The maximum
      number of neighbors to return per crowding attribute value
      (per_crowding_attribute_num_neighbors) is configured per-query. This
      field is ignored if per_crowding_attribute_num_neighbors is larger than
      the total number of neighbors to return for a given query.
  """

  crowdingAttribute = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1IndexDatapointNumericRestriction(_messages.Message):
  r"""This field allows restricts to be based on numeric comparisons rather
  than categorical tokens.

  Enums:
    OpValueValuesEnum: This MUST be specified for queries and must NOT be
      specified for datapoints.

  Fields:
    namespace: The namespace of this restriction. e.g.: cost.
    op: This MUST be specified for queries and must NOT be specified for
      datapoints.
    valueDouble: Represents 64 bit float.
    valueFloat: Represents 32 bit float.
    valueInt: Represents 64 bit integer.
  """

  class OpValueValuesEnum(_messages.Enum):
    r"""This MUST be specified for queries and must NOT be specified for
    datapoints.

    Values:
      OPERATOR_UNSPECIFIED: Default value of the enum.
      LESS: Datapoints are eligible iff their value is < the query's.
      LESS_EQUAL: Datapoints are eligible iff their value is <= the query's.
      EQUAL: Datapoints are eligible iff their value is == the query's.
      GREATER_EQUAL: Datapoints are eligible iff their value is >= the
        query's.
      GREATER: Datapoints are eligible iff their value is > the query's.
      NOT_EQUAL: Datapoints are eligible iff their value is != the query's.
    """
    OPERATOR_UNSPECIFIED = 0
    LESS = 1
    LESS_EQUAL = 2
    EQUAL = 3
    GREATER_EQUAL = 4
    GREATER = 5
    NOT_EQUAL = 6

  namespace = _messages.StringField(1)
  op = _messages.EnumField('OpValueValuesEnum', 2)
  valueDouble = _messages.FloatField(3)
  valueFloat = _messages.FloatField(4, variant=_messages.Variant.FLOAT)
  valueInt = _messages.IntegerField(5)


class GoogleCloudAiplatformV1beta1IndexDatapointRestriction(_messages.Message):
  r"""Restriction of a datapoint which describe its attributes(tokens) from
  each of several attribute categories(namespaces).

  Fields:
    allowList: The attributes to allow in this namespace. e.g.: 'red'
    denyList: The attributes to deny in this namespace. e.g.: 'blue'
    namespace: The namespace of this restriction. e.g.: color.
  """

  allowList = _messages.StringField(1, repeated=True)
  denyList = _messages.StringField(2, repeated=True)
  namespace = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1IndexDatapointSparseEmbedding(_messages.Message):
  r"""Feature embedding vector for sparse index. An array of numbers whose
  values are located in the specified dimensions.

  Fields:
    dimensions: Required. The list of indexes for the embedding values of the
      sparse vector.
    values: Required. The list of embedding values of the sparse vector.
  """

  dimensions = _messages.IntegerField(1, repeated=True)
  values = _messages.FloatField(2, repeated=True, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1beta1IndexEndpoint(_messages.Message):
  r"""Indexes are deployed into it. An IndexEndpoint can have multiple
  DeployedIndexes.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      IndexEndpoints. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.

  Fields:
    createTime: Output only. Timestamp when this IndexEndpoint was created.
    deployedIndexes: Output only. The indexes deployed in this endpoint.
    description: The description of the IndexEndpoint.
    displayName: Required. The display name of the IndexEndpoint. The name can
      be up to 128 characters long and can consist of any UTF-8 characters.
    enablePrivateServiceConnect: Optional. Deprecated: If true, expose the
      IndexEndpoint via private service connect. Only one of the fields,
      network or enable_private_service_connect, can be set.
    encryptionSpec: Immutable. Customer-managed encryption key spec for an
      IndexEndpoint. If set, this IndexEndpoint and all sub-resources of this
      IndexEndpoint will be secured by this key.
    etag: Used to perform consistent read-modify-write updates. If not set, a
      blind "overwrite" update happens.
    labels: The labels with user-defined metadata to organize your
      IndexEndpoints. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.
    name: Output only. The resource name of the IndexEndpoint.
    network: Optional. The full name of the Google Compute Engine
      [network](https://cloud.google.com/compute/docs/networks-and-
      firewalls#networks) to which the IndexEndpoint should be peered. Private
      services access must already be configured for the network. If left
      unspecified, the Endpoint is not peered with any network. network and
      private_service_connect_config are mutually exclusive. [Format](https://
      cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
      `projects/{project}/global/networks/{network}`. Where {project} is a
      project number, as in '12345', and {network} is network name.
    privateServiceConnectConfig: Optional. Configuration for private service
      connect. network and private_service_connect_config are mutually
      exclusive.
    publicEndpointDomainName: Output only. If public_endpoint_enabled is true,
      this field will be populated with the domain name to use for this index
      endpoint.
    publicEndpointEnabled: Optional. If true, the deployed index will be
      accessible through public endpoint.
    satisfiesPzi: Output only. Reserved for future use.
    satisfiesPzs: Output only. Reserved for future use.
    updateTime: Output only. Timestamp when this IndexEndpoint was last
      updated. This timestamp is not updated when the endpoint's
      DeployedIndexes are updated, e.g. due to updates of the original Indexes
      they are the deployments of.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your IndexEndpoints.
    Label keys and values can be no longer than 64 characters (Unicode
    codepoints), can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. See
    https://goo.gl/xmQnxf for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  deployedIndexes = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployedIndex', 2, repeated=True)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  enablePrivateServiceConnect = _messages.BooleanField(5)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1EncryptionSpec', 6)
  etag = _messages.StringField(7)
  labels = _messages.MessageField('LabelsValue', 8)
  name = _messages.StringField(9)
  network = _messages.StringField(10)
  privateServiceConnectConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1PrivateServiceConnectConfig', 11)
  publicEndpointDomainName = _messages.StringField(12)
  publicEndpointEnabled = _messages.BooleanField(13)
  satisfiesPzi = _messages.BooleanField(14)
  satisfiesPzs = _messages.BooleanField(15)
  updateTime = _messages.StringField(16)


class GoogleCloudAiplatformV1beta1IndexPrivateEndpoints(_messages.Message):
  r"""IndexPrivateEndpoints proto is used to provide paths for users to send
  requests via private endpoints (e.g. private service access, private service
  connect). To send request via private service access, use
  match_grpc_address. To send request via private service connect, use
  service_attachment.

  Fields:
    matchGrpcAddress: Output only. The ip address used to send match gRPC
      requests.
    pscAutomatedEndpoints: Output only. PscAutomatedEndpoints is populated if
      private service connect is enabled if PscAutomatedConfig is set.
    serviceAttachment: Output only. The name of the service attachment
      resource. Populated if private service connect is enabled.
  """

  matchGrpcAddress = _messages.StringField(1)
  pscAutomatedEndpoints = _messages.MessageField('GoogleCloudAiplatformV1beta1PscAutomatedEndpoints', 2, repeated=True)
  serviceAttachment = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1IndexStats(_messages.Message):
  r"""Stats of the Index.

  Fields:
    shardsCount: Output only. The number of shards in the Index.
    sparseVectorsCount: Output only. The number of sparse vectors in the
      Index.
    vectorsCount: Output only. The number of dense vectors in the Index.
  """

  shardsCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  sparseVectorsCount = _messages.IntegerField(2)
  vectorsCount = _messages.IntegerField(3)


class GoogleCloudAiplatformV1beta1InputDataConfig(_messages.Message):
  r"""Specifies Vertex AI owned input data to be used for training, and
  possibly evaluating, the Model.

  Fields:
    annotationSchemaUri: Applicable only to custom training with Datasets that
      have DataItems and Annotations. Cloud Storage URI that points to a YAML
      file describing the annotation schema. The schema is defined as an
      OpenAPI 3.0.2 [Schema Object](https://github.com/OAI/OpenAPI-
      Specification/blob/main/versions/3.0.2.md#schemaObject). The schema
      files that can be used here are found in gs://google-cloud-
      aiplatform/schema/dataset/annotation/ , note that the chosen schema must
      be consistent with metadata of the Dataset specified by dataset_id. Only
      Annotations that both match this schema and belong to DataItems not
      ignored by the split method are used in respectively training,
      validation or test role, depending on the role of the DataItem they are
      on. When used in conjunction with annotations_filter, the Annotations
      used for training are filtered by both annotations_filter and
      annotation_schema_uri.
    annotationsFilter: Applicable only to Datasets that have DataItems and
      Annotations. A filter on Annotations of the Dataset. Only Annotations
      that both match this filter and belong to DataItems not ignored by the
      split method are used in respectively training, validation or test role,
      depending on the role of the DataItem they are on (for the auto-assigned
      that role is decided by Vertex AI). A filter with same syntax as the one
      used in ListAnnotations may be used, but note here it filters across all
      Annotations of the Dataset, and not just within a single DataItem.
    bigqueryDestination: Only applicable to custom training with tabular
      Dataset with BigQuery source. The BigQuery project location where the
      training data is to be written to. In the given project a new dataset is
      created with name `dataset___` where timestamp is in
      YYYY_MM_DDThh_mm_ss_sssZ format. All training input data is written into
      that dataset. In the dataset three tables are created, `training`,
      `validation` and `test`. * AIP_DATA_FORMAT = "bigquery". *
      AIP_TRAINING_DATA_URI = "bigquery_destination.dataset___.training" *
      AIP_VALIDATION_DATA_URI = "bigquery_destination.dataset___.validation" *
      AIP_TEST_DATA_URI = "bigquery_destination.dataset___.test"
    datasetId: Required. The ID of the Dataset in the same Project and
      Location which data will be used to train the Model. The Dataset must
      use schema compatible with Model being trained, and what is compatible
      should be described in the used TrainingPipeline's
      training_task_definition. For tabular Datasets, all their data is
      exported to training, to pick and choose from.
    filterSplit: Split based on the provided filters for each set.
    fractionSplit: Split based on fractions defining the size of each set.
    gcsDestination: The Cloud Storage location where the training data is to
      be written to. In the given directory a new directory is created with
      name: `dataset---` where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ
      ISO-8601 format. All training input data is written into that directory.
      The Vertex AI environment variables representing Cloud Storage data URIs
      are represented in the Cloud Storage wildcard format to support sharded
      data. e.g.: "gs://.../training-*.jsonl" * AIP_DATA_FORMAT = "jsonl" for
      non-tabular data, "csv" for tabular data * AIP_TRAINING_DATA_URI =
      "gcs_destination/dataset---/training-*.${AIP_DATA_FORMAT}" *
      AIP_VALIDATION_DATA_URI =
      "gcs_destination/dataset---/validation-*.${AIP_DATA_FORMAT}" *
      AIP_TEST_DATA_URI =
      "gcs_destination/dataset---/test-*.${AIP_DATA_FORMAT}"
    persistMlUseAssignment: Whether to persist the ML use assignment to data
      item system labels.
    predefinedSplit: Supported only for tabular Datasets. Split based on a
      predefined key.
    savedQueryId: Only applicable to Datasets that have SavedQueries. The ID
      of a SavedQuery (annotation set) under the Dataset specified by
      dataset_id used for filtering Annotations for training. Only Annotations
      that are associated with this SavedQuery are used in respectively
      training. When used in conjunction with annotations_filter, the
      Annotations used for training are filtered by both saved_query_id and
      annotations_filter. Only one of saved_query_id and annotation_schema_uri
      should be specified as both of them represent the same thing: problem
      type.
    stratifiedSplit: Supported only for tabular Datasets. Split based on the
      distribution of the specified column.
    timestampSplit: Supported only for tabular Datasets. Split based on the
      timestamp of the input data pieces.
  """

  annotationSchemaUri = _messages.StringField(1)
  annotationsFilter = _messages.StringField(2)
  bigqueryDestination = _messages.MessageField('GoogleCloudAiplatformV1beta1BigQueryDestination', 3)
  datasetId = _messages.StringField(4)
  filterSplit = _messages.MessageField('GoogleCloudAiplatformV1beta1FilterSplit', 5)
  fractionSplit = _messages.MessageField('GoogleCloudAiplatformV1beta1FractionSplit', 6)
  gcsDestination = _messages.MessageField('GoogleCloudAiplatformV1beta1GcsDestination', 7)
  persistMlUseAssignment = _messages.BooleanField(8)
  predefinedSplit = _messages.MessageField('GoogleCloudAiplatformV1beta1PredefinedSplit', 9)
  savedQueryId = _messages.StringField(10)
  stratifiedSplit = _messages.MessageField('GoogleCloudAiplatformV1beta1StratifiedSplit', 11)
  timestampSplit = _messages.MessageField('GoogleCloudAiplatformV1beta1TimestampSplit', 12)


class GoogleCloudAiplatformV1beta1Int64Array(_messages.Message):
  r"""A list of int64 values.

  Fields:
    values: A list of int64 values.
  """

  values = _messages.IntegerField(1, repeated=True)


class GoogleCloudAiplatformV1beta1IntegratedGradientsAttribution(_messages.Message):
  r"""An attribution method that computes the Aumann-Shapley value taking
  advantage of the model's fully differentiable structure. Refer to this paper
  for more details: https://arxiv.org/abs/1703.01365

  Fields:
    blurBaselineConfig: Config for IG with blur baseline. When enabled, a
      linear path from the maximally blurred image to the input image is
      created. Using a blurred baseline instead of zero (black image) is
      motivated by the BlurIG approach explained here:
      https://arxiv.org/abs/2004.03383
    smoothGradConfig: Config for SmoothGrad approximation of gradients. When
      enabled, the gradients are approximated by averaging the gradients from
      noisy samples in the vicinity of the inputs. Adding noise can help
      improve the computed gradients. Refer to this paper for more details:
      https://arxiv.org/pdf/1706.03825.pdf
    stepCount: Required. The number of steps for approximating the path
      integral. A good value to start is 50 and gradually increase until the
      sum to diff property is within the desired error range. Valid range of
      its value is [1, 100], inclusively.
  """

  blurBaselineConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1BlurBaselineConfig', 1)
  smoothGradConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1SmoothGradConfig', 2)
  stepCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1InternalOsServiceStateInstance(_messages.Message):
  r"""Request message for [InternalOsServiceStateInstance].

  Enums:
    ServiceNameValueValuesEnum: Required. internal service name.
    ServiceStateValueValuesEnum: Required. internal service state.

  Fields:
    serviceName: Required. internal service name.
    serviceState: Required. internal service state.
  """

  class ServiceNameValueValuesEnum(_messages.Enum):
    r"""Required. internal service name.

    Values:
      INTERNAL_OS_SERVICE_ENUM_UNSPECIFIED: Service name unknown.
      DOCKER_SERVICE_STATE: Represents the internal os docker client.
      CONTROL_PLANE_API_DNS_STATE: Represents resolving DNS for the control
        plane api endpoint.
      PROXY_REGISTRATION_DNS_STATE: Represents resolving DNS for the proxy
        registration endpoint.
      JUPYTER_STATE: Represents the jupyter endpoint.
      JUPYTER_API_STATE: Represents the jupyter/api endpoint.
      EUC_METADATA_API_STATE: Represents the EUC metadata server API endpoint.
      EUC_AGENT_API_STATE: Represents the EUC agent server API endpoint.
      IDLE_SHUTDOWN_AGENT_STATE: Represents the idle shutdown agent sidecar
        container.
      PROXY_AGENT_STATE: Represents the proxy agent sidecar container.
      GCR_DNS_STATE: Represents resolving DNS for the gcr.io endpoint.
      GUEST_ATTRIBUTE_STATE: Represents if the guest attribute service is
        enabled.
    """
    INTERNAL_OS_SERVICE_ENUM_UNSPECIFIED = 0
    DOCKER_SERVICE_STATE = 1
    CONTROL_PLANE_API_DNS_STATE = 2
    PROXY_REGISTRATION_DNS_STATE = 3
    JUPYTER_STATE = 4
    JUPYTER_API_STATE = 5
    EUC_METADATA_API_STATE = 6
    EUC_AGENT_API_STATE = 7
    IDLE_SHUTDOWN_AGENT_STATE = 8
    PROXY_AGENT_STATE = 9
    GCR_DNS_STATE = 10
    GUEST_ATTRIBUTE_STATE = 11

  class ServiceStateValueValuesEnum(_messages.Enum):
    r"""Required. internal service state.

    Values:
      UNKNOWN: Health status is unknown: not initialized or failed to
        retrieve.
      HEALTHY: The resource is healthy.
      UNHEALTHY: The resource is unhealthy.
    """
    UNKNOWN = 0
    HEALTHY = 1
    UNHEALTHY = 2

  serviceName = _messages.EnumField('ServiceNameValueValuesEnum', 1)
  serviceState = _messages.EnumField('ServiceStateValueValuesEnum', 2)


class GoogleCloudAiplatformV1beta1JiraSource(_messages.Message):
  r"""The Jira source for the ImportRagFilesRequest.

  Fields:
    jiraQueries: Required. The Jira queries.
  """

  jiraQueries = _messages.MessageField('GoogleCloudAiplatformV1beta1JiraSourceJiraQueries', 1, repeated=True)


class GoogleCloudAiplatformV1beta1JiraSourceJiraQueries(_messages.Message):
  r"""JiraQueries contains the Jira queries and corresponding authentication.

  Fields:
    apiKeyConfig: Required. The SecretManager secret version resource name
      (e.g. projects/{project}/secrets/{secret}/versions/{version}) storing
      the Jira API key. See [Manage API tokens for your Atlassian
      account](https://support.atlassian.com/atlassian-account/docs/manage-
      api-tokens-for-your-atlassian-account/).
    customQueries: A list of custom Jira queries to import. For information
      about JQL (Jira Query Language), see https://support.atlassian.com/jira-
      service-management-cloud/docs/use-advanced-search-with-jira-query-
      language-jql/
    email: Required. The Jira email address.
    projects: A list of Jira projects to import in their entirety.
    serverUri: Required. The Jira server URI.
  """

  apiKeyConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1ApiAuthApiKeyConfig', 1)
  customQueries = _messages.StringField(2, repeated=True)
  email = _messages.StringField(3)
  projects = _messages.StringField(4, repeated=True)
  serverUri = _messages.StringField(5)


class GoogleCloudAiplatformV1beta1LargeModelReference(_messages.Message):
  r"""Contains information about the Large Model.

  Fields:
    name: Required. The unique name of the large Foundation or pre-built
      model. Like "chat-bison", "text-bison". Or model name with version ID,
      like "chat-bison@001", "text-bison@005", etc.
  """

  name = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1LineageSubgraph(_messages.Message):
  r"""A subgraph of the overall lineage graph. Event edges connect Artifact
  and Execution nodes.

  Fields:
    artifacts: The Artifact nodes in the subgraph.
    events: The Event edges between Artifacts and Executions in the subgraph.
    executions: The Execution nodes in the subgraph.
  """

  artifacts = _messages.MessageField('GoogleCloudAiplatformV1beta1Artifact', 1, repeated=True)
  events = _messages.MessageField('GoogleCloudAiplatformV1beta1Event', 2, repeated=True)
  executions = _messages.MessageField('GoogleCloudAiplatformV1beta1Execution', 3, repeated=True)


class GoogleCloudAiplatformV1beta1ListAnnotationsResponse(_messages.Message):
  r"""Response message for DatasetService.ListAnnotations.

  Fields:
    annotations: A list of Annotations that matches the specified filter in
      the request.
    nextPageToken: The standard List next-page token.
  """

  annotations = _messages.MessageField('GoogleCloudAiplatformV1beta1Annotation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListArtifactsResponse(_messages.Message):
  r"""Response message for MetadataService.ListArtifacts.

  Fields:
    artifacts: The Artifacts retrieved from the MetadataStore.
    nextPageToken: A token, which can be sent as
      ListArtifactsRequest.page_token to retrieve the next page. If this field
      is not populated, there are no subsequent pages.
  """

  artifacts = _messages.MessageField('GoogleCloudAiplatformV1beta1Artifact', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListBatchPredictionJobsResponse(_messages.Message):
  r"""Response message for JobService.ListBatchPredictionJobs

  Fields:
    batchPredictionJobs: List of BatchPredictionJobs in the requested page.
    nextPageToken: A token to retrieve the next page of results. Pass to
      ListBatchPredictionJobsRequest.page_token to obtain that page.
  """

  batchPredictionJobs = _messages.MessageField('GoogleCloudAiplatformV1beta1BatchPredictionJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListCachedContentsResponse(_messages.Message):
  r"""Response with a list of CachedContents.

  Fields:
    cachedContents: List of cached contents.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  cachedContents = _messages.MessageField('GoogleCloudAiplatformV1beta1CachedContent', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListContextsResponse(_messages.Message):
  r"""Response message for MetadataService.ListContexts.

  Fields:
    contexts: The Contexts retrieved from the MetadataStore.
    nextPageToken: A token, which can be sent as
      ListContextsRequest.page_token to retrieve the next page. If this field
      is not populated, there are no subsequent pages.
  """

  contexts = _messages.MessageField('GoogleCloudAiplatformV1beta1Context', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListCustomJobsResponse(_messages.Message):
  r"""Response message for JobService.ListCustomJobs

  Fields:
    customJobs: List of CustomJobs in the requested page.
    nextPageToken: A token to retrieve the next page of results. Pass to
      ListCustomJobsRequest.page_token to obtain that page.
  """

  customJobs = _messages.MessageField('GoogleCloudAiplatformV1beta1CustomJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListDataItemsResponse(_messages.Message):
  r"""Response message for DatasetService.ListDataItems.

  Fields:
    dataItems: A list of DataItems that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  dataItems = _messages.MessageField('GoogleCloudAiplatformV1beta1DataItem', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListDataLabelingJobsResponse(_messages.Message):
  r"""Response message for JobService.ListDataLabelingJobs.

  Fields:
    dataLabelingJobs: A list of DataLabelingJobs that matches the specified
      filter in the request.
    nextPageToken: The standard List next-page token.
  """

  dataLabelingJobs = _messages.MessageField('GoogleCloudAiplatformV1beta1DataLabelingJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListDatasetVersionsResponse(_messages.Message):
  r"""Response message for DatasetService.ListDatasetVersions.

  Fields:
    datasetVersions: A list of DatasetVersions that matches the specified
      filter in the request.
    nextPageToken: The standard List next-page token.
  """

  datasetVersions = _messages.MessageField('GoogleCloudAiplatformV1beta1DatasetVersion', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListDatasetsResponse(_messages.Message):
  r"""Response message for DatasetService.ListDatasets.

  Fields:
    datasets: A list of Datasets that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  datasets = _messages.MessageField('GoogleCloudAiplatformV1beta1Dataset', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListDeploymentResourcePoolsResponse(_messages.Message):
  r"""Response message for ListDeploymentResourcePools method.

  Fields:
    deploymentResourcePools: The DeploymentResourcePools from the specified
      location.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  deploymentResourcePools = _messages.MessageField('GoogleCloudAiplatformV1beta1DeploymentResourcePool', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListEndpointsResponse(_messages.Message):
  r"""Response message for EndpointService.ListEndpoints.

  Fields:
    endpoints: List of Endpoints in the requested page.
    nextPageToken: A token to retrieve the next page of results. Pass to
      ListEndpointsRequest.page_token to obtain that page.
  """

  endpoints = _messages.MessageField('GoogleCloudAiplatformV1beta1Endpoint', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListEntityTypesResponse(_messages.Message):
  r"""Response message for FeaturestoreService.ListEntityTypes.

  Fields:
    entityTypes: The EntityTypes matching the request.
    nextPageToken: A token, which can be sent as
      ListEntityTypesRequest.page_token to retrieve the next page. If this
      field is omitted, there are no subsequent pages.
  """

  entityTypes = _messages.MessageField('GoogleCloudAiplatformV1beta1EntityType', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListExecutionsResponse(_messages.Message):
  r"""Response message for MetadataService.ListExecutions.

  Fields:
    executions: The Executions retrieved from the MetadataStore.
    nextPageToken: A token, which can be sent as
      ListExecutionsRequest.page_token to retrieve the next page. If this
      field is not populated, there are no subsequent pages.
  """

  executions = _messages.MessageField('GoogleCloudAiplatformV1beta1Execution', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListExtensionsResponse(_messages.Message):
  r"""Response message for ExtensionRegistryService.ListExtensions

  Fields:
    extensions: List of Extension in the requested page.
    nextPageToken: A token to retrieve the next page of results. Pass to
      ListExtensionsRequest.page_token to obtain that page.
  """

  extensions = _messages.MessageField('GoogleCloudAiplatformV1beta1Extension', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListFeatureGroupsResponse(_messages.Message):
  r"""Response message for FeatureRegistryService.ListFeatureGroups.

  Fields:
    featureGroups: The FeatureGroups matching the request.
    nextPageToken: A token, which can be sent as
      ListFeatureGroupsRequest.page_token to retrieve the next page. If this
      field is omitted, there are no subsequent pages.
  """

  featureGroups = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureGroup', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListFeatureMonitorJobsResponse(_messages.Message):
  r"""Response message for FeatureRegistryService.ListFeatureMonitorJobs.

  Fields:
    featureMonitorJobs: The FeatureMonitorJobs matching the request.
    nextPageToken: A token, which can be sent as
      ListFeatureMonitorJobsRequest.page_token to retrieve the next page. If
      this field is omitted, there are no subsequent pages.
  """

  featureMonitorJobs = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureMonitorJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListFeatureMonitorsResponse(_messages.Message):
  r"""Response message for FeatureRegistryService.ListFeatureMonitors.

  Fields:
    featureMonitors: The FeatureMonitors matching the request.
    nextPageToken: A token, which can be sent as
      ListFeatureMonitorsRequest.page_token to retrieve the next page. If this
      field is omitted, there are no subsequent pages.
  """

  featureMonitors = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureMonitor', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListFeatureOnlineStoresResponse(_messages.Message):
  r"""Response message for
  FeatureOnlineStoreAdminService.ListFeatureOnlineStores.

  Fields:
    featureOnlineStores: The FeatureOnlineStores matching the request.
    nextPageToken: A token, which can be sent as
      ListFeatureOnlineStoresRequest.page_token to retrieve the next page. If
      this field is omitted, there are no subsequent pages.
  """

  featureOnlineStores = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureOnlineStore', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListFeatureViewSyncsResponse(_messages.Message):
  r"""Response message for
  FeatureOnlineStoreAdminService.ListFeatureViewSyncs.

  Fields:
    featureViewSyncs: The FeatureViewSyncs matching the request.
    nextPageToken: A token, which can be sent as
      ListFeatureViewSyncsRequest.page_token to retrieve the next page. If
      this field is omitted, there are no subsequent pages.
  """

  featureViewSyncs = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureViewSync', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListFeatureViewsResponse(_messages.Message):
  r"""Response message for FeatureOnlineStoreAdminService.ListFeatureViews.

  Fields:
    featureViews: The FeatureViews matching the request.
    nextPageToken: A token, which can be sent as
      ListFeatureViewsRequest.page_token to retrieve the next page. If this
      field is omitted, there are no subsequent pages.
  """

  featureViews = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureView', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListFeaturesResponse(_messages.Message):
  r"""Response message for FeaturestoreService.ListFeatures. Response message
  for FeatureRegistryService.ListFeatures.

  Fields:
    features: The Features matching the request.
    nextPageToken: A token, which can be sent as
      ListFeaturesRequest.page_token to retrieve the next page. If this field
      is omitted, there are no subsequent pages.
  """

  features = _messages.MessageField('GoogleCloudAiplatformV1beta1Feature', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListFeaturestoresResponse(_messages.Message):
  r"""Response message for FeaturestoreService.ListFeaturestores.

  Fields:
    featurestores: The Featurestores matching the request.
    nextPageToken: A token, which can be sent as
      ListFeaturestoresRequest.page_token to retrieve the next page. If this
      field is omitted, there are no subsequent pages.
  """

  featurestores = _messages.MessageField('GoogleCloudAiplatformV1beta1Featurestore', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListHyperparameterTuningJobsResponse(_messages.Message):
  r"""Response message for JobService.ListHyperparameterTuningJobs

  Fields:
    hyperparameterTuningJobs: List of HyperparameterTuningJobs in the
      requested page. HyperparameterTuningJob.trials of the jobs will be not
      be returned.
    nextPageToken: A token to retrieve the next page of results. Pass to
      ListHyperparameterTuningJobsRequest.page_token to obtain that page.
  """

  hyperparameterTuningJobs = _messages.MessageField('GoogleCloudAiplatformV1beta1HyperparameterTuningJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListIndexEndpointsResponse(_messages.Message):
  r"""Response message for IndexEndpointService.ListIndexEndpoints.

  Fields:
    indexEndpoints: List of IndexEndpoints in the requested page.
    nextPageToken: A token to retrieve next page of results. Pass to
      ListIndexEndpointsRequest.page_token to obtain that page.
  """

  indexEndpoints = _messages.MessageField('GoogleCloudAiplatformV1beta1IndexEndpoint', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListIndexesResponse(_messages.Message):
  r"""Response message for IndexService.ListIndexes.

  Fields:
    indexes: List of indexes in the requested page.
    nextPageToken: A token to retrieve next page of results. Pass to
      ListIndexesRequest.page_token to obtain that page.
  """

  indexes = _messages.MessageField('GoogleCloudAiplatformV1beta1Index', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListMetadataSchemasResponse(_messages.Message):
  r"""Response message for MetadataService.ListMetadataSchemas.

  Fields:
    metadataSchemas: The MetadataSchemas found for the MetadataStore.
    nextPageToken: A token, which can be sent as
      ListMetadataSchemasRequest.page_token to retrieve the next page. If this
      field is not populated, there are no subsequent pages.
  """

  metadataSchemas = _messages.MessageField('GoogleCloudAiplatformV1beta1MetadataSchema', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListMetadataStoresResponse(_messages.Message):
  r"""Response message for MetadataService.ListMetadataStores.

  Fields:
    metadataStores: The MetadataStores found for the Location.
    nextPageToken: A token, which can be sent as
      ListMetadataStoresRequest.page_token to retrieve the next page. If this
      field is not populated, there are no subsequent pages.
  """

  metadataStores = _messages.MessageField('GoogleCloudAiplatformV1beta1MetadataStore', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListModelDeploymentMonitoringJobsResponse(_messages.Message):
  r"""Response message for JobService.ListModelDeploymentMonitoringJobs.

  Fields:
    modelDeploymentMonitoringJobs: A list of ModelDeploymentMonitoringJobs
      that matches the specified filter in the request.
    nextPageToken: The standard List next-page token.
  """

  modelDeploymentMonitoringJobs = _messages.MessageField('GoogleCloudAiplatformV1beta1ModelDeploymentMonitoringJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ListModelEvaluationSlicesResponse(_messages.Message):
