"""Generated message classes for managedflink version v1alpha.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'managedflink'


class AutotuningConfig(_messages.Message):
  r"""The autotuning configuration for the Flink job.

  Fields:
    enableHorizontalAutoscaling: Optional. Whether horizontal autoscaling is
      enabled for the Flink job.
    maxParallelism: Optional. Max parallelism of the Flink job.
    minParallelism: Optional. Min parallelism of the Flink job.
  """

  enableHorizontalAutoscaling = _messages.BooleanField(1)
  maxParallelism = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  minParallelism = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class Deployment(_messages.Message):
  r"""Message describing Deployment object

  Messages:
    LabelsValue: Optional. Labels as key value pairs

  Fields:
    createTime: Output only. [Output only] Create time stamp
    deploymentStatus: Output only. Last observed status of the Flink
      deployment.
    gcpConfig: Optional. The GCP configurations for a ManagedFlink resource.
    labels: Optional. Labels as key value pairs
    name: name of resource
    spec: Optional. Spec that describes a Flink session cluster deployment.
    updateTime: Output only. [Output only] Update time stamp
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  deploymentStatus = _messages.MessageField('ManagedFlinkDeploymentStatus', 2)
  gcpConfig = _messages.MessageField('GcpConfig', 3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  spec = _messages.MessageField('ManagedFlinkDeploymentSpec', 6)
  updateTime = _messages.StringField(7)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class GcpConfig(_messages.Message):
  r"""The GCP configurations for a ManagedFlink resource.

  Fields:
    networkConfigs: Optional. The GCP network configurations for a
      ManagedFlink resource.
  """

  networkConfigs = _messages.MessageField('NetworkConfig', 1)


class Job(_messages.Message):
  r"""Message describing the Flink Job resource.

  Enums:
    StateValueValuesEnum: Output only. The state of the flink job.

  Messages:
    LabelsValue: Optional. User defined labels as key value pairs.

  Fields:
    createTime: Output only. The time when the job was created.
    deploymentId: Optional. The flink deployment that this job belongs to. If
      empty, the job is created in an ephemeral on-demand flink cluster.
    jobSpec: Required. The specification of the Flink job.
    labels: Optional. User defined labels as key value pairs.
    name: Identifier. The name of the job.
    state: Output only. The state of the flink job.
    updateTime: Output only. The time when the job was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of the flink job.

    Values:
      STATE_UNSPECIFIED: state unspecified.
      INITIALIZING: job is initializing.
      CREATED: job has been created.
      RUNNING: job is running .
      FAILING: job is failing.
      FAILED: job has failed.
      CANCELLING: job is getting cancelled.
      CANCELLED: job has been cancelled.
      FINISHED: job has finished.
      RESTARTING: job is restarting.
      SUSPENDED: job has been suspended.
      RECONCILING: job is reconciling.
    """
    STATE_UNSPECIFIED = 0
    INITIALIZING = 1
    CREATED = 2
    RUNNING = 3
    FAILING = 4
    FAILED = 5
    CANCELLING = 6
    CANCELLED = 7
    FINISHED = 8
    RESTARTING = 9
    SUSPENDED = 10
    RECONCILING = 11

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User defined labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  deploymentId = _messages.StringField(2)
  jobSpec = _messages.MessageField('JobSpec', 3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  updateTime = _messages.StringField(7)


class JobSpec(_messages.Message):
  r"""The specification of the Flink job.

  Fields:
    artifactUris: Required. The list of URIs for the flink job artifact files
      in cloud storage.
    autotuningConfig: Optional. Autotuning configuration for the job.
    displayName: Optional. Display name of the Flink job, derived from the
      Flink job graph.
    jarUris: Optional. The list of URIs for the job jars in cloud storage.
    jobGraphUri: Required. The flink job graph uri in cloud storage.
    network: Optional. The VPC network for the Flink job.
    subnetwork: Optional. The VPC subnet in which to create Private Service
      Connect (PSC) interfaces for the Flink job.
  """

  artifactUris = _messages.StringField(1, repeated=True)
  autotuningConfig = _messages.MessageField('AutotuningConfig', 2)
  displayName = _messages.StringField(3)
  jarUris = _messages.StringField(4, repeated=True)
  jobGraphUri = _messages.StringField(5)
  network = _messages.StringField(6)
  subnetwork = _messages.StringField(7)


class ListDeploymentsResponse(_messages.Message):
  r"""Message for response to listing Deployments

  Fields:
    deployments: The list of Deployment
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  deployments = _messages.MessageField('Deployment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListJobsResponse(_messages.Message):
  r"""Message for response to listing Jobs

  Fields:
    jobs: The list of Job
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  jobs = _messages.MessageField('Job', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class ManagedFlinkDeploymentSpec(_messages.Message):
  r"""The specification of the Flink deployment.

  Messages:
    FlinkConfigValue: Optional. Flink configuration overrides for the Flink
      deployment or Flink session job.
    LogConfigValue: Optional. Log configuration overrides for the Flink
      deployment. Format logConfigFileName -> configContent.

  Fields:
    entryClass: Optional. Adding temporarily to not break the existing code
      for deployment workflow.
    flinkConfig: Optional. Flink configuration overrides for the Flink
      deployment or Flink session job.
    image: Optional. Flink docker image used to start the Job and TaskManager
      pods.
    imagePullPolicy: Optional. Image pull policy of the Flink docker image.
    job: Optional. --- POTENTIALLY REMOVE FIELD: --- Might make sense to
      remove this field for the time being, based on OSS Flink's documentation
      this field should only be specified for Application Mode and should be
      empty for Session mode. I know we floated the idea of creating a Flink
      Session Cluster + Flink Job in a single CreateDeployment call, but I'm
      not sure if we're still trying to support ## that CUJ.
      https://screenshot.googleplex.com/93wyzH6rUzoySrR Job specification for
      application deployments/session job. Null for session clusters.
    logConfig: Optional. Log configuration overrides for the Flink deployment.
      Format logConfigFileName -> configContent.
    restartNonce: Optional. Nonce used to manually trigger restart for the
      cluster/session job. In order to trigger restart, change the number to a
      different non-null value.
    serviceAccount: Optional. Kubernetes service used by the Flink deployment.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FlinkConfigValue(_messages.Message):
    r"""Optional. Flink configuration overrides for the Flink deployment or
    Flink session job.

    Messages:
      AdditionalProperty: An additional property for a FlinkConfigValue
        object.

    Fields:
      additionalProperties: Additional properties of type FlinkConfigValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FlinkConfigValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LogConfigValue(_messages.Message):
    r"""Optional. Log configuration overrides for the Flink deployment. Format
    logConfigFileName -> configContent.

    Messages:
      AdditionalProperty: An additional property for a LogConfigValue object.

    Fields:
      additionalProperties: Additional properties of type LogConfigValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LogConfigValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  entryClass = _messages.StringField(1)
  flinkConfig = _messages.MessageField('FlinkConfigValue', 2)
  image = _messages.StringField(3)
  imagePullPolicy = _messages.StringField(4)
  job = _messages.MessageField('JobSpec', 5)
  logConfig = _messages.MessageField('LogConfigValue', 6)
  restartNonce = _messages.IntegerField(7)
  serviceAccount = _messages.StringField(8)


class ManagedFlinkDeploymentStatus(_messages.Message):
  r"""The status of the Flink deployment or Flink session job.

  Enums:
    LifecycleStateValueValuesEnum: Output only. Lifecycle state of the Flink
      resource (including being rolled back, failed etc.).

  Messages:
    ClusterInfoValue: Output only. Information from running clusters.

  Fields:
    clusterInfo: Output only. Information from running clusters.
    error: Output only. Error information about the
      FlinkDeployment/FlinkSessionJob.
    generation: Output only. Last observed generation of the
      FlinkDeployment/FlinkSessionJob.
    lifecycleState: Output only. Lifecycle state of the Flink resource
      (including being rolled back, failed etc.).
  """

  class LifecycleStateValueValuesEnum(_messages.Enum):
    r"""Output only. Lifecycle state of the Flink resource (including being
    rolled back, failed etc.).

    Values:
      RESOURCE_LIFECYCLE_STATE_UNSPECIFIED: Unspecified state.
      DEPLOYMENT_CREATED: Resource has been created.
      DEPLOYMENT_DEPLOYED: Resource has been deployed.
      DEPLOYMENT_FAILED: Resource has failed to deploy.
      DEPLOYMENT_ROLLED_BACK: Resource has been rolled back.
      DEPLOYMENT_ROLLING_BACK: Resource is stable.
      DEPLOYMENT_STABLE: Resource is stable.
      DEPLOYMENT_SUSPENDED: Resource is suspended.
      DEPLOYMENT_UPGRADING: Resource is upgrading.
    """
    RESOURCE_LIFECYCLE_STATE_UNSPECIFIED = 0
    DEPLOYMENT_CREATED = 1
    DEPLOYMENT_DEPLOYED = 2
    DEPLOYMENT_FAILED = 3
    DEPLOYMENT_ROLLED_BACK = 4
    DEPLOYMENT_ROLLING_BACK = 5
    DEPLOYMENT_STABLE = 6
    DEPLOYMENT_SUSPENDED = 7
    DEPLOYMENT_UPGRADING = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ClusterInfoValue(_messages.Message):
    r"""Output only. Information from running clusters.

    Messages:
      AdditionalProperty: An additional property for a ClusterInfoValue
        object.

    Fields:
      additionalProperties: Additional properties of type ClusterInfoValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ClusterInfoValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clusterInfo = _messages.MessageField('ClusterInfoValue', 1)
  error = _messages.StringField(2)
  generation = _messages.IntegerField(3)
  lifecycleState = _messages.EnumField('LifecycleStateValueValuesEnum', 4)


class ManagedflinkProjectsLocationsDeploymentsCreateRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsDeploymentsCreateRequest object.

  Fields:
    deployment: A Deployment resource to be passed as the request body.
    deploymentId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and deployment_id from the
      method_signature of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  deployment = _messages.MessageField('Deployment', 1)
  deploymentId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ManagedflinkProjectsLocationsDeploymentsDeleteRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsDeploymentsDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class ManagedflinkProjectsLocationsDeploymentsGetRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsDeploymentsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class ManagedflinkProjectsLocationsDeploymentsListRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsDeploymentsListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListDeploymentsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ManagedflinkProjectsLocationsDeploymentsPatchRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsDeploymentsPatchRequest object.

  Fields:
    deployment: A Deployment resource to be passed as the request body.
    name: name of resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Deployment resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  deployment = _messages.MessageField('Deployment', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class ManagedflinkProjectsLocationsGetRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class ManagedflinkProjectsLocationsJobsCreateRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsJobsCreateRequest object.

  Fields:
    job: A Job resource to be passed as the request body.
    jobId: Required. The ID to use for the job, which will become the final
      component of the job's name.
    parent: Required. The parent region in which to create the job. Structured
      like `projects/{project}/locations/{location}`.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  job = _messages.MessageField('Job', 1)
  jobId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ManagedflinkProjectsLocationsJobsDeleteRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsJobsDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class ManagedflinkProjectsLocationsJobsGetRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsJobsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class ManagedflinkProjectsLocationsJobsListRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsJobsListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListJobsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ManagedflinkProjectsLocationsJobsPatchRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsJobsPatchRequest object.

  Fields:
    job: A Job resource to be passed as the request body.
    name: Identifier. The name of the job.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Job resource by the update. The fields specified in
      the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  job = _messages.MessageField('Job', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class ManagedflinkProjectsLocationsListRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ManagedflinkProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class ManagedflinkProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class ManagedflinkProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class ManagedflinkProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class NetworkConfig(_messages.Message):
  r"""The VPC, region, subnetwork that can connect to this Flink Cluster.

  Fields:
    region: Optional. The region of the ManagedFlink resource.
    subnetwork: Optional. The subnetwork of the ManagedFlink resource.
    vpc: Optional. The name of the VPC Network to assocaite ManagedFlink
      resources with. Formatted as:
      projects/{project}/global/networks/{network_id}
  """

  region = _messages.StringField(1)
  subnetwork = _messages.StringField(2)
  vpc = _messages.StringField(3)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
