package net

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// PortRange represents a range of ports.
type PortRange struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The port that this range starts from.
	From uint32 `protobuf:"varint,1,opt,name=From,proto3" json:"From,omitempty"`
	// The port that this range ends with (inclusive).
	To            uint32 `protobuf:"varint,2,opt,name=To,proto3" json:"To,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PortRange) Reset() {
	*x = PortRange{}
	mi := &file_common_net_port_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PortRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PortRange) ProtoMessage() {}

func (x *PortRange) ProtoReflect() protoreflect.Message {
	mi := &file_common_net_port_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PortRange.ProtoReflect.Descriptor instead.
func (*PortRange) Descriptor() ([]byte, []int) {
	return file_common_net_port_proto_rawDescGZIP(), []int{0}
}

func (x *PortRange) GetFrom() uint32 {
	if x != nil {
		return x.From
	}
	return 0
}

func (x *PortRange) GetTo() uint32 {
	if x != nil {
		return x.To
	}
	return 0
}

// PortList is a list of ports.
type PortList struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Range         []*PortRange           `protobuf:"bytes,1,rep,name=range,proto3" json:"range,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PortList) Reset() {
	*x = PortList{}
	mi := &file_common_net_port_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PortList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PortList) ProtoMessage() {}

func (x *PortList) ProtoReflect() protoreflect.Message {
	mi := &file_common_net_port_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PortList.ProtoReflect.Descriptor instead.
func (*PortList) Descriptor() ([]byte, []int) {
	return file_common_net_port_proto_rawDescGZIP(), []int{1}
}

func (x *PortList) GetRange() []*PortRange {
	if x != nil {
		return x.Range
	}
	return nil
}

var File_common_net_port_proto protoreflect.FileDescriptor

const file_common_net_port_proto_rawDesc = "" +
	"\n" +
	"\x15common/net/port.proto\x12\x15v2ray.core.common.net\"/\n" +
	"\tPortRange\x12\x12\n" +
	"\x04From\x18\x01 \x01(\rR\x04From\x12\x0e\n" +
	"\x02To\x18\x02 \x01(\rR\x02To\"B\n" +
	"\bPortList\x126\n" +
	"\x05range\x18\x01 \x03(\v2 .v2ray.core.common.net.PortRangeR\x05rangeB`\n" +
	"\x19com.v2ray.core.common.netP\x01Z)github.com/v2fly/v2ray-core/v5/common/net\xaa\x02\x15V2Ray.Core.Common.Netb\x06proto3"

var (
	file_common_net_port_proto_rawDescOnce sync.Once
	file_common_net_port_proto_rawDescData []byte
)

func file_common_net_port_proto_rawDescGZIP() []byte {
	file_common_net_port_proto_rawDescOnce.Do(func() {
		file_common_net_port_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_common_net_port_proto_rawDesc), len(file_common_net_port_proto_rawDesc)))
	})
	return file_common_net_port_proto_rawDescData
}

var file_common_net_port_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_common_net_port_proto_goTypes = []any{
	(*PortRange)(nil), // 0: v2ray.core.common.net.PortRange
	(*PortList)(nil),  // 1: v2ray.core.common.net.PortList
}
var file_common_net_port_proto_depIdxs = []int32{
	0, // 0: v2ray.core.common.net.PortList.range:type_name -> v2ray.core.common.net.PortRange
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_common_net_port_proto_init() }
func file_common_net_port_proto_init() {
	if File_common_net_port_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_common_net_port_proto_rawDesc), len(file_common_net_port_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_common_net_port_proto_goTypes,
		DependencyIndexes: file_common_net_port_proto_depIdxs,
		MessageInfos:      file_common_net_port_proto_msgTypes,
	}.Build()
	File_common_net_port_proto = out.File
	file_common_net_port_proto_goTypes = nil
	file_common_net_port_proto_depIdxs = nil
}
