// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: sources.proto

package sourcespb

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on LocalSource with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *LocalSource) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on LocalSource with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in LocalSourceMultiError, or
// nil if none found.
func (m *LocalSource) ValidateAll() error {
	return m.validate(true)
}

func (m *LocalSource) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Type

	// no validation rules for Name

	if all {
		switch v := interface{}(m.GetScanInterval()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, LocalSourceValidationError{
					field:  "ScanInterval",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, LocalSourceValidationError{
					field:  "ScanInterval",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetScanInterval()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return LocalSourceValidationError{
				field:  "ScanInterval",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for Verify

	if all {
		switch v := interface{}(m.GetConnection()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, LocalSourceValidationError{
					field:  "Connection",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, LocalSourceValidationError{
					field:  "Connection",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetConnection()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return LocalSourceValidationError{
				field:  "Connection",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for ScanPeriod

	if len(errors) > 0 {
		return LocalSourceMultiError(errors)
	}

	return nil
}

// LocalSourceMultiError is an error wrapping multiple validation errors
// returned by LocalSource.ValidateAll() if the designated constraints aren't met.
type LocalSourceMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m LocalSourceMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m LocalSourceMultiError) AllErrors() []error { return m }

// LocalSourceValidationError is the validation error returned by
// LocalSource.Validate if the designated constraints aren't met.
type LocalSourceValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LocalSourceValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LocalSourceValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LocalSourceValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LocalSourceValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LocalSourceValidationError) ErrorName() string { return "LocalSourceValidationError" }

// Error satisfies the builtin error interface
func (e LocalSourceValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLocalSource.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LocalSourceValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LocalSourceValidationError{}

// Validate checks the field values on Artifactory with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Artifactory) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Artifactory with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ArtifactoryMultiError, or
// nil if none found.
func (m *Artifactory) ValidateAll() error {
	return m.validate(true)
}

func (m *Artifactory) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, err := url.Parse(m.GetEndpoint()); err != nil {
		err = ArtifactoryValidationError{
			field:  "Endpoint",
			reason: "value must be a valid URI",
			cause:  err,
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	switch v := m.Credential.(type) {
	case *Artifactory_BasicAuth:
		if v == nil {
			err := ArtifactoryValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetBasicAuth()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ArtifactoryValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ArtifactoryValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetBasicAuth()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ArtifactoryValidationError{
					field:  "BasicAuth",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Artifactory_AccessToken:
		if v == nil {
			err := ArtifactoryValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for AccessToken
	case *Artifactory_Unauthenticated:
		if v == nil {
			err := ArtifactoryValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUnauthenticated()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ArtifactoryValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ArtifactoryValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUnauthenticated()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ArtifactoryValidationError{
					field:  "Unauthenticated",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return ArtifactoryMultiError(errors)
	}

	return nil
}

// ArtifactoryMultiError is an error wrapping multiple validation errors
// returned by Artifactory.ValidateAll() if the designated constraints aren't met.
type ArtifactoryMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ArtifactoryMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ArtifactoryMultiError) AllErrors() []error { return m }

// ArtifactoryValidationError is the validation error returned by
// Artifactory.Validate if the designated constraints aren't met.
type ArtifactoryValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ArtifactoryValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ArtifactoryValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ArtifactoryValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ArtifactoryValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ArtifactoryValidationError) ErrorName() string { return "ArtifactoryValidationError" }

// Error satisfies the builtin error interface
func (e ArtifactoryValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sArtifactory.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ArtifactoryValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ArtifactoryValidationError{}

// Validate checks the field values on AzureStorage with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *AzureStorage) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AzureStorage with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in AzureStorageMultiError, or
// nil if none found.
func (m *AzureStorage) ValidateAll() error {
	return m.validate(true)
}

func (m *AzureStorage) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	switch v := m.Credential.(type) {
	case *AzureStorage_ConnectionString:
		if v == nil {
			err := AzureStorageValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for ConnectionString
	case *AzureStorage_BasicAuth:
		if v == nil {
			err := AzureStorageValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetBasicAuth()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, AzureStorageValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, AzureStorageValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetBasicAuth()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AzureStorageValidationError{
					field:  "BasicAuth",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *AzureStorage_ClientCertificate:
		if v == nil {
			err := AzureStorageValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for ClientCertificate
	case *AzureStorage_Unauthenticated:
		if v == nil {
			err := AzureStorageValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUnauthenticated()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, AzureStorageValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, AzureStorageValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUnauthenticated()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AzureStorageValidationError{
					field:  "Unauthenticated",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return AzureStorageMultiError(errors)
	}

	return nil
}

// AzureStorageMultiError is an error wrapping multiple validation errors
// returned by AzureStorage.ValidateAll() if the designated constraints aren't met.
type AzureStorageMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AzureStorageMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AzureStorageMultiError) AllErrors() []error { return m }

// AzureStorageValidationError is the validation error returned by
// AzureStorage.Validate if the designated constraints aren't met.
type AzureStorageValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AzureStorageValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AzureStorageValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AzureStorageValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AzureStorageValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AzureStorageValidationError) ErrorName() string { return "AzureStorageValidationError" }

// Error satisfies the builtin error interface
func (e AzureStorageValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAzureStorage.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AzureStorageValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AzureStorageValidationError{}

// Validate checks the field values on Bitbucket with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Bitbucket) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Bitbucket with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in BitbucketMultiError, or nil
// if none found.
func (m *Bitbucket) ValidateAll() error {
	return m.validate(true)
}

func (m *Bitbucket) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, err := url.Parse(m.GetEndpoint()); err != nil {
		err = BitbucketValidationError{
			field:  "Endpoint",
			reason: "value must be a valid URI",
			cause:  err,
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for SkipBinaries

	// no validation rules for SkipArchives

	// no validation rules for InstallationType

	switch v := m.Credential.(type) {
	case *Bitbucket_Token:
		if v == nil {
			err := BitbucketValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for Token
	case *Bitbucket_Oauth:
		if v == nil {
			err := BitbucketValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetOauth()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, BitbucketValidationError{
						field:  "Oauth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, BitbucketValidationError{
						field:  "Oauth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetOauth()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return BitbucketValidationError{
					field:  "Oauth",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Bitbucket_BasicAuth:
		if v == nil {
			err := BitbucketValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetBasicAuth()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, BitbucketValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, BitbucketValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetBasicAuth()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return BitbucketValidationError{
					field:  "BasicAuth",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return BitbucketMultiError(errors)
	}

	return nil
}

// BitbucketMultiError is an error wrapping multiple validation errors returned
// by Bitbucket.ValidateAll() if the designated constraints aren't met.
type BitbucketMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BitbucketMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BitbucketMultiError) AllErrors() []error { return m }

// BitbucketValidationError is the validation error returned by
// Bitbucket.Validate if the designated constraints aren't met.
type BitbucketValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BitbucketValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BitbucketValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BitbucketValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BitbucketValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BitbucketValidationError) ErrorName() string { return "BitbucketValidationError" }

// Error satisfies the builtin error interface
func (e BitbucketValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBitbucket.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BitbucketValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BitbucketValidationError{}

// Validate checks the field values on CircleCI with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *CircleCI) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on CircleCI with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in CircleCIMultiError, or nil
// if none found.
func (m *CircleCI) ValidateAll() error {
	return m.validate(true)
}

func (m *CircleCI) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, err := url.Parse(m.GetEndpoint()); err != nil {
		err = CircleCIValidationError{
			field:  "Endpoint",
			reason: "value must be a valid URI",
			cause:  err,
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	switch v := m.Credential.(type) {
	case *CircleCI_Token:
		if v == nil {
			err := CircleCIValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for Token
	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return CircleCIMultiError(errors)
	}

	return nil
}

// CircleCIMultiError is an error wrapping multiple validation errors returned
// by CircleCI.ValidateAll() if the designated constraints aren't met.
type CircleCIMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m CircleCIMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m CircleCIMultiError) AllErrors() []error { return m }

// CircleCIValidationError is the validation error returned by
// CircleCI.Validate if the designated constraints aren't met.
type CircleCIValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CircleCIValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CircleCIValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CircleCIValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CircleCIValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CircleCIValidationError) ErrorName() string { return "CircleCIValidationError" }

// Error satisfies the builtin error interface
func (e CircleCIValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCircleCI.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CircleCIValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CircleCIValidationError{}

// Validate checks the field values on TravisCI with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *TravisCI) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TravisCI with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in TravisCIMultiError, or nil
// if none found.
func (m *TravisCI) ValidateAll() error {
	return m.validate(true)
}

func (m *TravisCI) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, err := url.Parse(m.GetEndpoint()); err != nil {
		err = TravisCIValidationError{
			field:  "Endpoint",
			reason: "value must be a valid URI",
			cause:  err,
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	switch v := m.Credential.(type) {
	case *TravisCI_Token:
		if v == nil {
			err := TravisCIValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for Token
	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return TravisCIMultiError(errors)
	}

	return nil
}

// TravisCIMultiError is an error wrapping multiple validation errors returned
// by TravisCI.ValidateAll() if the designated constraints aren't met.
type TravisCIMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TravisCIMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TravisCIMultiError) AllErrors() []error { return m }

// TravisCIValidationError is the validation error returned by
// TravisCI.Validate if the designated constraints aren't met.
type TravisCIValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TravisCIValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TravisCIValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TravisCIValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TravisCIValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TravisCIValidationError) ErrorName() string { return "TravisCIValidationError" }

// Error satisfies the builtin error interface
func (e TravisCIValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTravisCI.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TravisCIValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TravisCIValidationError{}

// Validate checks the field values on Confluence with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Confluence) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Confluence with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ConfluenceMultiError, or
// nil if none found.
func (m *Confluence) ValidateAll() error {
	return m.validate(true)
}

func (m *Confluence) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, err := url.Parse(m.GetEndpoint()); err != nil {
		err = ConfluenceValidationError{
			field:  "Endpoint",
			reason: "value must be a valid URI",
			cause:  err,
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for SpacesScope

	// no validation rules for InsecureSkipVerifyTls

	// no validation rules for IncludeAttachments

	// no validation rules for SkipHistory

	switch v := m.Credential.(type) {
	case *Confluence_Unauthenticated:
		if v == nil {
			err := ConfluenceValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUnauthenticated()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ConfluenceValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ConfluenceValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUnauthenticated()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ConfluenceValidationError{
					field:  "Unauthenticated",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Confluence_BasicAuth:
		if v == nil {
			err := ConfluenceValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetBasicAuth()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ConfluenceValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ConfluenceValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetBasicAuth()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ConfluenceValidationError{
					field:  "BasicAuth",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Confluence_Token:
		if v == nil {
			err := ConfluenceValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for Token
	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return ConfluenceMultiError(errors)
	}

	return nil
}

// ConfluenceMultiError is an error wrapping multiple validation errors
// returned by Confluence.ValidateAll() if the designated constraints aren't met.
type ConfluenceMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ConfluenceMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ConfluenceMultiError) AllErrors() []error { return m }

// ConfluenceValidationError is the validation error returned by
// Confluence.Validate if the designated constraints aren't met.
type ConfluenceValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ConfluenceValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ConfluenceValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ConfluenceValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ConfluenceValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ConfluenceValidationError) ErrorName() string { return "ConfluenceValidationError" }

// Error satisfies the builtin error interface
func (e ConfluenceValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sConfluence.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ConfluenceValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ConfluenceValidationError{}

// Validate checks the field values on Docker with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Docker) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Docker with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in DockerMultiError, or nil if none found.
func (m *Docker) ValidateAll() error {
	return m.validate(true)
}

func (m *Docker) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	switch v := m.Credential.(type) {
	case *Docker_Unauthenticated:
		if v == nil {
			err := DockerValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUnauthenticated()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, DockerValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, DockerValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUnauthenticated()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return DockerValidationError{
					field:  "Unauthenticated",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Docker_BasicAuth:
		if v == nil {
			err := DockerValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetBasicAuth()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, DockerValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, DockerValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetBasicAuth()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return DockerValidationError{
					field:  "BasicAuth",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Docker_BearerToken:
		if v == nil {
			err := DockerValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for BearerToken
	case *Docker_DockerKeychain:
		if v == nil {
			err := DockerValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for DockerKeychain
	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return DockerMultiError(errors)
	}

	return nil
}

// DockerMultiError is an error wrapping multiple validation errors returned by
// Docker.ValidateAll() if the designated constraints aren't met.
type DockerMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DockerMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DockerMultiError) AllErrors() []error { return m }

// DockerValidationError is the validation error returned by Docker.Validate if
// the designated constraints aren't met.
type DockerValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DockerValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DockerValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DockerValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DockerValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DockerValidationError) ErrorName() string { return "DockerValidationError" }

// Error satisfies the builtin error interface
func (e DockerValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDocker.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DockerValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DockerValidationError{}

// Validate checks the field values on ECR with the rules defined in the proto
// definition for this message. If any rules are violated, the first error
// encountered is returned, or nil if there are no violations.
func (m *ECR) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ECR with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in ECRMultiError, or nil if none found.
func (m *ECR) ValidateAll() error {
	return m.validate(true)
}

func (m *ECR) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	switch v := m.Credential.(type) {
	case *ECR_AccessKey:
		if v == nil {
			err := ECRValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetAccessKey()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ECRValidationError{
						field:  "AccessKey",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ECRValidationError{
						field:  "AccessKey",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetAccessKey()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ECRValidationError{
					field:  "AccessKey",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return ECRMultiError(errors)
	}

	return nil
}

// ECRMultiError is an error wrapping multiple validation errors returned by
// ECR.ValidateAll() if the designated constraints aren't met.
type ECRMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ECRMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ECRMultiError) AllErrors() []error { return m }

// ECRValidationError is the validation error returned by ECR.Validate if the
// designated constraints aren't met.
type ECRValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ECRValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ECRValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ECRValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ECRValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ECRValidationError) ErrorName() string { return "ECRValidationError" }

// Error satisfies the builtin error interface
func (e ECRValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sECR.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ECRValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ECRValidationError{}

// Validate checks the field values on Filesystem with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Filesystem) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Filesystem with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in FilesystemMultiError, or
// nil if none found.
func (m *Filesystem) ValidateAll() error {
	return m.validate(true)
}

func (m *Filesystem) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for IncludePathsFile

	// no validation rules for ExcludePathsFile

	if len(errors) > 0 {
		return FilesystemMultiError(errors)
	}

	return nil
}

// FilesystemMultiError is an error wrapping multiple validation errors
// returned by Filesystem.ValidateAll() if the designated constraints aren't met.
type FilesystemMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m FilesystemMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m FilesystemMultiError) AllErrors() []error { return m }

// FilesystemValidationError is the validation error returned by
// Filesystem.Validate if the designated constraints aren't met.
type FilesystemValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FilesystemValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FilesystemValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FilesystemValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FilesystemValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FilesystemValidationError) ErrorName() string { return "FilesystemValidationError" }

// Error satisfies the builtin error interface
func (e FilesystemValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFilesystem.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FilesystemValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FilesystemValidationError{}

// Validate checks the field values on GCS with the rules defined in the proto
// definition for this message. If any rules are violated, the first error
// encountered is returned, or nil if there are no violations.
func (m *GCS) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GCS with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in GCSMultiError, or nil if none found.
func (m *GCS) ValidateAll() error {
	return m.validate(true)
}

func (m *GCS) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for ProjectId

	// no validation rules for MaxObjectSize

	switch v := m.Credential.(type) {
	case *GCS_JsonServiceAccount:
		if v == nil {
			err := GCSValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for JsonServiceAccount
	case *GCS_ApiKey:
		if v == nil {
			err := GCSValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for ApiKey
	case *GCS_Unauthenticated:
		if v == nil {
			err := GCSValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUnauthenticated()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GCSValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GCSValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUnauthenticated()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GCSValidationError{
					field:  "Unauthenticated",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *GCS_Adc:
		if v == nil {
			err := GCSValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetAdc()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GCSValidationError{
						field:  "Adc",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GCSValidationError{
						field:  "Adc",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetAdc()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GCSValidationError{
					field:  "Adc",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *GCS_ServiceAccountFile:
		if v == nil {
			err := GCSValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for ServiceAccountFile
	case *GCS_Oauth:
		if v == nil {
			err := GCSValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetOauth()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GCSValidationError{
						field:  "Oauth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GCSValidationError{
						field:  "Oauth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetOauth()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GCSValidationError{
					field:  "Oauth",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return GCSMultiError(errors)
	}

	return nil
}

// GCSMultiError is an error wrapping multiple validation errors returned by
// GCS.ValidateAll() if the designated constraints aren't met.
type GCSMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GCSMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GCSMultiError) AllErrors() []error { return m }

// GCSValidationError is the validation error returned by GCS.Validate if the
// designated constraints aren't met.
type GCSValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GCSValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GCSValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GCSValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GCSValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GCSValidationError) ErrorName() string { return "GCSValidationError" }

// Error satisfies the builtin error interface
func (e GCSValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGCS.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GCSValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GCSValidationError{}

// Validate checks the field values on Git with the rules defined in the proto
// definition for this message. If any rules are violated, the first error
// encountered is returned, or nil if there are no violations.
func (m *Git) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Git with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in GitMultiError, or nil if none found.
func (m *Git) ValidateAll() error {
	return m.validate(true)
}

func (m *Git) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Head

	// no validation rules for Base

	// no validation rules for Bare

	// no validation rules for IncludePathsFile

	// no validation rules for ExcludePathsFile

	// no validation rules for ExcludeGlobs

	// no validation rules for MaxDepth

	// no validation rules for Uri

	// no validation rules for SkipBinaries

	// no validation rules for SkipArchives

	switch v := m.Credential.(type) {
	case *Git_BasicAuth:
		if v == nil {
			err := GitValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetBasicAuth()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GitValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GitValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetBasicAuth()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GitValidationError{
					field:  "BasicAuth",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Git_Unauthenticated:
		if v == nil {
			err := GitValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUnauthenticated()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GitValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GitValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUnauthenticated()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GitValidationError{
					field:  "Unauthenticated",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Git_SshAuth:
		if v == nil {
			err := GitValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetSshAuth()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GitValidationError{
						field:  "SshAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GitValidationError{
						field:  "SshAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetSshAuth()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GitValidationError{
					field:  "SshAuth",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return GitMultiError(errors)
	}

	return nil
}

// GitMultiError is an error wrapping multiple validation errors returned by
// Git.ValidateAll() if the designated constraints aren't met.
type GitMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GitMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GitMultiError) AllErrors() []error { return m }

// GitValidationError is the validation error returned by Git.Validate if the
// designated constraints aren't met.
type GitValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GitValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GitValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GitValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GitValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GitValidationError) ErrorName() string { return "GitValidationError" }

// Error satisfies the builtin error interface
func (e GitValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGit.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GitValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GitValidationError{}

// Validate checks the field values on GitLab with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *GitLab) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GitLab with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in GitLabMultiError, or nil if none found.
func (m *GitLab) ValidateAll() error {
	return m.validate(true)
}

func (m *GitLab) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, err := url.Parse(m.GetEndpoint()); err != nil {
		err = GitLabValidationError{
			field:  "Endpoint",
			reason: "value must be a valid URI",
			cause:  err,
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for SkipBinaries

	// no validation rules for SkipArchives

	// no validation rules for ExcludeProjectsSharedIntoGroups

	switch v := m.Credential.(type) {
	case *GitLab_Token:
		if v == nil {
			err := GitLabValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for Token
	case *GitLab_Oauth:
		if v == nil {
			err := GitLabValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetOauth()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GitLabValidationError{
						field:  "Oauth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GitLabValidationError{
						field:  "Oauth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetOauth()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GitLabValidationError{
					field:  "Oauth",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *GitLab_BasicAuth:
		if v == nil {
			err := GitLabValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetBasicAuth()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GitLabValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GitLabValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetBasicAuth()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GitLabValidationError{
					field:  "BasicAuth",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return GitLabMultiError(errors)
	}

	return nil
}

// GitLabMultiError is an error wrapping multiple validation errors returned by
// GitLab.ValidateAll() if the designated constraints aren't met.
type GitLabMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GitLabMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GitLabMultiError) AllErrors() []error { return m }

// GitLabValidationError is the validation error returned by GitLab.Validate if
// the designated constraints aren't met.
type GitLabValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GitLabValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GitLabValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GitLabValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GitLabValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GitLabValidationError) ErrorName() string { return "GitLabValidationError" }

// Error satisfies the builtin error interface
func (e GitLabValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGitLab.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GitLabValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GitLabValidationError{}

// Validate checks the field values on GitHub with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *GitHub) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GitHub with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in GitHubMultiError, or nil if none found.
func (m *GitHub) ValidateAll() error {
	return m.validate(true)
}

func (m *GitHub) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, err := url.Parse(m.GetEndpoint()); err != nil {
		err = GitHubValidationError{
			field:  "Endpoint",
			reason: "value must be a valid URI",
			cause:  err,
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for ScanUsers

	// no validation rules for IncludeForks

	// no validation rules for Head

	// no validation rules for Base

	// no validation rules for IncludePullRequestComments

	// no validation rules for IncludeIssueComments

	// no validation rules for IncludeGistComments

	// no validation rules for SkipBinaries

	// no validation rules for SkipArchives

	// no validation rules for IncludeWikis

	// no validation rules for CommentsTimeframeDays

	switch v := m.Credential.(type) {
	case *GitHub_GithubApp:
		if v == nil {
			err := GitHubValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetGithubApp()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GitHubValidationError{
						field:  "GithubApp",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GitHubValidationError{
						field:  "GithubApp",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetGithubApp()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GitHubValidationError{
					field:  "GithubApp",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *GitHub_Token:
		if v == nil {
			err := GitHubValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for Token
	case *GitHub_Unauthenticated:
		if v == nil {
			err := GitHubValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUnauthenticated()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GitHubValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GitHubValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUnauthenticated()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GitHubValidationError{
					field:  "Unauthenticated",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *GitHub_BasicAuth:
		if v == nil {
			err := GitHubValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetBasicAuth()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GitHubValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GitHubValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetBasicAuth()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GitHubValidationError{
					field:  "BasicAuth",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return GitHubMultiError(errors)
	}

	return nil
}

// GitHubMultiError is an error wrapping multiple validation errors returned by
// GitHub.ValidateAll() if the designated constraints aren't met.
type GitHubMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GitHubMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GitHubMultiError) AllErrors() []error { return m }

// GitHubValidationError is the validation error returned by GitHub.Validate if
// the designated constraints aren't met.
type GitHubValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GitHubValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GitHubValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GitHubValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GitHubValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GitHubValidationError) ErrorName() string { return "GitHubValidationError" }

// Error satisfies the builtin error interface
func (e GitHubValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGitHub.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GitHubValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GitHubValidationError{}

// Validate checks the field values on GitHubExperimental with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *GitHubExperimental) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GitHubExperimental with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// GitHubExperimentalMultiError, or nil if none found.
func (m *GitHubExperimental) ValidateAll() error {
	return m.validate(true)
}

func (m *GitHubExperimental) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Repository

	// no validation rules for ObjectDiscovery

	// no validation rules for CollisionThreshold

	// no validation rules for DeleteCachedData

	switch v := m.Credential.(type) {
	case *GitHubExperimental_Token:
		if v == nil {
			err := GitHubExperimentalValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for Token
	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return GitHubExperimentalMultiError(errors)
	}

	return nil
}

// GitHubExperimentalMultiError is an error wrapping multiple validation errors
// returned by GitHubExperimental.ValidateAll() if the designated constraints
// aren't met.
type GitHubExperimentalMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GitHubExperimentalMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GitHubExperimentalMultiError) AllErrors() []error { return m }

// GitHubExperimentalValidationError is the validation error returned by
// GitHubExperimental.Validate if the designated constraints aren't met.
type GitHubExperimentalValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GitHubExperimentalValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GitHubExperimentalValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GitHubExperimentalValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GitHubExperimentalValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GitHubExperimentalValidationError) ErrorName() string {
	return "GitHubExperimentalValidationError"
}

// Error satisfies the builtin error interface
func (e GitHubExperimentalValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGitHubExperimental.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GitHubExperimentalValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GitHubExperimentalValidationError{}

// Validate checks the field values on GitHubRealtime with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *GitHubRealtime) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GitHubRealtime with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in GitHubRealtimeMultiError,
// or nil if none found.
func (m *GitHubRealtime) ValidateAll() error {
	return m.validate(true)
}

func (m *GitHubRealtime) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for ListenerPort

	// no validation rules for WebhookSecret

	if _, err := url.Parse(m.GetEndpoint()); err != nil {
		err = GitHubRealtimeValidationError{
			field:  "Endpoint",
			reason: "value must be a valid URI",
			cause:  err,
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	switch v := m.Credential.(type) {
	case *GitHubRealtime_GithubApp:
		if v == nil {
			err := GitHubRealtimeValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetGithubApp()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GitHubRealtimeValidationError{
						field:  "GithubApp",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GitHubRealtimeValidationError{
						field:  "GithubApp",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetGithubApp()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GitHubRealtimeValidationError{
					field:  "GithubApp",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *GitHubRealtime_Token:
		if v == nil {
			err := GitHubRealtimeValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for Token
	case *GitHubRealtime_Unauthenticated:
		if v == nil {
			err := GitHubRealtimeValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUnauthenticated()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GitHubRealtimeValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GitHubRealtimeValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUnauthenticated()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GitHubRealtimeValidationError{
					field:  "Unauthenticated",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *GitHubRealtime_BasicAuth:
		if v == nil {
			err := GitHubRealtimeValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetBasicAuth()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GitHubRealtimeValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GitHubRealtimeValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetBasicAuth()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GitHubRealtimeValidationError{
					field:  "BasicAuth",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return GitHubRealtimeMultiError(errors)
	}

	return nil
}

// GitHubRealtimeMultiError is an error wrapping multiple validation errors
// returned by GitHubRealtime.ValidateAll() if the designated constraints
// aren't met.
type GitHubRealtimeMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GitHubRealtimeMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GitHubRealtimeMultiError) AllErrors() []error { return m }

// GitHubRealtimeValidationError is the validation error returned by
// GitHubRealtime.Validate if the designated constraints aren't met.
type GitHubRealtimeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GitHubRealtimeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GitHubRealtimeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GitHubRealtimeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GitHubRealtimeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GitHubRealtimeValidationError) ErrorName() string { return "GitHubRealtimeValidationError" }

// Error satisfies the builtin error interface
func (e GitHubRealtimeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGitHubRealtime.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GitHubRealtimeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GitHubRealtimeValidationError{}

// Validate checks the field values on GoogleDrive with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *GoogleDrive) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GoogleDrive with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in GoogleDriveMultiError, or
// nil if none found.
func (m *GoogleDrive) ValidateAll() error {
	return m.validate(true)
}

func (m *GoogleDrive) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	switch v := m.Credential.(type) {
	case *GoogleDrive_RefreshToken:
		if v == nil {
			err := GoogleDriveValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for RefreshToken
	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return GoogleDriveMultiError(errors)
	}

	return nil
}

// GoogleDriveMultiError is an error wrapping multiple validation errors
// returned by GoogleDrive.ValidateAll() if the designated constraints aren't met.
type GoogleDriveMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GoogleDriveMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GoogleDriveMultiError) AllErrors() []error { return m }

// GoogleDriveValidationError is the validation error returned by
// GoogleDrive.Validate if the designated constraints aren't met.
type GoogleDriveValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GoogleDriveValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GoogleDriveValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GoogleDriveValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GoogleDriveValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GoogleDriveValidationError) ErrorName() string { return "GoogleDriveValidationError" }

// Error satisfies the builtin error interface
func (e GoogleDriveValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGoogleDrive.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GoogleDriveValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GoogleDriveValidationError{}

// Validate checks the field values on Huggingface with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Huggingface) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Huggingface with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in HuggingfaceMultiError, or
// nil if none found.
func (m *Huggingface) ValidateAll() error {
	return m.validate(true)
}

func (m *Huggingface) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, err := url.Parse(m.GetEndpoint()); err != nil {
		err = HuggingfaceValidationError{
			field:  "Endpoint",
			reason: "value must be a valid URI",
			cause:  err,
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for SkipAllModels

	// no validation rules for SkipAllSpaces

	// no validation rules for SkipAllDatasets

	// no validation rules for IncludeDiscussions

	// no validation rules for IncludePrs

	switch v := m.Credential.(type) {
	case *Huggingface_Token:
		if v == nil {
			err := HuggingfaceValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for Token
	case *Huggingface_Unauthenticated:
		if v == nil {
			err := HuggingfaceValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUnauthenticated()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HuggingfaceValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HuggingfaceValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUnauthenticated()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HuggingfaceValidationError{
					field:  "Unauthenticated",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return HuggingfaceMultiError(errors)
	}

	return nil
}

// HuggingfaceMultiError is an error wrapping multiple validation errors
// returned by Huggingface.ValidateAll() if the designated constraints aren't met.
type HuggingfaceMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HuggingfaceMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HuggingfaceMultiError) AllErrors() []error { return m }

// HuggingfaceValidationError is the validation error returned by
// Huggingface.Validate if the designated constraints aren't met.
type HuggingfaceValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HuggingfaceValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HuggingfaceValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HuggingfaceValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HuggingfaceValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HuggingfaceValidationError) ErrorName() string { return "HuggingfaceValidationError" }

// Error satisfies the builtin error interface
func (e HuggingfaceValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHuggingface.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HuggingfaceValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HuggingfaceValidationError{}

// Validate checks the field values on JIRA with the rules defined in the proto
// definition for this message. If any rules are violated, the first error
// encountered is returned, or nil if there are no violations.
func (m *JIRA) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on JIRA with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in JIRAMultiError, or nil if none found.
func (m *JIRA) ValidateAll() error {
	return m.validate(true)
}

func (m *JIRA) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, err := url.Parse(m.GetEndpoint()); err != nil {
		err = JIRAValidationError{
			field:  "Endpoint",
			reason: "value must be a valid URI",
			cause:  err,
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for InsecureSkipVerifyTls

	switch v := m.Credential.(type) {
	case *JIRA_BasicAuth:
		if v == nil {
			err := JIRAValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetBasicAuth()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, JIRAValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, JIRAValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetBasicAuth()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JIRAValidationError{
					field:  "BasicAuth",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *JIRA_Unauthenticated:
		if v == nil {
			err := JIRAValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUnauthenticated()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, JIRAValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, JIRAValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUnauthenticated()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JIRAValidationError{
					field:  "Unauthenticated",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *JIRA_Oauth:
		if v == nil {
			err := JIRAValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetOauth()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, JIRAValidationError{
						field:  "Oauth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, JIRAValidationError{
						field:  "Oauth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetOauth()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JIRAValidationError{
					field:  "Oauth",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *JIRA_Token:
		if v == nil {
			err := JIRAValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for Token
	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return JIRAMultiError(errors)
	}

	return nil
}

// JIRAMultiError is an error wrapping multiple validation errors returned by
// JIRA.ValidateAll() if the designated constraints aren't met.
type JIRAMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m JIRAMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m JIRAMultiError) AllErrors() []error { return m }

// JIRAValidationError is the validation error returned by JIRA.Validate if the
// designated constraints aren't met.
type JIRAValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e JIRAValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e JIRAValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e JIRAValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e JIRAValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e JIRAValidationError) ErrorName() string { return "JIRAValidationError" }

// Error satisfies the builtin error interface
func (e JIRAValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sJIRA.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = JIRAValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = JIRAValidationError{}

// Validate checks the field values on NPMUnauthenticatedPackage with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *NPMUnauthenticatedPackage) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on NPMUnauthenticatedPackage with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// NPMUnauthenticatedPackageMultiError, or nil if none found.
func (m *NPMUnauthenticatedPackage) ValidateAll() error {
	return m.validate(true)
}

func (m *NPMUnauthenticatedPackage) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	switch v := m.Credential.(type) {
	case *NPMUnauthenticatedPackage_Unauthenticated:
		if v == nil {
			err := NPMUnauthenticatedPackageValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUnauthenticated()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, NPMUnauthenticatedPackageValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, NPMUnauthenticatedPackageValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUnauthenticated()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return NPMUnauthenticatedPackageValidationError{
					field:  "Unauthenticated",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return NPMUnauthenticatedPackageMultiError(errors)
	}

	return nil
}

// NPMUnauthenticatedPackageMultiError is an error wrapping multiple validation
// errors returned by NPMUnauthenticatedPackage.ValidateAll() if the
// designated constraints aren't met.
type NPMUnauthenticatedPackageMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m NPMUnauthenticatedPackageMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m NPMUnauthenticatedPackageMultiError) AllErrors() []error { return m }

// NPMUnauthenticatedPackageValidationError is the validation error returned by
// NPMUnauthenticatedPackage.Validate if the designated constraints aren't met.
type NPMUnauthenticatedPackageValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e NPMUnauthenticatedPackageValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e NPMUnauthenticatedPackageValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e NPMUnauthenticatedPackageValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e NPMUnauthenticatedPackageValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e NPMUnauthenticatedPackageValidationError) ErrorName() string {
	return "NPMUnauthenticatedPackageValidationError"
}

// Error satisfies the builtin error interface
func (e NPMUnauthenticatedPackageValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sNPMUnauthenticatedPackage.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = NPMUnauthenticatedPackageValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = NPMUnauthenticatedPackageValidationError{}

// Validate checks the field values on PyPIUnauthenticatedPackage with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *PyPIUnauthenticatedPackage) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PyPIUnauthenticatedPackage with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// PyPIUnauthenticatedPackageMultiError, or nil if none found.
func (m *PyPIUnauthenticatedPackage) ValidateAll() error {
	return m.validate(true)
}

func (m *PyPIUnauthenticatedPackage) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	switch v := m.Credential.(type) {
	case *PyPIUnauthenticatedPackage_Unauthenticated:
		if v == nil {
			err := PyPIUnauthenticatedPackageValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUnauthenticated()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, PyPIUnauthenticatedPackageValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, PyPIUnauthenticatedPackageValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUnauthenticated()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return PyPIUnauthenticatedPackageValidationError{
					field:  "Unauthenticated",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return PyPIUnauthenticatedPackageMultiError(errors)
	}

	return nil
}

// PyPIUnauthenticatedPackageMultiError is an error wrapping multiple
// validation errors returned by PyPIUnauthenticatedPackage.ValidateAll() if
// the designated constraints aren't met.
type PyPIUnauthenticatedPackageMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PyPIUnauthenticatedPackageMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PyPIUnauthenticatedPackageMultiError) AllErrors() []error { return m }

// PyPIUnauthenticatedPackageValidationError is the validation error returned
// by PyPIUnauthenticatedPackage.Validate if the designated constraints aren't met.
type PyPIUnauthenticatedPackageValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PyPIUnauthenticatedPackageValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PyPIUnauthenticatedPackageValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PyPIUnauthenticatedPackageValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PyPIUnauthenticatedPackageValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PyPIUnauthenticatedPackageValidationError) ErrorName() string {
	return "PyPIUnauthenticatedPackageValidationError"
}

// Error satisfies the builtin error interface
func (e PyPIUnauthenticatedPackageValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPyPIUnauthenticatedPackage.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PyPIUnauthenticatedPackageValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PyPIUnauthenticatedPackageValidationError{}

// Validate checks the field values on S3 with the rules defined in the proto
// definition for this message. If any rules are violated, the first error
// encountered is returned, or nil if there are no violations.
func (m *S3) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on S3 with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in S3MultiError, or nil if none found.
func (m *S3) ValidateAll() error {
	return m.validate(true)
}

func (m *S3) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for MaxObjectSize

	// no validation rules for EnableResumption

	switch v := m.Credential.(type) {
	case *S3_AccessKey:
		if v == nil {
			err := S3ValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetAccessKey()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, S3ValidationError{
						field:  "AccessKey",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, S3ValidationError{
						field:  "AccessKey",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetAccessKey()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return S3ValidationError{
					field:  "AccessKey",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *S3_Unauthenticated:
		if v == nil {
			err := S3ValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUnauthenticated()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, S3ValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, S3ValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUnauthenticated()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return S3ValidationError{
					field:  "Unauthenticated",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *S3_CloudEnvironment:
		if v == nil {
			err := S3ValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetCloudEnvironment()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, S3ValidationError{
						field:  "CloudEnvironment",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, S3ValidationError{
						field:  "CloudEnvironment",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetCloudEnvironment()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return S3ValidationError{
					field:  "CloudEnvironment",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *S3_SessionToken:
		if v == nil {
			err := S3ValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetSessionToken()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, S3ValidationError{
						field:  "SessionToken",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, S3ValidationError{
						field:  "SessionToken",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetSessionToken()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return S3ValidationError{
					field:  "SessionToken",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return S3MultiError(errors)
	}

	return nil
}

// S3MultiError is an error wrapping multiple validation errors returned by
// S3.ValidateAll() if the designated constraints aren't met.
type S3MultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m S3MultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m S3MultiError) AllErrors() []error { return m }

// S3ValidationError is the validation error returned by S3.Validate if the
// designated constraints aren't met.
type S3ValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e S3ValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e S3ValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e S3ValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e S3ValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e S3ValidationError) ErrorName() string { return "S3ValidationError" }

// Error satisfies the builtin error interface
func (e S3ValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sS3.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = S3ValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = S3ValidationError{}

// Validate checks the field values on Slack with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Slack) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Slack with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in SlackMultiError, or nil if none found.
func (m *Slack) ValidateAll() error {
	return m.validate(true)
}

func (m *Slack) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, err := url.Parse(m.GetEndpoint()); err != nil {
		err = SlackValidationError{
			field:  "Endpoint",
			reason: "value must be a valid URI",
			cause:  err,
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	switch v := m.Credential.(type) {
	case *Slack_Token:
		if v == nil {
			err := SlackValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for Token
	case *Slack_Tokens:
		if v == nil {
			err := SlackValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetTokens()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, SlackValidationError{
						field:  "Tokens",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, SlackValidationError{
						field:  "Tokens",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetTokens()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return SlackValidationError{
					field:  "Tokens",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return SlackMultiError(errors)
	}

	return nil
}

// SlackMultiError is an error wrapping multiple validation errors returned by
// Slack.ValidateAll() if the designated constraints aren't met.
type SlackMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SlackMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SlackMultiError) AllErrors() []error { return m }

// SlackValidationError is the validation error returned by Slack.Validate if
// the designated constraints aren't met.
type SlackValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SlackValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SlackValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SlackValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SlackValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SlackValidationError) ErrorName() string { return "SlackValidationError" }

// Error satisfies the builtin error interface
func (e SlackValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSlack.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SlackValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SlackValidationError{}

// Validate checks the field values on Test with the rules defined in the proto
// definition for this message. If any rules are violated, the first error
// encountered is returned, or nil if there are no violations.
func (m *Test) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Test with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in TestMultiError, or nil if none found.
func (m *Test) ValidateAll() error {
	return m.validate(true)
}

func (m *Test) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return TestMultiError(errors)
	}

	return nil
}

// TestMultiError is an error wrapping multiple validation errors returned by
// Test.ValidateAll() if the designated constraints aren't met.
type TestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TestMultiError) AllErrors() []error { return m }

// TestValidationError is the validation error returned by Test.Validate if the
// designated constraints aren't met.
type TestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TestValidationError) ErrorName() string { return "TestValidationError" }

// Error satisfies the builtin error interface
func (e TestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TestValidationError{}

// Validate checks the field values on Buildkite with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Buildkite) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Buildkite with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in BuildkiteMultiError, or nil
// if none found.
func (m *Buildkite) ValidateAll() error {
	return m.validate(true)
}

func (m *Buildkite) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	switch v := m.Credential.(type) {
	case *Buildkite_Token:
		if v == nil {
			err := BuildkiteValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for Token
	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return BuildkiteMultiError(errors)
	}

	return nil
}

// BuildkiteMultiError is an error wrapping multiple validation errors returned
// by Buildkite.ValidateAll() if the designated constraints aren't met.
type BuildkiteMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BuildkiteMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BuildkiteMultiError) AllErrors() []error { return m }

// BuildkiteValidationError is the validation error returned by
// Buildkite.Validate if the designated constraints aren't met.
type BuildkiteValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BuildkiteValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BuildkiteValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BuildkiteValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BuildkiteValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BuildkiteValidationError) ErrorName() string { return "BuildkiteValidationError" }

// Error satisfies the builtin error interface
func (e BuildkiteValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBuildkite.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BuildkiteValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BuildkiteValidationError{}

// Validate checks the field values on Gerrit with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Gerrit) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Gerrit with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in GerritMultiError, or nil if none found.
func (m *Gerrit) ValidateAll() error {
	return m.validate(true)
}

func (m *Gerrit) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, err := url.Parse(m.GetEndpoint()); err != nil {
		err = GerritValidationError{
			field:  "Endpoint",
			reason: "value must be a valid URI",
			cause:  err,
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for SkipBinaries

	// no validation rules for SkipArchives

	switch v := m.Credential.(type) {
	case *Gerrit_BasicAuth:
		if v == nil {
			err := GerritValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetBasicAuth()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GerritValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GerritValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetBasicAuth()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GerritValidationError{
					field:  "BasicAuth",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Gerrit_Unauthenticated:
		if v == nil {
			err := GerritValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUnauthenticated()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GerritValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GerritValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUnauthenticated()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GerritValidationError{
					field:  "Unauthenticated",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return GerritMultiError(errors)
	}

	return nil
}

// GerritMultiError is an error wrapping multiple validation errors returned by
// Gerrit.ValidateAll() if the designated constraints aren't met.
type GerritMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GerritMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GerritMultiError) AllErrors() []error { return m }

// GerritValidationError is the validation error returned by Gerrit.Validate if
// the designated constraints aren't met.
type GerritValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GerritValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GerritValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GerritValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GerritValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GerritValidationError) ErrorName() string { return "GerritValidationError" }

// Error satisfies the builtin error interface
func (e GerritValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGerrit.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GerritValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GerritValidationError{}

// Validate checks the field values on Jenkins with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Jenkins) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Jenkins with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in JenkinsMultiError, or nil if none found.
func (m *Jenkins) ValidateAll() error {
	return m.validate(true)
}

func (m *Jenkins) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, err := url.Parse(m.GetEndpoint()); err != nil {
		err = JenkinsValidationError{
			field:  "Endpoint",
			reason: "value must be a valid URI",
			cause:  err,
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for InsecureSkipVerifyTls

	switch v := m.Credential.(type) {
	case *Jenkins_BasicAuth:
		if v == nil {
			err := JenkinsValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetBasicAuth()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, JenkinsValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, JenkinsValidationError{
						field:  "BasicAuth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetBasicAuth()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JenkinsValidationError{
					field:  "BasicAuth",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Jenkins_Header:
		if v == nil {
			err := JenkinsValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetHeader()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, JenkinsValidationError{
						field:  "Header",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, JenkinsValidationError{
						field:  "Header",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetHeader()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JenkinsValidationError{
					field:  "Header",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Jenkins_Unauthenticated:
		if v == nil {
			err := JenkinsValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUnauthenticated()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, JenkinsValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, JenkinsValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUnauthenticated()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JenkinsValidationError{
					field:  "Unauthenticated",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return JenkinsMultiError(errors)
	}

	return nil
}

// JenkinsMultiError is an error wrapping multiple validation errors returned
// by Jenkins.ValidateAll() if the designated constraints aren't met.
type JenkinsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m JenkinsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m JenkinsMultiError) AllErrors() []error { return m }

// JenkinsValidationError is the validation error returned by Jenkins.Validate
// if the designated constraints aren't met.
type JenkinsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e JenkinsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e JenkinsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e JenkinsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e JenkinsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e JenkinsValidationError) ErrorName() string { return "JenkinsValidationError" }

// Error satisfies the builtin error interface
func (e JenkinsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sJenkins.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = JenkinsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = JenkinsValidationError{}

// Validate checks the field values on Teams with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Teams) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Teams with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in TeamsMultiError, or nil if none found.
func (m *Teams) ValidateAll() error {
	return m.validate(true)
}

func (m *Teams) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, err := url.Parse(m.GetEndpoint()); err != nil {
		err = TeamsValidationError{
			field:  "Endpoint",
			reason: "value must be a valid URI",
			cause:  err,
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for TenantId

	switch v := m.Credential.(type) {
	case *Teams_Token:
		if v == nil {
			err := TeamsValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for Token
	case *Teams_Authenticated:
		if v == nil {
			err := TeamsValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetAuthenticated()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, TeamsValidationError{
						field:  "Authenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, TeamsValidationError{
						field:  "Authenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetAuthenticated()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return TeamsValidationError{
					field:  "Authenticated",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Teams_Oauth:
		if v == nil {
			err := TeamsValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetOauth()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, TeamsValidationError{
						field:  "Oauth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, TeamsValidationError{
						field:  "Oauth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetOauth()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return TeamsValidationError{
					field:  "Oauth",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return TeamsMultiError(errors)
	}

	return nil
}

// TeamsMultiError is an error wrapping multiple validation errors returned by
// Teams.ValidateAll() if the designated constraints aren't met.
type TeamsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TeamsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TeamsMultiError) AllErrors() []error { return m }

// TeamsValidationError is the validation error returned by Teams.Validate if
// the designated constraints aren't met.
type TeamsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TeamsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TeamsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TeamsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TeamsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TeamsValidationError) ErrorName() string { return "TeamsValidationError" }

// Error satisfies the builtin error interface
func (e TeamsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTeams.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TeamsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TeamsValidationError{}

// Validate checks the field values on Syslog with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Syslog) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Syslog with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in SyslogMultiError, or nil if none found.
func (m *Syslog) ValidateAll() error {
	return m.validate(true)
}

func (m *Syslog) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Protocol

	// no validation rules for ListenAddress

	// no validation rules for TlsCert

	// no validation rules for TlsKey

	// no validation rules for Format

	if len(errors) > 0 {
		return SyslogMultiError(errors)
	}

	return nil
}

// SyslogMultiError is an error wrapping multiple validation errors returned by
// Syslog.ValidateAll() if the designated constraints aren't met.
type SyslogMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SyslogMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SyslogMultiError) AllErrors() []error { return m }

// SyslogValidationError is the validation error returned by Syslog.Validate if
// the designated constraints aren't met.
type SyslogValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SyslogValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SyslogValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SyslogValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SyslogValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SyslogValidationError) ErrorName() string { return "SyslogValidationError" }

// Error satisfies the builtin error interface
func (e SyslogValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSyslog.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SyslogValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SyslogValidationError{}

// Validate checks the field values on Forager with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Forager) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Forager with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in ForagerMultiError, or nil if none found.
func (m *Forager) ValidateAll() error {
	return m.validate(true)
}

func (m *Forager) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for MaxDepth

	if all {
		switch v := interface{}(m.GetSince()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ForagerValidationError{
					field:  "Since",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ForagerValidationError{
					field:  "Since",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSince()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ForagerValidationError{
				field:  "Since",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	switch v := m.Credential.(type) {
	case *Forager_Unauthenticated:
		if v == nil {
			err := ForagerValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUnauthenticated()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ForagerValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ForagerValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUnauthenticated()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ForagerValidationError{
					field:  "Unauthenticated",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return ForagerMultiError(errors)
	}

	return nil
}

// ForagerMultiError is an error wrapping multiple validation errors returned
// by Forager.ValidateAll() if the designated constraints aren't met.
type ForagerMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ForagerMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ForagerMultiError) AllErrors() []error { return m }

// ForagerValidationError is the validation error returned by Forager.Validate
// if the designated constraints aren't met.
type ForagerValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ForagerValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ForagerValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ForagerValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ForagerValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ForagerValidationError) ErrorName() string { return "ForagerValidationError" }

// Error satisfies the builtin error interface
func (e ForagerValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sForager.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ForagerValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ForagerValidationError{}

// Validate checks the field values on SlackRealtime with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *SlackRealtime) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on SlackRealtime with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in SlackRealtimeMultiError, or
// nil if none found.
func (m *SlackRealtime) ValidateAll() error {
	return m.validate(true)
}

func (m *SlackRealtime) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	switch v := m.Credential.(type) {
	case *SlackRealtime_Tokens:
		if v == nil {
			err := SlackRealtimeValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetTokens()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, SlackRealtimeValidationError{
						field:  "Tokens",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, SlackRealtimeValidationError{
						field:  "Tokens",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetTokens()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return SlackRealtimeValidationError{
					field:  "Tokens",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return SlackRealtimeMultiError(errors)
	}

	return nil
}

// SlackRealtimeMultiError is an error wrapping multiple validation errors
// returned by SlackRealtime.ValidateAll() if the designated constraints
// aren't met.
type SlackRealtimeMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SlackRealtimeMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SlackRealtimeMultiError) AllErrors() []error { return m }

// SlackRealtimeValidationError is the validation error returned by
// SlackRealtime.Validate if the designated constraints aren't met.
type SlackRealtimeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SlackRealtimeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SlackRealtimeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SlackRealtimeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SlackRealtimeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SlackRealtimeValidationError) ErrorName() string { return "SlackRealtimeValidationError" }

// Error satisfies the builtin error interface
func (e SlackRealtimeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSlackRealtime.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SlackRealtimeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SlackRealtimeValidationError{}

// Validate checks the field values on Sharepoint with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Sharepoint) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Sharepoint with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in SharepointMultiError, or
// nil if none found.
func (m *Sharepoint) ValidateAll() error {
	return m.validate(true)
}

func (m *Sharepoint) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SiteUrl

	switch v := m.Credential.(type) {
	case *Sharepoint_Oauth:
		if v == nil {
			err := SharepointValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetOauth()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, SharepointValidationError{
						field:  "Oauth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, SharepointValidationError{
						field:  "Oauth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetOauth()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return SharepointValidationError{
					field:  "Oauth",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return SharepointMultiError(errors)
	}

	return nil
}

// SharepointMultiError is an error wrapping multiple validation errors
// returned by Sharepoint.ValidateAll() if the designated constraints aren't met.
type SharepointMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SharepointMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SharepointMultiError) AllErrors() []error { return m }

// SharepointValidationError is the validation error returned by
// Sharepoint.Validate if the designated constraints aren't met.
type SharepointValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SharepointValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SharepointValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SharepointValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SharepointValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SharepointValidationError) ErrorName() string { return "SharepointValidationError" }

// Error satisfies the builtin error interface
func (e SharepointValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSharepoint.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SharepointValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SharepointValidationError{}

// Validate checks the field values on AzureRepos with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *AzureRepos) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AzureRepos with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in AzureReposMultiError, or
// nil if none found.
func (m *AzureRepos) ValidateAll() error {
	return m.validate(true)
}

func (m *AzureRepos) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, err := url.Parse(m.GetEndpoint()); err != nil {
		err = AzureReposValidationError{
			field:  "Endpoint",
			reason: "value must be a valid URI",
			cause:  err,
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for IncludeForks

	// no validation rules for SkipBinaries

	// no validation rules for SkipArchives

	switch v := m.Credential.(type) {
	case *AzureRepos_Token:
		if v == nil {
			err := AzureReposValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for Token
	case *AzureRepos_Oauth:
		if v == nil {
			err := AzureReposValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetOauth()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, AzureReposValidationError{
						field:  "Oauth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, AzureReposValidationError{
						field:  "Oauth",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetOauth()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AzureReposValidationError{
					field:  "Oauth",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return AzureReposMultiError(errors)
	}

	return nil
}

// AzureReposMultiError is an error wrapping multiple validation errors
// returned by AzureRepos.ValidateAll() if the designated constraints aren't met.
type AzureReposMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AzureReposMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AzureReposMultiError) AllErrors() []error { return m }

// AzureReposValidationError is the validation error returned by
// AzureRepos.Validate if the designated constraints aren't met.
type AzureReposValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AzureReposValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AzureReposValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AzureReposValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AzureReposValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AzureReposValidationError) ErrorName() string { return "AzureReposValidationError" }

// Error satisfies the builtin error interface
func (e AzureReposValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAzureRepos.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AzureReposValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AzureReposValidationError{}

// Validate checks the field values on Postman with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Postman) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Postman with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in PostmanMultiError, or nil if none found.
func (m *Postman) ValidateAll() error {
	return m.validate(true)
}

func (m *Postman) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	switch v := m.Credential.(type) {
	case *Postman_Unauthenticated:
		if v == nil {
			err := PostmanValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUnauthenticated()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, PostmanValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, PostmanValidationError{
						field:  "Unauthenticated",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUnauthenticated()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return PostmanValidationError{
					field:  "Unauthenticated",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Postman_Token:
		if v == nil {
			err := PostmanValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for Token
	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return PostmanMultiError(errors)
	}

	return nil
}

// PostmanMultiError is an error wrapping multiple validation errors returned
// by Postman.ValidateAll() if the designated constraints aren't met.
type PostmanMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PostmanMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PostmanMultiError) AllErrors() []error { return m }

// PostmanValidationError is the validation error returned by Postman.Validate
// if the designated constraints aren't met.
type PostmanValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PostmanValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PostmanValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PostmanValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PostmanValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PostmanValidationError) ErrorName() string { return "PostmanValidationError" }

// Error satisfies the builtin error interface
func (e PostmanValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPostman.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PostmanValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PostmanValidationError{}

// Validate checks the field values on Webhook with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Webhook) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Webhook with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in WebhookMultiError, or nil if none found.
func (m *Webhook) ValidateAll() error {
	return m.validate(true)
}

func (m *Webhook) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if err := m._validateHostname(m.GetListenAddress()); err != nil {
		err = WebhookValidationError{
			field:  "ListenAddress",
			reason: "value must be a valid hostname",
			cause:  err,
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	switch v := m.Credential.(type) {
	case *Webhook_Header:
		if v == nil {
			err := WebhookValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetHeader()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, WebhookValidationError{
						field:  "Header",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, WebhookValidationError{
						field:  "Header",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetHeader()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return WebhookValidationError{
					field:  "Header",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return WebhookMultiError(errors)
	}

	return nil
}

func (m *Webhook) _validateHostname(host string) error {
	s := strings.ToLower(strings.TrimSuffix(host, "."))

	if len(host) > 253 {
		return errors.New("hostname cannot exceed 253 characters")
	}

	for _, part := range strings.Split(s, ".") {
		if l := len(part); l == 0 || l > 63 {
			return errors.New("hostname part must be non-empty and cannot exceed 63 characters")
		}

		if part[0] == '-' {
			return errors.New("hostname parts cannot begin with hyphens")
		}

		if part[len(part)-1] == '-' {
			return errors.New("hostname parts cannot end with hyphens")
		}

		for _, r := range part {
			if (r < 'a' || r > 'z') && (r < '0' || r > '9') && r != '-' {
				return fmt.Errorf("hostname parts can only contain alphanumeric characters or hyphens, got %q", string(r))
			}
		}
	}

	return nil
}

// WebhookMultiError is an error wrapping multiple validation errors returned
// by Webhook.ValidateAll() if the designated constraints aren't met.
type WebhookMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m WebhookMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m WebhookMultiError) AllErrors() []error { return m }

// WebhookValidationError is the validation error returned by Webhook.Validate
// if the designated constraints aren't met.
type WebhookValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e WebhookValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e WebhookValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e WebhookValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e WebhookValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e WebhookValidationError) ErrorName() string { return "WebhookValidationError" }

// Error satisfies the builtin error interface
func (e WebhookValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sWebhook.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = WebhookValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = WebhookValidationError{}

// Validate checks the field values on Elasticsearch with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Elasticsearch) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Elasticsearch with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ElasticsearchMultiError, or
// nil if none found.
func (m *Elasticsearch) ValidateAll() error {
	return m.validate(true)
}

func (m *Elasticsearch) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Username

	// no validation rules for Password

	// no validation rules for CloudId

	// no validation rules for ApiKey

	// no validation rules for ServiceToken

	// no validation rules for IndexPattern

	// no validation rules for QueryJson

	// no validation rules for SinceTimestamp

	// no validation rules for BestEffortScan

	if len(errors) > 0 {
		return ElasticsearchMultiError(errors)
	}

	return nil
}

// ElasticsearchMultiError is an error wrapping multiple validation errors
// returned by Elasticsearch.ValidateAll() if the designated constraints
// aren't met.
type ElasticsearchMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ElasticsearchMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ElasticsearchMultiError) AllErrors() []error { return m }

// ElasticsearchValidationError is the validation error returned by
// Elasticsearch.Validate if the designated constraints aren't met.
type ElasticsearchValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ElasticsearchValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ElasticsearchValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ElasticsearchValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ElasticsearchValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ElasticsearchValidationError) ErrorName() string { return "ElasticsearchValidationError" }

// Error satisfies the builtin error interface
func (e ElasticsearchValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sElasticsearch.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ElasticsearchValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ElasticsearchValidationError{}

// Validate checks the field values on Sentry with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Sentry) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Sentry with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in SentryMultiError, or nil if none found.
func (m *Sentry) ValidateAll() error {
	return m.validate(true)
}

func (m *Sentry) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Endpoint

	// no validation rules for InsecureSkipVerifyTls

	// no validation rules for Projects

	switch v := m.Credential.(type) {
	case *Sentry_AuthToken:
		if v == nil {
			err := SentryValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for AuthToken
	case *Sentry_DsnKey:
		if v == nil {
			err := SentryValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for DsnKey
	case *Sentry_ApiKey:
		if v == nil {
			err := SentryValidationError{
				field:  "Credential",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for ApiKey
	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return SentryMultiError(errors)
	}

	return nil
}

// SentryMultiError is an error wrapping multiple validation errors returned by
// Sentry.ValidateAll() if the designated constraints aren't met.
type SentryMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SentryMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SentryMultiError) AllErrors() []error { return m }

// SentryValidationError is the validation error returned by Sentry.Validate if
// the designated constraints aren't met.
type SentryValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SentryValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SentryValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SentryValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SentryValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SentryValidationError) ErrorName() string { return "SentryValidationError" }

// Error satisfies the builtin error interface
func (e SentryValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSentry.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SentryValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SentryValidationError{}
