// Copyright 2024 Stefan Prodan
// SPDX-License-Identifier: Apache-2.0

package v1alpha1

import (
	"encoding/base64"
	"strings"
)

// ImagePullSecret is a generator for Kubernetes Secrets of type kubernetes.io/dockerconfigjson.
// Spec: https://kubernetes.io/docs/concepts/configuration/secret/#docker-config-secrets.
#ImagePullSecret: {
	// Metadata is the Kubernetes object's metadata generated by Timoni.
	#Meta!: #Metadata

	// Registry is the hostname of the container registry in the format [HOST[:PORT_NUMBER]].
	#Registry!: string

	// Username is the username used to authenticate to the container registry.
	#Username!: string

	// Password is the password used to authenticate to the container registry.
	#Password!: string

	// Optional suffix used to generate the Secret name.
	#Suffix: *"" | string & strings.MaxRunes(30)

	let auth = base64.Encode(null, #Username+":"+#Password)

	apiVersion: "v1"
	kind:       "Secret"
	type:       "kubernetes.io/dockerconfigjson"
	metadata: {
		name:      #Meta.name + #Suffix
		namespace: #Meta.namespace
		labels:    #Meta.labels
		if #Meta.annotations != _|_ {
			annotations: #Meta.annotations
		}
	}
	stringData: {
		".dockerconfigjson": """
			{"auths": {"\(#Registry)": {"username": "\(#Username)","password": "\(#Password)","auth": "\(auth)"}}}
			"""
	}
}
