#!/usr/bin/env bash

set -eu
set -o pipefail

cd "$(dirname "$0")/.."

command_console() {
  echo '```console'
  echo "$ $*"
  "$@"
  echo '```'
}

commands() {
  for cmd in run create-config get-discussion version completion; do
    echo "
## tfmv $cmd

$(command_console tfmv help $cmd)"
  done
}

echo "# Usage

<!-- This is generated by scripts/generate-usage.sh. Don't edit this file directly. -->

$(command_console tfmv help)
$(commands)
" > USAGE.md
