# post_comments

## Description

post and comments View table

<details>
<summary><strong>Table Definition</strong></summary>

```sql
CREATE VIEW post_comments AS (select `c`.`id` AS `id`,`p`.`title` AS `title`,`u2`.`username` AS `post_user`,`c`.`comment` AS `comment`,`u2`.`username` AS `comment_user`,`c`.`created` AS `created`,`c`.`updated` AS `updated` from (((`testdb`.`posts` `p` left join `testdb`.`comments` `c` on((`p`.`id` = `c`.`post_id`))) left join `testdb`.`users` `u` on((`u`.`id` = `p`.`user_id`))) left join `testdb`.`users` `u2` on((`u2`.`id` = `c`.`user_id`))))
```

</details>

## Columns

| Name | Type | Default | Nullable | Children | Parents | Comment |
| ---- | ---- | ------- | -------- | -------- | ------- | ------- |
| id | bigint | 0 | true |  |  | comments.id |
| title | varchar(255) | Untitled | false |  |  | posts.title |
| post_user | varchar(50) |  | true |  |  | posts.users.username |
| comment | text |  | true |  |  | Comment<br>Multi-line<br>column<br>comment |
| comment_user | varchar(50) |  | true |  |  | comments.users.username |
| created | datetime |  | true |  |  | comments.created |
| updated | datetime |  | true |  |  | comments.updated |

## Referenced Tables

| Name | Columns | Comment | Type | Labels |
| ---- | ------- | ------- | ---- | ------ |
| [posts](posts.md) | 7 | Posts table | BASE TABLE | `green` `red` `blue` |
| [comments](comments.md) | 7 | Comments<br>Multi-line<br>table<br>comment | BASE TABLE |  |
| [users](users.md) | 6 | Users table | BASE TABLE |  |

## Relations

```mermaid
erDiagram


"post_comments" {
  bigint id
  varchar_255_ title
  varchar_50_ post_user
  text comment
  varchar_50_ comment_user
  datetime created
  datetime updated
}
```

---

> Generated by [tbls](https://github.com/k1LoW/tbls)
