-- ref: https://docs.snowflake.com/en/user-guide/sample-data-tpch.html#database-entities-relationships-and-characteristics
CREATE OR REPLACE SCHEMA TPCH_SF1;
USE SCHEMA TPCH_SF1;

CREATE OR REPLACE TABLE CUSTOMER (
  C_CUSTKEY	NUMBER(38,0) NOT NULL
  , C_NAME	VARCHAR(25) NOT NULL
  , C_ADDRESS	VARCHAR(40) NOT NULL
  , C_NATIONKEY	NUMBER(38,0) NOT NULL
  , C_PHONE	VARCHAR(15) NOT NULL
  , C_ACCTBAL	NUMBER(12,2) NOT NULL
  , C_MKTSEGMENT	VARCHAR(10)
  , C_COMMENT	VARCHAR(117)
);

CREATE OR REPLACE TABLE LINEITEM (
  L_ORDERKEY	NUMBER(38,0) NOT NULL
  , L_PARTKEY	NUMBER(38,0) NOT NULL
  , L_SUPPKEY	NUMBER(38,0) NOT NULL
  , L_LINENUMBER	NUMBER(38,0) NOT NULL
  , L_QUANTITY	NUMBER(12,2) NOT NULL
  , L_EXTENDEDPRICE	NUMBER(12,2) NOT NULL
  , L_DISCOUNT	NUMBER(12,2) NOT NULL
  , L_TAX	NUMBER(12,2) NOT NULL
  , L_RETURNFLAG	VARCHAR(1) NOT NULL
  , L_LINESTATUS	VARCHAR(1) NOT NULL
  , L_SHIPDATE	DATE NOT NULL
  , L_COMMITDATE	DATE NOT NULL
  , L_RECEIPTDATE	DATE NOT NULL
  , L_SHIPINSTRUCT	VARCHAR(25) NOT NULL
  , L_SHIPMODE	VARCHAR(10) NOT NULL
  , L_COMMENT	VARCHAR(44) NOT NULL
);

CREATE OR REPLACE TABLE NATION (
  N_NATIONKEY	NUMBER(38,0) NOT NULL
  , N_NAME	VARCHAR(25) NOT NULL
  , N_REGIONKEY	NUMBER(38,0) NOT NULL
  , N_COMMENT	VARCHAR(152)
);

CREATE OR REPLACE TABLE ORDERS (
  O_ORDERKEY	NUMBER(38,0) NOT NULL
  , O_CUSTKEY	NUMBER(38,0) NOT NULL
  , O_ORDERSTATUS	VARCHAR(1) NOT NULL
  , O_TOTALPRICE	NUMBER(12,2) NOT NULL
  , O_ORDERDATE	DATE NOT NULL
  , O_ORDERPRIORITY	VARCHAR(15) NOT NULL
  , O_CLERK	VARCHAR(15) NOT NULL
  , O_SHIPPRIORITY	NUMBER(38,0) NOT NULL
  , O_COMMENT	VARCHAR(79) NOT NULL
);

CREATE OR REPLACE TABLE PART (
  P_PARTKEY	NUMBER(38,0) NOT NULL
  , P_NAME	VARCHAR(55) NOT NULL
  , P_MFGR	VARCHAR(25) NOT NULL
  , P_BRAND	VARCHAR(10) NOT NULL
  , P_TYPE	VARCHAR(25) NOT NULL
  , P_SIZE	NUMBER(38,0) NOT NULL
  , P_CONTAINER	VARCHAR(10) NOT NULL
  , P_RETAILPRICE	NUMBER(12,2) NOT NULL
  , P_COMMENT	VARCHAR(23)
);

CREATE OR REPLACE TABLE PARTSUPP (
  PS_PARTKEY	NUMBER(38,0) NOT NULL
  , PS_SUPPKEY	NUMBER(38,0) NOT NULL
  , PS_AVAILQTY	NUMBER(38,0) NOT NULL
  , PS_SUPPLYCOST	NUMBER(12,2) NOT NULL
  , PS_COMMENT	VARCHAR(199)
);

CREATE OR REPLACE TABLE REGION (
  R_REGIONKEY	NUMBER(38,0) NOT NULL
  , R_NAME	VARCHAR(25) NOT NULL
  , R_COMMENT	VARCHAR(152)
);

CREATE OR REPLACE TABLE SUPPLIER (
  S_SUPPKEY	NUMBER(38,0) NOT NULL
  , S_NAME	VARCHAR(25) NOT NULL
  , S_ADDRESS	VARCHAR(40) NOT NULL
  , S_NATIONKEY	NUMBER(38,0) NOT NULL
  , S_PHONE	VARCHAR(15) NOT NULL
  , S_ACCTBAL	NUMBER(12,2) NOT NULL
  , S_COMMENT	VARCHAR(101)
);
