// Code generated by github.com/abhimanyu003/sttr/cmd/generate.go. DO NOT EDIT

package cmd

import (
	"fmt"
	"os"

	"github.com/abhimanyu003/sttr/processors"
	"github.com/abhimanyu003/sttr/utils"
	"github.com/spf13/cobra"
)

var jsonUnescape_flag_i bool

func init() {	
	jsonUnescapeCmd.Flags().BoolVarP(&jsonUnescape_flag_i, "indent", "i", false, "Indent the output (prettyprint)")
	rootCmd.AddCommand(jsonUnescapeCmd)
}

var jsonUnescapeCmd = &cobra.Command{
	Use:     "json-unescape [string]",
	Short:   "JSON Unescape",
	Aliases: []string{"json-unesc"},
	Args:    cobra.MaximumNArgs(1),
	RunE: func(cmd *cobra.Command, args []string) error {
		var err error
		var in []byte
		var out string

		if len(args) == 0 {
			in = []byte(utils.ReadMultilineInput())
		} else {
			if fi, err := os.Stat(args[0]); err == nil && !fi.IsDir() {
				d, err := os.ReadFile(args[0])
				if err != nil {
					return err
				}
				in = d
			} else {
				in = []byte(args[0])
			}
		}

		flags := make([]processors.Flag, 0)
		p := processors.JSONUnescape{}
		flags = append(flags, processors.Flag{Short: "i", Value: jsonUnescape_flag_i})

		out, err = p.Transform(in, flags...)
		if err != nil {
			return err
		}

		_, err = fmt.Fprint(os.Stdout, out)
		return err
	},
}
