# sqlc: A SQL Compiler

![go](https://github.com/sqlc-dev/sqlc/workflows/go/badge.svg)
[![Go Report Card](https://goreportcard.com/badge/github.com/sqlc-dev/sqlc)](https://goreportcard.com/report/github.com/sqlc-dev/sqlc)

sqlc generates **type-safe code** from SQL. Here's how it works:

1. You write queries in SQL.
1. You run sqlc to generate code with type-safe interfaces to those queries.
1. You write application code that calls the generated code.

Check out [an interactive example](https://play.sqlc.dev/) to see it in action, and the [introductory blog post](https://conroy.org/introducing-sqlc) for the motivation behind sqlc.

## Overview

- [Documentation](https://docs.sqlc.dev)
- [Installation](https://docs.sqlc.dev/en/latest/overview/install.html)
- [Playground](https://play.sqlc.dev)
- [Website](https://sqlc.dev)
- [Downloads](https://downloads.sqlc.dev/)
- [Community](https://discord.gg/EcXzGe5SEs)

## Supported languages

- [sqlc-gen-go](https://github.com/sqlc-dev/sqlc-gen-go)
- [sqlc-gen-kotlin](https://github.com/sqlc-dev/sqlc-gen-kotlin)
- [sqlc-gen-python](https://github.com/sqlc-dev/sqlc-gen-python)
- [sqlc-gen-typescript](https://github.com/sqlc-dev/sqlc-gen-typescript)

Additional languages can be added via [plugins](https://docs.sqlc.dev/en/latest/reference/language-support.html#community-language-support).

## Sponsors

Development is possible thanks to our sponsors. If you would like to support sqlc,
please consider [sponsoring on GitHub](https://github.com/sponsors/kyleconroy).

<p align="center">
  <a href="https://riza.io?utm_source=sqlc+readme"><img width=400 src="https://sqlc.dev/sponsors/riza-readme.png" alt="Riza.io"></a>
</p>

<p align="center">
  <a href="https://coder.com?utm_source=sqlc+readme"><img width=200 src="https://sqlc.dev/sponsors/coder-readme.png" alt="Coder.com" /></a>
  <a href="https://mint.fun?utm_source=sqlc+readme"><img width=200 src="https://sqlc.dev/sponsors/mint-readme.png" alt="Mint.fun" /></a>
  <a href="https://mux.com?utm_source=sqlc+readme"><img width=200 src="https://sqlc.dev/sponsors/mux-readme.png" alt="Mux.com" /></a>
</p>

<p align="center">
  <a href="https://github.com/Cyberax">Cyberax</a> - 
  <a href="https://github.com/NaNuNaNu">NaNuNaNu</a> - 
  <a href="https://github.com/Stumble">Stumble</a> - 
  <a href="https://github.com/WestfalNamur">WestfalNamur</a> - 
  <a href="https://github.com/alecthomas">alecthomas</a> - 
  <a href="https://github.com/cameronnewman">cameronnewman</a> - 
  <a href="https://github.com/danielbprice">danielbprice</a> - 
  <a href="https://github.com/davherrmann">davherrmann</a> - 
  <a href="https://github.com/dvob">dvob</a> - 
  <a href="https://github.com/gilcrest">gilcrest</a> - 
  <a href="https://github.com/gzuidhof">gzuidhof</a> - 
  <a href="https://github.com/jeffreylo">jeffreylo</a> - 
  <a href="https://github.com/mmcloughlin">mmcloughlin</a> - 
  <a href="https://github.com/ryohei1216">ryohei1216</a> - 
  <a href="https://github.com/sgielen">sgielen</a>
</p>
