	// Code generated by enum generator; DO NOT EDIT.
package enum

import (
	"fmt"

	"database/sql/driver"
	"strings"
)

// HashAlg is the exported type for the enum
type HashAlg struct {
	name  string
	value int
}

func (e HashAlg) String() string { return e.name }

// MarshalText implements encoding.TextMarshaler
func (e HashAlg) MarshalText() ([]byte, error) {
	return []byte(e.name), nil
}

// UnmarshalText implements encoding.TextUnmarshaler
func (e *HashAlg) UnmarshalText(text []byte) error {
	var err error
	*e, err = ParseHashAlg(string(text))
	return err
}

// Value implements the driver.Valuer interface
func (e HashAlg) Value() (driver.Value, error) {
	return e.name, nil
}

// Scan implements the sql.Scanner interface
func (e *HashAlg) Scan(value interface{}) error {
	if value == nil {
		*e = HashAlgValues()[0]
		return nil
	}

	str, ok := value.(string)
	if !ok {
		if b, ok := value.([]byte); ok {
			str = string(b)
		} else {
			return fmt.Errorf("invalid hashAlg value: %v", value)
		}
	}

	val, err := ParseHashAlg(str)
	if err != nil {
		return err
	}

	*e = val
	return nil
}

// ParseHashAlg converts string to hashAlg enum value
func ParseHashAlg(v string) (HashAlg, error) {

	switch strings.ToLower(v) {
	case strings.ToLower("MD5"):
		return HashAlgMD5, nil
	case strings.ToLower("SHA1"):
		return HashAlgSHA1, nil
	case strings.ToLower("SHA224"):
		return HashAlgSHA224, nil
	case strings.ToLower("SHA256"):
		return HashAlgSHA256, nil
	case strings.ToLower("SHA384"):
		return HashAlgSHA384, nil
	case strings.ToLower("SHA512"):
		return HashAlgSHA512, nil
	case strings.ToLower("SHA512_224"):
		return HashAlgSHA512_224, nil
	case strings.ToLower("SHA512_256"):
		return HashAlgSHA512_256, nil

	}

	return HashAlg{}, fmt.Errorf("invalid hashAlg: %s", v)
}

// MustHashAlg is like ParseHashAlg but panics if string is invalid
func MustHashAlg(v string) HashAlg {
	r, err := ParseHashAlg(v)
	if err != nil {
		panic(err)
	}
	return r
}

// Public constants for hashAlg values
var (
	HashAlgMD5        = HashAlg{name: "MD5", value: 0}
	HashAlgSHA1       = HashAlg{name: "SHA1", value: 1}
	HashAlgSHA224     = HashAlg{name: "SHA224", value: 3}
	HashAlgSHA256     = HashAlg{name: "SHA256", value: 2}
	HashAlgSHA384     = HashAlg{name: "SHA384", value: 4}
	HashAlgSHA512     = HashAlg{name: "SHA512", value: 5}
	HashAlgSHA512_224 = HashAlg{name: "SHA512_224", value: 6}
	HashAlgSHA512_256 = HashAlg{name: "SHA512_256", value: 7}
)

// HashAlgValues returns all possible enum values
func HashAlgValues() []HashAlg {
	return []HashAlg{
		HashAlgMD5,
		HashAlgSHA1,
		HashAlgSHA224,
		HashAlgSHA256,
		HashAlgSHA384,
		HashAlgSHA512,
		HashAlgSHA512_224,
		HashAlgSHA512_256,
	}
}

// HashAlgNames returns all possible enum names
func HashAlgNames() []string {
	return []string{
		"MD5",
		"SHA1",
		"SHA224",
		"SHA256",
		"SHA384",
		"SHA512",
		"SHA512_224",
		"SHA512_256",
	}
}
