<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw rdb`
This API allows you to manage your Managed Databases for PostgreSQL and MySQL.
  
- [Access Control List (ACL) management commands](#access-control-list-(acl)-management-commands)
  - [Add an ACL rule to a Database Instance](#add-an-acl-rule-to-a-database-instance)
  - [Delete ACL rules of a Database Instance](#delete-acl-rules-of-a-database-instance)
  - [Edit a database instance's ACL](#edit-a-database-instance's-acl)
  - [List ACL rules of a Database Instance](#list-acl-rules-of-a-database-instance)
  - [Set ACL rules for a Database Instance](#set-acl-rules-for-a-database-instance)
- [Backup management commands](#backup-management-commands)
  - [Create a database backup](#create-a-database-backup)
  - [Delete a database backup](#delete-a-database-backup)
  - [Download a backup locally](#download-a-backup-locally)
  - [Export a database backup](#export-a-database-backup)
  - [Get a database backup](#get-a-database-backup)
  - [List database backups](#list-database-backups)
  - [Restore a database backup](#restore-a-database-backup)
  - [Update a database backup](#update-a-database-backup)
  - [Wait for a backup to reach a stable state](#wait-for-a-backup-to-reach-a-stable-state)
- [Database management commands](#database-management-commands)
  - [Create a database in a Database Instance](#create-a-database-in-a-database-instance)
  - [Delete a database in a Database Instance](#delete-a-database-in-a-database-instance)
  - [Gets the URL to connect to the Database](#gets-the-url-to-connect-to-the-database)
  - [List databases in a Database Instance](#list-databases-in-a-database-instance)
- [Endpoint management](#endpoint-management)
  - [Create a new Database Instance endpoint](#create-a-new-database-instance-endpoint)
  - [Delete a Database Instance endpoint](#delete-a-database-instance-endpoint)
  - [Get a Database Instance endpoint](#get-a-database-instance-endpoint)
  - [Lists a Database Instance's endpoints](#lists-a-database-instance's-endpoints)
  - [Migrate an existing instance endpoint to another instance](#migrate-an-existing-instance-endpoint-to-another-instance)
- [Database engines commands](#database-engines-commands)
  - [List available database engines](#list-available-database-engines)
  - [List available settings from an engine.](#list-available-settings-from-an-engine.)
- [Instance management commands](#instance-management-commands)
  - [Clone a Database Instance](#clone-a-database-instance)
  - [Connect to an instance using locally installed CLI](#connect-to-an-instance-using-locally-installed-cli)
  - [Create a Database Instance](#create-a-database-instance)
  - [Delete a Database Instance](#delete-a-database-instance)
  - [Get a Database Instance](#get-a-database-instance)
  - [Get the TLS certificate of a Database Instance](#get-the-tls-certificate-of-a-database-instance)
  - [Get Database Instance metrics](#get-database-instance-metrics)
  - [List Database Instances](#list-database-instances)
  - [Renew the TLS certificate of a Database Instance](#renew-the-tls-certificate-of-a-database-instance)
  - [Restart Database Instance](#restart-database-instance)
  - [Update an instance](#update-an-instance)
  - [Upgrade a Database Instance](#upgrade-a-database-instance)
  - [Wait for an instance to reach a stable state](#wait-for-an-instance-to-reach-a-stable-state)
- [Instance logs management commands](#instance-logs-management-commands)
  - [Get given logs of a Database Instance](#get-given-logs-of-a-database-instance)
  - [List available logs of a Database Instance](#list-available-logs-of-a-database-instance)
  - [List remote Database Instance logs details](#list-remote-database-instance-logs-details)
  - [Prepare logs of a Database Instance](#prepare-logs-of-a-database-instance)
  - [Purge remote Database Instance logs](#purge-remote-database-instance-logs)
- [Node types management commands](#node-types-management-commands)
  - [List available node types](#list-available-node-types)
- [User privileges management commands](#user-privileges-management-commands)
  - [List user privileges for a database](#list-user-privileges-for-a-database)
  - [Set user privileges for a database](#set-user-privileges-for-a-database)
- [Read replica management](#read-replica-management)
  - [Create a Read Replica](#create-a-read-replica)
  - [Create an endpoint for a Read Replica](#create-an-endpoint-for-a-read-replica)
  - [Delete a Read Replica](#delete-a-read-replica)
  - [Get a Read Replica](#get-a-read-replica)
  - [Resync a Read Replica](#resync-a-read-replica)
- [Setting management](#setting-management)
  - [Add Database Instance advanced settings](#add-database-instance-advanced-settings)
  - [Delete Database Instance advanced settings](#delete-database-instance-advanced-settings)
  - [Set Database Instance advanced settings](#set-database-instance-advanced-settings)
- [Block snapshot management](#block-snapshot-management)
  - [Create a Database Instance snapshot](#create-a-database-instance-snapshot)
  - [Delete a Database Instance snapshot](#delete-a-database-instance-snapshot)
  - [Get a Database Instance snapshot](#get-a-database-instance-snapshot)
  - [List snapshots](#list-snapshots)
  - [Create a new Database Instance from a snapshot](#create-a-new-database-instance-from-a-snapshot)
  - [Update a Database Instance snapshot](#update-a-database-instance-snapshot)
- [User management commands](#user-management-commands)
  - [Create a user for a Database Instance](#create-a-user-for-a-database-instance)
  - [Delete a user on a Database Instance](#delete-a-user-on-a-database-instance)
  - [Gets the URL to connect to the Database](#gets-the-url-to-connect-to-the-database)
  - [List users of a Database Instance](#list-users-of-a-database-instance)
  - [Update a user on a Database Instance](#update-a-user-on-a-database-instance)

  
## Access Control List (ACL) management commands

Network Access Control Lists allow you to control incoming network traffic by setting up ACL rules.


### Add an ACL rule to a Database Instance

Add an additional ACL rule to a Database Instance.

**Usage:**

```
scw rdb acl add <acl-rule-ips ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| acl-rule-ips | Required | IP addresses defined in the ACL rules of the Database Instance |
| instance-id | Required | ID of the Database Instance |
| description |  | Description of the ACL rule. Indexes are not yet supported so the description will be applied to all the rules of the command. |
| region | Default: `fr-par` | Region to target. If none is passed will use default region from the config |



### Delete ACL rules of a Database Instance

Delete one or more ACL rules of a Database Instance.

**Usage:**

```
scw rdb acl delete <acl-rule-ips ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| acl-rule-ips | Required | IP addresses defined in the ACL rules of the Database Instance |
| instance-id | Required | ID of the Database Instance |
| region | Default: `fr-par` | Region to target. If none is passed will use default region from the config |



### Edit a database instance's ACL

This command starts your default editor to edit a marshaled version of your resource
Default editor will be taken from $VISUAL, then $EDITOR or an editor based on your system

**Usage:**

```
scw rdb acl edit <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | ID of the Database Instance |
| mode | Default: `yaml`<br />One of: `yaml`, `json` | marshaling used when editing data |
| region | Default: `fr-par` | Region to target. If none is passed will use default region from the config |



### List ACL rules of a Database Instance

List the ACL rules for a given Database Instance. The response is an array of ACL objects, each one representing an ACL that denies, allows or redirects traffic based on certain conditions.

**Usage:**

```
scw rdb acl list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Set ACL rules for a Database Instance

Replace all the ACL rules of a Database Instance.

**Usage:**

```
scw rdb acl set <acl-rule-ips ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| acl-rule-ips |  | IP addresses defined in the ACL rules of the Database Instance |
| instance-id | Required | ID of the Database Instance |
| descriptions |  | Descriptions of the ACL rules |
| region | Default: `fr-par` | Region to target. If none is passed will use default region from the config |



## Backup management commands

A database backup is a dated export of a Database Instance stored on an offsite backend located in a different region than your database, by default. Once a backup is created, it can be used to restore the database. Each logical database in a Database Instance is backed up and can be restored separately.


### Create a database backup

Create a new backup. You must set the `instance_id`, `database_name`, `name` and `expires_at` parameters.

**Usage:**

```
scw rdb backup create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id |  | UUID of the Database Instance |
| database-name |  | Name of the database you want to back up |
| name | Default: `<generated>` | Name of the backup |
| expires-at |  | Expiration date (must follow the ISO 8601 format) |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a database backup

Delete a backup, specified by its database backup ID and region. Deleting a backup is permanent, and cannot be undone.

**Usage:**

```
scw rdb backup delete <database-backup-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| database-backup-id | Required | UUID of the database backup to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Download a backup locally

Download a backup locally.

**Usage:**

```
scw rdb backup download <backup-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| backup-id | Required | ID of the backup you want to download. |
| output |  | Filename to write to |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Download a backup
```
scw rdb backup download 11111111-1111-1111-1111-111111111111
```




### Export a database backup

Export a backup, specified by the `database_backup_id` and the `region` parameters. The download URL is returned in the response.

**Usage:**

```
scw rdb backup export <database-backup-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| database-backup-id | Required | UUID of the database backup you want to export |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a database backup

Retrieve information about a given backup, specified by its database backup ID and region. Full details about the backup, like size, URL and expiration date, are returned in the response.

**Usage:**

```
scw rdb backup get <database-backup-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| database-backup-id | Required | UUID of the database backup |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List database backups

List all backups in a specified region, for a given Scaleway Organization or Scaleway Project. By default, the backups listed are ordered by creation date in ascending order. This can be modified via the `order_by` field.

**Usage:**

```
scw rdb backup list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name |  | Name of the database backups |
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc`, `status_asc`, `status_desc` | Criteria to use when ordering database backups listing |
| instance-id |  | UUID of the Database Instance |
| project-id |  | Project ID of the Project the database backups belong to |
| organization-id |  | Organization ID of the Organization the database backups belong to |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Restore a database backup

Launch the process of restoring database backup. You must specify the `instance_id` of the Database Instance of destination, where the backup will be restored. Note that large database backups can take up to several hours to restore.

**Usage:**

```
scw rdb backup restore <database-backup-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| database-name |  | Defines the destination database to restore into a specified database (the default destination is set to the origin database of the backup) |
| database-backup-id | Required | Backup of a logical database |
| instance-id | Required | Defines the Database Instance where the backup has to be restored |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Update a database backup

Update the parameters of a backup, including name and expiration date.

**Usage:**

```
scw rdb backup update <database-backup-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| database-backup-id | Required | UUID of the database backup to update |
| name |  | Name of the Database Backup |
| expires-at |  | Expiration date (must follow the ISO 8601 format) |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Wait for a backup to reach a stable state

Wait for a backup to reach a stable state. This is similar to using --wait flag.

**Usage:**

```
scw rdb backup wait <backup-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| backup-id | Required | ID of the backup you want to wait for. |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |
| timeout | Default: `20m0s` | Timeout of the wait |


**Examples:**


Wait for a backup to reach a stable state
```
scw rdb backup wait 11111111-1111-1111-1111-111111111111
```




## Database management commands

Databases can be used to store and manage sets of structured information, or data. The interaction between the user and a database is done using a Database Engine, which provides a structured query language to add, modify or delete information from the database.


### Create a database in a Database Instance

Create a new database. You must define the `name` parameter in the request.

**Usage:**

```
scw rdb database create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance where to create the database |
| name |  | Name of the database |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a database in a Database Instance

Delete a given database on a Database Instance. You must specify, in the endpoint, the `region`, `instance_id` and `name` parameters of the database you want to delete.

**Usage:**

```
scw rdb database delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance where to delete the database |
| name | Required | Name of the database to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Gets the URL to connect to the Database

Provides the URL to connect to a Database on an Instance as the given user

**Usage:**

```
scw rdb database get-url <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | ID of the Database Instance |
| user |  | User of the Database |
| db |  | Name of the Database to connect to |



### List databases in a Database Instance

List all databases of a given Database Instance. By default, the databases returned in the list are ordered by creation date in ascending order, though this can be modified via the order_by field. You can define additional parameters for your query, such as `name`, `managed` and `owner`.

**Usage:**

```
scw rdb database list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name |  | Name of the database |
| managed |  | Defines whether or not the database is managed |
| owner |  | User that owns this database |
| order-by | One of: `name_asc`, `name_desc`, `size_asc`, `size_desc` | Criteria to use when ordering database listing |
| instance-id | Required | UUID of the Database Instance to list the databases of |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



## Endpoint management

A point of connection to a Database Instance. The endpoint is associated with an IPv4 address and a port. It contains the information about whether the endpoint is read-write or not. The endpoints always point to the main node of a Database Instance.

All endpoints have TLS enabled. You can use TLS to make your data and your passwords unreadable in transit to anyone but you.

For added security, you can set up ACL rules to restrict access to your endpoint to a set of trusted hosts or networks of your choice.

Load Balancers are used to forward traffic to the right node based on the node state (active/hot standby). The Load Balancers' configuration is set to cut off inactive connections if no TCP traffic is sent within a 6-hour timeframe. We recommend using connection pooling on the application side to renew database connections regularly.


### Create a new Database Instance endpoint

Create a new endpoint for a Database Instance. You can add `load_balancer` and `private_network` specifications to the body of the request.

**Usage:**

```
scw rdb endpoint create <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance to which you want to add an endpoint |
| private-network.private-network-id |  | UUID of the Private Network to be connected to the Database Instance |
| private-network.service-ip |  | Endpoint IPv4 address with a CIDR notation. Refer to the official Scaleway documentation to learn more about IP and subnet limitations. |
| private-network.enable-ipam | Default: `true` | Will configure your Private Network endpoint with Scaleway IPAM service if true |
| load-balancer | Default: `true` | Will configure a public Load-Balancer endpoint |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a Database Instance endpoint

Delete the endpoint of a Database Instance. You must specify the `region` and `endpoint_id` parameters of the endpoint you want to delete. Note that might need to update any environment configurations that point to the deleted endpoint.

**Usage:**

```
scw rdb endpoint delete <endpoint-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance from which you want to delete an endpoint |
| endpoint-id | Required | UUID of the endpoint you want to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a Database Instance endpoint

Retrieve information about a Database Instance endpoint. Full details about the endpoint, like `ip`, `port`, `private_network` and `load_balancer` specifications are returned in the response.

**Usage:**

```
scw rdb endpoint get <endpoint-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| endpoint-id | Required | UUID of the endpoint you want to get |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Lists a Database Instance's endpoints

Lists all public and private endpoints of a Database Instance

**Usage:**

```
scw rdb endpoint list <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | ID of the Database Instance |



### Migrate an existing instance endpoint to another instance

Migrate an existing instance endpoint to another instance.

**Usage:**

```
scw rdb endpoint migrate [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| endpoint-id | Required | UUID of the endpoint you want to migrate |
| instance-id | Required | UUID of the instance you want to attach the endpoint to |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Database engines commands

A database engine is the software component that stores and retrieves your data from a database. Currently PostgreSQL 11, 12, 13 and 14 are available. MySQL is available in version 8.


### List available database engines

List the PostgreSQL and MySQL database engines available at Scaleway.

**Usage:**

```
scw rdb engine list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name |  | Name of the database engine |
| version |  | Version of the database engine |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### List available settings from an engine.

List available settings from an engine.

**Usage:**

```
scw rdb engine settings [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required | The name of your engine where you want list the available settings. |
| version | Required | The version of the engine. |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |


**Examples:**


List Engine Settings
```
scw rdb engine settings name=MySQL version=8
```




## Instance management commands

A Database Instance is made up of one or multiple dedicated compute nodes running a single database engine. Two node settings are available: **High-Availability (HA)**, with a main node and one replica, and **standalone** with a main node. The HA standby node is linked to the main node, using synchronous replication. Synchronous replication offers the ability to confirm that all changes intended by a transaction have been transferred and applied to the synchronous replica node, providing durability to the data.

**Note**: HA standby nodes are not accessible to users unless the main node becomes unavailable and the standby takes over. If you wish to run queries on a read-only node, you can use [Read Replicas](#path-read-replicas-create-a-read-replica)

Read Replicas can be used for certain read-only workflows such as Business Intelligence, or for a read-only scaling of your application. Read Replicas use asynchronous replication to replicate data from the main node.


### Clone a Database Instance

Clone a given Database Instance, specified by the `region` and `instance_id` parameters. The clone feature allows you to create a new Database Instance from an existing one. The clone includes all existing databases, users and permissions. You can create a clone on a Database Instance bigger than your current one.

**Usage:**

```
scw rdb instance clone <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance you want to clone |
| name |  | Name of the Database Instance clone |
| node-type |  | Node type of the clone |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Connect to an instance using locally installed CLI

Connect to an instance using locally installed CLI such as psql or mysql.

**Usage:**

```
scw rdb instance connect <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| private-network | Default: `false` | Connect by the private network endpoint attached. |
| instance-id | Required | UUID of the instance |
| username | Required | Name of the user to connect with to the database |
| database | Default: `rdb` | Name of the database |
| cli-db |  | Command line tool to use, default to psql/mysql |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |



### Create a Database Instance

Create a new Database Instance. You must set the `engine`, `user_name`, `password` and `node_type` parameters. Optionally, you can specify the volume type and size.

**Usage:**

```
scw rdb instance create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name | Default: `<generated>` | Name of the Database Instance |
| engine | Required | Database engine of the Database Instance (PostgreSQL, MySQL, ...) |
| user-name | Required | Username created when the Database Instance is created |
| generate-password | Default: `true` | Will generate a 21 character-length password that contains a mix of upper/lower case letters, numbers and special symbols |
| password |  | Password of the user. Password must be between 8 and 128 characters, contain at least one digit, one uppercase, one lowercase and one special character |
| node-type | Required<br />Default: `DB-DEV-S` | Type of node to use for the Database Instance |
| is-ha-cluster |  | Defines whether or not High-Availability is enabled |
| disable-backup |  | Defines whether or not backups are disabled |
| tags.{index} |  | Tags to apply to the Database Instance |
| init-settings.{index}.name |  |  |
| init-settings.{index}.value |  |  |
| volume-type | One of: `lssd`, `bssd`, `sbs_5k`, `sbs_15k` | Type of volume where data is stored (lssd, bssd, ...) |
| volume-size |  | Volume size when volume_type is not lssd |
| init-endpoints.{index}.load-balancer | Default: `false` | Will configure a load-balancer endpoint along with your private network endpoint if true |
| init-endpoints.{index}.private-network.enable-ipam |  | Will configure your Private Network endpoint with Scaleway IPAM service if true |
| init-endpoints.{index}.private-network.private-network-id |  | UUID of the Private Network to be connected to the Database Instance |
| init-endpoints.{index}.private-network.service-ip |  | Endpoint IPv4 address with a CIDR notation. Refer to the official Scaleway documentation to learn more about IP and subnet limitations. |
| backup-same-region |  | Defines whether to or not to store logical backups in the same region as the Database Instance |
| encryption.enabled |  |  |
| organization-id |  | Organization ID to use. If none is passed the default organization ID will be used |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a Database Instance

Delete a given Database Instance, specified by the `region` and `instance_id` parameters. Deleting a Database Instance is permanent, and cannot be undone. Note that upon deletion all your data will be lost.

**Usage:**

```
scw rdb instance delete <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a Database Instance

Retrieve information about a given Database Instance, specified by the `region` and `instance_id` parameters. Its full details, including name, status, IP address and port, are returned in the response object.

**Usage:**

```
scw rdb instance get <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get the TLS certificate of a Database Instance

Retrieve information about the TLS certificate of a given Database Instance. Details like name and content are returned in the response.

**Usage:**

```
scw rdb instance get-certificate <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get Database Instance metrics

Retrieve the time series metrics of a given Database Instance. You can define the period from which to retrieve metrics by specifying the `start_date` and `end_date`.

**Usage:**

```
scw rdb instance get-metrics <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance |
| start-date |  | Start date to gather metrics from |
| end-date |  | End date to gather metrics from |
| metric-name |  | Name of the metric to gather |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List Database Instances

List all Database Instances in the specified region, for a given Scaleway Organization or Scaleway Project. By default, the Database Instances returned in the list are ordered by creation date in ascending order, though this can be modified via the order_by field. You can define additional parameters for your query, such as `tags` and `name`. For the `name` parameter, the value you include will be checked against the whole name string to see if it includes the string you put in the parameter.

**Usage:**

```
scw rdb instance list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| tags.{index} |  | List Database Instances that have a given tag |
| name |  | Lists Database Instances that match a name pattern |
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc`, `region`, `status_asc`, `status_desc` | Criteria to use when ordering Database Instance listings |
| project-id |  | Project ID to list the Database Instance of |
| organization-id |  | Please use project_id instead |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Renew the TLS certificate of a Database Instance

Renew a TLS for a Database Instance. Renewing a certificate means that you will not be able to connect to your Database Instance using the previous certificate. You will also need to download and update the new certificate for all database clients.

**Usage:**

```
scw rdb instance renew-certificate <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance you want logs of |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Restart Database Instance

Restart a given Database Instance, specified by the `region` and `instance_id` parameters. The status of the Database Instance returned in the response.

**Usage:**

```
scw rdb instance restart <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance you want to restart |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Update an instance

Update an instance.

**Usage:**

```
scw rdb instance update <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| backup-schedule-frequency |  | In hours |
| backup-schedule-retention |  | In days |
| is-backup-schedule-disabled |  | Whether or not the backup schedule is disabled |
| name |  | Name of the instance |
| instance-id | Required | UUID of the instance to update |
| tags.{index} |  | Tags of a given instance |
| logs-policy.max-age-retention |  | Max age (in day) of remote logs to keep on the database instance |
| logs-policy.total-disk-retention |  | Max disk size of remote logs to keep on the database instance |
| backup-same-region |  | Store logical backups in the same region as the database instance |
| settings.{index}.name |  | Setting name of a given instance |
| settings.{index}.value |  | Setting value of a given instance |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |


**Examples:**


Update instance name
```
scw rdb instance update 11111111-1111-1111-1111-111111111111 name=foo --wait
```

Update instance tags
```
scw rdb instance update 11111111-1111-1111-1111-111111111111 tags.0=a --wait
```

Set a timezone
```
scw rdb instance update 11111111-1111-1111-1111-111111111111 settings.0.name=timezone settings.0.value=UTC --wait
```




### Upgrade a Database Instance

Upgrade your current Database Instance specifications like node type, high availability, volume, or the database engine version. Note that upon upgrade the `enable_ha` parameter can only be set to `true`.

**Usage:**

```
scw rdb instance upgrade <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance you want to upgrade |
| node-type |  | Node type of the Database Instance you want to upgrade to |
| enable-ha |  | Defines whether or not high availability should be enabled on the Database Instance |
| volume-size |  | Increase your block storage volume size |
| volume-type | One of: `lssd`, `bssd`, `sbs_5k`, `sbs_15k` | Change your Database Instance storage type |
| upgradable-version-id |  | Update your database engine to a newer version |
| major-upgrade-workflow.upgradable-version-id |  | Update your database engine to a newer version |
| major-upgrade-workflow.with-endpoints |  | Include endpoint during the migration |
| enable-encryption |  | Defines whether or not encryption should be enabled on the Database Instance |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Wait for an instance to reach a stable state

Wait for an instance to reach a stable state. This is similar to using --wait flag.

**Usage:**

```
scw rdb instance wait <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | ID of the instance you want to wait for. |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |
| timeout | Default: `20m0s` | Timeout of the wait |


**Examples:**


Wait for an instance to reach a stable state
```
scw rdb instance wait 11111111-1111-1111-1111-111111111111
```




## Instance logs management commands

Instance logs management commands.


### Get given logs of a Database Instance

Retrieve information about the logs of a Database Instance. Specify the `instance_log_id` and `region` in your request to get information such as `download_url`, `status`, `expires_at` and `created_at` about your logs in the response.

**Usage:**

```
scw rdb log get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-log-id | Required | UUID of the instance_log you want |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List available logs of a Database Instance

List the available logs of a Database Instance. By default, the logs returned in the list are ordered by creation date in ascending order, though this can be modified via the order_by field.

**Usage:**

```
scw rdb log list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance you want logs of |
| order-by | One of: `created_at_asc`, `created_at_desc` | Criteria to use when ordering Database Instance logs listing |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List remote Database Instance logs details

List remote log details. By default, the details returned in the list are ordered by creation date in ascending order, though this can be modified via the order_by field.

**Usage:**

```
scw rdb log list-details [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance you want logs of |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Prepare logs of a Database Instance

Prepare your Database Instance logs. You can define the `start_date` and `end_date` parameters for your query. The download URL is returned in the response. Logs are recorded from 00h00 to 23h59 and then aggregated in a `.log` file once a day. Therefore, even if you specify a timeframe from which you want to get the logs, you will receive logs from the full 24 hours.

**Usage:**

```
scw rdb log prepare [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance you want logs of |
| start-date |  | Start datetime of your log. (RFC 3339 format) |
| end-date |  | End datetime of your log. (RFC 3339 format) |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Purge remote Database Instance logs

Purge a given remote log from a Database Instance. You can specify the `log_name` of the log you wish to clean from your Database Instance.

**Usage:**

```
scw rdb log purge [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance you want logs of |
| log-name |  | Given log name to purge |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Node types management commands

Two node type ranges are available:

* **General Purpose:** production-grade nodes designed for scalable database infrastructures.
* **Development:** sandbox environments and reliable performance for development and testing purposes.


### List available node types

List all available node types. By default, the node types returned in the list are ordered by creation date in ascending order, though this can be modified via the `order_by` field.

**Usage:**

```
scw rdb node-type list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| include-disabled-types |  | Defines whether or not to include disabled types |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



## User privileges management commands

Privileges are permissions that can be granted to database users. You can manage user permissions either via the console, the Scaleway APIs or SQL. Managed Database for PostgreSQL and MySQL provides a simplified and unified permission model through the API and the console to make things easier to manage and understand.

Each user has associated permissions that give them access to zero or more logical databases. These include:

* **None:** No access to the database
* **Read:** Allow users to read tables and fields in a database
* **Write:** Allow users to write content in databases.
* **Admin:** Read and write access to the data, and extended privileges depending on the database engine.


### List user privileges for a database

List privileges of a user on a database. By default, the details returned in the list are ordered by creation date in ascending order, though this can be modified via the order_by field. You can define additional parameters for your query, such as `database_name` and `user_name`.

**Usage:**

```
scw rdb privilege list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `user_name_asc`, `user_name_desc`, `database_name_asc`, `database_name_desc` | Criteria to use when ordering privileges listing |
| database-name |  | Name of the database |
| instance-id | Required | UUID of the Database Instance |
| user-name |  | Name of the user |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Set user privileges for a database

Set the privileges of a user on a database. You must define `database_name`, `user_name` and `permission` in the request body.

**Usage:**

```
scw rdb privilege set [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance |
| database-name |  | Name of the database |
| user-name |  | Name of the user |
| permission | One of: `readonly`, `readwrite`, `all`, `custom`, `none` | Permission to set (Read, Read/Write, All, Custom) |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Read replica management

A Read Replica is a live copy of a Database Instance that behaves like an Instance, but that only allows read-only connections.
The replica mirrors the data of the primary Database node and any changes made are replicated to the replica asynchronously. Read Replicas allow you to scale your Database Instance for read-heavy database workloads. They can also be used for business intelligence workloads.

A Read Replica can have at most one direct access and one Private Network endpoint. `Loadbalancer` endpoints are not available on Read Replicas even if this resource is displayed in the Read Replica response example.

If you want to remove a Read Replica endpoint, you can use [delete a Database Instance endpoint](#path-endpoints-delete-a-database-instance-endpoint) API call.

Instance Access Control Lists (ACL) also apply to Read Replica direct access endpoints.

**Limitations:**
There might be replication lags between the primary node and its Read Replica nodes. You can try to reduce this lag with some good practices:
* All your tables should have a primary key
* Don't run large transactions that modify, delete or insert lots of rows. Try to split it into several small transactions.


### Create a Read Replica

Create a new Read Replica of a Database Instance. You must specify the `region` and the `instance_id`. You can only create a maximum of 3 Read Replicas per Database Instance.

**Usage:**

```
scw rdb read-replica create <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance you want to create a Read Replica from |
| endpoint-spec.{index}.private-network.private-network-id |  | UUID of the Private Network to be connected to the Read Replica |
| endpoint-spec.{index}.private-network.service-ip |  | Endpoint IPv4 address with a CIDR notation. Refer to the official Scaleway documentation to learn more about IP and subnet limitations. |
| same-zone |  | Defines whether to create the replica in the same availability zone as the main instance nodes or not. |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Create an endpoint for a Read Replica

Create a new endpoint for a Read Replica. Read Replicas can have at most one direct access and one Private Network endpoint.

**Usage:**

```
scw rdb read-replica create-endpoint <read-replica-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| read-replica-id | Required | UUID of the Read Replica |
| endpoint-spec.{index}.private-network.private-network-id |  | UUID of the Private Network to be connected to the Read Replica |
| endpoint-spec.{index}.private-network.service-ip |  | Endpoint IPv4 address with a CIDR notation. Refer to the official Scaleway documentation to learn more about IP and subnet limitations. |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a Read Replica

Delete a Read Replica of a Database Instance. You must specify the `region` and `read_replica_id` parameters of the Read Replica you want to delete.

**Usage:**

```
scw rdb read-replica delete <read-replica-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| read-replica-id | Required | UUID of the Read Replica |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a Read Replica

Retrieve information about a Database Instance Read Replica. Full details about the Read Replica, like `endpoints`, `status`  and `region` are returned in the response.

**Usage:**

```
scw rdb read-replica get <read-replica-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| read-replica-id | Required | UUID of the Read Replica |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Resync a Read Replica

When you resync a Read Replica, first it is reset, then its data is resynchronized from the primary node. Your Read Replica remains unavailable during the resync process. The duration of this process is proportional to the size of your Database Instance.
The configured endpoints do not change.

**Usage:**

```
scw rdb read-replica reset <read-replica-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| read-replica-id | Required | UUID of the Read Replica |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Setting management

Advanced Database Instance settings allow you to tune the behavior of your database engines to better fit your needs.

Available settings depend on the database engine and its version. Note that some settings can only be defined upon database engine initialization. These are called init settings. You can find a full list of the settings available in the response body of the [list available database engines](#path-databases-list-databases-in-a-database-instance) endpoint.

Each advanced setting entry has a default value that users can override. The deletion of a setting entry will restore the setting to default value. Some of the defaults values can be different from the engine's defaults, as we optimize them to the Scaleway platform.


### Add Database Instance advanced settings

Add an advanced setting to a Database Instance. You must set the `name` and the `value` of each setting.

**Usage:**

```
scw rdb setting add [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance you want to add settings to |
| settings.{index}.name |  |  |
| settings.{index}.value |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete Database Instance advanced settings

Delete an advanced setting in a Database Instance. You must specify the names of the settings you want to delete in the request.

**Usage:**

```
scw rdb setting delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance to delete settings from |
| setting-names.{index} | Required | Settings names to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Set Database Instance advanced settings

Update an advanced setting for a Database Instance. Settings added upon database engine initalization can only be defined once, and cannot, therefore, be updated.

**Usage:**

```
scw rdb setting set [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance where the settings must be set |
| settings.{index}.name |  |  |
| settings.{index}.value |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Block snapshot management

A snapshot is a consistent, instantaneous copy of the Block Storage volume of your Database Instance at a certain point in time. They are designed to recover your data in case of failure or accidental alterations of the data by a user. They allow you to quickly create a new Instance from a previous state of your database, regardless of the size of the volume. Their limitation is that, unlike backups, snapshots can only be stored in the same location as the original data.


### Create a Database Instance snapshot

Create a new snapshot of a Database Instance. You must define the `name` parameter in the request.

**Usage:**

```
scw rdb snapshot create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance |
| name | Required<br />Default: `<generated>` | Name of the snapshot |
| expires-at |  | Expiration date (must follow the ISO 8601 format) |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a Database Instance snapshot

Delete a given snapshot of a Database Instance. You must specify, in the endpoint,  the `region` and `snapshot_id` parameters of the snapshot you want to delete.

**Usage:**

```
scw rdb snapshot delete <snapshot-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| snapshot-id | Required | UUID of the snapshot to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a Database Instance snapshot

Retrieve information about a given snapshot, specified by its `snapshot_id` and `region`. Full details about the snapshot, like size and expiration date, are returned in the response.

**Usage:**

```
scw rdb snapshot get <snapshot-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| snapshot-id | Required | UUID of the snapshot |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List snapshots

List snapshots. You can include the `instance_id` or `project_id` in your query to get the list of snapshots for specific Database Instances and/or Projects. By default, the details returned in the list are ordered by creation date in ascending order, though this can be modified via the `order_by` field.

**Usage:**

```
scw rdb snapshot list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name |  | Name of the snapshot |
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc`, `expires_at_asc`, `expires_at_desc` | Criteria to use when ordering snapshot listing |
| instance-id |  | UUID of the Database Instance |
| project-id |  | Project ID the snapshots belongs to |
| organization-id |  | Organization ID the snapshots belongs to |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Create a new Database Instance from a snapshot

Restore a snapshot. When you restore a snapshot, a new Instance is created and billed to your account. Note that is possible to select a larger node type for your new Database Instance. However, the Block volume size will be the same as the size of the restored snapshot. All Instance settings will be restored if you chose a node type with the same or more memory size than the initial Instance. Settings will be reset to the default if your node type has less memory.

**Usage:**

```
scw rdb snapshot restore <snapshot-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| snapshot-id | Required | Block snapshot of the Database Instance |
| instance-name |  | Name of the Database Instance created with the snapshot |
| is-ha-cluster |  | Defines whether or not High-Availability is enabled on the new Database Instance |
| node-type |  | The node type used to restore the snapshot |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Update a Database Instance snapshot

Update the parameters of a snapshot of a Database Instance. You can update the `name` and `expires_at` parameters.

**Usage:**

```
scw rdb snapshot update <snapshot-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| snapshot-id | Required | UUID of the snapshot to update |
| name |  | Name of the snapshot |
| expires-at |  | Expiration date (must follow the ISO 8601 format) |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## User management commands

Users are profiles to which you can attribute database-level permissions. They allow you to define permissions specific to each type of database usage. For example, users with an `admin` role can create new databases and users.


### Create a user for a Database Instance

Create a new user for a Database Instance. You must define the `name`, `password` and `is_admin` parameters.

**Usage:**

```
scw rdb user create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance in which you want to create a user |
| name |  | Name of the user you want to create |
| generate-password | Default: `true` | Will generate a 21 character-length password that contains a mix of upper/lower case letters, numbers and special symbols |
| password |  | Password of the user you want to create. Password must be between 8 and 128 characters, contain at least one digit, one uppercase, one lowercase and one special character |
| is-admin |  | Defines whether the user will have administrative privileges |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a user on a Database Instance

Delete a given user on a Database Instance. You must specify, in the endpoint,  the `region`, `instance_id` and `name` parameters of the user you want to delete.

**Usage:**

```
scw rdb user delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance to delete the user from |
| name | Required | Name of the user |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Gets the URL to connect to the Database

Provides the URL to connect to a Database on an Instance as the given user

**Usage:**

```
scw rdb user get-url <instance-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | ID of the Database Instance |
| user |  | User of the Database |
| db |  | Name of the Database to connect to |



### List users of a Database Instance

List all users of a given Database Instance. By default, the users returned in the list are ordered by creation date in ascending order, though this can be modified via the order_by field.

**Usage:**

```
scw rdb user list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name |  | Name of the user |
| order-by | One of: `name_asc`, `name_desc`, `is_admin_asc`, `is_admin_desc` | Criteria to use when requesting user listing |
| instance-id | Required | UUID of the Database Instance |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update a user on a Database Instance

Update the parameters of a user on a Database Instance. You can update the `password` and `is_admin` parameters, but you cannot change the name of the user.

**Usage:**

```
scw rdb user update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| instance-id | Required | UUID of the Database Instance the user belongs to |
| name | Required | Name of the database user |
| generate-password | Default: `true` | Will generate a 21 character-length password that contains a mix of upper/lower case letters, numbers and special symbols |
| password |  | Password of the database user. Password must be between 8 and 128 characters, contain at least one digit, one uppercase, one lowercase and one special character |
| is-admin |  | Defines whether or not this user got administrative privileges |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



