<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw iam`
This API allows you to manage Identity and Access Management (IAM) across your Scaleway Organizations, Projects and resources.
  
- [API keys management commands](#api-keys-management-commands)
  - [Create an API key](#create-an-api-key)
  - [Delete an API key](#delete-an-api-key)
  - [Get an API key](#get-an-api-key)
  - [List API keys](#list-api-keys)
  - [Update an API key](#update-an-api-key)
- [Applications management commands](#applications-management-commands)
  - [Create a new application](#create-a-new-application)
  - [Delete an application](#delete-an-application)
  - [Get a given application](#get-a-given-application)
  - [List applications of an Organization](#list-applications-of-an-organization)
  - [Update an application](#update-an-application)
- [Groups management commands](#groups-management-commands)
  - [Add a user or an application to a group](#add-a-user-or-an-application-to-a-group)
  - [Add multiple users and applications to a group](#add-multiple-users-and-applications-to-a-group)
  - [Create a group](#create-a-group)
  - [Delete a group](#delete-a-group)
  - [Get a group](#get-a-group)
  - [List groups](#list-groups)
  - [Remove a user or an application from a group](#remove-a-user-or-an-application-from-a-group)
  - [Overwrite users and applications of a group](#overwrite-users-and-applications-of-a-group)
  - [Update a group](#update-a-group)
- [JWTs management commands](#jwts-management-commands)
  - [Delete a JWT](#delete-a-jwt)
  - [Get a JWT](#get-a-jwt)
  - [List JWTs](#list-jwts)
- [Log management commands](#log-management-commands)
  - [Get a log](#get-a-log)
  - [List logs](#list-logs)
- [Permission sets management commands](#permission-sets-management-commands)
  - [List permission sets](#list-permission-sets)
- [Policies management commands](#policies-management-commands)
  - [Clone a policy](#clone-a-policy)
  - [Create a new policy](#create-a-new-policy)
  - [Delete a policy](#delete-a-policy)
  - [Get an existing policy](#get-an-existing-policy)
  - [List policies of an Organization](#list-policies-of-an-organization)
  - [Update an existing policy](#update-an-existing-policy)
- [Rules management commands](#rules-management-commands)
  - [Create a rule for a specific IAM policy](#create-a-rule-for-a-specific-iam-policy)
  - [Delete a rule for a specific IAM policy](#delete-a-rule-for-a-specific-iam-policy)
  - [List rules of a given policy](#list-rules-of-a-given-policy)
  - [Set rules of a given policy](#set-rules-of-a-given-policy)
- [SSH keys management commands](#ssh-keys-management-commands)
  - [Create an SSH key](#create-an-ssh-key)
  - [Delete an SSH key](#delete-an-ssh-key)
  - [Get an SSH key](#get-an-ssh-key)
  - [Initialize SSH key](#initialize-ssh-key)
  - [List SSH keys](#list-ssh-keys)
  - [Update an SSH key](#update-an-ssh-key)
- [Users management commands](#users-management-commands)
  - [Create a new user](#create-a-new-user)
  - [Delete a guest user from an Organization](#delete-a-guest-user-from-an-organization)
  - [Get a given user](#get-a-given-user)
  - [List users of an Organization](#list-users-of-an-organization)
  - [Update a user](#update-a-user)
  - [Update an user's password](#update-an-user's-password)

  
## API keys management commands

API keys management commands.


### Create an API key

Create an API key. You must specify the `application_id` or the `user_id` and the description. You can also specify the `default_project_id` which is the Project ID of your preferred Project, to use with Object Storage. The `access_key` and `secret_key` values are returned in the response. Note that he secret key is only showed once. Make sure that you copy and store both keys somewhere safe.

**Usage:**

```
scw iam api-key create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| application-id |  | ID of the application |
| user-id |  | ID of the user |
| expires-at |  | Expiration date of the API key |
| default-project-id |  | Default Project ID to use with Object Storage |
| description |  | Description of the API key (max length is 200 characters) |



### Delete an API key

Delete an API key. Note that this action is irreversible and cannot be undone. Make sure you update any configurations using the API keys you delete.

**Usage:**

```
scw iam api-key delete <access-key ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| access-key | Required | Access key to delete |


**Examples:**


Delete a given API key
```
scw iam api-key delete SCW00000000000
```




### Get an API key

Retrive information about an API key, specified by the `access_key` parameter. The API key's details, including either the `user_id` or `application_id` of its bearer are returned in the response. Note that the string value for the `secret_key` is nullable, and therefore is not displayed in the response. The `secret_key` value is only displayed upon API key creation.

**Usage:**

```
scw iam api-key get <access-key ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| access-key | Required | Access key to search for |



### List API keys

List API keys. By default, the API keys listed are ordered by creation date in ascending order. This can be modified via the `order_by` field. You can define additional parameters for your query such as `editable`, `expired`, `access_key` and `bearer_id`.

**Usage:**

```
scw iam api-key list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | Default: `created_at_asc`<br />One of: `created_at_asc`, `created_at_desc`, `updated_at_asc`, `updated_at_desc`, `expires_at_asc`, `expires_at_desc`, `access_key_asc`, `access_key_desc` | Criteria for sorting results |
| ~~application-id~~ | Deprecated | ID of application that bears the API key |
| ~~user-id~~ | Deprecated | ID of user that bears the API key |
| editable |  | Defines whether to filter out editable API keys or not |
| expired |  | Defines whether to filter out expired API keys or not |
| ~~access-key~~ | Deprecated | Filter by access key (deprecated in favor of `access_keys`) |
| description |  | Filter by description |
| bearer-id |  | Filter by bearer ID |
| bearer-type | One of: `unknown_bearer_type`, `user`, `application` | Filter by type of bearer |
| access-keys.{index} |  | Filter by a list of access keys |
| organization-id | Required<br />Default: `<retrieved from config>` | ID of Organization |



### Update an API key

Update the parameters of an API key, including `default_project_id` and `description`.

**Usage:**

```
scw iam api-key update <access-key ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| access-key | Required | Access key to update |
| default-project-id |  | New default Project ID to set |
| description |  | New description to update |



## Applications management commands

Applications management commands.


### Create a new application

Create a new application. You must define the `name` parameter in the request.

**Usage:**

```
scw iam application create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required<br />Default: `<generated>` | Name of the application to create (max length is 64 characters) |
| description |  | Description of the application (max length is 200 characters) |
| tags.{index} |  | Tags associated with the application (maximum of 10 tags) |
| organization-id |  | Organization ID to use. If none is passed the default organization ID will be used |



### Delete an application

Delete an application. Note that this action is irreversible and will automatically delete the application's API keys. Policies attached to users and applications via this group will no longer apply.

**Usage:**

```
scw iam application delete <application-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| application-id | Required | ID of the application to delete |



### Get a given application

Retrieve information about an application, specified by the `application_id` parameter. The application's full details, including `id`, `email`, `organization_id`, `status` and `two_factor_enabled` are returned in the response.

**Usage:**

```
scw iam application get <application-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| application-id | Required | ID of the application to find |



### List applications of an Organization

List the applications of an Organization. By default, the applications listed are ordered by creation date in ascending order. This can be modified via the `order_by` field. You must define the `organization_id` in the query path of your request. You can also define additional parameters for your query such as `application_ids`.

**Usage:**

```
scw iam application list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | Default: `created_at_asc`<br />One of: `created_at_asc`, `created_at_desc`, `updated_at_asc`, `updated_at_desc`, `name_asc`, `name_desc` | Criteria for sorting results |
| name |  | Name of the application to filter |
| editable |  | Defines whether to filter out editable applications or not |
| application-ids.{index} |  | Filter by list of IDs |
| tag |  | Filter by tags containing a given string |
| organization-id | Default: `<retrieved from config>` | Organization ID to use. If none is passed the default organization ID will be used |



### Update an application

Update the parameters of an application, including `name` and `description`.

**Usage:**

```
scw iam application update <application-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| application-id | Required | ID of the application to update |
| name |  | New name for the application (max length is 64 chars) |
| description |  | New description for the application (max length is 200 chars) |
| tags.{index} |  | New tags for the application (maximum of 10 tags) |



## Groups management commands

Groups management commands.


### Add a user or an application to a group

Add a user or an application to a group. You can specify a `user_id` and and `application_id` in the body of your request. Note that you can only add one of each per request.

**Usage:**

```
scw iam group add-member <group-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| group-id | Required | ID of the group |
| user-id |  | ID of the user to add |
| application-id |  | ID of the application to add |



### Add multiple users and applications to a group

Add multiple users and applications to a group in a single call. You can specify an array of `user_id`s and `application_id`s. Note that any existing users and applications in the group will remain. To add new users/applications and delete pre-existing ones, use the [Overwrite users and applications of a group](#path-groups-overwrite-users-and-applications-of-a-group) method.

**Usage:**

```
scw iam group add-members [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| group-id | Required | ID of the group |
| user-ids.{index} |  | IDs of the users to add |
| application-ids.{index} |  | IDs of the applications to add |



### Create a group

Create a new group. You must define the `name` and `organization_id` parameters in the request.

**Usage:**

```
scw iam group create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required<br />Default: `<generated>` | Name of the group to create (max length is 64 chars). MUST be unique inside an Organization |
| description |  | Description of the group to create (max length is 200 chars) |
| tags.{index} |  | Tags associated with the group (maximum of 10 tags) |
| organization-id |  | Organization ID to use. If none is passed the default organization ID will be used |


**Examples:**


Create a group
```
scw iam group create name=foobar
```




### Delete a group

Delete a group. Note that this action is irreversible and could delete permissions for group members. Policies attached to users and applications via this group will no longer apply.

**Usage:**

```
scw iam group delete <group-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| group-id | Required | ID of the group to delete |


**Examples:**


Delete a given group
```
scw iam group delete 11111111-1111-1111-1111-111111111111
```




### Get a group

Retrive information about a given group, specified by the `group_id` parameter. The group's full details, including `user_ids` and `application_ids` are returned in the response.

**Usage:**

```
scw iam group get <group-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| group-id | Required | ID of the group |



### List groups

List groups. By default, the groups listed are ordered by creation date in ascending order. This can be modified via the `order_by` field. You can define additional parameters to filter your query. Use `user_ids` or `application_ids` to list all groups certain users or applications belong to.

**Usage:**

```
scw iam group list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | Default: `created_at_asc`<br />One of: `created_at_asc`, `created_at_desc`, `updated_at_asc`, `updated_at_desc`, `name_asc`, `name_desc` | Sort order of groups |
| name |  | Name of group to find |
| application-ids.{index} |  | Filter by a list of application IDs |
| user-ids.{index} |  | Filter by a list of user IDs |
| group-ids.{index} |  | Filter by a list of group IDs |
| tag |  | Filter by tags containing a given string |
| organization-id | Default: `<retrieved from config>` | Organization ID to use. If none is passed the default organization ID will be used |



### Remove a user or an application from a group

Remove a user or an application from a group. You can specify a `user_id` and and `application_id` in the body of your request. Note that you can only remove one of each per request. Removing a user from a group means that any permissions given to them via the group (i.e. from an attached policy) will no longer apply. Be sure you want to remove these permissions from the user before proceeding.

**Usage:**

```
scw iam group remove-member <group-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| group-id | Required | ID of the group |
| user-id |  | ID of the user to remove |
| application-id |  | ID of the application to remove |



### Overwrite users and applications of a group

Overwrite users and applications configuration in a group. Any information that you add using this command will overwrite the previous configuration.

**Usage:**

```
scw iam group set-members [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| group-id | Required |  |
| user-ids.{index} | Required |  |
| application-ids.{index} | Required |  |



### Update a group

Update the parameters of group, including `name` and `description`.

**Usage:**

```
scw iam group update <group-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| group-id | Required | ID of the group to update |
| name |  | New name for the group (max length is 64 chars). MUST be unique inside an Organization |
| description |  | New description for the group (max length is 200 chars) |
| tags.{index} |  | New tags for the group (maximum of 10 tags) |



## JWTs management commands

JWTs management commands.


### Delete a JWT

Delete a JWT.

**Usage:**

```
scw iam jwt delete <jti ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| jti | Required | JWT ID of the JWT to delete |



### Get a JWT

Get a JWT.

**Usage:**

```
scw iam jwt get <jti ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| jti | Required | JWT ID of the JWT to get |



### List JWTs

List JWTs.

**Usage:**

```
scw iam jwt list <audience-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | Default: `created_at_asc`<br />One of: `created_at_asc`, `created_at_desc`, `updated_at_asc`, `updated_at_desc` | Criteria for sorting results |
| audience-id | Required | ID of the user to search |
| expired |  | Filter out expired JWTs or not |



## Log management commands

Log management commands.


### Get a log

Retrieve information about a log, specified by the `log_id` parameter. The log's full details, including `id`, `ip`, `user_agent`, `action`, `bearer_id`, `resource_type` and `resource_id` are returned in the response.

**Usage:**

```
scw iam log get <log-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| log-id | Required | ID of the log |



### List logs

List logs available for given Organization. You must define the `organization_id` in the query path of your request.

**Usage:**

```
scw iam log list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | Default: `created_at_asc`<br />One of: `created_at_asc`, `created_at_desc` | Criteria for sorting results |
| created-after |  | Defined whether or not to filter out logs created after this timestamp |
| created-before |  | Defined whether or not to filter out logs created before this timestamp |
| action | One of: `unknown_action`, `created`, `updated`, `deleted` | Defined whether or not to filter out by a specific action |
| resource-type | One of: `unknown_resource_type`, `api_key`, `user`, `application`, `group`, `policy` | Defined whether or not to filter out by a specific type of resource |
| search |  | Defined whether or not to filter out log by bearer ID or resource ID |
| organization-id |  | Organization ID to use. If none is passed the default organization ID will be used |



## Permission sets management commands

Permission sets management commands.


### List permission sets

List permission sets available for given Organization. You must define the `organization_id` in the query path of your request.

**Usage:**

```
scw iam permission-set list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | Default: `created_at_asc`<br />One of: `name_asc`, `name_desc`, `created_at_asc`, `created_at_desc` | Criteria for sorting results |
| organization-id |  | Organization ID to use. If none is passed the default organization ID will be used |



## Policies management commands

Policies management commands.


### Clone a policy

Clone a policy. You must define specify the `policy_id` parameter in your request.

**Usage:**

```
scw iam policy clone [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| policy-id | Required |  |



### Create a new policy

Create a new application. You must define the `name` parameter in the request. You can specify parameters such as `user_id`, `groups_id`, `application_id`, `no_principal`, `rules` and its child attributes.

**Usage:**

```
scw iam policy create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required<br />Default: `<generated>` | Name of the policy to create (max length is 64 characters) |
| description |  | Description of the policy to create (max length is 200 characters) |
| rules.{index}.permission-set-names.{index} |  | Names of permission sets bound to the rule |
| rules.{index}.condition |  | Condition expression to evaluate |
| rules.{index}.project-ids.{index} |  | List of Project IDs the rule is scoped to |
| rules.{index}.organization-id |  | ID of Organization the rule is scoped to |
| tags.{index} |  | Tags associated with the policy (maximum of 10 tags) |
| user-id |  | ID of user attributed to the policy |
| group-id |  | ID of group attributed to the policy |
| application-id |  | ID of application attributed to the policy |
| no-principal |  | Defines whether or not a policy is attributed to a principal |
| organization-id |  | Organization ID to use. If none is passed the default organization ID will be used |


**Examples:**


Add a policy for a group that gives InstanceFullAccess on all projects
```
scw iam policy create group-id=11111111-1111-1111-1111-111111111111 rules.0.organization-id=11111111-1111-1111-1111-111111111111 rules.0.permission-set-names.0=InstancesFullAccess
```




### Delete a policy

Delete a policy. You must define specify the `policy_id` parameter in your request. Note that when deleting a policy, all permissions it gives to its principal (user, group or application) will be revoked.

**Usage:**

```
scw iam policy delete <policy-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| policy-id | Required | Id of policy to delete |



### Get an existing policy

Retrieve information about a policy, speficified by the `policy_id` parameter. The policy's full details, including `id`, `name`, `organization_id`, `nb_rules` and `nb_scopes`, `nb_permission_sets` are returned in the response.

**Usage:**

```
scw iam policy get <policy-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| policy-id | Required | Id of policy to search |



### List policies of an Organization

List the policies of an Organization. By default, the policies listed are ordered by creation date in ascending order. This can be modified via the `order_by` field. You must define the `organization_id` in the query path of your request. You can also define additional parameters to filter your query, such as `user_ids`, `groups_ids`, `application_ids`, and `policy_name`.

**Usage:**

```
scw iam policy list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | Default: `created_at_asc`<br />One of: `policy_name_asc`, `policy_name_desc`, `created_at_asc`, `created_at_desc` | Criteria for sorting results |
| editable |  | Defines whether or not filter out editable policies |
| user-ids.{index} |  | Defines whether or not to filter by list of user IDs |
| group-ids.{index} |  | Defines whether or not to filter by list of group IDs |
| application-ids.{index} |  | Filter by a list of application IDs |
| no-principal |  | Defines whether or not the policy is attributed to a principal |
| policy-name |  | Name of the policy to fetch |
| tag |  | Filter by tags containing a given string |
| policy-ids.{index} |  | Filter by a list of IDs |
| organization-id | Default: `<retrieved from config>` | Organization ID to use. If none is passed the default organization ID will be used |



### Update an existing policy

Update the parameters of a policy, including `name`, `description`, `user_id`, `group_id`, `application_id` and `no_principal`.

**Usage:**

```
scw iam policy update <policy-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| policy-id | Required | Id of policy to update |
| name |  | New name for the policy (max length is 64 characters) |
| description |  | New description of policy (max length is 200 characters) |
| tags.{index} |  | New tags for the policy (maximum of 10 tags) |
| user-id |  | New ID of user attributed to the policy |
| group-id |  | New ID of group attributed to the policy |
| application-id |  | New ID of application attributed to the policy |
| no-principal |  | Defines whether or not the policy is attributed to a principal |



## Rules management commands

Rules management commands.


### Create a rule for a specific IAM policy



**Usage:**

```
scw iam rule create <policy-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| policy-id |  | Id of policy to update |
| permission-set-names.{index} |  | Names of permission sets bound to the rule |
| project-ids.{index} |  | List of Project IDs the rule is scoped to |
| organization-id |  | ID of Organization the rule is scoped to |



### Delete a rule for a specific IAM policy



**Usage:**

```
scw iam rule delete <policy-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| policy-id |  | Id of policy to update |
| rule-id |  | Id of rule to delete |



### List rules of a given policy

List the rules of a given policy. By default, the rules listed are ordered by creation date in ascending order. This can be modified via the `order_by` field. You must define the `policy_id` in the query path of your request.

**Usage:**

```
scw iam rule list <policy-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| policy-id | Required | Id of policy to search |



### Set rules of a given policy

Overwrite the rules of a given policy. Any information that you add using this command will overwrite the previous configuration. If you include some of the rules you already had in your previous configuration in your new one, but you change their order, the new order of display will apply. While policy rules are ordered, they have no impact on the access logic of IAM because rules are allow-only.

**Usage:**

```
scw iam rule update <policy-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| policy-id | Required | Id of policy to update |
| rules.{index}.permission-set-names.{index} |  | Names of permission sets bound to the rule |
| rules.{index}.condition |  | Condition expression to evaluate |
| rules.{index}.project-ids.{index} |  | List of Project IDs the rule is scoped to |
| rules.{index}.organization-id |  | ID of Organization the rule is scoped to |



## SSH keys management commands

SSH keys management commands.


### Create an SSH key

Add a new SSH key to a Scaleway Project. You must specify the `name`, `public_key` and `project_id`.

**Usage:**

```
scw iam ssh-key create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required<br />Default: `<generated>` | Name of the SSH key. Max length is 1000 |
| public-key | Required | SSH public key. Currently only the ssh-rsa, ssh-dss (DSA), ssh-ed25519 and ecdsa keys with NIST curves are supported. Max length is 65000 |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |


**Examples:**


Add a given ssh key
```
scw iam ssh-key create name=foobar public-key="$(cat <path/to/your/public/key>)"
```




### Delete an SSH key

Delete a given SSH key, specified by the `ssh_key_id`. Deleting an SSH is permanent, and cannot be undone. Note that you might need to update any configurations that used the SSH key.

**Usage:**

```
scw iam ssh-key delete <ssh-key-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ssh-key-id | Required |  |


**Examples:**


Delete a given SSH key
```
scw iam ssh-key delete 11111111-1111-1111-1111-111111111111
```




### Get an SSH key

Retrieve information about a given SSH key, specified by the `ssh_key_id` parameter. The SSH key's full details, including `id`, `name`, `public_key`, and `project_id` are returned in the response.

**Usage:**

```
scw iam ssh-key get <ssh-key-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ssh-key-id | Required | ID of the SSH key |



### Initialize SSH key

Initialize SSH key.

**Usage:**

```
scw iam ssh-key init
```



### List SSH keys

List SSH keys. By default, the SSH keys listed are ordered by creation date in ascending order. This can be modified via the `order_by` field. You can define additional parameters for your query such as `organization_id`, `name`, `project_id` and `disabled`.

**Usage:**

```
scw iam ssh-key list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | Default: `created_at_asc`<br />One of: `created_at_asc`, `created_at_desc`, `updated_at_asc`, `updated_at_desc`, `name_asc`, `name_desc` | Sort order of the SSH keys |
| name |  | Name of group to find |
| project-id |  | Filter by Project ID |
| disabled |  | Defines whether to include disabled SSH keys or not |
| organization-id | Default: `<retrieved from config>` | Filter by Organization ID |



### Update an SSH key

Update the parameters of an SSH key, including `name` and `disable`.

**Usage:**

```
scw iam ssh-key update <ssh-key-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ssh-key-id | Required |  |
| name |  | Name of the SSH key. Max length is 1000 |
| disabled |  | Enable or disable the SSH key |



## Users management commands

Users management commands.


### Create a new user

Create a new user. You must define the `organization_id` and the `email` in your request.

**Usage:**

```
scw iam user create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| email |  | Email of the user |
| tags.{index} |  | Tags associated with the user |
| member.email |  | Email of the user to create |
| member.send-password-email |  | Whether or not to send an email containing the member's password. |
| member.send-welcome-email |  | Whether or not to send a welcome email that includes onboarding information. |
| member.username |  | The member's username |
| member.password |  | The member's password |
| organization-id |  | Organization ID to use. If none is passed the default organization ID will be used |



### Delete a guest user from an Organization

Remove a user from an Organization in which they are a guest. You must define the `user_id` in your request. Note that removing a user from an Organization automatically deletes their API keys, and any policies directly attached to them become orphaned.

**Usage:**

```
scw iam user delete <user-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| user-id | Required | ID of the user to delete |



### Get a given user

Retrieve information about a user, specified by the `user_id` parameter. The user's full details, including `id`, `email`, `organization_id`, `status` and `mfa` are returned in the response.

**Usage:**

```
scw iam user get <user-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| user-id | Required | ID of the user to find |



### List users of an Organization

List the users of an Organization. By default, the users listed are ordered by creation date in ascending order. This can be modified via the `order_by` field. You must define the `organization_id` in the query path of your request. You can also define additional parameters for your query such as `user_ids`.

**Usage:**

```
scw iam user list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | Default: `created_at_asc`<br />One of: `created_at_asc`, `created_at_desc`, `updated_at_asc`, `updated_at_desc`, `email_asc`, `email_desc`, `last_login_asc`, `last_login_desc` | Criteria for sorting results |
| user-ids.{index} |  | Filter by list of IDs |
| mfa |  | Filter by MFA status |
| tag |  | Filter by tags containing a given string |
| organization-id | Required<br />Default: `<retrieved from config>` | ID of the Organization to filter |



### Update a user

Update the parameters of a user, including `tags`.

**Usage:**

```
scw iam user update <user-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| user-id | Required | ID of the user to update |
| tags.{index} |  | New tags for the user (maximum of 10 tags) |
| email |  | New email for the user (only available on Members) |



### Update an user's password

Update an user's password.

**Usage:**

```
scw iam user update-password <user-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| user-id | Required | ID of the user to update |
| password | Required | The new password |
| send-email |  | Whether or not to send an email alerting the user their password has changed |



