package lb_test

import (
	"testing"

	"github.com/scaleway/scaleway-cli/v2/core"
	"github.com/scaleway/scaleway-cli/v2/internal/namespaces/lb/v1"
)

func Test_CreateCertificate(t *testing.T) {
	// You can generate a private key and a Certificate Signing Request (CSR) using:
	// openssl req -new -newkey rsa:4096 -nodes -keyout private_key.txt -out csr.txt -subj "/C=US/ST=Denial/L=Springfield/O=Dis/CN=www.example.com"
	// Generate Certificate
	//	openssl x509 -req -sha256 -days 365 -in csr.txt -signkey private_key.txt -out certificate.txt -extensions req_ext

	customCertificateChain := `
-----BEGIN PRIVATE KEY-----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-----END PRIVATE KEY-----
-----BEGIN CERTIFICATE-----
MIIFijCCA3KgAwIBAgIJAI+myVDGPxI7MA0GCSqGSIb3DQEBCwUAMG4xCzAJBgNV
BAYTAkZSMRYwFAYDVQQIDA1JbGUtZGUtRnJhbmNlMQ4wDAYDVQQHDAVQYXJpczEd
MBsGA1UECgwUTXlJbnRlcm5ldENvbXBhbnlMVEQxGDAWBgNVBAMMD3d3dy5leGFt
cGxlLmNvbTAeFw0yMjExMTQxNjA5MTFaFw0yMzExMTQxNjA5MTFaMG4xCzAJBgNV
BAYTAkZSMRYwFAYDVQQIDA1JbGUtZGUtRnJhbmNlMQ4wDAYDVQQHDAVQYXJpczEd
MBsGA1UECgwUTXlJbnRlcm5ldENvbXBhbnlMVEQxGDAWBgNVBAMMD3d3dy5leGFt
cGxlLmNvbTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAKOJJZJWGKyR
MBTSwA1dzTz7NGoJLXLWQyOq2rOiqfG2uZ3Djy+ATjb6/mP+/SgEFHiS4ETCmvZZ
PWU4bITm+FgEiOzyQ8EqdplH5Jrw54xim428ETydiASgghoiSSE+M9qzK4ROIrrf
LHQPmrBGyb0Chr87mQo6kDDXs3Pdssk1ORhaPAul9vsnIbZWEX09rZ1+vuxqFjVM
G70Zjwc1W9elYIYRYI1bwNCncHLbdHoGxSvAx6t/zxd/mGTEzji4dUJPAlrNx0yE
8RiGzixruer+1YNRYXHeg9Y/FxhgQ2gIIm7pVQgac9wNcBcUxqiUFIPvyjiPSgK3
SoBml4GAl3d1nP5+zAahV0UMty9Ez35lJq/qeLBTj2vyU34B7dEABG9JMllKxVLc
n97xDjSL22cSSWB63wDHB1oVWLBnlSLZDZFLuWdAW3t05qvnkwieqgtrrIubxClF
9VP92cyeggYNPmF3YspqYCxps22Y9JPU4m/cw6XRc/uBJUA6AMnw2OHUk3lfiq07
ca9NTMGiN+pt6Bwwt7wZTxlSLc9MSOon7TGddeLhkdOfevVrAhXKaYJU4/+ldsNS
J+V8FtVZk5C7k4XSUk8h6glLkDHlHcLS4OkK3w7T8LaSVrwVOw6BIWit359s43/7
SuNA8revIlYJgq33KeWDGv9vnZqHZTiLAgMBAAGjKzApMCcGA1UdEQQgMB6CC2V4
YW1wbGUuY29tgg93d3cuZXhhbXBsZS5jb20wDQYJKoZIhvcNAQELBQADggIBAD/F
iIwu462RaaN8dZ7G0vhTGoz70hGsaLw7Qi8mOCN1hUfMrxh+oxLNUu9A/pNCx9zA
g4N/8xvA3L85kv4RkvPDP5KQ9h/zIKgV2ADv8Swu67fclEVa6Mk4BmRPghfhs/h/
9TEc3oyEyG6TQx5msPz9z9ghQyhgbYlo4DigAv8Gjz7RyGg1stD0LOeVg6pSVhK0
37+dg55hox5mMN36g2O+xEM85u4uB4dqp4ibvKPapq+wAYg0YK3R79+KmlsbCVC1
zFWyDwaH3H3VLb1a/aAHxUqvpTMmrJpeZWTPeVcsIKsml9NpjQgeIy4MjkjcHBJk
ZfZ9/R3OaM9Bl/OtUWEDadEXhMA/neJ0bZh8Bt2ql1GnKUYJPH0qWKgMwFThykcU
l54C512JDGk8tBiNAh2cqbbKX+M0jqTuDmSeLZOcvWM+k0T/VbeERalPdH3xXO3L
x4FFaqNY5W1sndunzYeWCpVNfK2unwcocj8hXl+Vcm0YgzDhz8CrgFQgp7qmtGH8
eewzvqkUm8i+N4c7Rax25M06EcT8dCfjHG0ScC+iOOrgm9V8bVNNsnUQzAqhwozp
FKQ9WcK8j+KuYrWQJihn/omlWXSQ+zs12N7yKVLVRuY8aw4XuWZwvuu4EkRLYcUD
5h467I4rNC2+9W+AcNkzCE2i/dCyt3f3y1Rtu8l0
-----END CERTIFICATE-----
`
	t.Run("Import", core.Test(&core.TestConfig{
		Commands: lb.GetCommands(),
		BeforeFunc: core.BeforeFuncCombine(
			createLB(),
		),
		Args: []string{
			"scw", "lb", "certificate", "create",
			"lb-id={{ .LB.ID }}", "custom-certificate-chain=" + customCertificateChain,
		},
		Check:      core.TestCheckGolden(),
		AfterFunc:  deleteLB(),
		TmpHomeDir: true,
	}))
}
