//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright 2024 Rancher Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by deepcopy-gen. DO NOT EDIT.

package types

import (
	appsv1 "k8s.io/api/apps/v1"
	corev1 "k8s.io/api/core/v1"
	apiserverv1 "k8s.io/apiserver/pkg/apis/apiserver/v1"
	v1 "k8s.io/apiserver/pkg/apis/audit/v1"
	eventratelimit "k8s.io/kubernetes/plugin/pkg/admission/eventratelimit/apis/eventratelimit"
)

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AWSCloudProvider) DeepCopyInto(out *AWSCloudProvider) {
	*out = *in
	out.Global = in.Global
	if in.ServiceOverride != nil {
		in, out := &in.ServiceOverride, &out.ServiceOverride
		*out = make(map[string]ServiceOverride, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AWSCloudProvider.
func (in *AWSCloudProvider) DeepCopy() *AWSCloudProvider {
	if in == nil {
		return nil
	}
	out := new(AWSCloudProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AciNetworkProvider) DeepCopyInto(out *AciNetworkProvider) {
	*out = *in
	if in.ApicHosts != nil {
		in, out := &in.ApicHosts, &out.ApicHosts
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.L3OutExternalNetworks != nil {
		in, out := &in.L3OutExternalNetworks, &out.L3OutExternalNetworks
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.KafkaBrokers != nil {
		in, out := &in.KafkaBrokers, &out.KafkaBrokers
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.ServiceGraphEndpointAddServices != nil {
		in, out := &in.ServiceGraphEndpointAddServices, &out.ServiceGraphEndpointAddServices
		*out = make([]map[string]string, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = make(map[string]string, len(*in))
				for key, val := range *in {
					(*out)[key] = val
				}
			}
		}
	}
	if in.NodeSnatRedirectExclude != nil {
		in, out := &in.NodeSnatRedirectExclude, &out.NodeSnatRedirectExclude
		*out = make([]map[string]string, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = make(map[string]string, len(*in))
				for key, val := range *in {
					(*out)[key] = val
				}
			}
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AciNetworkProvider.
func (in *AciNetworkProvider) DeepCopy() *AciNetworkProvider {
	if in == nil {
		return nil
	}
	out := new(AciNetworkProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AuditLog) DeepCopyInto(out *AuditLog) {
	*out = *in
	if in.Configuration != nil {
		in, out := &in.Configuration, &out.Configuration
		*out = new(AuditLogConfig)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AuditLog.
func (in *AuditLog) DeepCopy() *AuditLog {
	if in == nil {
		return nil
	}
	out := new(AuditLog)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AuditLogConfig) DeepCopyInto(out *AuditLogConfig) {
	*out = *in
	if in.Policy != nil {
		in, out := &in.Policy, &out.Policy
		*out = new(v1.Policy)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AuditLogConfig.
func (in *AuditLogConfig) DeepCopy() *AuditLogConfig {
	if in == nil {
		return nil
	}
	out := new(AuditLogConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AuthWebhookConfig) DeepCopyInto(out *AuthWebhookConfig) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AuthWebhookConfig.
func (in *AuthWebhookConfig) DeepCopy() *AuthWebhookConfig {
	if in == nil {
		return nil
	}
	out := new(AuthWebhookConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AuthnConfig) DeepCopyInto(out *AuthnConfig) {
	*out = *in
	if in.SANs != nil {
		in, out := &in.SANs, &out.SANs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Webhook != nil {
		in, out := &in.Webhook, &out.Webhook
		*out = new(AuthWebhookConfig)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AuthnConfig.
func (in *AuthnConfig) DeepCopy() *AuthnConfig {
	if in == nil {
		return nil
	}
	out := new(AuthnConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AuthzConfig) DeepCopyInto(out *AuthzConfig) {
	*out = *in
	if in.Options != nil {
		in, out := &in.Options, &out.Options
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AuthzConfig.
func (in *AuthzConfig) DeepCopy() *AuthzConfig {
	if in == nil {
		return nil
	}
	out := new(AuthzConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AzureCloudProvider) DeepCopyInto(out *AzureCloudProvider) {
	*out = *in
	if in.ExcludeMasterFromStandardLB != nil {
		in, out := &in.ExcludeMasterFromStandardLB, &out.ExcludeMasterFromStandardLB
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AzureCloudProvider.
func (in *AzureCloudProvider) DeepCopy() *AzureCloudProvider {
	if in == nil {
		return nil
	}
	out := new(AzureCloudProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BackupConfig) DeepCopyInto(out *BackupConfig) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	if in.S3BackupConfig != nil {
		in, out := &in.S3BackupConfig, &out.S3BackupConfig
		*out = new(S3BackupConfig)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BackupConfig.
func (in *BackupConfig) DeepCopy() *BackupConfig {
	if in == nil {
		return nil
	}
	out := new(BackupConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BaseService) DeepCopyInto(out *BaseService) {
	*out = *in
	if in.ExtraArgs != nil {
		in, out := &in.ExtraArgs, &out.ExtraArgs
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.ExtraArgsArray != nil {
		in, out := &in.ExtraArgsArray, &out.ExtraArgsArray
		*out = make(map[string][]string, len(*in))
		for key, val := range *in {
			var outVal []string
			if val == nil {
				(*out)[key] = nil
			} else {
				in, out := &val, &outVal
				*out = make([]string, len(*in))
				copy(*out, *in)
			}
			(*out)[key] = outVal
		}
	}
	if in.ExtraBinds != nil {
		in, out := &in.ExtraBinds, &out.ExtraBinds
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.ExtraEnv != nil {
		in, out := &in.ExtraEnv, &out.ExtraEnv
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.WindowsExtraArgs != nil {
		in, out := &in.WindowsExtraArgs, &out.WindowsExtraArgs
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.WindowsExtraArgsArray != nil {
		in, out := &in.WindowsExtraArgsArray, &out.WindowsExtraArgsArray
		*out = make(map[string][]string, len(*in))
		for key, val := range *in {
			var outVal []string
			if val == nil {
				(*out)[key] = nil
			} else {
				in, out := &val, &outVal
				*out = make([]string, len(*in))
				copy(*out, *in)
			}
			(*out)[key] = outVal
		}
	}
	if in.WindowsExtraBinds != nil {
		in, out := &in.WindowsExtraBinds, &out.WindowsExtraBinds
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.WindowsExtraEnv != nil {
		in, out := &in.WindowsExtraEnv, &out.WindowsExtraEnv
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BaseService.
func (in *BaseService) DeepCopy() *BaseService {
	if in == nil {
		return nil
	}
	out := new(BaseService)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BastionHost) DeepCopyInto(out *BastionHost) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BastionHost.
func (in *BastionHost) DeepCopy() *BastionHost {
	if in == nil {
		return nil
	}
	out := new(BastionHost)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BlockStorageOpenstackOpts) DeepCopyInto(out *BlockStorageOpenstackOpts) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BlockStorageOpenstackOpts.
func (in *BlockStorageOpenstackOpts) DeepCopy() *BlockStorageOpenstackOpts {
	if in == nil {
		return nil
	}
	out := new(BlockStorageOpenstackOpts)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNetworkProvider) DeepCopyInto(out *CalicoNetworkProvider) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNetworkProvider.
func (in *CalicoNetworkProvider) DeepCopy() *CalicoNetworkProvider {
	if in == nil {
		return nil
	}
	out := new(CalicoNetworkProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CanalNetworkProvider) DeepCopyInto(out *CanalNetworkProvider) {
	*out = *in
	out.FlannelNetworkProvider = in.FlannelNetworkProvider
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CanalNetworkProvider.
func (in *CanalNetworkProvider) DeepCopy() *CanalNetworkProvider {
	if in == nil {
		return nil
	}
	out := new(CanalNetworkProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CloudProvider) DeepCopyInto(out *CloudProvider) {
	*out = *in
	if in.UseInstanceMetadataHostname != nil {
		in, out := &in.UseInstanceMetadataHostname, &out.UseInstanceMetadataHostname
		*out = new(bool)
		**out = **in
	}
	if in.AWSCloudProvider != nil {
		in, out := &in.AWSCloudProvider, &out.AWSCloudProvider
		*out = new(AWSCloudProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.AzureCloudProvider != nil {
		in, out := &in.AzureCloudProvider, &out.AzureCloudProvider
		*out = new(AzureCloudProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.OpenstackCloudProvider != nil {
		in, out := &in.OpenstackCloudProvider, &out.OpenstackCloudProvider
		*out = new(OpenstackCloudProvider)
		**out = **in
	}
	if in.VsphereCloudProvider != nil {
		in, out := &in.VsphereCloudProvider, &out.VsphereCloudProvider
		*out = new(VsphereCloudProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.HarvesterCloudProvider != nil {
		in, out := &in.HarvesterCloudProvider, &out.HarvesterCloudProvider
		*out = new(HarvesterCloudProvider)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CloudProvider.
func (in *CloudProvider) DeepCopy() *CloudProvider {
	if in == nil {
		return nil
	}
	out := new(CloudProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DNSConfig) DeepCopyInto(out *DNSConfig) {
	*out = *in
	if in.Options != nil {
		in, out := &in.Options, &out.Options
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.UpstreamNameservers != nil {
		in, out := &in.UpstreamNameservers, &out.UpstreamNameservers
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.ReverseCIDRs != nil {
		in, out := &in.ReverseCIDRs, &out.ReverseCIDRs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.StubDomains != nil {
		in, out := &in.StubDomains, &out.StubDomains
		*out = make(map[string][]string, len(*in))
		for key, val := range *in {
			var outVal []string
			if val == nil {
				(*out)[key] = nil
			} else {
				in, out := &val, &outVal
				*out = make([]string, len(*in))
				copy(*out, *in)
			}
			(*out)[key] = outVal
		}
	}
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Nodelocal != nil {
		in, out := &in.Nodelocal, &out.Nodelocal
		*out = new(Nodelocal)
		(*in).DeepCopyInto(*out)
	}
	if in.UpdateStrategy != nil {
		in, out := &in.UpdateStrategy, &out.UpdateStrategy
		*out = new(DeploymentStrategy)
		(*in).DeepCopyInto(*out)
	}
	if in.LinearAutoscalerParams != nil {
		in, out := &in.LinearAutoscalerParams, &out.LinearAutoscalerParams
		*out = new(LinearAutoscalerParams)
		**out = **in
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DNSConfig.
func (in *DNSConfig) DeepCopy() *DNSConfig {
	if in == nil {
		return nil
	}
	out := new(DNSConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DaemonSetUpdateStrategy) DeepCopyInto(out *DaemonSetUpdateStrategy) {
	*out = *in
	if in.RollingUpdate != nil {
		in, out := &in.RollingUpdate, &out.RollingUpdate
		*out = new(appsv1.RollingUpdateDaemonSet)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DaemonSetUpdateStrategy.
func (in *DaemonSetUpdateStrategy) DeepCopy() *DaemonSetUpdateStrategy {
	if in == nil {
		return nil
	}
	out := new(DaemonSetUpdateStrategy)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DeploymentStrategy) DeepCopyInto(out *DeploymentStrategy) {
	*out = *in
	if in.RollingUpdate != nil {
		in, out := &in.RollingUpdate, &out.RollingUpdate
		*out = new(appsv1.RollingUpdateDeployment)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DeploymentStrategy.
func (in *DeploymentStrategy) DeepCopy() *DeploymentStrategy {
	if in == nil {
		return nil
	}
	out := new(DeploymentStrategy)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DiskVsphereOpts) DeepCopyInto(out *DiskVsphereOpts) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DiskVsphereOpts.
func (in *DiskVsphereOpts) DeepCopy() *DiskVsphereOpts {
	if in == nil {
		return nil
	}
	out := new(DiskVsphereOpts)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ECRCredentialPlugin) DeepCopyInto(out *ECRCredentialPlugin) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ECRCredentialPlugin.
func (in *ECRCredentialPlugin) DeepCopy() *ECRCredentialPlugin {
	if in == nil {
		return nil
	}
	out := new(ECRCredentialPlugin)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ETCDService) DeepCopyInto(out *ETCDService) {
	*out = *in
	in.BaseService.DeepCopyInto(&out.BaseService)
	if in.ExternalURLs != nil {
		in, out := &in.ExternalURLs, &out.ExternalURLs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Snapshot != nil {
		in, out := &in.Snapshot, &out.Snapshot
		*out = new(bool)
		**out = **in
	}
	if in.BackupConfig != nil {
		in, out := &in.BackupConfig, &out.BackupConfig
		*out = new(BackupConfig)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ETCDService.
func (in *ETCDService) DeepCopy() *ETCDService {
	if in == nil {
		return nil
	}
	out := new(ETCDService)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EtcdBackupCondition) DeepCopyInto(out *EtcdBackupCondition) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EtcdBackupCondition.
func (in *EtcdBackupCondition) DeepCopy() *EtcdBackupCondition {
	if in == nil {
		return nil
	}
	out := new(EtcdBackupCondition)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EtcdBackupSpec) DeepCopyInto(out *EtcdBackupSpec) {
	*out = *in
	in.BackupConfig.DeepCopyInto(&out.BackupConfig)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EtcdBackupSpec.
func (in *EtcdBackupSpec) DeepCopy() *EtcdBackupSpec {
	if in == nil {
		return nil
	}
	out := new(EtcdBackupSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EtcdBackupStatus) DeepCopyInto(out *EtcdBackupStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]EtcdBackupCondition, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EtcdBackupStatus.
func (in *EtcdBackupStatus) DeepCopy() *EtcdBackupStatus {
	if in == nil {
		return nil
	}
	out := new(EtcdBackupStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EventRateLimit) DeepCopyInto(out *EventRateLimit) {
	*out = *in
	if in.Configuration != nil {
		in, out := &in.Configuration, &out.Configuration
		*out = new(eventratelimit.Configuration)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EventRateLimit.
func (in *EventRateLimit) DeepCopy() *EventRateLimit {
	if in == nil {
		return nil
	}
	out := new(EventRateLimit)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExtraEnv) DeepCopyInto(out *ExtraEnv) {
	*out = *in
	in.EnvVar.DeepCopyInto(&out.EnvVar)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExtraEnv.
func (in *ExtraEnv) DeepCopy() *ExtraEnv {
	if in == nil {
		return nil
	}
	out := new(ExtraEnv)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExtraVolume) DeepCopyInto(out *ExtraVolume) {
	*out = *in
	in.Volume.DeepCopyInto(&out.Volume)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExtraVolume.
func (in *ExtraVolume) DeepCopy() *ExtraVolume {
	if in == nil {
		return nil
	}
	out := new(ExtraVolume)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExtraVolumeMount) DeepCopyInto(out *ExtraVolumeMount) {
	*out = *in
	in.VolumeMount.DeepCopyInto(&out.VolumeMount)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExtraVolumeMount.
func (in *ExtraVolumeMount) DeepCopy() *ExtraVolumeMount {
	if in == nil {
		return nil
	}
	out := new(ExtraVolumeMount)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *File) DeepCopyInto(out *File) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new File.
func (in *File) DeepCopy() *File {
	if in == nil {
		return nil
	}
	out := new(File)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FlannelNetworkProvider) DeepCopyInto(out *FlannelNetworkProvider) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FlannelNetworkProvider.
func (in *FlannelNetworkProvider) DeepCopy() *FlannelNetworkProvider {
	if in == nil {
		return nil
	}
	out := new(FlannelNetworkProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GlobalAwsOpts) DeepCopyInto(out *GlobalAwsOpts) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GlobalAwsOpts.
func (in *GlobalAwsOpts) DeepCopy() *GlobalAwsOpts {
	if in == nil {
		return nil
	}
	out := new(GlobalAwsOpts)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GlobalOpenstackOpts) DeepCopyInto(out *GlobalOpenstackOpts) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GlobalOpenstackOpts.
func (in *GlobalOpenstackOpts) DeepCopy() *GlobalOpenstackOpts {
	if in == nil {
		return nil
	}
	out := new(GlobalOpenstackOpts)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GlobalVsphereOpts) DeepCopyInto(out *GlobalVsphereOpts) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GlobalVsphereOpts.
func (in *GlobalVsphereOpts) DeepCopy() *GlobalVsphereOpts {
	if in == nil {
		return nil
	}
	out := new(GlobalVsphereOpts)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HarvesterCloudProvider) DeepCopyInto(out *HarvesterCloudProvider) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HarvesterCloudProvider.
func (in *HarvesterCloudProvider) DeepCopy() *HarvesterCloudProvider {
	if in == nil {
		return nil
	}
	out := new(HarvesterCloudProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HealthCheck) DeepCopyInto(out *HealthCheck) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HealthCheck.
func (in *HealthCheck) DeepCopy() *HealthCheck {
	if in == nil {
		return nil
	}
	out := new(HealthCheck)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IngressConfig) DeepCopyInto(out *IngressConfig) {
	*out = *in
	if in.Options != nil {
		in, out := &in.Options, &out.Options
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.ExtraArgs != nil {
		in, out := &in.ExtraArgs, &out.ExtraArgs
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.ExtraEnvs != nil {
		in, out := &in.ExtraEnvs, &out.ExtraEnvs
		*out = make([]ExtraEnv, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.ExtraVolumes != nil {
		in, out := &in.ExtraVolumes, &out.ExtraVolumes
		*out = make([]ExtraVolume, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.ExtraVolumeMounts != nil {
		in, out := &in.ExtraVolumeMounts, &out.ExtraVolumeMounts
		*out = make([]ExtraVolumeMount, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.UpdateStrategy != nil {
		in, out := &in.UpdateStrategy, &out.UpdateStrategy
		*out = new(DaemonSetUpdateStrategy)
		(*in).DeepCopyInto(*out)
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.DefaultBackend != nil {
		in, out := &in.DefaultBackend, &out.DefaultBackend
		*out = new(bool)
		**out = **in
	}
	if in.DefaultIngressClass != nil {
		in, out := &in.DefaultIngressClass, &out.DefaultIngressClass
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IngressConfig.
func (in *IngressConfig) DeepCopy() *IngressConfig {
	if in == nil {
		return nil
	}
	out := new(IngressConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *K8sVersionInfo) DeepCopyInto(out *K8sVersionInfo) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new K8sVersionInfo.
func (in *K8sVersionInfo) DeepCopy() *K8sVersionInfo {
	if in == nil {
		return nil
	}
	out := new(K8sVersionInfo)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeAPIService) DeepCopyInto(out *KubeAPIService) {
	*out = *in
	in.BaseService.DeepCopyInto(&out.BaseService)
	if in.SecretsEncryptionConfig != nil {
		in, out := &in.SecretsEncryptionConfig, &out.SecretsEncryptionConfig
		*out = new(SecretsEncryptionConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.AuditLog != nil {
		in, out := &in.AuditLog, &out.AuditLog
		*out = new(AuditLog)
		(*in).DeepCopyInto(*out)
	}
	if in.AdmissionConfiguration != nil {
		in, out := &in.AdmissionConfiguration, &out.AdmissionConfiguration
		*out = new(apiserverv1.AdmissionConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.EventRateLimit != nil {
		in, out := &in.EventRateLimit, &out.EventRateLimit
		*out = new(EventRateLimit)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeAPIService.
func (in *KubeAPIService) DeepCopy() *KubeAPIService {
	if in == nil {
		return nil
	}
	out := new(KubeAPIService)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeControllerService) DeepCopyInto(out *KubeControllerService) {
	*out = *in
	in.BaseService.DeepCopyInto(&out.BaseService)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeControllerService.
func (in *KubeControllerService) DeepCopy() *KubeControllerService {
	if in == nil {
		return nil
	}
	out := new(KubeControllerService)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeletService) DeepCopyInto(out *KubeletService) {
	*out = *in
	in.BaseService.DeepCopyInto(&out.BaseService)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeletService.
func (in *KubeletService) DeepCopy() *KubeletService {
	if in == nil {
		return nil
	}
	out := new(KubeletService)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeproxyService) DeepCopyInto(out *KubeproxyService) {
	*out = *in
	in.BaseService.DeepCopyInto(&out.BaseService)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeproxyService.
func (in *KubeproxyService) DeepCopy() *KubeproxyService {
	if in == nil {
		return nil
	}
	out := new(KubeproxyService)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesServicesOptions) DeepCopyInto(out *KubernetesServicesOptions) {
	*out = *in
	if in.Etcd != nil {
		in, out := &in.Etcd, &out.Etcd
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.KubeAPI != nil {
		in, out := &in.KubeAPI, &out.KubeAPI
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Kubelet != nil {
		in, out := &in.Kubelet, &out.Kubelet
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Kubeproxy != nil {
		in, out := &in.Kubeproxy, &out.Kubeproxy
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.KubeController != nil {
		in, out := &in.KubeController, &out.KubeController
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Scheduler != nil {
		in, out := &in.Scheduler, &out.Scheduler
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesServicesOptions.
func (in *KubernetesServicesOptions) DeepCopy() *KubernetesServicesOptions {
	if in == nil {
		return nil
	}
	out := new(KubernetesServicesOptions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LinearAutoscalerParams) DeepCopyInto(out *LinearAutoscalerParams) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LinearAutoscalerParams.
func (in *LinearAutoscalerParams) DeepCopy() *LinearAutoscalerParams {
	if in == nil {
		return nil
	}
	out := new(LinearAutoscalerParams)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LoadBalancerOpenstackOpts) DeepCopyInto(out *LoadBalancerOpenstackOpts) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LoadBalancerOpenstackOpts.
func (in *LoadBalancerOpenstackOpts) DeepCopy() *LoadBalancerOpenstackOpts {
	if in == nil {
		return nil
	}
	out := new(LoadBalancerOpenstackOpts)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MetadataOpenstackOpts) DeepCopyInto(out *MetadataOpenstackOpts) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MetadataOpenstackOpts.
func (in *MetadataOpenstackOpts) DeepCopy() *MetadataOpenstackOpts {
	if in == nil {
		return nil
	}
	out := new(MetadataOpenstackOpts)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MonitoringConfig) DeepCopyInto(out *MonitoringConfig) {
	*out = *in
	if in.Options != nil {
		in, out := &in.Options, &out.Options
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.UpdateStrategy != nil {
		in, out := &in.UpdateStrategy, &out.UpdateStrategy
		*out = new(DeploymentStrategy)
		(*in).DeepCopyInto(*out)
	}
	if in.Replicas != nil {
		in, out := &in.Replicas, &out.Replicas
		*out = new(int32)
		**out = **in
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MonitoringConfig.
func (in *MonitoringConfig) DeepCopy() *MonitoringConfig {
	if in == nil {
		return nil
	}
	out := new(MonitoringConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NetworkConfig) DeepCopyInto(out *NetworkConfig) {
	*out = *in
	if in.Options != nil {
		in, out := &in.Options, &out.Options
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.CalicoNetworkProvider != nil {
		in, out := &in.CalicoNetworkProvider, &out.CalicoNetworkProvider
		*out = new(CalicoNetworkProvider)
		**out = **in
	}
	if in.CanalNetworkProvider != nil {
		in, out := &in.CanalNetworkProvider, &out.CanalNetworkProvider
		*out = new(CanalNetworkProvider)
		**out = **in
	}
	if in.FlannelNetworkProvider != nil {
		in, out := &in.FlannelNetworkProvider, &out.FlannelNetworkProvider
		*out = new(FlannelNetworkProvider)
		**out = **in
	}
	if in.WeaveNetworkProvider != nil {
		in, out := &in.WeaveNetworkProvider, &out.WeaveNetworkProvider
		*out = new(WeaveNetworkProvider)
		**out = **in
	}
	if in.AciNetworkProvider != nil {
		in, out := &in.AciNetworkProvider, &out.AciNetworkProvider
		*out = new(AciNetworkProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.UpdateStrategy != nil {
		in, out := &in.UpdateStrategy, &out.UpdateStrategy
		*out = new(DaemonSetUpdateStrategy)
		(*in).DeepCopyInto(*out)
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NetworkConfig.
func (in *NetworkConfig) DeepCopy() *NetworkConfig {
	if in == nil {
		return nil
	}
	out := new(NetworkConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NetworkVshpereOpts) DeepCopyInto(out *NetworkVshpereOpts) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NetworkVshpereOpts.
func (in *NetworkVshpereOpts) DeepCopy() *NetworkVshpereOpts {
	if in == nil {
		return nil
	}
	out := new(NetworkVshpereOpts)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NodeDrainInput) DeepCopyInto(out *NodeDrainInput) {
	*out = *in
	if in.IgnoreDaemonSets != nil {
		in, out := &in.IgnoreDaemonSets, &out.IgnoreDaemonSets
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NodeDrainInput.
func (in *NodeDrainInput) DeepCopy() *NodeDrainInput {
	if in == nil {
		return nil
	}
	out := new(NodeDrainInput)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NodeUpgradeStrategy) DeepCopyInto(out *NodeUpgradeStrategy) {
	*out = *in
	if in.Drain != nil {
		in, out := &in.Drain, &out.Drain
		*out = new(bool)
		**out = **in
	}
	if in.DrainInput != nil {
		in, out := &in.DrainInput, &out.DrainInput
		*out = new(NodeDrainInput)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NodeUpgradeStrategy.
func (in *NodeUpgradeStrategy) DeepCopy() *NodeUpgradeStrategy {
	if in == nil {
		return nil
	}
	out := new(NodeUpgradeStrategy)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Nodelocal) DeepCopyInto(out *Nodelocal) {
	*out = *in
	if in.UpdateStrategy != nil {
		in, out := &in.UpdateStrategy, &out.UpdateStrategy
		*out = new(DaemonSetUpdateStrategy)
		(*in).DeepCopyInto(*out)
	}
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Nodelocal.
func (in *Nodelocal) DeepCopy() *Nodelocal {
	if in == nil {
		return nil
	}
	out := new(Nodelocal)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OpenstackCloudProvider) DeepCopyInto(out *OpenstackCloudProvider) {
	*out = *in
	out.Global = in.Global
	out.LoadBalancer = in.LoadBalancer
	out.BlockStorage = in.BlockStorage
	out.Route = in.Route
	out.Metadata = in.Metadata
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OpenstackCloudProvider.
func (in *OpenstackCloudProvider) DeepCopy() *OpenstackCloudProvider {
	if in == nil {
		return nil
	}
	out := new(OpenstackCloudProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PortCheck) DeepCopyInto(out *PortCheck) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PortCheck.
func (in *PortCheck) DeepCopy() *PortCheck {
	if in == nil {
		return nil
	}
	out := new(PortCheck)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PrivateRegistry) DeepCopyInto(out *PrivateRegistry) {
	*out = *in
	if in.ECRCredentialPlugin != nil {
		in, out := &in.ECRCredentialPlugin, &out.ECRCredentialPlugin
		*out = new(ECRCredentialPlugin)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PrivateRegistry.
func (in *PrivateRegistry) DeepCopy() *PrivateRegistry {
	if in == nil {
		return nil
	}
	out := new(PrivateRegistry)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Process) DeepCopyInto(out *Process) {
	*out = *in
	if in.Command != nil {
		in, out := &in.Command, &out.Command
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Args != nil {
		in, out := &in.Args, &out.Args
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.VolumesFrom != nil {
		in, out := &in.VolumesFrom, &out.VolumesFrom
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Binds != nil {
		in, out := &in.Binds, &out.Binds
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	out.HealthCheck = in.HealthCheck
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Publish != nil {
		in, out := &in.Publish, &out.Publish
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Process.
func (in *Process) DeepCopy() *Process {
	if in == nil {
		return nil
	}
	out := new(Process)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RKEConfigNode) DeepCopyInto(out *RKEConfigNode) {
	*out = *in
	if in.Role != nil {
		in, out := &in.Role, &out.Role
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Taints != nil {
		in, out := &in.Taints, &out.Taints
		*out = make([]RKETaint, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RKEConfigNode.
func (in *RKEConfigNode) DeepCopy() *RKEConfigNode {
	if in == nil {
		return nil
	}
	out := new(RKEConfigNode)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RKEConfigNodePlan) DeepCopyInto(out *RKEConfigNodePlan) {
	*out = *in
	if in.Processes != nil {
		in, out := &in.Processes, &out.Processes
		*out = make(map[string]Process, len(*in))
		for key, val := range *in {
			(*out)[key] = *val.DeepCopy()
		}
	}
	if in.PortChecks != nil {
		in, out := &in.PortChecks, &out.PortChecks
		*out = make([]PortCheck, len(*in))
		copy(*out, *in)
	}
	if in.Files != nil {
		in, out := &in.Files, &out.Files
		*out = make([]File, len(*in))
		copy(*out, *in)
	}
	if in.Annotations != nil {
		in, out := &in.Annotations, &out.Annotations
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Taints != nil {
		in, out := &in.Taints, &out.Taints
		*out = make([]RKETaint, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RKEConfigNodePlan.
func (in *RKEConfigNodePlan) DeepCopy() *RKEConfigNodePlan {
	if in == nil {
		return nil
	}
	out := new(RKEConfigNodePlan)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RKEConfigServices) DeepCopyInto(out *RKEConfigServices) {
	*out = *in
	in.Etcd.DeepCopyInto(&out.Etcd)
	in.KubeAPI.DeepCopyInto(&out.KubeAPI)
	in.KubeController.DeepCopyInto(&out.KubeController)
	in.Scheduler.DeepCopyInto(&out.Scheduler)
	in.Kubelet.DeepCopyInto(&out.Kubelet)
	in.Kubeproxy.DeepCopyInto(&out.Kubeproxy)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RKEConfigServices.
func (in *RKEConfigServices) DeepCopy() *RKEConfigServices {
	if in == nil {
		return nil
	}
	out := new(RKEConfigServices)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RKEPlan) DeepCopyInto(out *RKEPlan) {
	*out = *in
	if in.Nodes != nil {
		in, out := &in.Nodes, &out.Nodes
		*out = make([]RKEConfigNodePlan, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RKEPlan.
func (in *RKEPlan) DeepCopy() *RKEPlan {
	if in == nil {
		return nil
	}
	out := new(RKEPlan)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RKESystemImages) DeepCopyInto(out *RKESystemImages) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RKESystemImages.
func (in *RKESystemImages) DeepCopy() *RKESystemImages {
	if in == nil {
		return nil
	}
	out := new(RKESystemImages)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RKETaint) DeepCopyInto(out *RKETaint) {
	*out = *in
	if in.TimeAdded != nil {
		in, out := &in.TimeAdded, &out.TimeAdded
		*out = (*in).DeepCopy()
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RKETaint.
func (in *RKETaint) DeepCopy() *RKETaint {
	if in == nil {
		return nil
	}
	out := new(RKETaint)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RancherKubernetesEngineConfig) DeepCopyInto(out *RancherKubernetesEngineConfig) {
	*out = *in
	if in.Nodes != nil {
		in, out := &in.Nodes, &out.Nodes
		*out = make([]RKEConfigNode, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	in.Services.DeepCopyInto(&out.Services)
	in.Network.DeepCopyInto(&out.Network)
	in.Authentication.DeepCopyInto(&out.Authentication)
	if in.AddonsInclude != nil {
		in, out := &in.AddonsInclude, &out.AddonsInclude
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	out.SystemImages = in.SystemImages
	in.Authorization.DeepCopyInto(&out.Authorization)
	if in.IgnoreDockerVersion != nil {
		in, out := &in.IgnoreDockerVersion, &out.IgnoreDockerVersion
		*out = new(bool)
		**out = **in
	}
	if in.EnableCRIDockerd != nil {
		in, out := &in.EnableCRIDockerd, &out.EnableCRIDockerd
		*out = new(bool)
		**out = **in
	}
	if in.PrivateRegistries != nil {
		in, out := &in.PrivateRegistries, &out.PrivateRegistries
		*out = make([]PrivateRegistry, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	in.Ingress.DeepCopyInto(&out.Ingress)
	in.CloudProvider.DeepCopyInto(&out.CloudProvider)
	out.BastionHost = in.BastionHost
	in.Monitoring.DeepCopyInto(&out.Monitoring)
	out.Restore = in.Restore
	if in.RotateCertificates != nil {
		in, out := &in.RotateCertificates, &out.RotateCertificates
		*out = new(RotateCertificates)
		(*in).DeepCopyInto(*out)
	}
	if in.DNS != nil {
		in, out := &in.DNS, &out.DNS
		*out = new(DNSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.UpgradeStrategy != nil {
		in, out := &in.UpgradeStrategy, &out.UpgradeStrategy
		*out = new(NodeUpgradeStrategy)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RancherKubernetesEngineConfig.
func (in *RancherKubernetesEngineConfig) DeepCopy() *RancherKubernetesEngineConfig {
	if in == nil {
		return nil
	}
	out := new(RancherKubernetesEngineConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RestoreConfig) DeepCopyInto(out *RestoreConfig) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RestoreConfig.
func (in *RestoreConfig) DeepCopy() *RestoreConfig {
	if in == nil {
		return nil
	}
	out := new(RestoreConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RotateCertificates) DeepCopyInto(out *RotateCertificates) {
	*out = *in
	if in.Services != nil {
		in, out := &in.Services, &out.Services
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RotateCertificates.
func (in *RotateCertificates) DeepCopy() *RotateCertificates {
	if in == nil {
		return nil
	}
	out := new(RotateCertificates)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RouteOpenstackOpts) DeepCopyInto(out *RouteOpenstackOpts) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RouteOpenstackOpts.
func (in *RouteOpenstackOpts) DeepCopy() *RouteOpenstackOpts {
	if in == nil {
		return nil
	}
	out := new(RouteOpenstackOpts)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *S3BackupConfig) DeepCopyInto(out *S3BackupConfig) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new S3BackupConfig.
func (in *S3BackupConfig) DeepCopy() *S3BackupConfig {
	if in == nil {
		return nil
	}
	out := new(S3BackupConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SchedulerService) DeepCopyInto(out *SchedulerService) {
	*out = *in
	in.BaseService.DeepCopyInto(&out.BaseService)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SchedulerService.
func (in *SchedulerService) DeepCopy() *SchedulerService {
	if in == nil {
		return nil
	}
	out := new(SchedulerService)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SecretsEncryptionConfig) DeepCopyInto(out *SecretsEncryptionConfig) {
	*out = *in
	if in.CustomConfig != nil {
		in, out := &in.CustomConfig, &out.CustomConfig
		*out = new(apiserverv1.EncryptionConfiguration)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SecretsEncryptionConfig.
func (in *SecretsEncryptionConfig) DeepCopy() *SecretsEncryptionConfig {
	if in == nil {
		return nil
	}
	out := new(SecretsEncryptionConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ServiceOverride) DeepCopyInto(out *ServiceOverride) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ServiceOverride.
func (in *ServiceOverride) DeepCopy() *ServiceOverride {
	if in == nil {
		return nil
	}
	out := new(ServiceOverride)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VirtualCenterConfig) DeepCopyInto(out *VirtualCenterConfig) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VirtualCenterConfig.
func (in *VirtualCenterConfig) DeepCopy() *VirtualCenterConfig {
	if in == nil {
		return nil
	}
	out := new(VirtualCenterConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VsphereCloudProvider) DeepCopyInto(out *VsphereCloudProvider) {
	*out = *in
	out.Global = in.Global
	if in.VirtualCenter != nil {
		in, out := &in.VirtualCenter, &out.VirtualCenter
		*out = make(map[string]VirtualCenterConfig, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	out.Network = in.Network
	out.Disk = in.Disk
	out.Workspace = in.Workspace
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VsphereCloudProvider.
func (in *VsphereCloudProvider) DeepCopy() *VsphereCloudProvider {
	if in == nil {
		return nil
	}
	out := new(VsphereCloudProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WeaveNetworkProvider) DeepCopyInto(out *WeaveNetworkProvider) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WeaveNetworkProvider.
func (in *WeaveNetworkProvider) DeepCopy() *WeaveNetworkProvider {
	if in == nil {
		return nil
	}
	out := new(WeaveNetworkProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WorkspaceVsphereOpts) DeepCopyInto(out *WorkspaceVsphereOpts) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WorkspaceVsphereOpts.
func (in *WorkspaceVsphereOpts) DeepCopy() *WorkspaceVsphereOpts {
	if in == nil {
		return nil
	}
	out := new(WorkspaceVsphereOpts)
	in.DeepCopyInto(out)
	return out
}
