---
title: "rclone copyurl"
description: "Copy the contents of the URL supplied content to dest:path."
versionIntroduced: v1.43
# autogenerated - DO NOT EDIT, instead edit the source code in cmd/copyurl/ and as part of making a release run "make commanddocs"
---
# rclone copyurl

Copy the contents of the URL supplied content to dest:path.

## Synopsis

Download a URL's content and copy it to the destination without saving
it in temporary storage.

Setting `--auto-filename` will attempt to automatically determine the
filename from the URL (after any redirections) and used in the
destination path.

With `--header-filename` in addition, if a specific filename is
set in HTTP headers, it will be used instead of the name from the URL.
With `--print-filename` in addition, the resulting file name will be
printed.

Setting `--no-clobber` will prevent overwriting file on the 
destination if there is one with the same name.

Setting `--stdout` or making the output file name `-`
will cause the output to be written to standard output.

## Troubleshooting

If you can't get `rclone copyurl` to work then here are some things you can try:

- `--disable-http2` rclone will use HTTP2 if available - try disabling it
- `--bind 0.0.0.0` rclone will use IPv6 if available - try disabling it
- `--bind ::0` to disable IPv4
- `--user agent curl` - some sites have whitelists for curl's user-agent - try that
- Make sure the site works with `curl` directly



```
rclone copyurl https://example.com dest:path [flags]
```

## Options

```
  -a, --auto-filename     Get the file name from the URL and use it for destination file path
      --header-filename   Get the file name from the Content-Disposition header
  -h, --help              help for copyurl
      --no-clobber        Prevent overwriting file with same name
  -p, --print-filename    Print the resulting name from --auto-filename
      --stdout            Write the output to stdout rather than a file
```

Options shared with other commands are described next.
See the [global flags page](/flags/) for global options not listed here.

### Important Options

Important flags useful for most commands

```
  -n, --dry-run         Do a trial run with no permanent changes
  -i, --interactive     Enable interactive mode
  -v, --verbose count   Print lots more stuff (repeat for more)
```

## See Also

* [rclone](/commands/rclone/)	 - Show help for rclone commands, flags and backends.

