---
title: v1.5.0
weight: 998995000
---

## For Go-based operators, migrate your project to use the project version stable.

The PROJECT version config file represents the project configuration. It reach the maturate stability and it will store the data used to do the scaffolds. The motivation for this behaviour is to allow tools and helpers in the future such as to make easier the process to update the projects to use upper versions. More info: TBD. //TODO: add link for docs (see the PR kubernetes-sigs/kubebuilder#1916)

_See [#4402](https://github.com/operator-framework/operator-sdk/pull/4402) for more details._

## PROJECT config version 3-alpha must be upgraded to 3.

PROJECT config version 3-alpha has been stabilized as [version 3](https://github.com/kubernetes-sigs/kubebuilder/blob/master/docs/book/src/migration/legacy/manually_migration_guide_v2_v3.md) (the `version` key in your PROJECT file), and contains a set of config fields sufficient to fully describe a project. While this change is not technically breaking because the spec at that version was alpha, it was used by default in `operator-sdk` commands so should be marked as breaking and have a convenient migration path. The `alpha config-3alpha-to-3` command will convert most of your PROJECT file from version 3-alpha to 3, and leave comments with directions where automatic conversion is not possible:

```console
$ cat PROJECT
version: 3-alpha
resources:
- crdVersion: v1
...

$ operator-sdk alpha config-3alpha-to-3
Your PROJECT config file has been converted from version 3-alpha to 3. Please make sure all config data is correct.
$ cat PROJECT
version: "3" 
esources:
- api:
  crdVersion: v1
...
```

_See [#4613](https://github.com/operator-framework/operator-sdk/pull/4613) for more details._

## (go/v3) Upgrade controller-runtime to v0.7.2.

In your go.mod file, upgrade `sigs.k8s.io/controller-runtime` to v0.7.2.

_See [#4626](https://github.com/operator-framework/operator-sdk/pull/4626) for more details._

## (go/v3) Add a `system:controller-manager` ServiceAccount to your project.

A non-default ServiceAccount `controller-manager` is scaffolded on `operator-sdk init`, to improve security for operators installed in shared namespaces. To add this ServiceAccount to your project, do the following:

```sh
# Create the ServiceAccount.
cat <<EOF > config/rbac/service_account.yaml
apiVersion: v1
kind: ServiceAccount
metadata:
  name: controller-manager
  namespace: system
EOF

# Add it to the list of RBAC resources.
echo "- service_account.yaml" >> config/rbac/kustomization.yaml

# Update all RoleBinding and ClusterRoleBinding subjects that reference the operator's ServiceAccount.
find config/rbac -name *_binding.yaml -exec sed -i -E 's/  name: default/  name: controller-manager/g' {} \;

# Add the ServiceAccount name to the manager Deployment's spec.template.spec.serviceAccountName.
sed -i -E 's/([ ]+)(terminationGracePeriodSeconds:)/\1serviceAccountName: controller-manager\n\1\2/g' config/manager/manager.yaml
```

The changes should look like:
```diff 
# config/manager/manager.yaml
           requests:
             cpu: 100m
             memory: 20Mi
+      serviceAccountName: controller-manager
       terminationGracePeriodSeconds: 10

# config/rbac/auth_proxy_role_binding.yaml
   name: proxy-role
 subjects:
 - kind: ServiceAccount
-  name: default 
+  name: controller-manager
   namespace: system

# config/rbac/kustomization.yaml
 resources:
+- service_account.yaml
 - role.yaml
 - role_binding.yaml
 - leader_election_role.yaml

# config/rbac/leader_election_role_binding.yaml
   name: leader-election-role
 subjects:
 - kind: ServiceAccount
-  name: default 
+  name: controller-manager
   namespace: system

# config/rbac/role_binding.yaml
   name: manager-role
 subjects:
 - kind: ServiceAccount
-  name: default 
+  name: controller-manager
   namespace: system

# config/rbac/service_account.yaml
+apiVersion: v1
+kind: ServiceAccount
+metadata:
+  name: controller-manager
+  namespace: system
```

_See [#4626](https://github.com/operator-framework/operator-sdk/pull/4626) for more details._

## (ansible/v1, helm/v1) Swap the paths of liveness/readiness probes in `config/manager/manager.yaml`.

The liveness and readiness probe endpoints were incorrectly named, although this mismatch will not affect their behavior. To fix, swap the `readinessProbe` and `livenessProbe` HTTP paths in `config/manager/manager.yaml`:

```yaml
  livenessProbe:
    httpGet:
      path: /healthz
      port: 6789
    initialDelaySeconds: 15
    periodSeconds: 20
  readinessProbe:
    httpGet:
      path: /readyz
      port: 6789
    initialDelaySeconds: 5
    periodSeconds: 10
```

_See [#4546](https://github.com/operator-framework/operator-sdk/pull/4546) for more details._
