// Code generated by gotmpl. DO NOT MODIFY.
// source: internal/shared/counter/counter_test.go.tmpl

// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

package counter

import (
	"sync"
	"testing"
)

func TestNextExporterID(t *testing.T) {
	SetExporterID(0)

	var expected int64
	for range 10 {
		id := NextExporterID()
		if id != expected {
			t.Errorf("NextExporterID() = %d; want %d", id, expected)
		}
		expected++
	}
}

func TestSetExporterID(t *testing.T) {
	SetExporterID(0)

	prev := SetExporterID(42)
	if prev != 0 {
		t.Errorf("SetExporterID(42) returned %d; want 0", prev)
	}

	id := NextExporterID()
	if id != 42 {
		t.Errorf("NextExporterID() = %d; want 42", id)
	}
}

func TestNextExporterIDConcurrentSafe(t *testing.T) {
	SetExporterID(0)

	const goroutines = 100
	const increments = 10

	var wg sync.WaitGroup
	wg.Add(goroutines)

	for range goroutines {
		go func() {
			defer wg.Done()
			for range increments {
				NextExporterID()
			}
		}()
	}

	wg.Wait()

	expected := int64(goroutines * increments)
	if id := NextExporterID(); id != expected {
		t.Errorf("NextExporterID() = %d; want %d", id, expected)
	}
}