# HTTP Client-Server Example

An HTTP client connects to an HTTP server. They both generate span information to `stdout`.
These instructions expect you have [docker-compose](https://docs.docker.com/compose/) installed.

Bring up the `http-server` and `http-client` services to run the example:
```sh
docker-compose up --detach http-server http-client
```

The `http-client` service sends just one HTTP request to `http-server` and then exits. View the span and metric generated to `stdout` in the logs:
```sh
docker-compose logs http-client
```

View the span generated by `http-server` in the logs:
```sh
docker-compose logs http-server
```

Shut down the services when you are finished with the example:
```sh
docker-compose down
```
