# gin-gonic instrumentation example

An HTTP server using gin-gonic and instrumentation. The server has a
`/users/:id` endpoint. The server generates span information to
`stdout`.

These instructions expect you have
[docker-compose](https://docs.docker.com/compose/) installed.

Bring up the `gin-server` and `gin-client` services to run the
example:

```sh
docker-compose up --detach gin-server gin-client
```

The `gin-client` service sends just one HTTP request to `gin-server`
and then exits. View the span generated by `gin-server` in the logs:

```sh
docker-compose logs gin-server
```

Shut down the services when you are finished with the example:

```sh
docker-compose down
```
