// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1 "github.com/openshift/api/operator/v1"
	operatorv1 "github.com/openshift/client-go/operator/applyconfigurations/operator/v1"
	scheme "github.com/openshift/client-go/operator/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// OpenShiftControllerManagersGetter has a method to return a OpenShiftControllerManagerInterface.
// A group's client should implement this interface.
type OpenShiftControllerManagersGetter interface {
	OpenShiftControllerManagers() OpenShiftControllerManagerInterface
}

// OpenShiftControllerManagerInterface has methods to work with OpenShiftControllerManager resources.
type OpenShiftControllerManagerInterface interface {
	Create(ctx context.Context, openShiftControllerManager *v1.OpenShiftControllerManager, opts metav1.CreateOptions) (*v1.OpenShiftControllerManager, error)
	Update(ctx context.Context, openShiftControllerManager *v1.OpenShiftControllerManager, opts metav1.UpdateOptions) (*v1.OpenShiftControllerManager, error)
	UpdateStatus(ctx context.Context, openShiftControllerManager *v1.OpenShiftControllerManager, opts metav1.UpdateOptions) (*v1.OpenShiftControllerManager, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.OpenShiftControllerManager, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.OpenShiftControllerManagerList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.OpenShiftControllerManager, err error)
	Apply(ctx context.Context, openShiftControllerManager *operatorv1.OpenShiftControllerManagerApplyConfiguration, opts metav1.ApplyOptions) (result *v1.OpenShiftControllerManager, err error)
	ApplyStatus(ctx context.Context, openShiftControllerManager *operatorv1.OpenShiftControllerManagerApplyConfiguration, opts metav1.ApplyOptions) (result *v1.OpenShiftControllerManager, err error)
	OpenShiftControllerManagerExpansion
}

// openShiftControllerManagers implements OpenShiftControllerManagerInterface
type openShiftControllerManagers struct {
	client rest.Interface
}

// newOpenShiftControllerManagers returns a OpenShiftControllerManagers
func newOpenShiftControllerManagers(c *OperatorV1Client) *openShiftControllerManagers {
	return &openShiftControllerManagers{
		client: c.RESTClient(),
	}
}

// Get takes name of the openShiftControllerManager, and returns the corresponding openShiftControllerManager object, and an error if there is any.
func (c *openShiftControllerManagers) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.OpenShiftControllerManager, err error) {
	result = &v1.OpenShiftControllerManager{}
	err = c.client.Get().
		Resource("openshiftcontrollermanagers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of OpenShiftControllerManagers that match those selectors.
func (c *openShiftControllerManagers) List(ctx context.Context, opts metav1.ListOptions) (result *v1.OpenShiftControllerManagerList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.OpenShiftControllerManagerList{}
	err = c.client.Get().
		Resource("openshiftcontrollermanagers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested openShiftControllerManagers.
func (c *openShiftControllerManagers) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("openshiftcontrollermanagers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a openShiftControllerManager and creates it.  Returns the server's representation of the openShiftControllerManager, and an error, if there is any.
func (c *openShiftControllerManagers) Create(ctx context.Context, openShiftControllerManager *v1.OpenShiftControllerManager, opts metav1.CreateOptions) (result *v1.OpenShiftControllerManager, err error) {
	result = &v1.OpenShiftControllerManager{}
	err = c.client.Post().
		Resource("openshiftcontrollermanagers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(openShiftControllerManager).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a openShiftControllerManager and updates it. Returns the server's representation of the openShiftControllerManager, and an error, if there is any.
func (c *openShiftControllerManagers) Update(ctx context.Context, openShiftControllerManager *v1.OpenShiftControllerManager, opts metav1.UpdateOptions) (result *v1.OpenShiftControllerManager, err error) {
	result = &v1.OpenShiftControllerManager{}
	err = c.client.Put().
		Resource("openshiftcontrollermanagers").
		Name(openShiftControllerManager.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(openShiftControllerManager).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *openShiftControllerManagers) UpdateStatus(ctx context.Context, openShiftControllerManager *v1.OpenShiftControllerManager, opts metav1.UpdateOptions) (result *v1.OpenShiftControllerManager, err error) {
	result = &v1.OpenShiftControllerManager{}
	err = c.client.Put().
		Resource("openshiftcontrollermanagers").
		Name(openShiftControllerManager.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(openShiftControllerManager).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the openShiftControllerManager and deletes it. Returns an error if one occurs.
func (c *openShiftControllerManagers) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("openshiftcontrollermanagers").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *openShiftControllerManagers) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("openshiftcontrollermanagers").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched openShiftControllerManager.
func (c *openShiftControllerManagers) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.OpenShiftControllerManager, err error) {
	result = &v1.OpenShiftControllerManager{}
	err = c.client.Patch(pt).
		Resource("openshiftcontrollermanagers").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied openShiftControllerManager.
func (c *openShiftControllerManagers) Apply(ctx context.Context, openShiftControllerManager *operatorv1.OpenShiftControllerManagerApplyConfiguration, opts metav1.ApplyOptions) (result *v1.OpenShiftControllerManager, err error) {
	if openShiftControllerManager == nil {
		return nil, fmt.Errorf("openShiftControllerManager provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(openShiftControllerManager)
	if err != nil {
		return nil, err
	}
	name := openShiftControllerManager.Name
	if name == nil {
		return nil, fmt.Errorf("openShiftControllerManager.Name must be provided to Apply")
	}
	result = &v1.OpenShiftControllerManager{}
	err = c.client.Patch(types.ApplyPatchType).
		Resource("openshiftcontrollermanagers").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *openShiftControllerManagers) ApplyStatus(ctx context.Context, openShiftControllerManager *operatorv1.OpenShiftControllerManagerApplyConfiguration, opts metav1.ApplyOptions) (result *v1.OpenShiftControllerManager, err error) {
	if openShiftControllerManager == nil {
		return nil, fmt.Errorf("openShiftControllerManager provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(openShiftControllerManager)
	if err != nil {
		return nil, err
	}

	name := openShiftControllerManager.Name
	if name == nil {
		return nil, fmt.Errorf("openShiftControllerManager.Name must be provided to Apply")
	}

	result = &v1.OpenShiftControllerManager{}
	err = c.client.Patch(types.ApplyPatchType).
		Resource("openshiftcontrollermanagers").
		Name(*name).
		SubResource("status").
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
