// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "github.com/openshift/api/image/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	testing "k8s.io/client-go/testing"
)

// FakeImageTags implements ImageTagInterface
type FakeImageTags struct {
	Fake *FakeImageV1
	ns   string
}

var imagetagsResource = v1.SchemeGroupVersion.WithResource("imagetags")

var imagetagsKind = v1.SchemeGroupVersion.WithKind("ImageTag")

// Get takes name of the imageTag, and returns the corresponding imageTag object, and an error if there is any.
func (c *FakeImageTags) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.ImageTag, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(imagetagsResource, c.ns, name), &v1.ImageTag{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.ImageTag), err
}

// List takes label and field selectors, and returns the list of ImageTags that match those selectors.
func (c *FakeImageTags) List(ctx context.Context, opts metav1.ListOptions) (result *v1.ImageTagList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(imagetagsResource, imagetagsKind, c.ns, opts), &v1.ImageTagList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.ImageTagList{ListMeta: obj.(*v1.ImageTagList).ListMeta}
	for _, item := range obj.(*v1.ImageTagList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Create takes the representation of a imageTag and creates it.  Returns the server's representation of the imageTag, and an error, if there is any.
func (c *FakeImageTags) Create(ctx context.Context, imageTag *v1.ImageTag, opts metav1.CreateOptions) (result *v1.ImageTag, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(imagetagsResource, c.ns, imageTag), &v1.ImageTag{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.ImageTag), err
}

// Update takes the representation of a imageTag and updates it. Returns the server's representation of the imageTag, and an error, if there is any.
func (c *FakeImageTags) Update(ctx context.Context, imageTag *v1.ImageTag, opts metav1.UpdateOptions) (result *v1.ImageTag, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(imagetagsResource, c.ns, imageTag), &v1.ImageTag{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.ImageTag), err
}

// Delete takes name of the imageTag and deletes it. Returns an error if one occurs.
func (c *FakeImageTags) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(imagetagsResource, c.ns, name, opts), &v1.ImageTag{})

	return err
}
