// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1 "github.com/openshift/api/config/v1"
	configv1 "github.com/openshift/client-go/config/applyconfigurations/config/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeImageContentPolicies implements ImageContentPolicyInterface
type FakeImageContentPolicies struct {
	Fake *FakeConfigV1
}

var imagecontentpoliciesResource = v1.SchemeGroupVersion.WithResource("imagecontentpolicies")

var imagecontentpoliciesKind = v1.SchemeGroupVersion.WithKind("ImageContentPolicy")

// Get takes name of the imageContentPolicy, and returns the corresponding imageContentPolicy object, and an error if there is any.
func (c *FakeImageContentPolicies) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.ImageContentPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(imagecontentpoliciesResource, name), &v1.ImageContentPolicy{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.ImageContentPolicy), err
}

// List takes label and field selectors, and returns the list of ImageContentPolicies that match those selectors.
func (c *FakeImageContentPolicies) List(ctx context.Context, opts metav1.ListOptions) (result *v1.ImageContentPolicyList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(imagecontentpoliciesResource, imagecontentpoliciesKind, opts), &v1.ImageContentPolicyList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.ImageContentPolicyList{ListMeta: obj.(*v1.ImageContentPolicyList).ListMeta}
	for _, item := range obj.(*v1.ImageContentPolicyList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested imageContentPolicies.
func (c *FakeImageContentPolicies) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(imagecontentpoliciesResource, opts))
}

// Create takes the representation of a imageContentPolicy and creates it.  Returns the server's representation of the imageContentPolicy, and an error, if there is any.
func (c *FakeImageContentPolicies) Create(ctx context.Context, imageContentPolicy *v1.ImageContentPolicy, opts metav1.CreateOptions) (result *v1.ImageContentPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(imagecontentpoliciesResource, imageContentPolicy), &v1.ImageContentPolicy{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.ImageContentPolicy), err
}

// Update takes the representation of a imageContentPolicy and updates it. Returns the server's representation of the imageContentPolicy, and an error, if there is any.
func (c *FakeImageContentPolicies) Update(ctx context.Context, imageContentPolicy *v1.ImageContentPolicy, opts metav1.UpdateOptions) (result *v1.ImageContentPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(imagecontentpoliciesResource, imageContentPolicy), &v1.ImageContentPolicy{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.ImageContentPolicy), err
}

// Delete takes name of the imageContentPolicy and deletes it. Returns an error if one occurs.
func (c *FakeImageContentPolicies) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteActionWithOptions(imagecontentpoliciesResource, name, opts), &v1.ImageContentPolicy{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeImageContentPolicies) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(imagecontentpoliciesResource, listOpts)

	_, err := c.Fake.Invokes(action, &v1.ImageContentPolicyList{})
	return err
}

// Patch applies the patch and returns the patched imageContentPolicy.
func (c *FakeImageContentPolicies) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ImageContentPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(imagecontentpoliciesResource, name, pt, data, subresources...), &v1.ImageContentPolicy{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.ImageContentPolicy), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied imageContentPolicy.
func (c *FakeImageContentPolicies) Apply(ctx context.Context, imageContentPolicy *configv1.ImageContentPolicyApplyConfiguration, opts metav1.ApplyOptions) (result *v1.ImageContentPolicy, err error) {
	if imageContentPolicy == nil {
		return nil, fmt.Errorf("imageContentPolicy provided to Apply must not be nil")
	}
	data, err := json.Marshal(imageContentPolicy)
	if err != nil {
		return nil, err
	}
	name := imageContentPolicy.Name
	if name == nil {
		return nil, fmt.Errorf("imageContentPolicy.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(imagecontentpoliciesResource, *name, types.ApplyPatchType, data), &v1.ImageContentPolicy{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.ImageContentPolicy), err
}
