// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	apibuildv1 "github.com/openshift/api/build/v1"
	internal "github.com/openshift/client-go/build/applyconfigurations/internal"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	managedfields "k8s.io/apimachinery/pkg/util/managedfields"
	v1 "k8s.io/client-go/applyconfigurations/meta/v1"
)

// BuildConfigApplyConfiguration represents an declarative configuration of the BuildConfig type for use
// with apply.
type BuildConfigApplyConfiguration struct {
	v1.TypeMetaApplyConfiguration    `json:",inline"`
	*v1.ObjectMetaApplyConfiguration `json:"metadata,omitempty"`
	Spec                             *BuildConfigSpecApplyConfiguration   `json:"spec,omitempty"`
	Status                           *BuildConfigStatusApplyConfiguration `json:"status,omitempty"`
}

// BuildConfig constructs an declarative configuration of the BuildConfig type for use with
// apply.
func BuildConfig(name, namespace string) *BuildConfigApplyConfiguration {
	b := &BuildConfigApplyConfiguration{}
	b.WithName(name)
	b.WithNamespace(namespace)
	b.WithKind("BuildConfig")
	b.WithAPIVersion("build.openshift.io/v1")
	return b
}

// ExtractBuildConfig extracts the applied configuration owned by fieldManager from
// buildConfig. If no managedFields are found in buildConfig for fieldManager, a
// BuildConfigApplyConfiguration is returned with only the Name, Namespace (if applicable),
// APIVersion and Kind populated. It is possible that no managed fields were found for because other
// field managers have taken ownership of all the fields previously owned by fieldManager, or because
// the fieldManager never owned fields any fields.
// buildConfig must be a unmodified BuildConfig API object that was retrieved from the Kubernetes API.
// ExtractBuildConfig provides a way to perform a extract/modify-in-place/apply workflow.
// Note that an extracted apply configuration will contain fewer fields than what the fieldManager previously
// applied if another fieldManager has updated or force applied any of the previously applied fields.
// Experimental!
func ExtractBuildConfig(buildConfig *apibuildv1.BuildConfig, fieldManager string) (*BuildConfigApplyConfiguration, error) {
	return extractBuildConfig(buildConfig, fieldManager, "")
}

// ExtractBuildConfigStatus is the same as ExtractBuildConfig except
// that it extracts the status subresource applied configuration.
// Experimental!
func ExtractBuildConfigStatus(buildConfig *apibuildv1.BuildConfig, fieldManager string) (*BuildConfigApplyConfiguration, error) {
	return extractBuildConfig(buildConfig, fieldManager, "status")
}

func extractBuildConfig(buildConfig *apibuildv1.BuildConfig, fieldManager string, subresource string) (*BuildConfigApplyConfiguration, error) {
	b := &BuildConfigApplyConfiguration{}
	err := managedfields.ExtractInto(buildConfig, internal.Parser().Type("com.github.openshift.api.build.v1.BuildConfig"), fieldManager, b, subresource)
	if err != nil {
		return nil, err
	}
	b.WithName(buildConfig.Name)
	b.WithNamespace(buildConfig.Namespace)

	b.WithKind("BuildConfig")
	b.WithAPIVersion("build.openshift.io/v1")
	return b, nil
}

// WithKind sets the Kind field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Kind field is set to the value of the last call.
func (b *BuildConfigApplyConfiguration) WithKind(value string) *BuildConfigApplyConfiguration {
	b.Kind = &value
	return b
}

// WithAPIVersion sets the APIVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the APIVersion field is set to the value of the last call.
func (b *BuildConfigApplyConfiguration) WithAPIVersion(value string) *BuildConfigApplyConfiguration {
	b.APIVersion = &value
	return b
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *BuildConfigApplyConfiguration) WithName(value string) *BuildConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.Name = &value
	return b
}

// WithGenerateName sets the GenerateName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the GenerateName field is set to the value of the last call.
func (b *BuildConfigApplyConfiguration) WithGenerateName(value string) *BuildConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.GenerateName = &value
	return b
}

// WithNamespace sets the Namespace field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Namespace field is set to the value of the last call.
func (b *BuildConfigApplyConfiguration) WithNamespace(value string) *BuildConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.Namespace = &value
	return b
}

// WithUID sets the UID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the UID field is set to the value of the last call.
func (b *BuildConfigApplyConfiguration) WithUID(value types.UID) *BuildConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.UID = &value
	return b
}

// WithResourceVersion sets the ResourceVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ResourceVersion field is set to the value of the last call.
func (b *BuildConfigApplyConfiguration) WithResourceVersion(value string) *BuildConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ResourceVersion = &value
	return b
}

// WithGeneration sets the Generation field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Generation field is set to the value of the last call.
func (b *BuildConfigApplyConfiguration) WithGeneration(value int64) *BuildConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.Generation = &value
	return b
}

// WithCreationTimestamp sets the CreationTimestamp field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CreationTimestamp field is set to the value of the last call.
func (b *BuildConfigApplyConfiguration) WithCreationTimestamp(value metav1.Time) *BuildConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.CreationTimestamp = &value
	return b
}

// WithDeletionTimestamp sets the DeletionTimestamp field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeletionTimestamp field is set to the value of the last call.
func (b *BuildConfigApplyConfiguration) WithDeletionTimestamp(value metav1.Time) *BuildConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.DeletionTimestamp = &value
	return b
}

// WithDeletionGracePeriodSeconds sets the DeletionGracePeriodSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeletionGracePeriodSeconds field is set to the value of the last call.
func (b *BuildConfigApplyConfiguration) WithDeletionGracePeriodSeconds(value int64) *BuildConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.DeletionGracePeriodSeconds = &value
	return b
}

// WithLabels puts the entries into the Labels field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Labels field,
// overwriting an existing map entries in Labels field with the same key.
func (b *BuildConfigApplyConfiguration) WithLabels(entries map[string]string) *BuildConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	if b.Labels == nil && len(entries) > 0 {
		b.Labels = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.Labels[k] = v
	}
	return b
}

// WithAnnotations puts the entries into the Annotations field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Annotations field,
// overwriting an existing map entries in Annotations field with the same key.
func (b *BuildConfigApplyConfiguration) WithAnnotations(entries map[string]string) *BuildConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	if b.Annotations == nil && len(entries) > 0 {
		b.Annotations = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.Annotations[k] = v
	}
	return b
}

// WithOwnerReferences adds the given value to the OwnerReferences field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the OwnerReferences field.
func (b *BuildConfigApplyConfiguration) WithOwnerReferences(values ...*v1.OwnerReferenceApplyConfiguration) *BuildConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithOwnerReferences")
		}
		b.OwnerReferences = append(b.OwnerReferences, *values[i])
	}
	return b
}

// WithFinalizers adds the given value to the Finalizers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Finalizers field.
func (b *BuildConfigApplyConfiguration) WithFinalizers(values ...string) *BuildConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	for i := range values {
		b.Finalizers = append(b.Finalizers, values[i])
	}
	return b
}

func (b *BuildConfigApplyConfiguration) ensureObjectMetaApplyConfigurationExists() {
	if b.ObjectMetaApplyConfiguration == nil {
		b.ObjectMetaApplyConfiguration = &v1.ObjectMetaApplyConfiguration{}
	}
}

// WithSpec sets the Spec field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Spec field is set to the value of the last call.
func (b *BuildConfigApplyConfiguration) WithSpec(value *BuildConfigSpecApplyConfiguration) *BuildConfigApplyConfiguration {
	b.Spec = value
	return b
}

// WithStatus sets the Status field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Status field is set to the value of the last call.
func (b *BuildConfigApplyConfiguration) WithStatus(value *BuildConfigStatusApplyConfiguration) *BuildConfigApplyConfiguration {
	b.Status = value
	return b
}
