## nsc export keys

Export operator, account and user keys in the current operator and account context

### Synopsis

Export operator, account and user keys in the current operator and account context.
Additional flags allow you to specify which types of keys to export. For example
the --operator flag exports any operator keys, --accounts exports account keys, etc. 

To export all key types specify the --all flag.


You can limit export to a different account context by specifying --account flag.
You can limit exporting user keys to the specified user by specifying the --user flag.

The --not-referenced flag exports all keys not relevant to the current  operator, 
accounts and users. These keys may be referenced in a different  operator context.

The --filter flag allows you to specify a few letters in a public key and export only 
those keys that matching the filter (provided the key type matches --operator, --account,
--user (or --all).

The --include-jwts flag will export the JWT configurations named by their identity key.
This allows you to export an entire configuration tree of operators, accounts, users
and their keys to a directory. To recreate an environment from this export use 'nsc fix'.


```
nsc export keys [flags]
```

### Examples

```
nsc export keys --dir <path> (exports the current operator, account and users keys)
nsc export keys --operator --accounts --users (exports current operators, all accounts, and users)
nsc export keys --all (same as specifying --operator --accounts --users)
nsc export keys --operator --not-referenced (exports any other operator keys in the keystore)
nsc export keys --all --filter VSVMGA (exports all keys containing the filter)
nsc export keys --account <name> (changes the account context to the specified account)

```

### Options

```
      --account string   change account context to the named account
  -a, --accounts         export account keys
  -A, --all              export operator, accounts and users keys
      --curve string     export specified curve key
      --curves           export curve keys
  -d, --dir string       directory to export keys to
  -f, --filter string    export keys containing string
  -F, --force            overwrite existing files
  -h, --help             help for keys
      --include-jwts     include jwts
      --not-referenced   export keys that are not referenced in the current operator context
  -o, --operator         export operator keys
  -R, --remove           removes the original key file from the keyring after exporting it
      --user string      export specified user key
  -u, --users            export user keys
```

### Options inherited from parent commands

```
  -H, --all-dirs string       sets --config-dir, --data-dir, and --keystore-dir to the same value
      --config-dir string     nsc config directory
      --data-dir string       nsc data store directory
  -i, --interactive           ask questions for various settings
      --keystore-dir string   nsc keystore directory
  -K, --private-key string    Key used to sign. Can be specified as role (where applicable),
                              public key (private portion is retrieved)
                              or file path to a private key or private key 
```

### SEE ALSO

* [nsc export](nsc_export.md)	 - Export assets such as nkeys

###### Auto generated by spf13/cobra on 2-Jan-2025
