# Integrations

> Default integrations shipped with Murex

## Description

Murex is highly customisable, as every good shell should be. However the Murex
community believe that extendability and support for customisations are no
substitute for good defaults.

Murex aims to provide you with the best support for your wider command line
needs, in its "out-of-the-box" configuration.

So with that goal in mind, the following configurations come pre-installed with
Murex's base install.

## Supported Integrations

* [ChatGPT](../integrations/chatgpt.md):
  How to enable ChatGPT hints
* [Cheat.sh](../integrations/cheatsh.md):
  Cheatsheets provided by cheat.sh
* [Kitty Integrations](../integrations/kitty.md):
  Get more out of Kitty terminal emulator
* [Makefiles / `make`](../integrations/make.md):
  `make` integrations
* [Man Pages (POSIX)](../integrations/man-pages.md):
  Linux/UNIX `man` page integrations
* [Spellcheck](../integrations/spellcheck.md):
  How to enable inline spellchecking
* [Terminology Integrations](../integrations/terminology.md):
  Get more out of Terminology terminal emulator
* [`direnv` Integrations](../integrations/direnv.md):
  Directory specific environmental variables
* [`yarn` Integrations](../integrations/yarn.md):
  Working with `yarn` and `package.json`
* [iTerm2 Integrations](../integrations/iterm2.md):
  Get more out of iTerm2 terminal emulator

## See Also

* [FileRef](../user-guide/fileref.md):
  How to track what code was loaded and from where
* [Modules And Packages](../user-guide/modules.md):
  An introduction to Murex modules and packages
* [Profile Files](../user-guide/profile.md):
  A breakdown of the different files loaded on start up
* [Spellcheck](../integrations/spellcheck.md):
  How to enable inline spellchecking

<hr/>

This document was generated from [gen/user-guide/integrations_doc.yaml](https://github.com/lmorg/murex/blob/master/gen/user-guide/integrations_doc.yaml).