# `direnv` Integrations

> Directory specific environmental variables

## Description

From `direnv`'s [Github README](https://github.com/direnv/direnv):

> `direnv` is an extension for your shell. It augments existing shells with a
> new feature that can load and unload environment variables depending on the
> current directory.

While this functionality isn't built into the core of Murex, `direnv` has
added their own hook to support Murex.

More details can be found on their [hook.md](https://github.com/direnv/direnv/blob/master/docs/hook.md#murex)
document.

## See Also

* [Profile Files](../user-guide/profile.md):
  A breakdown of the different files loaded on start up
* [`export`](../commands/export.md):
  Define an environmental variable and set it's value

## Other Integrations

* [ChatGPT](../integrations/chatgpt.md):
  How to enable ChatGPT hints
* [Cheat.sh](../integrations/cheatsh.md):
  Cheatsheets provided by cheat.sh
* [Kitty Integrations](../integrations/kitty.md):
  Get more out of Kitty terminal emulator
* [Makefiles / `make`](../integrations/make.md):
  `make` integrations
* [Man Pages (POSIX)](../integrations/man-pages.md):
  Linux/UNIX `man` page integrations
* [Spellcheck](../integrations/spellcheck.md):
  How to enable inline spellchecking
* [Terminology Integrations](../integrations/terminology.md):
  Get more out of Terminology terminal emulator
* [`direnv` Integrations](../integrations/direnv.md):
  Directory specific environmental variables
* [`yarn` Integrations](../integrations/yarn.md):
  Working with `yarn` and `package.json`
* [iTerm2 Integrations](../integrations/iterm2.md):
  Get more out of iTerm2 terminal emulator


<hr/>

This document was generated from [gen/integrations/direnv_doc.yaml](https://github.com/lmorg/murex/blob/master/gen/integrations/direnv_doc.yaml).