# v3.0

This is a major release that brings a significant number of changes and improvements, including a complete overhaul of the parser. Backwards compatibility is a high priority however these new features bring greater readability and consistency to shell scripting. So while the older syntax remains for compatibility, it is worth migrating over to the newer syntax for all new code being written

### Breaking Changes

* Optional builtin removed: `bson`. This was disabled by default and likely never used. So it has been removed to reduce Murex's testing footprint. It can easily be re-added if anyone does actually use it

* Optional builtin removed: `coreutils`. This was actually enabled by default for Windows builds. However rewriting Linux/UNIX coreutils for Windows support is a massive project in its own right and with the maturity of WSL there's almost no reason to run Murex on "native Windows". So the `coreutils` builtin has been dropped to allow us to focus on the responsibilities of the shell

### Features

* Support for expressions, eg `5 * 5` or `foobar = $foo + "bar"`, etc. This syntax can be used directly or specified specifically via the `expr` builtin

* New syntax sugar for creating JSON objects: `%{ foo: bar }`

* New syntax sugar for creating JSON arrays: `%[ foo bar ]`

* New syntax sugar for creating strings: `%()` (this is preferred over the, now deprecated, feature of parenthesis quotes)

* Ranges supported in `[]` (`@[` is now deprecated)

* Support for multiline comments: `/# comment #/`. It is unfortunate this differs from C-style comments (`/* comment */`) but this has to be the case because `/*` is ambiguous for barewords in shells: is it a path and glob or a comment? Where as `/#` isn't a common term due to `#` denoting a comment

* If any processes pass `null` as a data type across the pipe, it will be ignored. This solves the problem where functions that don't write to STDOUT would still define the data type

* Config option **auto-glob** renamed to **expand-glob**, and now enabled by default

* Globbing exclusion list. This allows you to avoid annoying prompts when parameters shouldn't be expanded as globs by the shell (eg when using regular expressions). This can be managed via **shell expand-glob-unsafe-commands** option in `config`

* `@g` removed. It is no longer needed with **expand-glob** enabled by default

* New builtin: `continue`: skip subsequent processes in an iteration block and continue to next iteration

* New builtin: `break`: exit out of a block of code (eg in an iteration loop)

* Additional syntax for _index_ (`[`): `*1`: 1st row, `*A`: 1st column

* New alias: `help` -> `murex-docs`. This brings Murex a little more inline with Bash et al

* **pre-cache-hint-summaries** now enabled by default after testing has demonstrated it doesn't have nearly as expensive footprint as first assumed

* Hitting **TAB** when nothing has been typed in the REPL will suggest past command lines

* `^` autocompletion added

* `getfile` writes to disk if STDOUT is a TTY

* **mkarray** (eg `ja`) now writes an integer array if range is integers. eg `ja: [1..3]`. This change wouldn't affect `a` since that outputs as list of strings (for streaming performance reasons) rather than a data type aware document

* `debug` (method) output tweaked

* Improved error messages in a number places

* Revamped README / website landing page

### Non-User Facing / Maintenance Changes

* Minimum Go version supported is now 1.17.x

* Main parser completely rewritten

* `ReadArray` API now requires a `context.Context`

* `egrep` references changed to `grep -E` to work around GNU grep deprecating support for _egrep_

* Added marshallers for `boolean`, `null`

* `Variables.GetValue()` now errors instead of returns `nil` when no variable set

* Additional tests. So many new tests added

* Lots of code refactoring

### Bug Fixes

* `regexp` wasn't erroring if nothing was matched

* readline: fixed deadlock

* `append` and `prepend` now type aware (no longer converts all arrays into string arrays)

* `foreach` was setting variables as strings rather than honoring their original data type

* `yarn` autocompletion errors should be suppressed

* spellcheck missing `break` causing more occasionally incorrect instances of underlined words

* `config` wasn't passing data type when executing blocks via **eval**

* `debug` wasn't setting data type when used as a function

* macro variables don't re-prompt when the same variable is used multiple times

<hr>

Published: 31.12.2022 at 08:10

## See Also

* [`[ ..Range ]`](../parser/range.md):
  Outputs a ranged subset of data from STDIN
* [`a` (mkarray)](../commands/a.md):
  A sophisticated yet simple way to build an array or list
* [`append`](../commands/append.md):
  Add data to the end of an array
* [`break`](../commands/break.md):
  Terminate execution of a block within your processes scope
* [`config`](../commands/config.md):
  Query or define Murex runtime settings
* [`continue`](../commands/continue.md):
  Terminate process of a block within a caller function
* [`expr`](../commands/expr.md):
  Expressions: mathematical, string comparisons, logical operators
* [`foreach`](../commands/foreach.md):
  Iterate through an array
* [`getfile`](../commands/getfile.md):
  Makes a standard HTTP request and return the contents as Murex-aware data type for passing along Murex pipelines.
* [`ja` (mkarray)](../commands/ja.md):
  A sophisticated yet simply way to build a JSON array
* [`murex-docs`](../commands/murex-docs.md):
  Displays the man pages for Murex builtins
* [`prepend`](../commands/prepend.md):
  Add data to the start of an array
* [`regexp`](../commands/regexp.md):
  Regexp tools for arrays / lists of strings
* [index](../parser/item-index.md):
  Outputs an element from an array, map or table

<hr/>

This document was generated from [gen/changelog/v3.0_doc.yaml](https://github.com/lmorg/murex/blob/master/gen/changelog/v3.0_doc.yaml).