package handlers

// BlankPNG returns bytes of a blank PNG of the requested size, falling back to
// 256px if a suitable size is not available.
// Used for the request handlers to return when an image tile is not available.
// Images created with https://png-pixel.com/ then minified using tinypng.com
func BlankPNG(tilesize uint32) []byte {
	switch tilesize {
	case 512:
		return []byte{
			0x89, 0x50, 0x4e, 0x47, 0xd, 0xa, 0x1a, 0xa, 0x0, 0x0, 0x0, 0xd,
			0x49, 0x48, 0x44, 0x52, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x2, 0x0, 0x1,
			0x3, 0x0, 0x0, 0x0, 0xce, 0xb6, 0x46, 0xb9, 0x0, 0x0, 0x0, 0x3, 0x50,
			0x4c, 0x54, 0x45, 0x0, 0x0, 0x0, 0xa7, 0x7a, 0x3d, 0xda, 0x0, 0x0,
			0x0, 0x1, 0x74, 0x52, 0x4e, 0x53, 0x0, 0x40, 0xe6, 0xd8, 0x66, 0x0,
			0x0, 0x0, 0x36, 0x49, 0x44, 0x41, 0x54, 0x78, 0xda, 0xed, 0xc1, 0x1,
			0x1, 0x0, 0x0, 0x0, 0x82, 0xa0, 0xfe, 0xaf, 0x6e, 0x88, 0xc0, 0x0,
			0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			0x0, 0x0, 0x0, 0xe2, 0xe, 0x82, 0x0, 0x0, 0x1, 0x1, 0xf5, 0x37, 0x5e,
			0x0, 0x0, 0x0, 0x0, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82,
		}
	default: // 256
		return []byte{
			0x89, 0x50, 0x4e, 0x47, 0xd, 0xa, 0x1a, 0xa, 0x0, 0x0, 0x0, 0xd,
			0x49, 0x48, 0x44, 0x52, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1,
			0x3, 0x0, 0x0, 0x0, 0x66, 0xbc, 0x3a, 0x25, 0x0, 0x0, 0x0, 0x3, 0x50,
			0x4c, 0x54, 0x45, 0x0, 0x0, 0x0, 0xa7, 0x7a, 0x3d, 0xda, 0x0, 0x0,
			0x0, 0x1, 0x74, 0x52, 0x4e, 0x53, 0x0, 0x40, 0xe6, 0xd8, 0x66, 0x0,
			0x0, 0x0, 0x1f, 0x49, 0x44, 0x41, 0x54, 0x68, 0xde, 0xed, 0xc1, 0x1,
			0xd, 0x0, 0x0, 0x0, 0xc2, 0x20, 0xfb, 0xa7, 0x36, 0xc7, 0x37, 0x60,
			0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x71, 0x7, 0x21, 0x0, 0x0,
			0x1, 0xa7, 0x57, 0x29, 0xd7, 0x0, 0x0, 0x0, 0x0, 0x49, 0x45, 0x4e,
			0x44, 0xae, 0x42, 0x60, 0x82,
		}
	}
}
