## Git hook

Contains settings for the git hook (commands, scripts, skip rules, etc.). You can specify any Git hook or your own custom, e.g. `test`

### Hook options

- [`files`](./files-global.md)
- [`parallel`](./parallel.md)
- [`piped`](./piped.md)
- [`follow`](./follow.md)
- [`exclude_tags`](./exclude_tags.md)
- [`skip`](./skip.md)
- [`only`](./only.md)
- [`jobs`](./jobs.md)
  - [`name`](./name.md)
  - [`run`](./run.md)
  - [`script`](./script.md)
  - [`runner`](./runner.md)
  - [`group`](./group.md)
    - [`parallel`](./parallel.md)
    - [`piped`](./piped.md)
    - [`jobs`](./jobs.md)
  - [`skip`](./skip.md)
  - [`only`](./only.md)
  - [`tags`](./tags.md)
  - [`glob`](./glob.md)
  - [`files`](./files.md)
  - [`file_types`](./file_types.md)
  - [`env`](./env.md)
  - [`root`](./root.md)
  - [`exclude`](./exclude.md)
  - [`fail_text`](./fail_text.md)
  - [`stage_fixed`](./stage_fixed.md)
  - [`interactive`](./interactive.md)
  - [`use_stdin`](./use_stdin.md)
- [`commands`](./Commands.md)
  - [`run`](./run.md)
  - [`skip`](./skip.md)
  - [`only`](./only.md)
  - [`tags`](./tags.md)
  - [`glob`](./glob.md)
  - [`files`](./files.md)
  - [`file_types`](./file_types.md)
  - [`env`](./env.md)
  - [`root`](./root.md)
  - [`exclude`](./exclude.md)
  - [`fail_text`](./fail_text.md)
  - [`stage_fixed`](./stage_fixed.md)
  - [`interactive`](./interactive.md)
  - [`use_stdin`](./use_stdin.md)
  - [`priority`](./priority.md)
- [`scripts`](./Scripts.md)
  - [`runner`](./runner.md)
  - [`skip`](./skip.md)
  - [`only`](./only.md)
  - [`tags`](./tags.md)
  - [`env`](./env.md)
  - [`fail_text`](./fail_text.md)
  - [`stage_fixed`](./stage_fixed.md)
  - [`interactive`](./interactive.md)
  - [`use_stdin`](./use_stdin.md)
  - [`priority`](./priority.md)
