//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by validation-gen. DO NOT EDIT.

package k8sextendedresourcename

import (
	context "context"
	fmt "fmt"

	operation "k8s.io/apimachinery/pkg/api/operation"
	safe "k8s.io/apimachinery/pkg/api/safe"
	validate "k8s.io/apimachinery/pkg/api/validate"
	field "k8s.io/apimachinery/pkg/util/validation/field"
	testscheme "k8s.io/code-generator/cmd/validation-gen/testscheme"
)

func init() { localSchemeBuilder.Register(RegisterValidations) }

// RegisterValidations adds validation functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterValidations(scheme *testscheme.Scheme) error {
	// type MyType
	scheme.AddValidationFunc((*MyType)(nil), func(ctx context.Context, op operation.Operation, obj, oldObj interface{}) field.ErrorList {
		switch op.Request.SubresourcePath() {
		case "/":
			return Validate_MyType(ctx, op, nil /* fldPath */, obj.(*MyType), safe.Cast[*MyType](oldObj))
		}
		return field.ErrorList{field.InternalError(nil, fmt.Errorf("no validation found for %T, subresource: %v", obj, op.Request.SubresourcePath()))}
	})
	return nil
}

// Validate_MyType validates an instance of MyType according
// to declarative validation rules in the API schema.
func Validate_MyType(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *MyType) (errs field.ErrorList) {
	// field MyType.TypeMeta has no validation

	// field MyType.NameField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalValue(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.ExtendedResourceName(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("nameField"), &obj.NameField, safe.Field(oldObj, func(oldObj *MyType) *string { return &oldObj.NameField }), oldObj != nil)...)

	// field MyType.NamePtrField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalPointer(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.ExtendedResourceName(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("namePtrField"), obj.NamePtrField, safe.Field(oldObj, func(oldObj *MyType) *string { return oldObj.NamePtrField }), oldObj != nil)...)

	// field MyType.NameTypedefField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *NameStringType, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call the type's validation function
			errs = append(errs, Validate_NameStringType(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("nameTypedefField"), &obj.NameTypedefField, safe.Field(oldObj, func(oldObj *MyType) *NameStringType { return &oldObj.NameTypedefField }), oldObj != nil)...)

	return errs
}

// Validate_NameStringType validates an instance of NameStringType according
// to declarative validation rules in the API schema.
func Validate_NameStringType(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *NameStringType) (errs field.ErrorList) {
	errs = append(errs, validate.ExtendedResourceName(ctx, op, fldPath, obj, oldObj)...)

	return errs
}
