/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
)

// ComponentConditionApplyConfiguration represents a declarative configuration of the ComponentCondition type for use
// with apply.
//
// Information about the condition of a component.
type ComponentConditionApplyConfiguration struct {
	// Type of condition for a component.
	// Valid value: "Healthy"
	Type *corev1.ComponentConditionType `json:"type,omitempty"`
	// Status of the condition for a component.
	// Valid values for "Healthy": "True", "False", or "Unknown".
	Status *corev1.ConditionStatus `json:"status,omitempty"`
	// Message about the condition for a component.
	// For example, information about a health check.
	Message *string `json:"message,omitempty"`
	// Condition error code for a component.
	// For example, a health check error code.
	Error *string `json:"error,omitempty"`
}

// ComponentConditionApplyConfiguration constructs a declarative configuration of the ComponentCondition type for use with
// apply.
func ComponentCondition() *ComponentConditionApplyConfiguration {
	return &ComponentConditionApplyConfiguration{}
}

// WithType sets the Type field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Type field is set to the value of the last call.
func (b *ComponentConditionApplyConfiguration) WithType(value corev1.ComponentConditionType) *ComponentConditionApplyConfiguration {
	b.Type = &value
	return b
}

// WithStatus sets the Status field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Status field is set to the value of the last call.
func (b *ComponentConditionApplyConfiguration) WithStatus(value corev1.ConditionStatus) *ComponentConditionApplyConfiguration {
	b.Status = &value
	return b
}

// WithMessage sets the Message field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Message field is set to the value of the last call.
func (b *ComponentConditionApplyConfiguration) WithMessage(value string) *ComponentConditionApplyConfiguration {
	b.Message = &value
	return b
}

// WithError sets the Error field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Error field is set to the value of the last call.
func (b *ComponentConditionApplyConfiguration) WithError(value string) *ComponentConditionApplyConfiguration {
	b.Error = &value
	return b
}
