/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

import (
	types "k8s.io/apimachinery/pkg/types"
)

// PodCertificateRequestSpecApplyConfiguration represents a declarative configuration of the PodCertificateRequestSpec type for use
// with apply.
//
// PodCertificateRequestSpec describes the certificate request.  All fields are
// immutable after creation.
type PodCertificateRequestSpecApplyConfiguration struct {
	// signerName indicates the requested signer.
	//
	// All signer names beginning with `kubernetes.io` are reserved for use by
	// the Kubernetes project.  There is currently one well-known signer
	// documented by the Kubernetes project,
	// `kubernetes.io/kube-apiserver-client-pod`, which will issue client
	// certificates understood by kube-apiserver.  It is currently
	// unimplemented.
	SignerName *string `json:"signerName,omitempty"`
	// podName is the name of the pod into which the certificate will be mounted.
	PodName *string `json:"podName,omitempty"`
	// podUID is the UID of the pod into which the certificate will be mounted.
	PodUID *types.UID `json:"podUID,omitempty"`
	// serviceAccountName is the name of the service account the pod is running as.
	ServiceAccountName *string `json:"serviceAccountName,omitempty"`
	// serviceAccountUID is the UID of the service account the pod is running as.
	ServiceAccountUID *types.UID `json:"serviceAccountUID,omitempty"`
	// nodeName is the name of the node the pod is assigned to.
	NodeName *types.NodeName `json:"nodeName,omitempty"`
	// nodeUID is the UID of the node the pod is assigned to.
	NodeUID *types.UID `json:"nodeUID,omitempty"`
	// maxExpirationSeconds is the maximum lifetime permitted for the
	// certificate.
	//
	// If omitted, kube-apiserver will set it to 86400(24 hours). kube-apiserver
	// will reject values shorter than 3600 (1 hour).  The maximum allowable
	// value is 7862400 (91 days).
	//
	// The signer implementation is then free to issue a certificate with any
	// lifetime *shorter* than MaxExpirationSeconds, but no shorter than 3600
	// seconds (1 hour).  This constraint is enforced by kube-apiserver.
	// `kubernetes.io` signers will never issue certificates with a lifetime
	// longer than 24 hours.
	MaxExpirationSeconds *int32 `json:"maxExpirationSeconds,omitempty"`
	// pkixPublicKey is the PKIX-serialized public key the signer will issue the
	// certificate to.
	//
	// The key must be one of RSA3072, RSA4096, ECDSAP256, ECDSAP384, ECDSAP521,
	// or ED25519. Note that this list may be expanded in the future.
	//
	// Signer implementations do not need to support all key types supported by
	// kube-apiserver and kubelet.  If a signer does not support the key type
	// used for a given PodCertificateRequest, it must deny the request by
	// setting a status.conditions entry with a type of "Denied" and a reason of
	// "UnsupportedKeyType". It may also suggest a key type that it does support
	// in the message field.
	PKIXPublicKey []byte `json:"pkixPublicKey,omitempty"`
	// proofOfPossession proves that the requesting kubelet holds the private
	// key corresponding to pkixPublicKey.
	//
	// It is contructed by signing the ASCII bytes of the pod's UID using
	// `pkixPublicKey`.
	//
	// kube-apiserver validates the proof of possession during creation of the
	// PodCertificateRequest.
	//
	// If the key is an RSA key, then the signature is over the ASCII bytes of
	// the pod UID, using RSASSA-PSS from RFC 8017 (as implemented by the golang
	// function crypto/rsa.SignPSS with nil options).
	//
	// If the key is an ECDSA key, then the signature is as described by [SEC 1,
	// Version 2.0](https://www.secg.org/sec1-v2.pdf) (as implemented by the
	// golang library function crypto/ecdsa.SignASN1)
	//
	// If the key is an ED25519 key, the the signature is as described by the
	// [ED25519 Specification](https://ed25519.cr.yp.to/) (as implemented by
	// the golang library crypto/ed25519.Sign).
	ProofOfPossession []byte `json:"proofOfPossession,omitempty"`
	// unverifiedUserAnnotations allow pod authors to pass additional information to
	// the signer implementation.  Kubernetes does not restrict or validate this
	// metadata in any way.
	//
	// Entries are subject to the same validation as object metadata annotations,
	// with the addition that all keys must be domain-prefixed. No restrictions
	// are placed on values, except an overall size limitation on the entire field.
	//
	// Signers should document the keys and values they support.  Signers should
	// deny requests that contain keys they do not recognize.
	UnverifiedUserAnnotations map[string]string `json:"unverifiedUserAnnotations,omitempty"`
}

// PodCertificateRequestSpecApplyConfiguration constructs a declarative configuration of the PodCertificateRequestSpec type for use with
// apply.
func PodCertificateRequestSpec() *PodCertificateRequestSpecApplyConfiguration {
	return &PodCertificateRequestSpecApplyConfiguration{}
}

// WithSignerName sets the SignerName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SignerName field is set to the value of the last call.
func (b *PodCertificateRequestSpecApplyConfiguration) WithSignerName(value string) *PodCertificateRequestSpecApplyConfiguration {
	b.SignerName = &value
	return b
}

// WithPodName sets the PodName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PodName field is set to the value of the last call.
func (b *PodCertificateRequestSpecApplyConfiguration) WithPodName(value string) *PodCertificateRequestSpecApplyConfiguration {
	b.PodName = &value
	return b
}

// WithPodUID sets the PodUID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PodUID field is set to the value of the last call.
func (b *PodCertificateRequestSpecApplyConfiguration) WithPodUID(value types.UID) *PodCertificateRequestSpecApplyConfiguration {
	b.PodUID = &value
	return b
}

// WithServiceAccountName sets the ServiceAccountName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServiceAccountName field is set to the value of the last call.
func (b *PodCertificateRequestSpecApplyConfiguration) WithServiceAccountName(value string) *PodCertificateRequestSpecApplyConfiguration {
	b.ServiceAccountName = &value
	return b
}

// WithServiceAccountUID sets the ServiceAccountUID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServiceAccountUID field is set to the value of the last call.
func (b *PodCertificateRequestSpecApplyConfiguration) WithServiceAccountUID(value types.UID) *PodCertificateRequestSpecApplyConfiguration {
	b.ServiceAccountUID = &value
	return b
}

// WithNodeName sets the NodeName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NodeName field is set to the value of the last call.
func (b *PodCertificateRequestSpecApplyConfiguration) WithNodeName(value types.NodeName) *PodCertificateRequestSpecApplyConfiguration {
	b.NodeName = &value
	return b
}

// WithNodeUID sets the NodeUID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NodeUID field is set to the value of the last call.
func (b *PodCertificateRequestSpecApplyConfiguration) WithNodeUID(value types.UID) *PodCertificateRequestSpecApplyConfiguration {
	b.NodeUID = &value
	return b
}

// WithMaxExpirationSeconds sets the MaxExpirationSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxExpirationSeconds field is set to the value of the last call.
func (b *PodCertificateRequestSpecApplyConfiguration) WithMaxExpirationSeconds(value int32) *PodCertificateRequestSpecApplyConfiguration {
	b.MaxExpirationSeconds = &value
	return b
}

// WithPKIXPublicKey adds the given value to the PKIXPublicKey field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the PKIXPublicKey field.
func (b *PodCertificateRequestSpecApplyConfiguration) WithPKIXPublicKey(values ...byte) *PodCertificateRequestSpecApplyConfiguration {
	for i := range values {
		b.PKIXPublicKey = append(b.PKIXPublicKey, values[i])
	}
	return b
}

// WithProofOfPossession adds the given value to the ProofOfPossession field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ProofOfPossession field.
func (b *PodCertificateRequestSpecApplyConfiguration) WithProofOfPossession(values ...byte) *PodCertificateRequestSpecApplyConfiguration {
	for i := range values {
		b.ProofOfPossession = append(b.ProofOfPossession, values[i])
	}
	return b
}

// WithUnverifiedUserAnnotations puts the entries into the UnverifiedUserAnnotations field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the UnverifiedUserAnnotations field,
// overwriting an existing map entries in UnverifiedUserAnnotations field with the same key.
func (b *PodCertificateRequestSpecApplyConfiguration) WithUnverifiedUserAnnotations(entries map[string]string) *PodCertificateRequestSpecApplyConfiguration {
	if b.UnverifiedUserAnnotations == nil && len(entries) > 0 {
		b.UnverifiedUserAnnotations = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.UnverifiedUserAnnotations[k] = v
	}
	return b
}
